#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cdtrrv2d(ConTxt, uplo, diag, m, n, A, lda, rsrc, csrc)
int  ConTxt;
char  *uplo;
char  *diag;
int  m;
int  n;
double  *A;
int  lda;
int  rsrc;
int  csrc;
#else
void dtrrv2d_(ConTxt, uplo, diag, m, n, A, lda, rsrc, csrc)
int  *ConTxt;
char  *uplo;
char  *diag;
int  *m;
int  *n;
double  *A;
int  *lda;
int  *rsrc;
int  *csrc;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point to point trapezoidal double precision receive.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to double precision two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
/*
 *  Prototypes and variable declarations
 */
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void dtrunpack00();
   void Srecv2dID();
   int tuplo, tdiag, tlda;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
   tdiag = Mlowcase(*diag);
   tuplo = Mlowcase(*uplo);

#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_RV, __FILE__, 'a', tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);
/*
 *  Receive the message.
 */
   Srecv2dID(ctxt, Mpval(rsrc), Mpval(csrc));
/*
 *  Unpack the buffer
 */
   dtrunpack00(tuplo, tdiag, Mpval(m), Mpval(n), (double *) A, tlda);
}
