/* calendar.c generated by valac 0.32.1, the Vala compiler
 * generated from calendar.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_CALENDAR_WIDGET (calendar_widget_get_type ())
#define CALENDAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALENDAR_WIDGET, CalendarWidget))
#define CALENDAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALENDAR_WIDGET, CalendarWidgetClass))
#define IS_CALENDAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALENDAR_WIDGET))
#define IS_CALENDAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALENDAR_WIDGET))
#define CALENDAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALENDAR_WIDGET, CalendarWidgetClass))

typedef struct _CalendarWidget CalendarWidget;
typedef struct _CalendarWidgetClass CalendarWidgetClass;
typedef struct _CalendarWidgetPrivate CalendarWidgetPrivate;

#define BUDGIE_TYPE_HEADER_WIDGET (budgie_header_widget_get_type ())
#define BUDGIE_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidget))
#define BUDGIE_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))
#define BUDGIE_IS_HEADER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_IS_HEADER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_HEADER_WIDGET))
#define BUDGIE_HEADER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_HEADER_WIDGET, BudgieHeaderWidgetClass))

typedef struct _BudgieHeaderWidget BudgieHeaderWidget;
typedef struct _BudgieHeaderWidgetClass BudgieHeaderWidgetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_RAVEN_EXPANDER (budgie_raven_expander_get_type ())
#define BUDGIE_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpander))
#define BUDGIE_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))
#define BUDGIE_IS_RAVEN_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_IS_RAVEN_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_RAVEN_EXPANDER))
#define BUDGIE_RAVEN_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_RAVEN_EXPANDER, BudgieRavenExpanderClass))

typedef struct _BudgieRavenExpander BudgieRavenExpander;
typedef struct _BudgieRavenExpanderClass BudgieRavenExpanderClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _CalendarWidget {
	GtkBox parent_instance;
	CalendarWidgetPrivate * priv;
};

struct _CalendarWidgetClass {
	GtkBoxClass parent_class;
};

struct _CalendarWidgetPrivate {
	GtkCalendar* cal;
	BudgieHeaderWidget* header;
};


static gpointer calendar_widget_parent_class = NULL;

GType calendar_widget_get_type (void) G_GNUC_CONST;
GType budgie_header_widget_get_type (void) G_GNUC_CONST;
#define CALENDAR_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CALENDAR_WIDGET, CalendarWidgetPrivate))
enum  {
	CALENDAR_WIDGET_DUMMY_PROPERTY
};
#define CALENDAR_WIDGET_date_format "%e %b %Y"
CalendarWidget* calendar_widget_new (void);
CalendarWidget* calendar_widget_construct (GType object_type);
BudgieHeaderWidget* budgie_header_widget_new (const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
BudgieHeaderWidget* budgie_header_widget_construct (GType object_type, const gchar* text, const gchar* icon_name, gboolean can_close, GtkWidget* custom_widget, GtkWidget* end_widget);
GType budgie_raven_expander_get_type (void) G_GNUC_CONST;
BudgieRavenExpander* budgie_raven_expander_new (BudgieHeaderWidget* header);
BudgieRavenExpander* budgie_raven_expander_construct (GType object_type, BudgieHeaderWidget* header);
static gboolean calendar_widget_update_date (CalendarWidget* self);
static gboolean _calendar_widget_update_date_gsource_func (gpointer self);
void budgie_header_widget_set_text (BudgieHeaderWidget* self, const gchar* value);
static void calendar_widget_finalize (GObject* obj);


static gboolean _calendar_widget_update_date_gsource_func (gpointer self) {
	gboolean result;
	result = calendar_widget_update_date ((CalendarWidget*) self);
	return result;
}


CalendarWidget* calendar_widget_construct (GType object_type) {
	CalendarWidget * self = NULL;
	GDateTime* time = NULL;
	GDateTime* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	BudgieHeaderWidget* _tmp3_ = NULL;
	BudgieRavenExpander* expander = NULL;
	BudgieHeaderWidget* _tmp4_ = NULL;
	BudgieRavenExpander* _tmp5_ = NULL;
	GtkCalendar* _tmp6_ = NULL;
	GtkCalendar* _tmp7_ = NULL;
	GtkStyleContext* _tmp8_ = NULL;
	GtkEventBox* ebox = NULL;
	GtkEventBox* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GtkCalendar* _tmp11_ = NULL;
	self = (CalendarWidget*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, NULL);
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = g_date_time_format (time, CALENDAR_WIDGET_date_format);
	_tmp2_ = _tmp1_;
	_tmp3_ = budgie_header_widget_new (_tmp2_, "x-office-calendar-symbolic", FALSE, NULL, NULL);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->header);
	self->priv->header = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp4_ = self->priv->header;
	_tmp5_ = budgie_raven_expander_new (_tmp4_);
	g_object_ref_sink (_tmp5_);
	expander = _tmp5_;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) expander, FALSE, FALSE, (guint) 0);
	_tmp6_ = (GtkCalendar*) gtk_calendar_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->cal);
	self->priv->cal = _tmp6_;
	_tmp7_ = self->priv->cal;
	_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
	gtk_style_context_add_class (_tmp8_, "raven-calendar");
	_tmp9_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp9_);
	ebox = _tmp9_;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) ebox);
	gtk_style_context_add_class (_tmp10_, "raven-background");
	_tmp11_ = self->priv->cal;
	gtk_container_add ((GtkContainer*) ebox, (GtkWidget*) _tmp11_);
	gtk_container_add ((GtkContainer*) expander, (GtkWidget*) ebox);
	g_timeout_add_seconds_full (G_PRIORITY_LOW, (guint) 30, _calendar_widget_update_date_gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (ebox);
	_g_object_unref0 (expander);
	_g_date_time_unref0 (time);
	return self;
}


CalendarWidget* calendar_widget_new (void) {
	return calendar_widget_construct (TYPE_CALENDAR_WIDGET);
}


static gboolean calendar_widget_update_date (CalendarWidget* self) {
	gboolean result = FALSE;
	GDateTime* time = NULL;
	GDateTime* _tmp0_ = NULL;
	gchar* strf = NULL;
	gchar* _tmp1_ = NULL;
	BudgieHeaderWidget* _tmp2_ = NULL;
	GtkCalendar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_date_time_new_now_local ();
	time = _tmp0_;
	_tmp1_ = g_date_time_format (time, CALENDAR_WIDGET_date_format);
	strf = _tmp1_;
	_tmp2_ = self->priv->header;
	budgie_header_widget_set_text (_tmp2_, strf);
	_tmp3_ = self->priv->cal;
	_tmp4_ = g_date_time_get_day_of_month (time);
	g_object_set (_tmp3_, "day", _tmp4_, NULL);
	result = TRUE;
	_g_free0 (strf);
	_g_date_time_unref0 (time);
	return result;
}


static void calendar_widget_class_init (CalendarWidgetClass * klass) {
	calendar_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CalendarWidgetPrivate));
	G_OBJECT_CLASS (klass)->finalize = calendar_widget_finalize;
}


static void calendar_widget_instance_init (CalendarWidget * self) {
	self->priv = CALENDAR_WIDGET_GET_PRIVATE (self);
	self->priv->cal = NULL;
	self->priv->header = NULL;
}


static void calendar_widget_finalize (GObject* obj) {
	CalendarWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALENDAR_WIDGET, CalendarWidget);
	_g_object_unref0 (self->priv->cal);
	_g_object_unref0 (self->priv->header);
	G_OBJECT_CLASS (calendar_widget_parent_class)->finalize (obj);
}


GType calendar_widget_get_type (void) {
	static volatile gsize calendar_widget_type_id__volatile = 0;
	if (g_once_init_enter (&calendar_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CalendarWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) calendar_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CalendarWidget), 0, (GInstanceInitFunc) calendar_widget_instance_init, NULL };
		GType calendar_widget_type_id;
		calendar_widget_type_id = g_type_register_static (gtk_box_get_type (), "CalendarWidget", &g_define_type_info, 0);
		g_once_init_leave (&calendar_widget_type_id__volatile, calendar_widget_type_id);
	}
	return calendar_widget_type_id__volatile;
}



