package definitions

func init() {
	add(`AskForPassword`, &defAskForPassword{})
}

type defAskForPassword struct{}

func (*defAskForPassword) String() string {
	return `<interface>
  <object class="GtkDialog" id="AskForPassword">
    <property name="window-position">GTK_WIN_POS_CENTER</property>
    <property name="title" translatable="yes">Enter your password</property>
    <signal name="delete-event" handler="on_cancel_password_signal" />
    <child internal-child="vbox">
      <object class="GtkBox" id="Vbox">
        <property name="margin">10</property>
        <child>
          <object class="GtkLabel" id="message">
            <property name="label" translatable="yes"></property>
            <property name="halign">GTK_ALIGN_START</property>
            <property name="justify">GTK_JUSTIFY_LEFT</property>
            <property name="wrap">true</property>
            <property name="max-width-chars">50</property>
            <property name="selectable">TRUE</property>
            <property name="margin-bottom">10</property>
          </object>
        </child>
        <child>
          <object class="GtkGrid" id="grid">
            <property name="margin-bottom">10</property>
            <property name="row-spacing">12</property>
            <property name="column-spacing">6</property>
            <child>
              <object class="GtkLabel" id="accountMessage" >
                <property name="label" translatable="yes">Account</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
                <attributes>
                  <attribute name="weight" value="bold"/>
                </attributes>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">0</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="accountName" >
                <property name="halign">GTK_ALIGN_START</property>
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">0</property>
              </packing>
            </child>
            <child>
              <object class="GtkLabel" id="passMessage" >
                <property name="label" translatable="yes">Password</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">1</property>
              </packing>
            </child>
            <child>
              <object class="GtkEntry" id="password">
                <property name="has-focus">true</property>
                <property name="visibility">false</property>
                <signal name="activate" handler="on_entered_pasword_signal" />
              </object>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">1</property>
              </packing>
            </child>

            <child>
              <object class="GtkLabel" id="savePasswordLabel">
                <property name="label" translatable="yes">Save password</property>
                <property name="justify">GTK_JUSTIFY_RIGHT</property>
                <property name="halign">GTK_ALIGN_END</property>
              </object>
              <packing>
                <property name="left-attach">0</property>
                <property name="top-attach">2</property>
              </packing>
            </child>
            <child>
              <object class="GtkCheckButton" id="savePassword"/>
              <packing>
                <property name="left-attach">1</property>
                <property name="top-attach">2</property>
              </packing>
            </child>

          </object>
        </child>
        <child internal-child="action_area">
          <object class="GtkButtonBox" id="button_box">
            <property name="orientation">GTK_ORIENTATION_HORIZONTAL</property>
            <child>
              <object class="GtkButton" id="button_cancel">
                <property name="label">Cancel</property>
                <signal name="clicked" handler="on_cancel_password_signal" />
              </object>
            </child>
            <child>
              <object class="GtkButton" id="button_ok">
                <property name="label" translatable="yes">Connect</property>
                <property name="can-default">true</property>
                <signal name="clicked" handler="on_entered_password_signal" />
              </object>
            </child>
          </object>
        </child>
      </object>
    </child>
  </object>
</interface>
`
}
