% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBConnection.R
\name{dbReadTable}
\alias{dbReadTable}
\alias{dbWriteTable}
\title{Copy data frames to and from database tables}
\usage{
dbReadTable(conn, name, ...)

dbWriteTable(conn, name, value, ...)
}
\arguments{
\item{conn}{A \code{\linkS4class{DBIConnection}} object, as produced by
\code{\link{dbConnect}}.}

\item{name}{A character string specifying a DBMS table name.}

\item{...}{Other parameters passed on to methods.}

\item{value}{a data.frame (or coercible to data.frame).}
}
\value{
a data.frame.
}
\description{
\code{dbReadTable}: database table -> data frame; \code{dbWriteTable}:
data frame -> database table.
}
\note{
The translation of identifiers between R and SQL is done through calls
  to \code{\link{make.names}} and \code{\link{make.db.names}}, but we cannot
  guarantee that the conversion is reversible.  For details see
  \code{\link{make.db.names}}.
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars[1:10, ])
dbReadTable(con, "mtcars")

dbDisconnect(con)
}
\seealso{
Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetInfo}},
  \code{\link{dbGetQuery}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListResults}},
  \code{\link{dbListTables}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}}
}

