.\" dpkg manual page - start-stop-daemon(8)
.\"
.\" Copyright © 1999 Klee Dienes <klee@mit.edu>
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000-2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2002-2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2008-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH start\-stop\-daemon 8 %RELEASE_DATE% %VERSION% "użytki dpkg"
.nh
.SH NAZWA
start\-stop\-daemon \- uruchamia i zatrzymuje demony systemowe
.
.SH SKŁADNIA
\fBstart\-stop\-daemon\fP [\fIopcja\fP...] \fIpolecenie\fP
.
.SH OPIS
\fBstart\-stop\-daemon\fP jest wykorzystywany do kontroli procesów uruchamianych
i zatrzymywanych podczas przełączania trybów pracy. Przez użycie jednej z
opcji dopasowywania, można skonfigurować \fBstart\-stop\-daemon\fP do
wyszukiwania istniejących instancji działającego procesu.
.PP
Note: unless \fB\-\-pid\fP or \fB\-\-pidfile\fP are specified, \fBstart\-stop\-daemon\fP
behaves similar to \fBkillall\fP(1).  \fBstart\-stop\-daemon\fP will scan the
process table looking for any processes which match the process name, parent
pid, uid, and/or gid (if specified). Any matching process will prevent
\fB\-\-start\fP from starting the daemon. All matching processes will be sent the
TERM signal (or the one specified via \fB\-\-signal\fP or \fB\-\-retry\fP) if
\fB\-\-stop\fP is specified. For daemons which have long\-lived children which
need to live through a \fB\-\-stop\fP, you must specify a pidfile.
.
.SH POLECENIA
.TP 
\fB\-S\fP, \fB\-\-start\fP [\fB\-\-\fP] \fIargumenty\fP
Sprawdza, czy dany proces jest już uruchomiony. Jeśli tak jest, to
\fBstart\-stop\-daemon\fP nie wykonuje żadnych czynności i kończy się, zwracając
kod błędu 1 (lub 0, jeśli podano opcję \fB\-\-oknodo\fP). Jeśli dany proces nie
jest jeszcze uruchomiony, to go uruchamia,  wykonując program określony albo
opcją \fB\-\-exec\fP, albo jeśli podano, opcją \fB\-\-startas\fP. Wszelkie argumenty
podane tuż po opcji \fB\-\-\fP są przekazywane do wykonywanego polecenia.
.TP 
\fB\-K\fP, \fB\-\-stop\fP
Sprawdza, czy dany proces jest już uruchomiony. Jeśli tak jest, to
\fBstart\-stop\-daemon\fP wysyła sygnał określony opcją \fB\-\-signal\fP i kończy
swoją pracę z kodem błędu 0. Jeśli proces nie istnieje, \fBstart\-stop\-daemon\fP
kończy się z kodem błędu 1 (lub 0, jeśli podano opcję \fB\-\-oknodo\fP). Jeżeli
podano opcję \fB\-\-retry\fP, to \fBstart\-stop\-daemon\fP sprawdzi, czy proces(y) się
zakończył(y).
.TP 
\fB\-T\fP, \fB\-\-status\fP
Check for the existence of a specified process, and returns an exit status
code, according to the LSB Init Script Actions (since version 1.16.1).
.TP 
\fB\-H\fP, \fB\-\-help\fP
Wyświetla informację o użytkowaniu programu i kończy działanie.
.TP 
\fB\-V\fP, \fB\-\-version\fP
Wyświetla informację o wersji programu i kończy działanie.
.
.SH OPCJE
.SS "Matching options"
.TP 
\fB\-\-pid\fP \fIpid\fP
Check for a process with the specified \fIpid\fP (since version 1.17.6).  The
\fIpid\fP must be a number greater than 0.
.TP 
\fB\-\-ppid\fP \fIppid\fP
Check for a process with the specified parent pid \fIppid\fP (since version
1.17.7).  The \fIppid\fP must be a number greater than 0.
.TP 
\fB\-p\fP, \fB\-\-pidfile\fP \fIplik\-pid\fP
Sprawdza, czy proces utworzył plik \fIplik\-pid\fP. Uwaga: używając wyłącznie
tej opcji dopasowania można wywołać działanie na niewłaściwym procesie,
jeśli stary proces zakończył się bez możliwości usunięcia \fIpliku\-pid\fP.
.TP 
\fB\-x\fP, \fB\-\-exec\fP \fIplik_wykonywalny\fP
Sprawdza procesy, będące instancją danego \fIpliku\-wykonywalnego\fP Argument
\fIplik\-wykonywalny\fP powinien być pełną nazwą ścieżkową. Uwaga: może to nie
działać zgodnie z intencją w skryptach interpretowanych, jako że plik
wykonywalny będzie wskazywał na interpreter. Proszę ziąć pod uwagę, że
procesy działające wewnątrz chroota również zostaną dopasowane, więc mogą
być konieczne dodatkowe warunki dopasowania.
.TP 
\fB\-n\fP, \fB\-\-name\fP \fInazwa\-procesu\fP
Sprawdza procesy o nazwie \fInazwa\-procesu\fP. \fINazwa\-procesu\fP jest z reguły
plikową nazwą procesu, ale niekiedy może zostać zmieniona przez sam
proces. Uwaga: w większości systemów informacja ta jest pobierana z nazwy
comm procesu z jądra, która może mieć stosunkowo duże graniczenie długości
(zakładanie więcej niż 15 znaków nie będzie przenośne).
.TP 
\fB\-u\fP, \fB\-\-user\fP \fIusername\fP|\fIuid\fP
Sprawdza procesy będące własnością użytkownika określonego
\fInazwą\-użytkownika\fP lub \fIuid\-em\fP. Uwaga: używanie samej opcji dopasowania
spowoduje, że pod uwagę będą wzięte wszystkie procesy z pasującym
użytkownikiem.
.
.SS "Generic options"
.TP 
\fB\-g\fP, \fB\-\-group\fP \fIgroup\fP|\fIgid\fP
Podczas uruchamiania procesu zmienia grupę na \fIgrupę\fP lub \fIgid\fP.
.TP 
\fB\-s\fP, \fB\-\-signal\fP \fIsygnał\fP
Przy operacji \fB\-\-stop\fP, wysyłany jest sygnał o podanej wartości do
zatrzymywanego procesu (domyślnie jest to TERM).
.TP 
\fB\-R\fP, \fB\-\-retry\fP \fItimeout\fP|\fIplan\-działania\fP
W czasie operacji \fB\-\-stop\fP powoduje sprawdzenie przez \fBstart\-stop\-daemon\fP,
czy proces(y) się zakończył(y). Sprawdzanie jest powtarzane, jeżeli działa
jakikolwiek pasujący proces, dopóki wszystkie się nie skończą. Jeżeli
procesy się nie zakończą, podejmowane są akcje określone przez parametr
\fIplan\-działania\fP.

Jeżeli określono \fItimeout\fP zamiast \fIplanu\-działania\fP, to wtedy używany
jest następujący plan działania: \fIsygnał\fP\fB/\fP\fItimeout\fP\fB/KILL/\fP\fItimeout\fP,
gdzie \fIsygnał\fP jest określony za pomocą opcji \fB\-\-signal\fP.

\fIplan\-działania\fP jest listą co najmniej dwóch wartości oddzielonych znakami
ukośnika (\fB/\fP); każdą z tych wartości może być albo \fB\-\fP\fInumer\-sygnału\fP
lub [\fB\-\fP]\fInazwa\-sygnału\fP, co oznacza wysłanie tego sygnału, albo
\fItimeout\fP, określający liczbę sekund, którą należy czekać na zakończenie
procesu, albo \fIforever\fP, oznaczający, że reszta planu działania ma być
powtarzana dopóki jest to konieczne.

Jeżeli osiągnięto koniec planu działania, a opcja \fBforever\fP nie została
użyta, to \fBstart\-stop\-daemon\fP kończy działanie z kodem błędu 2. Jeżeli
został określony plan działania, to sygnał podany w \fB\-\-signal\fP jest
ignorowany.
.TP 
\fB\-a\fP, \fB\-\-startas\fP \fInazwa\-ścieżki\fP
Przy operacji \fB\-\-start\fP, Uruchamiany jest program o określonej
\fIścieżce\fP. Jeśli brak tej opcji, domyślnie uruchamiany jest program podany
w opcji \fB\-\-exec\fP.
.TP 
\fB\-t\fP, \fB\-\-test\fP
Wyświetlana jest czynność, jaką należałoby wykonać, a także zwracany jest
odpowiedni kod błędu, jednakże opcja ta nie wykonuje żadnych operacji.
.TP 
\fB\-o\fP, \fB\-\-oknodo\fP
Zwracany jest kod błędu 0, nawet gdyby operacja nie zakończyła się
powodzeniem (zwróciłaby 1).
.TP 
\fB\-q\fP, \fB\-\-quiet\fP
Nie są wyświetlane żadne informacje oprócz komunikatów o błędach.
.TP 
\fB\-c\fP, \fB\-\-chuid\fP \fIużytkownik\fP|\fIuid\fP[\fB:\fP\fIgrupa\fP|\fIgid\fP]
Change to this username/uid before starting the process. You can also
specify a group by appending a \fB:\fP, then the group or gid in the same way
as you would for the \fBchown\fP(1) command (\fIuser\fP\fB:\fP\fIgroup\fP).  If a user
is specified without a group, the primary GID for that user is used.  When
using this option you must realize that the primary and supplemental groups
are set as well, even if the \fB\-\-group\fP option is not specified. The
\fB\-\-group\fP option is only for groups that the user isn't normally a member
of (like adding per process group membership for generic users like
\fBnobody\fP).
.TP 
\fB\-r\fP, \fB\-\-chroot\fP \fIroot\fP
Zmienia katalog bieżący na \fIroot\fP i czyni go głównym katalogiem (rootem)
przed wystartowaniem procesu. Proszę zauważyć, że plik pidfile jest tworzony
po wykonaniu chroot.
.TP 
\fB\-d\fP, \fB\-\-chdir\fP \fIścieżka\fP
Chdir to \fIpath\fP before starting the process. This is done after the chroot
if the \fB\-r\fP|\fB\-\-chroot\fP option is set. When not specified,
\fBstart\-stop\-daemon\fP will chdir to the root directory before starting the
process.
.TP 
\fB\-b\fP, \fB\-\-background\fP
Typically used with programs that don't detach on their own. This option
will force \fBstart\-stop\-daemon\fP to fork before starting the process, and
force it into the background.  \fBWarning: start\-stop\-daemon\fP cannot check
the exit status if the process fails to execute for \fBany\fP reason. This is a
last resort, and is only meant for programs that either make no sense
forking on their own, or where it's not feasible to add the code for them to
do this themselves.
.TP 
\fB\-C\fP, \fB\-\-no\-close\fP
Do not close any file descriptor when forcing the daemon into the background
(since version 1.16.5).  Used for debugging purposes to see the process
output, or to redirect file descriptors to log the process output.  Only
relevant when using \fB\-\-background\fP.
.TP 
\fB\-N\fP, \fB\-\-nicelevel\fP \fIliczba\fP
Zmienia priorytet uruchamianego procesu.
.TP 
\fB\-P\fP, \fB\-\-procsched\fP \fIpolityka\fP\fB:\fP\fIpriorytet\fP
This alters the process scheduler policy and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 0. The currently supported policy values are \fBother\fP, \fBfifo\fP and \fBrr\fP.
.TP 
\fB\-I\fP, \fB\-\-iosched\fP \fIklasa\fP\fB:\fP\fIpriorytet\fP
This alters the IO scheduler class and priority of the process before
starting it (since version 1.15.0).  The priority can be optionally
specified by appending a \fB:\fP followed by the value. The default \fIpriority\fP
is 4, unless \fIclass\fP is \fBidle\fP, then \fIpriority\fP will always be 7. The
currently supported values for \fIclass\fP are \fBidle\fP, \fBbest\-effort\fP and
\fBreal\-time\fP.
.TP 
\fB\-k\fP, \fB\-\-umask\fP \fImaska\fP
This sets the umask of the process before starting it (since version
1.13.22).
.TP 
\fB\-m\fP, \fB\-\-make\-pidfile\fP
Used when starting a program that does not create its own pid file. This
option will make \fBstart\-stop\-daemon\fP create the file referenced with
\fB\-\-pidfile\fP and place the pid into it just before executing the
process. Note, the file will only be removed when stopping the program if
\fB\-\-remove\-pidfile\fP is used.  \fBNote:\fP This feature may not work in all
cases. Most notably when the program being executed forks from its main
process. Because of this, it is usually only useful when combined with the
\fB\-\-background\fP option.
.TP 
\fB\-\-remove\-pidfile\fP
Used when stopping a program that does not remove its own pid file (since
version 1.17.19).  This option will make \fBstart\-stop\-daemon\fP remove the
file referenced with \fB\-\-pidfile\fP after terminating the process.
.TP 
\fB\-v\fP, \fB\-\-verbose\fP
Wyświetlane są dodatkowe komunikaty.
.
.SH "KOD WYJŚCIA"
.TP 
\fB0\fP
Żądana akcja została przeprowadzona. Jeżeli użyto \fB\-\-oknodo\fP, to istnieje
również możliwość, że nic nie zostało wykonane. Może się to stać, gdy podano
\fB\-\-start\fP, a pasujący proces już działał lub gdy podano \fB\-\-stop\fP i nie
znaleziono pasującego procesu.
.TP 
\fB1\fP
Jeżeli \fB\-\-oknodo\fP nie zostało podane i nic nie zostało zrobione.
.TP 
\fB2\fP
Jeżeli podano \fB\-\-stop\fP i \fB\-\-retry\fP, ale osiągnięto koniec harmonogramu, a
procesy wciąż były uruchomione.
.TP 
\fB3\fP
Każdy inny błąd.
.PP
Podczas użycia polecenia \fB\-\-status\fP zwracane są następujące kody statusu:
.TP 
\fB0\fP
Program działa.
.TP 
\fB1\fP
Program nie działa, a plik PID\-u istnieje.
.TP 
\fB3\fP
Program nie działa.
.TP 
\fB4\fP
Nie można określić statusu programu.
.
.SH PRZYKŁAD
Uruchamia demon \fBfood\fP, jeśli jeszcze nie działa (proces nazwany food,
działający jako użytkownik food, z identyfikatorem procesu w pliku
food.pid):
.IP
.nf
start\-stop\-daemon \-\-start \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-startas /usr/sbin/food \e
	\-\-chuid food \-\- \-\-daemon
.fi
.PP
Wyślij \fBSIGTERM\fP do \fBfood\fP i czekaj do 5 sekund na jego zakończenie:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry 5
.fi
.PP
Przykład własnego planu zatrzymywania \fBfood\fP:
.IP
.nf
start\-stop\-daemon \-\-stop \-\-oknodo \-\-user food \-\-name food \e
	\-\-pidfile /run/food.pid \-\-retry=TERM/30/KILL/5
.fi
.SH TŁUMACZE
Piotr Roszatycki <dexter@debian.org>, 1999
.br
Bartosz Feński <fenio@debian.org>, 2004-2005
.br
Robert Luberda <robert@debian.org>, 2006-2008
.br
Wiktor Wandachowicz <siryes@gmail.com>, 2008
.br
Michał Kułach <michal.kulach@gmail.com>, 2012
