!{\src2tex{textfont=tt}}
!!****m* etsf_io_data_group/etsf_io_data_get
!! NAME
!!  etsf_io_data_get
!!
!! FUNCTION
!!    This is a query routine to get informations about a variable when its name
!!    is given. It does not interact with any files and is just a Firtran version of
!!    the specifications.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * varname = 
!!     the name of a variable, to know if it is part of ETSF or not.
!! OUTPUT
!! * etsf_group = 
!!     this integer is a flag corresponding to the group in which the given
!!     @varname is defined.
!! * etsf_variable = 
!! * etsf_split = 
!!     this logical is .true. if @varname is a valid split name.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_data_get(etsf_group, etsf_variable, etsf_split, varname)

  !Arguments ------------------------------------
  integer, intent(out) :: etsf_group
  integer, intent(out) :: etsf_variable
  logical, intent(out) :: etsf_split
  character(len=*), intent(in) :: varname
  !Local variables-------------------------------
  character(len=*),parameter :: my_name = 'etsf_io_data_get'
  integer :: ncid, i


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_data_get : enter'
!ENDDEBUG

  etsf_group = etsf_grp_none
  etsf_variable = 0
  etsf_split = .false.
  if (trim(varname) == "gw_corrections") then
    etsf_group = etsf_grp_gwdata
    etsf_variable = etsf_gwdata_gw_corrections
  else if (trim(varname) == "kb_formfactor_sign") then
    etsf_group = etsf_grp_gwdata
    etsf_variable = etsf_gwdata_kb_coeff_sig
  else if (trim(varname) == "kb_formfactors") then
    etsf_group = etsf_grp_gwdata
    etsf_variable = etsf_gwdata_kb_coeff
  else if (trim(varname) == "kb_formfactor_derivative") then
    etsf_group = etsf_grp_gwdata
    etsf_variable = etsf_gwdata_kb_coeff_der
  else if (trim(varname) == "space_group") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_space_group
  else if (trim(varname) == "primitive_vectors") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_primitive_vectors
  else if (trim(varname) == "reduced_symmetry_matrices") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_red_sym_matrices
  else if (trim(varname) == "reduced_symmetry_translations") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_red_sym_trans
  else if (trim(varname) == "atom_species") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_atom_species
  else if (trim(varname) == "reduced_atom_positions") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_red_at_pos
  else if (trim(varname) == "valence_charges") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_valence_charges
  else if (trim(varname) == "atomic_numbers") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_atomic_numbers
  else if (trim(varname) == "atom_species_names") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_atom_species_names
  else if (trim(varname) == "chemical_symbols") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_chemical_symbols
  else if (trim(varname) == "pseudopotential_types") then
    etsf_group = etsf_grp_geometry
    etsf_variable = etsf_geometry_pseudo_types
  else if (trim(varname) == "kpoint_grid_shift") then
    etsf_group = etsf_grp_kpoints
    etsf_variable = etsf_kpoints_kpoint_grid_shift
  else if (trim(varname) == "kpoint_grid_vectors") then
    etsf_group = etsf_grp_kpoints
    etsf_variable = etsf_kpoints_kpoint_grid_vectors
  else if (trim(varname) == "monkhorst_pack_folding") then
    etsf_group = etsf_grp_kpoints
    etsf_variable = etsf_kpoints_mp_folding
  else if (trim(varname) == "reduced_coordinates_of_kpoints") then
    etsf_group = etsf_grp_kpoints
    etsf_variable = etsf_kpoints_red_coord_kpt
  else if (trim(varname) == "kpoint_weights") then
    etsf_group = etsf_grp_kpoints
    etsf_variable = etsf_kpoints_kpoint_weights
  else if (trim(varname) == "basis_set") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_basis_set
  else if (trim(varname) == "kinetic_energy_cutoff") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_kin_cutoff
  else if (trim(varname) == "number_of_coefficients") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_n_coeff
  else if (trim(varname) == "reduced_coordinates_of_plane_waves") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_red_coord_pw
  else if (trim(varname) == "coordinates_of_basis_grid_points") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_coord_grid
  else if (trim(varname) == "number_of_coefficients_per_grid_point") then
    etsf_group = etsf_grp_basisdata
    etsf_variable = etsf_basisdata_n_coeff_grid
  else if (trim(varname) == "number_of_electrons") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_number_of_electrons
  else if (trim(varname) == "exchange_functional") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_x_functional
  else if (trim(varname) == "correlation_functional") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_c_functional
  else if (trim(varname) == "fermi_energy") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_fermi_energy
  else if (trim(varname) == "smearing_scheme") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_smearing_scheme
  else if (trim(varname) == "smearing_width") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_smearing_width
  else if (trim(varname) == "number_of_states") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_number_of_states
  else if (trim(varname) == "eigenvalues") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_eigenvalues
  else if (trim(varname) == "occupations") then
    etsf_group = etsf_grp_electrons
    etsf_variable = etsf_electrons_occupations
  else if (trim(varname) == "density") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_density
  else if (trim(varname) == "exchange_potential") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_pot_x_only
  else if (trim(varname) == "correlation_potential") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_pot_c_only
  else if (trim(varname) == "exchange_correlation_potential") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_pot_xc
  else if (trim(varname) == "coefficients_of_wavefunctions") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_wfs_coeff
  else if (trim(varname) == "real_space_wavefunctions") then
    etsf_group = etsf_grp_main
    etsf_variable = etsf_main_wfs_rsp
  else if (trim(varname) == "frequencies_dielectric_function") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_frequencies
  else if (trim(varname) == "qpoints_dielectric_function") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_qpt
  else if (trim(varname) == "qpoints_gamma_limit") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_qpt_g_lim
  else if (trim(varname) == "dielectric_function") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function
  else if (trim(varname) == "dielectric_function_head") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_head
  else if (trim(varname) == "dielectric_function_lower_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_lower
  else if (trim(varname) == "dielectric_function_upper_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_upper
  else if (trim(varname) == "inverse_dielectric_function") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_inv
  else if (trim(varname) == "inverse_dielectric_function_head") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_inv_head
  else if (trim(varname) == "inverse_dielectric_function_lower_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_inv_lower
  else if (trim(varname) == "inverse_dielectric_function_upper_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_function_inv_upper
  else if (trim(varname) == "polarizability") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_polarizability
  else if (trim(varname) == "polarizability_head") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_head
  else if (trim(varname) == "polarizability_lower_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_lower
  else if (trim(varname) == "polarizability_upper_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_upper
  else if (trim(varname) == "inverse_polarizability") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_polarizability_inv
  else if (trim(varname) == "inverse_polarizability_head") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_inv_head
  else if (trim(varname) == "inverse_polarizability_lower_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_inv_lower
  else if (trim(varname) == "inverse_polarizability_upper_wing") then
    etsf_group = etsf_grp_dielectric
    etsf_variable = etsf_dielectric_pol_inv_upper
  else if (trim(varname) == "my_kpoints") then
    etsf_split = .true.
  else if (trim(varname) == "my_grid_points_vector3") then
    etsf_split = .true.
  else if (trim(varname) == "my_spins") then
    etsf_split = .true.
  else if (trim(varname) == "my_grid_points_vector1") then
    etsf_split = .true.
  else if (trim(varname) == "my_grid_points_vector2") then
    etsf_split = .true.
  else if (trim(varname) == "my_coefficients") then
    etsf_split = .true.
  else if (trim(varname) == "my_components") then
    etsf_split = .true.
  else if (trim(varname) == "my_states") then
    etsf_split = .true.
  end if


!DEBUG
!write (*,*) 'etsf_io_data_get : exit'
!ENDDEBUG

end subroutine etsf_io_data_get
!!***
