#ifndef __GBEMOL_INFO_H_
#define __GBEMOL_INFO_H_

#include "gbemol-mpd.h"
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GBEMOL_TYPE_INFO            (gbemol_info_get_type ())
#define GBEMOL_INFO(o)              (G_TYPE_CHECK_INSTANCE_CAST ((o), GBEMOL_TYPE_INFO, GbemolInfo))
#define GBEMOL_INFO_CLASS(k)        (G_TYPE_CHECK_CLASS_CAST((k), GBEMOL_TYPE_INFO, GbemolInfoClass))
#define GBEMOL_IS_INFO(o)           (G_TYPE_CHECK_INSTANCE_TYPE ((o), GBEMOL_TYPE_INFO))
#define GBEMOL_IS_INFO_CLASS(k)     (G_TYPE_CHECK_CLASS_TYPE ((k), GBEMOL_TYPE_INFO))
#define GBEMOL_INFO_GET_CLASS(o)    (G_TYPE_INSTANCE_GET_CLASS ((o), GBEMOL_TYPE_INFO, GbemolInfoClass))

#define N_C_RESULTS 10

typedef struct _GbemolInfo GbemolInfo;
typedef struct _GbemolInfoClass GbemolInfoClass;
typedef struct _GbemolInfoPrivate GbemolInfoPrivate;

/* Mode of the info being displayed */
enum {
	INFO_MODE_SONG = 1,
	INFO_MODE_ALBUM,
	INFO_MODE_ARTIST
};

struct _GbemolInfo {
	GtkEventBox parent;
	GbemolInfoPrivate *priv;
};

struct _GbemolInfoClass {
	GtkEventBoxClass parent;
};

GbemolInfo* gbemol_info_new (GbemolMpd* mpd);
void gbemol_info_set_song (GbemolInfo* info, GbemolMpdSong* song);
void gbemol_info_set_album (GbemolInfo* info, gchar* album, gchar* artist);
void gbemol_info_set_artist (GbemolInfo* info, gchar* artist);

G_END_DECLS

#endif

