#ifndef __GBEMOL_LIBRARY_H_
#define __GBEMOL_LIBRARY_H_

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>

#include "gbemol-mpd.h"

 /*
  *  Type macros.
  */

G_BEGIN_DECLS

#define GBEMOL_TYPE_LIBRARY         (gbemol_library_get_type ())
#define GBEMOL_LIBRARY(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GBEMOL_TYPE_LIBRARY, GbemolLibrary))
#define GBEMOL_LIBRARY_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GBEMOL_TYPE_LIBRARY, GbemolLibraryClass))
#define GBEMOL_IS_LIBRARY(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GBEMOL_TYPE_LIBRARY))
#define GBEMOL_IS_LIBRARY_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GBEMOL_TYPE_LIBRARY))
#define GBEMOL_LIBRARY_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GBEMOL_TYPE_LIBRARY, GbemolLibraryClass))

#define N_C_RESULTS 10
#define N_CONSTRAINTS 3

typedef struct _GbemolLibrary GbemolLibrary;
typedef struct _GbemolLibraryClass GbemolLibraryClass;
typedef struct _GbemolLibraryPrivate GbemolLibraryPrivate;

struct _GbemolLibrary {
  GtkVBox parent;
  GbemolLibraryPrivate *priv;
};

struct _GbemolLibraryClass {
  GtkVBoxClass parent;
};

GType gbemol_library_get_type (void);
GbemolLibrary* gbemol_library_new (GbemolMpd* mpd);
void gbemol_library_resolve_tags (GbemolLibrary* lib);
void gbemol_library_update_constraint (GbemolLibrary* lib, gint index);
void gbemol_library_start_constraints (GbemolLibrary* lib);
void gbemol_library_set_sensitive (GbemolLibrary* lib, gboolean sensitive);
void gbemol_library_set_updating (GbemolLibrary* lib, gboolean updating);

G_END_DECLS
#endif
