#!/usr/bin/python

##   GNOME Comics Organizer - Python Branch
##   Copyright (C) 2004 Mads Villadsen <maxx@krakoa.dk>
    
##   This program is free software; you can redistribute it and/or modify
##   it under the terms of the GNU General Public License as published by
##   the Free Software Foundation; either version 2 of the License, or
##   (at your option) any later version.
   
##   This program is distributed in the hope that it will be useful,
##   but WITHOUT ANY WARRANTY; without even the implied warranty of
##   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##   GNU General Public License for more details.
   
##   You should have received a copy of the GNU General Public License
##   along with this program; if not, write to the Free Software
##   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

import time, re, string

class ComicBook:
    def __init__(self):
        self.title = ""
        self.publisher = ""
        self.type = ""
        self.volume = "1"
        self.group = ""
        self.comment = ""
        
        self.show_me = True
        self.issues = []
        self.link_file = ""
        self.guid = 0

    def init(self, title, publisher, type, volume, group, comment, link_file, guid):
        self.title = title
        self.publisher = publisher
        self.type = type
        self.volume = volume
        self.group = group
        self.comment = comment
        self.link_file = link_file
        self.guid = guid

    def append_issue(self, issue):
        self.issues.append(issue)

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_volume(self):
        return self.volume

    def set_volume(self, volume):
        self.volume = volume

    def get_publisher(self):
        return self.publisher

    def set_publisher(self, publisher):
        self.publisher = publisher

    def get_group(self):
        return self.group

    def set_group(self, group):
        self.group = group

    def get_issues(self):
        return self.issues

    def get_type(self):
        return self.type

    def set_type(self, type):
        self.type = type

    def get_comment(self):
        return self.comment

    def set_comment(self, comment):
        self.comment = comment

    def get_guid(self):
        return self.guid

    def set_guid(self, guid):
        self.guid = guid

    def get_link_file(self):
        return self.link_file
    
    def set_link_file(self, link_file):
        self.link_file = link_file
    
    def pretty_print(self):
        if (self.volume != "1"):
            print self.title + " (Vol. " + self.volume + ")"
        else:
            print self.title
        print self.publisher
        print self.type
        print ""

    def pretty_print_issues(self):
        for i in self.issues:
            i.pretty_print()

        

class Issue:
    def __init__(self):
        self.issue_number = ""
        self.price = ""
        self.current_price = ""
        self.purchase_price = ""
        self.comment = ""
        self.image = ""
        self.writer = []
        self.penciller = []
        self.inker = []
        self.title = []

        self.condition = "1"
        self.location = ""
        self.date = time.time()

        self.show_me = True
        self.guid = 0

    def init(self, issue_number, price, current_price, purchase_price, comment, image, writer, penciller, inker, title, condition, location, date, guid):
        self.issue_number = issue_number
        self.price = price
        self.current_price = current_price
        self.purchase_price = purchase_price
        self.comment = comment
        self.image = image
        self.writer = writer
        self.penciller = penciller
        self.inker = inker
        self.title = title

        self.condition = condition
        self.location = location
        self.date = date

        self.guid = guid

    def get_issue_number(self):
        return self.issue_number

    def set_issue_number(self, issue_number):
        self.issue_number = issue_number

    def get_comment(self):
        return self.comment

    def set_comment(self, comment):
        self.comment = comment

    def get_price(self):
        return self.price

    def get_cover_price(self):
        return self.price

    def set_price(self, price):
        self.price = price

    def get_current_price(self):
        return self.current_price

    def set_current_price(self, current_price):
        self.current_price = current_price

    def get_purchase_price(self):
        return self.purchase_price

    def set_purchase_price(self, purchase_price):
        self.purchase_price = purchase_price

    def get_image(self):
        return self.image

    def set_image(self, image):
        self.image = image

    def get_title(self):
        return self.title

    def set_title(self, title):
        self.title = title

    def get_writer(self):
        return self.writer

    def set_writer(self, writer):
         self.writer = writer

    def get_penciller(self):
        return self.penciller

    def set_penciller(self, penciller):
        self.penciller = penciller

    def get_inker(self):
        return self.inker

    def set_inker(self, inker):
        self.inker = inker

    def get_condition(self):
        return self.condition

    def set_condition(self, condition):
        self.condition = condition

    def get_location(self):
        return self.location

    def set_location(self, location):
        self.location = location

    def get_date(self):
        return self.date

    def set_date(self, date):
        self.date = date

    def get_guid(self):
        return self.guid

    def set_guid(self, guid):
        self.guid = guid

    def pretty_print(self):
        print "Issue number: " + self.issue_number
        if (self.price != ""):
            print "Cover price: " + self.price
        if (len(self.writer) > 0):
            print "Writers:"
            for s in self.writer:
                print s
            print ""
        if (len(self.penciller) > 0):
            print "Pencillers:"
            for s in self.penciller:
                print s
            print ""
        if (len(self.inker) > 0):
            print "Inkers:"
            for s in self.inker:
                print s
            print ""
        if (len(self.title) > 0):
            print "Titles:"
            for s in self.title:
                print s
            print ""
        print "Condition: " + int2condition(int(self.condition))
        print ""


def uuid_generator(start):
    i = start
    while (True):
        i = i + 1
        yield i

def int2condition(i):
    condition_array = ["Mint", "Near-Mint", "Very Fine", "Fine/Very Fine", "Fine", "Very Good", "Good", "Fair", "Poor"]
    return condition_array[i]

def comic_compare_title(a, b):
    retval = cmp(a.get_group(), b.get_group())
    if (retval == 0): # same group
        retval = cmp(a.get_title(), b.get_title())
        if (retval == 0): # same title
            retval = cmp(a.get_volume(), b.get_volume())

    return retval

def comic_compare_publisher(a, b):
    retval = cmp(a.get_group(), b.get_group())
    if (retval == 0): # same group
        retval = cmp(a.get_publisher(), b.get_publisher())
        if (retval == 0): # same publisher
            retval = cmp(a.get_title(), b.get_title())
            if (retval == 0): # same title
                retval = cmp(a.get_volume(), b.get_volume())

    return retval

def comic_compare_type(a, b):
    retval = cmp(a.get_group(), b.get_group())
    if (retval == 0): # same group
        retval = cmp(a.get_type(), b.get_type())
        if (retval == 0): # same type
            retval = cmp(a.get_title(), b.get_title())
            if (retval == 0): # same title
                retval = cmp(a.get_volume(), b.get_volume())

    return retval

def issue_compare_issue_number(a, b):
    ia = 0
    ib = 0
    head_a = ""
    head_b = ""
    tail_a = ""
    tail_b = ""
    
    try:
        ia = int(a.get_issue_number())
        ib = int(b.get_issue_number())
    except:
        int_part_re = re.compile("([-]?[0-9][0-9]*)")

        int_part_match = int_part_re.search(a.get_issue_number())
        if (int_part_match != None):
            head_tail = string.split(a.get_issue_number(), int_part_match.group(1), 1)
            if (len(head_tail) == 2):
                head_a = head_tail[0]
                ia = int(int_part_match.group(1))
                tail_a = head_tail[1]
        else:
            tail_a = a.get_issue_number()

        int_part_match = int_part_re.search(b.get_issue_number())
        if (int_part_match != None):
            head_tail = string.split(b.get_issue_number(), int_part_match.group(1), 1)
            if (len(head_tail) == 2):
                head_b = head_tail[0]
                ib = int(int_part_match.group(1))
                tail_b = head_tail[1]
        else:
            tail_b = b.get_issue_number()

    retval = cmp(head_a, head_b)
    if (retval == 0):
        # head parts are the same
        retval = cmp(ia, ib)
        if (retval == 0):
            # same integer parts
            retval = cmp(tail_a, tail_b)

    return retval
