%top{
/* search-lexer.l - Lexer for search criteria strings.
 *
 * Copyright (C) 2005, 2007  Oskar Liljeblad
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

#include <config.h>
#include "xalloc.h"
#include "strbuf.h"
#include "gmediaserver.h"
#include "search-parser.h"

#define YY_EXTRA_TYPE SearchCriteriaParseData *

/* XXX: disabled. %option prefix="search_criteria_" */
}

%option noyywrap
%option nounput
%option noyyget_text noyyget_lineno noyyset_lineno noyyget_in noyyset_in
%option noyyget_out noyyset_out noyyget_lval noyyset_lval noyyget_lloc
%option noyyset_lloc noyyget_debug noyyset_debug

%option bison-bridge
%option reentrant
%option header-file="search-lexer.h"

%x STRING

WHITECHAR 		[ \t\n\v\f\r]
PROPERTYCHAR		[^ \t\n\v\f\r\"()]

%%

{WHITECHAR}+		/* discard */

"and"			return T_AND;
"or"			return T_OR;
"="			return T_EQ;
"!="			return T_NE;
"<"			return T_LT;
"<="			return T_LE;
">"			return T_GT;
">="			return T_GE;
"contains"		return T_CONTAINS;
"doesNotContain"	return T_DOES_NOT_CONTAIN;
"derivedfrom"		return T_DERIVED_FROM;
"exists"		return T_EXISTS;
"true"			return T_TRUE;
"false"			return T_FALSE;

[*()]			return yytext[0];

\"			{
			  BEGIN(STRING);
			  yyextra->buf = strbuf_new();
			}
<STRING>{
  \"			{
			  BEGIN(INITIAL);
			  /* Strings allocated will be freed in parser in
			   * case of error - see %destructor.
			   */
			  yylval->str = strbuf_free_to_string(yyextra->buf);
			  return T_STRING;
			}
  \\.			strbuf_append_char(yyextra->buf, yytext[1]);
  [^\\\"]+		strbuf_append(yyextra->buf, yytext);
  <<EOF>>		{
    			  strbuf_free(yyextra->buf);
			  yyterminate(); /* error */
  			}
}

{PROPERTYCHAR}+		{
			  /* This is a "catch all characters" match too! */
			  yylval->str = xstrdup(yytext);
			  return T_PROPERTY;
			}

<<EOF>>			yyterminate();

%%
