#include "ui_GNUDoQForm.h"
#include "GNUDoQ.H"

#include <QApplication>
#include <QTranslator>
#include <QLocale>

int
main (int argc, char *argv[])
{
  QApplication app (argc, argv);

  QTranslator translator;
  QString locale = QLocale::system().name();
 
  translator.load(QString("GNUDoQ_") + locale);
  app.installTranslator(&translator);

  GNUDoQ *gnudoq = new GNUDoQ;
  QObject::connect(&app, SIGNAL(lastWindowClosed()),
                   gnudoq, SLOT(SavePuzzle()));
  gnudoq->show();
  
  return app.exec ();
}
