// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/genomics/v1/readgroupset.proto
// DO NOT EDIT!

package google_genomics_v1 // import "google.golang.org/genproto/googleapis/genomics/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"
import google_protobuf3 "github.com/golang/protobuf/ptypes/struct"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// A read group set is a logical collection of read groups, which are
// collections of reads produced by a sequencer. A read group set typically
// models reads corresponding to one sample, sequenced one way, and aligned one
// way.
//
// * A read group set belongs to one dataset.
// * A read group belongs to one read group set.
// * A read belongs to one read group.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type ReadGroupSet struct {
	// The server-generated read group set ID, unique for all read group sets.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The dataset to which this read group set belongs.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The reference set to which the reads in this read group set are aligned.
	ReferenceSetId string `protobuf:"bytes,3,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// The read group set name. By default this will be initialized to the sample
	// name of the sequenced data contained in this set.
	Name string `protobuf:"bytes,4,opt,name=name" json:"name,omitempty"`
	// The filename of the original source file for this read group set, if any.
	Filename string `protobuf:"bytes,5,opt,name=filename" json:"filename,omitempty"`
	// The read groups in this set. There are typically 1-10 read groups in a read
	// group set.
	ReadGroups []*ReadGroup `protobuf:"bytes,6,rep,name=read_groups,json=readGroups" json:"read_groups,omitempty"`
	// A map of additional read group set information.
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,7,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ReadGroupSet) Reset()                    { *m = ReadGroupSet{} }
func (m *ReadGroupSet) String() string            { return proto.CompactTextString(m) }
func (*ReadGroupSet) ProtoMessage()               {}
func (*ReadGroupSet) Descriptor() ([]byte, []int) { return fileDescriptor8, []int{0} }

func (m *ReadGroupSet) GetReadGroups() []*ReadGroup {
	if m != nil {
		return m.ReadGroups
	}
	return nil
}

func (m *ReadGroupSet) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

func init() {
	proto.RegisterType((*ReadGroupSet)(nil), "google.genomics.v1.ReadGroupSet")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/genomics/v1/readgroupset.proto", fileDescriptor8)
}

var fileDescriptor8 = []byte{
	// 387 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x91, 0x4f, 0x8b, 0xdb, 0x30,
	0x10, 0xc5, 0xb1, 0xf3, 0xa7, 0x8d, 0x52, 0x42, 0xaa, 0x43, 0x31, 0x86, 0x40, 0xe8, 0x29, 0xf4,
	0x20, 0x25, 0x29, 0x85, 0xd2, 0x43, 0xa0, 0xa1, 0xa5, 0x04, 0x7a, 0x08, 0x36, 0xf4, 0x1a, 0x14,
	0x7b, 0xac, 0x8a, 0xda, 0x92, 0x91, 0x64, 0x43, 0xbe, 0x73, 0x3f, 0xc0, 0x1e, 0x17, 0xcb, 0x7f,
	0x58, 0xd8, 0x65, 0x59, 0xd8, 0x93, 0xc7, 0x6f, 0xde, 0xfc, 0x78, 0x9a, 0x41, 0x3f, 0xb8, 0x52,
	0x3c, 0x07, 0xc2, 0x55, 0xce, 0x24, 0x27, 0x4a, 0x73, 0xca, 0x41, 0x96, 0x5a, 0x59, 0x45, 0xdb,
	0x16, 0x2b, 0x85, 0x69, 0x34, 0x55, 0x88, 0xc4, 0xd0, 0x7a, 0x47, 0x35, 0xb0, 0x94, 0x6b, 0x55,
	0x95, 0x06, 0x2c, 0x71, 0x4e, 0x8c, 0x7b, 0x4a, 0x67, 0x23, 0xf5, 0x2e, 0x3c, 0xbd, 0x8c, 0xcc,
	0x4a, 0x41, 0x0d, 0xe8, 0x5a, 0x24, 0x90, 0x28, 0x99, 0x09, 0x4e, 0x99, 0x94, 0xca, 0x32, 0x2b,
	0x94, 0x34, 0x2d, 0x3e, 0xfc, 0xfe, 0x8a, 0x90, 0x1d, 0xe2, 0x0b, 0x17, 0xf6, 0x6f, 0x75, 0x25,
	0x89, 0x2a, 0x68, 0x8b, 0xa1, 0xae, 0x71, 0xad, 0x32, 0x5a, 0xda, 0x5b, 0x09, 0x86, 0x1a, 0xab,
	0xab, 0xc4, 0x76, 0x9f, 0x76, 0xec, 0xe3, 0x7f, 0x1f, 0xbd, 0x8b, 0x80, 0xa5, 0xbf, 0x1a, 0x54,
	0x0c, 0x16, 0x2f, 0x90, 0x2f, 0xd2, 0xc0, 0x5b, 0x7b, 0x9b, 0x59, 0xe4, 0x8b, 0x14, 0xaf, 0x10,
	0x4a, 0x99, 0x65, 0x06, 0xec, 0x45, 0xa4, 0x81, 0xef, 0xf4, 0x59, 0xa7, 0x9c, 0x52, 0xbc, 0x41,
	0x4b, 0x0d, 0x19, 0x68, 0x90, 0x09, 0x5c, 0x3a, 0xd3, 0xc8, 0x99, 0x16, 0x83, 0x1e, 0x3b, 0x27,
	0x46, 0x63, 0xc9, 0x0a, 0x08, 0xc6, 0xae, 0xeb, 0x6a, 0x1c, 0xa2, 0xb7, 0x99, 0xc8, 0xc1, 0xe9,
	0x13, 0xa7, 0x0f, 0xff, 0xf8, 0x80, 0xe6, 0xcd, 0x1b, 0x2f, 0xed, 0x25, 0x82, 0xe9, 0x7a, 0xb4,
	0x99, 0xef, 0x57, 0xe4, 0xf1, 0x21, 0xc8, 0x90, 0x3f, 0x42, 0xba, 0x2f, 0x0d, 0x3e, 0xa0, 0xb1,
	0x90, 0x99, 0x0a, 0xde, 0xb8, 0xc1, 0x4f, 0xcf, 0x0e, 0xc6, 0x60, 0xc9, 0x49, 0x66, 0xea, 0xa7,
	0xb4, 0xfa, 0x16, 0xb9, 0xb9, 0x30, 0x46, 0xb3, 0x41, 0xc2, 0x4b, 0x34, 0xfa, 0x07, 0xb7, 0x6e,
	0x2d, 0x4d, 0x89, 0xb7, 0x68, 0x52, 0xb3, 0xbc, 0x02, 0xb7, 0x92, 0xf9, 0x3e, 0xec, 0xf9, 0xfd,
	0xd2, 0xc9, 0x6f, 0x61, 0xec, 0x9f, 0xc6, 0x11, 0xb5, 0xc6, 0x6f, 0xfe, 0x57, 0xef, 0xb8, 0x45,
	0x1f, 0x12, 0x55, 0x3c, 0x91, 0xe5, 0xf8, 0xfe, 0x61, 0x98, 0x73, 0x03, 0x39, 0x7b, 0x77, 0x9e,
	0x77, 0x9d, 0x3a, 0xe0, 0xe7, 0xfb, 0x00, 0x00, 0x00, 0xff, 0xff, 0xdf, 0xc2, 0x82, 0x2e, 0xc8,
	0x02, 0x00, 0x00,
}
