/*
 * Copyright 2008 Advanced Micro Devices, Inc.
 * Copyright 2008 Red Hat Inc.
 * Copyright 2009 Jerome Glisse.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: Dave Airlie
 *          Alex Deucher
 *          Jerome Glisse
 */
#ifndef __RS100D_H__
#define __RS100D_H__

#include <sys/cdefs.h>
__FBSDID("$FreeBSD$");

/* Registers */
#define R_00015C_NB_TOM                              0x00015C
#define   S_00015C_MC_FB_START(x)                      (((x) & 0xFFFF) << 0)
#define   G_00015C_MC_FB_START(x)                      (((x) >> 0) & 0xFFFF)
#define   C_00015C_MC_FB_START                         0xFFFF0000
#define   S_00015C_MC_FB_TOP(x)                        (((x) & 0xFFFF) << 16)
#define   G_00015C_MC_FB_TOP(x)                        (((x) >> 16) & 0xFFFF)
#define   C_00015C_MC_FB_TOP                           0x0000FFFF

#endif
