// Unified token -*- c++ -*-

#ifdef __GNUC__
# pragma implementation
#endif // __GNUC__
#include "Token.h"
#include "VariableSet.h"

/** @file Token.C
 * Tokens used in the unification process
 */

/* Copyright  1999-2002 Marko Mkel (msmakela@tcs.hut.fi).

   This file is part of MARIA, a reachability analyzer and model checker
   for high-level Petri nets.

   MARIA is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   MARIA is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   The GNU General Public License is often shipped with GNU software, and
   is generally kept in a file called COPYING or LICENSE.  If you do not
   have a copy of the license, write to the Free Software Foundation,
   59 Temple Place, Suite 330, Boston, MA 02111 USA. */

Token::~Token ()
{
  delete myUnifiedUndefined;
  delete myValue;
}

bool
Token::isBindable (const class Valuation& valuation)
{
  assert (valuation.isOK ());
  const class Expression& expr = *myUnifier.m->getToken ();
  if (myUnifier.isSet) {
    delete myValue;
    if ((myValue = expr.meval (valuation))) {
      assert (valuation.isOK ());
      if (*myValue <= myPlaceMarking)
	return true;
    }
  }
  else if (class Value* value = expr.eval (valuation)) {
    assert (valuation.isOK ());
    myIterator = myPlaceMarking.find (value);
    delete value;
    if (myIterator != end ()) {
      if (myCardinality <= PlaceMarking::getCount (myIterator))
	return true;
      myIterator = begin ();
    }
  }

  return false;
}

bool
Token::isBindableUnfold (const class Valuation& valuation)
{
  assert (valuation.isOK ());
  const class Expression& expr = *myUnifier.m->getToken ();
  if (myUnifier.isSet) {
    delete myValue;
    if ((myValue = expr.meval (valuation))) {
      assert (valuation.isOK ());
      return myValue->isSubset (myPlaceMarking);
    }
  }
  else if (class Value* value = expr.eval (valuation)) {
    assert (valuation.isOK ());
    myIterator = myPlaceMarking.find (value);
    delete value;
    return myIterator != end ();
  }

  return false;
}

void
Token::undefine (class Valuation& valuation)
{
  if (!myUnifier.vars)
    return;
  const class VariableSet& vars = *myUnifier.vars;
  VariableSet::const_iterator i = vars.begin ();
  if (!myUnifier.varMult)
    for (; i != vars.end (); i++)
      valuation.undefine (**i);
  else
    for (; i != vars.end (); i++)
      if (!isUnified (**i)) valuation.undefine (**i);
}

void
Token::addUnified (const class Valuation& valuation)
{
  assert (myUnifier.varMult);
  assert (!myUnifiedUndefined);
  const class VariableSet& vars = *myUnifier.vars;
  for (VariableSet::const_iterator i = vars.begin (); i != vars.end (); i++) {
    if (valuation.getValue (**i)) {
      if (!myUnifiedUndefined) myUnifiedUndefined = new class VariableSet;
      myUnifiedUndefined->insert (**i);
    }
  }
}

bool
Token::isUnified (const class VariableDefinition& var) const
{
  return myUnifiedUndefined && myUnifiedUndefined->contains (var);
}

#ifndef NDEBUG
# include "VariableDefinition.h"

void
Token::assertUndefined (const class Valuation& valuation) const
{
  const class VariableSet& vars = *myUnifier.vars;
  for (VariableSet::const_iterator i = vars.begin (); i != vars.end (); i++)
    assert (!valuation.getValue (**i) || (*i)->isUndefined ());
}

void
Token::assertDefined (const class Valuation& valuation) const
{
  const class VariableSet& vars = *myUnifier.vars;
  for (VariableSet::const_iterator i = vars.begin (); i != vars.end (); i++)
    assert (!!valuation.getValue (**i));
}
#endif // NDEBUG
