/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.figures;

import org.jhotdraw.figures.GroupFigure;
import org.jhotdraw.framework.DrawingEditor;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.Figure;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.standard.AbstractCommand;
import org.jhotdraw.util.Undoable;
import org.jhotdraw.util.UndoableAdapter;

public class UngroupCommand
extends AbstractCommand {
    public UngroupCommand(String string, DrawingEditor drawingEditor) {
        super(string, drawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selection());
        this.view().clearSelection();
        ((UndoActivity)this.getUndoActivity()).ungroupFigures();
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        FigureEnumeration figureEnumeration = this.view().selection();
        while (figureEnumeration.hasNextFigure()) {
            Figure figure = figureEnumeration.nextFigure();
            if ((figure = figure.getDecoratedFigure()) instanceof GroupFigure) continue;
            return false;
        }
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView drawingView) {
            super(drawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                this.getDrawingView().drawing().orphanAll(figure.figures());
                Figure figure2 = this.getDrawingView().drawing().add(figure);
                this.getDrawingView().addToSelection(figure2);
            }
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
                this.getDrawingView().clearSelection();
                this.ungroupFigures();
                return true;
            }
            return false;
        }

        protected void ungroupFigures() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            while (figureEnumeration.hasNextFigure()) {
                Figure figure = figureEnumeration.nextFigure();
                Figure figure2 = this.getDrawingView().drawing().orphan(figure);
                this.getDrawingView().drawing().addAll(figure2.figures());
                this.getDrawingView().addToSelectionAll(figure2.figures());
            }
        }
    }
}

