/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.adde.AddeURLConnection;
import edu.wisc.ssec.mcidas.adde.AddeURLException;
import java.io.DataInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;

public class ReadTextFile {
    private int status = 0;
    private String statusString = "OK";
    private boolean debug = false;
    private Vector linesOfText = null;
    private URLConnection urlc;
    private DataInputStream dis;

    public ReadTextFile(String request) {
        try {
            URL url = new URL(request);
            if (this.debug) {
                System.out.println("Request: " + request);
            }
            this.urlc = url.openConnection();
            InputStream is = this.urlc.getInputStream();
            this.dis = new DataInputStream(is);
        }
        catch (AddeURLException ae) {
            this.status = -1;
            this.statusString = "No file found";
            String aes = ae.toString();
            if (aes.indexOf(" Accounting ") != -1) {
                this.statusString = "No accounting data";
                this.status = -3;
            }
            if (this.debug) {
                System.out.println("ReadText AF Exception:" + aes);
            }
        }
        catch (Exception e) {
            this.status = -2;
            if (this.debug) {
                System.out.println("ReadText Exception:" + e);
            }
            this.statusString = "Error opening connection: " + e;
        }
        this.linesOfText = new Vector();
        if (this.status == 0) {
            try {
                int numBytes = ((AddeURLConnection)this.urlc).getInitialRecordSize();
                if (this.debug) {
                    System.out.println("ReadTextFile: initial numBytes = " + numBytes);
                }
                numBytes = this.dis.readInt();
                while ((numBytes = this.dis.readInt()) != 0) {
                    if (this.debug) {
                        System.out.println("ReadTextFile: numBytes = " + numBytes);
                    }
                    byte[] data = new byte[numBytes];
                    this.dis.readFully(data, 0, numBytes);
                    String s = new String(data);
                    if (this.debug) {
                        System.out.println(s);
                    }
                    this.linesOfText.addElement(s);
                }
            }
            catch (Exception iox) {
                this.statusString = " " + iox;
                System.out.println(" " + iox);
            }
            if (this.linesOfText.size() < 1) {
                this.statusString = "No data read";
            }
            this.status = this.linesOfText.size();
        }
    }

    public String getStatus() {
        return this.statusString;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Vector getText() {
        return this.linesOfText;
    }

    public static void main(String[] args) throws Exception {
        String request = args.length == 0 ? "adde://adde.ucar.edu/text?file=PUBLIC.SRV" : args[0];
        ReadTextFile rtf = new ReadTextFile(request);
        String status = rtf.getStatus();
        System.out.println("Status = " + status);
        if (status.equals("OK")) {
            Vector l = rtf.getText();
            for (int i = 0; i < l.size(); ++i) {
                System.out.println((String)l.elementAt(i));
            }
        }
    }

    static {
        try {
            String handlers = System.getProperty("java.protocol.handler.pkgs");
            String newProperty = null;
            if (handlers == null) {
                newProperty = "edu.wisc.ssec.mcidas";
            } else if (handlers.indexOf("edu.wisc.ssec.mcidas") < 0) {
                newProperty = "edu.wisc.ssec.mcidas | " + handlers;
            }
            if (newProperty != null) {
                System.setProperty("java.protocol.handler.pkgs", newProperty);
            }
        }
        catch (Exception e) {
            System.out.println("Unable to set System Property: java.protocol.handler.pkgs");
        }
    }
}

