# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExportDevicesRequest(Model):
    """Used to provide parameters when requesting an export of all devices in the
    hub.

    :param export_blob_container_uri: The export BLOB container URI.
    :type export_blob_container_uri: str
    :param exclude_keys: The value indicating whether keys should be excluded
     during export.
    :type exclude_keys: bool
    """ 

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'ExportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'ExcludeKeys', 'type': 'bool'},
    }

    def __init__(self, export_blob_container_uri, exclude_keys):
        self.export_blob_container_uri = export_blob_container_uri
        self.exclude_keys = exclude_keys
