% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adephylo-package.R
\docType{data}
\name{carni70}
\alias{carni70}
\title{Phylogeny and quantitative traits of carnivora}
\format{\code{carni70} is a list containing the 2 following objects:
\describe{ \item{tre}{is a character string giving the phylogenetic tree in
Newick format.  Branch lengths are expressed as divergence times (millions
of years)} \item{tab}{is a data frame with 70 species and two traits: size
(body size (kg)) ; range (geographic range size (km)).} }}
\source{
Diniz-Filho, J. A. F., and N. M. Torres. (2002) Phylogenetic
comparative methods and the geographic range size-body size relationship in
new world terrestrial carnivora. \emph{Evolutionary Ecology}, \bold{16},
351--367.
}
\description{
This data set describes the phylogeny of 70 carnivora as reported by
Diniz-Filho and Torres (2002). It also gives the geographic range size and
body size corresponding to these 70 species.
}
\note{
This dataset replaces the former version in ade4.
}
\examples{

\dontrun{
if(require(ape) && require(phylobase)){

data(carni70)
rownames(carni70$tab) <- gsub("_", ".", rownames(carni70$tab))
tre <- read.tree(text=carni70$tre)
x <- phylo4d(tre, carni70$tab)
table.phylo4d(x)

par(mar=rep(.1,4))
table.phylo4d(x,cex.lab=.5, show.n=FALSE, ratio=.5)


## transform size in log and test for a phylogenetic signal
size <- log(carni70$tab)[,1]
names(size) <- row.names(carni70$tab)
orthogram(size, tre)

## transform range and test for a phylogenetic signal
yrange <- scale(carni70$tab)[,2]
names(yrange) <- row.names(carni70$tab)
orthogram(yrange, tre)
}
}

}
\keyword{datasets}

