% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{ego}
\alias{connect}
\alias{connect.neighborhood}
\alias{ego}
\alias{ego_graph}
\alias{ego_size}
\alias{graph.neighborhood}
\alias{make_ego_graph}
\alias{neighborhood}
\alias{neighborhood.size}
\title{Neighborhood of graph vertices}
\usage{
ego(graph, order, nodes = V(graph), mode = c("all", "out", "in"),
  mindist = 0)

make_ego_graph(graph, order, nodes = V(graph), mode = c("all", "out", "in"),
  mindist = 0)
}
\arguments{
\item{graph}{The input graph.}

\item{order}{Integer giving the order of the neighborhood.}

\item{nodes}{The vertices for which the calculation is performed.}

\item{mode}{Character constatnt, it specifies how to use the direction of
the edges if a directed graph is analyzed. For \sQuote{out} only the
outgoing edges are followed, so all vertices reachable from the source
vertex in at most \code{order} steps are counted. For \sQuote{"in"} all
vertices from which the source vertex is reachable in at most \code{order}
steps are counted. \sQuote{"all"} ignores the direction of the edges. This
argument is ignored for undirected graphs.}

\item{mindist}{The minimum distance to include the vertex in the result.}
}
\value{
\code{ego_size} returns with an integer vector.

\code{ego} returns with a list of integer vectors.

\code{make_ego_graph} returns with a list of graphs.

\code{connect} returns with a new graph object.
}
\description{
These functions find the vertices not farther than a given limit from
another fixed vertex, these are called the neighborhood of the vertex.
}
\details{
The neighborhood of a given order \code{o} of a vertex \code{v} includes all
vertices which are closer to \code{v} than the order. Ie. order 0 is always
\code{v} itself, order 1 is \code{v} plus its immediate neighbors, order 2
is order 1 plus the immediate neighbors of the vertices in order 1, etc.

\code{ego_size} calculates the size of the neighborhoods for the
given vertices with the given order.

\code{ego} calculates the neighborhoods of the given vertices with
the given order parameter.

\code{make_ego_graph} is creates (sub)graphs from all neighborhoods of
the given vertices with the given order parameter. This function preserves
the vertex, edge and graph attributes.

\code{connect} creates a new graph by connecting each vertex to
all other vertices in its neighborhood.
}
\examples{
g <- make_ring(10)
ego_size(g, 0, 1:3)
ego_size(g, 1, 1:3)
ego_size(g, 2, 1:3)
ego(g, 0, 1:3)
ego(g, 1, 1:3)
ego(g, 2, 1:3)

# attributes are preserved
V(g)$name <- c("a", "b", "c", "d", "e", "f", "g", "h", "i", "j")
make_ego_graph(g, 2, 1:3)

# connecting to the neighborhood
g <- make_ring(10)
g <- connect(g, 2)
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}, the first version was
done by Vincent Matossian
}
\keyword{graphs}

