% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all-equal.r
\name{all_equal}
\alias{all.equal.tbl_df}
\alias{all_equal}
\title{Flexible equality comparison for data frames.}
\usage{
all_equal(target, current, ignore_col_order = TRUE, ignore_row_order = TRUE,
  convert = FALSE, ...)

\method{all.equal}{tbl_df}(target, current, ignore_col_order = TRUE,
  ignore_row_order = TRUE, convert = FALSE, ...)
}
\arguments{
\item{target, current}{Two data frames to compare.}

\item{ignore_col_order}{Should order of columns be ignored?}

\item{ignore_row_order}{Should order of rows be ignored?}

\item{convert}{Should similar classes be converted? Currently this will
convert factor to character and integer to double.}

\item{...}{Ignored. Needed for compatibility with \code{all.equal}.}
}
\value{
\code{TRUE} if equal, otherwise a character vector describing
  the reasons why they're not equal. Use \code{\link{isTRUE}} if using the
  result in an \code{if} expression.
}
\description{
When comparing two \code{tbl_df} using \code{\link{all.equal}}, column and
row order is ignored by default, and types are not coerced.  The \code{dplyr}
package provides a much more efficient implementation for this functionality.
}
\examples{
scramble <- function(x) x[sample(nrow(x)), sample(ncol(x))]
mtcars_df <- as_tibble(mtcars)

# By default, ordering of rows and columns ignored
all.equal(mtcars_df, scramble(mtcars_df))

# But those can be overriden if desired
all.equal(mtcars_df, scramble(mtcars_df), ignore_col_order = FALSE)
all.equal(mtcars_df, scramble(mtcars_df), ignore_row_order = FALSE)

# By default all.equal is sensitive to variable differences
df1 <- tibble(x = "a")
df2 <- tibble(x = factor("a"))
all.equal(df1, df2)
# But you can request to convert similar types
all.equal(df1, df2, convert = TRUE)
}

