# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  module Models
    #
    # Represents a recommendation rule that the recommendation engine can
    # perform
    #
    class RecommendationRule

      include MsRestAzure

      # @return [String] Unique name of the rule
      attr_accessor :name

      # @return [String] UI friendly name of the rule
      attr_accessor :display_name

      # @return [String] Localized name of the rule (Good for UI)
      attr_accessor :message

      # @return [String] Recommendation ID of an associated recommendation
      # object tied to the rule, if exists.
      # If such an object doesn't exist, it is set to null.
      attr_accessor :recommendation_id

      # @return [String] Localized detailed description of the rule
      attr_accessor :description

      # @return [String] Name of action that is recommended by this rule in
      # string
      attr_accessor :action_name

      # @return [Integer] On/off flag indicating the rule is currently enabled
      # or disabled.
      attr_accessor :enabled

      # @return [NotificationLevel] Level of impact indicating how critical
      # this rule is. Possible values include: 'Critical', 'Warning',
      # 'Information', 'NonUrgentSuggestion'
      attr_accessor :level

      # @return [Channels] List of available channels that this rule applies.
      # Possible values include: 'Notification', 'Api', 'Email', 'All'
      attr_accessor :channels

      # @return [Array<String>] An array of category tags that the rule
      # contains.
      attr_accessor :tags


      #
      # Mapper for RecommendationRule class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'RecommendationRule',
          type: {
            name: 'Composite',
            class_name: 'RecommendationRule',
            model_properties: {
              name: {
                required: false,
                serialized_name: 'name',
                type: {
                  name: 'String'
                }
              },
              display_name: {
                required: false,
                serialized_name: 'displayName',
                type: {
                  name: 'String'
                }
              },
              message: {
                required: false,
                serialized_name: 'message',
                type: {
                  name: 'String'
                }
              },
              recommendation_id: {
                required: false,
                serialized_name: 'recommendationId',
                type: {
                  name: 'String'
                }
              },
              description: {
                required: false,
                serialized_name: 'description',
                type: {
                  name: 'String'
                }
              },
              action_name: {
                required: false,
                serialized_name: 'actionName',
                type: {
                  name: 'String'
                }
              },
              enabled: {
                required: false,
                serialized_name: 'enabled',
                type: {
                  name: 'Number'
                }
              },
              level: {
                required: true,
                serialized_name: 'level',
                type: {
                  name: 'Enum',
                  module: 'NotificationLevel'
                }
              },
              channels: {
                required: true,
                serialized_name: 'channels',
                type: {
                  name: 'Enum',
                  module: 'Channels'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Sequence',
                  element: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
