# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.0.0.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::Web
  #
  # Composite Swagger for WebSite Management Client
  #
  class WebApps
    include Azure::ARM::Web::Models
    include MsRestAzure

    #
    # Creates and initializes a new instance of the WebApps class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [WebSiteManagementClient] reference to the WebSiteManagementClient
    attr_reader :client

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list(custom_headers = nil)
      first_page = list_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(custom_headers = nil)
      list_async(custom_headers).value!
    end

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(custom_headers = nil)
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/providers/Microsoft.Web/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<DeletedSite>] operation results.
    #
    def list_deleted(resource_group_name, properties_to_include = nil, custom_headers = nil)
      first_page = list_deleted_as_lazy(resource_group_name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deleted_with_http_info(resource_group_name, properties_to_include = nil, custom_headers = nil)
      list_deleted_async(resource_group_name, properties_to_include, custom_headers).value!
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deleted_async(resource_group_name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/deletedSites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeletedWebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots in
    # results
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_by_resource_group(resource_group_name, properties_to_include = nil, include_slots = nil, custom_headers = nil)
      first_page = list_by_resource_group_as_lazy(resource_group_name, properties_to_include, include_slots, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots in
    # results
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_with_http_info(resource_group_name, properties_to_include = nil, include_slots = nil, custom_headers = nil)
      list_by_resource_group_async(resource_group_name, properties_to_include, include_slots, custom_headers).value!
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param resource_group_name [String] Name of resource group
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param include_slots [Boolean] Whether or not to include deployments slots in
    # results
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_async(resource_group_name, properties_to_include = nil, include_slots = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'includeSlots' => include_slots,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      response = get_async(resource_group_name, name, properties_to_include, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      get_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      response = delete_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      delete_async(resource_group_name, name, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, name, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomHostnameAnalysisResult] operation results.
    #
    def analyze_custom_hostname(resource_group_name, name, host_name = nil, custom_headers = nil)
      response = analyze_custom_hostname_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def analyze_custom_hostname_with_http_info(resource_group_name, name, host_name = nil, custom_headers = nil)
      analyze_custom_hostname_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Custom hostname
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def analyze_custom_hostname_async(resource_group_name, name, host_name = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/analyzeCustomHostname'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'hostName' => host_name,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CustomHostnameAnalysisResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def apply_slot_config_to_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_config_to_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_config_to_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup(resource_group_name, name, request, custom_headers = nil)
      response = backup_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_with_http_info(resource_group_name, name, request, custom_headers = nil)
      backup_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_backups(resource_group_name, name, custom_headers = nil)
      first_page = list_backups_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_with_http_info(resource_group_name, name, custom_headers = nil)
      list_backups_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_restore(resource_group_name, name, request, custom_headers = nil)
      response = discover_restore_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_restore_with_http_info(resource_group_name, name, request, custom_headers = nil)
      discover_restore_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_restore_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_backup_status(resource_group_name, name, backup_id, custom_headers = nil)
      response = get_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_status_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      get_backup_status_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_status_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def delete_backup(resource_group_name, name, backup_id, custom_headers = nil)
      response = delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_with_http_info(resource_group_name, name, backup_id, custom_headers = nil)
      delete_backup_async(resource_group_name, name, backup_id, custom_headers).value!
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_async(resource_group_name, name, backup_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def list_backup_status_secrets(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backup_status_secrets_with_http_info(resource_group_name, name, backup_id, request, custom_headers = nil)
      list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backup_status_secrets_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = restore_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      # Send request
      promise = begin_restore_async(resource_group_name, name, backup_id, request, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_application_settings(resource_group_name, name, app_settings, custom_headers = nil)
      response = update_application_settings_async(resource_group_name, name, app_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_application_settings_with_http_info(resource_group_name, name, app_settings, custom_headers = nil)
      update_application_settings_async(resource_group_name, name, app_settings, custom_headers).value!
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_application_settings_async(resource_group_name, name, app_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings, 'app_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_application_settings(resource_group_name, name, custom_headers = nil)
      response = list_application_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_application_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_application_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_application_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_auth_settings(resource_group_name, name, site_auth_settings, custom_headers = nil)
      response = update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_auth_settings_with_http_info(resource_group_name, name, site_auth_settings, custom_headers = nil)
      update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_auth_settings_async(resource_group_name, name, site_auth_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings, 'site_auth_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def list_auth_settings(resource_group_name, name, custom_headers = nil)
      response = list_auth_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_auth_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_auth_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_auth_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_backup_configuration(resource_group_name, name, request, custom_headers = nil)
      response = update_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_backup_configuration_with_http_info(resource_group_name, name, request, custom_headers = nil)
      update_backup_configuration_async(resource_group_name, name, request, custom_headers).value!
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_backup_configuration_async(resource_group_name, name, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_backup_configuration(resource_group_name, name, custom_headers = nil)
      response = delete_backup_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_backup_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_backup_configuration(resource_group_name, name, custom_headers = nil)
      response = get_backup_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_backup_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_connection_strings(resource_group_name, name, connection_strings, custom_headers = nil)
      response = update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_connection_strings_with_http_info(resource_group_name, name, connection_strings, custom_headers = nil)
      update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers).value!
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_connection_strings_async(resource_group_name, name, connection_strings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings, 'connection_strings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_connection_strings(resource_group_name, name, custom_headers = nil)
      response = list_connection_strings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connection_strings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_connection_strings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connection_strings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_diagnostic_logs_configuration(resource_group_name, name, custom_headers = nil)
      response = get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_diagnostic_logs_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_diagnostic_logs_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_diagnostic_logs_config(resource_group_name, name, site_logs_config, custom_headers = nil)
      response = update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_diagnostic_logs_config_with_http_info(resource_group_name, name, site_logs_config, custom_headers = nil)
      update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_diagnostic_logs_config_async(resource_group_name, name, site_logs_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config, 'site_logs_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_metadata(resource_group_name, name, metadata, custom_headers = nil)
      response = update_metadata_async(resource_group_name, name, metadata, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_metadata_with_http_info(resource_group_name, name, metadata, custom_headers = nil)
      update_metadata_async(resource_group_name, name, metadata, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_metadata_async(resource_group_name, name, metadata, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata, 'metadata')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_metadata(resource_group_name, name, custom_headers = nil)
      response = list_metadata_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metadata_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metadata_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metadata_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_publishing_credentials(resource_group_name, name, custom_headers = nil)
      response = list_publishing_credentials_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_publishing_credentials_async(resource_group_name, name, custom_headers = nil)
      # Send request
      promise = begin_list_publishing_credentials_async(resource_group_name, name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def update_site_push_settings(resource_group_name, name, push_settings, custom_headers = nil)
      response = update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_push_settings_with_http_info(resource_group_name, name, push_settings, custom_headers = nil)
      update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers).value!
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_push_settings_async(resource_group_name, name, push_settings, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'push_settings is nil' if push_settings.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PushSettings.mapper()
      request_content = @client.serialize(request_mapper,  push_settings, 'push_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def list_site_push_settings(resource_group_name, name, custom_headers = nil)
      response = list_site_push_settings_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_push_settings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_site_push_settings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_push_settings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/pushsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def list_slot_configuration_names(resource_group_name, name, custom_headers = nil)
      response = list_slot_configuration_names_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slot_configuration_names_with_http_info(resource_group_name, name, custom_headers = nil)
      list_slot_configuration_names_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # Gets the names of application settings and connection string that remain with
    # the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slot_configuration_names_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotConfigNamesResource] operation results.
    #
    def update_slot_configuration_names(resource_group_name, name, slot_config_names, custom_headers = nil)
      response = update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_slot_configuration_names_with_http_info(resource_group_name, name, slot_config_names, custom_headers = nil)
      update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers).value!
    end

    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # Updates the names of application settings and connection string that remain
    # with the slot during swap operation
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_config_names [SlotConfigNamesResource] Request body containing
    # the names of application settings and connection strings
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_slot_configuration_names_async(resource_group_name, name, slot_config_names, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_config_names is nil' if slot_config_names.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SlotConfigNamesResource.mapper()
      request_content = @client.serialize(request_mapper,  slot_config_names, 'slot_config_names')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/slotConfigNames'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotConfigNamesResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def get_configuration(resource_group_name, name, custom_headers = nil)
      response = get_configuration_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_with_http_info(resource_group_name, name, custom_headers = nil)
      get_configuration_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def create_or_update_configuration(resource_group_name, name, site_config, custom_headers = nil)
      response = create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_configuration_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_configuration_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def update_configuration(resource_group_name, name, site_config, custom_headers = nil)
      response = update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_configuration_with_http_info(resource_group_name, name, site_config, custom_headers = nil)
      update_configuration_async(resource_group_name, name, site_config, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_configuration_async(resource_group_name, name, site_config, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_deployments(resource_group_name, name, custom_headers = nil)
      first_page = list_deployments_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_with_http_info(resource_group_name, name, custom_headers = nil)
      list_deployments_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment(resource_group_name, name, id, custom_headers = nil)
      response = get_deployment_async(resource_group_name, name, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      get_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment(resource_group_name, name, id, deployment, custom_headers = nil)
      response = create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_with_http_info(resource_group_name, name, id, deployment, custom_headers = nil)
      create_deployment_async(resource_group_name, name, id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_async(resource_group_name, name, id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_deployment(resource_group_name, name, id, custom_headers = nil)
      response = delete_deployment_async(resource_group_name, name, id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_with_http_info(resource_group_name, name, id, custom_headers = nil)
      delete_deployment_async(resource_group_name, name, id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_async(resource_group_name, name, id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def list_host_name_bindings(resource_group_name, name, custom_headers = nil)
      first_page = list_host_name_bindings_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_with_http_info(resource_group_name, name, custom_headers = nil)
      list_host_name_bindings_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = get_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      get_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_host_name_binding(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      response = create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_host_name_binding_with_http_info(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers).value!
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_host_name_binding_async(resource_group_name, name, host_name, host_name_binding, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding, 'host_name_binding')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_host_name_binding(resource_group_name, name, host_name, custom_headers = nil)
      response = delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_host_name_binding_with_http_info(resource_group_name, name, host_name, custom_headers = nil)
      delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers).value!
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_host_name_binding_async(resource_group_name, name, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def get_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def create_or_update_hybrid_connection(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      response = create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_hybrid_connection(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def update_hybrid_connection(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      response = update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_hybrid_connection_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_hybrid_connection_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_hybrid_connection_keys(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      response = list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connection_keys_with_http_info(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers).value!
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connection_keys_async(resource_group_name, name, namespace_name, relay_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def list_hybrid_connections(resource_group_name, name, custom_headers = nil)
      response = list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_hybrid_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridConnectionRelays'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_relay_service_connections(resource_group_name, name, custom_headers = nil)
      response = list_relay_service_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_relay_service_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_relay_service_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_relay_service_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_relay_service_connection(resource_group_name, name, entity_name, custom_headers = nil)
      response = delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_relay_service_connection_with_http_info(resource_group_name, name, entity_name, custom_headers = nil)
      delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers).value!
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_relay_service_connection_async(resource_group_name, name, entity_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_relay_service_connection(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      response = update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_relay_service_connection_with_http_info(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_relay_service_connection_async(resource_group_name, name, entity_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def list_instance_identifiers(resource_group_name, name, custom_headers = nil)
      first_page = list_instance_identifiers_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_with_http_info(resource_group_name, name, custom_headers = nil)
      list_instance_identifiers_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_instance_deployments(resource_group_name, name, instance_id, custom_headers = nil)
      first_page = list_instance_deployments_as_lazy(resource_group_name, name, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_with_http_info(resource_group_name, name, instance_id, custom_headers = nil)
      list_instance_deployments_async(resource_group_name, name, instance_id, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_async(resource_group_name, name, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_async(resource_group_name, name, id, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_instance_deployment(resource_group_name, name, id, instance_id, custom_headers = nil)
      response = delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_with_http_info(resource_group_name, name, id, instance_id, custom_headers = nil)
      delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_async(resource_group_name, name, id, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_cloneable(resource_group_name, name, custom_headers = nil)
      response = is_cloneable_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_cloneable_with_http_info(resource_group_name, name, custom_headers = nil)
      is_cloneable_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_cloneable_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def list_metric_definitions(resource_group_name, name, custom_headers = nil)
      first_page = list_metric_definitions_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_with_http_info(resource_group_name, name, custom_headers = nil)
      list_metric_definitions_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_as_lazy(resource_group_name, name, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_with_http_info(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      list_metrics_async(resource_group_name, name, details, filter, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_async(resource_group_name, name, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [StorageMigrationOptions] Migration options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageMigrationResponse] operation results.
    #
    def migrate_storage(subscription_name, resource_group_name, name, options, custom_headers = nil)
      response = migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [StorageMigrationOptions] Migration options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers = nil)
      # Send request
      promise = begin_migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = StorageMigrationResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Operation] operation results.
    #
    def migrate_my_sql(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      response = migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      # Send request
      promise = begin_migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Operation.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def list_network_features(resource_group_name, name, view, custom_headers = nil)
      response = list_network_features_async(resource_group_name, name, view, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_network_features_with_http_info(resource_group_name, name, view, custom_headers = nil)
      list_network_features_async(resource_group_name, name, view, custom_headers).value!
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_network_features_async(resource_group_name, name, view, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def start_web_site_network_trace(resource_group_name, name, duration_in_seconds = nil, custom_headers = nil)
      response = start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_web_site_network_trace_with_http_info(resource_group_name, name, duration_in_seconds = nil, custom_headers = nil)
      start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds, custom_headers).value!
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_web_site_network_trace_async(resource_group_name, name, duration_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'durationInSeconds' => duration_in_seconds,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def stop_web_site_network_trace(resource_group_name, name, custom_headers = nil)
      response = stop_web_site_network_trace_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_web_site_network_trace_with_http_info(resource_group_name, name, custom_headers = nil)
      stop_web_site_network_trace_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_web_site_network_trace_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/networkTrace/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def generate_new_site_publishing_password(resource_group_name, name, custom_headers = nil)
      response = generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_with_http_info(resource_group_name, name, custom_headers = nil)
      generate_new_site_publishing_password_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_operation(resource_group_name, name, operation_id, custom_headers = nil)
      response = get_operation_async(resource_group_name, name, operation_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_operation_with_http_info(resource_group_name, name, operation_id, custom_headers = nil)
      get_operation_async(resource_group_name, name, operation_id, custom_headers).value!
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_operation_async(resource_group_name, name, operation_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/operationresults/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<PerfMonResponse>] operation results.
    #
    def list_perf_mon_counters(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = list_perf_mon_counters_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      list_perf_mon_counters_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/perfcounters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_site_php_error_log_flag(resource_group_name, name, custom_headers = nil)
      response = get_site_php_error_log_flag_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_php_error_log_flag_with_http_info(resource_group_name, name, custom_headers = nil)
      get_site_php_error_log_flag_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_php_error_log_flag_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/phplogging'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'ObjectElementType',
                    type: {
                      name: 'Object'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_premier_add_ons(resource_group_name, name, custom_headers = nil)
      response = list_premier_add_ons_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_ons_with_http_info(resource_group_name, name, custom_headers = nil)
      list_premier_add_ons_async(resource_group_name, name, custom_headers).value!
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_ons_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def add_premier_add_on(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      response = add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers).value!
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_premier_add_on_async(resource_group_name, name, premier_add_on_name, premier_add_on, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PremierAddOnRequest.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on, 'premier_add_on')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_premier_add_on(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      response = delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_premier_add_on_with_http_info(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers).value!
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_premier_add_on_async(resource_group_name, name, premier_add_on_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def list_publishing_profile_xml_with_secrets(resource_group_name, name, options, custom_headers = nil)
      response = list_publishing_profile_xml_with_secrets_async(resource_group_name, name, options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_publishing_profile_xml_with_secrets_with_http_info(resource_group_name, name, options, custom_headers = nil)
      list_publishing_profile_xml_with_secrets_async(resource_group_name, name, options, custom_headers).value!
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_publishing_profile_xml_with_secrets_async(resource_group_name, name, options, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'options is nil' if options.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  options, 'options')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def recover(resource_group_name, name, recovery_entity, custom_headers = nil)
      response = recover_async(resource_group_name, name, recovery_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_async(resource_group_name, name, recovery_entity, custom_headers = nil)
      # Send request
      promise = begin_recover_async(resource_group_name, name, recovery_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RecoverResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reset_production_slot_config(resource_group_name, name, custom_headers = nil)
      response = reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_production_slot_config_with_http_info(resource_group_name, name, custom_headers = nil)
      reset_production_slot_config_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_production_slot_config_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def restart(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_with_http_info(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_async(resource_group_name, name, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_async(resource_group_name, name, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Site>] operation results.
    #
    def list_slots(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      first_page = list_slots_as_lazy(resource_group_name, name, properties_to_include, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slots_with_http_info(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      list_slots_async(resource_group_name, name, properties_to_include, custom_headers).value!
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param properties_to_include [String] List of app properties to include in
    # the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slots_async(resource_group_name, name, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def get_slot(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      response = get_slot_async(resource_group_name, name, slot, properties_to_include, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slot_with_http_info(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      get_slot_async(resource_group_name, name, slot, properties_to_include, custom_headers).value!
    end

    #
    # Get details of a web app
    #
    # Get details of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param properties_to_include [String] Additional web app properties included
    # in the response
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slot_async(resource_group_name, name, slot, properties_to_include = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'propertiesToInclude' => properties_to_include,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def create_or_update_slot(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      # Send request
      promise = begin_create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = Site.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_slot(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      response = delete_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_slot_with_http_info(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      delete_slot_async(resource_group_name, name, slot, delete_metrics, delete_empty_server_farm, skip_dns_registration, custom_headers).value!
    end

    #
    # Deletes a web app
    #
    # Deletes a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param delete_metrics [Boolean] If true, web app metrics are also deleted
    # @param delete_empty_server_farm [Boolean] If true and App Service Plan is
    # empty after web app deletion, App Service Plan is also deleted
    # @param skip_dns_registration [Boolean] If true, DNS registration is skipped
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_slot_async(resource_group_name, name, slot, delete_metrics = nil, delete_empty_server_farm = nil, skip_dns_registration = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'deleteMetrics' => delete_metrics,'deleteEmptyServerFarm' => delete_empty_server_farm,'skipDnsRegistration' => skip_dns_registration,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CustomHostnameAnalysisResult] operation results.
    #
    def analyze_custom_hostname_slot(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      response = analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def analyze_custom_hostname_slot_with_http_info(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Analyze a custom hostname
    #
    # Analyze a custom hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Custom hostname
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def analyze_custom_hostname_slot_async(resource_group_name, name, slot, host_name = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/analyzeCustomHostname'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'hostName' => host_name,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CustomHostnameAnalysisResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def apply_slot_configuration_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def apply_slot_configuration_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # Applies the configuration settings from the target slot onto the current slot
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name. Settings from that slot will be applied on the source slot
    # @param slot [String] Name of the source slot. Settings from the target slot
    # will be applied onto this slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def apply_slot_configuration_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/applySlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def backup_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = backup_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def backup_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      backup_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Creates web app backup
    #
    # Creates web app backup
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def backup_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<BackupItem>] operation results.
    #
    def list_backups_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_backups_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_backups_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreRequest] operation results.
    #
    def discover_restore_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def discover_restore_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Discovers existing web app backups that can be restored
    #
    # Discovers existing web app backups that can be restored
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def discover_restore_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/discover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def get_backup_status_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_status_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress.
    #
    # Gets status of a web app backup that may be in progress.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_status_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def delete_backup_slot(resource_group_name, name, backup_id, slot, custom_headers = nil)
      response = delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_slot_with_http_info(resource_group_name, name, backup_id, slot, custom_headers = nil)
      delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers).value!
    end

    #
    # Deletes a backup from Azure Storage
    #
    # Deletes a backup from Azure Storage
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_slot_async(resource_group_name, name, backup_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItem] operation results.
    #
    def list_backup_status_secrets_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backup_status_secrets_slot_with_http_info(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
    end

    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # Gets status of a web app backup that may be in progress, including secrets
    # associated with the backup, such as the Azure Storage SAS URL. Also can be
    # used to update the SAS URL for the backup if a new URL is passed in the
    # request body.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backup_status_secrets_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItem.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def restore_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      # Send request
      promise = begin_restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RestoreResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_application_settings_slot(resource_group_name, name, app_settings, slot, custom_headers = nil)
      response = update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_application_settings_slot_with_http_info(resource_group_name, name, app_settings, slot, custom_headers = nil)
      update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers).value!
    end

    #
    # Updates the application settings of web app
    #
    # Updates the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param app_settings [StringDictionary] Application settings of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_application_settings_slot_async(resource_group_name, name, app_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'app_settings is nil' if app_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  app_settings, 'app_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_application_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_application_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_application_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_application_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the application settings of web app
    #
    # Gets the application settings of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_application_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/appsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def update_auth_settings_slot(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      response = update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_auth_settings_slot_with_http_info(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers).value!
    end

    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # Updates the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_auth_settings [SiteAuthSettings] Auth settings associated with
    # web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_auth_settings_slot_async(resource_group_name, name, site_auth_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_auth_settings is nil' if site_auth_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteAuthSettings.mapper()
      request_content = @client.serialize(request_mapper,  site_auth_settings, 'site_auth_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteAuthSettings] operation results.
    #
    def list_auth_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_auth_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_auth_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # Gets the Authentication / Authorization settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_auth_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/authsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteAuthSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def update_backup_configuration_slot(resource_group_name, name, request, slot, custom_headers = nil)
      response = update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_backup_configuration_slot_with_http_info(resource_group_name, name, request, slot, custom_headers = nil)
      update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers).value!
    end

    #
    # Updates backup configuration of web app
    #
    # Updates backup configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param request [BackupRequest] Information on backup request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_backup_configuration_slot_async(resource_group_name, name, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = BackupRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_backup_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_backup_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Removes the backup configuration for a web app
    #
    # Removes the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupRequest] operation results.
    #
    def get_backup_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_backup_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the backup configuration for a web app
    #
    # Gets the backup configuration for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_backup_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/backup/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupRequest.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def update_connection_strings_slot(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      response = update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_connection_strings_slot_with_http_info(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers).value!
    end

    #
    # Updates the connection strings associated with web app
    #
    # Updates the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param connection_strings [ConnectionStringDictionary] Connection strings
    # associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_connection_strings_slot_async(resource_group_name, name, connection_strings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'connection_strings is nil' if connection_strings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = ConnectionStringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  connection_strings, 'connection_strings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ConnectionStringDictionary] operation results.
    #
    def list_connection_strings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_connection_strings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the connection strings associated with web app
    #
    # Gets the connection strings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_connection_strings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/connectionstrings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ConnectionStringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def get_diagnostic_logs_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_diagnostic_logs_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app logs configuration
    #
    # Gets the web app logs configuration
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_diagnostic_logs_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteLogsConfig] operation results.
    #
    def update_diagnostic_logs_config_slot(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      response = update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_diagnostic_logs_config_slot_with_http_info(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_logs_config [SiteLogsConfig] Site logs configuration
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_diagnostic_logs_config_slot_async(resource_group_name, name, site_logs_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_logs_config is nil' if site_logs_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteLogsConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_logs_config, 'site_logs_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/logs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteLogsConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def update_metadata_slot(resource_group_name, name, metadata, slot, custom_headers = nil)
      response = update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_metadata_slot_with_http_info(resource_group_name, name, metadata, slot, custom_headers = nil)
      update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers).value!
    end

    #
    # Updates the meta data for web app
    #
    # Updates the meta data for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param metadata [StringDictionary] Meta data of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_metadata_slot_async(resource_group_name, name, metadata, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'metadata is nil' if metadata.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StringDictionary.mapper()
      request_content = @client.serialize(request_mapper,  metadata, 'metadata')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StringDictionary] operation results.
    #
    def list_metadata_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metadata_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_metadata_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app meta data.
    #
    # Gets the web app meta data.
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metadata_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/metadata/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StringDictionary.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def list_publishing_credentials_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers = nil)
      # Send request
      promise = begin_list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = User.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def update_site_push_settings_slot(resource_group_name, name, push_settings, slot, custom_headers = nil)
      response = update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_site_push_settings_slot_with_http_info(resource_group_name, name, push_settings, slot, custom_headers = nil)
      update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers).value!
    end

    #
    # Updates the Push settings associated with web app
    #
    # Updates the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param push_settings [PushSettings] Push settings associated with web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_site_push_settings_slot_async(resource_group_name, name, push_settings, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'push_settings is nil' if push_settings.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PushSettings.mapper()
      request_content = @client.serialize(request_mapper,  push_settings, 'push_settings')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PushSettings] operation results.
    #
    def list_site_push_settings_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_site_push_settings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the Push settings associated with web app
    #
    # Gets the Push settings associated with web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_site_push_settings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/pushsettings/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PushSettings.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def get_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the configuration of the web app
    #
    # Gets the configuration of the web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def create_or_update_configuration_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_configuration_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteConfig] operation results.
    #
    def update_configuration_slot(resource_group_name, name, site_config, slot, custom_headers = nil)
      response = update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_configuration_slot_with_http_info(resource_group_name, name, site_config, slot, custom_headers = nil)
      update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers).value!
    end

    #
    # Update the configuration of web app
    #
    # Update the configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_config [SiteConfig] Request body that contains the configuraiton
    # setting for the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_configuration_slot_async(resource_group_name, name, site_config, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_config is nil' if site_config.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteConfig.mapper()
      request_content = @client.serialize(request_mapper,  site_config, 'site_config')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteConfig.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_deployments_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_deployments_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_deployments_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_deployment_slot(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      response = create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_deployment_slot_with_http_info(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_deployment_slot_async(resource_group_name, name, id, slot, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_deployment_slot(resource_group_name, name, id, slot, custom_headers = nil)
      response = delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_deployment_slot_with_http_info(resource_group_name, name, id, slot, custom_headers = nil)
      delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_deployment_slot_async(resource_group_name, name, id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<HostNameBinding>] operation results.
    #
    def list_host_name_bindings_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_host_name_bindings_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def get_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Get web app binding for a hostname
    #
    # Get web app binding for a hostname
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBinding] operation results.
    #
    def create_or_update_host_name_binding_slot(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      response = create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_host_name_binding_slot_with_http_info(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers).value!
    end

    #
    # Creates a web app hostname binding
    #
    # Creates a web app hostname binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param host_name [String] Name of host
    # @param host_name_binding [HostNameBinding] Host name binding information
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_host_name_binding_slot_async(resource_group_name, name, host_name, host_name_binding, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, 'host_name_binding is nil' if host_name_binding.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HostNameBinding.mapper()
      request_content = @client.serialize(request_mapper,  host_name_binding, 'host_name_binding')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'hostName' => host_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBinding.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_host_name_binding_slot(resource_group_name, name, slot, host_name, custom_headers = nil)
      response = delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_host_name_binding_slot_with_http_info(resource_group_name, name, slot, host_name, custom_headers = nil)
      delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers).value!
    end

    #
    # Deletes a host name binding
    #
    # Deletes a host name binding
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param host_name [String] Name of host
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_host_name_binding_slot_async(resource_group_name, name, slot, host_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'host_name is nil' if host_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hostNameBindings/{hostName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'hostName' => host_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def get_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # Retrieves a specific Service Bus Hybrid Connection used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def create_or_update_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Removes a Hybrid Connection from this site.
    #
    # Removes a Hybrid Connection from this site.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def update_hybrid_connection_slot(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      response = update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_hybrid_connection_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # Creates a new Hybrid Connection using a Service Bus relay
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param connection_envelope [HybridConnection] The details of the hybrid
    # connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_hybrid_connection_slot_async(resource_group_name, name, namespace_name, relay_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = HybridConnection.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_hybrid_connection_keys_slot(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      response = list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connection_keys_slot_with_http_info(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers).value!
    end

    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # Gets the send key name and value for a Hybrid Connection
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param namespace_name [String] The namespace for this hybrid connection
    # @param relay_name [String] The relay name for this hybrid connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connection_keys_slot_async(resource_group_name, name, namespace_name, relay_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'relay_name is nil' if relay_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionNamespaces/{namespaceName}/relays/{relayName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'namespaceName' => namespace_name,'relayName' => relay_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HybridConnection] operation results.
    #
    def list_hybrid_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_hybrid_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # Retrieves all Service Bus Hybrid Connections used by this Web App.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_hybrid_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridConnectionRelays'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HybridConnection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def list_relay_service_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_relay_service_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # Retrieves all Biztalk Hybrid Connections associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_relay_service_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def get_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # Retrieves a Biztalk Hybrid Connection identified by its entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def create_or_update_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_relay_service_connection_slot(resource_group_name, name, entity_name, slot, custom_headers = nil)
      response = delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, slot, custom_headers = nil)
      delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers).value!
    end

    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # Removes the association to a Biztalk Hybrid Connection, identified by its
    # entity name.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_relay_service_connection_slot_async(resource_group_name, name, entity_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RelayServiceConnectionEntity] operation results.
    #
    def update_relay_service_connection_slot(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      response = update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_relay_service_connection_slot_with_http_info(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # Creates a new association to a Biztalk Hybrid Connection, or updates an
    # existing one.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param entity_name [String] The name by which the Hybrid Connection is
    # identified
    # @param connection_envelope [RelayServiceConnectionEntity] The details of the
    # Hybrid Connection
    # @param slot [String] The name of the slot for the web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_relay_service_connection_slot_async(resource_group_name, name, entity_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'entity_name is nil' if entity_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RelayServiceConnectionEntity.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/hybridconnection/{entityName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'entityName' => entity_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RelayServiceConnectionEntity.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SiteInstance>] operation results.
    #
    def list_instance_identifiers_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_instance_identifiers_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Deployment>] operation results.
    #
    def list_instance_deployments_slot(resource_group_name, name, slot, instance_id, custom_headers = nil)
      first_page = list_instance_deployments_slot_as_lazy(resource_group_name, name, slot, instance_id, custom_headers)
      first_page.get_all_items
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_slot_with_http_info(resource_group_name, name, slot, instance_id, custom_headers = nil)
      list_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_slot_async(resource_group_name, name, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def get_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Get the deployment
    #
    # Get the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Deployment] operation results.
    #
    def create_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      response = create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers).value!
    end

    #
    # Create a deployment
    #
    # Create a deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param deployment [Deployment] Details of deployment
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, deployment, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, 'deployment is nil' if deployment.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Deployment.mapper()
      request_content = @client.serialize(request_mapper,  deployment, 'deployment')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Deployment.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_instance_deployment_slot(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      response = delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_instance_deployment_slot_with_http_info(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers).value!
    end

    #
    # Delete the deployment
    #
    # Delete the deployment
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param id [String] Id of the deployment
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param instance_id [String] Id of web app instance
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_instance_deployment_slot_async(resource_group_name, name, id, slot, instance_id, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'id is nil' if id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, 'instance_id is nil' if instance_id.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/instances/{instanceId}/deployments/{id}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'id' => id,'slot' => slot,'instanceId' => instance_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteCloneability] operation results.
    #
    def is_cloneable_slot(resource_group_name, name, slot, custom_headers = nil)
      response = is_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def is_cloneable_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      is_cloneable_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def is_cloneable_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/iscloneable'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteCloneability.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<MetricDefinition>] operation results.
    #
    def list_metric_definitions_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_metric_definitions_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metricdefinitions'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<ResourceMetric>] operation results.
    #
    def list_metrics_slot(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      first_page = list_metrics_slot_as_lazy(resource_group_name, name, slot, details, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_slot_with_http_info(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      list_metrics_slot_async(resource_group_name, name, slot, details, filter, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param details [Boolean] If true, metric details are included in response
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_slot_async(resource_group_name, name, slot, details = nil, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/metrics'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'details' => details,'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NetworkFeatures] operation results.
    #
    def list_network_features_slot(resource_group_name, name, view, slot, custom_headers = nil)
      response = list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_network_features_slot_with_http_info(resource_group_name, name, view, slot, custom_headers = nil)
      list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers).value!
    end

    #
    # Retrieves a view of all network features in use on this web app.
    #
    # Retrieves a view of all network features in use on this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param view [String] The type of view. This can either be "summary" or
    # "detailed".
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_network_features_slot_async(resource_group_name, name, view, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'view is nil' if view.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkFeatures/{view}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'view' => view,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = NetworkFeatures.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def start_web_site_network_trace_slot(resource_group_name, name, slot, duration_in_seconds = nil, custom_headers = nil)
      response = start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_web_site_network_trace_slot_with_http_info(resource_group_name, name, slot, duration_in_seconds = nil, custom_headers = nil)
      start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds, custom_headers).value!
    end

    #
    # Start capturing network packets for the site
    #
    # Start capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param duration_in_seconds [Integer] The duration to keep capturing in
    # seconds
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_web_site_network_trace_slot_async(resource_group_name, name, slot, duration_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'durationInSeconds' => duration_in_seconds,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [String] operation results.
    #
    def stop_web_site_network_trace_slot(resource_group_name, name, slot, custom_headers = nil)
      response = stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_web_site_network_trace_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Stop ongoing capturing network packets for the site
    #
    # Stop ongoing capturing network packets for the site
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_web_site_network_trace_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/networkTrace/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'String'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def generate_new_site_publishing_password_slot(resource_group_name, name, slot, custom_headers = nil)
      response = generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def generate_new_site_publishing_password_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Generates new random app publishing password
    #
    # Generates new random app publishing password
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def generate_new_site_publishing_password_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/newpassword'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_operation_slot(resource_group_name, name, operation_id, slot, custom_headers = nil)
      response = get_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_operation_slot_with_http_info(resource_group_name, name, operation_id, slot, custom_headers = nil)
      get_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers).value!
    end

    #
    # Gets the operation for a web app
    #
    # Gets the operation for a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param operation_id [String] Id of an operation
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_operation_slot_async(resource_group_name, name, operation_id, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'operation_id is nil' if operation_id.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/operationresults/{operationId}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'operationId' => operation_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<PerfMonResponse>] operation results.
    #
    def list_perf_mon_counters_slot(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      first_page = list_perf_mon_counters_slot_as_lazy(resource_group_name, name, slot, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_slot_with_http_info(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      list_perf_mon_counters_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot. **** CURRENTLY UNUSED *****
    # @param filter [String] Return only usages/metrics specified in the filter.
    # Filter conforms to odata syntax. Example: $filter=(startTime eq
    # '2014-01-01T00:00:00Z' and endTime eq '2014-12-31T23:59:59Z' and timeGrain eq
    # duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_slot_async(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/perfcounters'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def get_site_php_error_log_flag_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_site_php_error_log_flag_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets sites's event logs
    #
    # Gets sites's event logs
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_site_php_error_log_flag_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/phplogging'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'ObjectElementType',
                    type: {
                      name: 'Object'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def list_premier_add_ons_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_premier_add_ons_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # List premier add ons for web app
    #
    # List premier add ons for web app
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param slot [String] web app slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_premier_add_ons_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # Gets a specific premier add on
    #
    # Gets a specific premier add on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def add_premier_add_on_slot(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      response = add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers).value!
    end

    #
    # Add premier add-on
    #
    # Add premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param premier_add_on [PremierAddOnRequest] Premier add on request
    # @param slot [String] web app slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, premier_add_on, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'premier_add_on is nil' if premier_add_on.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = PremierAddOnRequest.mapper()
      request_content = @client.serialize(request_mapper,  premier_add_on, 'premier_add_on')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_premier_add_on_slot(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      response = delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_premier_add_on_slot_with_http_info(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers).value!
    end

    #
    # Delete premier add-on
    #
    # Delete premier add-on
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] web app name
    # @param premier_add_on_name [String] Premier add on
    # @param slot [String] web app slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_premier_add_on_slot_async(resource_group_name, name, premier_add_on_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'premier_add_on_name is nil' if premier_add_on_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/premieraddons/{premierAddOnName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'premierAddOnName' => premier_add_on_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NOT_IMPLEMENTED] operation results.
    #
    def list_publishing_profile_xml_with_secrets_slot(resource_group_name, name, options, slot, custom_headers = nil)
      response = list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, options, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_publishing_profile_xml_with_secrets_slot_with_http_info(resource_group_name, name, options, slot, custom_headers = nil)
      list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, options, slot, custom_headers).value!
    end

    #
    # Gets the publishing profile for web app
    #
    # Gets the publishing profile for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [CsmPublishingProfileOptions] Specifies options for publishing
    # profile. Pass CsmPublishingProfileOptions.Format=FileZilla3 for FileZilla FTP
    # format.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_publishing_profile_xml_with_secrets_slot_async(resource_group_name, name, options, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'options is nil' if options.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmPublishingProfileOptions.mapper()
      request_content = @client.serialize(request_mapper,  options, 'options')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/publishxml'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Stream'
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def recover_slot(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      response = recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = RecoverResponse.mapper()
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def reset_slot_configuration_slot(resource_group_name, name, slot, custom_headers = nil)
      response = reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def reset_slot_configuration_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # Resets the configuration settings of the current slot if they were previously
    # modified by calling ApplySlotConfig API
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def reset_slot_configuration_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/resetSlotConfig'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def restart_slot(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      response = restart_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def restart_slot_with_http_info(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      restart_slot_async(resource_group_name, name, slot, soft_restart, synchronous, custom_headers).value!
    end

    #
    # Restarts web app
    #
    # Restarts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param soft_restart [Boolean] Soft restart applies the configuration settings
    # and restarts the app if necessary. Hard restart always restarts and
    # reprovisions the app
    # @param synchronous [Boolean] If true then the API will block until the app
    # has been restarted
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def restart_slot_async(resource_group_name, name, slot, soft_restart = nil, synchronous = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/restart'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'softRestart' => soft_restart,'synchronous' => synchronous,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def get_slots_differences_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      first_page = get_slots_differences_slot_as_lazy(resource_group_name, name, slot_swap_entity, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of the source slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      get_slots_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of the source slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def swap_slots_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      # Send request
      promise = begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Snapshot>] operation results.
    #
    def list_snapshots_slot(resource_group_name, name, slot, custom_headers = nil)
      first_page = list_snapshots_slot_as_lazy(resource_group_name, name, slot, custom_headers)
      first_page.get_all_items
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_snapshots_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_snapshots_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param slot [String] Website Slot
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_snapshots_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SnapshotCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = get_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      get_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_source_control_slot(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      response = create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_source_control_slot_with_http_info(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_source_control_slot(resource_group_name, name, slot, custom_headers = nil)
      response = delete_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_source_control_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      delete_source_control_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_source_control_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def update_source_control_slot(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      response = update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_source_control_slot_with_http_info(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_source_control_slot_async(resource_group_name, name, site_source_control, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def start_slot(resource_group_name, name, slot, custom_headers = nil)
      response = start_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      start_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def stop_slot(resource_group_name, name, slot, custom_headers = nil)
      response = stop_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      stop_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def sync_repository_slot(resource_group_name, name, slot, custom_headers = nil)
      response = sync_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_repository_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      sync_repository_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_repository_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def list_usages_slot(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      first_page = list_usages_slot_as_lazy(resource_group_name, name, slot, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_slot_with_http_info(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      list_usages_slot_async(resource_group_name, name, slot, filter, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_slot_async(resource_group_name, name, slot, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_vnet_connections_slot(resource_group_name, name, slot, custom_headers = nil)
      response = list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vnet_connections_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vnet_connections_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_connection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_vnet_connection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_vnet_connection_slot(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      response = delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers).value!
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_connection_slot_async(resource_group_name, name, vnet_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_vnet_connection_slot(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      response = update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_slot_with_http_info(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_slot_async(resource_group_name, name, vnet_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      response = get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers).value!
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_vnet_connection_gateway_slot(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      response = update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_gateway_slot_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param slot [String] The name of the slot for this web app.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_gateway_slot_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SlotDifference>] operation results.
    #
    def get_slots_differences_from_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      first_page = get_slots_differences_from_production_as_lazy(resource_group_name, name, slot_swap_entity, custom_headers)
      first_page.get_all_items
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_from_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      get_slots_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_from_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsdiffs'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def swap_slot_with_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      # Send request
      promise = begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
          result_mapper = {
            required: false,
            serialized_name: 'parsed_response',
            type: {
              name: 'Object'
            }
          }
          parsed_response = @client.deserialize(result_mapper, parsed_response, 'parsed_response')
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<Snapshot>] operation results.
    #
    def list_snapshots(resource_group_name, name, custom_headers = nil)
      first_page = list_snapshots_as_lazy(resource_group_name, name, custom_headers)
      first_page.get_all_items
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_snapshots_with_http_info(resource_group_name, name, custom_headers = nil)
      list_snapshots_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param resource_group_name [String] Resource group
    # @param name [String] Website Name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_snapshots_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/snapshots'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SnapshotCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def get_source_control(resource_group_name, name, custom_headers = nil)
      response = get_source_control_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      get_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Get the source control configuration of web app
    #
    # Get the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def create_or_update_source_control(resource_group_name, name, site_source_control, custom_headers = nil)
      response = create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_source_control_with_http_info(resource_group_name, name, site_source_control, custom_headers = nil)
      create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_source_control_async(resource_group_name, name, site_source_control, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 201
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_source_control(resource_group_name, name, custom_headers = nil)
      response = delete_source_control_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_source_control_with_http_info(resource_group_name, name, custom_headers = nil)
      delete_source_control_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Delete source control configuration of web app
    #
    # Delete source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_source_control_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteSourceControl] operation results.
    #
    def update_source_control(resource_group_name, name, site_source_control, custom_headers = nil)
      response = update_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_source_control_with_http_info(resource_group_name, name, site_source_control, custom_headers = nil)
      update_source_control_async(resource_group_name, name, site_source_control, custom_headers).value!
    end

    #
    # Update the source control configuration of web app
    #
    # Update the source control configuration of web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param site_source_control [SiteSourceControl] Request body that contains the
    # source control parameters
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_source_control_async(resource_group_name, name, site_source_control, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_source_control is nil' if site_source_control.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = SiteSourceControl.mapper()
      request_content = @client.serialize(request_mapper,  site_source_control, 'site_source_control')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sourcecontrols/web'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteSourceControl.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def start(resource_group_name, name, custom_headers = nil)
      response = start_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def start_with_http_info(resource_group_name, name, custom_headers = nil)
      start_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Starts web app
    #
    # Starts web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def start_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/start'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def stop(resource_group_name, name, custom_headers = nil)
      response = stop_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def stop_with_http_info(resource_group_name, name, custom_headers = nil)
      stop_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Stops web app
    #
    # Stops web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def stop_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/stop'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def sync_repository(resource_group_name, name, custom_headers = nil)
      response = sync_repository_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def sync_repository_with_http_info(resource_group_name, name, custom_headers = nil)
      sync_repository_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Sync web app repository
    #
    # Sync web app repository
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def sync_repository_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/sync'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<CsmUsageQuota>] operation results.
    #
    def list_usages(resource_group_name, name, filter = nil, custom_headers = nil)
      first_page = list_usages_as_lazy(resource_group_name, name, filter, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_usages_with_http_info(resource_group_name, name, filter = nil, custom_headers = nil)
      list_usages_async(resource_group_name, name, filter, custom_headers).value!
    end

    #
    # Gets the quota usage numbers for web app
    #
    # Gets the quota usage numbers for web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param filter [String] Return only usages specified in the filter. Filter is
    # specified by using OData syntax. Example: $filter=(name.value eq 'Metric1' or
    # name.value eq 'Metric2') and startTime eq '2014-01-01T00:00:00Z' and endTime
    # eq '2014-12-31T23:59:59Z' and timeGrain eq duration'[Hour|Minute|Day]'.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_usages_async(resource_group_name, name, filter = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/usages'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = CsmUsageQuotaCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array] operation results.
    #
    def list_vnet_connections(resource_group_name, name, custom_headers = nil)
      response = list_vnet_connections_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_vnet_connections_with_http_info(resource_group_name, name, custom_headers = nil)
      list_vnet_connections_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # Retrieves a list of all Virtual Network Connections associated with this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_vnet_connections_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = {
              required: false,
              serialized_name: 'parsed_response',
              type: {
                name: 'Sequence',
                element: {
                    required: false,
                    serialized_name: 'VnetInfoElementType',
                    type: {
                      name: 'Composite',
                      class_name: 'VnetInfo'
                    }
                }
              }
            }
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def get_vnet_connection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # Retrieves a specific Virtual Network Connection associated with this web app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def create_or_update_vnet_connection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def delete_vnet_connection(resource_group_name, name, vnet_name, custom_headers = nil)
      response = delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_vnet_connection_with_http_info(resource_group_name, name, vnet_name, custom_headers = nil)
      delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers).value!
    end

    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # Removes the specified Virtual Network Connection association from this web
    # app.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_vnet_connection_async(resource_group_name, name, vnet_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetInfo] operation results.
    #
    def update_vnet_connection(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      response = update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_with_http_info(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers).value!
    end

    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # Adds a Virtual Network Connection or updates it's properties.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param connection_envelope [VnetInfo] The properties of this Virtual Network
    # Connection
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_async(resource_group_name, name, vnet_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetInfo.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def get_vnet_connection_gateway(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      response = get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_vnet_connection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers).value!
    end

    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # Retrieves a Virtual Network connection gateway associated with this web app
    # and virtual network.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 404
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def create_or_update_vnet_connection_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = create_or_update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_vnet_connection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      create_or_update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [VnetGateway] operation results.
    #
    def update_vnet_connection_gateway(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      response = update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_vnet_connection_gateway_with_http_info(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers).value!
    end

    #
    # Updates the Virtual Network Gateway.
    #
    # Updates the Virtual Network Gateway.
    #
    # @param resource_group_name [String] The resource group name
    # @param name [String] The name of the web app
    # @param vnet_name [String] The name of the Virtual Network
    # @param gateway_name [String] The name of the gateway. The only gateway that
    # exists presently is "primary"
    # @param connection_envelope [VnetGateway] The properties to update this
    # gateway with.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_vnet_connection_gateway_async(resource_group_name, name, vnet_name, gateway_name, connection_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'vnet_name is nil' if vnet_name.nil?
      fail ArgumentError, 'gateway_name is nil' if gateway_name.nil?
      fail ArgumentError, 'connection_envelope is nil' if connection_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = VnetGateway.mapper()
      request_content = @client.serialize(request_mapper,  connection_envelope, 'connection_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/virtualNetworkConnections/{vnetName}/gateways/{gatewayName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'vnetName' => vnet_name,'gatewayName' => gateway_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = VnetGateway.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_create_or_update(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = begin_create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_with_http_info(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      begin_create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_async(resource_group_name, name, site_envelope, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_envelope is nil' if site_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Site.mapper()
      request_content = @client.serialize(request_mapper,  site_envelope, 'site_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'skipDnsRegistration' => skip_dns_registration,'skipCustomDomainVerification' => skip_custom_domain_verification,'forceDnsRegistration' => force_dns_registration,'ttlInSeconds' => ttl_in_seconds,'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def begin_restore(resource_group_name, name, backup_id, request, custom_headers = nil)
      response = begin_restore_async(resource_group_name, name, backup_id, request, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restore_with_http_info(resource_group_name, name, backup_id, request, custom_headers = nil)
      begin_restore_async(resource_group_name, name, backup_id, request, custom_headers).value!
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restore_async(resource_group_name, name, backup_id, request, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/backups/{backupId}/restore'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def begin_list_publishing_credentials(resource_group_name, name, custom_headers = nil)
      response = begin_list_publishing_credentials_async(resource_group_name, name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_publishing_credentials_with_http_info(resource_group_name, name, custom_headers = nil)
      begin_list_publishing_credentials_async(resource_group_name, name, custom_headers).value!
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_publishing_credentials_async(resource_group_name, name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/config/publishingcredentials/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = User.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [StorageMigrationOptions] Migration options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageMigrationResponse] operation results.
    #
    def begin_migrate_storage(subscription_name, resource_group_name, name, options, custom_headers = nil)
      response = begin_migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [StorageMigrationOptions] Migration options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_migrate_storage_with_http_info(subscription_name, resource_group_name, name, options, custom_headers = nil)
      begin_migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers).value!
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param subscription_name [String] Azure subscription
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param options [StorageMigrationOptions] Migration options
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_migrate_storage_async(subscription_name, resource_group_name, name, options, custom_headers = nil)
      fail ArgumentError, 'subscription_name is nil' if subscription_name.nil?
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'options is nil' if options.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = StorageMigrationOptions.mapper()
      request_content = @client.serialize(request_mapper,  options, 'options')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migrate'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'subscriptionName' => subscription_name,'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = StorageMigrationResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Operation] operation results.
    #
    def begin_migrate_my_sql(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      response = begin_migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_migrate_my_sql_with_http_info(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      begin_migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers).value!
    end

    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # Migrates a local (in-app) MySql database to a remote MySql database
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param migration_request_envelope [MigrateMySqlRequest] MySql migration
    # options
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_migrate_my_sql_async(resource_group_name, name, migration_request_envelope, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'migration_request_envelope is nil' if migration_request_envelope.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = MigrateMySqlRequest.mapper()
      request_content = @client.serialize(request_mapper,  migration_request_envelope, 'migration_request_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/migratemysql'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Operation.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def begin_recover(resource_group_name, name, recovery_entity, custom_headers = nil)
      response = begin_recover_async(resource_group_name, name, recovery_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_recover_with_http_info(resource_group_name, name, recovery_entity, custom_headers = nil)
      begin_recover_async(resource_group_name, name, recovery_entity, custom_headers).value!
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_recover_async(resource_group_name, name, recovery_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'recovery_entity is nil' if recovery_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSiteRecoveryEntity.mapper()
      request_content = @client.serialize(request_mapper,  recovery_entity, 'recovery_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecoverResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Site] operation results.
    #
    def begin_create_or_update_slot(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      response = begin_create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_create_or_update_slot_with_http_info(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      begin_create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration, skip_custom_domain_verification, force_dns_registration, ttl_in_seconds, custom_headers).value!
    end

    #
    # Creates a new web app or modifies an existing web app.
    #
    # Creates a new web app or modifies an existing web app.
    #
    # @param resource_group_name [String] Name of the resource group
    # @param name [String] Name of the web app
    # @param site_envelope [Site] Details of web app if it exists already
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param skip_dns_registration [Boolean] If true web app hostname is not
    # registered with DNS on creation. This parameter is
    # only used for app creation
    # @param skip_custom_domain_verification [Boolean] If true, custom (non
    # *.azurewebsites.net) domains associated with web app are not verified.
    # @param force_dns_registration [Boolean] If true, web app hostname is force
    # registered with DNS
    # @param ttl_in_seconds [String] Time to live in seconds for web app's default
    # domain name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_create_or_update_slot_async(resource_group_name, name, site_envelope, slot, skip_dns_registration = nil, skip_custom_domain_verification = nil, force_dns_registration = nil, ttl_in_seconds = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'site_envelope is nil' if site_envelope.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Site.mapper()
      request_content = @client.serialize(request_mapper,  site_envelope, 'site_envelope')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'skipDnsRegistration' => skip_dns_registration,'skipCustomDomainVerification' => skip_custom_domain_verification,'forceDnsRegistration' => force_dns_registration,'ttlInSeconds' => ttl_in_seconds,'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 202
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Site.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RestoreResponse] operation results.
    #
    def begin_restore_slot(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      response = begin_restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_restore_slot_with_http_info(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      begin_restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers).value!
    end

    #
    # Restores a web app
    #
    # Restores a web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param backup_id [String] Id of backup to restore
    # @param request [RestoreRequest] Information on restore request
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_restore_slot_async(resource_group_name, name, backup_id, request, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'backup_id is nil' if backup_id.nil?
      fail ArgumentError, 'request is nil' if request.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = RestoreRequest.mapper()
      request_content = @client.serialize(request_mapper,  request, 'request')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/backups/{backupId}/restore'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'backupId' => backup_id,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RestoreResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [User] operation results.
    #
    def begin_list_publishing_credentials_slot(resource_group_name, name, slot, custom_headers = nil)
      response = begin_list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_list_publishing_credentials_slot_with_http_info(resource_group_name, name, slot, custom_headers = nil)
      begin_list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers).value!
    end

    #
    # Gets the web app publishing credentials
    #
    # Gets the web app publishing credentials
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_list_publishing_credentials_slot_async(resource_group_name, name, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/config/publishingcredentials/list'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = User.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [RecoverResponse] operation results.
    #
    def begin_recover_slot(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      response = begin_recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_recover_slot_with_http_info(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      begin_recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers).value!
    end

    #
    # Recovers a deleted web app
    #
    # Recovers a deleted web app
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param recovery_entity [CsmSiteRecoveryEntity] Snapshot data used for web app
    # recovery. Snapshot information can be obtained by calling GetDeletedSites or
    # GetSiteSnapshots API.
    # @param slot [String] Name of web app slot. If not specified then will default
    # to production slot.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_recover_slot_async(resource_group_name, name, recovery_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'recovery_entity is nil' if recovery_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSiteRecoveryEntity.mapper()
      request_content = @client.serialize(request_mapper,  recovery_entity, 'recovery_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/recover'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = RecoverResponse.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_swap_slots_slot(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      response = begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of source slot for the swap
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_swap_slots_slot_with_http_info(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers).value!
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param slot [String] Name of source slot for the swap
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_swap_slots_slot_async(resource_group_name, name, slot_swap_entity, slot, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, 'slot is nil' if slot.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slots/{slot}/slotsswap'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'slot' => slot,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Object] operation results.
    #
    def begin_swap_slot_with_production(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      response = begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_swap_slot_with_production_with_http_info(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers).value!
    end

    #
    # Swaps web app slots
    #
    # Swaps web app slots
    #
    # @param resource_group_name [String] Name of resource group
    # @param name [String] Name of web app
    # @param slot_swap_entity [CsmSlotEntity] Request body that contains the target
    # slot name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_swap_slot_with_production_async(resource_group_name, name, slot_swap_entity, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'name is nil' if name.nil?
      fail ArgumentError, 'slot_swap_entity is nil' if slot_swap_entity.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?
      api_version = '2016-08-01'


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = CsmSlotEntity.mapper()
      request_content = @client.serialize(request_mapper,  slot_swap_entity, 'slot_swap_entity')
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{name}/slotsswap'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'name' => name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all Web Apps for a subscription
    #
    # Gets all Web Apps for a subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeletedWebAppCollection] operation results.
    #
    def list_deleted_next(next_page_link, custom_headers = nil)
      response = list_deleted_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deleted_next_with_http_info(next_page_link, custom_headers = nil)
      list_deleted_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets deleted web apps in subscription
    #
    # Gets deleted web apps in subscription
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deleted_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeletedWebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def list_by_resource_group_next(next_page_link, custom_headers = nil)
      response = list_by_resource_group_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_resource_group_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_resource_group_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # Gets the web apps for a subscription in the specified resource group
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_resource_group_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] operation results.
    #
    def list_backups_next(next_page_link, custom_headers = nil)
      response = list_backups_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_next_with_http_info(next_page_link, custom_headers = nil)
      list_backups_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def list_deployments_next(next_page_link, custom_headers = nil)
      response = list_deployments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_next_with_http_info(next_page_link, custom_headers = nil)
      list_deployments_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] operation results.
    #
    def list_host_name_bindings_next(next_page_link, custom_headers = nil)
      response = list_host_name_bindings_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_next_with_http_info(next_page_link, custom_headers = nil)
      list_host_name_bindings_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] operation results.
    #
    def list_instance_identifiers_next(next_page_link, custom_headers = nil)
      response = list_instance_identifiers_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_next_with_http_info(next_page_link, custom_headers = nil)
      list_instance_identifiers_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def list_instance_deployments_next(next_page_link, custom_headers = nil)
      response = list_instance_deployments_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_next_with_http_info(next_page_link, custom_headers = nil)
      list_instance_deployments_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def list_metric_definitions_next(next_page_link, custom_headers = nil)
      response = list_metric_definitions_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_next_with_http_info(next_page_link, custom_headers = nil)
      list_metric_definitions_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_metrics_next(next_page_link, custom_headers = nil)
      response = list_metrics_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_next_with_http_info(next_page_link, custom_headers = nil)
      list_metrics_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PerfMonCounterCollection] operation results.
    #
    def list_perf_mon_counters_next(next_page_link, custom_headers = nil)
      response = list_perf_mon_counters_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_next_with_http_info(next_page_link, custom_headers = nil)
      list_perf_mon_counters_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [WebAppCollection] operation results.
    #
    def list_slots_next(next_page_link, custom_headers = nil)
      response = list_slots_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_slots_next_with_http_info(next_page_link, custom_headers = nil)
      list_slots_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all the slots for a web apps
    #
    # Gets all the slots for a web apps
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_slots_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = WebAppCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [BackupItemCollection] operation results.
    #
    def list_backups_slot_next(next_page_link, custom_headers = nil)
      response = list_backups_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_backups_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_backups_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all available backups for web app
    #
    # Lists all available backups for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_backups_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = BackupItemCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def list_deployments_slot_next(next_page_link, custom_headers = nil)
      response = list_deployments_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_deployments_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_deployments_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_deployments_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [HostNameBindingCollection] operation results.
    #
    def list_host_name_bindings_slot_next(next_page_link, custom_headers = nil)
      response = list_host_name_bindings_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_host_name_bindings_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_host_name_bindings_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get web app hostname bindings
    #
    # Get web app hostname bindings
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_host_name_bindings_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = HostNameBindingCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SiteInstanceCollection] operation results.
    #
    def list_instance_identifiers_slot_next(next_page_link, custom_headers = nil)
      response = list_instance_identifiers_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_identifiers_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_instance_identifiers_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets all instance of a web app
    #
    # Gets all instance of a web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_identifiers_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SiteInstanceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DeploymentCollection] operation results.
    #
    def list_instance_deployments_slot_next(next_page_link, custom_headers = nil)
      response = list_instance_deployments_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_instance_deployments_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_instance_deployments_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # List deployments
    #
    # List deployments
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_instance_deployments_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = DeploymentCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MetricDefinitionCollection] operation results.
    #
    def list_metric_definitions_slot_next(next_page_link, custom_headers = nil)
      response = list_metric_definitions_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metric_definitions_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_metric_definitions_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metric definitions for web app
    #
    # Gets metric definitions for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metric_definitions_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = MetricDefinitionCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceMetricCollection] operation results.
    #
    def list_metrics_slot_next(next_page_link, custom_headers = nil)
      response = list_metrics_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_metrics_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_metrics_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets metrics for web app
    #
    # Gets metrics for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_metrics_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = ResourceMetricCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [PerfMonCounterCollection] operation results.
    #
    def list_perf_mon_counters_slot_next(next_page_link, custom_headers = nil)
      response = list_perf_mon_counters_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_perf_mon_counters_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_perf_mon_counters_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets perfmon counters for web app
    #
    # Gets perfmon counters for web app
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_perf_mon_counters_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = PerfMonCounterCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SlotDifferenceCollection] operation results.
    #
    def get_slots_differences_slot_next(next_page_link, custom_headers = nil)
      response = get_slots_differences_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_slots_differences_slot_next_with_http_info(next_page_link, custom_headers = nil)
      get_slots_differences_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Get the difference in configuration settings between two web app slots
    #
    # Get the difference in configuration settings between two web app slots
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_slots_differences_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = SlotDifferenceCollection.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response, 'result.body')
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SnapshotCollection] operation results.
    #
    def list_snapshots_slot_next(next_page_link, custom_headers = nil)
      response = list_snapshots_slot_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_snapshots_slot_next_with_http_info(next_page_link, custom_headers = nil)
      list_snapshots_slot_next_async(next_page_link, custom_headers).value!
    end

    #
    # Returns all Snapshots to the user.
    #
    # Returns all Snapshots to the user.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_snapshots_slot_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        en