# frozen_string_literal: true
require 'ffi-glib/container_class_methods'
require 'ffi-glib/array_methods'

GLib.load_class :PtrArray

module GLib
  # Overrides for GPtrArray, GLib's automatically growing array of
  # pointers.
  class PtrArray
    include Enumerable
    include ArrayMethods
    extend ContainerClassMethods

    attr_reader :element_type

    POINTER_SIZE = FFI.type_size(:pointer)

    class << self
      # Remove stub generated by builder.
      remove_method :add if method_defined? :add
    end

    def initialize(type)
      @element_type = type
      store_pointer Lib.g_ptr_array_new
    end

    def self.from_enumerable(type, it)
      new(type).tap { |arr| arr.add_array it }
    end

    def self.add(array, data)
      array.add data
    end

    def reset_typespec(typespec)
      @element_type = typespec
      self
    end

    def add(data)
      ptr = GirFFI::InPointer.from element_type, data
      Lib.g_ptr_array_add self, ptr
    end

    def add_array(ary)
      ary.each { |item| add item }
    end

    def data_ptr
      @struct[:pdata]
    end

    def element_size
      POINTER_SIZE
    end

    def each
      length.times do |idx|
        yield index(idx)
      end
    end

    def length
      @struct[:len]
    end

    def ==(other)
      to_a == other.to_a
    end
  end
end
