#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# SàT plugin for managing raw XML log
# Copyright (C) 2011  Jérôme Poisson (goffi@goffi.org)

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from sat.core.i18n import _
from sat.core.log import getLogger
log = getLogger(__name__)
from twisted.words.protocols.jabber.xmlstream import XmlStream
from twisted.words.xish import domish

PLUGIN_INFO = {
    "name": "Raw XML log Plugin",
    "import_name": "XmlLog",
    "type": "Misc",
    "protocols": [],
    "dependencies": [],
    "main": "XmlLog",
    "handler": "no",
    "description": _("""Send raw XML logs to bridge""")
}


class LoggingXmlStream(XmlStream):
    """This class send the raw XML to the Bridge, for logging purpose"""

    def send(self, obj):
        if isinstance(obj, basestring):
            log = unicode(obj)
        elif isinstance(obj, domish.Element):
            log = obj.toXml()
        else:
            log.error(_('INTERNAL ERROR: Unmanaged XML type'))
        self._host.bridge.xmlLog("OUT", log, self._profile)
        return XmlStream.send(self, obj)

    def dataReceived(self, data):
        # FIXME: we use "replace" here because a big stanza can be cut in the middle of a unicode char
        #        this plugin should probably moved to a better place, where stanzas are fully received
        self._host.bridge.xmlLog("IN", data.decode('utf-8', 'replace'), self._profile)
        return XmlStream.dataReceived(self, data)


class XmlLog(object):

    params = """
    <params>
    <general>
    <category name="Debug">
        <param name="Xml log" label="%(label_xmllog)s" value="false" type="bool" />
    </category>
    </general>
    </params>
    """ % {"label_xmllog": _("Activate XML log")}

    def __init__(self, host):
        log.info(_("Plugin XML Log initialization"))
        self.host = host

        #parameters
        host.memory.updateParams(self.params)

        #bridge
        host.bridge.addSignal("xmlLog", ".plugin", signature='sss')  # args: direction("IN" or "OUT"), xml_data, profile

        do_log = self.host.memory.getParamA("Xml log", "Debug")
        if do_log:
            log.info(_("XML log activated"))
            host.trigger.add("XML Initialized", self.logXml)

    def logXml(self, xmlstream, profile):
        xmlstream.__class__ = LoggingXmlStream
        xmlstream._profile = profile
        xmlstream._host = self.host
        return True
