/* ConfigurationInterfaces.c generated by valac 0.34.4, the Vala compiler
 * generated from ConfigurationInterfaces.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <time.h>


#define TYPE_FUZZY_PROPERTY_STATE (fuzzy_property_state_get_type ())

#define TYPE_CONFIGURABLE_PROPERTY (configurable_property_get_type ())

#define TYPE_CONFIGURATION_ENGINE (configuration_engine_get_type ())
#define CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngine))
#define IS_CONFIGURATION_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_ENGINE))
#define CONFIGURATION_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONFIGURATION_ENGINE, ConfigurationEngineIface))

typedef struct _ConfigurationEngine ConfigurationEngine;
typedef struct _ConfigurationEngineIface ConfigurationEngineIface;

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;
typedef struct _ConfigurationFacadePrivate ConfigurationFacadePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE,
	CONFIGURATION_ERROR_ENGINE_ERROR
} ConfigurationError;
#define CONFIGURATION_ERROR configuration_error_quark ()
typedef enum  {
	FUZZY_PROPERTY_STATE_ENABLED,
	FUZZY_PROPERTY_STATE_DISABLED,
	FUZZY_PROPERTY_STATE_UNKNOWN
} FuzzyPropertyState;

typedef enum  {
	CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY = 0,
	CONFIGURABLE_PROPERTY_BG_COLOR_NAME,
	CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE,
	CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_FILE,
	CONFIGURABLE_PROPERTY_SCREENSAVER_MODE,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN,
	CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS,
	CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES,
	CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR,
	CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES,
	CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP,
	CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP,
	CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED,
	CONFIGURABLE_PROPERTY_IMPORT_DIR,
	CONFIGURABLE_PROPERTY_KEEP_RELATIVITY,
	CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT,
	CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE,
	CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH,
	CONFIGURABLE_PROPERTY_LAST_USED_SERVICE,
	CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING,
	CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE,
	CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH,
	CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS,
	CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE,
	CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS,
	CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH,
	CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE,
	CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO,
	CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES,
	CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION,
	CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT,
	CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT,
	CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG,
	CONFIGURABLE_PROPERTY_SIDEBAR_POSITION,
	CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY,
	CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID,
	CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE,
	CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME,
	CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES,
	CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE,
	CONFIGURABLE_PROPERTY_NUM_PROPERTIES
} ConfigurableProperty;

struct _ConfigurationEngineIface {
	GTypeInterface parent_iface;
	gchar* (*get_name) (ConfigurationEngine* self);
	gint (*get_int_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_int_property) (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
	gchar* (*get_string_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_string_property) (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
	gboolean (*get_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_bool_property) (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
	gdouble (*get_double_property) (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
	void (*set_double_property) (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
	gboolean (*get_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationEngine* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationEngine* self, const gchar* id, gboolean enabled);
};

struct _Dimensions {
	gint width;
	gint height;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _ConfigurationFacade {
	GObject parent_instance;
	ConfigurationFacadePrivate * priv;
};

struct _ConfigurationFacadeClass {
	GObjectClass parent_class;
	gboolean (*get_auto_import_from_library) (ConfigurationFacade* self);
	void (*set_auto_import_from_library) (ConfigurationFacade* self, gboolean auto_import);
	gchar* (*get_bg_color_name) (ConfigurationFacade* self);
	void (*set_bg_color_name) (ConfigurationFacade* self, const gchar* color_name);
	gboolean (*get_commit_metadata_to_masters) (ConfigurationFacade* self);
	void (*set_commit_metadata_to_masters) (ConfigurationFacade* self, gboolean commit_metadata);
	gchar* (*get_desktop_background) (ConfigurationFacade* self);
	void (*set_desktop_background) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_screensaver) (ConfigurationFacade* self);
	void (*set_screensaver) (ConfigurationFacade* self, const gchar* filename);
	gchar* (*get_directory_pattern) (ConfigurationFacade* self);
	void (*set_directory_pattern) (ConfigurationFacade* self, const gchar* s);
	gchar* (*get_directory_pattern_custom) (ConfigurationFacade* self);
	void (*set_directory_pattern_custom) (ConfigurationFacade* self, const gchar* s);
	void (*get_direct_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_direct_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_display_basic_properties) (ConfigurationFacade* self);
	void (*set_display_basic_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_extended_properties) (ConfigurationFacade* self);
	void (*set_display_extended_properties) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_sidebar) (ConfigurationFacade* self);
	void (*set_display_sidebar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_toolbar) (ConfigurationFacade* self);
	void (*set_display_toolbar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_search_bar) (ConfigurationFacade* self);
	void (*set_display_search_bar) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_ratings) (ConfigurationFacade* self);
	void (*set_display_photo_ratings) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_tags) (ConfigurationFacade* self);
	void (*set_display_photo_tags) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_titles) (ConfigurationFacade* self);
	void (*set_display_photo_titles) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_photo_comments) (ConfigurationFacade* self);
	void (*set_display_photo_comments) (ConfigurationFacade* self, gboolean display);
	gboolean (*get_display_event_comments) (ConfigurationFacade* self);
	void (*set_display_event_comments) (ConfigurationFacade* self, gboolean display);
	void (*get_event_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_event_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	gboolean (*get_events_sort_ascending) (ConfigurationFacade* self);
	void (*set_events_sort_ascending) (ConfigurationFacade* self, gboolean sort);
	gchar* (*get_external_photo_app) (ConfigurationFacade* self);
	void (*set_external_photo_app) (ConfigurationFacade* self, const gchar* external_photo_app);
	gchar* (*get_external_raw_app) (ConfigurationFacade* self);
	void (*set_external_raw_app) (ConfigurationFacade* self, const gchar* external_raw_app);
	RawDeveloper (*get_default_raw_developer) (ConfigurationFacade* self);
	void (*set_default_raw_developer) (ConfigurationFacade* self, RawDeveloper d);
	gboolean (*get_hide_photos_already_imported) (ConfigurationFacade* self);
	void (*set_hide_photos_already_imported) (ConfigurationFacade* self, gboolean hide_imported);
	gchar* (*get_import_dir) (ConfigurationFacade* self);
	void (*set_import_dir) (ConfigurationFacade* self, const gchar* import_dir);
	gboolean (*get_keep_relativity) (ConfigurationFacade* self);
	void (*set_keep_relativity) (ConfigurationFacade* self, gboolean keep_relativity);
	gboolean (*get_pin_toolbar_state) (ConfigurationFacade* self);
	void (*set_pin_toolbar_state) (ConfigurationFacade* self, gboolean state);
	gint (*get_last_crop_height) (ConfigurationFacade* self);
	void (*set_last_crop_height) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_menu_choice) (ConfigurationFacade* self);
	void (*set_last_crop_menu_choice) (ConfigurationFacade* self, gint choice);
	gint (*get_last_crop_width) (ConfigurationFacade* self);
	void (*set_last_crop_width) (ConfigurationFacade* self, gint choice);
	gchar* (*get_last_used_service) (ConfigurationFacade* self);
	void (*set_last_used_service) (ConfigurationFacade* self, const gchar* service_name);
	gchar* (*get_last_used_dataimports_service) (ConfigurationFacade* self);
	void (*set_last_used_dataimports_service) (ConfigurationFacade* self, const gchar* service_name);
	void (*get_library_photos_sort) (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
	void (*set_library_photos_sort) (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
	void (*get_library_window_state) (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
	void (*set_library_window_state) (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
	gboolean (*get_modify_originals) (ConfigurationFacade* self);
	void (*set_modify_originals) (ConfigurationFacade* self, gboolean modify_originals);
	gint (*get_photo_thumbnail_scale) (ConfigurationFacade* self);
	void (*set_photo_thumbnail_scale) (ConfigurationFacade* self, gint scale);
	gdouble (*get_printing_content_height) (ConfigurationFacade* self);
	void (*set_printing_content_height) (ConfigurationFacade* self, gdouble content_height);
	gint (*get_printing_content_layout) (ConfigurationFacade* self);
	void (*set_printing_content_layout) (ConfigurationFacade* self, gint layout_code);
	gint (*get_printing_content_ppi) (ConfigurationFacade* self);
	void (*set_printing_content_ppi) (ConfigurationFacade* self, gint content_ppi);
	gint (*get_printing_content_units) (ConfigurationFacade* self);
	void (*set_printing_content_units) (ConfigurationFacade* self, gint units_code);
	gdouble (*get_printing_content_width) (ConfigurationFacade* self);
	void (*set_printing_content_width) (ConfigurationFacade* self, gdouble content_width);
	gint (*get_printing_images_per_page) (ConfigurationFacade* self);
	void (*set_printing_images_per_page) (ConfigurationFacade* self, gint images_per_page_code);
	gboolean (*get_printing_match_aspect_ratio) (ConfigurationFacade* self);
	void (*set_printing_match_aspect_ratio) (ConfigurationFacade* self, gboolean match_aspect_ratio);
	gboolean (*get_printing_print_titles) (ConfigurationFacade* self);
	void (*set_printing_print_titles) (ConfigurationFacade* self, gboolean print_titles);
	gint (*get_printing_size_selection) (ConfigurationFacade* self);
	void (*set_printing_size_selection) (ConfigurationFacade* self, gint size_code);
	gchar* (*get_printing_titles_font) (ConfigurationFacade* self);
	void (*set_printing_titles_font) (ConfigurationFacade* self, const gchar* font_name);
	gboolean (*get_show_welcome_dialog) (ConfigurationFacade* self);
	void (*set_show_welcome_dialog) (ConfigurationFacade* self, gboolean show);
	gint (*get_sidebar_position) (ConfigurationFacade* self);
	void (*set_sidebar_position) (ConfigurationFacade* self, gint position);
	gdouble (*get_slideshow_delay) (ConfigurationFacade* self);
	void (*set_slideshow_delay) (ConfigurationFacade* self, gdouble delay);
	gdouble (*get_slideshow_transition_delay) (ConfigurationFacade* self);
	void (*set_slideshow_transition_delay) (ConfigurationFacade* self, gdouble delay);
	gchar* (*get_slideshow_transition_effect_id) (ConfigurationFacade* self);
	void (*set_slideshow_transition_effect_id) (ConfigurationFacade* self, const gchar* id);
	gboolean (*get_slideshow_show_title) (ConfigurationFacade* self);
	void (*set_slideshow_show_title) (ConfigurationFacade* self, gboolean show_title);
	gboolean (*get_use_24_hour_time) (ConfigurationFacade* self);
	void (*set_use_24_hour_time) (ConfigurationFacade* self, gboolean use_24_hour_time);
	gboolean (*get_use_lowercase_filenames) (ConfigurationFacade* self);
	void (*set_use_lowercase_filenames) (ConfigurationFacade* self, gboolean b);
	gint (*get_video_interpreter_state_cookie) (ConfigurationFacade* self);
	void (*set_video_interpreter_state_cookie) (ConfigurationFacade* self, gint state_cookie);
	gboolean (*get_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
	void (*set_plugin_bool) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
	gdouble (*get_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
	void (*set_plugin_double) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
	gint (*get_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
	void (*set_plugin_int) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
	gchar* (*get_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
	void (*set_plugin_string) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
	void (*unset_plugin_key) (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
	FuzzyPropertyState (*is_plugin_enabled) (ConfigurationFacade* self, const gchar* id);
	void (*set_plugin_enabled) (ConfigurationFacade* self, const gchar* id, gboolean enabled);
};

struct _ConfigurationFacadePrivate {
	ConfigurationEngine* engine;
};


static gpointer configuration_facade_parent_class = NULL;

GQuark configuration_error_quark (void);
GType fuzzy_property_state_get_type (void) G_GNUC_CONST;
GType configurable_property_get_type (void) G_GNUC_CONST;
gchar* configurable_property_to_string (ConfigurableProperty self);
GType configuration_engine_get_type (void) G_GNUC_CONST;
gchar* configuration_engine_get_name (ConfigurationEngine* self);
gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error);
gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error);
gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error);
gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error);
void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error);
gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id);
void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled);
GType configuration_facade_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
#define CONFIGURATION_FACADE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONFIGURATION_FACADE, ConfigurationFacadePrivate))
enum  {
	CONFIGURATION_FACADE_DUMMY_PROPERTY
};
ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine);
static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p);
static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self);
ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self);
void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err);
gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self);
void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import);
gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self);
void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name);
gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self);
void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata);
gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self);
void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_screensaver (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self);
void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename);
static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename);
gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s);
gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self);
void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s);
void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void dimensions_init (Dimensions *self, gint width, gint height);
void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self);
void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self);
void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self);
void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self);
void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self);
void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self);
void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self);
void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self);
void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self);
void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display);
gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self);
void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display);
static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display);
void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self);
void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort);
gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self);
void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app);
gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self);
void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app);
RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self);
static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self);
RawDeveloper raw_developer_from_string (const gchar* value);
void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d);
gchar* raw_developer_to_string (RawDeveloper self);
gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self);
void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported);
gchar* configuration_facade_get_import_dir (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self);
void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir);
gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self);
void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity);
gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self);
void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state);
gint configuration_facade_get_last_crop_height (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self);
void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self);
void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice);
gint configuration_facade_get_last_crop_width (ConfigurationFacade* self);
static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self);
void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice);
static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice);
gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name);
gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self);
void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name);
void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by);
void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by);
void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions);
void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions);
gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self);
void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals);
gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self);
static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self);
gint thumbnail_get_DEFAULT_SCALE (void);
void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale);
gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self);
void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height);
gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self);
void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code);
gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self);
void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi);
gint configuration_facade_get_printing_content_units (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self);
void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code);
static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code);
gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self);
void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width);
gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self);
void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code);
gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self);
void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio);
gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self);
void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles);
gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self);
static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self);
void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code);
gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self);
void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name);
gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self);
void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show);
gint configuration_facade_get_sidebar_position (ConfigurationFacade* self);
static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self);
void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position);
static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position);
gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay);
gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self);
static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self);
void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay);
gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self);
static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self);
#define NULL_TRANSITION_DESCRIPTOR_EFFECT_ID "org.yorba.shotwell.transitions.null"
#define TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID NULL_TRANSITION_DESCRIPTOR_EFFECT_ID
void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id);
gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self);
void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title);
gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self);
gboolean is_string_empty (const gchar* s);
void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time);
gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self);
void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b);
gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self);
static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self);
void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie);
gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def);
void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val);
gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def);
void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val);
gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def);
void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val);
gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def);
void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val);
void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key);
FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id);
void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled);
static void configuration_facade_finalize (GObject* obj);


GQuark configuration_error_quark (void) {
	return g_quark_from_static_string ("configuration_error-quark");
}


GType fuzzy_property_state_get_type (void) {
	static volatile gsize fuzzy_property_state_type_id__volatile = 0;
	if (g_once_init_enter (&fuzzy_property_state_type_id__volatile)) {
		static const GEnumValue values[] = {{FUZZY_PROPERTY_STATE_ENABLED, "FUZZY_PROPERTY_STATE_ENABLED", "enabled"}, {FUZZY_PROPERTY_STATE_DISABLED, "FUZZY_PROPERTY_STATE_DISABLED", "disabled"}, {FUZZY_PROPERTY_STATE_UNKNOWN, "FUZZY_PROPERTY_STATE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType fuzzy_property_state_type_id;
		fuzzy_property_state_type_id = g_enum_register_static ("FuzzyPropertyState", values);
		g_once_init_leave (&fuzzy_property_state_type_id__volatile, fuzzy_property_state_type_id);
	}
	return fuzzy_property_state_type_id__volatile;
}


gchar* configurable_property_to_string (ConfigurableProperty self) {
	gchar* result = NULL;
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (self) {
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 615 "ConfigurationInterfaces.c"
		{
			gchar* _tmp0_ = NULL;
#line 93 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp0_ = g_strdup ("AUTO_IMPORT_FROM_LIBRARY");
#line 93 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp0_;
#line 93 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 624 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 628 "ConfigurationInterfaces.c"
		{
			gchar* _tmp1_ = NULL;
#line 96 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp1_ = g_strdup ("BG_COLOR_NAME");
#line 96 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp1_;
#line 96 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 637 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 641 "ConfigurationInterfaces.c"
		{
			gchar* _tmp2_ = NULL;
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp2_ = g_strdup ("COMMIT_METADATA_TO_MASTERS");
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp2_;
#line 99 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 650 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE:
#line 654 "ConfigurationInterfaces.c"
		{
			gchar* _tmp3_ = NULL;
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp3_ = g_strdup ("DESKTOP_BACKGROUND_FILE");
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp3_;
#line 102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 663 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE:
#line 667 "ConfigurationInterfaces.c"
		{
			gchar* _tmp4_ = NULL;
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = g_strdup ("DESKTOP_BACKGROUND_MODE");
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp4_;
#line 105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 676 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_FILE:
#line 680 "ConfigurationInterfaces.c"
		{
			gchar* _tmp5_ = NULL;
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp5_ = g_strdup ("SCREENSAVER_FILE");
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp5_;
#line 108 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 689 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SCREENSAVER_MODE:
#line 693 "ConfigurationInterfaces.c"
		{
			gchar* _tmp6_ = NULL;
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp6_ = g_strdup ("SCREENSAVER_MODE");
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp6_;
#line 111 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 702 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN:
#line 706 "ConfigurationInterfaces.c"
		{
			gchar* _tmp7_ = NULL;
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = g_strdup ("DIRECTORY_PATTERN");
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp7_;
#line 114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 715 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM:
#line 719 "ConfigurationInterfaces.c"
		{
			gchar* _tmp8_ = NULL;
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = g_strdup ("DIRECTORY_PATTERN_CUSTOM");
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp8_;
#line 117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 728 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT:
#line 732 "ConfigurationInterfaces.c"
		{
			gchar* _tmp9_ = NULL;
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = g_strdup ("DIRECT_WINDOW_HEIGHT");
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp9_;
#line 120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 741 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE:
#line 745 "ConfigurationInterfaces.c"
		{
			gchar* _tmp10_ = NULL;
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = g_strdup ("DIRECT_WINDOW_MAXIMIZE");
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp10_;
#line 123 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 754 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH:
#line 758 "ConfigurationInterfaces.c"
		{
			gchar* _tmp11_ = NULL;
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = g_strdup ("DIRECT_WINDOW_WIDTH");
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp11_;
#line 126 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 767 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES:
#line 771 "ConfigurationInterfaces.c"
		{
			gchar* _tmp12_ = NULL;
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = g_strdup ("DISPLAY_BASIC_PROPERTIES");
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp12_;
#line 129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 780 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES:
#line 784 "ConfigurationInterfaces.c"
		{
			gchar* _tmp13_ = NULL;
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = g_strdup ("DISPLAY_EXTENDED_PROPERTIES");
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp13_;
#line 132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 793 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR:
#line 797 "ConfigurationInterfaces.c"
		{
			gchar* _tmp14_ = NULL;
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = g_strdup ("DISPLAY_SIDEBAR");
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp14_;
#line 135 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 806 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR:
#line 810 "ConfigurationInterfaces.c"
		{
			gchar* _tmp15_ = NULL;
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = g_strdup ("DISPLAY_TOOLBAR");
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp15_;
#line 138 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 819 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR:
#line 823 "ConfigurationInterfaces.c"
		{
			gchar* _tmp16_ = NULL;
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = g_strdup ("DISPLAY_SEARCH_BAR");
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp16_;
#line 141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 832 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS:
#line 836 "ConfigurationInterfaces.c"
		{
			gchar* _tmp17_ = NULL;
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp17_ = g_strdup ("DISPLAY_PHOTO_RATINGS");
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp17_;
#line 144 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 845 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS:
#line 849 "ConfigurationInterfaces.c"
		{
			gchar* _tmp18_ = NULL;
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp18_ = g_strdup ("DISPLAY_PHOTO_TAGS");
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp18_;
#line 147 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 858 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES:
#line 862 "ConfigurationInterfaces.c"
		{
			gchar* _tmp19_ = NULL;
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp19_ = g_strdup ("DISPLAY_PHOTO_TITLES");
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp19_;
#line 150 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 871 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS:
#line 875 "ConfigurationInterfaces.c"
		{
			gchar* _tmp20_ = NULL;
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp20_ = g_strdup ("DISPLAY_PHOTO_COMMENTS");
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp20_;
#line 153 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 884 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS:
#line 888 "ConfigurationInterfaces.c"
		{
			gchar* _tmp21_ = NULL;
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp21_ = g_strdup ("DISPLAY_EVENT_COMMENTS");
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp21_;
#line 156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 897 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING:
#line 901 "ConfigurationInterfaces.c"
		{
			gchar* _tmp22_ = NULL;
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp22_ = g_strdup ("EVENT_PHOTOS_SORT_ASCENDING");
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp22_;
#line 159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 910 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY:
#line 914 "ConfigurationInterfaces.c"
		{
			gchar* _tmp23_ = NULL;
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp23_ = g_strdup ("EVENT_PHOTOS_SORT_BY");
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp23_;
#line 162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 923 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 927 "ConfigurationInterfaces.c"
		{
			gchar* _tmp24_ = NULL;
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp24_ = g_strdup ("EVENTS_SORT_ASCENDING");
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp24_;
#line 165 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 936 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 940 "ConfigurationInterfaces.c"
		{
			gchar* _tmp25_ = NULL;
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp25_ = g_strdup ("EXTERNAL_PHOTO_APP");
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp25_;
#line 168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 949 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 953 "ConfigurationInterfaces.c"
		{
			gchar* _tmp26_ = NULL;
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp26_ = g_strdup ("EXTERNAL_RAW_APP");
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp26_;
#line 171 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 962 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED:
#line 966 "ConfigurationInterfaces.c"
		{
			gchar* _tmp27_ = NULL;
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp27_ = g_strdup ("HIDE_PHOTOS_ALREADY_IMPORTED");
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp27_;
#line 174 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 975 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 979 "ConfigurationInterfaces.c"
		{
			gchar* _tmp28_ = NULL;
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp28_ = g_strdup ("IMPORT_DIR");
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp28_;
#line 177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 988 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_KEEP_RELATIVITY:
#line 992 "ConfigurationInterfaces.c"
		{
			gchar* _tmp29_ = NULL;
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp29_ = g_strdup ("KEEP_RELATIVITY");
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp29_;
#line 180 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1001 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT:
#line 1005 "ConfigurationInterfaces.c"
		{
			gchar* _tmp30_ = NULL;
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp30_ = g_strdup ("LAST_CROP_HEIGHT");
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp30_;
#line 183 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1014 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE:
#line 1018 "ConfigurationInterfaces.c"
		{
			gchar* _tmp31_ = NULL;
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp31_ = g_strdup ("LAST_CROP_MENU_CHOICE");
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp31_;
#line 186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1027 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH:
#line 1031 "ConfigurationInterfaces.c"
		{
			gchar* _tmp32_ = NULL;
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp32_ = g_strdup ("LAST_CROP_WIDTH");
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp32_;
#line 189 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1040 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_SERVICE:
#line 1044 "ConfigurationInterfaces.c"
		{
			gchar* _tmp33_ = NULL;
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp33_ = g_strdup ("LAST_USED_SERVICE");
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp33_;
#line 192 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1053 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE:
#line 1057 "ConfigurationInterfaces.c"
		{
			gchar* _tmp34_ = NULL;
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp34_ = g_strdup ("LAST_USED_DATAIMPORTS_SERVICE");
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp34_;
#line 195 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1066 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING:
#line 1070 "ConfigurationInterfaces.c"
		{
			gchar* _tmp35_ = NULL;
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp35_ = g_strdup ("LIBRARY_PHOTOS_SORT_ASCENDING");
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp35_;
#line 198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1079 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY:
#line 1083 "ConfigurationInterfaces.c"
		{
			gchar* _tmp36_ = NULL;
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp36_ = g_strdup ("LIBRARY_PHOTOS_SORT_BY");
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp36_;
#line 201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1092 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT:
#line 1096 "ConfigurationInterfaces.c"
		{
			gchar* _tmp37_ = NULL;
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp37_ = g_strdup ("LIBRARY_WINDOW_HEIGHT");
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp37_;
#line 204 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1105 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE:
#line 1109 "ConfigurationInterfaces.c"
		{
			gchar* _tmp38_ = NULL;
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp38_ = g_strdup ("LIBRARY_WINDOW_MAXIMIZE");
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp38_;
#line 207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1118 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH:
#line 1122 "ConfigurationInterfaces.c"
		{
			gchar* _tmp39_ = NULL;
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp39_ = g_strdup ("LIBRARY_WINDOW_WIDTH");
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp39_;
#line 210 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1131 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS:
#line 1135 "ConfigurationInterfaces.c"
		{
			gchar* _tmp40_ = NULL;
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp40_ = g_strdup ("MODIFY_ORIGINALS");
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp40_;
#line 213 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1144 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE:
#line 1148 "ConfigurationInterfaces.c"
		{
			gchar* _tmp41_ = NULL;
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp41_ = g_strdup ("PHOTO_THUMBNAIL_SCALE");
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp41_;
#line 216 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1157 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE:
#line 1161 "ConfigurationInterfaces.c"
		{
			gchar* _tmp42_ = NULL;
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp42_ = g_strdup ("PIN_TOOLBAR_STATE");
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp42_;
#line 219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1170 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT:
#line 1174 "ConfigurationInterfaces.c"
		{
			gchar* _tmp43_ = NULL;
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp43_ = g_strdup ("PRINTING_CONTENT_HEIGHT");
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp43_;
#line 222 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1183 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT:
#line 1187 "ConfigurationInterfaces.c"
		{
			gchar* _tmp44_ = NULL;
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp44_ = g_strdup ("PRINTING_CONTENT_LAYOUT");
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp44_;
#line 225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1196 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI:
#line 1200 "ConfigurationInterfaces.c"
		{
			gchar* _tmp45_ = NULL;
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp45_ = g_strdup ("PRINTING_CONTENT_PPI");
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp45_;
#line 228 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1209 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS:
#line 1213 "ConfigurationInterfaces.c"
		{
			gchar* _tmp46_ = NULL;
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp46_ = g_strdup ("PRINTING_CONTENT_UNITS");
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp46_;
#line 231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1222 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH:
#line 1226 "ConfigurationInterfaces.c"
		{
			gchar* _tmp47_ = NULL;
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp47_ = g_strdup ("PRINTING_CONTENT_WIDTH");
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp47_;
#line 234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1235 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE:
#line 1239 "ConfigurationInterfaces.c"
		{
			gchar* _tmp48_ = NULL;
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp48_ = g_strdup ("PRINTING_IMAGES_PER_PAGE");
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp48_;
#line 237 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1248 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO:
#line 1252 "ConfigurationInterfaces.c"
		{
			gchar* _tmp49_ = NULL;
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp49_ = g_strdup ("PRINTING_MATCH_ASPECT_RATIO");
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp49_;
#line 240 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1261 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES:
#line 1265 "ConfigurationInterfaces.c"
		{
			gchar* _tmp50_ = NULL;
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp50_ = g_strdup ("PRINTING_PRINT_TITLES");
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp50_;
#line 243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1274 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION:
#line 1278 "ConfigurationInterfaces.c"
		{
			gchar* _tmp51_ = NULL;
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp51_ = g_strdup ("PRINTING_SIZE_SELECTION");
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp51_;
#line 246 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1287 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT:
#line 1291 "ConfigurationInterfaces.c"
		{
			gchar* _tmp52_ = NULL;
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp52_ = g_strdup ("PRINTING_TITLES_FONT");
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp52_;
#line 249 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1300 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT:
#line 1304 "ConfigurationInterfaces.c"
		{
			gchar* _tmp53_ = NULL;
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp53_ = g_strdup ("RAW_DEVELOPER_DEFAULT");
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp53_;
#line 252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1313 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG:
#line 1317 "ConfigurationInterfaces.c"
		{
			gchar* _tmp54_ = NULL;
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp54_ = g_strdup ("SHOW_WELCOME_DIALOG");
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp54_;
#line 255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1326 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SIDEBAR_POSITION:
#line 1330 "ConfigurationInterfaces.c"
		{
			gchar* _tmp55_ = NULL;
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp55_ = g_strdup ("SIDEBAR_POSITION");
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp55_;
#line 258 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1339 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY:
#line 1343 "ConfigurationInterfaces.c"
		{
			gchar* _tmp56_ = NULL;
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp56_ = g_strdup ("SLIDESHOW_DELAY");
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp56_;
#line 261 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1352 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY:
#line 1356 "ConfigurationInterfaces.c"
		{
			gchar* _tmp57_ = NULL;
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp57_ = g_strdup ("SLIDESHOW_TRANSITION_DELAY");
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp57_;
#line 264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1365 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID:
#line 1369 "ConfigurationInterfaces.c"
		{
			gchar* _tmp58_ = NULL;
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp58_ = g_strdup ("SLIDESHOW_TRANSITION_EFFECT_ID");
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp58_;
#line 267 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1378 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE:
#line 1382 "ConfigurationInterfaces.c"
		{
			gchar* _tmp59_ = NULL;
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp59_ = g_strdup ("SLIDESHOW_SHOW_TITLE");
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp59_;
#line 270 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1391 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME:
#line 1395 "ConfigurationInterfaces.c"
		{
			gchar* _tmp60_ = NULL;
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp60_ = g_strdup ("USE_24_HOUR_TIME");
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp60_;
#line 273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1404 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES:
#line 1408 "ConfigurationInterfaces.c"
		{
			gchar* _tmp61_ = NULL;
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp61_ = g_strdup ("USE_LOWERCASE_FILENAMES");
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp61_;
#line 276 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1417 "ConfigurationInterfaces.c"
		}
#line 91 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE:
#line 1421 "ConfigurationInterfaces.c"
		{
			gchar* _tmp62_ = NULL;
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp62_ = g_strdup ("VIDEO_INTERPRETER_STATE_COOKIE");
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			result = _tmp62_;
#line 279 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return result;
#line 1430 "ConfigurationInterfaces.c"
		}
		default:
		{
#line 282 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_error ("ConfigurationInterfaces.vala:282: unknown ConfigurableProperty enumera" \
"tion value");
#line 1436 "ConfigurationInterfaces.c"
		}
	}
}


GType configurable_property_get_type (void) {
	static volatile gsize configurable_property_type_id__volatile = 0;
	if (g_once_init_enter (&configurable_property_type_id__volatile)) {
		static const GEnumValue values[] = {{CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, "CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY", "auto-import-from-library"}, {CONFIGURABLE_PROPERTY_BG_COLOR_NAME, "CONFIGURABLE_PROPERTY_BG_COLOR_NAME", "bg-color-name"}, {CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, "CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS", "commit-metadata-to-masters"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE", "desktop-background-file"}, {CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE", "desktop-background-mode"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, "CONFIGURABLE_PROPERTY_SCREENSAVER_FILE", "screensaver-file"}, {CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "CONFIGURABLE_PROPERTY_SCREENSAVER_MODE", "screensaver-mode"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN", "directory-pattern"}, {CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, "CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM", "directory-pattern-custom"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT", "direct-window-height"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE", "direct-window-maximize"}, {CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH", "direct-window-width"}, {CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES", "display-basic-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS", "display-event-comments"}, {CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, "CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES", "display-extended-properties"}, {CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, "CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR", "display-sidebar"}, {CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, "CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR", "display-toolbar"}, {CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, "CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR", "display-search-bar"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS", "display-photo-ratings"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS", "display-photo-tags"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES", "display-photo-titles"}, {CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, "CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS", "display-photo-comments"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING", "event-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY", "event-photos-sort-by"}, {CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING", "events-sort-ascending"}, {CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP", "external-photo-app"}, {CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, "CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP", "external-raw-app"}, {CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, "CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED", "hide-photos-already-imported"}, {CONFIGURABLE_PROPERTY_IMPORT_DIR, "CONFIGURABLE_PROPERTY_IMPORT_DIR", "import-dir"}, {CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, "CONFIGURABLE_PROPERTY_KEEP_RELATIVITY", "keep-relativity"}, {CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, "CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT", "last-crop-height"}, {CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, "CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE", "last-crop-menu-choice"}, {CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, "CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH", "last-crop-width"}, {CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_SERVICE", "last-used-service"}, {CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, "CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE", "last-used-dataimports-service"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING", "library-photos-sort-ascending"}, {CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, "CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY", "library-photos-sort-by"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT", "library-window-height"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE", "library-window-maximize"}, {CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, "CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH", "library-window-width"}, {CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, "CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS", "modify-originals"}, {CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, "CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE", "photo-thumbnail-scale"}, {CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, "CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE", "pin-toolbar-state"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT", "printing-content-height"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT", "printing-content-layout"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI", "printing-content-ppi"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS", "printing-content-units"}, {CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, "CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH", "printing-content-width"}, {CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, "CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE", "printing-images-per-page"}, {CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, "CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO", "printing-match-aspect-ratio"}, {CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, "CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES", "printing-print-titles"}, {CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, "CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION", "printing-size-selection"}, {CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, "CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT", "printing-titles-font"}, {CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, "CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT", "raw-developer-default"}, {CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, "CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG", "show-welcome-dialog"}, {CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, "CONFIGURABLE_PROPERTY_SIDEBAR_POSITION", "sidebar-position"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY", "slideshow-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY", "slideshow-transition-delay"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, "CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID", "slideshow-transition-effect-id"}, {CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, "CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE", "slideshow-show-title"}, {CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, "CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME", "use-24-hour-time"}, {CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, "CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES", "use-lowercase-filenames"}, {CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, "CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE", "video-interpreter-state-cookie"}, {CONFIGURABLE_PROPERTY_NUM_PROPERTIES, "CONFIGURABLE_PROPERTY_NUM_PROPERTIES", "num-properties"}, {0, NULL, NULL}};
		GType configurable_property_type_id;
		configurable_property_type_id = g_enum_register_static ("ConfigurableProperty", values);
		g_once_init_leave (&configurable_property_type_id__volatile, configurable_property_type_id);
	}
	return configurable_property_type_id__volatile;
}


gchar* configuration_engine_get_name (ConfigurationEngine* self) {
#line 290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_name (self);
#line 1459 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_int_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 292 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_int_property (self, p, error);
#line 1468 "ConfigurationInterfaces.c"
}


void configuration_engine_set_int_property (ConfigurationEngine* self, ConfigurableProperty p, gint val, GError** error) {
#line 293 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 293 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_int_property (self, p, val, error);
#line 1477 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_string_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_string_property (self, p, error);
#line 1486 "ConfigurationInterfaces.c"
}


void configuration_engine_set_string_property (ConfigurationEngine* self, ConfigurableProperty p, const gchar* val, GError** error) {
#line 296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_string_property (self, p, val, error);
#line 1495 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_bool_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 298 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_bool_property (self, p, error);
#line 1504 "ConfigurationInterfaces.c"
}


void configuration_engine_set_bool_property (ConfigurationEngine* self, ConfigurableProperty p, gboolean val, GError** error) {
#line 299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_bool_property (self, p, val, error);
#line 1513 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_double_property (ConfigurationEngine* self, ConfigurableProperty p, GError** error) {
#line 301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 301 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_double_property (self, p, error);
#line 1522 "ConfigurationInterfaces.c"
}


void configuration_engine_set_double_property (ConfigurationEngine* self, ConfigurableProperty p, gdouble val, GError** error) {
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 302 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_double_property (self, p, val, error);
#line 1531 "ConfigurationInterfaces.c"
}


gboolean configuration_engine_get_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), FALSE);
#line 304 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_bool (self, domain, id, key, def);
#line 1540 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_bool (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 305 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_bool (self, domain, id, key, val);
#line 1549 "ConfigurationInterfaces.c"
}


gdouble configuration_engine_get_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0.0);
#line 306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_double (self, domain, id, key, def);
#line 1558 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_double (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_double (self, domain, id, key, val);
#line 1567 "ConfigurationInterfaces.c"
}


gint configuration_engine_get_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_int (self, domain, id, key, def);
#line 1576 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_int (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 309 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 309 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_int (self, domain, id, key, val);
#line 1585 "ConfigurationInterfaces.c"
}


gchar* configuration_engine_get_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), NULL);
#line 310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->get_plugin_string (self, domain, id, key, def);
#line 1594 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_string (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 311 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_string (self, domain, id, key, val);
#line 1603 "ConfigurationInterfaces.c"
}


void configuration_engine_unset_plugin_key (ConfigurationEngine* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->unset_plugin_key (self, domain, id, key);
#line 1612 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_engine_is_plugin_enabled (ConfigurationEngine* self, const gchar* id) {
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (self), 0);
#line 314 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_ENGINE_GET_INTERFACE (self)->is_plugin_enabled (self, id);
#line 1621 "ConfigurationInterfaces.c"
}


void configuration_engine_set_plugin_enabled (ConfigurationEngine* self, const gchar* id, gboolean enabled) {
#line 315 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_ENGINE (self));
#line 315 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_ENGINE_GET_INTERFACE (self)->set_plugin_enabled (self, id, enabled);
#line 1630 "ConfigurationInterfaces.c"
}


static void configuration_engine_base_init (ConfigurationEngineIface * iface) {
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	static gboolean initialized = FALSE;
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (!initialized) {
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		initialized = TRUE;
#line 287 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_signal_new ("property_changed", TYPE_CONFIGURATION_ENGINE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_CONFIGURABLE_PROPERTY);
#line 1643 "ConfigurationInterfaces.c"
	}
}


GType configuration_engine_get_type (void) {
	static volatile gsize configuration_engine_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_engine_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationEngineIface), (GBaseInitFunc) configuration_engine_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType configuration_engine_type_id;
		configuration_engine_type_id = g_type_register_static (G_TYPE_INTERFACE, "ConfigurationEngine", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (configuration_engine_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&configuration_engine_type_id__volatile, configuration_engine_type_id);
	}
	return configuration_engine_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self ? g_object_ref (self) : NULL;
#line 1664 "ConfigurationInterfaces.c"
}


static void _configuration_facade_on_property_changed_configuration_engine_property_changed (ConfigurationEngine* _sender, ConfigurableProperty p, gpointer self) {
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_on_property_changed ((ConfigurationFacade*) self, p);
#line 1671 "ConfigurationInterfaces.c"
}


ConfigurationFacade* configuration_facade_construct (GType object_type, ConfigurationEngine* engine) {
	ConfigurationFacade * self = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	ConfigurationEngine* _tmp2_ = NULL;
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_ENGINE (engine), NULL);
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = (ConfigurationFacade*) g_object_new (object_type, NULL);
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = engine;
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv->engine = _tmp1_;
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = engine;
#line 331 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_connect_object (_tmp2_, "property-changed", (GCallback) _configuration_facade_on_property_changed_configuration_engine_property_changed, self, 0);
#line 328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return self;
#line 1698 "ConfigurationInterfaces.c"
}


static void configuration_facade_on_property_changed (ConfigurationFacade* self, ConfigurableProperty p) {
	ConfigurableProperty _tmp0_ = 0;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	ConfigurableProperty _tmp3_ = 0;
#line 334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = p;
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configurable_property_to_string (_tmp0_);
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_debug ("ConfigurationInterfaces.vala:335: ConfigurationFacade: engine reports " \
"property '%s' changed.", _tmp2_);
#line 335 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_tmp2_);
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = p;
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	switch (_tmp3_) {
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY:
#line 1725 "ConfigurationInterfaces.c"
		{
#line 339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "auto-import-from-library-changed");
#line 340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1731 "ConfigurationInterfaces.c"
		}
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_BG_COLOR_NAME:
#line 1735 "ConfigurationInterfaces.c"
		{
#line 343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "bg-color-name-changed");
#line 344 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1741 "ConfigurationInterfaces.c"
		}
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS:
#line 1745 "ConfigurationInterfaces.c"
		{
#line 347 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "commit-metadata-to-masters-changed");
#line 348 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1751 "ConfigurationInterfaces.c"
		}
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING:
#line 1755 "ConfigurationInterfaces.c"
		{
#line 351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "events-sort-ascending-changed");
#line 352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1761 "ConfigurationInterfaces.c"
		}
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP:
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP:
#line 1767 "ConfigurationInterfaces.c"
		{
#line 356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "external-app-changed");
#line 357 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1773 "ConfigurationInterfaces.c"
		}
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		case CONFIGURABLE_PROPERTY_IMPORT_DIR:
#line 1777 "ConfigurationInterfaces.c"
		{
#line 360 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_signal_emit_by_name (self, "import-directory-changed");
#line 361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			break;
#line 1783 "ConfigurationInterfaces.c"
		}
		default:
#line 337 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		break;
#line 1788 "ConfigurationInterfaces.c"
	}
}


ConfigurationEngine* configuration_facade_get_engine (ConfigurationFacade* self) {
	ConfigurationEngine* result = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
#line 365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = self->priv->engine;
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp1_;
#line 366 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 1807 "ConfigurationInterfaces.c"
}


void configuration_facade_on_configuration_error (ConfigurationFacade* self, GError* err) {
	GError* _tmp0_ = NULL;
#line 369 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = err;
#line 370 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_error_matches (_tmp0_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_PROPERTY_HAS_NO_VALUE)) {
#line 1819 "ConfigurationInterfaces.c"
		ConfigurationEngine* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = self->priv->engine;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_name (_tmp1_);
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp4_->message;
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_message ("ConfigurationInterfaces.vala:371: configuration engine '%s' reports PR" \
"OPERTY_HAS_NO_VALUE error: %s", _tmp3_, _tmp5_);
#line 371 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp3_);
#line 1839 "ConfigurationInterfaces.c"
	} else {
		GError* _tmp6_ = NULL;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_error_matches (_tmp6_, CONFIGURATION_ERROR, CONFIGURATION_ERROR_ENGINE_ERROR)) {
#line 1846 "ConfigurationInterfaces.c"
			ConfigurationEngine* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GError* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp7_ = self->priv->engine;
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp8_ = configuration_engine_get_name (_tmp7_);
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp9_ = _tmp8_;
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp10_ = err;
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp11_ = _tmp10_->message;
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:375: configuration engine '%s' reports EN" \
"GINE_ERROR: %s", _tmp9_, _tmp11_);
#line 375 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp9_);
#line 1866 "ConfigurationInterfaces.c"
		} else {
			ConfigurationEngine* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_ = NULL;
			GError* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp12_ = self->priv->engine;
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp13_ = configuration_engine_get_name (_tmp12_);
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp14_ = _tmp13_;
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp15_ = err;
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp16_ = _tmp15_->message;
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("ConfigurationInterfaces.vala:378: configuration engine '%s' reports un" \
"known error: %s", _tmp14_, _tmp16_);
#line 378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_g_free0 (_tmp14_);
#line 1887 "ConfigurationInterfaces.c"
		}
	}
}


static gboolean configuration_facade_real_get_auto_import_from_library (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, &_inner_error_);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 1918 "ConfigurationInterfaces.c"
				goto __catch81_configuration_error;
			}
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 1927 "ConfigurationInterfaces.c"
		}
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 388 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 1933 "ConfigurationInterfaces.c"
	}
	goto __finally81;
	__catch81_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 390 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 390 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 392 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 1954 "ConfigurationInterfaces.c"
	}
	__finally81:
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 1963 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_auto_import_from_library (ConfigurationFacade* self) {
#line 386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 386 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_auto_import_from_library (self);
#line 1972 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = auto_import;
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_AUTO_IMPORT_FROM_LIBRARY, _tmp2_, &_inner_error_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 1996 "ConfigurationInterfaces.c"
				goto __catch82_configuration_error;
			}
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2005 "ConfigurationInterfaces.c"
		}
	}
	goto __finally82;
	__catch82_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 401 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2025 "ConfigurationInterfaces.c"
	}
	__finally82:
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 397 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2036 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_auto_import_from_library (ConfigurationFacade* self, gboolean auto_import) {
#line 396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_auto_import_from_library (self, auto_import);
#line 2046 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_bg_color_name (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, &_inner_error_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2076 "ConfigurationInterfaces.c"
				goto __catch83_configuration_error;
			}
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2085 "ConfigurationInterfaces.c"
		}
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 411 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2097 "ConfigurationInterfaces.c"
	}
	goto __finally83;
	__catch83_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 413 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 415 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2121 "ConfigurationInterfaces.c"
	}
	__finally83:
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2130 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_bg_color_name (ConfigurationFacade* self) {
#line 409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 409 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_bg_color_name (self);
#line 2139 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
	GError * _inner_error_ = NULL;
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (color_name != NULL);
#line 2147 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = color_name;
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_BG_COLOR_NAME, _tmp2_, &_inner_error_);
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2166 "ConfigurationInterfaces.c"
				goto __catch84_configuration_error;
			}
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2175 "ConfigurationInterfaces.c"
		}
	}
	goto __finally84;
	__catch84_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 424 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2195 "ConfigurationInterfaces.c"
	}
	__finally84:
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 420 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2206 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_bg_color_name (ConfigurationFacade* self, const gchar* color_name) {
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_bg_color_name (self, color_name);
#line 2216 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_commit_metadata_to_masters (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, &_inner_error_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2245 "ConfigurationInterfaces.c"
				goto __catch85_configuration_error;
			}
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 2254 "ConfigurationInterfaces.c"
		}
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 433 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2260 "ConfigurationInterfaces.c"
	}
	goto __finally85;
	__catch85_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 435 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 437 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2281 "ConfigurationInterfaces.c"
	}
	__finally85:
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 2290 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_commit_metadata_to_masters (ConfigurationFacade* self) {
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 431 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_commit_metadata_to_masters (self);
#line 2299 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = commit_metadata;
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_COMMIT_METADATA_TO_MASTERS, _tmp2_, &_inner_error_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2323 "ConfigurationInterfaces.c"
				goto __catch86_configuration_error;
			}
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2332 "ConfigurationInterfaces.c"
		}
	}
	goto __finally86;
	__catch86_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 446 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 447 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2352 "ConfigurationInterfaces.c"
	}
	__finally86:
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 442 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2363 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_commit_metadata_to_masters (ConfigurationFacade* self, gboolean commit_metadata) {
#line 441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_commit_metadata_to_masters (self, commit_metadata);
#line 2373 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_desktop_background (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, &_inner_error_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2403 "ConfigurationInterfaces.c"
				goto __catch87_configuration_error;
			}
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2412 "ConfigurationInterfaces.c"
		}
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 456 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2424 "ConfigurationInterfaces.c"
	}
	goto __finally87;
	__catch87_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 458 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2448 "ConfigurationInterfaces.c"
	}
	__finally87:
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 455 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2457 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_desktop_background (ConfigurationFacade* self) {
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 454 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_desktop_background (self);
#line 2466 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2474 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_FILE, _tmp2_, &_inner_error_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2495 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2504 "ConfigurationInterfaces.c"
		}
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_DESKTOP_BACKGROUND_MODE, "zoom", &_inner_error_);
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2518 "ConfigurationInterfaces.c"
				goto __catch88_configuration_error;
			}
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 468 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2527 "ConfigurationInterfaces.c"
		}
	}
	goto __finally88;
	__catch88_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2545 "ConfigurationInterfaces.c"
	}
	__finally88:
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 465 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2556 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_desktop_background (ConfigurationFacade* self, const gchar* filename) {
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_desktop_background (self, filename);
#line 2566 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_screensaver (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, &_inner_error_);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2596 "ConfigurationInterfaces.c"
				goto __catch89_configuration_error;
			}
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2605 "ConfigurationInterfaces.c"
		}
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 480 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2617 "ConfigurationInterfaces.c"
	}
	goto __finally89;
	__catch89_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 484 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2641 "ConfigurationInterfaces.c"
	}
	__finally89:
#line 479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 479 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2650 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_screensaver (ConfigurationFacade* self) {
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 478 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_screensaver (self);
#line 2659 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
	GError * _inner_error_ = NULL;
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (filename != NULL);
#line 2667 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = filename;
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SCREENSAVER_FILE, _tmp2_, &_inner_error_);
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2688 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 490 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2697 "ConfigurationInterfaces.c"
		}
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp4_, CONFIGURABLE_PROPERTY_SCREENSAVER_MODE, "zoom", &_inner_error_);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2711 "ConfigurationInterfaces.c"
				goto __catch90_configuration_error;
			}
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2720 "ConfigurationInterfaces.c"
		}
	}
	goto __finally90;
	__catch90_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 495 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2738 "ConfigurationInterfaces.c"
	}
	__finally90:
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 489 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2749 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_screensaver (ConfigurationFacade* self, const gchar* filename) {
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_screensaver (self, filename);
#line 2759 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* s = NULL;
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = configuration_engine_get_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, &_inner_error_);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = _tmp2_;
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		s = _tmp3_;
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2790 "ConfigurationInterfaces.c"
				goto __catch91_configuration_error;
			}
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2799 "ConfigurationInterfaces.c"
		}
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (g_strcmp0 (s, "") == 0) {
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = NULL;
#line 2805 "ConfigurationInterfaces.c"
		} else {
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			_tmp4_ = s;
#line 2809 "ConfigurationInterfaces.c"
		}
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (s);
#line 505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2819 "ConfigurationInterfaces.c"
	}
	goto __finally91;
	__catch91_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 507 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2843 "ConfigurationInterfaces.c"
	}
	__finally91:
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 503 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 2852 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern (ConfigurationFacade* self) {
#line 502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 502 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern (self);
#line 2861 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
	{
		const gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = s;
#line 515 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (_tmp0_ == NULL) {
#line 516 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			s = "";
#line 2878 "ConfigurationInterfaces.c"
		}
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = s;
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN, _tmp3_, &_inner_error_);
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2894 "ConfigurationInterfaces.c"
				goto __catch92_configuration_error;
			}
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 2903 "ConfigurationInterfaces.c"
		}
	}
	goto __finally92;
	__catch92_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp4_ = NULL;
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = err;
#line 520 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp4_);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 2921 "ConfigurationInterfaces.c"
	}
	__finally92:
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 514 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 2932 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern (ConfigurationFacade* self, const gchar* s) {
#line 513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern (self, s);
#line 2942 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_directory_pattern_custom (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, &_inner_error_);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 2972 "ConfigurationInterfaces.c"
				goto __catch93_configuration_error;
			}
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 2981 "ConfigurationInterfaces.c"
		}
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 2993 "ConfigurationInterfaces.c"
	}
	goto __finally93;
	__catch93_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3017 "ConfigurationInterfaces.c"
	}
	__finally93:
#line 528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 528 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 3026 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_directory_pattern_custom (ConfigurationFacade* self) {
#line 527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 527 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_directory_pattern_custom (self);
#line 3035 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
	GError * _inner_error_ = NULL;
#line 537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (s != NULL);
#line 3043 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = s;
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECTORY_PATTERN_CUSTOM, _tmp2_, &_inner_error_);
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3062 "ConfigurationInterfaces.c"
				goto __catch94_configuration_error;
			}
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3071 "ConfigurationInterfaces.c"
		}
	}
	goto __finally94;
	__catch94_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3089 "ConfigurationInterfaces.c"
	}
	__finally94:
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 538 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3100 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_directory_pattern_custom (ConfigurationFacade* self, const gchar* s) {
#line 537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 537 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_directory_pattern_custom (self, s);
#line 3110 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 549 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 3122 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint w = 0;
		ConfigurationEngine* _tmp5_ = NULL;
		ConfigurationEngine* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint h = 0;
		ConfigurationEngine* _tmp9_ = NULL;
		ConfigurationEngine* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, &_inner_error_);
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3157 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3166 "ConfigurationInterfaces.c"
		}
#line 552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, &_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3186 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 553 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3195 "ConfigurationInterfaces.c"
		}
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, &_inner_error_);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3213 "ConfigurationInterfaces.c"
				goto __catch95_configuration_error;
			}
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3222 "ConfigurationInterfaces.c"
		}
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 555 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 3230 "ConfigurationInterfaces.c"
	}
	goto __finally95;
	__catch95_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_ = NULL;
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 557 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3247 "ConfigurationInterfaces.c"
	}
	__finally95:
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3258 "ConfigurationInterfaces.c"
	}
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 3264 "ConfigurationInterfaces.c"
	}
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 3270 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_direct_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 548 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_direct_window_state (self, maximize, dimensions);
#line 3280 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 3288 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		ConfigurationEngine* _tmp7_ = NULL;
		ConfigurationEngine* _tmp8_ = NULL;
		Dimensions _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3315 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3324 "ConfigurationInterfaces.c"
		}
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3342 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3351 "ConfigurationInterfaces.c"
		}
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_DIRECT_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3369 "ConfigurationInterfaces.c"
				goto __catch96_configuration_error;
			}
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3378 "ConfigurationInterfaces.c"
		}
	}
	goto __finally96;
	__catch96_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_ = NULL;
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 569 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3396 "ConfigurationInterfaces.c"
	}
	__finally96:
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3407 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_direct_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 561 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_direct_window_state (self, maximize, dimensions);
#line 3417 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_basic_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, &_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3446 "ConfigurationInterfaces.c"
				goto __catch97_configuration_error;
			}
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3455 "ConfigurationInterfaces.c"
		}
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 578 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3461 "ConfigurationInterfaces.c"
	}
	goto __finally97;
	__catch97_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 580 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 582 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3482 "ConfigurationInterfaces.c"
	}
	__finally97:
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3491 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_basic_properties (ConfigurationFacade* self) {
#line 576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 576 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_basic_properties (self);
#line 3500 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_BASIC_PROPERTIES, _tmp2_, &_inner_error_);
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3524 "ConfigurationInterfaces.c"
				goto __catch98_configuration_error;
			}
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 588 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3533 "ConfigurationInterfaces.c"
		}
	}
	goto __finally98;
	__catch98_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 590 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3551 "ConfigurationInterfaces.c"
	}
	__finally98:
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3562 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_basic_properties (ConfigurationFacade* self, gboolean display) {
#line 586 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 586 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_basic_properties (self, display);
#line 3572 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_extended_properties (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, &_inner_error_);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3601 "ConfigurationInterfaces.c"
				goto __catch99_configuration_error;
			}
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3610 "ConfigurationInterfaces.c"
		}
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3616 "ConfigurationInterfaces.c"
	}
	goto __finally99;
	__catch99_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 601 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 601 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 603 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3637 "ConfigurationInterfaces.c"
	}
	__finally99:
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 598 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3646 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_extended_properties (ConfigurationFacade* self) {
#line 597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 597 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_extended_properties (self);
#line 3655 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EXTENDED_PROPERTIES, _tmp2_, &_inner_error_);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3679 "ConfigurationInterfaces.c"
				goto __catch100_configuration_error;
			}
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 609 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3688 "ConfigurationInterfaces.c"
		}
	}
	goto __finally100;
	__catch100_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 612 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3706 "ConfigurationInterfaces.c"
	}
	__finally100:
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 608 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3717 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_extended_properties (ConfigurationFacade* self, gboolean display) {
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_extended_properties (self, display);
#line 3727 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_sidebar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, &_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3756 "ConfigurationInterfaces.c"
				goto __catch101_configuration_error;
			}
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3765 "ConfigurationInterfaces.c"
		}
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3771 "ConfigurationInterfaces.c"
	}
	goto __finally101;
	__catch101_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 623 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3792 "ConfigurationInterfaces.c"
	}
	__finally101:
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 620 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3801 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_sidebar (ConfigurationFacade* self) {
#line 619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 619 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_sidebar (self);
#line 3810 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SIDEBAR, _tmp2_, &_inner_error_);
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3834 "ConfigurationInterfaces.c"
				goto __catch102_configuration_error;
			}
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 631 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3843 "ConfigurationInterfaces.c"
		}
	}
	goto __finally102;
	__catch102_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 3861 "ConfigurationInterfaces.c"
	}
	__finally102:
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 3872 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_sidebar (ConfigurationFacade* self, gboolean display) {
#line 629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_sidebar (self, display);
#line 3882 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_toolbar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, &_inner_error_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3911 "ConfigurationInterfaces.c"
				goto __catch103_configuration_error;
			}
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 3920 "ConfigurationInterfaces.c"
		}
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3926 "ConfigurationInterfaces.c"
	}
	goto __finally103;
	__catch103_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 645 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 645 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 3947 "ConfigurationInterfaces.c"
	}
	__finally103:
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 3956 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_toolbar (ConfigurationFacade* self) {
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_toolbar (self);
#line 3965 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_TOOLBAR, _tmp2_, &_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 3989 "ConfigurationInterfaces.c"
				goto __catch104_configuration_error;
			}
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 3998 "ConfigurationInterfaces.c"
		}
	}
	goto __finally104;
	__catch104_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 655 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4016 "ConfigurationInterfaces.c"
	}
	__finally104:
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 652 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4027 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_toolbar (ConfigurationFacade* self, gboolean display) {
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 651 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_toolbar (self, display);
#line 4037 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_search_bar (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, &_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4066 "ConfigurationInterfaces.c"
				goto __catch105_configuration_error;
			}
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4075 "ConfigurationInterfaces.c"
		}
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4081 "ConfigurationInterfaces.c"
	}
	goto __finally105;
	__catch105_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 666 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 668 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4102 "ConfigurationInterfaces.c"
	}
	__finally105:
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 663 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4111 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_search_bar (ConfigurationFacade* self) {
#line 662 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 662 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_search_bar (self);
#line 4120 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_SEARCH_BAR, _tmp2_, &_inner_error_);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4144 "ConfigurationInterfaces.c"
				goto __catch106_configuration_error;
			}
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 674 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4153 "ConfigurationInterfaces.c"
		}
	}
	goto __finally106;
	__catch106_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 676 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4171 "ConfigurationInterfaces.c"
	}
	__finally106:
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 673 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4182 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_search_bar (ConfigurationFacade* self, gboolean display) {
#line 672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 672 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_search_bar (self, display);
#line 4192 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_ratings (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, &_inner_error_);
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4221 "ConfigurationInterfaces.c"
				goto __catch107_configuration_error;
			}
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4230 "ConfigurationInterfaces.c"
		}
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 685 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4236 "ConfigurationInterfaces.c"
	}
	goto __finally107;
	__catch107_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 687 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 689 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4257 "ConfigurationInterfaces.c"
	}
	__finally107:
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 684 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4266 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_ratings (ConfigurationFacade* self) {
#line 683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 683 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_ratings (self);
#line 4275 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_RATINGS, _tmp2_, &_inner_error_);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4299 "ConfigurationInterfaces.c"
				goto __catch108_configuration_error;
			}
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 695 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4308 "ConfigurationInterfaces.c"
		}
	}
	goto __finally108;
	__catch108_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 697 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4326 "ConfigurationInterfaces.c"
	}
	__finally108:
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 694 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4337 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_ratings (ConfigurationFacade* self, gboolean display) {
#line 693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 693 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_ratings (self, display);
#line 4347 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_tags (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, &_inner_error_);
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4376 "ConfigurationInterfaces.c"
				goto __catch109_configuration_error;
			}
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4385 "ConfigurationInterfaces.c"
		}
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 706 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4391 "ConfigurationInterfaces.c"
	}
	goto __finally109;
	__catch109_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 708 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 710 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4412 "ConfigurationInterfaces.c"
	}
	__finally109:
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 705 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4421 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_tags (ConfigurationFacade* self) {
#line 704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 704 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_tags (self);
#line 4430 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TAGS, _tmp2_, &_inner_error_);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4454 "ConfigurationInterfaces.c"
				goto __catch110_configuration_error;
			}
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 716 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4463 "ConfigurationInterfaces.c"
		}
	}
	goto __finally110;
	__catch110_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 718 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 718 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4481 "ConfigurationInterfaces.c"
	}
	__finally110:
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 715 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4492 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_tags (ConfigurationFacade* self, gboolean display) {
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 714 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_tags (self, display);
#line 4502 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, &_inner_error_);
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4531 "ConfigurationInterfaces.c"
				goto __catch111_configuration_error;
			}
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4540 "ConfigurationInterfaces.c"
		}
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 727 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4546 "ConfigurationInterfaces.c"
	}
	goto __finally111;
	__catch111_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 729 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 729 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 731 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4567 "ConfigurationInterfaces.c"
	}
	__finally111:
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 726 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4576 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_titles (ConfigurationFacade* self) {
#line 725 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 725 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_titles (self);
#line 4585 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_TITLES, _tmp2_, &_inner_error_);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4609 "ConfigurationInterfaces.c"
				goto __catch112_configuration_error;
			}
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 737 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4618 "ConfigurationInterfaces.c"
		}
	}
	goto __finally112;
	__catch112_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 739 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 739 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4636 "ConfigurationInterfaces.c"
	}
	__finally112:
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 736 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4647 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_titles (ConfigurationFacade* self, gboolean display) {
#line 735 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 735 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_titles (self, display);
#line 4657 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_photo_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, &_inner_error_);
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4686 "ConfigurationInterfaces.c"
				goto __catch113_configuration_error;
			}
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4695 "ConfigurationInterfaces.c"
		}
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 748 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4701 "ConfigurationInterfaces.c"
	}
	goto __finally113;
	__catch113_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 750 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 750 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 752 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4722 "ConfigurationInterfaces.c"
	}
	__finally113:
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 747 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4731 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_photo_comments (ConfigurationFacade* self) {
#line 746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 746 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_photo_comments (self);
#line 4740 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_PHOTO_COMMENTS, _tmp2_, &_inner_error_);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4764 "ConfigurationInterfaces.c"
				goto __catch114_configuration_error;
			}
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 758 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4773 "ConfigurationInterfaces.c"
		}
	}
	goto __finally114;
	__catch114_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 760 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4791 "ConfigurationInterfaces.c"
	}
	__finally114:
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 757 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4802 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_photo_comments (ConfigurationFacade* self, gboolean display) {
#line 756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 756 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_photo_comments (self, display);
#line 4812 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_display_event_comments (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, &_inner_error_);
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4841 "ConfigurationInterfaces.c"
				goto __catch115_configuration_error;
			}
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 4850 "ConfigurationInterfaces.c"
		}
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 769 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4856 "ConfigurationInterfaces.c"
	}
	goto __finally115;
	__catch115_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 771 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 773 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 4877 "ConfigurationInterfaces.c"
	}
	__finally115:
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 768 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 4886 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_display_event_comments (ConfigurationFacade* self) {
#line 767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 767 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_display_event_comments (self);
#line 4895 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = display;
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_DISPLAY_EVENT_COMMENTS, _tmp2_, &_inner_error_);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 4919 "ConfigurationInterfaces.c"
				goto __catch116_configuration_error;
			}
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 779 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 4928 "ConfigurationInterfaces.c"
		}
	}
	goto __finally116;
	__catch116_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 781 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 4946 "ConfigurationInterfaces.c"
	}
	__finally116:
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 778 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 4957 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_display_event_comments (ConfigurationFacade* self, gboolean display) {
#line 777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 777 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_display_event_comments (self, display);
#line 4967 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 789 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 790 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 4979 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_ = NULL;
		ConfigurationEngine* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5007 "ConfigurationInterfaces.c"
				goto __catch117_configuration_error;
			}
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5016 "ConfigurationInterfaces.c"
		}
#line 792 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, &_inner_error_);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5036 "ConfigurationInterfaces.c"
				goto __catch117_configuration_error;
			}
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5045 "ConfigurationInterfaces.c"
		}
#line 794 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 5049 "ConfigurationInterfaces.c"
	}
	goto __finally117;
	__catch117_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_ = NULL;
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 796 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5066 "ConfigurationInterfaces.c"
	}
	__finally117:
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 791 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5077 "ConfigurationInterfaces.c"
	}
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 5083 "ConfigurationInterfaces.c"
	}
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 5089 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_event_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 788 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_event_photos_sort (self, sort_order, sort_by);
#line 5099 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5126 "ConfigurationInterfaces.c"
				goto __catch118_configuration_error;
			}
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 802 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5135 "ConfigurationInterfaces.c"
		}
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_EVENT_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5151 "ConfigurationInterfaces.c"
				goto __catch118_configuration_error;
			}
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 804 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5160 "ConfigurationInterfaces.c"
		}
	}
	goto __finally118;
	__catch118_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 807 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 5178 "ConfigurationInterfaces.c"
	}
	__finally118:
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 801 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5189 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_event_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 800 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_event_photos_sort (self, sort_order, sort_by);
#line 5199 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_events_sort_ascending (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, &_inner_error_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5228 "ConfigurationInterfaces.c"
				goto __catch119_configuration_error;
			}
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 5237 "ConfigurationInterfaces.c"
		}
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 816 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5243 "ConfigurationInterfaces.c"
	}
	goto __finally119;
	__catch119_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 818 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 820 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5264 "ConfigurationInterfaces.c"
	}
	__finally119:
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 815 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 5273 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_events_sort_ascending (ConfigurationFacade* self) {
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 814 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_events_sort_ascending (self);
#line 5282 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort;
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_EVENTS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5306 "ConfigurationInterfaces.c"
				goto __catch120_configuration_error;
			}
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 826 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5315 "ConfigurationInterfaces.c"
		}
	}
	goto __finally120;
	__catch120_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 828 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 829 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5335 "ConfigurationInterfaces.c"
	}
	__finally120:
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 825 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5346 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_events_sort_ascending (ConfigurationFacade* self, gboolean sort) {
#line 824 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 824 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_events_sort_ascending (self, sort);
#line 5356 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_photo_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, &_inner_error_);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5386 "ConfigurationInterfaces.c"
				goto __catch121_configuration_error;
			}
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5395 "ConfigurationInterfaces.c"
		}
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 838 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5407 "ConfigurationInterfaces.c"
	}
	goto __finally121;
	__catch121_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 840 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 842 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5431 "ConfigurationInterfaces.c"
	}
	__finally121:
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 837 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5440 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self) {
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 836 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_photo_app (self);
#line 5449 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
	GError * _inner_error_ = NULL;
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_photo_app != NULL);
#line 5457 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_photo_app;
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_PHOTO_APP, _tmp2_, &_inner_error_);
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5476 "ConfigurationInterfaces.c"
				goto __catch122_configuration_error;
			}
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 848 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5485 "ConfigurationInterfaces.c"
		}
	}
	goto __finally122;
	__catch122_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 851 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 851 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 852 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5505 "ConfigurationInterfaces.c"
	}
	__finally122:
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5516 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_photo_app (ConfigurationFacade* self, const gchar* external_photo_app) {
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 846 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_photo_app (self, external_photo_app);
#line 5526 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_external_raw_app (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, &_inner_error_);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5556 "ConfigurationInterfaces.c"
				goto __catch123_configuration_error;
			}
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 5565 "ConfigurationInterfaces.c"
		}
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 861 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5577 "ConfigurationInterfaces.c"
	}
	goto __finally123;
	__catch123_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 863 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 865 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5601 "ConfigurationInterfaces.c"
	}
	__finally123:
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 860 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 5610 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self) {
#line 859 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 859 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_external_raw_app (self);
#line 5619 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
	GError * _inner_error_ = NULL;
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (external_raw_app != NULL);
#line 5627 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = external_raw_app;
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_EXTERNAL_RAW_APP, _tmp2_, &_inner_error_);
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5646 "ConfigurationInterfaces.c"
				goto __catch124_configuration_error;
			}
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 871 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5655 "ConfigurationInterfaces.c"
		}
	}
	goto __finally124;
	__catch124_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 874 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 875 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5675 "ConfigurationInterfaces.c"
	}
	__finally124:
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 870 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5686 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_external_raw_app (ConfigurationFacade* self, const gchar* external_raw_app) {
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 869 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_external_raw_app (self, external_raw_app);
#line 5696 "ConfigurationInterfaces.c"
}


static RawDeveloper configuration_facade_real_get_default_raw_developer (ConfigurationFacade* self) {
	RawDeveloper result = 0;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		RawDeveloper _tmp5_ = 0;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, &_inner_error_);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5726 "ConfigurationInterfaces.c"
				goto __catch125_configuration_error;
			}
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 5735 "ConfigurationInterfaces.c"
		}
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = raw_developer_from_string (_tmp0_);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 884 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5745 "ConfigurationInterfaces.c"
	}
	goto __finally125;
	__catch125_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 887 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 889 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = RAW_DEVELOPER_CAMERA;
#line 889 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 889 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5766 "ConfigurationInterfaces.c"
	}
	__finally125:
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 883 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 5775 "ConfigurationInterfaces.c"
}


RawDeveloper configuration_facade_get_default_raw_developer (ConfigurationFacade* self) {
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 882 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_default_raw_developer (self);
#line 5784 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		RawDeveloper _tmp2_ = 0;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = d;
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = raw_developer_to_string (_tmp2_);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_RAW_DEVELOPER_DEFAULT, _tmp4_, &_inner_error_);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp4_);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5816 "ConfigurationInterfaces.c"
				goto __catch126_configuration_error;
			}
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 895 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5825 "ConfigurationInterfaces.c"
		}
	}
	goto __finally126;
	__catch126_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 898 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 899 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 899 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5845 "ConfigurationInterfaces.c"
	}
	__finally126:
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 894 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 5856 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_default_raw_developer (ConfigurationFacade* self, RawDeveloper d) {
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 893 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_default_raw_developer (self, d);
#line 5866 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_hide_photos_already_imported (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, &_inner_error_);
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5895 "ConfigurationInterfaces.c"
				goto __catch127_configuration_error;
			}
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 5904 "ConfigurationInterfaces.c"
		}
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 908 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5910 "ConfigurationInterfaces.c"
	}
	goto __finally127;
	__catch127_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 910 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 912 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 5931 "ConfigurationInterfaces.c"
	}
	__finally127:
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 907 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 5940 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_hide_photos_already_imported (ConfigurationFacade* self) {
#line 906 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 906 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_hide_photos_already_imported (self);
#line 5949 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = hide_imported;
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_HIDE_PHOTOS_ALREADY_IMPORTED, _tmp2_, &_inner_error_);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 5973 "ConfigurationInterfaces.c"
				goto __catch128_configuration_error;
			}
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 918 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 5982 "ConfigurationInterfaces.c"
		}
	}
	goto __finally128;
	__catch128_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 920 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6000 "ConfigurationInterfaces.c"
	}
	__finally128:
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 917 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6011 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_hide_photos_already_imported (ConfigurationFacade* self, gboolean hide_imported) {
#line 916 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 916 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_hide_photos_already_imported (self, hide_imported);
#line 6021 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_import_dir (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_IMPORT_DIR, &_inner_error_);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6051 "ConfigurationInterfaces.c"
				goto __catch129_configuration_error;
			}
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 6060 "ConfigurationInterfaces.c"
		}
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 929 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6072 "ConfigurationInterfaces.c"
	}
	goto __finally129;
	__catch129_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 931 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 933 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6096 "ConfigurationInterfaces.c"
	}
	__finally129:
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 928 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 6105 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_import_dir (ConfigurationFacade* self) {
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 927 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_import_dir (self);
#line 6114 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
	GError * _inner_error_ = NULL;
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (import_dir != NULL);
#line 6122 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = import_dir;
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_IMPORT_DIR, _tmp2_, &_inner_error_);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6141 "ConfigurationInterfaces.c"
				goto __catch130_configuration_error;
			}
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 939 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6150 "ConfigurationInterfaces.c"
		}
	}
	goto __finally130;
	__catch130_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 941 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 941 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6168 "ConfigurationInterfaces.c"
	}
	__finally130:
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 938 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6179 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_import_dir (ConfigurationFacade* self, const gchar* import_dir) {
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 937 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_import_dir (self, import_dir);
#line 6189 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_keep_relativity (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, &_inner_error_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6218 "ConfigurationInterfaces.c"
				goto __catch131_configuration_error;
			}
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 6227 "ConfigurationInterfaces.c"
		}
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 950 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6233 "ConfigurationInterfaces.c"
	}
	goto __finally131;
	__catch131_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 952 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 954 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6254 "ConfigurationInterfaces.c"
	}
	__finally131:
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 949 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 6263 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_keep_relativity (ConfigurationFacade* self) {
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 948 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_keep_relativity (self);
#line 6272 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = keep_relativity;
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_KEEP_RELATIVITY, _tmp2_, &_inner_error_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6296 "ConfigurationInterfaces.c"
				goto __catch132_configuration_error;
			}
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 960 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6305 "ConfigurationInterfaces.c"
		}
	}
	goto __finally132;
	__catch132_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 962 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 962 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6323 "ConfigurationInterfaces.c"
	}
	__finally132:
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 959 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6334 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_keep_relativity (ConfigurationFacade* self, gboolean keep_relativity) {
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 958 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_keep_relativity (self, keep_relativity);
#line 6344 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_pin_toolbar_state (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, &_inner_error_);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6373 "ConfigurationInterfaces.c"
				goto __catch133_configuration_error;
			}
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 6382 "ConfigurationInterfaces.c"
		}
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 971 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6388 "ConfigurationInterfaces.c"
	}
	goto __finally133;
	__catch133_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 973 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 974 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6409 "ConfigurationInterfaces.c"
	}
	__finally133:
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 970 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 6418 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_pin_toolbar_state (ConfigurationFacade* self) {
#line 969 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 969 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_pin_toolbar_state (self);
#line 6427 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state;
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PIN_TOOLBAR_STATE, _tmp2_, &_inner_error_);
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6451 "ConfigurationInterfaces.c"
				goto __catch134_configuration_error;
			}
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 980 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6460 "ConfigurationInterfaces.c"
		}
	}
	goto __finally134;
	__catch134_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 982 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6478 "ConfigurationInterfaces.c"
	}
	__finally134:
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 979 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6489 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_pin_toolbar_state (ConfigurationFacade* self, gboolean state) {
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 978 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_pin_toolbar_state (self, state);
#line 6499 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_height (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, &_inner_error_);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6528 "ConfigurationInterfaces.c"
				goto __catch135_configuration_error;
			}
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6537 "ConfigurationInterfaces.c"
		}
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 991 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6543 "ConfigurationInterfaces.c"
	}
	goto __finally135;
	__catch135_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 993 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 993 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 994 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 994 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 994 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6564 "ConfigurationInterfaces.c"
	}
	__finally135:
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 990 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6573 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_height (ConfigurationFacade* self) {
#line 989 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 989 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_height (self);
#line 6582 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_height (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_HEIGHT, _tmp2_, &_inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6606 "ConfigurationInterfaces.c"
				goto __catch136_configuration_error;
			}
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1000 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6615 "ConfigurationInterfaces.c"
		}
	}
	goto __finally136;
	__catch136_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1002 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6633 "ConfigurationInterfaces.c"
	}
	__finally136:
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 999 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6644 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_height (ConfigurationFacade* self, gint choice) {
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 998 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_height (self, choice);
#line 6654 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_menu_choice (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, &_inner_error_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6683 "ConfigurationInterfaces.c"
				goto __catch137_configuration_error;
			}
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6692 "ConfigurationInterfaces.c"
		}
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1011 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6698 "ConfigurationInterfaces.c"
	}
	goto __finally137;
	__catch137_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1013 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1018 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6719 "ConfigurationInterfaces.c"
	}
	__finally137:
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1010 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6728 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_menu_choice (ConfigurationFacade* self) {
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1009 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_menu_choice (self);
#line 6737 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_MENU_CHOICE, _tmp2_, &_inner_error_);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6761 "ConfigurationInterfaces.c"
				goto __catch138_configuration_error;
			}
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1024 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6770 "ConfigurationInterfaces.c"
		}
	}
	goto __finally138;
	__catch138_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1026 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1026 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6788 "ConfigurationInterfaces.c"
	}
	__finally138:
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1023 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6799 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_menu_choice (ConfigurationFacade* self, gint choice) {
#line 1022 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1022 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_menu_choice (self, choice);
#line 6809 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_last_crop_width (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, &_inner_error_);
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6838 "ConfigurationInterfaces.c"
				goto __catch139_configuration_error;
			}
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 6847 "ConfigurationInterfaces.c"
		}
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1035 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6853 "ConfigurationInterfaces.c"
	}
	goto __finally139;
	__catch139_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1037 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1037 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 1;
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1038 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 6874 "ConfigurationInterfaces.c"
	}
	__finally139:
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1034 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 6883 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_last_crop_width (ConfigurationFacade* self) {
#line 1033 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1033 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_crop_width (self);
#line 6892 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_crop_width (ConfigurationFacade* self, gint choice) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = choice;
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_CROP_WIDTH, _tmp2_, &_inner_error_);
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6916 "ConfigurationInterfaces.c"
				goto __catch140_configuration_error;
			}
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1044 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 6925 "ConfigurationInterfaces.c"
		}
	}
	goto __finally140;
	__catch140_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1046 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1046 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 6943 "ConfigurationInterfaces.c"
	}
	__finally140:
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1043 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 6954 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_crop_width (ConfigurationFacade* self, gint choice) {
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1042 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_crop_width (self, choice);
#line 6964 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, &_inner_error_);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 6994 "ConfigurationInterfaces.c"
				goto __catch141_configuration_error;
			}
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 7003 "ConfigurationInterfaces.c"
		}
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1055 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7015 "ConfigurationInterfaces.c"
	}
	goto __finally141;
	__catch141_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1057 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1057 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1062 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7039 "ConfigurationInterfaces.c"
	}
	__finally141:
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1054 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 7048 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_service (ConfigurationFacade* self) {
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1053 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_service (self);
#line 7057 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 7065 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_SERVICE, _tmp2_, &_inner_error_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7084 "ConfigurationInterfaces.c"
				goto __catch142_configuration_error;
			}
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1068 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7093 "ConfigurationInterfaces.c"
		}
	}
	goto __finally142;
	__catch142_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1070 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1070 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7111 "ConfigurationInterfaces.c"
	}
	__finally142:
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1067 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7122 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1066 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_service (self, service_name);
#line 7132 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_last_used_dataimports_service (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, &_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7162 "ConfigurationInterfaces.c"
				goto __catch143_configuration_error;
			}
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 7171 "ConfigurationInterfaces.c"
		}
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1079 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7183 "ConfigurationInterfaces.c"
	}
	goto __finally143;
	__catch143_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1081 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1086 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("");
#line 1086 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1086 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1086 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7207 "ConfigurationInterfaces.c"
	}
	__finally143:
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1078 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 7216 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_last_used_dataimports_service (ConfigurationFacade* self) {
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1077 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_last_used_dataimports_service (self);
#line 7225 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
	GError * _inner_error_ = NULL;
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (service_name != NULL);
#line 7233 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = service_name;
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_LAST_USED_DATAIMPORTS_SERVICE, _tmp2_, &_inner_error_);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7252 "ConfigurationInterfaces.c"
				goto __catch144_configuration_error;
			}
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1092 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7261 "ConfigurationInterfaces.c"
		}
	}
	goto __finally144;
	__catch144_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1094 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7279 "ConfigurationInterfaces.c"
	}
	__finally144:
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1091 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7290 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_last_used_dataimports_service (ConfigurationFacade* self, const gchar* service_name) {
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1090 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_last_used_dataimports_service (self, service_name);
#line 7300 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
	gboolean _vala_sort_order = FALSE;
	gint _vala_sort_by = 0;
	GError * _inner_error_ = NULL;
#line 1102 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_order = FALSE;
#line 1103 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_sort_by = 2;
#line 7312 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		ConfigurationEngine* _tmp6_ = NULL;
		ConfigurationEngine* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, &_inner_error_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7340 "ConfigurationInterfaces.c"
				goto __catch145_configuration_error;
			}
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7349 "ConfigurationInterfaces.c"
		}
#line 1105 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_order = _tmp0_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = configuration_facade_get_engine (self);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = configuration_engine_get_int_property (_tmp7_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, &_inner_error_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = _tmp8_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp7_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp9_;
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7369 "ConfigurationInterfaces.c"
				goto __catch145_configuration_error;
			}
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7378 "ConfigurationInterfaces.c"
		}
#line 1107 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_sort_by = _tmp5_;
#line 7382 "ConfigurationInterfaces.c"
	}
	goto __finally145;
	__catch145_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp10_ = NULL;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1109 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = err;
#line 1109 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp10_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7399 "ConfigurationInterfaces.c"
	}
	__finally145:
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1104 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7410 "ConfigurationInterfaces.c"
	}
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_order) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_order = _vala_sort_order;
#line 7416 "ConfigurationInterfaces.c"
	}
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (sort_by) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*sort_by = _vala_sort_by;
#line 7422 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_photos_sort (ConfigurationFacade* self, gboolean* sort_order, gint* sort_by) {
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1101 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_photos_sort (self, sort_order, sort_by);
#line 7432 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		gint _tmp5_ = 0;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = sort_order;
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_ASCENDING, _tmp2_, &_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7459 "ConfigurationInterfaces.c"
				goto __catch146_configuration_error;
			}
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1115 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7468 "ConfigurationInterfaces.c"
		}
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = sort_by;
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_PHOTOS_SORT_BY, _tmp5_, &_inner_error_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7484 "ConfigurationInterfaces.c"
				goto __catch146_configuration_error;
			}
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1117 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7493 "ConfigurationInterfaces.c"
		}
	}
	goto __finally146;
	__catch146_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1120 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7511 "ConfigurationInterfaces.c"
	}
	__finally146:
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1114 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7522 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_photos_sort (ConfigurationFacade* self, gboolean sort_order, gint sort_by) {
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1113 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_photos_sort (self, sort_order, sort_by);
#line 7532 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
	gboolean _vala_maximize = FALSE;
	Dimensions _vala_dimensions = {0};
	GError * _inner_error_ = NULL;
#line 1128 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_vala_maximize = FALSE;
#line 1129 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	dimensions_init (&_vala_dimensions, 1024, 768);
#line 7544 "ConfigurationInterfaces.c"
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gint w = 0;
		ConfigurationEngine* _tmp5_ = NULL;
		ConfigurationEngine* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint h = 0;
		ConfigurationEngine* _tmp9_ = NULL;
		ConfigurationEngine* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, &_inner_error_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7579 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7588 "ConfigurationInterfaces.c"
		}
#line 1131 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_vala_maximize = _tmp0_;
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = configuration_facade_get_engine (self);
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_;
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_engine_get_int_property (_tmp6_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, &_inner_error_);
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp6_);
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		w = _tmp8_;
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7608 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1132 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7617 "ConfigurationInterfaces.c"
		}
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = configuration_facade_get_engine (self);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = configuration_engine_get_int_property (_tmp10_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, &_inner_error_);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp12_ = _tmp11_;
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp10_);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		h = _tmp12_;
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7635 "ConfigurationInterfaces.c"
				goto __catch147_configuration_error;
			}
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1133 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7644 "ConfigurationInterfaces.c"
		}
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp13_ = w;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp14_ = h;
#line 1134 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		dimensions_init (&_vala_dimensions, _tmp13_, _tmp14_);
#line 7652 "ConfigurationInterfaces.c"
	}
	goto __finally147;
	__catch147_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp15_ = NULL;
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1136 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp15_ = err;
#line 1136 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp15_);
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7669 "ConfigurationInterfaces.c"
	}
	__finally147:
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1130 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7680 "ConfigurationInterfaces.c"
	}
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (maximize) {
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*maximize = _vala_maximize;
#line 7686 "ConfigurationInterfaces.c"
	}
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (dimensions) {
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		*dimensions = _vala_dimensions;
#line 7692 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_get_library_window_state (ConfigurationFacade* self, gboolean* maximize, Dimensions* dimensions) {
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1127 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->get_library_window_state (self, maximize, dimensions);
#line 7702 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
	GError * _inner_error_ = NULL;
#line 1140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (dimensions != NULL);
#line 7710 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		ConfigurationEngine* _tmp3_ = NULL;
		ConfigurationEngine* _tmp4_ = NULL;
		Dimensions _tmp5_ = {0};
		gint _tmp6_ = 0;
		ConfigurationEngine* _tmp7_ = NULL;
		ConfigurationEngine* _tmp8_ = NULL;
		Dimensions _tmp9_ = {0};
		gint _tmp10_ = 0;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = maximize;
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_MAXIMIZE, _tmp2_, &_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7737 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1142 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7746 "ConfigurationInterfaces.c"
		}
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_facade_get_engine (self);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = *dimensions;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = _tmp5_.width;
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp4_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_WIDTH, _tmp6_, &_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp4_);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7764 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1143 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7773 "ConfigurationInterfaces.c"
		}
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = configuration_facade_get_engine (self);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = *dimensions;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_.height;
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp8_, CONFIGURABLE_PROPERTY_LIBRARY_WINDOW_HEIGHT, _tmp10_, &_inner_error_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp8_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7791 "ConfigurationInterfaces.c"
				goto __catch148_configuration_error;
			}
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1145 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7800 "ConfigurationInterfaces.c"
		}
	}
	goto __finally148;
	__catch148_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp11_ = NULL;
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1148 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp11_ = err;
#line 1148 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp11_);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7818 "ConfigurationInterfaces.c"
	}
	__finally148:
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1141 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7829 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_library_window_state (ConfigurationFacade* self, gboolean maximize, Dimensions* dimensions) {
#line 1140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1140 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_library_window_state (self, maximize, dimensions);
#line 7839 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_modify_originals (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, &_inner_error_);
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7868 "ConfigurationInterfaces.c"
				goto __catch149_configuration_error;
			}
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 7877 "ConfigurationInterfaces.c"
		}
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1157 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7883 "ConfigurationInterfaces.c"
	}
	goto __finally149;
	__catch149_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1159 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1162 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 7904 "ConfigurationInterfaces.c"
	}
	__finally149:
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1156 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 7913 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_modify_originals (ConfigurationFacade* self) {
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1155 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_modify_originals (self);
#line 7922 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = modify_originals;
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_MODIFY_ORIGINALS, _tmp2_, &_inner_error_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 7946 "ConfigurationInterfaces.c"
				goto __catch150_configuration_error;
			}
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1168 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 7955 "ConfigurationInterfaces.c"
		}
	}
	goto __finally150;
	__catch150_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1170 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 7973 "ConfigurationInterfaces.c"
	}
	__finally150:
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1167 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 7984 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_modify_originals (ConfigurationFacade* self, gboolean modify_originals) {
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1166 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_modify_originals (self, modify_originals);
#line 7994 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_photo_thumbnail_scale (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, &_inner_error_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8023 "ConfigurationInterfaces.c"
				goto __catch151_configuration_error;
			}
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8032 "ConfigurationInterfaces.c"
		}
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1179 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8038 "ConfigurationInterfaces.c"
	}
	goto __finally151;
	__catch151_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1181 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = thumbnail_get_DEFAULT_SCALE ();
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = _tmp6_;
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1182 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8065 "ConfigurationInterfaces.c"
	}
	__finally151:
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1178 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8074 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_photo_thumbnail_scale (ConfigurationFacade* self) {
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1177 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_photo_thumbnail_scale (self);
#line 8083 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = scale;
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PHOTO_THUMBNAIL_SCALE, _tmp2_, &_inner_error_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8107 "ConfigurationInterfaces.c"
				goto __catch152_configuration_error;
			}
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1188 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8116 "ConfigurationInterfaces.c"
		}
	}
	goto __finally152;
	__catch152_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1190 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1190 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8134 "ConfigurationInterfaces.c"
	}
	__finally152:
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1187 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8145 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_photo_thumbnail_scale (ConfigurationFacade* self, gint scale) {
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1186 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_photo_thumbnail_scale (self, scale);
#line 8155 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_height (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, &_inner_error_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8184 "ConfigurationInterfaces.c"
				goto __catch153_configuration_error;
			}
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 8193 "ConfigurationInterfaces.c"
		}
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1199 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8199 "ConfigurationInterfaces.c"
	}
	goto __finally153;
	__catch153_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1201 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 5.0;
#line 1203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1203 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8220 "ConfigurationInterfaces.c"
	}
	__finally153:
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1198 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 8229 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_height (ConfigurationFacade* self) {
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1197 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_height (self);
#line 8238 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_height;
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_HEIGHT, _tmp2_, &_inner_error_);
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8262 "ConfigurationInterfaces.c"
				goto __catch154_configuration_error;
			}
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1209 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8271 "ConfigurationInterfaces.c"
		}
	}
	goto __finally154;
	__catch154_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1212 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8289 "ConfigurationInterfaces.c"
	}
	__finally154:
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1208 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8300 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_height (ConfigurationFacade* self, gdouble content_height) {
#line 1207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1207 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_height (self, content_height);
#line 8310 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_layout (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, &_inner_error_);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8339 "ConfigurationInterfaces.c"
				goto __catch155_configuration_error;
			}
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8348 "ConfigurationInterfaces.c"
		}
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1221 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8354 "ConfigurationInterfaces.c"
	}
	goto __finally155;
	__catch155_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1220 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1220 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1223 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1225 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8375 "ConfigurationInterfaces.c"
	}
	__finally155:
#line 1220 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1220 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1220 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8384 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_layout (ConfigurationFacade* self) {
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1219 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_layout (self);
#line 8393 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = layout_code;
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_LAYOUT, _tmp2_ + 1, &_inner_error_);
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8417 "ConfigurationInterfaces.c"
				goto __catch156_configuration_error;
			}
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1231 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8426 "ConfigurationInterfaces.c"
		}
	}
	goto __finally156;
	__catch156_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1234 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8444 "ConfigurationInterfaces.c"
	}
	__finally156:
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1230 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8455 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_layout (ConfigurationFacade* self, gint layout_code) {
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1229 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_layout (self, layout_code);
#line 8465 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_ppi (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, &_inner_error_);
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8494 "ConfigurationInterfaces.c"
				goto __catch157_configuration_error;
			}
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8503 "ConfigurationInterfaces.c"
		}
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1243 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8509 "ConfigurationInterfaces.c"
	}
	goto __finally157;
	__catch157_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1245 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 600;
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1247 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8530 "ConfigurationInterfaces.c"
	}
	__finally157:
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1242 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8539 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_ppi (ConfigurationFacade* self) {
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1241 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_ppi (self);
#line 8548 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_ppi;
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_PPI, _tmp2_, &_inner_error_);
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8572 "ConfigurationInterfaces.c"
				goto __catch158_configuration_error;
			}
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1253 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8581 "ConfigurationInterfaces.c"
		}
	}
	goto __finally158;
	__catch158_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1255 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8599 "ConfigurationInterfaces.c"
	}
	__finally158:
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1252 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8610 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_ppi (ConfigurationFacade* self, gint content_ppi) {
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1251 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_ppi (self, content_ppi);
#line 8620 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_content_units (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, &_inner_error_);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8649 "ConfigurationInterfaces.c"
				goto __catch159_configuration_error;
			}
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8658 "ConfigurationInterfaces.c"
		}
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1264 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8664 "ConfigurationInterfaces.c"
	}
	goto __finally159;
	__catch159_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1266 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1268 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8685 "ConfigurationInterfaces.c"
	}
	__finally159:
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1263 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 8694 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_content_units (ConfigurationFacade* self) {
#line 1262 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1262 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_units (self);
#line 8703 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = units_code;
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_UNITS, _tmp2_ + 1, &_inner_error_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8727 "ConfigurationInterfaces.c"
				goto __catch160_configuration_error;
			}
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1274 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8736 "ConfigurationInterfaces.c"
		}
	}
	goto __finally160;
	__catch160_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1277 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8754 "ConfigurationInterfaces.c"
	}
	__finally160:
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1273 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8765 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_units (ConfigurationFacade* self, gint units_code) {
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1272 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_units (self, units_code);
#line 8775 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_printing_content_width (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, &_inner_error_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8804 "ConfigurationInterfaces.c"
				goto __catch161_configuration_error;
			}
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 8813 "ConfigurationInterfaces.c"
		}
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1286 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8819 "ConfigurationInterfaces.c"
	}
	goto __finally161;
	__catch161_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1288 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 7.0;
#line 1290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1290 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8840 "ConfigurationInterfaces.c"
	}
	__finally161:
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1285 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 8849 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_printing_content_width (ConfigurationFacade* self) {
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1284 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_content_width (self);
#line 8858 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = content_width;
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_CONTENT_WIDTH, _tmp2_, &_inner_error_);
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8882 "ConfigurationInterfaces.c"
				goto __catch162_configuration_error;
			}
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1296 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 8891 "ConfigurationInterfaces.c"
		}
	}
	goto __finally162;
	__catch162_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1299 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 8909 "ConfigurationInterfaces.c"
	}
	__finally162:
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1295 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 8920 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_content_width (ConfigurationFacade* self, gdouble content_width) {
#line 1294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1294 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_content_width (self, content_width);
#line 8930 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_images_per_page (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, &_inner_error_);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 8959 "ConfigurationInterfaces.c"
				goto __catch163_configuration_error;
			}
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 8968 "ConfigurationInterfaces.c"
		}
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1308 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8974 "ConfigurationInterfaces.c"
	}
	goto __finally163;
	__catch163_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1310 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1312 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 8995 "ConfigurationInterfaces.c"
	}
	__finally163:
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1307 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 9004 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_images_per_page (ConfigurationFacade* self) {
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1306 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_images_per_page (self);
#line 9013 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = images_per_page_code;
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_IMAGES_PER_PAGE, _tmp2_ + 1, &_inner_error_);
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9037 "ConfigurationInterfaces.c"
				goto __catch164_configuration_error;
			}
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9046 "ConfigurationInterfaces.c"
		}
	}
	goto __finally164;
	__catch164_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1321 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9064 "ConfigurationInterfaces.c"
	}
	__finally164:
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1317 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9075 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_images_per_page (ConfigurationFacade* self, gint images_per_page_code) {
#line 1316 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1316 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_images_per_page (self, images_per_page_code);
#line 9085 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, &_inner_error_);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9114 "ConfigurationInterfaces.c"
				goto __catch165_configuration_error;
			}
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 9123 "ConfigurationInterfaces.c"
		}
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1330 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9129 "ConfigurationInterfaces.c"
	}
	goto __finally165;
	__catch165_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1332 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1334 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9150 "ConfigurationInterfaces.c"
	}
	__finally165:
#line 1329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1329 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 9159 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_match_aspect_ratio (ConfigurationFacade* self) {
#line 1328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1328 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_match_aspect_ratio (self);
#line 9168 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = match_aspect_ratio;
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_MATCH_ASPECT_RATIO, _tmp2_, &_inner_error_);
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9192 "ConfigurationInterfaces.c"
				goto __catch166_configuration_error;
			}
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1340 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9201 "ConfigurationInterfaces.c"
		}
	}
	goto __finally166;
	__catch166_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1343 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9219 "ConfigurationInterfaces.c"
	}
	__finally166:
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1339 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9230 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_match_aspect_ratio (ConfigurationFacade* self, gboolean match_aspect_ratio) {
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1338 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_match_aspect_ratio (self, match_aspect_ratio);
#line 9240 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_printing_print_titles (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, &_inner_error_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9269 "ConfigurationInterfaces.c"
				goto __catch167_configuration_error;
			}
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 9278 "ConfigurationInterfaces.c"
		}
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1352 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9284 "ConfigurationInterfaces.c"
	}
	goto __finally167;
	__catch167_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1354 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1354 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1356 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9305 "ConfigurationInterfaces.c"
	}
	__finally167:
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1351 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 9314 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_printing_print_titles (ConfigurationFacade* self) {
#line 1350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1350 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_print_titles (self);
#line 9323 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = print_titles;
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_PRINT_TITLES, _tmp2_, &_inner_error_);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9347 "ConfigurationInterfaces.c"
				goto __catch168_configuration_error;
			}
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1362 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9356 "ConfigurationInterfaces.c"
		}
	}
	goto __finally168;
	__catch168_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1365 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9374 "ConfigurationInterfaces.c"
	}
	__finally168:
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1361 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9385 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_print_titles (ConfigurationFacade* self, gboolean print_titles) {
#line 1360 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1360 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_print_titles (self, print_titles);
#line 9395 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_printing_size_selection (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, &_inner_error_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9424 "ConfigurationInterfaces.c"
				goto __catch169_configuration_error;
			}
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 9433 "ConfigurationInterfaces.c"
		}
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_ - 1;
#line 1374 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9439 "ConfigurationInterfaces.c"
	}
	goto __finally169;
	__catch169_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1376 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0;
#line 1378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1378 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9460 "ConfigurationInterfaces.c"
	}
	__finally169:
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1373 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 9469 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_printing_size_selection (ConfigurationFacade* self) {
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1372 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_size_selection (self);
#line 9478 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = size_code;
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_SIZE_SELECTION, _tmp2_ + 1, &_inner_error_);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9502 "ConfigurationInterfaces.c"
				goto __catch170_configuration_error;
			}
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1384 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9511 "ConfigurationInterfaces.c"
		}
	}
	goto __finally170;
	__catch170_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1387 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9529 "ConfigurationInterfaces.c"
	}
	__finally170:
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1383 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9540 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_size_selection (ConfigurationFacade* self, gint size_code) {
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1382 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_size_selection (self, size_code);
#line 9550 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_printing_titles_font (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, &_inner_error_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9580 "ConfigurationInterfaces.c"
				goto __catch171_configuration_error;
			}
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 9589 "ConfigurationInterfaces.c"
		}
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1396 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9601 "ConfigurationInterfaces.c"
	}
	goto __finally171;
	__catch171_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1398 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup ("Sans Bold 12");
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1402 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9625 "ConfigurationInterfaces.c"
	}
	__finally171:
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1395 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 9634 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_printing_titles_font (ConfigurationFacade* self) {
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1394 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_printing_titles_font (self);
#line 9643 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
	GError * _inner_error_ = NULL;
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (font_name != NULL);
#line 9651 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = font_name;
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_PRINTING_TITLES_FONT, _tmp2_, &_inner_error_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9670 "ConfigurationInterfaces.c"
				goto __catch172_configuration_error;
			}
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1408 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9679 "ConfigurationInterfaces.c"
		}
	}
	goto __finally172;
	__catch172_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1410 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9697 "ConfigurationInterfaces.c"
	}
	__finally172:
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1407 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9708 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_printing_titles_font (ConfigurationFacade* self, const gchar* font_name) {
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1406 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_printing_titles_font (self, font_name);
#line 9718 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_show_welcome_dialog (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, &_inner_error_);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9747 "ConfigurationInterfaces.c"
				goto __catch173_configuration_error;
			}
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 9756 "ConfigurationInterfaces.c"
		}
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1419 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9762 "ConfigurationInterfaces.c"
	}
	goto __finally173;
	__catch173_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1421 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = TRUE;
#line 1423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1423 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9783 "ConfigurationInterfaces.c"
	}
	__finally173:
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1418 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 9792 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_show_welcome_dialog (ConfigurationFacade* self) {
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1417 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_show_welcome_dialog (self);
#line 9801 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show;
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SHOW_WELCOME_DIALOG, _tmp2_, &_inner_error_);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9825 "ConfigurationInterfaces.c"
				goto __catch174_configuration_error;
			}
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1429 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9834 "ConfigurationInterfaces.c"
		}
	}
	goto __finally174;
	__catch174_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1432 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 9852 "ConfigurationInterfaces.c"
	}
	__finally174:
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1428 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 9863 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_show_welcome_dialog (ConfigurationFacade* self, gboolean show) {
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1427 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_show_welcome_dialog (self, show);
#line 9873 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_sidebar_position (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, &_inner_error_);
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9902 "ConfigurationInterfaces.c"
				goto __catch175_configuration_error;
			}
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 9911 "ConfigurationInterfaces.c"
		}
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1441 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9917 "ConfigurationInterfaces.c"
	}
	goto __finally175;
	__catch175_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1443 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 180;
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1445 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 9938 "ConfigurationInterfaces.c"
	}
	__finally175:
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1440 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 9947 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_sidebar_position (ConfigurationFacade* self) {
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1439 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_sidebar_position (self);
#line 9956 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_sidebar_position (ConfigurationFacade* self, gint position) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = position;
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_SIDEBAR_POSITION, _tmp2_, &_inner_error_);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 9980 "ConfigurationInterfaces.c"
				goto __catch176_configuration_error;
			}
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1451 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 9989 "ConfigurationInterfaces.c"
		}
	}
	goto __finally176;
	__catch176_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1453 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1453 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10007 "ConfigurationInterfaces.c"
	}
	__finally176:
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1450 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10018 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_sidebar_position (ConfigurationFacade* self, gint position) {
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1449 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_sidebar_position (self, position);
#line 10028 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, &_inner_error_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10057 "ConfigurationInterfaces.c"
				goto __catch177_configuration_error;
			}
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 10066 "ConfigurationInterfaces.c"
		}
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1462 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10072 "ConfigurationInterfaces.c"
	}
	goto __finally177;
	__catch177_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1464 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 3.0;
#line 1466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1466 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10093 "ConfigurationInterfaces.c"
	}
	__finally177:
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1461 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 10102 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_delay (ConfigurationFacade* self) {
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1460 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_delay (self);
#line 10111 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_DELAY, _tmp2_, &_inner_error_);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10135 "ConfigurationInterfaces.c"
				goto __catch178_configuration_error;
			}
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1472 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10144 "ConfigurationInterfaces.c"
		}
	}
	goto __finally178;
	__catch178_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1474 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10162 "ConfigurationInterfaces.c"
	}
	__finally178:
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1471 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10173 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_delay (ConfigurationFacade* self, gdouble delay) {
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1470 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_delay (self, delay);
#line 10183 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_slideshow_transition_delay (ConfigurationFacade* self) {
	gdouble result = 0.0;
	GError * _inner_error_ = NULL;
	{
		gdouble _tmp0_ = 0.0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_double_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, &_inner_error_);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10212 "ConfigurationInterfaces.c"
				goto __catch179_configuration_error;
			}
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0.0;
#line 10221 "ConfigurationInterfaces.c"
		}
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1483 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10227 "ConfigurationInterfaces.c"
	}
	goto __finally179;
	__catch179_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1486 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = 0.3;
#line 1488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1488 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10248 "ConfigurationInterfaces.c"
	}
	__finally179:
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1482 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0.0;
#line 10257 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_slideshow_transition_delay (ConfigurationFacade* self) {
#line 1481 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1481 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_delay (self);
#line 10266 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = delay;
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_double_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_DELAY, _tmp2_, &_inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10290 "ConfigurationInterfaces.c"
				goto __catch180_configuration_error;
			}
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1494 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10299 "ConfigurationInterfaces.c"
		}
	}
	goto __finally180;
	__catch180_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1497 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1497 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10317 "ConfigurationInterfaces.c"
	}
	__finally180:
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1493 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10328 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_delay (ConfigurationFacade* self, gdouble delay) {
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1492 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_delay (self, delay);
#line 10338 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	{
		gchar* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_string_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, &_inner_error_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10368 "ConfigurationInterfaces.c"
				goto __catch181_configuration_error;
			}
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return NULL;
#line 10377 "ConfigurationInterfaces.c"
		}
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = _tmp0_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = NULL;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp5_;
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp0_);
#line 1506 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10389 "ConfigurationInterfaces.c"
	}
	goto __finally181;
	__catch181_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp6_ = err;
#line 1509 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp6_);
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_strdup (TRANSITION_EFFECTS_MANAGER_NULL_EFFECT_ID);
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp7_;
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1513 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10413 "ConfigurationInterfaces.c"
	}
	__finally181:
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1505 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return NULL;
#line 10422 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_slideshow_transition_effect_id (ConfigurationFacade* self) {
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1504 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_transition_effect_id (self);
#line 10431 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
	GError * _inner_error_ = NULL;
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 10439 "ConfigurationInterfaces.c"
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = id;
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_string_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_TRANSITION_EFFECT_ID, _tmp2_, &_inner_error_);
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10458 "ConfigurationInterfaces.c"
				goto __catch182_configuration_error;
			}
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1519 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10467 "ConfigurationInterfaces.c"
		}
	}
	goto __finally182;
	__catch182_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1522 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10485 "ConfigurationInterfaces.c"
	}
	__finally182:
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1518 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10496 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_transition_effect_id (ConfigurationFacade* self, const gchar* id) {
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1517 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_transition_effect_id (self, id);
#line 10506 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_slideshow_show_title (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, &_inner_error_);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10535 "ConfigurationInterfaces.c"
				goto __catch183_configuration_error;
			}
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10544 "ConfigurationInterfaces.c"
		}
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1531 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10550 "ConfigurationInterfaces.c"
	}
	goto __finally183;
	__catch183_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1533 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1535 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10571 "ConfigurationInterfaces.c"
	}
	__finally183:
#line 1530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1530 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10580 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_slideshow_show_title (ConfigurationFacade* self) {
#line 1529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1529 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_slideshow_show_title (self);
#line 10589 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = show_title;
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_SLIDESHOW_SHOW_TITLE, _tmp2_, &_inner_error_);
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10613 "ConfigurationInterfaces.c"
				goto __catch184_configuration_error;
			}
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1541 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10622 "ConfigurationInterfaces.c"
		}
	}
	goto __finally184;
	__catch184_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1543 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1543 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10640 "ConfigurationInterfaces.c"
	}
	__finally184:
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1540 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10651 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_slideshow_show_title (ConfigurationFacade* self, gboolean show_title) {
#line 1539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1539 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_slideshow_show_title (self, show_title);
#line 10661 "ConfigurationInterfaces.c"
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	localtime_r (&time, &_tmp0_);
#line 2750 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_result_ = _tmp0_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	*result = _result_;
#line 2751 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return;
#line 10676 "ConfigurationInterfaces.c"
}


static gchar* g_time_format (struct tm *self, const gchar* format) {
	gchar* result = NULL;
	gchar* buffer = NULL;
	gchar* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	gchar* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar* _tmp4_ = NULL;
#line 2758 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 64);
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = _tmp0_;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer_length1 = 64;
#line 2759 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_buffer_size_ = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = buffer;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1__length1 = buffer_length1;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp2_ = format;
#line 2760 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	strftime (_tmp1_, _tmp1__length1, _tmp2_, &(*self));
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3_ = buffer;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp3__length1 = buffer_length1;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	buffer = (g_free (buffer), NULL);
#line 2761 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 10722 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_24_hour_time (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, &_inner_error_);
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10751 "ConfigurationInterfaces.c"
				goto __catch185_configuration_error;
			}
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10760 "ConfigurationInterfaces.c"
		}
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1552 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10766 "ConfigurationInterfaces.c"
	}
	goto __finally185;
	__catch185_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
		struct tm _tmp6_ = {0};
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1554 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_time_local ((time_t) 0, &_tmp6_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp7_ = g_time_format (&_tmp6_, "%p");
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp7_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp9_ = is_string_empty (_tmp8_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _tmp9_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_free0 (_tmp8_);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp10_;
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1558 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10804 "ConfigurationInterfaces.c"
	}
	__finally185:
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1551 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10813 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_24_hour_time (ConfigurationFacade* self) {
#line 1550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1550 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_24_hour_time (self);
#line 10822 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = use_24_hour_time;
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_24_HOUR_TIME, _tmp2_, &_inner_error_);
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10846 "ConfigurationInterfaces.c"
				goto __catch186_configuration_error;
			}
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1564 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 10855 "ConfigurationInterfaces.c"
		}
	}
	goto __finally186;
	__catch186_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1566 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 10873 "ConfigurationInterfaces.c"
	}
	__finally186:
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1563 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 10884 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_24_hour_time (ConfigurationFacade* self, gboolean use_24_hour_time) {
#line 1562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1562 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_24_hour_time (self, use_24_hour_time);
#line 10894 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_use_lowercase_filenames (ConfigurationFacade* self) {
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	{
		gboolean _tmp0_ = FALSE;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_bool_property (_tmp2_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, &_inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 10923 "ConfigurationInterfaces.c"
				goto __catch187_configuration_error;
			}
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return FALSE;
#line 10932 "ConfigurationInterfaces.c"
		}
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1575 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10938 "ConfigurationInterfaces.c"
	}
	goto __finally187;
	__catch187_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1577 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = FALSE;
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1579 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 10959 "ConfigurationInterfaces.c"
	}
	__finally187:
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1574 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return FALSE;
#line 10968 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self) {
#line 1573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1573 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_use_lowercase_filenames (self);
#line 10977 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = b;
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_bool_property (_tmp1_, CONFIGURABLE_PROPERTY_USE_LOWERCASE_FILENAMES, _tmp2_, &_inner_error_);
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11001 "ConfigurationInterfaces.c"
				goto __catch188_configuration_error;
			}
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1585 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11010 "ConfigurationInterfaces.c"
		}
	}
	goto __finally188;
	__catch188_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1587 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11028 "ConfigurationInterfaces.c"
	}
	__finally188:
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1584 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11039 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_use_lowercase_filenames (ConfigurationFacade* self, gboolean b) {
#line 1583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1583 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_use_lowercase_filenames (self, b);
#line 11049 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
	gint result = 0;
	GError * _inner_error_ = NULL;
	{
		gint _tmp0_ = 0;
		ConfigurationEngine* _tmp1_ = NULL;
		ConfigurationEngine* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = configuration_facade_get_engine (self);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = _tmp1_;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = configuration_engine_get_int_property (_tmp2_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, &_inner_error_);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp4_ = _tmp3_;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp2_);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = _tmp4_;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11078 "ConfigurationInterfaces.c"
				goto __catch189_configuration_error;
			}
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return 0;
#line 11087 "ConfigurationInterfaces.c"
		}
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = _tmp0_;
#line 1596 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11093 "ConfigurationInterfaces.c"
	}
	goto __finally189;
	__catch189_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp5_ = NULL;
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp5_ = err;
#line 1599 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp5_);
#line 1601 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		result = -1;
#line 1601 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 1601 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return result;
#line 11114 "ConfigurationInterfaces.c"
	}
	__finally189:
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_clear_error (&_inner_error_);
#line 1595 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return 0;
#line 11123 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_video_interpreter_state_cookie (ConfigurationFacade* self) {
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1594 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_video_interpreter_state_cookie (self);
#line 11132 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
	GError * _inner_error_ = NULL;
	{
		ConfigurationEngine* _tmp0_ = NULL;
		ConfigurationEngine* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp0_ = configuration_facade_get_engine (self);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp1_ = _tmp0_;
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp2_ = state_cookie;
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_engine_set_int_property (_tmp1_, CONFIGURABLE_PROPERTY_VIDEO_INTERPRETER_STATE_COOKIE, _tmp2_, &_inner_error_);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_object_unref0 (_tmp1_);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			if (_inner_error_->domain == CONFIGURATION_ERROR) {
#line 11156 "ConfigurationInterfaces.c"
				goto __catch190_configuration_error;
			}
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			g_clear_error (&_inner_error_);
#line 1607 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
			return;
#line 11165 "ConfigurationInterfaces.c"
		}
	}
	goto __finally190;
	__catch190_configuration_error:
	{
		GError* err = NULL;
		GError* _tmp3_ = NULL;
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		err = _inner_error_;
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_inner_error_ = NULL;
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp3_ = err;
#line 1610 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		configuration_facade_on_configuration_error (self, _tmp3_);
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_g_error_free0 (err);
#line 11183 "ConfigurationInterfaces.c"
	}
	__finally190:
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		g_clear_error (&_inner_error_);
#line 1606 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		return;
#line 11194 "ConfigurationInterfaces.c"
	}
}


void configuration_facade_set_video_interpreter_state_cookie (ConfigurationFacade* self, gint state_cookie) {
#line 1605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1605 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_video_interpreter_state_cookie (self, state_cookie);
#line 11204 "ConfigurationInterfaces.c"
}


static gboolean configuration_facade_real_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
	gboolean result = FALSE;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, FALSE);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, FALSE);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1618 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11246 "ConfigurationInterfaces.c"
}


gboolean configuration_facade_get_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean def) {
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), FALSE);
#line 1617 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_bool (self, domain, id, key, def);
#line 11255 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_bool (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1622 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11288 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_bool (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gboolean val) {
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1621 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_bool (self, domain, id, key, val);
#line 11297 "ConfigurationInterfaces.c"
}


static gdouble configuration_facade_real_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
	gdouble result = 0.0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0.0);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0.0);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0.0);
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1626 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11339 "ConfigurationInterfaces.c"
}


gdouble configuration_facade_get_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble def) {
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0.0);
#line 1625 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_double (self, domain, id, key, def);
#line 11348 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gdouble _tmp5_ = 0.0;
#line 1629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_double (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1630 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11381 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_double (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gdouble val) {
#line 1629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1629 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_double (self, domain, id, key, val);
#line 11390 "ConfigurationInterfaces.c"
}


static gint configuration_facade_real_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
	gint result = 0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, 0);
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp7_;
#line 1634 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11432 "ConfigurationInterfaces.c"
}


gint configuration_facade_get_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint def) {
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1633 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_int (self, domain, id, key, def);
#line 11441 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 1637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = val;
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_int (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1638 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11474 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_int (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, gint val) {
#line 1637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1637 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_int (self, domain, id, key, val);
#line 11483 "ConfigurationInterfaces.c"
}


static gchar* configuration_facade_real_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp11_ = NULL;
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (domain != NULL, NULL);
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = def;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = configuration_engine_get_plugin_string (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp7_ = _tmp6_;
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1642 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_result_ = _tmp7_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp9_ = _result_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (g_strcmp0 (_tmp9_, "") == 0) {
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = NULL;
#line 11533 "ConfigurationInterfaces.c"
	} else {
		const gchar* _tmp10_ = NULL;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp10_ = _result_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		_tmp8_ = _tmp10_;
#line 11540 "ConfigurationInterfaces.c"
	}
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp11_ = g_strdup (_tmp8_);
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp11_;
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_free0 (_result_);
#line 1643 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11550 "ConfigurationInterfaces.c"
}


gchar* configuration_facade_get_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* def) {
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), NULL);
#line 1641 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->get_plugin_string (self, domain, id, key, def);
#line 11559 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
	const gchar* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	ConfigurationEngine* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = val;
#line 1647 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	if (_tmp0_ == NULL) {
#line 1648 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
		val = "";
#line 11583 "ConfigurationInterfaces.c"
	}
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = configuration_facade_get_engine (self);
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = _tmp1_;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = domain;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = id;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp5_ = key;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp6_ = val;
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_string (_tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
#line 1650 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp2_);
#line 11601 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_string (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key, const gchar* val) {
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1646 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_string (self, domain, id, key, val);
#line 11610 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
#line 1653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (domain != NULL);
#line 1653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (key != NULL);
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = domain;
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = id;
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = key;
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_unset_plugin_key (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1654 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11640 "ConfigurationInterfaces.c"
}


void configuration_facade_unset_plugin_key (ConfigurationFacade* self, const gchar* domain, const gchar* id, const gchar* key) {
#line 1653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1653 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->unset_plugin_key (self, domain, id, key);
#line 11649 "ConfigurationInterfaces.c"
}


static FuzzyPropertyState configuration_facade_real_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
	FuzzyPropertyState result = 0;
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	FuzzyPropertyState _tmp3_ = 0;
	FuzzyPropertyState _tmp4_ = 0;
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (id != NULL, 0);
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = configuration_engine_is_plugin_enabled (_tmp1_, _tmp2_);
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp4_ = _tmp3_;
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	result = _tmp4_;
#line 1661 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return result;
#line 11678 "ConfigurationInterfaces.c"
}


FuzzyPropertyState configuration_facade_is_plugin_enabled (ConfigurationFacade* self, const gchar* id) {
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_val_if_fail (IS_CONFIGURATION_FACADE (self), 0);
#line 1660 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	return CONFIGURATION_FACADE_GET_CLASS (self)->is_plugin_enabled (self, id);
#line 11687 "ConfigurationInterfaces.c"
}


static void configuration_facade_real_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
	ConfigurationEngine* _tmp0_ = NULL;
	ConfigurationEngine* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 1664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (id != NULL);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp0_ = configuration_facade_get_engine (self);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp1_ = _tmp0_;
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp2_ = id;
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_tmp3_ = enabled;
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_engine_set_plugin_enabled (_tmp1_, _tmp2_, _tmp3_);
#line 1665 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (_tmp1_);
#line 11710 "ConfigurationInterfaces.c"
}


void configuration_facade_set_plugin_enabled (ConfigurationFacade* self, const gchar* id, gboolean enabled) {
#line 1664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_return_if_fail (IS_CONFIGURATION_FACADE (self));
#line 1664 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	CONFIGURATION_FACADE_GET_CLASS (self)->set_plugin_enabled (self, id, enabled);
#line 11719 "ConfigurationInterfaces.c"
}


static void configuration_facade_class_init (ConfigurationFacadeClass * klass) {
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	configuration_facade_parent_class = g_type_class_peek_parent (klass);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_type_class_add_private (klass, sizeof (ConfigurationFacadePrivate));
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_auto_import_from_library = configuration_facade_real_get_auto_import_from_library;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_auto_import_from_library = configuration_facade_real_set_auto_import_from_library;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_bg_color_name = configuration_facade_real_get_bg_color_name;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_bg_color_name = configuration_facade_real_set_bg_color_name;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_commit_metadata_to_masters = configuration_facade_real_get_commit_metadata_to_masters;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_commit_metadata_to_masters = configuration_facade_real_set_commit_metadata_to_masters;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_desktop_background = configuration_facade_real_get_desktop_background;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_desktop_background = configuration_facade_real_set_desktop_background;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_screensaver = configuration_facade_real_get_screensaver;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_screensaver = configuration_facade_real_set_screensaver;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern = configuration_facade_real_get_directory_pattern;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern = configuration_facade_real_set_directory_pattern;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_directory_pattern_custom = configuration_facade_real_get_directory_pattern_custom;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_directory_pattern_custom = configuration_facade_real_set_directory_pattern_custom;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_direct_window_state = configuration_facade_real_get_direct_window_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_direct_window_state = configuration_facade_real_set_direct_window_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_basic_properties = configuration_facade_real_get_display_basic_properties;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_basic_properties = configuration_facade_real_set_display_basic_properties;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_extended_properties = configuration_facade_real_get_display_extended_properties;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_extended_properties = configuration_facade_real_set_display_extended_properties;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_sidebar = configuration_facade_real_get_display_sidebar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_sidebar = configuration_facade_real_set_display_sidebar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_toolbar = configuration_facade_real_get_display_toolbar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_toolbar = configuration_facade_real_set_display_toolbar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_search_bar = configuration_facade_real_get_display_search_bar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_search_bar = configuration_facade_real_set_display_search_bar;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_ratings = configuration_facade_real_get_display_photo_ratings;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_ratings = configuration_facade_real_set_display_photo_ratings;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_tags = configuration_facade_real_get_display_photo_tags;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_tags = configuration_facade_real_set_display_photo_tags;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_titles = configuration_facade_real_get_display_photo_titles;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_titles = configuration_facade_real_set_display_photo_titles;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_photo_comments = configuration_facade_real_get_display_photo_comments;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_photo_comments = configuration_facade_real_set_display_photo_comments;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_display_event_comments = configuration_facade_real_get_display_event_comments;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_display_event_comments = configuration_facade_real_set_display_event_comments;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_event_photos_sort = configuration_facade_real_get_event_photos_sort;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_event_photos_sort = configuration_facade_real_set_event_photos_sort;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_events_sort_ascending = configuration_facade_real_get_events_sort_ascending;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_events_sort_ascending = configuration_facade_real_set_events_sort_ascending;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_photo_app = configuration_facade_real_get_external_photo_app;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_photo_app = configuration_facade_real_set_external_photo_app;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_external_raw_app = configuration_facade_real_get_external_raw_app;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_external_raw_app = configuration_facade_real_set_external_raw_app;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_default_raw_developer = configuration_facade_real_get_default_raw_developer;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_default_raw_developer = configuration_facade_real_set_default_raw_developer;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_hide_photos_already_imported = configuration_facade_real_get_hide_photos_already_imported;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_hide_photos_already_imported = configuration_facade_real_set_hide_photos_already_imported;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_import_dir = configuration_facade_real_get_import_dir;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_import_dir = configuration_facade_real_set_import_dir;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_keep_relativity = configuration_facade_real_get_keep_relativity;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_keep_relativity = configuration_facade_real_set_keep_relativity;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_pin_toolbar_state = configuration_facade_real_get_pin_toolbar_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_pin_toolbar_state = configuration_facade_real_set_pin_toolbar_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_height = configuration_facade_real_get_last_crop_height;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_height = configuration_facade_real_set_last_crop_height;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_menu_choice = configuration_facade_real_get_last_crop_menu_choice;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_menu_choice = configuration_facade_real_set_last_crop_menu_choice;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_crop_width = configuration_facade_real_get_last_crop_width;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_crop_width = configuration_facade_real_set_last_crop_width;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_service = configuration_facade_real_get_last_used_service;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_service = configuration_facade_real_set_last_used_service;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_last_used_dataimports_service = configuration_facade_real_get_last_used_dataimports_service;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_last_used_dataimports_service = configuration_facade_real_set_last_used_dataimports_service;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_photos_sort = configuration_facade_real_get_library_photos_sort;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_photos_sort = configuration_facade_real_set_library_photos_sort;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_library_window_state = configuration_facade_real_get_library_window_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_library_window_state = configuration_facade_real_set_library_window_state;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_modify_originals = configuration_facade_real_get_modify_originals;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_modify_originals = configuration_facade_real_set_modify_originals;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_photo_thumbnail_scale = configuration_facade_real_get_photo_thumbnail_scale;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_photo_thumbnail_scale = configuration_facade_real_set_photo_thumbnail_scale;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_height = configuration_facade_real_get_printing_content_height;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_height = configuration_facade_real_set_printing_content_height;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_layout = configuration_facade_real_get_printing_content_layout;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_layout = configuration_facade_real_set_printing_content_layout;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_ppi = configuration_facade_real_get_printing_content_ppi;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_ppi = configuration_facade_real_set_printing_content_ppi;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_units = configuration_facade_real_get_printing_content_units;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_units = configuration_facade_real_set_printing_content_units;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_content_width = configuration_facade_real_get_printing_content_width;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_content_width = configuration_facade_real_set_printing_content_width;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_images_per_page = configuration_facade_real_get_printing_images_per_page;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_images_per_page = configuration_facade_real_set_printing_images_per_page;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_match_aspect_ratio = configuration_facade_real_get_printing_match_aspect_ratio;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_match_aspect_ratio = configuration_facade_real_set_printing_match_aspect_ratio;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_print_titles = configuration_facade_real_get_printing_print_titles;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_print_titles = configuration_facade_real_set_printing_print_titles;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_size_selection = configuration_facade_real_get_printing_size_selection;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_size_selection = configuration_facade_real_set_printing_size_selection;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_printing_titles_font = configuration_facade_real_get_printing_titles_font;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_printing_titles_font = configuration_facade_real_set_printing_titles_font;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_show_welcome_dialog = configuration_facade_real_get_show_welcome_dialog;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_show_welcome_dialog = configuration_facade_real_set_show_welcome_dialog;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_sidebar_position = configuration_facade_real_get_sidebar_position;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_sidebar_position = configuration_facade_real_set_sidebar_position;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_delay = configuration_facade_real_get_slideshow_delay;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_delay = configuration_facade_real_set_slideshow_delay;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_delay = configuration_facade_real_get_slideshow_transition_delay;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_delay = configuration_facade_real_set_slideshow_transition_delay;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_transition_effect_id = configuration_facade_real_get_slideshow_transition_effect_id;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_transition_effect_id = configuration_facade_real_set_slideshow_transition_effect_id;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_slideshow_show_title = configuration_facade_real_get_slideshow_show_title;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_slideshow_show_title = configuration_facade_real_set_slideshow_show_title;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_24_hour_time = configuration_facade_real_get_use_24_hour_time;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_24_hour_time = configuration_facade_real_set_use_24_hour_time;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_use_lowercase_filenames = configuration_facade_real_get_use_lowercase_filenames;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_use_lowercase_filenames = configuration_facade_real_set_use_lowercase_filenames;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_video_interpreter_state_cookie = configuration_facade_real_get_video_interpreter_state_cookie;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_video_interpreter_state_cookie = configuration_facade_real_set_video_interpreter_state_cookie;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_bool = configuration_facade_real_get_plugin_bool;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_bool = configuration_facade_real_set_plugin_bool;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_double = configuration_facade_real_get_plugin_double;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_double = configuration_facade_real_set_plugin_double;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_int = configuration_facade_real_get_plugin_int;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_int = configuration_facade_real_set_plugin_int;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->get_plugin_string = configuration_facade_real_get_plugin_string;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_string = configuration_facade_real_set_plugin_string;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->unset_plugin_key = configuration_facade_real_unset_plugin_key;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->is_plugin_enabled = configuration_facade_real_is_plugin_enabled;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	((ConfigurationFacadeClass *) klass)->set_plugin_enabled = configuration_facade_real_set_plugin_enabled;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (klass)->finalize = configuration_facade_finalize;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("auto_import_from_library_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("bg_color_name_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("commit_metadata_to_masters_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("events_sort_ascending_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("external_app_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	g_signal_new ("import_directory_changed", TYPE_CONFIGURATION_FACADE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 11984 "ConfigurationInterfaces.c"
}


static void configuration_facade_instance_init (ConfigurationFacade * self) {
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self->priv = CONFIGURATION_FACADE_GET_PRIVATE (self);
#line 11991 "ConfigurationInterfaces.c"
}


static void configuration_facade_finalize (GObject* obj) {
	ConfigurationFacade * self;
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONFIGURATION_FACADE, ConfigurationFacade);
#line 319 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	_g_object_unref0 (self->priv->engine);
#line 318 "/home/jens/Source/shotwell/src/config/ConfigurationInterfaces.vala"
	G_OBJECT_CLASS (configuration_facade_parent_class)->finalize (obj);
#line 12003 "ConfigurationInterfaces.c"
}


GType configuration_facade_get_type (void) {
	static volatile gsize configuration_facade_type_id__volatile = 0;
	if (g_once_init_enter (&configuration_facade_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ConfigurationFacadeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) configuration_facade_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ConfigurationFacade), 0, (GInstanceInitFunc) configuration_facade_instance_init, NULL };
		GType configuration_facade_type_id;
		configuration_facade_type_id = g_type_register_static (G_TYPE_OBJECT, "ConfigurationFacade", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&configuration_facade_type_id__volatile, configuration_facade_type_id);
	}
	return configuration_facade_type_id__volatile;
}



