/* scanner.c generated by valac 0.34.2, the Vala compiler
 * generated from scanner.vala, do not modify */

/*
 * Copyright (C) 2009-2015 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/* TODO: Could indicate the start of the next page immediately after the last page is received (i.e. before the sane_cancel()) */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include "sane/saneopts.h"
#include <gobject/gvaluecollector.h>


#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecScanDevice ParamSpecScanDevice;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ParamSpecScanPageInfo ParamSpecScanPageInfo;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanLinePrivate ScanLinePrivate;
typedef struct _ParamSpecScanLine ParamSpecScanLine;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;
typedef struct _ParamSpecScanOptions ParamSpecScanOptions;

#define TYPE_SCAN_JOB (scan_job_get_type ())
#define SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_JOB, ScanJob))
#define SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_JOB, ScanJobClass))
#define IS_SCAN_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_JOB))
#define IS_SCAN_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_JOB))
#define SCAN_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_JOB, ScanJobClass))

typedef struct _ScanJob ScanJob;
typedef struct _ScanJobClass ScanJobClass;
typedef struct _ScanJobPrivate ScanJobPrivate;
typedef struct _ParamSpecScanJob ParamSpecScanJob;

#define TYPE_REQUEST (request_get_type ())
#define REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST, Request))
#define REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST, RequestClass))
#define IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST))
#define IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST))
#define REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST, RequestClass))

typedef struct _Request Request;
typedef struct _RequestClass RequestClass;
typedef struct _RequestPrivate RequestPrivate;
typedef struct _ParamSpecRequest ParamSpecRequest;

#define TYPE_REQUEST_REDETECT (request_redetect_get_type ())
#define REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_REDETECT, RequestRedetect))
#define REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_REDETECT, RequestRedetectClass))
#define IS_REQUEST_REDETECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_REDETECT))
#define IS_REQUEST_REDETECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_REDETECT))
#define REQUEST_REDETECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_REDETECT, RequestRedetectClass))

typedef struct _RequestRedetect RequestRedetect;
typedef struct _RequestRedetectClass RequestRedetectClass;
typedef struct _RequestRedetectPrivate RequestRedetectPrivate;

#define TYPE_REQUEST_CANCEL (request_cancel_get_type ())
#define REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_CANCEL, RequestCancel))
#define REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_CANCEL, RequestCancelClass))
#define IS_REQUEST_CANCEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_CANCEL))
#define IS_REQUEST_CANCEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_CANCEL))
#define REQUEST_CANCEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_CANCEL, RequestCancelClass))

typedef struct _RequestCancel RequestCancel;
typedef struct _RequestCancelClass RequestCancelClass;
typedef struct _RequestCancelPrivate RequestCancelPrivate;

#define TYPE_REQUEST_START_SCAN (request_start_scan_get_type ())
#define REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_START_SCAN, RequestStartScan))
#define REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_START_SCAN, RequestStartScanClass))
#define IS_REQUEST_START_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_START_SCAN))
#define IS_REQUEST_START_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_START_SCAN))
#define REQUEST_START_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_START_SCAN, RequestStartScanClass))

typedef struct _RequestStartScan RequestStartScan;
typedef struct _RequestStartScanClass RequestStartScanClass;
typedef struct _RequestStartScanPrivate RequestStartScanPrivate;
#define _scan_job_unref0(var) ((var == NULL) ? NULL : (var = (scan_job_unref (var), NULL)))

#define TYPE_REQUEST_QUIT (request_quit_get_type ())
#define REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REQUEST_QUIT, RequestQuit))
#define REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REQUEST_QUIT, RequestQuitClass))
#define IS_REQUEST_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REQUEST_QUIT))
#define IS_REQUEST_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REQUEST_QUIT))
#define REQUEST_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REQUEST_QUIT, RequestQuitClass))

typedef struct _RequestQuit RequestQuit;
typedef struct _RequestQuitClass RequestQuitClass;
typedef struct _RequestQuitPrivate RequestQuitPrivate;

#define TYPE_CREDENTIALS (credentials_get_type ())
#define CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CREDENTIALS, Credentials))
#define CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CREDENTIALS, CredentialsClass))
#define IS_CREDENTIALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CREDENTIALS))
#define IS_CREDENTIALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CREDENTIALS))
#define CREDENTIALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CREDENTIALS, CredentialsClass))

typedef struct _Credentials Credentials;
typedef struct _CredentialsClass CredentialsClass;
typedef struct _CredentialsPrivate CredentialsPrivate;
typedef struct _ParamSpecCredentials ParamSpecCredentials;

#define TYPE_SCAN_STATE (scan_state_get_type ())

#define TYPE_NOTIFY (notify_get_type ())
#define NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY, Notify))
#define NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY, NotifyClass))
#define IS_NOTIFY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY))
#define IS_NOTIFY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY))
#define NOTIFY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY, NotifyClass))

typedef struct _Notify Notify;
typedef struct _NotifyClass NotifyClass;
typedef struct _NotifyPrivate NotifyPrivate;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;
typedef struct _ParamSpecNotify ParamSpecNotify;

#define TYPE_NOTIFY_SCANNING_CHANGED (notify_scanning_changed_get_type ())
#define NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChanged))
#define NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))
#define IS_NOTIFY_SCANNING_CHANGED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCANNING_CHANGED))
#define IS_NOTIFY_SCANNING_CHANGED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCANNING_CHANGED))
#define NOTIFY_SCANNING_CHANGED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCANNING_CHANGED, NotifyScanningChangedClass))

typedef struct _NotifyScanningChanged NotifyScanningChanged;
typedef struct _NotifyScanningChangedClass NotifyScanningChangedClass;
typedef struct _NotifyScanningChangedPrivate NotifyScanningChangedPrivate;

#define TYPE_NOTIFY_UPDATE_DEVICES (notify_update_devices_get_type ())
#define NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices))
#define NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))
#define IS_NOTIFY_UPDATE_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_UPDATE_DEVICES))
#define IS_NOTIFY_UPDATE_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_UPDATE_DEVICES))
#define NOTIFY_UPDATE_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesClass))

typedef struct _NotifyUpdateDevices NotifyUpdateDevices;
typedef struct _NotifyUpdateDevicesClass NotifyUpdateDevicesClass;
typedef struct _NotifyUpdateDevicesPrivate NotifyUpdateDevicesPrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))

#define TYPE_NOTIFY_REQUEST_AUTHORIZATION (notify_request_authorization_get_type ())
#define NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization))
#define NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))
#define IS_NOTIFY_REQUEST_AUTHORIZATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define IS_NOTIFY_REQUEST_AUTHORIZATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_REQUEST_AUTHORIZATION))
#define NOTIFY_REQUEST_AUTHORIZATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationClass))

typedef struct _NotifyRequestAuthorization NotifyRequestAuthorization;
typedef struct _NotifyRequestAuthorizationClass NotifyRequestAuthorizationClass;
typedef struct _NotifyRequestAuthorizationPrivate NotifyRequestAuthorizationPrivate;

#define TYPE_NOTIFY_SCAN_FAILED (notify_scan_failed_get_type ())
#define NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed))
#define NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))
#define IS_NOTIFY_SCAN_FAILED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_SCAN_FAILED))
#define IS_NOTIFY_SCAN_FAILED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_SCAN_FAILED))
#define NOTIFY_SCAN_FAILED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedClass))

typedef struct _NotifyScanFailed NotifyScanFailed;
typedef struct _NotifyScanFailedClass NotifyScanFailedClass;
typedef struct _NotifyScanFailedPrivate NotifyScanFailedPrivate;

#define TYPE_NOTIFY_DOCUMENT_DONE (notify_document_done_get_type ())
#define NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDone))
#define NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))
#define IS_NOTIFY_DOCUMENT_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_DOCUMENT_DONE))
#define IS_NOTIFY_DOCUMENT_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_DOCUMENT_DONE))
#define NOTIFY_DOCUMENT_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_DOCUMENT_DONE, NotifyDocumentDoneClass))

typedef struct _NotifyDocumentDone NotifyDocumentDone;
typedef struct _NotifyDocumentDoneClass NotifyDocumentDoneClass;
typedef struct _NotifyDocumentDonePrivate NotifyDocumentDonePrivate;

#define TYPE_NOTIFY_EXPECT_PAGE (notify_expect_page_get_type ())
#define NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPage))
#define NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))
#define IS_NOTIFY_EXPECT_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_EXPECT_PAGE))
#define IS_NOTIFY_EXPECT_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_EXPECT_PAGE))
#define NOTIFY_EXPECT_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_EXPECT_PAGE, NotifyExpectPageClass))

typedef struct _NotifyExpectPage NotifyExpectPage;
typedef struct _NotifyExpectPageClass NotifyExpectPageClass;
typedef struct _NotifyExpectPagePrivate NotifyExpectPagePrivate;

#define TYPE_NOTIFY_GOT_PAGE_INFO (notify_got_page_info_get_type ())
#define NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo))
#define NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))
#define IS_NOTIFY_GOT_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_PAGE_INFO))
#define IS_NOTIFY_GOT_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_PAGE_INFO))
#define NOTIFY_GOT_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoClass))

typedef struct _NotifyGotPageInfo NotifyGotPageInfo;
typedef struct _NotifyGotPageInfoClass NotifyGotPageInfoClass;
typedef struct _NotifyGotPageInfoPrivate NotifyGotPageInfoPrivate;
#define _scan_page_info_unref0(var) ((var == NULL) ? NULL : (var = (scan_page_info_unref (var), NULL)))
typedef struct _ScannerPrivate ScannerPrivate;

#define TYPE_NOTIFY_PAGE_DONE (notify_page_done_get_type ())
#define NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDone))
#define NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))
#define IS_NOTIFY_PAGE_DONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_PAGE_DONE))
#define IS_NOTIFY_PAGE_DONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_PAGE_DONE))
#define NOTIFY_PAGE_DONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_PAGE_DONE, NotifyPageDoneClass))

typedef struct _NotifyPageDone NotifyPageDone;
typedef struct _NotifyPageDoneClass NotifyPageDoneClass;
typedef struct _NotifyPageDonePrivate NotifyPageDonePrivate;

#define TYPE_NOTIFY_GOT_LINE (notify_got_line_get_type ())
#define NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLine))
#define NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))
#define IS_NOTIFY_GOT_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFY_GOT_LINE))
#define IS_NOTIFY_GOT_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFY_GOT_LINE))
#define NOTIFY_GOT_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFY_GOT_LINE, NotifyGotLineClass))

typedef struct _NotifyGotLine NotifyGotLine;
typedef struct _NotifyGotLineClass NotifyGotLineClass;
typedef struct _NotifyGotLinePrivate NotifyGotLinePrivate;
#define _scan_line_unref0(var) ((var == NULL) ? NULL : (var = (scan_line_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))
#define __g_list_free__scan_job_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_job_unref0_ (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _notify_unref0(var) ((var == NULL) ? NULL : (var = (notify_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _credentials_unref0(var) ((var == NULL) ? NULL : (var = (credentials_unref (var), NULL)))
#define _request_unref0(var) ((var == NULL) ? NULL : (var = (request_unref (var), NULL)))
typedef struct _ParamSpecScanner ParamSpecScanner;

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

struct _ParamSpecScanDevice {
	GParamSpec parent_instance;
};

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

struct _ParamSpecScanPageInfo {
	GParamSpec parent_instance;
};

struct _ScanLine {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanLinePrivate * priv;
	gint number;
	gint n_lines;
	gint width;
	gint depth;
	gint channel;
	guchar* data;
	gint data_length1;
	gint data_length;
};

struct _ScanLineClass {
	GTypeClass parent_class;
	void (*finalize) (ScanLine *self);
};

struct _ParamSpecScanLine {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};

struct _ParamSpecScanOptions {
	GParamSpec parent_instance;
};

struct _ScanJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanJobPrivate * priv;
	gint id;
	gchar* device;
	gdouble dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint page_width;
	gint page_height;
	gint brightness;
	gint contrast;
};

struct _ScanJobClass {
	GTypeClass parent_class;
	void (*finalize) (ScanJob *self);
};

struct _ParamSpecScanJob {
	GParamSpec parent_instance;
};

struct _Request {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RequestPrivate * priv;
};

struct _RequestClass {
	GTypeClass parent_class;
	void (*finalize) (Request *self);
};

struct _ParamSpecRequest {
	GParamSpec parent_instance;
};

struct _RequestRedetect {
	Request parent_instance;
	RequestRedetectPrivate * priv;
};

struct _RequestRedetectClass {
	RequestClass parent_class;
};

struct _RequestCancel {
	Request parent_instance;
	RequestCancelPrivate * priv;
};

struct _RequestCancelClass {
	RequestClass parent_class;
};

struct _RequestStartScan {
	Request parent_instance;
	RequestStartScanPrivate * priv;
	ScanJob* job;
};

struct _RequestStartScanClass {
	RequestClass parent_class;
};

struct _RequestQuit {
	Request parent_instance;
	RequestQuitPrivate * priv;
};

struct _RequestQuitClass {
	RequestClass parent_class;
};

struct _Credentials {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CredentialsPrivate * priv;
	gchar* username;
	gchar* password;
};

struct _CredentialsClass {
	GTypeClass parent_class;
	void (*finalize) (Credentials *self);
};

struct _ParamSpecCredentials {
	GParamSpec parent_instance;
};

typedef enum  {
	SCAN_STATE_IDLE = 0,
	SCAN_STATE_REDETECT,
	SCAN_STATE_OPEN,
	SCAN_STATE_GET_OPTION,
	SCAN_STATE_START,
	SCAN_STATE_GET_PARAMETERS,
	SCAN_STATE_READ
} ScanState;

struct _Notify {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NotifyPrivate * priv;
};

struct _NotifyClass {
	GTypeClass parent_class;
	void (*finalize) (Notify *self);
	void (*run) (Notify* self, Scanner* scanner);
};

struct _ParamSpecNotify {
	GParamSpec parent_instance;
};

struct _NotifyScanningChanged {
	Notify parent_instance;
	NotifyScanningChangedPrivate * priv;
};

struct _NotifyScanningChangedClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevices {
	Notify parent_instance;
	NotifyUpdateDevicesPrivate * priv;
};

struct _NotifyUpdateDevicesClass {
	NotifyClass parent_class;
};

struct _NotifyUpdateDevicesPrivate {
	GList* devices;
};

struct _NotifyRequestAuthorization {
	Notify parent_instance;
	NotifyRequestAuthorizationPrivate * priv;
};

struct _NotifyRequestAuthorizationClass {
	NotifyClass parent_class;
};

struct _NotifyRequestAuthorizationPrivate {
	gchar* resource;
};

struct _NotifyScanFailed {
	Notify parent_instance;
	NotifyScanFailedPrivate * priv;
};

struct _NotifyScanFailedClass {
	NotifyClass parent_class;
};

struct _NotifyScanFailedPrivate {
	gint error_code;
	gchar* error_string;
};

struct _NotifyDocumentDone {
	Notify parent_instance;
	NotifyDocumentDonePrivate * priv;
};

struct _NotifyDocumentDoneClass {
	NotifyClass parent_class;
};

struct _NotifyExpectPage {
	Notify parent_instance;
	NotifyExpectPagePrivate * priv;
};

struct _NotifyExpectPageClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfo {
	Notify parent_instance;
	NotifyGotPageInfoPrivate * priv;
};

struct _NotifyGotPageInfoClass {
	NotifyClass parent_class;
};

struct _NotifyGotPageInfoPrivate {
	gint job_id;
	ScanPageInfo* info;
};

struct _Scanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScannerPrivate * priv;
	gint first_job_id;
	gint job_id;
};

struct _ScannerClass {
	GTypeClass parent_class;
	void (*finalize) (Scanner *self);
};

struct _NotifyPageDone {
	Notify parent_instance;
	NotifyPageDonePrivate * priv;
};

struct _NotifyPageDoneClass {
	NotifyClass parent_class;
};

struct _NotifyPageDonePrivate {
	gint job_id;
};

struct _NotifyGotLine {
	Notify parent_instance;
	NotifyGotLinePrivate * priv;
};

struct _NotifyGotLineClass {
	NotifyClass parent_class;
};

struct _NotifyGotLinePrivate {
	gint job_id;
	ScanLine* line;
};

struct _ScannerPrivate {
	GThread* thread;
	GAsyncQueue* request_queue;
	GAsyncQueue* notify_queue;
	GAsyncQueue* authorize_queue;
	gchar* default_device;
	ScanState state;
	gboolean need_redetect;
	GList* job_queue;
	SANE_Handle handle;
	gboolean have_handle;
	gchar* current_device;
	SANE_Parameters parameters;
	SANE_Int option_index;
	GHashTable* options;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	gint n_used;
	gint line_count;
	gint pass_number;
	gint page_number;
	gint notified_page;
	gboolean scanning;
};

struct _ParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer scan_device_parent_class = NULL;
static gpointer scan_page_info_parent_class = NULL;
static gpointer scan_line_parent_class = NULL;
static gpointer scan_options_parent_class = NULL;
static gpointer scan_job_parent_class = NULL;
static gpointer request_parent_class = NULL;
static gpointer request_redetect_parent_class = NULL;
static gpointer request_cancel_parent_class = NULL;
static gpointer request_start_scan_parent_class = NULL;
static gpointer request_quit_parent_class = NULL;
static gpointer credentials_parent_class = NULL;
static gpointer notify_parent_class = NULL;
static gpointer notify_scanning_changed_parent_class = NULL;
static gpointer notify_update_devices_parent_class = NULL;
static gpointer notify_request_authorization_parent_class = NULL;
static gpointer notify_scan_failed_parent_class = NULL;
static gpointer notify_document_done_parent_class = NULL;
static gpointer notify_expect_page_parent_class = NULL;
static gpointer notify_got_page_info_parent_class = NULL;
static gpointer notify_page_done_parent_class = NULL;
static gpointer notify_got_line_parent_class = NULL;
static gpointer scanner_parent_class = NULL;
static Scanner* scanner_scanner_object;
static Scanner* scanner_scanner_object = NULL;

gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_DEVICE_DUMMY_PROPERTY
};
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void scan_device_finalize (ScanDevice* obj);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_PAGE_INFO_DUMMY_PROPERTY
};
ScanPageInfo* scan_page_info_new (void);
ScanPageInfo* scan_page_info_construct (GType object_type);
static void scan_page_info_finalize (ScanPageInfo* obj);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_LINE_DUMMY_PROPERTY
};
ScanLine* scan_line_new (void);
ScanLine* scan_line_construct (GType object_type);
static void scan_line_finalize (ScanLine* obj);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_OPTIONS_DUMMY_PROPERTY
};
ScanOptions* scan_options_new (void);
ScanOptions* scan_options_construct (GType object_type);
static void scan_options_finalize (ScanOptions* obj);
gpointer scan_job_ref (gpointer instance);
void scan_job_unref (gpointer instance);
GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_job (GValue* value, gpointer v_object);
void value_take_scan_job (GValue* value, gpointer v_object);
gpointer value_get_scan_job (const GValue* value);
GType scan_job_get_type (void) G_GNUC_CONST;
enum  {
	SCAN_JOB_DUMMY_PROPERTY
};
ScanJob* scan_job_new (void);
ScanJob* scan_job_construct (GType object_type);
static void scan_job_finalize (ScanJob* obj);
gpointer request_ref (gpointer instance);
void request_unref (gpointer instance);
GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_request (GValue* value, gpointer v_object);
void value_take_request (GValue* value, gpointer v_object);
gpointer value_get_request (const GValue* value);
GType request_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_DUMMY_PROPERTY
};
Request* request_new (void);
Request* request_construct (GType object_type);
static void request_finalize (Request* obj);
GType request_redetect_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_REDETECT_DUMMY_PROPERTY
};
RequestRedetect* request_redetect_new (void);
RequestRedetect* request_redetect_construct (GType object_type);
GType request_cancel_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_CANCEL_DUMMY_PROPERTY
};
RequestCancel* request_cancel_new (void);
RequestCancel* request_cancel_construct (GType object_type);
GType request_start_scan_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_START_SCAN_DUMMY_PROPERTY
};
RequestStartScan* request_start_scan_new (void);
RequestStartScan* request_start_scan_construct (GType object_type);
static void request_start_scan_finalize (Request* obj);
GType request_quit_get_type (void) G_GNUC_CONST;
enum  {
	REQUEST_QUIT_DUMMY_PROPERTY
};
RequestQuit* request_quit_new (void);
RequestQuit* request_quit_construct (GType object_type);
gpointer credentials_ref (gpointer instance);
void credentials_unref (gpointer instance);
GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_credentials (GValue* value, gpointer v_object);
void value_take_credentials (GValue* value, gpointer v_object);
gpointer value_get_credentials (const GValue* value);
GType credentials_get_type (void) G_GNUC_CONST;
enum  {
	CREDENTIALS_DUMMY_PROPERTY
};
Credentials* credentials_new (void);
Credentials* credentials_construct (GType object_type);
static void credentials_finalize (Credentials* obj);
GType scan_state_get_type (void) G_GNUC_CONST;
gpointer notify_ref (gpointer instance);
void notify_unref (gpointer instance);
GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_notify (GValue* value, gpointer v_object);
void value_take_notify (GValue* value, gpointer v_object);
gpointer value_get_notify (const GValue* value);
GType notify_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DUMMY_PROPERTY
};
void notify_run (Notify* self, Scanner* scanner);
static void notify_real_run (Notify* self, Scanner* scanner);
Notify* notify_new (void);
Notify* notify_construct (GType object_type);
static void notify_finalize (Notify* obj);
GType notify_scanning_changed_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_SCANNING_CHANGED_DUMMY_PROPERTY
};
static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner);
NotifyScanningChanged* notify_scanning_changed_new (void);
NotifyScanningChanged* notify_scanning_changed_construct (GType object_type);
GType notify_update_devices_get_type (void) G_GNUC_CONST;
#define NOTIFY_UPDATE_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevicesPrivate))
enum  {
	NOTIFY_UPDATE_DEVICES_DUMMY_PROPERTY
};
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
NotifyUpdateDevices* notify_update_devices_new (GList* devices);
NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices);
static void notify_update_devices_real_run (Notify* base, Scanner* scanner);
static void notify_update_devices_finalize (Notify* obj);
GType notify_request_authorization_get_type (void) G_GNUC_CONST;
#define NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorizationPrivate))
enum  {
	NOTIFY_REQUEST_AUTHORIZATION_DUMMY_PROPERTY
};
NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource);
NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource);
static void notify_request_authorization_real_run (Notify* base, Scanner* scanner);
static void notify_request_authorization_finalize (Notify* obj);
GType notify_scan_failed_get_type (void) G_GNUC_CONST;
#define NOTIFY_SCAN_FAILED_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailedPrivate))
enum  {
	NOTIFY_SCAN_FAILED_DUMMY_PROPERTY
};
NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string);
NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string);
static void notify_scan_failed_real_run (Notify* base, Scanner* scanner);
static void notify_scan_failed_finalize (Notify* obj);
GType notify_document_done_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_DOCUMENT_DONE_DUMMY_PROPERTY
};
static void notify_document_done_real_run (Notify* base, Scanner* scanner);
NotifyDocumentDone* notify_document_done_new (void);
NotifyDocumentDone* notify_document_done_construct (GType object_type);
GType notify_expect_page_get_type (void) G_GNUC_CONST;
enum  {
	NOTIFY_EXPECT_PAGE_DUMMY_PROPERTY
};
static void notify_expect_page_real_run (Notify* base, Scanner* scanner);
NotifyExpectPage* notify_expect_page_new (void);
NotifyExpectPage* notify_expect_page_construct (GType object_type);
GType notify_got_page_info_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_PAGE_INFO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfoPrivate))
enum  {
	NOTIFY_GOT_PAGE_INFO_DUMMY_PROPERTY
};
NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info);
NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info);
static void notify_got_page_info_real_run (Notify* base, Scanner* scanner);
static void notify_got_page_info_finalize (Notify* obj);
GType notify_page_done_get_type (void) G_GNUC_CONST;
#define NOTIFY_PAGE_DONE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_PAGE_DONE, NotifyPageDonePrivate))
enum  {
	NOTIFY_PAGE_DONE_DUMMY_PROPERTY
};
NotifyPageDone* notify_page_done_new (gint job_id);
NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id);
static void notify_page_done_real_run (Notify* base, Scanner* scanner);
static void notify_page_done_finalize (Notify* obj);
GType notify_got_line_get_type (void) G_GNUC_CONST;
#define NOTIFY_GOT_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NOTIFY_GOT_LINE, NotifyGotLinePrivate))
enum  {
	NOTIFY_GOT_LINE_DUMMY_PROPERTY
};
NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line);
NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line);
static void notify_got_line_real_run (Notify* base, Scanner* scanner);
static void notify_got_line_finalize (Notify* obj);
#define SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SCANNER, ScannerPrivate))
enum  {
	SCANNER_DUMMY_PROPERTY
};
static void _scan_job_unref0_ (gpointer var);
static void _g_list_free__scan_job_unref0_ (GList* self);
static Scanner* scanner_new (void);
static Scanner* scanner_construct (GType object_type);
static void _request_unref0_ (gpointer var);
static void _notify_unref0_ (gpointer var);
static void _credentials_unref0_ (gpointer var);
Scanner* scanner_get_instance (void);
static gboolean scanner_notify_idle_cb (Scanner* self);
static void scanner_notify (Scanner* self, Notify* notification);
static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self);
static void scanner_set_scanning (Scanner* self, gboolean is_scanning);
static gint scanner_get_device_weight (const gchar* device);
static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2);
static void scanner_do_redetect (Scanner* self);
static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b);
static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value);
static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_);
static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_);
static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_);
static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index);
static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_);
static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_);
static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option);
static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
static void scanner_close_device (Scanner* self);
static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string);
static gboolean scanner_handle_requests (Scanner* self);
static void scanner_do_open (Scanner* self);
static void _g_free0_ (gpointer var);
static void scanner_do_get_option (Scanner* self);
static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index);
static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi);
static void scanner_do_complete_document (Scanner* self);
static void scanner_do_start (Scanner* self);
static void scanner_do_get_parameters (Scanner* self);
static void scanner_do_complete_page (Scanner* self);
static void scanner_do_read (Scanner* self);
static void* scanner_scan_thread (Scanner* self);
static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password);
void scanner_redetect (Scanner* self);
void scanner_start (Scanner* self);
static gpointer _scanner_scan_thread_gthread_func (gpointer self);
gboolean scanner_is_scanning (Scanner* self);
static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode);
static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
void scanner_free (Scanner* self);
static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void scanner_finalize (Scanner* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


ScanDevice* scan_device_construct (GType object_type) {
	ScanDevice* self = NULL;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanDevice*) g_type_create_instance (object_type);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 986 "scanner.c"
}


ScanDevice* scan_device_new (void) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_device_construct (TYPE_SCAN_DEVICE);
#line 993 "scanner.c"
}


static void value_scan_device_init (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1000 "scanner.c"
}


static void value_scan_device_free_value (GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (value->data[0].v_pointer);
#line 1009 "scanner.c"
	}
}


static void value_scan_device_copy_value (const GValue* src_value, GValue* dest_value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_device_ref (src_value->data[0].v_pointer);
#line 1019 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1023 "scanner.c"
	}
}


static gpointer value_scan_device_peek_pointer (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1031 "scanner.c"
}


static gchar* value_scan_device_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1038 "scanner.c"
		ScanDevice* object;
		object = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1045 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1049 "scanner.c"
		}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_device_ref (object);
#line 1053 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1057 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1061 "scanner.c"
}


static gchar* value_scan_device_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanDevice** object_p;
	object_p = collect_values[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1072 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1078 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1082 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_device_ref (value->data[0].v_pointer);
#line 1086 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1090 "scanner.c"
}


GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanDevice* spec;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1104 "scanner.c"
}


gpointer value_get_scan_device (const GValue* value) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE), NULL);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1113 "scanner.c"
}


void value_set_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_ref (value->data[0].v_pointer);
#line 1133 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1137 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (old);
#line 1143 "scanner.c"
	}
}


void value_take_scan_device (GValue* value, gpointer v_object) {
	ScanDevice* old;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_DEVICE));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1162 "scanner.c"
	} else {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1166 "scanner.c"
	}
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_device_unref (old);
#line 1172 "scanner.c"
	}
}


static void scan_device_class_init (ScanDeviceClass * klass) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_device_parent_class = g_type_class_peek_parent (klass);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScanDeviceClass *) klass)->finalize = scan_device_finalize;
#line 1182 "scanner.c"
}


static void scan_device_instance_init (ScanDevice * self) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1189 "scanner.c"
}


static void scan_device_finalize (ScanDevice* obj) {
	ScanDevice * self;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_DEVICE, ScanDevice);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 16 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->name);
#line 17 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->label);
#line 1203 "scanner.c"
}


GType scan_device_get_type (void) {
	static volatile gsize scan_device_type_id__volatile = 0;
	if (g_once_init_enter (&scan_device_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_device_init, value_scan_device_free_value, value_scan_device_copy_value, value_scan_device_peek_pointer, "p", value_scan_device_collect_value, "p", value_scan_device_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanDevice), 0, (GInstanceInitFunc) scan_device_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_device_type_id;
		scan_device_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanDevice", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_device_type_id__volatile, scan_device_type_id);
	}
	return scan_device_type_id__volatile;
}


gpointer scan_device_ref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1228 "scanner.c"
}


void scan_device_unref (gpointer instance) {
	ScanDevice* self;
	self = instance;
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_DEVICE_GET_CLASS (self)->finalize (self);
#line 14 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1241 "scanner.c"
	}
}


ScanPageInfo* scan_page_info_construct (GType object_type) {
	ScanPageInfo* self = NULL;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanPageInfo*) g_type_create_instance (object_type);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1252 "scanner.c"
}


ScanPageInfo* scan_page_info_new (void) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_page_info_construct (TYPE_SCAN_PAGE_INFO);
#line 1259 "scanner.c"
}


static void value_scan_page_info_init (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1266 "scanner.c"
}


static void value_scan_page_info_free_value (GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (value->data[0].v_pointer);
#line 1275 "scanner.c"
	}
}


static void value_scan_page_info_copy_value (const GValue* src_value, GValue* dest_value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_page_info_ref (src_value->data[0].v_pointer);
#line 1285 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1289 "scanner.c"
	}
}


static gpointer value_scan_page_info_peek_pointer (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1297 "scanner.c"
}


static gchar* value_scan_page_info_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1304 "scanner.c"
		ScanPageInfo* object;
		object = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1311 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1315 "scanner.c"
		}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_page_info_ref (object);
#line 1319 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1323 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1327 "scanner.c"
}


static gchar* value_scan_page_info_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanPageInfo** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1338 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1344 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1348 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_page_info_ref (value->data[0].v_pointer);
#line 1352 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1356 "scanner.c"
}


GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanPageInfo* spec;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1370 "scanner.c"
}


gpointer value_get_scan_page_info (const GValue* value) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO), NULL);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1379 "scanner.c"
}


void value_set_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_ref (value->data[0].v_pointer);
#line 1399 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1403 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (old);
#line 1409 "scanner.c"
	}
}


void value_take_scan_page_info (GValue* value, gpointer v_object) {
	ScanPageInfo* old;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_PAGE_INFO));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1428 "scanner.c"
	} else {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1432 "scanner.c"
	}
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_page_info_unref (old);
#line 1438 "scanner.c"
	}
}


static void scan_page_info_class_init (ScanPageInfoClass * klass) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_page_info_parent_class = g_type_class_peek_parent (klass);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScanPageInfoClass *) klass)->finalize = scan_page_info_finalize;
#line 1448 "scanner.c"
}


static void scan_page_info_instance_init (ScanPageInfo * self) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1455 "scanner.c"
}


static void scan_page_info_finalize (ScanPageInfo* obj) {
	ScanPageInfo * self;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_PAGE_INFO, ScanPageInfo);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 36 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->device);
#line 1467 "scanner.c"
}


GType scan_page_info_get_type (void) {
	static volatile gsize scan_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&scan_page_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_page_info_init, value_scan_page_info_free_value, value_scan_page_info_copy_value, value_scan_page_info_peek_pointer, "p", value_scan_page_info_collect_value, "p", value_scan_page_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanPageInfo), 0, (GInstanceInitFunc) scan_page_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_page_info_type_id;
		scan_page_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanPageInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_page_info_type_id__volatile, scan_page_info_type_id);
	}
	return scan_page_info_type_id__volatile;
}


gpointer scan_page_info_ref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1492 "scanner.c"
}


void scan_page_info_unref (gpointer instance) {
	ScanPageInfo* self;
	self = instance;
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_PAGE_INFO_GET_CLASS (self)->finalize (self);
#line 20 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1505 "scanner.c"
	}
}


ScanLine* scan_line_construct (GType object_type) {
	ScanLine* self = NULL;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanLine*) g_type_create_instance (object_type);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1516 "scanner.c"
}


ScanLine* scan_line_new (void) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_line_construct (TYPE_SCAN_LINE);
#line 1523 "scanner.c"
}


static void value_scan_line_init (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1530 "scanner.c"
}


static void value_scan_line_free_value (GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (value->data[0].v_pointer);
#line 1539 "scanner.c"
	}
}


static void value_scan_line_copy_value (const GValue* src_value, GValue* dest_value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_line_ref (src_value->data[0].v_pointer);
#line 1549 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1553 "scanner.c"
	}
}


static gpointer value_scan_line_peek_pointer (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1561 "scanner.c"
}


static gchar* value_scan_line_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1568 "scanner.c"
		ScanLine* object;
		object = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1575 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1579 "scanner.c"
		}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_line_ref (object);
#line 1583 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1587 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1591 "scanner.c"
}


static gchar* value_scan_line_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanLine** object_p;
	object_p = collect_values[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1602 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1608 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1612 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_line_ref (value->data[0].v_pointer);
#line 1616 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1620 "scanner.c"
}


GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanLine* spec;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1634 "scanner.c"
}


gpointer value_get_scan_line (const GValue* value) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE), NULL);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1643 "scanner.c"
}


void value_set_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_ref (value->data[0].v_pointer);
#line 1663 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1667 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (old);
#line 1673 "scanner.c"
	}
}


void value_take_scan_line (GValue* value, gpointer v_object) {
	ScanLine* old;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_LINE));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1692 "scanner.c"
	} else {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1696 "scanner.c"
	}
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_line_unref (old);
#line 1702 "scanner.c"
	}
}


static void scan_line_class_init (ScanLineClass * klass) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_line_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScanLineClass *) klass)->finalize = scan_line_finalize;
#line 1712 "scanner.c"
}


static void scan_line_instance_init (ScanLine * self) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 1719 "scanner.c"
}


static void scan_line_finalize (ScanLine* obj) {
	ScanLine * self;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_LINE, ScanLine);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 55 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->data = (g_free (self->data), NULL);
#line 1731 "scanner.c"
}


GType scan_line_get_type (void) {
	static volatile gsize scan_line_type_id__volatile = 0;
	if (g_once_init_enter (&scan_line_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_line_init, value_scan_line_free_value, value_scan_line_copy_value, value_scan_line_peek_pointer, "p", value_scan_line_collect_value, "p", value_scan_line_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanLine), 0, (GInstanceInitFunc) scan_line_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_line_type_id;
		scan_line_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanLine", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_line_type_id__volatile, scan_line_type_id);
	}
	return scan_line_type_id__volatile;
}


gpointer scan_line_ref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 1756 "scanner.c"
}


void scan_line_unref (gpointer instance) {
	ScanLine* self;
	self = instance;
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_LINE_GET_CLASS (self)->finalize (self);
#line 39 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1769 "scanner.c"
	}
}


GType scan_mode_get_type (void) {
	static volatile gsize scan_mode_type_id__volatile = 0;
	if (g_once_init_enter (&scan_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_MODE_DEFAULT, "SCAN_MODE_DEFAULT", "default"}, {SCAN_MODE_COLOR, "SCAN_MODE_COLOR", "color"}, {SCAN_MODE_GRAY, "SCAN_MODE_GRAY", "gray"}, {SCAN_MODE_LINEART, "SCAN_MODE_LINEART", "lineart"}, {0, NULL, NULL}};
		GType scan_mode_type_id;
		scan_mode_type_id = g_enum_register_static ("ScanMode", values);
		g_once_init_leave (&scan_mode_type_id__volatile, scan_mode_type_id);
	}
	return scan_mode_type_id__volatile;
}


GType scan_type_get_type (void) {
	static volatile gsize scan_type_type_id__volatile = 0;
	if (g_once_init_enter (&scan_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_TYPE_SINGLE, "SCAN_TYPE_SINGLE", "single"}, {SCAN_TYPE_ADF_FRONT, "SCAN_TYPE_ADF_FRONT", "adf-front"}, {SCAN_TYPE_ADF_BACK, "SCAN_TYPE_ADF_BACK", "adf-back"}, {SCAN_TYPE_ADF_BOTH, "SCAN_TYPE_ADF_BOTH", "adf-both"}, {0, NULL, NULL}};
		GType scan_type_type_id;
		scan_type_type_id = g_enum_register_static ("ScanType", values);
		g_once_init_leave (&scan_type_type_id__volatile, scan_type_type_id);
	}
	return scan_type_type_id__volatile;
}


ScanOptions* scan_options_construct (GType object_type) {
	ScanOptions* self = NULL;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanOptions*) g_type_create_instance (object_type);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 1804 "scanner.c"
}


ScanOptions* scan_options_new (void) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_options_construct (TYPE_SCAN_OPTIONS);
#line 1811 "scanner.c"
}


static void value_scan_options_init (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 1818 "scanner.c"
}


static void value_scan_options_free_value (GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (value->data[0].v_pointer);
#line 1827 "scanner.c"
	}
}


static void value_scan_options_copy_value (const GValue* src_value, GValue* dest_value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_options_ref (src_value->data[0].v_pointer);
#line 1837 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1841 "scanner.c"
	}
}


static gpointer value_scan_options_peek_pointer (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1849 "scanner.c"
}


static gchar* value_scan_options_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 1856 "scanner.c"
		ScanOptions* object;
		object = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1863 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1867 "scanner.c"
		}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_options_ref (object);
#line 1871 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1875 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1879 "scanner.c"
}


static gchar* value_scan_options_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanOptions** object_p;
	object_p = collect_values[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1890 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 1896 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 1900 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_options_ref (value->data[0].v_pointer);
#line 1904 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 1908 "scanner.c"
}


GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanOptions* spec;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 1922 "scanner.c"
}


gpointer value_get_scan_options (const GValue* value) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS), NULL);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 1931 "scanner.c"
}


void value_set_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_ref (value->data[0].v_pointer);
#line 1951 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1955 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (old);
#line 1961 "scanner.c"
	}
}


void value_take_scan_options (GValue* value, gpointer v_object) {
	ScanOptions* old;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_OPTIONS));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 1980 "scanner.c"
	} else {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 1984 "scanner.c"
	}
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_options_unref (old);
#line 1990 "scanner.c"
	}
}


static void scan_options_class_init (ScanOptionsClass * klass) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_options_parent_class = g_type_class_peek_parent (klass);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScanOptionsClass *) klass)->finalize = scan_options_finalize;
#line 2000 "scanner.c"
}


static void scan_options_instance_init (ScanOptions * self) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2007 "scanner.c"
}


static void scan_options_finalize (ScanOptions* obj) {
	ScanOptions * self;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_OPTIONS, ScanOptions);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 2017 "scanner.c"
}


GType scan_options_get_type (void) {
	static volatile gsize scan_options_type_id__volatile = 0;
	if (g_once_init_enter (&scan_options_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_options_init, value_scan_options_free_value, value_scan_options_copy_value, value_scan_options_peek_pointer, "p", value_scan_options_collect_value, "p", value_scan_options_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanOptionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_options_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanOptions), 0, (GInstanceInitFunc) scan_options_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_options_type_id;
		scan_options_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanOptions", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_options_type_id__volatile, scan_options_type_id);
	}
	return scan_options_type_id__volatile;
}


gpointer scan_options_ref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2042 "scanner.c"
}


void scan_options_unref (gpointer instance) {
	ScanOptions* self;
	self = instance;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_OPTIONS_GET_CLASS (self)->finalize (self);
#line 75 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2055 "scanner.c"
	}
}


ScanJob* scan_job_construct (GType object_type) {
	ScanJob* self = NULL;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (ScanJob*) g_type_create_instance (object_type);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2066 "scanner.c"
}


ScanJob* scan_job_new (void) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scan_job_construct (TYPE_SCAN_JOB);
#line 2073 "scanner.c"
}


static void value_scan_job_init (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2080 "scanner.c"
}


static void value_scan_job_free_value (GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (value->data[0].v_pointer);
#line 2089 "scanner.c"
	}
}


static void value_scan_job_copy_value (const GValue* src_value, GValue* dest_value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scan_job_ref (src_value->data[0].v_pointer);
#line 2099 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2103 "scanner.c"
	}
}


static gpointer value_scan_job_peek_pointer (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2111 "scanner.c"
}


static gchar* value_scan_job_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2118 "scanner.c"
		ScanJob* object;
		object = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2125 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2129 "scanner.c"
		}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scan_job_ref (object);
#line 2133 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2137 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2141 "scanner.c"
}


static gchar* value_scan_job_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ScanJob** object_p;
	object_p = collect_values[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2152 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2158 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2162 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scan_job_ref (value->data[0].v_pointer);
#line 2166 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2170 "scanner.c"
}


GParamSpec* param_spec_scan_job (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanJob* spec;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2184 "scanner.c"
}


gpointer value_get_scan_job (const GValue* value) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB), NULL);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2193 "scanner.c"
}


void value_set_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_ref (value->data[0].v_pointer);
#line 2213 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2217 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (old);
#line 2223 "scanner.c"
	}
}


void value_take_scan_job (GValue* value, gpointer v_object) {
	ScanJob* old;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCAN_JOB));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2242 "scanner.c"
	} else {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2246 "scanner.c"
	}
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scan_job_unref (old);
#line 2252 "scanner.c"
	}
}


static void scan_job_class_init (ScanJobClass * klass) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scan_job_parent_class = g_type_class_peek_parent (klass);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScanJobClass *) klass)->finalize = scan_job_finalize;
#line 2262 "scanner.c"
}


static void scan_job_instance_init (ScanJob * self) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2269 "scanner.c"
}


static void scan_job_finalize (ScanJob* obj) {
	ScanJob * self;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCAN_JOB, ScanJob);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 90 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->device);
#line 2281 "scanner.c"
}


GType scan_job_get_type (void) {
	static volatile gsize scan_job_type_id__volatile = 0;
	if (g_once_init_enter (&scan_job_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scan_job_init, value_scan_job_free_value, value_scan_job_copy_value, value_scan_job_peek_pointer, "p", value_scan_job_collect_value, "p", value_scan_job_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScanJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scan_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScanJob), 0, (GInstanceInitFunc) scan_job_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scan_job_type_id;
		scan_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScanJob", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scan_job_type_id__volatile, scan_job_type_id);
	}
	return scan_job_type_id__volatile;
}


gpointer scan_job_ref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2306 "scanner.c"
}


void scan_job_unref (gpointer instance) {
	ScanJob* self;
	self = instance;
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCAN_JOB_GET_CLASS (self)->finalize (self);
#line 87 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2319 "scanner.c"
	}
}


Request* request_construct (GType object_type) {
	Request* self = NULL;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Request*) g_type_create_instance (object_type);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2330 "scanner.c"
}


Request* request_new (void) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_construct (TYPE_REQUEST);
#line 2337 "scanner.c"
}


static void value_request_init (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2344 "scanner.c"
}


static void value_request_free_value (GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (value->data[0].v_pointer);
#line 2353 "scanner.c"
	}
}


static void value_request_copy_value (const GValue* src_value, GValue* dest_value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = request_ref (src_value->data[0].v_pointer);
#line 2363 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2367 "scanner.c"
	}
}


static gpointer value_request_peek_pointer (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2375 "scanner.c"
}


static gchar* value_request_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2382 "scanner.c"
		Request* object;
		object = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2389 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2393 "scanner.c"
		}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = request_ref (object);
#line 2397 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2401 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2405 "scanner.c"
}


static gchar* value_request_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Request** object_p;
	object_p = collect_values[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2416 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2422 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2426 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = request_ref (value->data[0].v_pointer);
#line 2430 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2434 "scanner.c"
}


GParamSpec* param_spec_request (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecRequest* spec;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2448 "scanner.c"
}


gpointer value_get_request (const GValue* value) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST), NULL);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2457 "scanner.c"
}


void value_set_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_ref (value->data[0].v_pointer);
#line 2477 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2481 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (old);
#line 2487 "scanner.c"
	}
}


void value_take_request (GValue* value, gpointer v_object) {
	Request* old;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_REQUEST));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2506 "scanner.c"
	} else {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2510 "scanner.c"
	}
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_unref (old);
#line 2516 "scanner.c"
	}
}


static void request_class_init (RequestClass * klass) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_parent_class = g_type_class_peek_parent (klass);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((RequestClass *) klass)->finalize = request_finalize;
#line 2526 "scanner.c"
}


static void request_instance_init (Request * self) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2533 "scanner.c"
}


static void request_finalize (Request* obj) {
	Request * self;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST, Request);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 2543 "scanner.c"
}


GType request_get_type (void) {
	static volatile gsize request_type_id__volatile = 0;
	if (g_once_init_enter (&request_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_request_init, value_request_free_value, value_request_copy_value, value_request_peek_pointer, "p", value_request_collect_value, "p", value_request_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (RequestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Request), 0, (GInstanceInitFunc) request_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType request_type_id;
		request_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Request", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&request_type_id__volatile, request_type_id);
	}
	return request_type_id__volatile;
}


gpointer request_ref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 2568 "scanner.c"
}


void request_unref (gpointer instance) {
	Request* self;
	self = instance;
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		REQUEST_GET_CLASS (self)->finalize (self);
#line 101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2581 "scanner.c"
	}
}


RequestRedetect* request_redetect_construct (GType object_type) {
	RequestRedetect* self = NULL;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestRedetect*) request_construct (object_type);
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2592 "scanner.c"
}


RequestRedetect* request_redetect_new (void) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_redetect_construct (TYPE_REQUEST_REDETECT);
#line 2599 "scanner.c"
}


static void request_redetect_class_init (RequestRedetectClass * klass) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_redetect_parent_class = g_type_class_peek_parent (klass);
#line 2606 "scanner.c"
}


static void request_redetect_instance_init (RequestRedetect * self) {
}


GType request_redetect_get_type (void) {
	static volatile gsize request_redetect_type_id__volatile = 0;
	if (g_once_init_enter (&request_redetect_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestRedetectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_redetect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestRedetect), 0, (GInstanceInitFunc) request_redetect_instance_init, NULL };
		GType request_redetect_type_id;
		request_redetect_type_id = g_type_register_static (TYPE_REQUEST, "RequestRedetect", &g_define_type_info, 0);
		g_once_init_leave (&request_redetect_type_id__volatile, request_redetect_type_id);
	}
	return request_redetect_type_id__volatile;
}


RequestCancel* request_cancel_construct (GType object_type) {
	RequestCancel* self = NULL;
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestCancel*) request_construct (object_type);
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2632 "scanner.c"
}


RequestCancel* request_cancel_new (void) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_cancel_construct (TYPE_REQUEST_CANCEL);
#line 2639 "scanner.c"
}


static void request_cancel_class_init (RequestCancelClass * klass) {
#line 105 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_cancel_parent_class = g_type_class_peek_parent (klass);
#line 2646 "scanner.c"
}


static void request_cancel_instance_init (RequestCancel * self) {
}


GType request_cancel_get_type (void) {
	static volatile gsize request_cancel_type_id__volatile = 0;
	if (g_once_init_enter (&request_cancel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestCancelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_cancel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestCancel), 0, (GInstanceInitFunc) request_cancel_instance_init, NULL };
		GType request_cancel_type_id;
		request_cancel_type_id = g_type_register_static (TYPE_REQUEST, "RequestCancel", &g_define_type_info, 0);
		g_once_init_leave (&request_cancel_type_id__volatile, request_cancel_type_id);
	}
	return request_cancel_type_id__volatile;
}


RequestStartScan* request_start_scan_construct (GType object_type) {
	RequestStartScan* self = NULL;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestStartScan*) request_construct (object_type);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2672 "scanner.c"
}


RequestStartScan* request_start_scan_new (void) {
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_start_scan_construct (TYPE_REQUEST_START_SCAN);
#line 2679 "scanner.c"
}


static void request_start_scan_class_init (RequestStartScanClass * klass) {
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_start_scan_parent_class = g_type_class_peek_parent (klass);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((RequestClass *) klass)->finalize = request_start_scan_finalize;
#line 2688 "scanner.c"
}


static void request_start_scan_instance_init (RequestStartScan * self) {
}


static void request_start_scan_finalize (Request* obj) {
	RequestStartScan * self;
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REQUEST_START_SCAN, RequestStartScan);
#line 109 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (self->job);
#line 107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	REQUEST_CLASS (request_start_scan_parent_class)->finalize (obj);
#line 2704 "scanner.c"
}


GType request_start_scan_get_type (void) {
	static volatile gsize request_start_scan_type_id__volatile = 0;
	if (g_once_init_enter (&request_start_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestStartScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_start_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestStartScan), 0, (GInstanceInitFunc) request_start_scan_instance_init, NULL };
		GType request_start_scan_type_id;
		request_start_scan_type_id = g_type_register_static (TYPE_REQUEST, "RequestStartScan", &g_define_type_info, 0);
		g_once_init_leave (&request_start_scan_type_id__volatile, request_start_scan_type_id);
	}
	return request_start_scan_type_id__volatile;
}


RequestQuit* request_quit_construct (GType object_type) {
	RequestQuit* self = NULL;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (RequestQuit*) request_construct (object_type);
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2726 "scanner.c"
}


RequestQuit* request_quit_new (void) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return request_quit_construct (TYPE_REQUEST_QUIT);
#line 2733 "scanner.c"
}


static void request_quit_class_init (RequestQuitClass * klass) {
#line 112 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_quit_parent_class = g_type_class_peek_parent (klass);
#line 2740 "scanner.c"
}


static void request_quit_instance_init (RequestQuit * self) {
}


GType request_quit_get_type (void) {
	static volatile gsize request_quit_type_id__volatile = 0;
	if (g_once_init_enter (&request_quit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RequestQuitClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) request_quit_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RequestQuit), 0, (GInstanceInitFunc) request_quit_instance_init, NULL };
		GType request_quit_type_id;
		request_quit_type_id = g_type_register_static (TYPE_REQUEST, "RequestQuit", &g_define_type_info, 0);
		g_once_init_leave (&request_quit_type_id__volatile, request_quit_type_id);
	}
	return request_quit_type_id__volatile;
}


Credentials* credentials_construct (GType object_type) {
	Credentials* self = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Credentials*) g_type_create_instance (object_type);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 2766 "scanner.c"
}


Credentials* credentials_new (void) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return credentials_construct (TYPE_CREDENTIALS);
#line 2773 "scanner.c"
}


static void value_credentials_init (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 2780 "scanner.c"
}


static void value_credentials_free_value (GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (value->data[0].v_pointer);
#line 2789 "scanner.c"
	}
}


static void value_credentials_copy_value (const GValue* src_value, GValue* dest_value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = credentials_ref (src_value->data[0].v_pointer);
#line 2799 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2803 "scanner.c"
	}
}


static gpointer value_credentials_peek_pointer (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2811 "scanner.c"
}


static gchar* value_credentials_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 2818 "scanner.c"
		Credentials* object;
		object = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2825 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2829 "scanner.c"
		}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = credentials_ref (object);
#line 2833 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2837 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2841 "scanner.c"
}


static gchar* value_credentials_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Credentials** object_p;
	object_p = collect_values[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2852 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 2858 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 2862 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = credentials_ref (value->data[0].v_pointer);
#line 2866 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 2870 "scanner.c"
}


GParamSpec* param_spec_credentials (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecCredentials* spec;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 2884 "scanner.c"
}


gpointer value_get_credentials (const GValue* value) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS), NULL);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 2893 "scanner.c"
}


void value_set_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_ref (value->data[0].v_pointer);
#line 2913 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2917 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (old);
#line 2923 "scanner.c"
	}
}


void value_take_credentials (GValue* value, gpointer v_object) {
	Credentials* old;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CREDENTIALS));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 2942 "scanner.c"
	} else {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 2946 "scanner.c"
	}
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		credentials_unref (old);
#line 2952 "scanner.c"
	}
}


static void credentials_class_init (CredentialsClass * klass) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials_parent_class = g_type_class_peek_parent (klass);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((CredentialsClass *) klass)->finalize = credentials_finalize;
#line 2962 "scanner.c"
}


static void credentials_instance_init (Credentials * self) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 2969 "scanner.c"
}


static void credentials_finalize (Credentials* obj) {
	Credentials * self;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CREDENTIALS, Credentials);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->username);
#line 117 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->password);
#line 2983 "scanner.c"
}


GType credentials_get_type (void) {
	static volatile gsize credentials_type_id__volatile = 0;
	if (g_once_init_enter (&credentials_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_credentials_init, value_credentials_free_value, value_credentials_copy_value, value_credentials_peek_pointer, "p", value_credentials_collect_value, "p", value_credentials_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (CredentialsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) credentials_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Credentials), 0, (GInstanceInitFunc) credentials_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType credentials_type_id;
		credentials_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Credentials", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&credentials_type_id__volatile, credentials_type_id);
	}
	return credentials_type_id__volatile;
}


gpointer credentials_ref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 3008 "scanner.c"
}


void credentials_unref (gpointer instance) {
	Credentials* self;
	self = instance;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		CREDENTIALS_GET_CLASS (self)->finalize (self);
#line 114 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3021 "scanner.c"
	}
}


GType scan_state_get_type (void) {
	static volatile gsize scan_state_type_id__volatile = 0;
	if (g_once_init_enter (&scan_state_type_id__volatile)) {
		static const GEnumValue values[] = {{SCAN_STATE_IDLE, "SCAN_STATE_IDLE", "idle"}, {SCAN_STATE_REDETECT, "SCAN_STATE_REDETECT", "redetect"}, {SCAN_STATE_OPEN, "SCAN_STATE_OPEN", "open"}, {SCAN_STATE_GET_OPTION, "SCAN_STATE_GET_OPTION", "get-option"}, {SCAN_STATE_START, "SCAN_STATE_START", "start"}, {SCAN_STATE_GET_PARAMETERS, "SCAN_STATE_GET_PARAMETERS", "get-parameters"}, {SCAN_STATE_READ, "SCAN_STATE_READ", "read"}, {0, NULL, NULL}};
		GType scan_state_type_id;
		scan_state_type_id = g_enum_register_static ("ScanState", values);
		g_once_init_leave (&scan_state_type_id__volatile, scan_state_type_id);
	}
	return scan_state_type_id__volatile;
}


static void notify_real_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 3041 "scanner.c"
}


void notify_run (Notify* self, Scanner* scanner) {
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_GET_CLASS (self)->run (self, scanner);
#line 3050 "scanner.c"
}


Notify* notify_construct (GType object_type) {
	Notify* self = NULL;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Notify*) g_type_create_instance (object_type);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3060 "scanner.c"
}


Notify* notify_new (void) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_construct (TYPE_NOTIFY);
#line 3067 "scanner.c"
}


static void value_notify_init (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 3074 "scanner.c"
}


static void value_notify_free_value (GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (value->data[0].v_pointer);
#line 3083 "scanner.c"
	}
}


static void value_notify_copy_value (const GValue* src_value, GValue* dest_value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = notify_ref (src_value->data[0].v_pointer);
#line 3093 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 3097 "scanner.c"
	}
}


static gpointer value_notify_peek_pointer (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3105 "scanner.c"
}


static gchar* value_notify_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 3112 "scanner.c"
		Notify* object;
		object = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3119 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 3123 "scanner.c"
		}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = notify_ref (object);
#line 3127 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3131 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 3135 "scanner.c"
}


static gchar* value_notify_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Notify** object_p;
	object_p = collect_values[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 3146 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 3152 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 3156 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = notify_ref (value->data[0].v_pointer);
#line 3160 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 3164 "scanner.c"
}


GParamSpec* param_spec_notify (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecNotify* spec;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 3178 "scanner.c"
}


gpointer value_get_notify (const GValue* value) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY), NULL);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 3187 "scanner.c"
}


void value_set_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_ref (value->data[0].v_pointer);
#line 3207 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3211 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (old);
#line 3217 "scanner.c"
	}
}


void value_take_notify (GValue* value, gpointer v_object) {
	Notify* old;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NOTIFY));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 3236 "scanner.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 3240 "scanner.c"
	}
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		notify_unref (old);
#line 3246 "scanner.c"
	}
}


static void notify_class_init (NotifyClass * klass) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_parent_class = g_type_class_peek_parent (klass);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_finalize;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_real_run;
#line 3258 "scanner.c"
}


static void notify_instance_init (Notify * self) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 3265 "scanner.c"
}


static void notify_finalize (Notify* obj) {
	Notify * self;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY, Notify);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 3275 "scanner.c"
}


GType notify_get_type (void) {
	static volatile gsize notify_type_id__volatile = 0;
	if (g_once_init_enter (&notify_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_notify_init, value_notify_free_value, value_notify_copy_value, value_notify_peek_pointer, "p", value_notify_collect_value, "p", value_notify_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NotifyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Notify), 0, (GInstanceInitFunc) notify_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType notify_type_id;
		notify_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Notify", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&notify_type_id__volatile, notify_type_id);
	}
	return notify_type_id__volatile;
}


gpointer notify_ref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 3300 "scanner.c"
}


void notify_unref (gpointer instance) {
	Notify* self;
	self = instance;
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		NOTIFY_GET_CLASS (self)->finalize (self);
#line 131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3313 "scanner.c"
	}
}


static void notify_scanning_changed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanningChanged * self;
	Scanner* _tmp0_ = NULL;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanningChanged*) base;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 138 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scanning-changed");
#line 3329 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_construct (GType object_type) {
	NotifyScanningChanged* self = NULL;
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanningChanged*) notify_construct (object_type);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3339 "scanner.c"
}


NotifyScanningChanged* notify_scanning_changed_new (void) {
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_scanning_changed_construct (TYPE_NOTIFY_SCANNING_CHANGED);
#line 3346 "scanner.c"
}


static void notify_scanning_changed_class_init (NotifyScanningChangedClass * klass) {
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_scanning_changed_parent_class = g_type_class_peek_parent (klass);
#line 136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_scanning_changed_real_run;
#line 3355 "scanner.c"
}


static void notify_scanning_changed_instance_init (NotifyScanningChanged * self) {
}


GType notify_scanning_changed_get_type (void) {
	static volatile gsize notify_scanning_changed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scanning_changed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanningChangedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scanning_changed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanningChanged), 0, (GInstanceInitFunc) notify_scanning_changed_instance_init, NULL };
		GType notify_scanning_changed_type_id;
		notify_scanning_changed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanningChanged", &g_define_type_info, 0);
		g_once_init_leave (&notify_scanning_changed_type_id__volatile, notify_scanning_changed_type_id);
	}
	return notify_scanning_changed_type_id__volatile;
}


static void _scan_device_unref0_ (gpointer var) {
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 3378 "scanner.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_free (self);
#line 3387 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_construct (GType object_type, GList* devices) {
	NotifyUpdateDevices* self = NULL;
	GList* _tmp0_ = NULL;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyUpdateDevices*) notify_construct (object_type);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = devices;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->devices = _tmp0_;
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3408 "scanner.c"
}


NotifyUpdateDevices* notify_update_devices_new (GList* devices) {
#line 143 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_update_devices_construct (TYPE_NOTIFY_UPDATE_DEVICES, devices);
#line 3415 "scanner.c"
}


static void notify_update_devices_real_run (Notify* base, Scanner* scanner) {
	NotifyUpdateDevices * self;
	Scanner* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyUpdateDevices*) base;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->devices;
#line 145 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "update-devices", _tmp1_);
#line 3433 "scanner.c"
}


static void notify_update_devices_class_init (NotifyUpdateDevicesClass * klass) {
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_update_devices_parent_class = g_type_class_peek_parent (klass);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_update_devices_finalize;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyUpdateDevicesPrivate));
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_update_devices_real_run;
#line 3446 "scanner.c"
}


static void notify_update_devices_instance_init (NotifyUpdateDevices * self) {
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_UPDATE_DEVICES_GET_PRIVATE (self);
#line 3453 "scanner.c"
}


static void notify_update_devices_finalize (Notify* obj) {
	NotifyUpdateDevices * self;
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_UPDATE_DEVICES, NotifyUpdateDevices);
#line 144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (self->priv->devices);
#line 141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_update_devices_parent_class)->finalize (obj);
#line 3465 "scanner.c"
}


GType notify_update_devices_get_type (void) {
	static volatile gsize notify_update_devices_type_id__volatile = 0;
	if (g_once_init_enter (&notify_update_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyUpdateDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_update_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyUpdateDevices), 0, (GInstanceInitFunc) notify_update_devices_instance_init, NULL };
		GType notify_update_devices_type_id;
		notify_update_devices_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyUpdateDevices", &g_define_type_info, 0);
		g_once_init_leave (&notify_update_devices_type_id__volatile, notify_update_devices_type_id);
	}
	return notify_update_devices_type_id__volatile;
}


NotifyRequestAuthorization* notify_request_authorization_construct (GType object_type, const gchar* resource) {
	NotifyRequestAuthorization* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (resource != NULL, NULL);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyRequestAuthorization*) notify_construct (object_type);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = resource;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->resource = _tmp1_;
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3499 "scanner.c"
}


NotifyRequestAuthorization* notify_request_authorization_new (const gchar* resource) {
#line 150 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_request_authorization_construct (TYPE_NOTIFY_REQUEST_AUTHORIZATION, resource);
#line 3506 "scanner.c"
}


static void notify_request_authorization_real_run (Notify* base, Scanner* scanner) {
	NotifyRequestAuthorization * self;
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyRequestAuthorization*) base;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->resource;
#line 152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "request-authorization", _tmp1_);
#line 3524 "scanner.c"
}


static void notify_request_authorization_class_init (NotifyRequestAuthorizationClass * klass) {
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_request_authorization_parent_class = g_type_class_peek_parent (klass);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_request_authorization_finalize;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyRequestAuthorizationPrivate));
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_request_authorization_real_run;
#line 3537 "scanner.c"
}


static void notify_request_authorization_instance_init (NotifyRequestAuthorization * self) {
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_REQUEST_AUTHORIZATION_GET_PRIVATE (self);
#line 3544 "scanner.c"
}


static void notify_request_authorization_finalize (Notify* obj) {
	NotifyRequestAuthorization * self;
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_REQUEST_AUTHORIZATION, NotifyRequestAuthorization);
#line 151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->resource);
#line 148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_request_authorization_parent_class)->finalize (obj);
#line 3556 "scanner.c"
}


GType notify_request_authorization_get_type (void) {
	static volatile gsize notify_request_authorization_type_id__volatile = 0;
	if (g_once_init_enter (&notify_request_authorization_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyRequestAuthorizationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_request_authorization_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyRequestAuthorization), 0, (GInstanceInitFunc) notify_request_authorization_instance_init, NULL };
		GType notify_request_authorization_type_id;
		notify_request_authorization_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyRequestAuthorization", &g_define_type_info, 0);
		g_once_init_leave (&notify_request_authorization_type_id__volatile, notify_request_authorization_type_id);
	}
	return notify_request_authorization_type_id__volatile;
}


NotifyScanFailed* notify_scan_failed_construct (GType object_type, gint error_code, const gchar* error_string) {
	NotifyScanFailed* self = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (error_string != NULL, NULL);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanFailed*) notify_construct (object_type);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = error_code;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->error_code = _tmp0_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = error_string;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->error_string = _tmp2_;
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3595 "scanner.c"
}


NotifyScanFailed* notify_scan_failed_new (gint error_code, const gchar* error_string) {
#line 157 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_scan_failed_construct (TYPE_NOTIFY_SCAN_FAILED, error_code, error_string);
#line 3602 "scanner.c"
}


static void notify_scan_failed_real_run (Notify* base, Scanner* scanner) {
	NotifyScanFailed * self;
	Scanner* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyScanFailed*) base;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->error_code;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->error_string;
#line 160 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "scan-failed", _tmp1_, _tmp2_);
#line 3623 "scanner.c"
}


static void notify_scan_failed_class_init (NotifyScanFailedClass * klass) {
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_scan_failed_parent_class = g_type_class_peek_parent (klass);
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_scan_failed_finalize;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyScanFailedPrivate));
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_scan_failed_real_run;
#line 3636 "scanner.c"
}


static void notify_scan_failed_instance_init (NotifyScanFailed * self) {
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_SCAN_FAILED_GET_PRIVATE (self);
#line 3643 "scanner.c"
}


static void notify_scan_failed_finalize (Notify* obj) {
	NotifyScanFailed * self;
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_SCAN_FAILED, NotifyScanFailed);
#line 159 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->error_string);
#line 155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_scan_failed_parent_class)->finalize (obj);
#line 3655 "scanner.c"
}


GType notify_scan_failed_get_type (void) {
	static volatile gsize notify_scan_failed_type_id__volatile = 0;
	if (g_once_init_enter (&notify_scan_failed_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyScanFailedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_scan_failed_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyScanFailed), 0, (GInstanceInitFunc) notify_scan_failed_instance_init, NULL };
		GType notify_scan_failed_type_id;
		notify_scan_failed_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyScanFailed", &g_define_type_info, 0);
		g_once_init_leave (&notify_scan_failed_type_id__volatile, notify_scan_failed_type_id);
	}
	return notify_scan_failed_type_id__volatile;
}


static void notify_document_done_real_run (Notify* base, Scanner* scanner) {
	NotifyDocumentDone * self;
	Scanner* _tmp0_ = NULL;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyDocumentDone*) base;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "document-done");
#line 3682 "scanner.c"
}


NotifyDocumentDone* notify_document_done_construct (GType object_type) {
	NotifyDocumentDone* self = NULL;
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyDocumentDone*) notify_construct (object_type);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3692 "scanner.c"
}


NotifyDocumentDone* notify_document_done_new (void) {
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_document_done_construct (TYPE_NOTIFY_DOCUMENT_DONE);
#line 3699 "scanner.c"
}


static void notify_document_done_class_init (NotifyDocumentDoneClass * klass) {
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_document_done_parent_class = g_type_class_peek_parent (klass);
#line 163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_document_done_real_run;
#line 3708 "scanner.c"
}


static void notify_document_done_instance_init (NotifyDocumentDone * self) {
}


GType notify_document_done_get_type (void) {
	static volatile gsize notify_document_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_document_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyDocumentDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_document_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyDocumentDone), 0, (GInstanceInitFunc) notify_document_done_instance_init, NULL };
		GType notify_document_done_type_id;
		notify_document_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyDocumentDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_document_done_type_id__volatile, notify_document_done_type_id);
	}
	return notify_document_done_type_id__volatile;
}


static void notify_expect_page_real_run (Notify* base, Scanner* scanner) {
	NotifyExpectPage * self;
	Scanner* _tmp0_ = NULL;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyExpectPage*) base;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner;
#line 170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_emit_by_name (_tmp0_, "expect-page");
#line 3739 "scanner.c"
}


NotifyExpectPage* notify_expect_page_construct (GType object_type) {
	NotifyExpectPage* self = NULL;
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyExpectPage*) notify_construct (object_type);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3749 "scanner.c"
}


NotifyExpectPage* notify_expect_page_new (void) {
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_expect_page_construct (TYPE_NOTIFY_EXPECT_PAGE);
#line 3756 "scanner.c"
}


static void notify_expect_page_class_init (NotifyExpectPageClass * klass) {
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_expect_page_parent_class = g_type_class_peek_parent (klass);
#line 168 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_expect_page_real_run;
#line 3765 "scanner.c"
}


static void notify_expect_page_instance_init (NotifyExpectPage * self) {
}


GType notify_expect_page_get_type (void) {
	static volatile gsize notify_expect_page_type_id__volatile = 0;
	if (g_once_init_enter (&notify_expect_page_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyExpectPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_expect_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyExpectPage), 0, (GInstanceInitFunc) notify_expect_page_instance_init, NULL };
		GType notify_expect_page_type_id;
		notify_expect_page_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyExpectPage", &g_define_type_info, 0);
		g_once_init_leave (&notify_expect_page_type_id__volatile, notify_expect_page_type_id);
	}
	return notify_expect_page_type_id__volatile;
}


static gpointer _scan_page_info_ref0 (gpointer self) {
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_page_info_ref (self) : NULL;
#line 3788 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_construct (GType object_type, gint job_id, ScanPageInfo* info) {
	NotifyGotPageInfo* self = NULL;
	gint _tmp0_ = 0;
	ScanPageInfo* _tmp1_ = NULL;
	ScanPageInfo* _tmp2_ = NULL;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (info != NULL, NULL);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotPageInfo*) notify_construct (object_type);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = info;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_page_info_ref0 (_tmp1_);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->info = _tmp2_;
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3815 "scanner.c"
}


NotifyGotPageInfo* notify_got_page_info_new (gint job_id, ScanPageInfo* info) {
#line 175 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_got_page_info_construct (TYPE_NOTIFY_GOT_PAGE_INFO, job_id, info);
#line 3822 "scanner.c"
}


static void notify_got_page_info_real_run (Notify* base, Scanner* scanner) {
	NotifyGotPageInfo * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotPageInfo*) base;
#line 178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3844 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3856 "scanner.c"
	} else {
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3860 "scanner.c"
	}
#line 180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 3864 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanPageInfo* _tmp8_ = NULL;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->info;
#line 181 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-page-info", _tmp8_);
#line 3873 "scanner.c"
	}
}


static void notify_got_page_info_class_init (NotifyGotPageInfoClass * klass) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_got_page_info_parent_class = g_type_class_peek_parent (klass);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_got_page_info_finalize;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotPageInfoPrivate));
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_got_page_info_real_run;
#line 3887 "scanner.c"
}


static void notify_got_page_info_instance_init (NotifyGotPageInfo * self) {
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_GOT_PAGE_INFO_GET_PRIVATE (self);
#line 3894 "scanner.c"
}


static void notify_got_page_info_finalize (Notify* obj) {
	NotifyGotPageInfo * self;
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_PAGE_INFO, NotifyGotPageInfo);
#line 177 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (self->priv->info);
#line 173 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_got_page_info_parent_class)->finalize (obj);
#line 3906 "scanner.c"
}


GType notify_got_page_info_get_type (void) {
	static volatile gsize notify_got_page_info_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_page_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotPageInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_page_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotPageInfo), 0, (GInstanceInitFunc) notify_got_page_info_instance_init, NULL };
		GType notify_got_page_info_type_id;
		notify_got_page_info_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotPageInfo", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_page_info_type_id__volatile, notify_got_page_info_type_id);
	}
	return notify_got_page_info_type_id__volatile;
}


NotifyPageDone* notify_page_done_construct (GType object_type, gint job_id) {
	NotifyPageDone* self = NULL;
	gint _tmp0_ = 0;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyPageDone*) notify_construct (object_type);
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 3933 "scanner.c"
}


NotifyPageDone* notify_page_done_new (gint job_id) {
#line 187 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_page_done_construct (TYPE_NOTIFY_PAGE_DONE, job_id);
#line 3940 "scanner.c"
}


static void notify_page_done_real_run (Notify* base, Scanner* scanner) {
	NotifyPageDone * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyPageDone*) base;
#line 189 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 3962 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 3974 "scanner.c"
	} else {
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 3978 "scanner.c"
	}
#line 191 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 3982 "scanner.c"
		Scanner* _tmp7_ = NULL;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 192 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "page-done");
#line 3988 "scanner.c"
	}
}


static void notify_page_done_class_init (NotifyPageDoneClass * klass) {
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_page_done_parent_class = g_type_class_peek_parent (klass);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_page_done_finalize;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyPageDonePrivate));
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_page_done_real_run;
#line 4002 "scanner.c"
}


static void notify_page_done_instance_init (NotifyPageDone * self) {
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_PAGE_DONE_GET_PRIVATE (self);
#line 4009 "scanner.c"
}


static void notify_page_done_finalize (Notify* obj) {
	NotifyPageDone * self;
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_PAGE_DONE, NotifyPageDone);
#line 185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_page_done_parent_class)->finalize (obj);
#line 4019 "scanner.c"
}


GType notify_page_done_get_type (void) {
	static volatile gsize notify_page_done_type_id__volatile = 0;
	if (g_once_init_enter (&notify_page_done_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyPageDoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_page_done_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyPageDone), 0, (GInstanceInitFunc) notify_page_done_instance_init, NULL };
		GType notify_page_done_type_id;
		notify_page_done_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyPageDone", &g_define_type_info, 0);
		g_once_init_leave (&notify_page_done_type_id__volatile, notify_page_done_type_id);
	}
	return notify_page_done_type_id__volatile;
}


static gpointer _scan_line_ref0 (gpointer self) {
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_line_ref (self) : NULL;
#line 4038 "scanner.c"
}


NotifyGotLine* notify_got_line_construct (GType object_type, gint job_id, ScanLine* line) {
	NotifyGotLine* self = NULL;
	gint _tmp0_ = 0;
	ScanLine* _tmp1_ = NULL;
	ScanLine* _tmp2_ = NULL;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotLine*) notify_construct (object_type);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = job_id;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_id = _tmp0_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = line;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_line_ref0 (_tmp1_);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line = _tmp2_;
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 4065 "scanner.c"
}


NotifyGotLine* notify_got_line_new (gint job_id, ScanLine* line) {
#line 198 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return notify_got_line_construct (TYPE_NOTIFY_GOT_LINE, job_id, line);
#line 4072 "scanner.c"
}


static void notify_got_line_real_run (Notify* base, Scanner* scanner) {
	NotifyGotLine * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	Scanner* _tmp2_ = NULL;
	gint _tmp3_ = 0;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (NotifyGotLine*) base;
#line 201 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (scanner != NULL);
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->first_job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ >= _tmp3_) {
#line 4094 "scanner.c"
		gint _tmp4_ = 0;
		Scanner* _tmp5_ = NULL;
		gint _tmp6_ = 0;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = self->priv->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = scanner;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->job_id;
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_ < _tmp6_;
#line 4106 "scanner.c"
	} else {
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 4110 "scanner.c"
	}
#line 203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 4114 "scanner.c"
		Scanner* _tmp7_ = NULL;
		ScanLine* _tmp8_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = scanner;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->line;
#line 204 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_signal_emit_by_name (_tmp7_, "got-line", _tmp8_);
#line 4123 "scanner.c"
	}
}


static void notify_got_line_class_init (NotifyGotLineClass * klass) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_got_line_parent_class = g_type_class_peek_parent (klass);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->finalize = notify_got_line_finalize;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (NotifyGotLinePrivate));
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((NotifyClass *) klass)->run = notify_got_line_real_run;
#line 4137 "scanner.c"
}


static void notify_got_line_instance_init (NotifyGotLine * self) {
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = NOTIFY_GOT_LINE_GET_PRIVATE (self);
#line 4144 "scanner.c"
}


static void notify_got_line_finalize (Notify* obj) {
	NotifyGotLine * self;
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NOTIFY_GOT_LINE, NotifyGotLine);
#line 200 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_line_unref0 (self->priv->line);
#line 196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	NOTIFY_CLASS (notify_got_line_parent_class)->finalize (obj);
#line 4156 "scanner.c"
}


GType notify_got_line_get_type (void) {
	static volatile gsize notify_got_line_type_id__volatile = 0;
	if (g_once_init_enter (&notify_got_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NotifyGotLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) notify_got_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NotifyGotLine), 0, (GInstanceInitFunc) notify_got_line_instance_init, NULL };
		GType notify_got_line_type_id;
		notify_got_line_type_id = g_type_register_static (TYPE_NOTIFY, "NotifyGotLine", &g_define_type_info, 0);
		g_once_init_leave (&notify_got_line_type_id__volatile, notify_got_line_type_id);
	}
	return notify_got_line_type_id__volatile;
}


static void _scan_job_unref0_ (gpointer var) {
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (scan_job_unref (var), NULL));
#line 4175 "scanner.c"
}


static void _g_list_free__scan_job_unref0_ (GList* self) {
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_foreach (self, (GFunc) _scan_job_unref0_, NULL);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_list_free (self);
#line 4184 "scanner.c"
}


static void _request_unref0_ (gpointer var) {
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (request_unref (var), NULL));
#line 4191 "scanner.c"
}


static void _notify_unref0_ (gpointer var) {
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (notify_unref (var), NULL));
#line 4198 "scanner.c"
}


static void _credentials_unref0_ (gpointer var) {
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	(var == NULL) ? NULL : (var = (credentials_unref (var), NULL));
#line 4205 "scanner.c"
}


static Scanner* scanner_construct (GType object_type) {
	Scanner* self = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	GAsyncQueue* _tmp1_ = NULL;
	GAsyncQueue* _tmp2_ = NULL;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = (Scanner*) g_type_create_instance (object_type);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = g_async_queue_new_full (_request_unref0_);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->request_queue = _tmp0_;
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_async_queue_new_full (_notify_unref0_);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->notify_queue = _tmp1_;
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_async_queue_new_full (_credentials_unref0_);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 275 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->authorize_queue = _tmp2_;
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self;
#line 4236 "scanner.c"
}


static Scanner* scanner_new (void) {
#line 271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return scanner_construct (TYPE_SCANNER);
#line 4243 "scanner.c"
}


static gpointer _scanner_ref0 (gpointer self) {
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scanner_ref (self) : NULL;
#line 4250 "scanner.c"
}


Scanner* scanner_get_instance (void) {
	Scanner* result = NULL;
	Scanner* _tmp0_ = NULL;
	Scanner* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 280 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_ == NULL) {
#line 4263 "scanner.c"
		Scanner* _tmp1_ = NULL;
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = scanner_new ();
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scanner_unref0 (scanner_scanner_object);
#line 281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_scanner_object = _tmp1_;
#line 4271 "scanner.c"
	}
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner_scanner_object;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _scanner_ref0 (_tmp2_);
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp3_;
#line 282 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4281 "scanner.c"
}


static gboolean scanner_notify_idle_cb (Scanner* self) {
	gboolean result = FALSE;
	Notify* notification = NULL;
	GAsyncQueue* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
#line 285 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_async_queue_pop (_tmp0_);
#line 287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notification = (Notify*) _tmp1_;
#line 288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	notify_run (notification, self);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = FALSE;
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (notification);
#line 289 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4306 "scanner.c"
}


static gpointer _notify_ref0 (gpointer self) {
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? notify_ref (self) : NULL;
#line 4313 "scanner.c"
}


static gboolean _scanner_notify_idle_cb_gsource_func (gpointer self) {
	gboolean result;
	result = scanner_notify_idle_cb ((Scanner*) self);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4322 "scanner.c"
}


static void scanner_notify (Scanner* self, Notify* notification) {
	GAsyncQueue* _tmp0_ = NULL;
	Notify* _tmp1_ = NULL;
	Notify* _tmp2_ = NULL;
#line 292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (notification != NULL);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->notify_queue;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = notification;
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _notify_ref0 (_tmp1_);
#line 294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp0_, _tmp2_);
#line 295 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _scanner_notify_idle_cb_gsource_func, scanner_ref (self), scanner_unref);
#line 4344 "scanner.c"
}


static void scanner_set_scanning (Scanner* self, gboolean is_scanning) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 298 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_) {
#line 4358 "scanner.c"
		gboolean _tmp3_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = !_tmp3_;
#line 4364 "scanner.c"
	} else {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = FALSE;
#line 4368 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_) {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = TRUE;
#line 4374 "scanner.c"
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = self->priv->scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (!_tmp5_) {
#line 4382 "scanner.c"
			gboolean _tmp6_ = FALSE;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = is_scanning;
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = _tmp6_;
#line 4388 "scanner.c"
		} else {
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = FALSE;
#line 4392 "scanner.c"
		}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp4_;
#line 4396 "scanner.c"
	}
#line 300 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 4400 "scanner.c"
		gboolean _tmp7_ = FALSE;
		NotifyScanningChanged* _tmp8_ = NULL;
		NotifyScanningChanged* _tmp9_ = NULL;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = is_scanning;
#line 302 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->scanning = _tmp7_;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = notify_scanning_changed_new ();
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = _tmp8_;
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp9_);
#line 303 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp9_);
#line 4416 "scanner.c"
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1376 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = needle;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_ != NULL;
#line 1377 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 4437 "scanner.c"
}


static gint scanner_get_device_weight (const gchar* device) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
#line 307 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device != NULL, 0);
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = device;
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_str_has_prefix (_tmp0_, "vfl:");
#line 312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_) {
#line 313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = 2;
#line 313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4459 "scanner.c"
	}
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = device;
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = string_contains (_tmp2_, "usb");
#line 316 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_) {
#line 317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = 0;
#line 317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4471 "scanner.c"
	}
#line 319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = 1;
#line 319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4477 "scanner.c"
}


static gint scanner_compare_devices (ScanDevice* device1, ScanDevice* device2) {
	gint result = 0;
	gint weight1 = 0;
	ScanDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint weight2 = 0;
	ScanDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GCompareFunc _tmp10_ = NULL;
	ScanDevice* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	ScanDevice* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gint _tmp15_ = 0;
#line 322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device1 != NULL, 0);
#line 322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (device2 != NULL, 0);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = device1;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->name;
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = scanner_get_device_weight (_tmp1_);
#line 326 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	weight1 = _tmp2_;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = device2;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->name;
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = scanner_get_device_weight (_tmp4_);
#line 327 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	weight2 = _tmp5_;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = weight1;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = weight2;
#line 328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ != _tmp7_) {
#line 4525 "scanner.c"
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = weight1;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = weight2;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = _tmp8_ - _tmp9_;
#line 329 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 4536 "scanner.c"
	}
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = g_strcmp0;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = device1;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->label;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = device2;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_->label;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = _tmp10_ (_tmp12_, _tmp14_);
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp15_;
#line 331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4554 "scanner.c"
}


static gchar* sane_status_to_string (SANE_Status status) {
	gchar* result = NULL;
	SANE_Status _tmp0_ = 0;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	_tmp0_ = status;
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	switch (_tmp0_) {
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_GOOD:
#line 4567 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_STATUS_GOOD");
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp1_;
#line 57 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4576 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_UNSUPPORTED:
#line 4580 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_STATUS_UNSUPPORTED");
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp2_;
#line 59 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4589 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_CANCELLED:
#line 4593 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_STATUS_CANCELLED");
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp3_;
#line 61 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4602 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_DEVICE_BUSY:
#line 4606 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_STATUS_DEVICE_BUSY");
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp4_;
#line 63 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4615 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_INVAL:
#line 4619 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_STATUS_INVAL");
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp5_;
#line 65 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4628 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_EOF:
#line 4632 "scanner.c"
		{
			gchar* _tmp6_ = NULL;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp6_ = g_strdup ("SANE_STATUS_EOF");
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp6_;
#line 67 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4641 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_JAMMED:
#line 4645 "scanner.c"
		{
			gchar* _tmp7_ = NULL;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp7_ = g_strdup ("SANE_STATUS_JAMMED");
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp7_;
#line 69 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4654 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_NO_DOCS:
#line 4658 "scanner.c"
		{
			gchar* _tmp8_ = NULL;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp8_ = g_strdup ("SANE_STATUS_NO_DOCS");
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp8_;
#line 71 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4667 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_COVER_OPEN:
#line 4671 "scanner.c"
		{
			gchar* _tmp9_ = NULL;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp9_ = g_strdup ("SANE_STATUS_COVER_OPEN");
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp9_;
#line 73 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4680 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_IO_ERROR:
#line 4684 "scanner.c"
		{
			gchar* _tmp10_ = NULL;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp10_ = g_strdup ("SANE_STATUS_IO_ERROR");
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp10_;
#line 75 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4693 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_NO_MEM:
#line 4697 "scanner.c"
		{
			gchar* _tmp11_ = NULL;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp11_ = g_strdup ("SANE_STATUS_NO_MEM");
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp11_;
#line 77 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4706 "scanner.c"
		}
#line 54 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_STATUS_ACCESS_DENIED:
#line 4710 "scanner.c"
		{
			gchar* _tmp12_ = NULL;
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp12_ = g_strdup ("SANE_STATUS_ACCESS_DENIED");
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp12_;
#line 79 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4719 "scanner.c"
		}
		default:
		{
			SANE_Status _tmp13_ = 0;
			gchar* _tmp14_ = NULL;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp13_ = status;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp14_ = g_strdup_printf ("SANE_STATUS(%d)", (gint) _tmp13_);
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp14_;
#line 81 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 4733 "scanner.c"
		}
	}
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1380 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 4748 "scanner.c"
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4779 "scanner.c"
				goto __catch15_g_regex_error;
			}
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1382 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 4788 "scanner.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp6_ = regex;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp7_ = replacement;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = _tmp8_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 4804 "scanner.c"
				goto __catch15_g_regex_error;
			}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
			return NULL;
#line 4815 "scanner.c"
		}
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp9_ = _tmp5_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_tmp5_ = NULL;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		result = _tmp9_;
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_free0 (_tmp5_);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1383 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return result;
#line 4829 "scanner.c"
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1385 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 4843 "scanner.c"
	}
	__finally15:
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1381 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
		return NULL;
#line 4854 "scanner.c"
	}
}


static gpointer _scan_device_ref0 (gpointer self) {
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_device_ref (self) : NULL;
#line 4862 "scanner.c"
}


static gint _scanner_compare_devices_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = scanner_compare_devices ((ScanDevice*) a, (ScanDevice*) b);
#line 369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 4871 "scanner.c"
}


static void scanner_do_redetect (Scanner* self) {
	SANE_Device** device_list = NULL;
	gint device_list_length1 = 0;
	gint _device_list_size_ = 0;
	SANE_Status status = 0;
	SANE_Device** _tmp0_ = NULL;
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	GList* devices = NULL;
	GList* _tmp56_ = NULL;
	GList* _tmp63_ = NULL;
	NotifyUpdateDevices* _tmp64_ = NULL;
	NotifyUpdateDevices* _tmp65_ = NULL;
#line 334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list = NULL;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list_length1 = 0;
#line 336 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = sane_get_devices (&_tmp0_, FALSE);
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list = _tmp0_;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	device_list_length1 = -1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_device_list_size_ = device_list_length1;
#line 337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp1_;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = status;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:338: sane_get_devices () -> %s", _tmp4_);
#line 338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = status;
#line 339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 4923 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = status;
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 341 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:341: Unable to get SANE devices: %s", _tmp7_);
#line 342 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->need_redetect = FALSE;
#line 343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_IDLE;
#line 344 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 4938 "scanner.c"
	}
#line 347 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 4942 "scanner.c"
	{
		gint i = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 4947 "scanner.c"
		{
			gboolean _tmp8_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = TRUE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 4954 "scanner.c"
				SANE_Device** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				SANE_Device* _tmp12_ = NULL;
				SANE_Device** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp14_ = 0;
				SANE_Device* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				SANE_Device** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				SANE_Device* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				SANE_Device** _tmp21_ = NULL;
				gint _tmp21__length1 = 0;
				gint _tmp22_ = 0;
				SANE_Device* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				SANE_Device** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				gint _tmp26_ = 0;
				SANE_Device* _tmp27_ = NULL;
				const gchar* _tmp28_ = NULL;
				ScanDevice* scan_device = NULL;
				ScanDevice* _tmp29_ = NULL;
				ScanDevice* _tmp30_ = NULL;
				SANE_Device** _tmp31_ = NULL;
				gint _tmp31__length1 = 0;
				gint _tmp32_ = 0;
				SANE_Device* _tmp33_ = NULL;
				const gchar* _tmp34_ = NULL;
				gchar* _tmp35_ = NULL;
				gchar* vendor = NULL;
				SANE_Device** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				gint _tmp37_ = 0;
				SANE_Device* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				gchar* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				ScanDevice* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				SANE_Device** _tmp45_ = NULL;
				gint _tmp45__length1 = 0;
				gint _tmp46_ = 0;
				SANE_Device* _tmp47_ = NULL;
				const gchar* _tmp48_ = NULL;
				gchar* _tmp49_ = NULL;
				ScanDevice* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_ = NULL;
				ScanDevice* _tmp54_ = NULL;
				ScanDevice* _tmp55_ = NULL;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp8_) {
#line 5012 "scanner.c"
					gint _tmp9_ = 0;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp9_ + 1;
#line 5018 "scanner.c"
				}
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = FALSE;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10_ = device_list;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10__length1 = device_list_length1;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp11_ = i;
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = _tmp10_[_tmp11_];
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!(_tmp12_ != NULL)) {
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 5034 "scanner.c"
				}
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp14_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp15_ = _tmp13_[_tmp14_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = _tmp15_->name;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp18_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = _tmp17_[_tmp18_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp20_ = _tmp19_->vendor;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = _tmp21_[_tmp22_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp24_ = _tmp23_->model;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25_ = device_list;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25__length1 = device_list_length1;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp26_ = i;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp27_ = _tmp25_[_tmp26_];
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp28_ = _tmp27_->type;
#line 350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				g_debug ("scanner.vala:350: Device: name=\"%s\" vendor=\"%s\" model=\"%s\" type=" \
"\"%s\"", _tmp16_, _tmp20_, _tmp24_, _tmp28_);
#line 353 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp29_ = scan_device_new ();
#line 353 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scan_device = _tmp29_;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp30_ = scan_device;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp31_ = device_list;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp31__length1 = device_list_length1;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_ = i;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp33_ = _tmp31_[_tmp32_];
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp34_ = _tmp33_->name;
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp35_ = g_strdup (_tmp34_);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp30_->name);
#line 354 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp30_->name = _tmp35_;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36_ = device_list;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36__length1 = device_list_length1;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp37_ = i;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp38_ = _tmp36_[_tmp37_];
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp39_ = _tmp38_->vendor;
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp40_ = g_strdup (_tmp39_);
#line 357 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				vendor = _tmp40_;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp41_ = vendor;
#line 358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (g_strcmp0 (_tmp41_, "Hewlett-Packard") == 0) {
#line 5118 "scanner.c"
					gchar* _tmp42_ = NULL;
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp42_ = g_strdup ("HP");
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_g_free0 (vendor);
#line 359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					vendor = _tmp42_;
#line 5126 "scanner.c"
				}
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp43_ = scan_device;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp44_ = vendor;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp45_ = device_list;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp45__length1 = device_list_length1;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_ = i;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_ = _tmp45_[_tmp46_];
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_ = _tmp47_->model;
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_ = g_strdup_printf ("%s %s", _tmp44_, _tmp48_);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp43_->label);
#line 361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp43_->label = _tmp49_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_ = scan_device;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp51_ = _tmp50_->label;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp52_ = string_replace (_tmp51_, "_", " ");
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp53_ = _tmp52_;
#line 363 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp53_);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp54_ = scan_device;
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp55_ = _scan_device_ref0 (_tmp54_);
#line 365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				devices = g_list_append (devices, _tmp55_);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (vendor);
#line 348 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_scan_device_unref0 (scan_device);
#line 5168 "scanner.c"
			}
		}
	}
#line 369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = g_list_sort (devices, _scanner_compare_devices_gcompare_func);
#line 371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->need_redetect = FALSE;
#line 372 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_ = devices;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp56_ != NULL) {
#line 5182 "scanner.c"
		ScanDevice* device = NULL;
		GList* _tmp57_ = NULL;
		gconstpointer _tmp58_ = NULL;
		ScanDevice* _tmp59_ = NULL;
		ScanDevice* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_ = devices;
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58_ = g_list_nth_data (_tmp57_, (guint) 0);
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_ = _scan_device_ref0 ((ScanDevice*) _tmp58_);
#line 376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		device = _tmp59_;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp60_ = device;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp61_ = _tmp60_->name;
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_ = g_strdup (_tmp61_);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 377 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->default_device = _tmp62_;
#line 374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_device_unref0 (device);
#line 5210 "scanner.c"
	} else {
#line 380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (self->priv->default_device);
#line 380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->default_device = NULL;
#line 5216 "scanner.c"
	}
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp63_ = devices;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	devices = NULL;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = notify_update_devices_new (_tmp63_);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp65_ = _tmp64_;
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp65_);
#line 382 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp65_);
#line 334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_device_unref0_0 (devices);
#line 5232 "scanner.c"
}


static gint scanner_scale_int (Scanner* self, gint source_min, gint source_max, SANE_Option_Descriptor* option, gint value) {
	gint result = 0;
	gint v = 0;
	gint _tmp0_ = 0;
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Constraint_Type _tmp6_ = 0;
#line 385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 385 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0);
#line 387 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = value;
#line 387 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = _tmp0_;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = value;
#line 389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_INT, _tmp3_);
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_->constraint_type;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ == SANE_CONSTRAINT_RANGE) {
#line 5268 "scanner.c"
		SANE_Option_Descriptor* _tmp7_ = NULL;
		SANE_Range* _tmp8_ = NULL;
		SANE_Word _tmp9_ = {0};
		SANE_Option_Descriptor* _tmp10_ = NULL;
		SANE_Range* _tmp11_ = NULL;
		SANE_Word _tmp12_ = {0};
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = _tmp8_->max;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = option;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->constraint.range;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = _tmp11_->min;
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _tmp9_ != _tmp12_;
#line 5289 "scanner.c"
	} else {
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = FALSE;
#line 5293 "scanner.c"
	}
#line 391 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_) {
#line 5297 "scanner.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		SANE_Option_Descriptor* _tmp16_ = NULL;
		SANE_Range* _tmp17_ = NULL;
		SANE_Word _tmp18_ = {0};
		SANE_Option_Descriptor* _tmp19_ = NULL;
		SANE_Range* _tmp20_ = NULL;
		SANE_Word _tmp21_ = {0};
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		SANE_Option_Descriptor* _tmp26_ = NULL;
		SANE_Range* _tmp27_ = NULL;
		SANE_Word _tmp28_ = {0};
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		SANE_Option_Descriptor* _tmp33_ = NULL;
		SANE_Range* _tmp34_ = NULL;
		SANE_Word _tmp35_ = {0};
		SANE_Option_Descriptor* _tmp36_ = NULL;
		SANE_Range* _tmp37_ = NULL;
		SANE_Word _tmp38_ = {0};
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = v;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = source_min;
#line 393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp13_ - _tmp14_;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = v;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = option;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = _tmp16_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp18_ = _tmp17_->max;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = option;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint.range;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp21_ = _tmp20_->min;
#line 394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp15_ * ((gint) (_tmp18_ - _tmp21_));
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp22_ = v;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp23_ = source_max;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp24_ = source_min;
#line 395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp22_ / (_tmp23_ - _tmp24_);
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp25_ = v;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp26_ = option;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint.range;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp28_ = _tmp27_->min;
#line 396 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		v = _tmp25_ + ((gint) _tmp28_);
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp29_ = value;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp30_ = source_min;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = source_max;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = v;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = option;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _tmp33_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp35_ = _tmp34_->min;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp36_ = option;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37_ = _tmp36_->constraint.range;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp38_ = _tmp37_->max;
#line 397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:397: scale_int: scaling %d [min: %d, max: %d] to %d [min:" \
" %d, max: %d]", _tmp29_, _tmp30_, _tmp31_, _tmp32_, (gint) _tmp35_, (gint) _tmp38_);
#line 5386 "scanner.c"
	}
#line 401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = v;
#line 401 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 5392 "scanner.c"
}


static gboolean scanner_set_default_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Int _tmp1_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Status _tmp4_ = 0;
	SANE_Int _tmp5_ = {0};
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
	SANE_Status _tmp14_ = 0;
#line 404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->cap;
#line 407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if ((_tmp1_ & SANE_CAP_AUTOMATIC) == ((SANE_Int) 0)) {
#line 408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = FALSE;
#line 408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 5424 "scanner.c"
	}
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = handle;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option_index;
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_AUTO, NULL, NULL);
#line 410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp4_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = option_index;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:411: sane_control_option (%d, SANE_ACTION_SET_AUTO) -> %s", (gint) _tmp5_, _tmp8_);
#line 411 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = status;
#line 412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ != SANE_STATUS_GOOD) {
#line 5450 "scanner.c"
		SANE_Option_Descriptor* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		SANE_Status _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = option;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->name;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = status;
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = sane_strstatus (_tmp12_);
#line 413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:413: Error setting default option %s: %s", _tmp11_, _tmp13_);
#line 5465 "scanner.c"
	}
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = status;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp14_ == SANE_STATUS_GOOD;
#line 415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 5473 "scanner.c"
}


static void scanner_set_bool_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gboolean value, gboolean* _result_) {
	gboolean _vala_result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Bool v = {0};
	gboolean _tmp2_ = FALSE;
	SANE_Status status = 0;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Status _tmp5_ = 0;
	SANE_Bool _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	SANE_Int _tmp11_ = {0};
	SANE_Status _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 420 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_BOOL);
#line 422 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = value;
#line 422 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = (SANE_Bool) _tmp2_;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = handle;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = option_index;
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = sane_control_option (_tmp3_, _tmp4_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 423 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp5_;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = v;
#line 424 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = (gboolean) _tmp6_;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = value;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp8_) {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = "SANE_TRUE";
#line 5528 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = "SANE_FALSE";
#line 5532 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _vala_result;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp10_) {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = "SANE_TRUE";
#line 5540 "scanner.c"
	} else {
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = "SANE_FALSE";
#line 5544 "scanner.c"
	}
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = option_index;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = status;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = sane_status_to_string (_tmp12_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:425: sane_control_option (%d, SANE_ACTION_SET_VALUE, %s) " \
"-> (%s, %s)", (gint) _tmp11_, _tmp7_, _tmp14_, _tmp9_);
#line 425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 5562 "scanner.c"
	}
}


static void scanner_set_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gint value, gint* _result_) {
	gint _vala_result = 0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Int v = {0};
	gint _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp47_ = {0};
	SANE_Int _tmp48_ = {0};
	SANE_Status _tmp49_ = 0;
	SANE_Int _tmp50_ = {0};
	gint _tmp51_ = 0;
	gchar* _tmp52_ = NULL;
	gchar* _tmp53_ = NULL;
	SANE_Int _tmp54_ = {0};
	SANE_Int _tmp55_ = {0};
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp1_ == SANE_TYPE_INT);
#line 432 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = value;
#line 432 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = (SANE_Int) _tmp2_;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 433 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5605 "scanner.c"
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		SANE_Int _tmp12_ = {0};
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Range* _tmp14_ = NULL;
		SANE_Word _tmp15_ = {0};
		SANE_Int _tmp19_ = {0};
		SANE_Option_Descriptor* _tmp20_ = NULL;
		SANE_Range* _tmp21_ = NULL;
		SANE_Word _tmp22_ = {0};
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = _tmp6_->quant;
#line 435 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp7_ != ((SANE_Word) 0)) {
#line 5625 "scanner.c"
			SANE_Int _tmp8_ = {0};
			SANE_Option_Descriptor* _tmp9_ = NULL;
			SANE_Range* _tmp10_ = NULL;
			SANE_Word _tmp11_ = {0};
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = v;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = option;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = _tmp9_->constraint.range;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = _tmp10_->quant;
#line 436 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp8_ * _tmp11_;
#line 5640 "scanner.c"
		}
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = v;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = option;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->constraint.range;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = _tmp14_->min;
#line 437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp12_ < ((SANE_Int) _tmp15_)) {
#line 5652 "scanner.c"
			SANE_Option_Descriptor* _tmp16_ = NULL;
			SANE_Range* _tmp17_ = NULL;
			SANE_Word _tmp18_ = {0};
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = option;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = _tmp16_->constraint.range;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = _tmp17_->min;
#line 438 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp18_;
#line 5664 "scanner.c"
		}
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = v;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = option;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp21_ = _tmp20_->constraint.range;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp22_ = _tmp21_->max;
#line 439 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp19_ > ((SANE_Int) _tmp22_)) {
#line 5676 "scanner.c"
			SANE_Option_Descriptor* _tmp23_ = NULL;
			SANE_Range* _tmp24_ = NULL;
			SANE_Word _tmp25_ = {0};
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = option;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = _tmp23_->constraint.range;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = _tmp24_->max;
#line 440 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp25_;
#line 5688 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp26_ = NULL;
		SANE_Constraint_Type _tmp27_ = 0;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp26_ = option;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = _tmp26_->constraint_type;
#line 442 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp27_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5699 "scanner.c"
			gint distance = 0;
			gint nearest = 0;
			gint _tmp46_ = 0;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			distance = G_MAXINT;
#line 444 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			nearest = 0;
#line 5707 "scanner.c"
			{
				gint i = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 5712 "scanner.c"
				{
					gboolean _tmp28_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp28_ = TRUE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 5719 "scanner.c"
						gint _tmp30_ = 0;
						SANE_Option_Descriptor* _tmp31_ = NULL;
						SANE_Word* _tmp32_ = NULL;
						gint _tmp32__length1 = 0;
						SANE_Word _tmp33_ = {0};
						gint x = 0;
						SANE_Option_Descriptor* _tmp34_ = NULL;
						SANE_Word* _tmp35_ = NULL;
						gint _tmp35__length1 = 0;
						gint _tmp36_ = 0;
						SANE_Word _tmp37_ = {0};
						gint d = 0;
						gint _tmp38_ = 0;
						SANE_Int _tmp39_ = {0};
						gint _tmp40_ = 0;
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						gint _tmp43_ = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp28_) {
#line 5740 "scanner.c"
							gint _tmp29_ = 0;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp29_ = i;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp29_ + 1;
#line 5746 "scanner.c"
						}
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp28_ = FALSE;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp30_ = i;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp31_ = option;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp32_ = _tmp31_->constraint.word_list;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp32__length1 = -1;
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp33_ = _tmp32_[0];
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp30_) < _tmp33_)) {
#line 447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 5764 "scanner.c"
						}
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp34_ = option;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp35_ = _tmp34_->constraint.word_list;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp35__length1 = -1;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp36_ = i;
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp37_ = _tmp35_[_tmp36_ + 1];
#line 449 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						x = (gint) _tmp37_;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp38_ = x;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp39_ = v;
#line 450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						d = (gint) (_tmp38_ - _tmp39_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp40_ = d;
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp41_ = abs (_tmp40_);
#line 451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						d = _tmp41_;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp42_ = d;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp43_ = distance;
#line 452 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp42_ < _tmp43_) {
#line 5796 "scanner.c"
							gint _tmp44_ = 0;
							gint _tmp45_ = 0;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp44_ = d;
#line 454 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							distance = _tmp44_;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp45_ = x;
#line 455 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							nearest = _tmp45_;
#line 5807 "scanner.c"
						}
					}
				}
			}
#line 458 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp46_ = nearest;
#line 458 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = (SANE_Int) _tmp46_;
#line 5816 "scanner.c"
		}
	}
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp47_ = handle;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = option_index;
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = sane_control_option (_tmp47_, _tmp48_, SANE_ACTION_SET_VALUE, &v, NULL);
#line 461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp49_;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = option_index;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = value;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp52_ = sane_status_to_string (status);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp53_ = _tmp52_;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = v;
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:462: sane_control_option (%d, SANE_ACTION_SET_VALUE, %d) " \
"-> (%s, %d)", (gint) _tmp50_, _tmp51_, _tmp53_, (gint) _tmp54_);
#line 462 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp53_);
#line 463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = v;
#line 463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = (gint) _tmp55_;
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 5849 "scanner.c"
	}
}


static void scanner_set_fixed_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gdouble v = 0.0;
	gdouble _tmp0_ = 0.0;
	SANE_Fixed v_fixed = {0};
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Constraint_Type _tmp4_ = 0;
	gdouble _tmp41_ = 0.0;
	SANE_Fixed _tmp42_ = {0};
	SANE_Status status = 0;
	SANE_Handle _tmp43_ = {0};
	SANE_Int _tmp44_ = {0};
	SANE_Status _tmp45_ = 0;
	SANE_Int _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_ = 0.0;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 468 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = value;
#line 468 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v = _tmp0_;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (_tmp2_ == SANE_TYPE_FIXED);
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->constraint_type;
#line 473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp4_ == SANE_CONSTRAINT_RANGE) {
#line 5895 "scanner.c"
		gdouble min = 0.0;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		SANE_Range* _tmp6_ = NULL;
		SANE_Word _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gdouble max = 0.0;
		SANE_Option_Descriptor* _tmp9_ = NULL;
		SANE_Range* _tmp10_ = NULL;
		SANE_Word _tmp11_ = {0};
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->constraint.range;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = _tmp6_->min;
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = SANE_UNFIX ((SANE_Fixed) _tmp7_);
#line 475 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		min = _tmp8_;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = option;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = _tmp9_->constraint.range;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = _tmp10_->max;
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = SANE_UNFIX ((SANE_Fixed) _tmp11_);
#line 476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		max = _tmp12_;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = v;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = min;
#line 478 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp13_ < _tmp14_) {
#line 5936 "scanner.c"
			gdouble _tmp15_ = 0.0;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = min;
#line 479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp15_;
#line 5942 "scanner.c"
		}
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = v;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = max;
#line 480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp16_ > _tmp17_) {
#line 5950 "scanner.c"
			gdouble _tmp18_ = 0.0;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = max;
#line 481 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp18_;
#line 5956 "scanner.c"
		}
	} else {
		SANE_Option_Descriptor* _tmp19_ = NULL;
		SANE_Constraint_Type _tmp20_ = 0;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = option;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_->constraint_type;
#line 483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp20_ == SANE_CONSTRAINT_WORD_LIST) {
#line 5967 "scanner.c"
			gdouble distance = 0.0;
			gdouble nearest = 0.0;
			gdouble _tmp40_ = 0.0;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			distance = DBL_MAX;
#line 485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			nearest = 0.0;
#line 5975 "scanner.c"
			{
				gint i = 0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 5980 "scanner.c"
				{
					gboolean _tmp21_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp21_ = TRUE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 5987 "scanner.c"
						gint _tmp23_ = 0;
						SANE_Option_Descriptor* _tmp24_ = NULL;
						SANE_Word* _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						SANE_Word _tmp26_ = {0};
						gdouble x = 0.0;
						SANE_Option_Descriptor* _tmp27_ = NULL;
						SANE_Word* _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						gint _tmp29_ = 0;
						SANE_Word _tmp30_ = {0};
						gdouble _tmp31_ = 0.0;
						gdouble _tmp32_ = 0.0;
						gdouble _tmp33_ = 0.0;
						gdouble _tmp34_ = 0.0;
						gdouble _tmp35_ = 0.0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp21_) {
#line 6006 "scanner.c"
							gint _tmp22_ = 0;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp22_ = i;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp22_ + 1;
#line 6012 "scanner.c"
						}
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp21_ = FALSE;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp23_ = i;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp24_ = option;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp25_ = _tmp24_->constraint.word_list;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp25__length1 = -1;
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp26_ = _tmp25_[0];
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp23_) < _tmp26_)) {
#line 488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6030 "scanner.c"
						}
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp27_ = option;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp28_ = _tmp27_->constraint.word_list;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp28__length1 = -1;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp29_ = i;
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp30_ = _tmp28_[_tmp29_ + 1];
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp31_ = SANE_UNFIX ((SANE_Fixed) _tmp30_);
#line 490 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						x = _tmp31_;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp32_ = x;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp33_ = v;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp34_ = fabs (_tmp32_ - _tmp33_);
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp35_ = distance;
#line 491 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp34_ < _tmp35_) {
#line 6056 "scanner.c"
							gdouble _tmp36_ = 0.0;
							gdouble _tmp37_ = 0.0;
							gdouble _tmp38_ = 0.0;
							gdouble _tmp39_ = 0.0;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp36_ = x;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp37_ = v;
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp38_ = fabs (_tmp36_ - _tmp37_);
#line 493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							distance = _tmp38_;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp39_ = x;
#line 494 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							nearest = _tmp39_;
#line 6073 "scanner.c"
						}
					}
				}
			}
#line 497 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp40_ = nearest;
#line 497 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			v = _tmp40_;
#line 6082 "scanner.c"
		}
	}
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = v;
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = SANE_FIX (_tmp41_);
#line 500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	v_fixed = _tmp42_;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = handle;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = option_index;
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = sane_control_option (_tmp43_, _tmp44_, SANE_ACTION_SET_VALUE, &v_fixed, NULL);
#line 501 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp45_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp46_ = option_index;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp47_ = value;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = sane_status_to_string (status);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = _tmp48_;
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = SANE_UNFIX (v_fixed);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:502: sane_control_option (%d, SANE_ACTION_SET_VALUE, %f) " \
"-> (%s, %f)", (gint) _tmp46_, _tmp47_, _tmp49_, _tmp50_);
#line 502 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp49_);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = SANE_UNFIX (v_fixed);
#line 504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp51_;
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6121 "scanner.c"
	}
}


static void scanner_set_fixed_or_int_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gdouble value, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 509 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SANE_TYPE_FIXED) {
#line 6140 "scanner.c"
		SANE_Handle _tmp2_ = {0};
		SANE_Option_Descriptor* _tmp3_ = NULL;
		SANE_Int _tmp4_ = {0};
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = handle;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = option;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = option_index;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = value;
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_set_fixed_option (self, _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_tmp6_);
#line 510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_vala_result = _tmp6_;
#line 6158 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp7_ = NULL;
		SANE_Value_Type _tmp8_ = 0;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = option;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_->type;
#line 511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp8_ == SANE_TYPE_INT) {
#line 6168 "scanner.c"
			gint r = 0;
			SANE_Handle _tmp9_ = {0};
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gdouble _tmp12_ = 0.0;
			gdouble _tmp13_ = 0.0;
			gint _tmp14_ = 0;
			gint _tmp15_ = 0;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = handle;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = option;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = option_index;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp12_ = value;
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = round (_tmp12_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_int_option (self, _tmp9_, _tmp10_, _tmp11_, (gint) _tmp13_, &_tmp14_);
#line 514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			r = _tmp14_;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = r;
#line 515 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_vala_result = (gdouble) _tmp15_;
#line 6195 "scanner.c"
		} else {
#line 519 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_vala_result = 0.0;
#line 520 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:520: Unable to set unsupported option type");
#line 6201 "scanner.c"
		}
	}
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 507 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6208 "scanner.c"
	}
}


static void scanner_set_option_to_max (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index) {
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Constraint_Type _tmp1_ = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp2_ = {0};
	SANE_Int _tmp3_ = {0};
	SANE_Option_Descriptor* _tmp4_ = NULL;
	SANE_Range* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	SANE_Int _tmp7_ = {0};
	SANE_Status _tmp8_ = 0;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
#line 524 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 524 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->constraint_type;
#line 526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ != SANE_CONSTRAINT_RANGE) {
#line 527 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 6238 "scanner.c"
	}
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = handle;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option_index;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = option;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->constraint.range;
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = sane_control_option (_tmp2_, _tmp3_, SANE_ACTION_SET_VALUE, &_tmp5_->max, NULL);
#line 529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp6_;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = option_index;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = status;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = sane_status_to_string (_tmp8_);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _tmp9_;
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:530: sane_control_option (%d, SANE_ACTION_SET_VALUE, opti" \
"on.range.max) -> (%s)", (gint) _tmp7_, _tmp10_);
#line 530 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp10_);
#line 6264 "scanner.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
#line 1086 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1087 "/usr/share/vala-0.34/vapi/glib-2.0.vapi"
	return result;
#line 6282 "scanner.c"
}


static gboolean scanner_set_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, const gchar* value, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	SANE_Option_Descriptor* _tmp1_ = NULL;
	SANE_Value_Type _tmp2_ = 0;
	gchar* s = NULL;
	SANE_Option_Descriptor* _tmp3_ = NULL;
	SANE_Int _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	gint s_length1 = 0;
	gint _s_size_ = 0;
	gint i = 0;
	gchar* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gchar _tmp23_ = '\0';
	SANE_Status status = 0;
	SANE_Handle _tmp24_ = {0};
	SANE_Int _tmp25_ = {0};
	gchar* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gchar* _tmp29_ = NULL;
	SANE_Int _tmp30_ = {0};
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (value != NULL, FALSE);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = g_strdup ("");
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp0_;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = option;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _tmp1_->type;
#line 537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp2_ == SANE_TYPE_STRING, FALSE);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = option;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->size;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = g_new0 (gchar, _tmp4_);
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp5_;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s_length1 = _tmp4_;
#line 539 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_s_size_ = s_length1;
#line 540 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	i = 0;
#line 6349 "scanner.c"
	{
		gboolean _tmp6_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = TRUE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		while (TRUE) {
#line 6356 "scanner.c"
			gboolean _tmp8_ = FALSE;
			gint _tmp9_ = 0;
			SANE_Option_Descriptor* _tmp10_ = NULL;
			SANE_Int _tmp11_ = {0};
			gchar* _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint _tmp16_ = 0;
			const gchar* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gchar _tmp19_ = '\0';
			gchar _tmp20_ = '\0';
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp6_) {
#line 6370 "scanner.c"
				gint _tmp7_ = 0;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = _tmp7_ + 1;
#line 6376 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = FALSE;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = option;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = _tmp10_->size;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (((SANE_Int) _tmp9_) < (_tmp11_ - 1)) {
#line 6388 "scanner.c"
				const gchar* _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar _tmp14_ = '\0';
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = value;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = i;
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp14_ = string_get (_tmp12_, (glong) _tmp13_);
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = _tmp14_ != '\0';
#line 6400 "scanner.c"
			} else {
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = FALSE;
#line 6404 "scanner.c"
			}
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp8_) {
#line 541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 6410 "scanner.c"
			}
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = s;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15__length1 = s_length1;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = i;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = value;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = i;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp19_ = string_get (_tmp17_, (glong) _tmp18_);
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_[_tmp16_] = _tmp19_;
#line 542 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = _tmp15_[_tmp16_];
#line 6428 "scanner.c"
		}
	}
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = s;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21__length1 = s_length1;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = i;
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_[_tmp22_] = '\0';
#line 543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = _tmp21_[_tmp22_];
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = handle;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = option_index;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = s;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26__length1 = s_length1;
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = sane_control_option (_tmp24_, _tmp25_, SANE_ACTION_SET_VALUE, _tmp26_, NULL);
#line 544 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp27_;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = s;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28__length1 = s_length1;
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = g_strdup ((const gchar*) _tmp28_);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 545 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp29_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = option_index;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = value;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = sane_status_to_string (status);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = _tmp32_;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = _vala_result;
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:546: sane_control_option (%d, SANE_ACTION_SET_VALUE, \"%s" \
"\") -> (%s, \"%s\")", (gint) _tmp30_, _tmp31_, _tmp33_, _tmp34_);
#line 546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp33_);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = status == SANE_STATUS_GOOD;
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = (g_free (s), NULL);
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6485 "scanner.c"
	} else {
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6489 "scanner.c"
	}
#line 548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 6493 "scanner.c"
}


static gboolean scanner_set_constrained_string_option (Scanner* self, SANE_Handle handle, SANE_Option_Descriptor* option, SANE_Int option_index, gchar** values, int values_length1, gchar** _result_) {
	gchar* _vala_result = NULL;
	gboolean result = FALSE;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Value_Type _tmp1_ = 0;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	SANE_Constraint_Type _tmp3_ = 0;
	gchar* _tmp34_ = NULL;
#line 551 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 551 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, FALSE);
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->type;
#line 553 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp1_ == SANE_TYPE_STRING, FALSE);
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = option;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->constraint_type;
#line 554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (_tmp3_ == SANE_CONSTRAINT_STRING_LIST, FALSE);
#line 6521 "scanner.c"
	{
		gint i = 0;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 6526 "scanner.c"
		{
			gboolean _tmp4_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = TRUE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 6533 "scanner.c"
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp7_ = 0;
				const gchar* _tmp8_ = NULL;
				gint j = 0;
				SANE_Option_Descriptor* _tmp22_ = NULL;
				gchar** _tmp23_ = NULL;
				gint _tmp23__length1 = 0;
				gint _tmp24_ = 0;
				const gchar* _tmp25_ = NULL;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp4_) {
#line 6546 "scanner.c"
					gint _tmp5_ = 0;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp5_ = i;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp5_ + 1;
#line 6552 "scanner.c"
				}
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp4_ = FALSE;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp6_ = values;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp6__length1 = values_length1;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = i;
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp8_ = _tmp6_[_tmp7_];
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!(_tmp8_ != NULL)) {
#line 556 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 6568 "scanner.c"
				}
#line 558 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				j = 0;
#line 6572 "scanner.c"
				{
					gboolean _tmp9_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = TRUE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 6579 "scanner.c"
						SANE_Option_Descriptor* _tmp11_ = NULL;
						gchar** _tmp12_ = NULL;
						gint _tmp12__length1 = 0;
						gint _tmp13_ = 0;
						const gchar* _tmp14_ = NULL;
						gchar** _tmp15_ = NULL;
						gint _tmp15__length1 = 0;
						gint _tmp16_ = 0;
						const gchar* _tmp17_ = NULL;
						SANE_Option_Descriptor* _tmp18_ = NULL;
						gchar** _tmp19_ = NULL;
						gint _tmp19__length1 = 0;
						gint _tmp20_ = 0;
						const gchar* _tmp21_ = NULL;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp9_) {
#line 6596 "scanner.c"
							gint _tmp10_ = 0;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp10_ = j;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							j = _tmp10_ + 1;
#line 6602 "scanner.c"
						}
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp9_ = FALSE;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp11_ = option;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp12_ = _tmp11_->constraint.string_list;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp12__length1 = _vala_array_length (_tmp11_->constraint.string_list);
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp13_ = j;
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp14_ = _tmp12_[_tmp13_];
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp14_ != NULL)) {
#line 559 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6620 "scanner.c"
						}
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp15_ = values;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp15__length1 = values_length1;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp16_ = i;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp17_ = _tmp15_[_tmp16_];
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp18_ = option;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp19_ = _tmp18_->constraint.string_list;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp19__length1 = _vala_array_length (_tmp18_->constraint.string_list);
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp20_ = j;
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp21_ = _tmp19_[_tmp20_];
#line 561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (g_strcmp0 (_tmp17_, _tmp21_) == 0) {
#line 562 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 6644 "scanner.c"
						}
					}
				}
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = option;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = _tmp22_->constraint.string_list;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23__length1 = _vala_array_length (_tmp22_->constraint.string_list);
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp24_ = j;
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp25_ = _tmp23_[_tmp24_];
#line 565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp25_ != NULL) {
#line 6660 "scanner.c"
					SANE_Handle _tmp26_ = {0};
					SANE_Option_Descriptor* _tmp27_ = NULL;
					SANE_Int _tmp28_ = {0};
					gchar** _tmp29_ = NULL;
					gint _tmp29__length1 = 0;
					gint _tmp30_ = 0;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp26_ = handle;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp27_ = option;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp28_ = option_index;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp29_ = values;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp29__length1 = values_length1;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp30_ = i;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp31_ = _tmp29_[_tmp30_];
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp33_ = scanner_set_string_option (self, _tmp26_, _tmp27_, _tmp28_, _tmp31_, &_tmp32_);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_g_free0 (_vala_result);
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_vala_result = _tmp32_;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					result = _tmp33_;
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (_result_) {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						*_result_ = _vala_result;
#line 6696 "scanner.c"
					} else {
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (_vala_result);
#line 6700 "scanner.c"
					}
#line 566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					return result;
#line 6704 "scanner.c"
				}
			}
		}
	}
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = g_strdup ("");
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_vala_result);
#line 569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_result = _tmp34_;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = FALSE;
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_result_) {
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*_result_ = _vala_result;
#line 6721 "scanner.c"
	} else {
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_vala_result);
#line 6725 "scanner.c"
	}
#line 570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 6729 "scanner.c"
}


static void scanner_log_option (Scanner* self, SANE_Int index, SANE_Option_Descriptor* option) {
	gchar* s = NULL;
	SANE_Int _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	SANE_Option_Descriptor* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	SANE_Option_Descriptor* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SANE_Option_Descriptor* _tmp18_ = NULL;
	SANE_Value_Type _tmp19_ = 0;
	const gchar* _tmp38_ = NULL;
	SANE_Option_Descriptor* _tmp39_ = NULL;
	SANE_Int _tmp40_ = {0};
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	SANE_Option_Descriptor* _tmp44_ = NULL;
	SANE_Unit _tmp45_ = 0;
	SANE_Option_Descriptor* _tmp64_ = NULL;
	SANE_Constraint_Type _tmp65_ = 0;
	SANE_Int cap = {0};
	SANE_Option_Descriptor* _tmp149_ = NULL;
	SANE_Int _tmp150_ = {0};
	SANE_Int _tmp151_ = {0};
	const gchar* _tmp216_ = NULL;
	SANE_Option_Descriptor* _tmp217_ = NULL;
	const gchar* _tmp218_ = NULL;
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (option != NULL);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = index;
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = g_strdup_printf ("Option %d:", (gint) _tmp0_);
#line 575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp1_;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = option;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_->name;
#line 577 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_strcmp0 (_tmp3_, "") != 0) {
#line 6776 "scanner.c"
		const gchar* _tmp4_ = NULL;
		SANE_Option_Descriptor* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = s;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = option;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = _tmp5_->name;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = g_strdup_printf (" name='%s'", _tmp6_);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = _tmp7_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = g_strconcat (_tmp4_, _tmp8_, NULL);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp9_;
#line 578 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp8_);
#line 6801 "scanner.c"
	}
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = option;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->title;
#line 580 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_strcmp0 (_tmp11_, "") != 0) {
#line 6809 "scanner.c"
		const gchar* _tmp12_ = NULL;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = s;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = option;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->title;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = g_strdup_printf (" title='%s'", _tmp14_);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp17_;
#line 581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp16_);
#line 6834 "scanner.c"
	}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = option;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = _tmp18_->type;
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp19_) {
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_BOOL:
#line 6844 "scanner.c"
		{
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = s;
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = g_strconcat (_tmp20_, " type=bool", NULL);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 586 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp21_;
#line 587 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6858 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_INT:
#line 6862 "scanner.c"
		{
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = s;
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = g_strconcat (_tmp22_, " type=int", NULL);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp23_;
#line 590 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6876 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_FIXED:
#line 6880 "scanner.c"
		{
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = s;
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = g_strconcat (_tmp24_, " type=fixed", NULL);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 592 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp25_;
#line 593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6894 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_STRING:
#line 6898 "scanner.c"
		{
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = s;
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp27_ = g_strconcat (_tmp26_, " type=string", NULL);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 595 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp27_;
#line 596 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6912 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_BUTTON:
#line 6916 "scanner.c"
		{
			const gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = s;
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_ = g_strconcat (_tmp28_, " type=button", NULL);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp29_;
#line 599 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6930 "scanner.c"
		}
#line 583 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_TYPE_GROUP:
#line 6934 "scanner.c"
		{
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp30_ = s;
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp31_ = g_strconcat (_tmp30_, " type=group", NULL);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 601 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp31_;
#line 602 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6948 "scanner.c"
		}
		default:
		{
			const gchar* _tmp32_ = NULL;
			SANE_Option_Descriptor* _tmp33_ = NULL;
			SANE_Value_Type _tmp34_ = 0;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp32_ = s;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp33_ = option;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp34_ = _tmp33_->type;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp35_ = g_strdup_printf (" type=%d", (gint) _tmp34_);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp36_ = _tmp35_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_ = g_strconcat (_tmp32_, _tmp36_, NULL);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp37_;
#line 604 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp36_);
#line 605 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 6978 "scanner.c"
		}
	}
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = s;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = option;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = _tmp39_->size;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = g_strdup_printf (" size=%d", (gint) _tmp40_);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = _tmp41_;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = g_strconcat (_tmp38_, _tmp42_, NULL);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (s);
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	s = _tmp43_;
#line 608 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp42_);
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = option;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = _tmp44_->unit;
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp45_) {
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_NONE:
#line 7007 "scanner.c"
		{
#line 613 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7011 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_PIXEL:
#line 7015 "scanner.c"
		{
			const gchar* _tmp46_ = NULL;
			gchar* _tmp47_ = NULL;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp46_ = s;
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp47_ = g_strconcat (_tmp46_, " unit=pixels", NULL);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 615 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp47_;
#line 616 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7029 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_BIT:
#line 7033 "scanner.c"
		{
			const gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp48_ = s;
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp49_ = g_strconcat (_tmp48_, " unit=bits", NULL);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 618 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp49_;
#line 619 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7047 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_MM:
#line 7051 "scanner.c"
		{
			const gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp50_ = s;
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_ = g_strconcat (_tmp50_, " unit=mm", NULL);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 621 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp51_;
#line 622 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7065 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_DPI:
#line 7069 "scanner.c"
		{
			const gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp52_ = s;
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp53_ = g_strconcat (_tmp52_, " unit=dpi", NULL);
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 624 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp53_;
#line 625 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7083 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_PERCENT:
#line 7087 "scanner.c"
		{
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_ = s;
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp55_ = g_strconcat (_tmp54_, " unit=percent", NULL);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 627 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp55_;
#line 628 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7101 "scanner.c"
		}
#line 610 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_UNIT_MICROSECOND:
#line 7105 "scanner.c"
		{
			const gchar* _tmp56_ = NULL;
			gchar* _tmp57_ = NULL;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp56_ = s;
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp57_ = g_strconcat (_tmp56_, " unit=microseconds", NULL);
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 630 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp57_;
#line 631 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7119 "scanner.c"
		}
		default:
		{
			const gchar* _tmp58_ = NULL;
			SANE_Option_Descriptor* _tmp59_ = NULL;
			SANE_Unit _tmp60_ = 0;
			gchar* _tmp61_ = NULL;
			gchar* _tmp62_ = NULL;
			gchar* _tmp63_ = NULL;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp58_ = s;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp59_ = option;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp60_ = _tmp59_->unit;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp61_ = g_strdup_printf (" unit=%d", (gint) _tmp60_);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp62_ = _tmp61_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp63_ = g_strconcat (_tmp58_, _tmp62_, NULL);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp63_;
#line 633 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp62_);
#line 634 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7149 "scanner.c"
		}
	}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = option;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp65_ = _tmp64_->constraint_type;
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp65_) {
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_RANGE:
#line 7160 "scanner.c"
		{
			SANE_Option_Descriptor* _tmp66_ = NULL;
			SANE_Value_Type _tmp67_ = 0;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp66_ = option;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp67_ = _tmp66_->type;
#line 640 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp67_ == SANE_TYPE_FIXED) {
#line 7170 "scanner.c"
				const gchar* _tmp68_ = NULL;
				SANE_Option_Descriptor* _tmp69_ = NULL;
				SANE_Range* _tmp70_ = NULL;
				SANE_Word _tmp71_ = {0};
				gdouble _tmp72_ = 0.0;
				SANE_Option_Descriptor* _tmp73_ = NULL;
				SANE_Range* _tmp74_ = NULL;
				SANE_Word _tmp75_ = {0};
				gdouble _tmp76_ = 0.0;
				SANE_Option_Descriptor* _tmp77_ = NULL;
				SANE_Range* _tmp78_ = NULL;
				SANE_Word _tmp79_ = {0};
				gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_ = NULL;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp68_ = s;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp69_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp70_ = _tmp69_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp71_ = _tmp70_->min;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp72_ = SANE_UNFIX ((SANE_Fixed) _tmp71_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp73_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp74_ = _tmp73_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp75_ = _tmp74_->max;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp76_ = SANE_UNFIX ((SANE_Fixed) _tmp75_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp77_ = option;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp78_ = _tmp77_->constraint.range;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp79_ = _tmp78_->quant;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp80_ = g_strdup_printf (" min=%f, max=%f, quant=%d", _tmp72_, _tmp76_, (gint) _tmp79_);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp81_ = _tmp80_;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp82_ = g_strconcat (_tmp68_, _tmp81_, NULL);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp82_;
#line 641 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp81_);
#line 7222 "scanner.c"
			} else {
				const gchar* _tmp83_ = NULL;
				SANE_Option_Descriptor* _tmp84_ = NULL;
				SANE_Range* _tmp85_ = NULL;
				SANE_Word _tmp86_ = {0};
				SANE_Option_Descriptor* _tmp87_ = NULL;
				SANE_Range* _tmp88_ = NULL;
				SANE_Word _tmp89_ = {0};
				SANE_Option_Descriptor* _tmp90_ = NULL;
				SANE_Range* _tmp91_ = NULL;
				SANE_Word _tmp92_ = {0};
				gchar* _tmp93_ = NULL;
				gchar* _tmp94_ = NULL;
				gchar* _tmp95_ = NULL;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp83_ = s;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp84_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp85_ = _tmp84_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp86_ = _tmp85_->min;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp87_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp88_ = _tmp87_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp89_ = _tmp88_->max;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp90_ = option;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp91_ = _tmp90_->constraint.range;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp92_ = _tmp91_->quant;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp93_ = g_strdup_printf (" min=%d, max=%d, quant=%d", (gint) _tmp86_, (gint) _tmp89_, (gint) _tmp92_);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp94_ = _tmp93_;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp95_ = g_strconcat (_tmp83_, _tmp94_, NULL);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (s);
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				s = _tmp95_;
#line 643 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (_tmp94_);
#line 7269 "scanner.c"
			}
#line 644 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7273 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_WORD_LIST:
#line 7277 "scanner.c"
		{
			const gchar* _tmp96_ = NULL;
			gchar* _tmp97_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp96_ = s;
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp97_ = g_strconcat (_tmp96_, " values=[", NULL);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 646 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp97_;
#line 7291 "scanner.c"
			{
				gint i = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 7296 "scanner.c"
				{
					gboolean _tmp98_ = FALSE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp98_ = TRUE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 7303 "scanner.c"
						gint _tmp100_ = 0;
						SANE_Option_Descriptor* _tmp101_ = NULL;
						SANE_Word* _tmp102_ = NULL;
						gint _tmp102__length1 = 0;
						SANE_Word _tmp103_ = {0};
						gint _tmp104_ = 0;
						SANE_Option_Descriptor* _tmp107_ = NULL;
						SANE_Value_Type _tmp108_ = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp98_) {
#line 7314 "scanner.c"
							gint _tmp99_ = 0;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp99_ = i;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp99_ + 1;
#line 7320 "scanner.c"
						}
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp98_ = FALSE;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp100_ = i;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp101_ = option;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp102_ = _tmp101_->constraint.word_list;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp102__length1 = -1;
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp103_ = _tmp102_[0];
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(((SANE_Word) _tmp100_) < _tmp103_)) {
#line 647 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 7338 "scanner.c"
						}
#line 649 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp104_ = i;
#line 649 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp104_ != 0) {
#line 7344 "scanner.c"
							const gchar* _tmp105_ = NULL;
							gchar* _tmp106_ = NULL;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp105_ = s;
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp106_ = g_strconcat (_tmp105_, ", ", NULL);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 650 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp106_;
#line 7355 "scanner.c"
						}
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp107_ = option;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp108_ = _tmp107_->type;
#line 651 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp108_ == SANE_TYPE_INT) {
#line 7363 "scanner.c"
							const gchar* _tmp109_ = NULL;
							SANE_Option_Descriptor* _tmp110_ = NULL;
							SANE_Word* _tmp111_ = NULL;
							gint _tmp111__length1 = 0;
							gint _tmp112_ = 0;
							SANE_Word _tmp113_ = {0};
							gchar* _tmp114_ = NULL;
							gchar* _tmp115_ = NULL;
							gchar* _tmp116_ = NULL;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp109_ = s;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp110_ = option;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp111_ = _tmp110_->constraint.word_list;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp111__length1 = -1;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp112_ = i;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp113_ = _tmp111_[_tmp112_ + 1];
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp114_ = g_strdup_printf ("%d", (gint) _tmp113_);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp115_ = _tmp114_;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp116_ = g_strconcat (_tmp109_, _tmp115_, NULL);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp116_;
#line 652 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (_tmp115_);
#line 7397 "scanner.c"
						} else {
							const gchar* _tmp117_ = NULL;
							SANE_Option_Descriptor* _tmp118_ = NULL;
							SANE_Word* _tmp119_ = NULL;
							gint _tmp119__length1 = 0;
							gint _tmp120_ = 0;
							SANE_Word _tmp121_ = {0};
							gdouble _tmp122_ = 0.0;
							gchar* _tmp123_ = NULL;
							gchar* _tmp124_ = NULL;
							gchar* _tmp125_ = NULL;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp117_ = s;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp118_ = option;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp119_ = _tmp118_->constraint.word_list;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp119__length1 = -1;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp120_ = i;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp121_ = _tmp119_[_tmp120_ + 1];
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp122_ = SANE_UNFIX ((SANE_Fixed) _tmp121_);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp123_ = g_strdup_printf ("%f", _tmp122_);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp124_ = _tmp123_;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp125_ = g_strconcat (_tmp117_, _tmp124_, NULL);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp125_;
#line 654 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (_tmp124_);
#line 7435 "scanner.c"
						}
					}
				}
			}
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp126_ = s;
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp127_ = g_strconcat (_tmp126_, "]", NULL);
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 656 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp127_;
#line 657 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7450 "scanner.c"
		}
#line 637 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SANE_CONSTRAINT_STRING_LIST:
#line 7454 "scanner.c"
		{
			const gchar* _tmp128_ = NULL;
			gchar* _tmp129_ = NULL;
			const gchar* _tmp147_ = NULL;
			gchar* _tmp148_ = NULL;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp128_ = s;
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp129_ = g_strconcat (_tmp128_, " values=[", NULL);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 659 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp129_;
#line 7468 "scanner.c"
			{
				gint i = 0;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 7473 "scanner.c"
				{
					gboolean _tmp130_ = FALSE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp130_ = TRUE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 7480 "scanner.c"
						SANE_Option_Descriptor* _tmp132_ = NULL;
						gchar** _tmp133_ = NULL;
						gint _tmp133__length1 = 0;
						gint _tmp134_ = 0;
						const gchar* _tmp135_ = NULL;
						gint _tmp136_ = 0;
						const gchar* _tmp139_ = NULL;
						SANE_Option_Descriptor* _tmp140_ = NULL;
						gchar** _tmp141_ = NULL;
						gint _tmp141__length1 = 0;
						gint _tmp142_ = 0;
						const gchar* _tmp143_ = NULL;
						gchar* _tmp144_ = NULL;
						gchar* _tmp145_ = NULL;
						gchar* _tmp146_ = NULL;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp130_) {
#line 7498 "scanner.c"
							gint _tmp131_ = 0;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp131_ = i;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp131_ + 1;
#line 7504 "scanner.c"
						}
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp130_ = FALSE;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp132_ = option;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp133_ = _tmp132_->constraint.string_list;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp133__length1 = _vala_array_length (_tmp132_->constraint.string_list);
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp134_ = i;
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp135_ = _tmp133_[_tmp134_];
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp135_ != NULL)) {
#line 660 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 7522 "scanner.c"
						}
#line 662 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp136_ = i;
#line 662 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp136_ != 0) {
#line 7528 "scanner.c"
							const gchar* _tmp137_ = NULL;
							gchar* _tmp138_ = NULL;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp137_ = s;
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp138_ = g_strconcat (_tmp137_, ", ", NULL);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_g_free0 (s);
#line 663 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							s = _tmp138_;
#line 7539 "scanner.c"
						}
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp139_ = s;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp140_ = option;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp141_ = _tmp140_->constraint.string_list;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp141__length1 = _vala_array_length (_tmp140_->constraint.string_list);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp142_ = i;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp143_ = _tmp141_[_tmp142_];
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp144_ = g_strdup_printf ("\"%s\"", _tmp143_);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp145_ = _tmp144_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp146_ = g_strconcat (_tmp139_, _tmp145_, NULL);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (s);
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						s = _tmp146_;
#line 664 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_g_free0 (_tmp145_);
#line 7565 "scanner.c"
					}
				}
			}
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp147_ = s;
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp148_ = g_strconcat (_tmp147_, "]", NULL);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (s);
#line 666 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			s = _tmp148_;
#line 667 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7579 "scanner.c"
		}
		default:
		{
#line 669 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 7585 "scanner.c"
		}
	}
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp149_ = option;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp150_ = _tmp149_->cap;
#line 672 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	cap = _tmp150_;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp151_ = cap;
#line 673 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp151_ != ((SANE_Int) 0)) {
#line 7598 "scanner.c"
		gchar* caps = NULL;
		gchar* _tmp152_ = NULL;
		SANE_Int _tmp153_ = {0};
		SANE_Int _tmp160_ = {0};
		SANE_Int _tmp167_ = {0};
		SANE_Int _tmp174_ = {0};
		SANE_Int _tmp181_ = {0};
		SANE_Int _tmp188_ = {0};
		SANE_Int _tmp195_ = {0};
		SANE_Int _tmp202_ = {0};
		const gchar* _tmp211_ = NULL;
		const gchar* _tmp212_ = NULL;
		gchar* _tmp213_ = NULL;
		gchar* _tmp214_ = NULL;
		gchar* _tmp215_ = NULL;
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp152_ = g_strdup ("");
#line 675 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		caps = _tmp152_;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp153_ = cap;
#line 676 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp153_ & SANE_CAP_SOFT_SELECT) != ((SANE_Int) 0)) {
#line 7622 "scanner.c"
			const gchar* _tmp154_ = NULL;
			const gchar* _tmp157_ = NULL;
			gchar* _tmp158_ = NULL;
			SANE_Int _tmp159_ = {0};
#line 678 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp154_ = caps;
#line 678 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp154_, "") != 0) {
#line 7631 "scanner.c"
				const gchar* _tmp155_ = NULL;
				gchar* _tmp156_ = NULL;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp155_ = caps;
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp156_ = g_strconcat (_tmp155_, ",", NULL);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 679 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp156_;
#line 7642 "scanner.c"
			}
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp157_ = caps;
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp158_ = g_strconcat (_tmp157_, "soft-select", NULL);
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 680 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp158_;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp159_ = cap;
#line 681 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp159_ & (~SANE_CAP_SOFT_SELECT);
#line 7656 "scanner.c"
		}
#line 683 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp160_ = cap;
#line 683 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp160_ & SANE_CAP_HARD_SELECT) != ((SANE_Int) 0)) {
#line 7662 "scanner.c"
			const gchar* _tmp161_ = NULL;
			const gchar* _tmp164_ = NULL;
			gchar* _tmp165_ = NULL;
			SANE_Int _tmp166_ = {0};
#line 685 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp161_ = caps;
#line 685 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp161_, "") != 0) {
#line 7671 "scanner.c"
				const gchar* _tmp162_ = NULL;
				gchar* _tmp163_ = NULL;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp162_ = caps;
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp163_ = g_strconcat (_tmp162_, ",", NULL);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 686 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp163_;
#line 7682 "scanner.c"
			}
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp164_ = caps;
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp165_ = g_strconcat (_tmp164_, "hard-select", NULL);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 687 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp165_;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp166_ = cap;
#line 688 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp166_ & (~SANE_CAP_HARD_SELECT);
#line 7696 "scanner.c"
		}
#line 690 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp167_ = cap;
#line 690 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp167_ & SANE_CAP_SOFT_DETECT) != ((SANE_Int) 0)) {
#line 7702 "scanner.c"
			const gchar* _tmp168_ = NULL;
			const gchar* _tmp171_ = NULL;
			gchar* _tmp172_ = NULL;
			SANE_Int _tmp173_ = {0};
#line 692 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp168_ = caps;
#line 692 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp168_, "") != 0) {
#line 7711 "scanner.c"
				const gchar* _tmp169_ = NULL;
				gchar* _tmp170_ = NULL;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp169_ = caps;
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp170_ = g_strconcat (_tmp169_, ",", NULL);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 693 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp170_;
#line 7722 "scanner.c"
			}
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp171_ = caps;
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp172_ = g_strconcat (_tmp171_, "soft-detect", NULL);
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 694 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp172_;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp173_ = cap;
#line 695 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp173_ & (~SANE_CAP_SOFT_DETECT);
#line 7736 "scanner.c"
		}
#line 697 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp174_ = cap;
#line 697 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp174_ & SANE_CAP_EMULATED) != ((SANE_Int) 0)) {
#line 7742 "scanner.c"
			const gchar* _tmp175_ = NULL;
			const gchar* _tmp178_ = NULL;
			gchar* _tmp179_ = NULL;
			SANE_Int _tmp180_ = {0};
#line 699 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp175_ = caps;
#line 699 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp175_, "") != 0) {
#line 7751 "scanner.c"
				const gchar* _tmp176_ = NULL;
				gchar* _tmp177_ = NULL;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp176_ = caps;
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp177_ = g_strconcat (_tmp176_, ",", NULL);
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 700 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp177_;
#line 7762 "scanner.c"
			}
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp178_ = caps;
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp179_ = g_strconcat (_tmp178_, "emulated", NULL);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 701 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp179_;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp180_ = cap;
#line 702 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp180_ & (~SANE_CAP_EMULATED);
#line 7776 "scanner.c"
		}
#line 704 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp181_ = cap;
#line 704 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp181_ & SANE_CAP_AUTOMATIC) != ((SANE_Int) 0)) {
#line 7782 "scanner.c"
			const gchar* _tmp182_ = NULL;
			const gchar* _tmp185_ = NULL;
			gchar* _tmp186_ = NULL;
			SANE_Int _tmp187_ = {0};
#line 706 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp182_ = caps;
#line 706 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp182_, "") != 0) {
#line 7791 "scanner.c"
				const gchar* _tmp183_ = NULL;
				gchar* _tmp184_ = NULL;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp183_ = caps;
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp184_ = g_strconcat (_tmp183_, ",", NULL);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 707 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp184_;
#line 7802 "scanner.c"
			}
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_ = caps;
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp186_ = g_strconcat (_tmp185_, "automatic", NULL);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 708 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp186_;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp187_ = cap;
#line 709 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp187_ & (~SANE_CAP_AUTOMATIC);
#line 7816 "scanner.c"
		}
#line 711 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp188_ = cap;
#line 711 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp188_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 7822 "scanner.c"
			const gchar* _tmp189_ = NULL;
			const gchar* _tmp192_ = NULL;
			gchar* _tmp193_ = NULL;
			SANE_Int _tmp194_ = {0};
#line 713 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp189_ = caps;
#line 713 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp189_, "") != 0) {
#line 7831 "scanner.c"
				const gchar* _tmp190_ = NULL;
				gchar* _tmp191_ = NULL;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp190_ = caps;
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp191_ = g_strconcat (_tmp190_, ",", NULL);
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 714 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp191_;
#line 7842 "scanner.c"
			}
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp192_ = caps;
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp193_ = g_strconcat (_tmp192_, "inactive", NULL);
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 715 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp193_;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp194_ = cap;
#line 716 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp194_ & (~SANE_CAP_INACTIVE);
#line 7856 "scanner.c"
		}
#line 718 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp195_ = cap;
#line 718 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if ((_tmp195_ & SANE_CAP_ADVANCED) != ((SANE_Int) 0)) {
#line 7862 "scanner.c"
			const gchar* _tmp196_ = NULL;
			const gchar* _tmp199_ = NULL;
			gchar* _tmp200_ = NULL;
			SANE_Int _tmp201_ = {0};
#line 720 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp196_ = caps;
#line 720 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp196_, "") != 0) {
#line 7871 "scanner.c"
				const gchar* _tmp197_ = NULL;
				gchar* _tmp198_ = NULL;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp197_ = caps;
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp198_ = g_strconcat (_tmp197_, ",", NULL);
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 721 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp198_;
#line 7882 "scanner.c"
			}
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp199_ = caps;
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp200_ = g_strconcat (_tmp199_, "advanced", NULL);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 722 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp200_;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp201_ = cap;
#line 723 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			cap = _tmp201_ & (~SANE_CAP_ADVANCED);
#line 7896 "scanner.c"
		}
#line 726 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp202_ = cap;
#line 726 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp202_ != ((SANE_Int) 0)) {
#line 7902 "scanner.c"
			const gchar* _tmp203_ = NULL;
			const gchar* _tmp206_ = NULL;
			SANE_Int _tmp207_ = {0};
			gchar* _tmp208_ = NULL;
			gchar* _tmp209_ = NULL;
			gchar* _tmp210_ = NULL;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp203_ = caps;
#line 728 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (g_strcmp0 (_tmp203_, "") != 0) {
#line 7913 "scanner.c"
				const gchar* _tmp204_ = NULL;
				gchar* _tmp205_ = NULL;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp204_ = caps;
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp205_ = g_strconcat (_tmp204_, ",", NULL);
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_g_free0 (caps);
#line 729 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				caps = _tmp205_;
#line 7924 "scanner.c"
			}
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp206_ = caps;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp207_ = cap;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp208_ = g_strdup_printf ("%x", (guint) ((gint) _tmp207_));
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp209_ = _tmp208_;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp210_ = g_strconcat (_tmp206_, _tmp209_, NULL);
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (caps);
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			caps = _tmp210_;
#line 730 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_g_free0 (_tmp209_);
#line 7942 "scanner.c"
		}
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp211_ = s;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp212_ = caps;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp213_ = g_strconcat (" cap=", _tmp212_, NULL);
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp214_ = _tmp213_;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp215_ = g_strconcat (_tmp211_, _tmp214_, NULL);
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (s);
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		s = _tmp215_;
#line 732 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp214_);
#line 673 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (caps);
#line 7962 "scanner.c"
	}
#line 735 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp216_ = s;
#line 735 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:735: %s", _tmp216_);
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp217_ = option;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp218_ = _tmp217_->desc;
#line 737 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp218_ != NULL) {
#line 7974 "scanner.c"
		SANE_Option_Descriptor* _tmp219_ = NULL;
		const gchar* _tmp220_ = NULL;
#line 738 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp219_ = option;
#line 738 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp220_ = _tmp219_->desc;
#line 738 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:738:   Description: %s", _tmp220_);
#line 7983 "scanner.c"
	}
#line 573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (s);
#line 7987 "scanner.c"
}


static void scanner_authorization_cb (const gchar* resource, gchar* username, int username_length1, gchar* password, int password_length1) {
	Scanner* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	NotifyRequestAuthorization* _tmp2_ = NULL;
	NotifyRequestAuthorization* _tmp3_ = NULL;
	Credentials* credentials = NULL;
	Scanner* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	gpointer _tmp6_ = NULL;
#line 741 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (resource != NULL);
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = scanner_scanner_object;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = resource;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = notify_request_authorization_new (_tmp1_);
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (_tmp0_, (Notify*) _tmp3_);
#line 743 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = scanner_scanner_object;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->priv->authorize_queue;
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = g_async_queue_pop (_tmp5_);
#line 745 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials = (Credentials*) _tmp6_;
#line 8022 "scanner.c"
	{
		gint i = 0;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 8027 "scanner.c"
		{
			gboolean _tmp7_ = FALSE;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp7_ = TRUE;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 8034 "scanner.c"
				gboolean _tmp9_ = FALSE;
				Credentials* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				gchar _tmp13_ = '\0';
				gchar* _tmp16_ = NULL;
				gint _tmp16__length1 = 0;
				gint _tmp17_ = 0;
				Credentials* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gint _tmp20_ = 0;
				gchar _tmp21_ = '\0';
				gchar _tmp22_ = '\0';
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp7_) {
#line 8050 "scanner.c"
					gint _tmp8_ = 0;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp8_ = i;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp8_ + 1;
#line 8056 "scanner.c"
				}
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp7_ = FALSE;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp10_ = credentials;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp11_ = _tmp10_->username;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp12_ = i;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp13_ = string_get (_tmp11_, (glong) _tmp12_);
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp13_ != '\0') {
#line 8070 "scanner.c"
					gint _tmp14_ = 0;
					gint _tmp15_ = 0;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp14_ = i;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp15_ = SANE_MAX_USERNAME_LEN;
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = _tmp14_ < _tmp15_;
#line 8079 "scanner.c"
				} else {
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp9_ = FALSE;
#line 8083 "scanner.c"
				}
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp9_) {
#line 746 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 8089 "scanner.c"
				}
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = username;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16__length1 = username_length1;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp17_ = i;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp18_ = credentials;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = _tmp18_->username;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp20_ = i;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp21_ = string_get (_tmp19_, (glong) _tmp20_);
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_[_tmp17_] = _tmp21_;
#line 747 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp22_ = _tmp16_[_tmp17_];
#line 8109 "scanner.c"
			}
		}
	}
	{
		gint i = 0;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		i = 0;
#line 8117 "scanner.c"
		{
			gboolean _tmp23_ = FALSE;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = TRUE;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			while (TRUE) {
#line 8124 "scanner.c"
				gboolean _tmp25_ = FALSE;
				Credentials* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				gint _tmp28_ = 0;
				gchar _tmp29_ = '\0';
				gchar* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp33_ = 0;
				Credentials* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gchar _tmp37_ = '\0';
				gchar _tmp38_ = '\0';
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp23_) {
#line 8140 "scanner.c"
					gint _tmp24_ = 0;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp24_ = i;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					i = _tmp24_ + 1;
#line 8146 "scanner.c"
				}
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp23_ = FALSE;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp26_ = credentials;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp27_ = _tmp26_->password;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp28_ = i;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp29_ = string_get (_tmp27_, (glong) _tmp28_);
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp29_ != '\0') {
#line 8160 "scanner.c"
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp30_ = i;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp31_ = SANE_MAX_USERNAME_LEN;
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp25_ = _tmp30_ < _tmp31_;
#line 8169 "scanner.c"
				} else {
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp25_ = FALSE;
#line 8173 "scanner.c"
				}
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (!_tmp25_) {
#line 748 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 8179 "scanner.c"
				}
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_ = password;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32__length1 = password_length1;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp33_ = i;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp34_ = credentials;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp35_ = _tmp34_->password;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp36_ = i;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp37_ = string_get (_tmp35_, (glong) _tmp36_);
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp32_[_tmp33_] = _tmp37_;
#line 749 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp38_ = _tmp32_[_tmp33_];
#line 8199 "scanner.c"
			}
		}
	}
#line 741 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8205 "scanner.c"
}


static gpointer _credentials_ref0 (gpointer self) {
#line 757 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? credentials_ref (self) : NULL;
#line 8212 "scanner.c"
}


void scanner_authorize (Scanner* self, const gchar* username, const gchar* password) {
	Credentials* credentials = NULL;
	Credentials* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_ = NULL;
	Credentials* _tmp6_ = NULL;
#line 752 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 752 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (username != NULL);
#line 752 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (password != NULL);
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = credentials_new ();
#line 754 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials = _tmp0_;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = username;
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (credentials->username);
#line 755 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials->username = _tmp2_;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = password;
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (credentials->password);
#line 756 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	credentials->password = _tmp4_;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->authorize_queue;
#line 757 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _credentials_ref0 (credentials);
#line 757 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp5_, _tmp6_);
#line 752 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_credentials_unref0 (credentials);
#line 8259 "scanner.c"
}


static void scanner_close_device (Scanner* self) {
	gboolean _tmp0_ = FALSE;
#line 760 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 762 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->have_handle;
#line 762 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 8271 "scanner.c"
		SANE_Handle _tmp1_ = {0};
		SANE_Handle _tmp2_ = {0};
#line 764 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = self->priv->handle;
#line 764 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_cancel (_tmp1_);
#line 765 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:765: sane_cancel ()");
#line 767 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = self->priv->handle;
#line 767 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_close (_tmp2_);
#line 768 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:768: sane_close ()");
#line 769 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 770 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_hash_table_unref0 (self->priv->options);
#line 770 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->options = NULL;
#line 8292 "scanner.c"
	}
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = NULL;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer_length1 = 0;
#line 773 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 774 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 774 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_queue = NULL;
#line 776 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 8308 "scanner.c"
}


static void scanner_fail_scan (Scanner* self, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	NotifyScanFailed* _tmp2_ = NULL;
	NotifyScanFailed* _tmp3_ = NULL;
#line 779 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 779 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (error_string != NULL);
#line 781 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_close_device (self);
#line 782 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = error_code;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = error_string;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = notify_scan_failed_new (_tmp0_, _tmp1_);
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _tmp2_;
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp3_);
#line 783 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp3_);
#line 8337 "scanner.c"
}


static gpointer _request_ref0 (gpointer self) {
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? request_ref (self) : NULL;
#line 8344 "scanner.c"
}


static gpointer _scan_job_ref0 (gpointer self) {
#line 809 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? scan_job_ref (self) : NULL;
#line 8351 "scanner.c"
}


static gboolean scanner_handle_requests (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ScanState _tmp1_ = 0;
	gint request_count = 0;
#line 786 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->state;
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SCAN_STATE_IDLE) {
#line 8366 "scanner.c"
		gboolean _tmp2_ = FALSE;
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = self->priv->need_redetect;
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 8372 "scanner.c"
	} else {
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = FALSE;
#line 8376 "scanner.c"
	}
#line 789 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 790 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_REDETECT;
#line 8382 "scanner.c"
	}
#line 793 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request_count = 0;
#line 794 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	while (TRUE) {
#line 8388 "scanner.c"
		Request* request = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		ScanState _tmp5_ = 0;
		gint _tmp11_ = 0;
		Request* _tmp12_ = NULL;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = self->priv->state;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp5_ == SCAN_STATE_IDLE) {
#line 8399 "scanner.c"
			gint _tmp6_ = 0;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = request_count;
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = _tmp6_ == 0;
#line 8405 "scanner.c"
		} else {
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = FALSE;
#line 8409 "scanner.c"
		}
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp4_) {
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = TRUE;
#line 8415 "scanner.c"
		} else {
			GAsyncQueue* _tmp7_ = NULL;
			gint _tmp8_ = 0;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp7_ = self->priv->request_queue;
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp8_ = g_async_queue_length (_tmp7_);
#line 798 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = _tmp8_ > 0;
#line 8425 "scanner.c"
		}
#line 797 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp3_) {
#line 8429 "scanner.c"
			GAsyncQueue* _tmp9_ = NULL;
			gpointer _tmp10_ = NULL;
#line 799 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp9_ = self->priv->request_queue;
#line 799 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp10_ = g_async_queue_pop (_tmp9_);
#line 799 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (request);
#line 799 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			request = (Request*) _tmp10_;
#line 8440 "scanner.c"
		} else {
#line 801 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = TRUE;
#line 801 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (request);
#line 801 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 8448 "scanner.c"
		}
#line 803 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:803: Processing request");
#line 804 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = request_count;
#line 804 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		request_count = _tmp11_ + 1;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = request;
#line 806 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, TYPE_REQUEST_START_SCAN)) {
#line 8460 "scanner.c"
			RequestStartScan* r = NULL;
			Request* _tmp13_ = NULL;
			RequestStartScan* _tmp14_ = NULL;
			RequestStartScan* _tmp15_ = NULL;
			ScanJob* _tmp16_ = NULL;
			ScanJob* _tmp17_ = NULL;
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = request;
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp14_ = _request_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_REQUEST_START_SCAN, RequestStartScan));
#line 808 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			r = _tmp14_;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = r;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp16_ = _tmp15_->job;
#line 809 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = _scan_job_ref0 (_tmp16_);
#line 809 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			self->priv->job_queue = g_list_append (self->priv->job_queue, _tmp17_);
#line 806 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_request_unref0 (r);
#line 8483 "scanner.c"
		} else {
			Request* _tmp18_ = NULL;
#line 811 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = request;
#line 811 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_REQUEST_CANCEL)) {
#line 813 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_fail_scan (self, (gint) SANE_STATUS_CANCELLED, "Scan cancelled - do not report this error");
#line 8492 "scanner.c"
			} else {
				Request* _tmp19_ = NULL;
#line 815 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp19_ = request;
#line 815 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, TYPE_REQUEST_QUIT)) {
#line 817 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_close_device (self);
#line 818 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					result = FALSE;
#line 818 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_request_unref0 (request);
#line 818 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					return result;
#line 8507 "scanner.c"
				}
			}
		}
#line 794 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_request_unref0 (request);
#line 8513 "scanner.c"
	}
}


static void _g_free0_ (gpointer var) {
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	var = (g_free (var), NULL);
#line 8521 "scanner.c"
}


static void scanner_do_open (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ScanJob* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ScanJob* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gboolean _tmp13_ = FALSE;
	GHashFunc _tmp18_ = NULL;
	GEqualFunc _tmp19_ = NULL;
	GHashTable* _tmp20_ = NULL;
	SANE_Status status = 0;
	ScanJob* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	SANE_Handle _tmp23_ = {0};
	SANE_Status _tmp24_ = 0;
	ScanJob* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	SANE_Status _tmp27_ = 0;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	SANE_Status _tmp30_ = 0;
	ScanJob* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 825 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 825 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 825 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 825 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 827 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line_count = 0;
#line 828 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->pass_number = 0;
#line 829 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->page_number = 0;
#line 830 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->notified_page = -1;
#line 831 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->option_index = (SANE_Int) 0;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = job;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_->device;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ == NULL) {
#line 8579 "scanner.c"
		const gchar* _tmp6_ = NULL;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = self->priv->default_device;
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = _tmp6_ != NULL;
#line 8585 "scanner.c"
	} else {
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = FALSE;
#line 8589 "scanner.c"
	}
#line 833 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_) {
#line 8593 "scanner.c"
		ScanJob* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
#line 834 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = job;
#line 834 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = self->priv->default_device;
#line 834 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = g_strdup (_tmp8_);
#line 834 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_free0 (_tmp7_->device);
#line 834 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_->device = _tmp9_;
#line 8607 "scanner.c"
	}
#line 836 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = job;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->device;
#line 836 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp11_ == NULL) {
#line 8615 "scanner.c"
		const gchar* _tmp12_ = NULL;
#line 838 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:838: No scan device available");
#line 839 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = _ ("No scanners available.  Please connect a scanner.");
#line 839 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, 0, _tmp12_);
#line 842 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 842 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 8627 "scanner.c"
	}
#line 846 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = self->priv->have_handle;
#line 846 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp13_) {
#line 8633 "scanner.c"
		const gchar* _tmp14_ = NULL;
		ScanJob* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		SANE_Handle _tmp17_ = {0};
#line 848 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = self->priv->current_device;
#line 848 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = job;
#line 848 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_->device;
#line 848 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (g_strcmp0 (_tmp14_, _tmp16_) == 0) {
#line 850 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			self->priv->state = SCAN_STATE_GET_OPTION;
#line 851 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_scan_job_unref0 (job);
#line 851 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return;
#line 8652 "scanner.c"
		}
#line 854 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp17_ = self->priv->handle;
#line 854 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		sane_close (_tmp17_);
#line 855 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_debug ("scanner.vala:855: sane_close ()");
#line 856 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->have_handle = FALSE;
#line 8662 "scanner.c"
	}
#line 859 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 859 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->current_device = NULL;
#line 861 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->have_handle = FALSE;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = g_str_hash;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = g_str_equal;
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, NULL);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 862 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->options = _tmp20_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = job;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_->device;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = sane_open (_tmp22_, &_tmp23_);
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->handle = _tmp23_;
#line 863 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp24_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = job;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = _tmp25_->device;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = status;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = sane_status_to_string (_tmp27_);
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = _tmp28_;
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:864: sane_open (\"%s\") -> %s", _tmp26_, _tmp29_);
#line 864 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp29_);
#line 866 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = status;
#line 866 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp30_ != SANE_STATUS_GOOD) {
#line 8708 "scanner.c"
		SANE_Status _tmp31_ = 0;
		const gchar* _tmp32_ = NULL;
		SANE_Status _tmp33_ = 0;
		const gchar* _tmp34_ = NULL;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = status;
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = sane_strstatus (_tmp31_);
#line 868 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:868: Unable to get open device: %s", _tmp32_);
#line 869 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = status;
#line 869 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _ ("Unable to connect to scanner");
#line 869 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp33_, _tmp34_);
#line 872 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 872 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 8729 "scanner.c"
	}
#line 874 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->have_handle = TRUE;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = job;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = _tmp35_->device;
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = g_strdup (_tmp36_);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 876 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->current_device = _tmp37_;
#line 877 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_GET_OPTION;
#line 823 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 8747 "scanner.c"
}


static void scanner_do_get_option (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	SANE_Option_Descriptor* option = NULL;
	SANE_Handle _tmp3_ = {0};
	SANE_Int _tmp4_ = {0};
	SANE_Option_Descriptor* _tmp5_ = NULL;
	SANE_Int _tmp6_ = {0};
	SANE_Int index = {0};
	SANE_Int _tmp7_ = {0};
	SANE_Int _tmp8_ = {0};
	SANE_Option_Descriptor* _tmp9_ = NULL;
	SANE_Int _tmp356_ = {0};
	SANE_Option_Descriptor* _tmp357_ = NULL;
	SANE_Option_Descriptor* _tmp358_ = NULL;
	SANE_Value_Type _tmp359_ = 0;
	SANE_Option_Descriptor* _tmp360_ = NULL;
	SANE_Int _tmp361_ = {0};
	SANE_Option_Descriptor* _tmp362_ = NULL;
	const gchar* _tmp363_ = NULL;
	GHashTable* _tmp364_ = NULL;
	SANE_Option_Descriptor* _tmp365_ = NULL;
	const gchar* _tmp366_ = NULL;
	gchar* _tmp367_ = NULL;
	SANE_Int _tmp368_ = {0};
#line 880 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 882 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 882 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 882 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = self->priv->handle;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->option_index;
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = sane_get_option_descriptor (_tmp3_, _tmp4_);
#line 884 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	option = _tmp5_;
#line 885 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = self->priv->option_index;
#line 885 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:885: sane_get_option_descriptor (%d)", (gint) _tmp6_);
#line 886 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = self->priv->option_index;
#line 886 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	index = _tmp7_;
#line 887 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = self->priv->option_index;
#line 887 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->option_index = _tmp8_ + 1;
#line 890 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = option;
#line 890 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ == NULL) {
#line 8812 "scanner.c"
		SANE_Handle _tmp10_ = {0};
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		SANE_Option_Descriptor* _tmp13_ = NULL;
		SANE_Option_Descriptor* _tmp14_ = NULL;
		SANE_Option_Descriptor* _tmp18_ = NULL;
		SANE_Handle _tmp96_ = {0};
		const gchar* _tmp97_ = NULL;
		gint _tmp98_ = 0;
		SANE_Option_Descriptor* _tmp99_ = NULL;
		SANE_Option_Descriptor* _tmp100_ = NULL;
		SANE_Handle _tmp156_ = {0};
		gint _tmp157_ = 0;
		SANE_Option_Descriptor* _tmp158_ = NULL;
		SANE_Option_Descriptor* _tmp159_ = NULL;
		SANE_Handle _tmp167_ = {0};
		gint _tmp168_ = 0;
		SANE_Option_Descriptor* _tmp169_ = NULL;
		SANE_Option_Descriptor* _tmp170_ = NULL;
		SANE_Handle _tmp178_ = {0};
		gint _tmp179_ = 0;
		SANE_Option_Descriptor* _tmp180_ = NULL;
		SANE_Option_Descriptor* _tmp181_ = NULL;
		SANE_Handle _tmp194_ = {0};
		const gchar* _tmp195_ = NULL;
		gint _tmp196_ = 0;
		SANE_Option_Descriptor* _tmp197_ = NULL;
		SANE_Option_Descriptor* _tmp198_ = NULL;
		SANE_Handle _tmp218_ = {0};
		const gchar* _tmp219_ = NULL;
		gint _tmp220_ = 0;
		SANE_Option_Descriptor* _tmp221_ = NULL;
		SANE_Option_Descriptor* _tmp222_ = NULL;
		SANE_Handle _tmp237_ = {0};
		const gchar* _tmp238_ = NULL;
		gint _tmp239_ = 0;
		SANE_Option_Descriptor* _tmp240_ = NULL;
		SANE_Option_Descriptor* _tmp241_ = NULL;
		SANE_Handle _tmp256_ = {0};
		const gchar* _tmp257_ = NULL;
		gint _tmp258_ = 0;
		SANE_Option_Descriptor* _tmp259_ = NULL;
		gboolean _tmp260_ = FALSE;
		SANE_Option_Descriptor* _tmp261_ = NULL;
		SANE_Handle _tmp273_ = {0};
		const gchar* _tmp274_ = NULL;
		gint _tmp275_ = 0;
		SANE_Option_Descriptor* _tmp276_ = NULL;
		gboolean _tmp277_ = FALSE;
		SANE_Option_Descriptor* _tmp278_ = NULL;
		SANE_Handle _tmp290_ = {0};
		const gchar* _tmp291_ = NULL;
		gint _tmp292_ = 0;
		SANE_Option_Descriptor* _tmp293_ = NULL;
		SANE_Option_Descriptor* _tmp294_ = NULL;
		SANE_Handle _tmp305_ = {0};
		const gchar* _tmp306_ = NULL;
		gint _tmp307_ = 0;
		SANE_Option_Descriptor* _tmp308_ = NULL;
		SANE_Option_Descriptor* _tmp309_ = NULL;
		const gchar* _tmp320_ = NULL;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = self->priv->handle;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp11_ = SANE_NAME_SCAN_SOURCE;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = scanner_get_option_by_name (self, _tmp10_, _tmp11_, &_tmp12_);
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp12_;
#line 893 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp13_;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = option;
#line 894 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp14_ == NULL) {
#line 8888 "scanner.c"
			SANE_Handle _tmp15_ = {0};
			gint _tmp16_ = 0;
			SANE_Option_Descriptor* _tmp17_ = NULL;
#line 896 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_debug ("scanner.vala:896: SCAN_SOURCE not available, trying alternative \"doc-" \
"source\"");
#line 897 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp15_ = self->priv->handle;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp17_ = scanner_get_option_by_name (self, _tmp15_, "doc-source", &_tmp16_);
#line 897 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp16_;
#line 897 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp17_;
#line 8902 "scanner.c"
		}
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp18_ = option;
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp18_ != NULL) {
#line 8908 "scanner.c"
			gchar** flatbed_sources = NULL;
			gchar* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar** _tmp29_ = NULL;
			gint flatbed_sources_length1 = 0;
			gint _flatbed_sources_size_ = 0;
			gchar** adf_sources = NULL;
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			gchar** _tmp37_ = NULL;
			gint adf_sources_length1 = 0;
			gint _adf_sources_size_ = 0;
			gchar** adf_front_sources = NULL;
			gchar* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar** _tmp41_ = NULL;
			gint adf_front_sources_length1 = 0;
			gint _adf_front_sources_size_ = 0;
			gchar** adf_back_sources = NULL;
			gchar* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			gchar* _tmp44_ = NULL;
			gchar** _tmp45_ = NULL;
			gint adf_back_sources_length1 = 0;
			gint _adf_back_sources_size_ = 0;
			gchar** adf_duplex_sources = NULL;
			gchar* _tmp46_ = NULL;
			const gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_ = NULL;
			gchar** _tmp54_ = NULL;
			gint adf_duplex_sources_length1 = 0;
			gint _adf_duplex_sources_size_ = 0;
			ScanJob* _tmp55_ = NULL;
			ScanType _tmp56_ = 0;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp19_ = g_strdup ("Auto");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp20_ = SANE_I18N ("Auto");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = g_strdup (_tmp20_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = g_strdup ("Flatbed");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = SANE_I18N ("Flatbed");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = g_strdup (_tmp23_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = g_strdup ("FlatBed");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = g_strdup ("Normal");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp27_ = SANE_I18N ("Normal");
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = g_strdup (_tmp27_);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_ = g_new0 (gchar*, 7 + 1);
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[0] = _tmp19_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[1] = _tmp21_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[2] = _tmp22_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[3] = _tmp24_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[4] = _tmp25_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[5] = _tmp26_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp29_[6] = _tmp28_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources = _tmp29_;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources_length1 = 7;
#line 901 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_flatbed_sources_size_ = flatbed_sources_length1;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp30_ = g_strdup ("Automatic Document Feeder");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp31_ = SANE_I18N ("Automatic Document Feeder");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp32_ = g_strdup (_tmp31_);
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp33_ = g_strdup ("ADF");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp34_ = g_strdup ("Automatic Document Feeder(left aligned)");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp35_ = g_strdup ("Automatic Document Feeder(centrally aligned)");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp36_ = g_strdup ("ADF Simplex");
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_ = g_new0 (gchar*, 6 + 1);
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[0] = _tmp30_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[1] = _tmp32_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[2] = _tmp33_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[3] = _tmp34_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[4] = _tmp35_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp37_[5] = _tmp36_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources = _tmp37_;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources_length1 = 6;
#line 912 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_sources_size_ = adf_sources_length1;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp38_ = g_strdup ("ADF Front");
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp39_ = SANE_I18N ("ADF Front");
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp40_ = g_strdup (_tmp39_);
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_ = g_new0 (gchar*, 2 + 1);
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_[0] = _tmp38_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp41_[1] = _tmp40_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources = _tmp41_;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources_length1 = 2;
#line 922 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_front_sources_size_ = adf_front_sources_length1;
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp42_ = g_strdup ("ADF Back");
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp43_ = SANE_I18N ("ADF Back");
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp44_ = g_strdup (_tmp43_);
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_ = g_new0 (gchar*, 2 + 1);
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_[0] = _tmp42_;
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp45_[1] = _tmp44_;
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources = _tmp45_;
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources_length1 = 2;
#line 928 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_back_sources_size_ = adf_back_sources_length1;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp46_ = g_strdup ("ADF Duplex");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp47_ = SANE_I18N ("ADF Duplex");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp48_ = g_strdup (_tmp47_);
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp49_ = g_strdup ("ADF Duplex - Long-Edge Binding");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp50_ = g_strdup ("ADF Duplex - Short-Edge Binding");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp51_ = g_strdup ("Duplex");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp52_ = g_strdup ("Automatic Document Feeder(centrally aligned,Duplex)");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp53_ = g_strdup ("Automatic Document Feeder(left aligned,Duplex)");
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_ = g_new0 (gchar*, 7 + 1);
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[0] = _tmp46_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[1] = _tmp48_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[2] = _tmp49_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[3] = _tmp50_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[4] = _tmp51_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[5] = _tmp52_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp54_[6] = _tmp53_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources = _tmp54_;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources_length1 = 7;
#line 934 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_adf_duplex_sources_size_ = adf_duplex_sources_length1;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp55_ = job;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp56_ = _tmp55_->type;
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			switch (_tmp56_) {
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_SINGLE:
#line 9120 "scanner.c"
				{
					SANE_Handle _tmp57_ = {0};
					SANE_Option_Descriptor* _tmp58_ = NULL;
					SANE_Int _tmp59_ = {0};
					gboolean _tmp60_ = FALSE;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp57_ = self->priv->handle;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp58_ = option;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp59_ = index;
#line 948 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp60_ = scanner_set_default_option (self, _tmp57_, _tmp58_, _tmp59_);
#line 948 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp60_) {
#line 9136 "scanner.c"
						SANE_Handle _tmp61_ = {0};
						SANE_Option_Descriptor* _tmp62_ = NULL;
						SANE_Int _tmp63_ = {0};
						gchar** _tmp64_ = NULL;
						gint _tmp64__length1 = 0;
						gboolean _tmp65_ = FALSE;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp61_ = self->priv->handle;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp62_ = option;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp63_ = index;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp64_ = flatbed_sources;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp64__length1 = flatbed_sources_length1;
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp65_ = scanner_set_constrained_string_option (self, _tmp61_, _tmp62_, _tmp63_, _tmp64_, _tmp64__length1, NULL);
#line 949 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp65_) {
#line 950 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:950: Unable to set single page source, please file a bug");
#line 9159 "scanner.c"
						}
					}
#line 951 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9164 "scanner.c"
				}
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_FRONT:
#line 9168 "scanner.c"
				{
					SANE_Handle _tmp66_ = {0};
					SANE_Option_Descriptor* _tmp67_ = NULL;
					SANE_Int _tmp68_ = {0};
					gchar** _tmp69_ = NULL;
					gint _tmp69__length1 = 0;
					gboolean _tmp70_ = FALSE;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp66_ = self->priv->handle;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp67_ = option;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp68_ = index;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp69_ = adf_front_sources;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp69__length1 = adf_front_sources_length1;
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp70_ = scanner_set_constrained_string_option (self, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp69__length1, NULL);
#line 953 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp70_) {
#line 9190 "scanner.c"
						SANE_Handle _tmp71_ = {0};
						SANE_Option_Descriptor* _tmp72_ = NULL;
						SANE_Int _tmp73_ = {0};
						gchar** _tmp74_ = NULL;
						gint _tmp74__length1 = 0;
						gboolean _tmp75_ = FALSE;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp71_ = self->priv->handle;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp72_ = option;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp73_ = index;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp74_ = adf_sources;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp74__length1 = adf_sources_length1;
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp75_ = scanner_set_constrained_string_option (self, _tmp71_, _tmp72_, _tmp73_, _tmp74_, _tmp74__length1, NULL);
#line 954 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp75_) {
#line 955 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:955: Unable to set front ADF source, please file a bug");
#line 9213 "scanner.c"
						}
					}
#line 956 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9218 "scanner.c"
				}
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_BACK:
#line 9222 "scanner.c"
				{
					SANE_Handle _tmp76_ = {0};
					SANE_Option_Descriptor* _tmp77_ = NULL;
					SANE_Int _tmp78_ = {0};
					gchar** _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					gboolean _tmp80_ = FALSE;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp76_ = self->priv->handle;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp77_ = option;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp78_ = index;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp79_ = adf_back_sources;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp79__length1 = adf_back_sources_length1;
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp80_ = scanner_set_constrained_string_option (self, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp79__length1, NULL);
#line 958 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp80_) {
#line 9244 "scanner.c"
						SANE_Handle _tmp81_ = {0};
						SANE_Option_Descriptor* _tmp82_ = NULL;
						SANE_Int _tmp83_ = {0};
						gchar** _tmp84_ = NULL;
						gint _tmp84__length1 = 0;
						gboolean _tmp85_ = FALSE;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp81_ = self->priv->handle;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp82_ = option;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp83_ = index;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp84_ = adf_sources;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp84__length1 = adf_sources_length1;
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp85_ = scanner_set_constrained_string_option (self, _tmp81_, _tmp82_, _tmp83_, _tmp84_, _tmp84__length1, NULL);
#line 959 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp85_) {
#line 960 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:960: Unable to set back ADF source, please file a bug");
#line 9267 "scanner.c"
						}
					}
#line 961 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9272 "scanner.c"
				}
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_TYPE_ADF_BOTH:
#line 9276 "scanner.c"
				{
					SANE_Handle _tmp86_ = {0};
					SANE_Option_Descriptor* _tmp87_ = NULL;
					SANE_Int _tmp88_ = {0};
					gchar** _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					gboolean _tmp90_ = FALSE;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp86_ = self->priv->handle;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87_ = option;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp88_ = index;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp89_ = adf_duplex_sources;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp89__length1 = adf_duplex_sources_length1;
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp90_ = scanner_set_constrained_string_option (self, _tmp86_, _tmp87_, _tmp88_, _tmp89_, _tmp89__length1, NULL);
#line 963 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp90_) {
#line 9298 "scanner.c"
						SANE_Handle _tmp91_ = {0};
						SANE_Option_Descriptor* _tmp92_ = NULL;
						SANE_Int _tmp93_ = {0};
						gchar** _tmp94_ = NULL;
						gint _tmp94__length1 = 0;
						gboolean _tmp95_ = FALSE;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp91_ = self->priv->handle;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp92_ = option;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp93_ = index;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp94_ = adf_sources;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp94__length1 = adf_sources_length1;
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp95_ = scanner_set_constrained_string_option (self, _tmp91_, _tmp92_, _tmp93_, _tmp94_, _tmp94__length1, NULL);
#line 964 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp95_) {
#line 965 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							g_warning ("scanner.vala:965: Unable to set duplex ADF source, please file a bug");
#line 9321 "scanner.c"
						}
					}
#line 966 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9326 "scanner.c"
				}
				default:
#line 945 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 9331 "scanner.c"
			}
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_duplex_sources = (_vala_array_free (adf_duplex_sources, adf_duplex_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_back_sources = (_vala_array_free (adf_back_sources, adf_back_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_front_sources = (_vala_array_free (adf_front_sources, adf_front_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			adf_sources = (_vala_array_free (adf_sources, adf_sources_length1, (GDestroyNotify) g_free), NULL);
#line 899 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			flatbed_sources = (_vala_array_free (flatbed_sources, flatbed_sources_length1, (GDestroyNotify) g_free), NULL);
#line 9343 "scanner.c"
		}
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp96_ = self->priv->handle;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp97_ = SANE_NAME_SCAN_MODE;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp99_ = scanner_get_option_by_name (self, _tmp96_, _tmp97_, &_tmp98_);
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp98_;
#line 971 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp99_;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp100_ = option;
#line 972 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp100_ != NULL) {
#line 9359 "scanner.c"
			gchar** color_scan_modes = NULL;
			const gchar* _tmp101_ = NULL;
			gchar* _tmp102_ = NULL;
			gchar* _tmp103_ = NULL;
			gchar* _tmp104_ = NULL;
			gchar* _tmp105_ = NULL;
			gchar** _tmp106_ = NULL;
			gint color_scan_modes_length1 = 0;
			gint _color_scan_modes_size_ = 0;
			gchar** gray_scan_modes = NULL;
			const gchar* _tmp107_ = NULL;
			gchar* _tmp108_ = NULL;
			gchar* _tmp109_ = NULL;
			gchar* _tmp110_ = NULL;
			const gchar* _tmp111_ = NULL;
			gchar* _tmp112_ = NULL;
			gchar* _tmp113_ = NULL;
			gchar* _tmp114_ = NULL;
			gchar** _tmp115_ = NULL;
			gint gray_scan_modes_length1 = 0;
			gint _gray_scan_modes_size_ = 0;
			gchar** lineart_scan_modes = NULL;
			const gchar* _tmp116_ = NULL;
			gchar* _tmp117_ = NULL;
			gchar* _tmp118_ = NULL;
			gchar* _tmp119_ = NULL;
			const gchar* _tmp120_ = NULL;
			gchar* _tmp121_ = NULL;
			gchar* _tmp122_ = NULL;
			const gchar* _tmp123_ = NULL;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_ = NULL;
			const gchar* _tmp126_ = NULL;
			gchar* _tmp127_ = NULL;
			gchar* _tmp128_ = NULL;
			const gchar* _tmp129_ = NULL;
			gchar* _tmp130_ = NULL;
			gchar* _tmp131_ = NULL;
			gchar* _tmp132_ = NULL;
			const gchar* _tmp133_ = NULL;
			gchar* _tmp134_ = NULL;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_ = NULL;
			gchar* _tmp137_ = NULL;
			gchar** _tmp138_ = NULL;
			gint lineart_scan_modes_length1 = 0;
			gint _lineart_scan_modes_size_ = 0;
			ScanJob* _tmp139_ = NULL;
			ScanMode _tmp140_ = 0;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = SANE_VALUE_SCAN_MODE_COLOR;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp102_ = g_strdup (_tmp101_);
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp103_ = g_strdup ("Color");
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp104_ = g_strdup ("24bit Color");
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp105_ = g_strdup ("Color - 16 Million Colors");
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_ = g_new0 (gchar*, 4 + 1);
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_[0] = _tmp102_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_[1] = _tmp103_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_[2] = _tmp104_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_[3] = _tmp105_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes = _tmp106_;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes_length1 = 4;
#line 975 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_color_scan_modes_size_ = color_scan_modes_length1;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp107_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp108_ = g_strdup (_tmp107_);
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp109_ = g_strdup ("Gray");
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp110_ = g_strdup ("Grayscale");
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp111_ = SANE_I18N ("Grayscale");
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp112_ = g_strdup (_tmp111_);
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp113_ = g_strdup ("True Gray");
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp114_ = g_strdup ("Grayscale - 256 Levels");
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_ = g_new0 (gchar*, 6 + 1);
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[0] = _tmp108_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[1] = _tmp109_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[2] = _tmp110_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[3] = _tmp112_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[4] = _tmp113_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp115_[5] = _tmp114_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes = _tmp115_;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes_length1 = 6;
#line 982 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_gray_scan_modes_size_ = gray_scan_modes_length1;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp116_ = SANE_VALUE_SCAN_MODE_LINEART;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp117_ = g_strdup (_tmp116_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp118_ = g_strdup ("Lineart");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp119_ = g_strdup ("LineArt");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp120_ = SANE_I18N ("LineArt");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp121_ = g_strdup (_tmp120_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp122_ = g_strdup ("Black & White");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp123_ = SANE_I18N ("Black & White");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp124_ = g_strdup (_tmp123_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp125_ = g_strdup ("Binary");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp126_ = SANE_I18N ("Binary");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp127_ = g_strdup (_tmp126_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp128_ = g_strdup ("Thresholded");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp129_ = SANE_VALUE_SCAN_MODE_GRAY;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp130_ = g_strdup (_tmp129_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp131_ = g_strdup ("Gray");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp132_ = g_strdup ("Grayscale");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp133_ = SANE_I18N ("Grayscale");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp134_ = g_strdup (_tmp133_);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp135_ = g_strdup ("True Gray");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp136_ = g_strdup ("Black and White - Line Art");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp137_ = g_strdup ("Black and White - Halftone");
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_ = g_new0 (gchar*, 16 + 1);
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[0] = _tmp117_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[1] = _tmp118_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[2] = _tmp119_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[3] = _tmp121_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[4] = _tmp122_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[5] = _tmp124_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[6] = _tmp125_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[7] = _tmp127_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[8] = _tmp128_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[9] = _tmp130_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[10] = _tmp131_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[11] = _tmp132_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[12] = _tmp134_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[13] = _tmp135_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[14] = _tmp136_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp138_[15] = _tmp137_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes = _tmp138_;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes_length1 = 16;
#line 991 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_lineart_scan_modes_size_ = lineart_scan_modes_length1;
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp139_ = job;
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp140_ = _tmp139_->scan_mode;
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			switch (_tmp140_) {
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_COLOR:
#line 9563 "scanner.c"
				{
					SANE_Handle _tmp141_ = {0};
					SANE_Option_Descriptor* _tmp142_ = NULL;
					SANE_Int _tmp143_ = {0};
					gchar** _tmp144_ = NULL;
					gint _tmp144__length1 = 0;
					gboolean _tmp145_ = FALSE;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp141_ = self->priv->handle;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp142_ = option;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp143_ = index;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp144_ = color_scan_modes;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp144__length1 = color_scan_modes_length1;
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp145_ = scanner_set_constrained_string_option (self, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp144__length1, NULL);
#line 1014 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp145_) {
#line 1015 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1015: Unable to set Color mode, please file a bug");
#line 9587 "scanner.c"
					}
#line 1016 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9591 "scanner.c"
				}
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_GRAY:
#line 9595 "scanner.c"
				{
					SANE_Handle _tmp146_ = {0};
					SANE_Option_Descriptor* _tmp147_ = NULL;
					SANE_Int _tmp148_ = {0};
					gchar** _tmp149_ = NULL;
					gint _tmp149__length1 = 0;
					gboolean _tmp150_ = FALSE;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp146_ = self->priv->handle;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp147_ = option;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp148_ = index;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp149_ = gray_scan_modes;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp149__length1 = gray_scan_modes_length1;
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp150_ = scanner_set_constrained_string_option (self, _tmp146_, _tmp147_, _tmp148_, _tmp149_, _tmp149__length1, NULL);
#line 1018 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp150_) {
#line 1019 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1019: Unable to set Gray mode, please file a bug");
#line 9619 "scanner.c"
					}
#line 1020 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9623 "scanner.c"
				}
#line 1011 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				case SCAN_MODE_LINEART:
#line 9627 "scanner.c"
				{
					SANE_Handle _tmp151_ = {0};
					SANE_Option_Descriptor* _tmp152_ = NULL;
					SANE_Int _tmp153_ = {0};
					gchar** _tmp154_ = NULL;
					gint _tmp154__length1 = 0;
					gboolean _tmp155_ = FALSE;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp151_ = self->priv->handle;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp152_ = option;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp153_ = index;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp154_ = lineart_scan_modes;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp154__length1 = lineart_scan_modes_length1;
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp155_ = scanner_set_constrained_string_option (self, _tmp151_, _tmp152_, _tmp153_, _tmp154_, _tmp154__length1, NULL);
#line 1022 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp155_) {
#line 1023 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						g_warning ("scanner.vala:1023: Unable to set Lineart mode, please file a bug");
#line 9651 "scanner.c"
					}
#line 1024 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9655 "scanner.c"
				}
				default:
				{
#line 1026 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					break;
#line 9661 "scanner.c"
				}
			}
#line 972 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			lineart_scan_modes = (_vala_array_free (lineart_scan_modes, lineart_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			gray_scan_modes = (_vala_array_free (gray_scan_modes, gray_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 972 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			color_scan_modes = (_vala_array_free (color_scan_modes, color_scan_modes_length1, (GDestroyNotify) g_free), NULL);
#line 9670 "scanner.c"
		}
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp156_ = self->priv->handle;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp158_ = scanner_get_option_by_name (self, _tmp156_, "duplex", &_tmp157_);
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp157_;
#line 1031 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp158_;
#line 1032 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp159_ = option;
#line 1032 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp159_ != NULL) {
#line 9684 "scanner.c"
			SANE_Option_Descriptor* _tmp160_ = NULL;
			SANE_Value_Type _tmp161_ = 0;
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp160_ = option;
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp161_ = _tmp160_->type;
#line 1034 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp161_ == SANE_TYPE_BOOL) {
#line 9693 "scanner.c"
				SANE_Handle _tmp162_ = {0};
				SANE_Option_Descriptor* _tmp163_ = NULL;
				SANE_Int _tmp164_ = {0};
				ScanJob* _tmp165_ = NULL;
				ScanType _tmp166_ = 0;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp162_ = self->priv->handle;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp163_ = option;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp164_ = index;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp165_ = job;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp166_ = _tmp165_->type;
#line 1035 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp162_, _tmp163_, _tmp164_, _tmp166_ == SCAN_TYPE_ADF_BOTH, NULL);
#line 9711 "scanner.c"
			}
		}
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp167_ = self->priv->handle;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp169_ = scanner_get_option_by_name (self, _tmp167_, "batch-scan", &_tmp168_);
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp168_;
#line 1039 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp169_;
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp170_ = option;
#line 1040 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp170_ != NULL) {
#line 9726 "scanner.c"
			SANE_Option_Descriptor* _tmp171_ = NULL;
			SANE_Value_Type _tmp172_ = 0;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp171_ = option;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp172_ = _tmp171_->type;
#line 1042 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp172_ == SANE_TYPE_BOOL) {
#line 9735 "scanner.c"
				SANE_Handle _tmp173_ = {0};
				SANE_Option_Descriptor* _tmp174_ = NULL;
				SANE_Int _tmp175_ = {0};
				ScanJob* _tmp176_ = NULL;
				ScanType _tmp177_ = 0;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp173_ = self->priv->handle;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp174_ = option;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp175_ = index;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp176_ = job;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp177_ = _tmp176_->type;
#line 1043 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp173_, _tmp174_, _tmp175_, _tmp177_ != SCAN_TYPE_SINGLE, NULL);
#line 9753 "scanner.c"
			}
		}
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp178_ = self->priv->handle;
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp180_ = scanner_get_option_by_name (self, _tmp178_, "compression", &_tmp179_);
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp179_;
#line 1047 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp180_;
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp181_ = option;
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp181_ != NULL) {
#line 9768 "scanner.c"
			gchar** disable_compression_names = NULL;
			const gchar* _tmp182_ = NULL;
			gchar* _tmp183_ = NULL;
			const gchar* _tmp184_ = NULL;
			gchar* _tmp185_ = NULL;
			gchar* _tmp186_ = NULL;
			gchar* _tmp187_ = NULL;
			gchar** _tmp188_ = NULL;
			gint disable_compression_names_length1 = 0;
			gint _disable_compression_names_size_ = 0;
			SANE_Handle _tmp189_ = {0};
			SANE_Option_Descriptor* _tmp190_ = NULL;
			SANE_Int _tmp191_ = {0};
			gchar** _tmp192_ = NULL;
			gint _tmp192__length1 = 0;
			gboolean _tmp193_ = FALSE;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp182_ = SANE_I18N ("None");
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp183_ = g_strdup (_tmp182_);
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp184_ = SANE_I18N ("none");
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp185_ = g_strdup (_tmp184_);
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp186_ = g_strdup ("None");
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp187_ = g_strdup ("none");
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_ = g_new0 (gchar*, 4 + 1);
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_[0] = _tmp183_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_[1] = _tmp185_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_[2] = _tmp186_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp188_[3] = _tmp187_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names = _tmp188_;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names_length1 = 4;
#line 1050 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_disable_compression_names_size_ = disable_compression_names_length1;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp189_ = self->priv->handle;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp190_ = option;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp191_ = index;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp192_ = disable_compression_names;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp192__length1 = disable_compression_names_length1;
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp193_ = scanner_set_constrained_string_option (self, _tmp189_, _tmp190_, _tmp191_, _tmp192_, _tmp192__length1, NULL);
#line 1058 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (!_tmp193_) {
#line 1059 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				g_warning ("scanner.vala:1059: Unable to disable compression, please file a bug");
#line 9829 "scanner.c"
			}
#line 1048 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			disable_compression_names = (_vala_array_free (disable_compression_names, disable_compression_names_length1, (GDestroyNotify) g_free), NULL);
#line 9833 "scanner.c"
		}
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp194_ = self->priv->handle;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp195_ = SANE_NAME_SCAN_RESOLUTION;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp197_ = scanner_get_option_by_name (self, _tmp194_, _tmp195_, &_tmp196_);
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp196_;
#line 1063 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp197_;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp198_ = option;
#line 1064 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp198_ != NULL) {
#line 9849 "scanner.c"
			SANE_Handle _tmp199_ = {0};
			SANE_Option_Descriptor* _tmp200_ = NULL;
			SANE_Int _tmp201_ = {0};
			ScanJob* _tmp202_ = NULL;
			gdouble _tmp203_ = 0.0;
			ScanJob* _tmp204_ = NULL;
			gdouble _tmp205_ = 0.0;
			SANE_Handle _tmp206_ = {0};
			const gchar* _tmp207_ = NULL;
			gint _tmp208_ = 0;
			SANE_Option_Descriptor* _tmp209_ = NULL;
			SANE_Option_Descriptor* _tmp210_ = NULL;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp199_ = self->priv->handle;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp200_ = option;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp201_ = index;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp202_ = job;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp203_ = _tmp202_->dpi;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp204_ = job;
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp199_, _tmp200_, _tmp201_, _tmp203_, &_tmp205_);
#line 1066 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp204_->dpi = _tmp205_;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp206_ = self->priv->handle;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp207_ = SANE_NAME_BIT_DEPTH;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp209_ = scanner_get_option_by_name (self, _tmp206_, _tmp207_, &_tmp208_);
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp208_;
#line 1067 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp209_;
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp210_ = option;
#line 1068 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp210_ != NULL) {
#line 9892 "scanner.c"
				ScanJob* _tmp211_ = NULL;
				gint _tmp212_ = 0;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp211_ = job;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp212_ = _tmp211_->depth;
#line 1070 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp212_ > 0) {
#line 9901 "scanner.c"
					SANE_Handle _tmp213_ = {0};
					SANE_Option_Descriptor* _tmp214_ = NULL;
					SANE_Int _tmp215_ = {0};
					ScanJob* _tmp216_ = NULL;
					gint _tmp217_ = 0;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp213_ = self->priv->handle;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp214_ = option;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp215_ = index;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp216_ = job;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp217_ = _tmp216_->depth;
#line 1071 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_set_int_option (self, _tmp213_, _tmp214_, _tmp215_, _tmp217_, NULL);
#line 9919 "scanner.c"
				}
			}
		}
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp218_ = self->priv->handle;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp219_ = SANE_NAME_SCAN_BR_X;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp221_ = scanner_get_option_by_name (self, _tmp218_, _tmp219_, &_tmp220_);
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp220_;
#line 1076 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp221_;
#line 1077 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp222_ = option;
#line 1077 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp222_ != NULL) {
#line 9937 "scanner.c"
			ScanJob* _tmp223_ = NULL;
			gint _tmp224_ = 0;
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp223_ = job;
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp224_ = _tmp223_->page_width;
#line 1079 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp224_ > 0) {
#line 9946 "scanner.c"
				SANE_Handle _tmp225_ = {0};
				SANE_Option_Descriptor* _tmp226_ = NULL;
				SANE_Int _tmp227_ = {0};
				SANE_Option_Descriptor* _tmp228_ = NULL;
				ScanJob* _tmp229_ = NULL;
				gint _tmp230_ = 0;
				ScanJob* _tmp231_ = NULL;
				gdouble _tmp232_ = 0.0;
				gdouble _tmp233_ = 0.0;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp225_ = self->priv->handle;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp226_ = option;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp227_ = index;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp228_ = option;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp229_ = job;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp230_ = _tmp229_->page_width;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp231_ = job;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp232_ = _tmp231_->dpi;
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp233_ = scanner_convert_page_size (self, _tmp228_, (gdouble) _tmp230_, _tmp232_);
#line 1080 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp225_, _tmp226_, _tmp227_, _tmp233_, NULL);
#line 9976 "scanner.c"
			} else {
				SANE_Handle _tmp234_ = {0};
				SANE_Option_Descriptor* _tmp235_ = NULL;
				SANE_Int _tmp236_ = {0};
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp234_ = self->priv->handle;
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp235_ = option;
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp236_ = index;
#line 1082 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp234_, _tmp235_, _tmp236_);
#line 9989 "scanner.c"
			}
		}
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp237_ = self->priv->handle;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp238_ = SANE_NAME_SCAN_BR_Y;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp240_ = scanner_get_option_by_name (self, _tmp237_, _tmp238_, &_tmp239_);
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp239_;
#line 1084 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp240_;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp241_ = option;
#line 1085 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp241_ != NULL) {
#line 10006 "scanner.c"
			ScanJob* _tmp242_ = NULL;
			gint _tmp243_ = 0;
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp242_ = job;
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp243_ = _tmp242_->page_height;
#line 1087 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp243_ > 0) {
#line 10015 "scanner.c"
				SANE_Handle _tmp244_ = {0};
				SANE_Option_Descriptor* _tmp245_ = NULL;
				SANE_Int _tmp246_ = {0};
				SANE_Option_Descriptor* _tmp247_ = NULL;
				ScanJob* _tmp248_ = NULL;
				gint _tmp249_ = 0;
				ScanJob* _tmp250_ = NULL;
				gdouble _tmp251_ = 0.0;
				gdouble _tmp252_ = 0.0;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp244_ = self->priv->handle;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp245_ = option;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp246_ = index;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp247_ = option;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp248_ = job;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp249_ = _tmp248_->page_height;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp250_ = job;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp251_ = _tmp250_->dpi;
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp252_ = scanner_convert_page_size (self, _tmp247_, (gdouble) _tmp249_, _tmp251_);
#line 1088 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_fixed_or_int_option (self, _tmp244_, _tmp245_, _tmp246_, _tmp252_, NULL);
#line 10045 "scanner.c"
			} else {
				SANE_Handle _tmp253_ = {0};
				SANE_Option_Descriptor* _tmp254_ = NULL;
				SANE_Int _tmp255_ = {0};
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp253_ = self->priv->handle;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp254_ = option;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp255_ = index;
#line 1090 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_option_to_max (self, _tmp253_, _tmp254_, _tmp255_);
#line 10058 "scanner.c"
			}
		}
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp256_ = self->priv->handle;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp257_ = SANE_NAME_PAGE_WIDTH;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp259_ = scanner_get_option_by_name (self, _tmp256_, _tmp257_, &_tmp258_);
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp258_;
#line 1094 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp259_;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp261_ = option;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp261_ != NULL) {
#line 10075 "scanner.c"
			ScanJob* _tmp262_ = NULL;
			gint _tmp263_ = 0;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp262_ = job;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp263_ = _tmp262_->page_width;
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp260_ = ((gdouble) _tmp263_) > 0.0;
#line 10084 "scanner.c"
		} else {
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp260_ = FALSE;
#line 10088 "scanner.c"
		}
#line 1095 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp260_) {
#line 10092 "scanner.c"
			SANE_Handle _tmp264_ = {0};
			SANE_Option_Descriptor* _tmp265_ = NULL;
			SANE_Int _tmp266_ = {0};
			SANE_Option_Descriptor* _tmp267_ = NULL;
			ScanJob* _tmp268_ = NULL;
			gint _tmp269_ = 0;
			ScanJob* _tmp270_ = NULL;
			gdouble _tmp271_ = 0.0;
			gdouble _tmp272_ = 0.0;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp264_ = self->priv->handle;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp265_ = option;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp266_ = index;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp267_ = option;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp268_ = job;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp269_ = _tmp268_->page_width;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp270_ = job;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp271_ = _tmp270_->dpi;
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp272_ = scanner_convert_page_size (self, _tmp267_, (gdouble) _tmp269_, _tmp271_);
#line 1096 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp264_, _tmp265_, _tmp266_, _tmp272_, NULL);
#line 10122 "scanner.c"
		}
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp273_ = self->priv->handle;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp274_ = SANE_NAME_PAGE_HEIGHT;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp276_ = scanner_get_option_by_name (self, _tmp273_, _tmp274_, &_tmp275_);
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp275_;
#line 1097 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp276_;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp278_ = option;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp278_ != NULL) {
#line 10138 "scanner.c"
			ScanJob* _tmp279_ = NULL;
			gint _tmp280_ = 0;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp279_ = job;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp280_ = _tmp279_->page_height;
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp277_ = ((gdouble) _tmp280_) > 0.0;
#line 10147 "scanner.c"
		} else {
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp277_ = FALSE;
#line 10151 "scanner.c"
		}
#line 1098 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp277_) {
#line 10155 "scanner.c"
			SANE_Handle _tmp281_ = {0};
			SANE_Option_Descriptor* _tmp282_ = NULL;
			SANE_Int _tmp283_ = {0};
			SANE_Option_Descriptor* _tmp284_ = NULL;
			ScanJob* _tmp285_ = NULL;
			gint _tmp286_ = 0;
			ScanJob* _tmp287_ = NULL;
			gdouble _tmp288_ = 0.0;
			gdouble _tmp289_ = 0.0;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp281_ = self->priv->handle;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp282_ = option;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp283_ = index;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp284_ = option;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp285_ = job;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp286_ = _tmp285_->page_height;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp287_ = job;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp288_ = _tmp287_->dpi;
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp289_ = scanner_convert_page_size (self, _tmp284_, (gdouble) _tmp286_, _tmp288_);
#line 1099 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_set_fixed_or_int_option (self, _tmp281_, _tmp282_, _tmp283_, _tmp289_, NULL);
#line 10185 "scanner.c"
		}
#line 1101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp290_ = self->priv->handle;
#line 1101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp291_ = SANE_NAME_BRIGHTNESS;
#line 1101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp293_ = scanner_get_option_by_name (self, _tmp290_, _tmp291_, &_tmp292_);
#line 1101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp292_;
#line 1101 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp293_;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp294_ = option;
#line 1102 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp294_ != NULL) {
#line 10201 "scanner.c"
			ScanJob* _tmp295_ = NULL;
			gint _tmp296_ = 0;
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp295_ = job;
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp296_ = _tmp295_->brightness;
#line 1104 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp296_ != 0) {
#line 10210 "scanner.c"
				gint brightness = 0;
				SANE_Option_Descriptor* _tmp297_ = NULL;
				ScanJob* _tmp298_ = NULL;
				gint _tmp299_ = 0;
				gint _tmp300_ = 0;
				SANE_Handle _tmp301_ = {0};
				SANE_Option_Descriptor* _tmp302_ = NULL;
				SANE_Int _tmp303_ = {0};
				gint _tmp304_ = 0;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp297_ = option;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp298_ = job;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp299_ = _tmp298_->brightness;
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp300_ = scanner_scale_int (self, -100, 100, _tmp297_, _tmp299_);
#line 1106 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				brightness = _tmp300_;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp301_ = self->priv->handle;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp302_ = option;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp303_ = index;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp304_ = brightness;
#line 1107 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp301_, _tmp302_, _tmp303_, _tmp304_, NULL);
#line 10240 "scanner.c"
			}
		}
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp305_ = self->priv->handle;
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp306_ = SANE_NAME_CONTRAST;
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp308_ = scanner_get_option_by_name (self, _tmp305_, _tmp306_, &_tmp307_);
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		index = (SANE_Int) _tmp307_;
#line 1110 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		option = _tmp308_;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp309_ = option;
#line 1111 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp309_ != NULL) {
#line 10257 "scanner.c"
			ScanJob* _tmp310_ = NULL;
			gint _tmp311_ = 0;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp310_ = job;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp311_ = _tmp310_->contrast;
#line 1113 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp311_ != 0) {
#line 10266 "scanner.c"
				gint contrast = 0;
				SANE_Option_Descriptor* _tmp312_ = NULL;
				ScanJob* _tmp313_ = NULL;
				gint _tmp314_ = 0;
				gint _tmp315_ = 0;
				SANE_Handle _tmp316_ = {0};
				SANE_Option_Descriptor* _tmp317_ = NULL;
				SANE_Int _tmp318_ = {0};
				gint _tmp319_ = 0;
#line 1115 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp312_ = option;
#line 1115 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp313_ = job;
#line 1115 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp314_ = _tmp313_->contrast;
#line 1115 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp315_ = scanner_scale_int (self, -100, 100, _tmp312_, _tmp314_);
#line 1115 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				contrast = _tmp315_;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp316_ = self->priv->handle;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp317_ = option;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp318_ = index;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp319_ = contrast;
#line 1116 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp316_, _tmp317_, _tmp318_, _tmp319_, NULL);
#line 10296 "scanner.c"
			}
		}
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp320_ = self->priv->current_device;
#line 1121 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (g_strcmp0 (_tmp320_, "test") == 0) {
#line 10303 "scanner.c"
			SANE_Handle _tmp321_ = {0};
			gint _tmp322_ = 0;
			SANE_Option_Descriptor* _tmp323_ = NULL;
			SANE_Option_Descriptor* _tmp324_ = NULL;
			SANE_Handle _tmp328_ = {0};
			gint _tmp329_ = 0;
			SANE_Option_Descriptor* _tmp330_ = NULL;
			SANE_Option_Descriptor* _tmp331_ = NULL;
			SANE_Handle _tmp335_ = {0};
			gint _tmp336_ = 0;
			SANE_Option_Descriptor* _tmp337_ = NULL;
			SANE_Option_Descriptor* _tmp338_ = NULL;
			SANE_Handle _tmp342_ = {0};
			gint _tmp343_ = 0;
			SANE_Option_Descriptor* _tmp344_ = NULL;
			SANE_Option_Descriptor* _tmp345_ = NULL;
			SANE_Handle _tmp349_ = {0};
			gint _tmp350_ = 0;
			SANE_Option_Descriptor* _tmp351_ = NULL;
			SANE_Option_Descriptor* _tmp352_ = NULL;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp321_ = self->priv->handle;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp323_ = scanner_get_option_by_name (self, _tmp321_, "hand-scanner", &_tmp322_);
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp322_;
#line 1123 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp323_;
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp324_ = option;
#line 1124 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp324_ != NULL) {
#line 10336 "scanner.c"
				SANE_Handle _tmp325_ = {0};
				SANE_Option_Descriptor* _tmp326_ = NULL;
				SANE_Int _tmp327_ = {0};
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp325_ = self->priv->handle;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp326_ = option;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp327_ = index;
#line 1125 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp325_, _tmp326_, _tmp327_, FALSE, NULL);
#line 10348 "scanner.c"
			}
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp328_ = self->priv->handle;
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp330_ = scanner_get_option_by_name (self, _tmp328_, "three-pass", &_tmp329_);
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp329_;
#line 1126 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp330_;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp331_ = option;
#line 1127 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp331_ != NULL) {
#line 10362 "scanner.c"
				SANE_Handle _tmp332_ = {0};
				SANE_Option_Descriptor* _tmp333_ = NULL;
				SANE_Int _tmp334_ = {0};
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp332_ = self->priv->handle;
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp333_ = option;
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp334_ = index;
#line 1128 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp332_, _tmp333_, _tmp334_, FALSE, NULL);
#line 10374 "scanner.c"
			}
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp335_ = self->priv->handle;
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp337_ = scanner_get_option_by_name (self, _tmp335_, "test-picture", &_tmp336_);
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp336_;
#line 1129 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp337_;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp338_ = option;
#line 1130 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp338_ != NULL) {
#line 10388 "scanner.c"
				SANE_Handle _tmp339_ = {0};
				SANE_Option_Descriptor* _tmp340_ = NULL;
				SANE_Int _tmp341_ = {0};
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp339_ = self->priv->handle;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp340_ = option;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp341_ = index;
#line 1131 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_string_option (self, _tmp339_, _tmp340_, _tmp341_, "Color pattern", NULL);
#line 10400 "scanner.c"
			}
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp342_ = self->priv->handle;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp344_ = scanner_get_option_by_name (self, _tmp342_, "read-delay", &_tmp343_);
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp343_;
#line 1132 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp344_;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp345_ = option;
#line 1133 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp345_ != NULL) {
#line 10414 "scanner.c"
				SANE_Handle _tmp346_ = {0};
				SANE_Option_Descriptor* _tmp347_ = NULL;
				SANE_Int _tmp348_ = {0};
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp346_ = self->priv->handle;
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp347_ = option;
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp348_ = index;
#line 1134 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_bool_option (self, _tmp346_, _tmp347_, _tmp348_, TRUE, NULL);
#line 10426 "scanner.c"
			}
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp349_ = self->priv->handle;
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp351_ = scanner_get_option_by_name (self, _tmp349_, "read-delay-duration", &_tmp350_);
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			index = (SANE_Int) _tmp350_;
#line 1135 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			option = _tmp351_;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp352_ = option;
#line 1136 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			if (_tmp352_ != NULL) {
#line 10440 "scanner.c"
				SANE_Handle _tmp353_ = {0};
				SANE_Option_Descriptor* _tmp354_ = NULL;
				SANE_Int _tmp355_ = {0};
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp353_ = self->priv->handle;
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp354_ = option;
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp355_ = index;
#line 1137 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_set_int_option (self, _tmp353_, _tmp354_, _tmp355_, 200000, NULL);
#line 10452 "scanner.c"
			}
		}
#line 1140 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1141 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10461 "scanner.c"
	}
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp356_ = index;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp357_ = option;
#line 1144 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_log_option (self, _tmp356_, _tmp357_);
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp358_ = option;
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp359_ = _tmp358_->type;
#line 1147 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp359_ == SANE_TYPE_GROUP) {
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1148 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10479 "scanner.c"
	}
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp360_ = option;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp361_ = _tmp360_->cap;
#line 1151 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if ((_tmp361_ & SANE_CAP_INACTIVE) != ((SANE_Int) 0)) {
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1152 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10491 "scanner.c"
	}
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp362_ = option;
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp363_ = _tmp362_->name;
#line 1155 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp363_ == NULL) {
#line 1156 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1156 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10503 "scanner.c"
	}
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp364_ = self->priv->options;
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp365_ = option;
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp366_ = _tmp365_->name;
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp367_ = g_strdup (_tmp366_);
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp368_ = index;
#line 1158 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_hash_table_insert (_tmp364_, _tmp367_, (gpointer) ((gintptr) ((gint) _tmp368_)));
#line 880 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 10519 "scanner.c"
}


static gdouble scanner_convert_page_size (Scanner* self, SANE_Option_Descriptor* option, gdouble size, gdouble dpi) {
	gdouble result = 0.0;
	SANE_Option_Descriptor* _tmp0_ = NULL;
	SANE_Unit _tmp1_ = 0;
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 1161 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (option != NULL, 0.0);
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = option;
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->unit;
#line 1163 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ == SANE_UNIT_PIXEL) {
#line 10537 "scanner.c"
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = dpi;
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = size;
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = (_tmp2_ * _tmp3_) / 254.0;
#line 1164 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 10548 "scanner.c"
	} else {
		SANE_Option_Descriptor* _tmp4_ = NULL;
		SANE_Unit _tmp5_ = 0;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = option;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp5_ = _tmp4_->unit;
#line 1165 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp5_ == SANE_UNIT_MM) {
#line 10558 "scanner.c"
			gdouble _tmp6_ = 0.0;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = size;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_ / 10.0;
#line 1166 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 10566 "scanner.c"
		} else {
#line 1169 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1169: Unable to set unsupported unit type");
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = (gdouble) 0.0f;
#line 1170 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 10574 "scanner.c"
		}
	}
}


static SANE_Option_Descriptor* scanner_get_option_by_name (Scanner* self, SANE_Handle handle, const gchar* name, gint* index) {
	gint _vala_index = 0;
	SANE_Option_Descriptor* result = NULL;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	gint _tmp3_ = 0;
	SANE_Handle _tmp4_ = {0};
	gint _tmp5_ = 0;
	SANE_Option_Descriptor* _tmp6_ = NULL;
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1174 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->options;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = name;
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = g_hash_table_lookup (_tmp0_, _tmp1_);
#line 1176 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_vala_index = (gint) ((gintptr) _tmp2_);
#line 1177 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = _vala_index;
#line 1177 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp3_ == 0) {
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = NULL;
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (index) {
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			*index = _vala_index;
#line 10612 "scanner.c"
		}
#line 1178 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 10616 "scanner.c"
	}
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = handle;
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _vala_index;
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = sane_get_option_descriptor (_tmp4_, (SANE_Int) _tmp5_);
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp6_;
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (index) {
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*index = _vala_index;
#line 10630 "scanner.c"
	}
#line 1180 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 10634 "scanner.c"
}


static void scanner_do_complete_document (Scanner* self) {
	SANE_Handle _tmp0_ = {0};
	GList* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	NotifyDocumentDone* _tmp3_ = NULL;
	NotifyDocumentDone* _tmp4_ = NULL;
#line 1183 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1185 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	sane_cancel (_tmp0_);
#line 1186 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1186: sane_cancel ()");
#line 1188 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->job_queue;
#line 1188 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->job_queue = g_list_remove_link (self->priv->job_queue, _tmp1_);
#line 1190 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->job_queue;
#line 1193 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 1195 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_OPEN;
#line 1196 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10666 "scanner.c"
	}
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = notify_document_done_new ();
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp4_);
#line 1202 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp4_);
#line 1203 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_set_scanning (self, FALSE);
#line 10678 "scanner.c"
}


static void scanner_do_start (Scanner* self) {
	SANE_Status status = 0;
	NotifyExpectPage* _tmp0_ = NULL;
	NotifyExpectPage* _tmp1_ = NULL;
	SANE_Handle _tmp2_ = {0};
	SANE_Status _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	SANE_Status _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	SANE_Status _tmp9_ = 0;
#line 1206 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = notify_expect_page_new ();
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_;
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp1_);
#line 1210 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp1_);
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->handle;
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_start (_tmp2_);
#line 1212 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp3_;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->page_number;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->pass_number;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = sane_status_to_string (_tmp6_);
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1213: sane_start (page=%d, pass=%d) -> %s", _tmp4_, _tmp5_, _tmp8_);
#line 1213 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1214 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = status;
#line 1214 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp9_ == SANE_STATUS_GOOD) {
#line 1215 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_GET_PARAMETERS;
#line 10730 "scanner.c"
	} else {
		SANE_Status _tmp10_ = 0;
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = status;
#line 1216 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp10_ == SANE_STATUS_NO_DOCS) {
#line 1217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_do_complete_document (self);
#line 10739 "scanner.c"
		} else {
			SANE_Status _tmp11_ = 0;
			const gchar* _tmp12_ = NULL;
			SANE_Status _tmp13_ = 0;
			const gchar* _tmp14_ = NULL;
#line 1220 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp11_ = status;
#line 1220 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp12_ = sane_strstatus (_tmp11_);
#line 1220 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1220: Unable to start device: %s", _tmp12_);
#line 1221 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp13_ = status;
#line 1221 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp14_ = _ ("Unable to start scan");
#line 1221 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			scanner_fail_scan (self, (gint) _tmp13_, _tmp14_);
#line 10757 "scanner.c"
		}
	}
}


static gchar* sane_frame_to_string (SANE_Frame frame) {
	gchar* result = NULL;
	SANE_Frame _tmp0_ = 0;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	_tmp0_ = frame;
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
	switch (_tmp0_) {
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_GRAY:
#line 10772 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp1_ = g_strdup ("SANE_FRAME_GRAY");
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp1_;
#line 106 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10781 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_RGB:
#line 10785 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp2_ = g_strdup ("SANE_FRAME_RGB");
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp2_;
#line 108 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10794 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_RED:
#line 10798 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp3_ = g_strdup ("SANE_FRAME_RED");
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp3_;
#line 110 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10807 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_GREEN:
#line 10811 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp4_ = g_strdup ("SANE_FRAME_GREEN");
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp4_;
#line 112 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10820 "scanner.c"
		}
#line 103 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
		case SANE_FRAME_BLUE:
#line 10824 "scanner.c"
		{
			gchar* _tmp5_ = NULL;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp5_ = g_strdup ("SANE_FRAME_BLUE");
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp5_;
#line 114 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10833 "scanner.c"
		}
		default:
		{
			SANE_Frame _tmp6_ = 0;
			gchar* _tmp7_ = NULL;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp6_ = frame;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			_tmp7_ = g_strdup_printf ("SANE_FRAME(%d)", (gint) _tmp6_);
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			result = _tmp7_;
#line 116 "/home/bob/bzr/simple-scan/trunk/src/sane.vapi"
			return result;
#line 10847 "scanner.c"
		}
	}
}


static void scanner_do_get_parameters (Scanner* self) {
	SANE_Status status = 0;
	SANE_Handle _tmp0_ = {0};
	SANE_Parameters _tmp1_ = {0};
	SANE_Status _tmp2_ = 0;
	SANE_Status _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	SANE_Status _tmp6_ = 0;
	ScanJob* job = NULL;
	GList* _tmp11_ = NULL;
	gconstpointer _tmp12_ = NULL;
	ScanJob* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	SANE_Parameters _tmp15_ = {0};
	gboolean _tmp16_ = FALSE;
	SANE_Parameters _tmp17_ = {0};
	SANE_Frame _tmp18_ = 0;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	SANE_Parameters _tmp21_ = {0};
	gint _tmp22_ = 0;
	SANE_Parameters _tmp23_ = {0};
	gint _tmp24_ = 0;
	SANE_Parameters _tmp25_ = {0};
	gint _tmp26_ = 0;
	SANE_Parameters _tmp27_ = {0};
	gint _tmp28_ = 0;
	ScanPageInfo* info = NULL;
	ScanPageInfo* _tmp29_ = NULL;
	ScanPageInfo* _tmp30_ = NULL;
	SANE_Parameters _tmp31_ = {0};
	gint _tmp32_ = 0;
	ScanPageInfo* _tmp33_ = NULL;
	SANE_Parameters _tmp34_ = {0};
	gint _tmp35_ = 0;
	ScanPageInfo* _tmp36_ = NULL;
	SANE_Parameters _tmp37_ = {0};
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	SANE_Parameters _tmp42_ = {0};
	gint _tmp43_ = 0;
	gint _tmp53_ = 0;
	SANE_Parameters _tmp54_ = {0};
	SANE_Frame _tmp55_ = 0;
	ScanPageInfo* _tmp56_ = NULL;
	ScanPageInfo* _tmp57_ = NULL;
	ScanJob* _tmp58_ = NULL;
	gdouble _tmp59_ = 0.0;
	ScanPageInfo* _tmp60_ = NULL;
	const gchar* _tmp61_ = NULL;
	gchar* _tmp62_ = NULL;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint buffer_size = 0;
	SANE_Parameters _tmp71_ = {0};
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	guchar* _tmp74_ = NULL;
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->handle;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = sane_get_parameters (_tmp0_, &_tmp1_);
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->parameters = _tmp1_;
#line 1229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp2_;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = status;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = sane_status_to_string (_tmp3_);
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = _tmp4_;
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1230: sane_get_parameters () -> %s", _tmp5_);
#line 1230 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp5_);
#line 1231 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = status;
#line 1231 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp6_ != SANE_STATUS_GOOD) {
#line 10938 "scanner.c"
		SANE_Status _tmp7_ = 0;
		const gchar* _tmp8_ = NULL;
		SANE_Status _tmp9_ = 0;
		const gchar* _tmp10_ = NULL;
#line 1233 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = status;
#line 1233 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp8_ = sane_strstatus (_tmp7_);
#line 1233 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1233: Unable to get device parameters: %s", _tmp8_);
#line 1234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = status;
#line 1234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp10_ = _ ("Error communicating with scanner");
#line 1234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp9_, _tmp10_);
#line 1237 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 10957 "scanner.c"
	}
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = self->priv->job_queue;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->data;
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp12_, TYPE_SCAN_JOB, ScanJob));
#line 1240 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp13_;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = self->priv->parameters;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = _tmp15_.last_frame;
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp16_) {
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = "SANE_TRUE";
#line 10975 "scanner.c"
	} else {
#line 1244 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = "SANE_FALSE";
#line 10979 "scanner.c"
	}
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = self->priv->parameters;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = _tmp17_.format;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = sane_frame_to_string (_tmp18_);
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = _tmp19_;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = self->priv->parameters;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_.bytes_per_line;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = self->priv->parameters;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = _tmp23_.pixels_per_line;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = self->priv->parameters;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = _tmp25_.lines;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = self->priv->parameters;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = _tmp27_.depth;
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1242: Parameters: format=%s last_frame=%s bytes_per_line=" \
"%d pixels_per_line=%d lines=%d depth=%d", _tmp20_, _tmp14_, _tmp22_, _tmp24_, _tmp26_, _tmp28_);
#line 1242 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp20_);
#line 1250 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = scan_page_info_new ();
#line 1250 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	info = _tmp29_;
#line 1251 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = info;
#line 1251 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = self->priv->parameters;
#line 1251 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = _tmp31_.pixels_per_line;
#line 1251 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_->width = _tmp32_;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = info;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = self->priv->parameters;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = _tmp34_.lines;
#line 1252 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_->height = _tmp35_;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = info;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = self->priv->parameters;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = _tmp37_.depth;
#line 1253 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_->depth = _tmp38_;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = self->priv->parameters;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = _tmp42_.depth;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp43_ == 8) {
#line 11043 "scanner.c"
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp41_ = _tmp45_ == SANE_FRAME_GRAY;
#line 11052 "scanner.c"
	} else {
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp41_ = FALSE;
#line 11056 "scanner.c"
	}
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp41_) {
#line 11060 "scanner.c"
		ScanJob* _tmp46_ = NULL;
		gint _tmp47_ = 0;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp46_ = job;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp47_ = _tmp46_->depth;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp40_ = _tmp47_ == 2;
#line 11069 "scanner.c"
	} else {
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp40_ = FALSE;
#line 11073 "scanner.c"
	}
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp40_) {
#line 11077 "scanner.c"
		ScanJob* _tmp48_ = NULL;
		ScanMode _tmp49_ = 0;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp48_ = job;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp49_ = _tmp48_->scan_mode;
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp39_ = _tmp49_ == SCAN_MODE_GRAY;
#line 11086 "scanner.c"
	} else {
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp39_ = FALSE;
#line 11090 "scanner.c"
	}
#line 1256 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp39_) {
#line 11094 "scanner.c"
		ScanPageInfo* _tmp50_ = NULL;
		ScanJob* _tmp51_ = NULL;
		gint _tmp52_ = 0;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp50_ = info;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_ = job;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp52_ = _tmp51_->depth;
#line 1257 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp50_->depth = _tmp52_;
#line 11106 "scanner.c"
	}
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = self->priv->parameters;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = _tmp54_.format;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp55_ == SANE_FRAME_GRAY) {
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = 1;
#line 11116 "scanner.c"
	} else {
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = 3;
#line 11120 "scanner.c"
	}
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_ = info;
#line 1258 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp56_->n_channels = _tmp53_;
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp57_ = info;
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp58_ = job;
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp59_ = _tmp58_->dpi;
#line 1259 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp57_->dpi = _tmp59_;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp60_ = info;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp61_ = self->priv->current_device;
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp62_ = g_strdup (_tmp61_);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp60_->device);
#line 1260 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp60_->device = _tmp62_;
#line 1262 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp63_ = self->priv->page_number;
#line 1262 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp64_ = self->priv->notified_page;
#line 1262 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp63_ != _tmp64_) {
#line 11150 "scanner.c"
		ScanJob* _tmp65_ = NULL;
		gint _tmp66_ = 0;
		ScanPageInfo* _tmp67_ = NULL;
		NotifyGotPageInfo* _tmp68_ = NULL;
		NotifyGotPageInfo* _tmp69_ = NULL;
		gint _tmp70_ = 0;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp65_ = job;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp66_ = _tmp65_->id;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp67_ = info;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp68_ = notify_got_page_info_new (_tmp66_, _tmp67_);
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp69_ = _tmp68_;
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp69_);
#line 1264 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp69_);
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp70_ = self->priv->page_number;
#line 1265 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->notified_page = _tmp70_;
#line 11175 "scanner.c"
	}
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp71_ = self->priv->parameters;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp72_ = _tmp71_.bytes_per_line;
#line 1269 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	buffer_size = _tmp72_ + 1;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp73_ = buffer_size;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp74_ = g_new0 (guchar, _tmp73_);
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = _tmp74_;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer_length1 = _tmp73_;
#line 1270 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1271 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->n_used = 0;
#line 1272 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->line_count = 0;
#line 1273 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->pass_number = 0;
#line 1274 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_READ;
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_page_info_unref0 (info);
#line 1227 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11207 "scanner.c"
}


static void scanner_do_complete_page (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	ScanJob* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	NotifyPageDone* _tmp5_ = NULL;
	NotifyPageDone* _tmp6_ = NULL;
	SANE_Parameters _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	ScanJob* _tmp10_ = NULL;
	ScanType _tmp11_ = 0;
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1279 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = job;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->id;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = notify_page_done_new (_tmp4_);
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_;
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_notify (self, (Notify*) _tmp6_);
#line 1281 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_notify_unref0 (_tmp6_);
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = self->priv->parameters;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_.last_frame;
#line 1284 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!_tmp8_) {
#line 11252 "scanner.c"
		gint _tmp9_ = 0;
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp9_ = self->priv->pass_number;
#line 1286 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->pass_number = _tmp9_ + 1;
#line 1287 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1288 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11264 "scanner.c"
	}
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = job;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = _tmp10_->type;
#line 1292 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp11_ != SCAN_TYPE_SINGLE) {
#line 11272 "scanner.c"
		gint _tmp12_ = 0;
		ScanJob* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		NotifyPageDone* _tmp15_ = NULL;
		NotifyPageDone* _tmp16_ = NULL;
#line 1294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp12_ = self->priv->page_number;
#line 1294 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->page_number = _tmp12_ + 1;
#line 1295 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->pass_number = 0;
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp13_ = job;
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = _tmp13_->id;
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = notify_page_done_new (_tmp14_);
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp16_ = _tmp15_;
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp16_);
#line 1296 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp16_);
#line 1297 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->state = SCAN_STATE_START;
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1298 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11302 "scanner.c"
	}
#line 1301 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_do_complete_document (self);
#line 1277 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 11308 "scanner.c"
}


static void scanner_do_read (Scanner* self) {
	ScanJob* job = NULL;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	ScanJob* _tmp2_ = NULL;
	gint n_to_read = 0;
	guchar* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp4_ = 0;
	SANE_Int n_read = {0};
	guchar* b = NULL;
	guchar* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	SANE_Status status = 0;
	SANE_Handle _tmp6_ = {0};
	guchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	SANE_Status _tmp11_ = 0;
	gint _tmp12_ = 0;
	SANE_Status _tmp13_ = 0;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	SANE_Int _tmp16_ = {0};
	SANE_Status _tmp17_ = 0;
	SANE_Status _tmp29_ = 0;
	gboolean full_read = FALSE;
	gboolean _tmp34_ = FALSE;
	gint _tmp35_ = 0;
	gint _tmp38_ = 0;
	SANE_Int _tmp39_ = {0};
	gint _tmp40_ = 0;
	SANE_Parameters _tmp41_ = {0};
	gint _tmp42_ = 0;
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1306 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->job_queue;
#line 1306 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = _tmp0_->data;
#line 1306 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = _scan_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST ((ScanJob*) _tmp1_, TYPE_SCAN_JOB, ScanJob));
#line 1306 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	job = _tmp2_;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = self->priv->buffer;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3__length1 = self->priv->buffer_length1;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = self->priv->n_used;
#line 1309 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	n_to_read = _tmp3__length1 - _tmp4_;
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = self->priv->buffer;
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5__length1 = self->priv->buffer_length1;
#line 1312 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	b = (guchar*) _tmp5_;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = self->priv->handle;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = b;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = self->priv->n_used;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = n_to_read;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = sane_read (_tmp6_, (guint8*) (_tmp7_ + _tmp8_), (SANE_Int) _tmp9_, &_tmp10_);
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	n_read = _tmp10_;
#line 1313 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp11_;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = n_to_read;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = status;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = sane_status_to_string (_tmp13_);
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = _tmp14_;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = n_read;
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1314: sane_read (%d) -> (%s, %d)", _tmp12_, _tmp15_, (gint) _tmp16_);
#line 1314 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp15_);
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = status;
#line 1317 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp17_ == SANE_STATUS_EOF) {
#line 11403 "scanner.c"
		gboolean _tmp18_ = FALSE;
		SANE_Parameters _tmp19_ = {0};
		gint _tmp20_ = 0;
		gint _tmp27_ = 0;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp19_ = self->priv->parameters;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp20_ = _tmp19_.lines;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp20_ > 0) {
#line 11414 "scanner.c"
			gint _tmp21_ = 0;
			SANE_Parameters _tmp22_ = {0};
			gint _tmp23_ = 0;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp21_ = self->priv->line_count;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp22_ = self->priv->parameters;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp23_ = _tmp22_.lines;
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = _tmp21_ != _tmp23_;
#line 11426 "scanner.c"
		} else {
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp18_ = FALSE;
#line 11430 "scanner.c"
		}
#line 1319 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp18_) {
#line 11434 "scanner.c"
			gint _tmp24_ = 0;
			SANE_Parameters _tmp25_ = {0};
			gint _tmp26_ = 0;
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp24_ = self->priv->line_count;
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp25_ = self->priv->parameters;
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp26_ = _tmp25_.lines;
#line 1320 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1320: Scan completed with %d lines, expected %d lines", _tmp24_, _tmp26_);
#line 11446 "scanner.c"
		}
#line 1321 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp27_ = self->priv->n_used;
#line 1321 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp27_ > 0) {
#line 11452 "scanner.c"
			gint _tmp28_ = 0;
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp28_ = self->priv->n_used;
#line 1322 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			g_warning ("scanner.vala:1322: Scan complete with %d bytes of unused data", _tmp28_);
#line 11458 "scanner.c"
		}
#line 1323 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_do_complete_page (self);
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1324 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11466 "scanner.c"
	}
#line 1328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = status;
#line 1328 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp29_ != SANE_STATUS_GOOD) {
#line 11472 "scanner.c"
		SANE_Status _tmp30_ = 0;
		const gchar* _tmp31_ = NULL;
		SANE_Status _tmp32_ = 0;
		const gchar* _tmp33_ = NULL;
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp30_ = status;
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp31_ = sane_strstatus (_tmp30_);
#line 1330 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1330: Unable to read frame from device: %s", _tmp31_);
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp32_ = status;
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp33_ = _ ("Error communicating with scanner");
#line 1331 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_fail_scan (self, (gint) _tmp32_, _tmp33_);
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_job_unref0 (job);
#line 1334 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 11493 "scanner.c"
	}
#line 1337 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	full_read = FALSE;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = self->priv->n_used;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp35_ == 0) {
#line 11501 "scanner.c"
		SANE_Int _tmp36_ = {0};
		guchar* _tmp37_ = NULL;
		gint _tmp37__length1 = 0;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp36_ = n_read;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37_ = self->priv->buffer;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp37__length1 = self->priv->buffer_length1;
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = _tmp36_ == ((SANE_Int) _tmp37__length1);
#line 11513 "scanner.c"
	} else {
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp34_ = FALSE;
#line 11517 "scanner.c"
	}
#line 1338 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp34_) {
#line 1339 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		full_read = TRUE;
#line 11523 "scanner.c"
	}
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = self->priv->n_used;
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = n_read;
#line 1340 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->n_used = _tmp38_ + ((gint) _tmp39_);
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = self->priv->n_used;
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = self->priv->parameters;
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = _tmp41_.bytes_per_line;
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp40_ >= _tmp42_) {
#line 11539 "scanner.c"
		ScanLine* line = NULL;
		ScanLine* _tmp43_ = NULL;
		SANE_Parameters _tmp44_ = {0};
		SANE_Frame _tmp45_ = 0;
		ScanLine* _tmp51_ = NULL;
		SANE_Parameters _tmp52_ = {0};
		gint _tmp53_ = 0;
		ScanLine* _tmp54_ = NULL;
		SANE_Parameters _tmp55_ = {0};
		gint _tmp56_ = 0;
		ScanLine* _tmp57_ = NULL;
		guchar* _tmp58_ = NULL;
		gint _tmp58__length1 = 0;
		ScanLine* _tmp59_ = NULL;
		SANE_Parameters _tmp60_ = {0};
		gint _tmp61_ = 0;
		ScanLine* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		ScanLine* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		ScanLine* _tmp66_ = NULL;
		gint _tmp67_ = 0;
		gint _tmp68_ = 0;
		ScanLine* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint buffer_size = 0;
		ScanLine* _tmp71_ = NULL;
		guchar* _tmp72_ = NULL;
		gint _tmp72__length1 = 0;
		gboolean _tmp73_ = FALSE;
		gint _tmp77_ = 0;
		guchar* _tmp78_ = NULL;
		gint n_remaining = 0;
		gint _tmp79_ = 0;
		ScanLine* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		ScanLine* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		gboolean _tmp100_ = FALSE;
		gboolean _tmp101_ = FALSE;
		gboolean _tmp102_ = FALSE;
		SANE_Parameters _tmp103_ = {0};
		gint _tmp104_ = 0;
		ScanJob* _tmp153_ = NULL;
		gint _tmp154_ = 0;
		ScanLine* _tmp155_ = NULL;
		NotifyGotLine* _tmp156_ = NULL;
		NotifyGotLine* _tmp157_ = NULL;
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp43_ = scan_line_new ();
#line 1345 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		line = _tmp43_;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp44_ = self->priv->parameters;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp45_ = _tmp44_.format;
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		switch (_tmp45_) {
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_GRAY:
#line 11600 "scanner.c"
			{
				ScanLine* _tmp46_ = NULL;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_ = line;
#line 1349 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp46_->channel = 0;
#line 1350 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11609 "scanner.c"
			}
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_RGB:
#line 11613 "scanner.c"
			{
				ScanLine* _tmp47_ = NULL;
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_ = line;
#line 1352 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp47_->channel = -1;
#line 1353 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11622 "scanner.c"
			}
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_RED:
#line 11626 "scanner.c"
			{
				ScanLine* _tmp48_ = NULL;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_ = line;
#line 1355 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp48_->channel = 0;
#line 1356 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11635 "scanner.c"
			}
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_GREEN:
#line 11639 "scanner.c"
			{
				ScanLine* _tmp49_ = NULL;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_ = line;
#line 1358 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp49_->channel = 1;
#line 1359 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11648 "scanner.c"
			}
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SANE_FRAME_BLUE:
#line 11652 "scanner.c"
			{
				ScanLine* _tmp50_ = NULL;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_ = line;
#line 1361 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp50_->channel = 2;
#line 1362 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 11661 "scanner.c"
			}
			default:
#line 1346 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 11666 "scanner.c"
		}
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_ = line;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp52_ = self->priv->parameters;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp53_ = _tmp52_.pixels_per_line;
#line 1364 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp51_->width = _tmp53_;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp54_ = line;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp55_ = self->priv->parameters;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp56_ = _tmp55_.depth;
#line 1365 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp54_->depth = _tmp56_;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_ = line;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58_ = self->priv->buffer;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp58__length1 = self->priv->buffer_length1;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = NULL;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer_length1 = 0;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data = (g_free (_tmp57_->data), NULL);
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data = _tmp58_;
#line 1366 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp57_->data_length1 = _tmp58__length1;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_ = line;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp60_ = self->priv->parameters;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp61_ = _tmp60_.bytes_per_line;
#line 1367 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp59_->data_length = _tmp61_;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_ = line;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp63_ = self->priv->line_count;
#line 1368 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp62_->number = _tmp63_;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp64_ = line;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp65_ = self->priv->n_used;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp66_ = line;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp67_ = _tmp66_->data_length;
#line 1369 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp64_->n_lines = _tmp65_ / _tmp67_;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp68_ = self->priv->line_count;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp69_ = line;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp70_ = _tmp69_->n_lines;
#line 1371 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->line_count = _tmp68_ + _tmp70_;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp71_ = line;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp72_ = _tmp71_->data;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp72__length1 = _tmp71_->data_length1;
#line 1374 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		buffer_size = _tmp72__length1;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp73_ = full_read;
#line 1375 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp73_) {
#line 11744 "scanner.c"
			gint _tmp74_ = 0;
			SANE_Parameters _tmp75_ = {0};
			gint _tmp76_ = 0;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp74_ = buffer_size;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp75_ = self->priv->parameters;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp76_ = _tmp75_.bytes_per_line;
#line 1376 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			buffer_size = _tmp74_ + _tmp76_;
#line 11756 "scanner.c"
		}
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp77_ = buffer_size;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp78_ = g_new0 (guchar, _tmp77_);
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer = _tmp78_;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->buffer_length1 = _tmp77_;
#line 1378 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->_buffer_size_ = self->priv->buffer_length1;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp79_ = self->priv->n_used;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp80_ = line;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp81_ = _tmp80_->n_lines;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp82_ = line;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp83_ = _tmp82_->data_length;
#line 1379 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		n_remaining = _tmp79_ - (_tmp81_ * _tmp83_);
#line 1380 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->n_used = 0;
#line 11784 "scanner.c"
		{
			gint i = 0;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			i = 0;
#line 11789 "scanner.c"
			{
				gboolean _tmp84_ = FALSE;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp84_ = TRUE;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				while (TRUE) {
#line 11796 "scanner.c"
					gint _tmp86_ = 0;
					gint _tmp87_ = 0;
					guchar* _tmp88_ = NULL;
					gint _tmp88__length1 = 0;
					gint _tmp89_ = 0;
					ScanLine* _tmp90_ = NULL;
					guchar* _tmp91_ = NULL;
					gint _tmp91__length1 = 0;
					gint _tmp92_ = 0;
					ScanLine* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					ScanLine* _tmp95_ = NULL;
					gint _tmp96_ = 0;
					guchar _tmp97_ = '\0';
					guchar _tmp98_ = '\0';
					gint _tmp99_ = 0;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!_tmp84_) {
#line 11815 "scanner.c"
						gint _tmp85_ = 0;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp85_ = i;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						i = _tmp85_ + 1;
#line 11821 "scanner.c"
					}
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp84_ = FALSE;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp86_ = i;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp87_ = n_remaining;
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					if (!(_tmp86_ < _tmp87_)) {
#line 1381 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						break;
#line 11833 "scanner.c"
					}
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp88_ = self->priv->buffer;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp88__length1 = self->priv->buffer_length1;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp89_ = i;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp90_ = line;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp91_ = _tmp90_->data;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp91__length1 = _tmp90_->data_length1;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp92_ = i;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp93_ = line;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp94_ = _tmp93_->n_lines;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp95_ = line;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp96_ = _tmp95_->data_length;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp97_ = _tmp91_[_tmp92_ + (_tmp94_ * _tmp96_)];
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp88_[_tmp89_] = _tmp97_;
#line 1383 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp98_ = _tmp88_[_tmp89_];
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp99_ = self->priv->n_used;
#line 1384 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					self->priv->n_used = _tmp99_ + 1;
#line 11867 "scanner.c"
				}
			}
		}
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp103_ = self->priv->parameters;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp104_ = _tmp103_.depth;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp104_ == 8) {
#line 11877 "scanner.c"
			SANE_Parameters _tmp105_ = {0};
			SANE_Frame _tmp106_ = 0;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp105_ = self->priv->parameters;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp106_ = _tmp105_.format;
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp102_ = _tmp106_ == SANE_FRAME_GRAY;
#line 11886 "scanner.c"
		} else {
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp102_ = FALSE;
#line 11890 "scanner.c"
		}
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp102_) {
#line 11894 "scanner.c"
			ScanJob* _tmp107_ = NULL;
			gint _tmp108_ = 0;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp107_ = job;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp108_ = _tmp107_->depth;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = _tmp108_ == 2;
#line 11903 "scanner.c"
		} else {
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp101_ = FALSE;
#line 11907 "scanner.c"
		}
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp101_) {
#line 11911 "scanner.c"
			ScanJob* _tmp109_ = NULL;
			ScanMode _tmp110_ = 0;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp109_ = job;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp110_ = _tmp109_->scan_mode;
#line 1390 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp100_ = _tmp110_ == SCAN_MODE_GRAY;
#line 11920 "scanner.c"
		} else {
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp100_ = FALSE;
#line 11924 "scanner.c"
		}
#line 1389 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (_tmp100_) {
#line 11928 "scanner.c"
			guchar block = '\0';
			gint write_offset = 0;
			gint block_shift = 0;
			ScanLine* _tmp150_ = NULL;
			ScanLine* _tmp151_ = NULL;
			gint _tmp152_ = 0;
#line 1392 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			block = (guchar) 0;
#line 1393 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			write_offset = 0;
#line 1394 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			block_shift = 6;
#line 11941 "scanner.c"
			{
				gint i = 0;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				i = 0;
#line 11946 "scanner.c"
				{
					gboolean _tmp111_ = FALSE;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					_tmp111_ = TRUE;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					while (TRUE) {
#line 11953 "scanner.c"
						gint _tmp113_ = 0;
						ScanLine* _tmp114_ = NULL;
						gint _tmp115_ = 0;
						gint offset = 0;
						gint _tmp116_ = 0;
						ScanLine* _tmp117_ = NULL;
						gint _tmp118_ = 0;
						gint _tmp143_ = 0;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!_tmp111_) {
#line 11964 "scanner.c"
							gint _tmp112_ = 0;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp112_ = i;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							i = _tmp112_ + 1;
#line 11970 "scanner.c"
						}
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp111_ = FALSE;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp113_ = i;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp114_ = line;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp115_ = _tmp114_->n_lines;
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (!(_tmp113_ < _tmp115_)) {
#line 1395 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							break;
#line 11984 "scanner.c"
						}
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp116_ = i;
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp117_ = line;
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp118_ = _tmp117_->data_length;
#line 1397 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						offset = _tmp116_ * _tmp118_;
#line 11994 "scanner.c"
						{
							gint x = 0;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							x = 0;
#line 11999 "scanner.c"
							{
								gboolean _tmp119_ = FALSE;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
								_tmp119_ = TRUE;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
								while (TRUE) {
#line 12006 "scanner.c"
									gint _tmp121_ = 0;
									ScanLine* _tmp122_ = NULL;
									gint _tmp123_ = 0;
									guchar p = '\0';
									ScanLine* _tmp124_ = NULL;
									guchar* _tmp125_ = NULL;
									gint _tmp125__length1 = 0;
									gint _tmp126_ = 0;
									gint _tmp127_ = 0;
									guchar _tmp128_ = '\0';
									guchar sample = '\0';
									guchar _tmp129_ = '\0';
									guchar _tmp132_ = '\0';
									guchar _tmp133_ = '\0';
									gint _tmp134_ = 0;
									gint _tmp135_ = 0;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (!_tmp119_) {
#line 12025 "scanner.c"
										gint _tmp120_ = 0;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp120_ = x;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										x = _tmp120_ + 1;
#line 12031 "scanner.c"
									}
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp119_ = FALSE;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp121_ = x;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp122_ = line;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp123_ = _tmp122_->width;
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (!(_tmp121_ < _tmp123_)) {
#line 1398 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										break;
#line 12045 "scanner.c"
									}
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp124_ = line;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp125_ = _tmp124_->data;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp125__length1 = _tmp124_->data_length1;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp126_ = offset;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp127_ = x;
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp128_ = _tmp125_[_tmp126_ + _tmp127_];
#line 1400 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									p = _tmp128_;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp129_ = p;
#line 1403 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (((gint) _tmp129_) >= 192) {
#line 1404 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										sample = (guchar) 3;
#line 12067 "scanner.c"
									} else {
										guchar _tmp130_ = '\0';
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp130_ = p;
#line 1405 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										if (((gint) _tmp130_) >= 128) {
#line 1406 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											sample = (guchar) 2;
#line 12076 "scanner.c"
										} else {
											guchar _tmp131_ = '\0';
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											_tmp131_ = p;
#line 1407 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
											if (((gint) _tmp131_) >= 64) {
#line 1408 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
												sample = (guchar) 1;
#line 12085 "scanner.c"
											} else {
#line 1410 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
												sample = (guchar) 0;
#line 12089 "scanner.c"
											}
										}
									}
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp132_ = block;
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp133_ = sample;
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp134_ = block_shift;
#line 1412 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									block = _tmp132_ | (_tmp133_ << _tmp134_);
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									_tmp135_ = block_shift;
#line 1413 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
									if (_tmp135_ == 0) {
#line 12105 "scanner.c"
										ScanLine* _tmp136_ = NULL;
										guchar* _tmp137_ = NULL;
										gint _tmp137__length1 = 0;
										gint _tmp138_ = 0;
										guchar _tmp139_ = '\0';
										guchar _tmp140_ = '\0';
										gint _tmp141_ = 0;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp136_ = line;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp137_ = _tmp136_->data;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp137__length1 = _tmp136_->data_length1;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp138_ = write_offset;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp139_ = block;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp137_[_tmp138_] = _tmp139_;
#line 1415 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp140_ = _tmp137_[_tmp138_];
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp141_ = write_offset;
#line 1416 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										write_offset = _tmp141_ + 1;
#line 1417 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block = (guchar) 0;
#line 1418 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block_shift = 6;
#line 12135 "scanner.c"
									} else {
										gint _tmp142_ = 0;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										_tmp142_ = block_shift;
#line 1421 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
										block_shift = _tmp142_ - 2;
#line 12142 "scanner.c"
									}
								}
							}
						}
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						_tmp143_ = block_shift;
#line 1425 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
						if (_tmp143_ != 6) {
#line 12151 "scanner.c"
							ScanLine* _tmp144_ = NULL;
							guchar* _tmp145_ = NULL;
							gint _tmp145__length1 = 0;
							gint _tmp146_ = 0;
							guchar _tmp147_ = '\0';
							guchar _tmp148_ = '\0';
							gint _tmp149_ = 0;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp144_ = line;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp145_ = _tmp144_->data;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp145__length1 = _tmp144_->data_length1;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp146_ = write_offset;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp147_ = block;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp145_[_tmp146_] = _tmp147_;
#line 1427 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp148_ = _tmp145_[_tmp146_];
#line 1428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							_tmp149_ = write_offset;
#line 1428 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							write_offset = _tmp149_ + 1;
#line 1429 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							block = (guchar) 0;
#line 1430 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
							block_shift = 6;
#line 12181 "scanner.c"
						}
					}
				}
			}
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp150_ = line;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp151_ = line;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp152_ = _tmp151_->width;
#line 1434 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp150_->data_length = ((_tmp152_ * 2) + 7) / 8;
#line 12194 "scanner.c"
		}
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp153_ = job;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp154_ = _tmp153_->id;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp155_ = line;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp156_ = notify_got_line_new (_tmp154_, _tmp155_);
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp157_ = _tmp156_;
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_notify (self, (Notify*) _tmp157_);
#line 1437 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_notify_unref0 (_tmp157_);
#line 1343 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_scan_line_unref0 (line);
#line 12212 "scanner.c"
	}
#line 1304 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (job);
#line 12216 "scanner.c"
}


static void _scanner_authorization_cb_sane_authcallback (const gchar* resource, gchar* username, gchar* password) {
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_authorization_cb (resource, username, -1, password, -1);
#line 12223 "scanner.c"
}


static void* scanner_scan_thread (Scanner* self) {
	void* result = NULL;
	SANE_Int version_code = {0};
	SANE_Status status = 0;
	SANE_Int _tmp0_ = {0};
	SANE_Status _tmp1_ = 0;
	SANE_Status _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SANE_Status _tmp5_ = 0;
	SANE_Int _tmp8_ = {0};
	gint _tmp9_ = 0;
	SANE_Int _tmp10_ = {0};
	gint _tmp11_ = 0;
	SANE_Int _tmp12_ = {0};
	gint _tmp13_ = 0;
#line 1441 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1443 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->state = SCAN_STATE_IDLE;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = sane_init (&_tmp0_, _scanner_authorization_cb_sane_authcallback);
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	version_code = _tmp0_;
#line 1446 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	status = _tmp1_;
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = status;
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = sane_status_to_string (_tmp2_);
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_;
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1447: sane_init () -> %s", _tmp4_);
#line 1447 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp4_);
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = status;
#line 1448 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp5_ != SANE_STATUS_GOOD) {
#line 12267 "scanner.c"
		SANE_Status _tmp6_ = 0;
		const gchar* _tmp7_ = NULL;
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp6_ = status;
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp7_ = sane_strstatus (_tmp6_);
#line 1450 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_warning ("scanner.vala:1450: Unable to initialize SANE backend: %s", _tmp7_);
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		result = NULL;
#line 1451 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return result;
#line 12280 "scanner.c"
	}
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = version_code;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = SANE_VERSION_MAJOR (_tmp8_);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = version_code;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = SANE_VERSION_MINOR (_tmp10_);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = version_code;
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = SANE_VERSION_BUILD (_tmp12_);
#line 1453 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1453: SANE version %d.%d.%d", _tmp9_, _tmp11_, _tmp13_);
#line 1459 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_redetect (self);
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	while (TRUE) {
#line 12300 "scanner.c"
		gboolean _tmp14_ = FALSE;
		ScanState _tmp15_ = 0;
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp14_ = scanner_handle_requests (self);
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (!_tmp14_) {
#line 1461 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 12309 "scanner.c"
		}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp15_ = self->priv->state;
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		switch (_tmp15_) {
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_IDLE:
#line 12317 "scanner.c"
			{
				GList* _tmp16_ = NULL;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				_tmp16_ = self->priv->job_queue;
#line 1466 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				if (_tmp16_ != NULL) {
#line 1468 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					scanner_set_scanning (self, TRUE);
#line 1469 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
					self->priv->state = SCAN_STATE_OPEN;
#line 12328 "scanner.c"
				}
#line 1471 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12332 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_REDETECT:
#line 12336 "scanner.c"
			{
#line 1473 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_redetect (self);
#line 1474 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12342 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_OPEN:
#line 12346 "scanner.c"
			{
#line 1476 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_open (self);
#line 1477 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12352 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_GET_OPTION:
#line 12356 "scanner.c"
			{
#line 1479 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_get_option (self);
#line 1480 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12362 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_START:
#line 12366 "scanner.c"
			{
#line 1482 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_start (self);
#line 1483 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12372 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_GET_PARAMETERS:
#line 12376 "scanner.c"
			{
#line 1485 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_get_parameters (self);
#line 1486 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12382 "scanner.c"
			}
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			case SCAN_STATE_READ:
#line 12386 "scanner.c"
			{
#line 1488 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				scanner_do_read (self);
#line 1489 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
				break;
#line 12392 "scanner.c"
			}
			default:
#line 1463 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			break;
#line 12397 "scanner.c"
		}
	}
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = NULL;
#line 1493 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12404 "scanner.c"
}


static gpointer _scanner_scan_thread_gthread_func (gpointer self) {
	gpointer result;
	result = scanner_scan_thread ((Scanner*) self);
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_unref (self);
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12415 "scanner.c"
}


void scanner_start (Scanner* self) {
	GError * _inner_error_ = NULL;
#line 1496 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 12423 "scanner.c"
	{
		GThread* _tmp0_ = NULL;
		GThread* _tmp1_ = NULL;
		GThread* _tmp2_ = NULL;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp1_ = g_thread_try_new ("scan-thread", _scanner_scan_thread_gthread_func, scanner_ref (self), &_inner_error_);
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp1_;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 12434 "scanner.c"
			goto __catch16_g_error;
		}
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = _tmp0_;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = NULL;
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1500 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->thread = _tmp2_;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (_tmp0_);
#line 12447 "scanner.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		e = _inner_error_;
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_inner_error_ = NULL;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = e;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _tmp3_->message;
#line 1504 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_critical ("scanner.vala:1504: Unable to create thread: %s", _tmp4_);
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_error_free0 (e);
#line 12467 "scanner.c"
	}
	__finally16:
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_clear_error (&_inner_error_);
#line 1498 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 12478 "scanner.c"
	}
}


void scanner_redetect (Scanner* self) {
	gboolean _tmp0_ = FALSE;
	GAsyncQueue* _tmp1_ = NULL;
	RequestRedetect* _tmp2_ = NULL;
#line 1508 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->need_redetect;
#line 1510 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp0_) {
#line 1511 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return;
#line 12495 "scanner.c"
	}
#line 1512 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->need_redetect = TRUE;
#line 1514 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1514: Requesting redetection of scan devices");
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = request_redetect_new ();
#line 1516 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12507 "scanner.c"
}


gboolean scanner_is_scanning (Scanner* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 1519 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1521 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->scanning;
#line 1521 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	result = _tmp0_;
#line 1521 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return result;
#line 12522 "scanner.c"
}


static gchar* scanner_get_scan_mode_string (Scanner* self, ScanMode mode) {
	gchar* result = NULL;
	ScanMode _tmp0_ = 0;
#line 1524 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = mode;
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp0_) {
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_DEFAULT:
#line 12537 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanMode.DEFAULT");
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp1_;
#line 1529 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12546 "scanner.c"
		}
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_COLOR:
#line 12550 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanMode.COLOR");
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp2_;
#line 1531 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12559 "scanner.c"
		}
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_GRAY:
#line 12563 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanMode.GRAY");
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp3_;
#line 1533 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12572 "scanner.c"
		}
#line 1526 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_MODE_LINEART:
#line 12576 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanMode.LINEART");
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp4_;
#line 1535 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12585 "scanner.c"
		}
		default:
		{
			ScanMode _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp5_ = mode;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_;
#line 1537 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12599 "scanner.c"
		}
	}
}


static gchar* scanner_get_scan_type_string (Scanner* self, ScanType type) {
	gchar* result = NULL;
	ScanType _tmp0_ = 0;
#line 1541 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = type;
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	switch (_tmp0_) {
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_SINGLE:
#line 12616 "scanner.c"
		{
			gchar* _tmp1_ = NULL;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp1_ = g_strdup ("ScanType.SINGLE");
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp1_;
#line 1546 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12625 "scanner.c"
		}
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_FRONT:
#line 12629 "scanner.c"
		{
			gchar* _tmp2_ = NULL;
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp2_ = g_strdup ("ScanType.ADF_FRONT");
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp2_;
#line 1548 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12638 "scanner.c"
		}
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_BACK:
#line 12642 "scanner.c"
		{
			gchar* _tmp3_ = NULL;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp3_ = g_strdup ("ScanType.ADF_BACK");
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp3_;
#line 1550 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12651 "scanner.c"
		}
#line 1543 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		case SCAN_TYPE_ADF_BOTH:
#line 12655 "scanner.c"
		{
			gchar* _tmp4_ = NULL;
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp4_ = g_strdup ("ScanType.ADF_BOTH");
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp4_;
#line 1552 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12664 "scanner.c"
		}
		default:
		{
			ScanType _tmp5_ = 0;
			gchar* _tmp6_ = NULL;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp5_ = type;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			_tmp6_ = g_strdup_printf ("%d", (gint) _tmp5_);
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			result = _tmp6_;
#line 1554 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return result;
#line 12678 "scanner.c"
		}
	}
}


void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ScanOptions* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	ScanOptions* _tmp5_ = NULL;
	ScanMode _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	ScanOptions* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	ScanOptions* _tmp11_ = NULL;
	ScanType _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	ScanOptions* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	ScanOptions* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	ScanOptions* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	ScanOptions* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	RequestStartScan* request = NULL;
	RequestStartScan* _tmp23_ = NULL;
	ScanJob* _tmp24_ = NULL;
	ScanJob* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	ScanJob* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	ScanJob* _tmp30_ = NULL;
	ScanOptions* _tmp31_ = NULL;
	gint _tmp32_ = 0;
	ScanJob* _tmp33_ = NULL;
	ScanOptions* _tmp34_ = NULL;
	ScanMode _tmp35_ = 0;
	ScanJob* _tmp36_ = NULL;
	ScanOptions* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	ScanJob* _tmp39_ = NULL;
	ScanOptions* _tmp40_ = NULL;
	ScanType _tmp41_ = 0;
	ScanJob* _tmp42_ = NULL;
	ScanOptions* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	ScanJob* _tmp45_ = NULL;
	ScanOptions* _tmp46_ = NULL;
	gint _tmp47_ = 0;
	ScanJob* _tmp48_ = NULL;
	ScanOptions* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	ScanJob* _tmp51_ = NULL;
	ScanOptions* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	GAsyncQueue* _tmp54_ = NULL;
	Request* _tmp55_ = NULL;
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (options != NULL);
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = device;
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp1_ != NULL) {
#line 12749 "scanner.c"
		const gchar* _tmp2_ = NULL;
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp2_ = device;
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = _tmp2_;
#line 12755 "scanner.c"
	} else {
#line 1561 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp0_ = "(null)";
#line 12759 "scanner.c"
	}
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp3_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp4_ = _tmp3_->dpi;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp5_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp6_ = _tmp5_->scan_mode;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp7_ = scanner_get_scan_mode_string (self, _tmp6_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp8_ = _tmp7_;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp9_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp10_ = _tmp9_->depth;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp11_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp12_ = _tmp11_->type;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp13_ = scanner_get_scan_type_string (self, _tmp12_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp14_ = _tmp13_;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp15_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp16_ = _tmp15_->paper_width;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp17_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp18_ = _tmp17_->paper_height;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp19_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp20_ = _tmp19_->brightness;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp21_ = options;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp22_ = _tmp21_->contrast;
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1560: Scanner.scan (\"%s\", dpi=%d, scan_mode=%s, depth=%" \
"d, type=%s, paper_width=%d, paper_height=%d, brightness=%d, contrast=%" \
"d)", _tmp0_, _tmp4_, _tmp8_, _tmp10_, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp14_);
#line 1560 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp8_);
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp23_ = request_start_scan_new ();
#line 1564 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request = _tmp23_;
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp24_ = scan_job_new ();
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_scan_job_unref0 (request->job);
#line 1565 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	request->job = _tmp24_;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_ = request->job;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp26_ = self->job_id;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->job_id = _tmp26_ + 1;
#line 1566 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp25_->id = _tmp26_;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_ = request->job;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp28_ = device;
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp29_ = g_strdup (_tmp28_);
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (_tmp27_->device);
#line 1567 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp27_->device = _tmp29_;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_ = request->job;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp31_ = options;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp32_ = _tmp31_->dpi;
#line 1568 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp30_->dpi = (gdouble) _tmp32_;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_ = request->job;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp34_ = options;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp35_ = _tmp34_->scan_mode;
#line 1569 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp33_->scan_mode = _tmp35_;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_ = request->job;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp37_ = options;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp38_ = _tmp37_->depth;
#line 1570 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp36_->depth = _tmp38_;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_ = request->job;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp40_ = options;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp41_ = _tmp40_->type;
#line 1571 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp39_->type = _tmp41_;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_ = request->job;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp43_ = options;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp44_ = _tmp43_->paper_width;
#line 1572 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp42_->page_width = _tmp44_;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_ = request->job;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp46_ = options;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp47_ = _tmp46_->paper_height;
#line 1573 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp45_->page_height = _tmp47_;
#line 1574 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_ = request->job;
#line 1574 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp49_ = options;
#line 1574 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp50_ = _tmp49_->brightness;
#line 1574 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp48_->brightness = _tmp50_;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_ = request->job;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp52_ = options;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp53_ = _tmp52_->contrast;
#line 1575 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp51_->contrast = _tmp53_;
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp54_ = self->priv->request_queue;
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp55_ = _request_ref0 ((Request*) request);
#line 1576 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp54_, _tmp55_);
#line 1558 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_request_unref0 (request);
#line 12907 "scanner.c"
}


void scanner_cancel (Scanner* self) {
	gint _tmp0_ = 0;
	GAsyncQueue* _tmp1_ = NULL;
	RequestCancel* _tmp2_ = NULL;
#line 1579 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->job_id;
#line 1581 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->first_job_id = _tmp0_;
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = self->priv->request_queue;
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = request_cancel_new ();
#line 1582 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp1_, (Request*) _tmp2_);
#line 12927 "scanner.c"
}


static gpointer _g_thread_ref0 (gpointer self) {
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return self ? g_thread_ref (self) : NULL;
#line 12934 "scanner.c"
}


void scanner_free (Scanner* self) {
	GAsyncQueue* _tmp0_ = NULL;
	RequestQuit* _tmp1_ = NULL;
	GThread* _tmp2_ = NULL;
#line 1585 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (self != NULL);
#line 1587 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1587: Stopping scan thread");
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp0_ = self->priv->request_queue;
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp1_ = request_quit_new ();
#line 1589 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_async_queue_push (_tmp0_, (Request*) _tmp1_);
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_tmp2_ = self->priv->thread;
#line 1591 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (_tmp2_ != NULL) {
#line 12956 "scanner.c"
		GThread* _tmp3_ = NULL;
		GThread* _tmp4_ = NULL;
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp3_ = self->priv->thread;
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_tmp4_ = _g_thread_ref0 (_tmp3_);
#line 1593 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_thread_join (_tmp4_);
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		_g_thread_unref0 (self->priv->thread);
#line 1594 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		self->priv->thread = NULL;
#line 12969 "scanner.c"
	}
#line 1597 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	sane_exit ();
#line 1598 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_debug ("scanner.vala:1598: sane_exit ()");
#line 12975 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_PAGE_INFO) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_PAGE_INFO callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 12994 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 13000 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_PAGE_INFO) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, value_get_scan_page_info (param_values + 1), data2);
#line 13006 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__SCAN_LINE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__SCAN_LINE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__SCAN_LINE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 2);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13025 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 13031 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__SCAN_LINE) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, value_get_scan_line (param_values + 1), data2);
#line 13037 "scanner.c"
}


static void g_cclosure_user_marshal_VOID__INT_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (n_param_values == 3);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = closure->data;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = param_values->data[0].v_pointer;
#line 13056 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data1 = param_values->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		data2 = closure->data;
#line 13062 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback = (GMarshalFunc_VOID__INT_STRING) (marshal_data ? marshal_data : cc->callback);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_string (param_values + 2), data2);
#line 13068 "scanner.c"
}


static void value_scanner_init (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	value->data[0].v_pointer = NULL;
#line 13075 "scanner.c"
}


static void value_scanner_free_value (GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (value->data[0].v_pointer);
#line 13084 "scanner.c"
	}
}


static void value_scanner_copy_value (const GValue* src_value, GValue* dest_value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (src_value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = scanner_ref (src_value->data[0].v_pointer);
#line 13094 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		dest_value->data[0].v_pointer = NULL;
#line 13098 "scanner.c"
	}
}


static gpointer value_scanner_peek_pointer (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13106 "scanner.c"
}


static gchar* value_scanner_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (collect_values[0].v_pointer) {
#line 13113 "scanner.c"
		Scanner* object;
		object = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		if (object->parent_instance.g_class == NULL) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13120 "scanner.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 13124 "scanner.c"
		}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = scanner_ref (object);
#line 13128 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13132 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 13136 "scanner.c"
}


static gchar* value_scanner_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Scanner** object_p;
	object_p = collect_values[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!object_p) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 13147 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (!value->data[0].v_pointer) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = NULL;
#line 13153 "scanner.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = value->data[0].v_pointer;
#line 13157 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		*object_p = scanner_ref (value->data[0].v_pointer);
#line 13161 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return NULL;
#line 13165 "scanner.c"
}


GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecScanner* spec;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return G_PARAM_SPEC (spec);
#line 13179 "scanner.c"
}


gpointer value_get_scanner (const GValue* value) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER), NULL);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return value->data[0].v_pointer;
#line 13188 "scanner.c"
}


void value_set_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_ref (value->data[0].v_pointer);
#line 13208 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13212 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (old);
#line 13218 "scanner.c"
	}
}


void value_take_scanner (GValue* value, gpointer v_object) {
	Scanner* old;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	old = value->data[0].v_pointer;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (v_object) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SCANNER));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = v_object;
#line 13237 "scanner.c"
	} else {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		value->data[0].v_pointer = NULL;
#line 13241 "scanner.c"
	}
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (old) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		scanner_unref (old);
#line 13247 "scanner.c"
	}
}


static void scanner_class_init (ScannerClass * klass) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	scanner_parent_class = g_type_class_peek_parent (klass);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	((ScannerClass *) klass)->finalize = scanner_finalize;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_type_class_add_private (klass, sizeof (ScannerPrivate));
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("update_devices", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__POINTER, G_TYPE_NONE, 1, G_TYPE_POINTER);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("request_authorization", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("expect_page", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("got_page_info", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_PAGE_INFO, G_TYPE_NONE, 1, TYPE_SCAN_PAGE_INFO);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("got_line", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__SCAN_LINE, G_TYPE_NONE, 1, TYPE_SCAN_LINE);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("scan_failed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_STRING, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_STRING);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("page_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("document_done", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_new ("scanning_changed", TYPE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 13277 "scanner.c"
}


static void scanner_instance_init (Scanner * self) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv = SCANNER_GET_PRIVATE (self);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->ref_count = 1;
#line 13286 "scanner.c"
}


static void scanner_finalize (Scanner* obj) {
	Scanner * self;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCANNER, Scanner);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_signal_handlers_destroy (self);
#line 214 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_thread_unref0 (self->priv->thread);
#line 217 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->request_queue);
#line 220 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->notify_queue);
#line 223 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_async_queue_unref0 (self->priv->authorize_queue);
#line 229 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->default_device);
#line 234 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	__g_list_free__scan_job_unref0_0 (self->priv->job_queue);
#line 239 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_free0 (self->priv->current_device);
#line 247 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	_g_hash_table_unref0 (self->priv->options);
#line 250 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	self->priv->buffer = (g_free (self->priv->buffer), NULL);
#line 13314 "scanner.c"
}


GType scanner_get_type (void) {
	static volatile gsize scanner_type_id__volatile = 0;
	if (g_once_init_enter (&scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_scanner_init, value_scanner_free_value, value_scanner_copy_value, value_scanner_peek_pointer, "p", value_scanner_collect_value, "p", value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scanner), 0, (GInstanceInitFunc) scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType scanner_type_id;
		scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Scanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&scanner_type_id__volatile, scanner_type_id);
	}
	return scanner_type_id__volatile;
}


gpointer scanner_ref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	g_atomic_int_inc (&self->ref_count);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	return instance;
#line 13339 "scanner.c"
}


void scanner_unref (gpointer instance) {
	Scanner* self;
	self = instance;
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		SCANNER_GET_CLASS (self)->finalize (self);
#line 208 "/home/bob/bzr/simple-scan/trunk/src/scanner.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 13352 "scanner.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



