package org.stegosuite.image.format;

import java.io.File;
import java.util.Arrays;
import java.util.stream.IntStream;

import org.stegosuite.model.exception.SteganoImageException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class GIFImageTest {

	private GIFImage image = null;

	/**
	 * Using @BeforeMethod here so that we work with a fresh copy of the image for each test
	 * 
	 * @throws SteganoImageException
	 */
	@BeforeMethod
	public void beforeMethod()
			throws SteganoImageException {
		image = new GIFImage();
		image.load(new File(this.getClass().getClassLoader().getResource("sunflower.gif").getFile()));
	}

	@Test
	public void testWidth() {
		Assert.assertEquals(image.getWidth(), 1160);
	}

	@Test
	public void testHeight() {
		Assert.assertEquals(image.getHeight(), 1376);
	}

	@Test(dependsOnMethods = { "testWidth", "testHeight" })
	public void testGetPixels() {
		Integer[] pixels = IntStream.of(image.getPixels()).boxed().toArray(Integer[]::new);
		Assert.assertEquals(pixels.length, image.getWidth() * image.getHeight());
		Assert.assertEquals(Arrays.deepHashCode(pixels), -2099205017);
	}

	@Test(dependsOnMethods = { "testGetPixels" })
	public void testSetPixels() {
		int[] pixels = new int[image.getWidth() * image.getHeight()];
		Arrays.setAll(pixels, i -> 0);
		image.setPixels(pixels);
		Assert.assertEquals(image.getPixels(), pixels);
	}

}
