/* ====================================================================
 * Copyright (c) 2006-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_LOGGRAPHDIALOG_H
#define _SC_LOGGRAPHDIALOG_H

// sc
#include "util/String.h"
#include "svn/LogEntryTypes.h"
class LogGraphCanvasView;
class LogGraphBatonImpl;
class LogGraphViewModel;
class DiffViewModel;
class ActionStorage;

// qt
#include <QtGui/QWidget>
class QWheelEvent;
class QPushButton;
class QLabel;

// sys
#include <vector>

/**
 * Dialog class for displaying log messages information graphical.
 */
class LogGraphDialog : public QWidget
{
  typedef QWidget super;
  Q_OBJECT 

public:
  LogGraphDialog( LogGraphViewModel* model, QWidget *parent = 0 );
  virtual ~LogGraphDialog();

  void wheelEvent( QWheelEvent* e );

  void run();

public slots:
    void diff();
    void diffable(bool);
    void graph();

signals:
  void showDiff( DiffViewModel* );

private:
  LogGraphViewModel*  _model;
  LogGraphCanvasView* _view;

  QLabel*             _zoom;
  QPushButton*        _diff;
  QPushButton*        _done;
};

#endif // _SC_LOGGRAPHDIALOG_H
