#!/usr/bin/php
<?

/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

//
// This script generate src/swac_db.inc
// To use it ./conf.php > ../src/swac_db.inc
//

define('RET', "\n");
define('TAB', '	');
define('SL', " \\");


$swac_fields = array(
	"SWAC_LANG" => "varchar(3)",
	"SWAC_TEXT" => "varchar(255)",
	"SWAC_SPEAKER_NAME" => "varchar(64)",
	"SWAC_ALPHAIDX" => "varchar(128)",
	"SWAC_BASEFORM" => "varchar(64)",
	"SWAC_FORM_NAME" => "varchar(64)",
	"SWAC_FORM_REF" => "varchar(64)",
	"SWAC_HOMOGRAPHIDX" => "varchar(64)",
	"SWAC_HOMOGRAPHIDX_REF" => "varchar(64)",
	"SWAC_SPEAK_NAME" => "varchar(64)",
	"SWAC_SPEAK_GENDER" => "varchar(64)",
	"SWAC_SPEAK_BIRTH_YEAR" => "varchar(64)",
	"SWAC_SPEAK_LANG" => "varchar(3)",
	"SWAC_SPEAK_LANG_COUNTRY" => "varchar(2)",
	"SWAC_SPEAK_LANG_REGION" => "varchar(64)",
	"SWAC_SPEAK_PRON" => "varchar(64)",
	"SWAC_SPEAK_LIV_COUNTRY" => "varchar(2)",
	"SWAC_SPEAK_LIV_TOWN" => "varchar(64)",
	"SWAC_SPEAK_CONTACT" => "varchar(64)",
	"SWAC_SPEAK_DESC" => "varchar(255)",
	"SWAC_PRON_SPEED" => "varchar(1)",
	"SWAC_PRON_COMMENT" => "varchar(64)",
	"SWAC_PRON_API" => "varchar(64)",
	"SWAC_PRON_PHON" => "varchar(64)",
	"SWAC_PRON_INTONATION" => "varchar(32)",
	"SWAC_COLL_NAME" => "varchar(128)",
	"SWAC_COLL_SECTION" => "varchar(64)",
	"SWAC_COLL_DESC" => "varchar(64)",
	"SWAC_COLL_ORG" => "varchar(64)",
	"SWAC_COLL_ORG_URL" => "varchar(128)",
	"SWAC_COLL_LICENSE" => "varchar(64)",
	"SWAC_COLL_COPYRIGHT" => "varchar(128)",
	"SWAC_COLL_AUTHORS" => "varchar(64)",
	"SWAC_COLL_URL" => "varchar(128)",
	"SWAC_TECH_QLT" => "varchar(1)",
	"SWAC_TECH_DATE" => "varchar(10)",
	"SWAC_TECH_SOFT" => "varchar(32)"
);




function make_check_field($fields) {
	$cond = array();	
	foreach ($fields as $name => $type)	
		$cond[] = 'strcmp(str, "'.strtolower($name).'") == 0 '; 

	$str = 'bool Tswac_db::check_field(const char *str) {'.RET;
	$str .= TAB.'return ('.RET;
	$str .= TAB.TAB.implode("||".RET.TAB.TAB, $cond).RET;
	$str .= TAB.");".RET;
	$str .= "}".RET.RET;
	
	return $str;
}


function make_init_sounds($fields) {
	$str = 'bool Tswac_db::db_init_sounds() {'.RET;
	$str .= TAB.'db.query('.RET;
	$str .= TAB.'"CREATE TABLE sounds ('.SL.RET;
	$str .= TAB.TAB."`idx` INTEGER PRIMARY KEY AUTOINCREMENT,".SL.RET;
	$str .= TAB.TAB."`filename` varchar(128) NOT NULL default '',".SL.RET;
	$str .= TAB.TAB."`packages_idx` INTEGER NOT NULL default 0";
	foreach ($fields as $name => $type)	
		$str .= ",".SL.RET.TAB.TAB."`".$name."` ".$type." NOT NULL default ''";

	$str .= SL.RET;
	$str .= TAB.');");'.RET;
	$str .= "}".RET.RET;
	
	return $str;
}


echo "//Script generated by php/conf.php. Don't change it!".RET.RET;
echo make_check_field($swac_fields);
echo make_init_sounds($swac_fields);

