// SPDX-License-Identifier: GPL-2.0 OR BSD-3-Clause
/* Copyright(c) 2019-2020  Realtek Corporation
 */

#include "rtw8852a_rfk_table.h"

static const struct rtw89_reg5_def rtw8852a_tssi_sys_defs[] = {
	RTW89_DECL_RFK_WM(0x12a8, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x12a8, 0x0000000e, 0x00000002),
	RTW89_DECL_RFK_WM(0x32a8, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x32a8, 0x0000000e, 0x00000002),
	RTW89_DECL_RFK_WM(0x12bc, 0x000000f0, 0x00000005),
	RTW89_DECL_RFK_WM(0x12bc, 0x00000f00, 0x00000005),
	RTW89_DECL_RFK_WM(0x12bc, 0x000f0000, 0x00000005),
	RTW89_DECL_RFK_WM(0x12bc, 0x0000f000, 0x00000005),
	RTW89_DECL_RFK_WM(0x120c, 0x000000ff, 0x00000033),
	RTW89_DECL_RFK_WM(0x12c0, 0x0ff00000, 0x00000033),
	RTW89_DECL_RFK_WM(0x32bc, 0x000000f0, 0x00000005),
	RTW89_DECL_RFK_WM(0x32bc, 0x00000f00, 0x00000005),
	RTW89_DECL_RFK_WM(0x32bc, 0x000f0000, 0x00000005),
	RTW89_DECL_RFK_WM(0x32bc, 0x0000f000, 0x00000005),
	RTW89_DECL_RFK_WM(0x320c, 0x000000ff, 0x00000033),
	RTW89_DECL_RFK_WM(0x32c0, 0x0ff00000, 0x00000033),
	RTW89_DECL_RFK_WM(0x0300, 0xff000000, 0x00000019),
	RTW89_DECL_RFK_WM(0x0304, 0x000000ff, 0x00000019),
	RTW89_DECL_RFK_WM(0x0304, 0x0000ff00, 0x0000001d),
	RTW89_DECL_RFK_WM(0x0314, 0xffff0000, 0x00002044),
	RTW89_DECL_RFK_WM(0x0318, 0x0000ffff, 0x00002042),
	RTW89_DECL_RFK_WM(0x0318, 0xffff0000, 0x00002002),
	RTW89_DECL_RFK_WM(0x0020, 0x00006000, 0x00000003),
	RTW89_DECL_RFK_WM(0x0024, 0x00006000, 0x00000003),
	RTW89_DECL_RFK_WM(0x0704, 0xffff0000, 0x0000601e),
	RTW89_DECL_RFK_WM(0x2704, 0xffff0000, 0x0000601e),
	RTW89_DECL_RFK_WM(0x0700, 0xf0000000, 0x00000004),
	RTW89_DECL_RFK_WM(0x2700, 0xf0000000, 0x00000004),
	RTW89_DECL_RFK_WM(0x0650, 0x3c000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2650, 0x3c000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_sys_defs);

static const struct rtw89_reg5_def rtw8852a_tssi_sys_defs_2g[] = {
	RTW89_DECL_RFK_WM(0x120c, 0x000000ff, 0x00000033),
	RTW89_DECL_RFK_WM(0x12c0, 0x0ff00000, 0x00000033),
	RTW89_DECL_RFK_WM(0x32c0, 0x0ff00000, 0x00000033),
	RTW89_DECL_RFK_WM(0x320c, 0x000000ff, 0x00000033),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_sys_defs_2g);

static const struct rtw89_reg5_def rtw8852a_tssi_sys_defs_5g[] = {
	RTW89_DECL_RFK_WM(0x120c, 0x000000ff, 0x00000044),
	RTW89_DECL_RFK_WM(0x12c0, 0x0ff00000, 0x00000044),
	RTW89_DECL_RFK_WM(0x32c0, 0x0ff00000, 0x00000044),
	RTW89_DECL_RFK_WM(0x320c, 0x000000ff, 0x00000044),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_sys_defs_5g);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5800, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x5800, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x5800, 0x003f0000, 0x0000003f),
	RTW89_DECL_RFK_WM(0x5800, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5800, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5800, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5804, 0xf8000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x580c, 0x0000007f, 0x00000040),
	RTW89_DECL_RFK_WM(0x580c, 0x00007f00, 0x00000040),
	RTW89_DECL_RFK_WM(0x580c, 0x00008000, 0x00000000),
	RTW89_DECL_RFK_WM(0x580c, 0x0fff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x0000fc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x00010000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5810, 0x00fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5810, 0x06000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5810, 0x38000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x5810, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5810, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00000c00, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5814, 0x00002000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5814, 0x00038000, 0x00000005),
	RTW89_DECL_RFK_WM(0x5814, 0x003c0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x01c00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x18000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0xe0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x000000ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x0001ff00, 0x00000018),
	RTW89_DECL_RFK_WM(0x5818, 0x03fe0000, 0x00000016),
	RTW89_DECL_RFK_WM(0x5818, 0xfc000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x581c, 0x000003ff, 0x00000280),
	RTW89_DECL_RFK_WM(0x581c, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x581c, 0x00100000, 0x00000000),
	RTW89_DECL_RFK_WM(0x581c, 0x01e00000, 0x00000008),
	RTW89_DECL_RFK_WM(0x581c, 0x01e00000, 0x0000000e),
	RTW89_DECL_RFK_WM(0x581c, 0x1e000000, 0x00000008),
	RTW89_DECL_RFK_WM(0x581c, 0x1e000000, 0x0000000e),
	RTW89_DECL_RFK_WM(0x581c, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5820, 0x00000fff, 0x00000080),
	RTW89_DECL_RFK_WM(0x5820, 0x0000f000, 0x0000000f),
	RTW89_DECL_RFK_WM(0x5820, 0x001f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5820, 0xffe00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5824, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5824, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5828, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x582c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x582c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5830, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5834, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5834, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5838, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x583c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x583c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5840, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5844, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5844, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5848, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x584c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x584c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5850, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5854, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5854, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5858, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x585c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x585c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5828, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5828, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5830, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5830, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5838, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5838, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5840, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5840, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5848, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5848, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5850, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5850, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5858, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5858, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0x000003ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x5864, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x5864, 0x03f00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0x04000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5898, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x589c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a0, 0x000000ff, 0x000000fd),
	RTW89_DECL_RFK_WM(0x58a0, 0x0000ff00, 0x000000e5),
	RTW89_DECL_RFK_WM(0x58a0, 0x00ff0000, 0x000000cd),
	RTW89_DECL_RFK_WM(0x58a0, 0xff000000, 0x000000b5),
	RTW89_DECL_RFK_WM(0x58a4, 0x000000ff, 0x00000016),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x0000001f, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x00000020, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x000001c0, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x0000f000, 0x00000002),
	RTW89_DECL_RFK_WM(0x58b4, 0x00ff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x7f000000, 0x0000000a),
	RTW89_DECL_RFK_WM(0x58b8, 0x0000007f, 0x00000028),
	RTW89_DECL_RFK_WM(0x58b8, 0x00007f00, 0x00000076),
	RTW89_DECL_RFK_WM(0x58b8, 0x007f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b8, 0x7f000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58bc, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x58bc, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x58bc, 0x00030000, 0x00000003),
	RTW89_DECL_RFK_WM(0x58bc, 0x000c0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58bc, 0x00300000, 0x00000002),
	RTW89_DECL_RFK_WM(0x58bc, 0x00c00000, 0x00000002),
	RTW89_DECL_RFK_WM(0x58bc, 0x07000000, 0x00000007),
	RTW89_DECL_RFK_WM(0x58c0, 0x00fe0000, 0x0000003f),
	RTW89_DECL_RFK_WM(0x58c0, 0xff000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c4, 0x0003ffff, 0x0003ffff),
	RTW89_DECL_RFK_WM(0x58c4, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c4, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c8, 0x00ffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c8, 0xf0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58cc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58d0, 0x00001fff, 0x00000101),
	RTW89_DECL_RFK_WM(0x58d0, 0x0001e000, 0x00000004),
	RTW89_DECL_RFK_WM(0x58d0, 0x03fe0000, 0x00000100),
	RTW89_DECL_RFK_WM(0x58d0, 0x04000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58d4, 0x000000ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58d4, 0x0003fe00, 0x000000ff),
	RTW89_DECL_RFK_WM(0x58d4, 0x07fc0000, 0x00000100),
	RTW89_DECL_RFK_WM(0x58d8, 0x000001ff, 0x0000016c),
	RTW89_DECL_RFK_WM(0x58d8, 0x0003fe00, 0x0000005c),
	RTW89_DECL_RFK_WM(0x58d8, 0x000c0000, 0x00000002),
	RTW89_DECL_RFK_WM(0x58d8, 0xfff00000, 0x00000800),
	RTW89_DECL_RFK_WM(0x58dc, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x58dc, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x58dc, 0x00010000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58dc, 0x3ff00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58dc, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58f0, 0x000001ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x58f0, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7800, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x7800, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x7800, 0x003f0000, 0x0000003f),
	RTW89_DECL_RFK_WM(0x7800, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7800, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7800, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7804, 0xf8000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x780c, 0x0000007f, 0x00000040),
	RTW89_DECL_RFK_WM(0x780c, 0x00007f00, 0x00000040),
	RTW89_DECL_RFK_WM(0x780c, 0x00008000, 0x00000000),
	RTW89_DECL_RFK_WM(0x780c, 0x0fff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x0000fc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x00010000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7810, 0x00fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7810, 0x06000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7810, 0x38000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x7810, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7810, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00000c00, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7814, 0x00002000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7814, 0x00038000, 0x00000005),
	RTW89_DECL_RFK_WM(0x7814, 0x003c0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x01c00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x18000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0xe0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x000000ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x0001ff00, 0x00000018),
	RTW89_DECL_RFK_WM(0x7818, 0x03fe0000, 0x00000016),
	RTW89_DECL_RFK_WM(0x7818, 0xfc000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x781c, 0x000003ff, 0x00000280),
	RTW89_DECL_RFK_WM(0x781c, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x781c, 0x00100000, 0x00000000),
	RTW89_DECL_RFK_WM(0x781c, 0x01e00000, 0x00000008),
	RTW89_DECL_RFK_WM(0x781c, 0x01e00000, 0x0000000e),
	RTW89_DECL_RFK_WM(0x781c, 0x1e000000, 0x00000008),
	RTW89_DECL_RFK_WM(0x781c, 0x1e000000, 0x0000000e),
	RTW89_DECL_RFK_WM(0x781c, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7820, 0x00000fff, 0x00000080),
	RTW89_DECL_RFK_WM(0x7820, 0x0000f000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7820, 0x001f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7820, 0xffe00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7824, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7824, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7828, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x782c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x782c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7830, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7834, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7834, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7838, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x783c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x783c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7840, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7844, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7844, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7848, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x784c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x784c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7850, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7854, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7854, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7858, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x785c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x785c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7828, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7828, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7830, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7830, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7838, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7838, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7840, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7840, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7848, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7848, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7850, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7850, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7858, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7858, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x7fc00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0x000003ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x7864, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x7864, 0x03f00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0x04000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7898, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x789c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a0, 0x000000ff, 0x000000fd),
	RTW89_DECL_RFK_WM(0x78a0, 0x0000ff00, 0x000000e5),
	RTW89_DECL_RFK_WM(0x78a0, 0x00ff0000, 0x000000cd),
	RTW89_DECL_RFK_WM(0x78a0, 0xff000000, 0x000000b5),
	RTW89_DECL_RFK_WM(0x78a4, 0x000000ff, 0x00000016),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x0000001f, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x00000020, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x000001c0, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x0000f000, 0x00000002),
	RTW89_DECL_RFK_WM(0x78b4, 0x00ff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x7f000000, 0x0000000a),
	RTW89_DECL_RFK_WM(0x78b8, 0x0000007f, 0x00000028),
	RTW89_DECL_RFK_WM(0x78b8, 0x00007f00, 0x00000076),
	RTW89_DECL_RFK_WM(0x78b8, 0x007f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b8, 0x7f000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78bc, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x78bc, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x78bc, 0x00030000, 0x00000003),
	RTW89_DECL_RFK_WM(0x78bc, 0x000c0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78bc, 0x00300000, 0x00000002),
	RTW89_DECL_RFK_WM(0x78bc, 0x00c00000, 0x00000002),
	RTW89_DECL_RFK_WM(0x78bc, 0x07000000, 0x00000007),
	RTW89_DECL_RFK_WM(0x78c0, 0x00fe0000, 0x0000003f),
	RTW89_DECL_RFK_WM(0x78c0, 0xff000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c4, 0x0003ffff, 0x0003ffff),
	RTW89_DECL_RFK_WM(0x78c4, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c4, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c8, 0x00ffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c8, 0xf0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78cc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78d0, 0x00001fff, 0x00000101),
	RTW89_DECL_RFK_WM(0x78d0, 0x0001e000, 0x00000004),
	RTW89_DECL_RFK_WM(0x78d0, 0x03fe0000, 0x00000100),
	RTW89_DECL_RFK_WM(0x78d0, 0x04000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78d4, 0x000000ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78d4, 0x0003fe00, 0x000000ff),
	RTW89_DECL_RFK_WM(0x78d4, 0x07fc0000, 0x00000100),
	RTW89_DECL_RFK_WM(0x78d8, 0x000001ff, 0x0000016c),
	RTW89_DECL_RFK_WM(0x78d8, 0x0003fe00, 0x0000005c),
	RTW89_DECL_RFK_WM(0x78d8, 0x000c0000, 0x00000002),
	RTW89_DECL_RFK_WM(0x78d8, 0xfff00000, 0x00000800),
	RTW89_DECL_RFK_WM(0x78dc, 0x000000ff, 0x0000007f),
	RTW89_DECL_RFK_WM(0x78dc, 0x0000ff00, 0x00000080),
	RTW89_DECL_RFK_WM(0x78dc, 0x00010000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78dc, 0x3ff00000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78dc, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78f0, 0x000001ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x78f0, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_defs_2g[] = {
	RTW89_DECL_RFK_WM(0x58d8, 0x000001ff, 0x0000013c),
	RTW89_DECL_RFK_WM(0x78d8, 0x000001ff, 0x0000013c),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_defs_2g);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_defs_5g[] = {
	RTW89_DECL_RFK_WM(0x58d8, 0x000001ff, 0x0000016c),
	RTW89_DECL_RFK_WM(0x78d8, 0x000001ff, 0x0000016c),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_defs_5g);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_he_tb_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58a0, 0xffffffff, 0x000000fc),
	RTW89_DECL_RFK_WM(0x58e4, 0x0000007f, 0x00000020),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_he_tb_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_txpwr_ctrl_bb_he_tb_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78a0, 0xffffffff, 0x000000fc),
	RTW89_DECL_RFK_WM(0x78e4, 0x0000007f, 0x00000020),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txpwr_ctrl_bb_he_tb_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_dck_defs_a[] = {
	RTW89_DECL_RFK_WM(0x580c, 0x0fff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5814, 0x00002000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5814, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5814, 0x00038000, 0x00000005),
	RTW89_DECL_RFK_WM(0x5814, 0x003c0000, 0x00000003),
	RTW89_DECL_RFK_WM(0x5814, 0x18000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_dck_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_dck_defs_b[] = {
	RTW89_DECL_RFK_WM(0x780c, 0x0fff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7814, 0x00002000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7814, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7814, 0x00038000, 0x00000005),
	RTW89_DECL_RFK_WM(0x7814, 0x003c0000, 0x00000003),
	RTW89_DECL_RFK_WM(0x7814, 0x18000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_dck_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_dac_gain_tbl_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58b0, 0x00000fff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b0, 0x00000800, 0x00000001),
	RTW89_DECL_RFK_WM(0x5a00, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a04, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a08, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a0c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a10, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a14, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a18, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a1c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a20, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a24, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a28, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a2c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a30, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a34, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a38, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a3c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a40, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a44, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a48, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a4c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a50, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a54, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a58, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a5c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a60, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a64, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a68, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a6c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a70, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a74, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a78, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a7c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a80, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a84, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a88, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a8c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a90, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a94, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a98, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5a9c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5aa0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5aa4, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5aa8, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5aac, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5ab0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5ab4, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5ab8, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5abc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x5ac0, 0xffffffff, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_dac_gain_tbl_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_dac_gain_tbl_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78b0, 0x00000fff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b0, 0x00000800, 0x00000001),
	RTW89_DECL_RFK_WM(0x7a00, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a04, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a08, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a0c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a10, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a14, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a18, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a1c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a20, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a24, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a28, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a2c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a30, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a34, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a38, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a3c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a40, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a44, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a48, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a4c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a50, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a54, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a58, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a5c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a60, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a64, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a68, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a6c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a70, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a74, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a78, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a7c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a80, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a84, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a88, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a8c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a90, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a94, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a98, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7a9c, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7aa0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7aa4, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7aa8, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7aac, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7ab0, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7ab4, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7ab8, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7abc, 0xffffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x7ac0, 0xffffffff, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_dac_gain_tbl_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_slope_cal_org_defs_a[] = {
	RTW89_DECL_RFK_WM(0x581c, 0x00100000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58cc, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58cc, 0x00000007, 0x00000000),
	RTW89_DECL_RFK_WM(0x58cc, 0x00000038, 0x00000001),
	RTW89_DECL_RFK_WM(0x58cc, 0x000001c0, 0x00000002),
	RTW89_DECL_RFK_WM(0x58cc, 0x00000e00, 0x00000003),
	RTW89_DECL_RFK_WM(0x5828, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5898, 0x000000ff, 0x00000040),
	RTW89_DECL_RFK_WM(0x5830, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5898, 0x0000ff00, 0x00000040),
	RTW89_DECL_RFK_WM(0x5838, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5898, 0x00ff0000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5840, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5898, 0xff000000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5848, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x589c, 0x000000ff, 0x00000040),
	RTW89_DECL_RFK_WM(0x5850, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x589c, 0x0000ff00, 0x00000040),
	RTW89_DECL_RFK_WM(0x5858, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x589c, 0x00ff0000, 0x00000040),
	RTW89_DECL_RFK_WM(0x5860, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x589c, 0xff000000, 0x00000040),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_slope_cal_org_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_slope_cal_org_defs_b[] = {
	RTW89_DECL_RFK_WM(0x781c, 0x00100000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78cc, 0x00001000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78cc, 0x00000007, 0x00000000),
	RTW89_DECL_RFK_WM(0x78cc, 0x00000038, 0x00000001),
	RTW89_DECL_RFK_WM(0x78cc, 0x000001c0, 0x00000002),
	RTW89_DECL_RFK_WM(0x78cc, 0x00000e00, 0x00000003),
	RTW89_DECL_RFK_WM(0x7828, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7898, 0x000000ff, 0x00000040),
	RTW89_DECL_RFK_WM(0x7830, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7898, 0x0000ff00, 0x00000040),
	RTW89_DECL_RFK_WM(0x7838, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7898, 0x00ff0000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7840, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7898, 0xff000000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7848, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x789c, 0x000000ff, 0x00000040),
	RTW89_DECL_RFK_WM(0x7850, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x789c, 0x0000ff00, 0x00000040),
	RTW89_DECL_RFK_WM(0x7878, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x789c, 0x00ff0000, 0x00000040),
	RTW89_DECL_RFK_WM(0x7860, 0x7fc00000, 0x00000040),
	RTW89_DECL_RFK_WM(0x789c, 0xff000000, 0x00000040),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_slope_cal_org_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_rf_gap_tbl_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_rf_gap_tbl_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_rf_gap_tbl_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_rf_gap_tbl_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_slope_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00000800, 0x00000001),
	RTW89_DECL_RFK_WM(0x581c, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5820, 0x0000f000, 0x00000001),
	RTW89_DECL_RFK_WM(0x581c, 0x000003ff, 0x00000280),
	RTW89_DECL_RFK_WM(0x581c, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x58b8, 0x007f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b8, 0x7f000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58b4, 0x7f000000, 0x0000000a),
	RTW89_DECL_RFK_WM(0x58b8, 0x0000007f, 0x00000028),
	RTW89_DECL_RFK_WM(0x58b8, 0x00007f00, 0x00000076),
	RTW89_DECL_RFK_WM(0x5810, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x580c, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x580c, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5838, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5858, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5834, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5834, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5838, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5854, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5854, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5858, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5824, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5824, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5828, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x582c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x582c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5830, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x583c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x583c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5840, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5844, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x5844, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5848, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x584c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x584c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5850, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x585c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x585c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x5828, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5830, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5840, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5848, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5850, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5860, 0x003ff000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_slope_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_slope_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00000800, 0x00000001),
	RTW89_DECL_RFK_WM(0x781c, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7820, 0x0000f000, 0x00000001),
	RTW89_DECL_RFK_WM(0x781c, 0x000003ff, 0x00000280),
	RTW89_DECL_RFK_WM(0x781c, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x78b8, 0x007f0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b8, 0x7f000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78b4, 0x7f000000, 0x0000000a),
	RTW89_DECL_RFK_WM(0x78b8, 0x0000007f, 0x00000028),
	RTW89_DECL_RFK_WM(0x78b8, 0x00007f00, 0x00000076),
	RTW89_DECL_RFK_WM(0x7810, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x780c, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x780c, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7838, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7858, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7834, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7834, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7838, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7854, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7854, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7858, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7824, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7824, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7828, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x782c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x782c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7830, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x783c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x783c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7840, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7844, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x7844, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7848, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x784c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x784c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7850, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x785c, 0x0003ffff, 0x000115f2),
	RTW89_DECL_RFK_WM(0x785c, 0x3ffc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x00000fff, 0x00000121),
	RTW89_DECL_RFK_WM(0x7828, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7830, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7840, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7848, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7850, 0x003ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7860, 0x003ff000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_slope_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_track_defs_a[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x18000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5814, 0x00000800, 0x00000000),
	RTW89_DECL_RFK_WM(0x581c, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5864, 0x000003ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x5864, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x5820, 0x00000fff, 0x00000080),
	RTW89_DECL_RFK_WM(0x5814, 0x01000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_track_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_track_defs_b[] = {
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x18000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7814, 0x00000800, 0x00000000),
	RTW89_DECL_RFK_WM(0x781c, 0x20000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7864, 0x000003ff, 0x000001ff),
	RTW89_DECL_RFK_WM(0x7864, 0x000ffc00, 0x00000200),
	RTW89_DECL_RFK_WM(0x7820, 0x00000fff, 0x00000080),
	RTW89_DECL_RFK_WM(0x7814, 0x01000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_track_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_txagc_ofst_mv_avg_defs_a[] = {
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58e4, 0x00004000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58e4, 0x00008000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58e4, 0x000f0000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txagc_ofst_mv_avg_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_txagc_ofst_mv_avg_defs_b[] = {
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78e4, 0x00004000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78e4, 0x00008000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78e4, 0x000f0000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_txagc_ofst_mv_avg_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_a_2g[] = {
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x000001d0),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x000001e8),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x0000000b),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x00000088),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_a_2g);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_a_5g_1[] = {
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x000001d7),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x000001fb),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000005),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x0000007c),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_a_5g_1);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_a_5g_3[] = {
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x000001d8),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x000001fc),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000006),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x00000078),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_a_5g_3);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_a_5g_4[] = {
	RTW89_DECL_RFK_WM(0x5814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a4, 0x03fe0000, 0x000001e5),
	RTW89_DECL_RFK_WM(0x58a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58a8, 0x0003fe00, 0x0000000a),
	RTW89_DECL_RFK_WM(0x58a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x58ac, 0x0003fe00, 0x00000011),
	RTW89_DECL_RFK_WM(0x58ac, 0x07fc0000, 0x00000075),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_a_5g_4);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_b_2g[] = {
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x000001cc),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x000001e2),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000005),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000089),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_b_2g);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_b_5g_1[] = {
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x000001d5),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x000001fc),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x00000005),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000079),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_b_5g_1);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_b_5g_3[] = {
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x000001dc),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x00000002),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x0000000b),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000076),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_b_5g_3);

static const struct rtw89_reg5_def rtw8852a_tssi_pak_defs_b_5g_4[] = {
	RTW89_DECL_RFK_WM(0x7814, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f4, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000003ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f8, 0x000ffc00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x0001ff00, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a4, 0x03fe0000, 0x000001f0),
	RTW89_DECL_RFK_WM(0x78a8, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78a8, 0x0003fe00, 0x00000016),
	RTW89_DECL_RFK_WM(0x78a8, 0x07fc0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x000001ff, 0x00000000),
	RTW89_DECL_RFK_WM(0x78ac, 0x0003fe00, 0x0000001f),
	RTW89_DECL_RFK_WM(0x78ac, 0x07fc0000, 0x00000072),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_pak_defs_b_5g_4);

static const struct rtw89_reg5_def rtw8852a_tssi_enable_defs_a[] = {
	RTW89_DECL_RFK_WRF(0x0, 0x55, 0x00080, 0x00001),
	RTW89_DECL_RFK_WM(0x5818, 0x000000ff, 0x000000c0),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5818, 0x18000000, 0x00000003),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_enable_defs_a);

static const struct rtw89_reg5_def rtw8852a_tssi_enable_defs_b[] = {
	RTW89_DECL_RFK_WRF(0x1, 0x55, 0x00080, 0x00001),
	RTW89_DECL_RFK_WM(0x7818, 0x000000ff, 0x000000c0),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7818, 0x18000000, 0x00000003),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_enable_defs_b);

static const struct rtw89_reg5_def rtw8852a_tssi_disable_defs[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5818, 0x18000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7818, 0x18000000, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_disable_defs);

static const struct rtw89_reg5_def rtw8852a_tssi_enable_defs_ab[] = {
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x5820, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x5818, 0x18000000, 0x3),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x0),
	RTW89_DECL_RFK_WM(0x7820, 0x80000000, 0x1),
	RTW89_DECL_RFK_WM(0x7818, 0x18000000, 0x3),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_enable_defs_ab);

static const struct rtw89_reg5_def rtw8852a_tssi_tracking_defs[] = {
	RTW89_DECL_RFK_WM(0x5800, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f0, 0x00080000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5804, 0xf8000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58f0, 0xfff00000, 0x00000400),
	RTW89_DECL_RFK_WM(0x7800, 0x10000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f0, 0x00080000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7804, 0xf8000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f0, 0xfff00000, 0x00000400),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_tssi_tracking_defs);

static const struct rtw89_reg5_def rtw8852a_rfk_afe_init_defs[] = {
	RTW89_DECL_RFK_WC(0x12ec, 0x00008000),
	RTW89_DECL_RFK_WS(0x12ec, 0x00008000),
	RTW89_DECL_RFK_WC(0x5e00, 0x00000001),
	RTW89_DECL_RFK_WS(0x5e00, 0x00000001),
	RTW89_DECL_RFK_WC(0x32ec, 0x00008000),
	RTW89_DECL_RFK_WS(0x32ec, 0x00008000),
	RTW89_DECL_RFK_WC(0x7e00, 0x00000001),
	RTW89_DECL_RFK_WS(0x7e00, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_afe_init_defs);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_reload_defs_a[] = {
	RTW89_DECL_RFK_WS(0x5e00, 0x00000008),
	RTW89_DECL_RFK_WS(0x5e50, 0x00000008),
	RTW89_DECL_RFK_WS(0x5e10, 0x80000000),
	RTW89_DECL_RFK_WS(0x5e60, 0x80000000),
	RTW89_DECL_RFK_WC(0x5e00, 0x00000008),
	RTW89_DECL_RFK_WC(0x5e50, 0x00000008),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_reload_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_reload_defs_b[] = {
	RTW89_DECL_RFK_WS(0x7e00, 0x00000008),
	RTW89_DECL_RFK_WS(0x7e50, 0x00000008),
	RTW89_DECL_RFK_WS(0x7e10, 0x80000000),
	RTW89_DECL_RFK_WS(0x7e60, 0x80000000),
	RTW89_DECL_RFK_WC(0x7e00, 0x00000008),
	RTW89_DECL_RFK_WC(0x7e50, 0x00000008),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_reload_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_check_addc_defs_a[] = {
	RTW89_DECL_RFK_WC(0x20f4, 0x01000000),
	RTW89_DECL_RFK_WS(0x20f8, 0x80000000),
	RTW89_DECL_RFK_WM(0x20f0, 0x00ff0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x20f0, 0x00000f00, 0x00000002),
	RTW89_DECL_RFK_WC(0x20f0, 0x0000000f),
	RTW89_DECL_RFK_WM(0x20f0, 0x000000c0, 0x00000002),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_addc_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_check_addc_defs_b[] = {
	RTW89_DECL_RFK_WC(0x20f4, 0x01000000),
	RTW89_DECL_RFK_WS(0x20f8, 0x80000000),
	RTW89_DECL_RFK_WM(0x20f0, 0x00ff0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x20f0, 0x00000f00, 0x00000002),
	RTW89_DECL_RFK_WC(0x20f0, 0x0000000f),
	RTW89_DECL_RFK_WM(0x20f0, 0x000000c0, 0x00000003),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_addc_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_reset_defs_a[] = {
	RTW89_DECL_RFK_WC(0x12d8, 0x00000030),
	RTW89_DECL_RFK_WC(0x32d8, 0x00000030),
	RTW89_DECL_RFK_WS(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x032c, 0x40000000),
	RTW89_DECL_RFK_WC(0x032c, 0x00400000),
	RTW89_DECL_RFK_WS(0x032c, 0x00400000),
	RTW89_DECL_RFK_WS(0x030c, 0x0f000000),
	RTW89_DECL_RFK_WC(0x032c, 0x00010000),
	RTW89_DECL_RFK_WS(0x12dc, 0x00000002),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x00000003),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_reset_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_trigger_defs_a[] = {
	RTW89_DECL_RFK_WS(0x12d8, 0x000000c0),
	RTW89_DECL_RFK_WS(0x12d8, 0x00000800),
	RTW89_DECL_RFK_WC(0x12d8, 0x00000800),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x12d8, 0x00000300, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_trigger_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_restore_defs_a[] = {
	RTW89_DECL_RFK_WC(0x12dc, 0x00000002),
	RTW89_DECL_RFK_WS(0x032c, 0x00010000),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x0000000c),
	RTW89_DECL_RFK_WS(0x032c, 0x40000000),
	RTW89_DECL_RFK_WC(0x12b8, 0x40000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_restore_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_reset_defs_b[] = {
	RTW89_DECL_RFK_WS(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x032c, 0x40000000),
	RTW89_DECL_RFK_WC(0x032c, 0x00400000),
	RTW89_DECL_RFK_WS(0x032c, 0x00400000),
	RTW89_DECL_RFK_WS(0x030c, 0x0f000000),
	RTW89_DECL_RFK_WC(0x032c, 0x00010000),
	RTW89_DECL_RFK_WS(0x32dc, 0x00000002),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x00000003),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_reset_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_trigger_defs_b[] = {
	RTW89_DECL_RFK_WS(0x32d8, 0x000000c0),
	RTW89_DECL_RFK_WS(0x32d8, 0x00000800),
	RTW89_DECL_RFK_WC(0x32d8, 0x00000800),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x32d8, 0x00000300, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_trigger_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_addck_restore_defs_b[] = {
	RTW89_DECL_RFK_WC(0x32dc, 0x00000002),
	RTW89_DECL_RFK_WS(0x032c, 0x00010000),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x0000000c),
	RTW89_DECL_RFK_WS(0x032c, 0x40000000),
	RTW89_DECL_RFK_WC(0x32b8, 0x40000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_addck_restore_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_check_dadc_defs_f_a[] = {
	RTW89_DECL_RFK_WC(0x032c, 0x40000000),
	RTW89_DECL_RFK_WS(0x030c, 0x0f000000),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x00000003),
	RTW89_DECL_RFK_WC(0x032c, 0x00010000),
	RTW89_DECL_RFK_WS(0x12dc, 0x00000001),
	RTW89_DECL_RFK_WS(0x12e8, 0x00000004),
	RTW89_DECL_RFK_WRF(0x0, 0x8f, 0x02000, 0x00001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_dadc_defs_f_a);

static const struct rtw89_reg5_def rtw8852a_rfk_check_dadc_defs_f_b[] = {
	RTW89_DECL_RFK_WC(0x032c, 0x40000000),
	RTW89_DECL_RFK_WS(0x030c, 0x0f000000),
	RTW89_DECL_RFK_WM(0x030c, 0x0f000000, 0x00000003),
	RTW89_DECL_RFK_WC(0x032c, 0x00010000),
	RTW89_DECL_RFK_WS(0x32dc, 0x00000001),
	RTW89_DECL_RFK_WS(0x32e8, 0x00000004),
	RTW89_DECL_RFK_WRF(0x1, 0x8f, 0x02000, 0x00001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_dadc_defs_f_b);

static const struct rtw89_reg5_def rtw8852a_rfk_check_dadc_defs_r_a[] = {
	RTW89_DECL_RFK_WC(0x12dc, 0x00000001),
	RTW89_DECL_RFK_WC(0x12e8, 0x00000004),
	RTW89_DECL_RFK_WRF(0x0, 0x8f, 0x02000, 0x00000),
	RTW89_DECL_RFK_WM(0x032c, 0x00010000, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_dadc_defs_r_a);

static const struct rtw89_reg5_def rtw8852a_rfk_check_dadc_defs_r_b[] = {
	RTW89_DECL_RFK_WC(0x32dc, 0x00000001),
	RTW89_DECL_RFK_WC(0x32e8, 0x00000004),
	RTW89_DECL_RFK_WRF(0x1, 0x8f, 0x02000, 0x00000),
	RTW89_DECL_RFK_WM(0x032c, 0x00010000, 0x00000001),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_check_dadc_defs_r_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_f_a[] = {
	RTW89_DECL_RFK_WS(0x5e00, 0x00000008),
	RTW89_DECL_RFK_WC(0x5e10, 0x80000000),
	RTW89_DECL_RFK_WS(0x5e50, 0x00000008),
	RTW89_DECL_RFK_WC(0x5e60, 0x80000000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00008000),
	RTW89_DECL_RFK_WM(0x12a0, 0x00007000, 0x00000003),
	RTW89_DECL_RFK_WS(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WS(0x030c, 0x10000000),
	RTW89_DECL_RFK_WC(0x032c, 0x80000000),
	RTW89_DECL_RFK_WS(0x12e0, 0x00010000),
	RTW89_DECL_RFK_WS(0x12e4, 0x0c000000),
	RTW89_DECL_RFK_WM(0x5e00, 0x03ff0000, 0x00000030),
	RTW89_DECL_RFK_WM(0x5e50, 0x03ff0000, 0x00000030),
	RTW89_DECL_RFK_WC(0x5e00, 0x0c000000),
	RTW89_DECL_RFK_WC(0x5e50, 0x0c000000),
	RTW89_DECL_RFK_WC(0x5e0c, 0x00000008),
	RTW89_DECL_RFK_WC(0x5e5c, 0x00000008),
	RTW89_DECL_RFK_WS(0x5e0c, 0x00000001),
	RTW89_DECL_RFK_WS(0x5e5c, 0x00000001),
	RTW89_DECL_RFK_DELAY(1),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_f_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_m_a[] = {
	RTW89_DECL_RFK_WC(0x12e4, 0x0c000000),
	RTW89_DECL_RFK_WS(0x5e0c, 0x00000008),
	RTW89_DECL_RFK_WS(0x5e5c, 0x00000008),
	RTW89_DECL_RFK_DELAY(1),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_m_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_r_a[] = {
	RTW89_DECL_RFK_WC(0x5e0c, 0x00000001),
	RTW89_DECL_RFK_WC(0x5e5c, 0x00000001),
	RTW89_DECL_RFK_WC(0x12e0, 0x00010000),
	RTW89_DECL_RFK_WC(0x12a0, 0x00008000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00007000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_r_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_f_b[] = {
	RTW89_DECL_RFK_WS(0x7e00, 0x00000008),
	RTW89_DECL_RFK_WC(0x7e10, 0x80000000),
	RTW89_DECL_RFK_WS(0x7e50, 0x00000008),
	RTW89_DECL_RFK_WC(0x7e60, 0x80000000),
	RTW89_DECL_RFK_WS(0x32a0, 0x00008000),
	RTW89_DECL_RFK_WM(0x32a0, 0x00007000, 0x00000003),
	RTW89_DECL_RFK_WS(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WS(0x030c, 0x10000000),
	RTW89_DECL_RFK_WC(0x032c, 0x80000000),
	RTW89_DECL_RFK_WS(0x32e0, 0x00010000),
	RTW89_DECL_RFK_WS(0x32e4, 0x0c000000),
	RTW89_DECL_RFK_WM(0x7e00, 0x03ff0000, 0x00000030),
	RTW89_DECL_RFK_WM(0x7e50, 0x03ff0000, 0x00000030),
	RTW89_DECL_RFK_WC(0x7e00, 0x0c000000),
	RTW89_DECL_RFK_WC(0x7e50, 0x0c000000),
	RTW89_DECL_RFK_WC(0x7e0c, 0x00000008),
	RTW89_DECL_RFK_WC(0x7e5c, 0x00000008),
	RTW89_DECL_RFK_WS(0x7e0c, 0x00000001),
	RTW89_DECL_RFK_WS(0x7e5c, 0x00000001),
	RTW89_DECL_RFK_DELAY(1),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_f_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_m_b[] = {
	RTW89_DECL_RFK_WC(0x32e4, 0x0c000000),
	RTW89_DECL_RFK_WM(0x7e0c, 0x00000008, 0x00000001),
	RTW89_DECL_RFK_WM(0x7e5c, 0x00000008, 0x00000001),
	RTW89_DECL_RFK_DELAY(1),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_m_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dack_defs_r_b[] = {
	RTW89_DECL_RFK_WC(0x7e0c, 0x00000001),
	RTW89_DECL_RFK_WC(0x7e5c, 0x00000001),
	RTW89_DECL_RFK_WC(0x32e0, 0x00010000),
	RTW89_DECL_RFK_WC(0x32a0, 0x00008000),
	RTW89_DECL_RFK_WS(0x32a0, 0x00007000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dack_defs_r_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_sf_defs_a[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000101),
	RTW89_DECL_RFK_WS(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000041),
	RTW89_DECL_RFK_WS(0x12b8, 0x10000000),
	RTW89_DECL_RFK_WS(0x58c8, 0x01000000),
	RTW89_DECL_RFK_WS(0x5864, 0xc0000000),
	RTW89_DECL_RFK_WS(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WS(0x0c1c, 0x00000004),
	RTW89_DECL_RFK_WS(0x0700, 0x08000000),
	RTW89_DECL_RFK_WS(0x0c70, 0x000003ff),
	RTW89_DECL_RFK_WS(0x0c60, 0x00000003),
	RTW89_DECL_RFK_WS(0x0c6c, 0x00000001),
	RTW89_DECL_RFK_WS(0x58ac, 0x08000000),
	RTW89_DECL_RFK_WS(0x0c3c, 0x00000200),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_sf_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_sr_defs_a[] = {
	RTW89_DECL_RFK_WS(0x4490, 0x80000000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00007000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00008000),
	RTW89_DECL_RFK_WM(0x12a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WS(0x12a0, 0x00080000),
	RTW89_DECL_RFK_WS(0x0700, 0x01000000),
	RTW89_DECL_RFK_WM(0x0700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00001111),
	RTW89_DECL_RFK_WM(0x58f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_sr_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_sf_defs_b[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000202),
	RTW89_DECL_RFK_WS(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000041),
	RTW89_DECL_RFK_WS(0x32b8, 0x10000000),
	RTW89_DECL_RFK_WS(0x78c8, 0x01000000),
	RTW89_DECL_RFK_WS(0x7864, 0xc0000000),
	RTW89_DECL_RFK_WS(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WS(0x2c1c, 0x00000004),
	RTW89_DECL_RFK_WS(0x2700, 0x08000000),
	RTW89_DECL_RFK_WS(0x0c70, 0x000003ff),
	RTW89_DECL_RFK_WS(0x0c60, 0x00000003),
	RTW89_DECL_RFK_WS(0x0c6c, 0x00000001),
	RTW89_DECL_RFK_WS(0x78ac, 0x08000000),
	RTW89_DECL_RFK_WS(0x2c3c, 0x00000200),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_sf_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_sr_defs_b[] = {
	RTW89_DECL_RFK_WS(0x6490, 0x80000000),
	RTW89_DECL_RFK_WS(0x32a0, 0x00007000),
	RTW89_DECL_RFK_WS(0x32a0, 0x00008000),
	RTW89_DECL_RFK_WM(0x32a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WS(0x32a0, 0x00080000),
	RTW89_DECL_RFK_WS(0x2700, 0x01000000),
	RTW89_DECL_RFK_WM(0x2700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00002222),
	RTW89_DECL_RFK_WM(0x78f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_sr_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_s_defs_ab[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000303),
	RTW89_DECL_RFK_WS(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WS(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000041),
	RTW89_DECL_RFK_WS(0x12b8, 0x10000000),
	RTW89_DECL_RFK_WS(0x58c8, 0x01000000),
	RTW89_DECL_RFK_WS(0x78c8, 0x01000000),
	RTW89_DECL_RFK_WS(0x5864, 0xc0000000),
	RTW89_DECL_RFK_WS(0x7864, 0xc0000000),
	RTW89_DECL_RFK_WS(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WS(0x0c1c, 0x00000004),
	RTW89_DECL_RFK_WS(0x0700, 0x08000000),
	RTW89_DECL_RFK_WS(0x0c70, 0x000003ff),
	RTW89_DECL_RFK_WS(0x0c60, 0x00000003),
	RTW89_DECL_RFK_WS(0x0c6c, 0x00000001),
	RTW89_DECL_RFK_WS(0x58ac, 0x08000000),
	RTW89_DECL_RFK_WS(0x78ac, 0x08000000),
	RTW89_DECL_RFK_WS(0x0c3c, 0x00000200),
	RTW89_DECL_RFK_WS(0x2344, 0x80000000),
	RTW89_DECL_RFK_WS(0x4490, 0x80000000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00007000),
	RTW89_DECL_RFK_WS(0x12a0, 0x00008000),
	RTW89_DECL_RFK_WM(0x12a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WS(0x12a0, 0x00080000),
	RTW89_DECL_RFK_WM(0x32a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WS(0x32a0, 0x00080000),
	RTW89_DECL_RFK_WS(0x0700, 0x01000000),
	RTW89_DECL_RFK_WM(0x0700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00003333),
	RTW89_DECL_RFK_WM(0x58f0, 0x00080000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_s_defs_ab);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_r_defs_a[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000101),
	RTW89_DECL_RFK_WC(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x5864, 0xc0000000),
	RTW89_DECL_RFK_WC(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WC(0x0c1c, 0x00000004),
	RTW89_DECL_RFK_WC(0x0700, 0x08000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WC(0x12a0, 0x000ff000),
	RTW89_DECL_RFK_WC(0x0700, 0x07000000),
	RTW89_DECL_RFK_WC(0x5864, 0x20000000),
	RTW89_DECL_RFK_WC(0x0c3c, 0x00000200),
	RTW89_DECL_RFK_WC(0x20fc, 0xffff0000),
	RTW89_DECL_RFK_WC(0x58c8, 0x01000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_r_defs_a);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_r_defs_b[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000202),
	RTW89_DECL_RFK_WC(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x7864, 0xc0000000),
	RTW89_DECL_RFK_WC(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WC(0x2c1c, 0x00000004),
	RTW89_DECL_RFK_WC(0x2700, 0x08000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WC(0x32a0, 0x000ff000),
	RTW89_DECL_RFK_WC(0x2700, 0x07000000),
	RTW89_DECL_RFK_WC(0x7864, 0x20000000),
	RTW89_DECL_RFK_WC(0x2c3c, 0x00000200),
	RTW89_DECL_RFK_WC(0x20fc, 0xffff0000),
	RTW89_DECL_RFK_WC(0x78c8, 0x01000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_r_defs_b);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_bb_afe_r_defs_ab[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000303),
	RTW89_DECL_RFK_WC(0x12b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x32b8, 0x40000000),
	RTW89_DECL_RFK_WC(0x5864, 0xc0000000),
	RTW89_DECL_RFK_WC(0x7864, 0xc0000000),
	RTW89_DECL_RFK_WC(0x2008, 0x01ffffff),
	RTW89_DECL_RFK_WC(0x0c1c, 0x00000004),
	RTW89_DECL_RFK_WC(0x0700, 0x08000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WC(0x12a0, 0x000ff000),
	RTW89_DECL_RFK_WC(0x32a0, 0x000ff000),
	RTW89_DECL_RFK_WC(0x0700, 0x07000000),
	RTW89_DECL_RFK_WC(0x5864, 0x20000000),
	RTW89_DECL_RFK_WC(0x7864, 0x20000000),
	RTW89_DECL_RFK_WC(0x0c3c, 0x00000200),
	RTW89_DECL_RFK_WC(0x20fc, 0xffff0000),
	RTW89_DECL_RFK_WC(0x58c8, 0x01000000),
	RTW89_DECL_RFK_WC(0x78c8, 0x01000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_bb_afe_r_defs_ab);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_lbk_rxiqk_defs_f[] = {
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x0000000f),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x0000a001),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x0000a041),
	RTW89_DECL_RFK_WS(0x8074, 0x80000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_lbk_rxiqk_defs_f);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_lbk_rxiqk_defs_r[] = {
	RTW89_DECL_RFK_WC(0x8074, 0x80000000),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x0000001f),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000001),
	RTW89_DECL_RFK_DELAY(1),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000041),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000303),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00003333),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_lbk_rxiqk_defs_r);

static const struct rtw89_reg5_def rtw8852a_rfk_dpk_pas_read_defs[] = {
	RTW89_DECL_RFK_WM(0x80d4, 0x00ff0000, 0x00000006),
	RTW89_DECL_RFK_WC(0x80bc, 0x00004000),
	RTW89_DECL_RFK_WM(0x80c0, 0x00ff0000, 0x00000008),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_dpk_pas_read_defs);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_set_defs_nondbcc_path01[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000303),
	RTW89_DECL_RFK_WM(0x5864, 0x18000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x7864, 0x18000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x12b8, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x32b8, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12b8, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58c8, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78c8, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5864, 0xc0000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x7864, 0xc0000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x01ffffff),
	RTW89_DECL_RFK_WM(0x0c1c, 0x00000004, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003ff, 0x000003ff),
	RTW89_DECL_RFK_WM(0x0c60, 0x00000003, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c6c, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x58ac, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78ac, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0c3c, 0x00000200, 0x00000001),
	RTW89_DECL_RFK_WM(0x2344, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x4490, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12a0, 0x00007000, 0x00000007),
	RTW89_DECL_RFK_WM(0x12a0, 0x00008000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WM(0x12a0, 0x00080000, 0x00000001),
	RTW89_DECL_RFK_WM(0x32a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WM(0x32a0, 0x00080000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00003333),
	RTW89_DECL_RFK_WM(0x58f0, 0x00080000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_set_defs_nondbcc_path01);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_set_defs_dbcc_path0[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000101),
	RTW89_DECL_RFK_WM(0x5864, 0x18000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x7864, 0x18000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x12b8, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12b8, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x58c8, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x5864, 0xc0000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x01ffffff),
	RTW89_DECL_RFK_WM(0x0c1c, 0x00000004, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003ff, 0x000003ff),
	RTW89_DECL_RFK_WM(0x0c60, 0x00000003, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c6c, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x58ac, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0c3c, 0x00000200, 0x00000001),
	RTW89_DECL_RFK_WM(0x2320, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x4490, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12a0, 0x00007000, 0x00000007),
	RTW89_DECL_RFK_WM(0x12a0, 0x00008000, 0x00000001),
	RTW89_DECL_RFK_WM(0x12a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WM(0x12a0, 0x00080000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00001111),
	RTW89_DECL_RFK_WM(0x58f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_set_defs_dbcc_path0);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_set_defs_dbcc_path1[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000202),
	RTW89_DECL_RFK_WM(0x7864, 0x18000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x32b8, 0x40000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x030c, 0xff000000, 0x00000013),
	RTW89_DECL_RFK_WM(0x032c, 0xffff0000, 0x00000001),
	RTW89_DECL_RFK_WM(0x32b8, 0x10000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x78c8, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x7864, 0xc0000000, 0x00000003),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x01ffffff),
	RTW89_DECL_RFK_WM(0x2c1c, 0x00000004, 0x00000001),
	RTW89_DECL_RFK_WM(0x2700, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003ff, 0x000003ff),
	RTW89_DECL_RFK_WM(0x0c60, 0x00000003, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c6c, 0x00000001, 0x00000001),
	RTW89_DECL_RFK_WM(0x78ac, 0x08000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x2c3c, 0x00000200, 0x00000001),
	RTW89_DECL_RFK_WM(0x6490, 0x80000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x32a0, 0x00007000, 0x00000007),
	RTW89_DECL_RFK_WM(0x32a0, 0x00008000, 0x00000001),
	RTW89_DECL_RFK_WM(0x32a0, 0x00070000, 0x00000003),
	RTW89_DECL_RFK_WM(0x32a0, 0x00080000, 0x00000001),
	RTW89_DECL_RFK_WM(0x2700, 0x01000000, 0x00000001),
	RTW89_DECL_RFK_WM(0x2700, 0x06000000, 0x00000002),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00002222),
	RTW89_DECL_RFK_WM(0x78f0, 0x00080000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_set_defs_dbcc_path1);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_restore_defs_nondbcc_path01[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000303),
	RTW89_DECL_RFK_WM(0x12b8, 0x40000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x32b8, 0x40000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c1c, 0x00000004, 0x00000000),
	RTW89_DECL_RFK_WM(0x0700, 0x08000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WM(0x12a0, 0x000ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x32a0, 0x000ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0700, 0x07000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c3c, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x2320, 0x00000001, 0x00000000),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c8, 0x01000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c8, 0x01000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_restore_defs_nondbcc_path01);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_restore_defs_dbcc_path0[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000101),
	RTW89_DECL_RFK_WM(0x12b8, 0x40000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c1c, 0x00000004, 0x00000000),
	RTW89_DECL_RFK_WM(0x0700, 0x08000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WM(0x12a0, 0x000ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0700, 0x07000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x5864, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c3c, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x58c8, 0x01000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_restore_defs_dbcc_path0);

static const struct rtw89_reg5_def rtw8852a_rfk_iqk_restore_defs_dbcc_path1[] = {
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000202),
	RTW89_DECL_RFK_WM(0x32b8, 0x40000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0xc0000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2008, 0x01ffffff, 0x00000000),
	RTW89_DECL_RFK_WM(0x2c1c, 0x00000004, 0x00000000),
	RTW89_DECL_RFK_WM(0x2700, 0x08000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x0c70, 0x0000001f, 0x00000003),
	RTW89_DECL_RFK_WM(0x0c70, 0x000003e0, 0x00000003),
	RTW89_DECL_RFK_WM(0x32a0, 0x000ff000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2700, 0x07000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x7864, 0x20000000, 0x00000000),
	RTW89_DECL_RFK_WM(0x2c3c, 0x00000200, 0x00000000),
	RTW89_DECL_RFK_WM(0x20fc, 0xffff0000, 0x00000000),
	RTW89_DECL_RFK_WM(0x78c8, 0x01000000, 0x00000000),
};

RTW89_DECLARE_RFK_TBL(rtw8852a_rfk_iqk_restore_defs_dbcc_path1);
