#include "SDL_opengl.h"
#include "pill.h"


#include <iostream>

namespace models {

static GLuint pill_dl=0;

void pill::draw() {
	dldraw();
}
void pill::dldraw() {
	if (pill_dl==0) { sdraw(); return; }
	glCallList(pill_dl);
}

void pill::gen_dl() {
	pill_dl=glGenLists(1);
	glNewList(pill_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded pill " << pill_dl << std::endl;
}
namespace mtl_pill {
typedef enum MTL {
m_default,
m_last
};
} //namespace
void pill::material (int id) {
	switch (id) {
		case mtl_pill::m_default:
static const GLfloat m_default_diffuse[] = {1.00000,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_default_diffuse);
static const GLfloat m_default_ambient[] = {1.00000,1.00000,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_default_ambient);
static const GLfloat m_default_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_default_emissive);
			break;
	}
}
float pill::minx() { return -0.0509388 ; }
float pill::miny() { return -0.00339658 ; }
float pill::minz() { return -0.0509388 ; }
float pill::maxx() { return 0.0509388; }
float pill::maxy() { return 0.251723; }
float pill::maxz() { return 0.0509388; }
float pill::radius() { return 0.261828; }
void pill::sdraw() {
const float vertices[96][3]={
	{5.0938848e-2,0.25172269,1.1584351e-18},
	{4.7061359e-2,0.25172269,1.9493453e-2},
	{3.6019205e-2,0.25172269,3.6019205e-2},
	{1.9493453e-2,0.25172269,4.7061359e-2},
	{-3.3672343e-17,0.25172269,5.0938848e-2},
	{-1.9493453e-2,0.25172269,4.7061359e-2},
	{-3.6019205e-2,0.25172269,3.6019205e-2},
	{-4.7061359e-2,0.25172269,1.9493453e-2},
	{-5.0938848e-2,0.25172269,7.3964388e-18},
	{-4.7061359e-2,0.25172269,-1.9493453e-2},
	{-3.6019205e-2,0.25172269,-3.6019205e-2},
	{-1.9493453e-2,0.25172269,-4.7061359e-2},
	{-4.6148350e-17,0.25172269,-5.0938848e-2},
	{1.9493453e-2,0.25172269,-4.7061359e-2},
	{3.6019205e-2,0.25172269,-3.6019205e-2},
	{4.7061359e-2,0.25172269,-1.9493453e-2},
	{5.0938848e-2,-3.3965804e-3,1.1584351e-18},
	{4.7061359e-2,-3.3965804e-3,1.9493453e-2},
	{3.6019205e-2,-3.3965804e-3,3.6019205e-2},
	{1.9493453e-2,-3.3965804e-3,4.7061359e-2},
	{-3.3672343e-17,-3.3965804e-3,5.0938848e-2},
	{-1.9493453e-2,-3.3965804e-3,4.7061359e-2},
	{-3.6019205e-2,-3.3965804e-3,3.6019205e-2},
	{-4.7061359e-2,-3.3965804e-3,1.9493453e-2},
	{-5.0938848e-2,-3.3965804e-3,7.3964388e-18},
	{-4.7061359e-2,-3.3965804e-3,-1.9493453e-2},
	{-3.6019205e-2,-3.3965804e-3,-3.6019205e-2},
	{-1.9493453e-2,-3.3965804e-3,-4.7061359e-2},
	{-4.6148350e-17,-3.3965804e-3,-5.0938848e-2},
	{1.9493453e-2,-3.3965804e-3,-4.7061359e-2},
	{3.6019205e-2,-3.3965804e-3,-3.6019205e-2},
	{4.7061359e-2,-3.3965804e-3,-1.9493453e-2},
	{5.0938848e-2,0.14627339,1.1584351e-18},
	{5.0938848e-2,9.7154429e-2,1.1584351e-18},
	{4.7061359e-2,0.14627339,1.9493453e-2},
	{4.7061359e-2,9.7154429e-2,1.9493453e-2},
	{3.6019205e-2,0.14627339,3.6019205e-2},
	{3.6019205e-2,9.7154429e-2,3.6019205e-2},
	{1.9493453e-2,0.14627339,4.7061359e-2},
	{1.9493453e-2,9.7154429e-2,4.7061359e-2},
	{-3.3672343e-17,0.14627339,5.0938848e-2},
	{-3.3672343e-17,9.7154429e-2,5.0938848e-2},
	{-1.9493453e-2,0.14627339,4.7061359e-2},
	{-1.9493453e-2,9.7154429e-2,4.7061359e-2},
	{-3.6019205e-2,0.14627339,3.6019205e-2},
	{-3.6019205e-2,9.7154429e-2,3.6019205e-2},
	{-4.7061359e-2,0.14627339,1.9493453e-2},
	{-4.7061359e-2,9.7154429e-2,1.9493453e-2},
	{-5.0938848e-2,0.14627339,7.3964388e-18},
	{-5.0938848e-2,9.7154429e-2,7.3964388e-18},
	{-4.7061359e-2,0.14627339,-1.9493453e-2},
	{-4.7061359e-2,9.7154429e-2,-1.9493453e-2},
	{-3.6019205e-2,0.14627339,-3.6019205e-2},
	{-3.6019205e-2,9.7154429e-2,-3.6019205e-2},
	{-1.9493453e-2,0.14627339,-4.7061359e-2},
	{-1.9493453e-2,9.7154429e-2,-4.7061359e-2},
	{-4.6148350e-17,0.14627339,-5.0938848e-2},
	{-4.6148350e-17,9.7154429e-2,-5.0938848e-2},
	{1.9493453e-2,0.14627339,-4.7061359e-2},
	{1.9493453e-2,9.7154429e-2,-4.7061359e-2},
	{3.6019205e-2,0.14627339,-3.6019205e-2},
	{3.6019205e-2,9.7154429e-2,-3.6019205e-2},
	{4.7061359e-2,0.14627339,-1.9493453e-2},
	{4.7061359e-2,9.7154429e-2,-1.9493453e-2},
	{3.3619640e-2,0.14063552,4.2728729e-18},
	{3.3619640e-2,0.10279230,4.2728729e-18},
	{3.1060497e-2,0.14063552,1.2865679e-2},
	{3.1060497e-2,0.10279230,1.2865679e-2},
	{2.3772675e-2,0.14063552,2.3772675e-2},
	{2.3772675e-2,0.10279230,2.3772675e-2},
	{1.2865679e-2,0.14063552,3.1060497e-2},
	{1.2865679e-2,0.10279230,3.1060497e-2},
	{-3.4849526e-17,0.14063552,3.3619640e-2},
	{-3.4849526e-17,0.10279230,3.3619640e-2},
	{-1.2865679e-2,0.14063552,3.1060497e-2},
	{-1.2865679e-2,0.10279230,3.1060497e-2},
	{-2.3772675e-2,0.14063552,2.3772675e-2},
	{-2.3772675e-2,0.10279230,2.3772675e-2},
	{-3.1060497e-2,0.14063552,1.2865679e-2},
	{-3.1060497e-2,0.10279230,1.2865679e-2},
	{-3.3619640e-2,0.14063552,8.3899554e-18},
	{-3.3619640e-2,0.10279230,8.3899554e-18},
	{-3.1060497e-2,0.14063552,-1.2865679e-2},
	{-3.1060497e-2,0.10279230,-1.2865679e-2},
	{-2.3772675e-2,0.14063552,-2.3772675e-2},
	{-2.3772675e-2,0.10279230,-2.3772675e-2},
	{-1.2865679e-2,0.14063552,-3.1060497e-2},
	{-1.2865679e-2,0.10279230,-3.1060497e-2},
	{-4.3083691e-17,0.14063552,-3.3619640e-2},
	{-4.3083691e-17,0.10279230,-3.3619640e-2},
	{1.2865679e-2,0.14063552,-3.1060497e-2},
	{1.2865679e-2,0.10279230,-3.1060497e-2},
	{2.3772675e-2,0.14063552,-2.3772675e-2},
	{2.3772675e-2,0.10279230,-2.3772675e-2},
	{3.1060497e-2,0.14063552,-1.2865679e-2},
	{3.1060497e-2,0.10279230,-1.2865679e-2},
};
const float normals[96][3]={
	{0.89090915,0.45418155,-2.6472748e-16},
	{0.82309273,0.45418155,0.34093617},
	{0.62996790,0.45418155,0.62996790},
	{0.34093617,0.45418155,0.82309273},
	{0.0000000e+0,0.45418155,0.89090915},
	{-0.34093617,0.45418155,0.82309273},
	{-0.62996790,0.45418155,0.62996790},
	{-0.82309273,0.45418155,0.34093617},
	{-0.89090915,0.45418155,-2.5212141e-17},
	{-0.82309273,0.45418155,-0.34093617},
	{-0.62996790,0.45418155,-0.62996790},
	{-0.34093617,0.45418155,-0.82309273},
	{-1.7648498e-16,0.45418155,-0.89090915},
	{0.34093617,0.45418155,-0.82309273},
	{0.62996790,0.45418155,-0.62996790},
	{0.82309273,0.45418155,-0.34093617},
	{0.89090915,-0.45418155,-8.8242492e-17},
	{0.82309273,-0.45418155,0.34093617},
	{0.62996790,-0.45418155,0.62996790},
	{0.34093617,-0.45418155,0.82309273},
	{0.0000000e+0,-0.45418155,0.89090915},
	{-0.34093617,-0.45418155,0.82309273},
	{-0.62996790,-0.45418155,0.62996790},
	{-0.82309273,-0.45418155,0.34093617},
	{-0.89090915,-0.45418155,1.6387891e-16},
	{-0.82309273,-0.45418155,-0.34093617},
	{-0.62996790,-0.45418155,-0.62996790},
	{-0.34093617,-0.45418155,-0.82309273},
	{-1.8909105e-16,-0.45418155,-0.89090915},
	{0.34093617,-0.45418155,-0.82309273},
	{0.62996790,-0.45418155,-0.62996790},
	{0.82309273,-0.45418155,-0.34093617},
	{0.80542705,-0.59269491,-7.1498730e-17},
	{0.80542705,0.59269491,-7.5831986e-17},
	{0.74411757,-0.59269491,0.30822359},
	{0.74411757,0.59269491,0.30822359},
	{0.56952293,-0.59269491,0.56952293},
	{0.56952293,0.59269491,0.56952293},
	{0.30822359,-0.59269491,0.74411757},
	{0.30822359,0.59269491,0.74411757},
	{2.2966259e-16,-0.59269491,0.80542705},
	{0.0000000e+0,0.59269491,0.80542705},
	{-0.30822359,-0.59269491,0.74411757},
	{-0.30822359,0.59269491,0.74411757},
	{-0.56952293,-0.59269491,0.56952293},
	{-0.56952293,0.59269491,0.56952293},
	{-0.74411757,-0.59269491,0.30822359},
	{-0.74411757,0.59269491,0.30822359},
	{-0.80542705,-0.59269491,1.1483129e-16},
	{-0.80542705,0.59269491,1.1049804e-16},
	{-0.74411757,-0.59269491,-0.30822359},
	{-0.74411757,0.59269491,-0.30822359},
	{-0.56952293,-0.59269491,-0.56952293},
	{-0.56952293,0.59269491,-0.56952293},
	{-0.30822359,-0.59269491,-0.74411757},
	{-0.30822359,0.59269491,-0.74411757},
	{-1.2566443e-16,-0.59269491,-0.80542705},
	{-1.2999769e-16,0.59269491,-0.80542705},
	{0.30822359,-0.59269491,-0.74411757},
	{0.30822359,0.59269491,-0.74411757},
	{0.56952293,-0.59269491,-0.56952293},
	{0.56952293,0.59269491,-0.56952293},
	{0.74411757,-0.59269491,-0.30822359},
	{0.74411757,0.59269491,-0.30822359},
	{0.80542705,-0.59269491,-5.1999076e-17},
	{0.80542705,0.59269491,-5.8498961e-17},
	{0.74411757,-0.59269491,0.30822359},
	{0.74411757,0.59269491,0.30822359},
	{0.56952293,-0.59269491,0.56952293},
	{0.56952293,0.59269491,0.56952293},
	{0.30822359,-0.59269491,0.74411757},
	{0.30822359,0.59269491,0.74411757},
	{2.2532933e-16,-0.59269491,0.80542705},
	{4.3332564e-18,0.59269491,0.80542705},
	{-0.30822359,-0.59269491,0.74411757},
	{-0.30822359,0.59269491,0.74411757},
	{-0.56952293,-0.59269491,0.56952293},
	{-0.56952293,0.59269491,0.56952293},
	{-0.74411757,-0.59269491,0.30822359},
	{-0.74411757,0.59269491,0.30822359},
	{-0.80542705,-0.59269491,2.5999538e-16},
	{-0.80542705,0.59269491,2.5349550e-16},
	{-0.74411757,-0.59269491,-0.30822359},
	{-0.74411757,0.59269491,-0.30822359},
	{-0.56952293,-0.59269491,-0.56952293},
	{-0.56952293,0.59269491,-0.56952293},
	{-0.30822359,-0.59269491,-0.74411757},
	{-0.30822359,0.59269491,-0.74411757},
	{-1.7333025e-17,-0.59269491,-0.80542705},
	{-4.3332564e-18,0.59269491,-0.80542705},
	{0.30822359,-0.59269491,-0.74411757},
	{0.30822359,0.59269491,-0.74411757},
	{0.56952293,-0.59269491,-0.56952293},
	{0.56952293,0.59269491,-0.56952293},
	{0.74411757,-0.59269491,-0.30822359},
	{0.74411757,0.59269491,-0.30822359},
};
//o cylinder1
material(mtl_pill::m_default);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
glEnd();
}
} //namespace
