//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armazuredata

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SQLServerRegistrationsClient contains the methods for the SQLServerRegistrations group.
// Don't use this type directly, use NewSQLServerRegistrationsClient() instead.
type SQLServerRegistrationsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewSQLServerRegistrationsClient creates a new instance of SQLServerRegistrationsClient with the specified values.
// subscriptionID - Subscription ID that identifies an Azure subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewSQLServerRegistrationsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SQLServerRegistrationsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &SQLServerRegistrationsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// CreateOrUpdate - Creates or updates a SQL Server registration.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// resourceGroupName - Name of the resource group that contains the resource. You can obtain this value from the Azure Resource
// Manager API or the portal.
// sqlServerRegistrationName - Name of the SQL Server registration.
// parameters - The SQL Server registration to be created or updated.
// options - SQLServerRegistrationsClientCreateOrUpdateOptions contains the optional parameters for the SQLServerRegistrationsClient.CreateOrUpdate
// method.
func (client *SQLServerRegistrationsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, parameters SQLServerRegistration, options *SQLServerRegistrationsClientCreateOrUpdateOptions) (SQLServerRegistrationsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, sqlServerRegistrationName, parameters, options)
	if err != nil {
		return SQLServerRegistrationsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLServerRegistrationsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return SQLServerRegistrationsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SQLServerRegistrationsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, parameters SQLServerRegistration, options *SQLServerRegistrationsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sqlServerRegistrationName == "" {
		return nil, errors.New("parameter sqlServerRegistrationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlServerRegistrationName}", url.PathEscape(sqlServerRegistrationName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SQLServerRegistrationsClient) createOrUpdateHandleResponse(resp *http.Response) (SQLServerRegistrationsClientCreateOrUpdateResponse, error) {
	result := SQLServerRegistrationsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLServerRegistration); err != nil {
		return SQLServerRegistrationsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a SQL Server registration.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// resourceGroupName - Name of the resource group that contains the resource. You can obtain this value from the Azure Resource
// Manager API or the portal.
// sqlServerRegistrationName - Name of the SQL Server registration.
// options - SQLServerRegistrationsClientDeleteOptions contains the optional parameters for the SQLServerRegistrationsClient.Delete
// method.
func (client *SQLServerRegistrationsClient) Delete(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, options *SQLServerRegistrationsClientDeleteOptions) (SQLServerRegistrationsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, sqlServerRegistrationName, options)
	if err != nil {
		return SQLServerRegistrationsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLServerRegistrationsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return SQLServerRegistrationsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return SQLServerRegistrationsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SQLServerRegistrationsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, options *SQLServerRegistrationsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sqlServerRegistrationName == "" {
		return nil, errors.New("parameter sqlServerRegistrationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlServerRegistrationName}", url.PathEscape(sqlServerRegistrationName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Gets a SQL Server registration.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// resourceGroupName - Name of the resource group that contains the resource. You can obtain this value from the Azure Resource
// Manager API or the portal.
// sqlServerRegistrationName - Name of the SQL Server registration.
// options - SQLServerRegistrationsClientGetOptions contains the optional parameters for the SQLServerRegistrationsClient.Get
// method.
func (client *SQLServerRegistrationsClient) Get(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, options *SQLServerRegistrationsClientGetOptions) (SQLServerRegistrationsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, sqlServerRegistrationName, options)
	if err != nil {
		return SQLServerRegistrationsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLServerRegistrationsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLServerRegistrationsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *SQLServerRegistrationsClient) getCreateRequest(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, options *SQLServerRegistrationsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sqlServerRegistrationName == "" {
		return nil, errors.New("parameter sqlServerRegistrationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlServerRegistrationName}", url.PathEscape(sqlServerRegistrationName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SQLServerRegistrationsClient) getHandleResponse(resp *http.Response) (SQLServerRegistrationsClientGetResponse, error) {
	result := SQLServerRegistrationsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLServerRegistration); err != nil {
		return SQLServerRegistrationsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Gets all SQL Server registrations in a subscription.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// options - SQLServerRegistrationsClientListOptions contains the optional parameters for the SQLServerRegistrationsClient.List
// method.
func (client *SQLServerRegistrationsClient) NewListPager(options *SQLServerRegistrationsClientListOptions) *runtime.Pager[SQLServerRegistrationsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SQLServerRegistrationsClientListResponse]{
		More: func(page SQLServerRegistrationsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SQLServerRegistrationsClientListResponse) (SQLServerRegistrationsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SQLServerRegistrationsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SQLServerRegistrationsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SQLServerRegistrationsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *SQLServerRegistrationsClient) listCreateRequest(ctx context.Context, options *SQLServerRegistrationsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.AzureData/sqlServerRegistrations"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SQLServerRegistrationsClient) listHandleResponse(resp *http.Response) (SQLServerRegistrationsClientListResponse, error) {
	result := SQLServerRegistrationsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLServerRegistrationListResult); err != nil {
		return SQLServerRegistrationsClientListResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - Gets all SQL Server registrations in a resource group.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// resourceGroupName - Name of the resource group that contains the resource. You can obtain this value from the Azure Resource
// Manager API or the portal.
// options - SQLServerRegistrationsClientListByResourceGroupOptions contains the optional parameters for the SQLServerRegistrationsClient.ListByResourceGroup
// method.
func (client *SQLServerRegistrationsClient) NewListByResourceGroupPager(resourceGroupName string, options *SQLServerRegistrationsClientListByResourceGroupOptions) *runtime.Pager[SQLServerRegistrationsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[SQLServerRegistrationsClientListByResourceGroupResponse]{
		More: func(page SQLServerRegistrationsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SQLServerRegistrationsClientListByResourceGroupResponse) (SQLServerRegistrationsClientListByResourceGroupResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return SQLServerRegistrationsClientListByResourceGroupResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return SQLServerRegistrationsClientListByResourceGroupResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return SQLServerRegistrationsClientListByResourceGroupResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *SQLServerRegistrationsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *SQLServerRegistrationsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *SQLServerRegistrationsClient) listByResourceGroupHandleResponse(resp *http.Response) (SQLServerRegistrationsClientListByResourceGroupResponse, error) {
	result := SQLServerRegistrationsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLServerRegistrationListResult); err != nil {
		return SQLServerRegistrationsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// Update - Updates SQL Server Registration tags.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2019-07-24-preview
// resourceGroupName - Name of the resource group that contains the resource. You can obtain this value from the Azure Resource
// Manager API or the portal.
// sqlServerRegistrationName - Name of the SQL Server registration.
// parameters - The SQL Server Registration.
// options - SQLServerRegistrationsClientUpdateOptions contains the optional parameters for the SQLServerRegistrationsClient.Update
// method.
func (client *SQLServerRegistrationsClient) Update(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, parameters SQLServerRegistrationUpdate, options *SQLServerRegistrationsClientUpdateOptions) (SQLServerRegistrationsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, sqlServerRegistrationName, parameters, options)
	if err != nil {
		return SQLServerRegistrationsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return SQLServerRegistrationsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return SQLServerRegistrationsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *SQLServerRegistrationsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, sqlServerRegistrationName string, parameters SQLServerRegistrationUpdate, options *SQLServerRegistrationsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AzureData/sqlServerRegistrations/{sqlServerRegistrationName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if sqlServerRegistrationName == "" {
		return nil, errors.New("parameter sqlServerRegistrationName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{sqlServerRegistrationName}", url.PathEscape(sqlServerRegistrationName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2019-07-24-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateHandleResponse handles the Update response.
func (client *SQLServerRegistrationsClient) updateHandleResponse(resp *http.Response) (SQLServerRegistrationsClientUpdateResponse, error) {
	result := SQLServerRegistrationsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SQLServerRegistration); err != nil {
		return SQLServerRegistrationsClientUpdateResponse{}, err
	}
	return result, nil
}
