// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The definition of the Q App, specifying the cards and flow.
type AppDefinition struct {

	// The version of the app definition schema or specification.
	//
	// This member is required.
	AppDefinitionVersion *string

	// The cards that make up the Q App, such as text input, file upload, or query
	// cards.
	//
	// This member is required.
	Cards []Card

	// A flag indicating whether the Q App's definition can be edited by the user.
	CanEdit *bool

	noSmithyDocumentSerde
}

// The input for defining an Q App.
type AppDefinitionInput struct {

	// The cards that make up the Q App definition.
	//
	// This member is required.
	Cards []CardInput

	// The initial prompt displayed when the Q App is started.
	InitialPrompt *string

	noSmithyDocumentSerde
}

// The filter criteria used on responses based on document attributes or metadata
// fields.
type AttributeFilter struct {

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []AttributeFilter

	// Returns true when a document contains all the specified document attributes or
	// metadata fields. Supported for the following [document attribute value types]: stringListValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	ContainsAll *DocumentAttribute

	// Returns true when a document contains any of the specified document attributes
	// or metadata fields. Supported for the following [document attribute value types]: stringListValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	ContainsAny *DocumentAttribute

	// Performs an equals operation on two document attributes or metadata fields.
	// Supported for the following [document attribute value types]: dateValue , longValue , stringListValue and
	// stringValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	EqualsTo *DocumentAttribute

	// Performs a greater than operation on two document attributes or metadata
	// fields. Supported for the following [document attribute value types]: dateValue and longValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	GreaterThan *DocumentAttribute

	// Performs a greater than or equals operation on two document attributes or
	// metadata fields. Supported for the following [document attribute value types]: dateValue and longValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	GreaterThanOrEquals *DocumentAttribute

	// Performs a less than operation on two document attributes or metadata fields.
	// Supported for the following [document attribute value types]: dateValue and longValue .
	//
	// [document attribute value types]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	LessThan *DocumentAttribute

	// Performs a less than or equals operation on two document attributes or metadata
	// fields.Supported for the following [document attribute value type]: dateValue and longValue .
	//
	// [document attribute value type]: https://docs.aws.amazon.com/amazonq/latest/api-reference/API_DocumentAttributeValue.html
	LessThanOrEquals *DocumentAttribute

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter

	//  Performs a logical OR operation on all supplied filters.
	OrAllFilters []AttributeFilter

	noSmithyDocumentSerde
}

// A card representing a component or step in an Amazon Q App's flow.
//
// The following types satisfy this interface:
//
//	CardMemberFileUpload
//	CardMemberQPlugin
//	CardMemberQQuery
//	CardMemberTextInput
type Card interface {
	isCard()
}

// A container for the properties of the file upload card.
type CardMemberFileUpload struct {
	Value FileUploadCard

	noSmithyDocumentSerde
}

func (*CardMemberFileUpload) isCard() {}

// A container for the properties of the plugin card.
type CardMemberQPlugin struct {
	Value QPluginCard

	noSmithyDocumentSerde
}

func (*CardMemberQPlugin) isCard() {}

// A container for the properties of the query card.
type CardMemberQQuery struct {
	Value QQueryCard

	noSmithyDocumentSerde
}

func (*CardMemberQQuery) isCard() {}

// A container for the properties of the text input card.
type CardMemberTextInput struct {
	Value TextInputCard

	noSmithyDocumentSerde
}

func (*CardMemberTextInput) isCard() {}

// The properties defining an input card in an Amazon Q App.
//
// The following types satisfy this interface:
//
//	CardInputMemberFileUpload
//	CardInputMemberQPlugin
//	CardInputMemberQQuery
//	CardInputMemberTextInput
type CardInput interface {
	isCardInput()
}

// A container for the properties of the file upload input card.
type CardInputMemberFileUpload struct {
	Value FileUploadCardInput

	noSmithyDocumentSerde
}

func (*CardInputMemberFileUpload) isCardInput() {}

// A container for the properties of the plugin input card.
type CardInputMemberQPlugin struct {
	Value QPluginCardInput

	noSmithyDocumentSerde
}

func (*CardInputMemberQPlugin) isCardInput() {}

// A container for the properties of the query input card.
type CardInputMemberQQuery struct {
	Value QQueryCardInput

	noSmithyDocumentSerde
}

func (*CardInputMemberQQuery) isCardInput() {}

// A container for the properties of the text input card.
type CardInputMemberTextInput struct {
	Value TextInputCardInput

	noSmithyDocumentSerde
}

func (*CardInputMemberTextInput) isCardInput() {}

// The current status and value of a card in an active Amazon Q App session.
type CardStatus struct {

	// The current state of the card.
	//
	// This member is required.
	CurrentState ExecutionStatus

	// The current value or result associated with the card.
	//
	// This member is required.
	CurrentValue *string

	noSmithyDocumentSerde
}

// The value or result associated with a card in a Amazon Q App session.
type CardValue struct {

	// The unique identifier of the card.
	//
	// This member is required.
	CardId *string

	// The value or result associated with the card.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A category used to classify and filter library items for Amazon Q Apps.
type Category struct {

	// The unique identifier of the category.
	//
	// This member is required.
	Id *string

	// The title or name of the category.
	//
	// This member is required.
	Title *string

	noSmithyDocumentSerde
}

// A message in a conversation, used as input for generating an Amazon Q App
// definition.
type ConversationMessage struct {

	// The text content of the conversation message.
	//
	// This member is required.
	Body *string

	// The type of the conversation message.
	//
	// This member is required.
	Type Sender

	noSmithyDocumentSerde
}

// A document attribute or metadata field.
type DocumentAttribute struct {

	// The identifier for the attribute.
	//
	// This member is required.
	Name *string

	// The value of the attribute.
	//
	// This member is required.
	Value DocumentAttributeValue

	noSmithyDocumentSerde
}

// The value of a document attribute. You can only provide one value for a
// document attribute.
//
// The following types satisfy this interface:
//
//	DocumentAttributeValueMemberDateValue
//	DocumentAttributeValueMemberLongValue
//	DocumentAttributeValueMemberStringListValue
//	DocumentAttributeValueMemberStringValue
type DocumentAttributeValue interface {
	isDocumentAttributeValue()
}

// A date expressed as an ISO 8601 string.
//
// It's important for the time zone to be included in the ISO 8601 date-time
// format. For example, 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format
// for March 25th 2012 at 12:30PM (plus 10 seconds) in Central European Time.
type DocumentAttributeValueMemberDateValue struct {
	Value time.Time

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberDateValue) isDocumentAttributeValue() {}

// A long integer value.
type DocumentAttributeValueMemberLongValue struct {
	Value int64

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberLongValue) isDocumentAttributeValue() {}

// A list of strings.
type DocumentAttributeValueMemberStringListValue struct {
	Value []string

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberStringListValue) isDocumentAttributeValue() {}

// A string.
type DocumentAttributeValueMemberStringValue struct {
	Value string

	noSmithyDocumentSerde
}

func (*DocumentAttributeValueMemberStringValue) isDocumentAttributeValue() {}

// A card in an Amazon Q App that allows the user to upload a file.
type FileUploadCard struct {

	// Any dependencies or requirements for the file upload card.
	//
	// This member is required.
	Dependencies []string

	// The unique identifier of the file upload card.
	//
	// This member is required.
	Id *string

	// The title of the file upload card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// A flag indicating if the user can override the default file for the upload card.
	AllowOverride *bool

	// The unique identifier of the file associated with the card.
	FileId *string

	// The name of the file being uploaded.
	Filename *string

	noSmithyDocumentSerde
}

// Represents a file upload card. It can optionally receive a filename and fileId
// to set a default file. If not received, the user must provide the file when the
// Q App runs.
type FileUploadCardInput struct {

	// The unique identifier of the file upload card.
	//
	// This member is required.
	Id *string

	// The title or label of the file upload card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// A flag indicating if the user can override the default file for the upload card.
	AllowOverride *bool

	// The identifier of a pre-uploaded file associated with the card.
	FileId *string

	// The default filename to use for the file upload card.
	Filename *string

	noSmithyDocumentSerde
}

// A library item is a snapshot of an Amazon Q App that can be published so the
// users in their Amazon Q Apps library can discover it, clone it, and run it.
type LibraryItemMember struct {

	// The unique identifier of the Q App associated with the library item.
	//
	// This member is required.
	AppId *string

	// The version of the Q App associated with the library item.
	//
	// This member is required.
	AppVersion *int32

	// The categories associated with the library item.
	//
	// This member is required.
	Categories []Category

	// The date and time the library item was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The user who created the library item.
	//
	// This member is required.
	CreatedBy *string

	// The unique identifier of the library item.
	//
	// This member is required.
	LibraryItemId *string

	// The number of ratings the library item has received.
	//
	// This member is required.
	RatingCount *int32

	// The status of the library item.
	//
	// This member is required.
	Status *string

	// Whether the current user has rated the library item.
	IsRatedByUser *bool

	// The date and time the library item was last updated.
	UpdatedAt *time.Time

	// The user who last updated the library item.
	UpdatedBy *string

	// The number of users who have the associated Q App.
	UserCount *int32

	noSmithyDocumentSerde
}

// The definition of an Amazon Q App generated based on input such as a
// conversation or problem statement.
type PredictAppDefinition struct {

	// The definition specifying the cards and flow of the generated Q App.
	//
	// This member is required.
	AppDefinition *AppDefinitionInput

	// The title of the generated Q App definition.
	//
	// This member is required.
	Title *string

	// The description of the generated Q App definition.
	Description *string

	noSmithyDocumentSerde
}

// The input options for generating an Q App definition.
//
// The following types satisfy this interface:
//
//	PredictQAppInputOptionsMemberConversation
//	PredictQAppInputOptionsMemberProblemStatement
type PredictQAppInputOptions interface {
	isPredictQAppInputOptions()
}

// A conversation to use as input for generating the Q App definition.
type PredictQAppInputOptionsMemberConversation struct {
	Value []ConversationMessage

	noSmithyDocumentSerde
}

func (*PredictQAppInputOptionsMemberConversation) isPredictQAppInputOptions() {}

// A problem statement to use as input for generating the Q App definition.
type PredictQAppInputOptionsMemberProblemStatement struct {
	Value string

	noSmithyDocumentSerde
}

func (*PredictQAppInputOptionsMemberProblemStatement) isPredictQAppInputOptions() {}

// A card in an Q App that integrates with a third-party plugin or service.
type QPluginCard struct {

	// Any dependencies or requirements for the plugin card.
	//
	// This member is required.
	Dependencies []string

	// The unique identifier of the plugin card.
	//
	// This member is required.
	Id *string

	// The unique identifier of the plugin used by the card.
	//
	// This member is required.
	PluginId *string

	// The type or category of the plugin used by the card.
	//
	// This member is required.
	PluginType PluginType

	// The prompt or instructions displayed for the plugin card.
	//
	// This member is required.
	Prompt *string

	// The title or label of the plugin card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	noSmithyDocumentSerde
}

// The input shape for defining a plugin card in an Amazon Q App.
type QPluginCardInput struct {

	// The unique identifier of the plugin card.
	//
	// This member is required.
	Id *string

	// The unique identifier of the plugin used by the card.
	//
	// This member is required.
	PluginId *string

	// The prompt or instructions displayed for the plugin card.
	//
	// This member is required.
	Prompt *string

	// The title or label of the plugin card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	noSmithyDocumentSerde
}

// A card in a Amazon Q App that generates a response based on the Amazon Q
// Business service.
type QQueryCard struct {

	// Any dependencies or requirements for the query card.
	//
	// This member is required.
	Dependencies []string

	// The unique identifier of the query card.
	//
	// This member is required.
	Id *string

	// The source or type of output generated by the query card.
	//
	// This member is required.
	OutputSource CardOutputSource

	// The prompt or instructions displayed for the query card.
	//
	// This member is required.
	Prompt *string

	// The title or label of the query card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// The Amazon Q Business filters applied in this query card when resolving data
	// sources
	AttributeFilter *AttributeFilter

	noSmithyDocumentSerde
}

// The input shape for defining a query card in an Amazon Q App.
type QQueryCardInput struct {

	// The unique identifier of the query card.
	//
	// This member is required.
	Id *string

	// The prompt or instructions displayed for the query card.
	//
	// This member is required.
	Prompt *string

	// The title or label of the query card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// Turns on filtering of responses based on document attributes or metadata fields.
	AttributeFilter *AttributeFilter

	// The source or type of output to generate for the query card.
	OutputSource CardOutputSource

	noSmithyDocumentSerde
}

// A card in an Amazon Q App that allows the user to input text.
type TextInputCard struct {

	// Any dependencies or requirements for the text input card.
	//
	// This member is required.
	Dependencies []string

	// The unique identifier of the text input card.
	//
	// This member is required.
	Id *string

	// The title or label of the text input card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// The default value to pre-populate in the text input field.
	DefaultValue *string

	// The placeholder text to display in the text input field.
	Placeholder *string

	noSmithyDocumentSerde
}

// The input shape for defining a text input card in an Amazon Q App.
type TextInputCardInput struct {

	// The unique identifier of the text input card.
	//
	// This member is required.
	Id *string

	// The title or label of the text input card.
	//
	// This member is required.
	Title *string

	// The type of the card.
	//
	// This member is required.
	Type CardType

	// The default value to pre-populate in the text input field.
	DefaultValue *string

	// The placeholder text to display in the text input field.
	Placeholder *string

	noSmithyDocumentSerde
}

// An Amazon Q App associated with a user, either owned by the user or favorited.
type UserAppItem struct {

	// The Amazon Resource Name (ARN) of the Q App.
	//
	// This member is required.
	AppArn *string

	// The unique identifier of the Q App.
	//
	// This member is required.
	AppId *string

	// The date and time the user's association with the Q App was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The title of the Q App.
	//
	// This member is required.
	Title *string

	// A flag indicating whether the user can edit the Q App.
	CanEdit *bool

	// The description of the Q App.
	Description *string

	// The status of the user's association with the Q App.
	Status *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCard()                    {}
func (*UnknownUnionMember) isCardInput()               {}
func (*UnknownUnionMember) isDocumentAttributeValue()  {}
func (*UnknownUnionMember) isPredictQAppInputOptions() {}
