//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package cdn

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/cdn/mgmt/2021-06-01/cdn"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AFDEndpointProtocols = original.AFDEndpointProtocols

const (
	AFDEndpointProtocolsHTTP  AFDEndpointProtocols = original.AFDEndpointProtocolsHTTP
	AFDEndpointProtocolsHTTPS AFDEndpointProtocols = original.AFDEndpointProtocolsHTTPS
)

type ActionType = original.ActionType

const (
	ActionTypeAllow    ActionType = original.ActionTypeAllow
	ActionTypeBlock    ActionType = original.ActionTypeBlock
	ActionTypeLog      ActionType = original.ActionTypeLog
	ActionTypeRedirect ActionType = original.ActionTypeRedirect
)

type AfdCertificateType = original.AfdCertificateType

const (
	AfdCertificateTypeAzureFirstPartyManagedCertificate AfdCertificateType = original.AfdCertificateTypeAzureFirstPartyManagedCertificate
	AfdCertificateTypeCustomerCertificate               AfdCertificateType = original.AfdCertificateTypeCustomerCertificate
	AfdCertificateTypeManagedCertificate                AfdCertificateType = original.AfdCertificateTypeManagedCertificate
)

type AfdMinimumTLSVersion = original.AfdMinimumTLSVersion

const (
	AfdMinimumTLSVersionTLS10 AfdMinimumTLSVersion = original.AfdMinimumTLSVersionTLS10
	AfdMinimumTLSVersionTLS12 AfdMinimumTLSVersion = original.AfdMinimumTLSVersionTLS12
)

type AfdProvisioningState = original.AfdProvisioningState

const (
	AfdProvisioningStateCreating  AfdProvisioningState = original.AfdProvisioningStateCreating
	AfdProvisioningStateDeleting  AfdProvisioningState = original.AfdProvisioningStateDeleting
	AfdProvisioningStateFailed    AfdProvisioningState = original.AfdProvisioningStateFailed
	AfdProvisioningStateSucceeded AfdProvisioningState = original.AfdProvisioningStateSucceeded
	AfdProvisioningStateUpdating  AfdProvisioningState = original.AfdProvisioningStateUpdating
)

type AfdQueryStringCachingBehavior = original.AfdQueryStringCachingBehavior

const (
	AfdQueryStringCachingBehaviorIgnoreQueryString            AfdQueryStringCachingBehavior = original.AfdQueryStringCachingBehaviorIgnoreQueryString
	AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings  AfdQueryStringCachingBehavior = original.AfdQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings
	AfdQueryStringCachingBehaviorIncludeSpecifiedQueryStrings AfdQueryStringCachingBehavior = original.AfdQueryStringCachingBehaviorIncludeSpecifiedQueryStrings
	AfdQueryStringCachingBehaviorUseQueryString               AfdQueryStringCachingBehavior = original.AfdQueryStringCachingBehaviorUseQueryString
)

type Algorithm = original.Algorithm

const (
	AlgorithmSHA256 Algorithm = original.AlgorithmSHA256
)

type AutoGeneratedDomainNameLabelScope = original.AutoGeneratedDomainNameLabelScope

const (
	AutoGeneratedDomainNameLabelScopeNoReuse            AutoGeneratedDomainNameLabelScope = original.AutoGeneratedDomainNameLabelScopeNoReuse
	AutoGeneratedDomainNameLabelScopeResourceGroupReuse AutoGeneratedDomainNameLabelScope = original.AutoGeneratedDomainNameLabelScopeResourceGroupReuse
	AutoGeneratedDomainNameLabelScopeSubscriptionReuse  AutoGeneratedDomainNameLabelScope = original.AutoGeneratedDomainNameLabelScopeSubscriptionReuse
	AutoGeneratedDomainNameLabelScopeTenantReuse        AutoGeneratedDomainNameLabelScope = original.AutoGeneratedDomainNameLabelScopeTenantReuse
)

type CacheBehavior = original.CacheBehavior

const (
	CacheBehaviorBypassCache  CacheBehavior = original.CacheBehaviorBypassCache
	CacheBehaviorOverride     CacheBehavior = original.CacheBehaviorOverride
	CacheBehaviorSetIfMissing CacheBehavior = original.CacheBehaviorSetIfMissing
)

type CertificateSource = original.CertificateSource

const (
	CertificateSourceAzureKeyVault               CertificateSource = original.CertificateSourceAzureKeyVault
	CertificateSourceCdn                         CertificateSource = original.CertificateSourceCdn
	CertificateSourceCustomDomainHTTPSParameters CertificateSource = original.CertificateSourceCustomDomainHTTPSParameters
)

type CertificateType = original.CertificateType

const (
	CertificateTypeDedicated CertificateType = original.CertificateTypeDedicated
	CertificateTypeShared    CertificateType = original.CertificateTypeShared
)

type ClientPortOperator = original.ClientPortOperator

const (
	ClientPortOperatorAny                ClientPortOperator = original.ClientPortOperatorAny
	ClientPortOperatorBeginsWith         ClientPortOperator = original.ClientPortOperatorBeginsWith
	ClientPortOperatorContains           ClientPortOperator = original.ClientPortOperatorContains
	ClientPortOperatorEndsWith           ClientPortOperator = original.ClientPortOperatorEndsWith
	ClientPortOperatorEqual              ClientPortOperator = original.ClientPortOperatorEqual
	ClientPortOperatorGreaterThan        ClientPortOperator = original.ClientPortOperatorGreaterThan
	ClientPortOperatorGreaterThanOrEqual ClientPortOperator = original.ClientPortOperatorGreaterThanOrEqual
	ClientPortOperatorLessThan           ClientPortOperator = original.ClientPortOperatorLessThan
	ClientPortOperatorLessThanOrEqual    ClientPortOperator = original.ClientPortOperatorLessThanOrEqual
	ClientPortOperatorRegEx              ClientPortOperator = original.ClientPortOperatorRegEx
)

type CookiesOperator = original.CookiesOperator

const (
	CookiesOperatorAny                CookiesOperator = original.CookiesOperatorAny
	CookiesOperatorBeginsWith         CookiesOperator = original.CookiesOperatorBeginsWith
	CookiesOperatorContains           CookiesOperator = original.CookiesOperatorContains
	CookiesOperatorEndsWith           CookiesOperator = original.CookiesOperatorEndsWith
	CookiesOperatorEqual              CookiesOperator = original.CookiesOperatorEqual
	CookiesOperatorGreaterThan        CookiesOperator = original.CookiesOperatorGreaterThan
	CookiesOperatorGreaterThanOrEqual CookiesOperator = original.CookiesOperatorGreaterThanOrEqual
	CookiesOperatorLessThan           CookiesOperator = original.CookiesOperatorLessThan
	CookiesOperatorLessThanOrEqual    CookiesOperator = original.CookiesOperatorLessThanOrEqual
	CookiesOperatorRegEx              CookiesOperator = original.CookiesOperatorRegEx
)

type CustomDomainResourceState = original.CustomDomainResourceState

const (
	CustomDomainResourceStateActive   CustomDomainResourceState = original.CustomDomainResourceStateActive
	CustomDomainResourceStateCreating CustomDomainResourceState = original.CustomDomainResourceStateCreating
	CustomDomainResourceStateDeleting CustomDomainResourceState = original.CustomDomainResourceStateDeleting
)

type CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningState

const (
	CustomHTTPSProvisioningStateDisabled  CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningStateDisabled
	CustomHTTPSProvisioningStateDisabling CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningStateDisabling
	CustomHTTPSProvisioningStateEnabled   CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningStateEnabled
	CustomHTTPSProvisioningStateEnabling  CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningStateEnabling
	CustomHTTPSProvisioningStateFailed    CustomHTTPSProvisioningState = original.CustomHTTPSProvisioningStateFailed
)

type CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstate

const (
	CustomHTTPSProvisioningSubstateCertificateDeleted                            CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateCertificateDeleted
	CustomHTTPSProvisioningSubstateCertificateDeployed                           CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateCertificateDeployed
	CustomHTTPSProvisioningSubstateDeletingCertificate                           CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateDeletingCertificate
	CustomHTTPSProvisioningSubstateDeployingCertificate                          CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateDeployingCertificate
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved        CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateDomainControlValidationRequestApproved
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected        CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateDomainControlValidationRequestRejected
	CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut        CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateDomainControlValidationRequestTimedOut
	CustomHTTPSProvisioningSubstateIssuingCertificate                            CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateIssuingCertificate
	CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstatePendingDomainControlValidationREquestApproval
	CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest      CustomHTTPSProvisioningSubstate = original.CustomHTTPSProvisioningSubstateSubmittingDomainControlValidationRequest
)

type CustomRuleEnabledState = original.CustomRuleEnabledState

const (
	CustomRuleEnabledStateDisabled CustomRuleEnabledState = original.CustomRuleEnabledStateDisabled
	CustomRuleEnabledStateEnabled  CustomRuleEnabledState = original.CustomRuleEnabledStateEnabled
)

type DeploymentStatus = original.DeploymentStatus

const (
	DeploymentStatusFailed     DeploymentStatus = original.DeploymentStatusFailed
	DeploymentStatusInProgress DeploymentStatus = original.DeploymentStatusInProgress
	DeploymentStatusNotStarted DeploymentStatus = original.DeploymentStatusNotStarted
	DeploymentStatusSucceeded  DeploymentStatus = original.DeploymentStatusSucceeded
)

type DestinationProtocol = original.DestinationProtocol

const (
	DestinationProtocolHTTP         DestinationProtocol = original.DestinationProtocolHTTP
	DestinationProtocolHTTPS        DestinationProtocol = original.DestinationProtocolHTTPS
	DestinationProtocolMatchRequest DestinationProtocol = original.DestinationProtocolMatchRequest
)

type DomainValidationState = original.DomainValidationState

const (
	DomainValidationStateApproved                  DomainValidationState = original.DomainValidationStateApproved
	DomainValidationStateInternalError             DomainValidationState = original.DomainValidationStateInternalError
	DomainValidationStatePending                   DomainValidationState = original.DomainValidationStatePending
	DomainValidationStatePendingRevalidation       DomainValidationState = original.DomainValidationStatePendingRevalidation
	DomainValidationStateRefreshingValidationToken DomainValidationState = original.DomainValidationStateRefreshingValidationToken
	DomainValidationStateRejected                  DomainValidationState = original.DomainValidationStateRejected
	DomainValidationStateSubmitting                DomainValidationState = original.DomainValidationStateSubmitting
	DomainValidationStateTimedOut                  DomainValidationState = original.DomainValidationStateTimedOut
	DomainValidationStateUnknown                   DomainValidationState = original.DomainValidationStateUnknown
)

type EnabledState = original.EnabledState

const (
	EnabledStateDisabled EnabledState = original.EnabledStateDisabled
	EnabledStateEnabled  EnabledState = original.EnabledStateEnabled
)

type EndpointResourceState = original.EndpointResourceState

const (
	EndpointResourceStateCreating EndpointResourceState = original.EndpointResourceStateCreating
	EndpointResourceStateDeleting EndpointResourceState = original.EndpointResourceStateDeleting
	EndpointResourceStateRunning  EndpointResourceState = original.EndpointResourceStateRunning
	EndpointResourceStateStarting EndpointResourceState = original.EndpointResourceStateStarting
	EndpointResourceStateStopped  EndpointResourceState = original.EndpointResourceStateStopped
	EndpointResourceStateStopping EndpointResourceState = original.EndpointResourceStateStopping
)

type ForwardingProtocol = original.ForwardingProtocol

const (
	ForwardingProtocolHTTPOnly     ForwardingProtocol = original.ForwardingProtocolHTTPOnly
	ForwardingProtocolHTTPSOnly    ForwardingProtocol = original.ForwardingProtocolHTTPSOnly
	ForwardingProtocolMatchRequest ForwardingProtocol = original.ForwardingProtocolMatchRequest
)

type GeoFilterActions = original.GeoFilterActions

const (
	GeoFilterActionsAllow GeoFilterActions = original.GeoFilterActionsAllow
	GeoFilterActionsBlock GeoFilterActions = original.GeoFilterActionsBlock
)

type Granularity = original.Granularity

const (
	GranularityP1D  Granularity = original.GranularityP1D
	GranularityPT1H Granularity = original.GranularityPT1H
	GranularityPT5M Granularity = original.GranularityPT5M
)

type Granularity1 = original.Granularity1

const (
	Granularity1P1D  Granularity1 = original.Granularity1P1D
	Granularity1PT1H Granularity1 = original.Granularity1PT1H
	Granularity1PT5M Granularity1 = original.Granularity1PT5M
)

type HTTPSRedirect = original.HTTPSRedirect

const (
	HTTPSRedirectDisabled HTTPSRedirect = original.HTTPSRedirectDisabled
	HTTPSRedirectEnabled  HTTPSRedirect = original.HTTPSRedirectEnabled
)

type HeaderAction = original.HeaderAction

const (
	HeaderActionAppend    HeaderAction = original.HeaderActionAppend
	HeaderActionDelete    HeaderAction = original.HeaderActionDelete
	HeaderActionOverwrite HeaderAction = original.HeaderActionOverwrite
)

type HealthProbeRequestType = original.HealthProbeRequestType

const (
	HealthProbeRequestTypeGET    HealthProbeRequestType = original.HealthProbeRequestTypeGET
	HealthProbeRequestTypeHEAD   HealthProbeRequestType = original.HealthProbeRequestTypeHEAD
	HealthProbeRequestTypeNotSet HealthProbeRequestType = original.HealthProbeRequestTypeNotSet
)

type HostNameOperator = original.HostNameOperator

const (
	HostNameOperatorAny                HostNameOperator = original.HostNameOperatorAny
	HostNameOperatorBeginsWith         HostNameOperator = original.HostNameOperatorBeginsWith
	HostNameOperatorContains           HostNameOperator = original.HostNameOperatorContains
	HostNameOperatorEndsWith           HostNameOperator = original.HostNameOperatorEndsWith
	HostNameOperatorEqual              HostNameOperator = original.HostNameOperatorEqual
	HostNameOperatorGreaterThan        HostNameOperator = original.HostNameOperatorGreaterThan
	HostNameOperatorGreaterThanOrEqual HostNameOperator = original.HostNameOperatorGreaterThanOrEqual
	HostNameOperatorLessThan           HostNameOperator = original.HostNameOperatorLessThan
	HostNameOperatorLessThanOrEqual    HostNameOperator = original.HostNameOperatorLessThanOrEqual
	HostNameOperatorRegEx              HostNameOperator = original.HostNameOperatorRegEx
)

type IdentityType = original.IdentityType

const (
	IdentityTypeApplication     IdentityType = original.IdentityTypeApplication
	IdentityTypeKey             IdentityType = original.IdentityTypeKey
	IdentityTypeManagedIdentity IdentityType = original.IdentityTypeManagedIdentity
	IdentityTypeUser            IdentityType = original.IdentityTypeUser
)

type LinkToDefaultDomain = original.LinkToDefaultDomain

const (
	LinkToDefaultDomainDisabled LinkToDefaultDomain = original.LinkToDefaultDomainDisabled
	LinkToDefaultDomainEnabled  LinkToDefaultDomain = original.LinkToDefaultDomainEnabled
)

type LogMetric = original.LogMetric

const (
	LogMetricClientRequestBandwidth LogMetric = original.LogMetricClientRequestBandwidth
	LogMetricClientRequestCount     LogMetric = original.LogMetricClientRequestCount
	LogMetricClientRequestTraffic   LogMetric = original.LogMetricClientRequestTraffic
	LogMetricOriginRequestBandwidth LogMetric = original.LogMetricOriginRequestBandwidth
	LogMetricOriginRequestTraffic   LogMetric = original.LogMetricOriginRequestTraffic
	LogMetricTotalLatency           LogMetric = original.LogMetricTotalLatency
)

type LogMetricsGranularity = original.LogMetricsGranularity

const (
	LogMetricsGranularityP1D  LogMetricsGranularity = original.LogMetricsGranularityP1D
	LogMetricsGranularityPT1H LogMetricsGranularity = original.LogMetricsGranularityPT1H
	LogMetricsGranularityPT5M LogMetricsGranularity = original.LogMetricsGranularityPT5M
)

type LogMetricsGroupBy = original.LogMetricsGroupBy

const (
	LogMetricsGroupByCacheStatus     LogMetricsGroupBy = original.LogMetricsGroupByCacheStatus
	LogMetricsGroupByCountryOrRegion LogMetricsGroupBy = original.LogMetricsGroupByCountryOrRegion
	LogMetricsGroupByCustomDomain    LogMetricsGroupBy = original.LogMetricsGroupByCustomDomain
	LogMetricsGroupByHTTPStatusCode  LogMetricsGroupBy = original.LogMetricsGroupByHTTPStatusCode
	LogMetricsGroupByProtocol        LogMetricsGroupBy = original.LogMetricsGroupByProtocol
)

type LogRanking = original.LogRanking

const (
	LogRankingBrowser         LogRanking = original.LogRankingBrowser
	LogRankingCountryOrRegion LogRanking = original.LogRankingCountryOrRegion
	LogRankingReferrer        LogRanking = original.LogRankingReferrer
	LogRankingURL             LogRanking = original.LogRankingURL
	LogRankingUserAgent       LogRanking = original.LogRankingUserAgent
)

type LogRankingMetric = original.LogRankingMetric

const (
	LogRankingMetricClientRequestCount   LogRankingMetric = original.LogRankingMetricClientRequestCount
	LogRankingMetricClientRequestTraffic LogRankingMetric = original.LogRankingMetricClientRequestTraffic
	LogRankingMetricErrorCount           LogRankingMetric = original.LogRankingMetricErrorCount
	LogRankingMetricHitCount             LogRankingMetric = original.LogRankingMetricHitCount
	LogRankingMetricMissCount            LogRankingMetric = original.LogRankingMetricMissCount
	LogRankingMetricUserErrorCount       LogRankingMetric = original.LogRankingMetricUserErrorCount
)

type ManagedRuleEnabledState = original.ManagedRuleEnabledState

const (
	ManagedRuleEnabledStateDisabled ManagedRuleEnabledState = original.ManagedRuleEnabledStateDisabled
	ManagedRuleEnabledStateEnabled  ManagedRuleEnabledState = original.ManagedRuleEnabledStateEnabled
)

type MatchProcessingBehavior = original.MatchProcessingBehavior

const (
	MatchProcessingBehaviorContinue MatchProcessingBehavior = original.MatchProcessingBehaviorContinue
	MatchProcessingBehaviorStop     MatchProcessingBehavior = original.MatchProcessingBehaviorStop
)

type MinimumTLSVersion = original.MinimumTLSVersion

const (
	MinimumTLSVersionNone  MinimumTLSVersion = original.MinimumTLSVersionNone
	MinimumTLSVersionTLS10 MinimumTLSVersion = original.MinimumTLSVersionTLS10
	MinimumTLSVersionTLS12 MinimumTLSVersion = original.MinimumTLSVersionTLS12
)

type Name = original.Name

const (
	NameClientPort            Name = original.NameClientPort
	NameCookies               Name = original.NameCookies
	NameDeliveryRuleCondition Name = original.NameDeliveryRuleCondition
	NameHostName              Name = original.NameHostName
	NameHTTPVersion           Name = original.NameHTTPVersion
	NameIsDevice              Name = original.NameIsDevice
	NamePostArgs              Name = original.NamePostArgs
	NameQueryString           Name = original.NameQueryString
	NameRemoteAddress         Name = original.NameRemoteAddress
	NameRequestBody           Name = original.NameRequestBody
	NameRequestHeader         Name = original.NameRequestHeader
	NameRequestMethod         Name = original.NameRequestMethod
	NameRequestScheme         Name = original.NameRequestScheme
	NameRequestURI            Name = original.NameRequestURI
	NameServerPort            Name = original.NameServerPort
	NameSocketAddr            Name = original.NameSocketAddr
	NameSslProtocol           Name = original.NameSslProtocol
	NameURLFileExtension      Name = original.NameURLFileExtension
	NameURLFileName           Name = original.NameURLFileName
	NameURLPath               Name = original.NameURLPath
)

type NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleAction

const (
	NameBasicDeliveryRuleActionNameCacheExpiration            NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameCacheExpiration
	NameBasicDeliveryRuleActionNameCacheKeyQueryString        NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameCacheKeyQueryString
	NameBasicDeliveryRuleActionNameDeliveryRuleAction         NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameDeliveryRuleAction
	NameBasicDeliveryRuleActionNameModifyRequestHeader        NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameModifyRequestHeader
	NameBasicDeliveryRuleActionNameModifyResponseHeader       NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameModifyResponseHeader
	NameBasicDeliveryRuleActionNameOriginGroupOverride        NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameOriginGroupOverride
	NameBasicDeliveryRuleActionNameRouteConfigurationOverride NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameRouteConfigurationOverride
	NameBasicDeliveryRuleActionNameURLRedirect                NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameURLRedirect
	NameBasicDeliveryRuleActionNameURLRewrite                 NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameURLRewrite
	NameBasicDeliveryRuleActionNameURLSigning                 NameBasicDeliveryRuleAction = original.NameBasicDeliveryRuleActionNameURLSigning
)

type Operator = original.Operator

const (
	OperatorAny                Operator = original.OperatorAny
	OperatorBeginsWith         Operator = original.OperatorBeginsWith
	OperatorContains           Operator = original.OperatorContains
	OperatorEndsWith           Operator = original.OperatorEndsWith
	OperatorEqual              Operator = original.OperatorEqual
	OperatorGeoMatch           Operator = original.OperatorGeoMatch
	OperatorGreaterThan        Operator = original.OperatorGreaterThan
	OperatorGreaterThanOrEqual Operator = original.OperatorGreaterThanOrEqual
	OperatorIPMatch            Operator = original.OperatorIPMatch
	OperatorLessThan           Operator = original.OperatorLessThan
	OperatorLessThanOrEqual    Operator = original.OperatorLessThanOrEqual
	OperatorRegEx              Operator = original.OperatorRegEx
)

type OptimizationType = original.OptimizationType

const (
	OptimizationTypeDynamicSiteAcceleration     OptimizationType = original.OptimizationTypeDynamicSiteAcceleration
	OptimizationTypeGeneralMediaStreaming       OptimizationType = original.OptimizationTypeGeneralMediaStreaming
	OptimizationTypeGeneralWebDelivery          OptimizationType = original.OptimizationTypeGeneralWebDelivery
	OptimizationTypeLargeFileDownload           OptimizationType = original.OptimizationTypeLargeFileDownload
	OptimizationTypeVideoOnDemandMediaStreaming OptimizationType = original.OptimizationTypeVideoOnDemandMediaStreaming
)

type OriginGroupResourceState = original.OriginGroupResourceState

const (
	OriginGroupResourceStateActive   OriginGroupResourceState = original.OriginGroupResourceStateActive
	OriginGroupResourceStateCreating OriginGroupResourceState = original.OriginGroupResourceStateCreating
	OriginGroupResourceStateDeleting OriginGroupResourceState = original.OriginGroupResourceStateDeleting
)

type OriginResourceState = original.OriginResourceState

const (
	OriginResourceStateActive   OriginResourceState = original.OriginResourceStateActive
	OriginResourceStateCreating OriginResourceState = original.OriginResourceStateCreating
	OriginResourceStateDeleting OriginResourceState = original.OriginResourceStateDeleting
)

type ParamIndicator = original.ParamIndicator

const (
	ParamIndicatorExpires   ParamIndicator = original.ParamIndicatorExpires
	ParamIndicatorKeyID     ParamIndicator = original.ParamIndicatorKeyID
	ParamIndicatorSignature ParamIndicator = original.ParamIndicatorSignature
)

type PolicyEnabledState = original.PolicyEnabledState

const (
	PolicyEnabledStateDisabled PolicyEnabledState = original.PolicyEnabledStateDisabled
	PolicyEnabledStateEnabled  PolicyEnabledState = original.PolicyEnabledStateEnabled
)

type PolicyMode = original.PolicyMode

const (
	PolicyModeDetection  PolicyMode = original.PolicyModeDetection
	PolicyModePrevention PolicyMode = original.PolicyModePrevention
)

type PolicyResourceState = original.PolicyResourceState

const (
	PolicyResourceStateCreating  PolicyResourceState = original.PolicyResourceStateCreating
	PolicyResourceStateDeleting  PolicyResourceState = original.PolicyResourceStateDeleting
	PolicyResourceStateDisabled  PolicyResourceState = original.PolicyResourceStateDisabled
	PolicyResourceStateDisabling PolicyResourceState = original.PolicyResourceStateDisabling
	PolicyResourceStateEnabled   PolicyResourceState = original.PolicyResourceStateEnabled
	PolicyResourceStateEnabling  PolicyResourceState = original.PolicyResourceStateEnabling
)

type PostArgsOperator = original.PostArgsOperator

const (
	PostArgsOperatorAny                PostArgsOperator = original.PostArgsOperatorAny
	PostArgsOperatorBeginsWith         PostArgsOperator = original.PostArgsOperatorBeginsWith
	PostArgsOperatorContains           PostArgsOperator = original.PostArgsOperatorContains
	PostArgsOperatorEndsWith           PostArgsOperator = original.PostArgsOperatorEndsWith
	PostArgsOperatorEqual              PostArgsOperator = original.PostArgsOperatorEqual
	PostArgsOperatorGreaterThan        PostArgsOperator = original.PostArgsOperatorGreaterThan
	PostArgsOperatorGreaterThanOrEqual PostArgsOperator = original.PostArgsOperatorGreaterThanOrEqual
	PostArgsOperatorLessThan           PostArgsOperator = original.PostArgsOperatorLessThan
	PostArgsOperatorLessThanOrEqual    PostArgsOperator = original.PostArgsOperatorLessThanOrEqual
	PostArgsOperatorRegEx              PostArgsOperator = original.PostArgsOperatorRegEx
)

type PrivateEndpointStatus = original.PrivateEndpointStatus

const (
	PrivateEndpointStatusApproved     PrivateEndpointStatus = original.PrivateEndpointStatusApproved
	PrivateEndpointStatusDisconnected PrivateEndpointStatus = original.PrivateEndpointStatusDisconnected
	PrivateEndpointStatusPending      PrivateEndpointStatus = original.PrivateEndpointStatusPending
	PrivateEndpointStatusRejected     PrivateEndpointStatus = original.PrivateEndpointStatusRejected
	PrivateEndpointStatusTimeout      PrivateEndpointStatus = original.PrivateEndpointStatusTimeout
)

type ProbeProtocol = original.ProbeProtocol

const (
	ProbeProtocolHTTP   ProbeProtocol = original.ProbeProtocolHTTP
	ProbeProtocolHTTPS  ProbeProtocol = original.ProbeProtocolHTTPS
	ProbeProtocolNotSet ProbeProtocol = original.ProbeProtocolNotSet
)

type ProfileResourceState = original.ProfileResourceState

const (
	ProfileResourceStateActive   ProfileResourceState = original.ProfileResourceStateActive
	ProfileResourceStateCreating ProfileResourceState = original.ProfileResourceStateCreating
	ProfileResourceStateDeleting ProfileResourceState = original.ProfileResourceStateDeleting
	ProfileResourceStateDisabled ProfileResourceState = original.ProfileResourceStateDisabled
)

type ProtocolType = original.ProtocolType

const (
	ProtocolTypeIPBased              ProtocolType = original.ProtocolTypeIPBased
	ProtocolTypeServerNameIndication ProtocolType = original.ProtocolTypeServerNameIndication
)

type ProvisioningState = original.ProvisioningState

const (
	ProvisioningStateCreating  ProvisioningState = original.ProvisioningStateCreating
	ProvisioningStateFailed    ProvisioningState = original.ProvisioningStateFailed
	ProvisioningStateSucceeded ProvisioningState = original.ProvisioningStateSucceeded
)

type QueryStringBehavior = original.QueryStringBehavior

const (
	QueryStringBehaviorExclude    QueryStringBehavior = original.QueryStringBehaviorExclude
	QueryStringBehaviorExcludeAll QueryStringBehavior = original.QueryStringBehaviorExcludeAll
	QueryStringBehaviorInclude    QueryStringBehavior = original.QueryStringBehaviorInclude
	QueryStringBehaviorIncludeAll QueryStringBehavior = original.QueryStringBehaviorIncludeAll
)

type QueryStringCachingBehavior = original.QueryStringCachingBehavior

const (
	QueryStringCachingBehaviorBypassCaching     QueryStringCachingBehavior = original.QueryStringCachingBehaviorBypassCaching
	QueryStringCachingBehaviorIgnoreQueryString QueryStringCachingBehavior = original.QueryStringCachingBehaviorIgnoreQueryString
	QueryStringCachingBehaviorNotSet            QueryStringCachingBehavior = original.QueryStringCachingBehaviorNotSet
	QueryStringCachingBehaviorUseQueryString    QueryStringCachingBehavior = original.QueryStringCachingBehaviorUseQueryString
)

type QueryStringOperator = original.QueryStringOperator

const (
	QueryStringOperatorAny                QueryStringOperator = original.QueryStringOperatorAny
	QueryStringOperatorBeginsWith         QueryStringOperator = original.QueryStringOperatorBeginsWith
	QueryStringOperatorContains           QueryStringOperator = original.QueryStringOperatorContains
	QueryStringOperatorEndsWith           QueryStringOperator = original.QueryStringOperatorEndsWith
	QueryStringOperatorEqual              QueryStringOperator = original.QueryStringOperatorEqual
	QueryStringOperatorGreaterThan        QueryStringOperator = original.QueryStringOperatorGreaterThan
	QueryStringOperatorGreaterThanOrEqual QueryStringOperator = original.QueryStringOperatorGreaterThanOrEqual
	QueryStringOperatorLessThan           QueryStringOperator = original.QueryStringOperatorLessThan
	QueryStringOperatorLessThanOrEqual    QueryStringOperator = original.QueryStringOperatorLessThanOrEqual
	QueryStringOperatorRegEx              QueryStringOperator = original.QueryStringOperatorRegEx
)

type RedirectType = original.RedirectType

const (
	RedirectTypeFound             RedirectType = original.RedirectTypeFound
	RedirectTypeMoved             RedirectType = original.RedirectTypeMoved
	RedirectTypePermanentRedirect RedirectType = original.RedirectTypePermanentRedirect
	RedirectTypeTemporaryRedirect RedirectType = original.RedirectTypeTemporaryRedirect
)

type RemoteAddressOperator = original.RemoteAddressOperator

const (
	RemoteAddressOperatorAny      RemoteAddressOperator = original.RemoteAddressOperatorAny
	RemoteAddressOperatorGeoMatch RemoteAddressOperator = original.RemoteAddressOperatorGeoMatch
	RemoteAddressOperatorIPMatch  RemoteAddressOperator = original.RemoteAddressOperatorIPMatch
)

type RequestBodyOperator = original.RequestBodyOperator

const (
	RequestBodyOperatorAny                RequestBodyOperator = original.RequestBodyOperatorAny
	RequestBodyOperatorBeginsWith         RequestBodyOperator = original.RequestBodyOperatorBeginsWith
	RequestBodyOperatorContains           RequestBodyOperator = original.RequestBodyOperatorContains
	RequestBodyOperatorEndsWith           RequestBodyOperator = original.RequestBodyOperatorEndsWith
	RequestBodyOperatorEqual              RequestBodyOperator = original.RequestBodyOperatorEqual
	RequestBodyOperatorGreaterThan        RequestBodyOperator = original.RequestBodyOperatorGreaterThan
	RequestBodyOperatorGreaterThanOrEqual RequestBodyOperator = original.RequestBodyOperatorGreaterThanOrEqual
	RequestBodyOperatorLessThan           RequestBodyOperator = original.RequestBodyOperatorLessThan
	RequestBodyOperatorLessThanOrEqual    RequestBodyOperator = original.RequestBodyOperatorLessThanOrEqual
	RequestBodyOperatorRegEx              RequestBodyOperator = original.RequestBodyOperatorRegEx
)

type RequestHeaderOperator = original.RequestHeaderOperator

const (
	RequestHeaderOperatorAny                RequestHeaderOperator = original.RequestHeaderOperatorAny
	RequestHeaderOperatorBeginsWith         RequestHeaderOperator = original.RequestHeaderOperatorBeginsWith
	RequestHeaderOperatorContains           RequestHeaderOperator = original.RequestHeaderOperatorContains
	RequestHeaderOperatorEndsWith           RequestHeaderOperator = original.RequestHeaderOperatorEndsWith
	RequestHeaderOperatorEqual              RequestHeaderOperator = original.RequestHeaderOperatorEqual
	RequestHeaderOperatorGreaterThan        RequestHeaderOperator = original.RequestHeaderOperatorGreaterThan
	RequestHeaderOperatorGreaterThanOrEqual RequestHeaderOperator = original.RequestHeaderOperatorGreaterThanOrEqual
	RequestHeaderOperatorLessThan           RequestHeaderOperator = original.RequestHeaderOperatorLessThan
	RequestHeaderOperatorLessThanOrEqual    RequestHeaderOperator = original.RequestHeaderOperatorLessThanOrEqual
	RequestHeaderOperatorRegEx              RequestHeaderOperator = original.RequestHeaderOperatorRegEx
)

type RequestURIOperator = original.RequestURIOperator

const (
	RequestURIOperatorAny                RequestURIOperator = original.RequestURIOperatorAny
	RequestURIOperatorBeginsWith         RequestURIOperator = original.RequestURIOperatorBeginsWith
	RequestURIOperatorContains           RequestURIOperator = original.RequestURIOperatorContains
	RequestURIOperatorEndsWith           RequestURIOperator = original.RequestURIOperatorEndsWith
	RequestURIOperatorEqual              RequestURIOperator = original.RequestURIOperatorEqual
	RequestURIOperatorGreaterThan        RequestURIOperator = original.RequestURIOperatorGreaterThan
	RequestURIOperatorGreaterThanOrEqual RequestURIOperator = original.RequestURIOperatorGreaterThanOrEqual
	RequestURIOperatorLessThan           RequestURIOperator = original.RequestURIOperatorLessThan
	RequestURIOperatorLessThanOrEqual    RequestURIOperator = original.RequestURIOperatorLessThanOrEqual
	RequestURIOperatorRegEx              RequestURIOperator = original.RequestURIOperatorRegEx
)

type ResourceType = original.ResourceType

const (
	ResourceTypeMicrosoftCdnProfilesAfdEndpoints ResourceType = original.ResourceTypeMicrosoftCdnProfilesAfdEndpoints
	ResourceTypeMicrosoftCdnProfilesEndpoints    ResourceType = original.ResourceTypeMicrosoftCdnProfilesEndpoints
)

type ResponseBasedDetectedErrorTypes = original.ResponseBasedDetectedErrorTypes

const (
	ResponseBasedDetectedErrorTypesNone             ResponseBasedDetectedErrorTypes = original.ResponseBasedDetectedErrorTypesNone
	ResponseBasedDetectedErrorTypesTCPAndHTTPErrors ResponseBasedDetectedErrorTypes = original.ResponseBasedDetectedErrorTypesTCPAndHTTPErrors
	ResponseBasedDetectedErrorTypesTCPErrorsOnly    ResponseBasedDetectedErrorTypes = original.ResponseBasedDetectedErrorTypesTCPErrorsOnly
)

type RuleCacheBehavior = original.RuleCacheBehavior

const (
	RuleCacheBehaviorHonorOrigin             RuleCacheBehavior = original.RuleCacheBehaviorHonorOrigin
	RuleCacheBehaviorOverrideAlways          RuleCacheBehavior = original.RuleCacheBehaviorOverrideAlways
	RuleCacheBehaviorOverrideIfOriginMissing RuleCacheBehavior = original.RuleCacheBehaviorOverrideIfOriginMissing
)

type RuleIsCompressionEnabled = original.RuleIsCompressionEnabled

const (
	RuleIsCompressionEnabledDisabled RuleIsCompressionEnabled = original.RuleIsCompressionEnabledDisabled
	RuleIsCompressionEnabledEnabled  RuleIsCompressionEnabled = original.RuleIsCompressionEnabledEnabled
)

type RuleQueryStringCachingBehavior = original.RuleQueryStringCachingBehavior

const (
	RuleQueryStringCachingBehaviorIgnoreQueryString            RuleQueryStringCachingBehavior = original.RuleQueryStringCachingBehaviorIgnoreQueryString
	RuleQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings  RuleQueryStringCachingBehavior = original.RuleQueryStringCachingBehaviorIgnoreSpecifiedQueryStrings
	RuleQueryStringCachingBehaviorIncludeSpecifiedQueryStrings RuleQueryStringCachingBehavior = original.RuleQueryStringCachingBehaviorIncludeSpecifiedQueryStrings
	RuleQueryStringCachingBehaviorUseQueryString               RuleQueryStringCachingBehavior = original.RuleQueryStringCachingBehaviorUseQueryString
)

type SecretType = original.SecretType

const (
	SecretTypeAzureFirstPartyManagedCertificate SecretType = original.SecretTypeAzureFirstPartyManagedCertificate
	SecretTypeCustomerCertificate               SecretType = original.SecretTypeCustomerCertificate
	SecretTypeManagedCertificate                SecretType = original.SecretTypeManagedCertificate
	SecretTypeURLSigningKey                     SecretType = original.SecretTypeURLSigningKey
)

type ServerPortOperator = original.ServerPortOperator

const (
	ServerPortOperatorAny                ServerPortOperator = original.ServerPortOperatorAny
	ServerPortOperatorBeginsWith         ServerPortOperator = original.ServerPortOperatorBeginsWith
	ServerPortOperatorContains           ServerPortOperator = original.ServerPortOperatorContains
	ServerPortOperatorEndsWith           ServerPortOperator = original.ServerPortOperatorEndsWith
	ServerPortOperatorEqual              ServerPortOperator = original.ServerPortOperatorEqual
	ServerPortOperatorGreaterThan        ServerPortOperator = original.ServerPortOperatorGreaterThan
	ServerPortOperatorGreaterThanOrEqual ServerPortOperator = original.ServerPortOperatorGreaterThanOrEqual
	ServerPortOperatorLessThan           ServerPortOperator = original.ServerPortOperatorLessThan
	ServerPortOperatorLessThanOrEqual    ServerPortOperator = original.ServerPortOperatorLessThanOrEqual
	ServerPortOperatorRegEx              ServerPortOperator = original.ServerPortOperatorRegEx
)

type SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatus

const (
	SharedPrivateLinkResourceStatusApproved     SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatusApproved
	SharedPrivateLinkResourceStatusDisconnected SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatusDisconnected
	SharedPrivateLinkResourceStatusPending      SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatusPending
	SharedPrivateLinkResourceStatusRejected     SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatusRejected
	SharedPrivateLinkResourceStatusTimeout      SharedPrivateLinkResourceStatus = original.SharedPrivateLinkResourceStatusTimeout
)

type SkuName = original.SkuName

const (
	SkuNameCustomVerizon                    SkuName = original.SkuNameCustomVerizon
	SkuNamePremiumAzureFrontDoor            SkuName = original.SkuNamePremiumAzureFrontDoor
	SkuNamePremiumVerizon                   SkuName = original.SkuNamePremiumVerizon
	SkuNameStandard955BandWidthChinaCdn     SkuName = original.SkuNameStandard955BandWidthChinaCdn
	SkuNameStandardAkamai                   SkuName = original.SkuNameStandardAkamai
	SkuNameStandardAvgBandWidthChinaCdn     SkuName = original.SkuNameStandardAvgBandWidthChinaCdn
	SkuNameStandardAzureFrontDoor           SkuName = original.SkuNameStandardAzureFrontDoor
	SkuNameStandardChinaCdn                 SkuName = original.SkuNameStandardChinaCdn
	SkuNameStandardMicrosoft                SkuName = original.SkuNameStandardMicrosoft
	SkuNameStandardPlus955BandWidthChinaCdn SkuName = original.SkuNameStandardPlus955BandWidthChinaCdn
	SkuNameStandardPlusAvgBandWidthChinaCdn SkuName = original.SkuNameStandardPlusAvgBandWidthChinaCdn
	SkuNameStandardPlusChinaCdn             SkuName = original.SkuNameStandardPlusChinaCdn
	SkuNameStandardVerizon                  SkuName = original.SkuNameStandardVerizon
)

type SocketAddrOperator = original.SocketAddrOperator

const (
	SocketAddrOperatorAny     SocketAddrOperator = original.SocketAddrOperatorAny
	SocketAddrOperatorIPMatch SocketAddrOperator = original.SocketAddrOperatorIPMatch
)

type SslProtocol = original.SslProtocol

const (
	SslProtocolTLSv1  SslProtocol = original.SslProtocolTLSv1
	SslProtocolTLSv11 SslProtocol = original.SslProtocolTLSv11
	SslProtocolTLSv12 SslProtocol = original.SslProtocolTLSv12
)

type Status = original.Status

const (
	StatusAccessDenied       Status = original.StatusAccessDenied
	StatusCertificateExpired Status = original.StatusCertificateExpired
	StatusInvalid            Status = original.StatusInvalid
	StatusValid              Status = original.StatusValid
)

type Transform = original.Transform

const (
	TransformLowercase   Transform = original.TransformLowercase
	TransformRemoveNulls Transform = original.TransformRemoveNulls
	TransformTrim        Transform = original.TransformTrim
	TransformUppercase   Transform = original.TransformUppercase
	TransformURLDecode   Transform = original.TransformURLDecode
	TransformURLEncode   Transform = original.TransformURLEncode
)

type TransformType = original.TransformType

const (
	TransformTypeLowercase   TransformType = original.TransformTypeLowercase
	TransformTypeRemoveNulls TransformType = original.TransformTypeRemoveNulls
	TransformTypeTrim        TransformType = original.TransformTypeTrim
	TransformTypeUppercase   TransformType = original.TransformTypeUppercase
	TransformTypeURLDecode   TransformType = original.TransformTypeURLDecode
	TransformTypeURLEncode   TransformType = original.TransformTypeURLEncode
)

type Type = original.Type

const (
	TypeSecurityPolicyPropertiesParameters Type = original.TypeSecurityPolicyPropertiesParameters
	TypeWebApplicationFirewall             Type = original.TypeWebApplicationFirewall
)

type TypeBasicSecretParameters = original.TypeBasicSecretParameters

const (
	TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate TypeBasicSecretParameters = original.TypeBasicSecretParametersTypeAzureFirstPartyManagedCertificate
	TypeBasicSecretParametersTypeCustomerCertificate               TypeBasicSecretParameters = original.TypeBasicSecretParametersTypeCustomerCertificate
	TypeBasicSecretParametersTypeManagedCertificate                TypeBasicSecretParameters = original.TypeBasicSecretParametersTypeManagedCertificate
	TypeBasicSecretParametersTypeSecretParameters                  TypeBasicSecretParameters = original.TypeBasicSecretParametersTypeSecretParameters
	TypeBasicSecretParametersTypeURLSigningKey                     TypeBasicSecretParameters = original.TypeBasicSecretParametersTypeURLSigningKey
)

type URLFileExtensionOperator = original.URLFileExtensionOperator

const (
	URLFileExtensionOperatorAny                URLFileExtensionOperator = original.URLFileExtensionOperatorAny
	URLFileExtensionOperatorBeginsWith         URLFileExtensionOperator = original.URLFileExtensionOperatorBeginsWith
	URLFileExtensionOperatorContains           URLFileExtensionOperator = original.URLFileExtensionOperatorContains
	URLFileExtensionOperatorEndsWith           URLFileExtensionOperator = original.URLFileExtensionOperatorEndsWith
	URLFileExtensionOperatorEqual              URLFileExtensionOperator = original.URLFileExtensionOperatorEqual
	URLFileExtensionOperatorGreaterThan        URLFileExtensionOperator = original.URLFileExtensionOperatorGreaterThan
	URLFileExtensionOperatorGreaterThanOrEqual URLFileExtensionOperator = original.URLFileExtensionOperatorGreaterThanOrEqual
	URLFileExtensionOperatorLessThan           URLFileExtensionOperator = original.URLFileExtensionOperatorLessThan
	URLFileExtensionOperatorLessThanOrEqual    URLFileExtensionOperator = original.URLFileExtensionOperatorLessThanOrEqual
	URLFileExtensionOperatorRegEx              URLFileExtensionOperator = original.URLFileExtensionOperatorRegEx
)

type URLFileNameOperator = original.URLFileNameOperator

const (
	URLFileNameOperatorAny                URLFileNameOperator = original.URLFileNameOperatorAny
	URLFileNameOperatorBeginsWith         URLFileNameOperator = original.URLFileNameOperatorBeginsWith
	URLFileNameOperatorContains           URLFileNameOperator = original.URLFileNameOperatorContains
	URLFileNameOperatorEndsWith           URLFileNameOperator = original.URLFileNameOperatorEndsWith
	URLFileNameOperatorEqual              URLFileNameOperator = original.URLFileNameOperatorEqual
	URLFileNameOperatorGreaterThan        URLFileNameOperator = original.URLFileNameOperatorGreaterThan
	URLFileNameOperatorGreaterThanOrEqual URLFileNameOperator = original.URLFileNameOperatorGreaterThanOrEqual
	URLFileNameOperatorLessThan           URLFileNameOperator = original.URLFileNameOperatorLessThan
	URLFileNameOperatorLessThanOrEqual    URLFileNameOperator = original.URLFileNameOperatorLessThanOrEqual
	URLFileNameOperatorRegEx              URLFileNameOperator = original.URLFileNameOperatorRegEx
)

type URLPathOperator = original.URLPathOperator

const (
	URLPathOperatorAny                URLPathOperator = original.URLPathOperatorAny
	URLPathOperatorBeginsWith         URLPathOperator = original.URLPathOperatorBeginsWith
	URLPathOperatorContains           URLPathOperator = original.URLPathOperatorContains
	URLPathOperatorEndsWith           URLPathOperator = original.URLPathOperatorEndsWith
	URLPathOperatorEqual              URLPathOperator = original.URLPathOperatorEqual
	URLPathOperatorGreaterThan        URLPathOperator = original.URLPathOperatorGreaterThan
	URLPathOperatorGreaterThanOrEqual URLPathOperator = original.URLPathOperatorGreaterThanOrEqual
	URLPathOperatorLessThan           URLPathOperator = original.URLPathOperatorLessThan
	URLPathOperatorLessThanOrEqual    URLPathOperator = original.URLPathOperatorLessThanOrEqual
	URLPathOperatorRegEx              URLPathOperator = original.URLPathOperatorRegEx
	URLPathOperatorWildcard           URLPathOperator = original.URLPathOperatorWildcard
)

type Unit = original.Unit

const (
	UnitBitsPerSecond Unit = original.UnitBitsPerSecond
	UnitBytes         Unit = original.UnitBytes
	UnitCount         Unit = original.UnitCount
	UnitMilliSeconds  Unit = original.UnitMilliSeconds
)

type Unit1 = original.Unit1

const (
	Unit1Count Unit1 = original.Unit1Count
)

type WafAction = original.WafAction

const (
	WafActionAllow    WafAction = original.WafActionAllow
	WafActionBlock    WafAction = original.WafActionBlock
	WafActionLog      WafAction = original.WafActionLog
	WafActionRedirect WafAction = original.WafActionRedirect
)

type WafGranularity = original.WafGranularity

const (
	WafGranularityP1D  WafGranularity = original.WafGranularityP1D
	WafGranularityPT1H WafGranularity = original.WafGranularityPT1H
	WafGranularityPT5M WafGranularity = original.WafGranularityPT5M
)

type WafMatchVariable = original.WafMatchVariable

const (
	WafMatchVariableCookies       WafMatchVariable = original.WafMatchVariableCookies
	WafMatchVariablePostArgs      WafMatchVariable = original.WafMatchVariablePostArgs
	WafMatchVariableQueryString   WafMatchVariable = original.WafMatchVariableQueryString
	WafMatchVariableRemoteAddr    WafMatchVariable = original.WafMatchVariableRemoteAddr
	WafMatchVariableRequestBody   WafMatchVariable = original.WafMatchVariableRequestBody
	WafMatchVariableRequestHeader WafMatchVariable = original.WafMatchVariableRequestHeader
	WafMatchVariableRequestMethod WafMatchVariable = original.WafMatchVariableRequestMethod
	WafMatchVariableRequestURI    WafMatchVariable = original.WafMatchVariableRequestURI
	WafMatchVariableSocketAddr    WafMatchVariable = original.WafMatchVariableSocketAddr
)

type WafMetric = original.WafMetric

const (
	WafMetricClientRequestCount WafMetric = original.WafMetricClientRequestCount
)

type WafRankingGroupBy = original.WafRankingGroupBy

const (
	WafRankingGroupByCustomDomain   WafRankingGroupBy = original.WafRankingGroupByCustomDomain
	WafRankingGroupByHTTPStatusCode WafRankingGroupBy = original.WafRankingGroupByHTTPStatusCode
)

type WafRankingType = original.WafRankingType

const (
	WafRankingTypeAction          WafRankingType = original.WafRankingTypeAction
	WafRankingTypeClientIP        WafRankingType = original.WafRankingTypeClientIP
	WafRankingTypeCountryOrRegion WafRankingType = original.WafRankingTypeCountryOrRegion
	WafRankingTypeRuleGroup       WafRankingType = original.WafRankingTypeRuleGroup
	WafRankingTypeRuleID          WafRankingType = original.WafRankingTypeRuleID
	WafRankingTypeRuleType        WafRankingType = original.WafRankingTypeRuleType
	WafRankingTypeURL             WafRankingType = original.WafRankingTypeURL
	WafRankingTypeUserAgent       WafRankingType = original.WafRankingTypeUserAgent
)

type WafRuleType = original.WafRuleType

const (
	WafRuleTypeBot     WafRuleType = original.WafRuleTypeBot
	WafRuleTypeCustom  WafRuleType = original.WafRuleTypeCustom
	WafRuleTypeManaged WafRuleType = original.WafRuleTypeManaged
)

type AFDCustomDomainsClient = original.AFDCustomDomainsClient
type AFDCustomDomainsCreateFuture = original.AFDCustomDomainsCreateFuture
type AFDCustomDomainsDeleteFuture = original.AFDCustomDomainsDeleteFuture
type AFDCustomDomainsRefreshValidationTokenFuture = original.AFDCustomDomainsRefreshValidationTokenFuture
type AFDCustomDomainsUpdateFuture = original.AFDCustomDomainsUpdateFuture
type AFDDomain = original.AFDDomain
type AFDDomainHTTPSParameters = original.AFDDomainHTTPSParameters
type AFDDomainListResult = original.AFDDomainListResult
type AFDDomainListResultIterator = original.AFDDomainListResultIterator
type AFDDomainListResultPage = original.AFDDomainListResultPage
type AFDDomainProperties = original.AFDDomainProperties
type AFDDomainUpdateParameters = original.AFDDomainUpdateParameters
type AFDDomainUpdatePropertiesParameters = original.AFDDomainUpdatePropertiesParameters
type AFDEndpoint = original.AFDEndpoint
type AFDEndpointListResult = original.AFDEndpointListResult
type AFDEndpointListResultIterator = original.AFDEndpointListResultIterator
type AFDEndpointListResultPage = original.AFDEndpointListResultPage
type AFDEndpointProperties = original.AFDEndpointProperties
type AFDEndpointPropertiesUpdateParameters = original.AFDEndpointPropertiesUpdateParameters
type AFDEndpointUpdateParameters = original.AFDEndpointUpdateParameters
type AFDEndpointsClient = original.AFDEndpointsClient
type AFDEndpointsCreateFuture = original.AFDEndpointsCreateFuture
type AFDEndpointsDeleteFuture = original.AFDEndpointsDeleteFuture
type AFDEndpointsPurgeContentFuture = original.AFDEndpointsPurgeContentFuture
type AFDEndpointsUpdateFuture = original.AFDEndpointsUpdateFuture
type AFDOrigin = original.AFDOrigin
type AFDOriginGroup = original.AFDOriginGroup
type AFDOriginGroupListResult = original.AFDOriginGroupListResult
type AFDOriginGroupListResultIterator = original.AFDOriginGroupListResultIterator
type AFDOriginGroupListResultPage = original.AFDOriginGroupListResultPage
type AFDOriginGroupProperties = original.AFDOriginGroupProperties
type AFDOriginGroupUpdateParameters = original.AFDOriginGroupUpdateParameters
type AFDOriginGroupUpdatePropertiesParameters = original.AFDOriginGroupUpdatePropertiesParameters
type AFDOriginGroupsClient = original.AFDOriginGroupsClient
type AFDOriginGroupsCreateFuture = original.AFDOriginGroupsCreateFuture
type AFDOriginGroupsDeleteFuture = original.AFDOriginGroupsDeleteFuture
type AFDOriginGroupsUpdateFuture = original.AFDOriginGroupsUpdateFuture
type AFDOriginListResult = original.AFDOriginListResult
type AFDOriginListResultIterator = original.AFDOriginListResultIterator
type AFDOriginListResultPage = original.AFDOriginListResultPage
type AFDOriginProperties = original.AFDOriginProperties
type AFDOriginUpdateParameters = original.AFDOriginUpdateParameters
type AFDOriginUpdatePropertiesParameters = original.AFDOriginUpdatePropertiesParameters
type AFDOriginsClient = original.AFDOriginsClient
type AFDOriginsCreateFuture = original.AFDOriginsCreateFuture
type AFDOriginsDeleteFuture = original.AFDOriginsDeleteFuture
type AFDOriginsUpdateFuture = original.AFDOriginsUpdateFuture
type AFDProfilesClient = original.AFDProfilesClient
type AFDStateProperties = original.AFDStateProperties
type ActivatedResourceReference = original.ActivatedResourceReference
type AfdErrorResponse = original.AfdErrorResponse
type AfdPurgeParameters = original.AfdPurgeParameters
type AfdRouteCacheConfiguration = original.AfdRouteCacheConfiguration
type AzureFirstPartyManagedCertificate = original.AzureFirstPartyManagedCertificate
type AzureFirstPartyManagedCertificateParameters = original.AzureFirstPartyManagedCertificateParameters
type BaseClient = original.BaseClient
type BasicCustomDomainHTTPSParameters = original.BasicCustomDomainHTTPSParameters
type BasicDeliveryRuleAction = original.BasicDeliveryRuleAction
type BasicDeliveryRuleCondition = original.BasicDeliveryRuleCondition
type BasicSecretParameters = original.BasicSecretParameters
type BasicSecurityPolicyPropertiesParameters = original.BasicSecurityPolicyPropertiesParameters
type CacheConfiguration = original.CacheConfiguration
type CacheExpirationActionParameters = original.CacheExpirationActionParameters
type CacheKeyQueryStringActionParameters = original.CacheKeyQueryStringActionParameters
type Certificate = original.Certificate
type CertificateSourceParameters = original.CertificateSourceParameters
type CheckEndpointNameAvailabilityInput = original.CheckEndpointNameAvailabilityInput
type CheckEndpointNameAvailabilityOutput = original.CheckEndpointNameAvailabilityOutput
type CheckHostNameAvailabilityInput = original.CheckHostNameAvailabilityInput
type CheckNameAvailabilityInput = original.CheckNameAvailabilityInput
type CheckNameAvailabilityOutput = original.CheckNameAvailabilityOutput
type CidrIPAddress = original.CidrIPAddress
type ClientPortMatchConditionParameters = original.ClientPortMatchConditionParameters
type CompressionSettings = original.CompressionSettings
type ContinentsResponse = original.ContinentsResponse
type ContinentsResponseContinentsItem = original.ContinentsResponseContinentsItem
type ContinentsResponseCountryOrRegionsItem = original.ContinentsResponseCountryOrRegionsItem
type CookiesMatchConditionParameters = original.CookiesMatchConditionParameters
type CustomDomain = original.CustomDomain
type CustomDomainHTTPSParameters = original.CustomDomainHTTPSParameters
type CustomDomainListResult = original.CustomDomainListResult
type CustomDomainListResultIterator = original.CustomDomainListResultIterator
type CustomDomainListResultPage = original.CustomDomainListResultPage
type CustomDomainParameters = original.CustomDomainParameters
type CustomDomainProperties = original.CustomDomainProperties
type CustomDomainPropertiesParameters = original.CustomDomainPropertiesParameters
type CustomDomainsClient = original.CustomDomainsClient
type CustomDomainsCreateFuture = original.CustomDomainsCreateFuture
type CustomDomainsDeleteFuture = original.CustomDomainsDeleteFuture
type CustomRule = original.CustomRule
type CustomRuleList = original.CustomRuleList
type CustomerCertificate = original.CustomerCertificate
type CustomerCertificateParameters = original.CustomerCertificateParameters
type DeepCreatedOrigin = original.DeepCreatedOrigin
type DeepCreatedOriginGroup = original.DeepCreatedOriginGroup
type DeepCreatedOriginGroupProperties = original.DeepCreatedOriginGroupProperties
type DeepCreatedOriginProperties = original.DeepCreatedOriginProperties
type DeliveryRule = original.DeliveryRule
type DeliveryRuleAction = original.DeliveryRuleAction
type DeliveryRuleCacheExpirationAction = original.DeliveryRuleCacheExpirationAction
type DeliveryRuleCacheKeyQueryStringAction = original.DeliveryRuleCacheKeyQueryStringAction
type DeliveryRuleClientPortCondition = original.DeliveryRuleClientPortCondition
type DeliveryRuleCondition = original.DeliveryRuleCondition
type DeliveryRuleCookiesCondition = original.DeliveryRuleCookiesCondition
type DeliveryRuleHTTPVersionCondition = original.DeliveryRuleHTTPVersionCondition
type DeliveryRuleHostNameCondition = original.DeliveryRuleHostNameCondition
type DeliveryRuleIsDeviceCondition = original.DeliveryRuleIsDeviceCondition
type DeliveryRulePostArgsCondition = original.DeliveryRulePostArgsCondition
type DeliveryRuleQueryStringCondition = original.DeliveryRuleQueryStringCondition
type DeliveryRuleRemoteAddressCondition = original.DeliveryRuleRemoteAddressCondition
type DeliveryRuleRequestBodyCondition = original.DeliveryRuleRequestBodyCondition
type DeliveryRuleRequestHeaderAction = original.DeliveryRuleRequestHeaderAction
type DeliveryRuleRequestHeaderCondition = original.DeliveryRuleRequestHeaderCondition
type DeliveryRuleRequestMethodCondition = original.DeliveryRuleRequestMethodCondition
type DeliveryRuleRequestSchemeCondition = original.DeliveryRuleRequestSchemeCondition
type DeliveryRuleRequestURICondition = original.DeliveryRuleRequestURICondition
type DeliveryRuleResponseHeaderAction = original.DeliveryRuleResponseHeaderAction
type DeliveryRuleRouteConfigurationOverrideAction = original.DeliveryRuleRouteConfigurationOverrideAction
type DeliveryRuleServerPortCondition = original.DeliveryRuleServerPortCondition
type DeliveryRuleSocketAddrCondition = original.DeliveryRuleSocketAddrCondition
type DeliveryRuleSslProtocolCondition = original.DeliveryRuleSslProtocolCondition
type DeliveryRuleURLFileExtensionCondition = original.DeliveryRuleURLFileExtensionCondition
type DeliveryRuleURLFileNameCondition = original.DeliveryRuleURLFileNameCondition
type DeliveryRuleURLPathCondition = original.DeliveryRuleURLPathCondition
type DimensionProperties = original.DimensionProperties
type DomainValidationProperties = original.DomainValidationProperties
type EdgeNode = original.EdgeNode
type EdgeNodeProperties = original.EdgeNodeProperties
type EdgeNodesClient = original.EdgeNodesClient
type EdgenodeResult = original.EdgenodeResult
type EdgenodeResultIterator = original.EdgenodeResultIterator
type EdgenodeResultPage = original.EdgenodeResultPage
type Endpoint = original.Endpoint
type EndpointListResult = original.EndpointListResult
type EndpointListResultIterator = original.EndpointListResultIterator
type EndpointListResultPage = original.EndpointListResultPage
type EndpointProperties = original.EndpointProperties
type EndpointPropertiesUpdateParameters = original.EndpointPropertiesUpdateParameters
type EndpointPropertiesUpdateParametersDeliveryPolicy = original.EndpointPropertiesUpdateParametersDeliveryPolicy
type EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink = original.EndpointPropertiesUpdateParametersWebApplicationFirewallPolicyLink
type EndpointType = original.EndpointType
type EndpointUpdateParameters = original.EndpointUpdateParameters
type EndpointsClient = original.EndpointsClient
type EndpointsCreateFuture = original.EndpointsCreateFuture
type EndpointsDeleteFuture = original.EndpointsDeleteFuture
type EndpointsLoadContentFuture = original.EndpointsLoadContentFuture
type EndpointsPurgeContentFuture = original.EndpointsPurgeContentFuture
type EndpointsStartFuture = original.EndpointsStartFuture
type EndpointsStopFuture = original.EndpointsStopFuture
type EndpointsUpdateFuture = original.EndpointsUpdateFuture
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type GeoFilter = original.GeoFilter
type HTTPErrorRangeParameters = original.HTTPErrorRangeParameters
type HTTPVersionMatchConditionParameters = original.HTTPVersionMatchConditionParameters
type HeaderActionParameters = original.HeaderActionParameters
type HealthProbeParameters = original.HealthProbeParameters
type HostNameMatchConditionParameters = original.HostNameMatchConditionParameters
type IPAddressGroup = original.IPAddressGroup
type IsDeviceMatchConditionParameters = original.IsDeviceMatchConditionParameters
type KeyVaultCertificateSourceParameters = original.KeyVaultCertificateSourceParameters
type KeyVaultSigningKeyParameters = original.KeyVaultSigningKeyParameters
type LoadBalancingSettingsParameters = original.LoadBalancingSettingsParameters
type LoadParameters = original.LoadParameters
type LogAnalyticsClient = original.LogAnalyticsClient
type LogSpecification = original.LogSpecification
type ManagedCertificate = original.ManagedCertificate
type ManagedCertificateParameters = original.ManagedCertificateParameters
type ManagedHTTPSParameters = original.ManagedHTTPSParameters
type ManagedRuleDefinition = original.ManagedRuleDefinition
type ManagedRuleGroupDefinition = original.ManagedRuleGroupDefinition
type ManagedRuleGroupOverride = original.ManagedRuleGroupOverride
type ManagedRuleOverride = original.ManagedRuleOverride
type ManagedRuleSet = original.ManagedRuleSet
type ManagedRuleSetDefinition = original.ManagedRuleSetDefinition
type ManagedRuleSetDefinitionList = original.ManagedRuleSetDefinitionList
type ManagedRuleSetDefinitionListIterator = original.ManagedRuleSetDefinitionListIterator
type ManagedRuleSetDefinitionListPage = original.ManagedRuleSetDefinitionListPage
type ManagedRuleSetDefinitionProperties = original.ManagedRuleSetDefinitionProperties
type ManagedRuleSetList = original.ManagedRuleSetList
type ManagedRuleSetsClient = original.ManagedRuleSetsClient
type MatchCondition = original.MatchCondition
type MetricAvailability = original.MetricAvailability
type MetricSpecification = original.MetricSpecification
type MetricsResponse = original.MetricsResponse
type MetricsResponseSeriesItem = original.MetricsResponseSeriesItem
type MetricsResponseSeriesItemDataItem = original.MetricsResponseSeriesItemDataItem
type MetricsResponseSeriesItemGroupsItem = original.MetricsResponseSeriesItemGroupsItem
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type OperationsListResult = original.OperationsListResult
type OperationsListResultIterator = original.OperationsListResultIterator
type OperationsListResultPage = original.OperationsListResultPage
type Origin = original.Origin
type OriginGroup = original.OriginGroup
type OriginGroupListResult = original.OriginGroupListResult
type OriginGroupListResultIterator = original.OriginGroupListResultIterator
type OriginGroupListResultPage = original.OriginGroupListResultPage
type OriginGroupOverride = original.OriginGroupOverride
type OriginGroupOverrideAction = original.OriginGroupOverrideAction
type OriginGroupOverrideActionParameters = original.OriginGroupOverrideActionParameters
type OriginGroupProperties = original.OriginGroupProperties
type OriginGroupUpdateParameters = original.OriginGroupUpdateParameters
type OriginGroupUpdatePropertiesParameters = original.OriginGroupUpdatePropertiesParameters
type OriginGroupsClient = original.OriginGroupsClient
type OriginGroupsCreateFuture = original.OriginGroupsCreateFuture
type OriginGroupsDeleteFuture = original.OriginGroupsDeleteFuture
type OriginGroupsUpdateFuture = original.OriginGroupsUpdateFuture
type OriginListResult = original.OriginListResult
type OriginListResultIterator = original.OriginListResultIterator
type OriginListResultPage = original.OriginListResultPage
type OriginProperties = original.OriginProperties
type OriginUpdateParameters = original.OriginUpdateParameters
type OriginUpdatePropertiesParameters = original.OriginUpdatePropertiesParameters
type OriginsClient = original.OriginsClient
type OriginsCreateFuture = original.OriginsCreateFuture
type OriginsDeleteFuture = original.OriginsDeleteFuture
type OriginsUpdateFuture = original.OriginsUpdateFuture
type PoliciesClient = original.PoliciesClient
type PoliciesCreateOrUpdateFuture = original.PoliciesCreateOrUpdateFuture
type PoliciesUpdateFuture = original.PoliciesUpdateFuture
type PolicySettings = original.PolicySettings
type PostArgsMatchConditionParameters = original.PostArgsMatchConditionParameters
type Profile = original.Profile
type ProfileListResult = original.ProfileListResult
type ProfileListResultIterator = original.ProfileListResultIterator
type ProfileListResultPage = original.ProfileListResultPage
type ProfileProperties = original.ProfileProperties
type ProfilePropertiesUpdateParameters = original.ProfilePropertiesUpdateParameters
type ProfileUpdateParameters = original.ProfileUpdateParameters
type ProfilesClient = original.ProfilesClient
type ProfilesCreateFuture = original.ProfilesCreateFuture
type ProfilesDeleteFuture = original.ProfilesDeleteFuture
type ProfilesUpdateFuture = original.ProfilesUpdateFuture
type ProxyResource = original.ProxyResource
type PurgeParameters = original.PurgeParameters
type QueryStringMatchConditionParameters = original.QueryStringMatchConditionParameters
type RankingsResponse = original.RankingsResponse
type RankingsResponseTablesItem = original.RankingsResponseTablesItem
type RankingsResponseTablesItemDataItem = original.RankingsResponseTablesItemDataItem
type RankingsResponseTablesItemDataItemMetricsItem = original.RankingsResponseTablesItemDataItemMetricsItem
type RateLimitRule = original.RateLimitRule
type RateLimitRuleList = original.RateLimitRuleList
type RemoteAddressMatchConditionParameters = original.RemoteAddressMatchConditionParameters
type RequestBodyMatchConditionParameters = original.RequestBodyMatchConditionParameters
type RequestHeaderMatchConditionParameters = original.RequestHeaderMatchConditionParameters
type RequestMethodMatchConditionParameters = original.RequestMethodMatchConditionParameters
type RequestSchemeMatchConditionParameters = original.RequestSchemeMatchConditionParameters
type RequestURIMatchConditionParameters = original.RequestURIMatchConditionParameters
type Resource = original.Resource
type ResourceReference = original.ResourceReference
type ResourceUsage = original.ResourceUsage
type ResourceUsageClient = original.ResourceUsageClient
type ResourceUsageListResult = original.ResourceUsageListResult
type ResourceUsageListResultIterator = original.ResourceUsageListResultIterator
type ResourceUsageListResultPage = original.ResourceUsageListResultPage
type ResourcesResponse = original.ResourcesResponse
type ResourcesResponseCustomDomainsItem = original.ResourcesResponseCustomDomainsItem
type ResourcesResponseEndpointsItem = original.ResourcesResponseEndpointsItem
type ResourcesResponseEndpointsItemCustomDomainsItem = original.ResourcesResponseEndpointsItemCustomDomainsItem
type ResponseBasedOriginErrorDetectionParameters = original.ResponseBasedOriginErrorDetectionParameters
type Route = original.Route
type RouteConfigurationOverrideActionParameters = original.RouteConfigurationOverrideActionParameters
type RouteListResult = original.RouteListResult
type RouteListResultIterator = original.RouteListResultIterator
type RouteListResultPage = original.RouteListResultPage
type RouteProperties = original.RouteProperties
type RouteUpdateParameters = original.RouteUpdateParameters
type RouteUpdatePropertiesParameters = original.RouteUpdatePropertiesParameters
type RoutesClient = original.RoutesClient
type RoutesCreateFuture = original.RoutesCreateFuture
type RoutesDeleteFuture = original.RoutesDeleteFuture
type RoutesUpdateFuture = original.RoutesUpdateFuture
type Rule = original.Rule
type RuleListResult = original.RuleListResult
type RuleListResultIterator = original.RuleListResultIterator
type RuleListResultPage = original.RuleListResultPage
type RuleProperties = original.RuleProperties
type RuleSet = original.RuleSet
type RuleSetListResult = original.RuleSetListResult
type RuleSetListResultIterator = original.RuleSetListResultIterator
type RuleSetListResultPage = original.RuleSetListResultPage
type RuleSetProperties = original.RuleSetProperties
type RuleSetsClient = original.RuleSetsClient
type RuleSetsDeleteFuture = original.RuleSetsDeleteFuture
type RuleUpdateParameters = original.RuleUpdateParameters
type RuleUpdatePropertiesParameters = original.RuleUpdatePropertiesParameters
type RulesClient = original.RulesClient
type RulesCreateFuture = original.RulesCreateFuture
type RulesDeleteFuture = original.RulesDeleteFuture
type RulesUpdateFuture = original.RulesUpdateFuture
type Secret = original.Secret
type SecretListResult = original.SecretListResult
type SecretListResultIterator = original.SecretListResultIterator
type SecretListResultPage = original.SecretListResultPage
type SecretParameters = original.SecretParameters
type SecretProperties = original.SecretProperties
type SecretsClient = original.SecretsClient
type SecretsCreateFuture = original.SecretsCreateFuture
type SecretsDeleteFuture = original.SecretsDeleteFuture
type SecurityPoliciesClient = original.SecurityPoliciesClient
type SecurityPoliciesCreateFuture = original.SecurityPoliciesCreateFuture
type SecurityPoliciesDeleteFuture = original.SecurityPoliciesDeleteFuture
type SecurityPoliciesPatchFuture = original.SecurityPoliciesPatchFuture
type SecurityPolicy = original.SecurityPolicy
type SecurityPolicyListResult = original.SecurityPolicyListResult
type SecurityPolicyListResultIterator = original.SecurityPolicyListResultIterator
type SecurityPolicyListResultPage = original.SecurityPolicyListResultPage
type SecurityPolicyProperties = original.SecurityPolicyProperties
type SecurityPolicyPropertiesParameters = original.SecurityPolicyPropertiesParameters
type SecurityPolicyUpdateParameters = original.SecurityPolicyUpdateParameters
type SecurityPolicyUpdateProperties = original.SecurityPolicyUpdateProperties
type SecurityPolicyWebApplicationFirewallAssociation = original.SecurityPolicyWebApplicationFirewallAssociation
type SecurityPolicyWebApplicationFirewallParameters = original.SecurityPolicyWebApplicationFirewallParameters
type ServerPortMatchConditionParameters = original.ServerPortMatchConditionParameters
type ServiceSpecification = original.ServiceSpecification
type SharedPrivateLinkResourceProperties = original.SharedPrivateLinkResourceProperties
type Sku = original.Sku
type SocketAddrMatchConditionParameters = original.SocketAddrMatchConditionParameters
type SslProtocolMatchConditionParameters = original.SslProtocolMatchConditionParameters
type SsoURI = original.SsoURI
type SupportedOptimizationTypesListResult = original.SupportedOptimizationTypesListResult
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource
type URLFileExtensionMatchConditionParameters = original.URLFileExtensionMatchConditionParameters
type URLFileNameMatchConditionParameters = original.URLFileNameMatchConditionParameters
type URLPathMatchConditionParameters = original.URLPathMatchConditionParameters
type URLRedirectAction = original.URLRedirectAction
type URLRedirectActionParameters = original.URLRedirectActionParameters
type URLRewriteAction = original.URLRewriteAction
type URLRewriteActionParameters = original.URLRewriteActionParameters
type URLSigningAction = original.URLSigningAction
type URLSigningActionParameters = original.URLSigningActionParameters
type URLSigningKey = original.URLSigningKey
type URLSigningKeyParameters = original.URLSigningKeyParameters
type URLSigningParamIdentifier = original.URLSigningParamIdentifier
type Usage = original.Usage
type UsageName = original.UsageName
type UsagesListResult = original.UsagesListResult
type UsagesListResultIterator = original.UsagesListResultIterator
type UsagesListResultPage = original.UsagesListResultPage
type UserManagedHTTPSParameters = original.UserManagedHTTPSParameters
type ValidateClient = original.ValidateClient
type ValidateCustomDomainInput = original.ValidateCustomDomainInput
type ValidateCustomDomainOutput = original.ValidateCustomDomainOutput
type ValidateProbeInput = original.ValidateProbeInput
type ValidateProbeOutput = original.ValidateProbeOutput
type ValidateSecretInput = original.ValidateSecretInput
type ValidateSecretOutput = original.ValidateSecretOutput
type ValidationToken = original.ValidationToken
type WafMetricsResponse = original.WafMetricsResponse
type WafMetricsResponseSeriesItem = original.WafMetricsResponseSeriesItem
type WafMetricsResponseSeriesItemDataItem = original.WafMetricsResponseSeriesItemDataItem
type WafMetricsResponseSeriesItemGroupsItem = original.WafMetricsResponseSeriesItemGroupsItem
type WafRankingsResponse = original.WafRankingsResponse
type WafRankingsResponseDataItem = original.WafRankingsResponseDataItem
type WafRankingsResponseDataItemMetricsItem = original.WafRankingsResponseDataItemMetricsItem
type WebApplicationFirewallPolicy = original.WebApplicationFirewallPolicy
type WebApplicationFirewallPolicyList = original.WebApplicationFirewallPolicyList
type WebApplicationFirewallPolicyListIterator = original.WebApplicationFirewallPolicyListIterator
type WebApplicationFirewallPolicyListPage = original.WebApplicationFirewallPolicyListPage
type WebApplicationFirewallPolicyPatchParameters = original.WebApplicationFirewallPolicyPatchParameters
type WebApplicationFirewallPolicyProperties = original.WebApplicationFirewallPolicyProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAFDCustomDomainsClient(subscriptionID string) AFDCustomDomainsClient {
	return original.NewAFDCustomDomainsClient(subscriptionID)
}
func NewAFDCustomDomainsClientWithBaseURI(baseURI string, subscriptionID string) AFDCustomDomainsClient {
	return original.NewAFDCustomDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAFDDomainListResultIterator(page AFDDomainListResultPage) AFDDomainListResultIterator {
	return original.NewAFDDomainListResultIterator(page)
}
func NewAFDDomainListResultPage(cur AFDDomainListResult, getNextPage func(context.Context, AFDDomainListResult) (AFDDomainListResult, error)) AFDDomainListResultPage {
	return original.NewAFDDomainListResultPage(cur, getNextPage)
}
func NewAFDEndpointListResultIterator(page AFDEndpointListResultPage) AFDEndpointListResultIterator {
	return original.NewAFDEndpointListResultIterator(page)
}
func NewAFDEndpointListResultPage(cur AFDEndpointListResult, getNextPage func(context.Context, AFDEndpointListResult) (AFDEndpointListResult, error)) AFDEndpointListResultPage {
	return original.NewAFDEndpointListResultPage(cur, getNextPage)
}
func NewAFDEndpointsClient(subscriptionID string) AFDEndpointsClient {
	return original.NewAFDEndpointsClient(subscriptionID)
}
func NewAFDEndpointsClientWithBaseURI(baseURI string, subscriptionID string) AFDEndpointsClient {
	return original.NewAFDEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAFDOriginGroupListResultIterator(page AFDOriginGroupListResultPage) AFDOriginGroupListResultIterator {
	return original.NewAFDOriginGroupListResultIterator(page)
}
func NewAFDOriginGroupListResultPage(cur AFDOriginGroupListResult, getNextPage func(context.Context, AFDOriginGroupListResult) (AFDOriginGroupListResult, error)) AFDOriginGroupListResultPage {
	return original.NewAFDOriginGroupListResultPage(cur, getNextPage)
}
func NewAFDOriginGroupsClient(subscriptionID string) AFDOriginGroupsClient {
	return original.NewAFDOriginGroupsClient(subscriptionID)
}
func NewAFDOriginGroupsClientWithBaseURI(baseURI string, subscriptionID string) AFDOriginGroupsClient {
	return original.NewAFDOriginGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAFDOriginListResultIterator(page AFDOriginListResultPage) AFDOriginListResultIterator {
	return original.NewAFDOriginListResultIterator(page)
}
func NewAFDOriginListResultPage(cur AFDOriginListResult, getNextPage func(context.Context, AFDOriginListResult) (AFDOriginListResult, error)) AFDOriginListResultPage {
	return original.NewAFDOriginListResultPage(cur, getNextPage)
}
func NewAFDOriginsClient(subscriptionID string) AFDOriginsClient {
	return original.NewAFDOriginsClient(subscriptionID)
}
func NewAFDOriginsClientWithBaseURI(baseURI string, subscriptionID string) AFDOriginsClient {
	return original.NewAFDOriginsClientWithBaseURI(baseURI, subscriptionID)
}
func NewAFDProfilesClient(subscriptionID string) AFDProfilesClient {
	return original.NewAFDProfilesClient(subscriptionID)
}
func NewAFDProfilesClientWithBaseURI(baseURI string, subscriptionID string) AFDProfilesClient {
	return original.NewAFDProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCustomDomainListResultIterator(page CustomDomainListResultPage) CustomDomainListResultIterator {
	return original.NewCustomDomainListResultIterator(page)
}
func NewCustomDomainListResultPage(cur CustomDomainListResult, getNextPage func(context.Context, CustomDomainListResult) (CustomDomainListResult, error)) CustomDomainListResultPage {
	return original.NewCustomDomainListResultPage(cur, getNextPage)
}
func NewCustomDomainsClient(subscriptionID string) CustomDomainsClient {
	return original.NewCustomDomainsClient(subscriptionID)
}
func NewCustomDomainsClientWithBaseURI(baseURI string, subscriptionID string) CustomDomainsClient {
	return original.NewCustomDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEdgeNodesClient(subscriptionID string) EdgeNodesClient {
	return original.NewEdgeNodesClient(subscriptionID)
}
func NewEdgeNodesClientWithBaseURI(baseURI string, subscriptionID string) EdgeNodesClient {
	return original.NewEdgeNodesClientWithBaseURI(baseURI, subscriptionID)
}
func NewEdgenodeResultIterator(page EdgenodeResultPage) EdgenodeResultIterator {
	return original.NewEdgenodeResultIterator(page)
}
func NewEdgenodeResultPage(cur EdgenodeResult, getNextPage func(context.Context, EdgenodeResult) (EdgenodeResult, error)) EdgenodeResultPage {
	return original.NewEdgenodeResultPage(cur, getNextPage)
}
func NewEndpointListResultIterator(page EndpointListResultPage) EndpointListResultIterator {
	return original.NewEndpointListResultIterator(page)
}
func NewEndpointListResultPage(cur EndpointListResult, getNextPage func(context.Context, EndpointListResult) (EndpointListResult, error)) EndpointListResultPage {
	return original.NewEndpointListResultPage(cur, getNextPage)
}
func NewEndpointsClient(subscriptionID string) EndpointsClient {
	return original.NewEndpointsClient(subscriptionID)
}
func NewEndpointsClientWithBaseURI(baseURI string, subscriptionID string) EndpointsClient {
	return original.NewEndpointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewLogAnalyticsClient(subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClient(subscriptionID)
}
func NewLogAnalyticsClientWithBaseURI(baseURI string, subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewManagedRuleSetDefinitionListIterator(page ManagedRuleSetDefinitionListPage) ManagedRuleSetDefinitionListIterator {
	return original.NewManagedRuleSetDefinitionListIterator(page)
}
func NewManagedRuleSetDefinitionListPage(cur ManagedRuleSetDefinitionList, getNextPage func(context.Context, ManagedRuleSetDefinitionList) (ManagedRuleSetDefinitionList, error)) ManagedRuleSetDefinitionListPage {
	return original.NewManagedRuleSetDefinitionListPage(cur, getNextPage)
}
func NewManagedRuleSetsClient(subscriptionID string) ManagedRuleSetsClient {
	return original.NewManagedRuleSetsClient(subscriptionID)
}
func NewManagedRuleSetsClientWithBaseURI(baseURI string, subscriptionID string) ManagedRuleSetsClient {
	return original.NewManagedRuleSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsListResultIterator(page OperationsListResultPage) OperationsListResultIterator {
	return original.NewOperationsListResultIterator(page)
}
func NewOperationsListResultPage(cur OperationsListResult, getNextPage func(context.Context, OperationsListResult) (OperationsListResult, error)) OperationsListResultPage {
	return original.NewOperationsListResultPage(cur, getNextPage)
}
func NewOriginGroupListResultIterator(page OriginGroupListResultPage) OriginGroupListResultIterator {
	return original.NewOriginGroupListResultIterator(page)
}
func NewOriginGroupListResultPage(cur OriginGroupListResult, getNextPage func(context.Context, OriginGroupListResult) (OriginGroupListResult, error)) OriginGroupListResultPage {
	return original.NewOriginGroupListResultPage(cur, getNextPage)
}
func NewOriginGroupsClient(subscriptionID string) OriginGroupsClient {
	return original.NewOriginGroupsClient(subscriptionID)
}
func NewOriginGroupsClientWithBaseURI(baseURI string, subscriptionID string) OriginGroupsClient {
	return original.NewOriginGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOriginListResultIterator(page OriginListResultPage) OriginListResultIterator {
	return original.NewOriginListResultIterator(page)
}
func NewOriginListResultPage(cur OriginListResult, getNextPage func(context.Context, OriginListResult) (OriginListResult, error)) OriginListResultPage {
	return original.NewOriginListResultPage(cur, getNextPage)
}
func NewOriginsClient(subscriptionID string) OriginsClient {
	return original.NewOriginsClient(subscriptionID)
}
func NewOriginsClientWithBaseURI(baseURI string, subscriptionID string) OriginsClient {
	return original.NewOriginsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPoliciesClient(subscriptionID string) PoliciesClient {
	return original.NewPoliciesClient(subscriptionID)
}
func NewPoliciesClientWithBaseURI(baseURI string, subscriptionID string) PoliciesClient {
	return original.NewPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewProfileListResultIterator(page ProfileListResultPage) ProfileListResultIterator {
	return original.NewProfileListResultIterator(page)
}
func NewProfileListResultPage(cur ProfileListResult, getNextPage func(context.Context, ProfileListResult) (ProfileListResult, error)) ProfileListResultPage {
	return original.NewProfileListResultPage(cur, getNextPage)
}
func NewProfilesClient(subscriptionID string) ProfilesClient {
	return original.NewProfilesClient(subscriptionID)
}
func NewProfilesClientWithBaseURI(baseURI string, subscriptionID string) ProfilesClient {
	return original.NewProfilesClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceUsageClient(subscriptionID string) ResourceUsageClient {
	return original.NewResourceUsageClient(subscriptionID)
}
func NewResourceUsageClientWithBaseURI(baseURI string, subscriptionID string) ResourceUsageClient {
	return original.NewResourceUsageClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceUsageListResultIterator(page ResourceUsageListResultPage) ResourceUsageListResultIterator {
	return original.NewResourceUsageListResultIterator(page)
}
func NewResourceUsageListResultPage(cur ResourceUsageListResult, getNextPage func(context.Context, ResourceUsageListResult) (ResourceUsageListResult, error)) ResourceUsageListResultPage {
	return original.NewResourceUsageListResultPage(cur, getNextPage)
}
func NewRouteListResultIterator(page RouteListResultPage) RouteListResultIterator {
	return original.NewRouteListResultIterator(page)
}
func NewRouteListResultPage(cur RouteListResult, getNextPage func(context.Context, RouteListResult) (RouteListResult, error)) RouteListResultPage {
	return original.NewRouteListResultPage(cur, getNextPage)
}
func NewRoutesClient(subscriptionID string) RoutesClient {
	return original.NewRoutesClient(subscriptionID)
}
func NewRoutesClientWithBaseURI(baseURI string, subscriptionID string) RoutesClient {
	return original.NewRoutesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRuleListResultIterator(page RuleListResultPage) RuleListResultIterator {
	return original.NewRuleListResultIterator(page)
}
func NewRuleListResultPage(cur RuleListResult, getNextPage func(context.Context, RuleListResult) (RuleListResult, error)) RuleListResultPage {
	return original.NewRuleListResultPage(cur, getNextPage)
}
func NewRuleSetListResultIterator(page RuleSetListResultPage) RuleSetListResultIterator {
	return original.NewRuleSetListResultIterator(page)
}
func NewRuleSetListResultPage(cur RuleSetListResult, getNextPage func(context.Context, RuleSetListResult) (RuleSetListResult, error)) RuleSetListResultPage {
	return original.NewRuleSetListResultPage(cur, getNextPage)
}
func NewRuleSetsClient(subscriptionID string) RuleSetsClient {
	return original.NewRuleSetsClient(subscriptionID)
}
func NewRuleSetsClientWithBaseURI(baseURI string, subscriptionID string) RuleSetsClient {
	return original.NewRuleSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRulesClient(subscriptionID string) RulesClient {
	return original.NewRulesClient(subscriptionID)
}
func NewRulesClientWithBaseURI(baseURI string, subscriptionID string) RulesClient {
	return original.NewRulesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecretListResultIterator(page SecretListResultPage) SecretListResultIterator {
	return original.NewSecretListResultIterator(page)
}
func NewSecretListResultPage(cur SecretListResult, getNextPage func(context.Context, SecretListResult) (SecretListResult, error)) SecretListResultPage {
	return original.NewSecretListResultPage(cur, getNextPage)
}
func NewSecretsClient(subscriptionID string) SecretsClient {
	return original.NewSecretsClient(subscriptionID)
}
func NewSecretsClientWithBaseURI(baseURI string, subscriptionID string) SecretsClient {
	return original.NewSecretsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityPoliciesClient(subscriptionID string) SecurityPoliciesClient {
	return original.NewSecurityPoliciesClient(subscriptionID)
}
func NewSecurityPoliciesClientWithBaseURI(baseURI string, subscriptionID string) SecurityPoliciesClient {
	return original.NewSecurityPoliciesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSecurityPolicyListResultIterator(page SecurityPolicyListResultPage) SecurityPolicyListResultIterator {
	return original.NewSecurityPolicyListResultIterator(page)
}
func NewSecurityPolicyListResultPage(cur SecurityPolicyListResult, getNextPage func(context.Context, SecurityPolicyListResult) (SecurityPolicyListResult, error)) SecurityPolicyListResultPage {
	return original.NewSecurityPolicyListResultPage(cur, getNextPage)
}
func NewUsagesListResultIterator(page UsagesListResultPage) UsagesListResultIterator {
	return original.NewUsagesListResultIterator(page)
}
func NewUsagesListResultPage(cur UsagesListResult, getNextPage func(context.Context, UsagesListResult) (UsagesListResult, error)) UsagesListResultPage {
	return original.NewUsagesListResultPage(cur, getNextPage)
}
func NewValidateClient(subscriptionID string) ValidateClient {
	return original.NewValidateClient(subscriptionID)
}
func NewValidateClientWithBaseURI(baseURI string, subscriptionID string) ValidateClient {
	return original.NewValidateClientWithBaseURI(baseURI, subscriptionID)
}
func NewWebApplicationFirewallPolicyListIterator(page WebApplicationFirewallPolicyListPage) WebApplicationFirewallPolicyListIterator {
	return original.NewWebApplicationFirewallPolicyListIterator(page)
}
func NewWebApplicationFirewallPolicyListPage(cur WebApplicationFirewallPolicyList, getNextPage func(context.Context, WebApplicationFirewallPolicyList) (WebApplicationFirewallPolicyList, error)) WebApplicationFirewallPolicyListPage {
	return original.NewWebApplicationFirewallPolicyListPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAFDEndpointProtocolsValues() []AFDEndpointProtocols {
	return original.PossibleAFDEndpointProtocolsValues()
}
func PossibleActionTypeValues() []ActionType {
	return original.PossibleActionTypeValues()
}
func PossibleAfdCertificateTypeValues() []AfdCertificateType {
	return original.PossibleAfdCertificateTypeValues()
}
func PossibleAfdMinimumTLSVersionValues() []AfdMinimumTLSVersion {
	return original.PossibleAfdMinimumTLSVersionValues()
}
func PossibleAfdProvisioningStateValues() []AfdProvisioningState {
	return original.PossibleAfdProvisioningStateValues()
}
func PossibleAfdQueryStringCachingBehaviorValues() []AfdQueryStringCachingBehavior {
	return original.PossibleAfdQueryStringCachingBehaviorValues()
}
func PossibleAlgorithmValues() []Algorithm {
	return original.PossibleAlgorithmValues()
}
func PossibleAutoGeneratedDomainNameLabelScopeValues() []AutoGeneratedDomainNameLabelScope {
	return original.PossibleAutoGeneratedDomainNameLabelScopeValues()
}
func PossibleCacheBehaviorValues() []CacheBehavior {
	return original.PossibleCacheBehaviorValues()
}
func PossibleCertificateSourceValues() []CertificateSource {
	return original.PossibleCertificateSourceValues()
}
func PossibleCertificateTypeValues() []CertificateType {
	return original.PossibleCertificateTypeValues()
}
func PossibleClientPortOperatorValues() []ClientPortOperator {
	return original.PossibleClientPortOperatorValues()
}
func PossibleCookiesOperatorValues() []CookiesOperator {
	return original.PossibleCookiesOperatorValues()
}
func PossibleCustomDomainResourceStateValues() []CustomDomainResourceState {
	return original.PossibleCustomDomainResourceStateValues()
}
func PossibleCustomHTTPSProvisioningStateValues() []CustomHTTPSProvisioningState {
	return original.PossibleCustomHTTPSProvisioningStateValues()
}
func PossibleCustomHTTPSProvisioningSubstateValues() []CustomHTTPSProvisioningSubstate {
	return original.PossibleCustomHTTPSProvisioningSubstateValues()
}
func PossibleCustomRuleEnabledStateValues() []CustomRuleEnabledState {
	return original.PossibleCustomRuleEnabledStateValues()
}
func PossibleDeploymentStatusValues() []DeploymentStatus {
	return original.PossibleDeploymentStatusValues()
}
func PossibleDestinationProtocolValues() []DestinationProtocol {
	return original.PossibleDestinationProtocolValues()
}
func PossibleDomainValidationStateValues() []DomainValidationState {
	return original.PossibleDomainValidationStateValues()
}
func PossibleEnabledStateValues() []EnabledState {
	return original.PossibleEnabledStateValues()
}
func PossibleEndpointResourceStateValues() []EndpointResourceState {
	return original.PossibleEndpointResourceStateValues()
}
func PossibleForwardingProtocolValues() []ForwardingProtocol {
	return original.PossibleForwardingProtocolValues()
}
func PossibleGeoFilterActionsValues() []GeoFilterActions {
	return original.PossibleGeoFilterActionsValues()
}
func PossibleGranularity1Values() []Granularity1 {
	return original.PossibleGranularity1Values()
}
func PossibleGranularityValues() []Granularity {
	return original.PossibleGranularityValues()
}
func PossibleHTTPSRedirectValues() []HTTPSRedirect {
	return original.PossibleHTTPSRedirectValues()
}
func PossibleHeaderActionValues() []HeaderAction {
	return original.PossibleHeaderActionValues()
}
func PossibleHealthProbeRequestTypeValues() []HealthProbeRequestType {
	return original.PossibleHealthProbeRequestTypeValues()
}
func PossibleHostNameOperatorValues() []HostNameOperator {
	return original.PossibleHostNameOperatorValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleLinkToDefaultDomainValues() []LinkToDefaultDomain {
	return original.PossibleLinkToDefaultDomainValues()
}
func PossibleLogMetricValues() []LogMetric {
	return original.PossibleLogMetricValues()
}
func PossibleLogMetricsGranularityValues() []LogMetricsGranularity {
	return original.PossibleLogMetricsGranularityValues()
}
func PossibleLogMetricsGroupByValues() []LogMetricsGroupBy {
	return original.PossibleLogMetricsGroupByValues()
}
func PossibleLogRankingMetricValues() []LogRankingMetric {
	return original.PossibleLogRankingMetricValues()
}
func PossibleLogRankingValues() []LogRanking {
	return original.PossibleLogRankingValues()
}
func PossibleManagedRuleEnabledStateValues() []ManagedRuleEnabledState {
	return original.PossibleManagedRuleEnabledStateValues()
}
func PossibleMatchProcessingBehaviorValues() []MatchProcessingBehavior {
	return original.PossibleMatchProcessingBehaviorValues()
}
func PossibleMinimumTLSVersionValues() []MinimumTLSVersion {
	return original.PossibleMinimumTLSVersionValues()
}
func PossibleNameBasicDeliveryRuleActionValues() []NameBasicDeliveryRuleAction {
	return original.PossibleNameBasicDeliveryRuleActionValues()
}
func PossibleNameValues() []Name {
	return original.PossibleNameValues()
}
func PossibleOperatorValues() []Operator {
	return original.PossibleOperatorValues()
}
func PossibleOptimizationTypeValues() []OptimizationType {
	return original.PossibleOptimizationTypeValues()
}
func PossibleOriginGroupResourceStateValues() []OriginGroupResourceState {
	return original.PossibleOriginGroupResourceStateValues()
}
func PossibleOriginResourceStateValues() []OriginResourceState {
	return original.PossibleOriginResourceStateValues()
}
func PossibleParamIndicatorValues() []ParamIndicator {
	return original.PossibleParamIndicatorValues()
}
func PossiblePolicyEnabledStateValues() []PolicyEnabledState {
	return original.PossiblePolicyEnabledStateValues()
}
func PossiblePolicyModeValues() []PolicyMode {
	return original.PossiblePolicyModeValues()
}
func PossiblePolicyResourceStateValues() []PolicyResourceState {
	return original.PossiblePolicyResourceStateValues()
}
func PossiblePostArgsOperatorValues() []PostArgsOperator {
	return original.PossiblePostArgsOperatorValues()
}
func PossiblePrivateEndpointStatusValues() []PrivateEndpointStatus {
	return original.PossiblePrivateEndpointStatusValues()
}
func PossibleProbeProtocolValues() []ProbeProtocol {
	return original.PossibleProbeProtocolValues()
}
func PossibleProfileResourceStateValues() []ProfileResourceState {
	return original.PossibleProfileResourceStateValues()
}
func PossibleProtocolTypeValues() []ProtocolType {
	return original.PossibleProtocolTypeValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleQueryStringBehaviorValues() []QueryStringBehavior {
	return original.PossibleQueryStringBehaviorValues()
}
func PossibleQueryStringCachingBehaviorValues() []QueryStringCachingBehavior {
	return original.PossibleQueryStringCachingBehaviorValues()
}
func PossibleQueryStringOperatorValues() []QueryStringOperator {
	return original.PossibleQueryStringOperatorValues()
}
func PossibleRedirectTypeValues() []RedirectType {
	return original.PossibleRedirectTypeValues()
}
func PossibleRemoteAddressOperatorValues() []RemoteAddressOperator {
	return original.PossibleRemoteAddressOperatorValues()
}
func PossibleRequestBodyOperatorValues() []RequestBodyOperator {
	return original.PossibleRequestBodyOperatorValues()
}
func PossibleRequestHeaderOperatorValues() []RequestHeaderOperator {
	return original.PossibleRequestHeaderOperatorValues()
}
func PossibleRequestURIOperatorValues() []RequestURIOperator {
	return original.PossibleRequestURIOperatorValues()
}
func PossibleResourceTypeValues() []ResourceType {
	return original.PossibleResourceTypeValues()
}
func PossibleResponseBasedDetectedErrorTypesValues() []ResponseBasedDetectedErrorTypes {
	return original.PossibleResponseBasedDetectedErrorTypesValues()
}
func PossibleRuleCacheBehaviorValues() []RuleCacheBehavior {
	return original.PossibleRuleCacheBehaviorValues()
}
func PossibleRuleIsCompressionEnabledValues() []RuleIsCompressionEnabled {
	return original.PossibleRuleIsCompressionEnabledValues()
}
func PossibleRuleQueryStringCachingBehaviorValues() []RuleQueryStringCachingBehavior {
	return original.PossibleRuleQueryStringCachingBehaviorValues()
}
func PossibleSecretTypeValues() []SecretType {
	return original.PossibleSecretTypeValues()
}
func PossibleServerPortOperatorValues() []ServerPortOperator {
	return original.PossibleServerPortOperatorValues()
}
func PossibleSharedPrivateLinkResourceStatusValues() []SharedPrivateLinkResourceStatus {
	return original.PossibleSharedPrivateLinkResourceStatusValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleSocketAddrOperatorValues() []SocketAddrOperator {
	return original.PossibleSocketAddrOperatorValues()
}
func PossibleSslProtocolValues() []SslProtocol {
	return original.PossibleSslProtocolValues()
}
func PossibleStatusValues() []Status {
	return original.PossibleStatusValues()
}
func PossibleTransformTypeValues() []TransformType {
	return original.PossibleTransformTypeValues()
}
func PossibleTransformValues() []Transform {
	return original.PossibleTransformValues()
}
func PossibleTypeBasicSecretParametersValues() []TypeBasicSecretParameters {
	return original.PossibleTypeBasicSecretParametersValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleURLFileExtensionOperatorValues() []URLFileExtensionOperator {
	return original.PossibleURLFileExtensionOperatorValues()
}
func PossibleURLFileNameOperatorValues() []URLFileNameOperator {
	return original.PossibleURLFileNameOperatorValues()
}
func PossibleURLPathOperatorValues() []URLPathOperator {
	return original.PossibleURLPathOperatorValues()
}
func PossibleUnit1Values() []Unit1 {
	return original.PossibleUnit1Values()
}
func PossibleUnitValues() []Unit {
	return original.PossibleUnitValues()
}
func PossibleWafActionValues() []WafAction {
	return original.PossibleWafActionValues()
}
func PossibleWafGranularityValues() []WafGranularity {
	return original.PossibleWafGranularityValues()
}
func PossibleWafMatchVariableValues() []WafMatchVariable {
	return original.PossibleWafMatchVariableValues()
}
func PossibleWafMetricValues() []WafMetric {
	return original.PossibleWafMetricValues()
}
func PossibleWafRankingGroupByValues() []WafRankingGroupBy {
	return original.PossibleWafRankingGroupByValues()
}
func PossibleWafRankingTypeValues() []WafRankingType {
	return original.PossibleWafRankingTypeValues()
}
func PossibleWafRuleTypeValues() []WafRuleType {
	return original.PossibleWafRuleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
