<?php

namespace Faker\Test\Provider\en_ZA;

use Faker\Provider\en_ZA\Company;
use Faker\Provider\en_ZA\Internet;
use Faker\Provider\en_ZA\Person;
use Faker\Test\TestCase;

/**
 * @group legacy
 */
final class InternetTest extends TestCase
{
    public function testEmailIsValid()
    {
        $email = $this->faker->email();
        self::assertNotFalse(filter_var($email, FILTER_VALIDATE_EMAIL));
    }

    protected function getProviders(): iterable
    {
        yield new Person($this->faker);

        yield new Internet($this->faker);

        yield new Company($this->faker);
    }
}
