"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
Copied from https://github.com/louis49/androidtv-remote/blob/main/src/remote/remotemessage.proto
Comments on RemoteKeyCode enum added from https://android.googlesource.com/platform/frameworks/native/+/master/include/android/keycodes.h
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _RemoteKeyCode:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RemoteKeyCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RemoteKeyCode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    KEYCODE_UNKNOWN: _RemoteKeyCode.ValueType  # 0
    """Unknown key code."""
    KEYCODE_SOFT_LEFT: _RemoteKeyCode.ValueType  # 1
    """Soft Left key.
    Usually situated below the display on phones and used as a multi-function
    feature key for selecting a software defined function shown on the bottom left
    of the display.
    """
    KEYCODE_SOFT_RIGHT: _RemoteKeyCode.ValueType  # 2
    """Soft Right key.
    Usually situated below the display on phones and used as a multi-function
    feature key for selecting a software defined function shown on the bottom right
    of the display.
    """
    KEYCODE_HOME: _RemoteKeyCode.ValueType  # 3
    """Home key.
    This key is handled by the framework and is never delivered to applications.
    """
    KEYCODE_BACK: _RemoteKeyCode.ValueType  # 4
    """Back key."""
    KEYCODE_CALL: _RemoteKeyCode.ValueType  # 5
    """Call key."""
    KEYCODE_ENDCALL: _RemoteKeyCode.ValueType  # 6
    """End Call key."""
    KEYCODE_0: _RemoteKeyCode.ValueType  # 7
    """'0' key."""
    KEYCODE_1: _RemoteKeyCode.ValueType  # 8
    """'1' key."""
    KEYCODE_2: _RemoteKeyCode.ValueType  # 9
    """'2' key."""
    KEYCODE_3: _RemoteKeyCode.ValueType  # 10
    """'3' key."""
    KEYCODE_4: _RemoteKeyCode.ValueType  # 11
    """'4' key."""
    KEYCODE_5: _RemoteKeyCode.ValueType  # 12
    """'5' key."""
    KEYCODE_6: _RemoteKeyCode.ValueType  # 13
    """'6' key."""
    KEYCODE_7: _RemoteKeyCode.ValueType  # 14
    """'7' key."""
    KEYCODE_8: _RemoteKeyCode.ValueType  # 15
    """'8' key."""
    KEYCODE_9: _RemoteKeyCode.ValueType  # 16
    """'9' key."""
    KEYCODE_STAR: _RemoteKeyCode.ValueType  # 17
    """'*' key."""
    KEYCODE_POUND: _RemoteKeyCode.ValueType  # 18
    """'#' key."""
    KEYCODE_DPAD_UP: _RemoteKeyCode.ValueType  # 19
    """Directional Pad Up key.
    May also be synthesized from trackball motions.
    """
    KEYCODE_DPAD_DOWN: _RemoteKeyCode.ValueType  # 20
    """Directional Pad Down key.
    May also be synthesized from trackball motions.
    """
    KEYCODE_DPAD_LEFT: _RemoteKeyCode.ValueType  # 21
    """Directional Pad Left key.
    May also be synthesized from trackball motions.
    """
    KEYCODE_DPAD_RIGHT: _RemoteKeyCode.ValueType  # 22
    """Directional Pad Right key.
    May also be synthesized from trackball motions.
    """
    KEYCODE_DPAD_CENTER: _RemoteKeyCode.ValueType  # 23
    """Directional Pad Center key.
    May also be synthesized from trackball motions.
    """
    KEYCODE_VOLUME_UP: _RemoteKeyCode.ValueType  # 24
    """Volume Up key.
    Adjusts the speaker volume up.
    """
    KEYCODE_VOLUME_DOWN: _RemoteKeyCode.ValueType  # 25
    """Volume Down key.
    Adjusts the speaker volume down.
    """
    KEYCODE_POWER: _RemoteKeyCode.ValueType  # 26
    """Power key."""
    KEYCODE_CAMERA: _RemoteKeyCode.ValueType  # 27
    """Camera key.
    Used to launch a camera application or take pictures.
    """
    KEYCODE_CLEAR: _RemoteKeyCode.ValueType  # 28
    """Clear key."""
    KEYCODE_A: _RemoteKeyCode.ValueType  # 29
    """'A' key."""
    KEYCODE_B: _RemoteKeyCode.ValueType  # 30
    """'B' key."""
    KEYCODE_C: _RemoteKeyCode.ValueType  # 31
    """'C' key."""
    KEYCODE_D: _RemoteKeyCode.ValueType  # 32
    """'D' key."""
    KEYCODE_E: _RemoteKeyCode.ValueType  # 33
    """'E' key."""
    KEYCODE_F: _RemoteKeyCode.ValueType  # 34
    """'F' key."""
    KEYCODE_G: _RemoteKeyCode.ValueType  # 35
    """'G' key."""
    KEYCODE_H: _RemoteKeyCode.ValueType  # 36
    """'H' key."""
    KEYCODE_I: _RemoteKeyCode.ValueType  # 37
    """'I' key."""
    KEYCODE_J: _RemoteKeyCode.ValueType  # 38
    """'J' key."""
    KEYCODE_K: _RemoteKeyCode.ValueType  # 39
    """'K' key."""
    KEYCODE_L: _RemoteKeyCode.ValueType  # 40
    """'L' key."""
    KEYCODE_M: _RemoteKeyCode.ValueType  # 41
    """'M' key."""
    KEYCODE_N: _RemoteKeyCode.ValueType  # 42
    """'N' key."""
    KEYCODE_O: _RemoteKeyCode.ValueType  # 43
    """'O' key."""
    KEYCODE_P: _RemoteKeyCode.ValueType  # 44
    """'P' key."""
    KEYCODE_Q: _RemoteKeyCode.ValueType  # 45
    """'Q' key."""
    KEYCODE_R: _RemoteKeyCode.ValueType  # 46
    """'R' key."""
    KEYCODE_S: _RemoteKeyCode.ValueType  # 47
    """'S' key."""
    KEYCODE_T: _RemoteKeyCode.ValueType  # 48
    """'T' key."""
    KEYCODE_U: _RemoteKeyCode.ValueType  # 49
    """'U' key."""
    KEYCODE_V: _RemoteKeyCode.ValueType  # 50
    """'V' key."""
    KEYCODE_W: _RemoteKeyCode.ValueType  # 51
    """'W' key."""
    KEYCODE_X: _RemoteKeyCode.ValueType  # 52
    """'X' key."""
    KEYCODE_Y: _RemoteKeyCode.ValueType  # 53
    """'Y' key."""
    KEYCODE_Z: _RemoteKeyCode.ValueType  # 54
    """'Z' key."""
    KEYCODE_COMMA: _RemoteKeyCode.ValueType  # 55
    """',' key."""
    KEYCODE_PERIOD: _RemoteKeyCode.ValueType  # 56
    """'.' key."""
    KEYCODE_ALT_LEFT: _RemoteKeyCode.ValueType  # 57
    """Left Alt modifier key."""
    KEYCODE_ALT_RIGHT: _RemoteKeyCode.ValueType  # 58
    """Right Alt modifier key."""
    KEYCODE_SHIFT_LEFT: _RemoteKeyCode.ValueType  # 59
    """Left Shift modifier key."""
    KEYCODE_SHIFT_RIGHT: _RemoteKeyCode.ValueType  # 60
    """Right Shift modifier key."""
    KEYCODE_TAB: _RemoteKeyCode.ValueType  # 61
    """Tab key."""
    KEYCODE_SPACE: _RemoteKeyCode.ValueType  # 62
    """Space key."""
    KEYCODE_SYM: _RemoteKeyCode.ValueType  # 63
    """Symbol modifier key.
    Used to enter alternate symbols.
    """
    KEYCODE_EXPLORER: _RemoteKeyCode.ValueType  # 64
    """Explorer special function key.
    Used to launch a browser application.
    """
    KEYCODE_ENVELOPE: _RemoteKeyCode.ValueType  # 65
    """Envelope special function key.
    Used to launch a mail application.
    """
    KEYCODE_ENTER: _RemoteKeyCode.ValueType  # 66
    """Enter key."""
    KEYCODE_DEL: _RemoteKeyCode.ValueType  # 67
    """Backspace key.
    Deletes characters before the insertion point, unlike KEYCODE_FORWARD_DEL.
    """
    KEYCODE_GRAVE: _RemoteKeyCode.ValueType  # 68
    """'`' (backtick) key."""
    KEYCODE_MINUS: _RemoteKeyCode.ValueType  # 69
    """'-'."""
    KEYCODE_EQUALS: _RemoteKeyCode.ValueType  # 70
    """'=' key."""
    KEYCODE_LEFT_BRACKET: _RemoteKeyCode.ValueType  # 71
    """'[' key."""
    KEYCODE_RIGHT_BRACKET: _RemoteKeyCode.ValueType  # 72
    """']' key."""
    KEYCODE_BACKSLASH: _RemoteKeyCode.ValueType  # 73
    """'\\' key."""
    KEYCODE_SEMICOLON: _RemoteKeyCode.ValueType  # 74
    """';' key."""
    KEYCODE_APOSTROPHE: _RemoteKeyCode.ValueType  # 75
    """''' (apostrophe) key."""
    KEYCODE_SLASH: _RemoteKeyCode.ValueType  # 76
    """'/' key."""
    KEYCODE_AT: _RemoteKeyCode.ValueType  # 77
    """'@' key."""
    KEYCODE_NUM: _RemoteKeyCode.ValueType  # 78
    """Number modifier key.
    Used to enter numeric symbols.
    This key is not KEYCODE_NUM_LOCK; it is more like KEYCODE_ALT_LEFT.
    """
    KEYCODE_HEADSETHOOK: _RemoteKeyCode.ValueType  # 79
    """Headset Hook key.
    Used to hang up calls and stop media.
    """
    KEYCODE_FOCUS: _RemoteKeyCode.ValueType  # 80
    """Camera Focus key.
    Used to focus the camera.
    """
    KEYCODE_PLUS: _RemoteKeyCode.ValueType  # 81
    """'+' key."""
    KEYCODE_MENU: _RemoteKeyCode.ValueType  # 82
    """Menu key."""
    KEYCODE_NOTIFICATION: _RemoteKeyCode.ValueType  # 83
    """Notification key."""
    KEYCODE_SEARCH: _RemoteKeyCode.ValueType  # 84
    """Search key."""
    KEYCODE_MEDIA_PLAY_PAUSE: _RemoteKeyCode.ValueType  # 85
    """Play/Pause media key."""
    KEYCODE_MEDIA_STOP: _RemoteKeyCode.ValueType  # 86
    """Stop media key."""
    KEYCODE_MEDIA_NEXT: _RemoteKeyCode.ValueType  # 87
    """Play Next media key."""
    KEYCODE_MEDIA_PREVIOUS: _RemoteKeyCode.ValueType  # 88
    """Play Previous media key."""
    KEYCODE_MEDIA_REWIND: _RemoteKeyCode.ValueType  # 89
    """Rewind media key."""
    KEYCODE_MEDIA_FAST_FORWARD: _RemoteKeyCode.ValueType  # 90
    """Fast Forward media key."""
    KEYCODE_MUTE: _RemoteKeyCode.ValueType  # 91
    """Mute key.
    Mutes the microphone, unlike KEYCODE_VOLUME_MUTE.
    """
    KEYCODE_PAGE_UP: _RemoteKeyCode.ValueType  # 92
    """Page Up key."""
    KEYCODE_PAGE_DOWN: _RemoteKeyCode.ValueType  # 93
    """Page Down key."""
    KEYCODE_PICTSYMBOLS: _RemoteKeyCode.ValueType  # 94
    """Picture Symbols modifier key.
    Used to switch symbol sets (Emoji, Kao-moji).
    """
    KEYCODE_SWITCH_CHARSET: _RemoteKeyCode.ValueType  # 95
    """Switch Charset modifier key.
    Used to switch character sets (Kanji, Katakana).
    """
    KEYCODE_BUTTON_A: _RemoteKeyCode.ValueType  # 96
    """A Button key.
    On a game controller, the A button should be either the button labeled A
    or the first button on the bottom row of controller buttons.
    """
    KEYCODE_BUTTON_B: _RemoteKeyCode.ValueType  # 97
    """B Button key.
    On a game controller, the B button should be either the button labeled B
    or the second button on the bottom row of controller buttons.
    """
    KEYCODE_BUTTON_C: _RemoteKeyCode.ValueType  # 98
    """C Button key.
    On a game controller, the C button should be either the button labeled C
    or the third button on the bottom row of controller buttons.
    """
    KEYCODE_BUTTON_X: _RemoteKeyCode.ValueType  # 99
    """X Button key.
    On a game controller, the X button should be either the button labeled X
    or the first button on the upper row of controller buttons.
    """
    KEYCODE_BUTTON_Y: _RemoteKeyCode.ValueType  # 100
    """Y Button key.
    On a game controller, the Y button should be either the button labeled Y
    or the second button on the upper row of controller buttons.
    """
    KEYCODE_BUTTON_Z: _RemoteKeyCode.ValueType  # 101
    """Z Button key.
    On a game controller, the Z button should be either the button labeled Z
    or the third button on the upper row of controller buttons.
    """
    KEYCODE_BUTTON_L1: _RemoteKeyCode.ValueType  # 102
    """L1 Button key.
    On a game controller, the L1 button should be either the button labeled L1 (or L)
    or the top left trigger button.
    """
    KEYCODE_BUTTON_R1: _RemoteKeyCode.ValueType  # 103
    """R1 Button key.
    On a game controller, the R1 button should be either the button labeled R1 (or R)
    or the top right trigger button.
    """
    KEYCODE_BUTTON_L2: _RemoteKeyCode.ValueType  # 104
    """L2 Button key.
    On a game controller, the L2 button should be either the button labeled L2
    or the bottom left trigger button.
    """
    KEYCODE_BUTTON_R2: _RemoteKeyCode.ValueType  # 105
    """R2 Button key.
    On a game controller, the R2 button should be either the button labeled R2
    or the bottom right trigger button.
    """
    KEYCODE_BUTTON_THUMBL: _RemoteKeyCode.ValueType  # 106
    """Left Thumb Button key.
    On a game controller, the left thumb button indicates that the left (or only)
    joystick is pressed.
    """
    KEYCODE_BUTTON_THUMBR: _RemoteKeyCode.ValueType  # 107
    """Right Thumb Button key.
    On a game controller, the right thumb button indicates that the right
    joystick is pressed.
    """
    KEYCODE_BUTTON_START: _RemoteKeyCode.ValueType  # 108
    """Start Button key.
    On a game controller, the button labeled Start.
    """
    KEYCODE_BUTTON_SELECT: _RemoteKeyCode.ValueType  # 109
    """Select Button key.
    On a game controller, the button labeled Select.
    """
    KEYCODE_BUTTON_MODE: _RemoteKeyCode.ValueType  # 110
    """Mode Button key.
    On a game controller, the button labeled Mode.
    """
    KEYCODE_ESCAPE: _RemoteKeyCode.ValueType  # 111
    """Escape key."""
    KEYCODE_FORWARD_DEL: _RemoteKeyCode.ValueType  # 112
    """Forward Delete key.
    Deletes characters ahead of the insertion point, unlike KEYCODE_DEL.
    """
    KEYCODE_CTRL_LEFT: _RemoteKeyCode.ValueType  # 113
    """Left Control modifier key."""
    KEYCODE_CTRL_RIGHT: _RemoteKeyCode.ValueType  # 114
    """Right Control modifier key."""
    KEYCODE_CAPS_LOCK: _RemoteKeyCode.ValueType  # 115
    """Caps Lock key."""
    KEYCODE_SCROLL_LOCK: _RemoteKeyCode.ValueType  # 116
    """Scroll Lock key."""
    KEYCODE_META_LEFT: _RemoteKeyCode.ValueType  # 117
    """Left Meta modifier key."""
    KEYCODE_META_RIGHT: _RemoteKeyCode.ValueType  # 118
    """Right Meta modifier key."""
    KEYCODE_FUNCTION: _RemoteKeyCode.ValueType  # 119
    """Function modifier key."""
    KEYCODE_SYSRQ: _RemoteKeyCode.ValueType  # 120
    """System Request / Print Screen key."""
    KEYCODE_BREAK: _RemoteKeyCode.ValueType  # 121
    """Break / Pause key."""
    KEYCODE_MOVE_HOME: _RemoteKeyCode.ValueType  # 122
    """Home Movement key.
    Used for scrolling or moving the cursor around to the start of a line
    or to the top of a list.
    """
    KEYCODE_MOVE_END: _RemoteKeyCode.ValueType  # 123
    """End Movement key.
    Used for scrolling or moving the cursor around to the end of a line
    or to the bottom of a list.
    """
    KEYCODE_INSERT: _RemoteKeyCode.ValueType  # 124
    """Insert key.
    Toggles insert / overwrite edit mode.
    """
    KEYCODE_FORWARD: _RemoteKeyCode.ValueType  # 125
    """Forward key.
    Navigates forward in the history stack.  Complement of KEYCODE_BACK.
    """
    KEYCODE_MEDIA_PLAY: _RemoteKeyCode.ValueType  # 126
    """Play media key."""
    KEYCODE_MEDIA_PAUSE: _RemoteKeyCode.ValueType  # 127
    """Pause media key."""
    KEYCODE_MEDIA_CLOSE: _RemoteKeyCode.ValueType  # 128
    """Close media key.
    May be used to close a CD tray, for example.
    """
    KEYCODE_MEDIA_EJECT: _RemoteKeyCode.ValueType  # 129
    """Eject media key.
    May be used to eject a CD tray, for example.
    """
    KEYCODE_MEDIA_RECORD: _RemoteKeyCode.ValueType  # 130
    """Record media key."""
    KEYCODE_F1: _RemoteKeyCode.ValueType  # 131
    """F1 key."""
    KEYCODE_F2: _RemoteKeyCode.ValueType  # 132
    """F2 key."""
    KEYCODE_F3: _RemoteKeyCode.ValueType  # 133
    """F3 key."""
    KEYCODE_F4: _RemoteKeyCode.ValueType  # 134
    """F4 key."""
    KEYCODE_F5: _RemoteKeyCode.ValueType  # 135
    """F5 key."""
    KEYCODE_F6: _RemoteKeyCode.ValueType  # 136
    """F6 key."""
    KEYCODE_F7: _RemoteKeyCode.ValueType  # 137
    """F7 key."""
    KEYCODE_F8: _RemoteKeyCode.ValueType  # 138
    """F8 key."""
    KEYCODE_F9: _RemoteKeyCode.ValueType  # 139
    """F9 key."""
    KEYCODE_F10: _RemoteKeyCode.ValueType  # 140
    """F10 key."""
    KEYCODE_F11: _RemoteKeyCode.ValueType  # 141
    """F11 key."""
    KEYCODE_F12: _RemoteKeyCode.ValueType  # 142
    """F12 key."""
    KEYCODE_NUM_LOCK: _RemoteKeyCode.ValueType  # 143
    """Num Lock key.
    This is the Num Lock key; it is different from KEYCODE_NUM.
    This key alters the behavior of other keys on the numeric keypad.
    """
    KEYCODE_NUMPAD_0: _RemoteKeyCode.ValueType  # 144
    """Numeric keypad '0' key."""
    KEYCODE_NUMPAD_1: _RemoteKeyCode.ValueType  # 145
    """Numeric keypad '1' key."""
    KEYCODE_NUMPAD_2: _RemoteKeyCode.ValueType  # 146
    """Numeric keypad '2' key."""
    KEYCODE_NUMPAD_3: _RemoteKeyCode.ValueType  # 147
    """Numeric keypad '3' key."""
    KEYCODE_NUMPAD_4: _RemoteKeyCode.ValueType  # 148
    """Numeric keypad '4' key."""
    KEYCODE_NUMPAD_5: _RemoteKeyCode.ValueType  # 149
    """Numeric keypad '5' key."""
    KEYCODE_NUMPAD_6: _RemoteKeyCode.ValueType  # 150
    """Numeric keypad '6' key."""
    KEYCODE_NUMPAD_7: _RemoteKeyCode.ValueType  # 151
    """Numeric keypad '7' key."""
    KEYCODE_NUMPAD_8: _RemoteKeyCode.ValueType  # 152
    """Numeric keypad '8' key."""
    KEYCODE_NUMPAD_9: _RemoteKeyCode.ValueType  # 153
    """Numeric keypad '9' key."""
    KEYCODE_NUMPAD_DIVIDE: _RemoteKeyCode.ValueType  # 154
    """Numeric keypad '/' key (for division)."""
    KEYCODE_NUMPAD_MULTIPLY: _RemoteKeyCode.ValueType  # 155
    """Numeric keypad '*' key (for multiplication)."""
    KEYCODE_NUMPAD_SUBTRACT: _RemoteKeyCode.ValueType  # 156
    """Numeric keypad '-' key (for subtraction)."""
    KEYCODE_NUMPAD_ADD: _RemoteKeyCode.ValueType  # 157
    """Numeric keypad '+' key (for addition)."""
    KEYCODE_NUMPAD_DOT: _RemoteKeyCode.ValueType  # 158
    """Numeric keypad '.' key (for decimals or digit grouping)."""
    KEYCODE_NUMPAD_COMMA: _RemoteKeyCode.ValueType  # 159
    """Numeric keypad ',' key (for decimals or digit grouping)."""
    KEYCODE_NUMPAD_ENTER: _RemoteKeyCode.ValueType  # 160
    """Numeric keypad Enter key."""
    KEYCODE_NUMPAD_EQUALS: _RemoteKeyCode.ValueType  # 161
    """Numeric keypad '=' key."""
    KEYCODE_NUMPAD_LEFT_PAREN: _RemoteKeyCode.ValueType  # 162
    """Numeric keypad '(' key."""
    KEYCODE_NUMPAD_RIGHT_PAREN: _RemoteKeyCode.ValueType  # 163
    """Numeric keypad ')' key."""
    KEYCODE_VOLUME_MUTE: _RemoteKeyCode.ValueType  # 164
    """Volume Mute key.
    Mutes the speaker, unlike KEYCODE_MUTE.
    This key should normally be implemented as a toggle such that the first press
    mutes the speaker and the second press restores the original volume.
    """
    KEYCODE_INFO: _RemoteKeyCode.ValueType  # 165
    """Info key.
    Common on TV remotes to show additional information related to what is
    currently being viewed.
    """
    KEYCODE_CHANNEL_UP: _RemoteKeyCode.ValueType  # 166
    """Channel up key.
    On TV remotes, increments the television channel.
    """
    KEYCODE_CHANNEL_DOWN: _RemoteKeyCode.ValueType  # 167
    """Channel down key.
    On TV remotes, decrements the television channel.
    """
    KEYCODE_ZOOM_IN: _RemoteKeyCode.ValueType  # 168
    """Zoom in key."""
    KEYCODE_ZOOM_OUT: _RemoteKeyCode.ValueType  # 169
    """Zoom out key."""
    KEYCODE_TV: _RemoteKeyCode.ValueType  # 170
    """TV key.
    On TV remotes, switches to viewing live TV.
    """
    KEYCODE_WINDOW: _RemoteKeyCode.ValueType  # 171
    """Window key.
    On TV remotes, toggles picture-in-picture mode or other windowing functions.
    """
    KEYCODE_GUIDE: _RemoteKeyCode.ValueType  # 172
    """Guide key.
    On TV remotes, shows a programming guide.
    """
    KEYCODE_DVR: _RemoteKeyCode.ValueType  # 173
    """DVR key.
    On some TV remotes, switches to a DVR mode for recorded shows.
    """
    KEYCODE_BOOKMARK: _RemoteKeyCode.ValueType  # 174
    """Bookmark key.
    On some TV remotes, bookmarks content or web pages.
    """
    KEYCODE_CAPTIONS: _RemoteKeyCode.ValueType  # 175
    """Toggle captions key.
    Switches the mode for closed-captioning text, for example during television shows.
    """
    KEYCODE_SETTINGS: _RemoteKeyCode.ValueType  # 176
    """Settings key.
    Starts the system settings activity.
    """
    KEYCODE_TV_POWER: _RemoteKeyCode.ValueType  # 177
    """TV power key.
    On TV remotes, toggles the power on a television screen.
    """
    KEYCODE_TV_INPUT: _RemoteKeyCode.ValueType  # 178
    """TV input key.
    On TV remotes, switches the input on a television screen.
    """
    KEYCODE_STB_POWER: _RemoteKeyCode.ValueType  # 179
    """Set-top-box power key.
    On TV remotes, toggles the power on an external Set-top-box.
    """
    KEYCODE_STB_INPUT: _RemoteKeyCode.ValueType  # 180
    """Set-top-box input key.
    On TV remotes, switches the input mode on an external Set-top-box.
    """
    KEYCODE_AVR_POWER: _RemoteKeyCode.ValueType  # 181
    """A/V Receiver power key.
    On TV remotes, toggles the power on an external A/V Receiver.
    """
    KEYCODE_AVR_INPUT: _RemoteKeyCode.ValueType  # 182
    """A/V Receiver input key.
    On TV remotes, switches the input mode on an external A/V Receiver.
    """
    KEYCODE_PROG_RED: _RemoteKeyCode.ValueType  # 183
    """Red "programmable" key.
    On TV remotes, acts as a contextual/programmable key.
    """
    KEYCODE_PROG_GREEN: _RemoteKeyCode.ValueType  # 184
    """Green "programmable" key.
    On TV remotes, actsas a contextual/programmable key.
    """
    KEYCODE_PROG_YELLOW: _RemoteKeyCode.ValueType  # 185
    """Yellow "programmable" key.
    On TV remotes, acts as a contextual/programmable key.
    """
    KEYCODE_PROG_BLUE: _RemoteKeyCode.ValueType  # 186
    """Blue "programmable" key.
    On TV remotes, acts as a contextual/programmable key.
    """
    KEYCODE_APP_SWITCH: _RemoteKeyCode.ValueType  # 187
    """App switch key.
    Should bring up the application switcher dialog.
    """
    KEYCODE_BUTTON_1: _RemoteKeyCode.ValueType  # 188
    """Generic Game Pad Button #1.*/"""
    KEYCODE_BUTTON_2: _RemoteKeyCode.ValueType  # 189
    """Generic Game Pad Button #2.*/"""
    KEYCODE_BUTTON_3: _RemoteKeyCode.ValueType  # 190
    """Generic Game Pad Button #3.*/"""
    KEYCODE_BUTTON_4: _RemoteKeyCode.ValueType  # 191
    """Generic Game Pad Button #4.*/"""
    KEYCODE_BUTTON_5: _RemoteKeyCode.ValueType  # 192
    """Generic Game Pad Button #5.*/"""
    KEYCODE_BUTTON_6: _RemoteKeyCode.ValueType  # 193
    """Generic Game Pad Button #6.*/"""
    KEYCODE_BUTTON_7: _RemoteKeyCode.ValueType  # 194
    """Generic Game Pad Button #7.*/"""
    KEYCODE_BUTTON_8: _RemoteKeyCode.ValueType  # 195
    """Generic Game Pad Button #8.*/"""
    KEYCODE_BUTTON_9: _RemoteKeyCode.ValueType  # 196
    """Generic Game Pad Button #9.*/"""
    KEYCODE_BUTTON_10: _RemoteKeyCode.ValueType  # 197
    """Generic Game Pad Button #10.*/"""
    KEYCODE_BUTTON_11: _RemoteKeyCode.ValueType  # 198
    """Generic Game Pad Button #11.*/"""
    KEYCODE_BUTTON_12: _RemoteKeyCode.ValueType  # 199
    """Generic Game Pad Button #12.*/"""
    KEYCODE_BUTTON_13: _RemoteKeyCode.ValueType  # 200
    """Generic Game Pad Button #13.*/"""
    KEYCODE_BUTTON_14: _RemoteKeyCode.ValueType  # 201
    """Generic Game Pad Button #14.*/"""
    KEYCODE_BUTTON_15: _RemoteKeyCode.ValueType  # 202
    """Generic Game Pad Button #15.*/"""
    KEYCODE_BUTTON_16: _RemoteKeyCode.ValueType  # 203
    """Generic Game Pad Button #16.*/"""
    KEYCODE_LANGUAGE_SWITCH: _RemoteKeyCode.ValueType  # 204
    """Language Switch key.
    Toggles the current input language such as switching between English and Japanese on
    a QWERTY keyboard.  On some devices, the same function may be performed by
    pressing Shift+Spacebar.
    """
    KEYCODE_MANNER_MODE: _RemoteKeyCode.ValueType  # 205
    """Manner Mode key.
    Toggles silent or vibrate mode on and off to make the device behave more politely
    in certain settings such as on a crowded train.  On some devices, the key may only
    operate when long-pressed.
    """
    KEYCODE_3D_MODE: _RemoteKeyCode.ValueType  # 206
    """3D Mode key.
    Toggles the display between 2D and 3D mode.
    """
    KEYCODE_CONTACTS: _RemoteKeyCode.ValueType  # 207
    """Contacts special function key.
    Used to launch an address book application.
    """
    KEYCODE_CALENDAR: _RemoteKeyCode.ValueType  # 208
    """Calendar special function key.
    Used to launch a calendar application.
    """
    KEYCODE_MUSIC: _RemoteKeyCode.ValueType  # 209
    """Music special function key.
    Used to launch a music player application.
    """
    KEYCODE_CALCULATOR: _RemoteKeyCode.ValueType  # 210
    """Calculator special function key.
    Used to launch a calculator application.
    """
    KEYCODE_ZENKAKU_HANKAKU: _RemoteKeyCode.ValueType  # 211
    """Japanese full-width / half-width key."""
    KEYCODE_EISU: _RemoteKeyCode.ValueType  # 212
    """Japanese alphanumeric key."""
    KEYCODE_MUHENKAN: _RemoteKeyCode.ValueType  # 213
    """Japanese non-conversion key."""
    KEYCODE_HENKAN: _RemoteKeyCode.ValueType  # 214
    """Japanese conversion key."""
    KEYCODE_KATAKANA_HIRAGANA: _RemoteKeyCode.ValueType  # 215
    """Japanese katakana / hiragana key."""
    KEYCODE_YEN: _RemoteKeyCode.ValueType  # 216
    """Japanese Yen key."""
    KEYCODE_RO: _RemoteKeyCode.ValueType  # 217
    """Japanese Ro key."""
    KEYCODE_KANA: _RemoteKeyCode.ValueType  # 218
    """Japanese kana key."""
    KEYCODE_ASSIST: _RemoteKeyCode.ValueType  # 219
    """Assist key.
    Launches the global assist activity.  Not delivered to applications.
    """
    KEYCODE_BRIGHTNESS_DOWN: _RemoteKeyCode.ValueType  # 220
    """Brightness Down key.
    Adjusts the screen brightness down.
    """
    KEYCODE_BRIGHTNESS_UP: _RemoteKeyCode.ValueType  # 221
    """Brightness Up key.
    Adjusts the screen brightness up.
    """
    KEYCODE_MEDIA_AUDIO_TRACK: _RemoteKeyCode.ValueType  # 222
    """Audio Track key.
    Switches the audio tracks.
    """
    KEYCODE_SLEEP: _RemoteKeyCode.ValueType  # 223
    """Sleep key.
    Puts the device to sleep.  Behaves somewhat like KEYCODE_POWER but it
    has no effect if the device is already asleep.
    """
    KEYCODE_WAKEUP: _RemoteKeyCode.ValueType  # 224
    """Wakeup key.
    Wakes up the device.  Behaves somewhat like KEYCODE_POWER but it
    has no effect if the device is already awake.
    """
    KEYCODE_PAIRING: _RemoteKeyCode.ValueType  # 225
    """Pairing key.
    Initiates peripheral pairing mode. Useful for pairing remote control
    devices or game controllers, especially if no other input mode is
    available.
    """
    KEYCODE_MEDIA_TOP_MENU: _RemoteKeyCode.ValueType  # 226
    """Media Top Menu key.
    Goes to the top of media menu.
    """
    KEYCODE_11: _RemoteKeyCode.ValueType  # 227
    """'11' key."""
    KEYCODE_12: _RemoteKeyCode.ValueType  # 228
    """'12' key."""
    KEYCODE_LAST_CHANNEL: _RemoteKeyCode.ValueType  # 229
    """Last Channel key.
    Goes to the last viewed channel.
    """
    KEYCODE_TV_DATA_SERVICE: _RemoteKeyCode.ValueType  # 230
    """TV data service key.
    Displays data services like weather, sports.
    """
    KEYCODE_VOICE_ASSIST: _RemoteKeyCode.ValueType  # 231
    """Voice Assist key.
    Launches the global voice assist activity. Not delivered to applications.
    """
    KEYCODE_TV_RADIO_SERVICE: _RemoteKeyCode.ValueType  # 232
    """Radio key.
    Toggles TV service / Radio service.
    """
    KEYCODE_TV_TELETEXT: _RemoteKeyCode.ValueType  # 233
    """Teletext key.
    Displays Teletext service.
    """
    KEYCODE_TV_NUMBER_ENTRY: _RemoteKeyCode.ValueType  # 234
    """Number entry key.
    Initiates to enter multi-digit channel nubmber when each digit key is assigned
    for selecting separate channel. Corresponds to Number Entry Mode (0x1D) of CEC
    User Control Code.
    """
    KEYCODE_TV_TERRESTRIAL_ANALOG: _RemoteKeyCode.ValueType  # 235
    """Analog Terrestrial key.
    Switches to analog terrestrial broadcast service.
    """
    KEYCODE_TV_TERRESTRIAL_DIGITAL: _RemoteKeyCode.ValueType  # 236
    """Digital Terrestrial key.
    Switches to digital terrestrial broadcast service.
    """
    KEYCODE_TV_SATELLITE: _RemoteKeyCode.ValueType  # 237
    """Satellite key.
    Switches to digital satellite broadcast service.
    """
    KEYCODE_TV_SATELLITE_BS: _RemoteKeyCode.ValueType  # 238
    """BS key.
    Switches to BS digital satellite broadcasting service available in Japan.
    """
    KEYCODE_TV_SATELLITE_CS: _RemoteKeyCode.ValueType  # 239
    """CS key.
    Switches to CS digital satellite broadcasting service available in Japan.
    """
    KEYCODE_TV_SATELLITE_SERVICE: _RemoteKeyCode.ValueType  # 240
    """BS/CS key.
    Toggles between BS and CS digital satellite services.
    """
    KEYCODE_TV_NETWORK: _RemoteKeyCode.ValueType  # 241
    """Toggle Network key.
    Toggles selecting broadcast services.
    """
    KEYCODE_TV_ANTENNA_CABLE: _RemoteKeyCode.ValueType  # 242
    """Antenna/Cable key.
    Toggles broadcast input source between antenna and cable.
    """
    KEYCODE_TV_INPUT_HDMI_1: _RemoteKeyCode.ValueType  # 243
    """HDMI #1 key.
    Switches to HDMI input #1.
    """
    KEYCODE_TV_INPUT_HDMI_2: _RemoteKeyCode.ValueType  # 244
    """HDMI #2 key.
    Switches to HDMI input #2.
    """
    KEYCODE_TV_INPUT_HDMI_3: _RemoteKeyCode.ValueType  # 245
    """HDMI #3 key.
    Switches to HDMI input #3.
    """
    KEYCODE_TV_INPUT_HDMI_4: _RemoteKeyCode.ValueType  # 246
    """HDMI #4 key.
    Switches to HDMI input #4.
    """
    KEYCODE_TV_INPUT_COMPOSITE_1: _RemoteKeyCode.ValueType  # 247
    """Composite #1 key.
    Switches to composite video input #1.
    """
    KEYCODE_TV_INPUT_COMPOSITE_2: _RemoteKeyCode.ValueType  # 248
    """Composite #2 key.
    Switches to composite video input #2.
    """
    KEYCODE_TV_INPUT_COMPONENT_1: _RemoteKeyCode.ValueType  # 249
    """Component #1 key.
    Switches to component video input #1.
    """
    KEYCODE_TV_INPUT_COMPONENT_2: _RemoteKeyCode.ValueType  # 250
    """Component #2 key.
    Switches to component video input #2.
    """
    KEYCODE_TV_INPUT_VGA_1: _RemoteKeyCode.ValueType  # 251
    """VGA #1 key.
    Switches to VGA (analog RGB) input #1.
    """
    KEYCODE_TV_AUDIO_DESCRIPTION: _RemoteKeyCode.ValueType  # 252
    """Audio description key.
    Toggles audio description off / on.
    """
    KEYCODE_TV_AUDIO_DESCRIPTION_MIX_UP: _RemoteKeyCode.ValueType  # 253
    """Audio description mixing volume up key.
    Louden audio description volume as compared with normal audio volume.
    """
    KEYCODE_TV_AUDIO_DESCRIPTION_MIX_DOWN: _RemoteKeyCode.ValueType  # 254
    """Audio description mixing volume down key.
    Lessen audio description volume as compared with normal audio volume.
    """
    KEYCODE_TV_ZOOM_MODE: _RemoteKeyCode.ValueType  # 255
    """Zoom mode key.
    Changes Zoom mode (Normal, Full, Zoom, Wide-zoom, etc.)
    """
    KEYCODE_TV_CONTENTS_MENU: _RemoteKeyCode.ValueType  # 256
    """Contents menu key.
    Goes to the title list. Corresponds to Contents Menu (0x0B) of CEC User Control
    Code
    """
    KEYCODE_TV_MEDIA_CONTEXT_MENU: _RemoteKeyCode.ValueType  # 257
    """Media context menu key.
    Goes to the context menu of media contents. Corresponds to Media Context-sensitive
    Menu (0x11) of CEC User Control Code.
    """
    KEYCODE_TV_TIMER_PROGRAMMING: _RemoteKeyCode.ValueType  # 258
    """Timer programming key.
    Goes to the timer recording menu. Corresponds to Timer Programming (0x54) of
    CEC User Control Code.
    """
    KEYCODE_HELP: _RemoteKeyCode.ValueType  # 259
    """Help key."""
    KEYCODE_NAVIGATE_PREVIOUS: _RemoteKeyCode.ValueType  # 260
    KEYCODE_NAVIGATE_NEXT: _RemoteKeyCode.ValueType  # 261
    KEYCODE_NAVIGATE_IN: _RemoteKeyCode.ValueType  # 262
    KEYCODE_NAVIGATE_OUT: _RemoteKeyCode.ValueType  # 263
    KEYCODE_STEM_PRIMARY: _RemoteKeyCode.ValueType  # 264
    """Primary stem key for Wear
    Main power/reset button on watch.
    """
    KEYCODE_STEM_1: _RemoteKeyCode.ValueType  # 265
    """Generic stem key 1 for Wear"""
    KEYCODE_STEM_2: _RemoteKeyCode.ValueType  # 266
    """Generic stem key 2 for Wear"""
    KEYCODE_STEM_3: _RemoteKeyCode.ValueType  # 267
    """Generic stem key 3 for Wear"""
    KEYCODE_DPAD_UP_LEFT: _RemoteKeyCode.ValueType  # 268
    """Directional Pad Up-Left"""
    KEYCODE_DPAD_DOWN_LEFT: _RemoteKeyCode.ValueType  # 269
    """Directional Pad Down-Left"""
    KEYCODE_DPAD_UP_RIGHT: _RemoteKeyCode.ValueType  # 270
    """Directional Pad Up-Right"""
    KEYCODE_DPAD_DOWN_RIGHT: _RemoteKeyCode.ValueType  # 271
    """Directional Pad Down-Right"""
    KEYCODE_MEDIA_SKIP_FORWARD: _RemoteKeyCode.ValueType  # 272
    """Skip forward media key"""
    KEYCODE_MEDIA_SKIP_BACKWARD: _RemoteKeyCode.ValueType  # 273
    """Skip backward media key"""
    KEYCODE_MEDIA_STEP_FORWARD: _RemoteKeyCode.ValueType  # 274
    """Step forward media key.
    Steps media forward one from at a time.
    """
    KEYCODE_MEDIA_STEP_BACKWARD: _RemoteKeyCode.ValueType  # 275
    """Step backward media key.
    Steps media backward one from at a time.
    """
    KEYCODE_SOFT_SLEEP: _RemoteKeyCode.ValueType  # 276
    """Put device to sleep unless a wakelock is held."""
    KEYCODE_CUT: _RemoteKeyCode.ValueType  # 277
    """Cut key."""
    KEYCODE_COPY: _RemoteKeyCode.ValueType  # 278
    """Copy key."""
    KEYCODE_PASTE: _RemoteKeyCode.ValueType  # 279
    """Paste key."""
    KEYCODE_SYSTEM_NAVIGATION_UP: _RemoteKeyCode.ValueType  # 280
    """fingerprint navigation key, up."""
    KEYCODE_SYSTEM_NAVIGATION_DOWN: _RemoteKeyCode.ValueType  # 281
    """fingerprint navigation key, down."""
    KEYCODE_SYSTEM_NAVIGATION_LEFT: _RemoteKeyCode.ValueType  # 282
    """fingerprint navigation key, left."""
    KEYCODE_SYSTEM_NAVIGATION_RIGHT: _RemoteKeyCode.ValueType  # 283
    """fingerprint navigation key, right."""
    KEYCODE_ALL_APPS: _RemoteKeyCode.ValueType  # 284
    """all apps"""
    KEYCODE_REFRESH: _RemoteKeyCode.ValueType  # 285
    """refresh key"""
    KEYCODE_THUMBS_UP: _RemoteKeyCode.ValueType  # 286
    """Thumbs up key. Apps can use this to let user upvote content."""
    KEYCODE_THUMBS_DOWN: _RemoteKeyCode.ValueType  # 287
    """Thumbs down key. Apps can use this to let user downvote content."""
    KEYCODE_PROFILE_SWITCH: _RemoteKeyCode.ValueType  # 288
    """Used to switch current account that is consuming content.
    May be consumed by system to switch current viewer profile.
    """
    KEYCODE_VIDEO_APP_1: _RemoteKeyCode.ValueType  # 289
    KEYCODE_VIDEO_APP_2: _RemoteKeyCode.ValueType  # 290
    KEYCODE_VIDEO_APP_3: _RemoteKeyCode.ValueType  # 291
    KEYCODE_VIDEO_APP_4: _RemoteKeyCode.ValueType  # 292
    KEYCODE_VIDEO_APP_5: _RemoteKeyCode.ValueType  # 293
    KEYCODE_VIDEO_APP_6: _RemoteKeyCode.ValueType  # 294
    KEYCODE_VIDEO_APP_7: _RemoteKeyCode.ValueType  # 295
    KEYCODE_VIDEO_APP_8: _RemoteKeyCode.ValueType  # 296
    KEYCODE_FEATURED_APP_1: _RemoteKeyCode.ValueType  # 297
    KEYCODE_FEATURED_APP_2: _RemoteKeyCode.ValueType  # 298
    KEYCODE_FEATURED_APP_3: _RemoteKeyCode.ValueType  # 299
    KEYCODE_FEATURED_APP_4: _RemoteKeyCode.ValueType  # 300
    KEYCODE_DEMO_APP_1: _RemoteKeyCode.ValueType  # 301
    KEYCODE_DEMO_APP_2: _RemoteKeyCode.ValueType  # 302
    KEYCODE_DEMO_APP_3: _RemoteKeyCode.ValueType  # 303
    KEYCODE_DEMO_APP_4: _RemoteKeyCode.ValueType  # 304

class RemoteKeyCode(_RemoteKeyCode, metaclass=_RemoteKeyCodeEnumTypeWrapper): ...

KEYCODE_UNKNOWN: RemoteKeyCode.ValueType  # 0
"""Unknown key code."""
KEYCODE_SOFT_LEFT: RemoteKeyCode.ValueType  # 1
"""Soft Left key.
Usually situated below the display on phones and used as a multi-function
feature key for selecting a software defined function shown on the bottom left
of the display.
"""
KEYCODE_SOFT_RIGHT: RemoteKeyCode.ValueType  # 2
"""Soft Right key.
Usually situated below the display on phones and used as a multi-function
feature key for selecting a software defined function shown on the bottom right
of the display.
"""
KEYCODE_HOME: RemoteKeyCode.ValueType  # 3
"""Home key.
This key is handled by the framework and is never delivered to applications.
"""
KEYCODE_BACK: RemoteKeyCode.ValueType  # 4
"""Back key."""
KEYCODE_CALL: RemoteKeyCode.ValueType  # 5
"""Call key."""
KEYCODE_ENDCALL: RemoteKeyCode.ValueType  # 6
"""End Call key."""
KEYCODE_0: RemoteKeyCode.ValueType  # 7
"""'0' key."""
KEYCODE_1: RemoteKeyCode.ValueType  # 8
"""'1' key."""
KEYCODE_2: RemoteKeyCode.ValueType  # 9
"""'2' key."""
KEYCODE_3: RemoteKeyCode.ValueType  # 10
"""'3' key."""
KEYCODE_4: RemoteKeyCode.ValueType  # 11
"""'4' key."""
KEYCODE_5: RemoteKeyCode.ValueType  # 12
"""'5' key."""
KEYCODE_6: RemoteKeyCode.ValueType  # 13
"""'6' key."""
KEYCODE_7: RemoteKeyCode.ValueType  # 14
"""'7' key."""
KEYCODE_8: RemoteKeyCode.ValueType  # 15
"""'8' key."""
KEYCODE_9: RemoteKeyCode.ValueType  # 16
"""'9' key."""
KEYCODE_STAR: RemoteKeyCode.ValueType  # 17
"""'*' key."""
KEYCODE_POUND: RemoteKeyCode.ValueType  # 18
"""'#' key."""
KEYCODE_DPAD_UP: RemoteKeyCode.ValueType  # 19
"""Directional Pad Up key.
May also be synthesized from trackball motions.
"""
KEYCODE_DPAD_DOWN: RemoteKeyCode.ValueType  # 20
"""Directional Pad Down key.
May also be synthesized from trackball motions.
"""
KEYCODE_DPAD_LEFT: RemoteKeyCode.ValueType  # 21
"""Directional Pad Left key.
May also be synthesized from trackball motions.
"""
KEYCODE_DPAD_RIGHT: RemoteKeyCode.ValueType  # 22
"""Directional Pad Right key.
May also be synthesized from trackball motions.
"""
KEYCODE_DPAD_CENTER: RemoteKeyCode.ValueType  # 23
"""Directional Pad Center key.
May also be synthesized from trackball motions.
"""
KEYCODE_VOLUME_UP: RemoteKeyCode.ValueType  # 24
"""Volume Up key.
Adjusts the speaker volume up.
"""
KEYCODE_VOLUME_DOWN: RemoteKeyCode.ValueType  # 25
"""Volume Down key.
Adjusts the speaker volume down.
"""
KEYCODE_POWER: RemoteKeyCode.ValueType  # 26
"""Power key."""
KEYCODE_CAMERA: RemoteKeyCode.ValueType  # 27
"""Camera key.
Used to launch a camera application or take pictures.
"""
KEYCODE_CLEAR: RemoteKeyCode.ValueType  # 28
"""Clear key."""
KEYCODE_A: RemoteKeyCode.ValueType  # 29
"""'A' key."""
KEYCODE_B: RemoteKeyCode.ValueType  # 30
"""'B' key."""
KEYCODE_C: RemoteKeyCode.ValueType  # 31
"""'C' key."""
KEYCODE_D: RemoteKeyCode.ValueType  # 32
"""'D' key."""
KEYCODE_E: RemoteKeyCode.ValueType  # 33
"""'E' key."""
KEYCODE_F: RemoteKeyCode.ValueType  # 34
"""'F' key."""
KEYCODE_G: RemoteKeyCode.ValueType  # 35
"""'G' key."""
KEYCODE_H: RemoteKeyCode.ValueType  # 36
"""'H' key."""
KEYCODE_I: RemoteKeyCode.ValueType  # 37
"""'I' key."""
KEYCODE_J: RemoteKeyCode.ValueType  # 38
"""'J' key."""
KEYCODE_K: RemoteKeyCode.ValueType  # 39
"""'K' key."""
KEYCODE_L: RemoteKeyCode.ValueType  # 40
"""'L' key."""
KEYCODE_M: RemoteKeyCode.ValueType  # 41
"""'M' key."""
KEYCODE_N: RemoteKeyCode.ValueType  # 42
"""'N' key."""
KEYCODE_O: RemoteKeyCode.ValueType  # 43
"""'O' key."""
KEYCODE_P: RemoteKeyCode.ValueType  # 44
"""'P' key."""
KEYCODE_Q: RemoteKeyCode.ValueType  # 45
"""'Q' key."""
KEYCODE_R: RemoteKeyCode.ValueType  # 46
"""'R' key."""
KEYCODE_S: RemoteKeyCode.ValueType  # 47
"""'S' key."""
KEYCODE_T: RemoteKeyCode.ValueType  # 48
"""'T' key."""
KEYCODE_U: RemoteKeyCode.ValueType  # 49
"""'U' key."""
KEYCODE_V: RemoteKeyCode.ValueType  # 50
"""'V' key."""
KEYCODE_W: RemoteKeyCode.ValueType  # 51
"""'W' key."""
KEYCODE_X: RemoteKeyCode.ValueType  # 52
"""'X' key."""
KEYCODE_Y: RemoteKeyCode.ValueType  # 53
"""'Y' key."""
KEYCODE_Z: RemoteKeyCode.ValueType  # 54
"""'Z' key."""
KEYCODE_COMMA: RemoteKeyCode.ValueType  # 55
"""',' key."""
KEYCODE_PERIOD: RemoteKeyCode.ValueType  # 56
"""'.' key."""
KEYCODE_ALT_LEFT: RemoteKeyCode.ValueType  # 57
"""Left Alt modifier key."""
KEYCODE_ALT_RIGHT: RemoteKeyCode.ValueType  # 58
"""Right Alt modifier key."""
KEYCODE_SHIFT_LEFT: RemoteKeyCode.ValueType  # 59
"""Left Shift modifier key."""
KEYCODE_SHIFT_RIGHT: RemoteKeyCode.ValueType  # 60
"""Right Shift modifier key."""
KEYCODE_TAB: RemoteKeyCode.ValueType  # 61
"""Tab key."""
KEYCODE_SPACE: RemoteKeyCode.ValueType  # 62
"""Space key."""
KEYCODE_SYM: RemoteKeyCode.ValueType  # 63
"""Symbol modifier key.
Used to enter alternate symbols.
"""
KEYCODE_EXPLORER: RemoteKeyCode.ValueType  # 64
"""Explorer special function key.
Used to launch a browser application.
"""
KEYCODE_ENVELOPE: RemoteKeyCode.ValueType  # 65
"""Envelope special function key.
Used to launch a mail application.
"""
KEYCODE_ENTER: RemoteKeyCode.ValueType  # 66
"""Enter key."""
KEYCODE_DEL: RemoteKeyCode.ValueType  # 67
"""Backspace key.
Deletes characters before the insertion point, unlike KEYCODE_FORWARD_DEL.
"""
KEYCODE_GRAVE: RemoteKeyCode.ValueType  # 68
"""'`' (backtick) key."""
KEYCODE_MINUS: RemoteKeyCode.ValueType  # 69
"""'-'."""
KEYCODE_EQUALS: RemoteKeyCode.ValueType  # 70
"""'=' key."""
KEYCODE_LEFT_BRACKET: RemoteKeyCode.ValueType  # 71
"""'[' key."""
KEYCODE_RIGHT_BRACKET: RemoteKeyCode.ValueType  # 72
"""']' key."""
KEYCODE_BACKSLASH: RemoteKeyCode.ValueType  # 73
"""'\\' key."""
KEYCODE_SEMICOLON: RemoteKeyCode.ValueType  # 74
"""';' key."""
KEYCODE_APOSTROPHE: RemoteKeyCode.ValueType  # 75
"""''' (apostrophe) key."""
KEYCODE_SLASH: RemoteKeyCode.ValueType  # 76
"""'/' key."""
KEYCODE_AT: RemoteKeyCode.ValueType  # 77
"""'@' key."""
KEYCODE_NUM: RemoteKeyCode.ValueType  # 78
"""Number modifier key.
Used to enter numeric symbols.
This key is not KEYCODE_NUM_LOCK; it is more like KEYCODE_ALT_LEFT.
"""
KEYCODE_HEADSETHOOK: RemoteKeyCode.ValueType  # 79
"""Headset Hook key.
Used to hang up calls and stop media.
"""
KEYCODE_FOCUS: RemoteKeyCode.ValueType  # 80
"""Camera Focus key.
Used to focus the camera.
"""
KEYCODE_PLUS: RemoteKeyCode.ValueType  # 81
"""'+' key."""
KEYCODE_MENU: RemoteKeyCode.ValueType  # 82
"""Menu key."""
KEYCODE_NOTIFICATION: RemoteKeyCode.ValueType  # 83
"""Notification key."""
KEYCODE_SEARCH: RemoteKeyCode.ValueType  # 84
"""Search key."""
KEYCODE_MEDIA_PLAY_PAUSE: RemoteKeyCode.ValueType  # 85
"""Play/Pause media key."""
KEYCODE_MEDIA_STOP: RemoteKeyCode.ValueType  # 86
"""Stop media key."""
KEYCODE_MEDIA_NEXT: RemoteKeyCode.ValueType  # 87
"""Play Next media key."""
KEYCODE_MEDIA_PREVIOUS: RemoteKeyCode.ValueType  # 88
"""Play Previous media key."""
KEYCODE_MEDIA_REWIND: RemoteKeyCode.ValueType  # 89
"""Rewind media key."""
KEYCODE_MEDIA_FAST_FORWARD: RemoteKeyCode.ValueType  # 90
"""Fast Forward media key."""
KEYCODE_MUTE: RemoteKeyCode.ValueType  # 91
"""Mute key.
Mutes the microphone, unlike KEYCODE_VOLUME_MUTE.
"""
KEYCODE_PAGE_UP: RemoteKeyCode.ValueType  # 92
"""Page Up key."""
KEYCODE_PAGE_DOWN: RemoteKeyCode.ValueType  # 93
"""Page Down key."""
KEYCODE_PICTSYMBOLS: RemoteKeyCode.ValueType  # 94
"""Picture Symbols modifier key.
Used to switch symbol sets (Emoji, Kao-moji).
"""
KEYCODE_SWITCH_CHARSET: RemoteKeyCode.ValueType  # 95
"""Switch Charset modifier key.
Used to switch character sets (Kanji, Katakana).
"""
KEYCODE_BUTTON_A: RemoteKeyCode.ValueType  # 96
"""A Button key.
On a game controller, the A button should be either the button labeled A
or the first button on the bottom row of controller buttons.
"""
KEYCODE_BUTTON_B: RemoteKeyCode.ValueType  # 97
"""B Button key.
On a game controller, the B button should be either the button labeled B
or the second button on the bottom row of controller buttons.
"""
KEYCODE_BUTTON_C: RemoteKeyCode.ValueType  # 98
"""C Button key.
On a game controller, the C button should be either the button labeled C
or the third button on the bottom row of controller buttons.
"""
KEYCODE_BUTTON_X: RemoteKeyCode.ValueType  # 99
"""X Button key.
On a game controller, the X button should be either the button labeled X
or the first button on the upper row of controller buttons.
"""
KEYCODE_BUTTON_Y: RemoteKeyCode.ValueType  # 100
"""Y Button key.
On a game controller, the Y button should be either the button labeled Y
or the second button on the upper row of controller buttons.
"""
KEYCODE_BUTTON_Z: RemoteKeyCode.ValueType  # 101
"""Z Button key.
On a game controller, the Z button should be either the button labeled Z
or the third button on the upper row of controller buttons.
"""
KEYCODE_BUTTON_L1: RemoteKeyCode.ValueType  # 102
"""L1 Button key.
On a game controller, the L1 button should be either the button labeled L1 (or L)
or the top left trigger button.
"""
KEYCODE_BUTTON_R1: RemoteKeyCode.ValueType  # 103
"""R1 Button key.
On a game controller, the R1 button should be either the button labeled R1 (or R)
or the top right trigger button.
"""
KEYCODE_BUTTON_L2: RemoteKeyCode.ValueType  # 104
"""L2 Button key.
On a game controller, the L2 button should be either the button labeled L2
or the bottom left trigger button.
"""
KEYCODE_BUTTON_R2: RemoteKeyCode.ValueType  # 105
"""R2 Button key.
On a game controller, the R2 button should be either the button labeled R2
or the bottom right trigger button.
"""
KEYCODE_BUTTON_THUMBL: RemoteKeyCode.ValueType  # 106
"""Left Thumb Button key.
On a game controller, the left thumb button indicates that the left (or only)
joystick is pressed.
"""
KEYCODE_BUTTON_THUMBR: RemoteKeyCode.ValueType  # 107
"""Right Thumb Button key.
On a game controller, the right thumb button indicates that the right
joystick is pressed.
"""
KEYCODE_BUTTON_START: RemoteKeyCode.ValueType  # 108
"""Start Button key.
On a game controller, the button labeled Start.
"""
KEYCODE_BUTTON_SELECT: RemoteKeyCode.ValueType  # 109
"""Select Button key.
On a game controller, the button labeled Select.
"""
KEYCODE_BUTTON_MODE: RemoteKeyCode.ValueType  # 110
"""Mode Button key.
On a game controller, the button labeled Mode.
"""
KEYCODE_ESCAPE: RemoteKeyCode.ValueType  # 111
"""Escape key."""
KEYCODE_FORWARD_DEL: RemoteKeyCode.ValueType  # 112
"""Forward Delete key.
Deletes characters ahead of the insertion point, unlike KEYCODE_DEL.
"""
KEYCODE_CTRL_LEFT: RemoteKeyCode.ValueType  # 113
"""Left Control modifier key."""
KEYCODE_CTRL_RIGHT: RemoteKeyCode.ValueType  # 114
"""Right Control modifier key."""
KEYCODE_CAPS_LOCK: RemoteKeyCode.ValueType  # 115
"""Caps Lock key."""
KEYCODE_SCROLL_LOCK: RemoteKeyCode.ValueType  # 116
"""Scroll Lock key."""
KEYCODE_META_LEFT: RemoteKeyCode.ValueType  # 117
"""Left Meta modifier key."""
KEYCODE_META_RIGHT: RemoteKeyCode.ValueType  # 118
"""Right Meta modifier key."""
KEYCODE_FUNCTION: RemoteKeyCode.ValueType  # 119
"""Function modifier key."""
KEYCODE_SYSRQ: RemoteKeyCode.ValueType  # 120
"""System Request / Print Screen key."""
KEYCODE_BREAK: RemoteKeyCode.ValueType  # 121
"""Break / Pause key."""
KEYCODE_MOVE_HOME: RemoteKeyCode.ValueType  # 122
"""Home Movement key.
Used for scrolling or moving the cursor around to the start of a line
or to the top of a list.
"""
KEYCODE_MOVE_END: RemoteKeyCode.ValueType  # 123
"""End Movement key.
Used for scrolling or moving the cursor around to the end of a line
or to the bottom of a list.
"""
KEYCODE_INSERT: RemoteKeyCode.ValueType  # 124
"""Insert key.
Toggles insert / overwrite edit mode.
"""
KEYCODE_FORWARD: RemoteKeyCode.ValueType  # 125
"""Forward key.
Navigates forward in the history stack.  Complement of KEYCODE_BACK.
"""
KEYCODE_MEDIA_PLAY: RemoteKeyCode.ValueType  # 126
"""Play media key."""
KEYCODE_MEDIA_PAUSE: RemoteKeyCode.ValueType  # 127
"""Pause media key."""
KEYCODE_MEDIA_CLOSE: RemoteKeyCode.ValueType  # 128
"""Close media key.
May be used to close a CD tray, for example.
"""
KEYCODE_MEDIA_EJECT: RemoteKeyCode.ValueType  # 129
"""Eject media key.
May be used to eject a CD tray, for example.
"""
KEYCODE_MEDIA_RECORD: RemoteKeyCode.ValueType  # 130
"""Record media key."""
KEYCODE_F1: RemoteKeyCode.ValueType  # 131
"""F1 key."""
KEYCODE_F2: RemoteKeyCode.ValueType  # 132
"""F2 key."""
KEYCODE_F3: RemoteKeyCode.ValueType  # 133
"""F3 key."""
KEYCODE_F4: RemoteKeyCode.ValueType  # 134
"""F4 key."""
KEYCODE_F5: RemoteKeyCode.ValueType  # 135
"""F5 key."""
KEYCODE_F6: RemoteKeyCode.ValueType  # 136
"""F6 key."""
KEYCODE_F7: RemoteKeyCode.ValueType  # 137
"""F7 key."""
KEYCODE_F8: RemoteKeyCode.ValueType  # 138
"""F8 key."""
KEYCODE_F9: RemoteKeyCode.ValueType  # 139
"""F9 key."""
KEYCODE_F10: RemoteKeyCode.ValueType  # 140
"""F10 key."""
KEYCODE_F11: RemoteKeyCode.ValueType  # 141
"""F11 key."""
KEYCODE_F12: RemoteKeyCode.ValueType  # 142
"""F12 key."""
KEYCODE_NUM_LOCK: RemoteKeyCode.ValueType  # 143
"""Num Lock key.
This is the Num Lock key; it is different from KEYCODE_NUM.
This key alters the behavior of other keys on the numeric keypad.
"""
KEYCODE_NUMPAD_0: RemoteKeyCode.ValueType  # 144
"""Numeric keypad '0' key."""
KEYCODE_NUMPAD_1: RemoteKeyCode.ValueType  # 145
"""Numeric keypad '1' key."""
KEYCODE_NUMPAD_2: RemoteKeyCode.ValueType  # 146
"""Numeric keypad '2' key."""
KEYCODE_NUMPAD_3: RemoteKeyCode.ValueType  # 147
"""Numeric keypad '3' key."""
KEYCODE_NUMPAD_4: RemoteKeyCode.ValueType  # 148
"""Numeric keypad '4' key."""
KEYCODE_NUMPAD_5: RemoteKeyCode.ValueType  # 149
"""Numeric keypad '5' key."""
KEYCODE_NUMPAD_6: RemoteKeyCode.ValueType  # 150
"""Numeric keypad '6' key."""
KEYCODE_NUMPAD_7: RemoteKeyCode.ValueType  # 151
"""Numeric keypad '7' key."""
KEYCODE_NUMPAD_8: RemoteKeyCode.ValueType  # 152
"""Numeric keypad '8' key."""
KEYCODE_NUMPAD_9: RemoteKeyCode.ValueType  # 153
"""Numeric keypad '9' key."""
KEYCODE_NUMPAD_DIVIDE: RemoteKeyCode.ValueType  # 154
"""Numeric keypad '/' key (for division)."""
KEYCODE_NUMPAD_MULTIPLY: RemoteKeyCode.ValueType  # 155
"""Numeric keypad '*' key (for multiplication)."""
KEYCODE_NUMPAD_SUBTRACT: RemoteKeyCode.ValueType  # 156
"""Numeric keypad '-' key (for subtraction)."""
KEYCODE_NUMPAD_ADD: RemoteKeyCode.ValueType  # 157
"""Numeric keypad '+' key (for addition)."""
KEYCODE_NUMPAD_DOT: RemoteKeyCode.ValueType  # 158
"""Numeric keypad '.' key (for decimals or digit grouping)."""
KEYCODE_NUMPAD_COMMA: RemoteKeyCode.ValueType  # 159
"""Numeric keypad ',' key (for decimals or digit grouping)."""
KEYCODE_NUMPAD_ENTER: RemoteKeyCode.ValueType  # 160
"""Numeric keypad Enter key."""
KEYCODE_NUMPAD_EQUALS: RemoteKeyCode.ValueType  # 161
"""Numeric keypad '=' key."""
KEYCODE_NUMPAD_LEFT_PAREN: RemoteKeyCode.ValueType  # 162
"""Numeric keypad '(' key."""
KEYCODE_NUMPAD_RIGHT_PAREN: RemoteKeyCode.ValueType  # 163
"""Numeric keypad ')' key."""
KEYCODE_VOLUME_MUTE: RemoteKeyCode.ValueType  # 164
"""Volume Mute key.
Mutes the speaker, unlike KEYCODE_MUTE.
This key should normally be implemented as a toggle such that the first press
mutes the speaker and the second press restores the original volume.
"""
KEYCODE_INFO: RemoteKeyCode.ValueType  # 165
"""Info key.
Common on TV remotes to show additional information related to what is
currently being viewed.
"""
KEYCODE_CHANNEL_UP: RemoteKeyCode.ValueType  # 166
"""Channel up key.
On TV remotes, increments the television channel.
"""
KEYCODE_CHANNEL_DOWN: RemoteKeyCode.ValueType  # 167
"""Channel down key.
On TV remotes, decrements the television channel.
"""
KEYCODE_ZOOM_IN: RemoteKeyCode.ValueType  # 168
"""Zoom in key."""
KEYCODE_ZOOM_OUT: RemoteKeyCode.ValueType  # 169
"""Zoom out key."""
KEYCODE_TV: RemoteKeyCode.ValueType  # 170
"""TV key.
On TV remotes, switches to viewing live TV.
"""
KEYCODE_WINDOW: RemoteKeyCode.ValueType  # 171
"""Window key.
On TV remotes, toggles picture-in-picture mode or other windowing functions.
"""
KEYCODE_GUIDE: RemoteKeyCode.ValueType  # 172
"""Guide key.
On TV remotes, shows a programming guide.
"""
KEYCODE_DVR: RemoteKeyCode.ValueType  # 173
"""DVR key.
On some TV remotes, switches to a DVR mode for recorded shows.
"""
KEYCODE_BOOKMARK: RemoteKeyCode.ValueType  # 174
"""Bookmark key.
On some TV remotes, bookmarks content or web pages.
"""
KEYCODE_CAPTIONS: RemoteKeyCode.ValueType  # 175
"""Toggle captions key.
Switches the mode for closed-captioning text, for example during television shows.
"""
KEYCODE_SETTINGS: RemoteKeyCode.ValueType  # 176
"""Settings key.
Starts the system settings activity.
"""
KEYCODE_TV_POWER: RemoteKeyCode.ValueType  # 177
"""TV power key.
On TV remotes, toggles the power on a television screen.
"""
KEYCODE_TV_INPUT: RemoteKeyCode.ValueType  # 178
"""TV input key.
On TV remotes, switches the input on a television screen.
"""
KEYCODE_STB_POWER: RemoteKeyCode.ValueType  # 179
"""Set-top-box power key.
On TV remotes, toggles the power on an external Set-top-box.
"""
KEYCODE_STB_INPUT: RemoteKeyCode.ValueType  # 180
"""Set-top-box input key.
On TV remotes, switches the input mode on an external Set-top-box.
"""
KEYCODE_AVR_POWER: RemoteKeyCode.ValueType  # 181
"""A/V Receiver power key.
On TV remotes, toggles the power on an external A/V Receiver.
"""
KEYCODE_AVR_INPUT: RemoteKeyCode.ValueType  # 182
"""A/V Receiver input key.
On TV remotes, switches the input mode on an external A/V Receiver.
"""
KEYCODE_PROG_RED: RemoteKeyCode.ValueType  # 183
"""Red "programmable" key.
On TV remotes, acts as a contextual/programmable key.
"""
KEYCODE_PROG_GREEN: RemoteKeyCode.ValueType  # 184
"""Green "programmable" key.
On TV remotes, actsas a contextual/programmable key.
"""
KEYCODE_PROG_YELLOW: RemoteKeyCode.ValueType  # 185
"""Yellow "programmable" key.
On TV remotes, acts as a contextual/programmable key.
"""
KEYCODE_PROG_BLUE: RemoteKeyCode.ValueType  # 186
"""Blue "programmable" key.
On TV remotes, acts as a contextual/programmable key.
"""
KEYCODE_APP_SWITCH: RemoteKeyCode.ValueType  # 187
"""App switch key.
Should bring up the application switcher dialog.
"""
KEYCODE_BUTTON_1: RemoteKeyCode.ValueType  # 188
"""Generic Game Pad Button #1.*/"""
KEYCODE_BUTTON_2: RemoteKeyCode.ValueType  # 189
"""Generic Game Pad Button #2.*/"""
KEYCODE_BUTTON_3: RemoteKeyCode.ValueType  # 190
"""Generic Game Pad Button #3.*/"""
KEYCODE_BUTTON_4: RemoteKeyCode.ValueType  # 191
"""Generic Game Pad Button #4.*/"""
KEYCODE_BUTTON_5: RemoteKeyCode.ValueType  # 192
"""Generic Game Pad Button #5.*/"""
KEYCODE_BUTTON_6: RemoteKeyCode.ValueType  # 193
"""Generic Game Pad Button #6.*/"""
KEYCODE_BUTTON_7: RemoteKeyCode.ValueType  # 194
"""Generic Game Pad Button #7.*/"""
KEYCODE_BUTTON_8: RemoteKeyCode.ValueType  # 195
"""Generic Game Pad Button #8.*/"""
KEYCODE_BUTTON_9: RemoteKeyCode.ValueType  # 196
"""Generic Game Pad Button #9.*/"""
KEYCODE_BUTTON_10: RemoteKeyCode.ValueType  # 197
"""Generic Game Pad Button #10.*/"""
KEYCODE_BUTTON_11: RemoteKeyCode.ValueType  # 198
"""Generic Game Pad Button #11.*/"""
KEYCODE_BUTTON_12: RemoteKeyCode.ValueType  # 199
"""Generic Game Pad Button #12.*/"""
KEYCODE_BUTTON_13: RemoteKeyCode.ValueType  # 200
"""Generic Game Pad Button #13.*/"""
KEYCODE_BUTTON_14: RemoteKeyCode.ValueType  # 201
"""Generic Game Pad Button #14.*/"""
KEYCODE_BUTTON_15: RemoteKeyCode.ValueType  # 202
"""Generic Game Pad Button #15.*/"""
KEYCODE_BUTTON_16: RemoteKeyCode.ValueType  # 203
"""Generic Game Pad Button #16.*/"""
KEYCODE_LANGUAGE_SWITCH: RemoteKeyCode.ValueType  # 204
"""Language Switch key.
Toggles the current input language such as switching between English and Japanese on
a QWERTY keyboard.  On some devices, the same function may be performed by
pressing Shift+Spacebar.
"""
KEYCODE_MANNER_MODE: RemoteKeyCode.ValueType  # 205
"""Manner Mode key.
Toggles silent or vibrate mode on and off to make the device behave more politely
in certain settings such as on a crowded train.  On some devices, the key may only
operate when long-pressed.
"""
KEYCODE_3D_MODE: RemoteKeyCode.ValueType  # 206
"""3D Mode key.
Toggles the display between 2D and 3D mode.
"""
KEYCODE_CONTACTS: RemoteKeyCode.ValueType  # 207
"""Contacts special function key.
Used to launch an address book application.
"""
KEYCODE_CALENDAR: RemoteKeyCode.ValueType  # 208
"""Calendar special function key.
Used to launch a calendar application.
"""
KEYCODE_MUSIC: RemoteKeyCode.ValueType  # 209
"""Music special function key.
Used to launch a music player application.
"""
KEYCODE_CALCULATOR: RemoteKeyCode.ValueType  # 210
"""Calculator special function key.
Used to launch a calculator application.
"""
KEYCODE_ZENKAKU_HANKAKU: RemoteKeyCode.ValueType  # 211
"""Japanese full-width / half-width key."""
KEYCODE_EISU: RemoteKeyCode.ValueType  # 212
"""Japanese alphanumeric key."""
KEYCODE_MUHENKAN: RemoteKeyCode.ValueType  # 213
"""Japanese non-conversion key."""
KEYCODE_HENKAN: RemoteKeyCode.ValueType  # 214
"""Japanese conversion key."""
KEYCODE_KATAKANA_HIRAGANA: RemoteKeyCode.ValueType  # 215
"""Japanese katakana / hiragana key."""
KEYCODE_YEN: RemoteKeyCode.ValueType  # 216
"""Japanese Yen key."""
KEYCODE_RO: RemoteKeyCode.ValueType  # 217
"""Japanese Ro key."""
KEYCODE_KANA: RemoteKeyCode.ValueType  # 218
"""Japanese kana key."""
KEYCODE_ASSIST: RemoteKeyCode.ValueType  # 219
"""Assist key.
Launches the global assist activity.  Not delivered to applications.
"""
KEYCODE_BRIGHTNESS_DOWN: RemoteKeyCode.ValueType  # 220
"""Brightness Down key.
Adjusts the screen brightness down.
"""
KEYCODE_BRIGHTNESS_UP: RemoteKeyCode.ValueType  # 221
"""Brightness Up key.
Adjusts the screen brightness up.
"""
KEYCODE_MEDIA_AUDIO_TRACK: RemoteKeyCode.ValueType  # 222
"""Audio Track key.
Switches the audio tracks.
"""
KEYCODE_SLEEP: RemoteKeyCode.ValueType  # 223
"""Sleep key.
Puts the device to sleep.  Behaves somewhat like KEYCODE_POWER but it
has no effect if the device is already asleep.
"""
KEYCODE_WAKEUP: RemoteKeyCode.ValueType  # 224
"""Wakeup key.
Wakes up the device.  Behaves somewhat like KEYCODE_POWER but it
has no effect if the device is already awake.
"""
KEYCODE_PAIRING: RemoteKeyCode.ValueType  # 225
"""Pairing key.
Initiates peripheral pairing mode. Useful for pairing remote control
devices or game controllers, especially if no other input mode is
available.
"""
KEYCODE_MEDIA_TOP_MENU: RemoteKeyCode.ValueType  # 226
"""Media Top Menu key.
Goes to the top of media menu.
"""
KEYCODE_11: RemoteKeyCode.ValueType  # 227
"""'11' key."""
KEYCODE_12: RemoteKeyCode.ValueType  # 228
"""'12' key."""
KEYCODE_LAST_CHANNEL: RemoteKeyCode.ValueType  # 229
"""Last Channel key.
Goes to the last viewed channel.
"""
KEYCODE_TV_DATA_SERVICE: RemoteKeyCode.ValueType  # 230
"""TV data service key.
Displays data services like weather, sports.
"""
KEYCODE_VOICE_ASSIST: RemoteKeyCode.ValueType  # 231
"""Voice Assist key.
Launches the global voice assist activity. Not delivered to applications.
"""
KEYCODE_TV_RADIO_SERVICE: RemoteKeyCode.ValueType  # 232
"""Radio key.
Toggles TV service / Radio service.
"""
KEYCODE_TV_TELETEXT: RemoteKeyCode.ValueType  # 233
"""Teletext key.
Displays Teletext service.
"""
KEYCODE_TV_NUMBER_ENTRY: RemoteKeyCode.ValueType  # 234
"""Number entry key.
Initiates to enter multi-digit channel nubmber when each digit key is assigned
for selecting separate channel. Corresponds to Number Entry Mode (0x1D) of CEC
User Control Code.
"""
KEYCODE_TV_TERRESTRIAL_ANALOG: RemoteKeyCode.ValueType  # 235
"""Analog Terrestrial key.
Switches to analog terrestrial broadcast service.
"""
KEYCODE_TV_TERRESTRIAL_DIGITAL: RemoteKeyCode.ValueType  # 236
"""Digital Terrestrial key.
Switches to digital terrestrial broadcast service.
"""
KEYCODE_TV_SATELLITE: RemoteKeyCode.ValueType  # 237
"""Satellite key.
Switches to digital satellite broadcast service.
"""
KEYCODE_TV_SATELLITE_BS: RemoteKeyCode.ValueType  # 238
"""BS key.
Switches to BS digital satellite broadcasting service available in Japan.
"""
KEYCODE_TV_SATELLITE_CS: RemoteKeyCode.ValueType  # 239
"""CS key.
Switches to CS digital satellite broadcasting service available in Japan.
"""
KEYCODE_TV_SATELLITE_SERVICE: RemoteKeyCode.ValueType  # 240
"""BS/CS key.
Toggles between BS and CS digital satellite services.
"""
KEYCODE_TV_NETWORK: RemoteKeyCode.ValueType  # 241
"""Toggle Network key.
Toggles selecting broadcast services.
"""
KEYCODE_TV_ANTENNA_CABLE: RemoteKeyCode.ValueType  # 242
"""Antenna/Cable key.
Toggles broadcast input source between antenna and cable.
"""
KEYCODE_TV_INPUT_HDMI_1: RemoteKeyCode.ValueType  # 243
"""HDMI #1 key.
Switches to HDMI input #1.
"""
KEYCODE_TV_INPUT_HDMI_2: RemoteKeyCode.ValueType  # 244
"""HDMI #2 key.
Switches to HDMI input #2.
"""
KEYCODE_TV_INPUT_HDMI_3: RemoteKeyCode.ValueType  # 245
"""HDMI #3 key.
Switches to HDMI input #3.
"""
KEYCODE_TV_INPUT_HDMI_4: RemoteKeyCode.ValueType  # 246
"""HDMI #4 key.
Switches to HDMI input #4.
"""
KEYCODE_TV_INPUT_COMPOSITE_1: RemoteKeyCode.ValueType  # 247
"""Composite #1 key.
Switches to composite video input #1.
"""
KEYCODE_TV_INPUT_COMPOSITE_2: RemoteKeyCode.ValueType  # 248
"""Composite #2 key.
Switches to composite video input #2.
"""
KEYCODE_TV_INPUT_COMPONENT_1: RemoteKeyCode.ValueType  # 249
"""Component #1 key.
Switches to component video input #1.
"""
KEYCODE_TV_INPUT_COMPONENT_2: RemoteKeyCode.ValueType  # 250
"""Component #2 key.
Switches to component video input #2.
"""
KEYCODE_TV_INPUT_VGA_1: RemoteKeyCode.ValueType  # 251
"""VGA #1 key.
Switches to VGA (analog RGB) input #1.
"""
KEYCODE_TV_AUDIO_DESCRIPTION: RemoteKeyCode.ValueType  # 252
"""Audio description key.
Toggles audio description off / on.
"""
KEYCODE_TV_AUDIO_DESCRIPTION_MIX_UP: RemoteKeyCode.ValueType  # 253
"""Audio description mixing volume up key.
Louden audio description volume as compared with normal audio volume.
"""
KEYCODE_TV_AUDIO_DESCRIPTION_MIX_DOWN: RemoteKeyCode.ValueType  # 254
"""Audio description mixing volume down key.
Lessen audio description volume as compared with normal audio volume.
"""
KEYCODE_TV_ZOOM_MODE: RemoteKeyCode.ValueType  # 255
"""Zoom mode key.
Changes Zoom mode (Normal, Full, Zoom, Wide-zoom, etc.)
"""
KEYCODE_TV_CONTENTS_MENU: RemoteKeyCode.ValueType  # 256
"""Contents menu key.
Goes to the title list. Corresponds to Contents Menu (0x0B) of CEC User Control
Code
"""
KEYCODE_TV_MEDIA_CONTEXT_MENU: RemoteKeyCode.ValueType  # 257
"""Media context menu key.
Goes to the context menu of media contents. Corresponds to Media Context-sensitive
Menu (0x11) of CEC User Control Code.
"""
KEYCODE_TV_TIMER_PROGRAMMING: RemoteKeyCode.ValueType  # 258
"""Timer programming key.
Goes to the timer recording menu. Corresponds to Timer Programming (0x54) of
CEC User Control Code.
"""
KEYCODE_HELP: RemoteKeyCode.ValueType  # 259
"""Help key."""
KEYCODE_NAVIGATE_PREVIOUS: RemoteKeyCode.ValueType  # 260
KEYCODE_NAVIGATE_NEXT: RemoteKeyCode.ValueType  # 261
KEYCODE_NAVIGATE_IN: RemoteKeyCode.ValueType  # 262
KEYCODE_NAVIGATE_OUT: RemoteKeyCode.ValueType  # 263
KEYCODE_STEM_PRIMARY: RemoteKeyCode.ValueType  # 264
"""Primary stem key for Wear
Main power/reset button on watch.
"""
KEYCODE_STEM_1: RemoteKeyCode.ValueType  # 265
"""Generic stem key 1 for Wear"""
KEYCODE_STEM_2: RemoteKeyCode.ValueType  # 266
"""Generic stem key 2 for Wear"""
KEYCODE_STEM_3: RemoteKeyCode.ValueType  # 267
"""Generic stem key 3 for Wear"""
KEYCODE_DPAD_UP_LEFT: RemoteKeyCode.ValueType  # 268
"""Directional Pad Up-Left"""
KEYCODE_DPAD_DOWN_LEFT: RemoteKeyCode.ValueType  # 269
"""Directional Pad Down-Left"""
KEYCODE_DPAD_UP_RIGHT: RemoteKeyCode.ValueType  # 270
"""Directional Pad Up-Right"""
KEYCODE_DPAD_DOWN_RIGHT: RemoteKeyCode.ValueType  # 271
"""Directional Pad Down-Right"""
KEYCODE_MEDIA_SKIP_FORWARD: RemoteKeyCode.ValueType  # 272
"""Skip forward media key"""
KEYCODE_MEDIA_SKIP_BACKWARD: RemoteKeyCode.ValueType  # 273
"""Skip backward media key"""
KEYCODE_MEDIA_STEP_FORWARD: RemoteKeyCode.ValueType  # 274
"""Step forward media key.
Steps media forward one from at a time.
"""
KEYCODE_MEDIA_STEP_BACKWARD: RemoteKeyCode.ValueType  # 275
"""Step backward media key.
Steps media backward one from at a time.
"""
KEYCODE_SOFT_SLEEP: RemoteKeyCode.ValueType  # 276
"""Put device to sleep unless a wakelock is held."""
KEYCODE_CUT: RemoteKeyCode.ValueType  # 277
"""Cut key."""
KEYCODE_COPY: RemoteKeyCode.ValueType  # 278
"""Copy key."""
KEYCODE_PASTE: RemoteKeyCode.ValueType  # 279
"""Paste key."""
KEYCODE_SYSTEM_NAVIGATION_UP: RemoteKeyCode.ValueType  # 280
"""fingerprint navigation key, up."""
KEYCODE_SYSTEM_NAVIGATION_DOWN: RemoteKeyCode.ValueType  # 281
"""fingerprint navigation key, down."""
KEYCODE_SYSTEM_NAVIGATION_LEFT: RemoteKeyCode.ValueType  # 282
"""fingerprint navigation key, left."""
KEYCODE_SYSTEM_NAVIGATION_RIGHT: RemoteKeyCode.ValueType  # 283
"""fingerprint navigation key, right."""
KEYCODE_ALL_APPS: RemoteKeyCode.ValueType  # 284
"""all apps"""
KEYCODE_REFRESH: RemoteKeyCode.ValueType  # 285
"""refresh key"""
KEYCODE_THUMBS_UP: RemoteKeyCode.ValueType  # 286
"""Thumbs up key. Apps can use this to let user upvote content."""
KEYCODE_THUMBS_DOWN: RemoteKeyCode.ValueType  # 287
"""Thumbs down key. Apps can use this to let user downvote content."""
KEYCODE_PROFILE_SWITCH: RemoteKeyCode.ValueType  # 288
"""Used to switch current account that is consuming content.
May be consumed by system to switch current viewer profile.
"""
KEYCODE_VIDEO_APP_1: RemoteKeyCode.ValueType  # 289
KEYCODE_VIDEO_APP_2: RemoteKeyCode.ValueType  # 290
KEYCODE_VIDEO_APP_3: RemoteKeyCode.ValueType  # 291
KEYCODE_VIDEO_APP_4: RemoteKeyCode.ValueType  # 292
KEYCODE_VIDEO_APP_5: RemoteKeyCode.ValueType  # 293
KEYCODE_VIDEO_APP_6: RemoteKeyCode.ValueType  # 294
KEYCODE_VIDEO_APP_7: RemoteKeyCode.ValueType  # 295
KEYCODE_VIDEO_APP_8: RemoteKeyCode.ValueType  # 296
KEYCODE_FEATURED_APP_1: RemoteKeyCode.ValueType  # 297
KEYCODE_FEATURED_APP_2: RemoteKeyCode.ValueType  # 298
KEYCODE_FEATURED_APP_3: RemoteKeyCode.ValueType  # 299
KEYCODE_FEATURED_APP_4: RemoteKeyCode.ValueType  # 300
KEYCODE_DEMO_APP_1: RemoteKeyCode.ValueType  # 301
KEYCODE_DEMO_APP_2: RemoteKeyCode.ValueType  # 302
KEYCODE_DEMO_APP_3: RemoteKeyCode.ValueType  # 303
KEYCODE_DEMO_APP_4: RemoteKeyCode.ValueType  # 304
global___RemoteKeyCode = RemoteKeyCode

class _RemoteDirection:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _RemoteDirectionEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_RemoteDirection.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN_DIRECTION: _RemoteDirection.ValueType  # 0
    START_LONG: _RemoteDirection.ValueType  # 1
    END_LONG: _RemoteDirection.ValueType  # 2
    SHORT: _RemoteDirection.ValueType  # 3

class RemoteDirection(_RemoteDirection, metaclass=_RemoteDirectionEnumTypeWrapper): ...

UNKNOWN_DIRECTION: RemoteDirection.ValueType  # 0
START_LONG: RemoteDirection.ValueType  # 1
END_LONG: RemoteDirection.ValueType  # 2
SHORT: RemoteDirection.ValueType  # 3
global___RemoteDirection = RemoteDirection

@typing_extensions.final
class RemoteAppLinkLaunchRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_LINK_FIELD_NUMBER: builtins.int
    app_link: builtins.str
    def __init__(
        self,
        *,
        app_link: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_link", b"app_link"]) -> None: ...

global___RemoteAppLinkLaunchRequest = RemoteAppLinkLaunchRequest

@typing_extensions.final
class RemoteResetPreferredAudioDevice(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteResetPreferredAudioDevice = RemoteResetPreferredAudioDevice

@typing_extensions.final
class RemoteSetPreferredAudioDevice(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteSetPreferredAudioDevice = RemoteSetPreferredAudioDevice

@typing_extensions.final
class RemoteAdjustVolumeLevel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteAdjustVolumeLevel = RemoteAdjustVolumeLevel

@typing_extensions.final
class RemoteSetVolumeLevel(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    UNKNOWN1_FIELD_NUMBER: builtins.int
    UNKNOWN2_FIELD_NUMBER: builtins.int
    PLAYER_MODEL_FIELD_NUMBER: builtins.int
    UNKNOWN4_FIELD_NUMBER: builtins.int
    UNKNOWN5_FIELD_NUMBER: builtins.int
    VOLUME_MAX_FIELD_NUMBER: builtins.int
    VOLUME_LEVEL_FIELD_NUMBER: builtins.int
    VOLUME_MUTED_FIELD_NUMBER: builtins.int
    unknown1: builtins.int
    unknown2: builtins.int
    player_model: builtins.str
    unknown4: builtins.int
    unknown5: builtins.int
    volume_max: builtins.int
    volume_level: builtins.int
    volume_muted: builtins.bool
    def __init__(
        self,
        *,
        unknown1: builtins.int = ...,
        unknown2: builtins.int = ...,
        player_model: builtins.str = ...,
        unknown4: builtins.int = ...,
        unknown5: builtins.int = ...,
        volume_max: builtins.int = ...,
        volume_level: builtins.int = ...,
        volume_muted: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["player_model", b"player_model", "unknown1", b"unknown1", "unknown2", b"unknown2", "unknown4", b"unknown4", "unknown5", b"unknown5", "volume_level", b"volume_level", "volume_max", b"volume_max", "volume_muted", b"volume_muted"]) -> None: ...

global___RemoteSetVolumeLevel = RemoteSetVolumeLevel

@typing_extensions.final
class RemoteStart(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STARTED_FIELD_NUMBER: builtins.int
    started: builtins.bool
    def __init__(
        self,
        *,
        started: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["started", b"started"]) -> None: ...

global___RemoteStart = RemoteStart

@typing_extensions.final
class RemoteVoiceEnd(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteVoiceEnd = RemoteVoiceEnd

@typing_extensions.final
class RemoteVoicePayload(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteVoicePayload = RemoteVoicePayload

@typing_extensions.final
class RemoteVoiceBegin(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___RemoteVoiceBegin = RemoteVoiceBegin

@typing_extensions.final
class RemoteTextFieldStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNTER_FIELD_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    START_FIELD_NUMBER: builtins.int
    END_FIELD_NUMBER: builtins.int
    INT5_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    counter_field: builtins.int
    value: builtins.str
    start: builtins.int
    end: builtins.int
    int5: builtins.int
    label: builtins.str
    def __init__(
        self,
        *,
        counter_field: builtins.int = ...,
        value: builtins.str = ...,
        start: builtins.int = ...,
        end: builtins.int = ...,
        int5: builtins.int = ...,
        label: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["counter_field", b"counter_field", "end", b"end", "int5", b"int5", "label", b"label", "start", b"start", "value", b"value"]) -> None: ...

global___RemoteTextFieldStatus = RemoteTextFieldStatus

@typing_extensions.final
class RemoteImeShowRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REMOTE_TEXT_FIELD_STATUS_FIELD_NUMBER: builtins.int
    @property
    def remote_text_field_status(self) -> global___RemoteTextFieldStatus: ...
    def __init__(
        self,
        *,
        remote_text_field_status: global___RemoteTextFieldStatus | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["remote_text_field_status", b"remote_text_field_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["remote_text_field_status", b"remote_text_field_status"]) -> None: ...

global___RemoteImeShowRequest = RemoteImeShowRequest

@typing_extensions.final
class RemoteEditInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSERT_FIELD_NUMBER: builtins.int
    insert: builtins.int
    def __init__(
        self,
        *,
        insert: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["insert", b"insert"]) -> None: ...

global___RemoteEditInfo = RemoteEditInfo

@typing_extensions.final
class RemoteImeBatchEdit(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    IME_COUNTER_FIELD_NUMBER: builtins.int
    FIELD_COUNTER_FIELD_NUMBER: builtins.int
    EDIT_INFO_FIELD_NUMBER: builtins.int
    ime_counter: builtins.int
    field_counter: builtins.int
    @property
    def edit_info(self) -> global___RemoteEditInfo: ...
    def __init__(
        self,
        *,
        ime_counter: builtins.int = ...,
        field_counter: builtins.int = ...,
        edit_info: global___RemoteEditInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["edit_info", b"edit_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["edit_info", b"edit_info", "field_counter", b"field_counter", "ime_counter", b"ime_counter"]) -> None: ...

global___RemoteImeBatchEdit = RemoteImeBatchEdit

@typing_extensions.final
class RemoteAppInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COUNTER_FIELD_NUMBER: builtins.int
    INT2_FIELD_NUMBER: builtins.int
    INT3_FIELD_NUMBER: builtins.int
    INT4_FIELD_NUMBER: builtins.int
    INT7_FIELD_NUMBER: builtins.int
    INT8_FIELD_NUMBER: builtins.int
    LABEL_FIELD_NUMBER: builtins.int
    APP_PACKAGE_FIELD_NUMBER: builtins.int
    INT13_FIELD_NUMBER: builtins.int
    counter: builtins.int
    int2: builtins.int
    int3: builtins.int
    int4: builtins.str
    int7: builtins.int
    int8: builtins.int
    label: builtins.str
    app_package: builtins.str
    int13: builtins.int
    def __init__(
        self,
        *,
        counter: builtins.int = ...,
        int2: builtins.int = ...,
        int3: builtins.int = ...,
        int4: builtins.str = ...,
        int7: builtins.int = ...,
        int8: builtins.int = ...,
        label: builtins.str = ...,
        app_package: builtins.str = ...,
        int13: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_package", b"app_package", "counter", b"counter", "int13", b"int13", "int2", b"int2", "int3", b"int3", "int4", b"int4", "int7", b"int7", "int8", b"int8", "label", b"label"]) -> None: ...

global___RemoteAppInfo = RemoteAppInfo

@typing_extensions.final
class RemoteImeKeyInject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    APP_INFO_FIELD_NUMBER: builtins.int
    TEXT_FIELD_STATUS_FIELD_NUMBER: builtins.int
    @property
    def app_info(self) -> global___RemoteAppInfo: ...
    @property
    def text_field_status(self) -> global___RemoteTextFieldStatus: ...
    def __init__(
        self,
        *,
        app_info: global___RemoteAppInfo | None = ...,
        text_field_status: global___RemoteTextFieldStatus | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["app_info", b"app_info", "text_field_status", b"text_field_status"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_info", b"app_info", "text_field_status", b"text_field_status"]) -> None: ...

global___RemoteImeKeyInject = RemoteImeKeyInject

@typing_extensions.final
class RemoteKeyInject(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_CODE_FIELD_NUMBER: builtins.int
    DIRECTION_FIELD_NUMBER: builtins.int
    key_code: global___RemoteKeyCode.ValueType
    direction: global___RemoteDirection.ValueType
    def __init__(
        self,
        *,
        key_code: global___RemoteKeyCode.ValueType = ...,
        direction: global___RemoteDirection.ValueType = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["direction", b"direction", "key_code", b"key_code"]) -> None: ...

global___RemoteKeyInject = RemoteKeyInject

@typing_extensions.final
class RemotePingResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VAL1_FIELD_NUMBER: builtins.int
    val1: builtins.int
    def __init__(
        self,
        *,
        val1: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["val1", b"val1"]) -> None: ...

global___RemotePingResponse = RemotePingResponse

@typing_extensions.final
class RemotePingRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VAL1_FIELD_NUMBER: builtins.int
    VAL2_FIELD_NUMBER: builtins.int
    val1: builtins.int
    val2: builtins.int
    def __init__(
        self,
        *,
        val1: builtins.int = ...,
        val2: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["val1", b"val1", "val2", b"val2"]) -> None: ...

global___RemotePingRequest = RemotePingRequest

@typing_extensions.final
class RemoteSetActive(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTIVE_FIELD_NUMBER: builtins.int
    active: builtins.int
    def __init__(
        self,
        *,
        active: builtins.int = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["active", b"active"]) -> None: ...

global___RemoteSetActive = RemoteSetActive

@typing_extensions.final
class RemoteDeviceInfo(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MODEL_FIELD_NUMBER: builtins.int
    VENDOR_FIELD_NUMBER: builtins.int
    UNKNOWN1_FIELD_NUMBER: builtins.int
    UNKNOWN2_FIELD_NUMBER: builtins.int
    PACKAGE_NAME_FIELD_NUMBER: builtins.int
    APP_VERSION_FIELD_NUMBER: builtins.int
    model: builtins.str
    vendor: builtins.str
    unknown1: builtins.int
    unknown2: builtins.str
    package_name: builtins.str
    app_version: builtins.str
    def __init__(
        self,
        *,
        model: builtins.str = ...,
        vendor: builtins.str = ...,
        unknown1: builtins.int = ...,
        unknown2: builtins.str = ...,
        package_name: builtins.str = ...,
        app_version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["app_version", b"app_version", "model", b"model", "package_name", b"package_name", "unknown1", b"unknown1", "unknown2", b"unknown2", "vendor", b"vendor"]) -> None: ...

global___RemoteDeviceInfo = RemoteDeviceInfo

@typing_extensions.final
class RemoteConfigure(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CODE1_FIELD_NUMBER: builtins.int
    DEVICE_INFO_FIELD_NUMBER: builtins.int
    code1: builtins.int
    @property
    def device_info(self) -> global___RemoteDeviceInfo: ...
    def __init__(
        self,
        *,
        code1: builtins.int = ...,
        device_info: global___RemoteDeviceInfo | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["device_info", b"device_info"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["code1", b"code1", "device_info", b"device_info"]) -> None: ...

global___RemoteConfigure = RemoteConfigure

@typing_extensions.final
class RemoteError(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    value: builtins.bool
    @property
    def message(self) -> global___RemoteMessage: ...
    def __init__(
        self,
        *,
        value: builtins.bool = ...,
        message: global___RemoteMessage | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["message", b"message"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["message", b"message", "value", b"value"]) -> None: ...

global___RemoteError = RemoteError

@typing_extensions.final
class RemoteMessage(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REMOTE_CONFIGURE_FIELD_NUMBER: builtins.int
    REMOTE_SET_ACTIVE_FIELD_NUMBER: builtins.int
    REMOTE_ERROR_FIELD_NUMBER: builtins.int
    REMOTE_PING_REQUEST_FIELD_NUMBER: builtins.int
    REMOTE_PING_RESPONSE_FIELD_NUMBER: builtins.int
    REMOTE_KEY_INJECT_FIELD_NUMBER: builtins.int
    REMOTE_IME_KEY_INJECT_FIELD_NUMBER: builtins.int
    REMOTE_IME_BATCH_EDIT_FIELD_NUMBER: builtins.int
    REMOTE_IME_SHOW_REQUEST_FIELD_NUMBER: builtins.int
    REMOTE_VOICE_BEGIN_FIELD_NUMBER: builtins.int
    REMOTE_VOICE_PAYLOAD_FIELD_NUMBER: builtins.int
    REMOTE_VOICE_END_FIELD_NUMBER: builtins.int
    REMOTE_START_FIELD_NUMBER: builtins.int
    REMOTE_SET_VOLUME_LEVEL_FIELD_NUMBER: builtins.int
    REMOTE_ADJUST_VOLUME_LEVEL_FIELD_NUMBER: builtins.int
    REMOTE_SET_PREFERRED_AUDIO_DEVICE_FIELD_NUMBER: builtins.int
    REMOTE_RESET_PREFERRED_AUDIO_DEVICE_FIELD_NUMBER: builtins.int
    REMOTE_APP_LINK_LAUNCH_REQUEST_FIELD_NUMBER: builtins.int
    @property
    def remote_configure(self) -> global___RemoteConfigure: ...
    @property
    def remote_set_active(self) -> global___RemoteSetActive: ...
    @property
    def remote_error(self) -> global___RemoteError: ...
    @property
    def remote_ping_request(self) -> global___RemotePingRequest: ...
    @property
    def remote_ping_response(self) -> global___RemotePingResponse: ...
    @property
    def remote_key_inject(self) -> global___RemoteKeyInject: ...
    @property
    def remote_ime_key_inject(self) -> global___RemoteImeKeyInject: ...
    @property
    def remote_ime_batch_edit(self) -> global___RemoteImeBatchEdit: ...
    @property
    def remote_ime_show_request(self) -> global___RemoteImeShowRequest: ...
    @property
    def remote_voice_begin(self) -> global___RemoteVoiceBegin: ...
    @property
    def remote_voice_payload(self) -> global___RemoteVoicePayload: ...
    @property
    def remote_voice_end(self) -> global___RemoteVoiceEnd: ...
    @property
    def remote_start(self) -> global___RemoteStart: ...
    @property
    def remote_set_volume_level(self) -> global___RemoteSetVolumeLevel: ...
    @property
    def remote_adjust_volume_level(self) -> global___RemoteAdjustVolumeLevel: ...
    @property
    def remote_set_preferred_audio_device(self) -> global___RemoteSetPreferredAudioDevice: ...
    @property
    def remote_reset_preferred_audio_device(self) -> global___RemoteResetPreferredAudioDevice: ...
    @property
    def remote_app_link_launch_request(self) -> global___RemoteAppLinkLaunchRequest: ...
    def __init__(
        self,
        *,
        remote_configure: global___RemoteConfigure | None = ...,
        remote_set_active: global___RemoteSetActive | None = ...,
        remote_error: global___RemoteError | None = ...,
        remote_ping_request: global___RemotePingRequest | None = ...,
        remote_ping_response: global___RemotePingResponse | None = ...,
        remote_key_inject: global___RemoteKeyInject | None = ...,
        remote_ime_key_inject: global___RemoteImeKeyInject | None = ...,
        remote_ime_batch_edit: global___RemoteImeBatchEdit | None = ...,
        remote_ime_show_request: global___RemoteImeShowRequest | None = ...,
        remote_voice_begin: global___RemoteVoiceBegin | None = ...,
        remote_voice_payload: global___RemoteVoicePayload | None = ...,
        remote_voice_end: global___RemoteVoiceEnd | None = ...,
        remote_start: global___RemoteStart | None = ...,
        remote_set_volume_level: global___RemoteSetVolumeLevel | None = ...,
        remote_adjust_volume_level: global___RemoteAdjustVolumeLevel | None = ...,
        remote_set_preferred_audio_device: global___RemoteSetPreferredAudioDevice | None = ...,
        remote_reset_preferred_audio_device: global___RemoteResetPreferredAudioDevice | None = ...,
        remote_app_link_launch_request: global___RemoteAppLinkLaunchRequest | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["remote_adjust_volume_level", b"remote_adjust_volume_level", "remote_app_link_launch_request", b"remote_app_link_launch_request", "remote_configure", b"remote_configure", "remote_error", b"remote_error", "remote_ime_batch_edit", b"remote_ime_batch_edit", "remote_ime_key_inject", b"remote_ime_key_inject", "remote_ime_show_request", b"remote_ime_show_request", "remote_key_inject", b"remote_key_inject", "remote_ping_request", b"remote_ping_request", "remote_ping_response", b"remote_ping_response", "remote_reset_preferred_audio_device", b"remote_reset_preferred_audio_device", "remote_set_active", b"remote_set_active", "remote_set_preferred_audio_device", b"remote_set_preferred_audio_device", "remote_set_volume_level", b"remote_set_volume_level", "remote_start", b"remote_start", "remote_voice_begin", b"remote_voice_begin", "remote_voice_end", b"remote_voice_end", "remote_voice_payload", b"remote_voice_payload"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["remote_adjust_volume_level", b"remote_adjust_volume_level", "remote_app_link_launch_request", b"remote_app_link_launch_request", "remote_configure", b"remote_configure", "remote_error", b"remote_error", "remote_ime_batch_edit", b"remote_ime_batch_edit", "remote_ime_key_inject", b"remote_ime_key_inject", "remote_ime_show_request", b"remote_ime_show_request", "remote_key_inject", b"remote_key_inject", "remote_ping_request", b"remote_ping_request", "remote_ping_response", b"remote_ping_response", "remote_reset_preferred_audio_device", b"remote_reset_preferred_audio_device", "remote_set_active", b"remote_set_active", "remote_set_preferred_audio_device", b"remote_set_preferred_audio_device", "remote_set_volume_level", b"remote_set_volume_level", "remote_start", b"remote_start", "remote_voice_begin", b"remote_voice_begin", "remote_voice_end", b"remote_voice_end", "remote_voice_payload", b"remote_voice_payload"]) -> None: ...

global___RemoteMessage = RemoteMessage
