% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{sum.integer64}
\alias{sum.integer64}
\alias{any.integer64}
\alias{all.integer64}
\alias{prod.integer64}
\alias{min.integer64}
\alias{max.integer64}
\alias{range.integer64}
\alias{lim.integer64}
\title{Summary functions for integer64 vectors}
\usage{
\method{any}{integer64}(..., na.rm = FALSE)

\method{all}{integer64}(..., na.rm = FALSE)

\method{sum}{integer64}(..., na.rm = FALSE)

\method{prod}{integer64}(..., na.rm = FALSE)

\method{min}{integer64}(..., na.rm = FALSE)

\method{max}{integer64}(..., na.rm = FALSE)

\method{range}{integer64}(..., na.rm = FALSE, finite = FALSE)

lim.integer64()
}
\arguments{
\item{...}{atomic vectors of class 'integer64'}

\item{na.rm}{logical scalar indicating whether to ignore NAs}

\item{finite}{logical scalar indicating whether to ignore NAs (just for
compatibility with \code{\link[=range.default]{range.default()}})}
}
\value{
\code{\link[=all]{all()}} and \code{\link[=any]{any()}} return a logical scalar

\code{\link[=range]{range()}} returns a integer64 vector with two elements

\code{\link[=min]{min()}}, \code{\link[=max]{max()}}, \code{\link[=sum]{sum()}} and \code{\link[=prod]{prod()}} return a integer64 scalar
}
\description{
Summary functions for integer64 vectors. Function 'range' without arguments
returns the smallest and largest value of the 'integer64' class.
}
\details{
The numerical summary methods always return \code{integer64}. Therefore the
methods for \code{min},\code{max} and \code{range} do not return \verb{+Inf,-Inf} on empty
arguments, but \verb{+9223372036854775807, -9223372036854775807} (in this sequence).
The same is true if only  \code{NA}s are submitted with argument \code{na.rm=TRUE}.

\code{lim.integer64} returns these limits in proper order
\verb{-9223372036854775807, +9223372036854775807} and without a \code{\link[=warning]{warning()}}.
}
\examples{
  lim.integer64()
  range(as.integer64(1:12))
}
\seealso{
\code{\link[=mean.integer64]{mean.integer64()}} \code{\link[=cumsum.integer64]{cumsum.integer64()}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
