% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{data}
\name{ExampleData.BINfileData}
\alias{ExampleData.BINfileData}
\alias{CWOSL.SAR.Data}
\alias{TL.SAR.Data}
\title{Example data from a SAR OSL and SAR TL measurement for the package
Luminescence}
\format{
\code{CWOSL.SAR.Data}: SAR OSL measurement data

\code{TL.SAR.Data}: SAR TL measurement data

Each class object contains two slots: (a) \code{METADATA} is a \link{data.frame} with
all metadata stored in the BIN file of the measurements and (b) \code{DATA}
contains a list of vectors of the measured data (usually count values).
}
\source{
\strong{CWOSL.SAR.Data}

\tabular{ll}{
Lab: \tab Luminescence Laboratory Bayreuth \cr
Lab-Code: \tab BT607 \cr
Location: \tab Saxony/Germany \cr
Material: \tab Middle grain quartz measured on aluminium cups on a Risø TL/OSL DA-15 reader\cr
Reference: \tab unpublished
}

\strong{TL.SAR.Data}

\tabular{ll}{
Lab: \tab Luminescence Laboratory of Cologne\cr
Lab-Code: \tab LP1_5\cr
Location: \tab Spain\cr
Material: \tab Flint \cr
Setup: \tab Risoe TL/OSL DA-20 reader (Filter: Semrock Brightline, HC475/50, N2, unpolished steel discs) \cr
Reference: \tab unpublished \cr
Remarks: \tab dataset limited to one position
}
}
\description{
Example data from a SAR OSL and TL measurement for package Luminescence
directly extracted from a Risoe BIN-file and provided in an object of type
\linkS4class{Risoe.BINfileData}
}
\note{
Please note that this example data cannot be exported to a BIN-file using the function
\code{writeR2BIN} as it was generated and implemented in the package long time ago. In the meantime
the BIN-file format changed.
}
\section{Version}{
 0.1
}

\examples{

## show first 5 elements of the METADATA and DATA elements in the terminal
data(ExampleData.BINfileData, envir = environment())
CWOSL.SAR.Data@METADATA[1:5,]
CWOSL.SAR.Data@DATA[1:5]

}
\references{
\strong{CWOSL.SAR.Data}: unpublished data

\strong{TL.SAR.Data}: unpublished data
}
\keyword{datasets}
\keyword{internal}
