% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ne_states.R
\name{ne_states}
\alias{ne_states}
\alias{ne_admin1}
\title{Get natural earth world state (admin level 1) polygons}
\usage{
ne_states(
  country = NULL,
  geounit = NULL,
  iso_a2 = NULL,
  spat_object = NULL,
  returnclass = c("sf", "sv")
)
}
\arguments{
\item{country}{a character vector of country names.}

\item{geounit}{a character vector of geounit names.}

\item{iso_a2}{a character vector of iso_a2 country codes}

\item{spat_object}{an optional alternative states map}

\item{returnclass}{A string determining the spatial object to return. Either
"sf" for for simple feature (from `sf`, the default) or "sv" for a
`SpatVector` (from `terra`).}
}
\value{
An object of class `sf` for simple feature (from `sf`, the default)
or `SpatVector` (from `terra`).
}
\description{
returns state polygons (administrative level 1) for specified countries
}
\details{
Note that the filename of the requested object will be returned if
`load = FALSE`.
}
\examples{

# comparing using country and geounit to filter
if (requireNamespace("rnaturalearthhires")) {
  spdf_france_country <- ne_states(country = "france")
  spdf_france_geounit <- ne_states(geounit = "france")

  plot(spdf_france_country)
  plot(spdf_france_geounit)

  plot(ne_states(country = "united kingdom"))
  plot(ne_states(geounit = "england"))
}

}
\seealso{
\code{\link{ne_load}}, pre-downloaded data are available using
  \code{\link{ne_countries}}, \code{\link{ne_states}}. Other geographic data
  are available in the raster package : \code{\link[raster]{getData}}.
}
