% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/font_outline.R
\name{glyph_raster}
\alias{glyph_raster}
\title{Render glyphs to raster image}
\usage{
glyph_raster(
  glyph,
  path,
  index = 0,
  size = 12,
  res = 300,
  col = "black",
  verbose = FALSE
)
}
\arguments{
\item{glyph}{The index of the glyph in the font file}

\item{path}{The path to the font file encoding the glyph}

\item{index}{The index of the font in the font file}

\item{size}{The size of the font in big points (1/72 inch)}

\item{res}{The resolution to render the glyphs to}

\item{col}{The color of the glyph assuming the glyph doesn't have a native
coloring}

\item{verbose}{Should font and glyph loading errors be reported as warnings}
}
\value{
A list of nativeRaster objects (or \code{NULL} if it failed to render a
given glyph). The nativeRasters have additional attributes attached. \code{"size"}
will give the size of the glyph in big points and \code{"offset"} will give the
location of the top-left corner of the raster with respect to where it should
be rendered.
}
\description{
Not all glyphs are encoded as vector outlines (emojis often not). Even for
fonts that provide an outline you might be interested in a raster version.
This function gives you just that. It converts a glyph into an optimized
raster object that can be plotted with e.g. \code{\link[graphics:rasterImage]{graphics::rasterImage()}} or
\code{\link[grid:grid.raster]{grid::grid.raster()}}. For convenience, you can also use
\code{\link[=glyph_raster_grob]{glyph_raster_grob()}} for plotting the result.
}
\examples{
font <- font_info()
glyph <- glyph_info("R", path = font$path, index = font$index)

R <- glyph_raster(glyph$index, font$path, font$index, size = 150)

plot.new()
plot.window(c(0,150), c(0, 150), asp = 1)
rasterImage(R[[1]], 0, 0, attr(R[[1]], "size")[2], attr(R[[1]], "size")[1])

}
