# Warp - Fast and secure file transfer

Warp allows you to securely send files to each other via the internet or local network by exchanging a word-based code.

The best transfer method will be determined using the [Magic Wormhole](https://github.com/magic-wormhole/magic-wormhole#magic-wormhole) protocol which includes local network transfer if possible. File transfers are encrypted.

[<img width='240' alt='Download on Flathub' src='https://flathub.org/api/badge?svg&locale=en' />](https://flathub.org/apps/details/app.drey.Warp)

[<img width='240' alt='View on apps.gnome.org' src='https://gitlab.gnome.org/World/warp/-/raw/main/data/icons/app.drey.Warp.Badge.png' />](https://apps.gnome.org/Warp/)

[<img width='240' alt='Part of GNOME Circle' src='https://gitlab.gnome.org/Teams/Circle/-/raw/91de93edbb3e75eb0882d56bd466e58b525135d5/assets/button/circle-button-fullcolor.svg' />](https://circle.gnome.org/)

## Features

* Send files between multiple devices
* Every file transfer is encrypted
* Directly transfer files on the local network if possible
* An internet connection is required
* Compatibility with the “Magic Wormhole” command line client

![File Transfer](data/screenshots/screenshot5.png "File Transfer")

## Support

Warp has fairly extensive [help pages](https://world.pages.gitlab.gnome.org/warp/help/C/index.html).

To receive further support, you can join the matrix channel at [#warp:gnome.org](https://matrix.to/#/#warp:gnome.org).

Please report issues and bugs in the [issue tracker](https://gitlab.gnome.org/World/warp/-/issues) in Gitlab.

### QR Codes

The following known applications support QR codes generated by this app:

* Warp
* [Wormhole (Android)](https://play.google.com/store/apps/details?id=eu.heili.wormhole)
* [iyox Wormhole (Android)](https://play.google.com/store/apps/details?id=com.iyox.wormhole)

Using any other applications might lead to problems scanning the code. The QR code standard is fairly new and not all applications have updated their custom QR code format to the standardized version.

## Flatpak

Flatpak is the recommended way to build and run Warp.

## Nightly

### Linux / Flatpak

Download and install the latest flatpak build from gitlab

```shell
wget "https://gitlab.gnome.org/api/v4/projects/19921/jobs/artifacts/main/raw/warp-nightly.flatpak?job=flatpak" -O warp-nightly.flatpak
flatpak install warp-nightly.flatpak
```

### Windows

Extract the archive to a directory of your choice and run `warp.exe`. The [0.6.2 release](https://gitlab.gnome.org/World/warp/-/releases/v0.6.2) is the latest Windows release.

### Build

Make sure you have `flatpak` and `flatpak-builder` installed. Then run the command below.

This will add the `flathub` and `gnome-nightly` repositories to your flatpak user installation.

```shell
build-aux/flatpak-build.sh dev
```

### Run

Once the project is built, run the command below.

```shell
flatpak-builder --run app app.drey.Warp.Devel.json warp
```

### Install

After installing the dependencies you can build and install with this command:

```shell
cd build-aux
flatpak-builder --install --user app app.drey.Warp.Devel.json warp --force-clean 
```

## Meson

It is supported to install the project locally without flatpak.

```shell
meson setup build
ninja -C build
ninja -C build install
```

To uninstall:

```shell
sudo ninja -C uninstall
``` 

It is required to test any big changes with flatpak before contributing any new code.

# Contributing
See the [Contribution guide](./CONTRIBUTING.md) on how to contribute to the project
