
#include <ctype.h> 
#include <fli.h>
#include <stdio.h>
#include <string.h> 

void fli_help_browser_cb (FL_OBJECT *ob, long data)
{
    register int
	thisindex = (int) data,
	active = 0;
    register FILE
	*f = fli_help_browser [thisindex].f;
    char
	selection [1025],
	buf [1025],
	*cp;
    register FL_FORM
	*form = fli_help_browser [thisindex].form;
    register FL_OBJECT
	*textw = fli_help_browser [thisindex].textbrowser;

    /* determine clicked selection, put it in variable selection */
    strcpy (buf, fl_get_browser_line (ob, fl_get_browser (ob)));

    if (ob == textw)		/* for text window, strip off [] */ 
    {
	if (sscanf (buf, "%*[^[][%s]", selection) < 1)
	    return;
	if (! (cp = strchr (selection, ']')) )
	    return;
	* (cp + 1) = '\0';
    }
    else			/* for index/contents, strip off whitesp */
    {
	cp = buf;
	while (isspace (*cp))
	    cp++;
	strcpy (selection, cp);
	if ( (cp = strchr (selection, '\n')) )
	    *cp = '\0';
	strcat (selection, "]");
    }

    /* selection is now the string and a terminating ] , but not
       the leading [ */ 

    rewind (f);
    fl_clear_browser (textw);

    fl_freeze_form (form);
    while (1)
    {
	fgets (buf, 1024, f);
	if (feof (f))
	    break;

	if (buf [0] == '[')
	{
	    if (active)
		break;
	    else if (! strncmp (buf + 1, selection, strlen (selection)))
		active = 1;
	}
	else
	{
	    if (active)
		fl_add_browser_line (textw, buf);
	}
    }
    fl_unfreeze_form (form);

    /* all done */ 
}
    
