/*
            Copyright Oliver Kowalke 2009.
            Copyright Thomas Sailer 2013.
   Distributed under the Boost Software License, Version 1.0.
      (See accompanying file LICENSE_1_0.txt or copy at
            http://www.boost.org/LICENSE_1_0.txt)
*/

/****************************************************************************************
 *                                                                                      *
 *  ----------------------------------------------------------------------------------
 *  |    0    |    1    |                                                            |
 *  ----------------------------------------------------------------------------------
 *  |   0x0   |   0x4   |                                                            |
 *  ----------------------------------------------------------------------------------
 *  |    <indicator>    |                                                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    2    |    3    |    4     |    5    |    6    |    7    |    8    |    9    |
 *  ----------------------------------------------------------------------------------
 *  |   0x8   |   0xc   |   0x10   |   0x14  |   0x18  |   0x1c  |   0x20  |   0x24  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |   10    |   11    |    12    |    13   |    14   |    15   |    16   |    17   |
 *  ----------------------------------------------------------------------------------
 *  |   0x28  |  0x2c   |   0x30   |   0x34  |   0x38  |   0x3c  |   0x40  |   0x44  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    18   |    19   |    20   |    21    |    22   |    23   |    24   |    25   |
 *  ----------------------------------------------------------------------------------
 *  |   0x48  |   0x4c  |   0x50  |   0x54   |   0x58  |   0x5c  |  0x60   |   0x64  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    26   |    27   |    28    |   29    |    30   |    31   |    32   |    33   |
 *  ----------------------------------------------------------------------------------
 *  |   0x68  |   0x6c  |   0x70   |   0x74  |   0x78  |   0x7c  |   0x80  |   0x84  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    34    |   35   |    36    |    37   |    38   |    39   |    40   |    41   |
 *  ----------------------------------------------------------------------------------
 *  |   0x88   |  0x8c  |   0x90   |   0x94  |   0x98  |   0x9c  |   0xa0  |   0xa4  |
 *  ----------------------------------------------------------------------------------
 *  |                          SEE registers (XMM6-XMM15)                            |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    42   |    43   |    44    |    45   |    46   |    47   |    48   |    49   |
 *  ----------------------------------------------------------------------------------
 *  |   0xa8  |   0xac  |   0xb0   |   0xb4  |   0xb8  |   0xbc  |   0xc0  |   0xc4  |
 *  ----------------------------------------------------------------------------------
 *  | fc_mxcsr|fc_x87_cw|     <alignment>    |      fbr_strg     |      fc_dealloc   |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    50   |   51    |    52    |    53   |    54   |    55   |    56   |    57   |
 *  ----------------------------------------------------------------------------------
 *  |   0xc8  |  0xcc   |   0xd0   |   0xd4  |   0xd8  |   0xdc  |   0xe0  |   0xe4  |
 *  ----------------------------------------------------------------------------------
 *  |      limit        |       base         |      R12          |        R13        |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    58   |    59   |    60   |    61    |    62   |    63   |    64   |    65   |
 *  ----------------------------------------------------------------------------------
 *  |   0xe8  |   0xec  |   0xf0  |   0xf4   |   0xf8  |   0xfc  |  0x100  |  0x104  |
 *  ----------------------------------------------------------------------------------
 *  |        R14        |        R15         |       RDI         |       RSI         |
 *  ----------------------------------------------------------------------------------
 *  ----------------------------------------------------------------------------------
 *  |    66   |   67    |    68    |   69    |    70   |  71     |    72   |    73   |
 *  ----------------------------------------------------------------------------------
 *  |  0x108  |  0x10c  |  0x110   |  0x114  |  0x118  |  0x11c  |  0x120  |  0x124  |
 *  ----------------------------------------------------------------------------------
 *  |        RBX        |         RBP        |        RIP        |       EXIT        |
 *  ----------------------------------------------------------------------------------
 *                                                                                      *
 * *************************************************************************************/

.file	"jump_x86_64_ms_pe_gas.asm"
.text
.p2align 4,,15
.globl	jump_fcontext_v1
.def	jump_fcontext_v1;	.scl	2;	.type	32;	.endef
.seh_proc	jump_fcontext_v1
jump_fcontext_v1:
.seh_endprologue

    pushq  %rbp  /* save RBP */
    pushq  %rbx  /* save RBX */
    pushq  %rsi  /* save RSI */
    pushq  %rdi  /* save RDI */
    pushq  %r15  /* save R15 */
    pushq  %r14  /* save R14 */
    pushq  %r13  /* save R13 */
    pushq  %r12  /* save R12 */

    /* load NT_TIB */
    movq  %gs:(0x30), %r10
    /* save current stack base */
    movq  0x08(%r10), %rax
    pushq  %rax
    /* save current stack limit */
    movq  0x10(%r10), %rax
    pushq  %rax
    /* save current deallocation stack */
    movq  0x1478(%r10), %rax
    pushq  %rax
    /* save fiber local storage */
    movq  0x18(%r10), %rax
    pushq  %rax

    /* prepare stack for FPU */
    leaq  -0xa8(%rsp), %rsp

    /* test for flag preserve_fpu */
    testq  %r9, %r9
    je  1f

    /* save MMX control- and status-word */
    stmxcsr  0xa0(%rsp)
    /* save x87 control-word */
    fnstcw  0xa4(%rsp)

    /* save XMM storage */
    movaps  %xmm6, (%rsp)
    movaps  %xmm7, 0x10(%rsp)
    movaps  %xmm8, 0x20(%rsp)
    movaps  %xmm9, 0x30(%rsp)
    movaps  %xmm10, 0x40(%rsp)
    movaps  %xmm11, 0x50(%rsp)
    movaps  %xmm12, 0x60(%rsp)
    movaps  %xmm13, 0x70(%rsp)
    movaps  %xmm14, 0x80(%rsp)
    movaps  %xmm15, 0x90(%rsp)

1:
    /* set R10 to zero */
    xorq  %r10, %r10
    /* set indicator */
    pushq  %r10

    /* store RSP (pointing to context-data) in RCX */
    movq  %rsp, (%rcx)

    /* restore RSP (pointing to context-data) from RDX */
    movq  %rdx, %rsp

    /* load indicator */
    popq  %r10

    /* test for flag preserve_fpu */
    testq  %r9, %r9
    je  2f

    /* restore MMX control- and status-word */
    ldmxcsr  0xa0(%rsp)
    /* save x87 control-word */
    fldcw  0xa4(%rsp)

    /* restore XMM storage */
    movaps  (%rsp), %xmm6
    movaps  0x10(%rsp), %xmm7
    movaps  0x20(%rsp), %xmm8
    movaps  0x30(%rsp), %xmm9
    movaps  0x40(%rsp), %xmm10
    movaps  0x50(%rsp), %xmm11
    movaps  0x60(%rsp), %xmm12
    movaps  0x70(%rsp), %xmm13
    movaps  0x80(%rsp), %xmm14
    movaps  0x90(%rsp), %xmm15

2:
    /* set offset of stack */
    movq  0xa8, %rcx

    /* test for indicator */
    testq  %r10, %r10
    je  3f

    addq  0x8, %rcx

3:
    /* prepare stack for FPU */
    leaq (%rsp,%rcx), %rsp

    /* load NT_TIB */
    movq  %gs:(0x30), %r10
    /* restore fiber local storage */
    popq  %rax
    movq  %rax, 0x18(%r10)
    /* restore deallocation stack */
    popq  %rax
    movq  %rax, 0x1478(%r10)
    /* restore stack limit */
    popq  %rax
    movq  %rax, 0x10(%r10)
    /* restore stack base */
    popq  %rax
    movq  %rax, 0x8(%r10)

    popq  %r12  /* restore R12 */
    popq  %r13  /* restore R13 */
    popq  %r14  /* restore R14 */
    popq  %r15  /* restore R15 */
    popq  %rdi  /* restore RDI */
    popq  %rsi  /* restore RSI */
    popq  %rbx  /* restore RBX */
    popq  %rbp  /* restore RBP */

    /* restore return-address */
    popq  %r10

    /* use third arg as return-value after jump */
    movq  %r8, %rax
    /* use third arg as first arg in context function */
    movq  %r8, %rcx

    /* indirect jump to context */
    jmp  *%r10
.seh_endproc
