/**

BSD 3-Clause License

Copyright (c) 2011-present, Phalcon Team
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived from
  this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <math.h>
#include <ctype.h>
#include <stdlib.h>

#include <main/php.h>

#define ZEPHIR_RELEASE 1
#define PHALCON_RELEASE 1

#include "php_phalcon.h"
#include "phalcon.zep.h"

#include <main/php_main.h>
#include <main/php_variables.h>
#include <main/php_streams.h>
#include <main/php_output.h>
#include <main/php_ini.h>
#include <main/SAPI.h>
#include <ext/standard/php_string.h>
#include <ext/standard/php_smart_string.h>
#include <ext/standard/info.h>
#include <ext/standard/file.h>
#include <ext/standard/php_filestat.h>
#include <ext/standard/php_rand.h>
#include <ext/standard/php_lcg.h>
#include <ext/standard/php_math.h>
#include <ext/standard/php_array.h>
#include <ext/standard/php_var.h>
#include <ext/standard/php_http.h>
#include <ext/standard/php_versioning.h>
#include <ext/standard/html.h>
#include <ext/standard/base64.h>
#include <ext/standard/md5.h>
#include <ext/standard/head.h>
#include <ext/standard/url.h>
#include <ext/standard/crc32.h>

#include <ext/spl/spl_heap.h>
#include <ext/spl/spl_exceptions.h>
#include <ext/spl/spl_directory.h>
#include <ext/spl/spl_iterators.h>
#include <ext/spl/spl_array.h>

#if defined ZEPHIR_USE_PHP_PCRE && ZEPHIR_USE_PHP_PCRE
#include <ext/pcre/php_pcre.h>
#endif

#include <ext/pdo/php_pdo_driver.h>
#include <ext/hash/php_hash.h>
#include <ext/date/php_date.h>
#include <ext/json/php_json.h>
#include <ext/session/php_session.h>

#include <Zend/zend_API.h>
#include <Zend/zend_operators.h>
#include <Zend/zend_exceptions.h>
#include <Zend/zend_interfaces.h>
#include <Zend/zend_execute.h>
#include <Zend/zend_extensions.h>
#include <Zend/zend_builtin_functions.h>
#include <Zend/zend_closures.h>
#include <Zend/zend_multiply.h>
#include <Zend/zend_generators.h>



#ifndef PHALCON_ANNOTATIONS_SCANNER_H
#define PHALCON_ANNOTATIONS_SCANNER_H

#define PHANNOT_SCANNER_RETCODE_EOF -1
#define PHANNOT_SCANNER_RETCODE_ERR -2
#define PHANNOT_SCANNER_RETCODE_IMPOSSIBLE -3

/** Modes */
#define PHANNOT_MODE_RAW 0
#define PHANNOT_MODE_ANNOTATION 1

#define PHANNOT_T_IGNORE 297

#define PHANNOT_T_DOCBLOCK_ANNOTATION 299
#define PHANNOT_T_ANNOTATION 300

/* Literals & Identifiers */
#define PHANNOT_T_INTEGER 301
#define PHANNOT_T_DOUBLE 302
#define PHANNOT_T_STRING 303
#define PHANNOT_T_NULL 304
#define PHANNOT_T_FALSE 305
#define PHANNOT_T_TRUE 306
#define PHANNOT_T_IDENTIFIER 307
#define PHANNOT_T_ARRAY 308
#define PHANNOT_T_ARBITRARY_TEXT 309

/* Operators */
#define PHANNOT_T_AT '@'
#define PHANNOT_T_DOT '.'
#define PHANNOT_T_COMMA ','
#define PHANNOT_T_EQUALS '='
#define PHANNOT_T_COLON ':'
#define PHANNOT_T_BRACKET_OPEN '{'
#define PHANNOT_T_BRACKET_CLOSE '}'
#define PHANNOT_T_SBRACKET_OPEN '['
#define PHANNOT_T_SBRACKET_CLOSE ']'
#define PHANNOT_T_PARENTHESES_OPEN '('
#define PHANNOT_T_PARENTHESES_CLOSE ')'

/* List of tokens and their names */
typedef struct _phannot_token_names {
	char *name;
	unsigned int code;
} phannot_token_names;

/* Active token state */
typedef struct _phannot_scanner_state {
	char* start;
	char* end;
	int active_token;
	unsigned int start_length;
	int mode;
	unsigned int active_line;
	const char *active_file;
} phannot_scanner_state;

/* Extra information tokens */
typedef struct _phannot_scanner_token {
	char *value;
	int opcode;
	int len;
} phannot_scanner_token;

static int phannot_get_token(phannot_scanner_state *s, phannot_scanner_token *token);

const phannot_token_names phannot_tokens[];

#endif /* PHALCON_ANNOTATIONS_SCANNER_H */


/* annot.h
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifndef PHALCON_ANNOTATIONS_ANNOT_H
#define PHALCON_ANNOTATIONS_ANNOT_H


typedef struct _phannot_parser_token {
	char *token;
	int opcode;
	int token_len;
	int free_flag;
} phannot_parser_token;

typedef struct _phannot_parser_status {
	zval ret;
	phannot_scanner_state *scanner_state;
	phannot_scanner_token *token;
	char *syntax_error;
	int status;
} phannot_parser_status;

#define PHANNOT_PARSING_OK 1
#define PHANNOT_PARSING_FAILED 0

static int phannot_parse_annotations(zval *result, zval *comment, zval *file_path, zval *line);
static int phannot_internal_parse_annotations(zval **result, const char *comment, int comment_len, const char *file_path, int line, char **error_msg);

#endif /* PHALCON_ANNOTATIONS_ANNOT_H */




static void phalcon_orm_destroy_cache();
static void phalcon_orm_singlequotes(zval *return_value, zval *str);


/* scanner.h
 *
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifndef PHALCON_MVC_MODEL_QUERY_SCANNER_H
#define PHALCON_MVC_MODEL_QUERY_SCANNER_H

#define PHQL_SCANNER_RETCODE_EOF -1
#define PHQL_SCANNER_RETCODE_ERR -2
#define PHQL_SCANNER_RETCODE_IMPOSSIBLE -3

#define PHQL_T_IGNORE 257

/* Literals & Identifiers */
#define PHQL_T_INTEGER 258
#define PHQL_T_DOUBLE 259
#define PHQL_T_STRING 260
#define PHQL_T_IDENTIFIER 265
#define PHQL_T_HINTEGER 414

/* Operators */
#define PHQL_T_ADD '+'
#define PHQL_T_SUB '-'
#define PHQL_T_MUL '*'
#define PHQL_T_DIV '/'
#define PHQL_T_MOD '%'
#define PHQL_T_BITWISE_AND '&'
#define PHQL_T_BITWISE_OR '|'
#define PHQL_T_BITWISE_XOR '^'
#define PHQL_T_BITWISE_NOT '~'
#define PHQL_T_AND 266
#define PHQL_T_OR 267
#define PHQL_T_LIKE 268
#define PHQL_T_ILIKE 275
#define PHQL_T_AGAINST 276

#define PHQL_T_DOT '.'
#define PHQL_T_COMMA 269
#define PHQL_T_COLON ':'

#define PHQL_T_EQUALS '='
#define PHQL_T_NOTEQUALS 270
#define PHQL_T_NOT '!'
#define PHQL_T_LESS '<'
#define PHQL_T_LESSEQUAL 271
#define PHQL_T_GREATER '>'
#define PHQL_T_GREATEREQUAL 272

#define PHQL_T_PARENTHESES_OPEN '('
#define PHQL_T_PARENTHESES_CLOSE ')'

/** Placeholders */
#define PHQL_T_NPLACEHOLDER 273
#define PHQL_T_SPLACEHOLDER 274
#define PHQL_T_BPLACEHOLDER 277

/** Reserved words */
#define PHQL_T_UPDATE 300
#define PHQL_T_SET 301
#define PHQL_T_WHERE 302
#define PHQL_T_DELETE 303
#define PHQL_T_FROM 304
#define PHQL_T_AS 305
#define PHQL_T_INSERT 306
#define PHQL_T_INTO 307
#define PHQL_T_VALUES 308
#define PHQL_T_SELECT 309
#define PHQL_T_ORDER 310
#define PHQL_T_BY 311
#define PHQL_T_LIMIT 312
#define PHQL_T_GROUP 313
#define PHQL_T_HAVING 314
#define PHQL_T_IN 315
#define PHQL_T_ON 316
#define PHQL_T_INNER 317
#define PHQL_T_JOIN 318
#define PHQL_T_LEFT 319
#define PHQL_T_RIGHT 320
#define PHQL_T_IS 321
#define PHQL_T_NULL 322
#define PHQL_T_NOTIN 323
#define PHQL_T_CROSS 324
#define PHQL_T_FULL 325
#define PHQL_T_OUTER 326
#define PHQL_T_ASC 327
#define PHQL_T_DESC 328
#define PHQL_T_OFFSET 329
#define PHQL_T_DISTINCT 330
#define PHQL_T_BETWEEN 331
#define PHQL_T_BETWEEN_NOT 332
#define PHQL_T_CAST 333
#define PHQL_T_TRUE 334
#define PHQL_T_FALSE 335
#define PHQL_T_CONVERT 336
#define PHQL_T_USING 337
#define PHQL_T_ALL 338
#define PHQL_T_FOR 339

/** Special Tokens */
#define PHQL_T_FCALL 350
#define PHQL_T_NLIKE 351
#define PHQL_T_STARALL 352
#define PHQL_T_DOMAINALL 353
#define PHQL_T_EXPR 354
#define PHQL_T_QUALIFIED 355
#define PHQL_T_ENCLOSED 356
#define PHQL_T_NILIKE 357
#define PHQL_T_RAW_QUALIFIED 358

#define PHQL_T_INNERJOIN 360
#define PHQL_T_LEFTJOIN 361
#define PHQL_T_RIGHTJOIN 362
#define PHQL_T_CROSSJOIN 363
#define PHQL_T_FULLJOIN 364
#define PHQL_T_ISNULL 365
#define PHQL_T_ISNOTNULL 366
#define PHQL_T_MINUS 367

/** Postgresql Text Search Operators */
#define PHQL_T_TS_MATCHES 401
#define PHQL_T_TS_OR 402
#define PHQL_T_TS_AND 403
#define PHQL_T_TS_NEGATE 404
#define PHQL_T_TS_CONTAINS_ANOTHER 405
#define PHQL_T_TS_CONTAINS_IN 406

#define PHQL_T_SUBQUERY 407
#define PHQL_T_EXISTS 408

#define PHQL_T_CASE 409
#define PHQL_T_WHEN 410
#define PHQL_T_ELSE 411
#define PHQL_T_END 412
#define PHQL_T_THEN 413
#define PHQL_T_WITH 415

/* list of tokens and their names */
typedef struct _phql_token_names {
	char *name;
	unsigned int length;
	unsigned int code;
} phql_token_names;

/* active token state */
typedef struct _phql_scanner_state {
	int active_token;
	unsigned int start_length;
	char* start;
	char* end;
} phql_scanner_state;

/* extra information tokens */
typedef struct _phql_scanner_token {
	char *value;
	int opcode;
	unsigned int len;
} phql_scanner_token;

static int phql_get_token(phql_scanner_state *s, phql_scanner_token *token);

const phql_token_names phql_tokens[];

#endif  /* PHALCON_MVC_MODEL_QUERY_SCANNER_H */


/* phql.h
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifndef PHALCON_MVC_MODEL_QUERY_PHQL_H
#define PHALCON_MVC_MODEL_QUERY_PHQL_H

typedef struct _phql_parser_token {
	char *token;
	int opcode;
	unsigned int token_len;
	int free_flag;
} phql_parser_token;

typedef struct _phql_parser_status {
	zval ret;
	char* phql;
	unsigned int phql_length;
	int status;
	phql_scanner_state *scanner_state;
	phql_scanner_token *token;
	char *syntax_error;
	unsigned int syntax_error_len;
	zend_bool enable_literals;
} phql_parser_status;

#define PHQL_PARSING_OK 1
#define PHQL_PARSING_FAILED 0

static int phql_parse_phql(zval *result, zval *phql);
static int phql_internal_parse_phql(zval **result, char *phql, unsigned int phql_length, zval **error_msg);

#endif /* PHALCON_MVC_MODEL_QUERY_PHQL_H */


/* scanner.h
 *
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifndef PHALCON_MVC_VIEW_ENGINE_VOLT_SCANNER_H
#define PHALCON_MVC_VIEW_ENGINE_VOLT_SCANNER_H


#define PHVOLT_RAW_BUFFER_SIZE 256

#define PHVOLT_SCANNER_RETCODE_EOF -1
#define PHVOLT_SCANNER_RETCODE_ERR -2
#define PHVOLT_SCANNER_RETCODE_IMPOSSIBLE -3

/** Modes */
#define PHVOLT_MODE_RAW 0
#define PHVOLT_MODE_CODE 1
#define PHVOLT_MODE_COMMENT 2

#define PHVOLT_T_IGNORE 257

/* Literals & Identifiers */
#define PHVOLT_T_INTEGER 258
#define PHVOLT_T_DOUBLE 259
#define PHVOLT_T_STRING 260
#define PHVOLT_T_NULL 261
#define PHVOLT_T_FALSE 262
#define PHVOLT_T_TRUE 263
#define PHVOLT_T_IDENTIFIER 265

/* Operators */
#define PHVOLT_T_ADD '+'
#define PHVOLT_T_SUB '-'
#define PHVOLT_T_MUL '*'
#define PHVOLT_T_DIV '/'
#define PHVOLT_T_MOD '%'
#define PHVOLT_T_AND 266
#define PHVOLT_T_OR 267
#define PHVOLT_T_CONCAT '~'
#define PHVOLT_T_PIPE '|'

#define PHVOLT_T_DOT '.'
#define PHVOLT_T_COMMA 269

#define PHVOLT_T_NOT '!'
#define PHVOLT_T_LESS '<'
#define PHVOLT_T_LESSEQUAL 270
#define PHVOLT_T_GREATER '>'
#define PHVOLT_T_GREATEREQUAL 271
#define PHVOLT_T_EQUALS 272
#define PHVOLT_T_NOTEQUALS 273
#define PHVOLT_T_IDENTICAL 274
#define PHVOLT_T_NOTIDENTICAL 275
#define PHVOLT_T_RANGE 276
#define PHVOLT_T_ASSIGN '='
#define PHVOLT_T_COLON 277
#define PHVOLT_T_QUESTION '?'
#define PHVOLT_T_POW 278
#define PHVOLT_T_INCR 279
#define PHVOLT_T_DECR 280
#define PHVOLT_T_ADD_ASSIGN 281
#define PHVOLT_T_SUB_ASSIGN 282
#define PHVOLT_T_MUL_ASSIGN 283
#define PHVOLT_T_DIV_ASSIGN 284

#define PHVOLT_T_PARENTHESES_OPEN '('
#define PHVOLT_T_PARENTHESES_CLOSE ')'
#define PHVOLT_T_SBRACKET_OPEN '['
#define PHVOLT_T_SBRACKET_CLOSE ']'
#define PHVOLT_T_CBRACKET_OPEN '{'
#define PHVOLT_T_CBRACKET_CLOSE '}'

/** Reserved words */
#define PHVOLT_T_IF 300
#define PHVOLT_T_ELSE 301
#define PHVOLT_T_ELSEIF 302
#define PHVOLT_T_ENDIF 303
#define PHVOLT_T_FOR 304
#define PHVOLT_T_ENDFOR 305
#define PHVOLT_T_SET 306
#define PHVOLT_T_BLOCK 307
#define PHVOLT_T_ENDBLOCK 308
#define PHVOLT_T_IN 309
#define PHVOLT_T_EXTENDS 310
#define PHVOLT_T_IS 311
#define PHVOLT_T_DEFINED 312
#define PHVOLT_T_INCLUDE 313
#define PHVOLT_T_CACHE 314
#define PHVOLT_T_ENDCACHE 315
#define PHVOLT_T_DO 316
#define PHVOLT_T_AUTOESCAPE 317
#define PHVOLT_T_ENDAUTOESCAPE 318
#define PHVOLT_T_CONTINUE 319
#define PHVOLT_T_BREAK 320
#define PHVOLT_T_ELSEFOR 321
#define PHVOLT_T_MACRO 322
#define PHVOLT_T_ENDMACRO 323
#define PHVOLT_T_WITH 324
#define PHVOLT_T_CALL 325
#define PHVOLT_T_ENDCALL 326
#define PHVOLT_T_RETURN 327

/** Delimiters */
#define PHVOLT_T_OPEN_DELIMITER  330
#define PHVOLT_T_CLOSE_DELIMITER  331
#define PHVOLT_T_OPEN_EDELIMITER  332
#define PHVOLT_T_CLOSE_EDELIMITER  333

/** Special Tokens */
#define PHVOLT_T_FCALL 350
#define PHVOLT_T_EXPR 354
#define PHVOLT_T_QUALIFIED 355
#define PHVOLT_T_ENCLOSED 356
#define PHVOLT_T_RAW_FRAGMENT 357
#define PHVOLT_T_EMPTY_STATEMENT 358
#define PHVOLT_T_ECHO 359
#define PHVOLT_T_ARRAY 360
#define PHVOLT_T_ARRAYACCESS 361
#define PHVOLT_T_NOT_ISSET 362
#define PHVOLT_T_ISSET 363
#define PHVOLT_T_RESOLVED_EXPR 364
#define PHVOLT_T_SLICE 365
#define PHVOLT_T_TERNARY 366
#define PHVOLT_T_NOT_IN 367

#define PHVOLT_T_MINUS 368
#define PHVOLT_T_PLUS 369

#define PHVOLT_T_EMPTY 380
#define PHVOLT_T_EVEN 381
#define PHVOLT_T_ODD 382
#define PHVOLT_T_NUMERIC 383
#define PHVOLT_T_SCALAR 384
#define PHVOLT_T_ITERABLE 385

#define PHVOLT_T_ISEMPTY 386
#define PHVOLT_T_ISEVEN 387
#define PHVOLT_T_ISODD 388
#define PHVOLT_T_ISNUMERIC 389
#define PHVOLT_T_ISSCALAR 390
#define PHVOLT_T_ISITERABLE 391

#define PHVOLT_T_NOT_ISEMPTY 392
#define PHVOLT_T_NOT_ISEVEN 393
#define PHVOLT_T_NOT_ISODD 394
#define PHVOLT_T_NOT_ISNUMERIC 395
#define PHVOLT_T_NOT_ISSCALAR 396
#define PHVOLT_T_NOT_ISITERABLE 397

#define PHVOLT_T_RAW 400
#define PHVOLT_T_ENDRAW 401

/* switch-case statement */
#define PHVOLT_T_SWITCH 411
#define PHVOLT_T_CASE 412
#define PHVOLT_T_DEFAULT 413
#define PHVOLT_T_ENDSWITCH 414

/* List of tokens and their names */
typedef struct _phvolt_token_names { /* {{{ */
	char *name;
	int len;
	unsigned int code;
} phvolt_token_names;
/* }}} */

/* Contains all state for a single scan session.
 *
 * This structure is used by a scanner to preserve its state.
 *
 * TODO: Make all charptrs declared as const to help ensure that
 * you don't accidentally end up modifying the buffer as it's being
 * scanned. This means that any time you want to read data into the
 * buffer, you need to cast the pointers to be nonconst.
 */
typedef struct _phvolt_scanner_state { /* {{{ */
	int active_token;
	int mode;

	/* The current character being looked at by the scanner.
	 * This is the same as re2c's YYCURSOR. */
	char *start;

	/* The last (uppermost) valid character in the current buffer.
	 * This is the same as re2c's YYLIMIT. */
	char *end;

	/* Used internally by re2c engine to handle backtracking.
	 * This is the same as re2c's YYMARKER. */
	char *marker;

	unsigned int start_length;
	unsigned int active_line;
	zval *active_file;
	unsigned int statement_position;
	unsigned int extends_mode;
	unsigned int block_level;
	unsigned int macro_level;
	char *raw_buffer;
	unsigned int raw_buffer_cursor;
	unsigned int raw_buffer_size;
	unsigned int old_if_level;
	unsigned int if_level;
	unsigned int for_level;
	unsigned int switch_level;
	int whitespace_control;
	int forced_raw_state;
} phvolt_scanner_state;
/* }}} */

/* Extra information tokens */
typedef struct _phvolt_scanner_token { /* {{{ */
	int opcode;
	int len;
	char *value;
} phvolt_scanner_token;
/* }}} */

static int phvolt_get_token(phvolt_scanner_state *s, phvolt_scanner_token *token);

const phvolt_token_names phvolt_tokens[];

#ifdef YYDEBUG
#undef YYDEBUG
#endif

/* The YYDEBUG macro is designed to produce of trace information,
 * that will be written on stderr. Change next line to "#if 1"
 * to enable scanner tracing.
 */
#if 0

#define YYDEBUG(s, c) do { \
	fprintf(stderr, "State: %d char: '%c'\n", s, c); \
} while(0);
#else
#define YYDEBUG(s, c)
#endif

#endif  /* PHALCON_MVC_VIEW_ENGINE_VOLT_SCANNER_H */



/* volt.h
 *
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifndef PHALCON_MVC_VIEW_ENGINE_VOLT_VOLT_H
#define PHALCON_MVC_VIEW_ENGINE_VOLT_VOLT_H

typedef struct _phvolt_parser_token { /* {{{ */
	char *token;
	int opcode;
	int token_len;
	int free_flag;
} phvolt_parser_token;
/* }}} */

typedef struct _phvolt_parser_status { /* {{{ */
	zval ret;
	phvolt_scanner_state *scanner_state;
	int status;
	unsigned int syntax_error_len;
	char *syntax_error;
	phvolt_scanner_token *token;
} phvolt_parser_status;
/* }}} */

#define PHVOLT_PARSING_OK 1
#define PHVOLT_PARSING_FAILED 0

static int phvolt_parse_view(zval *result, zval *view_code, zval *template_path);
static int phvolt_internal_parse_view(zval **result, zval *view_code, zval *template_path, zval **error_msg);

#endif // PHALCON_MVC_VIEW_ENGINE_VOLT_VOLT_H

/* Local variables:
 * tab-width: 4
 * c-basic-offset: 4
 * End:
 * vim600: noet sw=4 ts=4 fdm=marker
 * vim<600: noet sw=4 ts=4
 */


#define PHQL_AGAINST                         1
#define PHQL_BETWEEN                         2
#define PHQL_BETWEEN_NOT                     3
#define PHQL_EQUALS                          4
#define PHQL_NOTEQUALS                       5
#define PHQL_LESS                            6
#define PHQL_GREATER                         7
#define PHQL_GREATEREQUAL                    8
#define PHQL_LESSEQUAL                       9
#define PHQL_AND                            10
#define PHQL_OR                             11
#define PHQL_LIKE                           12
#define PHQL_ILIKE                          13
#define PHQL_BITWISE_AND                    14
#define PHQL_BITWISE_OR                     15
#define PHQL_BITWISE_XOR                    16
#define PHQL_DIVIDE                         17
#define PHQL_TIMES                          18
#define PHQL_MOD                            19
#define PHQL_PLUS                           20
#define PHQL_MINUS                          21
#define PHQL_IS                             22
#define PHQL_IN                             23
#define PHQL_NOT                            24
#define PHQL_BITWISE_NOT                    25
#define PHQL_COMMA                          26
#define PHQL_SELECT                         27
#define PHQL_FROM                           28
#define PHQL_DISTINCT                       29
#define PHQL_ALL                            30
#define PHQL_IDENTIFIER                     31
#define PHQL_DOT                            32
#define PHQL_AS                             33
#define PHQL_INNER                          34
#define PHQL_JOIN                           35
#define PHQL_CROSS                          36
#define PHQL_LEFT                           37
#define PHQL_OUTER                          38
#define PHQL_RIGHT                          39
#define PHQL_FULL                           40
#define PHQL_ON                             41
#define PHQL_INSERT                         42
#define PHQL_INTO                           43
#define PHQL_VALUES                         44
#define PHQL_PARENTHESES_OPEN               45
#define PHQL_PARENTHESES_CLOSE              46
#define PHQL_UPDATE                         47
#define PHQL_SET                            48
#define PHQL_DELETE                         49
#define PHQL_WITH                           50
#define PHQL_WHERE                          51
#define PHQL_ORDER                          52
#define PHQL_BY                             53
#define PHQL_ASC                            54
#define PHQL_DESC                           55
#define PHQL_GROUP                          56
#define PHQL_HAVING                         57
#define PHQL_FOR                            58
#define PHQL_LIMIT                          59
#define PHQL_OFFSET                         60
#define PHQL_INTEGER                        61
#define PHQL_HINTEGER                       62
#define PHQL_NPLACEHOLDER                   63
#define PHQL_SPLACEHOLDER                   64
#define PHQL_BPLACEHOLDER                   65
#define PHQL_EXISTS                         66
#define PHQL_CAST                           67
#define PHQL_CONVERT                        68
#define PHQL_USING                          69
#define PHQL_CASE                           70
#define PHQL_END                            71
#define PHQL_WHEN                           72
#define PHQL_THEN                           73
#define PHQL_ELSE                           74
#define PHQL_NULL                           75
#define PHQL_STRING                         76
#define PHQL_DOUBLE                         77
#define PHQL_TRUE                           78
#define PHQL_FALSE                          79



#ifdef HAVE_CONFIG_H
#endif




#define phql_add_assoc_stringl(var, index, str, len, copy) add_assoc_stringl(var, index, str, len);

static void phql_ret_literal_zval(zval *ret, int type, phql_parser_token *T)
{
	array_init(ret);
	add_assoc_long(ret, "type", type);
	if (T) {
		phql_add_assoc_stringl(ret, "value", T->token, T->token_len, 0);
		efree(T->token);
		efree(T);
	}
}

static void phql_ret_placeholder_zval(zval *ret, int type, phql_parser_token *T)
{
	array_init(ret);
	add_assoc_long(ret, "type", type);
	phql_add_assoc_stringl(ret, "value", T->token, T->token_len, 0);
	efree(T->token);
	efree(T);
}

static void phql_ret_qualified_name(zval *ret, phql_parser_token *A, phql_parser_token *B, phql_parser_token *C)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_QUALIFIED);

	if (A) {
		phql_add_assoc_stringl(ret, "ns-alias", A->token, A->token_len, 0);
		efree(A->token);
		efree(A);
	}

	if (B) {
		phql_add_assoc_stringl(ret, "domain", B->token, B->token_len, 0);
		efree(B->token);
		efree(B);
	}

	phql_add_assoc_stringl(ret, "name", C->token, C->token_len, 0);
	efree(C->token);
	efree(C);
}

static void phql_ret_raw_qualified_name(zval *ret, phql_parser_token *A, phql_parser_token *B)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_RAW_QUALIFIED);
	if (B) {
		phql_add_assoc_stringl(ret, "domain", A->token, A->token_len, 0);
		phql_add_assoc_stringl(ret, "name", B->token, B->token_len, 0);
		efree(B->token);
		efree(B);
	} else {
		phql_add_assoc_stringl(ret, "name", A->token, A->token_len, 0);
	}

	efree(A->token);
	efree(A);
}

static void phql_ret_select_statement(zval *ret, zval *S, zval *W, zval *O, zval *G, zval *H, zval *L, zval *F)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_SELECT);
	add_assoc_zval(ret, "select", S);

	if (W && Z_TYPE_P(W) != IS_UNDEF) {
		add_assoc_zval(ret, "where", W);
	}
	if (O && Z_TYPE_P(O) != IS_UNDEF) {
		add_assoc_zval(ret, "orderBy", O);
	}
	if (G && Z_TYPE_P(G) != IS_UNDEF) {
		add_assoc_zval(ret, "groupBy", G);
	}
	if (H && Z_TYPE_P(H) != IS_UNDEF) {
		add_assoc_zval(ret, "having", H);
	}
	if (L && Z_TYPE_P(L) != IS_UNDEF) {
		add_assoc_zval(ret, "limit", L);
	}
	if (F && Z_TYPE_P(F) != IS_UNDEF) {
		add_assoc_zval(ret, "forUpdate", F);
	}
}

static void phql_ret_select_clause(zval *ret, zval *distinct, zval *columns, zval *tables, zval *join_list)
{
	array_init(ret);

	if (distinct && Z_TYPE_P(distinct) != IS_UNDEF) {
		add_assoc_zval(ret, "distinct", distinct);
	}

	add_assoc_zval(ret, "columns", columns);
	add_assoc_zval(ret, "tables", tables);

	if (join_list && Z_TYPE_P(join_list) != IS_UNDEF) {
		add_assoc_zval(ret, "joins", join_list);
	}
}

static void phql_ret_distinct_all(zval *ret, int distinct)
{
	ZVAL_LONG(ret, distinct);
}

static void phql_ret_distinct(zval *ret)
{
	ZVAL_TRUE(ret);
}

static void phql_ret_order_item(zval *ret, zval *column, int sort){

	array_init(ret);
	add_assoc_zval(ret, "column", column);
	if (sort) {
		add_assoc_long(ret, "sort", sort);
	}
}

static void phql_ret_limit_clause(zval *ret, zval *L, zval *O)
{
	array_init(ret);

	add_assoc_zval(ret, "number", L);

	if (O && Z_TYPE_P(O) != IS_UNDEF) {
		add_assoc_zval(ret, "offset", O);
	}
}

static void phql_ret_for_update_clause(zval *ret)
{
	ZVAL_BOOL(ret, 1);
}

static void phql_ret_insert_statement(zval *ret, zval *Q, zval *F, zval *V)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_INSERT);
	add_assoc_zval(ret, "qualifiedName", Q);
	if (F && Z_TYPE_P(F) != IS_UNDEF) {
		add_assoc_zval(ret, "fields", F);
	}
	add_assoc_zval(ret, "values", V);
}

static void phql_ret_update_statement(zval *ret, zval *U, zval *W, zval *L)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_UPDATE);
	add_assoc_zval(ret, "update", U);
	if (W && Z_TYPE_P(W) != IS_UNDEF) {
		add_assoc_zval(ret, "where", W);
	}
	if (L && Z_TYPE_P(L) != IS_UNDEF) {
		add_assoc_zval(ret, "limit", L);
	}
}

static void phql_ret_update_clause(zval *ret, zval *tables, zval *values)
{
	array_init(ret);
	add_assoc_zval(ret, "tables", tables);
	add_assoc_zval(ret, "values", values);
}

static void phql_ret_update_item(zval *ret, zval *column, zval *expr)
{
	array_init(ret);
	add_assoc_zval(ret, "column", column);
	add_assoc_zval(ret, "expr", expr);
}

static void phql_ret_delete_statement(zval *ret, zval *D, zval *W, zval *L)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_DELETE);
	add_assoc_zval(ret, "delete", D);

	if (W && Z_TYPE_P(W) != IS_UNDEF) {
		add_assoc_zval(ret, "where", W);
	}
	if (L && Z_TYPE_P(L) != IS_UNDEF) {
		add_assoc_zval(ret, "limit", L);
	}
}

static void phql_ret_delete_clause(zval *ret, zval *tables)
{
	array_init(ret);
	add_assoc_zval(ret, "tables", tables);
}

static void phql_ret_zval_list(zval *ret, zval *list_left, zval *right_list)
{
    HashTable *list;

	array_init(ret);

	if (list_left && Z_TYPE_P(list_left) != IS_UNDEF) {

		list = Z_ARRVAL_P(list_left);
		if (zend_hash_index_exists(list, 0)) {
            {
                zval *item;
                ZEND_HASH_FOREACH_VAL(list, item) {

                    Z_TRY_ADDREF_P(item);
                    add_next_index_zval(ret, item);

                } ZEND_HASH_FOREACH_END();
            }
            zval_dtor(list_left);
		} else {
			add_next_index_zval(ret, list_left);
		}
	}

	if (right_list && Z_TYPE_P(right_list) != IS_UNDEF) {
		add_next_index_zval(ret, right_list);
	}
}

static void phql_ret_column_item(zval *ret, int type, zval *column, phql_parser_token *identifier_column, phql_parser_token *alias)
{

	array_init(ret);
	add_assoc_long(ret, "type", type);

	if (column && Z_TYPE_P(column) != IS_UNDEF) {
		add_assoc_zval(ret, "column", column);
	}

	if (identifier_column) {
		phql_add_assoc_stringl(ret, "column", identifier_column->token, identifier_column->token_len, 0);
		efree(identifier_column->token);
		efree(identifier_column);
	}

	if (alias) {
		phql_add_assoc_stringl(ret, "alias", alias->token, alias->token_len, 0);
		efree(alias->token);
		efree(alias);
	}
}

static void phql_ret_assoc_name(zval *ret, zval *qualified_name, phql_parser_token *alias, zval *with)
{

	array_init(ret);
	add_assoc_zval(ret, "qualifiedName", qualified_name);

	if (alias) {
		phql_add_assoc_stringl(ret, "alias", alias->token, alias->token_len, 0);
		efree(alias->token);
		efree(alias);
	}

	if (with && Z_TYPE_P(with) != IS_UNDEF) {
		add_assoc_zval(ret, "with", with);
	}
}

static void phql_ret_join_type(zval *ret, int type)
{
	ZVAL_LONG(ret, type);
}

static void phql_ret_join_item(zval *ret, zval *type, zval *qualified, zval *alias, zval *conditions)
{

	array_init(ret);
	add_assoc_zval(ret, "type", type);

	if (qualified && Z_TYPE_P(qualified) != IS_UNDEF) {
		add_assoc_zval(ret, "qualified", qualified);
	}

	if (alias && Z_TYPE_P(alias) != IS_UNDEF) {
		add_assoc_zval(ret, "alias", alias);
	}

	if (conditions && Z_TYPE_P(conditions) != IS_UNDEF) {
		add_assoc_zval(ret, "conditions", conditions);
	}
}

static void phql_ret_expr(zval *ret, int type, zval *left, zval *right)
{
	array_init(ret);
	add_assoc_long(ret, "type", type);
	if (left && Z_TYPE_P(left) != IS_UNDEF) {
		add_assoc_zval(ret, "left", left);
	}
	if (right && Z_TYPE_P(right) != IS_UNDEF) {
		add_assoc_zval(ret, "right", right);
	}
}

static void phql_ret_func_call(zval *ret, phql_parser_token *name, zval *arguments, zval *distinct)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHQL_T_FCALL);
	phql_add_assoc_stringl(ret, "name", name->token, name->token_len, 0);
	efree(name->token);
	efree(name);

	if (arguments && Z_TYPE_P(arguments) != IS_UNDEF) {
		add_assoc_zval(ret, "arguments", arguments);
	}

	if (distinct && Z_TYPE_P(distinct) != IS_UNDEF) {
		add_assoc_zval(ret, "distinct", distinct);
	}
}


#define PHVOLT_OPEN_DELIMITER                  1
#define PHVOLT_COMMA                           2
#define PHVOLT_QUESTION                        3
#define PHVOLT_COLON                           4
#define PHVOLT_RANGE                           5
#define PHVOLT_AND                             6
#define PHVOLT_OR                              7
#define PHVOLT_IN                              8
#define PHVOLT_IS                              9
#define PHVOLT_EQUALS                         10
#define PHVOLT_NOTEQUALS                      11
#define PHVOLT_LESS                           12
#define PHVOLT_GREATER                        13
#define PHVOLT_GREATEREQUAL                   14
#define PHVOLT_LESSEQUAL                      15
#define PHVOLT_IDENTICAL                      16
#define PHVOLT_NOTIDENTICAL                   17
#define PHVOLT_DIVIDE                         18
#define PHVOLT_TIMES                          19
#define PHVOLT_MOD                            20
#define PHVOLT_PLUS                           21
#define PHVOLT_MINUS                          22
#define PHVOLT_CONCAT                         23
#define PHVOLT_SBRACKET_OPEN                  24
#define PHVOLT_PIPE                           25
#define PHVOLT_NOT                            26
#define PHVOLT_INCR                           27
#define PHVOLT_DECR                           28
#define PHVOLT_PARENTHESES_OPEN               29
#define PHVOLT_DOT                            30
#define PHVOLT_IF                             31
#define PHVOLT_CLOSE_DELIMITER                32
#define PHVOLT_ENDIF                          33
#define PHVOLT_ELSE                           34
#define PHVOLT_ELSEIF                         35
#define PHVOLT_ELSEFOR                        36
#define PHVOLT_FOR                            37
#define PHVOLT_IDENTIFIER                     38
#define PHVOLT_ENDFOR                         39
#define PHVOLT_SWITCH                         40
#define PHVOLT_ENDSWITCH                      41
#define PHVOLT_CASE                           42
#define PHVOLT_DEFAULT                        43
#define PHVOLT_SET                            44
#define PHVOLT_ASSIGN                         45
#define PHVOLT_ADD_ASSIGN                     46
#define PHVOLT_SUB_ASSIGN                     47
#define PHVOLT_MUL_ASSIGN                     48
#define PHVOLT_DIV_ASSIGN                     49
#define PHVOLT_SBRACKET_CLOSE                 50
#define PHVOLT_MACRO                          51
#define PHVOLT_PARENTHESES_CLOSE              52
#define PHVOLT_ENDMACRO                       53
#define PHVOLT_INTEGER                        54
#define PHVOLT_STRING                         55
#define PHVOLT_DOUBLE                         56
#define PHVOLT_NULL                           57
#define PHVOLT_FALSE                          58
#define PHVOLT_TRUE                           59
#define PHVOLT_CALL                           60
#define PHVOLT_ENDCALL                        61
#define PHVOLT_OPEN_EDELIMITER                62
#define PHVOLT_CLOSE_EDELIMITER               63
#define PHVOLT_BLOCK                          64
#define PHVOLT_ENDBLOCK                       65
#define PHVOLT_CACHE                          66
#define PHVOLT_ENDCACHE                       67
#define PHVOLT_RAW                            68
#define PHVOLT_ENDRAW                         69
#define PHVOLT_EXTENDS                        70
#define PHVOLT_INCLUDE                        71
#define PHVOLT_WITH                           72
#define PHVOLT_DO                             73
#define PHVOLT_RETURN                         74
#define PHVOLT_AUTOESCAPE                     75
#define PHVOLT_ENDAUTOESCAPE                  76
#define PHVOLT_BREAK                          77
#define PHVOLT_CONTINUE                       78
#define PHVOLT_RAW_FRAGMENT                   79
#define PHVOLT_DEFINED                        80
#define PHVOLT_EMPTY                          81
#define PHVOLT_EVEN                           82
#define PHVOLT_ODD                            83
#define PHVOLT_NUMERIC                        84
#define PHVOLT_SCALAR                         85
#define PHVOLT_ITERABLE                       86
#define PHVOLT_CBRACKET_OPEN                  87
#define PHVOLT_CBRACKET_CLOSE                 88


/* parser.php.inc.h
 *
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

#ifdef HAVE_CONFIG_H
#endif





#define phvolt_add_assoc_stringl(var, index, str, len, copy) \
	add_assoc_stringl(var, index, str, len);

/* {{{ phvolt_ret_literal_zval */
static void phvolt_ret_literal_zval(zval *ret, int type, phvolt_parser_token *T, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", type);
	if (T) {
		phvolt_add_assoc_stringl(ret, "value", T->token, T->token_len, 0);
		efree(T->token);
		efree(T);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_if_statement */
static void phvolt_ret_if_statement(zval *ret, zval *expr, zval *true_statements, zval *false_statements,
	phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_IF);
	add_assoc_zval(ret, "expr", expr);

	if (true_statements) {
		add_assoc_zval(ret, "true_statements", true_statements);
	}
	if (false_statements) {
		add_assoc_zval(ret, "false_statements", false_statements);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_elseif_statement */
static void phvolt_ret_elseif_statement(zval *ret, zval *expr, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_ELSEIF);
	add_assoc_zval(ret, "expr", expr);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_elsefor_statement */
static void phvolt_ret_elsefor_statement(zval *ret, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_ELSEFOR);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_switch_statement */
static void phvolt_ret_switch_statement(zval *ret, zval *expr, zval *case_clauses, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_SWITCH);
	add_assoc_zval(ret, "expr", expr);

	if (case_clauses) {
		add_assoc_zval(ret, "case_clauses", case_clauses);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_case_clause */
static void phvolt_ret_case_clause(zval *ret, zval *expr, phvolt_scanner_state *state)
{
	array_init(ret);

	if (expr) {
		add_assoc_long(ret, "type", PHVOLT_T_CASE);
		add_assoc_zval(ret, "expr", expr);
	} else {
		add_assoc_long(ret, "type", PHVOLT_T_DEFAULT);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_for_statement */
static void phvolt_ret_for_statement(zval *ret, phvolt_parser_token *variable, phvolt_parser_token *key,
	zval *expr, zval *if_expr, zval *block_statements, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_FOR);

	phvolt_add_assoc_stringl(ret, "variable", variable->token, variable->token_len, 0);
	efree(variable->token);
	efree(variable);

	if (key) {
		phvolt_add_assoc_stringl(ret, "key", key->token, key->token_len, 0);
		efree(key->token);
		efree(key);
	}

	add_assoc_zval(ret, "expr", expr);
	if (if_expr) {
		add_assoc_zval(ret, "if_expr", if_expr);
	}

	add_assoc_zval(ret, "block_statements", block_statements);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_cache_statement */
static void phvolt_ret_cache_statement(zval *ret, zval *expr, zval *lifetime, zval *block_statements,
	phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_CACHE);
	add_assoc_zval(ret, "expr", expr);

	if (lifetime) {
		add_assoc_zval(ret, "lifetime", lifetime);
	}
	add_assoc_zval(ret, "block_statements", block_statements);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_raw_statement */
static void phvolt_ret_raw_statement(zval *ret, zval *statement, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_RAW);
	add_assoc_zval(ret, "content", statement);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_set_statement */
static void phvolt_ret_set_statement(zval *ret, zval *assignments)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_SET);

	add_assoc_zval(ret, "assignments", assignments);
}
/* }}} */

/* {{{ phvolt_ret_set_assignment */
static void phvolt_ret_set_assignment(zval *ret, zval *assignable_expr, int operator, zval *expr,
	phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_zval(ret, "variable", assignable_expr);
	add_assoc_long(ret, "op", operator);
	add_assoc_zval(ret, "expr", expr);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_echo_statement */
static void phvolt_ret_echo_statement(zval *ret, zval *expr, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_ECHO);
	add_assoc_zval(ret, "expr", expr);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_block_statement */
static void phvolt_ret_block_statement(zval *ret, phvolt_parser_token *name, zval *block_statements,
	phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_BLOCK);

	phvolt_add_assoc_stringl(ret, "name", name->token, name->token_len, 0);
	efree(name->token);
	efree(name);

	if (block_statements) {
		add_assoc_zval(ret, "block_statements", block_statements);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_macro_statement */
static void phvolt_ret_macro_statement(zval *ret, phvolt_parser_token *macro_name, zval *parameters,
	zval *block_statements, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_MACRO);

	phvolt_add_assoc_stringl(ret, "name", macro_name->token, macro_name->token_len, 0);
	efree(macro_name->token);
	efree(macro_name);

	if (parameters) {
		add_assoc_zval(ret, "parameters", parameters);
	}

	if (block_statements) {
		add_assoc_zval(ret, "block_statements", block_statements);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_macro_parameter */
static void phvolt_ret_macro_parameter(zval *ret, phvolt_parser_token *variable, zval *default_value,
	phvolt_scanner_state *state)
{
	array_init(ret);

	phvolt_add_assoc_stringl(ret, "variable", variable->token, variable->token_len, 0);
	efree(variable->token);
	efree(variable);

	if (default_value) {
		add_assoc_zval(ret, "default", default_value);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_extends_statement */
static void phvolt_ret_extends_statement(zval *ret, zval *path, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_EXTENDS);
	add_assoc_zval(ret, "path", path);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_include_statement */
static void phvolt_ret_include_statement(zval *ret, zval *path, zval *params, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_INCLUDE);

	add_assoc_zval(ret, "path", path);
	if (params) {
		add_assoc_zval(ret, "params", params);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_do_statement */
static void phvolt_ret_do_statement(zval *ret, zval *expr, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_DO);
	add_assoc_zval(ret, "expr", expr);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_return_statement */
static void phvolt_ret_return_statement(zval *ret, zval *expr, phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_RETURN);
	add_assoc_zval(ret, "expr", expr);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_autoescape_statement */
static void phvolt_ret_autoescape_statement(zval *ret, int enable, zval *block_statements,
	phvolt_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHVOLT_T_AUTOESCAPE);
	add_assoc_long(ret, "enable", enable);
	add_assoc_zval(ret, "block_statements", block_statements);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_empty_statement */
static void phvolt_ret_empty_statement(zval *ret, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_EMPTY_STATEMENT);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_break_statement */
static void phvolt_ret_break_statement(zval *ret, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_BREAK);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_continue_statement */
static void phvolt_ret_continue_statement(zval *ret, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_CONTINUE);

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_zval_list */
static void phvolt_ret_zval_list(zval *ret, zval *list_left, zval *right_list)
{
	HashTable *list;

	array_init(ret);

	if (list_left) {

		list = Z_ARRVAL_P(list_left);
		if (zend_hash_index_exists(list, 0)) {
			{
				zval *item;
				ZEND_HASH_FOREACH_VAL(list, item) {

					Z_TRY_ADDREF_P(item);
					add_next_index_zval(ret, item);

				} ZEND_HASH_FOREACH_END();
			}
			zval_dtor(list_left);
		} else {
			add_next_index_zval(ret, list_left);
		}
	}

	add_next_index_zval(ret, right_list);
}
/* }}} */

/* {{{ phvolt_ret_named_item */
static void phvolt_ret_named_item(zval *ret, phvolt_parser_token *name, zval *expr,
	phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_zval(ret, "expr", expr);
	if (name != NULL) {
		phvolt_add_assoc_stringl(ret, "name", name->token, name->token_len, 0);
		efree(name->token);
		efree(name);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_expr */
static void phvolt_ret_expr(zval *ret, int type, zval *left, zval *right, zval *ternary,
	phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", type);

	if (ternary) {
		add_assoc_zval(ret, "ternary", ternary);
	}

	if (left) {
		add_assoc_zval(ret, "left", left);
	}

	if (right) {
		add_assoc_zval(ret, "right", right);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_slice */
static void phvolt_ret_slice(zval *ret, zval *left, zval *start, zval *end, phvolt_scanner_state *state)
{
	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_SLICE);
	add_assoc_zval(ret, "left", left);

	if (start != NULL) {
		add_assoc_zval(ret, "start", start);
	}

	if (end != NULL) {
		add_assoc_zval(ret, "end", end);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_func_call */
static void phvolt_ret_func_call(zval *ret, zval *expr, zval *arguments, phvolt_scanner_state *state)
{

	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_FCALL);
	add_assoc_zval(ret, "name", expr);

	if (arguments) {
		add_assoc_zval(ret, "arguments", arguments);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */

/* {{{ phvolt_ret_macro_call_statement */
static void phvolt_ret_macro_call_statement(zval *ret, zval *expr, zval *arguments, zval *caller,
	phvolt_scanner_state *state)
{

	array_init(ret);
	add_assoc_long(ret, "type", PHVOLT_T_CALL);
	add_assoc_zval(ret, "name", expr);

	if (arguments) {
		add_assoc_zval(ret, "arguments", arguments);
	}

	if (caller) {
		add_assoc_zval(ret, "caller", caller);
	}

	Z_TRY_ADDREF_P(state->active_file);
	add_assoc_zval(ret, "file", state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}
/* }}} */



#define PHANNOT_COMMA                           1
#define PHANNOT_AT                              2
#define PHANNOT_IDENTIFIER                      3
#define PHANNOT_PARENTHESES_OPEN                4
#define PHANNOT_PARENTHESES_CLOSE               5
#define PHANNOT_STRING                          6
#define PHANNOT_EQUALS                          7
#define PHANNOT_COLON                           8
#define PHANNOT_INTEGER                         9
#define PHANNOT_DOUBLE                         10
#define PHANNOT_NULL                           11
#define PHANNOT_FALSE                          12
#define PHANNOT_TRUE                           13
#define PHANNOT_BRACKET_OPEN                   14
#define PHANNOT_BRACKET_CLOSE                  15
#define PHANNOT_SBRACKET_OPEN                  16
#define PHANNOT_SBRACKET_CLOSE                 17








#define phannot_add_assoc_stringl(var, index, str, len) add_assoc_stringl(var, index, str, len);
#define phannot_add_assoc_string(var, index, str) add_assoc_string(var, index, str);

static void phannot_ret_literal_zval(zval *ret, int type, phannot_parser_token *T)
{
    array_init(ret);

	add_assoc_long(ret, "type", type);
	if (T) {
		phannot_add_assoc_stringl(ret, "value", T->token, T->token_len);
        efree(T->token);
		efree(T);
	}
}

static void phannot_ret_array(zval *ret, zval *items)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHANNOT_T_ARRAY);

	if (items) {
		add_assoc_zval(ret, "items", items);
	}
}

static void phannot_ret_zval_list(zval *ret, zval *list_left, zval *right_list)
{
	HashTable *list;

	array_init(ret);

	if (list_left) {

		list = Z_ARRVAL_P(list_left);
		if (zend_hash_index_exists(list, 0)) {
            {
                zval *item;
                ZEND_HASH_FOREACH_VAL(list, item) {

                    Z_TRY_ADDREF_P(item);
                    add_next_index_zval(ret, item);

                } ZEND_HASH_FOREACH_END();
            }
            zval_dtor(list_left);
		} else {
			add_next_index_zval(ret, list_left);
		}
	}

	add_next_index_zval(ret, right_list);
}

static void phannot_ret_named_item(zval *ret, phannot_parser_token *name, zval *expr)
{
	array_init(ret);

	add_assoc_zval(ret, "expr", expr);
	if (name != NULL) {
		phannot_add_assoc_stringl(ret, "name", name->token, name->token_len);
        efree(name->token);
		efree(name);
	}
}

static void phannot_ret_annotation(zval *ret, phannot_parser_token *name, zval *arguments, phannot_scanner_state *state)
{
	array_init(ret);

	add_assoc_long(ret, "type", PHANNOT_T_ANNOTATION);

	if (name) {
		phannot_add_assoc_stringl(ret, "name", name->token, name->token_len);
        efree(name->token);
		efree(name);
	}

	if (arguments) {
		add_assoc_zval(ret, "arguments", arguments);
	}

	phannot_add_assoc_string(ret, "file", (char*) state->active_file);
	add_assoc_long(ret, "line", state->active_line);
}




#ifndef PHALCON_URL_UTILS_H
#define PHALCON_URL_UTILS_H


/* Extract named parameters */
static void phalcon_get_uri(zval *return_value, zval *path);
static void phalcon_extract_named_params(zval *return_value, zval *str, zval *matches);
static void phalcon_replace_paths(zval *return_value, zval *pattern, zval *paths, zval *uri);

#endif /* PHALCON_URL_UTILS_H */



#ifndef ZEPHIR_KERNEL_MAIN_H
#define ZEPHIR_KERNEL_MAIN_H


zend_string* i_parent;
zend_string* i_static;
zend_string* i_self;

/* Main macros */
#define PH_DEBUG 0

#define PH_NOISY 256
#define PH_SILENT 1024
#define PH_READONLY 4096

#define PH_NOISY_CC PH_NOISY
#define PH_SILENT_CC PH_SILENT

#define PH_SEPARATE 256
#define PH_COPY 1024
#define PH_CTOR 4096

#ifndef ZEND_ACC_FINAL_CLASS
 #define ZEND_ACC_FINAL_CLASS ZEND_ACC_FINAL
#endif

#define SL(str) ZEND_STRL(str)
#define SS(str) ZEND_STRS(str)
#define ISL(str) (zephir_interned_##str), (sizeof(#str)-1)
#define ISS(str) (zephir_interned_##str), (sizeof(#str))


/* class/interface registering */
#define ZEPHIR_REGISTER_CLASS(ns, class_name, lower_ns, name, methods, flags)		\
	{																				\
		zend_class_entry ce;														\
		memset(&ce, 0, sizeof(zend_class_entry));									\
		INIT_NS_CLASS_ENTRY(ce, #ns, #class_name, methods);							\
		lower_ns## _ ##name## _ce = zend_register_internal_class(&ce);				\
		if (UNEXPECTED(!lower_ns## _ ##name## _ce)) {								\
			const char *_n = (#ns);													\
			const char *_c = (#class_name);											\
			zend_error(E_ERROR, "%s\\%s: class registration has failed.", _n, _c);	\
			return FAILURE;															\
		}																			\
		lower_ns## _ ##name## _ce->ce_flags |= flags;								\
	}

#define ZEPHIR_REGISTER_CLASS_EX(ns, class_name, lower_ns, lcname, parent_ce, methods, flags) \
	{ \
		zend_class_entry ce; \
		if (!parent_ce) { \
			fprintf(stderr, "Can't register class %s::%s with null parent\n", #ns, #class_name); \
			return FAILURE; \
		} \
		memset(&ce, 0, sizeof(zend_class_entry)); \
		INIT_NS_CLASS_ENTRY(ce, #ns, #class_name, methods); \
		lower_ns## _ ##lcname## _ce = zend_register_internal_class_ex(&ce, parent_ce); \
		if (!lower_ns## _ ##lcname## _ce) { \
			fprintf(stderr, "Zephir Error: Class to extend '%s' was not found when registering class '%s'\n", (parent_ce ? ZSTR_VAL(parent_ce->name) : "(null)"), ZEND_NS_NAME(#ns, #class_name)); \
			return FAILURE; \
		} \
		lower_ns## _ ##lcname## _ce->ce_flags |= flags;  \
	}

#define ZEPHIR_REGISTER_INTERFACE(ns, classname, lower_ns, name, methods) \
	{ \
		zend_class_entry ce; \
		memset(&ce, 0, sizeof(zend_class_entry)); \
		INIT_NS_CLASS_ENTRY(ce, #ns, #classname, methods); \
		lower_ns## _ ##name## _ce = zend_register_internal_interface(&ce); \
	}

#define ZEPHIR_REGISTER_INTERFACE_EX(ns, classname, lower_ns, lcname, parent_ce, methods) \
	{ \
		zend_class_entry ce; \
		if (!parent_ce) { \
			fprintf(stderr, "Can't register interface %s with null parent\n", ZEND_NS_NAME(#ns, #classname)); \
			return FAILURE; \
		} \
		memset(&ce, 0, sizeof(zend_class_entry)); \
		INIT_NS_CLASS_ENTRY(ce, #ns, #classname, methods); \
		lower_ns## _ ##lcname## _ce = zend_register_internal_interface(&ce); \
		if (parent_ce) { \
			zend_do_inheritance(ce, parent_ce); \
		} \
		if (!lower_ns## _ ##lcname## _ce) { \
			fprintf(stderr, "Can't register interface %s with parent %s\n", ZEND_NS_NAME(#ns, #classname), (parent_ce ? ZSTR_VAL(parent_ce->name) : "(null)")); \
			return FAILURE; \
		} \
	}

/** Return zval with always ctor */
#define RETURN_CTOR(var)        \
	do {                        \
		RETVAL_ZVAL(var, 1, 0); \
		ZEPHIR_MM_RESTORE();    \
		return;                 \
	} while (0)

/** Return zval with always ctor, without restoring the memory stack */
#define RETURN_CTORW(var)       \
	do {                        \
		RETVAL_ZVAL(var, 1, 0); \
		return;                 \
	} while (0)

/** Return zval checking if it's needed to ctor */
#define RETURN_CCTOR(v)            \
	do {                           \
		ZVAL_DUP(return_value, v); \
		ZEPHIR_MM_RESTORE();       \
		return;                    \
	} while (0)

/** Return zval checking if it's needed to ctor, without restoring the memory stack  */
#define RETURN_CCTORW(v)           \
	do {                           \
		ZVAL_DUP(return_value, v); \
		return;                    \
	} while (0)

/** Return zval with always ctor, without restoring the memory stack */
#define RETURN_THISW() \
	RETURN_ZVAL(getThis(), 1, 0);

/** Return this pointer */
#define RETURN_THIS() { \
		RETVAL_ZVAL(getThis(), 1, 0); \
	} \
	ZEPHIR_MM_RESTORE(); \
	return;

#define RETURN_LCTORW(var) RETURN_CCTORW(var);

#define RETURN_LCTOR(var) RETURN_CCTOR(var);

#define RETURN_MEMBER(object, member_name) \
	zephir_return_property(return_value, object, SL(member_name)); \
	return;

/** Return without change return_value */
#define RETURN_MM()                 { ZEPHIR_MM_RESTORE(); return; }

/** Return null restoring memory frame */
#define RETURN_MM_BOOL(value)       { RETVAL_BOOL(value); ZEPHIR_MM_RESTORE(); return; }

/** Return string restoring memory frame */
#define RETURN_MM_STRING(str)       { RETVAL_STRING(str); ZEPHIR_MM_RESTORE(); return; }
#define RETURN_MM_EMPTY_STRING()    { RETVAL_EMPTY_STRING(); ZEPHIR_MM_RESTORE(); return; }

/* Return long */
#define RETURN_MM_LONG(value)       { RETVAL_LONG(value); ZEPHIR_MM_RESTORE(); return; }

/* Return double */
#define RETURN_MM_DOUBLE(value)     { RETVAL_DOUBLE(value); ZEPHIR_MM_RESTORE(); return; }

#define RETURN_MM_MEMBER(object, member_name) \
  zephir_return_property(return_value, object, SL(member_name)); \
  RETURN_MM();

#define RETURN_ON_FAILURE(what) \
	do { \
		if (what == FAILURE) { \
			return; \
		} \
	} while (0)

#define RETURN_MM_ON_FAILURE(what) \
	do { \
		if (what == FAILURE) { \
			return; \
		} \
	} while (0)

/** Return null restoring memory frame */
#define RETURN_MM_NULL()            { RETVAL_NULL(); ZEPHIR_MM_RESTORE(); return; }

/* Globals functions */
static int zephir_get_global(zval *arr, const char *global, unsigned int global_length);

/* Count */
static void zephir_fast_count(zval *result, zval *array);
static int zephir_fast_count_ev(zval *array);
static int zephir_fast_count_int(zval *value);

static int zephir_is_callable(zval *var);
static int zephir_is_scalar(zval *var);

static int zephir_function_exists(const zval *function_name);
static int zephir_function_exists_ex(const char *func_name, unsigned int func_len);

zend_class_entry* zephir_get_internal_ce(const char *class_name, unsigned int class_name_len);

/* types */
static void zephir_gettype(zval *return_value, zval *arg);

/* Utils functions */
static inline int zephir_maybe_separate_zval(zval* z)
{
	if (!Z_REFCOUNTED_P(z) || (Z_REFCOUNT_P(z) > 1 && !Z_ISREF_P(z))) {
		if (!(Z_COPYABLE_P(z) && !Z_REFCOUNTED_P(z))) {
			Z_DELREF_P(z);
		}
		zval_copy_ctor_func(z);
		return 1;
	}

	return 0;
}

#define ZEPHIR_SET_SYMBOL(symbol_table, name, value) { \
	Z_TRY_ADDREF_P(value); \
	zend_hash_str_update(symbol_table, name, sizeof(name) - 1, value); \
}

static int zephir_is_iterable_ex(zval *arr, int duplicate);

/** Check if an array is iterable or not */
#define zephir_is_iterable(var, duplicate, file, line) \
	if (!zephir_is_iterable_ex(var, duplicate)) { \
		ZEPHIR_THROW_EXCEPTION_DEBUG_STRW(zend_exception_get_default(), "The argument is not initialized or iterable()", file, line); \
		ZEPHIR_MM_RESTORE(); \
		return; \
	}

/* Fetch Parameters */
static int zephir_fetch_parameters(int num_args, int required_args, int optional_args, ...);

/** Low overhead parse/fetch parameters */
#define zephir_fetch_params(memory_grow, required_params, optional_params, ...) \
	if (zephir_fetch_parameters(ZEND_NUM_ARGS(), required_params, optional_params, __VA_ARGS__) == FAILURE) { \
		if (memory_grow) { \
			RETURN_MM_NULL(); \
		} else { \
			RETURN_NULL(); \
		} \
	}

#define zephir_fetch_params_without_memory_grow(required_params, optional_params, ...) \
	if (zephir_fetch_parameters(ZEND_NUM_ARGS(), required_params, optional_params, __VA_ARGS__) == FAILURE) { \
		RETURN_NULL(); \
	}

#define ZEPHIR_CREATE_OBJECT(obj, class_type) \
	{ \
		zend_object *object = zend_objects_new(class_type); \
		ZVAL_UNDEF(obj); \
		ZVAL_OBJ(obj, object); \
		object_properties_init(object, class_type); \
	}

#define ZEPHIR_MAKE_REF(obj) ZVAL_NEW_REF(obj, obj);
#define ZEPHIR_UNREF(obj) ZVAL_UNREF(obj);

#define ZEPHIR_GET_CONSTANT(return_value, const_name) do { \
	zval *_constant_ptr = zend_get_constant_str(SL(const_name)); \
	if (_constant_ptr == NULL) { \
	    zval _null; \
		ZVAL_NULL(&_null); \
		ZVAL_COPY(return_value, &_null); \
		zval_ptr_dtor(&_null); \
	} else { \
	    ZVAL_COPY(return_value, _constant_ptr); \
	} \
} while(0)

#define ZEPHIR_GET_IMKEY(var, it) it->funcs->get_current_key(it, &var);

/* Declare class constants */
static int zephir_declare_class_constant_null(zend_class_entry *ce, const char *name, size_t name_length);
static int zephir_declare_class_constant_long(zend_class_entry *ce, const char *name, size_t name_length, zend_long value);
static int zephir_declare_class_constant_bool(zend_class_entry *ce, const char *name, size_t name_length, zend_bool value);
static int zephir_declare_class_constant_double(zend_class_entry *ce, const char *name, size_t name_length, double value);
static int zephir_declare_class_constant_stringl(zend_class_entry *ce, const char *name, size_t name_length, const char *value, size_t value_length);
static int zephir_declare_class_constant_string(zend_class_entry *ce, const char *name, size_t name_length, const char *value);

static int zephir_is_php_version(unsigned int id);

/** Method declaration for API generation */
#define ZEPHIR_DOC_METHOD(class_name, method)

#ifndef ZEPHIR_RELEASE
#define ZEPHIR_DEBUG_PARAMS , const char *file, int line
#define ZEPHIR_DEBUG_PARAMS_DUMMY , "", 0
#else
#define ZEPHIR_DEBUG_PARAMS , const char *file, int line
#define ZEPHIR_DEBUG_PARAMS_DUMMY , "", 0
#endif

static void zephir_get_args(zval* return_value);
static void zephir_get_arg(zval* return_value, zend_long idx);

static void zephir_module_init();

#endif /* ZEPHIR_KERNEL_MAIN_H */



#ifndef ZEPHIR_KERNEL_MEMORY_H
#define ZEPHIR_KERNEL_MEMORY_H


/** Memory frame */
typedef struct _zephir_memory_entry {
	size_t pointer;
	size_t capacity;
	zval **addresses;
#ifndef ZEPHIR_RELEASE
	int permanent;
	const char *func;
#endif
} zephir_memory_entry;

/** Virtual Symbol Table */
typedef struct _zephir_symbol_table {
	struct _zephir_memory_entry *scope;
	zend_array *symbol_table;
	struct _zephir_symbol_table *prev;
} zephir_symbol_table;

typedef struct _zephir_method_globals {
	/* Memory */
	zephir_memory_entry *active_memory; /**< The current memory frame */

	/* Virtual Symbol Tables */
	zephir_symbol_table *active_symbol_table;
} zephir_method_globals;

/* Memory Frames */
static void ZEPHIR_FASTCALL zephir_memory_grow_stack(zephir_method_globals *g, const char *func);
static void ZEPHIR_FASTCALL zephir_memory_restore_stack(zephir_method_globals *g, const char *func);

#define ZEPHIR_MM_RESTORE() \
	zephir_memory_restore_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__); \
	pefree(ZEPHIR_METHOD_GLOBALS_PTR, 0); \
	ZEPHIR_METHOD_GLOBALS_PTR = NULL;

static void zephir_initialize_memory(zend_zephir_globals_def *zephir_globals_ptr);
static void zephir_deinitialize_memory();

static void ZEPHIR_FASTCALL zephir_do_memory_observe(zval *var, const zephir_method_globals *g);
#define zephir_memory_observe(var) zephir_do_memory_observe(var, ZEPHIR_METHOD_GLOBALS_PTR);

#define zephir_safe_zval_ptr_dtor(pzval)

static void zephir_create_symbol_table(zephir_method_globals *g);

#define ZEPHIR_CREATE_SYMBOL_TABLE() zephir_create_symbol_table(ZEPHIR_METHOD_GLOBALS_PTR);

static int zephir_set_symbol(zval *key_name, zval *value);

#define ZEPHIR_INIT_VAR(z) \
	zephir_memory_observe(z); \
	ZVAL_NULL(z);

#define ZEPHIR_INIT_NVAR(z) \
	do { \
		if (Z_TYPE_P(z) == IS_UNDEF) { \
			zephir_memory_observe(z); \
		} else if (Z_REFCOUNTED_P(z) && !Z_ISREF_P(z)) { \
			if (Z_REFCOUNT_P(z) > 1) { \
				Z_DELREF_P(z); \
			} else { \
				zval_dtor(z); \
			} \
		} \
		ZVAL_NULL(z); \
	} while (0)

#define ZEPHIR_CPY_WRT(d, v) \
	Z_TRY_ADDREF_P(v); \
	if (Z_TYPE_P(d) > IS_UNDEF) { \
		if (Z_REFCOUNTED_P(d) && Z_REFCOUNT_P(d) > 0) { \
			zval_ptr_dtor(d); \
		} \
	} else { \
		zephir_memory_observe(d); \
	} \
	ZVAL_COPY_VALUE(d, v);

#define ZEPHIR_CPY_WRT_CTOR(d, v) \
	if (d) { \
		if (Z_REFCOUNTED_P(d) && Z_REFCOUNT_P(d) > 0) { \
			zval_ptr_dtor(d); \
		} \
	} \
	ZVAL_DUP(d, v);

#define ZEPHIR_OBS_COPY_OR_DUP(z, v) \
	if (Z_TYPE_P(z) == IS_UNDEF) { \
		zephir_memory_observe(z); \
	} \
	ZVAL_COPY(z, v);

#define ZEPHIR_HASH_COPY(z, v) \
	if (Z_TYPE_P(z) == IS_ARRAY && Z_TYPE_P(v) == IS_ARRAY) { \
		zend_hash_copy(Z_ARRVAL_P(z), Z_ARRVAL_P(v), (copy_ctor_func_t) zval_add_ref); \
	}

#define ZEPHIR_OBS_NVAR(z) \
	if (Z_TYPE_P(z) != IS_UNDEF) { \
		if (Z_REFCOUNTED_P(z) && Z_REFCOUNT_P(z) > 1) { \
			Z_DELREF_P(z); \
		} else {\
			zval_ptr_dtor(z); \
			ZVAL_NULL(z); \
		} \
	} else { \
		zephir_memory_observe(z); \
	}

/* TODO: this might causes troubles, since we cannot observe here, since we aren't using double pointers
 * figure out away to fix this (if it's an issue, which it isn't if observing isn't necessary)
 */
#define ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(ppzv) \
	do { \
		zval *tmp_ = (ppzv); \
		if (tmp_ != NULL) { \
			if (Z_TYPE_P(tmp_) != IS_UNDEF) { \
				zval_ptr_dtor(tmp_); \
			} else { \
				zephir_memory_observe(tmp_); \
			} \
			ZVAL_NULL(tmp_); \
		} \
	} while (0)

#define ZEPHIR_SEPARATE_PARAM(z) \
	do { \
		zval *orig_ptr = z; \
		SEPARATE_ZVAL(orig_ptr); \
	} while (0)

#endif



#ifndef ZEPHIR_KERNEL_EXCEPTIONS_H
#define ZEPHIR_KERNEL_EXCEPTIONS_H


/** Exceptions */
#define ZEPHIR_THROW_EXCEPTION_STR(class_entry, message) \
	do { \
		zephir_throw_exception_string(class_entry, message, strlen(message)); \
		ZEPHIR_MM_RESTORE(); \
	} while (0)

#define ZEPHIR_THROW_EXCEPTION_DEBUG_STR(class_entry, message, file, line) \
  do { \
    zephir_throw_exception_string_debug(class_entry, message, strlen(message), file, line); \
    ZEPHIR_MM_RESTORE(); \
  } while (0)

#define ZEPHIR_THROW_EXCEPTION_ZVAL(class_entry, message) \
	do { \
		zephir_throw_exception_zval(class_entry, message); \
		ZEPHIR_MM_RESTORE(); \
	} while (0)

#define ZEPHIR_THROW_EXCEPTION_DEBUG_ZVAL(class_entry, message, file, line) \
  do { \
    zephir_throw_exception_zval(class_entry, message, file, line); \
    ZEPHIR_MM_RESTORE(); \
  } while (0)


#define ZEPHIR_THROW_EXCEPTION_DEBUG_STRW(class_entry, message, file, line) zephir_throw_exception_string_debug(class_entry, message, strlen(message), file, line)
#define ZEPHIR_THROW_EXCEPTION_STRW(class_entry, message) zephir_throw_exception_string(class_entry, message, strlen(message))
#define ZEPHIR_THROW_EXCEPTION_ZVALW(class_entry, message) zephir_throw_exception_zval(class_entry, message)
#define ZEPHIR_THROW_EXCEPTION_DEBUG_ZVALW(class_entry, message, file, line) zephir_throw_exception_zval_debug(class_entry, message, file, line)

/** Throw Exceptions */
static void zephir_throw_exception_string(zend_class_entry *ce, const char *message, uint32_t message_len);
static void zephir_throw_exception_debug(zval *object, const char *file, uint32_t line);
static void zephir_throw_exception_format(zend_class_entry *ce, const char *format, ...);
static void zephir_throw_exception_string_debug(zend_class_entry *ce, const char *message, uint32_t message_len, const char *file, uint32_t line);

#endif /* ZEPHIR_KERNEL_EXCEPTIONS_H */



#ifndef ZEPHIR_KERNEL_DEBUG_H
#define ZEPHIR_KERNEL_DEBUG_H

#ifndef ZEPHIR_RELEASE


static void zephir_vdump(zval *var, const char *func);

#define PHV(v) zephir_vdump(zval *var, const char *func)
#define PHPR(v) zephir_print_r(v)

typedef struct _zephir_debug_entry {
	struct _zephir_debug_entry *prev;
	struct _zephir_debug_entry *next;
	char *class_name;
	char *method_name;
	int lineno;
} zephir_debug_entry;

/** The zval's reference count dump */
#define RC_DUMP(zv)                                                                                                                \
	do {                                                                                                                           \
		char *_n = (strrchr((#zv), '&') ? strrchr((#zv), '&') + 1 : (#zv));                                                        \
		char *_f = (strrchr(__FILE__, '/') ? strrchr(__FILE__, '/') + 1 : __FILE__);                                               \
		zval *_z = (zv);                                                                                                           \
		if (Z_REFCOUNTED_P(_z)) {                                                                                                  \
			fprintf(stderr, "[DUMP]: %s:%d %s (%p) refcount=%d, type=%d\n", _f, __LINE__, _n, _z, Z_REFCOUNT_P(_z), Z_TYPE_P(_z)); \
		} else {                                                                                                                   \
			fprintf(stderr, "[DUMP]: %s:%d %s (%p) is not reference-counted, type=%d\n", _f, __LINE__, _n, _z, Z_TYPE_P(_z));      \
		}                                                                                                                          \
	} while (0)


#else

#define RC_DUMP(zv)

#endif /* ZEPHIR_RELEASE */
#endif /* ZEPHIR_KERNEL_DEBUG_H */



#ifndef ZEPHIR_KERNEL_BACKTRACE_H
#define ZEPHIR_KERNEL_BACKTRACE_H

#ifndef ZEPHIR_RELEASE

static void zephir_print_backtrace(void);

#else

#ifndef zephir_print_backtrace
#define zephir_print_backtrace()
#endif

#endif
#endif /* ZEPHIR_KERNEL_BACKTRACE_H */



#ifndef ZEPHIR_KERNEL_OBJECT_H
#define ZEPHIR_KERNEL_OBJECT_H



/* Working with scopes */
# define zephir_get_scope(e) ((e) ? zend_get_executed_scope() : EG(fake_scope))
# define zephir_set_scope(s) EG(fake_scope) = (s)

/** Class Retrieving/Checking */
static int zephir_class_exists(zval *class_name, int autoload);
static int zephir_interface_exists(zval *interface_name, int autoload);
static void zephir_get_called_class(zval *return_value);
zend_class_entry *zephir_fetch_class(zval *class_name);
zend_class_entry *zephir_fetch_class_str_ex(const char *class_name, size_t length, int fetch_type);
static void zephir_get_class(zval *result, zval *object, int lower);
static void zephir_get_class_ns(zval *result, zval *object, int lower);
static void zephir_get_ns_class(zval *result, zval *object, int lower);

/** Cloning/Instance of */
static int zephir_clone(zval *destination, zval *obj);
static int zephir_is_instance_of(zval *object, const char *class_name, unsigned int class_length);
static int zephir_instance_of_ev(zval *object, const zend_class_entry *ce);
static int zephir_zval_is_traversable(zval *object);

/** Method exists */
static int zephir_method_exists(zval *object, const zval *method_name);

/** Isset properties */
static int zephir_isset_property(zval *object, const char *property_name, unsigned int property_length);
static int zephir_isset_property_zval(zval *object, const zval *property);

/** Reading properties */
static int zephir_read_property_ex(zval *result, zval *object, const char *property_name, uint32_t property_length, int silent);
static int zephir_read_property(zval *result, zval *object, const char *property_name, uint32_t property_length, int silent);
static int zephir_read_property_zval(zval *result, zval *object, zval *property, int silent);
static int zephir_return_property(zval *return_value, zval *object, char *property_name, unsigned int property_length);
static int zephir_fetch_property(zval *result, zval *object, const char *property_name, uint32_t property_length, int silent);
static int zephir_fetch_property_zval(zval *result, zval *object, zval *property, int silent);

/** Updating properties */
static int zephir_update_property_zval_ex(zval *obj, const char *property_name, unsigned int property_length, zval *value);
static int zephir_update_property_zval(zval *obj, const char *property_name, unsigned int property_length, zval *value);
static int zephir_update_property_zval_zval(zval *obj, zval *property, zval *value);

/** Updating array properties */
static int zephir_update_property_array(zval *object, const char *property, uint32_t property_length, const zval *index, zval *value);
static int zephir_update_property_array_string(zval *object, char *property, unsigned int property_length, char *index, unsigned int index_length, zval *value);
static int zephir_update_property_array_append(zval *object, char *property, unsigned int property_length, zval *value);
static int zephir_update_property_array_multi(zval *object, const char *property, uint32_t property_length, zval *value, const char *types, int types_length, int types_count, ...);

/** Unset properties */
static int zephir_unset_property(zval* object, const char* name);
static int zephir_unset_property_array(zval *object, char *property, unsigned int property_length, zval *index);

/** Static properties */
static int zephir_read_static_property_ce(zval *result, zend_class_entry *ce, const char *property, int len, int flags);
static int zephir_update_static_property_ce(zend_class_entry *ce, const char *property, uint32_t len, zval *value);
static int zephir_add_static_property_ce(zend_class_entry *ce, const char *property, uint32_t len, zval *value);
static int zephir_sub_static_property_ce(zend_class_entry *ce, const char *property, uint32_t len, zval *value);
static int zephir_update_static_property_array_multi_ce(zend_class_entry *ce, const char *property, uint32_t property_length, zval *value, const char *types, int types_length, int types_count, ...);

/** Create closures */
static int zephir_create_closure_ex(zval *return_value, zval *this_ptr, zend_class_entry *ce, const char *method_name, uint32_t method_length);

/** Create instances */
static int zephir_create_instance(zval *return_value, const zval *class_name);
static int zephir_create_instance_params(zval *return_value, const zval *class_name, zval *params);

/** Increment/Decrement properties */
#define zephir_property_incr(object, property) zephir_property_incr_decr(object, property, 1)
#define zephir_property_decr(object, property) zephir_property_incr_decr(object, property, 0)
static int zephir_property_incr_decr(zval *object, char *property_name, unsigned int property_length, unsigned int increment);

#define zephir_fetch_safe_class(destination, var) { \
		if (Z_TYPE_P(var) == IS_STRING) { \
			ZEPHIR_CPY_WRT(destination, var); \
		} else { \
			ZEPHIR_INIT_NVAR(destination); \
			ZVAL_STRING(destination, "<undefined class>"); \
		} \
	}

/** Methods */
static int zephir_method_exists_ex(zval *object, const char *method_name, unsigned int method_len);

#endif



#define ZEPHIR_MAX_ARRAY_LEVELS 16


static void ZEPHIR_FASTCALL zephir_create_array(zval *return_value, uint32_t size, int initialize);

static void ZEPHIR_FASTCALL zephir_ensure_array(zval *probable_array);

/** Combined isset/fetch */
static int zephir_array_isset_fetch(zval *fetched, const zval *arr, zval *index, int readonly);
static int zephir_array_isset_string_fetch(zval *fetched, const zval *arr, char *index, uint32_t index_length, int readonly);
static int zephir_array_isset_long_fetch(zval *fetched, const zval *arr, unsigned long index, int readonly);

/** Check for index existence */
static int ZEPHIR_FASTCALL zephir_array_isset(const zval *arr, zval *index);
static int ZEPHIR_FASTCALL zephir_array_isset_long(const zval *arr, unsigned long index);
static int ZEPHIR_FASTCALL zephir_array_isset_string(const zval *arr, const char *index, uint32_t index_length);

/** Unset existing indexes */
static int ZEPHIR_FASTCALL zephir_array_unset(zval *arr, zval *index, int flags);
static int ZEPHIR_FASTCALL zephir_array_unset_long(zval *arr, unsigned long index, int flags);
static int ZEPHIR_FASTCALL zephir_array_unset_string(zval *arr, const char *index, uint32_t index_length, int flags);

/** Fetch items from arrays */
static int zephir_array_fetch(zval *return_value, zval *arr, zval *index, int flags ZEPHIR_DEBUG_PARAMS);
static int zephir_array_fetch_string(zval *return_value, zval *arr, const char *index, uint32_t index_length, int flags ZEPHIR_DEBUG_PARAMS);
static int zephir_array_fetch_long(zval *return_value, zval *arr, unsigned long index, int flags ZEPHIR_DEBUG_PARAMS);

/** Append elements to arrays */
static int zephir_array_append(zval *arr, zval *value, int separate ZEPHIR_DEBUG_PARAMS);
static void zephir_merge_append(zval *left, zval *values);

/** Modify array */
static int zephir_array_update_zval(zval *arr, zval *index, zval *value, int flags);
static int zephir_array_update_string(zval *arr, const char *index, uint32_t index_length, zval *value, int flags);
static int zephir_array_update_long(zval *arr, unsigned long index, zval *value, int flags ZEPHIR_DEBUG_PARAMS);

static void zephir_array_keys(zval *return_value, zval *arr);
static int zephir_array_key_exists(zval *arr, zval *key);

/* Update array using multiple keys */
static void zephir_array_update_multi_ex(zval *arr, zval *value, const char *types, int types_length, int types_count, va_list ap);
static int zephir_array_update_multi(zval *arr, zval *value, const char *types, int types_length, int types_count, ...);

/** Fast Array Merge */
static void zephir_fast_array_merge(zval *return_value, zval *array1, zval *array2);

/* In Array */
static int zephir_fast_in_array(zval *needle, zval *haystack);

#define zephir_array_fast_append(arr, value) \
	do { \
		Z_TRY_ADDREF_P(value); \
		zend_hash_next_index_insert(Z_ARRVAL_P(arr), value); \
	} while (0)



#ifndef ZEPHIR_KERNEL_STRING_H
#define ZEPHIR_KERNEL_STRING_H


#define ZEPHIR_TRIM_LEFT  1
#define ZEPHIR_TRIM_RIGHT 2
#define ZEPHIR_TRIM_BOTH  3
#define ZEPHIR_SUBSTR_NO_LENGTH 1

/** Fast char position */
static int zephir_memnstr(const zval *haystack, const zval *needle ZEPHIR_DEBUG_PARAMS);
static int zephir_memnstr_str(const zval *haystack, char *needle, unsigned int needle_length ZEPHIR_DEBUG_PARAMS);

static int zephir_fast_strlen_ev(zval *str);
static void zephir_fast_strtolower(zval *return_value, zval *str);
static void zephir_fast_strtoupper(zval *return_value, zval *str);
static void zephir_fast_join(zval *result, zval *glue, zval *pieces);
static void zephir_fast_join_str(zval *result, char *glue, unsigned int glue_length, zval *pieces);
static void zephir_fast_explode(zval *result, zval *delimiter, zval *str, long limit);
static void zephir_fast_explode_str(zval *result, const char *delimiter, int delimiter_length, zval *str, long limit);
static void zephir_fast_strpos(zval *return_value, const zval *haystack, const zval *needle, unsigned int offset);
static void zephir_fast_strpos_str(zval *return_value, const zval *haystack, char *needle, unsigned int needle_length);
static void zephir_fast_trim(zval *return_value, zval *str, zval *charlist, int where);
static void zephir_fast_str_replace(zval *return_value, zval *search, zval *replace, zval *subject);

static void zephir_camelize(zval *return_value, const zval *str, const zval *delimiter);
static void zephir_uncamelize(zval *return_value, const zval *str, const zval *delimiter);

/** Starts/Ends with */
static int zephir_start_with(const zval *str, const zval *compared, zval *case_sensitive);
static int zephir_start_with_str(const zval *str, char *compared, unsigned int compared_length);
static int zephir_start_with_str_str(char *str, unsigned int str_length, char *compared, unsigned int compared_length);

static int zephir_end_with(const zval *str, const zval *compared, zval *case_sensitive);
static int zephir_end_with_str(const zval *str, char *compared, unsigned int compared_length);

/** spprintf */
static int zephir_spprintf(char **message, int max_len, char *format, ...);

/** JSON */
static int zephir_json_encode(zval *return_value, zval *v, int opts);
static int zephir_json_decode(zval *return_value, zval *v, zend_bool assoc);

/* Substr */
static void zephir_substr(zval *return_value, zval *str, long from, long length, int flags);

/** Preg-Match */
static void zephir_preg_match(zval *return_value, zval *regex, zval *subject, zval *matches, int global, long flags, long offset);

/** Hash */
static void zephir_md5(zval *return_value, zval *str);
static void zephir_crc32(zval *return_value, zval *str);

/** */
static void zephir_ucfirst(zval *return_value, zval *s);
static void zephir_addslashes(zval *return_value, zval *str);
static void zephir_stripslashes(zval *return_value, zval *str);
static void zephir_stripcslashes(zval *return_value, zval *str);
static void zephir_unique_key(zval *return_value, const zval *prefix, zval *value);

static void zephir_append_printable_array(smart_str *implstr, const zval *value);

static int zephir_hash_equals(const zval *known_zval, const zval *user_zval);

static void zephir_string_to_hex(zval *return_value, zval *var);

#endif /* ZEPHIR_KERNEL_STRING_H */



#ifndef ZEPHIR_KERNEL_FCALL_H
#define ZEPHIR_KERNEL_FCALL_H



typedef enum _zephir_call_type {
	zephir_fcall_parent,
	zephir_fcall_self,
	zephir_fcall_static,
	zephir_fcall_ce,
	zephir_fcall_method,
	zephir_fcall_function
} zephir_call_type;

#if defined(_MSC_VER)
#define ZEPHIR_PASS_CALL_PARAMS(x) x + 1
#define ZEPHIR_CALL_NUM_PARAMS(x) ((sizeof(x) - sizeof(x[0]))/sizeof(x[0]))
#define ZEPHIR_FETCH_VA_ARGS NULL,
#else
#define ZEPHIR_PASS_CALL_PARAMS(x) x
#define ZEPHIR_CALL_NUM_PARAMS(x) sizeof(x)/sizeof(zval*)
#define ZEPHIR_FETCH_VA_ARGS
#endif

#define ZEPHIR_CALL_FUNCTION(return_value_ptr, func_name, cache, cache_slot, ...) \
	do { \
		zephir_fcall_cache_entry **cache_entry_ = cache; \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_func_aparams(return_value_ptr, func_name, strlen(func_name), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_ZVAL_FUNCTION(return_value_ptr, func_name, cache, cache_slot, ...) \
	do { \
        	zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
        	ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
        	ZEPHIR_LAST_CALL_STATUS = zephir_call_zval_func_aparams(return_value_ptr, func_name, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_SET_THIS(zv) ZEPHIR_SET_THIS_OBJ((zv ? Z_OBJ_P(zv) : NULL))
#define ZEPHIR_SET_THIS_EXPLICIT_NULL() \
 	ZVAL_NULL(&EG(current_execute_data)->This); \
	Z_OBJ(EG(current_execute_data)->This) = NULL;

#define ZEPHIR_SET_THIS_OBJ(obj) \
	if (obj) { \
		ZVAL_OBJ(&EG(current_execute_data)->This, obj); \
	} \
	else { ZEPHIR_SET_THIS_EXPLICIT_NULL(); } \

#define ZEPHIR_BACKUP_SCOPE() \
	zend_class_entry *old_scope = EG(fake_scope); \
	zend_execute_data *old_call = execute_data; \
	zend_execute_data *old_execute_data = EG(current_execute_data), new_execute_data; \
	if (!EG(current_execute_data)) { \
		memset(&new_execute_data, 0, sizeof(zend_execute_data)); \
		execute_data = EG(current_execute_data) = &new_execute_data; \
	} else { \
		new_execute_data = *EG(current_execute_data); \
		new_execute_data.prev_execute_data = EG(current_execute_data); \
		new_execute_data.call = NULL; \
		new_execute_data.opline = NULL; \
		new_execute_data.func = NULL; \
		execute_data = EG(current_execute_data) = &new_execute_data; \
	}

#define ZEPHIR_RESTORE_SCOPE() \
	EG(fake_scope) = old_scope; \
	execute_data = old_call; \
	EG(current_execute_data) = old_execute_data;

#define ZEPHIR_SET_SCOPE(_scope, _scope_called) \
	EG(fake_scope) = _scope; \
	zephir_set_called_scope(EG(current_execute_data), _scope_called); \

/* End internal calls */

#define ZEPHIR_RETURN_CALL_ZVAL_FUNCTION(func_name, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_zval_function(return_value, func_name, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_FUNCTION(func_name, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_function(return_value, func_name, strlen(func_name), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(return_value_ptr, object, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, Z_TYPE_P(object) == IS_OBJECT ? Z_OBJCE_P(object) : NULL, zephir_fcall_method, object, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_METHOD(return_value_ptr, object, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, Z_TYPE_P(object) == IS_OBJECT ? Z_OBJCE_P(object) : NULL, zephir_fcall_method, object, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_METHOD_ZVAL(object, method, cache, cache_slot, ...) \
	do { \
		char *method_name; \
		int method_len; \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		if (Z_TYPE_P(method) == IS_STRING) { \
			method_len = Z_STRLEN_P(method); \
			method_name = zend_str_tolower_dup(Z_STRVAL_P(method), method_len); \
		} else { \
			method_len = 0; \
			method_name = zend_str_tolower_dup("", 0); \
		} \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, Z_TYPE_P(object) == IS_OBJECT ? Z_OBJCE_P(object) : NULL, zephir_fcall_method, object, method_name, method_len, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
		efree(method_name); \
	} while (0)

#define ZEPHIR_CALL_METHOD_ZVAL(return_value_ptr, object, method, cache, cache_slot, ...) \
	do { \
		char *method_name; \
		int method_len; \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		if (Z_TYPE_P(method) == IS_STRING) { \
			method_len = Z_STRLEN_P(method); \
			method_name = zend_str_tolower_dup(Z_STRVAL_P(method), method_len); \
		} else { \
			method_len = 0; \
			method_name = zend_str_tolower_dup("", 0); \
		} \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, Z_TYPE_P(object) == IS_OBJECT ? Z_OBJCE_P(object) : NULL, zephir_fcall_method, object, method_name, method_len, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
		efree(method_name); \
	} while (0)

#define ZEPHIR_CALL_PARENT(return_value_ptr, class_entry, this_ptr, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, class_entry, zephir_fcall_parent, this_ptr, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_METHOD(object, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, Z_TYPE_P(object) == IS_OBJECT ? Z_OBJCE_P(object) : NULL, zephir_fcall_method, object, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_STATIC(method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, (getThis() ? Z_OBJCE_P(getThis()) : NULL), zephir_fcall_static, getThis(), method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_PARENT(class_entry, this_ptr, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, class_entry, zephir_fcall_parent, this_ptr, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_SELF(return_value_ptr, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, (getThis() ? Z_OBJCE_P(getThis()) : NULL), zephir_fcall_self, getThis(), method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_SELF(method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, (getThis() ? Z_OBJCE_P(getThis()) : NULL), zephir_fcall_self, getThis(), method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_STATIC(return_value_ptr, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, (getThis() ? Z_OBJCE_P(getThis()) : NULL), zephir_fcall_static, getThis(), method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_CE_STATIC(return_value_ptr, class_entry, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, class_entry, zephir_fcall_ce, NULL, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_RETURN_CALL_CE_STATIC(class_entry, method, cache, cache_slot, ...) \
	do { \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, class_entry, zephir_fcall_ce, NULL, method, strlen(method), cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
	} while (0)

#define ZEPHIR_CALL_CE_STATIC_ZVAL(return_value_ptr, class_entry, method, cache, cache_slot, ...) \
	do { \
		char *method_name; \
		int method_len; \
		zval *params_[] = {ZEPHIR_FETCH_VA_ARGS __VA_ARGS__}; \
		if (Z_TYPE(method) == IS_STRING) { \
			method_len = Z_STRLEN(method); \
			method_name = zend_str_tolower_dup(Z_STRVAL(method), method_len); \
		} else { \
			method_len = 0; \
			method_name = zend_str_tolower_dup("", 0); \
		} \
		ZEPHIR_OBSERVE_OR_NULLIFY_PPZV(return_value_ptr); \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_class_method_aparams(return_value_ptr, class_entry, zephir_fcall_ce, NULL, method_name, method_len, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
		efree(method_name); \
	} while (0)

#define ZEPHIR_RETURN_CALL_CE_STATIC_ZVAL(class_entry, method, cache, cache_slot, ...) \
	do { \
		char *method_name; \
		int method_len; \
		zval *params_[] = { ZEPHIR_FETCH_VA_ARGS __VA_ARGS__ }; \
		if (Z_TYPE(method) == IS_STRING) { \
			method_len = Z_STRLEN(method); \
			method_name = zend_str_tolower_dup(Z_STRVAL(method), method_len); \
		} else { \
			method_len = 0; \
			method_name = zend_str_tolower_dup("", 0); \
		} \
		ZEPHIR_LAST_CALL_STATUS = zephir_return_call_class_method(return_value, class_entry, zephir_fcall_ce, NULL, method_name, method_len, cache, cache_slot, ZEPHIR_CALL_NUM_PARAMS(params_), ZEPHIR_PASS_CALL_PARAMS(params_)); \
		efree(method_name); \
	} while (0)

/** Use these functions to call functions in the PHP userland using an arbitrary zval as callable */
#define ZEPHIR_CALL_USER_FUNC(return_value, handler) ZEPHIR_CALL_USER_FUNC_ARRAY(return_value, handler, NULL)
#define ZEPHIR_CALL_USER_FUNC_ARRAY(return_value, handler, params) \
	do { \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_user_func_array(return_value, handler, params); \
	} while (0)

#define ZEPHIR_CALL_USER_FUNC_ARRAY_NOEX(return_value, handler, params) \
	do { \
		ZEPHIR_LAST_CALL_STATUS = zephir_call_user_func_array_noex(return_value, handler, params); \
	} while (0)

static int zephir_call_func_aparams(zval *return_value_ptr, const char *func_name, uint32_t func_length,
	zephir_fcall_cache_entry **cache_entry, int cache_slot,
	uint32_t param_count, zval **params);

static int zephir_call_zval_func_aparams(zval *return_value_ptr, zval *func_name,
	zephir_fcall_cache_entry **cache_entry, int cache_slot,
	uint32_t param_count, zval **params) ZEPHIR_ATTR_WARN_UNUSED_RESULT;

static int zephir_call_class_method_aparams(
    zval *return_value_ptr,
	zend_class_entry *ce,
	zephir_call_type type,
	zval *object,
	const char *method_name,
	uint32_t method_len,
	zephir_fcall_cache_entry **cache_entry,
	int cache_slot,
	uint32_t param_count,
	zval **params) ZEPHIR_ATTR_WARN_UNUSED_RESULT;

ZEPHIR_ATTR_WARN_UNUSED_RESULT static inline int zephir_return_call_function(zval *return_value,
	const char *func, uint32_t func_len, zephir_fcall_cache_entry **cache_entry, int cache_slot, uint32_t param_count, zval **params)
{
	zval rv, *rvp = return_value ? return_value : &rv;
	int status;

	if (return_value) {
		zval_ptr_dtor(return_value);
		ZVAL_UNDEF(return_value);
	}

	status = zephir_call_func_aparams(rvp, func, func_len, cache_entry, cache_slot, param_count, params);

	if (status == FAILURE) {
		if (return_value && EG(exception)) {
			ZVAL_NULL(return_value);
		}

		return FAILURE;
	}

	if (!return_value) {
		zval_ptr_dtor(&rv);
	}

	return SUCCESS;
}

ZEPHIR_ATTR_WARN_UNUSED_RESULT static inline int zephir_return_call_zval_function(zval *return_value,
	zval *func, zephir_fcall_cache_entry **cache_entry, int cache_slot, uint32_t param_count, zval **params)
{
	zval rv, *rvp = return_value ? return_value : &rv;
	int status;

	if (return_value) {
		zval_ptr_dtor(return_value);
		ZVAL_UNDEF(return_value);
	}

	status = zephir_call_zval_func_aparams(rvp, func, cache_entry, cache_slot, param_count, params);

	if (status == FAILURE) {
		if (return_value && EG(exception)) {
			ZVAL_NULL(return_value);
		}

		return FAILURE;
	}

	if (!return_value) {
		zval_ptr_dtor(&rv);
	}

	return SUCCESS;
}

ZEPHIR_ATTR_WARN_UNUSED_RESULT static inline int zephir_return_call_class_method(
	zval *return_value,
	zend_class_entry *ce,
	zephir_call_type type,
	zval *object,
	const char *method_name,
	uint32_t method_len,
	zephir_fcall_cache_entry **cache_entry,
	int cache_slot,
	uint32_t param_count,
	zval **params
) {
	zval rv, *rvp = return_value ? return_value : &rv;
	int status;

	ZVAL_UNDEF(&rv);

	if (return_value) {
		zval_ptr_dtor(return_value);
		ZVAL_UNDEF(return_value);
	}

	status = zephir_call_class_method_aparams(rvp, ce, type, object, method_name, method_len, cache_entry, cache_slot, param_count, params);

	if (status == FAILURE) {
		if (return_value && EG(exception)) {
			ZVAL_NULL(return_value);
		}

		return FAILURE;
	}

	if (!return_value) {
		zval_ptr_dtor(&rv);
	}

	return SUCCESS;
}

/** Fast call_user_func_array/call_user_func */
static int zephir_call_user_func_array_noex(zval *return_value, zval *handler, zval *params) ZEPHIR_ATTR_WARN_UNUSED_RESULT;

ZEPHIR_ATTR_WARN_UNUSED_RESULT static inline int zephir_call_user_func_array(zval *return_value, zval *handler, zval *params)
{
	int status = zephir_call_user_func_array_noex(return_value, handler, params);
	return (EG(exception)) ? FAILURE : status;
}

static int zephir_has_constructor_ce(const zend_class_entry *ce) ZEPHIR_ATTR_PURE ZEPHIR_ATTR_NONNULL;

ZEPHIR_ATTR_WARN_UNUSED_RESULT ZEPHIR_ATTR_NONNULL static inline int zephir_has_constructor(const zval *object)
{
	return Z_TYPE_P(object) == IS_OBJECT ? zephir_has_constructor_ce(Z_OBJCE_P(object)) : 0;
}

#define zephir_check_call_status() \
	do { \
		if (ZEPHIR_LAST_CALL_STATUS == FAILURE) { \
			ZEPHIR_MM_RESTORE(); \
			return; \
		} \
	} while(0)

#define zephir_check_call_status_or_jump(label) \
	do { \
		if (ZEPHIR_LAST_CALL_STATUS == FAILURE) { \
			if (EG(exception)) { \
				goto label; \
			} else { \
				ZEPHIR_MM_RESTORE(); \
				return; \
			} \
		} \
	} while (0)

#ifdef ZEPHIR_RELEASE
#define ZEPHIR_TEMP_PARAM_COPY 0
#define zephir_check_temp_parameter(param) do { if (Z_REFCOUNT(param) > 1) zval_copy_ctor(&param); else ZVAL_NULL(&param); } while(0)
#else
#define ZEPHIR_TEMP_PARAM_COPY 1
#define zephir_check_temp_parameter(param)
#endif

static void zephir_eval_php(zval *str, zval *retval_ptr, char *context);

static inline void zephir_set_called_scope(zend_execute_data *ex, zend_class_entry *called_scope)
{
	while (ex) {
		if (Z_TYPE(ex->This) == IS_OBJECT) {
			Z_OBJCE(ex->This) = called_scope;
			return;
		}else if (ex->func) {
			if (ex->func->type != ZEND_INTERNAL_FUNCTION || ex->func->common.scope) {
				return;
			}
		} else {
			Z_CE(ex->This) = called_scope;
			return;
		}
		ex = ex->prev_execute_data;
	}
}

#endif /* ZEPHIR_KERNEL_FCALL_H */



#ifndef ZEPHIR_KERNEL_REQUIRE_H
#define ZEPHIR_KERNEL_REQUIRE_H


static int zephir_require_ret(zval *return_value_ptr, const char *require_path) ZEPHIR_ATTR_NONNULL1(2);
static int zephir_require_once_ret(zval *return_value_ptr, const char *require_path) ZEPHIR_ATTR_NONNULL1(2);

ZEPHIR_ATTR_NONNULL static inline int zephir_require_zval(const zval *require_path)
{
    return zephir_require_ret(NULL, Z_TYPE_P(require_path) == IS_STRING ? Z_STRVAL_P(require_path) : "");
}

ZEPHIR_ATTR_NONNULL static inline int zephir_require_zval_ret(zval *return_value_ptr, const zval *require_path)
{
    return zephir_require_ret(return_value_ptr, Z_TYPE_P(require_path) == IS_STRING ? Z_STRVAL_P(require_path) : "");
}

ZEPHIR_ATTR_NONNULL static inline int zephir_require_once_zval(const zval *require_path)
{
    return zephir_require_once_ret(NULL, Z_TYPE_P(require_path) == IS_STRING ? Z_STRVAL_P(require_path) : "");
}

ZEPHIR_ATTR_NONNULL static inline int zephir_require_once_zval_ret(zval *return_value_ptr, const zval *require_path)
{
    return zephir_require_once_ret(return_value_ptr, Z_TYPE_P(require_path) == IS_STRING ? Z_STRVAL_P(require_path) : "");
}

#endif /* ZEPHIR_KERNEL_REQUIRE_H */



#ifndef ZEPHIR_KERNEL_FILE_H
#define ZEPHIR_KERNEL_FILE_H


static int zephir_file_exists(zval *filename);

static void zephir_fwrite(zval *return_value, zval *stream_zval, zval *data);
static int zephir_feof(zval *stream_zval);
static int zephir_fclose(zval *stream_zval);
static void zephir_file_get_contents(zval *return_value, zval *filename);
static void zephir_file_put_contents(zval *return_value, zval *filename, zval *data);

static void zephir_basename(zval *return_value, zval *path);
static void zephir_filemtime(zval *return_value, zval *path);
static int zephir_compare_mtime(zval *filename1, zval *filename2);
static void zephir_prepare_virtual_path(zval *return_value, zval *path, zval *virtual_separator);
static void zephir_unique_path_key(zval *return_value, zval *path);

#ifdef TSRM_WIN32
#define ZEPHIR_DIRECTORY_SEPARATOR "\\"
#else
#define ZEPHIR_DIRECTORY_SEPARATOR "/"
#endif

#endif /* ZEPHIR_KERNEL_FILE_H */



#ifndef ZEPHIR_KERNEL_OPERATORS_H
#define ZEPHIR_KERNEL_OPERATORS_H


#define zephir_make_printable_zval(expr, expr_copy) zend_make_printable_zval(expr, expr_copy);

/** Strict comparing */
#define ZEPHIR_IS_LONG(op1, op2)   ((Z_TYPE_P(op1) == IS_LONG && Z_LVAL_P(op1) == op2) || zephir_compare_strict_long(op1, op2))
#define ZEPHIR_IS_DOUBLE(op1, op2) ((Z_TYPE_P(op1) == IS_DOUBLE && Z_DVAL_P(op1) == op2) || zephir_compare_strict_double(op1, op2))
#define ZEPHIR_IS_STRING(op1, op2) zephir_compare_strict_string(op1, op2, strlen(op2))

#define ZEPHIR_IS_LONG_IDENTICAL(op1, op2)   (Z_TYPE_P(op1) == IS_LONG && Z_LVAL_P(op1) == op2)
#define ZEPHIR_IS_DOUBLE_IDENTICAL(op1, op2) (Z_TYPE_P(op1) == IS_DOUBLE && Z_DVAL_P(op1) == op2)
#define ZEPHIR_IS_STRING_IDENTICAL(op1, op2) (Z_TYPE_P(op1) == IS_STRING && zephir_compare_strict_string(op1, op2, strlen(op2)))
#define ZEPHIR_IS_BOOL_IDENTICAL(op1, op2) ((Z_TYPE_P(op1) == IS_FALSE || Z_TYPE_P(op1) == IS_TRUE) && zephir_compare_strict_bool(op1, op2))

#define ZEPHIR_IS_NULL(var) (Z_TYPE_P(var) == IS_NULL)

/** strict boolean comparison */
#define ZEPHIR_IS_FALSE(var)       ((Z_TYPE_P(var) == IS_FALSE) || zephir_compare_strict_bool(var, 0))
#define ZEPHIR_IS_TRUE(var)        ((Z_TYPE_P(var) == IS_TRUE) || zephir_compare_strict_bool(var, 1))
#define ZEPHIR_IS_FALSE_IDENTICAL(var)       (Z_TYPE_P(var) == IS_FALSE)
#define ZEPHIR_IS_TRUE_IDENTICAL(var)        (Z_TYPE_P(var) == IS_TRUE)

#define ZEPHIR_IS_NOT_FALSE(var)   ((Z_TYPE_P(var) != IS_TRUE && Z_TYPE_P(var) != IS_FALSE) || Z_TYPE_P(var) == IS_TRUE)
#define ZEPHIR_IS_NOT_TRUE(var)    ((Z_TYPE_P(var) != IS_TRUE && Z_TYPE_P(var) != IS_FALSE) || Z_TYPE_P(var) == IS_FALSE)
#define ZEPHIR_IS_BOOL(op1, op2) zephir_compare_strict_bool(op1, op2)
#define ZEPHIR_IS_BOOL_VALUE(op1, op2) zephir_compare_strict_bool(op1, op2)

/** SQL null empty **/
#define ZEPHIR_IS_EMPTY(var)       (Z_TYPE_P(var) == IS_NULL || ZEPHIR_IS_FALSE(var) || (Z_TYPE_P(var) == IS_STRING && !Z_STRLEN_P(var)) || !zend_is_true(var))
#define ZEPHIR_IS_NOT_EMPTY(var)   (!ZEPHIR_IS_EMPTY(var))

/** Is scalar */
#define ZEPHIR_IS_SCALAR(var)      (!ZEPHIR_IS_NOT_SCALAR(var))
#define ZEPHIR_IS_NOT_SCALAR(var)  (Z_TYPE_P(var) == IS_NULL || Z_TYPE_P(var) == IS_ARRAY || Z_TYPE_P(var) == IS_OBJECT || Z_TYPE_P(var) == IS_RESOURCE)

/** Equals/Identical */
#define ZEPHIR_IS_EQUAL(op1, op2)      zephir_is_equal(op1, op2)
#define ZEPHIR_IS_IDENTICAL(op1, op2)  zephir_is_identical(op1, op2)

/** Greater/Smaller equals */
#define ZEPHIR_LE(op1, op2)       zephir_less_equal(op1, op2)
#define ZEPHIR_LE_LONG(op1, op2)  ((Z_TYPE_P(op1) == IS_LONG && Z_LVAL_P(op1) <= op2) || zephir_less_equal_long(op1, op2))
#define ZEPHIR_LE_DOUBLE(op1, op2)  ((Z_TYPE_P(op1) == IS_DOUBLE && Z_DVAL_P(op1) <= op2) || zephir_less_equal_double(op1, op2))
#define ZEPHIR_GE(op1, op2)       zephir_greater_equal(op1, op2)
#define ZEPHIR_GE_LONG(op1, op2)  zephir_greater_equal_long(op1, op2)
#define ZEPHIR_LT(op1, op2)       ((Z_TYPE_P(op1) == IS_LONG && Z_TYPE_P(op2) == IS_LONG) ? Z_LVAL_P(op1) < Z_LVAL_P(op2) : zephir_less(op1, op2))
#define ZEPHIR_LT_LONG(op1, op2)  ((Z_TYPE_P(op1) == IS_LONG && Z_LVAL_P(op1) < op2) || zephir_less_long(op1, op2))
#define ZEPHIR_LT_DOUBLE(op1, op2)  ((Z_TYPE_P(op1) == IS_DOUBLE && Z_DVAL_P(op1) < op2) || zephir_less_double(op1, op2))
#define ZEPHIR_GT(op1, op2)       zephir_greater(op1, op2)
#define ZEPHIR_GT_LONG(op1, op2)  ((Z_TYPE_P(op1) == IS_LONG && Z_LVAL_P(op1) > op2) || zephir_greater_long(op1, op2))
#define ZEPHIR_GT_DOUBLE(op1, op2)  ((Z_TYPE_P(op1) == IS_DOUBLE && Z_DVAL_P(op1) > op2) || zephir_greater_double(op1, op2))

#define ZEPHIR_STRING_OFFSET(op1, index) ((index >= 0 && index < Z_STRLEN_P(op1)) ? Z_STRVAL_P(op1)[index] : '\0')

/* concatenation */
static void zephir_concat_self(zval *left, zval *right);
static void zephir_concat_self_str(zval *left, const char *right, int right_length);
static void zephir_concat_self_long(zval *left, const long right);
static void zephir_concat_self_char(zval *left, unsigned char right);

/** Strict comparing */
static int zephir_compare_strict_string(zval *op1, const char *op2, int op2_length);
static int zephir_compare_strict_long(zval *op1, long op2);

/** Operator functions */
static int zephir_add_function_ex(zval *result, zval *op1, zval *op2);
static int zephir_and_function(zval *result, zval *left, zval *right);
static void zephir_negate(zval *z);

/** Bitwise functions */
static int zephir_bitwise_and_function(zval *result, zval *op1, zval *op2);
static int zephir_bitwise_or_function(zval *result, zval *op1, zval *op2);
static int zephir_bitwise_xor_function(zval *result, zval *op1, zval *op2);
static int zephir_shift_left_function(zval *result, zval *op1, zval *op2);
static int zephir_shift_right_function(zval *result, zval *op1, zval *op2);

/** Strict comparing */
static int zephir_compare_strict_string(zval *op1, const char *op2, int op2_length);
static int zephir_compare_strict_long(zval *op1, long op2);
static int zephir_compare_strict_double(zval *op1, double op2);
static int zephir_compare_strict_bool(zval *op1, zend_bool op2);

static void zephir_cast(zval *result, zval *var, uint32_t type);
static void zephir_convert_to_object(zval *op);
long zephir_get_intval_ex(const zval *op);
long zephir_get_charval_ex(const zval *op);
double zephir_get_doubleval_ex(const zval *op);
zend_bool zephir_get_boolval_ex(zval *op);

static int zephir_is_numeric_ex(const zval *op);

static int zephir_is_equal(zval *op1, zval *op2);
static int zephir_is_identical(zval *op1, zval *op2);

static int zephir_less(zval *op1, zval *op2);
static int zephir_less_long(zval *op1, long op2);
static int zephir_less_double(zval *op1, double op2);

static int zephir_greater(zval *op1, zval *op2);
static int zephir_greater_long(zval *op1, long op2);
static int zephir_greater_double(zval *op1, double op2);

static int zephir_less_equal(zval *op1, zval *op2);
static int zephir_less_equal_long(zval *op1, long op2);

static int zephir_greater_equal(zval *op1, zval *op2);
static int zephir_greater_equal_long(zval *op1, long op2);

double zephir_safe_div_long_long(long op1, long op2);
double zephir_safe_div_long_double(long op1, double op2);
double zephir_safe_div_double_long(double op1, long op2);
double zephir_safe_div_double_double(double op1, double op2);
double zephir_safe_div_zval_long(zval *op1, long op2);
double zephir_safe_div_zval_double(zval *op1, double op2);
double zephir_safe_div_long_zval(long op1, zval *op2);
double zephir_safe_div_double_zval(double op1, zval *op2);

long zephir_safe_mod_long_long(long op1, long op2);
long zephir_safe_mod_long_double(long op1, double op2);
long zephir_safe_mod_double_long(double op1, long op2);
long zephir_safe_mod_double_double(double op1, double op2);
long zephir_safe_mod_zval_long(zval *op1, long op2);
long zephir_safe_mod_zval_double(zval *op1, double op2);
long zephir_safe_mod_long_zval(long op1, zval *op2);
long zephir_safe_mod_double_zval(double op1, zval *op2);

#define zephir_get_numberval(z) (Z_TYPE_P(z) == IS_LONG ? Z_LVAL_P(z) : zephir_get_doubleval(z))
#define zephir_get_intval(z) (Z_TYPE_P(z) == IS_LONG ? Z_LVAL_P(z) : zephir_get_intval_ex(z))
#define zephir_get_doubleval(z) (Z_TYPE_P(z) == IS_DOUBLE ? Z_DVAL_P(z) : zephir_get_doubleval_ex(z))
#define zephir_get_boolval(z) (Z_TYPE_P(z) == IS_TRUE ? 1 : (Z_TYPE_P(z) == IS_FALSE ? 0 : zephir_get_boolval_ex(z)))
#define zephir_get_charval(z) (Z_TYPE_P(z) == IS_LONG ? Z_LVAL_P(z) : zephir_get_charval_ex(z))

#if PHP_VERSION_ID >= 80300
#define zephir_add_function(result, left, right) add_function(result, left, right)
#else
#define zephir_add_function(result, left, right) fast_add_function(result, left, right)
#endif
#define zephir_sub_function(result, left, right) sub_function(result, left, right)
#define zephir_pow_function(result, op1, op2) pow_function(result, op1, op2)
#define zephir_increment(var) increment_function(var)
#define zephir_decrement(var) decrement_function(var)

#define ZEPHIR_ADD_ASSIGN(z, v)  \
	{  \
		zval tmp;  \
		SEPARATE_ZVAL(z);  \
		add_function(&tmp, z, v);  \
		if (Z_TYPE(tmp) == IS_LONG) {  \
			Z_LVAL_P(z) = Z_LVAL(tmp);  \
		} else {  \
			if (Z_TYPE(tmp) == IS_DOUBLE) {  \
				Z_DVAL_P(z) = Z_DVAL(tmp);  \
			}  \
		}  \
	}

#define ZEPHIR_SUB_ASSIGN(z, v)  \
	{  \
		zval tmp;  \
		SEPARATE_ZVAL(z);  \
		sub_function(&tmp, z, v);  \
		if (Z_TYPE(tmp) == IS_LONG) {  \
			Z_LVAL_P(z) = Z_LVAL(tmp);  \
		} else {  \
			if (Z_TYPE(tmp) == IS_DOUBLE) {  \
				Z_DVAL_P(z) = Z_DVAL(tmp);  \
			}  \
		}  \
	}

#define ZEPHIR_MUL_ASSIGN(z, v)  \
	{  \
		zval tmp;  \
		SEPARATE_ZVAL(z);  \
		mul_function(&tmp, z, v);  \
		if (Z_TYPE(tmp) == IS_LONG) {  \
			Z_LVAL_P(z) = Z_LVAL(tmp);  \
		} else {  \
			if (Z_TYPE(tmp) == IS_DOUBLE) {  \
				Z_DVAL_P(z) = Z_DVAL(tmp);  \
			}  \
		}  \
	}

#define zephir_cast_to_string(left, right) \
    { \
        int use_copy_right; \
        zval right_tmp; \
        if (Z_TYPE_P(right) == IS_STRING) { \
            ZEPHIR_CPY_WRT(left, right); \
        } else { \
            use_copy_right = zephir_make_printable_zval(right, &right_tmp); \
            if (use_copy_right) { \
                ZEPHIR_INIT_NVAR(left); \
                ZVAL_STRINGL(left, Z_STRVAL(right_tmp), Z_STRLEN(right_tmp)); \
                zval_ptr_dtor(&right_tmp); \
            } \
        } \
    }

#define zephir_get_strval(left, right) \
	{ \
		int use_copy_right; \
		zval right_tmp; \
		if (Z_TYPE_P(right) == IS_STRING) { \
			ZEPHIR_CPY_WRT(left, right); \
		} else if (Z_TYPE_P(right) == IS_NULL) { \
		    ZEPHIR_INIT_VAR(left); \
		} else { \
			use_copy_right = zephir_make_printable_zval(right, &right_tmp); \
			if (use_copy_right) { \
				ZEPHIR_INIT_NVAR(left); \
				ZVAL_STRINGL(left, Z_STRVAL(right_tmp), Z_STRLEN(right_tmp)); \
				zval_ptr_dtor(&right_tmp); \
			} \
		} \
	}

#define zephir_get_arrval(returnValue, passValue) \
	{ \
		if (Z_TYPE_P(passValue) == IS_ARRAY) { \
			ZEPHIR_CPY_WRT(returnValue, passValue); \
		} else if (Z_ISNULL_P(passValue) || Z_ISUNDEF_P(passValue)) { \
			ZEPHIR_INIT_NVAR(returnValue); \
			array_init_size(returnValue, 0); \
		} else { \
			convert_to_array(passValue); \
			ZEPHIR_CPY_WRT(returnValue, passValue); \
		} \
	}

#define zephir_is_numeric(value) (Z_TYPE_P(value) == IS_LONG || Z_TYPE_P(value) == IS_DOUBLE || zephir_is_numeric_ex(value))

#define zephir_is_true(value) \
	(Z_TYPE_P(value) == IS_TRUE ? 1 : \
		(Z_TYPE_P(value) == IS_FALSE ? 0 : \
			(Z_TYPE_P(value) == IS_NULL ? 0 : \
				(Z_TYPE_P(value) == IS_LONG ? (Z_LVAL_P(value) ? 1 : 0) : \
					zend_is_true(value) \
				) \
			) \
		) \
	)


#endif



#ifndef ZEPHIR_KERNEL_CONCAT_H
#define ZEPHIR_KERNEL_CONCAT_H
#define ZEPHIR_CONCAT_SS(result, op1, op2) \
	 zephir_concat_ss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, 0);
#define ZEPHIR_SCONCAT_SS(result, op1, op2) \
	 zephir_concat_ss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, 1);

#define ZEPHIR_CONCAT_SSS(result, op1, op2, op3) \
	 zephir_concat_sss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, 0);
#define ZEPHIR_SCONCAT_SSS(result, op1, op2, op3) \
	 zephir_concat_sss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, 1);

#define ZEPHIR_CONCAT_SSSSSS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_ssssss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, sizeof(op5)-1, op6, sizeof(op6)-1, 0);
#define ZEPHIR_SCONCAT_SSSSSS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_ssssss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, sizeof(op5)-1, op6, sizeof(op6)-1, 1);

#define ZEPHIR_CONCAT_SSSVSS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_sssvss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, sizeof(op6)-1, 0);
#define ZEPHIR_SCONCAT_SSSVSS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_sssvss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, sizeof(op6)-1, 1);

#define ZEPHIR_CONCAT_SSSVSVSSVSVSS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13) \
	 zephir_concat_sssvsvssvsvss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, sizeof(op8)-1, op9, op10, sizeof(op10)-1, op11, op12, sizeof(op12)-1, op13, sizeof(op13)-1, 0);
#define ZEPHIR_SCONCAT_SSSVSVSSVSVSS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13) \
	 zephir_concat_sssvsvssvsvss(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, sizeof(op8)-1, op9, op10, sizeof(op10)-1, op11, op12, sizeof(op12)-1, op13, sizeof(op13)-1, 1);

#define ZEPHIR_CONCAT_SSSVSVSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13) \
	 zephir_concat_sssvsvsvsvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, op10, op11, sizeof(op11)-1, op12, op13, sizeof(op13)-1, 0);
#define ZEPHIR_SCONCAT_SSSVSVSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13) \
	 zephir_concat_sssvsvsvsvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, op10, op11, sizeof(op11)-1, op12, op13, sizeof(op13)-1, 1);

#define ZEPHIR_CONCAT_SSV(result, op1, op2, op3) \
	 zephir_concat_ssv(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, 0);
#define ZEPHIR_SCONCAT_SSV(result, op1, op2, op3) \
	 zephir_concat_ssv(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, 1);

#define ZEPHIR_CONCAT_SSVSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_ssvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 0);
#define ZEPHIR_SCONCAT_SSVSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_ssvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 1);

#define ZEPHIR_CONCAT_SSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_ssvsvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 0);
#define ZEPHIR_SCONCAT_SSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_ssvsvsvs(result, op1, sizeof(op1)-1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 1);

#define ZEPHIR_CONCAT_SV(result, op1, op2) \
	 zephir_concat_sv(result, op1, sizeof(op1)-1, op2, 0);
#define ZEPHIR_SCONCAT_SV(result, op1, op2) \
	 zephir_concat_sv(result, op1, sizeof(op1)-1, op2, 1);

#define ZEPHIR_CONCAT_SVS(result, op1, op2, op3) \
	 zephir_concat_svs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, 0);
#define ZEPHIR_SCONCAT_SVS(result, op1, op2, op3) \
	 zephir_concat_svs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, 1);

#define ZEPHIR_CONCAT_SVSSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 0);
#define ZEPHIR_SCONCAT_SVSSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 1);

#define ZEPHIR_CONCAT_SVSSVSSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9) \
	 zephir_concat_svssvssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, 0);
#define ZEPHIR_SCONCAT_SVSSVSSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9) \
	 zephir_concat_svssvssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, 1);

#define ZEPHIR_CONCAT_SVSSVSSVSSVSSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13, op14, op15) \
	 zephir_concat_svssvssvssvssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, op10, sizeof(op10)-1, op11, op12, sizeof(op12)-1, op13, sizeof(op13)-1, op14, op15, sizeof(op15)-1, 0);
#define ZEPHIR_SCONCAT_SVSSVSSVSSVSSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, op12, op13, op14, op15) \
	 zephir_concat_svssvssvssvssvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, op10, sizeof(op10)-1, op11, op12, sizeof(op12)-1, op13, sizeof(op13)-1, op14, op15, sizeof(op15)-1, 1);

#define ZEPHIR_CONCAT_SVSSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_svssvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 0);
#define ZEPHIR_SCONCAT_SVSSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_svssvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 1);

#define ZEPHIR_CONCAT_SVSV(result, op1, op2, op3, op4) \
	 zephir_concat_svsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, 0);
#define ZEPHIR_SCONCAT_SVSV(result, op1, op2, op3, op4) \
	 zephir_concat_svsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, 1);

#define ZEPHIR_CONCAT_SVSVS(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, 0);
#define ZEPHIR_SCONCAT_SVSVS(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, 1);

#define ZEPHIR_CONCAT_SVSVSSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10) \
	 zephir_concat_svsvssvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, op9, op10, sizeof(op10)-1, 0);
#define ZEPHIR_SCONCAT_SVSVSSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10) \
	 zephir_concat_svsvssvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, op9, op10, sizeof(op10)-1, 1);

#define ZEPHIR_CONCAT_SVSVSV(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svsvsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, 0);
#define ZEPHIR_SCONCAT_SVSVSV(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svsvsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, 1);

#define ZEPHIR_CONCAT_SVSVSVS(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, 0);
#define ZEPHIR_SCONCAT_SVSVSVS(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, 1);

#define ZEPHIR_CONCAT_SVSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9) \
	 zephir_concat_svsvsvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, 0);
#define ZEPHIR_SCONCAT_SVSVSVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8, op9) \
	 zephir_concat_svsvsvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, sizeof(op5)-1, op6, op7, sizeof(op7)-1, op8, op9, sizeof(op9)-1, 1);

#define ZEPHIR_CONCAT_SVSVV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svsvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, 0);
#define ZEPHIR_SCONCAT_SVSVV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svsvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, 1);

#define ZEPHIR_CONCAT_SVSVVSV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvvsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, sizeof(op6)-1, op7, 0);
#define ZEPHIR_SCONCAT_SVSVVSV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvvsv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, sizeof(op6)-1, op7, 1);

#define ZEPHIR_CONCAT_SVSVVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_svsvvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 0);
#define ZEPHIR_SCONCAT_SVSVVSVS(result, op1, op2, op3, op4, op5, op6, op7, op8) \
	 zephir_concat_svsvvsvs(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, sizeof(op6)-1, op7, op8, sizeof(op8)-1, 1);

#define ZEPHIR_CONCAT_SVSVVV(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svsvvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, 0);
#define ZEPHIR_SCONCAT_SVSVVV(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_svsvvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, 1);

#define ZEPHIR_CONCAT_SVSVVVV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvvvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, op7, 0);
#define ZEPHIR_SCONCAT_SVSVVVV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_svsvvvv(result, op1, sizeof(op1)-1, op2, op3, sizeof(op3)-1, op4, op5, op6, op7, 1);

#define ZEPHIR_CONCAT_SVV(result, op1, op2, op3) \
	 zephir_concat_svv(result, op1, sizeof(op1)-1, op2, op3, 0);
#define ZEPHIR_SCONCAT_SVV(result, op1, op2, op3) \
	 zephir_concat_svv(result, op1, sizeof(op1)-1, op2, op3, 1);

#define ZEPHIR_CONCAT_SVVS(result, op1, op2, op3, op4) \
	 zephir_concat_svvs(result, op1, sizeof(op1)-1, op2, op3, op4, sizeof(op4)-1, 0);
#define ZEPHIR_SCONCAT_SVVS(result, op1, op2, op3, op4) \
	 zephir_concat_svvs(result, op1, sizeof(op1)-1, op2, op3, op4, sizeof(op4)-1, 1);

#define ZEPHIR_CONCAT_SVVVS(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svvvs(result, op1, sizeof(op1)-1, op2, op3, op4, op5, sizeof(op5)-1, 0);
#define ZEPHIR_SCONCAT_SVVVS(result, op1, op2, op3, op4, op5) \
	 zephir_concat_svvvs(result, op1, sizeof(op1)-1, op2, op3, op4, op5, sizeof(op5)-1, 1);

#define ZEPHIR_CONCAT_SVVVVVVVVVV(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11) \
	 zephir_concat_svvvvvvvvvv(result, op1, sizeof(op1)-1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, 0);
#define ZEPHIR_SCONCAT_SVVVVVVVVVV(result, op1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11) \
	 zephir_concat_svvvvvvvvvv(result, op1, sizeof(op1)-1, op2, op3, op4, op5, op6, op7, op8, op9, op10, op11, 1);

#define ZEPHIR_CONCAT_VS(result, op1, op2) \
	 zephir_concat_vs(result, op1, op2, sizeof(op2)-1, 0);
#define ZEPHIR_SCONCAT_VS(result, op1, op2) \
	 zephir_concat_vs(result, op1, op2, sizeof(op2)-1, 1);

#define ZEPHIR_CONCAT_VSV(result, op1, op2, op3) \
	 zephir_concat_vsv(result, op1, op2, sizeof(op2)-1, op3, 0);
#define ZEPHIR_SCONCAT_VSV(result, op1, op2, op3) \
	 zephir_concat_vsv(result, op1, op2, sizeof(op2)-1, op3, 1);

#define ZEPHIR_CONCAT_VSVS(result, op1, op2, op3, op4) \
	 zephir_concat_vsvs(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, 0);
#define ZEPHIR_SCONCAT_VSVS(result, op1, op2, op3, op4) \
	 zephir_concat_vsvs(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, 1);

#define ZEPHIR_CONCAT_VSVSV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_vsvsv(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, 0);
#define ZEPHIR_SCONCAT_VSVSV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_vsvsv(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, 1);

#define ZEPHIR_CONCAT_VSVSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_vsvsvs(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 0);
#define ZEPHIR_SCONCAT_VSVSVS(result, op1, op2, op3, op4, op5, op6) \
	 zephir_concat_vsvsvs(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, 1);

#define ZEPHIR_CONCAT_VSVSVSV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_vsvsvsv(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, 0);
#define ZEPHIR_SCONCAT_VSVSVSV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_vsvsvsv(result, op1, op2, sizeof(op2)-1, op3, op4, sizeof(op4)-1, op5, op6, sizeof(op6)-1, op7, 1);

#define ZEPHIR_CONCAT_VV(result, op1, op2) \
	 zephir_concat_vv(result, op1, op2, 0);
#define ZEPHIR_SCONCAT_VV(result, op1, op2) \
	 zephir_concat_vv(result, op1, op2, 1);

#define ZEPHIR_CONCAT_VVS(result, op1, op2, op3) \
	 zephir_concat_vvs(result, op1, op2, op3, sizeof(op3)-1, 0);
#define ZEPHIR_SCONCAT_VVS(result, op1, op2, op3) \
	 zephir_concat_vvs(result, op1, op2, op3, sizeof(op3)-1, 1);

#define ZEPHIR_CONCAT_VVSV(result, op1, op2, op3, op4) \
	 zephir_concat_vvsv(result, op1, op2, op3, sizeof(op3)-1, op4, 0);
#define ZEPHIR_SCONCAT_VVSV(result, op1, op2, op3, op4) \
	 zephir_concat_vvsv(result, op1, op2, op3, sizeof(op3)-1, op4, 1);

#define ZEPHIR_CONCAT_VVV(result, op1, op2, op3) \
	 zephir_concat_vvv(result, op1, op2, op3, 0);
#define ZEPHIR_SCONCAT_VVV(result, op1, op2, op3) \
	 zephir_concat_vvv(result, op1, op2, op3, 1);

#define ZEPHIR_CONCAT_VVVV(result, op1, op2, op3, op4) \
	 zephir_concat_vvvv(result, op1, op2, op3, op4, 0);
#define ZEPHIR_SCONCAT_VVVV(result, op1, op2, op3, op4) \
	 zephir_concat_vvvv(result, op1, op2, op3, op4, 1);

#define ZEPHIR_CONCAT_VVVVSVV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_vvvvsvv(result, op1, op2, op3, op4, op5, sizeof(op5)-1, op6, op7, 0);
#define ZEPHIR_SCONCAT_VVVVSVV(result, op1, op2, op3, op4, op5, op6, op7) \
	 zephir_concat_vvvvsvv(result, op1, op2, op3, op4, op5, sizeof(op5)-1, op6, op7, 1);

#define ZEPHIR_CONCAT_VVVVV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_vvvvv(result, op1, op2, op3, op4, op5, 0);
#define ZEPHIR_SCONCAT_VVVVV(result, op1, op2, op3, op4, op5) \
	 zephir_concat_vvvvv(result, op1, op2, op3, op4, op5, 1);


static void zephir_concat_ss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, int self_var);
static void zephir_concat_sss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, int self_var);
static void zephir_concat_ssssss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, int self_var);
static void zephir_concat_sssvss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, int self_var);
static void zephir_concat_sssvsvssvsvss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, const char *op8, uint32_t op8_len, zval *op9, const char *op10, uint32_t op10_len, zval *op11, const char *op12, uint32_t op12_len, const char *op13, uint32_t op13_len, int self_var);
static void zephir_concat_sssvsvsvsvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, zval *op10, const char *op11, uint32_t op11_len, zval *op12, const char *op13, uint32_t op13_len, int self_var);
static void zephir_concat_ssv(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, int self_var);
static void zephir_concat_ssvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var);
static void zephir_concat_ssvsvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var);
static void zephir_concat_sv(zval *result, const char *op1, uint32_t op1_len, zval *op2, int self_var);
static void zephir_concat_svs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, int self_var);
static void zephir_concat_svssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var);
static void zephir_concat_svssvssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, int self_var);
static void zephir_concat_svssvssvssvssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, const char *op10, uint32_t op10_len, zval *op11, const char *op12, uint32_t op12_len, const char *op13, uint32_t op13_len, zval *op14, const char *op15, uint32_t op15_len, int self_var);
static void zephir_concat_svssvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var);
static void zephir_concat_svsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, int self_var);
static void zephir_concat_svsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, int self_var);
static void zephir_concat_svsvssvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, zval *op9, const char *op10, uint32_t op10_len, int self_var);
static void zephir_concat_svsvsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, int self_var);
static void zephir_concat_svsvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, int self_var);
static void zephir_concat_svsvsvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, int self_var);
static void zephir_concat_svsvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, int self_var);
static void zephir_concat_svsvvsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, const char *op6, uint32_t op6_len, zval *op7, int self_var);
static void zephir_concat_svsvvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var);
static void zephir_concat_svsvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, zval *op6, int self_var);
static void zephir_concat_svsvvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, zval *op6, zval *op7, int self_var);
static void zephir_concat_svv(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, int self_var);
static void zephir_concat_svvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, const char *op4, uint32_t op4_len, int self_var);
static void zephir_concat_svvvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, zval *op4, const char *op5, uint32_t op5_len, int self_var);
static void zephir_concat_svvvvvvvvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, zval *op4, zval *op5, zval *op6, zval *op7, zval *op8, zval *op9, zval *op10, zval *op11, int self_var);
static void zephir_concat_vs(zval *result, zval *op1, const char *op2, uint32_t op2_len, int self_var);
static void zephir_concat_vsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, int self_var);
static void zephir_concat_vsvs(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, int self_var);
static void zephir_concat_vsvsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, int self_var);
static void zephir_concat_vsvsvs(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var);
static void zephir_concat_vsvsvsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, int self_var);
static void zephir_concat_vv(zval *result, zval *op1, zval *op2, int self_var);
static void zephir_concat_vvs(zval *result, zval *op1, zval *op2, const char *op3, uint32_t op3_len, int self_var);
static void zephir_concat_vvsv(zval *result, zval *op1, zval *op2, const char *op3, uint32_t op3_len, zval *op4, int self_var);
static void zephir_concat_vvv(zval *result, zval *op1, zval *op2, zval *op3, int self_var);
static void zephir_concat_vvvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, int self_var);
static void zephir_concat_vvvvsvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, const char *op5, uint32_t op5_len, zval *op6, zval *op7, int self_var);
static void zephir_concat_vvvvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, zval *op5, int self_var);
static void zephir_concat_function(zval *result, zval *op1, zval *op2);
#endif /* ZEPHIR_KERNEL_CONCAT_H */



#ifndef ZEPHIR_KERNEL_MATH_H
#define ZEPHIR_KERNEL_MATH_H


double zephir_sin(zval *op1);
double zephir_asin(zval *op1);
double zephir_tan(zval *op1);
double zephir_cos(zval *op1);
double zephir_acos(zval *op1);
double zephir_sqrt(zval *op1);

double zephir_floor(zval *op1);
double zephir_ceil(zval *op1);
static void zephir_round(zval *return_value, zval *op1, zval *op2, zval *op3);

double zephir_ldexp(zval *value, zval *expval);

#endif



#ifndef ZEPHIR_KERNEL_VARIABLES_H
#define ZEPHIR_KERNEL_VARIABLES_H


static void zephir_var_dump(zval *var);

static void zephir_var_export(zval *var);
static void zephir_var_export_ex(zval *return_value, zval *var);

static void zephir_get_defined_vars(zval *return_value);

#endif



#ifndef ZEPHIR_KERNEL_FILTER_H
#define ZEPHIR_KERNEL_FILTER_H


static void zephir_filter_alphanum(zval *return_value, zval *param);
static void zephir_is_basic_charset(zval *return_value, const zval *param);
static void zephir_escape_multi(zval *return_value, zval *param, const char *escape_char, unsigned int escape_length, char escape_extra, int use_whitelist);
static void zephir_escape_js(zval *return_value, zval *param);
static void zephir_escape_css(zval *return_value, zval *param);

#endif



#ifndef ZEPHIR_KERNEL_ITERATOR_H
#define ZEPHIR_KERNEL_ITERATOR_H


zend_object_iterator *zephir_get_iterator(zval *iterator);

#define ZEPHIR_ITERATOR_COPY(var, it) \
	{ \
		zval *ZEPHIR_TMP_ITERATOR_PTR; \
		ZEPHIR_TMP_ITERATOR_PTR = it->funcs->get_current_data(it); \
		if (UNEXPECTED(EG(exception) != NULL)) { \
			return; \
		} \
		ZEPHIR_INIT_NVAR(var); \
		if (Z_ISREF_P(var)) { \
			ZVAL_DUP(var, Z_REFVAL_P(var)); \
		} else { \
			ZVAL_COPY(var, ZEPHIR_TMP_ITERATOR_PTR); \
		} \
	}

#endif



#ifndef ZEPHIR_KERNEL_TIME_H
#define ZEPHIR_KERNEL_TIME_H


#define MICRO_IN_SEC 1000000.00

static void zephir_time(zval *return_value);
#ifdef HAVE_GETTIMEOFDAY
static void zephir_microtime(zval *return_value, zval *get_as_float);
#endif

#endif /* ZEPHIR_KERNEL_TIME_H */



#ifndef ZEPHIR_KERNEL_EXIT_H
#define ZEPHIR_KERNEL_EXIT_H


static void zephir_exit_empty();
static void zephir_exit(zval *ptr);

#endif



#ifdef HAVE_CONFIG_H
#endif




zend_string* i_parent = NULL;
zend_string* i_static = NULL;
zend_string* i_self   = NULL;

static int zephir_is_iterable_ex(zval *arr, int duplicate)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_iterator))) {
		return 1;
	} else if (UNEXPECTED(Z_TYPE_P(arr) != IS_ARRAY)) {
		return 0;
	}
    //TODO: duplicate
    return 1;
}

static int zephir_fetch_parameters(int num_args, int required_args, int optional_args, ...)
{
	va_list va;
	int arg_count = ZEND_CALL_NUM_ARGS(EG(current_execute_data));
	zval *arg, **p;
	int i;

	if (num_args < required_args || (num_args > (required_args + optional_args))) {
		zephir_throw_exception_string(spl_ce_BadMethodCallException, SL("Wrong number of parameters"));
		return FAILURE;
	}

	if (num_args > arg_count) {
		zephir_throw_exception_string(spl_ce_BadMethodCallException, SL("Could not obtain parameters for parsing"));
		return FAILURE;
	}

	if (!num_args) {
		return SUCCESS;
	}

	va_start(va, optional_args);

	i = 0;
	while (num_args-- > 0) {
		arg = ZEND_CALL_ARG(EG(current_execute_data), i + 1);
		p = va_arg(va, zval **);
		*p = arg;

		i++;
	}

	va_end(va);

	return SUCCESS;
}

static int zephir_get_global(zval *arr, const char *global, unsigned int global_length)
{
	zend_array *symbol_table;
	zend_string *str = zend_string_init(global, global_length, 0);

	if (PG(auto_globals_jit)) {
		zend_is_auto_global(str);
	}

	if (&EG(symbol_table)) {
		zval *gv;

		if ((gv = zend_hash_find_ind(&EG(symbol_table), str)) != NULL) {
			ZVAL_DEREF(gv);
			if (Z_TYPE_P(gv) == IS_ARRAY) {
				if (Z_REFCOUNTED_P(gv) && Z_REFCOUNT_P(gv) <= 1) {
					ZVAL_COPY_VALUE(arr, gv);
				} else {
					ZVAL_DUP(arr, gv);
					zend_hash_update(&EG(symbol_table), str, arr);
				}

				zend_string_release(str);
				return SUCCESS;
			}
		}
	}

	array_init(arr);
	if (!(&EG(symbol_table))) {
		symbol_table = zend_rebuild_symbol_table();
	} else {
		symbol_table = &EG(symbol_table);
	}

	zend_hash_update(symbol_table, str, arr);
	zend_string_release(str);

	return FAILURE;
}

static void zephir_fast_count(zval *result, zval *value)
{
	if (Z_TYPE_P(value) == IS_ARRAY) {
		ZVAL_LONG(result, zend_hash_num_elements(Z_ARRVAL_P(value)));
		return;
	}

	if (Z_TYPE_P(value) == IS_OBJECT) {
		zval retval;

		if (Z_OBJ_HT_P(value)->count_elements) {
			ZVAL_LONG(result, 1);
			if (SUCCESS == Z_OBJ_HT(*value)->count_elements(Z_OBJ_P(value), &Z_LVAL_P(result))) {
				return;
			}
		}

		if (instanceof_function(Z_OBJCE_P(value), zend_ce_countable)) {
			zend_call_method_with_0_params(Z_OBJ_P(value), NULL, NULL, "count", &retval);
			if (Z_TYPE(retval) != IS_UNDEF) {
				convert_to_long_ex(&retval);
				ZVAL_LONG(result, Z_LVAL(retval));
				zval_ptr_dtor(&retval);
			}
			return;
		}

		ZVAL_LONG(result, 0);
		return;
	}

	if (Z_TYPE_P(value) == IS_NULL) {
		ZVAL_LONG(result, 0);
		return;
	}

	ZVAL_LONG(result, 1);
}

static int zephir_fast_count_ev(zval *value)
{
	zend_long count = 0;

	if (Z_TYPE_P(value) == IS_ARRAY) {
		return zend_hash_num_elements(Z_ARRVAL_P(value)) > 0;
	}

	if (Z_TYPE_P(value) == IS_OBJECT) {
		zval retval;

		if (Z_OBJ_HT_P(value)->count_elements) {
			Z_OBJ_HT(*value)->count_elements(Z_OBJ_P(value), &count);
			return (int) count > 0;
		}

		if (instanceof_function(Z_OBJCE_P(value), zend_ce_countable)) {
			zend_call_method_with_0_params(Z_OBJ_P(value), NULL, NULL, "count", &retval);
			if (Z_TYPE(retval) != IS_UNDEF) {
				convert_to_long_ex(&retval);
				count = Z_LVAL(retval);
				zval_ptr_dtor(&retval);
				return (int) count > 0;
			}
			return 0;
		}

		return 0;
	}

	if (Z_TYPE_P(value) == IS_NULL) {
		return 0;
	}

	return 1;
}

static int zephir_fast_count_int(zval *value)
{
	zend_long count = 0;

	if (Z_TYPE_P(value) == IS_ARRAY) {
		return zend_hash_num_elements(Z_ARRVAL_P(value));
	}

	if (Z_TYPE_P(value) == IS_OBJECT) {
		zval retval;

		if (Z_OBJ_HT_P(value)->count_elements) {
			Z_OBJ_HT(*value)->count_elements(Z_OBJ_P(value), &count);
			return (int) count;
		}

		if (instanceof_function(Z_OBJCE_P(value), zend_ce_countable)) {
			zend_call_method_with_0_params(Z_OBJ_P(value), NULL, NULL, "count", &retval);
			if (Z_TYPE(retval) != IS_UNDEF) {
				convert_to_long_ex(&retval);
				count = Z_LVAL(retval);
				zval_ptr_dtor(&retval);
				return (int) count;
			}
			return 0;
		}

		return 0;
	}

	if (Z_TYPE_P(value) == IS_NULL) {
		return 0;
	}

	return 1;
}

static int zephir_function_exists(const zval *function_name)
{
	if (zend_hash_str_exists(CG(function_table), Z_STRVAL_P(function_name), Z_STRLEN_P(function_name))) {
		return SUCCESS;
	}

	return FAILURE;
}

static int zephir_function_exists_ex(const char *function_name, unsigned int function_len)
{
	if (zend_hash_str_exists(CG(function_table), function_name, function_len) != NULL) {
        return SUCCESS;
    }

    return FAILURE;
}

static int zephir_is_callable(zval *var)
{
	char *error = NULL;
	zend_bool retval;

	retval = zend_is_callable_ex(var, NULL, 0, NULL, NULL, &error);
	if (error) {
		efree(error);
	}

	return (int) retval;
}

static int zephir_is_scalar(zval *var)
{
	switch (Z_TYPE_P(var)) {
		case IS_TRUE:
		case IS_FALSE:
		case IS_DOUBLE:
		case IS_LONG:
		case IS_STRING:
			return 1;
			break;
	}

	return 0;
}

static void zephir_gettype(zval *return_value, zval *arg)
{
	switch (Z_TYPE_P(arg)) {

		case IS_NULL:
			RETVAL_STRING("NULL");
			break;

		case IS_TRUE:
		case IS_FALSE:
			RETVAL_STRING("boolean");
			break;

		case IS_LONG:
			RETVAL_STRING("integer");
			break;

		case IS_DOUBLE:
			RETVAL_STRING("double");
			break;

		case IS_STRING:
			RETVAL_STRING("string");
			break;

		case IS_ARRAY:
			RETVAL_STRING("array");
			break;

		case IS_OBJECT:
			RETVAL_STRING("object");
			break;

		case IS_RESOURCE:
			{
				const char *type_name = zend_rsrc_list_get_rsrc_type(Z_RES_P(arg));

				if (type_name) {
					RETVAL_STRING("resource");
					break;
				}
			}
			/* no break */

		default:
			RETVAL_STRING("unknown type");
	}
}

zend_class_entry* zephir_get_internal_ce(const char *class_name, unsigned int class_name_len)
{
    zend_class_entry* temp_ce;

    if ((temp_ce = zend_hash_str_find_ptr(CG(class_table), class_name, class_name_len)) == NULL) {
        zend_error(E_ERROR, "Class '%s' not found", class_name);
        return NULL;
    }

    return temp_ce;
}

/* Declare constants */
static int zephir_declare_class_constant(zend_class_entry *ce, const char *name, size_t name_length, zval *value)
{
	zend_string *key;

	if (ce->type == ZEND_INTERNAL_CLASS) {
		key = zend_string_init_interned(name, name_length, 1);
	} else {
		key = zend_string_init(name, name_length, 0);
	}

	zend_declare_class_constant_ex(ce, key, value, ZEND_ACC_PUBLIC, NULL);

	if (ce->type != ZEND_INTERNAL_CLASS) {
		zend_string_release(key);
	}

	return SUCCESS;
}

static int zephir_declare_class_constant_null(zend_class_entry *ce, const char *name, size_t name_length)
{
	zval constant;

	ZVAL_NULL(&constant);
	return zephir_declare_class_constant(ce, name, name_length, &constant);
}

static int zephir_declare_class_constant_long(zend_class_entry *ce, const char *name, size_t name_length, zend_long value)
{
	zval constant;

	ZVAL_LONG(&constant, value);
	return zephir_declare_class_constant(ce, name, name_length, &constant);
}

static int zephir_declare_class_constant_bool(zend_class_entry *ce, const char *name, size_t name_length, zend_bool value)
{
	zval constant;

	ZVAL_BOOL(&constant, value);
	return zephir_declare_class_constant(ce, name, name_length, &constant);
}

static int zephir_declare_class_constant_double(zend_class_entry *ce, const char *name, size_t name_length, double value)
{
	zval constant;

	ZVAL_DOUBLE(&constant, value);
	return zephir_declare_class_constant(ce, name, name_length, &constant);
}

static int zephir_declare_class_constant_stringl(zend_class_entry *ce, const char *name, size_t name_length, const char *value, size_t value_length)
{
	zval constant;

	ZVAL_NEW_STR(&constant, zend_string_init(value, value_length, ce->type & ZEND_INTERNAL_CLASS));
	return zephir_declare_class_constant(ce, name, name_length, &constant);
}

static int zephir_declare_class_constant_string(zend_class_entry *ce, const char *name, size_t name_length, const char *value)
{
	return zephir_declare_class_constant_stringl(ce, name, name_length, value, strlen(value));
}

static int zephir_is_php_version(unsigned int id)
{
	int php_major = PHP_MAJOR_VERSION * 10000;
	int php_minor = PHP_MINOR_VERSION * 100;
	int php_release = PHP_RELEASE_VERSION;

	int zep_major = id / 10000;
	int zep_minor = id / 100 - zep_major * 100;
	int zep_release = id - (zep_major * 10000 + zep_minor * 100);

	if (zep_minor == 0)
	{
		php_minor = 0;
	}

	if (zep_release == 0)
	{
		php_release = 0;
	}

	return ((php_major + php_minor + php_release) == id ? 1 : 0);
}

static void zephir_get_args(zval *return_value)
{
	zend_execute_data *ex = EG(current_execute_data);
	uint32_t arg_count    = ZEND_CALL_NUM_ARGS(ex);

	array_init_size(return_value, arg_count);
	if (arg_count) {
		uint32_t first_extra_arg = ex->func->op_array.num_args;
		zval *p    = ZEND_CALL_ARG(ex, 1);
		uint32_t i = 0;

		if (arg_count > first_extra_arg) {
			while (i < first_extra_arg) {
				zval *q = p;

				if (Z_TYPE_P(q) != IS_UNDEF) {
					ZVAL_DEREF(q);
					Z_TRY_ADDREF_P(q);
					zend_hash_next_index_insert_new(Z_ARRVAL_P(return_value), q);
				}

				++p;
				++i;
			}

			p = ZEND_CALL_VAR_NUM(ex, i);
		}

		while (i < arg_count) {
			zval *q = p;

			if (Z_TYPE_P(q) != IS_UNDEF) {
				ZVAL_DEREF(q);
				Z_TRY_ADDREF_P(q);
				zend_hash_next_index_insert_new(Z_ARRVAL_P(return_value), q);
			}

			++p;
			++i;
		}
	}
}

static void zephir_get_arg(zval *return_value, zend_long idx)
{
	zend_execute_data *ex = EG(current_execute_data);
	uint32_t arg_count;
	zval *arg;

	if (UNEXPECTED(idx < 0)) {
		zend_error(E_WARNING, "func_get_arg():  The argument number should be >= 0");
		RETURN_FALSE;
	}

	arg_count = ZEND_CALL_NUM_ARGS(ex);
#if PHP_VERSION_ID >= 80200
	if (zend_forbid_dynamic_call() == FAILURE) {
		RETURN_FALSE;
	}
#else
	if (zend_forbid_dynamic_call("func_get_arg()") == FAILURE) {
		RETURN_FALSE;
	}
#endif

	if (UNEXPECTED((zend_ulong)idx >= arg_count)) {
		zend_error(E_WARNING, "func_get_arg():  Argument " ZEND_LONG_FMT " not passed to function", idx);
		RETURN_FALSE;
	}

	arg = ZEND_CALL_VAR_NUM(ex, idx);

	if (EXPECTED(!Z_ISUNDEF_P(arg))) {
		ZVAL_DEREF(arg);
		ZVAL_COPY(return_value, arg);
		return;
	}

	RETURN_NULL();
}

static void zephir_module_init()
{
	/* Though these strings won't be interned in ZTS,
	 * we still benefit from using zend_string* instead of char*
	 * in hash tables
	 */
	i_parent = zend_new_interned_string(zend_string_init(ZEND_STRL("parent"), 1));
	i_static = zend_new_interned_string(zend_string_init(ZEND_STRL("static"), 1));
	i_self   = zend_new_interned_string(zend_string_init(ZEND_STRL("self"), 1));
}







static zend_always_inline zend_execute_data* find_symbol_table(zend_execute_data* ex)
{
 while (ex && (!ex->func || !ZEND_USER_CODE(ex->func->common.type))) {
	 ex = ex->prev_execute_data;
 }

 return ex;
}

static void ZEPHIR_FASTCALL zephir_memory_grow_stack(zephir_method_globals *g, const char *func)
{
if (g->active_memory == NULL) {
	zephir_memory_entry *active_memory;

	active_memory = (zephir_memory_entry *) pecalloc(1, sizeof(zephir_memory_entry), 0);

	active_memory->addresses = pecalloc(24, sizeof(zval*), 0);
	active_memory->capacity  = 24;

	g->active_memory = active_memory;
}

assert(g->active_memory != NULL);
assert(g->active_memory->pointer == 0);

#ifndef ZEPHIR_RELEASE
g->active_memory->func = func;
#endif
}

static void ZEPHIR_FASTCALL zephir_memory_restore_stack(zephir_method_globals *g, const char *func)
{
size_t i;
zephir_memory_entry *active_memory;
zephir_symbol_table *active_symbol_table;
zval *ptr;
#ifndef ZEPHIR_RELEASE
int show_backtrace = 0;
#endif

#ifndef ZEPHIR_RELEASE
if (UNEXPECTED(g->active_memory == NULL)) {
	fprintf(stderr, "WARNING: calling zephir_memory_restore_stack() without an active memory frame!\n");
	fprintf(stderr, "The frame was created by %s\n", g->active_memory->func);
	fprintf(stderr, "Calling function: %s\n", func);
	zephir_print_backtrace();
	return;
}

if (UNEXPECTED(g->active_memory->func != func)) {
	fprintf(stderr, "Trying to free someone else's memory frame!\n");
	fprintf(stderr, "The frame was created by %s\n", g->active_memory->func);
	fprintf(stderr, "Calling function: %s\n", func);
	zephir_print_backtrace();
	return;
}
#endif

active_memory = g->active_memory;
assert(active_memory != NULL);

if (EXPECTED(!CG(unclean_shutdown))) {
	/* Clean active symbol table */
	if (g->active_symbol_table) {
		active_symbol_table = g->active_symbol_table;
		while (active_symbol_table && active_symbol_table->scope == active_memory) {
			zend_execute_data *ex = find_symbol_table(EG(current_execute_data));
#ifndef ZEPHIR_RELEASE
			if (UNEXPECTED(!ex)) {
				fprintf(stderr, "ERROR: unable to find a symbol table");
				zephir_print_backtrace();
				return;
			}
#endif
			zend_hash_destroy(ex->symbol_table);
			efree(ex->symbol_table);
			ex->symbol_table = active_symbol_table->symbol_table;
			zend_attach_symbol_table(ex);
			zend_rebuild_symbol_table();

			g->active_symbol_table = active_symbol_table->prev;
			efree(active_symbol_table);
			active_symbol_table = g->active_symbol_table;
		}
	}

#ifndef ZEPHIR_RELEASE
	for (i = 0; i < active_memory->pointer; ++i) {
		if (active_memory->addresses[i] != NULL) {
			zval *var = active_memory->addresses[i];
			if (Z_TYPE_P(var) > IS_CALLABLE) {
				fprintf(stderr, "%s: observed variable #%d (%p) has invalid type %u [%s]\n", __func__, (int)i, var, Z_TYPE_P(var), active_memory->func);
				show_backtrace = 1;
			}

			if (!Z_REFCOUNTED_P(var)) {
				continue;
			}

			if (Z_REFCOUNT_P(var) == 0) {
				fprintf(stderr, "%s: observed variable #%d (%p) has 0 references, type=%d [%s]\n", __func__, (int)i, var, Z_TYPE_P(var), active_memory->func);
				show_backtrace = 1;
			}
			else if (Z_REFCOUNT_P(var) >= 1000000) {
				fprintf(stderr, "%s: observed variable #%d (%p) has too many references (%u), type=%d  [%s]\n", __func__, (int)i, var, Z_REFCOUNT_P(var), Z_TYPE_P(var), active_memory->func);
				show_backtrace = 1;
			}
		}
	}
#endif

	/* Traverse all zvals allocated, reduce the reference counting or free them */
	for (i = 0; i < active_memory->pointer; ++i) {
		ptr = active_memory->addresses[i];
		if (EXPECTED(ptr != NULL)) {
			if (!Z_REFCOUNTED_P(ptr)) continue;
			if (Z_REFCOUNT_P(ptr) == 1) {
				zval_ptr_dtor(ptr);
			} else {
				Z_DELREF_P(ptr);
			}
		}
	}
}

#ifndef ZEPHIR_RELEASE
active_memory->func = NULL;
#endif

if (active_memory->addresses != NULL) {
	pefree(active_memory->addresses, 0);
}

pefree(g->active_memory, 0);
g->active_memory = NULL;

#ifndef ZEPHIR_RELEASE
if (show_backtrace == 1) {
	zephir_print_backtrace();
}
#endif
}

static void zephir_initialize_memory(zend_zephir_globals_def *zephir_globals_ptr)
{
	zephir_globals_ptr->fcache = pemalloc(sizeof(HashTable), 1);
	zend_hash_init(zephir_globals_ptr->fcache, 128, NULL, NULL, 1); // zephir_fcall_cache_dtor

	zephir_globals_ptr->initialized = 1;
}

static void zephir_deinitialize_memory()
{
	zend_zephir_globals_def *zephir_globals_ptr = ZEPHIR_VGLOBAL;

	if (zephir_globals_ptr->initialized != 1) {
		zephir_globals_ptr->initialized = 0;
		return;
	}

	zend_hash_destroy(zephir_globals_ptr->fcache);
	pefree(zephir_globals_ptr->fcache, 1);
	zephir_globals_ptr->fcache = NULL;

	zephir_globals_ptr->initialized = 0;
}

static void zephir_create_symbol_table(zephir_method_globals *gptr)
{
	zephir_symbol_table *entry;
	zend_array *symbol_table;

#ifndef ZEPHIR_RELEASE
	if (!gptr->active_memory) {
		fprintf(stderr, "ERROR: Trying to create a virtual symbol table without a memory frame");
		zephir_print_backtrace();
		return;
	}
#endif

	zend_execute_data* ex = find_symbol_table(EG(current_execute_data));
#ifndef ZEPHIR_RELEASE
    if (UNEXPECTED(!ex)) {
        fprintf(stderr, "ERROR: unable to find a symbol table");
        zephir_print_backtrace();
        return;
    }
#endif

	zend_rebuild_symbol_table();
	zend_detach_symbol_table(ex);

	entry               = (zephir_symbol_table*)emalloc(sizeof(zephir_symbol_table));
	entry->scope        = gptr->active_memory;
	entry->symbol_table = ex->symbol_table;
	entry->prev         = gptr->active_symbol_table;

	symbol_table = (zend_array*)emalloc(sizeof(zend_array));
	zend_hash_init(symbol_table, 0, NULL, ZVAL_PTR_DTOR, 0);
	zend_hash_real_init(symbol_table, 0);

	ex->symbol_table          = symbol_table;
	gptr->active_symbol_table = entry;
}

static int zephir_set_symbol(zval *key_name, zval *value)
{
	zend_array *symbol_table;

	symbol_table = zend_rebuild_symbol_table();
	if (!symbol_table) {
		php_error_docref(NULL, E_WARNING, "Cannot find a valid symbol_table");
		return FAILURE;
	}

	if (Z_TYPE_P(key_name) == IS_STRING) {
		Z_TRY_ADDREF_P(value);
		zend_hash_update(symbol_table, Z_STR_P(key_name), value);
	}

	return SUCCESS;
}

static void ZEPHIR_FASTCALL zephir_do_memory_observe(zval *var, const zephir_method_globals *g)
{
	zephir_memory_entry *frame = g->active_memory;
#ifndef ZEPHIR_RELEASE
	if (UNEXPECTED(frame == NULL)) {
		fprintf(stderr, "ZEPHIR_MM_GROW() must be called before using any of MM functions or macros!");
		zephir_print_backtrace();
		abort();
	}
#endif

	if (UNEXPECTED(frame->pointer == frame->capacity)) {
		void *buf = perealloc(frame->addresses, sizeof(zval *) * (frame->capacity + 16), 0);
		if (EXPECTED(buf != NULL)) {
			frame->capacity += 16;
			frame->addresses = buf;
		} else {
			zend_error(E_CORE_ERROR, "Memory allocation failed");
			return;
		}
	}

#ifndef ZEPHIR_RELEASE
	{
		size_t i;
		for (i = 0; i < frame->pointer; ++i) {
			if (frame->addresses[i] == var) {
				fprintf(stderr, "Variable %p is already observed", var);
				zephir_print_backtrace();
				abort();
			}
		}
	}
#endif

	frame->addresses[frame->pointer] = var;
	++frame->pointer;
}



#ifdef HAVE_CONFIG_H
#endif




static void zephir_throw_exception_debug(zval *object, const char *file, uint32_t line)
{
	zend_class_entry *default_exception_ce;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	int ZEPHIR_LAST_CALL_STATUS = 0;
	zval curline;
	zval object_copy;

	ZVAL_UNDEF(&curline);

	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	if (Z_TYPE_P(object) != IS_OBJECT) {
		ZVAL_COPY_VALUE(&object_copy, object);
		object_init_ex(object, zend_exception_get_default());
		ZEPHIR_CALL_METHOD(NULL, object, "__construct", NULL, 0, &object_copy);
		zval_ptr_dtor(&object_copy);
	}

	Z_ADDREF_P(object);

	if (line > 0) {
		ZEPHIR_CALL_METHOD(&curline, object, "getline", NULL, 0);
		zephir_check_call_status();
		if (ZEPHIR_IS_LONG(&curline, 0)) {
			default_exception_ce = zend_exception_get_default();
			zend_update_property_string(default_exception_ce, Z_OBJ_P(object), SL("file"), file);
			zend_update_property_long(default_exception_ce, Z_OBJ_P(object), SL("line"), line);
		}
	}

	if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
		zend_throw_exception_object(object);
	}
	ZEPHIR_MM_RESTORE();
}

static void zephir_throw_exception_string_debug(zend_class_entry *ce, const char *message, uint32_t message_len, const char *file, uint32_t line)
{
	zval object, msg;
	int ZEPHIR_LAST_CALL_STATUS = 0;
	zend_class_entry *default_exception_ce;

	object_init_ex(&object, ce);

	ZVAL_STRINGL(&msg, message, message_len);

	ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, &object, "__construct", NULL, 0, &msg);

	if (line > 0) {
		default_exception_ce = zend_exception_get_default();
		zend_update_property_string(default_exception_ce, Z_OBJ(object), "file", sizeof("file")-1, file);
		zend_update_property_long(default_exception_ce, Z_OBJ(object), "line", sizeof("line")-1, line);
	}

	if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
		zend_throw_exception_object(&object);
	}

	zval_ptr_dtor(&msg);
}

static void zephir_throw_exception_string(zend_class_entry *ce, const char *message, uint32_t message_len)
{
	zval object, msg;
	int ZEPHIR_LAST_CALL_STATUS = 0;

	object_init_ex(&object, ce);

	ZVAL_STRINGL(&msg, message, message_len);

	ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, &object, "__construct", NULL, 0, &msg);

	if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
		zend_throw_exception_object(&object);
	}

	zval_ptr_dtor(&msg);
}

static void zephir_throw_exception_format(zend_class_entry *ce, const char *format, ...)
{
	zval object, msg;
	int ZEPHIR_LAST_CALL_STATUS = 0, len;
	char *buffer;
	va_list args;

	object_init_ex(&object, ce);

	va_start(args, format);
	len = vspprintf(&buffer, 0, format, args);
	va_end(args);

	ZVAL_STRINGL(&msg, buffer, len);
	efree(buffer);

	ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, &object, "__construct", NULL, 0, &msg);

	if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
		zend_throw_exception_object(&object);
	}

	zval_ptr_dtor(&msg);
}



#ifdef HAVE_CONFIG_H
#endif


#ifndef ZEPHIR_RELEASE

static void zephir_vdump(zval *var, const char *func)
{
    if (Z_TYPE_P(var) > IS_CALLABLE) {
        fprintf(stderr, "%s: (%p) has invalid type %u\n", func, var, Z_TYPE_P(var));
    }

    if (!Z_REFCOUNTED_P(var)) {
    	fprintf(stderr, "%s: (%p) is not reference-counted, type=%d\n", func, var, Z_TYPE_P(var));
        return;
    }

    if (Z_REFCOUNT_P(var) == 0) {
        fprintf(stderr, "%s: (%p) has 0 references, type=%d\n", func, var, Z_TYPE_P(var));
    } else {
        if (Z_REFCOUNT_P(var) >= 1000000) {
            fprintf(stderr, "%s: (%p) has too many references (%u), type=%d\n", func, var, Z_REFCOUNT_P(var), Z_TYPE_P(var));
        }
    }
}

#endif



#ifndef ZEPHIR_RELEASE
#if defined(linux) && !defined(ALPINE_LINUX) || defined(DARWIN) || defined(__APPLE__)


void *backtrace_buf[4096];

static void zephir_print_backtrace(void)
{
	int i;
	int stack_size       = backtrace(backtrace_buf, sizeof(backtrace_buf) / sizeof(void*));
	char **stack_symbols = backtrace_symbols(backtrace_buf, stack_size);
	char buf[50];
	smart_str s = {0};

	for (i = 0; i < stack_size; ++i) {
		snprintf(buf, sizeof(buf), "#%d  %p [", i, backtrace_buf[i]);
		smart_str_appends(&s, buf);
		smart_str_appends(&s, stack_symbols[i]);
		smart_str_appends(&s, "]\n");
	}

	smart_str_0(&s);

	fprintf(stderr, "%s\n", ZSTR_VAL(s.s));
	smart_str_free(&s);
}

#else

static void zephir_print_backtrace(void)
{
}

#endif
#endif /* ZEPHIR_RELEASE */



#ifdef HAVE_CONFIG_H
#endif




static int zephir_instance_of_ev(zval *object, const zend_class_entry *ce)
{
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;
	if (Z_TYPE_P(z) != IS_OBJECT) {
		php_error_docref(NULL, E_WARNING, "instanceof expects an object instance");
		return 0;
	}

	return instanceof_function(Z_OBJCE_P(z), ce);
}

static int zephir_is_instance_of(zval *object, const char *class_name, unsigned int class_length)
{
	zend_class_entry *ce, *temp_ce;
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;

	if (Z_TYPE_P(z) == IS_OBJECT) {

		ce = Z_OBJCE_P(z);
		if (ZSTR_LEN(ce->name) == class_length) {
			if (!zend_binary_strcasecmp(ZSTR_VAL(ce->name), ZSTR_LEN(ce->name), class_name, class_length)) {
				return 1;
			}
		}

		temp_ce = zephir_fetch_class_str_ex(class_name, class_length, ZEND_FETCH_CLASS_DEFAULT);
		if (temp_ce) {
			return instanceof_function(ce, temp_ce);
		}
	}

	return 0;
}

static int zephir_zval_is_traversable(zval *object)
{
	zend_class_entry *ce;
	uint32_t i;
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;

	if (Z_TYPE_P(z) == IS_OBJECT) {
		ce = Z_OBJCE_P(z);

		if (ce->get_iterator || (ce->parent && ce->parent->get_iterator)) {
			return 1;
		}

		for (i = 0; i < ce->num_interfaces; i++) {
			if (ce->interfaces[i] == zend_ce_aggregate ||
				ce->interfaces[i] == zend_ce_iterator ||
				ce->interfaces[i] == zend_ce_traversable
			) {
				return 1;
			}
		}
	}

	return 0;
}

static void zephir_get_called_class(zval *return_value)
{
	zend_class_entry *called_scope = zend_get_called_scope(EG(current_execute_data));
	if (called_scope) {
		ZVAL_STR(return_value, zend_string_dup(called_scope->name, 0));
	}

	if (!zend_get_executed_scope())  {
		php_error_docref(NULL, E_WARNING, "zephir_get_called_class() called from outside a class");
	}
}

zend_class_entry *zephir_fetch_class_str_ex(const char *class_name, size_t length, int fetch_type)
{
	zend_class_entry *retval;
	zend_string *str = zend_string_init(class_name, length, 0);
	retval = zend_fetch_class(str, fetch_type);
	zend_string_release(str);
	return retval;
}

zend_class_entry *zephir_fetch_class(zval *class_name)
{
	zval *z = Z_ISREF_P(class_name) ? Z_REFVAL_P(class_name) : class_name;
	if (Z_TYPE_P(z) == IS_STRING) {
		return zend_fetch_class(Z_STR_P(z), ZEND_FETCH_CLASS_DEFAULT);
	}

	php_error_docref(NULL, E_WARNING, "class name must be a string");
	return zend_standard_class_def;
}

static void zephir_get_class(zval *result, zval *object, int lower)
{
	zend_class_entry *ce;
	zend_string *class_name;
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;

	if (Z_TYPE_P(z) == IS_OBJECT) {
		ce = Z_OBJCE_P(z);
		//zval_ptr_dtor(result);
		class_name = zend_string_init(ZSTR_VAL(ce->name), ZSTR_LEN(ce->name), 0);
		ZVAL_STR(result, class_name);

		if (lower) {
			zend_str_tolower(Z_STRVAL_P(result), Z_STRLEN_P(result));
		}

	} else {
		ZVAL_NULL(result);
		php_error_docref(NULL, E_WARNING, "zephir_get_class expects an object");
	}
}

static void zephir_get_class_ns(zval *result, zval *object, int lower)
{
	int found = 0;
	unsigned int i, class_length;
	char *cursor, *class_name;
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;

	if (Z_TYPE_P(z) != IS_OBJECT) {
		if (Z_TYPE_P(z) != IS_STRING) {
			ZVAL_NULL(result);
			php_error_docref(NULL, E_WARNING, "zephir_get_class_ns expects an object");
			return;
		}

		class_name   = Z_STRVAL_P(z);
		class_length = Z_STRLEN_P(z);
	}
	else {
		zend_class_entry *ce = Z_OBJCE_P(z);
		class_name   = ZSTR_VAL(ce->name);
		class_length = ZSTR_LEN(ce->name);
	}

	if (!class_length) {
		ZVAL_NULL(result);
		return;
	}

	i = class_length;
	cursor = (char *) (class_name + class_length - 1);

	while (i > 0) {
		if ((*cursor) == '\\') {
			found = 1;
			break;
		}
		cursor--;
		i--;
	}

	if (found) {
		int cursor_length = class_length - i;
		cursor = (char *) emalloc(cursor_length + 1);
		memcpy(cursor, class_name + i, cursor_length);
		cursor[cursor_length] = 0;
		ZVAL_STRING(result, cursor);
		efree(cursor);
	} else {
		ZVAL_STRINGL(result, class_name, class_length);
	}

	if (lower) {
		zend_str_tolower(Z_STRVAL_P(result), Z_STRLEN_P(result));
	}
}

static void zephir_get_ns_class(zval *result, zval *object, int lower)
{
	int found = 0;
	unsigned int i, j, class_length;
	char *cursor, *class_name;
	zval *z = Z_ISREF_P(object) ? Z_REFVAL_P(object) : object;

	ZVAL_NULL(result);

	if (Z_TYPE_P(z) != IS_OBJECT) {
		if (Z_TYPE_P(z) != IS_STRING) {
			php_error_docref(NULL, E_WARNING, "zephir_get_ns_class expects an object");
			return;
		}

		class_name   = Z_STRVAL_P(z);
		class_length = Z_STRLEN_P(z);
	}
	else {
		zend_class_entry *ce = Z_OBJCE_P(z);
		class_name   = ZSTR_VAL(ce->name);
		class_length = ZSTR_LEN(ce->name);
	}

	if (!class_length) {
		return;
	}

	j = 0;
	i = class_length;
	cursor = (char *) (class_name + class_length - 1);

	while (i > 0) {
		if ((*cursor) == '\\') {
			found = 1;
			break;
		}
		cursor--;
		i--;
		j++;
	}

	if (j > 0) {

		if (found) {
			int cursor_length = class_length - j - 1;
			cursor = (char *) emalloc(cursor_length + 1);
			memcpy(cursor, class_name, cursor_length);
			cursor[cursor_length] = 0;
			ZVAL_STRING(result, cursor);
			efree(cursor);
		} else {
			ZVAL_EMPTY_STRING(result);
		}

		if (lower) {
			zend_str_tolower(Z_STRVAL_P(result), Z_STRLEN_P(result));
		}
	}
}

static int zephir_class_exists(zval *class_name, int autoload)
{
	zend_class_entry *ce;
	zval *z = Z_ISREF_P(class_name) ? Z_REFVAL_P(class_name) : class_name;

	if (Z_TYPE_P(z) == IS_STRING) {
		if ((ce = zend_lookup_class_ex(Z_STR_P(z), NULL, autoload)) != NULL) {
			return (ce->ce_flags & (ZEND_ACC_INTERFACE | (ZEND_ACC_INTERFACE | ZEND_ACC_TRAIT))) == 0;
		}
		return 0;
	}

	php_error_docref(NULL, E_WARNING, "class name must be a string");
	return 0;
}

static int zephir_interface_exists(zval *class_name, int autoload)
{
	zend_class_entry *ce;
	zval *z = Z_ISREF_P(class_name) ? Z_REFVAL_P(class_name) : class_name;

	if (Z_TYPE_P(z) == IS_STRING) {
		if ((ce = zend_lookup_class(Z_STR_P(z))) != NULL) {
			return ((ce->ce_flags & ZEND_ACC_INTERFACE) > 0);
		}
		return 0;
	}

	php_error_docref(NULL, E_WARNING, "interface name must be a string");
	return 0;
}

static int zephir_clone(zval *destination, zval *obj)
{
	int status = SUCCESS;
	zend_class_entry *ce;
	zend_object_clone_obj_t clone_call;

	if (Z_TYPE_P(obj) != IS_OBJECT) {
		php_error_docref(NULL, E_ERROR, "__clone method called on non-object");
		status = FAILURE;
	} else {
		ce = Z_OBJCE_P(obj);
		clone_call =  Z_OBJ_HT_P(obj)->clone_obj;
		if (!clone_call) {
			if (ce) {
				php_error_docref(NULL, E_ERROR, "Trying to clone an uncloneable object of class %s", ZSTR_VAL(ce->name));
			} else {
				php_error_docref(NULL, E_ERROR, "Trying to clone an uncloneable object");
			}
			status = FAILURE;
		} else {
			if (!EG(exception)) {
				ZVAL_OBJ(destination, clone_call(Z_OBJ_P(obj)));
				if (EG(exception)) {
					zval_ptr_dtor(destination);
				}
			}
		}
	}

	return status;
}

static int zephir_isset_property(zval *object, const char *property_name, unsigned int property_length)
{
	if (Z_TYPE_P(object) == IS_OBJECT) {
		if (EXPECTED(zend_hash_str_exists(&Z_OBJCE_P(object)->properties_info, property_name, property_length))) {
			return 1;
		}

		return zend_hash_str_exists(
			Z_OBJ_HT_P(object)->get_properties(Z_OBJ_P(object)),
			property_name,
			property_length
		);
	}

	return 0;
}

static int zephir_isset_property_zval(zval *object, const zval *property)
{
	if (Z_TYPE_P(object) == IS_OBJECT) {
		if (Z_TYPE_P(property) == IS_STRING) {
			if (EXPECTED(zend_hash_str_exists(&Z_OBJCE_P(object)->properties_info, Z_STRVAL_P(property), Z_STRLEN_P(property)))) {
				return 1;
			} else {
				return zend_hash_str_exists(
					Z_OBJ_HT_P(object)->get_properties(Z_OBJ_P(object)),
					Z_STRVAL_P(property),
					Z_STRLEN_P(property)
				);
			}
		}
	}

	return 0;
}

static inline zend_class_entry *zephir_lookup_class_ce(
	zend_class_entry *ce,
	const char *property_name,
	unsigned int property_length
) {
	zend_class_entry *original_ce = ce;
	zend_property_info *info;
	zend_class_entry *scope;
	zval member;

	ZVAL_STRINGL(&member, property_name, property_length);

	/* Backup current scope */
	scope = zephir_get_scope(0);

	while (ce) {
		/* Use the scope of the current object */
		zephir_set_scope(ce);

		info = zend_get_property_info(ce, Z_STR(member), 1);
		if (info && info != ZEND_WRONG_PROPERTY_INFO) {
			zval_ptr_dtor(&member);
			/* Restore original scope */
			zephir_set_scope(scope);

			return ce;
		}

		ce = ce->parent;
	}

	zval_ptr_dtor(&member);

	/* Restore original scope */
	zephir_set_scope(scope);

	return original_ce;
}

static int zephir_read_property_ex(
	zval *result,
	zval *object,
	const char *property_name,
	uint32_t property_length, int flags
) {
	zend_class_entry *scope;
	int retval;

	if (Z_TYPE_P(object) == IS_OBJECT) {
		zend_class_entry *ce;

		/* Backup current scope */
		scope = zephir_get_scope(0);
		ce = Z_OBJCE_P(object);

		/* Lookup for the real owner of the property */
		if (ce->parent) {
			ce = zephir_lookup_class_ce(ce, property_name, property_length);
		}

		/* Use the scope of the found object */
		zephir_set_scope(ce);
	}
	/* Read the property */
	retval = zephir_read_property(result, object, property_name, property_length, flags);

	if (Z_TYPE_P(object) == IS_OBJECT) {
		/* Restore original scope */
		zephir_set_scope(scope);
	}

	return retval;
}

static int zephir_read_property(
	zval *result,
	zval *object,
	const char *property_name,
	uint32_t property_length,
	int flags
) {
	zval property, tmp;
	zval *res;

	ZVAL_UNDEF(&tmp);

	if (Z_TYPE_P(object) != IS_OBJECT) {
		if ((flags & PH_NOISY) == PH_NOISY) {
			php_error_docref(NULL, E_NOTICE, "Trying to get property '%s' of non-object", property_name);
		}

		ZVAL_NULL(result);
		return FAILURE;
	}

	if (!Z_OBJ_HT_P(object)->read_property) {
		zend_error(E_CORE_ERROR, "Property %s of class %s cannot be read", property_name, ZSTR_VAL(Z_OBJCE_P(object)->name));
	}

	ZVAL_STRINGL(&property, property_name, property_length);
	res = Z_OBJ_HT_P(object)->read_property(Z_OBJ_P(object), Z_STR(property),
											flags ? BP_VAR_IS : BP_VAR_R,
											NULL, &tmp);

	if ((flags & PH_READONLY) == PH_READONLY) {
		ZVAL_COPY_VALUE(result, res);
	} else {
		ZVAL_COPY(result, res);
	}

	zval_ptr_dtor(&property);

	return SUCCESS;
}

static int zephir_fetch_property(zval *result, zval *object, const char *property_name, uint32_t property_length, int silent)
{
	if (zephir_isset_property(object, property_name, property_length)) {
		zephir_read_property(result, object, property_name, property_length, 0);
		return 1;
	}

	ZVAL_NULL(result);
	return 0;
}

static int zephir_fetch_property_zval(zval *result, zval *object, zval *property, int silent)
{
	if (UNEXPECTED(Z_TYPE_P(property) != IS_STRING)) {
		ZVAL_NULL(result);
		return 0;
	}

	if (zephir_isset_property(object, Z_STRVAL_P(property), Z_STRLEN_P(property))) {
		zephir_read_property(result, object, Z_STRVAL_P(property), Z_STRLEN_P(property), 0);
		return 1;
	}

	ZVAL_NULL(result);
	return 0;
}

static int zephir_return_property(zval *return_value, zval *object, char *property_name, unsigned int property_length)
{
	ZVAL_NULL(return_value);
	return zephir_read_property(return_value, object, property_name, property_length, 0);
}

static int zephir_read_property_zval(zval *result, zval *object, zval *property, int flags)
{
	if (UNEXPECTED(Z_TYPE_P(property) != IS_STRING)) {
		if ((flags & PH_NOISY) == PH_NOISY) {
			php_error_docref(NULL, E_NOTICE, "Cannot access empty property %d", Z_TYPE_P(property));
		}

		ZVAL_NULL(result);
		return FAILURE;
	}

	return zephir_read_property(result, object, Z_STRVAL_P(property), Z_STRLEN_P(property), flags);
}

static int zephir_update_property_zval_ex(
	zval *object,
	const char *property_name,
	unsigned int property_length,
	zval *value
) {
	zend_class_entry *scope;
	int retval;

	if (Z_TYPE_P(object) == IS_OBJECT) {
		zend_class_entry *ce;

		/* Backup current scope */
		scope = zephir_get_scope(0);
		ce = Z_OBJCE_P(object);

		/* Lookup for the real owner of the property */
		if (ce->parent) {
			ce = zephir_lookup_class_ce(ce, property_name, property_length);
		}

		/* Use the scope of the found object */
		zephir_set_scope(ce);
	}
	/* Update the property */
	retval = zephir_update_property_zval(object, property_name, property_length, value);

	if (Z_TYPE_P(object) == IS_OBJECT) {
		/* Restore original scope */
		zephir_set_scope(scope);
	}

	return retval;
}

static int zephir_update_property_zval(
	zval *object,
	const char *property_name,
	unsigned int property_length,
	zval *value
) {
	zval property, sep_value;

	if (Z_TYPE_P(object) != IS_OBJECT) {
		php_error_docref(NULL, E_WARNING, "Attempt to assign property '%s' of non-object", property_name);
		return FAILURE;
	}

	if (!Z_OBJ_HT_P(object)->write_property) {
		zend_error(E_CORE_ERROR, "Property %s of class %s cannot be updated", property_name, ZSTR_VAL(Z_OBJCE_P(object)->name));
	}

	ZVAL_STRINGL(&property, property_name, property_length);
	ZVAL_COPY_VALUE(&sep_value, value);
	if (Z_TYPE(sep_value) == IS_ARRAY) {
		ZVAL_ARR(&sep_value, zend_array_dup(Z_ARR(sep_value)));
		if (EXPECTED(!(GC_FLAGS(Z_ARRVAL(sep_value)) & IS_ARRAY_IMMUTABLE))) {
			if (UNEXPECTED(GC_REFCOUNT(Z_ARR(sep_value)) > 0)) {
				GC_DELREF(Z_ARR(sep_value));
			}
		}
	}

	/* write_property will add 1 to refcount,
	   so no Z_TRY_ADDREF_P(value) is necessary */
	Z_OBJ_HT_P(object)->write_property(Z_OBJ_P(object), Z_STR(property), &sep_value, 0);

	zval_ptr_dtor(&property);

	if (UNEXPECTED(EG(exception))) {
		return FAILURE;
	}

	return SUCCESS;
}

static int zephir_update_property_zval_zval(zval *object, zval *property, zval *value)
{
	if (Z_TYPE_P(property) != IS_STRING) {
		php_error_docref(NULL, E_WARNING, "Property should be string");
		return FAILURE;
	}

	return zephir_update_property_zval(object, Z_STRVAL_P(property), Z_STRLEN_P(property), value);
}

static int zephir_update_property_array(zval *object, const char *property, uint32_t property_length, const zval *index, zval *value)
{
	zval tmp, sep_value;
	int separated = 0;

	if (Z_TYPE_P(object) != IS_OBJECT) {
		return SUCCESS;
	}

	zephir_read_property(&tmp, object, property, property_length, PH_NOISY | PH_READONLY);

	/** Separation only when refcount > 1 */
	if (Z_REFCOUNTED(tmp)) {
		if (Z_REFCOUNT(tmp) > 1) {
			if (!Z_ISREF(tmp)) {
				zval new_zv;
				ZVAL_DUP(&new_zv, &tmp);
				ZVAL_COPY_VALUE(&tmp, &new_zv);
				Z_TRY_DELREF(new_zv);
				Z_ADDREF(tmp);
				separated = 1;
			}
		}
	} else {
		zval new_zv;
		ZVAL_DUP(&new_zv, &tmp);
		ZVAL_COPY_VALUE(&tmp, &new_zv);
		Z_TRY_DELREF(new_zv);
		separated = 1;
	}

	/** Convert the value to array if not is an array */
	if (Z_TYPE(tmp) != IS_ARRAY) {
		if (separated) {
			convert_to_array(&tmp);
		} else {
			array_init(&tmp);
			separated = 1;
		}

		if (Z_REFCOUNTED(tmp)) {
			if (Z_REFCOUNT(tmp) > 1) {
				if (!Z_ISREF(tmp)) {
					Z_DELREF(tmp);
				}
			}
		}
	}

	if (Z_TYPE_P(value) == IS_ARRAY) {
		ZVAL_ARR(&sep_value, zend_array_dup(Z_ARR_P(value)));
	} else {
		ZVAL_COPY(&sep_value, value);
	}

	if (Z_TYPE_P(index) == IS_STRING) {
		zend_symtable_str_update(Z_ARRVAL(tmp), Z_STRVAL_P(index), Z_STRLEN_P(index), &sep_value);
	} else if (Z_TYPE_P(index) == IS_LONG) {
		zend_hash_index_update(Z_ARRVAL(tmp), Z_LVAL_P(index), &sep_value);
	} else if (Z_TYPE_P(index) == IS_NULL) {
		zend_hash_next_index_insert(Z_ARRVAL(tmp), &sep_value);
	}

	if (separated) {
		zephir_update_property_zval(object, property, property_length, &tmp);
		zval_ptr_dtor(&tmp);
	}

	return SUCCESS;
}

static int zephir_update_property_array_append(zval *object, char *property, unsigned int property_length, zval *value)
{
	zval tmp, sep_value;
	int separated = 0;

	ZVAL_UNDEF(&tmp);

	if (Z_TYPE_P(object) != IS_OBJECT) {
		return SUCCESS;
	}

	zephir_read_property(&tmp, object, property, property_length, PH_NOISY | PH_READONLY);

	/** Separation only when refcount > 1 */
	if (Z_REFCOUNTED(tmp)) {
		if (Z_REFCOUNT(tmp) > 1) {
			if (!Z_ISREF(tmp)) {
				zval new_zv;
				ZVAL_DUP(&new_zv, &tmp);
				ZVAL_COPY_VALUE(&tmp, &new_zv);
				if (Z_REFCOUNT(tmp) > 1) {
				    Z_TRY_DELREF(new_zv);
				}
				separated = 1;
			}
		}
	} else {
		zval new_zv;
		ZVAL_DUP(&new_zv, &tmp);
		ZVAL_COPY_VALUE(&tmp, &new_zv);
		Z_TRY_DELREF(new_zv);
		separated = 1;

		if (Z_REFCOUNTED(tmp)) {
			if (EXPECTED(Z_REFCOUNT(tmp) == 0)) {
				Z_ADDREF(tmp);
			}
		}
	}

	/** Convert the value to array if not is an array */
	if (Z_TYPE(tmp) != IS_ARRAY) {
		if (separated) {
			convert_to_array(&tmp);
		} else {
			array_init(&tmp);
			separated = 1;
		}

		if (Z_REFCOUNTED(tmp)) {
			if (Z_REFCOUNT(tmp) > 1) {
				if (!Z_ISREF(tmp)) {
					Z_DELREF(tmp);
				}
			}
		}
	}

	if (Z_TYPE_P(value) == IS_ARRAY) {
		ZVAL_ARR(&sep_value, zend_array_dup(Z_ARR_P(value)));
	} else {
		ZVAL_COPY(&sep_value, value);
	}

	add_next_index_zval(&tmp, &sep_value);

	if (separated) {
		zephir_update_property_zval(object, property, property_length, &tmp);
		zval_ptr_dtor(&tmp);
	}

	return SUCCESS;
}

static int zephir_update_property_array_multi(zval *object, const char *property, uint32_t property_length, zval *value, const char *types, int types_length, int types_count, ...)
{
	va_list ap;
	zval tmp_arr;
	int separated = 0;

	if (Z_TYPE_P(object) == IS_OBJECT) {
		zephir_read_property(&tmp_arr, object, property, property_length, PH_NOISY | PH_READONLY);

		/** Separation only when refcount > 1 */
		if (Z_REFCOUNTED(tmp_arr)) {
			if (Z_REFCOUNT(tmp_arr) > 1) {
				if (!Z_ISREF(tmp_arr)) {
					zval new_zv;
					ZVAL_DUP(&new_zv, &tmp_arr);
					ZVAL_COPY_VALUE(&tmp_arr, &new_zv);
					Z_TRY_DELREF(new_zv);
					Z_ADDREF(tmp_arr);
					separated = 1;
				}
			}
		} else {
			zval new_zv;
			ZVAL_DUP(&new_zv, &tmp_arr);
			ZVAL_COPY_VALUE(&tmp_arr, &new_zv);
			Z_TRY_DELREF(new_zv);
			separated = 1;
		}

		/** Convert the value to array if not is an array */
		if (Z_TYPE(tmp_arr) != IS_ARRAY) {
			if (separated) {
				convert_to_array(&tmp_arr);
			} else {
				array_init(&tmp_arr);
				separated = 1;
			}

			if (Z_REFCOUNTED(tmp_arr)) {
				if (Z_REFCOUNT(tmp_arr) > 1) {
					if (!Z_ISREF(tmp_arr)) {
						Z_DELREF(tmp_arr);
					}
				}
			}
		}

		va_start(ap, types_count);
		zephir_array_update_multi_ex(&tmp_arr, value, types, types_length, types_count, ap);
		va_end(ap);

		if (separated) {
			zephir_update_property_zval(object, property, property_length, &tmp_arr);
			zval_ptr_dtor(&tmp_arr);
		}
	}

	return SUCCESS;
}

static int zephir_unset_property(zval* object, const char* name)
{
	if (Z_TYPE_P(object) != IS_OBJECT) {
		return FAILURE;
	}

	zval member;
	zend_class_entry *scope;

	ZVAL_STRING(&member, name);

	/* Backup current scope */
	scope = zephir_get_scope(0);

	/* Use caller's scope */
	zephir_set_scope(Z_OBJCE_P(object));
	Z_OBJ_HT_P(object)->unset_property(Z_OBJ_P(object), Z_STR(member), 0);
	/* Restore original scope */
	zephir_set_scope(scope);

	return SUCCESS;
}

static int zephir_unset_property_array(zval *object, char *property, unsigned int property_length, zval *index)
{
	zval tmp;
	int separated = 0;

	if (Z_TYPE_P(object) == IS_OBJECT) {
		zephir_read_property(&tmp, object, property, property_length, PH_NOISY_CC);
		Z_TRY_DELREF(tmp);

		/** Separation only when refcount > 1 */
		if (Z_REFCOUNTED(tmp)) {
			if (Z_REFCOUNT(tmp) > 1) {
				if (!Z_ISREF(tmp)) {
					zval new_zv;
					ZVAL_DUP(&new_zv, &tmp);
					ZVAL_COPY_VALUE(&tmp, &new_zv);
					Z_TRY_DELREF(new_zv);
					separated = 1;
				}
			}
		} else {
			zval new_zv;
			ZVAL_DUP(&new_zv, &tmp);
			ZVAL_COPY_VALUE(&tmp, &new_zv);
			Z_TRY_DELREF(new_zv);
			separated = 1;
		}

		zephir_array_unset(&tmp, index, PH_SEPARATE);

		if (separated) {
			zephir_update_property_zval(object, property, property_length, &tmp);
		}
	}

	return SUCCESS;
}

static int zephir_method_exists_ex(zval *object, const char *method_name, unsigned int method_len)
{
	zend_class_entry *ce;
	union _zend_function *func = NULL;
	zend_string *method;

	if (EXPECTED(Z_TYPE_P(object) == IS_OBJECT)) {
		ce = Z_OBJCE_P(object);
	} else if (Z_TYPE_P(object) == IS_STRING) {
		ce = zend_fetch_class(Z_STR_P(object), ZEND_FETCH_CLASS_DEFAULT);
	} else {
		return FAILURE;
	}

	if (zend_hash_str_exists(&ce->function_table, method_name, method_len)) {
		return SUCCESS;
	}

	method = zend_string_init(method_name, method_len, 0);
	if (
		   Z_TYPE_P(object) == IS_OBJECT
		&& Z_OBJ_HT_P(object)->get_method
		&& (func = Z_OBJ_HT_P(object)->get_method(&Z_OBJ_P(object), method, NULL))
	) {
		if (func->common.fn_flags & ZEND_ACC_CALL_VIA_TRAMPOLINE) {
			int status = (func->common.scope == zend_ce_closure && zend_string_equals_literal(method, ZEND_INVOKE_FUNC_NAME));

			zend_string_release(method);
			zend_string_release(func->common.function_name);
			zend_free_trampoline(func);
			return status ? SUCCESS : FAILURE;
		}

		zend_string_release(method);
		return SUCCESS;
	}

	zend_string_release(method);
	return FAILURE;
}

static int zephir_method_exists(zval *object, const zval *method_name)
{
	if (Z_TYPE_P(method_name) != IS_STRING) {
		zend_error(E_WARNING, "method_exists expected a string");
		return 0;
	}

	char *lcname = zend_str_tolower_dup(Z_STRVAL_P(method_name), Z_STRLEN_P(method_name));
	int res = zephir_method_exists_ex(object, lcname, Z_STRLEN_P(method_name));
	efree(lcname);

	return res;
}

static int zephir_read_static_property_ce(zval *result, zend_class_entry *ce, const char *property, int len, int flags)
{
	zval *tmp = zend_read_static_property(ce, property, len, (zend_bool) ZEND_FETCH_CLASS_SILENT);

	ZVAL_NULL(result);
	if (tmp) {
		if ((flags & PH_READONLY) == PH_READONLY) {
			ZVAL_COPY_VALUE(result, tmp);
		} else {
			ZVAL_COPY(result, tmp);
		}

		return SUCCESS;
	}

	return FAILURE;
}

static int zephir_update_static_property_ce(zend_class_entry *ce, const char *property_name, uint32_t property_length, zval *value)
{
	return zend_update_static_property(ce, property_name, property_length, value);
}

static int zephir_add_static_property_ce(zend_class_entry *ce, const char *property_name, uint32_t property_length, zval *value)
{
	zval tmp_value, new_value;
	zephir_read_static_property_ce(&tmp_value, ce, property_name, property_length, PH_NOISY | PH_READONLY);
	zephir_add_function(&new_value, &tmp_value, value);
	return zend_update_static_property(ce, property_name, property_length, &new_value);
}

static int zephir_sub_static_property_ce(zend_class_entry *ce, const char *property_name, uint32_t property_length, zval *value)
{
	zval tmp_value, new_value;
	zephir_read_static_property_ce(&tmp_value, ce, property_name, property_length, PH_NOISY | PH_READONLY);
	zephir_sub_function(&new_value, &tmp_value, value);
	return zend_update_static_property(ce, property_name, property_length, &new_value);
}

static int zephir_update_static_property_array_multi_ce(
	zend_class_entry *ce,
	const char *property,
	uint32_t property_length,
	zval *value,
	const char *types,
	int types_length,
	int types_count,
	...
) {
	va_list ap;
	zval tmp_arr;
	int separated = 0;

	ZVAL_UNDEF(&tmp_arr);

	zephir_read_static_property_ce(&tmp_arr, ce, property, property_length, PH_NOISY | PH_READONLY);

	/** Separation only when refcount > 1 */
	if (Z_REFCOUNTED(tmp_arr)) {
		if (Z_REFCOUNT(tmp_arr) > 1) {
			if (!Z_ISREF(tmp_arr)) {
				zval new_zv;
				ZVAL_DUP(&new_zv, &tmp_arr);
				ZVAL_COPY_VALUE(&tmp_arr, &new_zv);
				Z_TRY_DELREF(new_zv);
				Z_ADDREF(tmp_arr);
				separated = 1;
			}
		}
	} else {
		zval new_zv;
		ZVAL_DUP(&new_zv, &tmp_arr);
		ZVAL_COPY_VALUE(&tmp_arr, &new_zv);
		Z_TRY_DELREF(new_zv);
		separated = 1;
	}

	/** Convert the value to array if not is an array */
	if (Z_TYPE(tmp_arr) != IS_ARRAY) {
		if (separated) {
			convert_to_array(&tmp_arr);
		} else {
			array_init(&tmp_arr);
			separated = 1;
		}

		if (Z_REFCOUNTED(tmp_arr)) {
			if (Z_REFCOUNT(tmp_arr) > 1) {
				if (!Z_ISREF(tmp_arr)) {
					Z_DELREF(tmp_arr);
				}
			}
		}
	}

	va_start(ap, types_count);
	SEPARATE_ZVAL_NOREF(&tmp_arr);
	zephir_array_update_multi_ex(&tmp_arr, value, types, types_length, types_count, ap);
	va_end(ap);

	if (separated) {
		zend_update_static_property(ce, property, property_length, &tmp_arr);
	}

	if (Z_REFCOUNTED(tmp_arr)) {
		if (Z_REFCOUNT(tmp_arr) > 1) {
			if (!Z_ISREF(tmp_arr)) {
				Z_DELREF(tmp_arr);
			}
		}
	}

	return SUCCESS;
}

static int zephir_property_incr_decr(zval *object, char *property_name, unsigned int property_length, unsigned int increment)
{
	zval tmp;
	zend_class_entry *ce;
	int separated = 0;

	ZVAL_UNDEF(&tmp);

	if (Z_TYPE_P(object) != IS_OBJECT) {
		php_error_docref(NULL, E_WARNING, "Attempt to assign property of non-object");
		return FAILURE;
	}

	ce = Z_OBJCE_P(object);
	if (ce->parent) {
		ce = zephir_lookup_class_ce(ce, property_name, property_length);
	}

	zephir_read_property(&tmp, object, property_name, property_length, 0);
	if (Z_TYPE(tmp) > IS_UNDEF) {
		Z_TRY_DELREF(tmp);

		/** Separation only when refcount > 1 */
		if (Z_REFCOUNTED(tmp)) {
			if (Z_REFCOUNT(tmp) > 1) {
				if (!Z_ISREF(tmp)) {
					zval new_zv;
					ZVAL_DUP(&new_zv, &tmp);
					ZVAL_COPY_VALUE(&tmp, &new_zv);
					Z_TRY_DELREF(new_zv);
					separated = 1;
				}
			}
		} else {
			zval new_zv;
			ZVAL_DUP(&new_zv, &tmp);
			ZVAL_COPY_VALUE(&tmp, &new_zv);
			Z_TRY_DELREF(new_zv);
			separated = 1;
		}

		if (increment) {
			zephir_increment(&tmp);
		} else {
			zephir_decrement(&tmp);
		}

		if (separated) {
			zephir_update_property_zval(object, property_name, property_length, &tmp);
		}
	}

	return SUCCESS;
}

/* Imported since PHP is so nice to define this in a .c file... */
typedef struct _zend_closure {
	zend_object       std;
	zend_function     func;
	zval              this_ptr;
	zend_class_entry *called_scope;
	zif_handler       orig_internal_handler;
} zend_closure;

static int zephir_create_closure_ex(zval *return_value, zval *this_ptr, zend_class_entry *ce, const char *method_name, uint32_t method_length)
{
	zend_function *function_ptr;
	zend_closure *closure;

	if ((function_ptr = zend_hash_str_find_ptr(&ce->function_table, method_name, method_length)) == NULL) {
		ZVAL_NULL(return_value);
		return FAILURE;
	}

	zend_create_closure(return_value, function_ptr, ce, ce, this_ptr);
	// Make sure we can use a closure multiple times
	closure = (zend_closure*)Z_OBJ_P(return_value);
	closure->func.internal_function.handler = closure->orig_internal_handler;
	return SUCCESS;
}

static int zephir_create_instance(zval *return_value, const zval *class_name)
{
	zend_class_entry *ce;

	if (Z_TYPE_P(class_name) != IS_STRING) {
		zephir_throw_exception_string(spl_ce_RuntimeException, SL("Invalid class name"));
		return FAILURE;
	}

	ce = zend_fetch_class(Z_STR_P(class_name), ZEND_FETCH_CLASS_DEFAULT);
	if (!ce) {
		ZVAL_NULL(return_value);
		return FAILURE;
	}

	if(UNEXPECTED(object_init_ex(return_value, ce) != SUCCESS)) {
    	return FAILURE;
    }

	if (EXPECTED(Z_OBJ_HT_P(return_value)->get_constructor)) {
		zend_object* obj    = Z_OBJ_P(return_value);
		zend_function* ctor = Z_OBJ_HT_P(return_value)->get_constructor(obj);
		if (ctor) {
			zend_fcall_info fci;
			zend_fcall_info_cache fcc;

			zend_class_entry* ce = Z_OBJCE_P(return_value);

			fci.size             = sizeof(fci);
			fci.object           = obj;
			fci.retval           = 0;
			fci.param_count      = 0;
			fci.params           = 0;
			fci.named_params 	 = NULL;

			ZVAL_NULL(&fci.function_name);

			fcc.object           = obj;
			fcc.called_scope     = ce;
			fcc.calling_scope    = ce;
			fcc.function_handler = ctor;

			return zend_fcall_info_call(&fci, &fcc, NULL, NULL);
		}
	}

	return SUCCESS;
}

static int zephir_create_instance_params(zval *return_value, const zval *class_name, zval *params)
{
	zend_class_entry *ce;

	if (Z_TYPE_P(class_name) != IS_STRING) {
		zephir_throw_exception_string(spl_ce_RuntimeException, SL("Invalid class name"));
		return FAILURE;
	}

	if (Z_TYPE_P(params) != IS_ARRAY) {
		zephir_throw_exception_string(spl_ce_RuntimeException, SL("Instantiation parameters must be an array"));
		return FAILURE;
	}

	ce = zend_fetch_class(Z_STR_P(class_name), ZEND_FETCH_CLASS_AUTO);
	if (!ce) {
		ZVAL_NULL(return_value);
		return FAILURE;
	}

	if(UNEXPECTED(object_init_ex(return_value, ce) != SUCCESS)) {
    	return FAILURE;
    }

	if (EXPECTED(Z_OBJ_HT_P(return_value)->get_constructor)) {
		zend_object* obj    = Z_OBJ_P(return_value);
		zend_function* ctor = Z_OBJ_HT_P(return_value)->get_constructor(obj);
		if (ctor) {
			int status;
			zend_fcall_info fci;
			zend_fcall_info_cache fcc;

			zend_class_entry* ce = Z_OBJCE_P(return_value);

			fci.size             = sizeof(fci);
			fci.object           = obj;
			fci.retval           = 0;
			fci.param_count      = 0;
			fci.params           = 0;
			fci.named_params 	 = NULL;

			ZVAL_NULL(&fci.function_name);

			fcc.object           = obj;
			fcc.called_scope     = ce;
			fcc.calling_scope    = ce;
			fcc.function_handler = ctor;

			zend_fcall_info_args_ex(&fci, fcc.function_handler, params);
			status = zend_fcall_info_call(&fci, &fcc, NULL, NULL);
			zend_fcall_info_args_clear(&fci, 1);
			return status;
		}
	}

	return SUCCESS;
}



#ifdef HAVE_CONFIG_H
#endif



static void ZEPHIR_FASTCALL zephir_create_array(zval *return_value, uint32_t size, int initialize)
{
	uint32_t i;
	zval null_value;
	HashTable *hashTable;
	ZVAL_NULL(&null_value);

	array_init_size(return_value, size);
	hashTable = Z_ARRVAL_P(return_value);
	if (size > 0) {
		zend_hash_real_init(hashTable, 0);
		if (initialize) {
			for (i = 0; i < size; i++) {
				zend_hash_next_index_insert(hashTable, &null_value);
			}
		}
	}
}

void
ZEPHIR_FASTCALL zephir_ensure_array(zval *zv)
{
	if (
		Z_TYPE_P(zv) == IS_ARRAY &&
		zend_hash_num_elements(Z_ARRVAL_P(zv)) == 0 &&
		(!Z_REFCOUNTED_P(zv) || Z_REFCOUNT_P(zv) < 1)
	) {
		zephir_create_array(zv, 0, 0);
	}
}

static int zephir_array_isset_fetch(zval *fetched, const zval *arr, zval *index, int readonly)
{
	HashTable *h;
	zval *result;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist;
		ZVAL_UNDEF(&exist);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, index);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE && zend_is_true(&exist)) {
			ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(fetched, (zval *)arr, "offsetget", NULL, 0, index);
			if (readonly) {
				Z_TRY_DELREF_P(fetched);
			}

			return 1;
		}

		ZVAL_NULL(fetched);

		return 0;
	} else if (UNEXPECTED(Z_TYPE_P(arr) != IS_ARRAY)) {
		ZVAL_NULL(fetched);

		return 0;
	}

	h = Z_ARRVAL_P(arr);
	switch (Z_TYPE_P(index)) {
		case IS_NULL:
			result = zend_hash_str_find(h, SL(""));
			break;

		case IS_DOUBLE:
			result = zend_hash_index_find(h, (zend_ulong)Z_DVAL_P(index));
			break;

		case IS_LONG:
		case IS_RESOURCE:
			result = zend_hash_index_find(h, Z_LVAL_P(index));
			break;

		case IS_TRUE:
		case IS_FALSE:
			result = zend_hash_index_find(h, Z_TYPE_P(index) == IS_TRUE ? 1 : 0);
			break;

		case IS_STRING:
			result = zend_symtable_str_find(h, (Z_STRLEN_P(index) ? Z_STRVAL_P(index) : ""), Z_STRLEN_P(index));
			break;

		default:
			zend_error(E_WARNING, "Illegal offset type %d", Z_TYPE_P(index));
			return 0;
	}

	if (result != NULL) {
		zephir_ensure_array(result);

		if (!readonly) {
			ZVAL_COPY(fetched, result);
		} else {
			ZVAL_COPY_VALUE(fetched, result);
		}

		return 1;
	}

	ZVAL_NULL(fetched);

	return 0;
}

static int zephir_array_isset_string_fetch(zval *fetched, const zval *arr, char *index, uint32_t index_length, int readonly)
{
	zval *zv;
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist, offset;
		ZVAL_UNDEF(&exist);
		ZVAL_STRINGL(&offset, index, index_length);

		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, &offset);
		zval_ptr_dtor(&offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE && zend_is_true(&exist)) {
			ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(fetched, (zval *)arr, "offsetget", NULL, 0, &offset);
			if (readonly) {
				Z_TRY_DELREF_P(fetched);
			}
			return 1;
		}

		ZVAL_NULL(fetched);

		return 0;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		if ((zv = zend_hash_str_find(Z_ARRVAL_P(arr), index, index_length)) != NULL) {
			zephir_ensure_array(zv);

			if (!readonly) {
				ZVAL_COPY(fetched, zv);
			} else {
				ZVAL_COPY_VALUE(fetched, zv);
			}
			return 1;
		}
	}

	ZVAL_NULL(fetched);

	return 0;
}

static int zephir_array_isset_long_fetch(zval *fetched, const zval *arr, unsigned long index, int readonly)
{
	zval *zv;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist, offset;
		ZVAL_UNDEF(&exist);
		ZVAL_LONG(&offset, index);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, &offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE && zend_is_true(&exist)) {
			ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(fetched, (zval *)arr, "offsetget", NULL, 0, &offset);
			if (readonly) {
				Z_TRY_DELREF_P(fetched);
			}

			return 1;
		}

		ZVAL_NULL(fetched);

		return 0;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		if ((zv = zend_hash_index_find(Z_ARRVAL_P(arr), index)) != NULL) {
			zephir_ensure_array(zv);

			if (!readonly) {
				ZVAL_COPY(fetched, zv);
			} else {
				ZVAL_COPY_VALUE(fetched, zv);
			}
			return 1;
		}
	}

	ZVAL_NULL(fetched);

	return 0;
}

static int ZEPHIR_FASTCALL zephir_array_isset(const zval *arr, zval *index)
{
	HashTable *h;

	if (UNEXPECTED(!arr)) {
		return 0;
	}

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist;
		ZVAL_UNDEF(&exist);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, index);
		if (zend_is_true(&exist)) {
			return 1;
		}

		return 0;
	} else if (UNEXPECTED(Z_TYPE_P(arr) != IS_ARRAY)) {
		return 0;
	}

	h = Z_ARRVAL_P(arr);
	switch (Z_TYPE_P(index)) {
		case IS_NULL:
			return zend_hash_str_exists(h, SL(""));

		case IS_DOUBLE:
			return zend_hash_index_exists(h, (zend_ulong)Z_DVAL_P(index));

		case IS_TRUE:
		case IS_FALSE:
			return zend_hash_index_exists(h, Z_TYPE_P(index) == IS_TRUE ? 1 : 0);

		case IS_LONG:
		case IS_RESOURCE:
			return zend_hash_index_exists(h, Z_LVAL_P(index));

		case IS_STRING:
			return zend_symtable_str_exists(h, Z_STRVAL_P(index), Z_STRLEN_P(index));

		default:
			zend_error(E_WARNING, "Illegal offset type");
			return 0;
	}
}

static int ZEPHIR_FASTCALL zephir_array_isset_string(const zval *arr, const char *index, uint32_t index_length)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist, offset;
		ZVAL_UNDEF(&exist);
		ZVAL_STRINGL(&offset, index, index_length);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, &offset);
		zval_ptr_dtor(&offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE && zend_is_true(&exist)) {
			return 1;
		}

		return 0;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		return zend_hash_str_exists(Z_ARRVAL_P(arr), index, index_length);
	}

	return 0;
}

static int ZEPHIR_FASTCALL zephir_array_isset_long(const zval *arr, unsigned long index)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev((zval *)arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval exist, offset;
		ZVAL_UNDEF(&exist);
		ZVAL_LONG(&offset, index);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(&exist, (zval *)arr, "offsetexists", NULL, 0, &offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE && zend_is_true(&exist)) {
			return 1;
		}

		return 0;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		return zend_hash_index_exists(Z_ARRVAL_P(arr), index);
	}

	return 0;
}

static int ZEPHIR_FASTCALL zephir_array_unset(zval *arr, zval *index, int flags)
{
	HashTable *ht;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetunset", NULL, 0, index);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return 1;
		}

		return 0;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		return 0;
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	ht = Z_ARRVAL_P(arr);

	switch (Z_TYPE_P(index)) {
		case IS_NULL:
			return (zend_hash_str_del(ht, "", 1) == SUCCESS);

		case IS_DOUBLE:
			return (zend_hash_index_del(ht, (zend_ulong)Z_DVAL_P(index)) == SUCCESS);

		case IS_TRUE:
			return (zend_hash_index_del(ht, 1) == SUCCESS);

		case IS_FALSE:
			return (zend_hash_index_del(ht, 0) == SUCCESS);

		case IS_LONG:
		case IS_RESOURCE:
			return (zend_hash_index_del(ht, Z_LVAL_P(index)) == SUCCESS);

		case IS_STRING:
			return (zend_symtable_del(ht, Z_STR_P(index)) == SUCCESS);

		default:
			zend_error(E_WARNING, "Passed index has illegal offset type (check zephir_array_unset())");
			return 0;
	}
}

static int ZEPHIR_FASTCALL zephir_array_unset_string(zval *arr, const char *index, uint32_t index_length, int flags)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_STRINGL(&offset, index, index_length);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetunset", NULL, 0, &offset);
		zval_ptr_dtor(&offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return 1;
		}

		return 0;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		return 0;
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ZVAL(arr);
	}

	return zend_hash_str_del(Z_ARRVAL_P(arr), index, index_length);
}

static int ZEPHIR_FASTCALL zephir_array_unset_long(zval *arr, unsigned long index, int flags)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_LONG(&offset, index);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetunset", NULL, 0, &offset);

		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return 1;
		}

		return 0;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		return 0;
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	return zend_hash_index_del(Z_ARRVAL_P(arr), index);
}

static int zephir_array_append(zval *arr, zval *value, int flags ZEPHIR_DEBUG_PARAMS)
{
	if (Z_TYPE_P(arr) != IS_ARRAY) {
		zend_error(E_WARNING, "Cannot use a scalar value as an array in %s on line %d", file, line);
		return FAILURE;
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	Z_TRY_ADDREF_P(value);
	return add_next_index_zval(arr, value);
}

static int zephir_array_fetch(zval *return_value, zval *arr, zval *index, int flags ZEPHIR_DEBUG_PARAMS)
{
	zval *zv;
	HashTable *ht;
	int result = SUCCESS, found = 0;
	zend_ulong uidx = 0;
	char *sidx = NULL;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(return_value, arr, "offsetget", NULL, 0, index);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			if ((flags & PH_READONLY) == PH_READONLY) {
				Z_TRY_DELREF_P(return_value);
			}
			return SUCCESS;
		}

		return FAILURE;
	} else if (Z_TYPE_P(arr) == IS_ARRAY) {
		ht = Z_ARRVAL_P(arr);
		switch (Z_TYPE_P(index)) {
			case IS_NULL:
				found = (zv = zend_hash_str_find(ht, SL(""))) != NULL;
				sidx   = "";
				break;

			case IS_DOUBLE:
				uidx   = (zend_ulong)Z_DVAL_P(index);
				found  = (zv = zend_hash_index_find(ht, uidx)) != NULL;
				break;

			case IS_LONG:
			case IS_RESOURCE:
				uidx   = Z_LVAL_P(index);
				found  = (zv = zend_hash_index_find(ht, uidx)) != NULL;
				break;

			case IS_FALSE:
				uidx = 0;
				found  = (zv = zend_hash_index_find(ht, uidx)) != NULL;
				break;

			case IS_TRUE:
				uidx = 1;
				found  = (zv = zend_hash_index_find(ht, uidx)) != NULL;
				break;

			case IS_STRING:
				sidx   = Z_STRLEN_P(index) ? Z_STRVAL_P(index) : "";
				found  = (zv = zend_symtable_str_find(ht, Z_STRVAL_P(index), Z_STRLEN_P(index))) != NULL;
				break;

			default:
				if ((flags & PH_NOISY) == PH_NOISY) {
					zend_error(E_WARNING, "Illegal offset type in %s on line %d", file, line);
				}
				result = FAILURE;
				break;
		}

		if (result != FAILURE && found == 1) {
			if ((flags & PH_READONLY) == PH_READONLY) {
				ZVAL_COPY_VALUE(return_value, zv);
			} else {
				ZVAL_COPY(return_value, zv);
			}
			return SUCCESS;
		}

		if ((flags & PH_NOISY) == PH_NOISY) {
			if (sidx == NULL) {
				zend_error(E_NOTICE, "Undefined index: %ld in %s on line %d", uidx, file, line);
			} else {
				zend_error(E_NOTICE, "Undefined index: %s in %s on line %d", sidx, file, line);
			}
		}
	}

	ZVAL_NULL(return_value);
	return FAILURE;
}

static int zephir_array_fetch_string(zval *return_value, zval *arr, const char *index, uint32_t index_length, int flags ZEPHIR_DEBUG_PARAMS)
{
	zval *zv;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_STRINGL(&offset, index, index_length);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(return_value, arr, "offsetget", NULL, 0, &offset);
		zval_ptr_dtor(&offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			if ((flags & PH_READONLY) == PH_READONLY) {
				Z_TRY_DELREF_P(return_value);
			}
			return SUCCESS;
		}

		return FAILURE;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		if ((zv = zend_hash_str_find(Z_ARRVAL_P(arr), index, index_length)) != NULL) {

			if ((flags & PH_READONLY) == PH_READONLY) {
				ZVAL_COPY_VALUE(return_value, zv);
			} else {
				ZVAL_COPY(return_value, zv);
			}
			return SUCCESS;
		}
		if ((flags & PH_NOISY) == PH_NOISY) {
			zend_error(E_NOTICE, "Undefined index: %s", index);
		}
	} else {
		if ((flags & PH_NOISY) == PH_NOISY) {
			zend_error(E_NOTICE, "Cannot use a scalar value as an array in %s on line %d", file, line);
		}
	}

	if (return_value == NULL) {
		zend_error(E_ERROR, "No return value passed to zephir_array_fetch_string");
		return FAILURE;
	}

	ZVAL_NULL(return_value);
	return FAILURE;
}

static int zephir_array_fetch_long(zval *return_value, zval *arr, unsigned long index, int flags ZEPHIR_DEBUG_PARAMS)
{
	zval *zv;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_LONG(&offset, index);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(return_value, arr, "offsetget", NULL, 0, &offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			if ((flags & PH_READONLY) == PH_READONLY) {
				Z_TRY_DELREF_P(return_value);
			}
			return SUCCESS;
		}

		return FAILURE;
	} else if (EXPECTED(Z_TYPE_P(arr) == IS_ARRAY)) {
		if ((zv = zend_hash_index_find(Z_ARRVAL_P(arr), index)) != NULL) {

			if ((flags & PH_READONLY) == PH_READONLY) {
				ZVAL_COPY_VALUE(return_value, zv);
			} else {
				ZVAL_COPY(return_value, zv);
			}
			return SUCCESS;
		}
		if ((flags & PH_NOISY) == PH_NOISY) {
			zend_error(E_NOTICE, "Undefined index: %lu", index);
		}
	} else {
		if ((flags & PH_NOISY) == PH_NOISY) {
			zend_error(E_NOTICE, "Cannot use a scalar value as an array in %s on line %d", file, line);
		}
	}

	if (return_value == NULL) {
		zend_error(E_ERROR, "No return value passed to zephir_array_fetch_string");
		return FAILURE;
	}

	ZVAL_NULL(return_value);
	return FAILURE;
}

static void zephir_merge_append(zval *left, zval *values)
{
	if (Z_TYPE_P(left) != IS_ARRAY) {
		zend_error(E_NOTICE, "First parameter of zephir_merge_append must be an array");
		return;
	}

	if (Z_TYPE_P(values) == IS_ARRAY) {
		zval *tmp;

		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(values), tmp) {

			Z_TRY_ADDREF_P(tmp);
			add_next_index_zval(left, tmp);

		} ZEND_HASH_FOREACH_END();

	} else {
		Z_TRY_ADDREF_P(values);
		add_next_index_zval(left, values);
	}
}

static int zephir_array_update_zval(zval *arr, zval *index, zval *value, int flags)
{
	HashTable *ht;
	zval *ret = NULL;

	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetset", NULL, 0, index, value);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return SUCCESS;
		}

		return FAILURE;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		zend_error(E_WARNING, "Cannot use a scalar value as an array (2)");
		return FAILURE;
	}

	if ((flags & PH_CTOR) == PH_CTOR) {
		zval new_zv;
		//Z_TRY_DELREF_P(value); //?
		ZVAL_DUP(&new_zv, value);
		value = &new_zv;
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	if ((flags & PH_COPY) == PH_COPY) {
		Z_TRY_ADDREF_P(value);
	}

	ht = Z_ARRVAL_P(arr);

	switch (Z_TYPE_P(index)) {
		case IS_NULL:
			ret = zend_symtable_str_update(ht, "", 1, value);
			break;

		case IS_DOUBLE:
			ret = zend_hash_index_update(ht, (zend_ulong)Z_DVAL_P(index), value);
			break;

		case IS_LONG:
		case IS_RESOURCE:
			ret = zend_hash_index_update(ht, Z_LVAL_P(index), value);
			break;

		case IS_TRUE:
		case IS_FALSE:
			ret = zend_hash_index_update(ht, Z_TYPE_P(index) == IS_TRUE ? 1 : 0, value);
			break;

		case IS_STRING:
			ret = zend_symtable_str_update(ht, Z_STRVAL_P(index), Z_STRLEN_P(index), value);
			break;

		default:
			zend_error(E_WARNING, "Illegal offset type");
			return FAILURE;
	}

	return ret != NULL ? FAILURE : SUCCESS;
}

static int zephir_array_update_string(zval *arr, const char *index, uint32_t index_length, zval *value, int flags)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_STRINGL(&offset, index, index_length);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetset", NULL, 0, &offset, value);
		zval_ptr_dtor(&offset);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return SUCCESS;
		}

		return FAILURE;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		zend_error(E_WARNING, "Cannot use a scalar value as an array (3)");
		return FAILURE;
	}

	if ((flags & PH_CTOR) == PH_CTOR) {
		zval new_value;

		ZVAL_DUP(&new_value, value);
		value = &new_value;
	} else if ((flags & PH_COPY) == PH_COPY) {
		Z_TRY_ADDREF_P(value);
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	return zend_hash_str_update(Z_ARRVAL_P(arr), index, index_length, value) ? SUCCESS : FAILURE;
}

static int zephir_array_update_long(zval *arr, unsigned long index, zval *value, int flags ZEPHIR_DEBUG_PARAMS)
{
	if (UNEXPECTED(Z_TYPE_P(arr) == IS_OBJECT && zephir_instance_of_ev(arr, (const zend_class_entry *)zend_ce_arrayaccess))) {
		zend_long ZEPHIR_LAST_CALL_STATUS;
		zval offset;
		ZVAL_LONG(&offset, index);
		ZEPHIR_CALL_METHOD_WITHOUT_OBSERVE(NULL, arr, "offsetset", NULL, 0, &offset, value);
		if (ZEPHIR_LAST_CALL_STATUS != FAILURE) {
			return SUCCESS;
		}

		return FAILURE;
	} else if (Z_TYPE_P(arr) != IS_ARRAY) {
		zend_error(E_WARNING, "Cannot use a scalar value as an array in %s on line %d", file, line);
		return FAILURE;
	}

	if ((flags & PH_CTOR) == PH_CTOR) {
		zval new_value;

		ZVAL_DUP(&new_value, value);
		value = &new_value;
	} else if ((flags & PH_COPY) == PH_COPY) {
		Z_TRY_ADDREF_P(value);
	}

	if ((flags & PH_SEPARATE) == PH_SEPARATE) {
		SEPARATE_ARRAY(arr);
	}

	return zend_hash_index_update(Z_ARRVAL_P(arr), index, value) ? SUCCESS : FAILURE;
}

static void zephir_array_keys(zval *return_value, zval *input)
{
	zval *entry, new_val;
	zend_ulong num_idx;
	zend_string *str_idx;

	if (EXPECTED(Z_TYPE_P(input) == IS_ARRAY)) {
		array_init_size(return_value, zend_hash_num_elements(Z_ARRVAL_P(input)));
		zend_hash_real_init(Z_ARRVAL_P(return_value), 1);
		ZEND_HASH_FILL_PACKED(Z_ARRVAL_P(return_value)) {
			/* Go through input array and add keys to the return array */
			ZEND_HASH_FOREACH_KEY_VAL_IND(Z_ARRVAL_P(input), num_idx, str_idx, entry) {
				if (str_idx) {
					ZVAL_STR_COPY(&new_val, str_idx);
				} else {
					ZVAL_LONG(&new_val, num_idx);
				}
				ZEND_HASH_FILL_ADD(&new_val);
			} ZEND_HASH_FOREACH_END();
		} ZEND_HASH_FILL_END();
	}

	entry = NULL;
	str_idx = NULL;
	num_idx = 0;
	ZVAL_UNDEF(&new_val);
}

static int zephir_array_key_exists(zval *arr, zval *key)
{
	HashTable *h = Z_ARRVAL_P(arr);
	if (h) {
		switch (Z_TYPE_P(key)) {
			case IS_STRING:
				return zend_symtable_exists(h, Z_STR_P(key));

			case IS_LONG:
				return zend_hash_index_exists(h, Z_LVAL_P(key));

			case IS_NULL:
				return zend_hash_str_exists(h, "", 1);

			default:
				zend_error(E_WARNING, "The key should be either a string or an integer");
				return 0;
		}
	}

	return 0;
}

static void zephir_array_update_multi_ex(zval *arr, zval *value, const char *types, int types_length, int types_count, va_list ap)
{
	char *s;
	zval *item;
	zval pzv;
	zend_array *p;
	int i, j, l, ll, re_update, must_continue, wrap_tmp;

	ZVAL_UNDEF(&pzv);

	if (Z_TYPE_P(arr) != IS_ARRAY) {
		zend_error(E_ERROR, "Cannot use a scalar value as an array (multi)");
		return;
	}
	p = Z_ARRVAL_P(arr);

	for (i = 0; i < types_length; ++i) {
		zval tmp;
		zval fetched;
		ZVAL_UNDEF(&fetched);

		re_update = 0;
		must_continue = 0;
		wrap_tmp = 0;

		ZVAL_ARR(&pzv, p);
		switch (types[i]) {

			case 's':
				s = va_arg(ap, char*);
				l = va_arg(ap, int);
				if (zephir_array_isset_string_fetch(&fetched, &pzv, s, l, 1)) {
					if (Z_TYPE(fetched) == IS_ARRAY) {
						if (i == (types_length - 1)) {
							re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
							zephir_array_update_string(&pzv, s, l, value, PH_COPY | PH_SEPARATE);
							p = Z_ARRVAL(pzv);
						} else {
							re_update = !Z_REFCOUNTED(fetched) || (Z_REFCOUNT(fetched) > 1 && !Z_ISREF(fetched));
							if (re_update) {
								ZVAL_DUP(&tmp, &fetched);
								zephir_array_update_string(&pzv, s, l, &tmp, 0);
								p = Z_ARRVAL(tmp);
							} else {
								p = Z_ARRVAL(fetched);
							}
						}
						must_continue = 1;
					}
				}

				if (!must_continue) {
					ZVAL_ARR(&pzv, p);
					re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
					if (i == (types_length - 1)) {
						zephir_array_update_string(&pzv, s, l, value, PH_COPY | PH_SEPARATE);
						p = Z_ARRVAL(pzv);
					} else {
						array_init(&tmp);
						zephir_array_update_string(&pzv, s, l, &tmp, PH_SEPARATE);
						p = Z_ARRVAL(pzv);
						if (re_update) {
							wrap_tmp = 1;
						} else {
							p = Z_ARRVAL(tmp);
						}
					}
				}
				break;

			case 'l':
				ll = va_arg(ap, long);
				if (zephir_array_isset_long_fetch(&fetched, &pzv, ll, 1)) {
					if (Z_TYPE(fetched) == IS_ARRAY) {
						if (i == (types_length - 1)) {
							re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
							zephir_array_update_long(&pzv, ll, value, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
							p = Z_ARRVAL(pzv);
						} else {
							re_update = !Z_REFCOUNTED(fetched) || (Z_REFCOUNT(fetched) > 1 && !Z_ISREF(fetched));
							if (re_update) {
								ZVAL_DUP(&tmp, &fetched);
								zephir_array_update_long(&pzv, ll, &tmp, 0 ZEPHIR_DEBUG_PARAMS_DUMMY);
								p = Z_ARRVAL(tmp);
							} else {
								p = Z_ARRVAL(fetched);
							}
						}
						must_continue = 1;
					}
				}

				if (!must_continue) {
					ZVAL_ARR(&pzv, p);
					re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
					if (i == (types_length - 1)) {
						zephir_array_update_long(&pzv, ll, value, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
						p = Z_ARRVAL(pzv);
					} else {
						array_init(&tmp);
						zephir_array_update_long(&pzv, ll, &tmp, PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
						p = Z_ARRVAL(pzv);
						if (re_update) {
							wrap_tmp = 1;
						} else {
							p = Z_ARRVAL(tmp);
						}
					}
				}
				break;

			case 'z':
				item = va_arg(ap, zval*);
				if (zephir_array_isset_fetch(&fetched, &pzv, item, 1)) {
					if (Z_TYPE(fetched) == IS_ARRAY) {
						if (i == (types_length - 1)) {
							re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
							zephir_array_update_zval(&pzv, item, value, PH_COPY | PH_SEPARATE);
							p = Z_ARRVAL(pzv);
						} else {
							re_update = !Z_REFCOUNTED(fetched) || (Z_REFCOUNT(fetched) > 1 && !Z_ISREF(fetched));
							if (re_update) {
								ZVAL_DUP(&tmp, &fetched);
								zephir_array_update_zval(&pzv, item, &tmp, 0);
								p = Z_ARRVAL(tmp);
							} else {
								p = Z_ARRVAL(fetched);
							}
						}
						must_continue = 1;
					}
				}

				if (!must_continue) {
					ZVAL_ARR(&pzv, p);
					re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
					if (i == (types_length - 1)) {
						zephir_array_update_zval(&pzv, item, value, PH_COPY | PH_SEPARATE);
						p = Z_ARRVAL(pzv);
					} else {
						array_init(&tmp);
						zephir_array_update_zval(&pzv, item, &tmp, PH_SEPARATE);
						p = Z_ARRVAL(pzv);
						if (re_update) {
							wrap_tmp = 1;
						} else {
							p = Z_ARRVAL(tmp);
						}
					}
				}
				break;

			case 'a':
				re_update = !Z_REFCOUNTED(pzv) || (Z_REFCOUNT(pzv) > 1 && !Z_ISREF(pzv));
				if (re_update) {
					zephir_array_append(&pzv, value, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
				} else {
					zephir_array_append(&pzv, value, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
				}

				p = Z_ARRVAL(pzv);
				break;
		}
	}
}

static int zephir_array_update_multi(zval *arr, zval *value, const char *types, int types_length, int types_count, ...)
{
	va_list ap;
	va_start(ap, types_count);
	SEPARATE_ZVAL(arr);

	zephir_array_update_multi_ex(arr, value, types, types_length, types_count, ap);
	va_end(ap);

	return 0;
}

static int zephir_fast_in_array(zval *value, zval *haystack)
{
	zval *entry;
	zend_ulong num_idx;
	zend_string *str_idx;

	if (Z_TYPE_P(haystack) != IS_ARRAY) {
		return 0;
	}

	if (Z_TYPE_P(value) == IS_STRING) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(haystack), num_idx, str_idx, entry) {
			if (fast_equal_check_string(value, entry)) {
				return 1;
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(haystack), num_idx, str_idx, entry) {
			if (fast_equal_check_function(value, entry)) {
				return 1;
			}
		} ZEND_HASH_FOREACH_END();
	}

	return 0;
}

static void zephir_fast_array_merge(zval *return_value, zval *array1, zval *array2)
{
	int init_size, num;

	if (Z_TYPE_P(array1) != IS_ARRAY) {
		zend_error(E_WARNING, "First argument is not an array");
		RETURN_NULL();
	}

	if (Z_TYPE_P(array2) != IS_ARRAY) {
		zend_error(E_WARNING, "Second argument is not an array");
		RETURN_NULL();
	}

	init_size = zend_hash_num_elements(Z_ARRVAL_P(array1));
	num = zend_hash_num_elements(Z_ARRVAL_P(array2));
	if (num > init_size) {
		init_size = num;
	}

	array_init_size(return_value, init_size);
	php_array_merge(Z_ARRVAL_P(return_value), Z_ARRVAL_P(array1));
	php_array_merge(Z_ARRVAL_P(return_value), Z_ARRVAL_P(array2));
}



#ifdef HAVE_CONFIG_H
#endif




#if defined ZEPHIR_USE_PHP_PCRE && ZEPHIR_USE_PHP_PCRE
#endif

#if defined ZEPHIR_USE_PHP_JSON && ZEPHIR_USE_PHP_JSON
#endif


#define PH_RANDOM_ALNUM 0
#define PH_RANDOM_ALPHA 1
#define PH_RANDOM_HEXDEC 2
#define PH_RANDOM_NUMERIC 3
#define PH_RANDOM_NOZERO 4

static int zephir_spprintf(char **message, int max_len, char *format, ...)
{
	va_list arg;
	int len;

	va_start(arg, format);
	len = vspprintf(message, max_len, format, arg);
	va_end(arg);
	return len;
}

static int zephir_fast_strlen_ev(zval *str)
{
	zval copy;
	int use_copy = 0, length;

	if (Z_TYPE_P(str) != IS_STRING) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	length = Z_STRLEN_P(str);
	if (use_copy) {
		zval_dtor(str);
	}

	return length;
}

static void zephir_fast_strtolower(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;
	char *lower_str;
	unsigned int length;

	if (Z_TYPE_P(str) != IS_STRING) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	length = Z_STRLEN_P(str);
	lower_str = estrndup(Z_STRVAL_P(str), length);
	php_strtolower(lower_str, length);

	if (use_copy) {
		zval_dtor(str);
	}

	ZVAL_STRINGL(return_value, lower_str, length);
	efree(lower_str);
}

static void zephir_fast_strtoupper(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;
	char *lower_str;
	unsigned int length;

	if (Z_TYPE_P(str) != IS_STRING) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	length = Z_STRLEN_P(str);
	lower_str = estrndup(Z_STRVAL_P(str), length);
	php_strtoupper(lower_str, length);

	if (use_copy) {
		zval_dtor(str);
	}

	ZVAL_STRINGL(return_value, lower_str, length);
	efree(lower_str);
}

static int zephir_start_with(const zval *str, const zval *compared, zval *case_sensitive)
{
	int i;
	int sensitive = 0;
	char *op1_cursor, *op2_cursor;

	if (Z_TYPE_P(str) != IS_STRING || Z_TYPE_P(compared) != IS_STRING) {
		return 0;
	}

	if (!Z_STRLEN_P(compared) || !Z_STRLEN_P(str) || Z_STRLEN_P(compared) > Z_STRLEN_P(str)) {
		return 0;
	}

	if (case_sensitive) {
		sensitive = zend_is_true(case_sensitive);
	}

	if (!sensitive) {
		return !memcmp(Z_STRVAL_P(str), Z_STRVAL_P(compared), Z_STRLEN_P(compared));
	}

	op1_cursor = Z_STRVAL_P(str);
	op2_cursor = Z_STRVAL_P(compared);
	for (i = 0; i < Z_STRLEN_P(compared); i++) {
		if (tolower(*op1_cursor) != tolower(*op2_cursor)) {
			return 0;
		}

		op1_cursor++;
		op2_cursor++;
	}

	return 1;
}

static int zephir_start_with_str(const zval *str, char *compared, unsigned int compared_length)
{
	if (Z_TYPE_P(str) != IS_STRING || compared_length > Z_STRLEN_P(str)) {
		return 0;
	}

	return !memcmp(Z_STRVAL_P(str), compared, compared_length);
}

static int zephir_start_with_str_str(char *str, unsigned int str_length, char *compared, unsigned int compared_length)
{

	if (compared_length > str_length) {
		return 0;
	}

	return !memcmp(str, compared, compared_length);
}

static int zephir_end_with(const zval *str, const zval *compared, zval *case_sensitive)
{
	int sensitive = 0;
	int i;
	char *op1_cursor, *op2_cursor;

	if (Z_TYPE_P(str) != IS_STRING || Z_TYPE_P(compared) != IS_STRING) {
		return 0;
	}

	if (!Z_STRLEN_P(compared) || !Z_STRLEN_P(str) || Z_STRLEN_P(compared) > Z_STRLEN_P(str)) {
		return 0;
	}

	if (case_sensitive) {
		sensitive = zend_is_true(case_sensitive);
	}

	if (!sensitive) {
		return !memcmp(Z_STRVAL_P(str) + Z_STRLEN_P(str) - Z_STRLEN_P(compared), Z_STRVAL_P(compared), Z_STRLEN_P(compared));
	}

	op1_cursor = Z_STRVAL_P(str) + Z_STRLEN_P(str) - Z_STRLEN_P(compared);
	op2_cursor = Z_STRVAL_P(compared);

	for (i = 0; i < Z_STRLEN_P(compared); ++i) {

		if (tolower(*op1_cursor) != tolower(*op2_cursor)) {
			return 0;
		}

		++op1_cursor;
		++op2_cursor;
	}

	return 1;
}

static int zephir_end_with_str(const zval *str, char *compared, unsigned int compared_length)
{
	if (Z_TYPE_P(str) != IS_STRING) {
		return 0;
	}

	if (!compared_length || !Z_STRLEN_P(str) || compared_length > Z_STRLEN_P(str)) {
		return 0;
	}

	return !memcmp(Z_STRVAL_P(str) + Z_STRLEN_P(str) - compared_length, compared, compared_length);
}

static void zephir_substr(zval *return_value, zval *str, long f, long l, int flags)
{
	zval copy;
	int use_copy = 0;
	int str_len;

	if (Z_TYPE_P(str) != IS_STRING) {

		if (Z_TYPE_P(str) == IS_NULL || Z_TYPE_P(str) == IS_TRUE || Z_TYPE_P(str) == IS_FALSE) {
			RETURN_FALSE;
		}

		if (Z_TYPE_P(str) != IS_STRING) {
			use_copy = zend_make_printable_zval(str, &copy);
			if (use_copy) {
				str = &copy;
			}
		}
	}

	str_len = Z_STRLEN_P(str);
	if ((flags & ZEPHIR_SUBSTR_NO_LENGTH) == ZEPHIR_SUBSTR_NO_LENGTH) {
		l = str_len;
	}

	if ((l < 0 && -l > str_len)) {
		if (use_copy) {
			zval_dtor(str);
		}
		RETURN_FALSE;
	} else {
		if (l > str_len) {
			l = str_len;
		}
	}

	if (f > str_len) {
		if (use_copy) {
			zval_dtor(str);
		}
		RETURN_FALSE;
	} else {
		if (f < 0 && -f > str_len) {
			f = 0;
		}
	}

	if (l < 0 && (l + str_len - f) < 0) {
		if (use_copy) {
			zval_dtor(str);
		}
		RETURN_FALSE;
	}

	/* if "from" position is negative, count start position from the end
	 * of the string
	 */
	if (f < 0) {
		f = str_len + f;
		if (f < 0) {
			f = 0;
		}
	}

	/* if "length" position is negative, set it to the length
	 * needed to stop that many chars from the end of the string
	 */
	if (l < 0) {
		l = (str_len - f) + l;
		if (l < 0) {
			l = 0;
		}
	}

	if (f >= str_len) {
		if (use_copy) {
			zval_dtor(str);
		}
		RETURN_FALSE;
	}

	if ((f + l) > str_len) {
		l = str_len - f;
	}

	if (!l) {
		if (use_copy) {
			zval_dtor(str);
		}
		RETURN_EMPTY_STRING();
	}

	ZVAL_STRINGL(return_value, Z_STRVAL_P(str) + f, l);

	if (use_copy) {
		zval_dtor(str);
	}

	return;
}

static void zephir_append_printable_zval(smart_str *implstr, zval *tmp)
{
	switch (Z_TYPE_P(tmp)) {

		case IS_STRING:
			smart_str_appendl(implstr, Z_STRVAL_P(tmp), Z_STRLEN_P(tmp));
			break;

		default:
			smart_str_append(implstr, _zval_get_string_func(tmp));
			break;
	}
}

static void zephir_append_printable_array(smart_str *implstr, const zval *value)
{
	zend_array *arr;
	unsigned int numelems;

	arr = Z_ARRVAL_P(value);
	numelems = zend_hash_num_elements(arr);

	smart_str_appendc(implstr, '[');

	if (numelems > 0) {
		zval *tmp;
		unsigned int i = 0;

		ZEND_HASH_FOREACH_VAL(arr, tmp) {

			if (Z_TYPE_P(tmp) == IS_OBJECT) {

			} else {
				if (Z_TYPE_P(tmp) == IS_ARRAY) {
					zephir_append_printable_array(implstr, tmp);
				} else {
					zephir_append_printable_zval(implstr, tmp);
				}
			}

			if (++i != numelems) {
				smart_str_appendc(implstr, ',');
			}

		} ZEND_HASH_FOREACH_END();
	}

	smart_str_appendc(implstr, ']');
}

static void zephir_unique_key(zval *return_value, const zval *prefix, zval *value)
{
	smart_str implstr = {0};

	if (Z_TYPE_P(prefix) == IS_STRING) {
		smart_str_appendl(&implstr, Z_STRVAL_P(prefix), Z_STRLEN_P(prefix));
	}

	if (Z_TYPE_P(value) == IS_ARRAY) {
		zephir_append_printable_array(&implstr, value);
	} else {
		zephir_append_printable_zval(&implstr, value);
	}

	smart_str_0(&implstr);

	if (implstr.s) {
		RETURN_STR(implstr.s);
	} else {
		smart_str_free(&implstr);
		RETURN_NULL();
	}
}

static void zephir_fast_join(zval *result, zval *glue, zval *pieces)
{
	if (Z_TYPE_P(glue) != IS_STRING || Z_TYPE_P(pieces) != IS_ARRAY) {
		ZVAL_NULL(result);
		zend_error(E_WARNING, "Invalid arguments supplied for join()");
		return;
	}

	php_implode(Z_STR_P(glue), Z_ARRVAL_P(pieces), result);
}

static void zephir_fast_join_str(zval *return_value, char *glue, unsigned int glue_length, zval *pieces)
{
	zval         *tmp;
	int           numelems;
	zend_string  *str;
	char         *cptr;
	size_t        len = 0;
	zend_string **strings, **strptr;
	zend_array *arr;

	if (Z_TYPE_P(pieces) != IS_ARRAY) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for fast_join()");
		RETURN_EMPTY_STRING();
	}

	arr = Z_ARRVAL_P(pieces);
	numelems = zend_hash_num_elements(arr);

	if (numelems == 0) {
		RETURN_EMPTY_STRING();
	} else if (numelems == 1) {
		/* loop to search the first not undefined element... */
		ZEND_HASH_FOREACH_VAL(arr, tmp) {
			RETURN_STR(zval_get_string(tmp));
		} ZEND_HASH_FOREACH_END();
	}

	strings = emalloc((sizeof(zend_long) + sizeof(zend_string *)) * numelems);
	strptr = strings - 1;

	ZEND_HASH_FOREACH_VAL(arr, tmp) {
		if (Z_TYPE_P(tmp) == IS_LONG) {
			double val = Z_LVAL_P(tmp);
			*++strptr = NULL;
			((zend_long *) (strings + numelems))[strptr - strings] = Z_LVAL_P(tmp);
			if (val < 0) {
				val = -10 * val;
			}
			if (val < 10) {
				len++;
			} else {
				len += (int) log10(10 * (double) val);
			}
		} else {
			*++strptr = zval_get_string(tmp);
			len += ZSTR_LEN(*strptr);
		}
	} ZEND_HASH_FOREACH_END();

	str = zend_string_alloc(len + (numelems - 1) * glue_length, 0);
	cptr = ZSTR_VAL(str) + ZSTR_LEN(str);
	*cptr = 0;

	do {
		if (*strptr) {
			cptr -= ZSTR_LEN(*strptr);
			memcpy(cptr, ZSTR_VAL(*strptr), ZSTR_LEN(*strptr));
			zend_string_release(*strptr);
		} else {
			char *oldPtr = cptr;
			char oldVal = *cptr;
			zend_long val = ((zend_long *) (strings + numelems))[strptr - strings];
			cptr = zend_print_long_to_buf(cptr, val);
			*oldPtr = oldVal;
		}

		cptr -= glue_length;
		memcpy(cptr, glue, glue_length);
	} while (--strptr > strings);

	if (*strptr) {
		memcpy(ZSTR_VAL(str), ZSTR_VAL(*strptr), ZSTR_LEN(*strptr));
		zend_string_release(*strptr);
	} else {
		char *oldPtr = cptr;
		char oldVal = *cptr;
		zend_print_long_to_buf(cptr, ((zend_long *) (strings + numelems))[strptr - strings]);
		*oldPtr = oldVal;
	}

	efree(strings);
	RETURN_NEW_STR(str);
}

static void zephir_camelize(zval *return_value, const zval *str, const zval *delimiter)
{
	int i, len, delim_len, pre_del = 1;
	smart_str camelize_str = {0};
	char *marker, ch, *delim;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		zend_error(E_WARNING, "Invalid arguments supplied for camelize()");
		RETURN_EMPTY_STRING();
	}

	if (delimiter == NULL || Z_TYPE_P(delimiter) == IS_NULL) {
		delim = "_-";
		delim_len = 2;
	} else if (Z_TYPE_P(delimiter) == IS_STRING && Z_STRLEN_P(delimiter) > 0) {
		delim = Z_STRVAL_P(delimiter);
		delim_len = Z_STRLEN_P(delimiter);
	} else {
		zend_error(E_WARNING, "The second argument passed to the camelize() must be a string containing at least one character");
		RETURN_EMPTY_STRING();
	}

	marker = Z_STRVAL_P(str);
	len    = Z_STRLEN_P(str);

	for (i = 0; i < len; i++) {
		ch = marker[i];

		if (memchr(delim, ch, delim_len)) {
			pre_del = 1;
			continue;
		}
		if (pre_del == 1) {
			smart_str_appendc(&camelize_str, toupper(ch));
			pre_del = 0;
		} else {
			smart_str_appendc(&camelize_str, tolower(ch));
		}
	}

	smart_str_0(&camelize_str);

	if (camelize_str.s) {
		RETURN_STR(camelize_str.s);
	} else {
		RETURN_EMPTY_STRING();
	}
}

static void zephir_uncamelize(zval *return_value, const zval *str, const zval *delimiter)
{
	unsigned int i;
	smart_str uncamelize_str = {0};
	char *marker, ch, delim;

	if (Z_TYPE_P(str) != IS_STRING) {
		zend_error(E_WARNING, "Invalid arguments supplied for uncamelize()");
		RETURN_EMPTY_STRING();
	}

	if (delimiter == NULL || Z_TYPE_P(delimiter) == IS_NULL) {
		delim = '_';
	} else if (Z_TYPE_P(delimiter) == IS_STRING && Z_STRLEN_P(delimiter) == 1) {
		delim = *(Z_STRVAL_P(delimiter));
	} else {
		zend_error(E_WARNING, "Second argument passed to the uncamelize() must be a string of one character");
		RETURN_EMPTY_STRING();
	}

	marker = Z_STRVAL_P(str);
	for (i = 0; i < Z_STRLEN_P(str); i++) {
		ch = *marker;
		if (ch == '\0') {
			break;
		}
		if (ch >= 'A' && ch <= 'Z') {
			if (i > 0) {
				smart_str_appendc(&uncamelize_str, delim);
			}
			smart_str_appendc(&uncamelize_str, (*marker) + 32);
		} else {
			smart_str_appendc(&uncamelize_str, (*marker));
		}
		marker++;
	}
	smart_str_0(&uncamelize_str);

	if (uncamelize_str.s) {
		RETURN_STR(uncamelize_str.s);
	} else {
		RETURN_EMPTY_STRING();
	}
}

static int zephir_memnstr(const zval *haystack, const zval *needle ZEPHIR_DEBUG_PARAMS)
{
	if (Z_TYPE_P(haystack) != IS_STRING || Z_TYPE_P(needle) != IS_STRING) {
		#ifndef ZEPHIR_RELEASE
		zend_error(E_WARNING, "Invalid arguments supplied for memnstr in %s on line %d", file, line);
		#else
		zend_error(E_WARNING, "Invalid arguments supplied for memnstr()");
		#endif
		return 0;
	}

	if (Z_STRLEN_P(haystack) >= Z_STRLEN_P(needle)) {
		return php_memnstr(Z_STRVAL_P(haystack), Z_STRVAL_P(needle), Z_STRLEN_P(needle), Z_STRVAL_P(haystack) + Z_STRLEN_P(haystack)) ? 1 : 0;
	}

	return 0;
}

static int zephir_memnstr_str(const zval *haystack, char *needle, unsigned int needle_length ZEPHIR_DEBUG_PARAMS)
{
	if (Z_TYPE_P(haystack) != IS_STRING) {
		#ifndef ZEPHIR_RELEASE
		zend_error(E_WARNING, "Invalid arguments supplied for memnstr in %s on line %d", file, line);
		#else
		zend_error(E_WARNING, "Invalid arguments supplied for memnstr()");
		#endif
		return 0;
	}

	if (Z_STRLEN_P(haystack) >= needle_length) {
		return php_memnstr(Z_STRVAL_P(haystack), needle, needle_length, Z_STRVAL_P(haystack) + Z_STRLEN_P(haystack)) ? 1 : 0;
	}

	return 0;
}

static void zephir_fast_explode(zval *return_value, zval *delimiter, zval *str, long limit)
{
	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING || Z_TYPE_P(delimiter) != IS_STRING)) {
		zend_error(E_WARNING, "Invalid arguments supplied for explode()");
		RETURN_EMPTY_STRING();
	}

	array_init(return_value);
	php_explode(Z_STR_P(delimiter), Z_STR_P(str), return_value, limit);
}

static void zephir_fast_explode_str(zval *return_value, const char *delim, int delim_length, zval *str, long limit)
{
	zend_string *delimiter;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		zend_error(E_WARNING, "Invalid arguments supplied for explode()");
		RETURN_EMPTY_STRING();
	}

	delimiter = zend_string_init(delim, delim_length, 0);
	array_init(return_value);
	php_explode(delimiter, Z_STR_P(str), return_value, limit);
	zend_string_free(delimiter);
}

static void zephir_fast_strpos(zval *return_value, const zval *haystack, const zval *needle, unsigned int offset)
{
	const char *found = NULL;

	if (UNEXPECTED(Z_TYPE_P(haystack) != IS_STRING || Z_TYPE_P(needle) != IS_STRING)) {
		ZVAL_NULL(return_value);
		zend_error(E_WARNING, "Invalid arguments supplied for strpos()");
		return;
	}

	if (offset > Z_STRLEN_P(haystack)) {
		ZVAL_NULL(return_value);
		zend_error(E_WARNING, "Offset not contained in string");
		return;
	}

	if (!Z_STRLEN_P(needle)) {
		ZVAL_NULL(return_value);
		zend_error(E_WARNING, "Empty delimiter");
		return;
	}

	found = php_memnstr(Z_STRVAL_P(haystack)+offset, Z_STRVAL_P(needle), Z_STRLEN_P(needle), Z_STRVAL_P(haystack) + Z_STRLEN_P(haystack));

	if (found) {
		ZVAL_LONG(return_value, found - Z_STRVAL_P(haystack));
	} else {
		ZVAL_BOOL(return_value, 0);
	}
}

static void zephir_fast_strpos_str(zval *return_value, const zval *haystack, char *needle, unsigned int needle_length)
{
	const char *found = NULL;

	if (UNEXPECTED(Z_TYPE_P(haystack) != IS_STRING)) {
		ZVAL_NULL(return_value);
		zend_error(E_WARNING, "Invalid arguments supplied for strpos()");
		return;
	}

	found = php_memnstr(Z_STRVAL_P(haystack), needle, needle_length, Z_STRVAL_P(haystack) + Z_STRLEN_P(haystack));

	if (found) {
		ZVAL_LONG(return_value, found - Z_STRVAL_P(haystack));
	} else {
		ZVAL_BOOL(return_value, 0);
	}
}

static void zephir_fast_trim(zval *return_value, zval *str, zval *charlist, int where)
{
	zval copy;
	int use_copy = 0;
	zend_string *trimmed;

	if (Z_TYPE_P(str) != IS_STRING) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	if (charlist && Z_TYPE_P(charlist) == IS_STRING) {
		trimmed = php_trim(Z_STR_P(str), Z_STRVAL_P(charlist), Z_STRLEN_P(charlist), where);
	} else {
		trimmed = php_trim(Z_STR_P(str), NULL, 0, where);
	}
	ZVAL_STR(return_value, trimmed);

	if (use_copy) {
		zval_dtor(&copy);
	}
}

/* {{{ php_char_to_str_ex This function is subject to version 3.01 of the PHP license
 */
static zend_string* php_char_to_str_ex(zend_string *str, char from, char *to, size_t to_len, int case_sensitivity, zend_long *replace_count)
{
	zend_string *result;
	size_t char_count = 0;
	char lc_from = 0;
	char *source, *target, *source_end= ZSTR_VAL(str) + ZSTR_LEN(str);

	if (case_sensitivity) {
		char *p = ZSTR_VAL(str), *e = p + ZSTR_LEN(str);
		while ((p = memchr(p, from, (e - p)))) {
			char_count++;
			p++;
		}
	} else {
		lc_from = tolower(from);
		for (source = ZSTR_VAL(str); source < source_end; source++) {
			if (tolower(*source) == lc_from) {
				char_count++;
			}
		}
	}

	if (char_count == 0) {
		return zend_string_copy(str);
	}

	if (to_len > 0) {
		result = zend_string_safe_alloc(char_count, to_len - 1, ZSTR_LEN(str), 0);
	} else {
		result = zend_string_alloc(ZSTR_LEN(str) - char_count, 0);
	}
	target = ZSTR_VAL(result);

	if (case_sensitivity) {
		char *p = ZSTR_VAL(str), *e = p + ZSTR_LEN(str), *s = ZSTR_VAL(str);
		while ((p = memchr(p, from, (e - p)))) {
			memcpy(target, s, (p - s));
			target += p - s;
			memcpy(target, to, to_len);
			target += to_len;
			p++;
			s = p;
			if (replace_count) {
				*replace_count += 1;
			}
		}
		if (s < e) {
			memcpy(target, s, (e - s));
			target += e - s;
		}
	} else {
		for (source = ZSTR_VAL(str); source < source_end; source++) {
			if (tolower(*source) == lc_from) {
				if (replace_count) {
					*replace_count += 1;
				}
				memcpy(target, to, to_len);
				target += to_len;
			} else {
				*target = *source;
				target++;
			}
		}
	}

	*target = 0;
	return result;
}
/* }}} */

/* {{{ php_str_to_str_ex This function is subject to version 3.01 of the PHP license
 */
static zend_string *php_str_to_str_ex(zend_string *haystack,
	char *needle, size_t needle_len, char *str, size_t str_len, zend_long *replace_count)
{
	zend_string *new_str;

	if (needle_len < ZSTR_LEN(haystack)) {
		char *end;
		char *e, *s, *p, *r;

		if (needle_len == str_len) {
			new_str = NULL;
			end = ZSTR_VAL(haystack) + ZSTR_LEN(haystack);
			for (p = ZSTR_VAL(haystack); (r = (char*)php_memnstr(p, needle, needle_len, end)); p = r + needle_len) {
				if (!new_str) {
					new_str = zend_string_init(ZSTR_VAL(haystack), ZSTR_LEN(haystack), 0);
				}
				memcpy(ZSTR_VAL(new_str) + (r - ZSTR_VAL(haystack)), str, str_len);
				(*replace_count)++;
			}
			if (!new_str) {
				goto nothing_todo;
			}
			return new_str;
		} else {
			size_t count = 0;
			char *o = ZSTR_VAL(haystack);
			char *n = needle;
			char *endp = o + ZSTR_LEN(haystack);

			while ((o = (char*)php_memnstr(o, n, needle_len, endp))) {
				o += needle_len;
				count++;
			}
			if (count == 0) {
				/* Needle doesn't occur, shortcircuit the actual replacement. */
				goto nothing_todo;
			}
			new_str = zend_string_alloc(count * (str_len - needle_len) + ZSTR_LEN(haystack), 0);

			e = s = ZSTR_VAL(new_str);
			end = ZSTR_VAL(haystack) + ZSTR_LEN(haystack);
			for (p = ZSTR_VAL(haystack); (r = (char*)php_memnstr(p, needle, needle_len, end)); p = r + needle_len) {
				memcpy(e, p, r - p);
				e += r - p;
				memcpy(e, str, str_len);
				e += str_len;
				(*replace_count)++;
			}

			if (p < end) {
				memcpy(e, p, end - p);
				e += end - p;
			}

			*e = '\0';
			return new_str;
		}
	} else if (needle_len > ZSTR_LEN(haystack) || memcmp(ZSTR_VAL(haystack), needle, ZSTR_LEN(haystack))) {
nothing_todo:
		return zend_string_copy(haystack);
	} else {
		new_str = zend_string_init(str, str_len, 0);
		(*replace_count)++;
		return new_str;
	}
}
/* }}} */

static void zephir_fast_str_replace(zval *return_value_ptr, zval *search, zval *replace, zval *subject)
{
	zval replace_copy, search_copy;
	int copy_replace = 0, copy_search = 0;
	zend_long replace_count = 0;

	if (Z_TYPE_P(subject) != IS_STRING) {
		ZVAL_NULL(return_value_ptr);
		zend_error(E_WARNING, "Invalid arguments supplied for str_replace()");
		return;
	}

	if (Z_TYPE_P(search) == IS_ARRAY) {
		do {
			zval *params[] = { search, replace, subject };
			ZVAL_NULL(return_value_ptr);
			zephir_call_func_aparams(return_value_ptr, "str_replace", sizeof("str_replace")-1, NULL, 0, 3, params);
			return;
		} while(0);
	}

	if (Z_TYPE_P(replace) != IS_STRING) {
		copy_replace = zend_make_printable_zval(replace, &replace_copy);
		if (copy_replace) {
			replace = &replace_copy;
		}
	}

	if (Z_TYPE_P(search) != IS_STRING) {
		copy_search = zend_make_printable_zval(search, &search_copy);
		if (copy_search) {
			search = &search_copy;
		}
	}

	if (Z_STRLEN_P(subject) == 0) {
		ZVAL_STRINGL(return_value_ptr, "", 0);
		return;
	}

	if (Z_STRLEN_P(search) == 1) {
		ZVAL_STR(return_value_ptr, php_char_to_str_ex(Z_STR_P(subject),
			Z_STRVAL_P(search)[0],
			Z_STRVAL_P(replace),
			Z_STRLEN_P(replace),
			1,
			&replace_count));
	} else {
		if (Z_STRLEN_P(search) > 1) {
			ZVAL_STR(return_value_ptr, php_str_to_str_ex(Z_STR_P(subject),
				Z_STRVAL_P(search), Z_STRLEN_P(search),
				Z_STRVAL_P(replace), Z_STRLEN_P(replace), &replace_count));
		} else {
			ZVAL_STR_COPY(return_value_ptr, Z_STR_P(subject));
		}
	}

	if (copy_replace) {
		zval_dtor(replace);
	}

	if (copy_search) {
		zval_dtor(search);
	}
}

#if defined ZEPHIR_USE_PHP_PCRE && ZEPHIR_USE_PHP_PCRE

static void zephir_preg_match(zval *return_value, zval *regex, zval *subject, zval *matches, int global, long flags, long offset)
{
	int use_copy = 0;
	zval copy, tmp_matches;
	pcre_cache_entry *pce;

	if (Z_TYPE_P(regex) != IS_STRING) {
		zend_error(E_WARNING, "Invalid arguments supplied for zephir_preg_match()");
		RETURN_FALSE;
	}

	if (Z_TYPE_P(subject) != IS_STRING) {
		use_copy = zend_make_printable_zval(subject, &copy);
		if (use_copy) {
			subject = &copy;
		}
	}

	/* Compile regex or get it from cache */
	if ((pce = pcre_get_compiled_regex_cache(Z_STR_P(regex))) == NULL) {

		if (use_copy) {
			zval_dtor(subject);
		}

		RETURN_FALSE;
	}

	ZVAL_UNDEF(&tmp_matches);

	if (flags != 0 || offset != 0) {
		php_pcre_match_impl(pce, Z_STR_P(subject), return_value, &tmp_matches, global, 1, flags, offset);
	} else {
		php_pcre_match_impl(pce, Z_STR_P(subject), return_value, &tmp_matches, global, 0, 0, 0);
	}

	if (matches) {
		zval *php_matches = &tmp_matches;

		zval_dtor(matches);
		ZVAL_DEREF(php_matches);
		ZVAL_COPY(matches, php_matches);
	}

	zval_ptr_dtor(&tmp_matches);

	if (use_copy) {
		zval_dtor(&copy);
	}
}

#else

static void zephir_preg_match(zval *return_value, zval *regex, zval *subject, zval *matches, int global, long flags, long offset)
{
	zval tmp_flags;
	zval tmp_offset;
	zval rv, tmp_matches;
	zval *rvp = return_value ? return_value : &rv;

	ZVAL_NULL(&tmp_flags);
	ZVAL_NULL(&tmp_offset);

	ZVAL_LONG(&tmp_flags, flags);
	ZVAL_LONG(&tmp_offset, offset);

	ZVAL_NULL(&tmp_matches);
	ZVAL_MAKE_REF(&tmp_matches);

	{
		zval *tmp_params[5] = { regex, subject, &tmp_matches, &tmp_flags, &tmp_offset };

		if (global) {
			zephir_call_func_aparams(rvp, SL("preg_match_all"), NULL, 0, 5, tmp_params);
		} else {
			zephir_call_func_aparams(rvp, SL("preg_match"), NULL, 0, 5, tmp_params);
		}
	}

	if (matches) {
		if (Z_TYPE(tmp_matches) == IS_REFERENCE) {
			ZVAL_COPY(matches, Z_REFVAL(tmp_matches));
		} else {
			ZVAL_NULL(matches);
		}
	}

	zval_dtor(&tmp_matches);

	if (!return_value) {
		zval_dtor(&rv);
	}
}

#endif /* ZEPHIR_USE_PHP_PCRE */

#if defined ZEPHIR_USE_PHP_JSON && ZEPHIR_USE_PHP_JSON

static int zephir_json_encode(zval *return_value, zval *v, int opts)
{
	smart_str buf = { 0 };

	php_json_encode(&buf, v, opts);
	smart_str_0(&buf);
	ZVAL_STR(return_value, buf.s);

	return SUCCESS;
}

static int zephir_json_decode(zval *return_value, zval *v, zend_bool assoc)
{
	zval copy;
	int use_copy = 0;

	if (UNEXPECTED(Z_TYPE_P(v) != IS_STRING)) {
		use_copy = zend_make_printable_zval(v, &copy);
		if (use_copy) {
			v = &copy;
		}
	}

	php_json_decode(return_value, Z_STRVAL_P(v), Z_STRLEN_P(v), assoc, 512 /* JSON_PARSER_DEFAULT_DEPTH */);

	if (UNEXPECTED(use_copy)) {
		zval_dtor(&copy);
	}

	return SUCCESS;
}

#else

static int zephir_json_encode(zval *return_value, zval *v, int opts)
{
	zval zopts;
	zval *params[2];

	ZVAL_NULL(&zopts);
	ZVAL_LONG(&zopts, opts);

	params[0] = v;
	params[1] = &zopts;

	return zephir_return_call_function(return_value, SL("json_encode"), NULL, 0, 2, params);
}

static int zephir_json_decode(zval *return_value, zval *v, zend_bool assoc)
{
	zval zassoc;
	zval *params[2];

	ZVAL_NULL(&zassoc);
	ZVAL_BOOL(&zassoc, assoc);

	params[0] = v;
	params[1] = &zassoc;

	return zephir_return_call_function(return_value, SL("json_decode"), NULL, 0, 2, params);
}

#endif /* ZEPHIR_USE_PHP_JSON */

static void zephir_md5(zval *return_value, zval *str)
{
	PHP_MD5_CTX ctx;
	unsigned char digest[16];
	char hexdigest[33];
	zval copy;

	if (Z_TYPE_P(str) != IS_STRING) {
		int use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	PHP_MD5Init(&ctx);
	PHP_MD5Update(&ctx, Z_STRVAL_P(str), Z_STRLEN_P(str));
	PHP_MD5Final(digest, &ctx);

	make_digest(hexdigest, digest);

	ZVAL_STRINGL(return_value, hexdigest, 32);
}

static void zephir_crc32(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;
	size_t nr;
	char *p;
	php_uint32 crc;
	php_uint32 crcinit = 0;

	if (Z_TYPE_P(str) != IS_STRING) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	p = Z_STRVAL_P(str);
	nr = Z_STRLEN_P(str);

	crc = crcinit^0xFFFFFFFF;
	for (; nr--; ++p) {
		crc = ((crc >> 8) & 0x00FFFFFF) ^ crc32tab[(crc ^ (*p)) & 0xFF];
	}

	if (use_copy) {
		zval_dtor(str);
	}

	RETVAL_LONG(crc ^ 0xFFFFFFFF);
}

static void zephir_ucfirst(zval *return_value, zval *s)
{
	zval copy;
	int use_copy = 0;

	if (UNEXPECTED(Z_TYPE_P(s) != IS_STRING)) {
		use_copy = zend_make_printable_zval(s, &copy);
		if (use_copy) {
			s = &copy;
		}
	}

	if (!Z_STRLEN_P(s)) {
		ZVAL_EMPTY_STRING(return_value);
	} else {
		char *c;
		ZVAL_STRINGL(return_value, Z_STRVAL_P(s), Z_STRLEN_P(s));
		c = Z_STRVAL_P(return_value);
		*c = toupper((unsigned char)*c);
	}

	if (UNEXPECTED(use_copy)) {
		zval_dtor(&copy);
	}
}

static void zephir_addslashes(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

    ZVAL_STR(return_value, php_addslashes(Z_STR_P(str)));

	if (UNEXPECTED(use_copy)) {
		zval_dtor(&copy);
	}
}

static void zephir_stripslashes(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	ZVAL_STRINGL(return_value, Z_STRVAL_P(str), Z_STRLEN_P(str));
	php_stripslashes(Z_STR_P(return_value));

	if (UNEXPECTED(use_copy)) {
		zval_dtor(&copy);
	}
}

static void zephir_stripcslashes(zval *return_value, zval *str)
{
	zval copy;
	int use_copy = 0;

	if (UNEXPECTED(Z_TYPE_P(str) != IS_STRING)) {
		use_copy = zend_make_printable_zval(str, &copy);
		if (use_copy) {
			str = &copy;
		}
	}

	ZVAL_STRINGL(return_value, Z_STRVAL_P(str), Z_STRLEN_P(str));
	php_stripcslashes(Z_STR_P(return_value));

	if (UNEXPECTED(use_copy)) {
		zval_dtor(&copy);
	}
}

static int zephir_hash_equals(const zval *known_zval, const zval *user_zval)
{
	char *known_str, *user_str;
	int result = 0;
	size_t j;

	if (Z_TYPE_P(known_zval) != IS_STRING || Z_TYPE_P(user_zval) != IS_STRING) {
		return 0;
	}

	if (Z_STRLEN_P(known_zval) != Z_STRLEN_P(user_zval)) {
		return 0;
	}

	known_str = Z_STRVAL_P(known_zval);
	user_str = Z_STRVAL_P(user_zval);

	for (j = 0; j < Z_STRLEN_P(known_zval); j++) {
		result |= known_str[j] ^ user_str[j];
	}

	return (int) (result == 0);
}

static void zephir_string_to_hex(zval *return_value, zval *var)
{
	int use_copy = 0;
	zval copy;
	size_t i;
	char *s;
	zend_string *res;

	if (Z_TYPE_P(var) != IS_STRING) {
		use_copy = zend_make_printable_zval(var, &copy);
		if (use_copy) {
			var = &copy;
		}
	}

	res = zend_string_alloc(2*Z_STRLEN_P(var) + 1, 0);
	s   = Z_STRVAL_P(var);
	for (i=0; i<Z_STRLEN_P(var); ++i) {
		sprintf(res->val + 2*i, "%hhX", (unsigned char) s[i]);
	}

	res->val[2*Z_STRLEN_P(var)] = 0;
	res->len = 2*Z_STRLEN_P(var);
	zend_string_forget_hash_val(res);
	ZVAL_STR(return_value, res);

	if (use_copy) {
		zval_dtor(var);
	}
}






static int zephir_has_constructor_ce(const zend_class_entry *ce)
{
	do {
		if (ce->constructor != NULL) {
			return 1;
		}

		ce = ce->parent;
	} while (ce);

	return 0;
}

static int zephir_make_fcall_key(zend_string* s, zephir_call_type type, zend_class_entry *ce, zval *function, const zend_class_entry* called_scope)
{
	const zend_class_entry *calling_scope;
	unsigned char t;

	calling_scope = zend_get_executed_scope();

	switch (type) {
		case zephir_fcall_parent:
			if (UNEXPECTED(!calling_scope || !calling_scope->parent)) {
				return FAILURE;
			}

			calling_scope = calling_scope->parent;
			break;

		case zephir_fcall_static:
			calling_scope = called_scope;
			if (UNEXPECTED(!calling_scope)) {
				return FAILURE;
			}

			break;

		case zephir_fcall_self:
			/* EG(scope) */
			break;

		case zephir_fcall_function:
			if (Z_TYPE_P(function) == IS_OBJECT) {
				return FAILURE;
			}

			calling_scope = NULL;
			called_scope  = NULL;
			break;

		case zephir_fcall_ce:
			calling_scope = ce;
			called_scope  = ce;
			break;

		case zephir_fcall_method:
			if (Z_TYPE_P(function) == IS_OBJECT) {
				return FAILURE;
			}

			calling_scope = ce;
			called_scope  = ce;
			break;

		default:
			return FAILURE;
	}

	if (called_scope == calling_scope) {
	/* Calls within the same scope, this won't trigger magic methods or failures due to restricted visibility */
		t = 0;
	}
	else if (called_scope && calling_scope && (instanceof_function(called_scope, calling_scope) || instanceof_function(calling_scope, called_scope))) {
	/* Calls within the same chain of inheritance; can call protected methods */
		t = 1;
	}
	else {
	/* Can safely call only public methods */
		t = 2;
	}

	{
		char* cls      = calling_scope ? ZSTR_VAL(calling_scope->name) : "";
		size_t cls_len = calling_scope ? ZSTR_LEN(calling_scope->name) : 0;
		char* mth      = NULL;
		size_t mth_len = 0;
		char* buf;

		if (Z_TYPE_P(function) == IS_STRING) {
			mth     = Z_STRVAL_P(function);
			mth_len = Z_STRLEN_P(function);
		}
		else if (Z_TYPE_P(function) == IS_ARRAY) {
			zval *method;
			HashTable *function_hash = Z_ARRVAL_P(function);
			if (
					function_hash->nNumOfElements == 2
				 && ((method = zend_hash_index_find(function_hash, 1)) != NULL)
				 && Z_TYPE_P(method) == IS_STRING
			) {
				mth     = Z_STRVAL_P(method);
				mth_len = Z_STRLEN_P(method);
			}
		}

		if (cls_len + 1 + mth_len + sizeof(unsigned char) > 255) {
			return FAILURE;
		}

		ZSTR_LEN(s) = cls_len + 1 + mth_len + sizeof(unsigned char);
		buf = ZSTR_VAL(s);
		zend_str_tolower_copy(buf, cls, cls_len + 1);
		zend_str_tolower_copy(buf + cls_len + 1, mth, mth_len);
		buf[cls_len + 1 + mth_len] = t;
		buf[cls_len + 1 + mth_len + sizeof(t)] = '\0';
	}

	ZSTR_H(s) = zend_hash_func(ZSTR_VAL(s), ZSTR_LEN(s));
	return SUCCESS;
}

static void resolve_callable(zval* retval, zephir_call_type type, zend_class_entry *ce, zval *object, zval *function)
{
	if (type == zephir_fcall_function || IS_ARRAY == Z_TYPE_P(function) || IS_OBJECT == Z_TYPE_P(function)) {
		ZVAL_COPY(retval, function);
		return;
	}

	array_init_size(retval, 2);
	zend_hash_real_init(Z_ARRVAL_P(retval), 1);
	ZEND_HASH_FILL_PACKED(Z_ARRVAL_P(retval)) {
		zval q;
		switch (type) {
			case zephir_fcall_parent:
				zend_string_addref(i_parent);
				ZVAL_STR(&q, i_parent);
				ZEND_HASH_FILL_ADD(&q);
				break;

			case zephir_fcall_self:
				zend_string_addref(i_self);
				ZVAL_STR(&q, i_self);
				ZEND_HASH_FILL_ADD(&q);
				break;

			case zephir_fcall_static:
				zend_string_addref(i_static);
				ZVAL_STR(&q, i_static);
				ZEND_HASH_FILL_ADD(&q);
				break;

			case zephir_fcall_ce:
				assert(ce);
				zend_string_addref(ce->name);
				ZVAL_STR(&q, ce->name);
				ZEND_HASH_FILL_ADD(&q);
				break;

			default:
				assert(object);
				Z_TRY_ADDREF_P(object);
				ZEND_HASH_FILL_ADD(object);
				break;
		}

		Z_TRY_ADDREF_P(function);
		ZEND_HASH_FILL_ADD(function);
	} ZEND_HASH_FILL_END();
}

static void populate_fcic(zend_fcall_info_cache* fcic, zephir_call_type type, zend_class_entry* ce, zval *this_ptr, zval *func, zend_class_entry* called_scope)
{
	zend_class_entry* calling_scope;

	fcic->function_handler = NULL;

	if (type == zephir_fcall_function && Z_TYPE_P(func) == IS_STRING) {
		fcic->called_scope  = NULL;
		fcic->calling_scope = NULL;
		fcic->object        = NULL;
		return;
	}

	fcic->called_scope = called_scope;
	calling_scope = zend_get_called_scope(EG(current_execute_data));
	fcic->object = this_ptr ? Z_OBJ_P(this_ptr) : NULL;
	switch (type) {
		case zephir_fcall_parent:
			if (ce && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&ce->parent->function_table, Z_STR_P(func));
				fcic->calling_scope = ce->parent;
			} else if (EXPECTED(calling_scope && calling_scope->parent)) {
				if (Z_TYPE_P(func) == IS_STRING) {
					fcic->function_handler = zend_hash_find_ptr(&calling_scope->parent->function_table, Z_STR_P(func));
				}
				fcic->calling_scope = calling_scope->parent;
			} else {
				return;
			}

			if (UNEXPECTED(!calling_scope || !calling_scope->parent)) {
				return;
			}

			fcic->calling_scope = calling_scope->parent;
			break;

		case zephir_fcall_static:
			if (ce && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&ce->function_table, Z_STR_P(func));
				fcic->calling_scope = ce;
			} else if (calling_scope && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&calling_scope->function_table, Z_STR_P(func));
				fcic->calling_scope = called_scope;
			}

			break;

		case zephir_fcall_self:
			if (ce && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&ce->function_table, Z_STR_P(func));
				fcic->calling_scope = ce;
			} else if (calling_scope && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&calling_scope->function_table, Z_STR_P(func));
				// TODO: Review when error will be enabled in zend_is_callable_ex() calls
				//fcic->object = zend_get_this_object(EG(current_execute_data));
				//fcic->called_scope = zend_get_called_scope(EG(current_execute_data));
				fcic->calling_scope = calling_scope;
			}
			break;

		case zephir_fcall_ce:
			if (ce && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&ce->function_table, Z_STR_P(func));

				fcic->calling_scope = ce;
			} else if (calling_scope && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&calling_scope->function_table, Z_STR_P(func));
				fcic->calling_scope = calling_scope;
			}
			// TODO: Check for PHP 7.4 and PHP 8.0, as it rewrite from above
			fcic->calling_scope = ce;
			fcic->called_scope  = ce;
			break;

		case zephir_fcall_function:
		case zephir_fcall_method:
			if (Z_TYPE_P(func) == IS_OBJECT) {
				if (Z_OBJ_HANDLER_P(func, get_closure) && Z_OBJ_HANDLER_P(func, get_closure)(Z_OBJ_P(func), &fcic->calling_scope, &fcic->function_handler, &fcic->object, 0) == SUCCESS) {
					fcic->called_scope = fcic->calling_scope;
					break;
				}

				return;
			}

			if (ce && Z_TYPE_P(func) == IS_STRING) {
				fcic->function_handler = zend_hash_find_ptr(&ce->function_table, Z_STR_P(func));
			}
			fcic->calling_scope = this_ptr ? Z_OBJCE_P(this_ptr) : NULL;
			fcic->called_scope  = fcic->calling_scope;
			break;

		default:
			return;
	}
}

static int zephir_call_user_function(
    zval *object_pp,
    zend_class_entry *obj_ce,
    zephir_call_type type,
	zval *function_name,
	zval *retval_ptr,
	zephir_fcall_cache_entry **cache_entry,
	int cache_slot,
	uint32_t param_count,
	zval *params[]
) {
	zval local_retval_ptr;
	int status;
	zend_fcall_info fci;
	zend_fcall_info_cache fcic;
	zend_zephir_globals_def *zephir_globals_ptr = ZEPHIR_VGLOBAL;
	char fcall_key[sizeof(zend_string) + 256];
	int key_ok = FAILURE;
	zephir_fcall_cache_entry *temp_cache_entry = NULL;
	zval callable;
	zend_class_entry* called_scope = zend_get_called_scope(EG(current_execute_data));

	assert(obj_ce || !object_pp);
	ZVAL_UNDEF(&callable);
	ZVAL_UNDEF(&local_retval_ptr);

	if ((!cache_entry || !*cache_entry) && zephir_globals_ptr->cache_enabled) {
		int reload_cache = 1;
		if (cache_slot > 0 && zephir_globals_ptr->scache[cache_slot]) {
			reload_cache = 0;
			temp_cache_entry = zephir_globals_ptr->scache[cache_slot];
			if (cache_entry) {
				*cache_entry = temp_cache_entry;
			}
		}

		if (reload_cache) {
			key_ok = zephir_make_fcall_key((zend_string*)fcall_key, type, (object_pp && type != zephir_fcall_ce ? Z_OBJCE_P(object_pp) : obj_ce), function_name, called_scope);
			if (SUCCESS == key_ok) {
				zend_string* zs = (zend_string*)fcall_key;

				GC_SET_REFCOUNT(zs, 1);
				GC_TYPE_INFO(zs) = IS_STRING;

				temp_cache_entry = zend_hash_find_ptr(zephir_globals_ptr->fcache, zs);
				if (temp_cache_entry) {
					cache_entry = &temp_cache_entry;
				}
			}
		}
	}

	fci.size        = sizeof(fci);
	fci.object      = object_pp ? Z_OBJ_P(object_pp) : NULL;
	ZVAL_COPY_VALUE(&fci.function_name, function_name);
	fci.retval      = retval_ptr ? retval_ptr : &local_retval_ptr;
	fci.param_count = param_count;
	fci.named_params = NULL;

	if (cache_entry && *cache_entry) {
		/* We have a cache record, initialize scope */
		populate_fcic(&fcic, type, obj_ce, object_pp, function_name, called_scope);
		if (!fcic.function_handler) {
			fcic.function_handler = *cache_entry;
		}

		ZVAL_UNDEF(&fci.function_name);
	} else if ((cache_entry && !*cache_entry) || zephir_globals_ptr->cache_enabled) {
		/* The caller is interested in caching OR we have the call cache enabled */
		resolve_callable(&callable, type, (object_pp && type != zephir_fcall_ce ? Z_OBJCE_P(object_pp) : obj_ce), object_pp, function_name);

		char *is_callable_error = NULL;
		zend_execute_data *frame = EG(current_execute_data);
#if PHP_VERSION_ID >= 80200
		if (obj_ce || !zend_is_callable_at_frame(&callable, fci.object, frame, IS_CALLABLE_SUPPRESS_DEPRECATIONS, &fcic, &is_callable_error)) {
#else
		if (obj_ce || !zend_is_callable_at_frame(&callable, fci.object, frame, 0, &fcic, &is_callable_error)) {
#endif
			if (is_callable_error) {
				zend_error(E_WARNING, "%s", is_callable_error);
				efree(is_callable_error);

				return FAILURE;
			}

			populate_fcic(&fcic, type, obj_ce, object_pp, function_name, called_scope);
		}
	}

#ifdef _MSC_VER
	zval *p = emalloc(sizeof(zval) * (fci.param_count + 1));
#else
	zval p[fci.param_count];
#endif

	uint32_t i;
	for (i = 0; i < fci.param_count; ++i) {
		ZVAL_COPY_VALUE(&p[i], params[i]);
	}

	fci.params = p;
	if (!fcic.function_handler) {
		ZVAL_COPY_VALUE(&fci.function_name, &callable);
	}

	status = zend_call_function(&fci, &fcic);

#ifdef _MSC_VER
	efree(p);
#endif

	if (Z_TYPE(callable) != IS_UNDEF) {
		zval_ptr_dtor(&callable);
	}

	/* Skip caching IF:
	 * call failed OR there was an exception (to be safe) OR cache key is not defined OR
	 * fcall cache was de-initialized OR we have a slot cache
	 */
	int initialized = 1;

	if (EXPECTED(status != FAILURE) && !EG(exception) && SUCCESS == key_ok && initialized && !temp_cache_entry) {
		zephir_fcall_cache_entry *cache_entry_temp = fcic.function_handler;

		if (cache_entry) {
			*cache_entry = cache_entry_temp;
			if (cache_slot > 0) {
				zephir_globals_ptr->scache[cache_slot] = *cache_entry;
			}
		}

		if (zephir_globals_ptr->cache_enabled) {
			zend_string *zs = (zend_string*)fcall_key;
			zend_hash_str_add_ptr(zephir_globals_ptr->fcache, ZSTR_VAL(zs), ZSTR_LEN(zs), cache_entry_temp);
		}
	}

	if (!retval_ptr) {
		zval_ptr_dtor(&local_retval_ptr);
	} else if (FAILURE == status || EG(exception)) {
		ZVAL_NULL(retval_ptr);
	} else if (Z_TYPE_P(retval_ptr) == IS_ARRAY) {
		SEPARATE_ARRAY(retval_ptr);
	}

	return status;
}

static int zephir_call_func_aparams(zval *return_value_ptr, const char *func_name, uint32_t func_length,
	zephir_fcall_cache_entry **cache_entry, int cache_slot,
	uint32_t param_count, zval **params)
{
	int status;
	zval rv, *rvp = return_value_ptr ? return_value_ptr : &rv;

	ZVAL_UNDEF(&rv);

#ifndef ZEPHIR_RELEASE
	if (return_value_ptr != NULL && Z_TYPE_P(return_value_ptr) > IS_NULL) {
		fprintf(stderr, "%s: *return_value_ptr must be NULL\n", __func__);
		zephir_print_backtrace();
		abort();
	}
#endif

	zval f;
	ZVAL_STRINGL(&f, func_name, func_length);
	status = zephir_call_user_function(NULL, NULL, zephir_fcall_function, &f, rvp, cache_entry, cache_slot, param_count, params);
	zval_ptr_dtor(&f);

	if (status == FAILURE && !EG(exception)) {
		zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined function %s()", func_name);
	} else if (EG(exception)) {
		status = FAILURE;
	}

	if (!return_value_ptr) {
		zval_ptr_dtor(&rv);
	}

	return status;
}

static int zephir_call_zval_func_aparams(zval *return_value_ptr, zval *func_name,
	zephir_fcall_cache_entry **cache_entry, int cache_slot,
	uint32_t param_count, zval **params)
{
	int status;
	zval rv, *rvp = return_value_ptr ? return_value_ptr : &rv;

	ZVAL_UNDEF(&rv);

#ifndef ZEPHIR_RELEASE
	if (return_value_ptr != NULL && Z_TYPE_P(return_value_ptr) > IS_NULL) {
		fprintf(stderr, "%s: *return_value_ptr must be NULL\n", __func__);
		zephir_print_backtrace();
		abort();
	}
#endif

	status = zephir_call_user_function(NULL, NULL, zephir_fcall_function, func_name, rvp, cache_entry, cache_slot, param_count, params);

	if (status == FAILURE && !EG(exception)) {
		zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined function %s()", Z_TYPE_P(func_name) == IS_STRING ? Z_STRVAL_P(func_name) : "undefined");
	} else if (EG(exception)) {
		status = FAILURE;
	}

	if (!return_value_ptr) {
		zval_ptr_dtor(&rv);
	}

	return status;
}

static int zephir_call_class_method_aparams(
    zval *return_value,
    zend_class_entry *ce,
    zephir_call_type type,
    zval *object,
	const char *method_name,
	uint32_t method_len,
	zephir_fcall_cache_entry **cache_entry,
	int cache_slot,
	uint32_t param_count,
	zval **params
) {
	int status;

#ifndef ZEPHIR_RELEASE
	if (return_value != NULL && Z_TYPE_P(return_value) > IS_NULL) {
		fprintf(stderr, "%s: *return_value must be IS_NULL or IS_UNDEF\n", __func__);
		zephir_print_backtrace();
		abort();
	}
#endif

	if (object && Z_TYPE_P(object) != IS_OBJECT) {
		zephir_throw_exception_format(spl_ce_RuntimeException, "Trying to call method %s on a non-object", method_name);
		if (return_value) {
			ZVAL_NULL(return_value);
		}
		return FAILURE;
	}

	zval method;
	ZVAL_STRINGL(&method, method_name, method_len);
	status = zephir_call_user_function(object, ce, type, &method, return_value, cache_entry, cache_slot, param_count, params);
	zval_ptr_dtor(&method);

	if (status == FAILURE && !EG(exception)) {
		switch (type) {
			case zephir_fcall_parent:
				zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined method parent::%s()", method_name);
				break;

			case zephir_fcall_self:
				zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined method self::%s()", method_name);
				break;

			case zephir_fcall_static:
				zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined method static::%s()", method_name);
				break;

			case zephir_fcall_ce:
			case zephir_fcall_method:
				zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined method %s::%s()", ZSTR_VAL(ce->name), method_name);
				break;

			default:
				zephir_throw_exception_format(spl_ce_RuntimeException, "Call to undefined method ?::%s()", method_name);
		}
	} else if (EG(exception)) {
		status = FAILURE;
	}

	return status;
}

static int zephir_call_user_func_array_noex(zval *return_value, zval *handler, zval *params)
{
	zend_fcall_info fci;
	zend_fcall_info_cache fci_cache;
	char *is_callable_error = NULL;
	int status = FAILURE;

	if (params && Z_TYPE_P(params) != IS_ARRAY) {
		ZVAL_NULL(return_value);
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_call_user_func_array_noex()");
		return FAILURE;
	}

	zend_execute_data *frame = EG(current_execute_data);
#if PHP_VERSION_ID >= 80200
	if (!zend_is_callable_at_frame(handler, NULL, frame, IS_CALLABLE_SUPPRESS_DEPRECATIONS, &fci_cache, &is_callable_error)) {
#else
	if (!zend_is_callable_at_frame(handler, NULL, frame, 0, &fci_cache, &is_callable_error)) {
#endif
		if (is_callable_error) {
			zend_error(E_WARNING, "%s", is_callable_error);
			efree(is_callable_error);
		}

		return FAILURE;
	}

	fci.size = sizeof(fci);
	fci.object = fci_cache.object;
	ZVAL_COPY_VALUE(&fci.function_name, handler);
	fci.param_count = 0;
	fci.params = NULL;
	fci.retval = return_value;
	fci.named_params = NULL;

	zend_fcall_info_args(&fci, params);
	status = zend_call_function(&fci, &fci_cache);
	zend_fcall_info_args_clear(&fci, 1);

	return status;
}

static void zephir_eval_php(zval *str, zval *retval_ptr, char *context)
{
	zval local_retval;
	zend_op_array *new_op_array = NULL;
	uint32_t original_compiler_options;

	ZVAL_UNDEF(&local_retval);

	original_compiler_options = CG(compiler_options);
	CG(compiler_options) = ZEND_COMPILE_DEFAULT_FOR_EVAL;
#if PHP_VERSION_ID >= 80200
	new_op_array = zend_compile_string(Z_STR_P(str), context, ZEND_COMPILE_POSITION_AFTER_OPEN_TAG);
#else
	new_op_array = zend_compile_string(Z_STR_P(str), context);
#endif

	CG(compiler_options) = original_compiler_options;

	if (new_op_array) {
		EG(no_extensions) = 1;
		zend_try {
			zend_execute(new_op_array, &local_retval);
		} zend_catch {
			destroy_op_array(new_op_array);
			efree_size(new_op_array, sizeof(zend_op_array));
			zend_bailout();
		} zend_end_try();
		EG(no_extensions) = 0;

		if (Z_TYPE(local_retval) != IS_UNDEF) {
			if (retval_ptr) {
				ZVAL_COPY_VALUE(retval_ptr, &local_retval);
			} else {
				zval_ptr_dtor(&local_retval);
			}
		} else if (retval_ptr) {
			ZVAL_NULL(retval_ptr);
		}

		destroy_op_array(new_op_array);
		efree_size(new_op_array, sizeof(zend_op_array));
	}
}



#ifdef HAVE_CONFIG_H
#endif



#ifndef ENFORCE_SAFE_MODE
#define ENFORCE_SAFE_MODE    0
#endif

static int zephir_require_ret(zval *return_value_ptr, const char *require_path)
{
	zend_file_handle file_handle;
	zend_op_array *new_op_array;
	zval dummy, local_retval;
	int ret;

	ZVAL_UNDEF(&local_retval);

#ifndef ZEPHIR_RELEASE
	if (return_value_ptr != NULL && Z_TYPE_P(return_value_ptr) > IS_NULL) {
		fprintf(stderr, "%s: *return_value_ptr is expected to be NULL", __func__);
		zephir_print_backtrace();
		abort();
	}
#endif

#if PHP_VERSION_ID >= 80100
	zend_string *zend_string_path = zend_string_init(require_path, strlen(require_path), 0);

	zend_stream_init_filename_ex(&file_handle, zend_string_path);
    ret = php_stream_open_for_zend_ex(&file_handle, USE_PATH|STREAM_OPEN_FOR_INCLUDE);

    zval_ptr_dtor(zend_string_path);
#else
	ret = php_stream_open_for_zend_ex(require_path, &file_handle, USE_PATH|STREAM_OPEN_FOR_INCLUDE);
#endif
    if (ret != SUCCESS) {
        return FAILURE;
    }

	new_op_array = zend_compile_file(&file_handle, ZEND_REQUIRE);
	if (new_op_array) {
		if (file_handle.handle.stream.handle) {
			ZVAL_NULL(&dummy);
			if (!file_handle.opened_path) {
				file_handle.opened_path = zend_string_init(require_path, strlen(require_path), 0);
			}

			zend_hash_add(&EG(included_files), file_handle.opened_path, &dummy);
			zend_destroy_file_handle(&file_handle);
		}

		new_op_array->scope = EG(fake_scope) ? EG(fake_scope) : zend_get_executed_scope();
		zend_execute(new_op_array, &local_retval);

		if (return_value_ptr) {
			zval_ptr_dtor(return_value_ptr);
			ZVAL_COPY_VALUE(return_value_ptr, &local_retval);
		} else {
			zval_ptr_dtor(&local_retval);
		}

		destroy_op_array(new_op_array);
		efree_size(new_op_array, sizeof(zend_op_array));

		if (EG(exception)) {
			ret = FAILURE;
		} else {
			ret = SUCCESS;
		}

		return ret;
	} else {
		zend_destroy_file_handle(&file_handle);
	}

	return FAILURE;
}

static int zephir_require_once_ret(zval *return_value_ptr, const char *require_path)
{
	zend_file_handle file_handle;
	zend_op_array *new_op_array;
	zval dummy, local_retval;
	int ret;

	ZVAL_UNDEF(&local_retval);

#ifndef ZEPHIR_RELEASE
	if (return_value_ptr != NULL && Z_TYPE_P(return_value_ptr) > IS_NULL) {
		fprintf(stderr, "%s: *return_value_ptr is expected to be NULL", __func__);
		zephir_print_backtrace();
		abort();
	}
#endif

#if PHP_VERSION_ID >= 80100
	zend_string *zend_string_path = zend_string_init(require_path, strlen(require_path), 0);

	zend_stream_init_filename_ex(&file_handle, zend_string_path);
    ret = php_stream_open_for_zend_ex(&file_handle, USE_PATH|STREAM_OPEN_FOR_INCLUDE);

    zval_ptr_dtor(zend_string_path);
#else
	ret = php_stream_open_for_zend_ex(require_path, &file_handle, USE_PATH|STREAM_OPEN_FOR_INCLUDE);
#endif
    if (ret != SUCCESS) {
        return FAILURE;
    }

	if (zend_hash_exists(&EG(included_files), file_handle.opened_path)) {
		zend_destroy_file_handle(&file_handle);

		if (return_value_ptr) {
			ZVAL_TRUE(&local_retval);

			zval_ptr_dtor(return_value_ptr);
			ZVAL_COPY_VALUE(return_value_ptr, &local_retval);
		} else {
			zval_ptr_dtor(&local_retval);
		}

		return SUCCESS;
	}

	new_op_array = zend_compile_file(&file_handle, ZEND_INCLUDE);
	if (new_op_array) {
		if (file_handle.handle.stream.handle) {
			ZVAL_NULL(&dummy);
			if (!file_handle.opened_path) {
				file_handle.opened_path = zend_string_init(require_path, strlen(require_path), 0);
			}

			zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);
			zend_destroy_file_handle(&file_handle);
		}

		new_op_array->scope = EG(fake_scope) ? EG(fake_scope) : zend_get_executed_scope();
		zend_execute(new_op_array, &local_retval);

		if (return_value_ptr) {
			zval_ptr_dtor(return_value_ptr);
			ZVAL_COPY_VALUE(return_value_ptr, &local_retval);
		} else {
			zval_ptr_dtor(&local_retval);
		}

		destroy_op_array(new_op_array);
		efree_size(new_op_array, sizeof(zend_op_array));

		if (EG(exception)) {
			ret = FAILURE;
		} else {
			ret = SUCCESS;
		}

		return ret;
	} else {
		zend_destroy_file_handle(&file_handle);
	}

	return FAILURE;
}



#ifdef HAVE_CONFIG_H
#endif




#define PHP_STREAM_TO_ZVAL(stream, arg) \
	php_stream_from_zval_no_verify(stream, arg); \
	if (stream == NULL) {   \
		if (return_value) { \
			RETURN_FALSE;   \
		} else { \
			return; \
		} \
	}

static void zephir_basename(zval *return_value, zval *path)
{
	if (EXPECTED(Z_TYPE_P(path) == IS_STRING)) {
		zend_string *ret;
		ret = php_basename(Z_STRVAL_P(path), Z_STRLEN_P(path), NULL, 0);
		ZVAL_STR(return_value, ret);
	} else {
		ZVAL_FALSE(return_value);
	}
}

static int zephir_file_exists(zval *filename)
{
	zval return_value;

	if (Z_TYPE_P(filename) != IS_STRING) {
		return FAILURE;
	}

#if PHP_VERSION_ID >= 80100
	zend_string *file = zend_string_init(Z_STRVAL_P(filename), Z_STRLEN_P(filename), 0);
	php_stat(file, FS_EXISTS, &return_value);
	zval_ptr_dtor(file);
#else
	php_stat(Z_STRVAL_P(filename), (php_stat_len) Z_STRLEN_P(filename), FS_EXISTS, &return_value);
#endif

	if (Z_TYPE(return_value) != IS_TRUE) {
		return FAILURE;
	}

	return SUCCESS;
}

static int zephir_compare_mtime(zval *filename1, zval *filename2)
{
	php_stream_statbuf statbuffer1, statbuffer2;

	if (Z_TYPE_P(filename1) != IS_STRING || Z_TYPE_P(filename2) != IS_STRING) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for compare_mtime()");
		return 0;
	}

	if (php_stream_stat_path_ex(Z_STRVAL_P(filename1), 0, &statbuffer1, NULL)) {
		php_error_docref(NULL, E_WARNING, "mstat failed for %s", Z_STRVAL_P(filename1));
		return 0;
	}

	if (php_stream_stat_path_ex(Z_STRVAL_P(filename2), 0, &statbuffer2, NULL)) {
		php_error_docref(NULL, E_WARNING, "mstat failed for %s", Z_STRVAL_P(filename2));
		return 0;
	}

	return (int) (statbuffer1.sb.st_mtime >= statbuffer2.sb.st_mtime);
}

static void zephir_fwrite(zval *return_value, zval *stream_zval, zval *data)
{
	int num_bytes;
	php_stream *stream;

	if (Z_TYPE_P(stream_zval) != IS_RESOURCE) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_fwrite()");
		if (return_value) {
			RETVAL_FALSE;
		} else {
			return;
		}
	}

	if (Z_TYPE_P(data) != IS_STRING) {
		/* @todo convert data to string */
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_fwrite()");
		if (return_value) {
			RETVAL_FALSE;
		} else {
			return;
		}
	}

	if (!Z_STRLEN_P(data)) {
		if (return_value) {
			RETURN_LONG(0);
		} else {
			return;
		}
	}

	PHP_STREAM_TO_ZVAL(stream, stream_zval);

	num_bytes = php_stream_write(stream, Z_STRVAL_P(data), Z_STRLEN_P(data));
	if (return_value) {
		RETURN_LONG(num_bytes);
	}
}

static int zephir_feof(zval *stream_zval)
{
	php_stream *stream;

	if (Z_TYPE_P(stream_zval) != IS_RESOURCE) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_feof()");
		return 0;
	}

	php_stream_from_zval_no_verify(stream, stream_zval);
	if (stream == NULL) {
		return 0;
	}

	return php_stream_eof(stream);
}

static int zephir_fclose(zval *stream_zval)
{
	php_stream *stream;

	if (Z_TYPE_P(stream_zval) != IS_RESOURCE) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_fclose()");
		return 0;
	}

	if ((stream = (php_stream*)zend_fetch_resource2(Z_RES_P(stream_zval), "stream", php_file_le_stream(), php_file_le_pstream())) == NULL) {
		return 0;
	}

	if ((stream->flags & PHP_STREAM_FLAG_NO_FCLOSE) != 0) {
		php_error_docref(NULL, E_WARNING, "%d is not a valid stream resource", stream->res->handle);
		return 0;
	}

	php_stream_free(stream, PHP_STREAM_FREE_KEEP_RSRC | (stream->is_persistent ? PHP_STREAM_FREE_CLOSE_PERSISTENT : PHP_STREAM_FREE_CLOSE));

	return 1;
}

static void zephir_file_get_contents(zval *return_value, zval *filename)
{
	zend_string *contents;
	php_stream *stream;
	long maxlen = PHP_STREAM_COPY_ALL;
	zval *zcontext = NULL;
	php_stream_context *context = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_file_get_contents()");
		RETVAL_FALSE;
		return;
	}

	context = php_stream_context_from_zval(zcontext, 0);

	stream = php_stream_open_wrapper_ex(Z_STRVAL_P(filename), "rb", 0 | REPORT_ERRORS, NULL, context);
	if (!stream) {
		RETURN_FALSE;
	}

	if ((contents = php_stream_copy_to_mem(stream, maxlen, 0)) != NULL) {
		RETVAL_STR(contents);
	} else {
		RETVAL_EMPTY_STRING();
	}

	php_stream_close(stream);
}

static void zephir_file_put_contents(zval *return_value, zval *filename, zval *data)
{
	php_stream *stream;
	int numbytes = 0, use_copy = 0;
	zval *zcontext = NULL;
	zval copy;
	php_stream_context *context = NULL;

	if (Z_TYPE_P(filename) != IS_STRING) {
		php_error_docref(NULL, E_WARNING, "Invalid arguments supplied for zephir_file_put_contents()");
		if (return_value) {
			RETVAL_FALSE;
		}
		return;
	}

	context = php_stream_context_from_zval(zcontext, 0 & PHP_FILE_NO_DEFAULT_CONTEXT);

	stream = php_stream_open_wrapper_ex(Z_STRVAL_P(filename), "wb", ((0 & PHP_FILE_USE_INCLUDE_PATH) ? USE_PATH : 0) | REPORT_ERRORS, NULL, context);
	if (stream == NULL) {
		if (return_value) {
			RETURN_FALSE;
		}
		return;
	}

	switch (Z_TYPE_P(data)) {
		case IS_NULL:
		case IS_LONG:
		case IS_DOUBLE:
		case IS_TRUE:
		case IS_FALSE:
		case IS_CONSTANT_AST:
			use_copy = zend_make_printable_zval(data, &copy);
			if (use_copy) {
				data = &copy;
			}
			/* no break */

		case IS_STRING:
			if (Z_STRLEN_P(data)) {
				numbytes = php_stream_write(stream, Z_STRVAL_P(data), Z_STRLEN_P(data));
				if (numbytes != Z_STRLEN_P(data)) {
					php_error_docref(NULL, E_WARNING, "Only %d of %zu bytes written, possibly out of free disk space", numbytes, Z_STRLEN_P(data));
					numbytes = -1;
				}
			}
			break;
		default:
			numbytes = -1;
			break;
	}

	php_stream_close(stream);

	if (use_copy) {
		zval_dtor(data);
	}

	if (numbytes < 0) {
		if (return_value) {
			RETURN_FALSE;
		} else {
			return;
		}
	}

	if (return_value) {
		RETURN_LONG(numbytes);
	}
	return;
}

static void zephir_filemtime(zval *return_value, zval *path)
{
	if (EXPECTED(Z_TYPE_P(path) == IS_STRING)) {
#if PHP_VERSION_ID >= 80100
		zend_string *file = zend_string_init(Z_STRVAL_P(path), Z_STRLEN_P(path), 0);
		php_stat(file, FS_MTIME, return_value);
		zval_ptr_dtor(file);
#else
		php_stat(Z_STRVAL_P(path), (php_stat_len)(Z_STRLEN_P(path)), FS_MTIME, return_value);
#endif
	} else {
		ZVAL_FALSE(return_value);
	}
}

static void zephir_prepare_virtual_path(zval *return_value, zval *path, zval *virtual_separator)
{
	unsigned int i;
	unsigned char ch;
	smart_str virtual_str = {0};

	if (Z_TYPE_P(path) != IS_STRING || Z_TYPE_P(virtual_separator) != IS_STRING) {
		if (Z_TYPE_P(path) == IS_STRING) {
			RETURN_STR(zval_get_string(path));
		} else {
			RETURN_EMPTY_STRING();
		}
		return;
	}

	for (i = 0; i < Z_STRLEN_P(path); i++) {
		ch = Z_STRVAL_P(path)[i];
		if (ch == '\0') {
			break;
		}
		if (ch == '/' || ch == '\\' || ch == ':') {
			smart_str_appendl(&virtual_str, Z_STRVAL_P(virtual_separator), Z_STRLEN_P(virtual_separator));
		}
		else {
			smart_str_appendc(&virtual_str, tolower(ch));
		}
	}

	smart_str_0(&virtual_str);

	if (virtual_str.s) {
		RETURN_STR(virtual_str.s);
	} else {
		RETURN_EMPTY_STRING();
	}
}

static void zephir_unique_path_key(zval *return_value, zval *path)
{
	unsigned long h;
	char *strKey;

	if (Z_TYPE_P(path) != IS_STRING) {
		return;
	}

	h = zend_hash_func(Z_STRVAL_P(path), Z_STRLEN_P(path) + 1);

	strKey = emalloc(24);
	sprintf(strKey, "v%lu", h);

	RETVAL_STRING(strKey);
	efree(strKey);
}



#ifdef HAVE_CONFIG_H
#endif




static void zephir_concat_self(zval *left, zval *right)
{
	zval left_copy, right_copy;
	size_t length, left_length, right_length;
	int use_copy_left = 0, use_copy_right = 0;
	zend_string *target;

	if (Z_TYPE_P(right) != IS_STRING) {
		use_copy_right = zephir_make_printable_zval(right, &right_copy);
		if (use_copy_right) {
			right = &right_copy;
		}
	}

	if (Z_TYPE_P(left) == IS_NULL) {
		ZVAL_STRINGL(left, Z_STRVAL_P(right), Z_STRLEN_P(right));

		if (use_copy_right) {
			zval_dtor(&right_copy);
		}

		return;
	}

	if (Z_TYPE_P(left) != IS_STRING) {
		use_copy_left = zephir_make_printable_zval(left, &left_copy);
		if (use_copy_left) {
			ZEPHIR_CPY_WRT_CTOR(left, (&left_copy));
		}
	}

	SEPARATE_ZVAL_NOREF(left);

	left_length = Z_STRLEN_P(left);
	right_length = Z_STRLEN_P(right);
	length = left_length + right_length;
	target = zend_string_extend(Z_STR_P(left), length, 0);
	ZVAL_NEW_STR(left, target);
	memcpy(ZSTR_VAL(target) + left_length, Z_STRVAL_P(right), right_length);

	ZSTR_VAL(target)[length] = '\0';

	if (use_copy_left) {
		zval_dtor(&left_copy);
	}

	if (use_copy_right) {
		zval_dtor(&right_copy);
	}
}

static void zephir_concat_self_char(zval *left, unsigned char right)
{
	zval left_copy;
	int use_copy = 0, length;
	zend_string *target;

	if (Z_TYPE_P(left) == IS_NULL) {
		target = zend_string_alloc(1, 0);
		ZSTR_VAL(target)[0] = right;
		ZSTR_VAL(target)[1] = 0;
		ZVAL_STR(left, target);;
		return;
	}

	if (Z_TYPE_P(left) != IS_STRING) {
		use_copy = zephir_make_printable_zval(left, &left_copy);
		if (use_copy) {
			ZEPHIR_CPY_WRT_CTOR(left, (&left_copy));
		}
	}

	SEPARATE_ZVAL_NOREF(left);

	length = Z_STRLEN_P(left) + 1;
	target = zend_string_extend(Z_STR_P(left), length, 0);
	ZVAL_NEW_STR(left, target);
	ZSTR_VAL(target)[length - 1] = right;
	ZSTR_VAL(target)[length] = 0;

	if (use_copy) {
		zval_dtor(&left_copy);
	}
}

static void zephir_concat_self_str(zval *left, const char *right, int right_length)
{
	zval left_copy;
	size_t length, left_length;
	int use_copy = 0;
	zend_string *target;

	if (Z_TYPE_P(left) == IS_NULL) {
		ZVAL_STRINGL(left, right, right_length);
		return;
	}

	if (Z_TYPE_P(left) != IS_STRING) {
		use_copy = zephir_make_printable_zval(left, &left_copy);
		if (use_copy) {
			ZEPHIR_CPY_WRT_CTOR(left, (&left_copy));
		}
	}

	SEPARATE_ZVAL_NOREF(left);
	left_length = Z_STRLEN_P(left);
	length = left_length + right_length;
	target = zend_string_extend(Z_STR_P(left), length, 0);
	ZVAL_NEW_STR(left, target);
	memcpy(ZSTR_VAL(target) + left_length, right, right_length);
	ZSTR_VAL(target)[length] = '\0';

	if (use_copy) {
		zval_dtor(&left_copy);
	}
}

static int zephir_compare_strict_long(zval *op1, long op2)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return Z_LVAL_P(op1) == op2;
		case IS_DOUBLE:
			return Z_DVAL_P(op1) == (double) op2;
		case IS_NULL:
			return 0 == op2;
		case IS_TRUE:
		case IS_FALSE:
			if (Z_TYPE_P(op1) == IS_TRUE) {
				return 1 == op2;
			} else {
				return 0 == op2;
			}
		default:
			{
				zval result, op2_tmp;
				ZVAL_LONG(&op2_tmp, op2);
				is_equal_function(&result, op1, &op2_tmp);
				return Z_TYPE(result) == IS_TRUE ? 1 : 0;
			}
	}

	return 0;
}

static int zephir_compare_strict_bool(zval *op1, zend_bool op2)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return (Z_LVAL_P(op1) ? 1 : 0) == op2;
		case IS_DOUBLE:
			return (Z_DVAL_P(op1) ? 1 : 0) == op2;
		case IS_NULL:
			return 0 == op2;
		case IS_TRUE:
			return 1 == op2;
		case IS_FALSE:
			return 0 == op2;
		default:
			{
				zval result, op2_tmp;
				ZVAL_BOOL(&op2_tmp, op2);
				is_equal_function(&result, op1, &op2_tmp);
				return Z_TYPE(result) == IS_TRUE;
			}
	}

	return 0;
}

static int zephir_compare_strict_string(zval *op1, const char *op2, int op2_length)
{
	switch (Z_TYPE_P(op1)) {

		case IS_STRING:
			if (!Z_STRLEN_P(op1) && !op2_length) {
				return 1;
			}
			if (Z_STRLEN_P(op1) != op2_length) {
				return 0;
			}
			return !zend_binary_strcmp(Z_STRVAL_P(op1), Z_STRLEN_P(op1), op2, op2_length);

		case IS_NULL:
			return !zend_binary_strcmp("", 0, op2, op2_length);

		case IS_TRUE:
			return !zend_binary_strcmp("1", strlen("1"), op2, op2_length);

		case IS_FALSE:
			return !zend_binary_strcmp("0", strlen("0"), op2, op2_length);
	}

	return 0;
}

static void zephir_negate(zval *z)
{
	while (1) {
		switch (Z_TYPE_P(z)) {
			case IS_LONG:
				ZVAL_LONG(z, -Z_LVAL_P(z));
				return;

			case IS_TRUE:
				ZVAL_LONG(z, -1);
				return;

			case IS_DOUBLE:
				ZVAL_DOUBLE(z, -Z_DVAL_P(z));
				return;

			case IS_NULL:
			case IS_FALSE:
				ZVAL_LONG(z, 0);
				return;

			default:
				convert_scalar_to_number(z);
				assert(Z_TYPE_P(z) == IS_LONG || Z_TYPE_P(z) == IS_DOUBLE);
		}
	}
}

static void zephir_convert_to_object(zval *op)
{
    convert_to_object(op);
}

long zephir_get_intval_ex(const zval *op)
{
    int type;
    double double_value = 0;
    zend_long long_value = 0;

	switch (Z_TYPE_P(op)) {
		case IS_ARRAY:
			return zend_hash_num_elements(Z_ARRVAL_P(op)) ? 1 : 0;

		case IS_RESOURCE:
			return (zend_long)Z_RES_HANDLE_P(op);

		case IS_CALLABLE:
		case IS_OBJECT:
			return 1;

		case IS_LONG:
			return Z_LVAL_P(op);

		case IS_TRUE:
			return 1;

		case IS_FALSE:
			return 0;

		case IS_DOUBLE:
			return (long) Z_DVAL_P(op);

		case IS_STRING: {
			ASSUME(Z_STRVAL_P(op) != NULL);

			type = is_numeric_string(Z_STRVAL_P(op), Z_STRLEN_P(op), &long_value, &double_value, 1);
            switch (type) {
                case IS_LONG:
                    return long_value;

                case IS_DOUBLE:
                    return (long) double_value;
            }
		}
	}

	return 0;
}

long zephir_get_charval_ex(const zval *op)
{
	switch (Z_TYPE_P(op)) {
        case IS_ARRAY:
	    case IS_CALLABLE:
	    case IS_RESOURCE:
	    case IS_OBJECT:
	        return 0;

		case IS_LONG:
			return Z_LVAL_P(op);

		case IS_TRUE:
			return 1;

		case IS_FALSE:
			return 0;

		case IS_DOUBLE:
			return (long) Z_DVAL_P(op);

		case IS_STRING: {
			if (Z_STRLEN_P(op) > 0) {
				return Z_STRVAL_P(op)[0];
			}
			return 0;
		}
	}

	return 0;
}

double zephir_get_doubleval_ex(const zval *op)
{
	int type;
    double double_value = 0;
    zend_long long_value = 0;

	switch (Z_TYPE_P(op)) {
        case IS_ARRAY:
            return zend_hash_num_elements(Z_ARRVAL_P(op)) ? (double) 1 : 0;

	    case IS_CALLABLE:
	    case IS_RESOURCE:
	    case IS_OBJECT:
	        return (double) 1;

		case IS_LONG:
			return (double) Z_LVAL_P(op);

		case IS_TRUE:
			return (double) 1;

		case IS_FALSE:
			return (double) 0;

		case IS_DOUBLE:
			return Z_DVAL_P(op);

		case IS_STRING:
		    type = is_numeric_string(Z_STRVAL_P(op), Z_STRLEN_P(op), &long_value, &double_value, 1);
            switch (type) {
                case IS_LONG:
                    return (double) long_value;

                case IS_DOUBLE:
                    return double_value;
            }
	}

	return 0;
}

zend_bool zephir_get_boolval_ex(zval *op)
{
	return (zend_bool) zend_is_true(op);
}

static int zephir_is_numeric_ex(const zval *op)
{
	int type;

	switch (Z_TYPE_P(op)) {

		case IS_LONG:
			return 1;

		case IS_TRUE:
		case IS_FALSE:
			return 0;

		case IS_DOUBLE:
			return 1;

		case IS_STRING:
			if ((type = is_numeric_string(Z_STRVAL_P(op), Z_STRLEN_P(op), NULL, NULL, 0))) {
				if (type == IS_LONG || type == IS_DOUBLE) {
					return 1;
				}
			}
	}

	return 0;
}

static int zephir_is_equal(zval *op1, zval *op2)
{
	zval result;

	is_equal_function(&result, op1, op2);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_less(zval *op1, zval *op2)
{
	zval result;
	is_smaller_function(&result, op1, op2);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_greater(zval *op1, zval *op2)
{
	zval result;
	is_smaller_or_equal_function(&result, op1, op2);
	return Z_TYPE(result) == IS_FALSE;
}

static int zephir_is_identical(zval *op1, zval *op2)
{
	zval result;
	is_identical_function(&result, op1, op2);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_bitwise_and_function(zval *result, zval *op1, zval *op2)
{
	int status;
	status = bitwise_and_function(result, op1, op2);
	return status;
}

static int zephir_bitwise_or_function(zval *result, zval *op1, zval *op2)
{
	int status;
	status = bitwise_or_function(result, op1, op2);
	return status;
}

static int zephir_bitwise_xor_function(zval *result, zval *op1, zval *op2)
{
	int status;
	status = bitwise_xor_function(result, op1, op2);
	return status;
}

static int zephir_less_equal(zval *op1, zval *op2)
{
	zval result;
	is_smaller_or_equal_function(&result, op1, op2);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_less_long(zval *op1, long op2)
{
	zval result, op2_zval;
	ZVAL_LONG(&op2_zval, op2);

	is_smaller_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_less_double(zval *op1, double op2)
{
	zval result, op2_zval;
	ZVAL_DOUBLE(&op2_zval, op2);

	is_smaller_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_less_equal_long(zval *op1, long op2)
{
	zval result, op2_zval;
	ZVAL_LONG(&op2_zval, op2);

	is_smaller_or_equal_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_TRUE;
}

static int zephir_greater_long(zval *op1, long op2)
{
	zval result, op2_zval;
	ZVAL_LONG(&op2_zval, op2);

	is_smaller_or_equal_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_FALSE;
}

static int zephir_greater_double(zval *op1, double op2)
{
	zval result, op2_zval;
	ZVAL_DOUBLE(&op2_zval, op2);

	is_smaller_or_equal_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_FALSE;
}

static int zephir_greater_equal(zval *op1, zval *op2)
{
	zval result;
	is_smaller_function(&result, op1, op2);
	return Z_TYPE(result) == IS_FALSE;
}

static int zephir_greater_equal_long(zval *op1, long op2)
{
	zval result, op2_zval;
	ZVAL_LONG(&op2_zval, op2);
	is_smaller_function(&result, op1, &op2_zval);
	return Z_TYPE(result) == IS_FALSE;
}

double zephir_safe_div_long_long(long op1, long op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	return (double) op1 / (double) op2;
}

double zephir_safe_div_long_double(long op1, double op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	return (double) op1 / op2;
}

double zephir_safe_div_double_zval(double op1, zval *op2)
{
	if (!zephir_get_numberval(op2)) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	switch (Z_TYPE_P(op2)) {
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return op1 / ((double) zephir_get_numberval(op2));
}

double zephir_safe_div_double_long(double op1, long op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	return op1 / (double) op2;
}

double zephir_safe_div_double_double(double op1, double op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	return op1 / op2;
}

double zephir_safe_div_zval_long(zval *op1, long op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	switch (Z_TYPE_P(op1)) {
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return ((double) zephir_get_numberval(op1)) / (double) op2;
}

double zephir_safe_div_long_zval(long op1, zval *op2)
{
	if (!zephir_get_numberval(op2)) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	switch (Z_TYPE_P(op2)) {
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return (double) op1 / ((double) zephir_get_numberval(op2));
}

double zephir_safe_div_zval_double(zval *op1, double op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	switch (Z_TYPE_P(op1)) {
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return ((double) zephir_get_numberval(op1)) / op2;
}

long zephir_safe_mod_long_long(long op1, long op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	return op1 % op2;
}

long zephir_safe_mod_zval_long(zval *op1, long op2)
{
	if (!op2) {
		zend_error(E_WARNING, "Division by zero");
		return 0;
	}
	switch (Z_TYPE_P(op1)) {
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return ((long) zephir_get_numberval(op1)) % (long) op2;
}



#ifdef HAVE_CONFIG_H
#endif

static void zephir_concat_ss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, int self_var){

	zval result_copy;
	int use_copy = 0;
	size_t offset = 0, length;

	length = op1_len + op2_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_sss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, int self_var){

	zval result_copy;
	int use_copy = 0;
	size_t offset = 0, length;

	length = op1_len + op2_len + op3_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, op3, op3_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_ssssss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, int self_var){

	zval result_copy;
	int use_copy = 0;
	size_t offset = 0, length;

	length = op1_len + op2_len + op3_len + op4_len + op5_len + op6_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len, op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + op4_len, op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + op4_len + op5_len, op6, op6_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_sssvss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, int self_var){

	zval result_copy, op4_copy;
	int use_copy = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len, op6, op6_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_sssvsvssvsvss(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, const char *op8, uint32_t op8_len, zval *op9, const char *op10, uint32_t op10_len, zval *op11, const char *op12, uint32_t op12_len, const char *op13, uint32_t op13_len, int self_var){

	zval result_copy, op4_copy, op6_copy, op9_copy, op11_copy;
	int use_copy = 0, use_copy4 = 0, use_copy6 = 0, use_copy9 = 0, use_copy11 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op9) != IS_STRING) {
	   use_copy9 = zend_make_printable_zval(op9, &op9_copy);
	   if (use_copy9) {
	       op9 = &op9_copy;
	   }
	}

	if (Z_TYPE_P(op11) != IS_STRING) {
	   use_copy11 = zend_make_printable_zval(op11, &op11_copy);
	   if (use_copy11) {
	       op11 = &op11_copy;
	   }
	}

	length = op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len + Z_STRLEN_P(op9) + op10_len + Z_STRLEN_P(op11) + op12_len + op13_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6), op7, op7_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len, op8, op8_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len, Z_STRVAL_P(op9), Z_STRLEN_P(op9));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len + Z_STRLEN_P(op9), op10, op10_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len + Z_STRLEN_P(op9) + op10_len, Z_STRVAL_P(op11), Z_STRLEN_P(op11));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len + Z_STRLEN_P(op9) + op10_len + Z_STRLEN_P(op11), op12, op12_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + op8_len + Z_STRLEN_P(op9) + op10_len + Z_STRLEN_P(op11) + op12_len, op13, op13_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy9) {
	   zval_dtor(op9);
	}

	if (use_copy11) {
	   zval_dtor(op11);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_sssvsvsvsvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, zval *op10, const char *op11, uint32_t op11_len, zval *op12, const char *op13, uint32_t op13_len, int self_var){

	zval result_copy, op4_copy, op6_copy, op8_copy, op10_copy, op12_copy;
	int use_copy = 0, use_copy4 = 0, use_copy6 = 0, use_copy8 = 0, use_copy10 = 0, use_copy12 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op8) != IS_STRING) {
	   use_copy8 = zend_make_printable_zval(op8, &op8_copy);
	   if (use_copy8) {
	       op8 = &op8_copy;
	   }
	}

	if (Z_TYPE_P(op10) != IS_STRING) {
	   use_copy10 = zend_make_printable_zval(op10, &op10_copy);
	   if (use_copy10) {
	       op10 = &op10_copy;
	   }
	}

	if (Z_TYPE_P(op12) != IS_STRING) {
	   use_copy12 = zend_make_printable_zval(op12, &op12_copy);
	   if (use_copy12) {
	       op12 = &op12_copy;
	   }
	}

	length = op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len + Z_STRLEN_P(op10) + op11_len + Z_STRLEN_P(op12) + op13_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6), op7, op7_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len, Z_STRVAL_P(op8), Z_STRLEN_P(op8));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8), op9, op9_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len, Z_STRVAL_P(op10), Z_STRLEN_P(op10));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len + Z_STRLEN_P(op10), op11, op11_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len + Z_STRLEN_P(op10) + op11_len, Z_STRVAL_P(op12), Z_STRLEN_P(op12));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len + Z_STRLEN_P(op10) + op11_len + Z_STRLEN_P(op12), op13, op13_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy8) {
	   zval_dtor(op8);
	}

	if (use_copy10) {
	   zval_dtor(op10);
	}

	if (use_copy12) {
	   zval_dtor(op12);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_ssv(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, int self_var){

	zval result_copy, op3_copy;
	int use_copy = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = op1_len + op2_len + Z_STRLEN_P(op3);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_ssvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var){

	zval result_copy, op3_copy, op5_copy;
	int use_copy = 0, use_copy3 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_ssvsvsvs(zval *result, const char *op1, uint32_t op1_len, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var){

	zval result_copy, op3_copy, op5_copy, op7_copy;
	int use_copy = 0, use_copy3 = 0, use_copy5 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7) + op8_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7), op8, op8_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_sv(zval *result, const char *op1, uint32_t op1_len, zval *op2, int self_var){

	zval result_copy, op2_copy;
	int use_copy = 0, use_copy2 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, int self_var){

	zval result_copy, op2_copy;
	int use_copy = 0, use_copy2 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var){

	zval result_copy, op2_copy, op5_copy;
	int use_copy = 0, use_copy2 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svssvssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, int self_var){

	zval result_copy, op2_copy, op5_copy, op8_copy;
	int use_copy = 0, use_copy2 = 0, use_copy5 = 0, use_copy8 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op8) != IS_STRING) {
	   use_copy8 = zend_make_printable_zval(op8, &op8_copy);
	   if (use_copy8) {
	       op8 = &op8_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len, op7, op7_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len, Z_STRVAL_P(op8), Z_STRLEN_P(op8));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8), op9, op9_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy8) {
	   zval_dtor(op8);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svssvssvssvssvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, const char *op10, uint32_t op10_len, zval *op11, const char *op12, uint32_t op12_len, const char *op13, uint32_t op13_len, zval *op14, const char *op15, uint32_t op15_len, int self_var){

	zval result_copy, op2_copy, op5_copy, op8_copy, op11_copy, op14_copy;
	int use_copy = 0, use_copy2 = 0, use_copy5 = 0, use_copy8 = 0, use_copy11 = 0, use_copy14 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op8) != IS_STRING) {
	   use_copy8 = zend_make_printable_zval(op8, &op8_copy);
	   if (use_copy8) {
	       op8 = &op8_copy;
	   }
	}

	if (Z_TYPE_P(op11) != IS_STRING) {
	   use_copy11 = zend_make_printable_zval(op11, &op11_copy);
	   if (use_copy11) {
	       op11 = &op11_copy;
	   }
	}

	if (Z_TYPE_P(op14) != IS_STRING) {
	   use_copy14 = zend_make_printable_zval(op14, &op14_copy);
	   if (use_copy14) {
	       op14 = &op14_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len + Z_STRLEN_P(op11) + op12_len + op13_len + Z_STRLEN_P(op14) + op15_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len, op7, op7_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len, Z_STRVAL_P(op8), Z_STRLEN_P(op8));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8), op9, op9_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len, op10, op10_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len, Z_STRVAL_P(op11), Z_STRLEN_P(op11));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len + Z_STRLEN_P(op11), op12, op12_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len + Z_STRLEN_P(op11) + op12_len, op13, op13_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len + Z_STRLEN_P(op11) + op12_len + op13_len, Z_STRVAL_P(op14), Z_STRLEN_P(op14));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + op7_len + Z_STRLEN_P(op8) + op9_len + op10_len + Z_STRLEN_P(op11) + op12_len + op13_len + Z_STRLEN_P(op14), op15, op15_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy8) {
	   zval_dtor(op8);
	}

	if (use_copy11) {
	   zval_dtor(op11);
	}

	if (use_copy14) {
	   zval_dtor(op14);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svssvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var){

	zval result_copy, op2_copy, op5_copy, op7_copy;
	int use_copy = 0, use_copy2 = 0, use_copy5 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7) + op8_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + op4_len + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7), op8, op8_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, int self_var){

	zval result_copy, op2_copy, op4_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, int self_var){

	zval result_copy, op2_copy, op4_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvssvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, zval *op9, const char *op10, uint32_t op10_len, int self_var){

	zval result_copy, op2_copy, op4_copy, op7_copy, op9_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy7 = 0, use_copy9 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	if (Z_TYPE_P(op9) != IS_STRING) {
	   use_copy9 = zend_make_printable_zval(op9, &op9_copy);
	   if (use_copy9) {
	       op9 = &op9_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len + Z_STRLEN_P(op7) + op8_len + Z_STRLEN_P(op9) + op10_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len, op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len + Z_STRLEN_P(op7), op8, op8_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len + Z_STRLEN_P(op7) + op8_len, Z_STRVAL_P(op9), Z_STRLEN_P(op9));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + op6_len + Z_STRLEN_P(op7) + op8_len + Z_STRLEN_P(op9), op10, op10_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy9) {
	   zval_dtor(op9);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, int self_var){

	zval result_copy, op2_copy, op4_copy, op6_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy6 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, int self_var){

	zval result_copy, op2_copy, op4_copy, op6_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy6 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6), op7, op7_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvsvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, const char *op5, uint32_t op5_len, zval *op6, const char *op7, uint32_t op7_len, zval *op8, const char *op9, uint32_t op9_len, int self_var){

	zval result_copy, op2_copy, op4_copy, op6_copy, op8_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy6 = 0, use_copy8 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op8) != IS_STRING) {
	   use_copy8 = zend_make_printable_zval(op8, &op8_copy);
	   if (use_copy8) {
	       op8 = &op8_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8) + op9_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6), op7, op7_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len, Z_STRVAL_P(op8), Z_STRLEN_P(op8));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + op7_len + Z_STRLEN_P(op8), op9, op9_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy8) {
	   zval_dtor(op8);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, int self_var){

	zval result_copy, op2_copy, op4_copy, op5_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvvsv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, const char *op6, uint32_t op6_len, zval *op7, int self_var){

	zval result_copy, op2_copy, op4_copy, op5_copy, op7_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy5 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvvsvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, const char *op6, uint32_t op6_len, zval *op7, const char *op8, uint32_t op8_len, int self_var){

	zval result_copy, op2_copy, op4_copy, op5_copy, op7_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy5 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7) + op8_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7), op8, op8_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, zval *op6, int self_var){

	zval result_copy, op2_copy, op4_copy, op5_copy, op6_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy5 = 0, use_copy6 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5), Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svsvvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, const char *op3, uint32_t op3_len, zval *op4, zval *op5, zval *op6, zval *op7, int self_var){

	zval result_copy, op2_copy, op4_copy, op5_copy, op6_copy, op7_copy;
	int use_copy = 0, use_copy2 = 0, use_copy4 = 0, use_copy5 = 0, use_copy6 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5), Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6), Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svv(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, int self_var){

	zval result_copy, op2_copy, op3_copy;
	int use_copy = 0, use_copy2 = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, const char *op4, uint32_t op4_len, int self_var){

	zval result_copy, op2_copy, op3_copy;
	int use_copy = 0, use_copy2 = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + op4_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), op4, op4_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svvvs(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, zval *op4, const char *op5, uint32_t op5_len, int self_var){

	zval result_copy, op2_copy, op3_copy, op4_copy;
	int use_copy = 0, use_copy2 = 0, use_copy3 = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + op5_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4), op5, op5_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_svvvvvvvvvv(zval *result, const char *op1, uint32_t op1_len, zval *op2, zval *op3, zval *op4, zval *op5, zval *op6, zval *op7, zval *op8, zval *op9, zval *op10, zval *op11, int self_var){

	zval result_copy, op2_copy, op3_copy, op4_copy, op5_copy, op6_copy, op7_copy, op8_copy, op9_copy, op10_copy, op11_copy;
	int use_copy = 0, use_copy2 = 0, use_copy3 = 0, use_copy4 = 0, use_copy5 = 0, use_copy6 = 0, use_copy7 = 0, use_copy8 = 0, use_copy9 = 0, use_copy10 = 0, use_copy11 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	if (Z_TYPE_P(op8) != IS_STRING) {
	   use_copy8 = zend_make_printable_zval(op8, &op8_copy);
	   if (use_copy8) {
	       op8 = &op8_copy;
	   }
	}

	if (Z_TYPE_P(op9) != IS_STRING) {
	   use_copy9 = zend_make_printable_zval(op9, &op9_copy);
	   if (use_copy9) {
	       op9 = &op9_copy;
	   }
	}

	if (Z_TYPE_P(op10) != IS_STRING) {
	   use_copy10 = zend_make_printable_zval(op10, &op10_copy);
	   if (use_copy10) {
	       op10 = &op10_copy;
	   }
	}

	if (Z_TYPE_P(op11) != IS_STRING) {
	   use_copy11 = zend_make_printable_zval(op11, &op11_copy);
	   if (use_copy11) {
	       op11 = &op11_copy;
	   }
	}

	length = op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7) + Z_STRLEN_P(op8) + Z_STRLEN_P(op9) + Z_STRLEN_P(op10) + Z_STRLEN_P(op11);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, op1, op1_len);
	memcpy(Z_STRVAL_P(result) + offset + op1_len, Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5), Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6), Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7), Z_STRVAL_P(op8), Z_STRLEN_P(op8));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7) + Z_STRLEN_P(op8), Z_STRVAL_P(op9), Z_STRLEN_P(op9));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7) + Z_STRLEN_P(op8) + Z_STRLEN_P(op9), Z_STRVAL_P(op10), Z_STRLEN_P(op10));
	memcpy(Z_STRVAL_P(result) + offset + op1_len + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5) + Z_STRLEN_P(op6) + Z_STRLEN_P(op7) + Z_STRLEN_P(op8) + Z_STRLEN_P(op9) + Z_STRLEN_P(op10), Z_STRVAL_P(op11), Z_STRLEN_P(op11));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy8) {
	   zval_dtor(op8);
	}

	if (use_copy9) {
	   zval_dtor(op9);
	}

	if (use_copy10) {
	   zval_dtor(op10);
	}

	if (use_copy11) {
	   zval_dtor(op11);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vs(zval *result, zval *op1, const char *op2, uint32_t op2_len, int self_var){

	zval result_copy, op1_copy;
	int use_copy = 0, use_copy1 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, int self_var){

	zval result_copy, op1_copy, op3_copy;
	int use_copy = 0, use_copy1 = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vsvs(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, int self_var){

	zval result_copy, op1_copy, op3_copy;
	int use_copy = 0, use_copy1 = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vsvsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, int self_var){

	zval result_copy, op1_copy, op3_copy, op5_copy;
	int use_copy = 0, use_copy1 = 0, use_copy3 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vsvsvs(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, int self_var){

	zval result_copy, op1_copy, op3_copy, op5_copy;
	int use_copy = 0, use_copy1 = 0, use_copy3 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vsvsvsv(zval *result, zval *op1, const char *op2, uint32_t op2_len, zval *op3, const char *op4, uint32_t op4_len, zval *op5, const char *op6, uint32_t op6_len, zval *op7, int self_var){

	zval result_copy, op1_copy, op3_copy, op5_copy, op7_copy;
	int use_copy = 0, use_copy1 = 0, use_copy3 = 0, use_copy5 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len + Z_STRLEN_P(op7);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), op2, op2_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len, Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3), op4, op4_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len, Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5), op6, op6_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + op2_len + Z_STRLEN_P(op3) + op4_len + Z_STRLEN_P(op5) + op6_len, Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vv(zval *result, zval *op1, zval *op2, int self_var){

	zval result_copy, op1_copy, op2_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvs(zval *result, zval *op1, zval *op2, const char *op3, uint32_t op3_len, int self_var){

	zval result_copy, op1_copy, op2_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + op3_len;
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), op3, op3_len);
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvsv(zval *result, zval *op1, zval *op2, const char *op3, uint32_t op3_len, zval *op4, int self_var){

	zval result_copy, op1_copy, op2_copy, op4_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + op3_len + Z_STRLEN_P(op4);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), op3, op3_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + op3_len, Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvv(zval *result, zval *op1, zval *op2, zval *op3, int self_var){

	zval result_copy, op1_copy, op2_copy, op3_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0, use_copy3 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, int self_var){

	zval result_copy, op1_copy, op2_copy, op3_copy, op4_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0, use_copy3 = 0, use_copy4 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvvvsvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, const char *op5, uint32_t op5_len, zval *op6, zval *op7, int self_var){

	zval result_copy, op1_copy, op2_copy, op3_copy, op4_copy, op6_copy, op7_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0, use_copy3 = 0, use_copy4 = 0, use_copy6 = 0, use_copy7 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op6) != IS_STRING) {
	   use_copy6 = zend_make_printable_zval(op6, &op6_copy);
	   if (use_copy6) {
	       op6 = &op6_copy;
	   }
	}

	if (Z_TYPE_P(op7) != IS_STRING) {
	   use_copy7 = zend_make_printable_zval(op7, &op7_copy);
	   if (use_copy7) {
	       op7 = &op7_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6) + Z_STRLEN_P(op7);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4), op5, op5_len);
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + op5_len, Z_STRVAL_P(op6), Z_STRLEN_P(op6));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + op5_len + Z_STRLEN_P(op6), Z_STRVAL_P(op7), Z_STRLEN_P(op7));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy6) {
	   zval_dtor(op6);
	}

	if (use_copy7) {
	   zval_dtor(op7);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_vvvvv(zval *result, zval *op1, zval *op2, zval *op3, zval *op4, zval *op5, int self_var){

	zval result_copy, op1_copy, op2_copy, op3_copy, op4_copy, op5_copy;
	int use_copy = 0, use_copy1 = 0, use_copy2 = 0, use_copy3 = 0, use_copy4 = 0, use_copy5 = 0;
	size_t offset = 0, length;

	if (Z_TYPE_P(op1) != IS_STRING) {
	   use_copy1 = zend_make_printable_zval(op1, &op1_copy);
	   if (use_copy1) {
	       op1 = &op1_copy;
	   }
	}

	if (Z_TYPE_P(op2) != IS_STRING) {
	   use_copy2 = zend_make_printable_zval(op2, &op2_copy);
	   if (use_copy2) {
	       op2 = &op2_copy;
	   }
	}

	if (Z_TYPE_P(op3) != IS_STRING) {
	   use_copy3 = zend_make_printable_zval(op3, &op3_copy);
	   if (use_copy3) {
	       op3 = &op3_copy;
	   }
	}

	if (Z_TYPE_P(op4) != IS_STRING) {
	   use_copy4 = zend_make_printable_zval(op4, &op4_copy);
	   if (use_copy4) {
	       op4 = &op4_copy;
	   }
	}

	if (Z_TYPE_P(op5) != IS_STRING) {
	   use_copy5 = zend_make_printable_zval(op5, &op5_copy);
	   if (use_copy5) {
	       op5 = &op5_copy;
	   }
	}

	length = Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4) + Z_STRLEN_P(op5);
	if (self_var) {

		if (Z_TYPE_P(result) != IS_STRING) {
			use_copy = zend_make_printable_zval(result, &result_copy);
			if (use_copy) {
				ZEPHIR_CPY_WRT_CTOR(result, (&result_copy));
			}
		}

		offset = Z_STRLEN_P(result);
		length += offset;
		Z_STR_P(result) = zend_string_realloc(Z_STR_P(result), length, 0);

	} else {
		ZVAL_STR(result, zend_string_alloc(length, 0));
	}

	memcpy(Z_STRVAL_P(result) + offset, Z_STRVAL_P(op1), Z_STRLEN_P(op1));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1), Z_STRVAL_P(op2), Z_STRLEN_P(op2));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2), Z_STRVAL_P(op3), Z_STRLEN_P(op3));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3), Z_STRVAL_P(op4), Z_STRLEN_P(op4));
	memcpy(Z_STRVAL_P(result) + offset + Z_STRLEN_P(op1) + Z_STRLEN_P(op2) + Z_STRLEN_P(op3) + Z_STRLEN_P(op4), Z_STRVAL_P(op5), Z_STRLEN_P(op5));
	Z_STRVAL_P(result)[length] = 0;
	zend_string_forget_hash_val(Z_STR_P(result));
	if (use_copy1) {
	   zval_dtor(op1);
	}

	if (use_copy2) {
	   zval_dtor(op2);
	}

	if (use_copy3) {
	   zval_dtor(op3);
	}

	if (use_copy4) {
	   zval_dtor(op4);
	}

	if (use_copy5) {
	   zval_dtor(op5);
	}

	if (use_copy) {
	   zval_dtor(&result_copy);
	}

}

static void zephir_concat_function(zval *result, zval *op1, zval *op2)
{
	zval tmp;
	SEPARATE_ZVAL_NOREF(result);

	if (result == op2 && result != op1) {
		ZVAL_COPY_VALUE(&tmp, result);
		ZVAL_NULL(result);
		op2 = &tmp;
	}
	else {
		ZVAL_UNDEF(&tmp);
	}

	concat_function(result, op1, op2);
	assert(!Z_REFCOUNTED(tmp) || 1 == Z_REFCOUNT(tmp));
	zval_dtor(&tmp);
}


#ifdef HAVE_CONFIG_H
#endif




double zephir_sqrt(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return sqrt(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return sqrt(zephir_get_numberval(op1));
}

double zephir_sin(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return sin(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return sin(zephir_get_numberval(op1));
}

double zephir_asin(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return asin(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return asin(zephir_get_numberval(op1));
}

double zephir_cos(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return cos(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return cos(zephir_get_numberval(op1));
}

double zephir_acos(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return acos(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return acos(zephir_get_numberval(op1));
}

double zephir_tan(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return tan(Z_LVAL_P(op1));
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return tan(zephir_get_numberval(op1));
}

double zephir_floor(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return (double) Z_LVAL_P(op1);
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return floor(zephir_get_numberval(op1));
}

double zephir_ceil(zval *op1)
{
	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			return (double) Z_LVAL_P(op1);
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}
	return ceil(zephir_get_numberval(op1));
}

double _php_math_round(double value, int places, int mode);

static void zephir_round(zval *return_value, zval *op1, zval *op2, zval *op3)
{
	int places = 0;
	long mode = PHP_ROUND_HALF_UP;
	double return_val;

	convert_scalar_to_number_ex(op1);

	if (op2) {
		places = zephir_get_intval_ex(op2);
	}
	if (op3) {
		mode = zephir_get_intval_ex(op3);
	}

	switch (Z_TYPE_P(op1)) {
		case IS_LONG:
			/* Simple case - long that doesn't need to be rounded. */
			if (places >= 0) {
				RETURN_DOUBLE((double) Z_LVAL_P(op1));
			}
			/* break omitted intentionally */

		case IS_DOUBLE:
			return_val = (Z_TYPE_P(op1) == IS_LONG) ? (double)Z_LVAL_P(op1) : Z_DVAL_P(op1);
			return_val = _php_math_round(return_val, places, mode);
			RETURN_DOUBLE(return_val);
			break;

		default:
			RETURN_FALSE;
			break;
	}
}

double zephir_ldexp(zval *value, zval *expval)
{
	int exp = (int) zephir_get_numberval(expval);

	switch (Z_TYPE_P(value)) {
		case IS_LONG:
			return (double) ldexp(Z_LVAL_P(value), exp);
		case IS_DOUBLE:
			return (double) ldexp(Z_DVAL_P(value), exp);
		case IS_ARRAY:
		case IS_OBJECT:
		case IS_RESOURCE:
			zend_error(E_WARNING, "Unsupported operand types");
			break;
	}

	return ldexp(zephir_get_numberval(value), exp);
}



#ifdef HAVE_CONFIG_H
#endif



static zend_always_inline void zephir_smart_str_0(smart_str *str)
{
	if (str->s) {
		ZSTR_VAL(str->s)[ZSTR_LEN(str->s)] = '\0';
	}
}

static void zephir_var_dump(zval *var)
{
    php_var_dump(var, 1);
}

static void zephir_var_export(zval *var)
{
    php_var_export(var, 1);
}

static void zephir_var_export_ex(zval *return_value, zval *var)
{
    smart_str buf = { 0 };

    php_var_export_ex(var, 1, &buf);
    zephir_smart_str_0(&buf);
    ZVAL_STR(return_value, buf.s);
}

static void zephir_get_defined_vars(zval *return_value)
{
	zend_array *symtable = zend_rebuild_symbol_table();
	if (EXPECTED(symtable != NULL)) {
		RETURN_ARR(zend_array_dup(symtable));
	}

	RETURN_NULL();
}



#ifdef HAVE_CONFIG_H
#endif





static void zephir_filter_alphanum(zval *return_value, zval *param)
{
	unsigned int i;
	unsigned char ch;
	smart_str filtered_str = {0};
	zval copy;
	int use_copy = 0;

	if (Z_TYPE_P(param) != IS_STRING) {
		use_copy = zend_make_printable_zval(param, &copy);
		if (use_copy) {
			param = &copy;
		}
	}

	for (i = 0; i < Z_STRLEN_P(param); i++) {
		ch = Z_STRVAL_P(param)[i];
		if (ch == '\0') {
			break;
		}
		if (isalnum(ch)) {
			smart_str_appendc(&filtered_str, ch);
		}
	}

	if (use_copy) {
		zval_dtor(param);
	}

	smart_str_0(&filtered_str);

	if (filtered_str.s) {
		RETURN_STR(filtered_str.s);
	} else {
		RETURN_EMPTY_STRING();
	}
}

static void zephir_is_basic_charset(zval *return_value, const zval *param)
{
	unsigned int i;
	unsigned int ch;
	int iso88591 = 0;

	for (i = 0; i < Z_STRLEN_P(param); i++) {
		ch = Z_STRVAL_P(param)[i];
		if (ch != '\0') {
			if (ch == 172 || (ch >= 128 && ch <= 159)) {
				continue;
			}
			if (ch >= 160 && ch <= 255) {
				iso88591 = 1;
				continue;
			}
		}
		RETURN_FALSE;
	}

	if (!iso88591) {
		RETURN_STRING("ASCII");
	}

	RETURN_STRING("ISO-8859-1");
}

static long zephir_unpack(char *data, int size, int issigned, int *map)
{
	long result;
	char *cresult = (char *) &result;
	int i;

	result = issigned ? -1 : 0;

	for (i = 0; i < size; i++) {
		cresult[map[i]] = *data++;
	}

	return result;
}

static inline char *zephir_longtohex(unsigned long value)
{
	static char digits[] = "0123456789abcdef";
	char buf[(sizeof(unsigned long) << 3) + 1];
	char *ptr, *end;

	end = ptr = buf + sizeof(buf) - 1;
	*ptr = '\0';
	do {
		*--ptr = digits[value & 0x0F];
		value >>= 4;
	} while (ptr > buf && value);

	return estrndup(ptr, end - ptr);
}

static void zephir_escape_multi(zval *return_value, zval *param, const char *escape_char, unsigned int escape_length, char escape_extra, int use_whitelist)
{
	unsigned int i;
	zval copy;
	smart_str escaped_str = {0};
	char machine_little_endian, *hex;
	int big_endian_long_map[4];
	int use_copy = 0, machine_endian_check = 1;
	int issigned = 0;
	long value;

	if (Z_TYPE_P(param) != IS_STRING) {
		use_copy = zend_make_printable_zval(param, &copy);
		if (use_copy) {
			param = &copy;
		}
	}

	if (Z_STRLEN_P(param) <= 0) {
		RETURN_FALSE;
	}

	machine_little_endian = ((char *) &machine_endian_check)[0];
	if (machine_little_endian) {
		big_endian_long_map[0] = 3;
		big_endian_long_map[1] = 2;
		big_endian_long_map[2] = 1;
		big_endian_long_map[3] = 0;
	} else {
		int size = sizeof(Z_LVAL_P(param));
		big_endian_long_map[0] = size - 4;
		big_endian_long_map[1] = size - 3;
		big_endian_long_map[2] = size - 2;
		big_endian_long_map[3] = size - 1;
	}

	if ((Z_STRLEN_P(param) % 4) != 0) {
		RETURN_FALSE;
	}

	for (i = 0; i < Z_STRLEN_P(param); i += 4) {

		issigned = Z_STRVAL_P(param)[i] & 0x80;

		value = 0;
		if (sizeof(long) > 4 && issigned) {
			value = ~INT_MAX;
		}

		value |= zephir_unpack(&Z_STRVAL_P(param)[i], 4, issigned, big_endian_long_map);
		if (sizeof(long) > 4) {
			value = (unsigned int) value;
		}

		if (value == '\0') {
			RETURN_FALSE;
		}

		if (value < 123 && isalnum(value)) {
			smart_str_appendc(&escaped_str, (unsigned char) value);
			continue;
		}

		if (use_whitelist) {
			switch (value) {
				case ' ':
				case '/':
				case '*':
				case '+':
				case '-':
				case '\t':
				case '\n':
				case '^':
				case '$':
				case '!':
				case '?':
				case '\\':
				case '#':
				case '}':
				case '{':
				case ')':
				case '(':
				case ']':
				case '[':
				case '.':
				case ',':
				case ':':
				case ';':
				case '_':
				case '|':
					smart_str_appendc(&escaped_str, (unsigned char) value);
					continue;
			}
		}

		hex = zephir_longtohex(value);

		smart_str_appendl(&escaped_str, escape_char, escape_length);
		smart_str_appendl(&escaped_str, hex, strlen(hex));
		if (escape_extra != '\0') {
			smart_str_appendc(&escaped_str, escape_extra);
		}

		efree(hex);
	}

	if (use_copy) {
		zval_dtor(param);
	}

	smart_str_0(&escaped_str);

	if (escaped_str.s) {
		RETURN_STR(escaped_str.s);
	} else {
		RETURN_EMPTY_STRING();
	}
}

static void zephir_escape_css(zval *return_value, zval *param)
{
	zephir_escape_multi(return_value, param, "\\", sizeof("\\")-1, ' ', 0);
}

static void zephir_escape_js(zval *return_value, zval *param)
{
	zephir_escape_multi(return_value, param, "\\x", sizeof("\\x")-1, '\0', 1);
}



#ifdef HAVE_CONFIG_H
#endif



zend_object_iterator *zephir_get_iterator(zval *iterator)
{
	zend_class_entry *ce;
	zend_object_iterator *it;

	if (UNEXPECTED(Z_TYPE_P(iterator) != IS_OBJECT)) {
		return NULL;
	}

	ce = Z_OBJCE_P(iterator);
	it = ce->get_iterator(ce, iterator, 0);
	if (UNEXPECTED(!it || EG(exception))) {
		return NULL;
	}

	if (UNEXPECTED(it->funcs->get_current_key == NULL)) {
		return NULL;
	}

	if (UNEXPECTED(it->funcs->rewind == NULL)) {
		return NULL;
	}

	return it;
}



#ifdef HAVE_CONFIG_H
#endif

#ifdef PHP_WIN32
#elif defined(NETWARE)
#else
#endif




static void zephir_time(zval *return_value)
{
	RETURN_LONG(time(NULL));
}

static void zephir_microtime(zval *return_value, zval *get_as_float)
{
	struct timeval tp = {0};
	char ret[100];

	if (gettimeofday(&tp, NULL)) {
		RETURN_FALSE;
	}

	if (get_as_float && ZEPHIR_IS_TRUE(get_as_float)) {
		RETURN_DOUBLE((double)(tp.tv_sec + tp.tv_usec / MICRO_IN_SEC));
	}

	snprintf(ret, 100, "%.8F %ld", tp.tv_usec / MICRO_IN_SEC, tp.tv_sec);
	RETURN_STRING(ret);
}



#ifdef HAVE_CONFIG_H
#endif



static void zephir_exit_empty()
{
	zend_bailout();
}

static void zephir_exit(zval *ptr)
{
	if (Z_TYPE_P(ptr) == IS_LONG) {
		EG(exit_status) = Z_LVAL_P(ptr);
	} else {
		zend_print_variable(ptr);
	}
	zephir_exit_empty();
}



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_0__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 0__closure, phalcon, 0__closure, phalcon_0__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_0__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(4, 4)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(4, 0, &number, &message, &file, &line);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_10__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 10__closure, phalcon, 10__closure, phalcon_10__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_10__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(4, 4)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(4, 0, &number, &message, &file, &line);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_11__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 11__closure, phalcon, 11__closure, phalcon_11__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_11__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, *context, context_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_UNDEF(&context_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(5, 5)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
		Z_PARAM_ZVAL(context)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(5, 0, &number, &message, &file, &line, &context);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_12__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 12__closure, phalcon, 12__closure, phalcon_12__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_12__closure, __invoke)
{
	zend_bool _0;
	zval *element, element_sub;

	ZVAL_UNDEF(&element_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &element);
	_0 = Z_TYPE_P(element) == IS_LONG;
	if (!(_0)) {
		_0 = Z_TYPE_P(element) == IS_STRING;
	}
	RETURN_BOOL(_0);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_13__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 13__closure, phalcon, 13__closure, phalcon_13__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_13__closure, __invoke)
{
	zend_bool _0;
	zval *element, element_sub;

	ZVAL_UNDEF(&element_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &element);
	_0 = Z_TYPE_P(element) == IS_LONG;
	if (!(_0)) {
		_0 = Z_TYPE_P(element) == IS_STRING;
	}
	RETURN_BOOL(_0);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_1__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 1__closure, phalcon, 1__closure, phalcon_1__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_1__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, *context, context_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_UNDEF(&context_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(5, 5)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
		Z_PARAM_ZVAL(context)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(5, 0, &number, &message, &file, &line, &context);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_2__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 2__closure, phalcon, 2__closure, phalcon_2__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_2__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(4, 4)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(4, 0, &number, &message, &file, &line);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_3__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 3__closure, phalcon, 3__closure, phalcon_3__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_3__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, *context, context_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_UNDEF(&context_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(5, 5)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
		Z_PARAM_ZVAL(context)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(5, 0, &number, &message, &file, &line, &context);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_4__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 4__closure, phalcon, 4__closure, phalcon_4__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_4__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(4, 4)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(4, 0, &number, &message, &file, &line);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_5__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 5__closure, phalcon, 5__closure, phalcon_5__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_5__closure, __invoke)
{
	zval *number, number_sub, *message, message_sub, *file, file_sub, *line, line_sub, *context, context_sub, __$true;

	ZVAL_UNDEF(&number_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_UNDEF(&context_sub);
	ZVAL_BOOL(&__$true, 1);
	ZEND_PARSE_PARAMETERS_START(5, 5)
		Z_PARAM_ZVAL(number)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
		Z_PARAM_ZVAL(context)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(5, 0, &number, &message, &file, &line, &context);
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$true);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_6__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 6__closure, phalcon, 6__closure, phalcon_6__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_6__closure, __invoke)
{
	zval *file, file_sub;

	ZVAL_UNDEF(&file_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(file)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &file);
	RETURN_BOOL(1);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_7__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 7__closure, phalcon, 7__closure, phalcon_7__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_7__closure, __invoke)
{
	zend_bool _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *element, element_sub, _0, _2;

	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	zephir_memory_observe(&_0);
	zephir_array_fetch_long(&_0, element, 0, PH_NOISY, "phalcon/Filter/Validation.zep", 81);
	_1 = Z_TYPE_P(&_0) != IS_ARRAY;
	if (!(_1)) {
		zephir_memory_observe(&_2);
		zephir_array_fetch_long(&_2, element, 1, PH_NOISY, "phalcon/Filter/Validation.zep", 81);
		_1 = !(zephir_instance_of_ev(&_2, phalcon_filter_validation_abstractcombinedfieldsvalidator_ce));
	}
	RETURN_MM_BOOL(_1);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_8__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 8__closure, phalcon, 8__closure, phalcon_8__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_8__closure, __invoke)
{
	zend_bool _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *element, element_sub, _0, _2;

	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	zephir_memory_observe(&_0);
	zephir_array_fetch_long(&_0, element, 0, PH_NOISY, "phalcon/Filter/Validation.zep", 88);
	_1 = Z_TYPE_P(&_0) == IS_ARRAY;
	if (_1) {
		zephir_memory_observe(&_2);
		zephir_array_fetch_long(&_2, element, 1, PH_NOISY, "phalcon/Filter/Validation.zep", 88);
		_1 = zephir_instance_of_ev(&_2, phalcon_filter_validation_abstractcombinedfieldsvalidator_ce);
	}
	RETURN_MM_BOOL(_1);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(phalcon_9__closure)
{
	ZEPHIR_REGISTER_CLASS(phalcon, 9__closure, phalcon, 9__closure, phalcon_9__closure_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(phalcon_9__closure, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *action, action_sub, _0;

	ZVAL_UNDEF(&action_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(action)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &action);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "-");
	zephir_uncamelize(return_value, action, &_0);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Tag)
{
	ZEPHIR_REGISTER_CLASS(Phalcon, Tag, phalcon, tag, phalcon_tag_method_entry, 0);

	zend_declare_property_bool(phalcon_tag_ce, SL("autoEscape"), 1, ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("container"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("displayValues"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("documentAppendTitle"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("documentPrependTitle"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("documentTitle"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("documentTitleSeparator"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_long(phalcon_tag_ce, SL("documentType"), 11, ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("escaperService"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_null(phalcon_tag_ce, SL("urlService"), ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zephir_declare_class_constant_long(phalcon_tag_ce, SL("HTML32"), 1);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("HTML401_STRICT"), 2);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("HTML401_TRANSITIONAL"), 3);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("HTML401_FRAMESET"), 4);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("HTML5"), 5);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML10_STRICT"), 6);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML10_TRANSITIONAL"), 7);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML10_FRAMESET"), 8);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML11"), 9);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML20"), 10);

	zephir_declare_class_constant_long(phalcon_tag_ce, SL("XHTML5"), 11);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Tag, appendTitle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *title, title_sub, _0, _1$$3;

	ZVAL_UNDEF(&title_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(title)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &title);
	zephir_read_static_property_ce(&_0, phalcon_tag_ce, SL("documentAppendTitle"), PH_NOISY_CC | PH_READONLY);
	if (Z_TYPE_P(&_0) == IS_NULL) {
		ZEPHIR_INIT_VAR(&_1$$3);
		array_init(&_1$$3);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentAppendTitle"), &_1$$3);
	}
	if (Z_TYPE_P(title) == IS_ARRAY) {
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentAppendTitle"), title);
	} else {
		zephir_update_static_property_array_multi_ce(phalcon_tag_ce, SL("documentAppendTitle"), title, SL("a"), 1);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, checkField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "checkbox");
	ZEPHIR_RETURN_CALL_SELF("inputfieldchecked", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, colorField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "color");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, dateField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "date");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, dateTimeField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "datetime");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, dateTimeLocalField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "datetime-local");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, displayTo)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *id_param = NULL, *value, value_sub;
	zval id;

	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(id)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &id_param, &value);
	if (UNEXPECTED(Z_TYPE_P(id_param) != IS_STRING && Z_TYPE_P(id_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'id' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(id_param) == IS_STRING)) {
		zephir_get_strval(&id, id_param);
	} else {
		ZEPHIR_INIT_VAR(&id);
	}
	ZEPHIR_CALL_SELF(NULL, "setdefault", NULL, 0, &id, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, emailField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "email");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, endForm)
{

	RETURN_STRING("</form>");
}

static PHP_METHOD(Phalcon_Tag, fileField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "file");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, formLegacy)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters = NULL, parameters_sub, params, paramsAction, action, code, _3, _0$$6, _1$$7, _2$$8;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&paramsAction);
	ZVAL_UNDEF(&action);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_0$$6);
	ZVAL_UNDEF(&_1$$7);
	ZVAL_UNDEF(&_2$$8);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_SEPARATE_PARAM(parameters);
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 1, 0);
		zephir_array_fast_append(&params, parameters);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	zephir_memory_observe(&paramsAction);
	if (!(zephir_array_isset_long_fetch(&paramsAction, &params, 0, 0))) {
		ZEPHIR_OBS_NVAR(&paramsAction);
		zephir_array_isset_string_fetch(&paramsAction, &params, SL("action"), 0);
	}
	if (!(zephir_array_isset_string(&params, SL("method")))) {
		ZEPHIR_INIT_VAR(&_0$$6);
		ZVAL_STRING(&_0$$6, "post");
		zephir_array_update_string(&params, SL("method"), &_0$$6, PH_COPY | PH_SEPARATE);
	}
	ZEPHIR_INIT_VAR(&action);
	ZVAL_NULL(&action);
	if (!(ZEPHIR_IS_EMPTY(&paramsAction))) {
		ZEPHIR_CALL_SELF(&_1$$7, "geturlservice", NULL, 0);
		zephir_check_call_status();
		ZEPHIR_CALL_METHOD(&action, &_1$$7, "get", NULL, 0, &paramsAction);
		zephir_check_call_status();
	}
	ZEPHIR_OBS_NVAR(parameters);
	if (zephir_array_isset_string_fetch(parameters, &params, SL("parameters"), 0)) {
		ZEPHIR_INIT_VAR(&_2$$8);
		ZEPHIR_CONCAT_SV(&_2$$8, "?", parameters);
		zephir_concat_self(&action, &_2$$8);
	}
	if (!(ZEPHIR_IS_EMPTY(&action))) {
		zephir_array_update_string(&params, SL("action"), &action, PH_COPY | PH_SEPARATE);
	}
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "<form");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_3, &params);
	zephir_check_call_status();
	zephir_concat_self_str(&code, SL(">"));
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, friendlyTitle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool lowercase;
	zval *text_param = NULL, *separator_param = NULL, *lowercase_param = NULL, *replace = NULL, replace_sub, __$null, ex, _2, _0$$3, _1$$3, _3$$4, _4$$4;
	zval text, separator;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&separator);
	ZVAL_UNDEF(&replace_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&ex);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_4$$4);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(separator)
		Z_PARAM_BOOL(lowercase)
		Z_PARAM_ZVAL_OR_NULL(replace)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &text_param, &separator_param, &lowercase_param, &replace);
	zephir_get_strval(&text, text_param);
	if (!separator_param) {
		ZEPHIR_INIT_VAR(&separator);
		ZVAL_STRING(&separator, "-");
	} else {
		zephir_get_strval(&separator, separator_param);
	}
	if (!lowercase_param) {
		lowercase = 1;
	} else {
		}
	if (!replace) {
		replace = &replace_sub;
		replace = &__$null;
	}
	/* try_start_1: */

		ZEPHIR_INIT_VAR(&_0$$3);
		object_init_ex(&_0$$3, phalcon_support_helper_str_friendly_ce);
		if (zephir_has_constructor(&_0$$3)) {
			ZEPHIR_CALL_METHOD(NULL, &_0$$3, "__construct", NULL, 0);
			zephir_check_call_status_or_jump(try_end_1);
		}

		if (lowercase) {
			ZVAL_BOOL(&_1$$3, 1);
		} else {
			ZVAL_BOOL(&_1$$3, 0);
		}
		ZEPHIR_RETURN_CALL_METHOD(&_0$$3, "__invoke", NULL, 0, &text, &separator, &_1$$3, replace);
		zephir_check_call_status_or_jump(try_end_1);
		RETURN_MM();

	try_end_1:

	if (EG(exception)) {
		ZEPHIR_INIT_VAR(&_2);
		ZVAL_OBJ(&_2, EG(exception));
		Z_ADDREF_P(&_2);
		if (zephir_is_instance_of(&_2, SL("Exception"))) {
			zend_clear_exception();
			ZEPHIR_CPY_WRT(&ex, &_2);
			ZEPHIR_INIT_VAR(&_3$$4);
			object_init_ex(&_3$$4, phalcon_tag_exception_ce);
			ZEPHIR_CALL_METHOD(&_4$$4, &ex, "getmessage", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(NULL, &_3$$4, "__construct", NULL, 33, &_4$$4);
			zephir_check_call_status();
			zephir_throw_exception_debug(&_3$$4, "phalcon/Tag.zep", 308);
			ZEPHIR_MM_RESTORE();
			return;
		}
	}
}

static PHP_METHOD(Phalcon_Tag, getDocType)
{
	zval _0, _1$$3, _2$$4, _3$$4, _4$$5, _5$$5, _6$$6, _7$$6, _8$$7, _9$$7, _10$$8, _11$$8, _12$$9, _13$$9, _14$$10, _15$$10, _16$$11, _17$$11, _18$$12;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$4);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_4$$5);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&_6$$6);
	ZVAL_UNDEF(&_7$$6);
	ZVAL_UNDEF(&_8$$7);
	ZVAL_UNDEF(&_9$$7);
	ZVAL_UNDEF(&_10$$8);
	ZVAL_UNDEF(&_11$$8);
	ZVAL_UNDEF(&_12$$9);
	ZVAL_UNDEF(&_13$$9);
	ZVAL_UNDEF(&_14$$10);
	ZVAL_UNDEF(&_15$$10);
	ZVAL_UNDEF(&_16$$11);
	ZVAL_UNDEF(&_17$$11);
	ZVAL_UNDEF(&_18$$12);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_static_property_ce(&_0, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	do {
		if (ZEPHIR_IS_LONG(&_0, 1)) {
			ZEPHIR_INIT_VAR(&_1$$3);
			ZEPHIR_GET_CONSTANT(&_1$$3, "PHP_EOL");
			ZEPHIR_CONCAT_SV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\">", &_1$$3);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 2)) {
			ZEPHIR_INIT_VAR(&_2$$4);
			ZEPHIR_GET_CONSTANT(&_2$$4, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_3$$4);
			ZEPHIR_GET_CONSTANT(&_3$$4, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01//EN\"", &_2$$4, "\t\"http://www.w3.org/TR/html4/strict.dtd\">", &_3$$4);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 3)) {
			ZEPHIR_INIT_VAR(&_4$$5);
			ZEPHIR_GET_CONSTANT(&_4$$5, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_5$$5);
			ZEPHIR_GET_CONSTANT(&_5$$5, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"", &_4$$5, "\t\"http://www.w3.org/TR/html4/loose.dtd\">", &_5$$5);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 4)) {
			ZEPHIR_INIT_VAR(&_6$$6);
			ZEPHIR_GET_CONSTANT(&_6$$6, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_7$$6);
			ZEPHIR_GET_CONSTANT(&_7$$6, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"", &_6$$6, "\t\"http://www.w3.org/TR/html4/frameset.dtd\">", &_7$$6);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 6)) {
			ZEPHIR_INIT_VAR(&_8$$7);
			ZEPHIR_GET_CONSTANT(&_8$$7, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_9$$7);
			ZEPHIR_GET_CONSTANT(&_9$$7, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"", &_8$$7, "\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">", &_9$$7);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 7)) {
			ZEPHIR_INIT_VAR(&_10$$8);
			ZEPHIR_GET_CONSTANT(&_10$$8, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_11$$8);
			ZEPHIR_GET_CONSTANT(&_11$$8, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"", &_10$$8, "\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">", &_11$$8);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 8)) {
			ZEPHIR_INIT_VAR(&_12$$9);
			ZEPHIR_GET_CONSTANT(&_12$$9, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_13$$9);
			ZEPHIR_GET_CONSTANT(&_13$$9, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"", &_12$$9, "\t\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\">", &_13$$9);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 9)) {
			ZEPHIR_INIT_VAR(&_14$$10);
			ZEPHIR_GET_CONSTANT(&_14$$10, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_15$$10);
			ZEPHIR_GET_CONSTANT(&_15$$10, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\"", &_14$$10, "\t\"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">", &_15$$10);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 10)) {
			ZEPHIR_INIT_VAR(&_16$$11);
			ZEPHIR_GET_CONSTANT(&_16$$11, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_17$$11);
			ZEPHIR_GET_CONSTANT(&_17$$11, "PHP_EOL");
			ZEPHIR_CONCAT_SVSV(return_value, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 2.0//EN\"", &_16$$11, "\t\"http://www.w3.org/MarkUp/DTD/xhtml2.dtd\">", &_17$$11);
			RETURN_MM();
		}
		if (ZEPHIR_IS_LONG(&_0, 5) || ZEPHIR_IS_LONG(&_0, 11)) {
			ZEPHIR_INIT_VAR(&_18$$12);
			ZEPHIR_GET_CONSTANT(&_18$$12, "PHP_EOL");
			ZEPHIR_CONCAT_SV(return_value, "<!DOCTYPE html>", &_18$$12);
			RETURN_MM();
		}
	} while(0);

	RETURN_MM_STRING("");
}

static PHP_METHOD(Phalcon_Tag, getEscaper)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *params_param = NULL, autoescape;
	zval params;

	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&autoescape);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(params)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &params_param);
	ZEPHIR_OBS_COPY_OR_DUP(&params, params_param);
	zephir_memory_observe(&autoescape);
	if (!(zephir_array_isset_string_fetch(&autoescape, &params, SL("escape"), 0))) {
		ZEPHIR_OBS_NVAR(&autoescape);
		zephir_read_static_property_ce(&autoescape, phalcon_tag_ce, SL("autoEscape"), PH_NOISY_CC);
	}
	if (!(zephir_is_true(&autoescape))) {
		RETURN_MM_NULL();
	}
	ZEPHIR_RETURN_CALL_SELF("getescaperservice", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, getDI)
{
	zval di;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&di);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&di);
	zephir_read_static_property_ce(&di, phalcon_tag_ce, SL("container"), PH_NOISY_CC);
	if (Z_TYPE_P(&di) == IS_NULL) {
		ZEPHIR_CALL_CE_STATIC(&di, phalcon_di_di_ce, "getdefault", NULL, 0);
		zephir_check_call_status();
	}
	RETURN_CCTOR(&di);
}

static PHP_METHOD(Phalcon_Tag, getEscaperService)
{
	zval escaper, container, _0$$3, _1$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&escaper);
	ZVAL_UNDEF(&container);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$3);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&escaper);
	zephir_read_static_property_ce(&escaper, phalcon_tag_ce, SL("escaperService"), PH_NOISY_CC);
	if (Z_TYPE_P(&escaper) != IS_OBJECT) {
		ZEPHIR_CALL_SELF(&container, "getdi", NULL, 0);
		zephir_check_call_status();
		if (Z_TYPE_P(&container) == IS_NULL) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "A dependency injection container is required to access the 'escaper' service", "phalcon/Tag.zep", 403);
			return;
		}
		ZEPHIR_INIT_VAR(&_1$$3);
		ZVAL_STRING(&_1$$3, "escaper");
		ZEPHIR_CALL_METHOD(&_0$$3, &container, "getshared", NULL, 0, &_1$$3);
		zephir_check_call_status();
		ZEPHIR_CPY_WRT(&escaper, &_0$$3);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("escaperService"), &escaper);
	}
	RETURN_CCTOR(&escaper);
}

static PHP_METHOD(Phalcon_Tag, getTitle)
{
	zval _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_10 = NULL, *_12 = NULL, *_19 = NULL, *_21 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *prepend_param = NULL, *append_param = NULL, __$true, items, output, title, documentTitle, documentAppendTitle, documentPrependTitle, documentTitleSeparator, escaper, _0, _2, _3, _4$$3, _6$$3, _5$$4, tmp$$5, *_7$$5, _8$$5, _9$$6, _11$$7, _13$$9, _15$$9, _14$$10, *_16$$11, _17$$11, _18$$12, _20$$13;
	zend_bool prepend, append;

	ZVAL_BOOL(&__$true, 1);
	ZVAL_UNDEF(&items);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&title);
	ZVAL_UNDEF(&documentTitle);
	ZVAL_UNDEF(&documentAppendTitle);
	ZVAL_UNDEF(&documentPrependTitle);
	ZVAL_UNDEF(&documentTitleSeparator);
	ZVAL_UNDEF(&escaper);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4$$3);
	ZVAL_UNDEF(&_6$$3);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&tmp$$5);
	ZVAL_UNDEF(&_8$$5);
	ZVAL_UNDEF(&_9$$6);
	ZVAL_UNDEF(&_11$$7);
	ZVAL_UNDEF(&_13$$9);
	ZVAL_UNDEF(&_15$$9);
	ZVAL_UNDEF(&_14$$10);
	ZVAL_UNDEF(&_17$$11);
	ZVAL_UNDEF(&_18$$12);
	ZVAL_UNDEF(&_20$$13);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(prepend)
		Z_PARAM_BOOL(append)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &prepend_param, &append_param);
	if (!prepend_param) {
		prepend = 1;
	} else {
		}
	if (!append_param) {
		append = 1;
	} else {
		}
	ZEPHIR_INIT_VAR(&_1);
	zephir_create_array(&_1, 1, 0);
	zephir_array_update_string(&_1, SL("escape"), &__$true, PH_COPY | PH_SEPARATE);
	ZEPHIR_CALL_SELF(&_0, "getescaper", NULL, 0, &_1);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&escaper, &_0);
	ZEPHIR_INIT_VAR(&items);
	array_init(&items);
	ZEPHIR_INIT_VAR(&output);
	ZVAL_STRING(&output, "");
	zephir_read_static_property_ce(&_2, phalcon_tag_ce, SL("documentTitle"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CALL_METHOD(&documentTitle, &escaper, "escapehtml", NULL, 0, &_2);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_3, phalcon_tag_ce, SL("documentTitleSeparator"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CALL_METHOD(&documentTitleSeparator, &escaper, "escapehtml", NULL, 0, &_3);
	zephir_check_call_status();
	if (prepend) {
		zephir_read_static_property_ce(&_4$$3, phalcon_tag_ce, SL("documentPrependTitle"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_4$$3) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_5$$4);
			array_init(&_5$$4);
			zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentPrependTitle"), &_5$$4);
		}
		zephir_memory_observe(&_6$$3);
		zephir_read_static_property_ce(&_6$$3, phalcon_tag_ce, SL("documentPrependTitle"), PH_NOISY_CC);
		ZEPHIR_CPY_WRT(&documentPrependTitle, &_6$$3);
		if (!(ZEPHIR_IS_EMPTY(&documentPrependTitle))) {
			ZEPHIR_CALL_FUNCTION(&tmp$$5, "array_reverse", NULL, 297, &documentPrependTitle);
			zephir_check_call_status();
			zephir_is_iterable(&tmp$$5, 0, "phalcon/Tag.zep", 443);
			if (Z_TYPE_P(&tmp$$5) == IS_ARRAY) {
				ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&tmp$$5), _7$$5)
				{
					ZEPHIR_INIT_NVAR(&title);
					ZVAL_COPY(&title, _7$$5);
					ZEPHIR_CALL_METHOD(&_9$$6, &escaper, "escapehtml", &_10, 0, &title);
					zephir_check_call_status();
					zephir_array_append(&items, &_9$$6, PH_SEPARATE, "phalcon/Tag.zep", 441);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &tmp$$5, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_8$$5, &tmp$$5, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_8$$5)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&title, &tmp$$5, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_CALL_METHOD(&_11$$7, &escaper, "escapehtml", &_12, 0, &title);
						zephir_check_call_status();
						zephir_array_append(&items, &_11$$7, PH_SEPARATE, "phalcon/Tag.zep", 441);
					ZEPHIR_CALL_METHOD(NULL, &tmp$$5, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&title);
		}
	}
	if (!(ZEPHIR_IS_EMPTY(&documentTitle))) {
		zephir_array_append(&items, &documentTitle, PH_SEPARATE, "phalcon/Tag.zep", 447);
	}
	if (append) {
		zephir_read_static_property_ce(&_13$$9, phalcon_tag_ce, SL("documentAppendTitle"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_13$$9) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_14$$10);
			array_init(&_14$$10);
			zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentAppendTitle"), &_14$$10);
		}
		zephir_memory_observe(&_15$$9);
		zephir_read_static_property_ce(&_15$$9, phalcon_tag_ce, SL("documentAppendTitle"), PH_NOISY_CC);
		ZEPHIR_CPY_WRT(&documentAppendTitle, &_15$$9);
		if (!(ZEPHIR_IS_EMPTY(&documentAppendTitle))) {
			zephir_is_iterable(&documentAppendTitle, 0, "phalcon/Tag.zep", 461);
			if (Z_TYPE_P(&documentAppendTitle) == IS_ARRAY) {
				ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&documentAppendTitle), _16$$11)
				{
					ZEPHIR_INIT_NVAR(&title);
					ZVAL_COPY(&title, _16$$11);
					ZEPHIR_CALL_METHOD(&_18$$12, &escaper, "escapehtml", &_19, 0, &title);
					zephir_check_call_status();
					zephir_array_append(&items, &_18$$12, PH_SEPARATE, "phalcon/Tag.zep", 459);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &documentAppendTitle, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_17$$11, &documentAppendTitle, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_17$$11)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&title, &documentAppendTitle, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_CALL_METHOD(&_20$$13, &escaper, "escapehtml", &_21, 0, &title);
						zephir_check_call_status();
						zephir_array_append(&items, &_20$$13, PH_SEPARATE, "phalcon/Tag.zep", 459);
					ZEPHIR_CALL_METHOD(NULL, &documentAppendTitle, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&title);
		}
	}
	if (ZEPHIR_IS_EMPTY(&documentTitleSeparator)) {
		ZEPHIR_INIT_NVAR(&documentTitleSeparator);
		ZVAL_STRING(&documentTitleSeparator, "");
	}
	if (!(ZEPHIR_IS_EMPTY(&items))) {
		ZEPHIR_INIT_NVAR(&output);
		zephir_fast_join(&output, &documentTitleSeparator, &items);
	}
	RETURN_CCTOR(&output);
}

static PHP_METHOD(Phalcon_Tag, getTitleSeparator)
{
	zval _0;

	ZVAL_UNDEF(&_0);
	zephir_read_static_property_ce(&_0, phalcon_tag_ce, SL("documentTitleSeparator"), PH_NOISY_CC | PH_READONLY);
	RETURN_CTORW(&_0);
}

static PHP_METHOD(Phalcon_Tag, getUrlService)
{
	zval url, container, _0$$3, _1$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&url);
	ZVAL_UNDEF(&container);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$3);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&url);
	zephir_read_static_property_ce(&url, phalcon_tag_ce, SL("urlService"), PH_NOISY_CC);
	if (Z_TYPE_P(&url) != IS_OBJECT) {
		ZEPHIR_CALL_SELF(&container, "getdi", NULL, 0);
		zephir_check_call_status();
		if (Z_TYPE_P(&container) == IS_NULL) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "A dependency injection container is required to access the 'url' service", "phalcon/Tag.zep", 498);
			return;
		}
		ZEPHIR_INIT_VAR(&_1$$3);
		ZVAL_STRING(&_1$$3, "url");
		ZEPHIR_CALL_METHOD(&_0$$3, &container, "getshared", NULL, 0, &_1$$3);
		zephir_check_call_status();
		ZEPHIR_CPY_WRT(&url, &_0$$3);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("urlService"), &url);
	}
	RETURN_CCTOR(&url);
}

static PHP_METHOD(Phalcon_Tag, getValue)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval params;
	zval *name, name_sub, *params_param = NULL, _POST, value, _0$$3;

	ZVAL_UNDEF(&name_sub);
	ZVAL_UNDEF(&_POST);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&params);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(name)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(params)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_get_global(&_POST, SL("_POST"));
	zephir_fetch_params(1, 1, 1, &name, &params_param);
	if (!params_param) {
		ZEPHIR_INIT_VAR(&params);
		array_init(&params);
	} else {
		zephir_get_arrval(&params, params_param);
	}
	zephir_memory_observe(&value);
	if (!(zephir_array_isset_string_fetch(&value, &params, SL("value"), 0))) {
		ZEPHIR_OBS_NVAR(&value);
		zephir_read_static_property_ce(&_0$$3, phalcon_tag_ce, SL("displayValues"), PH_NOISY_CC | PH_READONLY);
		if (!(zephir_array_isset_fetch(&value, &_0$$3, name, 0))) {
			ZEPHIR_OBS_NVAR(&value);
			if (!(zephir_array_isset_fetch(&value, &_POST, name, 0))) {
				RETURN_MM_NULL();
			}
		}
	}
	RETURN_CCTOR(&value);
}

static PHP_METHOD(Phalcon_Tag, hasValue)
{
	zend_bool _1;
	zval *name, name_sub, _POST, _0;

	ZVAL_UNDEF(&name_sub);
	ZVAL_UNDEF(&_POST);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(name)
	ZEND_PARSE_PARAMETERS_END();
	zephir_get_global(&_POST, SL("_POST"));
	zephir_fetch_params_without_memory_grow(1, 0, &name);
	zephir_read_static_property_ce(&_0, phalcon_tag_ce, SL("displayValues"), PH_NOISY_CC | PH_READONLY);
	_1 = zephir_array_isset(&_0, name);
	if (!(_1)) {
		_1 = zephir_array_isset(&_POST, name);
	}
	RETURN_BOOL(_1);
}

static PHP_METHOD(Phalcon_Tag, hiddenField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "hidden");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, image)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool local;
	zval *parameters = NULL, parameters_sub, *local_param = NULL, __$null, params, code, src, _5, _6, _0$$5, _1$$8, _2$$9, _3$$9, _4$$9;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&src);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_0$$5);
	ZVAL_UNDEF(&_1$$8);
	ZVAL_UNDEF(&_2$$9);
	ZVAL_UNDEF(&_3$$9);
	ZVAL_UNDEF(&_4$$9);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(parameters)
		Z_PARAM_BOOL(local)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &parameters, &local_param);
	if (!parameters) {
		parameters = &parameters_sub;
		parameters = &__$null;
	}
	if (!local_param) {
		local = 1;
	} else {
		}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 1, 0);
		zephir_array_fast_append(&params, parameters);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
		if (zephir_array_isset_long(&params, 1)) {
			zephir_memory_observe(&_0$$5);
			zephir_array_fetch_long(&_0$$5, &params, 1, PH_NOISY, "phalcon/Tag.zep", 581);
			local = zephir_get_boolval(&_0$$5);
		}
	}
	if (!(zephir_array_isset_string(&params, SL("src")))) {
		zephir_memory_observe(&src);
		if (zephir_array_isset_long_fetch(&src, &params, 0, 0)) {
			zephir_array_update_string(&params, SL("src"), &src, PH_COPY | PH_SEPARATE);
		} else {
			ZEPHIR_INIT_VAR(&_1$$8);
			ZVAL_STRING(&_1$$8, "");
			zephir_array_update_string(&params, SL("src"), &_1$$8, PH_COPY | PH_SEPARATE);
		}
	}
	if (local) {
		ZEPHIR_CALL_SELF(&_2$$9, "geturlservice", NULL, 0);
		zephir_check_call_status();
		zephir_array_fetch_string(&_4$$9, &params, SL("src"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 597);
		ZEPHIR_CALL_METHOD(&_3$$9, &_2$$9, "getstatic", NULL, 0, &_4$$9);
		zephir_check_call_status();
		zephir_array_update_string(&params, SL("src"), &_3$$9, PH_COPY | PH_SEPARATE);
	}
	ZEPHIR_INIT_VAR(&_5);
	ZVAL_STRING(&_5, "<img");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_5, &params);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_6, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	if (ZEPHIR_GT_LONG(&_6, 5)) {
		zephir_concat_self_str(&code, SL(" />"));
	} else {
		zephir_concat_self_str(&code, SL(">"));
	}
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, imageInput)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1, _2;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "image");
	ZVAL_BOOL(&_2, 1);
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters, &_2);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, javascriptInclude)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool local, _3;
	zval *parameters = NULL, parameters_sub, *local_param = NULL, __$null, params, code, _4, _11, _12, _0$$3, _1$$5, _2$$7, _5$$8, _6$$10, _7$$11, _8$$12, _9$$12, _10$$12;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_11);
	ZVAL_UNDEF(&_12);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$5);
	ZVAL_UNDEF(&_2$$7);
	ZVAL_UNDEF(&_5$$8);
	ZVAL_UNDEF(&_6$$10);
	ZVAL_UNDEF(&_7$$11);
	ZVAL_UNDEF(&_8$$12);
	ZVAL_UNDEF(&_9$$12);
	ZVAL_UNDEF(&_10$$12);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(parameters)
		Z_PARAM_BOOL(local)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &parameters, &local_param);
	if (!parameters) {
		parameters = &parameters_sub;
		parameters = &__$null;
	}
	if (!local_param) {
		local = 1;
	} else {
		}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 2, 0);
		zephir_array_fast_append(&params, parameters);
		ZEPHIR_INIT_VAR(&_0$$3);
		ZVAL_BOOL(&_0$$3, local);
		zephir_array_fast_append(&params, &_0$$3);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	if (zephir_array_isset_long(&params, 1)) {
		zephir_memory_observe(&_1$$5);
		zephir_array_fetch_long(&_1$$5, &params, 1, PH_NOISY, "phalcon/Tag.zep", 650);
		local = zephir_get_boolval(&_1$$5);
	} else {
		if (zephir_array_isset_string(&params, SL("local"))) {
			zephir_memory_observe(&_2$$7);
			zephir_array_fetch_string(&_2$$7, &params, SL("local"), PH_NOISY, "phalcon/Tag.zep", 653);
			local = zephir_get_boolval(&_2$$7);
			zephir_array_unset_string(&params, SL("local"), PH_SEPARATE);
		}
	}
	_3 = !(zephir_array_isset_string(&params, SL("type")));
	if (_3) {
		zephir_read_static_property_ce(&_4, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
		_3 = ZEPHIR_LT_LONG(&_4, 5);
	}
	if (_3) {
		ZEPHIR_INIT_VAR(&_5$$8);
		ZVAL_STRING(&_5$$8, "text/javascript");
		zephir_array_update_string(&params, SL("type"), &_5$$8, PH_COPY | PH_SEPARATE);
	}
	if (!(zephir_array_isset_string(&params, SL("src")))) {
		if (zephir_array_isset_long(&params, 0)) {
			zephir_array_fetch_long(&_6$$10, &params, 0, PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 665);
			zephir_array_update_string(&params, SL("src"), &_6$$10, PH_COPY | PH_SEPARATE);
		} else {
			ZEPHIR_INIT_VAR(&_7$$11);
			ZVAL_STRING(&_7$$11, "");
			zephir_array_update_string(&params, SL("src"), &_7$$11, PH_COPY | PH_SEPARATE);
		}
	}
	if (local) {
		ZEPHIR_CALL_SELF(&_8$$12, "geturlservice", NULL, 0);
		zephir_check_call_status();
		zephir_array_fetch_string(&_10$$12, &params, SL("src"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 675);
		ZEPHIR_CALL_METHOD(&_9$$12, &_8$$12, "getstatic", NULL, 0, &_10$$12);
		zephir_check_call_status();
		zephir_array_update_string(&params, SL("src"), &_9$$12, PH_COPY | PH_SEPARATE);
	}
	ZEPHIR_INIT_VAR(&_11);
	ZVAL_STRING(&_11, "<script");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_11, &params);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_11);
	ZEPHIR_GET_CONSTANT(&_11, "PHP_EOL");
	ZEPHIR_INIT_VAR(&_12);
	ZEPHIR_CONCAT_SV(&_12, "></script>", &_11);
	zephir_concat_self(&code, &_12);
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, linkTo)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, *text = NULL, text_sub, *local = NULL, local_sub, __$null, __$true, params, action, query, url, code, _0, _1, _2;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&text_sub);
	ZVAL_UNDEF(&local_sub);
	ZVAL_NULL(&__$null);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&action);
	ZVAL_UNDEF(&query);
	ZVAL_UNDEF(&url);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(parameters)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(text)
		Z_PARAM_ZVAL(local)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &parameters, &text, &local);
	if (!text) {
		text = &text_sub;
		ZEPHIR_CPY_WRT(text, &__$null);
	} else {
		ZEPHIR_SEPARATE_PARAM(text);
	}
	if (!local) {
		local = &local_sub;
		ZEPHIR_CPY_WRT(local, &__$true);
	} else {
		ZEPHIR_SEPARATE_PARAM(local);
	}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 3, 0);
		zephir_array_fast_append(&params, parameters);
		zephir_array_fast_append(&params, text);
		zephir_array_fast_append(&params, local);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	zephir_memory_observe(&action);
	if (!(zephir_array_isset_long_fetch(&action, &params, 0, 0))) {
		ZEPHIR_OBS_NVAR(&action);
		if (!(zephir_array_isset_string_fetch(&action, &params, SL("action"), 0))) {
			ZEPHIR_INIT_NVAR(&action);
			ZVAL_STRING(&action, "");
		} else {
			zephir_array_unset_string(&params, SL("action"), PH_SEPARATE);
		}
	}
	ZEPHIR_OBS_NVAR(text);
	if (!(zephir_array_isset_long_fetch(text, &params, 1, 0))) {
		ZEPHIR_OBS_NVAR(text);
		if (!(zephir_array_isset_string_fetch(text, &params, SL("text"), 0))) {
			ZEPHIR_INIT_NVAR(text);
			ZVAL_STRING(text, "");
		} else {
			zephir_array_unset_string(&params, SL("text"), PH_SEPARATE);
		}
	}
	ZEPHIR_OBS_NVAR(local);
	if (!(zephir_array_isset_long_fetch(local, &params, 2, 0))) {
		ZEPHIR_OBS_NVAR(local);
		if (!(zephir_array_isset_string_fetch(local, &params, SL("local"), 0))) {
			ZEPHIR_INIT_NVAR(local);
			ZVAL_BOOL(local, 1);
		} else {
			zephir_array_unset_string(&params, SL("local"), PH_SEPARATE);
		}
	}
	zephir_memory_observe(&query);
	if (zephir_array_isset_string_fetch(&query, &params, SL("query"), 0)) {
		zephir_array_unset_string(&params, SL("query"), PH_SEPARATE);
	} else {
		ZEPHIR_INIT_NVAR(&query);
		ZVAL_NULL(&query);
	}
	ZEPHIR_CALL_SELF(&url, "geturlservice", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&_0, &url, "get", NULL, 0, &action, &query, local);
	zephir_check_call_status();
	zephir_array_update_string(&params, SL("href"), &_0, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "<a");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_1, &params);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_2);
	ZEPHIR_CONCAT_SVS(&_2, ">", text, "</a>");
	zephir_concat_self(&code, &_2);
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, monthField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "month");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, numericField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "number");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, passwordField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "password");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, prependTitle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *title, title_sub, _0, _1$$3;

	ZVAL_UNDEF(&title_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(title)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &title);
	zephir_read_static_property_ce(&_0, phalcon_tag_ce, SL("documentPrependTitle"), PH_NOISY_CC | PH_READONLY);
	if (Z_TYPE_P(&_0) == IS_NULL) {
		ZEPHIR_INIT_VAR(&_1$$3);
		array_init(&_1$$3);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentPrependTitle"), &_1$$3);
	}
	if (Z_TYPE_P(title) == IS_ARRAY) {
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentPrependTitle"), title);
	} else {
		zephir_update_static_property_array_multi_ce(phalcon_tag_ce, SL("documentPrependTitle"), title, SL("a"), 1);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, preload)
{
	zval _10$$5;
	zend_bool _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, attributes, container, header, href, link, params, response, _2, _3, _0$$3, _4$$7, _5$$5, _6$$5, _7$$5, _8$$5, _9$$5;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&attributes);
	ZVAL_UNDEF(&container);
	ZVAL_UNDEF(&header);
	ZVAL_UNDEF(&href);
	ZVAL_UNDEF(&link);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&response);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_4$$7);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_7$$5);
	ZVAL_UNDEF(&_8$$5);
	ZVAL_UNDEF(&_9$$5);
	ZVAL_UNDEF(&_10$$5);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&params);
	array_init(&params);
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&_0$$3);
		zephir_create_array(&_0$$3, 1, 0);
		zephir_array_fast_append(&_0$$3, parameters);
		ZEPHIR_CPY_WRT(&params, &_0$$3);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	zephir_memory_observe(&href);
	zephir_array_isset_long_fetch(&href, &params, 0, 0);
	ZEPHIR_CALL_SELF(&container, "getdi", NULL, 0);
	zephir_check_call_status();
	_1 = zephir_is_true(&container);
	if (_1) {
		ZEPHIR_INIT_VAR(&_3);
		ZVAL_STRING(&_3, "response");
		ZEPHIR_CALL_METHOD(&_2, &container, "has", NULL, 0, &_3);
		zephir_check_call_status();
		_1 = zephir_is_true(&_2);
	}
	if (_1) {
		if (zephir_array_isset_long(&params, 1)) {
			zephir_memory_observe(&attributes);
			zephir_array_fetch_long(&attributes, &params, 1, PH_NOISY, "phalcon/Tag.zep", 840);
		} else {
			ZEPHIR_INIT_VAR(&_4$$7);
			zephir_create_array(&_4$$7, 1, 0);
			add_assoc_stringl_ex(&_4$$7, SL("as"), SL("style"));
			ZEPHIR_CPY_WRT(&attributes, &_4$$7);
		}
		ZEPHIR_INIT_VAR(&_5$$5);
		ZVAL_STRING(&_5$$5, "response");
		ZEPHIR_CALL_METHOD(&response, &container, "get", NULL, 0, &_5$$5);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&link);
		object_init_ex(&link, phalcon_html_link_link_ce);
		ZEPHIR_INIT_NVAR(&_5$$5);
		ZEPHIR_INIT_VAR(&_6$$5);
		ZVAL_STRING(&_6$$5, "'");
		ZEPHIR_INIT_VAR(&_7$$5);
		ZVAL_STRING(&_7$$5, "");
		zephir_fast_str_replace(&_5$$5, &_6$$5, &_7$$5, &href);
		ZEPHIR_INIT_VAR(&_8$$5);
		ZVAL_STRING(&_8$$5, "preload");
		ZEPHIR_CALL_METHOD(NULL, &link, "__construct", NULL, 499, &_8$$5, &_5$$5, &attributes);
		zephir_check_call_status();
		ZEPHIR_INIT_NVAR(&_8$$5);
		object_init_ex(&_8$$5, phalcon_html_link_serializer_header_ce);
		if (zephir_has_constructor(&_8$$5)) {
			ZEPHIR_CALL_METHOD(NULL, &_8$$5, "__construct", NULL, 0);
			zephir_check_call_status();
		}

		ZEPHIR_INIT_VAR(&_10$$5);
		zephir_create_array(&_10$$5, 1, 0);
		zephir_array_fast_append(&_10$$5, &link);
		ZEPHIR_CALL_METHOD(&_9$$5, &_8$$5, "serialize", NULL, 500, &_10$$5);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&header);
		ZEPHIR_CONCAT_SV(&header, "Link: ", &_9$$5);
		ZEPHIR_CALL_METHOD(NULL, &response, "setrawheader", NULL, 0, &header);
		zephir_check_call_status();
	}
	RETURN_CCTOR(&href);
}

static PHP_METHOD(Phalcon_Tag, radioField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "radio");
	ZEPHIR_RETURN_CALL_SELF("inputfieldchecked", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, rangeField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "range");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, renderAttributes)
{
	zend_bool _13$$11, _14$$12, _21$$16, _22$$17;
	zend_string *_3, *_7, *_12;
	zend_ulong _2, _6, _11;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_18 = NULL, *_19 = NULL, *_26 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval attributes;
	zval *code_param = NULL, *attributes_param = NULL, __$null, order, escaper, attrs, attribute, value, escaped, key, newCode, *_0, _1, *_4, _5, _8, *_9, _10, _20$$12, _15$$13, _16$$13, _17$$13, _27$$17, _23$$18, _24$$18, _25$$18;
	zval code;

	ZVAL_UNDEF(&code);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&order);
	ZVAL_UNDEF(&escaper);
	ZVAL_UNDEF(&attrs);
	ZVAL_UNDEF(&attribute);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&escaped);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&newCode);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_8);
	ZVAL_UNDEF(&_10);
	ZVAL_UNDEF(&_20$$12);
	ZVAL_UNDEF(&_15$$13);
	ZVAL_UNDEF(&_16$$13);
	ZVAL_UNDEF(&_17$$13);
	ZVAL_UNDEF(&_27$$17);
	ZVAL_UNDEF(&_23$$18);
	ZVAL_UNDEF(&_24$$18);
	ZVAL_UNDEF(&_25$$18);
	ZVAL_UNDEF(&attributes);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(code)
		Z_PARAM_ARRAY(attributes)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &code_param, &attributes_param);
	if (UNEXPECTED(Z_TYPE_P(code_param) != IS_STRING && Z_TYPE_P(code_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'code' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(code_param) == IS_STRING)) {
		zephir_get_strval(&code, code_param);
	} else {
		ZEPHIR_INIT_VAR(&code);
	}
	ZEPHIR_OBS_COPY_OR_DUP(&attributes, attributes_param);
	ZEPHIR_INIT_VAR(&order);
	zephir_create_array(&order, 10, 0);
	zephir_array_update_string(&order, SL("rel"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("type"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("for"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("src"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("href"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("action"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("id"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("name"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("value"), &__$null, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&order, SL("class"), &__$null, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_VAR(&attrs);
	array_init(&attrs);
	zephir_is_iterable(&order, 0, "phalcon/Tag.zep", 935);
	if (Z_TYPE_P(&order) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&order), _2, _3, _0)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_3 != NULL) { 
				ZVAL_STR_COPY(&key, _3);
			} else {
				ZVAL_LONG(&key, _2);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _0);
			ZEPHIR_OBS_NVAR(&attribute);
			if (zephir_array_isset_fetch(&attribute, &attributes, &key, 0)) {
				zephir_array_update_zval(&attrs, &key, &attribute, PH_COPY | PH_SEPARATE);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &order, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &order, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &order, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &order, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_OBS_NVAR(&attribute);
				if (zephir_array_isset_fetch(&attribute, &attributes, &key, 0)) {
					zephir_array_update_zval(&attrs, &key, &attribute, PH_COPY | PH_SEPARATE);
				}
			ZEPHIR_CALL_METHOD(NULL, &order, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	zephir_is_iterable(&attributes, 0, "phalcon/Tag.zep", 941);
	if (Z_TYPE_P(&attributes) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&attributes), _6, _7, _4)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_7 != NULL) { 
				ZVAL_STR_COPY(&key, _7);
			} else {
				ZVAL_LONG(&key, _6);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _4);
			if (!(zephir_array_isset(&attrs, &key))) {
				zephir_array_update_zval(&attrs, &key, &value, PH_COPY | PH_SEPARATE);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &attributes, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_5, &attributes, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_5)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &attributes, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &attributes, "current", NULL, 0);
			zephir_check_call_status();
				if (!(zephir_array_isset(&attrs, &key))) {
					zephir_array_update_zval(&attrs, &key, &value, PH_COPY | PH_SEPARATE);
				}
			ZEPHIR_CALL_METHOD(NULL, &attributes, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	ZEPHIR_CALL_SELF(&_8, "getescaper", NULL, 0, &attributes);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&escaper, &_8);
	zephir_array_unset_string(&attrs, SL("escape"), PH_SEPARATE);
	ZEPHIR_CPY_WRT(&newCode, &code);
	zephir_is_iterable(&attrs, 0, "phalcon/Tag.zep", 965);
	if (Z_TYPE_P(&attrs) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&attrs), _11, _12, _9)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_12 != NULL) { 
				ZVAL_STR_COPY(&key, _12);
			} else {
				ZVAL_LONG(&key, _11);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _9);
			_13$$11 = Z_TYPE_P(&key) == IS_STRING;
			if (_13$$11) {
				_13$$11 = Z_TYPE_P(&value) != IS_NULL;
			}
			if (_13$$11) {
				_14$$12 = Z_TYPE_P(&value) == IS_ARRAY;
				if (!(_14$$12)) {
					_14$$12 = Z_TYPE_P(&value) == IS_RESOURCE;
				}
				if (UNEXPECTED(_14$$12)) {
					ZEPHIR_INIT_NVAR(&_15$$13);
					object_init_ex(&_15$$13, phalcon_tag_exception_ce);
					ZEPHIR_INIT_NVAR(&_16$$13);
					zephir_gettype(&_16$$13, &value);
					ZEPHIR_INIT_NVAR(&_17$$13);
					ZEPHIR_CONCAT_SVSVS(&_17$$13, "Value at index: '", &key, "' type: '", &_16$$13, "' cannot be rendered");
					ZEPHIR_CALL_METHOD(NULL, &_15$$13, "__construct", &_18, 33, &_17$$13);
					zephir_check_call_status();
					zephir_throw_exception_debug(&_15$$13, "phalcon/Tag.zep", 952);
					ZEPHIR_MM_RESTORE();
					return;
				}
				if (zephir_is_true(&escaper)) {
					ZEPHIR_CALL_METHOD(&escaped, &escaper, "escapehtmlattr", &_19, 0, &value);
					zephir_check_call_status();
				} else {
					ZEPHIR_CPY_WRT(&escaped, &value);
				}
				ZEPHIR_INIT_NVAR(&_20$$12);
				ZEPHIR_CONCAT_SVSVS(&_20$$12, " ", &key, "=\"", &escaped, "\"");
				zephir_concat_self(&newCode, &_20$$12);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &attrs, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_10, &attrs, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_10)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &attrs, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &attrs, "current", NULL, 0);
			zephir_check_call_status();
				_21$$16 = Z_TYPE_P(&key) == IS_STRING;
				if (_21$$16) {
					_21$$16 = Z_TYPE_P(&value) != IS_NULL;
				}
				if (_21$$16) {
					_22$$17 = Z_TYPE_P(&value) == IS_ARRAY;
					if (!(_22$$17)) {
						_22$$17 = Z_TYPE_P(&value) == IS_RESOURCE;
					}
					if (UNEXPECTED(_22$$17)) {
						ZEPHIR_INIT_NVAR(&_23$$18);
						object_init_ex(&_23$$18, phalcon_tag_exception_ce);
						ZEPHIR_INIT_NVAR(&_24$$18);
						zephir_gettype(&_24$$18, &value);
						ZEPHIR_INIT_NVAR(&_25$$18);
						ZEPHIR_CONCAT_SVSVS(&_25$$18, "Value at index: '", &key, "' type: '", &_24$$18, "' cannot be rendered");
						ZEPHIR_CALL_METHOD(NULL, &_23$$18, "__construct", &_18, 33, &_25$$18);
						zephir_check_call_status();
						zephir_throw_exception_debug(&_23$$18, "phalcon/Tag.zep", 952);
						ZEPHIR_MM_RESTORE();
						return;
					}
					if (zephir_is_true(&escaper)) {
						ZEPHIR_CALL_METHOD(&escaped, &escaper, "escapehtmlattr", &_26, 0, &value);
						zephir_check_call_status();
					} else {
						ZEPHIR_CPY_WRT(&escaped, &value);
					}
					ZEPHIR_INIT_NVAR(&_27$$17);
					ZEPHIR_CONCAT_SVSVS(&_27$$17, " ", &key, "=\"", &escaped, "\"");
					zephir_concat_self(&newCode, &_27$$17);
				}
			ZEPHIR_CALL_METHOD(NULL, &attrs, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	RETURN_CCTOR(&newCode);
}

static PHP_METHOD(Phalcon_Tag, renderTitle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *prepend_param = NULL, *append_param = NULL, _0, _1, _2, _3;
	zend_bool prepend, append;

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(prepend)
		Z_PARAM_BOOL(append)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &prepend_param, &append_param);
	if (!prepend_param) {
		prepend = 1;
	} else {
		}
	if (!append_param) {
		append = 1;
	} else {
		}
	if (prepend) {
		ZVAL_BOOL(&_1, 1);
	} else {
		ZVAL_BOOL(&_1, 0);
	}
	if (append) {
		ZVAL_BOOL(&_2, 1);
	} else {
		ZVAL_BOOL(&_2, 0);
	}
	ZEPHIR_CALL_SELF(&_0, "gettitle", NULL, 0, &_1, &_2);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_3);
	ZEPHIR_GET_CONSTANT(&_3, "PHP_EOL");
	ZEPHIR_CONCAT_SVSV(return_value, "<title>", &_0, "</title>", &_3);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, resetInput)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval __$null, _0, _1, _2;

	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	array_init(&_0);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("displayValues"), &_0);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentTitle"), &__$null);
	ZEPHIR_INIT_VAR(&_1);
	array_init(&_1);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentAppendTitle"), &_1);
	ZEPHIR_INIT_VAR(&_2);
	array_init(&_2);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentPrependTitle"), &_2);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentTitleSeparator"), &__$null);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, searchField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "search");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, select)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, *data = NULL, data_sub, __$null;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&data_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(parameters)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &parameters, &data);
	if (!data) {
		data = &data_sub;
		data = &__$null;
	}
	ZEPHIR_RETURN_CALL_CE_STATIC(phalcon_tag_select_ce, "selectfield", NULL, 0, parameters, data);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, selectStatic)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, *data = NULL, data_sub, __$null;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&data_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(parameters)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &parameters, &data);
	if (!data) {
		data = &data_sub;
		data = &__$null;
	}
	ZEPHIR_RETURN_CALL_CE_STATIC(phalcon_tag_select_ce, "selectfield", NULL, 0, parameters, data);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, setAutoescape)
{
	zval *autoescape_param = NULL, _0;
	zend_bool autoescape;

	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_BOOL(autoescape)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &autoescape_param);
	ZVAL_UNDEF(&_0);
	ZVAL_BOOL(&_0, autoescape);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("autoEscape"), &_0);
}

static PHP_METHOD(Phalcon_Tag, setDefault)
{
	zend_bool _0$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *id_param = NULL, *value, value_sub;
	zval id;

	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(id)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &id_param, &value);
	if (UNEXPECTED(Z_TYPE_P(id_param) != IS_STRING && Z_TYPE_P(id_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'id' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(id_param) == IS_STRING)) {
		zephir_get_strval(&id, id_param);
	} else {
		ZEPHIR_INIT_VAR(&id);
	}
	if (Z_TYPE_P(value) != IS_NULL) {
		_0$$3 = Z_TYPE_P(value) == IS_ARRAY;
		if (!(_0$$3)) {
			_0$$3 = Z_TYPE_P(value) == IS_OBJECT;
		}
		if (UNEXPECTED(_0$$3)) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "Only scalar values can be assigned to UI components", "phalcon/Tag.zep", 1058);
			return;
		}
	}
	zephir_update_static_property_array_multi_ce(phalcon_tag_ce, SL("displayValues"), value, SL("z"), 1, &id);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, setDefaults)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_bool merge, _0;
	zval *values_param = NULL, *merge_param = NULL, _1, _2$$3, _3$$3;
	zval values;

	ZVAL_UNDEF(&values);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(values)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(merge)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &values_param, &merge_param);
	ZEPHIR_OBS_COPY_OR_DUP(&values, values_param);
	if (!merge_param) {
		merge = 0;
	} else {
		}
	_0 = merge;
	if (_0) {
		zephir_memory_observe(&_1);
		zephir_read_static_property_ce(&_1, phalcon_tag_ce, SL("displayValues"), PH_NOISY_CC);
		_0 = Z_TYPE_P(&_1) == IS_ARRAY;
	}
	if (_0) {
		ZEPHIR_INIT_VAR(&_2$$3);
		zephir_read_static_property_ce(&_3$$3, phalcon_tag_ce, SL("displayValues"), PH_NOISY_CC | PH_READONLY);
		zephir_fast_array_merge(&_2$$3, &_3$$3, &values);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("displayValues"), &_2$$3);
	} else {
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("displayValues"), &values);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, setDI)
{
	zval *container, container_sub;

	ZVAL_UNDEF(&container_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_OBJECT_OF_CLASS(container, phalcon_di_diinterface_ce)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &container);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("container"), container);
}

static PHP_METHOD(Phalcon_Tag, setDocType)
{
	zend_bool _0;
	zval *doctype_param = NULL, _1$$3, _2$$4;
	zend_long doctype;

	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$4);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_LONG(doctype)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &doctype_param);
	_0 = doctype < 1;
	if (!(_0)) {
		_0 = doctype > 11;
	}
	if (_0) {
		ZVAL_UNDEF(&_1$$3);
		ZVAL_LONG(&_1$$3, 5);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentType"), &_1$$3);
	} else {
		ZVAL_UNDEF(&_2$$4);
		ZVAL_LONG(&_2$$4, doctype);
		zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentType"), &_2$$4);
	}
}

static PHP_METHOD(Phalcon_Tag, setTitle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *title_param = NULL;
	zval title;

	ZVAL_UNDEF(&title);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(title)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &title_param);
	zephir_get_strval(&title, title_param);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentTitle"), &title);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, setTitleSeparator)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *titleSeparator_param = NULL;
	zval titleSeparator;

	ZVAL_UNDEF(&titleSeparator);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(titleSeparator)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &titleSeparator_param);
	zephir_get_strval(&titleSeparator, titleSeparator_param);
	zephir_update_static_property_ce(phalcon_tag_ce, ZEND_STRL("documentTitleSeparator"), &titleSeparator);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Tag, stylesheetLink)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool local;
	zval *parameters = NULL, parameters_sub, *local_param = NULL, __$null, params, code, _10, _11, _0$$3, _1$$5, _2$$7, _3$$8, _4$$10, _5$$11, _6$$12, _7$$12, _8$$12, _9$$13, _12$$14, _13$$14, _14$$15, _15$$15;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_10);
	ZVAL_UNDEF(&_11);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$5);
	ZVAL_UNDEF(&_2$$7);
	ZVAL_UNDEF(&_3$$8);
	ZVAL_UNDEF(&_4$$10);
	ZVAL_UNDEF(&_5$$11);
	ZVAL_UNDEF(&_6$$12);
	ZVAL_UNDEF(&_7$$12);
	ZVAL_UNDEF(&_8$$12);
	ZVAL_UNDEF(&_9$$13);
	ZVAL_UNDEF(&_12$$14);
	ZVAL_UNDEF(&_13$$14);
	ZVAL_UNDEF(&_14$$15);
	ZVAL_UNDEF(&_15$$15);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(parameters)
		Z_PARAM_BOOL(local)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &parameters, &local_param);
	if (!parameters) {
		parameters = &parameters_sub;
		parameters = &__$null;
	}
	if (!local_param) {
		local = 1;
	} else {
		}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 2, 0);
		zephir_array_fast_append(&params, parameters);
		ZEPHIR_INIT_VAR(&_0$$3);
		ZVAL_BOOL(&_0$$3, local);
		zephir_array_fast_append(&params, &_0$$3);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	if (zephir_array_isset_long(&params, 1)) {
		zephir_memory_observe(&_1$$5);
		zephir_array_fetch_long(&_1$$5, &params, 1, PH_NOISY, "phalcon/Tag.zep", 1127);
		local = zephir_get_boolval(&_1$$5);
	} else {
		if (zephir_array_isset_string(&params, SL("local"))) {
			zephir_memory_observe(&_2$$7);
			zephir_array_fetch_string(&_2$$7, &params, SL("local"), PH_NOISY, "phalcon/Tag.zep", 1130);
			local = zephir_get_boolval(&_2$$7);
			zephir_array_unset_string(&params, SL("local"), PH_SEPARATE);
		}
	}
	if (!(zephir_array_isset_string(&params, SL("type")))) {
		ZEPHIR_INIT_VAR(&_3$$8);
		ZVAL_STRING(&_3$$8, "text/css");
		zephir_array_update_string(&params, SL("type"), &_3$$8, PH_COPY | PH_SEPARATE);
	}
	if (!(zephir_array_isset_string(&params, SL("href")))) {
		if (zephir_array_isset_long(&params, 0)) {
			zephir_array_fetch_long(&_4$$10, &params, 0, PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 1142);
			zephir_array_update_string(&params, SL("href"), &_4$$10, PH_COPY | PH_SEPARATE);
		} else {
			ZEPHIR_INIT_VAR(&_5$$11);
			ZVAL_STRING(&_5$$11, "");
			zephir_array_update_string(&params, SL("href"), &_5$$11, PH_COPY | PH_SEPARATE);
		}
	}
	if (local) {
		ZEPHIR_CALL_SELF(&_6$$12, "geturlservice", NULL, 0);
		zephir_check_call_status();
		zephir_array_fetch_string(&_8$$12, &params, SL("href"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 1154);
		ZEPHIR_CALL_METHOD(&_7$$12, &_6$$12, "getstatic", NULL, 0, &_8$$12);
		zephir_check_call_status();
		zephir_array_update_string(&params, SL("href"), &_7$$12, PH_COPY | PH_SEPARATE);
	}
	if (!(zephir_array_isset_string(&params, SL("rel")))) {
		ZEPHIR_INIT_VAR(&_9$$13);
		ZVAL_STRING(&_9$$13, "stylesheet");
		zephir_array_update_string(&params, SL("rel"), &_9$$13, PH_COPY | PH_SEPARATE);
	}
	ZEPHIR_INIT_VAR(&_10);
	ZVAL_STRING(&_10, "<link");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_10, &params);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_11, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	if (ZEPHIR_GT_LONG(&_11, 5)) {
		ZEPHIR_INIT_VAR(&_12$$14);
		ZEPHIR_GET_CONSTANT(&_12$$14, "PHP_EOL");
		ZEPHIR_INIT_VAR(&_13$$14);
		ZEPHIR_CONCAT_SV(&_13$$14, " />", &_12$$14);
		zephir_concat_self(&code, &_13$$14);
	} else {
		ZEPHIR_INIT_VAR(&_14$$15);
		ZEPHIR_GET_CONSTANT(&_14$$15, "PHP_EOL");
		ZEPHIR_INIT_VAR(&_15$$15);
		ZEPHIR_CONCAT_SV(&_15$$15, ">", &_14$$15);
		zephir_concat_self(&code, &_15$$15);
	}
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, submitButton)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1, _2;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "submit");
	ZVAL_BOOL(&_2, 1);
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters, &_2);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, tagHtml)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool selfClose, onlyStart, useEol;
	zval *tagName_param = NULL, *parameters = NULL, parameters_sub, *selfClose_param = NULL, *onlyStart_param = NULL, *useEol_param = NULL, __$null, params, localCode, _1, _3$$11;
	zval tagName, _0, _2$$10;

	ZVAL_UNDEF(&tagName);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2$$10);
	ZVAL_UNDEF(&parameters_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&localCode);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_3$$11);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 5)
		Z_PARAM_STR(tagName)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(parameters)
		Z_PARAM_BOOL(selfClose)
		Z_PARAM_BOOL(onlyStart)
		Z_PARAM_BOOL(useEol)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 4, &tagName_param, &parameters, &selfClose_param, &onlyStart_param, &useEol_param);
	zephir_get_strval(&tagName, tagName_param);
	if (!parameters) {
		parameters = &parameters_sub;
		parameters = &__$null;
	}
	if (!selfClose_param) {
		selfClose = 0;
	} else {
		}
	if (!onlyStart_param) {
		onlyStart = 0;
	} else {
		}
	if (!useEol_param) {
		useEol = 0;
	} else {
		}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 1, 0);
		zephir_array_fast_append(&params, parameters);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_CONCAT_SV(&_0, "<", &tagName);
	ZEPHIR_CALL_SELF(&localCode, "renderattributes", NULL, 0, &_0, &params);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_1, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	if (ZEPHIR_GT_LONG(&_1, 5)) {
		if (selfClose) {
			zephir_concat_self_str(&localCode, SL(" />"));
		} else {
			zephir_concat_self_str(&localCode, SL(">"));
		}
	} else {
		if (onlyStart) {
			zephir_concat_self_str(&localCode, SL(">"));
		} else {
			ZEPHIR_INIT_VAR(&_2$$10);
			ZEPHIR_CONCAT_SVS(&_2$$10, "></", &tagName, ">");
			zephir_concat_self(&localCode, &_2$$10);
		}
	}
	if (useEol) {
		ZEPHIR_INIT_VAR(&_3$$11);
		ZEPHIR_GET_CONSTANT(&_3$$11, "PHP_EOL");
		zephir_concat_self(&localCode, &_3$$11);
	}
	RETURN_CCTOR(&localCode);
}

static PHP_METHOD(Phalcon_Tag, tagHtmlClose)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_bool useEol;
	zval *tagName_param = NULL, *useEol_param = NULL, _0$$3;
	zval tagName;

	ZVAL_UNDEF(&tagName);
	ZVAL_UNDEF(&_0$$3);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(tagName)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(useEol)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &tagName_param, &useEol_param);
	zephir_get_strval(&tagName, tagName_param);
	if (!useEol_param) {
		useEol = 0;
	} else {
		}
	if (useEol) {
		ZEPHIR_INIT_VAR(&_0$$3);
		ZEPHIR_GET_CONSTANT(&_0$$3, "PHP_EOL");
		ZEPHIR_CONCAT_SVSV(return_value, "</", &tagName, ">", &_0$$3);
		RETURN_MM();
	}
	ZEPHIR_CONCAT_SVS(return_value, "</", &tagName, ">");
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, telField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "tel");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, textArea)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, params, id, name, content, code, _1, _2, _3, _0$$6;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&content);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_0$$6);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 1, 0);
		zephir_array_fast_append(&params, parameters);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	if (!(zephir_array_isset_long(&params, 0))) {
		if (zephir_array_isset_string(&params, SL("id"))) {
			zephir_array_fetch_string(&_0$$6, &params, SL("id"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 1277);
			zephir_array_update_long(&params, 0, &_0$$6, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
		}
	}
	zephir_memory_observe(&id);
	zephir_array_fetch_long(&id, &params, 0, PH_NOISY, "phalcon/Tag.zep", 1281);
	if (!(zephir_array_isset_string(&params, SL("name")))) {
		zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
	} else {
		zephir_memory_observe(&name);
		zephir_array_fetch_string(&name, &params, SL("name"), PH_NOISY, "phalcon/Tag.zep", 1286);
		if (ZEPHIR_IS_EMPTY(&name)) {
			zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
		}
	}
	if (!(zephir_array_isset_string(&params, SL("id")))) {
		zephir_array_update_string(&params, SL("id"), &id, PH_COPY | PH_SEPARATE);
	}
	if (zephir_array_isset_string(&params, SL("value"))) {
		zephir_memory_observe(&content);
		zephir_array_fetch_string(&content, &params, SL("value"), PH_NOISY, "phalcon/Tag.zep", 1298);
		zephir_array_unset_string(&params, SL("value"), PH_SEPARATE);
	} else {
		ZEPHIR_CALL_SELF(&content, "getvalue", NULL, 0, &id, &params);
		zephir_check_call_status();
	}
	if (UNEXPECTED(Z_TYPE_P(&content) == IS_NULL)) {
		ZEPHIR_INIT_NVAR(&content);
		ZVAL_STRING(&content, "");
	}
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "<textarea");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_1, &params);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&_2, "htmlspecialchars", NULL, 286, &content);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_3);
	ZEPHIR_CONCAT_SVS(&_3, ">", &_2, "</textarea>");
	zephir_concat_self(&code, &_3);
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, textField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "text");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, timeField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "time");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, urlField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "url");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, weekField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zephir_fcall_cache_entry *_0 = NULL;
	zval *parameters, parameters_sub, _1;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &parameters);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "week");
	ZEPHIR_RETURN_CALL_SELF("inputfield", &_0, 0, &_1, parameters);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Tag, inputField)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool asValue, _1$$10;
	zval *type_param = NULL, *parameters, parameters_sub, *asValue_param = NULL, params, id, value, code, name, _3, _4, _0$$6, _2$$5;
	zval type;

	ZVAL_UNDEF(&type);
	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_0$$6);
	ZVAL_UNDEF(&_2$$5);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_STR(type)
		Z_PARAM_ZVAL(parameters)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(asValue)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &type_param, &parameters, &asValue_param);
	zephir_get_strval(&type, type_param);
	if (!asValue_param) {
		asValue = 0;
	} else {
		}
	ZEPHIR_INIT_VAR(&params);
	array_init(&params);
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		zephir_array_append(&params, parameters, PH_SEPARATE, "phalcon/Tag.zep", 1396);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	if (asValue == 0) {
		zephir_memory_observe(&id);
		if (!(zephir_array_isset_long_fetch(&id, &params, 0, 0))) {
			zephir_array_fetch_string(&_0$$6, &params, SL("id"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 1403);
			zephir_array_update_long(&params, 0, &_0$$6, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
		}
		zephir_memory_observe(&name);
		if (zephir_array_isset_string_fetch(&name, &params, SL("name"), 0)) {
			if (ZEPHIR_IS_EMPTY(&name)) {
				zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
			}
		} else {
			zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
		}
		if (Z_TYPE_P(&id) == IS_STRING) {
			_1$$10 = !(zephir_memnstr_str(&id, SL("["), "phalcon/Tag.zep", 1418));
			if (_1$$10) {
				_1$$10 = !(zephir_array_isset_string(&params, SL("id")));
			}
			if (_1$$10) {
				zephir_array_update_string(&params, SL("id"), &id, PH_COPY | PH_SEPARATE);
			}
		}
		ZEPHIR_CALL_SELF(&_2$$5, "getvalue", NULL, 0, &id, &params);
		zephir_check_call_status();
		zephir_array_update_string(&params, SL("value"), &_2$$5, PH_COPY | PH_SEPARATE);
	} else {
		if (!(zephir_array_isset_string(&params, SL("value")))) {
			zephir_memory_observe(&value);
			if (zephir_array_isset_long_fetch(&value, &params, 0, 0)) {
				zephir_array_update_string(&params, SL("value"), &value, PH_COPY | PH_SEPARATE);
			}
		}
	}
	zephir_array_update_string(&params, SL("type"), &type, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "<input");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_3, &params);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_4, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	if (ZEPHIR_GT_LONG(&_4, 5)) {
		zephir_concat_self_str(&code, SL(" />"));
	} else {
		zephir_concat_self_str(&code, SL(">"));
	}
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag, inputFieldChecked)
{
	zend_bool _3$$11;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *type_param = NULL, *parameters, parameters_sub, params, value, id, code, name, currentValue, _1, _2, _6, _7, _0$$5, _4$$12, _5$$14;
	zval type;

	ZVAL_UNDEF(&type);
	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&currentValue);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_7);
	ZVAL_UNDEF(&_0$$5);
	ZVAL_UNDEF(&_4$$12);
	ZVAL_UNDEF(&_5$$14);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(type)
		Z_PARAM_ZVAL(parameters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &type_param, &parameters);
	zephir_get_strval(&type, type_param);
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 1, 0);
		zephir_array_fast_append(&params, parameters);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	if (!(zephir_array_isset_long(&params, 0))) {
		zephir_array_fetch_string(&_0$$5, &params, SL("id"), PH_NOISY | PH_READONLY, "phalcon/Tag.zep", 1464);
		zephir_array_update_long(&params, 0, &_0$$5, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
	}
	zephir_memory_observe(&id);
	zephir_array_fetch_long(&id, &params, 0, PH_NOISY, "phalcon/Tag.zep", 1467);
	if (!(zephir_array_isset_string(&params, SL("name")))) {
		zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
	} else {
		zephir_memory_observe(&name);
		zephir_array_fetch_string(&name, &params, SL("name"), PH_NOISY, "phalcon/Tag.zep", 1472);
		if (ZEPHIR_IS_EMPTY(&name)) {
			zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
		}
	}
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "[");
	ZEPHIR_INIT_VAR(&_2);
	zephir_fast_strpos(&_2, &id, &_1, 0 );
	if (!(zephir_is_true(&_2))) {
		if (!(zephir_array_isset_string(&params, SL("id")))) {
			zephir_array_update_string(&params, SL("id"), &id, PH_COPY | PH_SEPARATE);
		}
	}
	zephir_memory_observe(&currentValue);
	if (zephir_array_isset_string_fetch(&currentValue, &params, SL("value"), 0)) {
		zephir_array_unset_string(&params, SL("value"), PH_SEPARATE);
		ZEPHIR_CALL_SELF(&value, "getvalue", NULL, 0, &id, &params);
		zephir_check_call_status();
		_3$$11 = Z_TYPE_P(&value) != IS_NULL;
		if (_3$$11) {
			_3$$11 = ZEPHIR_IS_EQUAL(&currentValue, &value);
		}
		if (_3$$11) {
			ZEPHIR_INIT_VAR(&_4$$12);
			ZVAL_STRING(&_4$$12, "checked");
			zephir_array_update_string(&params, SL("checked"), &_4$$12, PH_COPY | PH_SEPARATE);
		}
		zephir_array_update_string(&params, SL("value"), &currentValue, PH_COPY | PH_SEPARATE);
	} else {
		ZEPHIR_CALL_SELF(&value, "getvalue", NULL, 0, &id, &params);
		zephir_check_call_status();
		if (Z_TYPE_P(&value) != IS_NULL) {
			ZEPHIR_INIT_VAR(&_5$$14);
			ZVAL_STRING(&_5$$14, "checked");
			zephir_array_update_string(&params, SL("checked"), &_5$$14, PH_COPY | PH_SEPARATE);
		}
		zephir_array_update_string(&params, SL("value"), &value, PH_COPY | PH_SEPARATE);
	}
	zephir_array_update_string(&params, SL("type"), &type, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_VAR(&_6);
	ZVAL_STRING(&_6, "<input");
	ZEPHIR_CALL_SELF(&code, "renderattributes", NULL, 0, &_6, &params);
	zephir_check_call_status();
	zephir_read_static_property_ce(&_7, phalcon_tag_ce, SL("documentType"), PH_NOISY_CC | PH_READONLY);
	if (ZEPHIR_GT_LONG(&_7, 5)) {
		zephir_concat_self_str(&code, SL(" />"));
	} else {
		zephir_concat_self_str(&code, SL(">"));
	}
	RETURN_CCTOR(&code);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Tag_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Tag, Exception, phalcon, tag_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Tag_Select)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Tag, Select, phalcon, tag_select, phalcon_tag_select_method_entry, ZEND_ACC_EXPLICIT_ABSTRACT_CLASS);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Tag_Select, selectField)
{
	zend_bool _1$$19;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_7 = NULL, *_11 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *parameters, parameters_sub, *data = NULL, data_sub, __$null, params, name, id, value, useEmpty, code, emptyValue, emptyText, options, using, _2, _3, _0$$5, _4$$22, _5$$22, _6$$23, _8$$23, _9$$23, _10$$25, _12$$25, _13$$25;

	ZVAL_UNDEF(&parameters_sub);
	ZVAL_UNDEF(&data_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&id);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&useEmpty);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&emptyValue);
	ZVAL_UNDEF(&emptyText);
	ZVAL_UNDEF(&options);
	ZVAL_UNDEF(&using);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_0$$5);
	ZVAL_UNDEF(&_4$$22);
	ZVAL_UNDEF(&_5$$22);
	ZVAL_UNDEF(&_6$$23);
	ZVAL_UNDEF(&_8$$23);
	ZVAL_UNDEF(&_9$$23);
	ZVAL_UNDEF(&_10$$25);
	ZVAL_UNDEF(&_12$$25);
	ZVAL_UNDEF(&_13$$25);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(parameters)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &parameters, &data);
	if (!data) {
		data = &data_sub;
		data = &__$null;
	}
	if (Z_TYPE_P(parameters) != IS_ARRAY) {
		ZEPHIR_INIT_VAR(&params);
		zephir_create_array(&params, 2, 0);
		zephir_array_fast_append(&params, parameters);
		zephir_array_fast_append(&params, data);
	} else {
		ZEPHIR_CPY_WRT(&params, parameters);
	}
	zephir_memory_observe(&id);
	if (!(zephir_array_isset_long_fetch(&id, &params, 0, 0))) {
		zephir_array_fetch_string(&_0$$5, &params, SL("id"), PH_NOISY | PH_READONLY, "phalcon/Tag/Select.zep", 50);
		zephir_array_update_long(&params, 0, &_0$$5, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
	}
	if (!(zephir_memnstr_str(&id, SL("["), "phalcon/Tag/Select.zep", 56))) {
		if (!(zephir_array_isset_string(&params, SL("id")))) {
			zephir_array_update_string(&params, SL("id"), &id, PH_COPY | PH_SEPARATE);
		}
	}
	zephir_memory_observe(&name);
	if (!(zephir_array_isset_string_fetch(&name, &params, SL("name"), 0))) {
		zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
	} else {
		if (!(zephir_is_true(&name))) {
			zephir_array_update_string(&params, SL("name"), &id, PH_COPY | PH_SEPARATE);
		}
	}
	zephir_memory_observe(&value);
	if (!(zephir_array_isset_string_fetch(&value, &params, SL("value"), 0))) {
		ZEPHIR_CALL_CE_STATIC(&value, phalcon_tag_ce, "getvalue", NULL, 0, &id, &params);
		zephir_check_call_status();
	} else {
		zephir_array_unset_string(&params, SL("value"), PH_SEPARATE);
	}
	zephir_memory_observe(&useEmpty);
	if (zephir_array_isset_string_fetch(&useEmpty, &params, SL("useEmpty"), 0)) {
		zephir_memory_observe(&emptyValue);
		if (!(zephir_array_isset_string_fetch(&emptyValue, &params, SL("emptyValue"), 0))) {
			ZEPHIR_INIT_NVAR(&emptyValue);
			ZVAL_STRING(&emptyValue, "");
		} else {
			zephir_array_unset_string(&params, SL("emptyValue"), PH_SEPARATE);
		}
		zephir_memory_observe(&emptyText);
		if (!(zephir_array_isset_string_fetch(&emptyText, &params, SL("emptyText"), 0))) {
			ZEPHIR_INIT_NVAR(&emptyText);
			ZVAL_STRING(&emptyText, "Choose...");
		} else {
			zephir_array_unset_string(&params, SL("emptyText"), PH_SEPARATE);
		}
		zephir_array_unset_string(&params, SL("useEmpty"), PH_SEPARATE);
	}
	zephir_memory_observe(&options);
	if (!(zephir_array_isset_long_fetch(&options, &params, 1, 0))) {
		ZEPHIR_CPY_WRT(&options, data);
	}
	if (Z_TYPE_P(&options) == IS_OBJECT) {
		zephir_memory_observe(&using);
		if (UNEXPECTED(!(zephir_array_isset_string_fetch(&using, &params, SL("using"), 0)))) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "The 'using' parameter is required", "phalcon/Tag/Select.zep", 101);
			return;
		}
		_1$$19 = Z_TYPE_P(&using) != IS_ARRAY;
		if (_1$$19) {
			_1$$19 = Z_TYPE_P(&using) != IS_OBJECT;
		}
		if (UNEXPECTED(_1$$19)) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "The 'using' parameter should be an array", "phalcon/Tag/Select.zep", 107);
			return;
		}
	}
	zephir_array_unset_string(&params, SL("using"), PH_SEPARATE);
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "<select");
	ZEPHIR_CALL_CE_STATIC(&_2, phalcon_tag_ce, "renderattributes", NULL, 0, &_3, &params);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_3);
	ZEPHIR_GET_CONSTANT(&_3, "PHP_EOL");
	ZEPHIR_INIT_VAR(&code);
	ZEPHIR_CONCAT_VSV(&code, &_2, ">", &_3);
	if (zephir_is_true(&useEmpty)) {
		ZEPHIR_INIT_VAR(&_4$$22);
		ZEPHIR_GET_CONSTANT(&_4$$22, "PHP_EOL");
		ZEPHIR_INIT_VAR(&_5$$22);
		ZEPHIR_CONCAT_SVSVSV(&_5$$22, "\t<option value=\"", &emptyValue, "\">", &emptyText, "</option>", &_4$$22);
		zephir_concat_self(&code, &_5$$22);
	}
	if (Z_TYPE_P(&options) == IS_OBJECT) {
		ZEPHIR_INIT_VAR(&_8$$23);
		ZEPHIR_GET_CONSTANT(&_8$$23, "PHP_EOL");
		ZEPHIR_INIT_VAR(&_9$$23);
		ZEPHIR_CONCAT_SV(&_9$$23, "</option>", &_8$$23);
		ZEPHIR_CALL_SELF(&_6$$23, "optionsfromresultset", &_7, 0, &options, &using, &value, &_9$$23);
		zephir_check_call_status();
		zephir_concat_self(&code, &_6$$23);
	} else {
		if (Z_TYPE_P(&options) == IS_ARRAY) {
			ZEPHIR_INIT_VAR(&_12$$25);
			ZEPHIR_GET_CONSTANT(&_12$$25, "PHP_EOL");
			ZEPHIR_INIT_VAR(&_13$$25);
			ZEPHIR_CONCAT_SV(&_13$$25, "</option>", &_12$$25);
			ZEPHIR_CALL_SELF(&_10$$25, "optionsfromarray", &_11, 0, &options, &value, &_13$$25);
			zephir_check_call_status();
			zephir_concat_self(&code, &_10$$25);
		}
	}
	zephir_concat_self_str(&code, SL("</select>"));
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag_Select, optionsFromArray)
{
	zend_string *_3;
	zend_ulong _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL, *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval closeOption, _12$$8, _13$$8, _22$$16, _23$$16;
	zval *data_param = NULL, *value, value_sub, *closeOption_param = NULL, strValue, strOptionValue, code, optionValue, optionText, escaped, *_0, _1, _5$$4, _6$$4, _8$$4, _9$$4, _10$$6, _11$$7, _14$$9, _15$$10, _16$$12, _17$$12, _18$$12, _19$$12, _20$$14, _21$$15, _24$$17, _25$$18;
	zval data;

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&strValue);
	ZVAL_UNDEF(&strOptionValue);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&optionValue);
	ZVAL_UNDEF(&optionText);
	ZVAL_UNDEF(&escaped);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&_6$$4);
	ZVAL_UNDEF(&_8$$4);
	ZVAL_UNDEF(&_9$$4);
	ZVAL_UNDEF(&_10$$6);
	ZVAL_UNDEF(&_11$$7);
	ZVAL_UNDEF(&_14$$9);
	ZVAL_UNDEF(&_15$$10);
	ZVAL_UNDEF(&_16$$12);
	ZVAL_UNDEF(&_17$$12);
	ZVAL_UNDEF(&_18$$12);
	ZVAL_UNDEF(&_19$$12);
	ZVAL_UNDEF(&_20$$14);
	ZVAL_UNDEF(&_21$$15);
	ZVAL_UNDEF(&_24$$17);
	ZVAL_UNDEF(&_25$$18);
	ZVAL_UNDEF(&closeOption);
	ZVAL_UNDEF(&_12$$8);
	ZVAL_UNDEF(&_13$$8);
	ZVAL_UNDEF(&_22$$16);
	ZVAL_UNDEF(&_23$$16);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(data)
		Z_PARAM_ZVAL(value)
		Z_PARAM_STR(closeOption)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &data_param, &value, &closeOption_param);
	zephir_get_arrval(&data, data_param);
	zephir_get_strval(&closeOption, closeOption_param);
	ZEPHIR_INIT_VAR(&code);
	ZVAL_STRING(&code, "");
	zephir_is_iterable(&data, 0, "phalcon/Tag/Select.zep", 186);
	if (Z_TYPE_P(&data) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&data), _2, _3, _0)
		{
			ZEPHIR_INIT_NVAR(&optionValue);
			if (_3 != NULL) { 
				ZVAL_STR_COPY(&optionValue, _3);
			} else {
				ZVAL_LONG(&optionValue, _2);
			}
			ZEPHIR_INIT_NVAR(&optionText);
			ZVAL_COPY(&optionText, _0);
			ZEPHIR_CALL_FUNCTION(&escaped, "htmlspecialchars", &_4, 286, &optionValue);
			zephir_check_call_status();
			if (Z_TYPE_P(&optionText) == IS_ARRAY) {
				ZEPHIR_INIT_NVAR(&_5$$4);
				ZEPHIR_GET_CONSTANT(&_5$$4, "PHP_EOL");
				ZEPHIR_CALL_SELF(&_6$$4, "optionsfromarray", &_7, 0, &optionText, value, &closeOption);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_8$$4);
				ZEPHIR_GET_CONSTANT(&_8$$4, "PHP_EOL");
				ZEPHIR_INIT_NVAR(&_9$$4);
				ZEPHIR_CONCAT_SVSVVSV(&_9$$4, "\t<optgroup label=\"", &escaped, "\">", &_5$$4, &_6$$4, "\t</optgroup>", &_8$$4);
				zephir_concat_self(&code, &_9$$4);
				continue;
			}
			if (Z_TYPE_P(value) == IS_ARRAY) {
				if (zephir_fast_in_array(&optionValue, value)) {
					ZEPHIR_INIT_NVAR(&_10$$6);
					ZEPHIR_CONCAT_SVSVV(&_10$$6, "\t<option selected=\"selected\" value=\"", &escaped, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_10$$6);
				} else {
					ZEPHIR_INIT_NVAR(&_11$$7);
					ZEPHIR_CONCAT_SVSVV(&_11$$7, "\t<option value=\"", &escaped, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_11$$7);
				}
			} else {
				zephir_cast_to_string(&_12$$8, &optionValue);
				ZEPHIR_CPY_WRT(&strOptionValue, &_12$$8);
				zephir_cast_to_string(&_13$$8, value);
				ZEPHIR_CPY_WRT(&strValue, &_13$$8);
				if (ZEPHIR_IS_IDENTICAL(&strOptionValue, &strValue)) {
					ZEPHIR_INIT_NVAR(&_14$$9);
					ZEPHIR_CONCAT_SVSVV(&_14$$9, "\t<option selected=\"selected\" value=\"", &escaped, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_14$$9);
				} else {
					ZEPHIR_INIT_NVAR(&_15$$10);
					ZEPHIR_CONCAT_SVSVV(&_15$$10, "\t<option value=\"", &escaped, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_15$$10);
				}
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &data, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &data, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&optionValue, &data, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&optionText, &data, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_FUNCTION(&escaped, "htmlspecialchars", &_4, 286, &optionValue);
				zephir_check_call_status();
				if (Z_TYPE_P(&optionText) == IS_ARRAY) {
					ZEPHIR_INIT_NVAR(&_16$$12);
					ZEPHIR_GET_CONSTANT(&_16$$12, "PHP_EOL");
					ZEPHIR_CALL_SELF(&_17$$12, "optionsfromarray", &_7, 0, &optionText, value, &closeOption);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_18$$12);
					ZEPHIR_GET_CONSTANT(&_18$$12, "PHP_EOL");
					ZEPHIR_INIT_NVAR(&_19$$12);
					ZEPHIR_CONCAT_SVSVVSV(&_19$$12, "\t<optgroup label=\"", &escaped, "\">", &_16$$12, &_17$$12, "\t</optgroup>", &_18$$12);
					zephir_concat_self(&code, &_19$$12);
					continue;
				}
				if (Z_TYPE_P(value) == IS_ARRAY) {
					if (zephir_fast_in_array(&optionValue, value)) {
						ZEPHIR_INIT_NVAR(&_20$$14);
						ZEPHIR_CONCAT_SVSVV(&_20$$14, "\t<option selected=\"selected\" value=\"", &escaped, "\">", &optionText, &closeOption);
						zephir_concat_self(&code, &_20$$14);
					} else {
						ZEPHIR_INIT_NVAR(&_21$$15);
						ZEPHIR_CONCAT_SVSVV(&_21$$15, "\t<option value=\"", &escaped, "\">", &optionText, &closeOption);
						zephir_concat_self(&code, &_21$$15);
					}
				} else {
					zephir_cast_to_string(&_22$$16, &optionValue);
					ZEPHIR_CPY_WRT(&strOptionValue, &_22$$16);
					zephir_cast_to_string(&_23$$16, value);
					ZEPHIR_CPY_WRT(&strValue, &_23$$16);
					if (ZEPHIR_IS_IDENTICAL(&strOptionValue, &strValue)) {
						ZEPHIR_INIT_NVAR(&_24$$17);
						ZEPHIR_CONCAT_SVSVV(&_24$$17, "\t<option selected=\"selected\" value=\"", &escaped, "\">", &optionText, &closeOption);
						zephir_concat_self(&code, &_24$$17);
					} else {
						ZEPHIR_INIT_NVAR(&_25$$18);
						ZEPHIR_CONCAT_SVSVV(&_25$$18, "\t<option value=\"", &escaped, "\">", &optionText, &closeOption);
						zephir_concat_self(&code, &_25$$18);
					}
				}
			ZEPHIR_CALL_METHOD(NULL, &data, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&optionText);
	ZEPHIR_INIT_NVAR(&optionValue);
	RETURN_CCTOR(&code);
}

static PHP_METHOD(Phalcon_Tag_Select, optionsFromResultset)
{
	zend_object_iterator *_1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_3 = NULL, *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval closeOption, _7$$15, _8$$15;
	zval *resultset, resultset_sub, *using, using_sub, *value, value_sub, *closeOption_param = NULL, code, params, option, usingZero, usingOne, escaper, optionValue, optionText, strValue, strOptionValue, _0, _2$$6, _5$$13, _6$$14, _9$$16, _10$$17, _11$$19;

	ZVAL_UNDEF(&resultset_sub);
	ZVAL_UNDEF(&using_sub);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&option);
	ZVAL_UNDEF(&usingZero);
	ZVAL_UNDEF(&usingOne);
	ZVAL_UNDEF(&escaper);
	ZVAL_UNDEF(&optionValue);
	ZVAL_UNDEF(&optionText);
	ZVAL_UNDEF(&strValue);
	ZVAL_UNDEF(&strOptionValue);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2$$6);
	ZVAL_UNDEF(&_5$$13);
	ZVAL_UNDEF(&_6$$14);
	ZVAL_UNDEF(&_9$$16);
	ZVAL_UNDEF(&_10$$17);
	ZVAL_UNDEF(&_11$$19);
	ZVAL_UNDEF(&closeOption);
	ZVAL_UNDEF(&_7$$15);
	ZVAL_UNDEF(&_8$$15);
	ZEND_PARSE_PARAMETERS_START(4, 4)
		Z_PARAM_OBJECT_OF_CLASS(resultset, phalcon_mvc_model_resultsetinterface_ce)
		Z_PARAM_ZVAL(using)
		Z_PARAM_ZVAL(value)
		Z_PARAM_STR(closeOption)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 4, 0, &resultset, &using, &value, &closeOption_param);
	zephir_get_strval(&closeOption, closeOption_param);
	ZEPHIR_INIT_VAR(&code);
	ZVAL_STRING(&code, "");
	ZEPHIR_INIT_VAR(&params);
	ZVAL_NULL(&params);
	if (Z_TYPE_P(using) == IS_ARRAY) {
		if (UNEXPECTED(zephir_fast_count_int(using) != 2)) {
			ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "Parameter 'using' requires two values", "phalcon/Tag/Select.zep", 209);
			return;
		}
		zephir_memory_observe(&usingZero);
		zephir_array_fetch_long(&usingZero, using, 0, PH_NOISY, "phalcon/Tag/Select.zep", 212);
		zephir_memory_observe(&usingOne);
		zephir_array_fetch_long(&usingOne, using, 1, PH_NOISY, "phalcon/Tag/Select.zep", 213);
	}
	ZEPHIR_CALL_CE_STATIC(&_0, phalcon_tag_ce, "getescaperservice", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&escaper, &_0);
	_1 = zephir_get_iterator(resultset);
	_1->funcs->rewind(_1);
	for (;_1->funcs->valid(_1) == SUCCESS && !EG(exception); _1->funcs->move_forward(_1)) {
		{
			ZEPHIR_ITERATOR_COPY(&option, _1);
		}
		if (Z_TYPE_P(using) == IS_ARRAY) {
			if (Z_TYPE_P(&option) == IS_OBJECT) {
				if ((zephir_method_exists_ex(&option, ZEND_STRL("readattribute")) == SUCCESS)) {
					ZEPHIR_CALL_METHOD(&optionValue, &option, "readattribute", NULL, 0, &usingZero);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&optionText, &option, "readattribute", NULL, 0, &usingOne);
					zephir_check_call_status();
				} else {
					ZEPHIR_OBS_NVAR(&optionValue);
					zephir_read_property(&optionValue, &option, ZEND_STRL("usingZero"), PH_NOISY_CC);
					ZEPHIR_OBS_NVAR(&optionText);
					zephir_read_property(&optionText, &option, ZEND_STRL("usingOne"), PH_NOISY_CC);
				}
			} else {
				if (UNEXPECTED(Z_TYPE_P(&option) != IS_ARRAY)) {
					ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_tag_exception_ce, "Resultset returned an invalid value", "phalcon/Tag/Select.zep", 232);
					return;
				}
				ZEPHIR_OBS_NVAR(&optionValue);
				zephir_array_fetch(&optionValue, &option, &usingZero, PH_NOISY, "phalcon/Tag/Select.zep", 235);
				ZEPHIR_OBS_NVAR(&optionText);
				zephir_array_fetch(&optionText, &option, &usingOne, PH_NOISY, "phalcon/Tag/Select.zep", 236);
			}
			ZEPHIR_CALL_METHOD(&_2$$6, &escaper, "escapehtmlattr", &_3, 0, &optionValue);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&optionValue, &_2$$6);
			ZEPHIR_CALL_METHOD(&_2$$6, &escaper, "escapehtml", &_4, 0, &optionText);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&optionText, &_2$$6);
			if (Z_TYPE_P(value) == IS_ARRAY) {
				if (zephir_fast_in_array(&optionValue, value)) {
					ZEPHIR_INIT_NVAR(&_5$$13);
					ZEPHIR_CONCAT_SVSVV(&_5$$13, "\t<option selected=\"selected\" value=\"", &optionValue, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_5$$13);
				} else {
					ZEPHIR_INIT_NVAR(&_6$$14);
					ZEPHIR_CONCAT_SVSVV(&_6$$14, "\t<option value=\"", &optionValue, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_6$$14);
				}
			} else {
				zephir_cast_to_string(&_7$$15, &optionValue);
				ZEPHIR_CPY_WRT(&strOptionValue, &_7$$15);
				zephir_cast_to_string(&_8$$15, value);
				ZEPHIR_CPY_WRT(&strValue, &_8$$15);
				if (ZEPHIR_IS_IDENTICAL(&strOptionValue, &strValue)) {
					ZEPHIR_INIT_NVAR(&_9$$16);
					ZEPHIR_CONCAT_SVSVV(&_9$$16, "\t<option selected=\"selected\" value=\"", &strOptionValue, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_9$$16);
				} else {
					ZEPHIR_INIT_NVAR(&_10$$17);
					ZEPHIR_CONCAT_SVSVV(&_10$$17, "\t<option value=\"", &strOptionValue, "\">", &optionText, &closeOption);
					zephir_concat_self(&code, &_10$$17);
				}
			}
		} else {
			if (Z_TYPE_P(using) == IS_OBJECT) {
				if (Z_TYPE_P(&params) == IS_NULL) {
					ZEPHIR_INIT_NVAR(&params);
					array_init(&params);
				}
				zephir_array_update_long(&params, 0, &option, PH_COPY | PH_SEPARATE ZEPHIR_DEBUG_PARAMS_DUMMY);
				ZEPHIR_INIT_NVAR(&_11$$19);
				ZEPHIR_CALL_USER_FUNC_ARRAY(&_11$$19, using, &params);
				zephir_check_call_status();
				zephir_concat_self(&code, &_11$$19);
			}
		}
	}
	zend_iterator_dtor(_1);
	RETURN_CCTOR(&code);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Collection)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support, Collection, phalcon, support_collection, phalcon_support_collection_method_entry, 0);

	zend_declare_property_null(phalcon_support_collection_ce, SL("data"), ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_support_collection_ce, SL("insensitive"), 1, ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_collection_ce, SL("lowerKeys"), ZEND_ACC_PROTECTED);
	phalcon_support_collection_ce->create_object = zephir_init_properties_Phalcon_Support_Collection;

	zend_class_implements(phalcon_support_collection_ce, 1, zend_ce_arrayaccess);
	zend_class_implements(phalcon_support_collection_ce, 1, phalcon_support_collection_collectioninterface_ce);
	zend_class_implements(phalcon_support_collection_ce, 1, zend_ce_countable);
	zend_class_implements(phalcon_support_collection_ce, 1, zend_ce_aggregate);
	zend_class_implements(phalcon_support_collection_ce, 1, php_json_serializable_ce);
	zend_class_implements(phalcon_support_collection_ce, 1, zend_ce_serializable);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Collection, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool insensitive;
	zval *data_param = NULL, *insensitive_param = NULL, __$true, __$false;
	zval data;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&data);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(data)
		Z_PARAM_BOOL(insensitive)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &data_param, &insensitive_param);
	if (!data_param) {
		ZEPHIR_INIT_VAR(&data);
		array_init(&data);
	} else {
		zephir_get_arrval(&data, data_param);
	}
	if (!insensitive_param) {
		insensitive = 1;
	} else {
		}
	if (insensitive) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("insensitive"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("insensitive"), &__$false);
	}
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "init", NULL, 0, &data);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, __get)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "get", NULL, 0, &element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, __isset)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "has", NULL, 0, &element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, __set)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *value, value_sub;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "set", NULL, 0, &element, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, __unset)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "remove", NULL, 0, &element);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, clear)
{
	zval _0, _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	array_init(&_0);
	zephir_update_property_zval(this_ptr, ZEND_STRL("data"), &_0);
	ZEPHIR_INIT_VAR(&_1);
	array_init(&_1);
	zephir_update_property_zval(this_ptr, ZEND_STRL("lowerKeys"), &_1);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, count)
{
	zval _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	RETURN_LONG(zephir_fast_count_int(&_0));
}

static PHP_METHOD(Phalcon_Support_Collection, get)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *defaultValue = NULL, defaultValue_sub, *cast_param = NULL, __$null, key, value, _0, _1, _2, _3;
	zval element, cast;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&cast);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_STR(element)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
		Z_PARAM_STR_OR_NULL(cast)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &element_param, &defaultValue, &cast_param);
	zephir_get_strval(&element, element_param);
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	if (!cast_param) {
		ZEPHIR_INIT_VAR(&cast);
	} else {
	if (UNEXPECTED(Z_TYPE_P(cast_param) != IS_STRING && Z_TYPE_P(cast_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'cast' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(cast_param) == IS_STRING)) {
		zephir_get_strval(&cast, cast_param);
	} else {
		ZEPHIR_INIT_VAR(&cast);
	}
	}
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "processkey", NULL, 0, &element);
	zephir_check_call_status();
	zephir_get_strval(&element, &_0);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC | PH_READONLY);
	if (UNEXPECTED(1 != zephir_array_isset(&_1, &element))) {
		RETVAL_ZVAL(defaultValue, 1, 0);
		RETURN_MM();
	}
	zephir_read_property(&_2, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC | PH_READONLY);
	zephir_memory_observe(&key);
	zephir_array_fetch(&key, &_2, &element, PH_NOISY, "phalcon/Support/Collection.zep", 140);
	zephir_read_property(&_3, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	zephir_memory_observe(&value);
	zephir_array_fetch(&value, &_3, &key, PH_NOISY, "phalcon/Support/Collection.zep", 141);
	if (UNEXPECTED((Z_TYPE_P(&value) == IS_NULL))) {
		RETVAL_ZVAL(defaultValue, 1, 0);
		RETURN_MM();
	}
	if (UNEXPECTED(zephir_is_true(&cast))) {
		ZEPHIR_MAKE_REF(&value);
		ZEPHIR_CALL_FUNCTION(NULL, "settype", NULL, 11, &value, &cast);
		ZEPHIR_UNREF(&value);
		zephir_check_call_status();
	}
	RETURN_CCTOR(&value);
}

static PHP_METHOD(Phalcon_Support_Collection, getIterator)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	object_init_ex(return_value, spl_ce_ArrayIterator);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CALL_METHOD(NULL, return_value, "__construct", NULL, 13, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, getKeys)
{
	zval collection;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *insensitive_param = NULL, _0;
	zend_bool insensitive;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&collection);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(insensitive)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &insensitive_param);
	if (!insensitive_param) {
		insensitive = 1;
	} else {
		}
	ZEPHIR_INIT_VAR(&_0);
	if (insensitive == 1) {
		ZEPHIR_OBS_NVAR(&_0);
		zephir_read_property(&_0, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC);
	} else {
		ZEPHIR_OBS_NVAR(&_0);
		zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC);
	}
	ZEPHIR_CPY_WRT(&collection, &_0);
	zephir_array_keys(return_value, &collection);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, getValues)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_RETURN_CALL_FUNCTION("array_values", NULL, 14, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, has)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, _0, _1;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "processkey", NULL, 0, &element);
	zephir_check_call_status();
	zephir_get_strval(&element, &_0);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC | PH_READONLY);
	RETURN_MM_BOOL(zephir_array_isset(&_1, &element));
}

static PHP_METHOD(Phalcon_Support_Collection, init)
{
	zend_string *_3;
	zend_ulong _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL, key, value, *_0, _1;
	zval data;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &data_param);
	if (!data_param) {
		ZEPHIR_INIT_VAR(&data);
		array_init(&data);
	} else {
		zephir_get_arrval(&data, data_param);
	}
	zephir_is_iterable(&data, 0, "phalcon/Support/Collection.zep", 206);
	if (Z_TYPE_P(&data) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&data), _2, _3, _0)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_3 != NULL) { 
				ZVAL_STR_COPY(&key, _3);
			} else {
				ZVAL_LONG(&key, _2);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _0);
			ZEPHIR_CALL_METHOD(NULL, this_ptr, "setdata", &_4, 0, &key, &value);
			zephir_check_call_status();
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &data, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &data, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &data, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &data, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(NULL, this_ptr, "setdata", &_4, 0, &key, &value);
				zephir_check_call_status();
			ZEPHIR_CALL_METHOD(NULL, &data, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, jsonSerialize)
{
	zend_bool _5$$3, _7$$6;
	zend_string *_4;
	zend_ulong _3;
	zval records;
	zval key, value, _0, *_1, _2, _6$$4, _8$$7;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_6$$4);
	ZVAL_UNDEF(&_8$$7);
	ZVAL_UNDEF(&records);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&records);
	array_init(&records);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	zephir_is_iterable(&_0, 0, "phalcon/Support/Collection.zep", 227);
	if (Z_TYPE_P(&_0) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_0), _3, _4, _1)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_4 != NULL) { 
				ZVAL_STR_COPY(&key, _4);
			} else {
				ZVAL_LONG(&key, _3);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _1);
			_5$$3 = Z_TYPE_P(&value) == IS_OBJECT;
			if (_5$$3) {
				_5$$3 = (zephir_method_exists_ex(&value, ZEND_STRL("jsonserialize")) == SUCCESS);
			}
			if (_5$$3) {
				ZEPHIR_CALL_METHOD(&_6$$4, &value, "jsonserialize", NULL, 0);
				zephir_check_call_status();
				zephir_array_update_zval(&records, &key, &_6$$4, PH_COPY | PH_SEPARATE);
			} else {
				zephir_array_update_zval(&records, &key, &value, PH_COPY | PH_SEPARATE);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &_0, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &_0, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &_0, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &_0, "current", NULL, 0);
			zephir_check_call_status();
				_7$$6 = Z_TYPE_P(&value) == IS_OBJECT;
				if (_7$$6) {
					_7$$6 = (zephir_method_exists_ex(&value, ZEND_STRL("jsonserialize")) == SUCCESS);
				}
				if (_7$$6) {
					ZEPHIR_CALL_METHOD(&_8$$7, &value, "jsonserialize", NULL, 0);
					zephir_check_call_status();
					zephir_array_update_zval(&records, &key, &_8$$7, PH_COPY | PH_SEPARATE);
				} else {
					zephir_array_update_zval(&records, &key, &value, PH_COPY | PH_SEPARATE);
				}
			ZEPHIR_CALL_METHOD(NULL, &_0, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	RETURN_CTOR(&records);
}

static PHP_METHOD(Phalcon_Support_Collection, offsetExists)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval element_sub;
	zval *element = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	zephir_cast_to_string(&_0, element);
	ZEPHIR_CPY_WRT(element, &_0);
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "has", NULL, 0, element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, offsetGet)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval element_sub;
	zval *element = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	zephir_cast_to_string(&_0, element);
	ZEPHIR_CPY_WRT(element, &_0);
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "get", NULL, 0, element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, offsetSet)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval offset_sub, value_sub;
	zval *offset = NULL, *value;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&offset_sub);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ZVAL(offset)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &offset, &value);
	zephir_cast_to_string(&_0, offset);
	ZEPHIR_CPY_WRT(offset, &_0);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "set", NULL, 0, offset, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, offsetUnset)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval element_sub;
	zval *element = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	zephir_cast_to_string(&_0, element);
	ZEPHIR_CPY_WRT(element, &_0);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "remove", NULL, 0, element);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, remove)
{
	zval lowerKeys, data;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, key, _0, _1$$3, _2$$3, _3$$3;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&lowerKeys);
	ZVAL_UNDEF(&data);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "has", NULL, 0, &element);
	zephir_check_call_status();
	if (UNEXPECTED(zephir_is_true(&_0))) {
		ZEPHIR_CALL_METHOD(&_1$$3, this_ptr, "processkey", NULL, 0, &element);
		zephir_check_call_status();
		zephir_get_strval(&element, &_1$$3);
		zephir_read_property(&_2$$3, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&data, &_2$$3);
		zephir_read_property(&_3$$3, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&lowerKeys, &_3$$3);
		zephir_array_fetch(&key, &lowerKeys, &element, PH_NOISY | PH_READONLY, "phalcon/Support/Collection.zep", 286);
		zephir_array_unset(&lowerKeys, &element, PH_SEPARATE);
		zephir_array_unset(&data, &key, PH_SEPARATE);
		zephir_update_property_zval(this_ptr, ZEND_STRL("data"), &data);
		zephir_update_property_zval(this_ptr, ZEND_STRL("lowerKeys"), &lowerKeys);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, set)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *value, value_sub;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "setdata", NULL, 0, &element, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, serialize)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_CALL_METHOD(&_0, this_ptr, "toarray", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("serialize", NULL, 15, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, toArray)
{

	RETURN_MEMBER(getThis(), "data");
}

static PHP_METHOD(Phalcon_Support_Collection, toJson)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *options_param = NULL, result, _0, _1;
	zend_long options, ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &options_param);
	if (!options_param) {
		options = 4194383;
	} else {
		}
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "jsonserialize", NULL, 0);
	zephir_check_call_status();
	ZVAL_LONG(&_1, options);
	ZEPHIR_CALL_METHOD(&result, this_ptr, "phpjsonencode", NULL, 0, &_0, &_1);
	zephir_check_call_status();
	if (ZEPHIR_IS_FALSE_IDENTICAL(&result)) {
		ZEPHIR_INIT_NVAR(&result);
		ZVAL_STRING(&result, "");
	}
	RETURN_CCTOR(&result);
}

static PHP_METHOD(Phalcon_Support_Collection, unserialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL, unserialized;
	zval data;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&unserialized);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &data_param);
	zephir_get_strval(&data, data_param);
	ZEPHIR_CALL_FUNCTION(&unserialized, "unserialize", NULL, 16, &data);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "init", NULL, 0, &unserialized);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, __serialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "toarray", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Collection, __unserialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL;
	zval data;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&data);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &data_param);
	zephir_get_arrval(&data, data_param);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "init", NULL, 0, &data);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, setData)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *value, value_sub, key;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&key);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	zephir_get_strval(&element, element_param);
	ZEPHIR_CALL_METHOD(&key, this_ptr, "processkey", NULL, 0, &element);
	zephir_check_call_status();
	zephir_update_property_array(this_ptr, SL("data"), &element, value);
	zephir_update_property_array(this_ptr, SL("lowerKeys"), &key, &element);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Collection, phpJsonEncode)
{
	zend_long flags, depth;
	zval *value, value_sub, *flags_param = NULL, *depth_param = NULL, _0, _1;

	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(value)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(flags)
		Z_PARAM_LONG(depth)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 2, &value, &flags_param, &depth_param);
	if (!flags_param) {
		flags = 0;
	} else {
		}
	if (!depth_param) {
		depth = 512;
	} else {
		}
	ZVAL_LONG(&_0, flags);
	ZVAL_LONG(&_1, depth);
	zephir_json_encode(return_value, value, zephir_get_intval(&_0) );
	return;
}

static PHP_METHOD(Phalcon_Support_Collection, processKey)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, _0;
	zval element;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("insensitive"), PH_NOISY_CC | PH_READONLY);
	if (UNEXPECTED(zephir_is_true(&_0))) {
		ZEPHIR_RETURN_CALL_FUNCTION("mb_strtolower", NULL, 10, &element);
		zephir_check_call_status();
		RETURN_MM();
	}
	RETURN_CTOR(&element);
}

zend_object *zephir_init_properties_Phalcon_Support_Collection(zend_class_entry *class_type)
{
		zval _0, _2, _1$$3, _3$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$4);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("lowerKeys"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("lowerKeys"), &_1$$3);
		}
		zephir_read_property_ex(&_2, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_2) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_3$$4);
			array_init(&_3$$4);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("data"), &_3$$4);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Debug)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support, Debug, phalcon, support_debug, phalcon_support_debug_method_entry, 0);

	zend_declare_property_null(phalcon_support_debug_ce, SL("blacklist"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_debug_ce, SL("data"), ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_support_debug_ce, SL("hideDocumentRoot"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_support_debug_ce, SL("isActive"), 0, ZEND_ACC_PROTECTED|ZEND_ACC_STATIC);
	zend_declare_property_bool(phalcon_support_debug_ce, SL("showBackTrace"), 1, ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_support_debug_ce, SL("showFileFragment"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_support_debug_ce, SL("showFiles"), 1, ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_support_debug_ce, SL("uri"), "https://assets.phalcon.io/debug/5.0.x/", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_debug_ce, SL("version"), ZEND_ACC_PRIVATE);
	phalcon_support_debug_ce->create_object = zephir_init_properties_Phalcon_Support_Debug;

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Debug, __construct)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	object_init_ex(&_0, phalcon_support_version_ce);
	if (zephir_has_constructor(&_0)) {
		ZEPHIR_CALL_METHOD(NULL, &_0, "__construct", NULL, 0);
		zephir_check_call_status();
	}

	zephir_update_property_zval(this_ptr, ZEND_STRL("version"), &_0);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Debug, clearVars)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	array_init(&_0);
	zephir_update_property_zval(this_ptr, ZEND_STRL("data"), &_0);
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, debugVar)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *varz, varz_sub, _1, _2;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&varz_sub);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(varz)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &varz);
	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 3, 0);
	zephir_array_fast_append(&_0, varz);
	ZEPHIR_CALL_FUNCTION(&_1, "debug_backtrace", NULL, 0);
	zephir_check_call_status();
	zephir_array_fast_append(&_0, &_1);
	ZEPHIR_INIT_VAR(&_2);
	zephir_time(&_2);
	zephir_array_fast_append(&_0, &_2);
	zephir_update_property_array_append(this_ptr, SL("data"), &_0);
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, getCssSources)
{
	zval uri, sources, _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&uri);
	ZVAL_UNDEF(&sources);
	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("uri"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&uri, &_0);
	ZEPHIR_INIT_VAR(&sources);
	ZEPHIR_CONCAT_SVSSVSSVS(&sources, "<link rel=\"stylesheet\" type=\"text/css\" href=\"", &uri, "assets/jquery-ui/themes/ui-lightness/jquery-ui.min.css\" />", "<link rel=\"stylesheet\" type=\"text/css\" href=\"", &uri, "assets/jquery-ui/themes/ui-lightness/theme.css\" />", "<link rel=\"stylesheet\" type=\"text/css\" href=\"", &uri, "themes/default/style.css\" />");
	RETURN_CCTOR(&sources);
}

static PHP_METHOD(Phalcon_Support_Debug, getJsSources)
{
	zval uri, sources, _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&uri);
	ZVAL_UNDEF(&sources);
	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("uri"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&uri, &_0);
	ZEPHIR_INIT_VAR(&sources);
	ZEPHIR_CONCAT_SVSSVSSVSSVSSVS(&sources, "<script type=\"application/javascript\" src=\"", &uri, "assets/jquery/dist/jquery.min.js\"></script>", "<script type=\"application/javascript\" src=\"", &uri, "assets/jquery-ui/jquery-ui.min.js\"></script>", "<script type=\"application/javascript\" src=\"", &uri, "assets/jquery.scrollTo/jquery.scrollTo.min.js\"></script>", "<script type=\"application/javascript\" src=\"", &uri, "prettify/prettify.js\"></script>", "<script type=\"application/javascript\" src=\"", &uri, "pretty.js\"></script>");
	RETURN_CCTOR(&sources);
}

static PHP_METHOD(Phalcon_Support_Debug, getVersion)
{
	zval link, _0, _1, _2, _3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&link);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("version"), PH_NOISY_CC | PH_READONLY);
	ZVAL_LONG(&_2, 0);
	ZEPHIR_CALL_METHOD(&_1, &_0, "getpart", NULL, 0, &_2);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&link);
	ZEPHIR_CONCAT_SVS(&link, "https://docs.phalcon.io/", &_1, ".0/en/");
	zephir_read_property(&_2, this_ptr, ZEND_STRL("version"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CALL_METHOD(&_3, &_2, "get", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CONCAT_SSVSVS(return_value, "<div class=\"version\">Phalcon Framework ", "<a href=\"", &link, "\" target=\"_new\">", &_3, "</a></div>");
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug, halt)
{

	ZEPHIR_THROW_EXCEPTION_DEBUG_STRW(phalcon_support_debug_exception_ce, "Halted request", "phalcon/Support/Debug.zep", 169);
	return;
}

static PHP_METHOD(Phalcon_Support_Debug, listen)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *exceptions_param = NULL, *lowSeverity_param = NULL;
	zend_bool exceptions, lowSeverity;
	zval *this_ptr = getThis();

	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(exceptions)
		Z_PARAM_BOOL(lowSeverity)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &exceptions_param, &lowSeverity_param);
	if (!exceptions_param) {
		exceptions = 1;
	} else {
		}
	if (!lowSeverity_param) {
		lowSeverity = 0;
	} else {
		}
	if (exceptions) {
		ZEPHIR_CALL_METHOD(NULL, this_ptr, "listenexceptions", NULL, 0);
		zephir_check_call_status();
	}
	if (lowSeverity) {
		ZEPHIR_CALL_METHOD(NULL, this_ptr, "listenlowseverity", NULL, 0);
		zephir_check_call_status();
	}
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, listenExceptions)
{
	zval _1;
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	zephir_array_fast_append(&_0, this_ptr);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "onUncaughtException");
	zephir_array_fast_append(&_0, &_1);
	ZEPHIR_CALL_FUNCTION(NULL, "set_exception_handler", NULL, 0, &_0);
	zephir_check_call_status();
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, listenLowSeverity)
{
	zval _1;
	zval _0, _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	zephir_array_fast_append(&_0, this_ptr);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "onUncaughtLowSeverity");
	zephir_array_fast_append(&_0, &_1);
	ZEPHIR_CALL_FUNCTION(NULL, "set_error_handler", NULL, 135, &_0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_2);
	zephir_create_array(&_2, 2, 0);
	zephir_array_fast_append(&_2, this_ptr);
	ZEPHIR_INIT_NVAR(&_1);
	ZVAL_STRING(&_1, "onUncaughtException");
	zephir_array_fast_append(&_2, &_1);
	ZEPHIR_CALL_FUNCTION(NULL, "set_exception_handler", NULL, 0, &_2);
	zephir_check_call_status();
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, onUncaughtException)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *exception, exception_sub, __$true, __$false, obLevel, _0, _2, _1$$4;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&exception_sub);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZVAL_UNDEF(&obLevel);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1$$4);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_OBJECT_OF_CLASS(exception, zend_ce_throwable)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &exception);
	ZEPHIR_CALL_FUNCTION(&obLevel, "ob_get_level", NULL, 0);
	zephir_check_call_status();
	if (ZEPHIR_GT_LONG(&obLevel, 0)) {
		ZEPHIR_CALL_FUNCTION(NULL, "ob_end_clean", NULL, 489);
		zephir_check_call_status();
	}
	zephir_read_static_property_ce(&_0, phalcon_support_debug_ce, SL("isActive"), PH_NOISY_CC | PH_READONLY);
	if (zephir_is_true(&_0)) {
		ZEPHIR_CALL_METHOD(&_1$$4, exception, "getmessage", NULL, 0);
		zephir_check_call_status();
		zend_print_zval(&_1$$4, 0);
		RETURN_MM_NULL();
	}
	zephir_update_static_property_ce(phalcon_support_debug_ce, ZEND_STRL("isActive"), &__$true);
	ZEPHIR_CALL_METHOD(&_2, this_ptr, "renderhtml", NULL, 0, exception);
	zephir_check_call_status();
	zend_print_zval(&_2, 0);
	zephir_update_static_property_ce(phalcon_support_debug_ce, ZEND_STRL("isActive"), &__$false);
	RETURN_MM_BOOL(1);
}

static PHP_METHOD(Phalcon_Support_Debug, onUncaughtLowSeverity)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *severity, severity_sub, *message, message_sub, *file, file_sub, *line, line_sub, *context, context_sub, _0, _1, _2$$3, _3$$3;

	ZVAL_UNDEF(&severity_sub);
	ZVAL_UNDEF(&message_sub);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_UNDEF(&context_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZEND_PARSE_PARAMETERS_START(5, 5)
		Z_PARAM_ZVAL(severity)
		Z_PARAM_ZVAL(message)
		Z_PARAM_ZVAL(file)
		Z_PARAM_ZVAL(line)
		Z_PARAM_ZVAL(context)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 5, 0, &severity, &message, &file, &line, &context);
	ZEPHIR_CALL_FUNCTION(&_0, "error_reporting", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_1);
	zephir_bitwise_and_function(&_1, &_0, severity);
	if (UNEXPECTED(zephir_is_true(&_1))) {
		ZEPHIR_INIT_VAR(&_2$$3);
		object_init_ex(&_2$$3, zend_ce_error_exception);
		ZVAL_LONG(&_3$$3, 0);
		ZEPHIR_CALL_METHOD(NULL, &_2$$3, "__construct", NULL, 0, message, &_3$$3, severity, file, line);
		zephir_check_call_status();
		zephir_throw_exception_debug(&_2$$3, "phalcon/Support/Debug.zep", 268);
		ZEPHIR_MM_RESTORE();
		return;
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Debug, renderHtml)
{
	zend_string *_12$$3, *_23$$3, *_39$$3, *_52$$3, *_61$$21;
	zend_ulong _11$$3, _22$$3, _38$$3, _51$$3, _60$$21;
	zval _7$$3, _16$$3, _33$$3, _47$$3, _57$$21;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_14 = NULL, *_27 = NULL, *_42 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *exception, exception_sub, _REQUEST, __$true, _SERVER, blacklist, className, dataVar, dataVars, escapedMessage, html, keyFile, keyRequest, keyServer, keyVar, n, showBackTrace, traceItem, value, _0, _1, _2, _3, _4, _5, _6, _68, _69, _8$$3, *_9$$3, _10$$3, _17$$3, _18$$3, _19$$3, *_20$$3, _21$$3, _34$$3, _35$$3, *_36$$3, _37$$3, _48$$3, *_49$$3, _50$$3, _55$$3, _56$$3, _13$$5, _15$$6, _24$$7, _25$$9, _26$$10, _28$$10, _29$$11, _30$$13, _31$$14, _32$$14, _40$$15, _41$$16, _43$$16, _44$$17, _45$$18, _46$$18, _53$$19, _54$$20, *_58$$21, _59$$21, _62$$22, _63$$22, _64$$22, _65$$23, _66$$23, _67$$23;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&exception_sub);
	ZVAL_UNDEF(&_REQUEST);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_UNDEF(&_SERVER);
	ZVAL_UNDEF(&blacklist);
	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&dataVar);
	ZVAL_UNDEF(&dataVars);
	ZVAL_UNDEF(&escapedMessage);
	ZVAL_UNDEF(&html);
	ZVAL_UNDEF(&keyFile);
	ZVAL_UNDEF(&keyRequest);
	ZVAL_UNDEF(&keyServer);
	ZVAL_UNDEF(&keyVar);
	ZVAL_UNDEF(&n);
	ZVAL_UNDEF(&showBackTrace);
	ZVAL_UNDEF(&traceItem);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_68);
	ZVAL_UNDEF(&_69);
	ZVAL_UNDEF(&_8$$3);
	ZVAL_UNDEF(&_10$$3);
	ZVAL_UNDEF(&_17$$3);
	ZVAL_UNDEF(&_18$$3);
	ZVAL_UNDEF(&_19$$3);
	ZVAL_UNDEF(&_21$$3);
	ZVAL_UNDEF(&_34$$3);
	ZVAL_UNDEF(&_35$$3);
	ZVAL_UNDEF(&_37$$3);
	ZVAL_UNDEF(&_48$$3);
	ZVAL_UNDEF(&_50$$3);
	ZVAL_UNDEF(&_55$$3);
	ZVAL_UNDEF(&_56$$3);
	ZVAL_UNDEF(&_13$$5);
	ZVAL_UNDEF(&_15$$6);
	ZVAL_UNDEF(&_24$$7);
	ZVAL_UNDEF(&_25$$9);
	ZVAL_UNDEF(&_26$$10);
	ZVAL_UNDEF(&_28$$10);
	ZVAL_UNDEF(&_29$$11);
	ZVAL_UNDEF(&_30$$13);
	ZVAL_UNDEF(&_31$$14);
	ZVAL_UNDEF(&_32$$14);
	ZVAL_UNDEF(&_40$$15);
	ZVAL_UNDEF(&_41$$16);
	ZVAL_UNDEF(&_43$$16);
	ZVAL_UNDEF(&_44$$17);
	ZVAL_UNDEF(&_45$$18);
	ZVAL_UNDEF(&_46$$18);
	ZVAL_UNDEF(&_53$$19);
	ZVAL_UNDEF(&_54$$20);
	ZVAL_UNDEF(&_59$$21);
	ZVAL_UNDEF(&_62$$22);
	ZVAL_UNDEF(&_63$$22);
	ZVAL_UNDEF(&_64$$22);
	ZVAL_UNDEF(&_65$$23);
	ZVAL_UNDEF(&_66$$23);
	ZVAL_UNDEF(&_67$$23);
	ZVAL_UNDEF(&_7$$3);
	ZVAL_UNDEF(&_16$$3);
	ZVAL_UNDEF(&_33$$3);
	ZVAL_UNDEF(&_47$$3);
	ZVAL_UNDEF(&_57$$21);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_OBJECT_OF_CLASS(exception, zend_ce_throwable)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_get_global(&_SERVER, SL("_SERVER"));
	zephir_get_global(&_REQUEST, SL("_REQUEST"));
	zephir_fetch_params(1, 1, 0, &exception);
	ZEPHIR_INIT_VAR(&className);
	zephir_get_class(&className, exception, 0);
	ZEPHIR_CALL_METHOD(&_0, exception, "getmessage", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&escapedMessage, this_ptr, "escapestring", NULL, 0, &_0);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&_1, this_ptr, "getcsssources", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&html);
	ZEPHIR_CONCAT_SSVSVSVS(&html, "<html><head>", "<title>", &className, ": ", &escapedMessage, "</title>", &_1, "</head><body>");
	ZEPHIR_CALL_METHOD(&_2, this_ptr, "getversion", NULL, 0);
	zephir_check_call_status();
	zephir_concat_self(&html, &_2);
	ZEPHIR_CALL_METHOD(&_3, exception, "getfile", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&_4, exception, "getline", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_5);
	ZEPHIR_CONCAT_SSSVSVSSVSVSS(&_5, "<div align=\"center\">", "<div class=\"error-main\">", "<h1>", &className, ": ", &escapedMessage, "</h1>", "<span class=\"error-file\">", &_3, " (", &_4, ")</span>", "</div>");
	zephir_concat_self(&html, &_5);
	zephir_read_property(&_6, this_ptr, ZEND_STRL("showBackTrace"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&showBackTrace, &_6);
	if (zephir_is_true(&showBackTrace)) {
		zephir_memory_observe(&dataVars);
		zephir_read_property(&dataVars, this_ptr, ZEND_STRL("data"), PH_NOISY_CC);
		ZEPHIR_INIT_VAR(&_7$$3);
		ZEPHIR_CONCAT_SSSSSS(&_7$$3, "<div class=\"error-info\"><div id=\"tabs\"><ul>", "<li><a href=\"#error-tabs-1\">Backtrace</a></li>", "<li><a href=\"#error-tabs-2\">Request</a></li>", "<li><a href=\"#error-tabs-3\">Server</a></li>", "<li><a href=\"#error-tabs-4\">Included Files</a></li>", "<li><a href=\"#error-tabs-5\">Memory</a></li>");
		zephir_concat_self(&html, &_7$$3);
		if (!(ZEPHIR_IS_EMPTY(&dataVars))) {
			zephir_concat_self_str(&html, SL("<li><a href=\"#error-tabs-6\">Variables</a></li>"));
		}
		zephir_concat_self_str(&html, SL("</ul>"));
		zephir_concat_self_str(&html, SL("<div id=\"error-tabs-1\"><table cellspacing=\"0\" align=\"center\" width=\"100%\">"));
		ZEPHIR_CALL_METHOD(&_8$$3, exception, "gettrace", NULL, 0);
		zephir_check_call_status();
		zephir_is_iterable(&_8$$3, 0, "phalcon/Support/Debug.zep", 355);
		if (Z_TYPE_P(&_8$$3) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_8$$3), _11$$3, _12$$3, _9$$3)
			{
				ZEPHIR_INIT_NVAR(&n);
				if (_12$$3 != NULL) { 
					ZVAL_STR_COPY(&n, _12$$3);
				} else {
					ZVAL_LONG(&n, _11$$3);
				}
				ZEPHIR_INIT_NVAR(&traceItem);
				ZVAL_COPY(&traceItem, _9$$3);
				ZEPHIR_CALL_METHOD(&_13$$5, this_ptr, "showtraceitem", &_14, 0, &n, &traceItem);
				zephir_check_call_status();
				zephir_concat_self(&html, &_13$$5);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &_8$$3, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_10$$3, &_8$$3, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_10$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&n, &_8$$3, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&traceItem, &_8$$3, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&_15$$6, this_ptr, "showtraceitem", &_14, 0, &n, &traceItem);
					zephir_check_call_status();
					zephir_concat_self(&html, &_15$$6);
				ZEPHIR_CALL_METHOD(NULL, &_8$$3, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&traceItem);
		ZEPHIR_INIT_NVAR(&n);
		zephir_concat_self_str(&html, SL("</table></div>"));
		ZEPHIR_INIT_VAR(&_16$$3);
		ZEPHIR_CONCAT_SSS(&_16$$3, "<div id=\"error-tabs-2\">", "<table cellspacing=\"0\" align=\"center\" class=\"superglobal-detail\">", "<tr><th>Key</th><th>Value</th></tr>");
		zephir_concat_self(&html, &_16$$3);
		zephir_read_property(&_17$$3, this_ptr, ZEND_STRL("blacklist"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_INIT_VAR(&_18$$3);
		array_init(&_18$$3);
		ZEPHIR_INIT_VAR(&_19$$3);
		ZVAL_STRING(&_19$$3, "request");
		ZEPHIR_CALL_METHOD(&blacklist, this_ptr, "getarrval", NULL, 0, &_17$$3, &_19$$3, &_18$$3);
		zephir_check_call_status();
		zephir_is_iterable(&_REQUEST, 0, "phalcon/Support/Debug.zep", 379);
		if (Z_TYPE_P(&_REQUEST) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_REQUEST), _22$$3, _23$$3, _20$$3)
			{
				ZEPHIR_INIT_NVAR(&keyRequest);
				if (_23$$3 != NULL) { 
					ZVAL_STR_COPY(&keyRequest, _23$$3);
				} else {
					ZVAL_LONG(&keyRequest, _22$$3);
				}
				ZEPHIR_INIT_NVAR(&value);
				ZVAL_COPY(&value, _20$$3);
				ZEPHIR_INIT_NVAR(&_24$$7);
				zephir_fast_strtolower(&_24$$7, &keyRequest);
				if (1 != zephir_array_isset(&blacklist, &_24$$7)) {
					if (Z_TYPE_P(&value) != IS_ARRAY) {
						ZEPHIR_INIT_NVAR(&_25$$9);
						ZEPHIR_CONCAT_SVSVS(&_25$$9, "<tr><td class=\"key\">", &keyRequest, "</td><td>", &value, "</td></tr>");
						zephir_concat_self(&html, &_25$$9);
					} else {
						ZEPHIR_CALL_FUNCTION(&_26$$10, "print_r", &_27, 0, &value, &__$true);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_28$$10);
						ZEPHIR_CONCAT_SVSVS(&_28$$10, "<tr><td class=\"key\">", &keyRequest, "</td><td>", &_26$$10, "</td></tr>");
						zephir_concat_self(&html, &_28$$10);
					}
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &_REQUEST, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_21$$3, &_REQUEST, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_21$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&keyRequest, &_REQUEST, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&value, &_REQUEST, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_29$$11);
					zephir_fast_strtolower(&_29$$11, &keyRequest);
					if (1 != zephir_array_isset(&blacklist, &_29$$11)) {
						if (Z_TYPE_P(&value) != IS_ARRAY) {
							ZEPHIR_INIT_NVAR(&_30$$13);
							ZEPHIR_CONCAT_SVSVS(&_30$$13, "<tr><td class=\"key\">", &keyRequest, "</td><td>", &value, "</td></tr>");
							zephir_concat_self(&html, &_30$$13);
						} else {
							ZEPHIR_CALL_FUNCTION(&_31$$14, "print_r", &_27, 0, &value, &__$true);
							zephir_check_call_status();
							ZEPHIR_INIT_NVAR(&_32$$14);
							ZEPHIR_CONCAT_SVSVS(&_32$$14, "<tr><td class=\"key\">", &keyRequest, "</td><td>", &_31$$14, "</td></tr>");
							zephir_concat_self(&html, &_32$$14);
						}
					}
				ZEPHIR_CALL_METHOD(NULL, &_REQUEST, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&value);
		ZEPHIR_INIT_NVAR(&keyRequest);
		zephir_concat_self_str(&html, SL("</table></div>"));
		ZEPHIR_INIT_VAR(&_33$$3);
		ZEPHIR_CONCAT_SSS(&_33$$3, "<div id=\"error-tabs-3\">", "<table cellspacing=\"0\" align=\"center\" class=\"superglobal-detail\">", "<tr><th>Key</th><th>Value</th></tr>");
		zephir_concat_self(&html, &_33$$3);
		zephir_read_property(&_34$$3, this_ptr, ZEND_STRL("blacklist"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_INIT_NVAR(&_19$$3);
		array_init(&_19$$3);
		ZEPHIR_INIT_VAR(&_35$$3);
		ZVAL_STRING(&_35$$3, "server");
		ZEPHIR_CALL_METHOD(&blacklist, this_ptr, "getarrval", NULL, 0, &_34$$3, &_35$$3, &_19$$3);
		zephir_check_call_status();
		zephir_is_iterable(&_SERVER, 0, "phalcon/Support/Debug.zep", 397);
		if (Z_TYPE_P(&_SERVER) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_SERVER), _38$$3, _39$$3, _36$$3)
			{
				ZEPHIR_INIT_NVAR(&keyServer);
				if (_39$$3 != NULL) { 
					ZVAL_STR_COPY(&keyServer, _39$$3);
				} else {
					ZVAL_LONG(&keyServer, _38$$3);
				}
				ZEPHIR_INIT_NVAR(&value);
				ZVAL_COPY(&value, _36$$3);
				ZEPHIR_INIT_NVAR(&_40$$15);
				zephir_fast_strtolower(&_40$$15, &keyServer);
				if (1 != zephir_array_isset(&blacklist, &_40$$15)) {
					ZEPHIR_CALL_METHOD(&_41$$16, this_ptr, "getvardump", &_42, 0, &value);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_43$$16);
					ZEPHIR_CONCAT_SVSVS(&_43$$16, "<tr><td class=\"key\">", &keyServer, "</td><td>", &_41$$16, "</td></tr>");
					zephir_concat_self(&html, &_43$$16);
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &_SERVER, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_37$$3, &_SERVER, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_37$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&keyServer, &_SERVER, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&value, &_SERVER, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_44$$17);
					zephir_fast_strtolower(&_44$$17, &keyServer);
					if (1 != zephir_array_isset(&blacklist, &_44$$17)) {
						ZEPHIR_CALL_METHOD(&_45$$18, this_ptr, "getvardump", &_42, 0, &value);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_46$$18);
						ZEPHIR_CONCAT_SVSVS(&_46$$18, "<tr><td class=\"key\">", &keyServer, "</td><td>", &_45$$18, "</td></tr>");
						zephir_concat_self(&html, &_46$$18);
					}
				ZEPHIR_CALL_METHOD(NULL, &_SERVER, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&value);
		ZEPHIR_INIT_NVAR(&keyServer);
		zephir_concat_self_str(&html, SL("</table></div>"));
		ZEPHIR_INIT_VAR(&_47$$3);
		ZEPHIR_CONCAT_SSS(&_47$$3, "<div id=\"error-tabs-4\">", "<table cellspacing=\"0\" align=\"center\" class=\"superglobal-detail\">", "<tr><th>#</th><th>Path</th></tr>");
		zephir_concat_self(&html, &_47$$3);
		ZEPHIR_CALL_FUNCTION(&_48$$3, "get_included_files", NULL, 0);
		zephir_check_call_status();
		zephir_is_iterable(&_48$$3, 0, "phalcon/Support/Debug.zep", 410);
		if (Z_TYPE_P(&_48$$3) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_48$$3), _51$$3, _52$$3, _49$$3)
			{
				ZEPHIR_INIT_NVAR(&keyFile);
				if (_52$$3 != NULL) { 
					ZVAL_STR_COPY(&keyFile, _52$$3);
				} else {
					ZVAL_LONG(&keyFile, _51$$3);
				}
				ZEPHIR_INIT_NVAR(&value);
				ZVAL_COPY(&value, _49$$3);
				ZEPHIR_INIT_NVAR(&_53$$19);
				ZEPHIR_CONCAT_SVSVS(&_53$$19, "<tr><td>", &keyFile, "</th><td>", &value, "</td></tr>");
				zephir_concat_self(&html, &_53$$19);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &_48$$3, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_50$$3, &_48$$3, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_50$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&keyFile, &_48$$3, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&value, &_48$$3, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_54$$20);
					ZEPHIR_CONCAT_SVSVS(&_54$$20, "<tr><td>", &keyFile, "</th><td>", &value, "</td></tr>");
					zephir_concat_self(&html, &_54$$20);
				ZEPHIR_CALL_METHOD(NULL, &_48$$3, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&value);
		ZEPHIR_INIT_NVAR(&keyFile);
		zephir_concat_self_str(&html, SL("</table></div>"));
		ZEPHIR_CALL_FUNCTION(&_55$$3, "memory_get_usage", NULL, 0, &__$true);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&_56$$3);
		ZEPHIR_CONCAT_SSSVSS(&_56$$3, "<div id=\"error-tabs-5\">", "<table cellspacing=\"0\" align=\"center\" class=\"superglobal-detail\">", "<tr><th colspan=\"2\">Memory</th></tr><tr><td>Usage</td><td>", &_55$$3, "</td></tr>", "</table></div>");
		zephir_concat_self(&html, &_56$$3);
		if (!(ZEPHIR_IS_EMPTY(&dataVars))) {
			ZEPHIR_INIT_VAR(&_57$$21);
			ZEPHIR_CONCAT_SSS(&_57$$21, "<div id=\"error-tabs-6\">", "<table cellspacing=\"0\" align=\"center\" class=\"superglobal-detail\">", "<tr><th>Key</th><th>Value</th></tr>");
			zephir_concat_self(&html, &_57$$21);
			zephir_is_iterable(&dataVars, 0, "phalcon/Support/Debug.zep", 435);
			if (Z_TYPE_P(&dataVars) == IS_ARRAY) {
				ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&dataVars), _60$$21, _61$$21, _58$$21)
				{
					ZEPHIR_INIT_NVAR(&keyVar);
					if (_61$$21 != NULL) { 
						ZVAL_STR_COPY(&keyVar, _61$$21);
					} else {
						ZVAL_LONG(&keyVar, _60$$21);
					}
					ZEPHIR_INIT_NVAR(&dataVar);
					ZVAL_COPY(&dataVar, _58$$21);
					zephir_array_fetch_long(&_63$$22, &dataVar, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Debug.zep", 432);
					ZEPHIR_CALL_METHOD(&_62$$22, this_ptr, "getvardump", &_42, 0, &_63$$22);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_64$$22);
					ZEPHIR_CONCAT_SVSVS(&_64$$22, "<tr><td class=\"key\">", &keyVar, "</td><td>", &_62$$22, "</td></tr>");
					zephir_concat_self(&html, &_64$$22);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &dataVars, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_59$$21, &dataVars, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_59$$21)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&keyVar, &dataVars, "key", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&dataVar, &dataVars, "current", NULL, 0);
					zephir_check_call_status();
						zephir_array_fetch_long(&_66$$23, &dataVar, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Debug.zep", 432);
						ZEPHIR_CALL_METHOD(&_65$$23, this_ptr, "getvardump", &_42, 0, &_66$$23);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_67$$23);
						ZEPHIR_CONCAT_SVSVS(&_67$$23, "<tr><td class=\"key\">", &keyVar, "</td><td>", &_65$$23, "</td></tr>");
						zephir_concat_self(&html, &_67$$23);
					ZEPHIR_CALL_METHOD(NULL, &dataVars, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&dataVar);
			ZEPHIR_INIT_NVAR(&keyVar);
			zephir_concat_self_str(&html, SL("</table></div>"));
		}
		zephir_concat_self_str(&html, SL("</div>"));
	}
	ZEPHIR_CALL_METHOD(&_68, this_ptr, "getjssources", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_69);
	ZEPHIR_CONCAT_VS(&_69, &_68, "</div></body></html>");
	zephir_concat_self(&html, &_69);
	RETURN_CCTOR(&html);
}

static PHP_METHOD(Phalcon_Support_Debug, setBlacklist)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *blacklist_param = NULL, area, result, subArray, value, _0, _1, *_2, _3, _6, *_7, _8, _4$$3, _5$$4, _9$$5, _10$$6;
	zval blacklist;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&blacklist);
	ZVAL_UNDEF(&area);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&subArray);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_8);
	ZVAL_UNDEF(&_4$$3);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&_9$$5);
	ZVAL_UNDEF(&_10$$6);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(blacklist)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &blacklist_param);
	zephir_get_arrval(&blacklist, blacklist_param);
	ZEPHIR_INIT_VAR(&_0);
	array_init(&_0);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "request");
	ZEPHIR_CALL_METHOD(&area, this_ptr, "getarrval", NULL, 0, &blacklist, &_1, &_0);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&subArray);
	array_init(&subArray);
	ZEPHIR_INIT_VAR(&result);
	array_init(&result);
	zephir_is_iterable(&area, 0, "phalcon/Support/Debug.zep", 467);
	if (Z_TYPE_P(&area) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&area), _2)
		{
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _2);
			ZEPHIR_INIT_NVAR(&_4$$3);
			zephir_fast_strtolower(&_4$$3, &value);
			ZEPHIR_CPY_WRT(&value, &_4$$3);
			ZEPHIR_INIT_NVAR(&_4$$3);
			ZVAL_LONG(&_4$$3, 1);
			zephir_array_update_zval(&subArray, &value, &_4$$3, PH_COPY | PH_SEPARATE);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &area, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_3, &area, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_3)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&value, &area, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_5$$4);
				zephir_fast_strtolower(&_5$$4, &value);
				ZEPHIR_CPY_WRT(&value, &_5$$4);
				ZEPHIR_INIT_NVAR(&_5$$4);
				ZVAL_LONG(&_5$$4, 1);
				zephir_array_update_zval(&subArray, &value, &_5$$4, PH_COPY | PH_SEPARATE);
			ZEPHIR_CALL_METHOD(NULL, &area, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	zephir_array_update_string(&result, SL("request"), &subArray, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_NVAR(&_1);
	array_init(&_1);
	ZEPHIR_INIT_VAR(&_6);
	ZVAL_STRING(&_6, "server");
	ZEPHIR_CALL_METHOD(&area, this_ptr, "getarrval", NULL, 0, &blacklist, &_6, &_1);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&subArray);
	array_init(&subArray);
	zephir_is_iterable(&area, 0, "phalcon/Support/Debug.zep", 476);
	if (Z_TYPE_P(&area) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&area), _7)
		{
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _7);
			ZEPHIR_INIT_NVAR(&_9$$5);
			zephir_fast_strtolower(&_9$$5, &value);
			ZEPHIR_CPY_WRT(&value, &_9$$5);
			ZEPHIR_INIT_NVAR(&_9$$5);
			ZVAL_LONG(&_9$$5, 1);
			zephir_array_update_zval(&subArray, &value, &_9$$5, PH_COPY | PH_SEPARATE);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &area, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_8, &area, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_8)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&value, &area, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_10$$6);
				zephir_fast_strtolower(&_10$$6, &value);
				ZEPHIR_CPY_WRT(&value, &_10$$6);
				ZEPHIR_INIT_NVAR(&_10$$6);
				ZVAL_LONG(&_10$$6, 1);
				zephir_array_update_zval(&subArray, &value, &_10$$6, PH_COPY | PH_SEPARATE);
			ZEPHIR_CALL_METHOD(NULL, &area, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	zephir_array_update_string(&result, SL("server"), &subArray, PH_COPY | PH_SEPARATE);
	zephir_update_property_zval(this_ptr, ZEND_STRL("blacklist"), &result);
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, setShowBackTrace)
{
	zval *showBackTrace_param = NULL, __$true, __$false;
	zend_bool showBackTrace;
	zval *this_ptr = getThis();

	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_BOOL(showBackTrace)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &showBackTrace_param);
	if (showBackTrace) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showBackTrace"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showBackTrace"), &__$false);
	}
	RETURN_THISW();
}

static PHP_METHOD(Phalcon_Support_Debug, setShowFileFragment)
{
	zval *showFileFragment_param = NULL, __$true, __$false;
	zend_bool showFileFragment;
	zval *this_ptr = getThis();

	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_BOOL(showFileFragment)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &showFileFragment_param);
	if (showFileFragment) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showFileFragment"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showFileFragment"), &__$false);
	}
	RETURN_THISW();
}

static PHP_METHOD(Phalcon_Support_Debug, setShowFiles)
{
	zval *showFiles_param = NULL, __$true, __$false;
	zend_bool showFiles;
	zval *this_ptr = getThis();

	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_BOOL(showFiles)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &showFiles_param);
	if (showFiles) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showFiles"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("showFiles"), &__$false);
	}
	RETURN_THISW();
}

static PHP_METHOD(Phalcon_Support_Debug, setUri)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *uri_param = NULL;
	zval uri;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&uri);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(uri)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &uri_param);
	if (UNEXPECTED(Z_TYPE_P(uri_param) != IS_STRING && Z_TYPE_P(uri_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'uri' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(uri_param) == IS_STRING)) {
		zephir_get_strval(&uri, uri_param);
	} else {
		ZEPHIR_INIT_VAR(&uri);
	}
	zephir_update_property_zval(this_ptr, ZEND_STRL("uri"), &uri);
	RETURN_THIS();
}

static PHP_METHOD(Phalcon_Support_Debug, escapeString)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *value_param = NULL, _0, _1, _2, _3, _4;
	zval value;

	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &value_param);
	zephir_get_strval(&value, value_param);
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "\n");
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "\\n");
	zephir_fast_str_replace(&_0, &_1, &_2, &value);
	ZVAL_LONG(&_3, 2);
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_STRING(&_4, "utf-8");
	ZEPHIR_RETURN_CALL_FUNCTION("htmlentities", NULL, 0, &_0, &_3, &_4);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug, getArrayDump)
{
	zend_string *_4;
	zend_ulong _3;
	zend_bool _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_5 = NULL, *_8 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *argument_param = NULL, *n = NULL, n_sub, numberArguments, dump, varDump, k, v, *_1, _2, _6$$8, _7$$8, _9$$9, _10$$5, _11$$15, _12$$15, _13$$16, _14$$12;
	zval argument;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&n_sub);
	ZVAL_UNDEF(&numberArguments);
	ZVAL_UNDEF(&dump);
	ZVAL_UNDEF(&varDump);
	ZVAL_UNDEF(&k);
	ZVAL_UNDEF(&v);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_6$$8);
	ZVAL_UNDEF(&_7$$8);
	ZVAL_UNDEF(&_9$$9);
	ZVAL_UNDEF(&_10$$5);
	ZVAL_UNDEF(&_11$$15);
	ZVAL_UNDEF(&_12$$15);
	ZVAL_UNDEF(&_13$$16);
	ZVAL_UNDEF(&_14$$12);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(argument)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL(n)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &argument_param, &n);
	ZEPHIR_OBS_COPY_OR_DUP(&argument, argument_param);
	if (!n) {
		n = &n_sub;
		ZEPHIR_INIT_VAR(n);
		ZVAL_LONG(n, 0);
	}
	ZEPHIR_INIT_VAR(&numberArguments);
	ZVAL_LONG(&numberArguments, zephir_fast_count_int(&argument));
	_0 = ZEPHIR_GE_LONG(n, 3);
	if (!(_0)) {
		_0 = ZEPHIR_IS_LONG(&numberArguments, 0);
	}
	if (_0) {
		RETURN_MM_NULL();
	}
	if (ZEPHIR_GE_LONG(&numberArguments, 10)) {
		RETURN_CCTOR(&numberArguments);
	}
	ZEPHIR_INIT_VAR(&dump);
	array_init(&dump);
	zephir_is_iterable(&argument, 0, "phalcon/Support/Debug.zep", 587);
	if (Z_TYPE_P(&argument) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&argument), _3, _4, _1)
		{
			ZEPHIR_INIT_NVAR(&k);
			if (_4 != NULL) { 
				ZVAL_STR_COPY(&k, _4);
			} else {
				ZVAL_LONG(&k, _3);
			}
			ZEPHIR_INIT_NVAR(&v);
			ZVAL_COPY(&v, _1);
			if (ZEPHIR_IS_STRING(&v, "")) {
				ZEPHIR_INIT_NVAR(&varDump);
				ZVAL_STRING(&varDump, "(empty string)");
			} else if (zephir_is_scalar(&v)) {
				ZEPHIR_CALL_METHOD(&varDump, this_ptr, "escapestring", &_5, 0, &v);
				zephir_check_call_status();
			} else if (Z_TYPE_P(&v) == IS_ARRAY) {
				ZVAL_LONG(&_7$$8, (zephir_get_numberval(n) + 1));
				ZEPHIR_CALL_METHOD(&_6$$8, this_ptr, "getarraydump", &_8, 0, &v, &_7$$8);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&varDump);
				ZEPHIR_CONCAT_SVS(&varDump, "Array(", &_6$$8, ")");
			} else if (Z_TYPE_P(&v) == IS_OBJECT) {
				ZEPHIR_INIT_NVAR(&_9$$9);
				zephir_get_class(&_9$$9, &v, 0);
				ZEPHIR_INIT_NVAR(&varDump);
				ZEPHIR_CONCAT_SVS(&varDump, "Object(", &_9$$9, ")");
			} else if (Z_TYPE_P(&v) == IS_NULL) {
				ZEPHIR_INIT_NVAR(&varDump);
				ZVAL_STRING(&varDump, "null");
			} else {
				ZEPHIR_CPY_WRT(&varDump, &v);
			}
			ZEPHIR_INIT_NVAR(&_10$$5);
			ZEPHIR_CONCAT_SVSV(&_10$$5, "[", &k, "] =&gt; ", &varDump);
			zephir_array_append(&dump, &_10$$5, PH_SEPARATE, "phalcon/Support/Debug.zep", 584);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &argument, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &argument, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&k, &argument, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&v, &argument, "current", NULL, 0);
			zephir_check_call_status();
				if (ZEPHIR_IS_STRING(&v, "")) {
					ZEPHIR_INIT_NVAR(&varDump);
					ZVAL_STRING(&varDump, "(empty string)");
				} else if (zephir_is_scalar(&v)) {
					ZEPHIR_CALL_METHOD(&varDump, this_ptr, "escapestring", &_5, 0, &v);
					zephir_check_call_status();
				} else if (Z_TYPE_P(&v) == IS_ARRAY) {
					ZVAL_LONG(&_12$$15, (zephir_get_numberval(n) + 1));
					ZEPHIR_CALL_METHOD(&_11$$15, this_ptr, "getarraydump", &_8, 0, &v, &_12$$15);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&varDump);
					ZEPHIR_CONCAT_SVS(&varDump, "Array(", &_11$$15, ")");
				} else if (Z_TYPE_P(&v) == IS_OBJECT) {
					ZEPHIR_INIT_NVAR(&_13$$16);
					zephir_get_class(&_13$$16, &v, 0);
					ZEPHIR_INIT_NVAR(&varDump);
					ZEPHIR_CONCAT_SVS(&varDump, "Object(", &_13$$16, ")");
				} else if (Z_TYPE_P(&v) == IS_NULL) {
					ZEPHIR_INIT_NVAR(&varDump);
					ZVAL_STRING(&varDump, "null");
				} else {
					ZEPHIR_CPY_WRT(&varDump, &v);
				}
				ZEPHIR_INIT_NVAR(&_14$$12);
				ZEPHIR_CONCAT_SVSV(&_14$$12, "[", &k, "] =&gt; ", &varDump);
				zephir_array_append(&dump, &_14$$12, PH_SEPARATE, "phalcon/Support/Debug.zep", 584);
			ZEPHIR_CALL_METHOD(NULL, &argument, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&v);
	ZEPHIR_INIT_NVAR(&k);
	zephir_fast_join_str(return_value, SL(", "), &dump);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug, getVarDump)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *variable, variable_sub, className, dumpedObject, _0$$8, _1$$10;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&variable_sub);
	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&dumpedObject);
	ZVAL_UNDEF(&_0$$8);
	ZVAL_UNDEF(&_1$$10);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(variable)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &variable);
	if (ZEPHIR_IS_TRUE_IDENTICAL(variable)) {
		RETURN_MM_STRING("true");
	}
	if (ZEPHIR_IS_FALSE_IDENTICAL(variable)) {
		RETURN_MM_STRING("false");
	}
	if (Z_TYPE_P(variable) == IS_STRING) {
		ZEPHIR_RETURN_CALL_METHOD(this_ptr, "escapestring", NULL, 0, variable);
		zephir_check_call_status();
		RETURN_MM();
	}
	if (zephir_is_scalar(variable)) {
		RETVAL_ZVAL(variable, 1, 0);
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_OBJECT) {
		ZEPHIR_INIT_VAR(&className);
		zephir_get_class(&className, variable, 0);
		if ((zephir_method_exists_ex(variable, ZEND_STRL("dump")) == SUCCESS)) {
			ZEPHIR_CALL_METHOD(&dumpedObject, variable, "dump", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&_0$$8, this_ptr, "getarraydump", NULL, 0, &dumpedObject);
			zephir_check_call_status();
			ZEPHIR_CONCAT_SVSVS(return_value, "Object(", &className, ": ", &_0$$8, ")");
			RETURN_MM();
		} else {
			ZEPHIR_CONCAT_SVS(return_value, "Object(", &className, ")");
			RETURN_MM();
		}
	}
	if (Z_TYPE_P(variable) == IS_ARRAY) {
		ZEPHIR_CALL_METHOD(&_1$$10, this_ptr, "getarraydump", NULL, 0, variable);
		zephir_check_call_status();
		ZEPHIR_CONCAT_SVS(return_value, "Array(", &_1$$10, ")");
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_NULL) {
		RETURN_MM_STRING("null");
	}
	zephir_gettype(return_value, variable);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug, showTraceItem)
{
	zend_bool _45$$25;
	zval _1, _31$$17;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_24 = NULL, *_52 = NULL;
	zval trace;
	zval *n_param = NULL, *trace_param = NULL, className, prepareInternalClass, preparedFunctionName, html, classReflection, prepareUriClass, functionName, functionReflection, traceArgs, arguments, argument, filez, line, showFiles, lines, numberLines, showFileFragment, firstLine, lastLine, linePosition, currentLine, classNameWithLink, functionNameWithLink, parts, _0, _20, _2$$3, _3$$3, _4$$3, _5$$3, _15$$3, _16$$3, _6$$4, _7$$4, _8$$4, _9$$4, _10$$4, _11$$5, _12$$6, _13$$6, _14$$6, _17$$10, _18$$11, _19$$11, *_21$$14, _22$$14, _28$$14, _29$$14, _23$$15, _25$$15, _26$$16, _27$$16, _30$$17, _32$$17, _33$$17, _34$$18, _35$$19, _36$$24, _37$$27, _38$$27, _39$$27, _40$$27, _41$$27, _42$$28, _43$$28, _44$$28, _46$$30, _47$$30, _48$$30, _49$$30, _50$$30, _51$$30;
	zend_long n, ZEPHIR_LAST_CALL_STATUS, i = 0, beforeLine$$19, afterLine$$19;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&prepareInternalClass);
	ZVAL_UNDEF(&preparedFunctionName);
	ZVAL_UNDEF(&html);
	ZVAL_UNDEF(&classReflection);
	ZVAL_UNDEF(&prepareUriClass);
	ZVAL_UNDEF(&functionName);
	ZVAL_UNDEF(&functionReflection);
	ZVAL_UNDEF(&traceArgs);
	ZVAL_UNDEF(&arguments);
	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&filez);
	ZVAL_UNDEF(&line);
	ZVAL_UNDEF(&showFiles);
	ZVAL_UNDEF(&lines);
	ZVAL_UNDEF(&numberLines);
	ZVAL_UNDEF(&showFileFragment);
	ZVAL_UNDEF(&firstLine);
	ZVAL_UNDEF(&lastLine);
	ZVAL_UNDEF(&linePosition);
	ZVAL_UNDEF(&currentLine);
	ZVAL_UNDEF(&classNameWithLink);
	ZVAL_UNDEF(&functionNameWithLink);
	ZVAL_UNDEF(&parts);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_20);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$3);
	ZVAL_UNDEF(&_5$$3);
	ZVAL_UNDEF(&_15$$3);
	ZVAL_UNDEF(&_16$$3);
	ZVAL_UNDEF(&_6$$4);
	ZVAL_UNDEF(&_7$$4);
	ZVAL_UNDEF(&_8$$4);
	ZVAL_UNDEF(&_9$$4);
	ZVAL_UNDEF(&_10$$4);
	ZVAL_UNDEF(&_11$$5);
	ZVAL_UNDEF(&_12$$6);
	ZVAL_UNDEF(&_13$$6);
	ZVAL_UNDEF(&_14$$6);
	ZVAL_UNDEF(&_17$$10);
	ZVAL_UNDEF(&_18$$11);
	ZVAL_UNDEF(&_19$$11);
	ZVAL_UNDEF(&_22$$14);
	ZVAL_UNDEF(&_28$$14);
	ZVAL_UNDEF(&_29$$14);
	ZVAL_UNDEF(&_23$$15);
	ZVAL_UNDEF(&_25$$15);
	ZVAL_UNDEF(&_26$$16);
	ZVAL_UNDEF(&_27$$16);
	ZVAL_UNDEF(&_30$$17);
	ZVAL_UNDEF(&_32$$17);
	ZVAL_UNDEF(&_33$$17);
	ZVAL_UNDEF(&_34$$18);
	ZVAL_UNDEF(&_35$$19);
	ZVAL_UNDEF(&_36$$24);
	ZVAL_UNDEF(&_37$$27);
	ZVAL_UNDEF(&_38$$27);
	ZVAL_UNDEF(&_39$$27);
	ZVAL_UNDEF(&_40$$27);
	ZVAL_UNDEF(&_41$$27);
	ZVAL_UNDEF(&_42$$28);
	ZVAL_UNDEF(&_43$$28);
	ZVAL_UNDEF(&_44$$28);
	ZVAL_UNDEF(&_46$$30);
	ZVAL_UNDEF(&_47$$30);
	ZVAL_UNDEF(&_48$$30);
	ZVAL_UNDEF(&_49$$30);
	ZVAL_UNDEF(&_50$$30);
	ZVAL_UNDEF(&_51$$30);
	ZVAL_UNDEF(&trace);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_31$$17);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_LONG(n)
		Z_PARAM_ARRAY(trace)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &n_param, &trace_param);
	ZEPHIR_OBS_COPY_OR_DUP(&trace, trace_param);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_LONG(&_0, n);
	ZEPHIR_INIT_VAR(&_1);
	ZEPHIR_CONCAT_SVS(&_1, "<tr><td align=\"right\" valign=\"top\" class=\"error-number\">#", &_0, "</td><td>");
	ZEPHIR_CPY_WRT(&html, &_1);
	zephir_memory_observe(&className);
	if (zephir_array_isset_string_fetch(&className, &trace, SL("class"), 0)) {
		ZEPHIR_INIT_VAR(&_2$$3);
		ZEPHIR_INIT_VAR(&_3$$3);
		ZVAL_STRING(&_3$$3, "/^Phalcon/");
		ZEPHIR_INIT_VAR(&_4$$3);
		ZEPHIR_INIT_VAR(&_5$$3);
		ZVAL_STRING(&_5$$3, "/^Phalcon/");
		zephir_preg_match(&_4$$3, &_5$$3, &className, &_2$$3, 0, 0 , 0 );
		if (zephir_is_true(&_4$$3)) {
			ZEPHIR_INIT_VAR(&parts);
			zephir_fast_explode_str(&parts, SL("\\"), &className, LONG_MAX);
			zephir_array_fetch_long(&_6$$4, &parts, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Debug.zep", 700);
			zephir_array_fetch_long(&_7$$4, &parts, 1, PH_NOISY | PH_READONLY, "phalcon/Support/Debug.zep", 700);
			ZEPHIR_INIT_VAR(&prepareUriClass);
			ZEPHIR_CONCAT_VSV(&prepareUriClass, &_6$$4, "_", &_7$$4);
			zephir_read_property(&_8$$4, this_ptr, ZEND_STRL("version"), PH_NOISY_CC | PH_READONLY);
			ZVAL_LONG(&_10$$4, 0);
			ZEPHIR_CALL_METHOD(&_9$$4, &_8$$4, "getpart", NULL, 0, &_10$$4);
			zephir_check_call_status();
			ZEPHIR_INIT_VAR(&classNameWithLink);
			ZEPHIR_CONCAT_SVSVSVS(&classNameWithLink, "<a target=\"_new\" href=\"https://docs.phalcon.io/", &_9$$4, ".0/en/api/", &prepareUriClass, "\">", &className, "</a>");
		} else {
			ZEPHIR_INIT_VAR(&classReflection);
			object_init_ex(&classReflection, zephir_get_internal_ce(SL("reflectionclass")));
			ZEPHIR_CALL_METHOD(NULL, &classReflection, "__construct", NULL, 154, &className);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&_11$$5, &classReflection, "isinternal", NULL, 0);
			zephir_check_call_status();
			if (zephir_is_true(&_11$$5)) {
				ZEPHIR_INIT_VAR(&_12$$6);
				zephir_fast_strtolower(&_12$$6, &className);
				ZEPHIR_INIT_VAR(&_13$$6);
				ZVAL_STRING(&_13$$6, "_");
				ZEPHIR_INIT_VAR(&_14$$6);
				ZVAL_STRING(&_14$$6, "-");
				ZEPHIR_INIT_VAR(&prepareInternalClass);
				zephir_fast_str_replace(&prepareInternalClass, &_13$$6, &_14$$6, &_12$$6);
				ZEPHIR_INIT_NVAR(&classNameWithLink);
				ZEPHIR_CONCAT_SVSVS(&classNameWithLink, "<a target=\"_new\" href=\"https://secure.php.net/manual/en/class.", &prepareInternalClass, ".php\">", &className, "</a>");
			} else {
				ZEPHIR_CPY_WRT(&classNameWithLink, &className);
			}
		}
		ZEPHIR_INIT_VAR(&_15$$3);
		ZEPHIR_CONCAT_SVS(&_15$$3, "<span class=\"error-class\">", &classNameWithLink, "</span>");
		zephir_concat_self(&html, &_15$$3);
		zephir_array_fetch_string(&_16$$3, &trace, SL("type"), PH_NOISY | PH_READONLY, "phalcon/Support/Debug.zep", 739);
		zephir_concat_self(&html, &_16$$3);
	}
	zephir_memory_observe(&functionName);
	zephir_array_fetch_string(&functionName, &trace, SL("function"), PH_NOISY, "phalcon/Support/Debug.zep", 745);
	if (zephir_array_isset_string(&trace, SL("class"))) {
		ZEPHIR_CPY_WRT(&functionNameWithLink, &functionName);
	} else {
		if ((zephir_function_exists(&functionName) == SUCCESS)) {
			ZEPHIR_INIT_VAR(&functionReflection);
			object_init_ex(&functionReflection, zephir_get_internal_ce(SL("reflectionfunction")));
			ZEPHIR_CALL_METHOD(NULL, &functionReflection, "__construct", NULL, 151, &functionName);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&_17$$10, &functionReflection, "isinternal", NULL, 0);
			zephir_check_call_status();
			if (zephir_is_true(&_17$$10)) {
				ZEPHIR_INIT_VAR(&_18$$11);
				ZVAL_STRING(&_18$$11, "_");
				ZEPHIR_INIT_VAR(&_19$$11);
				ZVAL_STRING(&_19$$11, "-");
				ZEPHIR_INIT_VAR(&preparedFunctionName);
				zephir_fast_str_replace(&preparedFunctionName, &_18$$11, &_19$$11, &functionName);
				ZEPHIR_INIT_NVAR(&functionNameWithLink);
				ZEPHIR_CONCAT_SVSVS(&functionNameWithLink, "<a target=\"_new\" href=\"https://secure.php.net/manual/en/function.", &preparedFunctionName, ".php\">", &functionName, "</a>");
			} else {
				ZEPHIR_CPY_WRT(&functionNameWithLink, &functionName);
			}
		} else {
			ZEPHIR_CPY_WRT(&functionNameWithLink, &functionName);
		}
	}
	ZEPHIR_INIT_VAR(&_20);
	ZEPHIR_CONCAT_SVS(&_20, "<span class=\"error-function\">", &functionNameWithLink, "</span>");
	zephir_concat_self(&html, &_20);
	zephir_memory_observe(&traceArgs);
	if (zephir_array_isset_string_fetch(&traceArgs, &trace, SL("args"), 0)) {
		ZEPHIR_INIT_VAR(&arguments);
		array_init(&arguments);
		zephir_is_iterable(&traceArgs, 0, "phalcon/Support/Debug.zep", 800);
		if (Z_TYPE_P(&traceArgs) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&traceArgs), _21$$14)
			{
				ZEPHIR_INIT_NVAR(&argument);
				ZVAL_COPY(&argument, _21$$14);
				ZEPHIR_CALL_METHOD(&_23$$15, this_ptr, "getvardump", &_24, 0, &argument);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_25$$15);
				ZEPHIR_CONCAT_SVS(&_25$$15, "<span class=\"error-parameter\">", &_23$$15, "</span>");
				zephir_array_append(&arguments, &_25$$15, PH_SEPARATE, "phalcon/Support/Debug.zep", 794);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &traceArgs, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_22$$14, &traceArgs, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_22$$14)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&argument, &traceArgs, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&_26$$16, this_ptr, "getvardump", &_24, 0, &argument);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_27$$16);
					ZEPHIR_CONCAT_SVS(&_27$$16, "<span class=\"error-parameter\">", &_26$$16, "</span>");
					zephir_array_append(&arguments, &_27$$16, PH_SEPARATE, "phalcon/Support/Debug.zep", 794);
				ZEPHIR_CALL_METHOD(NULL, &traceArgs, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&argument);
		ZEPHIR_INIT_VAR(&_28$$14);
		zephir_fast_join_str(&_28$$14, SL(", "), &arguments);
		ZEPHIR_INIT_VAR(&_29$$14);
		ZEPHIR_CONCAT_SVS(&_29$$14, "(", &_28$$14, ")");
		zephir_concat_self(&html, &_29$$14);
	}
	zephir_memory_observe(&filez);
	if (zephir_array_isset_string_fetch(&filez, &trace, SL("file"), 0)) {
		zephir_memory_observe(&_30$$17);
		zephir_array_fetch_string(&_30$$17, &trace, SL("line"), PH_NOISY, "phalcon/Support/Debug.zep", 808);
		zephir_cast_to_string(&_31$$17, &_30$$17);
		ZEPHIR_CPY_WRT(&line, &_31$$17);
		ZEPHIR_INIT_VAR(&_32$$17);
		ZEPHIR_CONCAT_SVSVS(&_32$$17, "<br/><div class=\"error-file\">", &filez, " (", &line, ")</div>");
		zephir_concat_self(&html, &_32$$17);
		zephir_read_property(&_33$$17, this_ptr, ZEND_STRL("showFiles"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&showFiles, &_33$$17);
		if (zephir_is_true(&showFiles)) {
			ZEPHIR_CALL_FUNCTION(&lines, "file", NULL, 0, &filez);
			zephir_check_call_status();
			ZEPHIR_INIT_VAR(&numberLines);
			ZVAL_LONG(&numberLines, zephir_fast_count_int(&lines));
			zephir_read_property(&_34$$18, this_ptr, ZEND_STRL("showFileFragment"), PH_NOISY_CC | PH_READONLY);
			ZEPHIR_CPY_WRT(&showFileFragment, &_34$$18);
			if (zephir_is_true(&showFileFragment)) {
				beforeLine$$19 = (zephir_get_numberval(&line) - 7);
				if (beforeLine$$19 < 1) {
					ZEPHIR_INIT_VAR(&firstLine);
					ZVAL_LONG(&firstLine, 1);
				} else {
					ZEPHIR_INIT_NVAR(&firstLine);
					ZVAL_LONG(&firstLine, beforeLine$$19);
				}
				afterLine$$19 = (zephir_get_numberval(&line) + 5);
				if (ZEPHIR_LT_LONG(&numberLines, afterLine$$19)) {
					ZEPHIR_CPY_WRT(&lastLine, &numberLines);
				} else {
					ZEPHIR_INIT_NVAR(&lastLine);
					ZVAL_LONG(&lastLine, afterLine$$19);
				}
				ZEPHIR_INIT_VAR(&_35$$19);
				ZEPHIR_CONCAT_SVSVSVS(&_35$$19, "<pre class=\"prettyprint highlight:", &firstLine, ":", &line, " linenums:", &firstLine, "\">");
				zephir_concat_self(&html, &_35$$19);
			} else {
				ZEPHIR_INIT_NVAR(&firstLine);
				ZVAL_LONG(&firstLine, 1);
				ZEPHIR_CPY_WRT(&lastLine, &numberLines);
				ZEPHIR_INIT_VAR(&_36$$24);
				ZEPHIR_CONCAT_SVSVS(&_36$$24, "<pre class=\"prettyprint highlight:", &firstLine, ":", &line, " linenums error-scroll\">");
				zephir_concat_self(&html, &_36$$24);
			}
			i = zephir_get_numberval(&firstLine);
			while (1) {
				if (!(ZEPHIR_GE_LONG(&lastLine, i))) {
					break;
				}
				ZEPHIR_INIT_NVAR(&linePosition);
				ZVAL_LONG(&linePosition, (i - 1));
				ZEPHIR_OBS_NVAR(&currentLine);
				zephir_array_fetch(&currentLine, &lines, &linePosition, PH_NOISY, "phalcon/Support/Debug.zep", 881);
				if (zephir_is_true(&showFileFragment)) {
					if (ZEPHIR_IS_LONG(&firstLine, i)) {
						ZEPHIR_INIT_NVAR(&_37$$27);
						ZEPHIR_INIT_NVAR(&_38$$27);
						zephir_fast_trim(&_38$$27, &currentLine, NULL , ZEPHIR_TRIM_RIGHT);
						ZEPHIR_INIT_NVAR(&_39$$27);
						ZVAL_STRING(&_39$$27, "#\\*\\/#");
						ZEPHIR_INIT_NVAR(&_40$$27);
						ZEPHIR_INIT_NVAR(&_41$$27);
						ZVAL_STRING(&_41$$27, "#\\*\\/#");
						zephir_preg_match(&_40$$27, &_41$$27, &_38$$27, &_37$$27, 0, 0 , 0 );
						if (zephir_is_true(&_40$$27)) {
							ZEPHIR_INIT_NVAR(&_42$$28);
							ZEPHIR_INIT_NVAR(&_43$$28);
							ZVAL_STRING(&_43$$28, "* /");
							ZEPHIR_INIT_NVAR(&_44$$28);
							ZVAL_STRING(&_44$$28, " ");
							zephir_fast_str_replace(&_42$$28, &_43$$28, &_44$$28, &currentLine);
							ZEPHIR_CPY_WRT(&currentLine, &_42$$28);
						}
					}
				}
				_45$$25 = ZEPHIR_IS_STRING(&currentLine, "\n");
				if (!(_45$$25)) {
					_45$$25 = ZEPHIR_IS_STRING(&currentLine, "\r\n");
				}
				if (_45$$25) {
					zephir_concat_self_str(&html, SL("&nbsp;\n"));
				} else {
					ZEPHIR_INIT_NVAR(&_46$$30);
					ZEPHIR_INIT_NVAR(&_47$$30);
					ZVAL_STRING(&_47$$30, "\t");
					ZEPHIR_INIT_NVAR(&_48$$30);
					ZVAL_STRING(&_48$$30, "  ");
					zephir_fast_str_replace(&_46$$30, &_47$$30, &_48$$30, &currentLine);
					ZVAL_LONG(&_49$$30, 2);
					ZEPHIR_INIT_NVAR(&_50$$30);
					ZVAL_STRING(&_50$$30, "UTF-8");
					ZEPHIR_CALL_FUNCTION(&_51$$30, "htmlentities", &_52, 0, &_46$$30, &_49$$30, &_50$$30);
					zephir_check_call_status();
					zephir_concat_self(&html, &_51$$30);
				}
				i++;
			}
			zephir_concat_self_str(&html, SL("</pre>"));
		}
	}
	zephir_concat_self_str(&html, SL("</td></tr>"));
	RETURN_CCTOR(&html);
}

static PHP_METHOD(Phalcon_Support_Debug, getArrVal)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *collection_param = NULL, *index, index_sub, *defaultValue = NULL, defaultValue_sub, __$null, value;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&index_sub);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&value);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(index)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &collection_param, &index, &defaultValue);
	ZEPHIR_OBS_COPY_OR_DUP(&collection, collection_param);
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	zephir_memory_observe(&value);
	if (UNEXPECTED(!(zephir_array_isset_fetch(&value, &collection, index, 0)))) {
		RETVAL_ZVAL(defaultValue, 1, 0);
		RETURN_MM();
	}
	RETURN_CCTOR(&value);
}

zend_object *zephir_init_properties_Phalcon_Support_Debug(zend_class_entry *class_type)
{
		zval _3$$4;
	zval _0, _2, _1$$3, _4$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_4$$4);
	ZVAL_UNDEF(&_3$$4);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("data"), &_1$$3);
		}
		zephir_read_property_ex(&_2, this_ptr, ZEND_STRL("blacklist"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_2) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_3$$4);
			zephir_create_array(&_3$$4, 2, 0);
			ZEPHIR_INIT_VAR(&_4$$4);
			array_init(&_4$$4);
			zephir_array_update_string(&_3$$4, SL("request"), &_4$$4, PH_COPY | PH_SEPARATE);
			ZEPHIR_INIT_NVAR(&_4$$4);
			array_init(&_4$$4);
			zephir_array_update_string(&_3$$4, SL("server"), &_4$$4, PH_COPY | PH_SEPARATE);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("blacklist"), &_3$$4);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support, Exception, phalcon, support_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_HelperFactory)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support, HelperFactory, phalcon, support_helperfactory, phalcon_factory_abstractfactory_ce, phalcon_support_helperfactory_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_HelperFactory, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *services_param = NULL;
	zval services;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&services);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(services)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &services_param);
	if (!services_param) {
		ZEPHIR_INIT_VAR(&services);
		array_init(&services);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&services, services_param);
	}
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "init", NULL, 0, &services);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_HelperFactory, __call)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval arguments, _0;
	zval *name_param = NULL, *arguments_param = NULL, helper, _1;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&helper);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&arguments);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(name)
		Z_PARAM_ARRAY(arguments)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &name_param, &arguments_param);
	zephir_get_strval(&name, name_param);
	zephir_get_arrval(&arguments, arguments_param);
	ZEPHIR_CALL_METHOD(&helper, this_ptr, "newinstance", NULL, 0, &name);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	zephir_array_fast_append(&_0, &helper);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "__invoke");
	zephir_array_fast_append(&_0, &_1);
	ZEPHIR_CALL_USER_FUNC_ARRAY(return_value, &_0, &arguments);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_HelperFactory, newInstance)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *name_param = NULL, _0, _3, _4, _1$$3, _2$$3;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	zephir_get_strval(&name, name_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("services"), PH_NOISY_CC | PH_READONLY);
	if (1 != zephir_array_isset(&_0, &name)) {
		ZEPHIR_INIT_VAR(&_1$$3);
		ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "getservice", NULL, 0, &name);
		zephir_check_call_status();
		ZEPHIR_LAST_CALL_STATUS = zephir_create_instance(&_1$$3, &_2$$3);
		zephir_check_call_status();
		zephir_update_property_array(this_ptr, SL("services"), &name, &_1$$3);
	}
	zephir_read_property(&_3, this_ptr, ZEND_STRL("services"), PH_NOISY_CC | PH_READONLY);
	zephir_array_fetch(&_4, &_3, &name, PH_NOISY | PH_READONLY, "phalcon/Support/HelperFactory.zep", 118);
	RETURN_CTOR(&_4);
}

static PHP_METHOD(Phalcon_Support_HelperFactory, getExceptionClass)
{

	RETURN_STRING("Phalcon\\Support\\Exception");
}

static PHP_METHOD(Phalcon_Support_HelperFactory, getServices)
{

	zephir_create_array(return_value, 59, 0);
	add_assoc_stringl_ex(return_value, SL("blacklist"), SL("Phalcon\\Support\\Helper\\Arr\\Blacklist"));
	add_assoc_stringl_ex(return_value, SL("chunk"), SL("Phalcon\\Support\\Helper\\Arr\\Chunk"));
	add_assoc_stringl_ex(return_value, SL("filter"), SL("Phalcon\\Support\\Helper\\Arr\\Filter"));
	add_assoc_stringl_ex(return_value, SL("first"), SL("Phalcon\\Support\\Helper\\Arr\\First"));
	add_assoc_stringl_ex(return_value, SL("firstKey"), SL("Phalcon\\Support\\Helper\\Arr\\FirstKey"));
	add_assoc_stringl_ex(return_value, SL("flatten"), SL("Phalcon\\Support\\Helper\\Arr\\Flatten"));
	add_assoc_stringl_ex(return_value, SL("get"), SL("Phalcon\\Support\\Helper\\Arr\\Get"));
	add_assoc_stringl_ex(return_value, SL("group"), SL("Phalcon\\Support\\Helper\\Arr\\Group"));
	add_assoc_stringl_ex(return_value, SL("has"), SL("Phalcon\\Support\\Helper\\Arr\\Has"));
	add_assoc_stringl_ex(return_value, SL("isUnique"), SL("Phalcon\\Support\\Helper\\Arr\\IsUnique"));
	add_assoc_stringl_ex(return_value, SL("last"), SL("Phalcon\\Support\\Helper\\Arr\\Last"));
	add_assoc_stringl_ex(return_value, SL("lastKey"), SL("Phalcon\\Support\\Helper\\Arr\\LastKey"));
	add_assoc_stringl_ex(return_value, SL("order"), SL("Phalcon\\Support\\Helper\\Arr\\Order"));
	add_assoc_stringl_ex(return_value, SL("pluck"), SL("Phalcon\\Support\\Helper\\Arr\\Pluck"));
	add_assoc_stringl_ex(return_value, SL("set"), SL("Phalcon\\Support\\Helper\\Arr\\Set"));
	add_assoc_stringl_ex(return_value, SL("sliceLeft"), SL("Phalcon\\Support\\Helper\\Arr\\SliceLeft"));
	add_assoc_stringl_ex(return_value, SL("sliceRight"), SL("Phalcon\\Support\\Helper\\Arr\\SliceRight"));
	add_assoc_stringl_ex(return_value, SL("split"), SL("Phalcon\\Support\\Helper\\Arr\\Split"));
	add_assoc_stringl_ex(return_value, SL("toObject"), SL("Phalcon\\Support\\Helper\\Arr\\ToObject"));
	add_assoc_stringl_ex(return_value, SL("validateAll"), SL("Phalcon\\Support\\Helper\\Arr\\ValidateAll"));
	add_assoc_stringl_ex(return_value, SL("validateAny"), SL("Phalcon\\Support\\Helper\\Arr\\ValidateAny"));
	add_assoc_stringl_ex(return_value, SL("whitelist"), SL("Phalcon\\Support\\Helper\\Arr\\Whitelist"));
	add_assoc_stringl_ex(return_value, SL("basename"), SL("Phalcon\\Support\\Helper\\File\\Basename"));
	add_assoc_stringl_ex(return_value, SL("decode"), SL("Phalcon\\Support\\Helper\\Json\\Decode"));
	add_assoc_stringl_ex(return_value, SL("encode"), SL("Phalcon\\Support\\Helper\\Json\\Encode"));
	add_assoc_stringl_ex(return_value, SL("isBetween"), SL("Phalcon\\Support\\Helper\\Number\\IsBetween"));
	add_assoc_stringl_ex(return_value, SL("camelize"), SL("Phalcon\\Support\\Helper\\Str\\Camelize"));
	add_assoc_stringl_ex(return_value, SL("concat"), SL("Phalcon\\Support\\Helper\\Str\\Concat"));
	add_assoc_stringl_ex(return_value, SL("countVowels"), SL("Phalcon\\Support\\Helper\\Str\\CountVowels"));
	add_assoc_stringl_ex(return_value, SL("decapitalize"), SL("Phalcon\\Support\\Helper\\Str\\Decapitalize"));
	add_assoc_stringl_ex(return_value, SL("decrement"), SL("Phalcon\\Support\\Helper\\Str\\Decrement"));
	add_assoc_stringl_ex(return_value, SL("dirFromFile"), SL("Phalcon\\Support\\Helper\\Str\\DirFromFile"));
	add_assoc_stringl_ex(return_value, SL("dirSeparator"), SL("Phalcon\\Support\\Helper\\Str\\DirSeparator"));
	add_assoc_stringl_ex(return_value, SL("dynamic"), SL("Phalcon\\Support\\Helper\\Str\\Dynamic"));
	add_assoc_stringl_ex(return_value, SL("endsWith"), SL("Phalcon\\Support\\Helper\\Str\\EndsWith"));
	add_assoc_stringl_ex(return_value, SL("firstBetween"), SL("Phalcon\\Support\\Helper\\Str\\FirstBetween"));
	add_assoc_stringl_ex(return_value, SL("friendly"), SL("Phalcon\\Support\\Helper\\Str\\Friendly"));
	add_assoc_stringl_ex(return_value, SL("humanize"), SL("Phalcon\\Support\\Helper\\Str\\Humanize"));
	add_assoc_stringl_ex(return_value, SL("includes"), SL("Phalcon\\Support\\Helper\\Str\\Includes"));
	add_assoc_stringl_ex(return_value, SL("increment"), SL("Phalcon\\Support\\Helper\\Str\\Increment"));
	add_assoc_stringl_ex(return_value, SL("interpolate"), SL("Phalcon\\Support\\Helper\\Str\\Interpolate"));
	add_assoc_stringl_ex(return_value, SL("isAnagram"), SL("Phalcon\\Support\\Helper\\Str\\IsAnagram"));
	add_assoc_stringl_ex(return_value, SL("isLower"), SL("Phalcon\\Support\\Helper\\Str\\IsLower"));
	add_assoc_stringl_ex(return_value, SL("isPalindrome"), SL("Phalcon\\Support\\Helper\\Str\\IsPalindrome"));
	add_assoc_stringl_ex(return_value, SL("isUpper"), SL("Phalcon\\Support\\Helper\\Str\\IsUpper"));
	add_assoc_stringl_ex(return_value, SL("kebabCase"), SL("Phalcon\\Support\\Helper\\Str\\KebabCase"));
	add_assoc_stringl_ex(return_value, SL("len"), SL("Phalcon\\Support\\Helper\\Str\\Len"));
	add_assoc_stringl_ex(return_value, SL("lower"), SL("Phalcon\\Support\\Helper\\Str\\Lower"));
	add_assoc_stringl_ex(return_value, SL("pascalCase"), SL("Phalcon\\Support\\Helper\\Str\\PascalCase"));
	add_assoc_stringl_ex(return_value, SL("prefix"), SL("Phalcon\\Support\\Helper\\Str\\Prefix"));
	add_assoc_stringl_ex(return_value, SL("random"), SL("Phalcon\\Support\\Helper\\Str\\Random"));
	add_assoc_stringl_ex(return_value, SL("reduceSlashes"), SL("Phalcon\\Support\\Helper\\Str\\ReduceSlashes"));
	add_assoc_stringl_ex(return_value, SL("snakeCase"), SL("Phalcon\\Support\\Helper\\Str\\SnakeCase"));
	add_assoc_stringl_ex(return_value, SL("startsWith"), SL("Phalcon\\Support\\Helper\\Str\\StartsWith"));
	add_assoc_stringl_ex(return_value, SL("suffix"), SL("Phalcon\\Support\\Helper\\Str\\Suffix"));
	add_assoc_stringl_ex(return_value, SL("ucwords"), SL("Phalcon\\Support\\Helper\\Str\\Ucwords"));
	add_assoc_stringl_ex(return_value, SL("uncamelize"), SL("Phalcon\\Support\\Helper\\Str\\Uncamelize"));
	add_assoc_stringl_ex(return_value, SL("underscore"), SL("Phalcon\\Support\\Helper\\Str\\Underscore"));
	add_assoc_stringl_ex(return_value, SL("upper"), SL("Phalcon\\Support\\Helper\\Str\\Upper"));
	return;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Registry)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support, Registry, phalcon, support_registry, phalcon_support_collection_ce, phalcon_support_registry_method_entry, ZEND_ACC_FINAL_CLASS);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Registry, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL;
	zval data;

	ZVAL_UNDEF(&data);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &data_param);
	if (!data_param) {
		ZEPHIR_INIT_VAR(&data);
		array_init(&data);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&data, data_param);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "__construct", NULL, 0, &data);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, __get)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "get", NULL, 0, &element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, __isset)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "has", NULL, 0, &element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, __set)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *value, value_sub;
	zval element;

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "set", NULL, 0, &element, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, __unset)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "remove", NULL, 0, &element);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, clear)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "clear", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, count)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "count", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, get)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *defaultValue = NULL, defaultValue_sub, *cast_param = NULL, __$null;
	zval element, cast;

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&cast);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_STR(element)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
		Z_PARAM_STR_OR_NULL(cast)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &element_param, &defaultValue, &cast_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	if (!cast_param) {
		ZEPHIR_INIT_VAR(&cast);
	} else {
	if (UNEXPECTED(Z_TYPE_P(cast_param) != IS_STRING && Z_TYPE_P(cast_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'cast' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(cast_param) == IS_STRING)) {
		zephir_get_strval(&cast, cast_param);
	} else {
		ZEPHIR_INIT_VAR(&cast);
	}
	}
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "get", NULL, 0, &element, defaultValue, &cast);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, getIterator)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "getiterator", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, has)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "has", NULL, 0, &element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, init)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL;
	zval data;

	ZVAL_UNDEF(&data);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &data_param);
	if (!data_param) {
		ZEPHIR_INIT_VAR(&data);
		array_init(&data);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&data, data_param);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "init", NULL, 0, &data);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, jsonSerialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "jsonserialize", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, offsetExists)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element, element_sub;

	ZVAL_UNDEF(&element_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "has", NULL, 0, element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, offsetGet)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval element_sub;
	zval *element;

	ZVAL_UNDEF(&element_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "get", NULL, 0, element);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, offsetSet)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *offset, offset_sub, *value, value_sub;

	ZVAL_UNDEF(&offset_sub);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ZVAL(offset)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &offset, &value);
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "set", NULL, 0, offset, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, offsetUnset)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element, element_sub;

	ZVAL_UNDEF(&element_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element);
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "remove", NULL, 0, element);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, remove)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "remove", NULL, 0, &element);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, serialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "serialize", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, set)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *element_param = NULL, *value, value_sub;
	zval element;

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	if (UNEXPECTED(Z_TYPE_P(element_param) != IS_STRING && Z_TYPE_P(element_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'element' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(element_param) == IS_STRING)) {
		zephir_get_strval(&element, element_param);
	} else {
		ZEPHIR_INIT_VAR(&element);
	}
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "set", NULL, 0, &element, value);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Registry, toArray)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "toarray", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, toJson)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *options_param = NULL, _0;
	zend_long options, ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &options_param);
	if (!options_param) {
		options = 79;
	} else {
		}
	ZVAL_LONG(&_0, options);
	ZEPHIR_RETURN_CALL_PARENT(phalcon_support_registry_ce, getThis(), "tojson", NULL, 0, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Registry, unserialize)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *data_param = NULL;
	zval data;

	ZVAL_UNDEF(&data);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(data)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &data_param);
	zephir_get_strval(&data, data_param);
	ZEPHIR_CALL_PARENT(NULL, phalcon_support_registry_ce, getThis(), "unserialize", NULL, 0, &data);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Version)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support, Version, phalcon, support_version, phalcon_support_version_method_entry, 0);

	zephir_declare_class_constant_long(phalcon_support_version_ce, SL("VERSION_MAJOR"), 0);

	zephir_declare_class_constant_long(phalcon_support_version_ce, SL("VERSION_MEDIUM"), 1);

	zephir_declare_class_constant_long(phalcon_support_version_ce, SL("VERSION_MINOR"), 2);

	zephir_declare_class_constant_long(phalcon_support_version_ce, SL("VERSION_SPECIAL"), 3);

	zephir_declare_class_constant_long(phalcon_support_version_ce, SL("VERSION_SPECIAL_NUMBER"), 4);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Version, getVersion)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;

	ZVAL_UNDEF(&_0);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_create_array(return_value, 5, 0);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_LONG(&_0, 5);
	zephir_array_fast_append(return_value, &_0);
	ZEPHIR_INIT_NVAR(&_0);
	ZVAL_LONG(&_0, 8);
	zephir_array_fast_append(return_value, &_0);
	ZEPHIR_INIT_NVAR(&_0);
	ZVAL_LONG(&_0, 0);
	zephir_array_fast_append(return_value, &_0);
	ZEPHIR_INIT_NVAR(&_0);
	ZVAL_LONG(&_0, 4);
	zephir_array_fast_append(return_value, &_0);
	ZEPHIR_INIT_NVAR(&_0);
	ZVAL_LONG(&_0, 0);
	zephir_array_fast_append(return_value, &_0);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Version, getSpecial)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *special_param = NULL, suffix;
	zend_long special;

	ZVAL_UNDEF(&suffix);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_LONG(special)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &special_param);
	do {
		if (special == 1) {
			ZEPHIR_INIT_VAR(&suffix);
			ZVAL_STRING(&suffix, "alpha");
			break;
		}
		if (special == 2) {
			ZEPHIR_INIT_NVAR(&suffix);
			ZVAL_STRING(&suffix, "beta");
			break;
		}
		if (special == 3) {
			ZEPHIR_INIT_NVAR(&suffix);
			ZVAL_STRING(&suffix, "RC");
			break;
		}
		ZEPHIR_INIT_NVAR(&suffix);
		ZVAL_STRING(&suffix, "");
		break;
	} while(0);

	RETURN_CCTOR(&suffix);
}

static PHP_METHOD(Phalcon_Support_Version, get)
{
	zval result;
	zval version, major, medium, minor, special, specialNumber, suffix, _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&version);
	ZVAL_UNDEF(&major);
	ZVAL_UNDEF(&medium);
	ZVAL_UNDEF(&minor);
	ZVAL_UNDEF(&special);
	ZVAL_UNDEF(&specialNumber);
	ZVAL_UNDEF(&suffix);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&result);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_CALL_METHOD(&version, this_ptr, "getversion", NULL, 0);
	zephir_check_call_status();
	zephir_memory_observe(&major);
	zephir_array_fetch_long(&major, &version, 0, PH_NOISY, "phalcon/Support/Version.zep", 122);
	zephir_memory_observe(&medium);
	zephir_array_fetch_long(&medium, &version, 1, PH_NOISY, "phalcon/Support/Version.zep", 123);
	zephir_memory_observe(&minor);
	zephir_array_fetch_long(&minor, &version, 2, PH_NOISY, "phalcon/Support/Version.zep", 124);
	zephir_memory_observe(&special);
	zephir_array_fetch_long(&special, &version, 3, PH_NOISY, "phalcon/Support/Version.zep", 125);
	zephir_memory_observe(&specialNumber);
	zephir_array_fetch_long(&specialNumber, &version, 4, PH_NOISY, "phalcon/Support/Version.zep", 126);
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_CONCAT_VSVSV(&_0, &major, ".", &medium, ".", &minor);
	zephir_get_strval(&result, &_0);
	ZEPHIR_CALL_METHOD(&suffix, this_ptr, "getspecial", NULL, 0, &special);
	zephir_check_call_status();
	if (!ZEPHIR_IS_STRING(&suffix, "")) {
		zephir_concat_self(&result, &suffix);
		if (!ZEPHIR_IS_LONG(&specialNumber, 0)) {
			zephir_concat_self(&result, &specialNumber);
		}
	}
	RETURN_CTOR(&result);
}

static PHP_METHOD(Phalcon_Support_Version, getId)
{
	zval version, major, medium, minor, special, specialNumber, _0, _1, _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&version);
	ZVAL_UNDEF(&major);
	ZVAL_UNDEF(&medium);
	ZVAL_UNDEF(&minor);
	ZVAL_UNDEF(&special);
	ZVAL_UNDEF(&specialNumber);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_CALL_METHOD(&version, this_ptr, "getversion", NULL, 0);
	zephir_check_call_status();
	zephir_memory_observe(&major);
	zephir_array_fetch_long(&major, &version, 0, PH_NOISY, "phalcon/Support/Version.zep", 160);
	zephir_memory_observe(&medium);
	zephir_array_fetch_long(&medium, &version, 1, PH_NOISY, "phalcon/Support/Version.zep", 161);
	zephir_memory_observe(&minor);
	zephir_array_fetch_long(&minor, &version, 2, PH_NOISY, "phalcon/Support/Version.zep", 162);
	zephir_memory_observe(&special);
	zephir_array_fetch_long(&special, &version, 3, PH_NOISY, "phalcon/Support/Version.zep", 163);
	zephir_memory_observe(&specialNumber);
	zephir_array_fetch_long(&specialNumber, &version, 4, PH_NOISY, "phalcon/Support/Version.zep", 164);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "%02s");
	ZEPHIR_CALL_FUNCTION(&_1, "sprintf", NULL, 117, &_0, &medium);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_0);
	ZVAL_STRING(&_0, "%02s");
	ZEPHIR_CALL_FUNCTION(&_2, "sprintf", NULL, 117, &_0, &minor);
	zephir_check_call_status();
	ZEPHIR_CONCAT_VVVVV(return_value, &major, &_1, &_2, &special, &specialNumber);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Version, getPart)
{
	zval _1$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *part_param = NULL, version, _0$$3, _2$$4;
	zend_long part, ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&version);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_2$$4);
	ZVAL_UNDEF(&_1$$3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_LONG(part)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &part_param);
	ZEPHIR_CALL_METHOD(&version, this_ptr, "getversion", NULL, 0);
	zephir_check_call_status();
	do {
		if (part == 0 || part == 1 || part == 2 || part == 4) {
			zephir_memory_observe(&_0$$3);
			zephir_array_fetch_long(&_0$$3, &version, part, PH_NOISY, "phalcon/Support/Version.zep", 192);
			zephir_cast_to_string(&_1$$3, &_0$$3);
			RETURN_CTOR(&_1$$3);
		}
		if (part == 3) {
			zephir_array_fetch_long(&_2$$4, &version, 3, PH_NOISY | PH_READONLY, "phalcon/Support/Version.zep", 195);
			ZEPHIR_RETURN_CALL_METHOD(this_ptr, "getspecial", NULL, 0, &_2$$4);
			zephir_check_call_status();
			RETURN_MM();
		}
	} while(0);

	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "get", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper, Exception, phalcon, support_helper_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_File_Basename)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\File, Basename, phalcon, support_helper_file_basename, phalcon_support_helper_file_basename_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_File_Basename, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *uri_param = NULL, *suffix_param = NULL, fileName, matches, _0, _1, _2, _3, _4, _5, _6$$3, _7$$3, _8$$3, _9$$3;
	zval uri, suffix;

	ZVAL_UNDEF(&uri);
	ZVAL_UNDEF(&suffix);
	ZVAL_UNDEF(&fileName);
	ZVAL_UNDEF(&matches);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_6$$3);
	ZVAL_UNDEF(&_7$$3);
	ZVAL_UNDEF(&_8$$3);
	ZVAL_UNDEF(&_9$$3);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(uri)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(suffix)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &uri_param, &suffix_param);
	zephir_get_strval(&uri, uri_param);
	if (!suffix_param) {
		ZEPHIR_INIT_VAR(&suffix);
	} else {
		zephir_get_strval(&suffix, suffix_param);
	}
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "/");
	zephir_fast_trim(&_0, &uri, &_1, ZEPHIR_TRIM_RIGHT);
	zephir_get_strval(&uri, &_0);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "/");
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "@");
	ZEPHIR_CALL_FUNCTION(&_4, "preg_quote", NULL, 351, &_2, &_3);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_5);
	ZEPHIR_CONCAT_SVS(&_5, "@[^", &_4, "]+$@");
	ZEPHIR_INIT_NVAR(&_2);
	zephir_preg_match(&_2, &_5, &uri, &matches, 0, 0 , 0 );
	if (zephir_is_true(&_2)) {
		zephir_memory_observe(&fileName);
		zephir_array_fetch_long(&fileName, &matches, 0, PH_NOISY, "phalcon/Support/Helper/File/Basename.zep", 39);
	} else {
		ZEPHIR_INIT_NVAR(&fileName);
		ZVAL_STRING(&fileName, "");
	}
	if (1 != ZEPHIR_IS_EMPTY(&suffix)) {
		ZEPHIR_INIT_VAR(&_6$$3);
		ZVAL_STRING(&_6$$3, "@");
		ZEPHIR_CALL_FUNCTION(&_7$$3, "preg_quote", NULL, 351, &suffix, &_6$$3);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&_8$$3);
		ZEPHIR_CONCAT_SVS(&_8$$3, "@", &_7$$3, "$@");
		ZEPHIR_INIT_NVAR(&_6$$3);
		ZVAL_STRING(&_6$$3, "");
		ZEPHIR_CALL_FUNCTION(&_9$$3, "preg_replace", NULL, 41, &_8$$3, &_6$$3, &fileName);
		zephir_check_call_status();
		ZEPHIR_CPY_WRT(&fileName, &_9$$3);
	}
	RETURN_CCTOR(&fileName);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Number_IsBetween)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Number, IsBetween, phalcon, support_helper_number_isbetween, phalcon_support_helper_number_isbetween_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Number_IsBetween, __invoke)
{
	zend_bool _0;
	zval *value_param = NULL, *start_param = NULL, *end_param = NULL;
	zend_long value, start, end;

	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_LONG(value)
		Z_PARAM_LONG(start)
		Z_PARAM_LONG(end)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(3, 0, &value_param, &start_param, &end_param);
	_0 = value >= start;
	if (_0) {
		_0 = value <= end;
	}
	RETURN_BOOL(_0);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Json_Decode)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Json, Decode, phalcon, support_helper_json_decode, phalcon_support_helper_json_decode_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Json_Decode, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long depth, options, ZEPHIR_LAST_CALL_STATUS;
	zend_bool associative;
	zval *data_param = NULL, *associative_param = NULL, *depth_param = NULL, *options_param = NULL, __$null, decoded, error, message, _0, _1, _2, _3$$3, _4$$3;
	zval data;

	ZVAL_UNDEF(&data);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&decoded);
	ZVAL_UNDEF(&error);
	ZVAL_UNDEF(&message);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$3);
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(data)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(associative)
		Z_PARAM_LONG(depth)
		Z_PARAM_LONG(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &data_param, &associative_param, &depth_param, &options_param);
	zephir_get_strval(&data, data_param);
	if (!associative_param) {
		associative = 0;
	} else {
		}
	if (!depth_param) {
		depth = 512;
	} else {
		}
	if (!options_param) {
		options = 79;
	} else {
		}
	ZEPHIR_INIT_VAR(&decoded);
	zephir_json_encode(&decoded, &__$null, 0 );
	ZVAL_BOOL(&_0, (associative ? 1 : 0));
	ZVAL_LONG(&_1, depth);
	ZVAL_LONG(&_2, options);
	ZEPHIR_INIT_NVAR(&decoded);
	zephir_json_decode(&decoded, &data, zephir_get_intval(&_0) );
	ZEPHIR_CALL_FUNCTION(&error, "json_last_error", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&message, "json_last_error_msg", NULL, 0);
	zephir_check_call_status();
	if (!ZEPHIR_IS_LONG_IDENTICAL(&error, 0)) {
		ZEPHIR_INIT_VAR(&_3$$3);
		zephir_json_encode(&_3$$3, &__$null, 0 );
		ZEPHIR_INIT_VAR(&_4$$3);
		object_init_ex(&_4$$3, spl_ce_InvalidArgumentException);
		ZEPHIR_CALL_METHOD(NULL, &_4$$3, "__construct", NULL, 200, &message, &error);
		zephir_check_call_status();
		zephir_throw_exception_debug(&_4$$3, "phalcon/Support/Helper/Json/Decode.zep", 64);
		ZEPHIR_MM_RESTORE();
		return;
	}
	RETURN_CCTOR(&decoded);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Json_Encode)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Json, Encode, phalcon, support_helper_json_encode, phalcon_support_helper_json_encode_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Json_Encode, __invoke)
{
	zval _4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long options, depth, ZEPHIR_LAST_CALL_STATUS;
	zval *data, data_sub, *options_param = NULL, *depth_param = NULL, __$null, encoded, error, message, _0, _1, _2$$3, _3$$3;

	ZVAL_UNDEF(&data_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&encoded);
	ZVAL_UNDEF(&error);
	ZVAL_UNDEF(&message);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4);
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(data)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(options)
		Z_PARAM_LONG(depth)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &data, &options_param, &depth_param);
	if (!options_param) {
		options = 79;
	} else {
		}
	if (!depth_param) {
		depth = 512;
	} else {
		}
	ZEPHIR_INIT_VAR(&encoded);
	zephir_json_encode(&encoded, &__$null, 0 );
	ZVAL_LONG(&_0, options);
	ZVAL_LONG(&_1, depth);
	ZEPHIR_INIT_NVAR(&encoded);
	zephir_json_encode(&encoded, data, zephir_get_intval(&_0) );
	ZEPHIR_CALL_FUNCTION(&error, "json_last_error", NULL, 0);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&message, "json_last_error_msg", NULL, 0);
	zephir_check_call_status();
	if (!ZEPHIR_IS_LONG_IDENTICAL(&error, 0)) {
		ZEPHIR_INIT_VAR(&_2$$3);
		zephir_json_encode(&_2$$3, &__$null, 0 );
		ZEPHIR_INIT_VAR(&_3$$3);
		object_init_ex(&_3$$3, spl_ce_InvalidArgumentException);
		ZEPHIR_CALL_METHOD(NULL, &_3$$3, "__construct", NULL, 200, &message, &error);
		zephir_check_call_status();
		zephir_throw_exception_debug(&_3$$3, "phalcon/Support/Helper/Json/Encode.zep", 64);
		ZEPHIR_MM_RESTORE();
		return;
	}
	zephir_cast_to_string(&_4, &encoded);
	RETURN_CTOR(&_4);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_AbstractStr)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, AbstractStr, phalcon, support_helper_str_abstractstr, phalcon_support_helper_str_abstractstr_method_entry, ZEND_ACC_EXPLICIT_ABSTRACT_CLASS);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_AbstractStr, toEndsWith)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool ignoreCase;
	zval *haystack_param = NULL, *needle_param = NULL, *ignoreCase_param = NULL, child, parent, _0;
	zval haystack, needle;

	ZVAL_UNDEF(&haystack);
	ZVAL_UNDEF(&needle);
	ZVAL_UNDEF(&child);
	ZVAL_UNDEF(&parent);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_STR(haystack)
		Z_PARAM_STR(needle)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(ignoreCase)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &haystack_param, &needle_param, &ignoreCase_param);
	zephir_get_strval(&haystack, haystack_param);
	zephir_get_strval(&needle, needle_param);
	if (!ignoreCase_param) {
		ignoreCase = 1;
	} else {
		}
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "");
	if (ZEPHIR_IS_IDENTICAL(&_0, &haystack)) {
		RETURN_MM_BOOL(0);
	}
	if (EXPECTED(ignoreCase)) {
		ZEPHIR_CALL_FUNCTION(&child, "mb_strtolower", NULL, 10, &needle);
		zephir_check_call_status();
		ZEPHIR_CALL_FUNCTION(&parent, "mb_strtolower", NULL, 10, &haystack);
		zephir_check_call_status();
	} else {
		ZEPHIR_CPY_WRT(&child, &needle);
		ZEPHIR_CPY_WRT(&parent, &haystack);
	}
	RETURN_MM_BOOL(zephir_end_with(&parent, &child, NULL));
}

static PHP_METHOD(Phalcon_Support_Helper_Str_AbstractStr, toInterpolate)
{
	zend_string *_3;
	zend_ulong _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval context;
	zval *input_param = NULL, *context_param = NULL, *left_param = NULL, *right_param = NULL, key, replace, value, *_0, _1, _4$$4, _5$$5;
	zval input, left, right;

	ZVAL_UNDEF(&input);
	ZVAL_UNDEF(&left);
	ZVAL_UNDEF(&right);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&replace);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_4$$4);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&context);
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(input)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(context)
		Z_PARAM_STR(left)
		Z_PARAM_STR(right)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &input_param, &context_param, &left_param, &right_param);
	zephir_get_strval(&input, input_param);
	if (!context_param) {
		ZEPHIR_INIT_VAR(&context);
		array_init(&context);
	} else {
		zephir_get_arrval(&context, context_param);
	}
	if (!left_param) {
		ZEPHIR_INIT_VAR(&left);
		ZVAL_STRING(&left, "%");
	} else {
		zephir_get_strval(&left, left_param);
	}
	if (!right_param) {
		ZEPHIR_INIT_VAR(&right);
		ZVAL_STRING(&right, "%");
	} else {
		zephir_get_strval(&right, right_param);
	}
	if (ZEPHIR_IS_EMPTY(&context)) {
		RETURN_CTOR(&input);
	}
	ZEPHIR_INIT_VAR(&replace);
	array_init(&replace);
	zephir_is_iterable(&context, 0, "phalcon/Support/Helper/Str/AbstractStr.zep", 82);
	if (Z_TYPE_P(&context) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&context), _2, _3, _0)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_3 != NULL) { 
				ZVAL_STR_COPY(&key, _3);
			} else {
				ZVAL_LONG(&key, _2);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _0);
			ZEPHIR_INIT_NVAR(&_4$$4);
			ZEPHIR_CONCAT_VVV(&_4$$4, &left, &key, &right);
			zephir_array_update_zval(&replace, &_4$$4, &value, PH_COPY | PH_SEPARATE);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &context, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &context, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &context, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &context, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_5$$5);
				ZEPHIR_CONCAT_VVV(&_5$$5, &left, &key, &right);
				zephir_array_update_zval(&replace, &_5$$5, &value, PH_COPY | PH_SEPARATE);
			ZEPHIR_CALL_METHOD(NULL, &context, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	ZEPHIR_RETURN_CALL_FUNCTION("strtr", NULL, 5, &input, &replace);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Str_AbstractStr, toLower)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL, _0;
	zval text, encoding;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZVAL_LONG(&_0, 1);
	ZEPHIR_RETURN_CALL_FUNCTION("mb_convert_case", NULL, 12, &text, &_0, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Str_AbstractStr, toStartsWith)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool ignoreCase;
	zval *haystack_param = NULL, *needle_param = NULL, *ignoreCase_param = NULL, child, parent, _0;
	zval haystack, needle;

	ZVAL_UNDEF(&haystack);
	ZVAL_UNDEF(&needle);
	ZVAL_UNDEF(&child);
	ZVAL_UNDEF(&parent);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_STR(haystack)
		Z_PARAM_STR(needle)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(ignoreCase)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &haystack_param, &needle_param, &ignoreCase_param);
	zephir_get_strval(&haystack, haystack_param);
	zephir_get_strval(&needle, needle_param);
	if (!ignoreCase_param) {
		ignoreCase = 1;
	} else {
		}
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "");
	if (ZEPHIR_IS_IDENTICAL(&_0, &haystack)) {
		RETURN_MM_BOOL(0);
	}
	if (EXPECTED(ignoreCase)) {
		ZEPHIR_CALL_FUNCTION(&child, "mb_strtolower", NULL, 10, &needle);
		zephir_check_call_status();
		ZEPHIR_CALL_FUNCTION(&parent, "mb_strtolower", NULL, 10, &haystack);
		zephir_check_call_status();
	} else {
		ZEPHIR_CPY_WRT(&child, &needle);
		ZEPHIR_CPY_WRT(&parent, &haystack);
	}
	RETURN_MM_BOOL(zephir_start_with(&parent, &child, NULL));
}

static PHP_METHOD(Phalcon_Support_Helper_Str_AbstractStr, toUpper)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL, _0;
	zval text, encoding;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZVAL_LONG(&_0, 0);
	ZEPHIR_RETURN_CALL_FUNCTION("mb_convert_case", NULL, 12, &text, &_0, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Camelize)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Camelize, phalcon, support_helper_str_camelize, phalcon_support_helper_str_pascalcase_ce, phalcon_support_helper_str_camelize_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Camelize, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool lowerFirst;
	zval *text_param = NULL, *delimiters_param = NULL, *lowerFirst_param = NULL, result, _0$$3;
	zval text, delimiters;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiters);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0$$3);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(delimiters)
		Z_PARAM_BOOL(lowerFirst)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &text_param, &delimiters_param, &lowerFirst_param);
	zephir_get_strval(&text, text_param);
	if (!delimiters_param) {
		ZEPHIR_INIT_VAR(&delimiters);
	} else {
		zephir_get_strval(&delimiters, delimiters_param);
	}
	if (!lowerFirst_param) {
		lowerFirst = 0;
	} else {
		}
	ZEPHIR_CALL_PARENT(&result, phalcon_support_helper_str_camelize_ce, getThis(), "__invoke", NULL, 0, &text, &delimiters);
	zephir_check_call_status();
	if (lowerFirst == 1) {
		ZEPHIR_CALL_FUNCTION(&_0$$3, "lcfirst", NULL, 76, &result);
		zephir_check_call_status();
		ZEPHIR_CPY_WRT(&result, &_0$$3);
	}
	RETURN_CCTOR(&result);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Concat)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Concat, phalcon, support_helper_str_concat, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_concat_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Concat, __invoke)
{
	zval argument, arguments, delimiter, data, first, last, prefix, suffix, _0, _1, *_2, _3, _6, _4$$6, _5$$7;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&arguments);
	ZVAL_UNDEF(&delimiter);
	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&first);
	ZVAL_UNDEF(&last);
	ZVAL_UNDEF(&prefix);
	ZVAL_UNDEF(&suffix);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_4$$6);
	ZVAL_UNDEF(&_5$$7);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&arguments);
	zephir_get_args(&arguments);
	if (UNEXPECTED(zephir_fast_count_int(&arguments) < 3)) {
		ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_support_helper_exception_ce, "concat needs at least three parameters", "phalcon/Support/Helper/Str/Concat.zep", 37);
		return;
	}
	ZEPHIR_MAKE_REF(&arguments);
	ZEPHIR_CALL_FUNCTION(&delimiter, "reset", NULL, 477, &arguments);
	ZEPHIR_UNREF(&arguments);
	zephir_check_call_status();
	ZVAL_LONG(&_0, 1);
	ZEPHIR_CALL_FUNCTION(&_1, "array_slice", NULL, 501, &arguments, &_0);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&arguments, &_1);
	ZEPHIR_MAKE_REF(&arguments);
	ZEPHIR_CALL_FUNCTION(&first, "reset", NULL, 477, &arguments);
	ZEPHIR_UNREF(&arguments);
	zephir_check_call_status();
	ZEPHIR_MAKE_REF(&arguments);
	ZEPHIR_CALL_FUNCTION(&last, "end", NULL, 320, &arguments);
	ZEPHIR_UNREF(&arguments);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&prefix);
	ZVAL_STRING(&prefix, "");
	ZEPHIR_INIT_VAR(&suffix);
	ZVAL_STRING(&suffix, "");
	ZEPHIR_INIT_VAR(&data);
	array_init(&data);
	if (zephir_start_with(&first, &delimiter, NULL)) {
		ZEPHIR_CPY_WRT(&prefix, &delimiter);
	}
	if (zephir_end_with(&last, &delimiter, NULL)) {
		ZEPHIR_CPY_WRT(&suffix, &delimiter);
	}
	zephir_is_iterable(&arguments, 0, "phalcon/Support/Helper/Str/Concat.zep", 61);
	if (Z_TYPE_P(&arguments) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&arguments), _2)
		{
			ZEPHIR_INIT_NVAR(&argument);
			ZVAL_COPY(&argument, _2);
			ZEPHIR_INIT_NVAR(&_4$$6);
			zephir_fast_trim(&_4$$6, &argument, &delimiter, ZEPHIR_TRIM_BOTH);
			zephir_array_append(&data, &_4$$6, PH_SEPARATE, "phalcon/Support/Helper/Str/Concat.zep", 58);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &arguments, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_3, &arguments, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_3)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&argument, &arguments, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_5$$7);
				zephir_fast_trim(&_5$$7, &argument, &delimiter, ZEPHIR_TRIM_BOTH);
				zephir_array_append(&data, &_5$$7, PH_SEPARATE, "phalcon/Support/Helper/Str/Concat.zep", 58);
			ZEPHIR_CALL_METHOD(NULL, &arguments, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&argument);
	ZEPHIR_INIT_VAR(&_6);
	zephir_fast_join(&_6, &delimiter, &data);
	ZEPHIR_CONCAT_VVV(return_value, &prefix, &_6, &suffix);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_CountVowels)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, CountVowels, phalcon, support_helper_str_countvowels, phalcon_support_helper_str_countvowels_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_CountVowels, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *text_param = NULL, matches, _0, _1, _2, _3;
	zval text;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&matches);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(text)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &text_param);
	zephir_get_strval(&text, text_param);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "/[aeiouy]/i");
	ZEPHIR_INIT_VAR(&_1);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "/[aeiouy]/i");
	zephir_preg_match(&_1, &_2, &text, &matches, 1, 0 , 0 );
	zephir_array_fetch_long(&_3, &matches, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/CountVowels.zep", 30);
	RETURN_MM_LONG(zephir_fast_count_int(&_3));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Decapitalize)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Decapitalize, phalcon, support_helper_str_decapitalize, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_decapitalize_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Decapitalize, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool upperRest;
	zval *text_param = NULL, *upperRest_param = NULL, *encoding_param = NULL, substr, suffix, _0, _1, _2, _3;
	zval text, encoding;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&substr);
	ZVAL_UNDEF(&suffix);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(upperRest)
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &text_param, &upperRest_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!upperRest_param) {
		upperRest = 0;
	} else {
		}
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZVAL_LONG(&_0, 1);
	ZEPHIR_CALL_FUNCTION(&substr, "mb_substr", NULL, 228, &text, &_0);
	zephir_check_call_status();
	if (upperRest) {
		ZEPHIR_CALL_METHOD(&suffix, this_ptr, "toupper", NULL, 0, &substr, &encoding);
		zephir_check_call_status();
	} else {
		ZEPHIR_CPY_WRT(&suffix, &substr);
	}
	ZVAL_LONG(&_0, 0);
	ZVAL_LONG(&_2, 1);
	ZEPHIR_CALL_FUNCTION(&_3, "mb_substr", NULL, 228, &text, &_0, &_2);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&_1, this_ptr, "tolower", NULL, 0, &_3, &encoding);
	zephir_check_call_status();
	ZEPHIR_CONCAT_VV(return_value, &_1, &suffix);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Decrement)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Decrement, phalcon, support_helper_str_decrement, phalcon_support_helper_str_decrement_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Decrement, __invoke)
{
	zend_long number = 0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *text_param = NULL, *separator_param = NULL, parts, _0, _3, _4, _1$$3, _2$$4;
	zval text, separator;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&separator);
	ZVAL_UNDEF(&parts);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$4);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(separator)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &separator_param);
	zephir_get_strval(&text, text_param);
	if (!separator_param) {
		ZEPHIR_INIT_VAR(&separator);
		ZVAL_STRING(&separator, "_");
	} else {
		zephir_get_strval(&separator, separator_param);
	}
	number = 0;
	ZEPHIR_INIT_VAR(&parts);
	zephir_fast_explode(&parts, &separator, &text, LONG_MAX);
	ZEPHIR_INIT_VAR(&_0);
	if (Z_TYPE_P(&parts) != IS_ARRAY) {
		ZEPHIR_INIT_NVAR(&_0);
		array_init(&_0);
	} else {
		ZEPHIR_CPY_WRT(&_0, &parts);
	}
	ZEPHIR_CPY_WRT(&parts, &_0);
	if (1 == zephir_array_isset_long(&parts, 1)) {
		zephir_memory_observe(&_1$$3);
		zephir_array_fetch_long(&_1$$3, &parts, 1, PH_NOISY, "phalcon/Support/Helper/Str/Decrement.zep", 36);
		number = zephir_get_intval(&_1$$3);
		number--;
		if (number <= 0) {
			zephir_array_fetch_long(&_2$$4, &parts, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Decrement.zep", 39);
			RETURN_CTOR(&_2$$4);
		}
	}
	zephir_array_fetch_long(&_3, &parts, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Decrement.zep", 43);
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_LONG(&_4, number);
	ZEPHIR_CONCAT_VVV(return_value, &_3, &separator, &_4);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_DirFromFile)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, DirFromFile, phalcon, support_helper_str_dirfromfile, phalcon_support_helper_str_dirfromfile_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_DirFromFile, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *file_param = NULL, name, start, _0, _1, _4, _5, _2$$3, _3$$3;
	zval file;

	ZVAL_UNDEF(&file);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&start);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(file)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &file_param);
	zephir_get_strval(&file, file_param);
	ZVAL_LONG(&_0, 8);
	ZEPHIR_CALL_FUNCTION(&name, "pathinfo", NULL, 89, &file, &_0);
	zephir_check_call_status();
	ZVAL_LONG(&_0, 0);
	ZVAL_LONG(&_1, -2);
	ZEPHIR_CALL_FUNCTION(&start, "mb_substr", NULL, 228, &name, &_0, &_1);
	zephir_check_call_status();
	if (!zephir_is_true(&start)) {
		ZVAL_LONG(&_2$$3, 0);
		ZVAL_LONG(&_3$$3, 1);
		ZEPHIR_CALL_FUNCTION(&start, "mb_substr", NULL, 228, &name, &_2$$3, &_3$$3);
		zephir_check_call_status();
	}
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_LONG(&_0, 2);
	ZEPHIR_CALL_FUNCTION(&_5, "mb_str_split", NULL, 0, &start, &_0);
	zephir_check_call_status();
	zephir_fast_join_str(&_4, SL("/"), &_5);
	ZEPHIR_CONCAT_VS(return_value, &_4, "/");
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_DirSeparator)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, DirSeparator, phalcon, support_helper_str_dirseparator, phalcon_support_helper_str_dirseparator_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_DirSeparator, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *directory_param = NULL, _0, _1;
	zval directory;

	ZVAL_UNDEF(&directory);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(directory)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &directory_param);
	zephir_get_strval(&directory, directory_param);
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "/");
	zephir_fast_trim(&_0, &directory, &_1, ZEPHIR_TRIM_RIGHT);
	ZEPHIR_CONCAT_VS(return_value, &_0, "/");
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Dynamic)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Dynamic, phalcon, support_helper_str_dynamic, phalcon_support_helper_str_dynamic_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Dynamic, __invoke)
{
	zend_bool _8$$6, _17$$8;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_11 = NULL, *_16 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *leftDelimiter_param = NULL, *rightDelimiter_param = NULL, *separator_param = NULL, ldS, rdS, matches, match, words, word, sub, _0, _1, _4, _5, _2$$3, *_6$$5, _7$$5, _9$$6, _10$$6, _12$$6, _13$$6, _14$$6, _15$$6, _18$$8, _19$$8, _20$$8, _21$$8, _22$$8, _23$$8;
	zval text, leftDelimiter, rightDelimiter, separator, pattern, _3$$3;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&leftDelimiter);
	ZVAL_UNDEF(&rightDelimiter);
	ZVAL_UNDEF(&separator);
	ZVAL_UNDEF(&pattern);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&ldS);
	ZVAL_UNDEF(&rdS);
	ZVAL_UNDEF(&matches);
	ZVAL_UNDEF(&match);
	ZVAL_UNDEF(&words);
	ZVAL_UNDEF(&word);
	ZVAL_UNDEF(&sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_7$$5);
	ZVAL_UNDEF(&_9$$6);
	ZVAL_UNDEF(&_10$$6);
	ZVAL_UNDEF(&_12$$6);
	ZVAL_UNDEF(&_13$$6);
	ZVAL_UNDEF(&_14$$6);
	ZVAL_UNDEF(&_15$$6);
	ZVAL_UNDEF(&_18$$8);
	ZVAL_UNDEF(&_19$$8);
	ZVAL_UNDEF(&_20$$8);
	ZVAL_UNDEF(&_21$$8);
	ZVAL_UNDEF(&_22$$8);
	ZVAL_UNDEF(&_23$$8);
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(leftDelimiter)
		Z_PARAM_STR(rightDelimiter)
		Z_PARAM_STR(separator)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &text_param, &leftDelimiter_param, &rightDelimiter_param, &separator_param);
	zephir_get_strval(&text, text_param);
	if (!leftDelimiter_param) {
		ZEPHIR_INIT_VAR(&leftDelimiter);
		ZVAL_STRING(&leftDelimiter, "{");
	} else {
		zephir_get_strval(&leftDelimiter, leftDelimiter_param);
	}
	if (!rightDelimiter_param) {
		ZEPHIR_INIT_VAR(&rightDelimiter);
		ZVAL_STRING(&rightDelimiter, "}");
	} else {
		zephir_get_strval(&rightDelimiter, rightDelimiter_param);
	}
	if (!separator_param) {
		ZEPHIR_INIT_VAR(&separator);
		ZVAL_STRING(&separator, "|");
	} else {
		zephir_get_strval(&separator, separator_param);
	}
	ZEPHIR_CALL_FUNCTION(&_0, "substr_count", NULL, 0, &text, &leftDelimiter);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&_1, "substr_count", NULL, 0, &text, &rightDelimiter);
	zephir_check_call_status();
	if (UNEXPECTED(!ZEPHIR_IS_IDENTICAL(&_0, &_1))) {
		ZEPHIR_INIT_VAR(&_2$$3);
		object_init_ex(&_2$$3, spl_ce_RuntimeException);
		ZEPHIR_INIT_VAR(&_3$$3);
		ZEPHIR_CONCAT_SVS(&_3$$3, "Syntax error in string '", &text, "'");
		ZEPHIR_CALL_METHOD(NULL, &_2$$3, "__construct", NULL, 0, &_3$$3);
		zephir_check_call_status();
		zephir_throw_exception_debug(&_2$$3, "phalcon/Support/Helper/Str/Dynamic.zep", 43);
		ZEPHIR_MM_RESTORE();
		return;
	}
	ZEPHIR_CALL_FUNCTION(&ldS, "preg_quote", NULL, 351, &leftDelimiter);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&rdS, "preg_quote", NULL, 351, &rightDelimiter);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_4);
	ZEPHIR_CONCAT_SVSVVSVS(&_4, "/", &ldS, "([^", &ldS, &rdS, "]+)", &rdS, "/");
	zephir_get_strval(&pattern, &_4);
	ZEPHIR_INIT_VAR(&matches);
	array_init(&matches);
	ZEPHIR_INIT_VAR(&_5);
	zephir_preg_match(&_5, &pattern, &text, &matches, 1, 2 , 0 );
	if (!(zephir_is_true(&_5))) {
		RETURN_CTOR(&text);
	}
	if (Z_TYPE_P(&matches) == IS_ARRAY) {
		zephir_is_iterable(&matches, 0, "phalcon/Support/Helper/Str/Dynamic.zep", 66);
		if (Z_TYPE_P(&matches) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&matches), _6$$5)
			{
				ZEPHIR_INIT_NVAR(&match);
				ZVAL_COPY(&match, _6$$5);
				_8$$6 = !(zephir_array_isset_long(&match, 0));
				if (!(_8$$6)) {
					_8$$6 = !(zephir_array_isset_long(&match, 1));
				}
				if (_8$$6) {
					continue;
				}
				zephir_array_fetch_long(&_9$$6, &match, 1, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Dynamic.zep", 61);
				ZEPHIR_INIT_NVAR(&words);
				zephir_fast_explode(&words, &separator, &_9$$6, LONG_MAX);
				ZEPHIR_OBS_NVAR(&word);
				ZEPHIR_CALL_FUNCTION(&_10$$6, "array_rand", &_11, 202, &words);
				zephir_check_call_status();
				zephir_array_fetch(&word, &words, &_10$$6, PH_NOISY, "phalcon/Support/Helper/Str/Dynamic.zep", 62);
				zephir_array_fetch_long(&_12$$6, &match, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Dynamic.zep", 63);
				ZEPHIR_CALL_FUNCTION(&sub, "preg_quote", NULL, 351, &_12$$6, &separator);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_13$$6);
				ZEPHIR_CONCAT_SVS(&_13$$6, "/", &sub, "/");
				ZVAL_LONG(&_14$$6, 1);
				ZEPHIR_CALL_FUNCTION(&_15$$6, "preg_replace", &_16, 41, &_13$$6, &word, &text, &_14$$6);
				zephir_check_call_status();
				zephir_get_strval(&text, &_15$$6);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &matches, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_7$$5, &matches, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_7$$5)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&match, &matches, "current", NULL, 0);
				zephir_check_call_status();
					_17$$8 = !(zephir_array_isset_long(&match, 0));
					if (!(_17$$8)) {
						_17$$8 = !(zephir_array_isset_long(&match, 1));
					}
					if (_17$$8) {
						continue;
					}
					zephir_array_fetch_long(&_18$$8, &match, 1, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Dynamic.zep", 61);
					ZEPHIR_INIT_NVAR(&words);
					zephir_fast_explode(&words, &separator, &_18$$8, LONG_MAX);
					ZEPHIR_OBS_NVAR(&word);
					ZEPHIR_CALL_FUNCTION(&_19$$8, "array_rand", &_11, 202, &words);
					zephir_check_call_status();
					zephir_array_fetch(&word, &words, &_19$$8, PH_NOISY, "phalcon/Support/Helper/Str/Dynamic.zep", 62);
					zephir_array_fetch_long(&_20$$8, &match, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Dynamic.zep", 63);
					ZEPHIR_CALL_FUNCTION(&sub, "preg_quote", NULL, 351, &_20$$8, &separator);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_21$$8);
					ZEPHIR_CONCAT_SVS(&_21$$8, "/", &sub, "/");
					ZVAL_LONG(&_22$$8, 1);
					ZEPHIR_CALL_FUNCTION(&_23$$8, "preg_replace", &_16, 41, &_21$$8, &word, &text, &_22$$8);
					zephir_check_call_status();
					zephir_get_strval(&text, &_23$$8);
				ZEPHIR_CALL_METHOD(NULL, &matches, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&match);
	}
	RETURN_CTOR(&text);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_EndsWith)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, EndsWith, phalcon, support_helper_str_endswith, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_endswith_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_EndsWith, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool ignoreCase;
	zval *haystack_param = NULL, *needle_param = NULL, *ignoreCase_param = NULL, _0;
	zval haystack, needle;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&haystack);
	ZVAL_UNDEF(&needle);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_STR(haystack)
		Z_PARAM_STR(needle)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(ignoreCase)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &haystack_param, &needle_param, &ignoreCase_param);
	zephir_get_strval(&haystack, haystack_param);
	zephir_get_strval(&needle, needle_param);
	if (!ignoreCase_param) {
		ignoreCase = 1;
	} else {
		}
	if (ignoreCase) {
		ZVAL_BOOL(&_0, 1);
	} else {
		ZVAL_BOOL(&_0, 0);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "toendswith", NULL, 0, &haystack, &needle, &_0);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_FirstBetween)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, FirstBetween, phalcon, support_helper_str_firstbetween, phalcon_support_helper_str_firstbetween_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_FirstBetween, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *start_param = NULL, *end_param = NULL, __$true, result, _0, _1;
	zval text, start, end, _2;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&start);
	ZVAL_UNDEF(&end);
	ZVAL_UNDEF(&_2);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_STR(text)
		Z_PARAM_STR(start)
		Z_PARAM_STR(end)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &text_param, &start_param, &end_param);
	zephir_get_strval(&text, text_param);
	zephir_get_strval(&start, start_param);
	zephir_get_strval(&end, end_param);
	ZEPHIR_CALL_FUNCTION(&result, "mb_strstr", NULL, 0, &text, &start);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_0);
	if (ZEPHIR_IS_FALSE_IDENTICAL(&result)) {
		ZEPHIR_INIT_NVAR(&_0);
		ZVAL_STRING(&_0, "");
	} else {
		ZEPHIR_CPY_WRT(&_0, &result);
	}
	ZEPHIR_CPY_WRT(&result, &_0);
	ZEPHIR_CALL_FUNCTION(&_1, "mb_strstr", NULL, 0, &result, &end, &__$true);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&result, &_1);
	ZEPHIR_INIT_NVAR(&_0);
	if (ZEPHIR_IS_FALSE_IDENTICAL(&result)) {
		ZEPHIR_INIT_NVAR(&_0);
		ZVAL_STRING(&_0, "");
	} else {
		ZEPHIR_CPY_WRT(&_0, &result);
	}
	ZEPHIR_CPY_WRT(&result, &_0);
	ZEPHIR_INIT_VAR(&_2);
	ZEPHIR_CONCAT_VV(&_2, &start, &end);
	zephir_fast_trim(return_value, &result, &_2, ZEPHIR_TRIM_BOTH);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Friendly)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Friendly, phalcon, support_helper_str_friendly, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_friendly_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Friendly, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool lowercase;
	zval *text_param = NULL, *separator_param = NULL, *lowercase_param = NULL, *replace = NULL, replace_sub, __$null, friendly, matrix, _1, _2, _3, _4, _5, _7, _0$$3, _6$$5;
	zval text, separator;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&separator);
	ZVAL_UNDEF(&replace_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&friendly);
	ZVAL_UNDEF(&matrix);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_7);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_6$$5);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(separator)
		Z_PARAM_BOOL(lowercase)
		Z_PARAM_ZVAL_OR_NULL(replace)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &text_param, &separator_param, &lowercase_param, &replace);
	if (UNEXPECTED(Z_TYPE_P(text_param) != IS_STRING && Z_TYPE_P(text_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'text' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(text_param) == IS_STRING)) {
		zephir_get_strval(&text, text_param);
	} else {
		ZEPHIR_INIT_VAR(&text);
	}
	if (!separator_param) {
		ZEPHIR_INIT_VAR(&separator);
		ZVAL_STRING(&separator, "-");
	} else {
	if (UNEXPECTED(Z_TYPE_P(separator_param) != IS_STRING && Z_TYPE_P(separator_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'separator' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(separator_param) == IS_STRING)) {
		zephir_get_strval(&separator, separator_param);
	} else {
		ZEPHIR_INIT_VAR(&separator);
	}
	}
	if (!lowercase_param) {
		lowercase = 1;
	} else {
		}
	if (!replace) {
		replace = &replace_sub;
		ZEPHIR_CPY_WRT(replace, &__$null);
	} else {
		ZEPHIR_SEPARATE_PARAM(replace);
	}
	if (zephir_is_true(replace)) {
		ZEPHIR_CALL_METHOD(&_0$$3, this_ptr, "checkreplace", NULL, 0, replace);
		zephir_check_call_status();
		ZEPHIR_CPY_WRT(replace, &_0$$3);
	} else {
		ZEPHIR_INIT_NVAR(replace);
		array_init(replace);
	}
	ZEPHIR_CALL_METHOD(&matrix, this_ptr, "getmatrix", NULL, 0, replace);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_1);
	ZEPHIR_INIT_VAR(&_2);
	zephir_array_keys(&_2, &matrix);
	ZEPHIR_CALL_FUNCTION(&_3, "array_values", NULL, 14, &matrix);
	zephir_check_call_status();
	zephir_fast_str_replace(&_1, &_2, &_3, &text);
	zephir_get_strval(&text, &_1);
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_STRING(&_4, "/[^a-zA-Z0-9\\/_|+ -]/");
	ZEPHIR_INIT_VAR(&_5);
	ZVAL_STRING(&_5, "");
	ZEPHIR_CALL_FUNCTION(&friendly, "preg_replace", NULL, 41, &_4, &_5, &text);
	zephir_check_call_status();
	if (lowercase) {
		ZEPHIR_INIT_VAR(&_6$$5);
		zephir_fast_strtolower(&_6$$5, &friendly);
		ZEPHIR_CPY_WRT(&friendly, &_6$$5);
	}
	ZEPHIR_INIT_NVAR(&_4);
	ZVAL_STRING(&_4, "/[\\/_|+ -]+/");
	ZEPHIR_CALL_FUNCTION(&_7, "preg_replace", NULL, 41, &_4, &separator, &friendly);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&friendly, &_7);
	zephir_fast_trim(return_value, &friendly, &separator, ZEPHIR_TRIM_BOTH);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Friendly, checkReplace)
{
	zend_bool _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *replace = NULL, replace_sub, _1$$4;

	ZVAL_UNDEF(&replace_sub);
	ZVAL_UNDEF(&_1$$4);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(replace)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &replace);
	ZEPHIR_SEPARATE_PARAM(replace);
	_0 = Z_TYPE_P(replace) != IS_ARRAY;
	if (_0) {
		_0 = Z_TYPE_P(replace) != IS_STRING;
	}
	if (_0) {
		ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_support_helper_exception_ce, "Parameter replace must be an array or a string", "phalcon/Support/Helper/Str/Friendly.zep", 74);
		return;
	}
	if (Z_TYPE_P(replace) == IS_STRING) {
		ZEPHIR_INIT_VAR(&_1$$4);
		zephir_create_array(&_1$$4, 1, 0);
		zephir_array_fast_append(&_1$$4, replace);
		ZEPHIR_CPY_WRT(replace, &_1$$4);
	}
	RETVAL_ZVAL(replace, 1, 0);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Friendly, getMatrix)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *replace_param = NULL, item, *_0, _1, _2$$3, _3$$4;
	zval replace, matrix;

	ZVAL_UNDEF(&replace);
	ZVAL_UNDEF(&matrix);
	ZVAL_UNDEF(&item);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$4);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(replace)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &replace_param);
	zephir_get_arrval(&replace, replace_param);
	ZEPHIR_INIT_VAR(&matrix);
	zephir_create_array(&matrix, 79, 0);
	add_assoc_stringl_ex(&matrix, SL("Š"), SL("S"));
	add_assoc_stringl_ex(&matrix, SL("š"), SL("s"));
	add_assoc_stringl_ex(&matrix, SL("Đ"), SL("Dj"));
	add_assoc_stringl_ex(&matrix, SL("Ð"), SL("Dj"));
	add_assoc_stringl_ex(&matrix, SL("đ"), SL("dj"));
	add_assoc_stringl_ex(&matrix, SL("Ž"), SL("Z"));
	add_assoc_stringl_ex(&matrix, SL("ž"), SL("z"));
	add_assoc_stringl_ex(&matrix, SL("Č"), SL("C"));
	add_assoc_stringl_ex(&matrix, SL("č"), SL("c"));
	add_assoc_stringl_ex(&matrix, SL("Ć"), SL("C"));
	add_assoc_stringl_ex(&matrix, SL("ć"), SL("c"));
	add_assoc_stringl_ex(&matrix, SL("À"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Á"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Â"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Ã"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Ä"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Å"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Æ"), SL("A"));
	add_assoc_stringl_ex(&matrix, SL("Ç"), SL("C"));
	add_assoc_stringl_ex(&matrix, SL("È"), SL("E"));
	add_assoc_stringl_ex(&matrix, SL("É"), SL("E"));
	add_assoc_stringl_ex(&matrix, SL("Ê"), SL("E"));
	add_assoc_stringl_ex(&matrix, SL("Ë"), SL("E"));
	add_assoc_stringl_ex(&matrix, SL("Ì"), SL("I"));
	add_assoc_stringl_ex(&matrix, SL("Í"), SL("I"));
	add_assoc_stringl_ex(&matrix, SL("Î"), SL("I"));
	add_assoc_stringl_ex(&matrix, SL("Ï"), SL("I"));
	add_assoc_stringl_ex(&matrix, SL("Ñ"), SL("N"));
	add_assoc_stringl_ex(&matrix, SL("Ò"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Ó"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Ô"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Õ"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Ö"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Ø"), SL("O"));
	add_assoc_stringl_ex(&matrix, SL("Ù"), SL("U"));
	add_assoc_stringl_ex(&matrix, SL("Ú"), SL("U"));
	add_assoc_stringl_ex(&matrix, SL("Û"), SL("U"));
	add_assoc_stringl_ex(&matrix, SL("Ü"), SL("U"));
	add_assoc_stringl_ex(&matrix, SL("Ý"), SL("Y"));
	add_assoc_stringl_ex(&matrix, SL("Þ"), SL("B"));
	add_assoc_stringl_ex(&matrix, SL("ß"), SL("Ss"));
	add_assoc_stringl_ex(&matrix, SL("à"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("á"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("â"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("ã"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("ä"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("å"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("æ"), SL("a"));
	add_assoc_stringl_ex(&matrix, SL("ç"), SL("c"));
	add_assoc_stringl_ex(&matrix, SL("è"), SL("e"));
	add_assoc_stringl_ex(&matrix, SL("é"), SL("e"));
	add_assoc_stringl_ex(&matrix, SL("ê"), SL("e"));
	add_assoc_stringl_ex(&matrix, SL("ë"), SL("e"));
	add_assoc_stringl_ex(&matrix, SL("ì"), SL("i"));
	add_assoc_stringl_ex(&matrix, SL("í"), SL("i"));
	add_assoc_stringl_ex(&matrix, SL("î"), SL("i"));
	add_assoc_stringl_ex(&matrix, SL("ï"), SL("i"));
	add_assoc_stringl_ex(&matrix, SL("ð"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ñ"), SL("n"));
	add_assoc_stringl_ex(&matrix, SL("ò"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ó"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ô"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("õ"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ö"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ø"), SL("o"));
	add_assoc_stringl_ex(&matrix, SL("ù"), SL("u"));
	add_assoc_stringl_ex(&matrix, SL("ú"), SL("u"));
	add_assoc_stringl_ex(&matrix, SL("û"), SL("u"));
	add_assoc_stringl_ex(&matrix, SL("ý"), SL("y"));
	add_assoc_stringl_ex(&matrix, SL("þ"), SL("b"));
	add_assoc_stringl_ex(&matrix, SL("ÿ"), SL("y"));
	add_assoc_stringl_ex(&matrix, SL("Ŕ"), SL("R"));
	add_assoc_stringl_ex(&matrix, SL("ŕ"), SL("r"));
	add_assoc_stringl_ex(&matrix, SL("ē"), SL("e"));
	add_assoc_stringl_ex(&matrix, SL("'"), SL(""));
	add_assoc_stringl_ex(&matrix, SL("&"), SL(" and "));
	add_assoc_stringl_ex(&matrix, SL("\r\n"), SL(" "));
	add_assoc_stringl_ex(&matrix, SL("\n"), SL(" "));
	zephir_is_iterable(&replace, 0, "phalcon/Support/Helper/Str/Friendly.zep", 122);
	if (Z_TYPE_P(&replace) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&replace), _0)
		{
			ZEPHIR_INIT_NVAR(&item);
			ZVAL_COPY(&item, _0);
			ZEPHIR_INIT_NVAR(&_2$$3);
			ZVAL_STRING(&_2$$3, " ");
			zephir_array_update_zval(&matrix, &item, &_2$$3, PH_COPY | PH_SEPARATE);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &replace, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &replace, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&item, &replace, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_3$$4);
				ZVAL_STRING(&_3$$4, " ");
				zephir_array_update_zval(&matrix, &item, &_3$$4, PH_COPY | PH_SEPARATE);
			ZEPHIR_CALL_METHOD(NULL, &replace, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&item);
	RETURN_CTOR(&matrix);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Humanize)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Humanize, phalcon, support_helper_str_humanize, phalcon_support_helper_str_humanize_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Humanize, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, result, _0, _1, _2;
	zval text;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(text)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &text_param);
	zephir_get_strval(&text, text_param);
	ZEPHIR_INIT_VAR(&_0);
	zephir_fast_trim(&_0, &text, NULL , ZEPHIR_TRIM_BOTH);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "#[_-]+#");
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, " ");
	ZEPHIR_CALL_FUNCTION(&result, "preg_replace", NULL, 41, &_1, &_2, &_0);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_1);
	if (Z_TYPE_P(&result) == IS_NULL) {
		ZEPHIR_INIT_NVAR(&_1);
		ZVAL_STRING(&_1, "");
	} else {
		ZEPHIR_CPY_WRT(&_1, &result);
	}
	RETURN_CCTOR(&_1);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Includes)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Includes, phalcon, support_helper_str_includes, phalcon_support_helper_str_includes_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Includes, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *haystack_param = NULL, *needle_param = NULL, _0;
	zval haystack, needle;

	ZVAL_UNDEF(&haystack);
	ZVAL_UNDEF(&needle);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(haystack)
		Z_PARAM_STR(needle)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &haystack_param, &needle_param);
	zephir_get_strval(&haystack, haystack_param);
	zephir_get_strval(&needle, needle_param);
	ZEPHIR_CALL_FUNCTION(&_0, "mb_strpos", NULL, 86, &haystack, &needle);
	zephir_check_call_status();
	RETURN_MM_BOOL(!ZEPHIR_IS_FALSE_IDENTICAL(&_0));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Increment)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Increment, phalcon, support_helper_str_increment, phalcon_support_helper_str_increment_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Increment, __invoke)
{
	zend_long number = 0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *text_param = NULL, *separator_param = NULL, parts, _1, _2, _0$$3;
	zval text, separator;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&separator);
	ZVAL_UNDEF(&parts);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_0$$3);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(separator)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &separator_param);
	zephir_get_strval(&text, text_param);
	if (!separator_param) {
		ZEPHIR_INIT_VAR(&separator);
		ZVAL_STRING(&separator, "_");
	} else {
		zephir_get_strval(&separator, separator_param);
	}
	ZEPHIR_INIT_VAR(&parts);
	zephir_fast_explode(&parts, &separator, &text, LONG_MAX);
	number = 1;
	if (1 == zephir_array_isset_long(&parts, 1)) {
		zephir_memory_observe(&_0$$3);
		zephir_array_fetch_long(&_0$$3, &parts, 1, PH_NOISY, "phalcon/Support/Helper/Str/Increment.zep", 35);
		number = (zephir_get_intval(&_0$$3) + 1);
	}
	zephir_array_fetch_long(&_1, &parts, 0, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Increment.zep", 38);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_LONG(&_2, number);
	ZEPHIR_CONCAT_VVV(return_value, &_1, &separator, &_2);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Interpolate)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Interpolate, phalcon, support_helper_str_interpolate, phalcon_support_helper_str_interpolate_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Interpolate, __invoke)
{
	zend_string *_3$$3;
	zend_ulong _2$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval context, replace;
	zval *message_param = NULL, *context_param = NULL, *leftToken_param = NULL, *rightToken_param = NULL, key, value, *_0$$3, _1$$3, _4$$4, _5$$5;
	zval message, leftToken, rightToken;

	ZVAL_UNDEF(&message);
	ZVAL_UNDEF(&leftToken);
	ZVAL_UNDEF(&rightToken);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_4$$4);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&context);
	ZVAL_UNDEF(&replace);
	ZEND_PARSE_PARAMETERS_START(1, 4)
		Z_PARAM_STR(message)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(context)
		Z_PARAM_STR(leftToken)
		Z_PARAM_STR(rightToken)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 3, &message_param, &context_param, &leftToken_param, &rightToken_param);
	zephir_get_strval(&message, message_param);
	if (!context_param) {
		ZEPHIR_INIT_VAR(&context);
		array_init(&context);
	} else {
		zephir_get_arrval(&context, context_param);
	}
	if (!leftToken_param) {
		ZEPHIR_INIT_VAR(&leftToken);
		ZVAL_STRING(&leftToken, "%");
	} else {
		zephir_get_strval(&leftToken, leftToken_param);
	}
	if (!rightToken_param) {
		ZEPHIR_INIT_VAR(&rightToken);
		ZVAL_STRING(&rightToken, "%");
	} else {
		zephir_get_strval(&rightToken, rightToken_param);
	}
	if (!(ZEPHIR_IS_EMPTY(&context))) {
		ZEPHIR_INIT_VAR(&replace);
		array_init(&replace);
		zephir_is_iterable(&context, 0, "phalcon/Support/Helper/Str/Interpolate.zep", 41);
		if (Z_TYPE_P(&context) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&context), _2$$3, _3$$3, _0$$3)
			{
				ZEPHIR_INIT_NVAR(&key);
				if (_3$$3 != NULL) { 
					ZVAL_STR_COPY(&key, _3$$3);
				} else {
					ZVAL_LONG(&key, _2$$3);
				}
				ZEPHIR_INIT_NVAR(&value);
				ZVAL_COPY(&value, _0$$3);
				ZEPHIR_INIT_NVAR(&_4$$4);
				ZEPHIR_CONCAT_VVV(&_4$$4, &leftToken, &key, &rightToken);
				zephir_array_update_zval(&replace, &_4$$4, &value, PH_COPY | PH_SEPARATE);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &context, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_1$$3, &context, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_1$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&key, &context, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&value, &context, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_5$$5);
					ZEPHIR_CONCAT_VVV(&_5$$5, &leftToken, &key, &rightToken);
					zephir_array_update_zval(&replace, &_5$$5, &value, PH_COPY | PH_SEPARATE);
				ZEPHIR_CALL_METHOD(NULL, &context, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&value);
		ZEPHIR_INIT_NVAR(&key);
		ZEPHIR_RETURN_CALL_FUNCTION("strtr", NULL, 5, &message, &replace);
		zephir_check_call_status();
		RETURN_MM();
	}
	RETURN_CTOR(&message);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_IsAnagram)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, IsAnagram, phalcon, support_helper_str_isanagram, phalcon_support_helper_str_isanagram_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_IsAnagram, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *first_param = NULL, *second_param = NULL, _0, _1, _2;
	zval first, second;

	ZVAL_UNDEF(&first);
	ZVAL_UNDEF(&second);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(first)
		Z_PARAM_STR(second)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &first_param, &second_param);
	zephir_get_strval(&first, first_param);
	zephir_get_strval(&second, second_param);
	ZVAL_LONG(&_0, 1);
	ZEPHIR_CALL_FUNCTION(&_1, "count_chars", NULL, 0, &first, &_0);
	zephir_check_call_status();
	ZVAL_LONG(&_0, 1);
	ZEPHIR_CALL_FUNCTION(&_2, "count_chars", NULL, 0, &second, &_0);
	zephir_check_call_status();
	RETURN_MM_BOOL(ZEPHIR_IS_IDENTICAL(&_1, &_2));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_IsLower)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, IsLower, phalcon, support_helper_str_islower, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_islower_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_IsLower, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL, _0;
	zval text, encoding;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "tolower", NULL, 0, &text, &encoding);
	zephir_check_call_status();
	RETURN_MM_BOOL(ZEPHIR_IS_IDENTICAL(&text, &_0));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_IsPalindrome)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, IsPalindrome, phalcon, support_helper_str_ispalindrome, phalcon_support_helper_str_ispalindrome_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_IsPalindrome, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, _0;
	zval text;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(text)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &text_param);
	zephir_get_strval(&text, text_param);
	ZEPHIR_CALL_FUNCTION(&_0, "strrev", NULL, 0, &text);
	zephir_check_call_status();
	RETURN_MM_BOOL(ZEPHIR_IS_IDENTICAL(&_0, &text));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_IsUpper)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, IsUpper, phalcon, support_helper_str_isupper, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_isupper_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_IsUpper, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL, _0;
	zval text, encoding;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "toupper", NULL, 0, &text, &encoding);
	zephir_check_call_status();
	RETURN_MM_BOOL(ZEPHIR_IS_IDENTICAL(&text, &_0));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_KebabCase)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, KebabCase, phalcon, support_helper_str_kebabcase, phalcon_support_helper_str_pascalcase_ce, phalcon_support_helper_str_kebabcase_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_KebabCase, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *delimiters_param = NULL, output;
	zval text, delimiters;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiters);
	ZVAL_UNDEF(&output);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(delimiters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &delimiters_param);
	zephir_get_strval(&text, text_param);
	if (!delimiters_param) {
		ZEPHIR_INIT_VAR(&delimiters);
	} else {
		zephir_get_strval(&delimiters, delimiters_param);
	}
	ZEPHIR_CALL_METHOD(&output, this_ptr, "processarray", NULL, 0, &text, &delimiters);
	zephir_check_call_status();
	zephir_fast_join_str(return_value, SL("-"), &output);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Len)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Len, phalcon, support_helper_str_len, phalcon_support_helper_str_len_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Len, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL;
	zval text, encoding;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZEPHIR_RETURN_CALL_FUNCTION("mb_strlen", NULL, 234, &text, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Lower)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Lower, phalcon, support_helper_str_lower, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_lower_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Lower, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL;
	zval text, encoding;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "tolower", NULL, 0, &text, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_PascalCase)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, PascalCase, phalcon, support_helper_str_pascalcase, phalcon_support_helper_str_pascalcase_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_PascalCase, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *delimiters_param = NULL, exploded, output, element, *_0, _1, _2$$3, _3$$3, _5$$3, _6$$4, _7$$4, _8$$4;
	zval text, delimiters;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiters);
	ZVAL_UNDEF(&exploded);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_5$$3);
	ZVAL_UNDEF(&_6$$4);
	ZVAL_UNDEF(&_7$$4);
	ZVAL_UNDEF(&_8$$4);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(delimiters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &delimiters_param);
	zephir_get_strval(&text, text_param);
	if (!delimiters_param) {
		ZEPHIR_INIT_VAR(&delimiters);
	} else {
		zephir_get_strval(&delimiters, delimiters_param);
	}
	ZEPHIR_CALL_METHOD(&exploded, this_ptr, "processarray", NULL, 0, &text, &delimiters);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&output);
	ZVAL_STRING(&output, "");
	zephir_is_iterable(&exploded, 0, "phalcon/Support/Helper/Str/PascalCase.zep", 37);
	if (Z_TYPE_P(&exploded) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&exploded), _0)
		{
			ZEPHIR_INIT_NVAR(&element);
			ZVAL_COPY(&element, _0);
			ZEPHIR_INIT_NVAR(&_2$$3);
			ZEPHIR_CALL_FUNCTION(&_3$$3, "mb_strtolower", &_4, 10, &element);
			zephir_check_call_status();
			zephir_ucfirst(&_2$$3, &_3$$3);
			ZEPHIR_INIT_NVAR(&_5$$3);
			ZEPHIR_CONCAT_VV(&_5$$3, &output, &_2$$3);
			ZEPHIR_CPY_WRT(&output, &_5$$3);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &exploded, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &exploded, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&element, &exploded, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_6$$4);
				ZEPHIR_CALL_FUNCTION(&_7$$4, "mb_strtolower", &_4, 10, &element);
				zephir_check_call_status();
				zephir_ucfirst(&_6$$4, &_7$$4);
				ZEPHIR_INIT_NVAR(&_8$$4);
				ZEPHIR_CONCAT_VV(&_8$$4, &output, &_6$$4);
				ZEPHIR_CPY_WRT(&output, &_8$$4);
			ZEPHIR_CALL_METHOD(NULL, &exploded, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&element);
	RETURN_CCTOR(&output);
}

static PHP_METHOD(Phalcon_Support_Helper_Str_PascalCase, processArray)
{
	zval _6$$4, _8$$4;
	zend_bool _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *delimiters_param = NULL, result, _0, _1, _3, _4, _11, _12, _13, _5$$4, _7$$4;
	zval text, delimiters, _10, _9$$4;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiters);
	ZVAL_UNDEF(&_10);
	ZVAL_UNDEF(&_9$$4);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_11);
	ZVAL_UNDEF(&_12);
	ZVAL_UNDEF(&_13);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&_7$$4);
	ZVAL_UNDEF(&_6$$4);
	ZVAL_UNDEF(&_8$$4);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(delimiters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &delimiters_param);
	zephir_get_strval(&text, text_param);
	if (!delimiters_param) {
		ZEPHIR_INIT_VAR(&delimiters);
	} else {
		zephir_get_strval(&delimiters, delimiters_param);
	}
	if (ZEPHIR_IS_NULL(&delimiters)) {
		ZEPHIR_INIT_NVAR(&delimiters);
		ZVAL_STRING(&delimiters, "-_");
	}
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "\\-");
	ZEPHIR_INIT_VAR(&_1);
	zephir_fast_strpos(&_1, &delimiters, &_0, 0 );
	_2 = !ZEPHIR_IS_FALSE_IDENTICAL(&_1);
	if (!(_2)) {
		ZEPHIR_INIT_VAR(&_3);
		ZVAL_STRING(&_3, "-");
		ZEPHIR_INIT_VAR(&_4);
		zephir_fast_strpos(&_4, &delimiters, &_3, 0 );
		_2 = !ZEPHIR_IS_FALSE_IDENTICAL(&_4);
	}
	if (_2) {
		ZEPHIR_INIT_VAR(&_5$$4);
		ZEPHIR_INIT_VAR(&_6$$4);
		zephir_create_array(&_6$$4, 2, 0);
		ZEPHIR_INIT_VAR(&_7$$4);
		ZVAL_STRING(&_7$$4, "\\-");
		zephir_array_fast_append(&_6$$4, &_7$$4);
		ZEPHIR_INIT_NVAR(&_7$$4);
		ZVAL_STRING(&_7$$4, "-");
		zephir_array_fast_append(&_6$$4, &_7$$4);
		ZEPHIR_INIT_VAR(&_8$$4);
		zephir_create_array(&_8$$4, 2, 0);
		ZEPHIR_INIT_NVAR(&_7$$4);
		ZVAL_STRING(&_7$$4, "");
		zephir_array_fast_append(&_8$$4, &_7$$4);
		ZEPHIR_INIT_NVAR(&_7$$4);
		ZVAL_STRING(&_7$$4, "");
		zephir_array_fast_append(&_8$$4, &_7$$4);
		zephir_fast_str_replace(&_5$$4, &_6$$4, &_8$$4, &delimiters);
		zephir_get_strval(&delimiters, &_5$$4);
		ZEPHIR_INIT_VAR(&_9$$4);
		ZEPHIR_CONCAT_SV(&_9$$4, "-", &delimiters);
		ZEPHIR_CPY_WRT(&delimiters, &_9$$4);
	}
	ZEPHIR_INIT_VAR(&_10);
	ZEPHIR_CONCAT_SVS(&_10, "/[", &delimiters, "]+/");
	ZVAL_LONG(&_11, -1);
	ZVAL_LONG(&_12, (2 | 1));
	ZEPHIR_CALL_FUNCTION(&result, "preg_split", NULL, 70, &_10, &text, &_11, &_12);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_13);
	if (ZEPHIR_IS_FALSE_IDENTICAL(&result)) {
		ZEPHIR_INIT_NVAR(&_13);
		array_init(&_13);
	} else {
		ZEPHIR_CPY_WRT(&_13, &result);
	}
	RETURN_CCTOR(&_13);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Prefix)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Prefix, phalcon, support_helper_str_prefix, phalcon_support_helper_str_prefix_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Prefix, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval prefix, _0;
	zval *text, text_sub, *prefix_param = NULL;

	ZVAL_UNDEF(&text_sub);
	ZVAL_UNDEF(&prefix);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ZVAL(text)
		Z_PARAM_STR(prefix)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &text, &prefix_param);
	zephir_get_strval(&prefix, prefix_param);
	zephir_cast_to_string(&_0, text);
	ZEPHIR_CONCAT_VV(return_value, &prefix, &_0);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Random)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Random, phalcon, support_helper_str_random, phalcon_support_helper_str_random_method_entry, 0);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_ALNUM"), 0);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_ALPHA"), 1);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_DISTINCT"), 5);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_HEXDEC"), 2);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_NOZERO"), 4);

	zephir_declare_class_constant_long(phalcon_support_helper_str_random_ce, SL("RANDOM_NUMERIC"), 3);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Random, __invoke)
{
	zend_bool _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_20 = NULL;
	zval *type_param = NULL, *length_param = NULL, end, pools, text, _0, _2, _3, _4, _5, _6, _7, _8, _9, _10, _11, _12, _13, _14, _15, _16$$3, _17$$3, _18$$3, _19$$3;
	zend_long type, length, ZEPHIR_LAST_CALL_STATUS;

	ZVAL_UNDEF(&end);
	ZVAL_UNDEF(&pools);
	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_7);
	ZVAL_UNDEF(&_8);
	ZVAL_UNDEF(&_9);
	ZVAL_UNDEF(&_10);
	ZVAL_UNDEF(&_11);
	ZVAL_UNDEF(&_12);
	ZVAL_UNDEF(&_13);
	ZVAL_UNDEF(&_14);
	ZVAL_UNDEF(&_15);
	ZVAL_UNDEF(&_16$$3);
	ZVAL_UNDEF(&_17$$3);
	ZVAL_UNDEF(&_18$$3);
	ZVAL_UNDEF(&_19$$3);
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(type)
		Z_PARAM_LONG(length)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &type_param, &length_param);
	if (!type_param) {
		type = 0;
	} else {
		}
	if (!length_param) {
		length = 8;
	} else {
		}
	ZEPHIR_INIT_VAR(&text);
	ZVAL_STRING(&text, "");
	ZEPHIR_INIT_VAR(&_0);
	_1 = type < 0;
	if (!(_1)) {
		_1 = type > 5;
	}
	if (_1) {
		ZEPHIR_INIT_NVAR(&_0);
		ZVAL_LONG(&_0, 0);
	} else {
		ZEPHIR_INIT_NVAR(&_0);
		ZVAL_LONG(&_0, type);
	}
	type = zephir_get_numberval(&_0);
	ZEPHIR_INIT_VAR(&pools);
	zephir_create_array(&pools, 6, 0);
	ZEPHIR_INIT_VAR(&_2);
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "a");
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_STRING(&_4, "z");
	ZEPHIR_CALL_FUNCTION(&_5, "range", NULL, 314, &_3, &_4);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_3);
	ZVAL_STRING(&_3, "A");
	ZEPHIR_INIT_NVAR(&_4);
	ZVAL_STRING(&_4, "Z");
	ZEPHIR_CALL_FUNCTION(&_6, "range", NULL, 314, &_3, &_4);
	zephir_check_call_status();
	zephir_fast_array_merge(&_2, &_5, &_6);
	zephir_array_update_long(&pools, 1, &_2, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	ZEPHIR_INIT_NVAR(&_2);
	ZVAL_LONG(&_7, 0);
	ZVAL_LONG(&_8, 9);
	ZEPHIR_CALL_FUNCTION(&_9, "range", NULL, 314, &_7, &_8);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_3);
	ZVAL_STRING(&_3, "a");
	ZEPHIR_INIT_NVAR(&_4);
	ZVAL_STRING(&_4, "f");
	ZEPHIR_CALL_FUNCTION(&_10, "range", NULL, 314, &_3, &_4);
	zephir_check_call_status();
	zephir_fast_array_merge(&_2, &_9, &_10);
	zephir_array_update_long(&pools, 2, &_2, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	ZVAL_LONG(&_7, 0);
	ZVAL_LONG(&_8, 9);
	ZEPHIR_CALL_FUNCTION(&_11, "range", NULL, 314, &_7, &_8);
	zephir_check_call_status();
	zephir_array_update_long(&pools, 3, &_11, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	ZVAL_LONG(&_7, 1);
	ZVAL_LONG(&_8, 9);
	ZEPHIR_CALL_FUNCTION(&_11, "range", NULL, 314, &_7, &_8);
	zephir_check_call_status();
	zephir_array_update_long(&pools, 4, &_11, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	ZEPHIR_INIT_NVAR(&_2);
	ZVAL_STRING(&_2, "2345679ACDEFHJKLMNPRSTUVWXYZ");
	ZEPHIR_CALL_FUNCTION(&_11, "str_split", NULL, 88, &_2);
	zephir_check_call_status();
	zephir_array_update_long(&pools, 5, &_11, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	ZVAL_LONG(&_7, 0);
	ZVAL_LONG(&_8, 9);
	ZEPHIR_CALL_FUNCTION(&_11, "range", NULL, 314, &_7, &_8);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_2);
	ZVAL_STRING(&_2, "a");
	ZEPHIR_INIT_NVAR(&_3);
	ZVAL_STRING(&_3, "z");
	ZEPHIR_CALL_FUNCTION(&_12, "range", NULL, 314, &_2, &_3);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_2);
	ZVAL_STRING(&_2, "A");
	ZEPHIR_INIT_NVAR(&_3);
	ZVAL_STRING(&_3, "Z");
	ZEPHIR_CALL_FUNCTION(&_13, "range", NULL, 314, &_2, &_3);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&_14, "array_merge", NULL, 330, &_11, &_12, &_13);
	zephir_check_call_status();
	zephir_array_update_long(&pools, 0, &_14, PH_COPY ZEPHIR_DEBUG_PARAMS_DUMMY);
	zephir_array_fetch_long(&_15, &pools, type, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Random.zep", 66);
	ZEPHIR_INIT_VAR(&end);
	ZVAL_LONG(&end, (zephir_fast_count_int(&_15) - 1));
	while (1) {
		if (!(zephir_fast_strlen_ev(&text) < length)) {
			break;
		}
		zephir_array_fetch_long(&_16$$3, &pools, type, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Random.zep", 69);
		ZVAL_LONG(&_18$$3, 0);
		ZEPHIR_CALL_FUNCTION(&_19$$3, "mt_rand", &_20, 0, &_18$$3, &end);
		zephir_check_call_status();
		zephir_array_fetch(&_17$$3, &_16$$3, &_19$$3, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Str/Random.zep", 69);
		zephir_concat_self(&text, &_17$$3);
	}
	RETURN_CCTOR(&text);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_ReduceSlashes)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, ReduceSlashes, phalcon, support_helper_str_reduceslashes, phalcon_support_helper_str_reduceslashes_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_ReduceSlashes, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, result, _0, _1;
	zval text;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(text)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &text_param);
	zephir_get_strval(&text, text_param);
	ZEPHIR_INIT_VAR(&_0);
	ZVAL_STRING(&_0, "#(?<!:)//+#");
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "/");
	ZEPHIR_CALL_FUNCTION(&result, "preg_replace", NULL, 41, &_0, &_1, &text);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_0);
	if (Z_TYPE_P(&result) == IS_NULL) {
		ZEPHIR_INIT_NVAR(&_0);
		ZVAL_STRING(&_0, "");
	} else {
		ZEPHIR_CPY_WRT(&_0, &result);
	}
	RETURN_CCTOR(&_0);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_SnakeCase)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, SnakeCase, phalcon, support_helper_str_snakecase, phalcon_support_helper_str_pascalcase_ce, phalcon_support_helper_str_snakecase_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_SnakeCase, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *delimiters_param = NULL, output;
	zval text, delimiters;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiters);
	ZVAL_UNDEF(&output);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(delimiters)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &delimiters_param);
	zephir_get_strval(&text, text_param);
	if (!delimiters_param) {
		ZEPHIR_INIT_VAR(&delimiters);
	} else {
		zephir_get_strval(&delimiters, delimiters_param);
	}
	ZEPHIR_CALL_METHOD(&output, this_ptr, "processarray", NULL, 0, &text, &delimiters);
	zephir_check_call_status();
	zephir_fast_join_str(return_value, SL("_"), &output);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_StartsWith)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, StartsWith, phalcon, support_helper_str_startswith, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_startswith_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_StartsWith, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool ignoreCase;
	zval *haystack_param = NULL, *needle_param = NULL, *ignoreCase_param = NULL, _0;
	zval haystack, needle;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&haystack);
	ZVAL_UNDEF(&needle);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_STR(haystack)
		Z_PARAM_STR(needle)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(ignoreCase)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &haystack_param, &needle_param, &ignoreCase_param);
	zephir_get_strval(&haystack, haystack_param);
	zephir_get_strval(&needle, needle_param);
	if (!ignoreCase_param) {
		ignoreCase = 1;
	} else {
		}
	if (ignoreCase) {
		ZVAL_BOOL(&_0, 1);
	} else {
		ZVAL_BOOL(&_0, 0);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "tostartswith", NULL, 0, &haystack, &needle, &_0);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Suffix)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Suffix, phalcon, support_helper_str_suffix, phalcon_support_helper_str_suffix_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Suffix, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval suffix, _0;
	zval *text, text_sub, *suffix_param = NULL;

	ZVAL_UNDEF(&text_sub);
	ZVAL_UNDEF(&suffix);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ZVAL(text)
		Z_PARAM_STR(suffix)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &text, &suffix_param);
	zephir_get_strval(&suffix, suffix_param);
	zephir_cast_to_string(&_0, text);
	ZEPHIR_CONCAT_VV(return_value, &_0, &suffix);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Ucwords)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Ucwords, phalcon, support_helper_str_ucwords, phalcon_support_helper_str_ucwords_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Ucwords, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL, _0;
	zval text, encoding;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZVAL_LONG(&_0, 2);
	ZEPHIR_RETURN_CALL_FUNCTION("mb_convert_case", NULL, 12, &text, &_0, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Uncamelize)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Uncamelize, phalcon, support_helper_str_uncamelize, phalcon_support_helper_str_uncamelize_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Uncamelize, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *delimiter_param = NULL, _1, _2, _3;
	zval text, delimiter, _0;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&delimiter);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(delimiter)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &delimiter_param);
	zephir_get_strval(&text, text_param);
	if (!delimiter_param) {
		ZEPHIR_INIT_VAR(&delimiter);
		ZVAL_STRING(&delimiter, "_");
	} else {
		zephir_get_strval(&delimiter, delimiter_param);
	}
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_CONCAT_VS(&_0, &delimiter, "\\0");
	ZEPHIR_CALL_FUNCTION(&_1, "lcfirst", NULL, 76, &text);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "/[A-Z]/");
	ZEPHIR_CALL_FUNCTION(&_3, "preg_replace", NULL, 41, &_2, &_0, &_1);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("mb_strtolower", NULL, 10, &_3);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Underscore)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Str, Underscore, phalcon, support_helper_str_underscore, phalcon_support_helper_str_underscore_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Underscore, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, result, _0, _1, _2;
	zval text;

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&result);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(text)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &text_param);
	zephir_get_strval(&text, text_param);
	ZEPHIR_INIT_VAR(&_0);
	zephir_fast_trim(&_0, &text, NULL , ZEPHIR_TRIM_BOTH);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "#\\s+#");
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "_");
	ZEPHIR_CALL_FUNCTION(&result, "preg_replace", NULL, 41, &_1, &_2, &_0);
	zephir_check_call_status();
	ZEPHIR_INIT_NVAR(&_1);
	if (Z_TYPE_P(&result) == IS_NULL) {
		ZEPHIR_INIT_NVAR(&_1);
		ZVAL_STRING(&_1, "");
	} else {
		ZEPHIR_CPY_WRT(&_1, &result);
	}
	RETURN_CCTOR(&_1);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Str_Upper)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Str, Upper, phalcon, support_helper_str_upper, phalcon_support_helper_str_abstractstr_ce, phalcon_support_helper_str_upper_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Str_Upper, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *text_param = NULL, *encoding_param = NULL;
	zval text, encoding;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&text);
	ZVAL_UNDEF(&encoding);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(text)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR(encoding)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &text_param, &encoding_param);
	zephir_get_strval(&text, text_param);
	if (!encoding_param) {
		ZEPHIR_INIT_VAR(&encoding);
		ZVAL_STRING(&encoding, "UTF-8");
	} else {
		zephir_get_strval(&encoding, encoding_param);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "toupper", NULL, 0, &text, &encoding);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_AbstractArr)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, AbstractArr, phalcon, support_helper_arr_abstractarr, phalcon_support_helper_arr_abstractarr_method_entry, ZEND_ACC_EXPLICIT_ABSTRACT_CLASS);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_AbstractArr, toFilter)
{
	zend_bool _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	_0 = !zephir_is_true(method);
	if (!(_0)) {
		_0 = !(zephir_is_callable(method));
	}
	if (_0) {
		RETURN_CTOR(&collection);
	}
	ZEPHIR_RETURN_CALL_FUNCTION("array_filter", NULL, 17, &collection, method);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Blacklist)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, Blacklist, phalcon, support_helper_arr_blacklist, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_blacklist_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Blacklist, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *blackList_param = NULL, blackListed, _0, _1;
	zval collection, blackList;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&blackList);
	ZVAL_UNDEF(&blackListed);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ARRAY(blackList)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &blackList_param);
	zephir_get_arrval(&collection, collection_param);
	zephir_get_arrval(&blackList, blackList_param);
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_INIT_NVAR(&_0);
	zephir_create_closure_ex(&_0, NULL, phalcon_12__closure_ce, SL("__invoke"));
	ZEPHIR_CALL_METHOD(&blackListed, this_ptr, "tofilter", NULL, 0, &blackList, &_0);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&_1, "array_flip", NULL, 100, &blackListed);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("array_diff_key", NULL, 99, &collection, &_1);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Chunk)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Chunk, phalcon, support_helper_arr_chunk, phalcon_support_helper_arr_chunk_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Chunk, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_bool preserveKeys;
	zend_long size, ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *size_param = NULL, *preserveKeys_param = NULL, _0, _1;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_LONG(size)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(preserveKeys)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &collection_param, &size_param, &preserveKeys_param);
	zephir_get_arrval(&collection, collection_param);
	if (!preserveKeys_param) {
		preserveKeys = 0;
	} else {
		}
	ZVAL_LONG(&_0, size);
	ZVAL_BOOL(&_1, (preserveKeys ? 1 : 0));
	ZEPHIR_RETURN_CALL_FUNCTION("array_chunk", NULL, 0, &collection, &_0, &_1);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Filter)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, Filter, phalcon, support_helper_arr_filter, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_filter_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Filter, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_First)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, First, phalcon, support_helper_arr_first, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_first_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_First, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null, filtered;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&filtered);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	ZEPHIR_CALL_METHOD(&filtered, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	ZEPHIR_MAKE_REF(&filtered);
	ZEPHIR_RETURN_CALL_FUNCTION("reset", NULL, 477, &filtered);
	ZEPHIR_UNREF(&filtered);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_FirstKey)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, FirstKey, phalcon, support_helper_arr_firstkey, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_firstkey_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_FirstKey, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null, filtered;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&filtered);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	ZEPHIR_CALL_METHOD(&filtered, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("array_key_first", NULL, 0, &filtered);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Flatten)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Flatten, phalcon, support_helper_arr_flatten, phalcon_support_helper_arr_flatten_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Flatten, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_3 = NULL, *_5 = NULL, *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool deep;
	zval *collection_param = NULL, *deep_param = NULL, data, item, *_0, _1, _2$$3, _4$$3, _6$$3, _8$$4, _9$$4, _10$$4;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&item);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_4$$3);
	ZVAL_UNDEF(&_6$$3);
	ZVAL_UNDEF(&_8$$4);
	ZVAL_UNDEF(&_9$$4);
	ZVAL_UNDEF(&_10$$4);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_BOOL(deep)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &deep_param);
	zephir_get_arrval(&collection, collection_param);
	if (!deep_param) {
		deep = 0;
	} else {
		}
	ZEPHIR_INIT_VAR(&data);
	array_init(&data);
	zephir_is_iterable(&collection, 0, "phalcon/Support/Helper/Arr/Flatten.zep", 37);
	if (Z_TYPE_P(&collection) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&collection), _0)
		{
			ZEPHIR_INIT_NVAR(&item);
			ZVAL_COPY(&item, _0);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processnotarray", &_3, 0, &data, &item);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&data, &_2$$3);
			if (deep) {
				ZVAL_BOOL(&_4$$3, 1);
			} else {
				ZVAL_BOOL(&_4$$3, 0);
			}
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processarraydeep", &_5, 0, &data, &item, &_4$$3);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&data, &_2$$3);
			if (deep) {
				ZVAL_BOOL(&_6$$3, 1);
			} else {
				ZVAL_BOOL(&_6$$3, 0);
			}
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processarray", &_7, 0, &data, &item, &_6$$3);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&data, &_2$$3);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &collection, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &collection, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&item, &collection, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_8$$4, this_ptr, "processnotarray", &_3, 0, &data, &item);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&data, &_8$$4);
				if (deep) {
					ZVAL_BOOL(&_9$$4, 1);
				} else {
					ZVAL_BOOL(&_9$$4, 0);
				}
				ZEPHIR_CALL_METHOD(&_8$$4, this_ptr, "processarraydeep", &_5, 0, &data, &item, &_9$$4);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&data, &_8$$4);
				if (deep) {
					ZVAL_BOOL(&_10$$4, 1);
				} else {
					ZVAL_BOOL(&_10$$4, 0);
				}
				ZEPHIR_CALL_METHOD(&_8$$4, this_ptr, "processarray", &_7, 0, &data, &item, &_10$$4);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&data, &_8$$4);
			ZEPHIR_CALL_METHOD(NULL, &collection, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&item);
	RETURN_CCTOR(&data);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Flatten, processNotArray)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *data_param = NULL, *item, item_sub;
	zval data;

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&item_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(data)
		Z_PARAM_ZVAL(item)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &data_param, &item);
	zephir_get_arrval(&data, data_param);
	if (Z_TYPE_P(item) != IS_ARRAY) {
		zephir_array_append(&data, item, PH_SEPARATE, "phalcon/Support/Helper/Arr/Flatten.zep", 49);
	}
	RETURN_CTOR(&data);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Flatten, processArray)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool deep, _0;
	zval *data_param = NULL, *item, item_sub, *deep_param = NULL, _1$$3, _2$$3;
	zval data;

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&item_sub);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$3);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(data)
		Z_PARAM_ZVAL(item)
		Z_PARAM_BOOL(deep)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &data_param, &item, &deep_param);
	zephir_get_arrval(&data, data_param);
	_0 = Z_TYPE_P(item) == IS_ARRAY;
	if (_0) {
		_0 = !deep;
	}
	if (_0) {
		ZEPHIR_INIT_VAR(&_1$$3);
		ZEPHIR_CALL_FUNCTION(&_2$$3, "array_values", NULL, 14, item);
		zephir_check_call_status();
		zephir_fast_array_merge(&_1$$3, &data, &_2$$3);
		ZEPHIR_CPY_WRT(&data, &_1$$3);
	}
	RETURN_CTOR(&data);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Flatten, processArrayDeep)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool deep, _0;
	zval *data_param = NULL, *item, item_sub, *deep_param = NULL, _1$$3, _2$$3, _3$$3;
	zval data;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&item_sub);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(data)
		Z_PARAM_ZVAL(item)
		Z_PARAM_BOOL(deep)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &data_param, &item, &deep_param);
	zephir_get_arrval(&data, data_param);
	_0 = Z_TYPE_P(item) == IS_ARRAY;
	if (_0) {
		_0 = deep;
	}
	if (_0) {
		ZEPHIR_INIT_VAR(&_1$$3);
		ZVAL_BOOL(&_3$$3, 1);
		ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "__invoke", NULL, 0, item, &_3$$3);
		zephir_check_call_status();
		zephir_fast_array_merge(&_1$$3, &data, &_2$$3);
		ZEPHIR_CPY_WRT(&data, &_1$$3);
	}
	RETURN_CTOR(&data);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Get)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Get, phalcon, support_helper_arr_get, phalcon_support_helper_arr_get_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Get, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval cast;
	zval *collection_param = NULL, *index, index_sub, *defaultValue = NULL, defaultValue_sub, *cast_param = NULL, __$null, value;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&index_sub);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&cast);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(2, 4)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(index)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
		Z_PARAM_STR_OR_NULL(cast)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 2, &collection_param, &index, &defaultValue, &cast_param);
	zephir_get_arrval(&collection, collection_param);
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	if (!cast_param) {
		ZEPHIR_INIT_VAR(&cast);
	} else {
		zephir_get_strval(&cast, cast_param);
	}
	ZEPHIR_CPY_WRT(&value, defaultValue);
	if (1 == zephir_array_isset(&collection, index)) {
		ZEPHIR_OBS_NVAR(&value);
		zephir_array_fetch(&value, &collection, index, PH_NOISY, "phalcon/Support/Helper/Arr/Get.zep", 38);
	}
	if (!(ZEPHIR_IS_EMPTY(&cast))) {
		ZEPHIR_MAKE_REF(&value);
		ZEPHIR_CALL_FUNCTION(NULL, "settype", NULL, 11, &value, &cast);
		ZEPHIR_UNREF(&value);
		zephir_check_call_status();
	}
	RETURN_CCTOR(&value);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Group)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Group, phalcon, support_helper_arr_group, phalcon_support_helper_arr_group_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Group, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_3 = NULL, *_4 = NULL, *_5 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method, method_sub, element, filtered, *_0, _1, _2$$3, _6$$4;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_6$$4);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	ZEPHIR_INIT_VAR(&filtered);
	array_init(&filtered);
	zephir_is_iterable(&collection, 0, "phalcon/Support/Helper/Arr/Group.zep", 36);
	if (Z_TYPE_P(&collection) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&collection), _0)
		{
			ZEPHIR_INIT_NVAR(&element);
			ZVAL_COPY(&element, _0);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processcallable", &_3, 0, &filtered, method, &element);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&filtered, &_2$$3);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processobject", &_4, 0, &filtered, method, &element);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&filtered, &_2$$3);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "processother", &_5, 0, &filtered, method, &element);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&filtered, &_2$$3);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &collection, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &collection, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&element, &collection, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_6$$4, this_ptr, "processcallable", &_3, 0, &filtered, method, &element);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&filtered, &_6$$4);
				ZEPHIR_CALL_METHOD(&_6$$4, this_ptr, "processobject", &_4, 0, &filtered, method, &element);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&filtered, &_6$$4);
				ZEPHIR_CALL_METHOD(&_6$$4, this_ptr, "processother", &_5, 0, &filtered, method, &element);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&filtered, &_6$$4);
			ZEPHIR_CALL_METHOD(NULL, &collection, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&element);
	RETURN_CCTOR(&filtered);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Group, isCallable)
{
	zend_bool _0, _1;
	zval *method, method_sub;

	ZVAL_UNDEF(&method_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(method)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &method);
	_0 = zephir_is_callable(method);
	if (!(_0)) {
		_1 = Z_TYPE_P(method) == IS_STRING;
		if (_1) {
			_1 = 1 == (zephir_function_exists(method) == SUCCESS);
		}
		_0 = _1;
	}
	RETURN_BOOL(_0);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Group, processCallable)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *filtered_param = NULL, *method, method_sub, *element, element_sub, key, output, _0;
	zval filtered;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(filtered)
		Z_PARAM_ZVAL(method)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &filtered_param, &method, &element);
	zephir_get_arrval(&filtered, filtered_param);
	ZEPHIR_CPY_WRT(&output, &filtered);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "iscallable", NULL, 0, method);
	zephir_check_call_status();
	if (ZEPHIR_IS_TRUE_IDENTICAL(&_0)) {
		ZEPHIR_CALL_FUNCTION(&key, "call_user_func", NULL, 188, method, element);
		zephir_check_call_status();
		zephir_array_update_multi(&output, element, SL("za"), 2, &key);
	}
	RETURN_CCTOR(&output);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Group, processObject)
{
	zend_bool _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *filtered_param = NULL, *method, method_sub, *element, element_sub, output, _0, key$$3;
	zval filtered;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&key$$3);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(filtered)
		Z_PARAM_ZVAL(method)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &filtered_param, &method, &element);
	zephir_get_arrval(&filtered, filtered_param);
	ZEPHIR_CPY_WRT(&output, &filtered);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "iscallable", NULL, 0, method);
	zephir_check_call_status();
	_1 = !ZEPHIR_IS_TRUE_IDENTICAL(&_0);
	if (_1) {
		_1 = Z_TYPE_P(element) == IS_OBJECT;
	}
	if (_1) {
		zephir_memory_observe(&key$$3);
		zephir_read_property_zval(&key$$3, element, method, PH_NOISY_CC);
		zephir_array_update_multi(&output, element, SL("za"), 2, &key$$3);
	}
	RETURN_CCTOR(&output);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Group, processOther)
{
	zend_bool _1, _2;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *filtered_param = NULL, *method, method_sub, *element, element_sub, output, _0, key$$3;
	zval filtered;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&element_sub);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&key$$3);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(filtered)
		Z_PARAM_ZVAL(method)
		Z_PARAM_ZVAL(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &filtered_param, &method, &element);
	zephir_get_arrval(&filtered, filtered_param);
	ZEPHIR_CPY_WRT(&output, &filtered);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "iscallable", NULL, 0, method);
	zephir_check_call_status();
	_1 = !ZEPHIR_IS_TRUE_IDENTICAL(&_0);
	if (_1) {
		_1 = Z_TYPE_P(element) != IS_OBJECT;
	}
	_2 = _1;
	if (_2) {
		_2 = 1 == zephir_array_isset(element, method);
	}
	if (_2) {
		zephir_memory_observe(&key$$3);
		zephir_array_fetch(&key$$3, element, method, PH_NOISY, "phalcon/Support/Helper/Arr/Group.zep", 116);
		zephir_array_update_multi(&output, element, SL("za"), 2, &key$$3);
	}
	RETURN_CCTOR(&output);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Has)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Has, phalcon, support_helper_arr_has, phalcon_support_helper_arr_has_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Has, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *collection_param = NULL, *index, index_sub;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&index_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(index)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &index);
	zephir_get_arrval(&collection, collection_param);
	RETURN_MM_BOOL(zephir_array_key_exists(&collection, index));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_IsUnique)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, IsUnique, phalcon, support_helper_arr_isunique, phalcon_support_helper_arr_isunique_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_IsUnique, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, _0;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(collection)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &collection_param);
	zephir_get_arrval(&collection, collection_param);
	ZEPHIR_CALL_FUNCTION(&_0, "array_unique", NULL, 180, &collection);
	zephir_check_call_status();
	RETURN_MM_BOOL(zephir_fast_count_int(&collection) == zephir_fast_count_int(&_0));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Last)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, Last, phalcon, support_helper_arr_last, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_last_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Last, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null, filtered;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&filtered);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	ZEPHIR_CALL_METHOD(&filtered, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	ZEPHIR_MAKE_REF(&filtered);
	ZEPHIR_RETURN_CALL_FUNCTION("end", NULL, 320, &filtered);
	ZEPHIR_UNREF(&filtered);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_LastKey)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, LastKey, phalcon, support_helper_arr_lastkey, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_lastkey_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_LastKey, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method = NULL, method_sub, __$null, filtered;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&filtered);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	if (!method) {
		method = &method_sub;
		method = &__$null;
	}
	ZEPHIR_CALL_METHOD(&filtered, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("array_key_last", NULL, 40, &filtered);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Order)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Order, phalcon, support_helper_arr_order, phalcon_support_helper_arr_order_method_entry, 0);

	zephir_declare_class_constant_long(phalcon_support_helper_arr_order_ce, SL("ORDER_ASC"), 1);

	zephir_declare_class_constant_long(phalcon_support_helper_arr_order_ce, SL("ORDER_DESC"), 2);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Order, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_3 = NULL, *_4 = NULL;
	zend_long order, flags, ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *attribute, attribute_sub, *order_param = NULL, *flags_param = NULL, item, sorted, *_0, _1, _2$$3, _5$$4, _6$$5, _7$$6;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&attribute_sub);
	ZVAL_UNDEF(&item);
	ZVAL_UNDEF(&sorted);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_7$$6);
	ZEND_PARSE_PARAMETERS_START(2, 4)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(attribute)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(order)
		Z_PARAM_LONG(flags)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 2, &collection_param, &attribute, &order_param, &flags_param);
	zephir_get_arrval(&collection, collection_param);
	if (!order_param) {
		order = 1;
	} else {
		}
	if (!flags_param) {
		flags = 0;
	} else {
		}
	ZEPHIR_INIT_VAR(&sorted);
	array_init(&sorted);
	zephir_is_iterable(&collection, 0, "phalcon/Support/Helper/Arr/Order.zep", 45);
	if (Z_TYPE_P(&collection) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&collection), _0)
		{
			ZEPHIR_INIT_NVAR(&item);
			ZVAL_COPY(&item, _0);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "checkobject", &_3, 0, &sorted, attribute, &item);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&sorted, &_2$$3);
			ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "checknonobject", &_4, 0, &sorted, attribute, &item);
			zephir_check_call_status();
			ZEPHIR_CPY_WRT(&sorted, &_2$$3);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &collection, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &collection, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&item, &collection, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_5$$4, this_ptr, "checkobject", &_3, 0, &sorted, attribute, &item);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&sorted, &_5$$4);
				ZEPHIR_CALL_METHOD(&_5$$4, this_ptr, "checknonobject", &_4, 0, &sorted, attribute, &item);
				zephir_check_call_status();
				ZEPHIR_CPY_WRT(&sorted, &_5$$4);
			ZEPHIR_CALL_METHOD(NULL, &collection, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&item);
	if (1 == order) {
		ZVAL_LONG(&_6$$5, flags);
		ZEPHIR_MAKE_REF(&sorted);
		ZEPHIR_CALL_FUNCTION(NULL, "ksort", NULL, 0, &sorted, &_6$$5);
		ZEPHIR_UNREF(&sorted);
		zephir_check_call_status();
	} else {
		ZVAL_LONG(&_7$$6, flags);
		ZEPHIR_MAKE_REF(&sorted);
		ZEPHIR_CALL_FUNCTION(NULL, "krsort", NULL, 0, &sorted, &_7$$6);
		ZEPHIR_UNREF(&sorted);
		zephir_check_call_status();
	}
	ZEPHIR_RETURN_CALL_FUNCTION("array_values", NULL, 14, &sorted);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Order, checkObject)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *sorted_param = NULL, *attribute, attribute_sub, *item, item_sub, key;
	zval sorted;

	ZVAL_UNDEF(&sorted);
	ZVAL_UNDEF(&attribute_sub);
	ZVAL_UNDEF(&item_sub);
	ZVAL_UNDEF(&key);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(sorted)
		Z_PARAM_ZVAL(attribute)
		Z_PARAM_ZVAL(item)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &sorted_param, &attribute, &item);
	zephir_get_arrval(&sorted, sorted_param);
	if (Z_TYPE_P(item) == IS_OBJECT) {
		zephir_memory_observe(&key);
		zephir_read_property_zval(&key, item, attribute, PH_NOISY_CC);
		zephir_array_update_zval(&sorted, &key, item, PH_COPY | PH_SEPARATE);
	}
	RETURN_CTOR(&sorted);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Order, checkNonObject)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *sorted_param = NULL, *attribute, attribute_sub, *item, item_sub, key;
	zval sorted;

	ZVAL_UNDEF(&sorted);
	ZVAL_UNDEF(&attribute_sub);
	ZVAL_UNDEF(&item_sub);
	ZVAL_UNDEF(&key);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(sorted)
		Z_PARAM_ZVAL(attribute)
		Z_PARAM_ZVAL(item)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &sorted_param, &attribute, &item);
	zephir_get_arrval(&sorted, sorted_param);
	if (Z_TYPE_P(item) != IS_OBJECT) {
		zephir_memory_observe(&key);
		zephir_array_fetch(&key, item, attribute, PH_NOISY, "phalcon/Support/Helper/Arr/Order.zep", 85);
		zephir_array_update_zval(&sorted, &key, item, PH_COPY | PH_SEPARATE);
	}
	RETURN_CTOR(&sorted);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Pluck)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Pluck, phalcon, support_helper_arr_pluck, phalcon_support_helper_arr_pluck_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Pluck, __invoke)
{
	zend_bool _2$$3, _3$$3, _6$$6, _7$$6;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval element;
	zval *collection_param = NULL, *element_param = NULL, item, *_0, _1, _4$$4, _5$$5, _8$$7, _9$$8;
	zval collection, filtered;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&item);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_4$$4);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&_8$$7);
	ZVAL_UNDEF(&_9$$8);
	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &element_param);
	zephir_get_arrval(&collection, collection_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_INIT_VAR(&filtered);
	array_init(&filtered);
	zephir_is_iterable(&collection, 0, "phalcon/Support/Helper/Arr/Pluck.zep", 39);
	if (Z_TYPE_P(&collection) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&collection), _0)
		{
			ZEPHIR_INIT_NVAR(&item);
			ZVAL_COPY(&item, _0);
			_2$$3 = Z_TYPE_P(&item) == IS_OBJECT;
			if (_2$$3) {
				_2$$3 = zephir_isset_property_zval(&item, &element);
			}
			_3$$3 = Z_TYPE_P(&item) == IS_ARRAY;
			if (_3$$3) {
				_3$$3 = zephir_array_isset(&item, &element);
			}
			if (_2$$3) {
				ZEPHIR_OBS_NVAR(&_4$$4);
				zephir_read_property_zval(&_4$$4, &item, &element, PH_NOISY_CC);
				zephir_array_append(&filtered, &_4$$4, PH_SEPARATE, "phalcon/Support/Helper/Arr/Pluck.zep", 33);
			} else if (_3$$3) {
				zephir_array_fetch(&_5$$5, &item, &element, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Arr/Pluck.zep", 35);
				zephir_array_append(&filtered, &_5$$5, PH_SEPARATE, "phalcon/Support/Helper/Arr/Pluck.zep", 35);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &collection, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &collection, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&item, &collection, "current", NULL, 0);
			zephir_check_call_status();
				_6$$6 = Z_TYPE_P(&item) == IS_OBJECT;
				if (_6$$6) {
					_6$$6 = zephir_isset_property_zval(&item, &element);
				}
				_7$$6 = Z_TYPE_P(&item) == IS_ARRAY;
				if (_7$$6) {
					_7$$6 = zephir_array_isset(&item, &element);
				}
				if (_6$$6) {
					ZEPHIR_OBS_NVAR(&_8$$7);
					zephir_read_property_zval(&_8$$7, &item, &element, PH_NOISY_CC);
					zephir_array_append(&filtered, &_8$$7, PH_SEPARATE, "phalcon/Support/Helper/Arr/Pluck.zep", 33);
				} else if (_7$$6) {
					zephir_array_fetch(&_9$$8, &item, &element, PH_NOISY | PH_READONLY, "phalcon/Support/Helper/Arr/Pluck.zep", 35);
					zephir_array_append(&filtered, &_9$$8, PH_SEPARATE, "phalcon/Support/Helper/Arr/Pluck.zep", 35);
				}
			ZEPHIR_CALL_METHOD(NULL, &collection, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&item);
	RETURN_CTOR(&filtered);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Set)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Set, phalcon, support_helper_arr_set, phalcon_support_helper_arr_set_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Set, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *value, value_sub, *index = NULL, index_sub, __$null, source;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&index_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&source);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(value)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(index)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &collection_param, &value, &index);
	zephir_get_arrval(&collection, collection_param);
	if (!index) {
		index = &index_sub;
		index = &__$null;
	}
	ZEPHIR_CALL_METHOD(&source, this_ptr, "checknull", NULL, 0, &collection, value, index);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "checknotnull", NULL, 0, &source, value, index);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Set, checkNull)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *collection_param = NULL, *value, value_sub, *index, index_sub;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&index_sub);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(value)
		Z_PARAM_ZVAL(index)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &collection_param, &value, &index);
	zephir_get_arrval(&collection, collection_param);
	if (Z_TYPE_P(index) == IS_NULL) {
		zephir_array_append(&collection, value, PH_SEPARATE, "phalcon/Support/Helper/Arr/Set.zep", 47);
	}
	RETURN_CTOR(&collection);
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Set, checkNotNull)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *collection_param = NULL, *value, value_sub, *index, index_sub;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&value_sub);
	ZVAL_UNDEF(&index_sub);
	ZEND_PARSE_PARAMETERS_START(3, 3)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(value)
		Z_PARAM_ZVAL(index)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 3, 0, &collection_param, &value, &index);
	zephir_get_arrval(&collection, collection_param);
	if (Z_TYPE_P(index) != IS_NULL) {
		zephir_array_update_zval(&collection, index, value, PH_COPY | PH_SEPARATE);
	}
	RETURN_CTOR(&collection);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_SliceLeft)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, SliceLeft, phalcon, support_helper_arr_sliceleft, phalcon_support_helper_arr_sliceleft_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_SliceLeft, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long elements, ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *elements_param = NULL, _0, _1;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(elements)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &elements_param);
	zephir_get_arrval(&collection, collection_param);
	if (!elements_param) {
		elements = 1;
	} else {
		}
	ZVAL_LONG(&_0, 0);
	ZVAL_LONG(&_1, elements);
	ZEPHIR_RETURN_CALL_FUNCTION("array_slice", NULL, 501, &collection, &_0, &_1);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_SliceRight)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, SliceRight, phalcon, support_helper_arr_sliceright, phalcon_support_helper_arr_sliceright_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_SliceRight, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long elements, ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *elements_param = NULL, _0;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_OPTIONAL
		Z_PARAM_LONG(elements)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &collection_param, &elements_param);
	zephir_get_arrval(&collection, collection_param);
	if (!elements_param) {
		elements = 1;
	} else {
		}
	ZVAL_LONG(&_0, elements);
	ZEPHIR_RETURN_CALL_FUNCTION("array_slice", NULL, 501, &collection, &_0);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Split)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, Split, phalcon, support_helper_arr_split, phalcon_support_helper_arr_split_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Split, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, _0, _1;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(collection)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &collection_param);
	zephir_get_arrval(&collection, collection_param);
	zephir_create_array(return_value, 2, 0);
	ZEPHIR_INIT_VAR(&_0);
	zephir_array_keys(&_0, &collection);
	zephir_array_fast_append(return_value, &_0);
	ZEPHIR_CALL_FUNCTION(&_1, "array_values", NULL, 14, &collection);
	zephir_check_call_status();
	zephir_array_fast_append(return_value, &_1);
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_ToObject)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Helper\\Arr, ToObject, phalcon, support_helper_arr_toobject, phalcon_support_helper_arr_toobject_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_ToObject, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *collection_param = NULL;
	zval collection;

	ZVAL_UNDEF(&collection);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(collection)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &collection_param);
	zephir_get_arrval(&collection, collection_param);
	zephir_convert_to_object(&collection);
	RETURN_CTOR(&collection);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_ValidateAll)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, ValidateAll, phalcon, support_helper_arr_validateall, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_validateall_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_ValidateAll, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method, method_sub, _0;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	RETURN_MM_BOOL(zephir_fast_count_int(&_0) == zephir_fast_count_int(&collection));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_ValidateAny)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, ValidateAny, phalcon, support_helper_arr_validateany, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_validateany_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_ValidateAny, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *method, method_sub, _0;
	zval collection;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&method_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ZVAL(method)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &method);
	zephir_get_arrval(&collection, collection_param);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "tofilter", NULL, 0, &collection, method);
	zephir_check_call_status();
	RETURN_MM_BOOL(zephir_fast_count_int(&_0) > 0);
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Helper_Arr_Whitelist)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Helper\\Arr, Whitelist, phalcon, support_helper_arr_whitelist, phalcon_support_helper_arr_abstractarr_ce, phalcon_support_helper_arr_whitelist_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Helper_Arr_Whitelist, __invoke)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *collection_param = NULL, *whiteList_param = NULL, filtered, _0, _1;
	zval collection, whiteList;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&collection);
	ZVAL_UNDEF(&whiteList);
	ZVAL_UNDEF(&filtered);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_ARRAY(collection)
		Z_PARAM_ARRAY(whiteList)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &collection_param, &whiteList_param);
	zephir_get_arrval(&collection, collection_param);
	zephir_get_arrval(&whiteList, whiteList_param);
	ZEPHIR_INIT_VAR(&_0);
	ZEPHIR_INIT_NVAR(&_0);
	zephir_create_closure_ex(&_0, NULL, phalcon_13__closure_ce, SL("__invoke"));
	ZEPHIR_CALL_METHOD(&filtered, this_ptr, "tofilter", NULL, 0, &whiteList, &_0);
	zephir_check_call_status();
	ZEPHIR_CALL_FUNCTION(&_1, "array_flip", NULL, 100, &filtered);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_FUNCTION("array_intersect_key", NULL, 2, &collection, &_1);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Debug_Dump)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Support\\Debug, Dump, phalcon, support_debug_dump, phalcon_support_debug_dump_method_entry, 0);

	zend_declare_property_bool(phalcon_support_debug_dump_ce, SL("detailed"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_debug_dump_ce, SL("methods"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_debug_dump_ce, SL("styles"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_support_debug_dump_ce, SL("encode"), ZEND_ACC_PRIVATE);
	phalcon_support_debug_dump_ce->create_object = zephir_init_properties_Phalcon_Support_Debug_Dump;

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zend_bool detailed;
	zval *styles_param = NULL, *detailed_param = NULL, __$true, __$false, _0;
	zval styles;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&styles);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(0, 2)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(styles)
		Z_PARAM_BOOL(detailed)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 2, &styles_param, &detailed_param);
	if (!styles_param) {
		ZEPHIR_INIT_VAR(&styles);
		array_init(&styles);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&styles, styles_param);
	}
	if (!detailed_param) {
		detailed = 0;
	} else {
		}
	ZEPHIR_INIT_VAR(&_0);
	object_init_ex(&_0, phalcon_support_helper_json_encode_ce);
	if (zephir_has_constructor(&_0)) {
		ZEPHIR_CALL_METHOD(NULL, &_0, "__construct", NULL, 0);
		zephir_check_call_status();
	}

	zephir_update_property_zval(this_ptr, ZEND_STRL("encode"), &_0);
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "setstyles", NULL, 0, &styles);
	zephir_check_call_status();
	if (detailed) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("detailed"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("detailed"), &__$false);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, all)
{
	zval _1;
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	zephir_array_fast_append(&_0, this_ptr);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "variables");
	zephir_array_fast_append(&_0, &_1);
	ZEPHIR_INIT_NVAR(&_1);
	zephir_get_args(&_1);
	ZEPHIR_CALL_USER_FUNC_ARRAY(return_value, &_0, &_1);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, getDetailed)
{

	RETURN_MEMBER(getThis(), "detailed");
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, setDetailed)
{
	zval *detailed_param = NULL, __$true, __$false;
	zend_bool detailed;
	zval *this_ptr = getThis();

	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_BOOL(detailed)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &detailed_param);
	if (detailed) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("detailed"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("detailed"), &__$false);
	}
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, one)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval name;
	zval *variable, variable_sub, *name_param = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&variable_sub);
	ZVAL_UNDEF(&name);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(variable)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &variable, &name_param);
	if (!name_param) {
		ZEPHIR_INIT_VAR(&name);
	} else {
		zephir_get_strval(&name, name_param);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "variable", NULL, 0, variable, &name);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, setStyles)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *styles_param = NULL, defaultStyles, _0;
	zval styles;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&styles);
	ZVAL_UNDEF(&defaultStyles);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(styles)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &styles_param);
	if (!styles_param) {
		ZEPHIR_INIT_VAR(&styles);
		array_init(&styles);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&styles, styles_param);
	}
	ZEPHIR_INIT_VAR(&defaultStyles);
	zephir_create_array(&defaultStyles, 11, 0);
	add_assoc_stringl_ex(&defaultStyles, SL("pre"), SL("background-color:#f3f3f3; font-size:11px; padding:10px; border:1px solid #ccc; text-align:left; color:#333"));
	add_assoc_stringl_ex(&defaultStyles, SL("arr"), SL("color:red"));
	add_assoc_stringl_ex(&defaultStyles, SL("bool"), SL("color:green"));
	add_assoc_stringl_ex(&defaultStyles, SL("float"), SL("color:fuchsia"));
	add_assoc_stringl_ex(&defaultStyles, SL("int"), SL("color:blue"));
	add_assoc_stringl_ex(&defaultStyles, SL("null"), SL("color:black"));
	add_assoc_stringl_ex(&defaultStyles, SL("num"), SL("color:navy"));
	add_assoc_stringl_ex(&defaultStyles, SL("obj"), SL("color:purple"));
	add_assoc_stringl_ex(&defaultStyles, SL("other"), SL("color:maroon"));
	add_assoc_stringl_ex(&defaultStyles, SL("res"), SL("color:lime"));
	add_assoc_stringl_ex(&defaultStyles, SL("str"), SL("color:teal"));
	ZEPHIR_INIT_VAR(&_0);
	zephir_fast_array_merge(&_0, &defaultStyles, &styles);
	zephir_update_property_zval(this_ptr, ZEND_STRL("styles"), &_0);
	RETURN_MM_MEMBER(getThis(), "styles");
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, toJson)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *variable, variable_sub, _0, _1;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&variable_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(variable)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &variable);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("encode"), PH_NOISY_CC | PH_READONLY);
	ZVAL_LONG(&_1, ((128 | 64) | 256));
	ZEPHIR_RETURN_CALL_METHOD(&_0, "__invoke", NULL, 0, variable, &_1);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, variable)
{
	zval _0;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval name;
	zval *variable, variable_sub, *name_param = NULL, _1, _2;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&variable_sub);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&_0);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_ZVAL(variable)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &variable, &name_param);
	if (!name_param) {
		ZEPHIR_INIT_VAR(&name);
	} else {
		zephir_get_strval(&name, name_param);
	}
	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "pre");
	ZEPHIR_CALL_METHOD(&_1, this_ptr, "getstyle", NULL, 0, &_2);
	zephir_check_call_status();
	zephir_array_update_string(&_0, SL(":style"), &_1, PH_COPY | PH_SEPARATE);
	ZEPHIR_CALL_METHOD(&_1, this_ptr, "output", NULL, 0, variable, &name);
	zephir_check_call_status();
	zephir_array_update_string(&_0, SL(":output"), &_1, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_NVAR(&_2);
	ZVAL_STRING(&_2, "<pre style=\":style\">:output</pre>");
	ZEPHIR_RETURN_CALL_FUNCTION("strtr", NULL, 5, &_2, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, variables)
{
	zend_string *_4;
	zend_ulong _3;
	zval output;
	zval key, value, _0, *_1, _2, _5$$3, _6$$3, _8$$4, _9$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_5$$3);
	ZVAL_UNDEF(&_6$$3);
	ZVAL_UNDEF(&_8$$4);
	ZVAL_UNDEF(&_9$$4);
	ZVAL_UNDEF(&output);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	ZEPHIR_INIT_VAR(&output);
	ZEPHIR_INIT_VAR(&_0);
	zephir_get_args(&_0);
	zephir_is_iterable(&_0, 0, "phalcon/Support/Debug/Dump.zep", 198);
	if (Z_TYPE_P(&_0) == IS_ARRAY) {
		ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_0), _3, _4, _1)
		{
			ZEPHIR_INIT_NVAR(&key);
			if (_4 != NULL) { 
				ZVAL_STR_COPY(&key, _4);
			} else {
				ZVAL_LONG(&key, _3);
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_COPY(&value, _1);
			ZEPHIR_INIT_NVAR(&_6$$3);
			ZEPHIR_CONCAT_SV(&_6$$3, "var ", &key);
			ZEPHIR_CALL_METHOD(&_5$$3, this_ptr, "one", &_7, 0, &value, &_6$$3);
			zephir_check_call_status();
			zephir_concat_self(&output, &_5$$3);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &_0, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &_0, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&key, &_0, "key", NULL, 0);
			zephir_check_call_status();
			ZEPHIR_CALL_METHOD(&value, &_0, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_9$$4);
				ZEPHIR_CONCAT_SV(&_9$$4, "var ", &key);
				ZEPHIR_CALL_METHOD(&_8$$4, this_ptr, "one", &_7, 0, &value, &_9$$4);
				zephir_check_call_status();
				zephir_concat_self(&output, &_8$$4);
			ZEPHIR_CALL_METHOD(NULL, &_0, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&value);
	ZEPHIR_INIT_NVAR(&key);
	RETURN_CTOR(&output);
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, getStyle)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *type_param = NULL, style, _0;
	zval type;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&type);
	ZVAL_UNDEF(&style);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(type)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &type_param);
	if (UNEXPECTED(Z_TYPE_P(type_param) != IS_STRING && Z_TYPE_P(type_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'type' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(type_param) == IS_STRING)) {
		zephir_get_strval(&type, type_param);
	} else {
		ZEPHIR_INIT_VAR(&type);
	}
	zephir_memory_observe(&style);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("styles"), PH_NOISY_CC | PH_READONLY);
	if (!(zephir_array_isset_fetch(&style, &_0, &type, 0))) {
		RETURN_MM_STRING("color:gray");
	}
	RETURN_CCTOR(&style);
}

static PHP_METHOD(Phalcon_Support_Debug_Dump, output)
{
	zend_class_entry *_74$$16, *_91$$17;
	zend_bool _15$$5, _16$$5, _17$$5, _27$$7, _28$$7, _29$$7, _42$$9;
	zend_string *_7$$4, *_50$$12;
	zend_ulong _6$$4, _49$$12;
	zval _166, _1$$4, _11$$5, _23$$7, _34$$9, _105$$9, _38$$10, _53$$13, _61$$14, _79$$16, _95$$17, _116$$21, _122$$22, _129$$24, _135$$25, _144$$26, _148$$27, _151$$28, _154$$29, _159$$30, _163$$31;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_10 = NULL, *_19 = NULL, *_71 = NULL, *_72 = NULL, *_75 = NULL, *_77 = NULL, *_85 = NULL, *_88 = NULL, *_89 = NULL, *_93 = NULL, *_101 = NULL;
	zend_long tab, ZEPHIR_LAST_CALL_STATUS;
	zval name, _0$$3;
	zval *variable, variable_sub, *name_param = NULL, *tab_param = NULL, key, value, output, space, type, attr, _147, _167, _168, _2$$4, _3$$4, *_4$$4, _5$$4, _32$$4, _33$$4, _8$$5, _9$$5, _12$$5, _13$$5, _14$$5, _18$$5, _20$$5, _21$$7, _22$$7, _24$$7, _25$$7, _26$$7, _30$$7, _31$$7, _35$$9, _36$$9, _37$$9, _41$$9, _103$$9, _104$$9, _106$$9, _107$$9, _142$$9, _143$$9, _39$$10, _40$$10, _43$$11, _44$$11, _45$$11, _46$$12, *_47$$12, _48$$12, _51$$13, _52$$13, _54$$13, _55$$13, _56$$13, _57$$13, _58$$13, _59$$14, _60$$14, _62$$14, _63$$14, _64$$14, _65$$14, _66$$14, reflect$$15, props$$15, property$$15, _67$$15, *_68$$15, _69$$15, _70$$16, _73$$16, _76$$16, _78$$16, _80$$16, _81$$16, _82$$16, _83$$16, _84$$16, _86$$16, _87$$17, _90$$17, _92$$17, _94$$17, _96$$17, _97$$17, _98$$17, _99$$17, _100$$17, _102$$17, _108$$18, _109$$18, _110$$18, *_111$$19, _112$$19, _139$$19, _140$$19, _141$$19, _113$$20, _114$$21, _115$$21, _117$$21, _118$$21, _119$$21, _120$$22, _121$$22, _123$$22, _124$$22, _125$$22, _126$$23, _127$$24, _128$$24, _130$$24, _131$$24, _132$$24, _133$$25, _134$$25, _136$$25, _137$$25, _138$$25, _145$$26, _146$$26, _149$$27, _150$$27, _152$$28, _153$$28, _155$$29, _156$$29, _157$$29, _158$$29, _160$$30, _161$$30, _162$$30, _164$$31, _165$$31;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&variable_sub);
	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&output);
	ZVAL_UNDEF(&space);
	ZVAL_UNDEF(&type);
	ZVAL_UNDEF(&attr);
	ZVAL_UNDEF(&_147);
	ZVAL_UNDEF(&_167);
	ZVAL_UNDEF(&_168);
	ZVAL_UNDEF(&_2$$4);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_5$$4);
	ZVAL_UNDEF(&_32$$4);
	ZVAL_UNDEF(&_33$$4);
	ZVAL_UNDEF(&_8$$5);
	ZVAL_UNDEF(&_9$$5);
	ZVAL_UNDEF(&_12$$5);
	ZVAL_UNDEF(&_13$$5);
	ZVAL_UNDEF(&_14$$5);
	ZVAL_UNDEF(&_18$$5);
	ZVAL_UNDEF(&_20$$5);
	ZVAL_UNDEF(&_21$$7);
	ZVAL_UNDEF(&_22$$7);
	ZVAL_UNDEF(&_24$$7);
	ZVAL_UNDEF(&_25$$7);
	ZVAL_UNDEF(&_26$$7);
	ZVAL_UNDEF(&_30$$7);
	ZVAL_UNDEF(&_31$$7);
	ZVAL_UNDEF(&_35$$9);
	ZVAL_UNDEF(&_36$$9);
	ZVAL_UNDEF(&_37$$9);
	ZVAL_UNDEF(&_41$$9);
	ZVAL_UNDEF(&_103$$9);
	ZVAL_UNDEF(&_104$$9);
	ZVAL_UNDEF(&_106$$9);
	ZVAL_UNDEF(&_107$$9);
	ZVAL_UNDEF(&_142$$9);
	ZVAL_UNDEF(&_143$$9);
	ZVAL_UNDEF(&_39$$10);
	ZVAL_UNDEF(&_40$$10);
	ZVAL_UNDEF(&_43$$11);
	ZVAL_UNDEF(&_44$$11);
	ZVAL_UNDEF(&_45$$11);
	ZVAL_UNDEF(&_46$$12);
	ZVAL_UNDEF(&_48$$12);
	ZVAL_UNDEF(&_51$$13);
	ZVAL_UNDEF(&_52$$13);
	ZVAL_UNDEF(&_54$$13);
	ZVAL_UNDEF(&_55$$13);
	ZVAL_UNDEF(&_56$$13);
	ZVAL_UNDEF(&_57$$13);
	ZVAL_UNDEF(&_58$$13);
	ZVAL_UNDEF(&_59$$14);
	ZVAL_UNDEF(&_60$$14);
	ZVAL_UNDEF(&_62$$14);
	ZVAL_UNDEF(&_63$$14);
	ZVAL_UNDEF(&_64$$14);
	ZVAL_UNDEF(&_65$$14);
	ZVAL_UNDEF(&_66$$14);
	ZVAL_UNDEF(&reflect$$15);
	ZVAL_UNDEF(&props$$15);
	ZVAL_UNDEF(&property$$15);
	ZVAL_UNDEF(&_67$$15);
	ZVAL_UNDEF(&_69$$15);
	ZVAL_UNDEF(&_70$$16);
	ZVAL_UNDEF(&_73$$16);
	ZVAL_UNDEF(&_76$$16);
	ZVAL_UNDEF(&_78$$16);
	ZVAL_UNDEF(&_80$$16);
	ZVAL_UNDEF(&_81$$16);
	ZVAL_UNDEF(&_82$$16);
	ZVAL_UNDEF(&_83$$16);
	ZVAL_UNDEF(&_84$$16);
	ZVAL_UNDEF(&_86$$16);
	ZVAL_UNDEF(&_87$$17);
	ZVAL_UNDEF(&_90$$17);
	ZVAL_UNDEF(&_92$$17);
	ZVAL_UNDEF(&_94$$17);
	ZVAL_UNDEF(&_96$$17);
	ZVAL_UNDEF(&_97$$17);
	ZVAL_UNDEF(&_98$$17);
	ZVAL_UNDEF(&_99$$17);
	ZVAL_UNDEF(&_100$$17);
	ZVAL_UNDEF(&_102$$17);
	ZVAL_UNDEF(&_108$$18);
	ZVAL_UNDEF(&_109$$18);
	ZVAL_UNDEF(&_110$$18);
	ZVAL_UNDEF(&_112$$19);
	ZVAL_UNDEF(&_139$$19);
	ZVAL_UNDEF(&_140$$19);
	ZVAL_UNDEF(&_141$$19);
	ZVAL_UNDEF(&_113$$20);
	ZVAL_UNDEF(&_114$$21);
	ZVAL_UNDEF(&_115$$21);
	ZVAL_UNDEF(&_117$$21);
	ZVAL_UNDEF(&_118$$21);
	ZVAL_UNDEF(&_119$$21);
	ZVAL_UNDEF(&_120$$22);
	ZVAL_UNDEF(&_121$$22);
	ZVAL_UNDEF(&_123$$22);
	ZVAL_UNDEF(&_124$$22);
	ZVAL_UNDEF(&_125$$22);
	ZVAL_UNDEF(&_126$$23);
	ZVAL_UNDEF(&_127$$24);
	ZVAL_UNDEF(&_128$$24);
	ZVAL_UNDEF(&_130$$24);
	ZVAL_UNDEF(&_131$$24);
	ZVAL_UNDEF(&_132$$24);
	ZVAL_UNDEF(&_133$$25);
	ZVAL_UNDEF(&_134$$25);
	ZVAL_UNDEF(&_136$$25);
	ZVAL_UNDEF(&_137$$25);
	ZVAL_UNDEF(&_138$$25);
	ZVAL_UNDEF(&_145$$26);
	ZVAL_UNDEF(&_146$$26);
	ZVAL_UNDEF(&_149$$27);
	ZVAL_UNDEF(&_150$$27);
	ZVAL_UNDEF(&_152$$28);
	ZVAL_UNDEF(&_153$$28);
	ZVAL_UNDEF(&_155$$29);
	ZVAL_UNDEF(&_156$$29);
	ZVAL_UNDEF(&_157$$29);
	ZVAL_UNDEF(&_158$$29);
	ZVAL_UNDEF(&_160$$30);
	ZVAL_UNDEF(&_161$$30);
	ZVAL_UNDEF(&_162$$30);
	ZVAL_UNDEF(&_164$$31);
	ZVAL_UNDEF(&_165$$31);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_166);
	ZVAL_UNDEF(&_1$$4);
	ZVAL_UNDEF(&_11$$5);
	ZVAL_UNDEF(&_23$$7);
	ZVAL_UNDEF(&_34$$9);
	ZVAL_UNDEF(&_105$$9);
	ZVAL_UNDEF(&_38$$10);
	ZVAL_UNDEF(&_53$$13);
	ZVAL_UNDEF(&_61$$14);
	ZVAL_UNDEF(&_79$$16);
	ZVAL_UNDEF(&_95$$17);
	ZVAL_UNDEF(&_116$$21);
	ZVAL_UNDEF(&_122$$22);
	ZVAL_UNDEF(&_129$$24);
	ZVAL_UNDEF(&_135$$25);
	ZVAL_UNDEF(&_144$$26);
	ZVAL_UNDEF(&_148$$27);
	ZVAL_UNDEF(&_151$$28);
	ZVAL_UNDEF(&_154$$29);
	ZVAL_UNDEF(&_159$$30);
	ZVAL_UNDEF(&_163$$31);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(variable)
		Z_PARAM_OPTIONAL
		Z_PARAM_STR_OR_NULL(name)
		Z_PARAM_LONG(tab)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &variable, &name_param, &tab_param);
	if (!name_param) {
		ZEPHIR_INIT_VAR(&name);
	} else {
		zephir_get_strval(&name, name_param);
	}
	if (!tab_param) {
		tab = 1;
	} else {
		}
	ZEPHIR_INIT_VAR(&space);
	ZVAL_STRING(&space, "  ");
	ZEPHIR_INIT_VAR(&output);
	ZVAL_STRING(&output, "");
	if (!(ZEPHIR_IS_EMPTY(&name))) {
		ZEPHIR_INIT_VAR(&_0$$3);
		ZEPHIR_CONCAT_VS(&_0$$3, &name, " ");
		ZEPHIR_CPY_WRT(&output, &_0$$3);
	}
	if (Z_TYPE_P(variable) == IS_ARRAY) {
		ZEPHIR_INIT_VAR(&_1$$4);
		zephir_create_array(&_1$$4, 2, 0);
		ZEPHIR_INIT_VAR(&_3$$4);
		ZVAL_STRING(&_3$$4, "arr");
		ZEPHIR_CALL_METHOD(&_2$$4, this_ptr, "getstyle", NULL, 0, &_3$$4);
		zephir_check_call_status();
		zephir_array_update_string(&_1$$4, SL(":style"), &_2$$4, PH_COPY | PH_SEPARATE);
		add_assoc_long_ex(&_1$$4, SL(":count"), zephir_fast_count_int(variable));
		ZEPHIR_INIT_NVAR(&_3$$4);
		ZVAL_STRING(&_3$$4, "<b style=\":style\">Array</b> (<span style=\":style\">:count</span>) (\n");
		ZEPHIR_CALL_FUNCTION(&_2$$4, "strtr", NULL, 5, &_3$$4, &_1$$4);
		zephir_check_call_status();
		zephir_concat_self(&output, &_2$$4);
		zephir_is_iterable(variable, 0, "phalcon/Support/Debug/Dump.zep", 248);
		if (Z_TYPE_P(variable) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(variable), _6$$4, _7$$4, _4$$4)
			{
				ZEPHIR_INIT_NVAR(&key);
				if (_7$$4 != NULL) { 
					ZVAL_STR_COPY(&key, _7$$4);
				} else {
					ZVAL_LONG(&key, _6$$4);
				}
				ZEPHIR_INIT_NVAR(&value);
				ZVAL_COPY(&value, _4$$4);
				ZVAL_LONG(&_8$$5, tab);
				ZEPHIR_CALL_FUNCTION(&_9$$5, "str_repeat", &_10, 1, &space, &_8$$5);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_11$$5);
				zephir_create_array(&_11$$5, 2, 0);
				ZEPHIR_INIT_NVAR(&_13$$5);
				ZVAL_STRING(&_13$$5, "arr");
				ZEPHIR_CALL_METHOD(&_12$$5, this_ptr, "getstyle", NULL, 0, &_13$$5);
				zephir_check_call_status();
				zephir_array_update_string(&_11$$5, SL(":style"), &_12$$5, PH_COPY | PH_SEPARATE);
				zephir_array_update_string(&_11$$5, SL(":key"), &key, PH_COPY | PH_SEPARATE);
				ZEPHIR_INIT_NVAR(&_13$$5);
				ZVAL_STRING(&_13$$5, "[<span style=\":style\">:key</span>] => ");
				ZEPHIR_CALL_FUNCTION(&_12$$5, "strtr", NULL, 5, &_13$$5, &_11$$5);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_14$$5);
				ZEPHIR_CONCAT_VV(&_14$$5, &_9$$5, &_12$$5);
				zephir_concat_self(&output, &_14$$5);
				_15$$5 = tab == 1;
				if (_15$$5) {
					_15$$5 = !ZEPHIR_IS_STRING(&name, "");
				}
				_16$$5 = _15$$5;
				if (_16$$5) {
					_16$$5 = !(Z_TYPE_P(&key) == IS_LONG);
				}
				_17$$5 = _16$$5;
				if (_17$$5) {
					_17$$5 = ZEPHIR_IS_EQUAL(&name, &key);
				}
				if (_17$$5) {
					continue;
				}
				ZEPHIR_INIT_NVAR(&_13$$5);
				ZVAL_STRING(&_13$$5, "");
				ZVAL_LONG(&_8$$5, (tab + 1));
				ZEPHIR_CALL_METHOD(&_18$$5, this_ptr, "output", &_19, 0, &value, &_13$$5, &_8$$5);
				zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_20$$5);
				ZEPHIR_CONCAT_VS(&_20$$5, &_18$$5, "\n");
				zephir_concat_self(&output, &_20$$5);
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, variable, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_5$$4, variable, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_5$$4)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&key, variable, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&value, variable, "current", NULL, 0);
				zephir_check_call_status();
					ZVAL_LONG(&_21$$7, tab);
					ZEPHIR_CALL_FUNCTION(&_22$$7, "str_repeat", &_10, 1, &space, &_21$$7);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_23$$7);
					zephir_create_array(&_23$$7, 2, 0);
					ZEPHIR_INIT_NVAR(&_25$$7);
					ZVAL_STRING(&_25$$7, "arr");
					ZEPHIR_CALL_METHOD(&_24$$7, this_ptr, "getstyle", NULL, 0, &_25$$7);
					zephir_check_call_status();
					zephir_array_update_string(&_23$$7, SL(":style"), &_24$$7, PH_COPY | PH_SEPARATE);
					zephir_array_update_string(&_23$$7, SL(":key"), &key, PH_COPY | PH_SEPARATE);
					ZEPHIR_INIT_NVAR(&_25$$7);
					ZVAL_STRING(&_25$$7, "[<span style=\":style\">:key</span>] => ");
					ZEPHIR_CALL_FUNCTION(&_24$$7, "strtr", NULL, 5, &_25$$7, &_23$$7);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_26$$7);
					ZEPHIR_CONCAT_VV(&_26$$7, &_22$$7, &_24$$7);
					zephir_concat_self(&output, &_26$$7);
					_27$$7 = tab == 1;
					if (_27$$7) {
						_27$$7 = !ZEPHIR_IS_STRING(&name, "");
					}
					_28$$7 = _27$$7;
					if (_28$$7) {
						_28$$7 = !(Z_TYPE_P(&key) == IS_LONG);
					}
					_29$$7 = _28$$7;
					if (_29$$7) {
						_29$$7 = ZEPHIR_IS_EQUAL(&name, &key);
					}
					if (_29$$7) {
						continue;
					}
					ZEPHIR_INIT_NVAR(&_25$$7);
					ZVAL_STRING(&_25$$7, "");
					ZVAL_LONG(&_21$$7, (tab + 1));
					ZEPHIR_CALL_METHOD(&_30$$7, this_ptr, "output", &_19, 0, &value, &_25$$7, &_21$$7);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_31$$7);
					ZEPHIR_CONCAT_VS(&_31$$7, &_30$$7, "\n");
					zephir_concat_self(&output, &_31$$7);
				ZEPHIR_CALL_METHOD(NULL, variable, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&value);
		ZEPHIR_INIT_NVAR(&key);
		ZVAL_LONG(&_32$$4, (tab - 1));
		ZEPHIR_CALL_FUNCTION(&_33$$4, "str_repeat", &_10, 1, &space, &_32$$4);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VVS(return_value, &output, &_33$$4, ")");
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_OBJECT) {
		ZEPHIR_INIT_VAR(&_34$$9);
		zephir_create_array(&_34$$9, 2, 0);
		ZEPHIR_INIT_VAR(&_36$$9);
		ZVAL_STRING(&_36$$9, "obj");
		ZEPHIR_CALL_METHOD(&_35$$9, this_ptr, "getstyle", NULL, 0, &_36$$9);
		zephir_check_call_status();
		zephir_array_update_string(&_34$$9, SL(":style"), &_35$$9, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_36$$9);
		zephir_get_class(&_36$$9, variable, 0);
		zephir_array_update_string(&_34$$9, SL(":class"), &_36$$9, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_36$$9);
		ZVAL_STRING(&_36$$9, "<b style=\":style\">Object</b> :class");
		ZEPHIR_CALL_FUNCTION(&_35$$9, "strtr", NULL, 5, &_36$$9, &_34$$9);
		zephir_check_call_status();
		zephir_concat_self(&output, &_35$$9);
		ZEPHIR_CALL_FUNCTION(&_37$$9, "get_parent_class", NULL, 0, variable);
		zephir_check_call_status();
		if (zephir_is_true(&_37$$9)) {
			ZEPHIR_INIT_VAR(&_38$$10);
			zephir_create_array(&_38$$10, 2, 0);
			ZEPHIR_INIT_VAR(&_40$$10);
			ZVAL_STRING(&_40$$10, "obj");
			ZEPHIR_CALL_METHOD(&_39$$10, this_ptr, "getstyle", NULL, 0, &_40$$10);
			zephir_check_call_status();
			zephir_array_update_string(&_38$$10, SL(":style"), &_39$$10, PH_COPY | PH_SEPARATE);
			ZEPHIR_CALL_FUNCTION(&_39$$10, "get_parent_class", NULL, 0, variable);
			zephir_check_call_status();
			zephir_array_update_string(&_38$$10, SL(":parent"), &_39$$10, PH_COPY | PH_SEPARATE);
			ZEPHIR_INIT_NVAR(&_40$$10);
			ZVAL_STRING(&_40$$10, " <b style=\":style\">extends</b> :parent");
			ZEPHIR_CALL_FUNCTION(&_39$$10, "strtr", NULL, 5, &_40$$10, &_38$$10);
			zephir_check_call_status();
			zephir_concat_self(&output, &_39$$10);
		}
		zephir_concat_self_str(&output, SL(" (\n"));
		zephir_read_property(&_41$$9, this_ptr, ZEND_STRL("detailed"), PH_NOISY_CC | PH_READONLY);
		_42$$9 = !zephir_is_true(&_41$$9);
		if (!(_42$$9)) {
			_42$$9 = zephir_is_instance_of(variable, SL("stdClass"));
		}
		if (zephir_instance_of_ev(variable, phalcon_di_di_ce)) {
			ZVAL_LONG(&_43$$11, tab);
			ZEPHIR_CALL_FUNCTION(&_44$$11, "str_repeat", &_10, 1, &space, &_43$$11);
			zephir_check_call_status();
			ZEPHIR_INIT_VAR(&_45$$11);
			ZEPHIR_CONCAT_VS(&_45$$11, &_44$$11, "[skipped]\n");
			zephir_concat_self(&output, &_45$$11);
		} else if (_42$$9) {
			ZEPHIR_CALL_FUNCTION(&_46$$12, "get_object_vars", NULL, 426, variable);
			zephir_check_call_status();
			zephir_is_iterable(&_46$$12, 0, "phalcon/Support/Debug/Dump.zep", 280);
			if (Z_TYPE_P(&_46$$12) == IS_ARRAY) {
				ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&_46$$12), _49$$12, _50$$12, _47$$12)
				{
					ZEPHIR_INIT_NVAR(&key);
					if (_50$$12 != NULL) { 
						ZVAL_STR_COPY(&key, _50$$12);
					} else {
						ZVAL_LONG(&key, _49$$12);
					}
					ZEPHIR_INIT_NVAR(&value);
					ZVAL_COPY(&value, _47$$12);
					ZVAL_LONG(&_51$$13, tab);
					ZEPHIR_CALL_FUNCTION(&_52$$13, "str_repeat", &_10, 1, &space, &_51$$13);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_53$$13);
					zephir_create_array(&_53$$13, 3, 0);
					ZEPHIR_INIT_NVAR(&_55$$13);
					ZVAL_STRING(&_55$$13, "obj");
					ZEPHIR_CALL_METHOD(&_54$$13, this_ptr, "getstyle", NULL, 0, &_55$$13);
					zephir_check_call_status();
					zephir_array_update_string(&_53$$13, SL(":style"), &_54$$13, PH_COPY | PH_SEPARATE);
					zephir_array_update_string(&_53$$13, SL(":key"), &key, PH_COPY | PH_SEPARATE);
					add_assoc_stringl_ex(&_53$$13, SL(":type"), SL("public"));
					ZEPHIR_INIT_NVAR(&_55$$13);
					ZVAL_STRING(&_55$$13, "-><span style=\":style\">:key</span> (<span style=\":style\">:type</span>) = ");
					ZEPHIR_CALL_FUNCTION(&_54$$13, "strtr", NULL, 5, &_55$$13, &_53$$13);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_56$$13);
					ZEPHIR_CONCAT_VV(&_56$$13, &_52$$13, &_54$$13);
					zephir_concat_self(&output, &_56$$13);
					ZEPHIR_INIT_NVAR(&_55$$13);
					ZVAL_STRING(&_55$$13, "");
					ZVAL_LONG(&_51$$13, (tab + 1));
					ZEPHIR_CALL_METHOD(&_57$$13, this_ptr, "output", &_19, 0, &value, &_55$$13, &_51$$13);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_58$$13);
					ZEPHIR_CONCAT_VS(&_58$$13, &_57$$13, "\n");
					zephir_concat_self(&output, &_58$$13);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &_46$$12, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_48$$12, &_46$$12, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_48$$12)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&key, &_46$$12, "key", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&value, &_46$$12, "current", NULL, 0);
					zephir_check_call_status();
						ZVAL_LONG(&_59$$14, tab);
						ZEPHIR_CALL_FUNCTION(&_60$$14, "str_repeat", &_10, 1, &space, &_59$$14);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_61$$14);
						zephir_create_array(&_61$$14, 3, 0);
						ZEPHIR_INIT_NVAR(&_63$$14);
						ZVAL_STRING(&_63$$14, "obj");
						ZEPHIR_CALL_METHOD(&_62$$14, this_ptr, "getstyle", NULL, 0, &_63$$14);
						zephir_check_call_status();
						zephir_array_update_string(&_61$$14, SL(":style"), &_62$$14, PH_COPY | PH_SEPARATE);
						zephir_array_update_string(&_61$$14, SL(":key"), &key, PH_COPY | PH_SEPARATE);
						add_assoc_stringl_ex(&_61$$14, SL(":type"), SL("public"));
						ZEPHIR_INIT_NVAR(&_63$$14);
						ZVAL_STRING(&_63$$14, "-><span style=\":style\">:key</span> (<span style=\":style\">:type</span>) = ");
						ZEPHIR_CALL_FUNCTION(&_62$$14, "strtr", NULL, 5, &_63$$14, &_61$$14);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_64$$14);
						ZEPHIR_CONCAT_VV(&_64$$14, &_60$$14, &_62$$14);
						zephir_concat_self(&output, &_64$$14);
						ZEPHIR_INIT_NVAR(&_63$$14);
						ZVAL_STRING(&_63$$14, "");
						ZVAL_LONG(&_59$$14, (tab + 1));
						ZEPHIR_CALL_METHOD(&_65$$14, this_ptr, "output", &_19, 0, &value, &_63$$14, &_59$$14);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_66$$14);
						ZEPHIR_CONCAT_VS(&_66$$14, &_65$$14, "\n");
						zephir_concat_self(&output, &_66$$14);
					ZEPHIR_CALL_METHOD(NULL, &_46$$12, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&value);
			ZEPHIR_INIT_NVAR(&key);
		} else {
			ZEPHIR_INIT_VAR(&reflect$$15);
			object_init_ex(&reflect$$15, zephir_get_internal_ce(SL("reflectionclass")));
			ZEPHIR_CALL_METHOD(NULL, &reflect$$15, "__construct", NULL, 154, variable);
			zephir_check_call_status();
			ZVAL_LONG(&_67$$15, ((1 | 2) | 4));
			ZEPHIR_CALL_METHOD(&props$$15, &reflect$$15, "getproperties", NULL, 165, &_67$$15);
			zephir_check_call_status();
			zephir_is_iterable(&props$$15, 0, "phalcon/Support/Debug/Dump.zep", 306);
			if (Z_TYPE_P(&props$$15) == IS_ARRAY) {
				ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&props$$15), _68$$15)
				{
					ZEPHIR_INIT_NVAR(&property$$15);
					ZVAL_COPY(&property$$15, _68$$15);
					ZVAL_BOOL(&_70$$16, 1);
					ZEPHIR_CALL_METHOD(NULL, &property$$15, "setaccessible", &_71, 0, &_70$$16);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&key, &property$$15, "getname", &_72, 0);
					zephir_check_call_status();
					_74$$16 = zephir_fetch_class_str_ex(SL("Reflection"), ZEND_FETCH_CLASS_AUTO);
					ZEPHIR_CALL_METHOD(&_76$$16, &property$$15, "getmodifiers", &_77, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_CE_STATIC(&_73$$16, _74$$16, "getmodifiernames", &_75, 0, &_76$$16);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&type);
					zephir_fast_join_str(&type, SL(" "), &_73$$16);
					ZVAL_LONG(&_70$$16, tab);
					ZEPHIR_CALL_FUNCTION(&_78$$16, "str_repeat", &_10, 1, &space, &_70$$16);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_79$$16);
					zephir_create_array(&_79$$16, 3, 0);
					ZEPHIR_INIT_NVAR(&_81$$16);
					ZVAL_STRING(&_81$$16, "obj");
					ZEPHIR_CALL_METHOD(&_80$$16, this_ptr, "getstyle", NULL, 0, &_81$$16);
					zephir_check_call_status();
					zephir_array_update_string(&_79$$16, SL(":style"), &_80$$16, PH_COPY | PH_SEPARATE);
					zephir_array_update_string(&_79$$16, SL(":key"), &key, PH_COPY | PH_SEPARATE);
					zephir_array_update_string(&_79$$16, SL(":type"), &type, PH_COPY | PH_SEPARATE);
					ZEPHIR_INIT_NVAR(&_81$$16);
					ZVAL_STRING(&_81$$16, "-><span style=\":style\">:key</span> (<span style=\":style\">:type</span>) = ");
					ZEPHIR_CALL_FUNCTION(&_80$$16, "strtr", NULL, 5, &_81$$16, &_79$$16);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_82$$16);
					ZEPHIR_CONCAT_VV(&_82$$16, &_78$$16, &_80$$16);
					zephir_concat_self(&output, &_82$$16);
					ZEPHIR_CALL_METHOD(&_84$$16, &property$$15, "getvalue", &_85, 0, variable);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_81$$16);
					ZVAL_STRING(&_81$$16, "");
					ZVAL_LONG(&_70$$16, (tab + 1));
					ZEPHIR_CALL_METHOD(&_83$$16, this_ptr, "output", &_19, 0, &_84$$16, &_81$$16, &_70$$16);
					zephir_check_call_status();
					ZEPHIR_INIT_NVAR(&_86$$16);
					ZEPHIR_CONCAT_VS(&_86$$16, &_83$$16, "\n");
					zephir_concat_self(&output, &_86$$16);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &props$$15, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_69$$15, &props$$15, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_69$$15)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&property$$15, &props$$15, "current", NULL, 0);
					zephir_check_call_status();
						ZVAL_BOOL(&_87$$17, 1);
						ZEPHIR_CALL_METHOD(NULL, &property$$15, "setaccessible", &_88, 0, &_87$$17);
						zephir_check_call_status();
						ZEPHIR_CALL_METHOD(&key, &property$$15, "getname", &_89, 0);
						zephir_check_call_status();
						_91$$17 = zephir_fetch_class_str_ex(SL("Reflection"), ZEND_FETCH_CLASS_AUTO);
						ZEPHIR_CALL_METHOD(&_92$$17, &property$$15, "getmodifiers", &_93, 0);
						zephir_check_call_status();
						ZEPHIR_CALL_CE_STATIC(&_90$$17, _91$$17, "getmodifiernames", &_75, 0, &_92$$17);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&type);
						zephir_fast_join_str(&type, SL(" "), &_90$$17);
						ZVAL_LONG(&_87$$17, tab);
						ZEPHIR_CALL_FUNCTION(&_94$$17, "str_repeat", &_10, 1, &space, &_87$$17);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_95$$17);
						zephir_create_array(&_95$$17, 3, 0);
						ZEPHIR_INIT_NVAR(&_97$$17);
						ZVAL_STRING(&_97$$17, "obj");
						ZEPHIR_CALL_METHOD(&_96$$17, this_ptr, "getstyle", NULL, 0, &_97$$17);
						zephir_check_call_status();
						zephir_array_update_string(&_95$$17, SL(":style"), &_96$$17, PH_COPY | PH_SEPARATE);
						zephir_array_update_string(&_95$$17, SL(":key"), &key, PH_COPY | PH_SEPARATE);
						zephir_array_update_string(&_95$$17, SL(":type"), &type, PH_COPY | PH_SEPARATE);
						ZEPHIR_INIT_NVAR(&_97$$17);
						ZVAL_STRING(&_97$$17, "-><span style=\":style\">:key</span> (<span style=\":style\">:type</span>) = ");
						ZEPHIR_CALL_FUNCTION(&_96$$17, "strtr", NULL, 5, &_97$$17, &_95$$17);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_98$$17);
						ZEPHIR_CONCAT_VV(&_98$$17, &_94$$17, &_96$$17);
						zephir_concat_self(&output, &_98$$17);
						ZEPHIR_CALL_METHOD(&_100$$17, &property$$15, "getvalue", &_101, 0, variable);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_97$$17);
						ZVAL_STRING(&_97$$17, "");
						ZVAL_LONG(&_87$$17, (tab + 1));
						ZEPHIR_CALL_METHOD(&_99$$17, this_ptr, "output", &_19, 0, &_100$$17, &_97$$17, &_87$$17);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_102$$17);
						ZEPHIR_CONCAT_VS(&_102$$17, &_99$$17, "\n");
						zephir_concat_self(&output, &_102$$17);
					ZEPHIR_CALL_METHOD(NULL, &props$$15, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&property$$15);
		}
		ZEPHIR_CALL_FUNCTION(&attr, "get_class_methods", NULL, 0, variable);
		zephir_check_call_status();
		ZVAL_LONG(&_103$$9, tab);
		ZEPHIR_CALL_FUNCTION(&_104$$9, "str_repeat", &_10, 1, &space, &_103$$9);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&_105$$9);
		zephir_create_array(&_105$$9, 3, 0);
		ZEPHIR_INIT_NVAR(&_36$$9);
		ZVAL_STRING(&_36$$9, "obj");
		ZEPHIR_CALL_METHOD(&_106$$9, this_ptr, "getstyle", NULL, 0, &_36$$9);
		zephir_check_call_status();
		zephir_array_update_string(&_105$$9, SL(":style"), &_106$$9, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_36$$9);
		zephir_get_class(&_36$$9, variable, 0);
		zephir_array_update_string(&_105$$9, SL(":class"), &_36$$9, PH_COPY | PH_SEPARATE);
		add_assoc_long_ex(&_105$$9, SL(":count"), zephir_fast_count_int(&attr));
		ZEPHIR_INIT_NVAR(&_36$$9);
		ZVAL_STRING(&_36$$9, ":class <b style=\":style\">methods</b>: (<span style=\":style\">:count</span>) (\n");
		ZEPHIR_CALL_FUNCTION(&_106$$9, "strtr", NULL, 5, &_36$$9, &_105$$9);
		zephir_check_call_status();
		ZEPHIR_INIT_VAR(&_107$$9);
		ZEPHIR_CONCAT_VV(&_107$$9, &_104$$9, &_106$$9);
		zephir_concat_self(&output, &_107$$9);
		ZEPHIR_INIT_NVAR(&_36$$9);
		zephir_get_class(&_36$$9, variable, 0);
		zephir_read_property(&_103$$9, this_ptr, ZEND_STRL("methods"), PH_NOISY_CC | PH_READONLY);
		if (zephir_fast_in_array(&_36$$9, &_103$$9)) {
			ZVAL_LONG(&_108$$18, tab);
			ZEPHIR_CALL_FUNCTION(&_109$$18, "str_repeat", &_10, 1, &space, &_108$$18);
			zephir_check_call_status();
			ZEPHIR_INIT_VAR(&_110$$18);
			ZEPHIR_CONCAT_VS(&_110$$18, &_109$$18, "[already listed]\n");
			zephir_concat_self(&output, &_110$$18);
		} else {
			zephir_is_iterable(&attr, 0, "phalcon/Support/Debug/Dump.zep", 324);
			if (Z_TYPE_P(&attr) == IS_ARRAY) {
				ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&attr), _111$$19)
				{
					ZEPHIR_INIT_NVAR(&value);
					ZVAL_COPY(&value, _111$$19);
					ZEPHIR_INIT_NVAR(&_113$$20);
					zephir_get_class(&_113$$20, variable, 0);
					zephir_update_property_array_append(this_ptr, SL("methods"), &_113$$20);
					if (ZEPHIR_IS_STRING(&value, "__construct")) {
						ZVAL_LONG(&_114$$21, (tab + 1));
						ZEPHIR_CALL_FUNCTION(&_115$$21, "str_repeat", &_10, 1, &space, &_114$$21);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_116$$21);
						zephir_create_array(&_116$$21, 2, 0);
						ZEPHIR_INIT_NVAR(&_118$$21);
						ZVAL_STRING(&_118$$21, "obj");
						ZEPHIR_CALL_METHOD(&_117$$21, this_ptr, "getstyle", NULL, 0, &_118$$21);
						zephir_check_call_status();
						zephir_array_update_string(&_116$$21, SL(":style"), &_117$$21, PH_COPY | PH_SEPARATE);
						zephir_array_update_string(&_116$$21, SL(":method"), &value, PH_COPY | PH_SEPARATE);
						ZEPHIR_INIT_NVAR(&_118$$21);
						ZVAL_STRING(&_118$$21, "-><span style=\":style\">:method</span>(); [<b style=\":style\">constructor</b>]\n");
						ZEPHIR_CALL_FUNCTION(&_117$$21, "strtr", NULL, 5, &_118$$21, &_116$$21);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_119$$21);
						ZEPHIR_CONCAT_VV(&_119$$21, &_115$$21, &_117$$21);
						zephir_concat_self(&output, &_119$$21);
					} else {
						ZVAL_LONG(&_120$$22, (tab + 1));
						ZEPHIR_CALL_FUNCTION(&_121$$22, "str_repeat", &_10, 1, &space, &_120$$22);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_122$$22);
						zephir_create_array(&_122$$22, 2, 0);
						ZEPHIR_INIT_NVAR(&_124$$22);
						ZVAL_STRING(&_124$$22, "obj");
						ZEPHIR_CALL_METHOD(&_123$$22, this_ptr, "getstyle", NULL, 0, &_124$$22);
						zephir_check_call_status();
						zephir_array_update_string(&_122$$22, SL(":style"), &_123$$22, PH_COPY | PH_SEPARATE);
						zephir_array_update_string(&_122$$22, SL(":method"), &value, PH_COPY | PH_SEPARATE);
						ZEPHIR_INIT_NVAR(&_124$$22);
						ZVAL_STRING(&_124$$22, "-><span style=\":style\">:method</span>();\n");
						ZEPHIR_CALL_FUNCTION(&_123$$22, "strtr", NULL, 5, &_124$$22, &_122$$22);
						zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_125$$22);
						ZEPHIR_CONCAT_VV(&_125$$22, &_121$$22, &_123$$22);
						zephir_concat_self(&output, &_125$$22);
					}
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &attr, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_112$$19, &attr, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_112$$19)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&value, &attr, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_126$$23);
						zephir_get_class(&_126$$23, variable, 0);
						zephir_update_property_array_append(this_ptr, SL("methods"), &_126$$23);
						if (ZEPHIR_IS_STRING(&value, "__construct")) {
							ZVAL_LONG(&_127$$24, (tab + 1));
							ZEPHIR_CALL_FUNCTION(&_128$$24, "str_repeat", &_10, 1, &space, &_127$$24);
							zephir_check_call_status();
							ZEPHIR_INIT_NVAR(&_129$$24);
							zephir_create_array(&_129$$24, 2, 0);
							ZEPHIR_INIT_NVAR(&_131$$24);
							ZVAL_STRING(&_131$$24, "obj");
							ZEPHIR_CALL_METHOD(&_130$$24, this_ptr, "getstyle", NULL, 0, &_131$$24);
							zephir_check_call_status();
							zephir_array_update_string(&_129$$24, SL(":style"), &_130$$24, PH_COPY | PH_SEPARATE);
							zephir_array_update_string(&_129$$24, SL(":method"), &value, PH_COPY | PH_SEPARATE);
							ZEPHIR_INIT_NVAR(&_131$$24);
							ZVAL_STRING(&_131$$24, "-><span style=\":style\">:method</span>(); [<b style=\":style\">constructor</b>]\n");
							ZEPHIR_CALL_FUNCTION(&_130$$24, "strtr", NULL, 5, &_131$$24, &_129$$24);
							zephir_check_call_status();
							ZEPHIR_INIT_NVAR(&_132$$24);
							ZEPHIR_CONCAT_VV(&_132$$24, &_128$$24, &_130$$24);
							zephir_concat_self(&output, &_132$$24);
						} else {
							ZVAL_LONG(&_133$$25, (tab + 1));
							ZEPHIR_CALL_FUNCTION(&_134$$25, "str_repeat", &_10, 1, &space, &_133$$25);
							zephir_check_call_status();
							ZEPHIR_INIT_NVAR(&_135$$25);
							zephir_create_array(&_135$$25, 2, 0);
							ZEPHIR_INIT_NVAR(&_137$$25);
							ZVAL_STRING(&_137$$25, "obj");
							ZEPHIR_CALL_METHOD(&_136$$25, this_ptr, "getstyle", NULL, 0, &_137$$25);
							zephir_check_call_status();
							zephir_array_update_string(&_135$$25, SL(":style"), &_136$$25, PH_COPY | PH_SEPARATE);
							zephir_array_update_string(&_135$$25, SL(":method"), &value, PH_COPY | PH_SEPARATE);
							ZEPHIR_INIT_NVAR(&_137$$25);
							ZVAL_STRING(&_137$$25, "-><span style=\":style\">:method</span>();\n");
							ZEPHIR_CALL_FUNCTION(&_136$$25, "strtr", NULL, 5, &_137$$25, &_135$$25);
							zephir_check_call_status();
							ZEPHIR_INIT_NVAR(&_138$$25);
							ZEPHIR_CONCAT_VV(&_138$$25, &_134$$25, &_136$$25);
							zephir_concat_self(&output, &_138$$25);
						}
					ZEPHIR_CALL_METHOD(NULL, &attr, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_LONG(&_139$$19, tab);
			ZEPHIR_CALL_FUNCTION(&_140$$19, "str_repeat", &_10, 1, &space, &_139$$19);
			zephir_check_call_status();
			ZEPHIR_INIT_VAR(&_141$$19);
			ZEPHIR_CONCAT_VS(&_141$$19, &_140$$19, ")\n");
			zephir_concat_self(&output, &_141$$19);
		}
		ZVAL_LONG(&_142$$9, (tab - 1));
		ZEPHIR_CALL_FUNCTION(&_143$$9, "str_repeat", &_10, 1, &space, &_142$$9);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VVS(return_value, &output, &_143$$9, ")");
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_LONG) {
		ZEPHIR_INIT_VAR(&_144$$26);
		zephir_create_array(&_144$$26, 2, 0);
		ZEPHIR_INIT_VAR(&_146$$26);
		ZVAL_STRING(&_146$$26, "int");
		ZEPHIR_CALL_METHOD(&_145$$26, this_ptr, "getstyle", NULL, 0, &_146$$26);
		zephir_check_call_status();
		zephir_array_update_string(&_144$$26, SL(":style"), &_145$$26, PH_COPY | PH_SEPARATE);
		zephir_array_update_string(&_144$$26, SL(":var"), variable, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_146$$26);
		ZVAL_STRING(&_146$$26, "<b style=\":style\">Integer</b> (<span style=\":style\">:var</span>)");
		ZEPHIR_CALL_FUNCTION(&_145$$26, "strtr", NULL, 5, &_146$$26, &_144$$26);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_145$$26);
		RETURN_MM();
	}
	ZEPHIR_CALL_FUNCTION(&_147, "is_float", NULL, 214, variable);
	zephir_check_call_status();
	if (zephir_is_true(&_147)) {
		ZEPHIR_INIT_VAR(&_148$$27);
		zephir_create_array(&_148$$27, 2, 0);
		ZEPHIR_INIT_VAR(&_150$$27);
		ZVAL_STRING(&_150$$27, "float");
		ZEPHIR_CALL_METHOD(&_149$$27, this_ptr, "getstyle", NULL, 0, &_150$$27);
		zephir_check_call_status();
		zephir_array_update_string(&_148$$27, SL(":style"), &_149$$27, PH_COPY | PH_SEPARATE);
		zephir_array_update_string(&_148$$27, SL(":var"), variable, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_150$$27);
		ZVAL_STRING(&_150$$27, "<b style=\":style\">Float</b> (<span style=\":style\">:var</span>)");
		ZEPHIR_CALL_FUNCTION(&_149$$27, "strtr", NULL, 5, &_150$$27, &_148$$27);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_149$$27);
		RETURN_MM();
	}
	if (zephir_is_numeric(variable)) {
		ZEPHIR_INIT_VAR(&_151$$28);
		zephir_create_array(&_151$$28, 3, 0);
		ZEPHIR_INIT_VAR(&_153$$28);
		ZVAL_STRING(&_153$$28, "num");
		ZEPHIR_CALL_METHOD(&_152$$28, this_ptr, "getstyle", NULL, 0, &_153$$28);
		zephir_check_call_status();
		zephir_array_update_string(&_151$$28, SL(":style"), &_152$$28, PH_COPY | PH_SEPARATE);
		add_assoc_long_ex(&_151$$28, SL(":length"), zephir_fast_strlen_ev(variable));
		zephir_array_update_string(&_151$$28, SL(":var"), variable, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_153$$28);
		ZVAL_STRING(&_153$$28, "<b style=\":style\">Numeric string</b> (<span style=\":style\">:length</span>) \"<span style=\":style\">:var</span>\"");
		ZEPHIR_CALL_FUNCTION(&_152$$28, "strtr", NULL, 5, &_153$$28, &_151$$28);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_152$$28);
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_STRING) {
		ZEPHIR_INIT_VAR(&_154$$29);
		zephir_create_array(&_154$$29, 3, 0);
		ZEPHIR_INIT_VAR(&_156$$29);
		ZVAL_STRING(&_156$$29, "str");
		ZEPHIR_CALL_METHOD(&_155$$29, this_ptr, "getstyle", NULL, 0, &_156$$29);
		zephir_check_call_status();
		zephir_array_update_string(&_154$$29, SL(":style"), &_155$$29, PH_COPY | PH_SEPARATE);
		add_assoc_long_ex(&_154$$29, SL(":length"), zephir_fast_strlen_ev(variable));
		ZVAL_LONG(&_157$$29, 4);
		ZEPHIR_INIT_NVAR(&_156$$29);
		ZVAL_STRING(&_156$$29, "utf-8");
		ZEPHIR_CALL_FUNCTION(&_155$$29, "htmlentities", NULL, 0, variable, &_157$$29, &_156$$29);
		zephir_check_call_status();
		ZEPHIR_CALL_FUNCTION(&_158$$29, "nl2br", NULL, 0, &_155$$29);
		zephir_check_call_status();
		zephir_array_update_string(&_154$$29, SL(":var"), &_158$$29, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_156$$29);
		ZVAL_STRING(&_156$$29, "<b style=\":style\">String</b> (<span style=\":style\">:length</span>) \"<span style=\":style\">:var</span>\"");
		ZEPHIR_CALL_FUNCTION(&_158$$29, "strtr", NULL, 5, &_156$$29, &_154$$29);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_158$$29);
		RETURN_MM();
	}
	if ((Z_TYPE_P(variable) == IS_TRUE || Z_TYPE_P(variable) == IS_FALSE)) {
		ZEPHIR_INIT_VAR(&_159$$30);
		zephir_create_array(&_159$$30, 2, 0);
		ZEPHIR_INIT_VAR(&_161$$30);
		ZVAL_STRING(&_161$$30, "bool");
		ZEPHIR_CALL_METHOD(&_160$$30, this_ptr, "getstyle", NULL, 0, &_161$$30);
		zephir_check_call_status();
		zephir_array_update_string(&_159$$30, SL(":style"), &_160$$30, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_VAR(&_162$$30);
		if (zephir_is_true(variable)) {
			ZEPHIR_INIT_NVAR(&_162$$30);
			ZVAL_STRING(&_162$$30, "TRUE");
		} else {
			ZEPHIR_INIT_NVAR(&_162$$30);
			ZVAL_STRING(&_162$$30, "FALSE");
		}
		zephir_array_update_string(&_159$$30, SL(":var"), &_162$$30, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_161$$30);
		ZVAL_STRING(&_161$$30, "<b style=\":style\">Boolean</b> (<span style=\":style\">:var</span>)");
		ZEPHIR_CALL_FUNCTION(&_160$$30, "strtr", NULL, 5, &_161$$30, &_159$$30);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_160$$30);
		RETURN_MM();
	}
	if (Z_TYPE_P(variable) == IS_NULL) {
		ZEPHIR_INIT_VAR(&_163$$31);
		zephir_create_array(&_163$$31, 1, 0);
		ZEPHIR_INIT_VAR(&_165$$31);
		ZVAL_STRING(&_165$$31, "null");
		ZEPHIR_CALL_METHOD(&_164$$31, this_ptr, "getstyle", NULL, 0, &_165$$31);
		zephir_check_call_status();
		zephir_array_update_string(&_163$$31, SL(":style"), &_164$$31, PH_COPY | PH_SEPARATE);
		ZEPHIR_INIT_NVAR(&_165$$31);
		ZVAL_STRING(&_165$$31, "<b style=\":style\">NULL</b>");
		ZEPHIR_CALL_FUNCTION(&_164$$31, "strtr", NULL, 5, &_165$$31, &_163$$31);
		zephir_check_call_status();
		ZEPHIR_CONCAT_VV(return_value, &output, &_164$$31);
		RETURN_MM();
	}
	ZEPHIR_INIT_VAR(&_166);
	zephir_create_array(&_166, 2, 0);
	ZEPHIR_INIT_VAR(&_168);
	ZVAL_STRING(&_168, "other");
	ZEPHIR_CALL_METHOD(&_167, this_ptr, "getstyle", NULL, 0, &_168);
	zephir_check_call_status();
	zephir_array_update_string(&_166, SL(":style"), &_167, PH_COPY | PH_SEPARATE);
	zephir_array_update_string(&_166, SL(":var"), variable, PH_COPY | PH_SEPARATE);
	ZEPHIR_INIT_NVAR(&_168);
	ZVAL_STRING(&_168, "(<span style=\":style\">:var</span>)");
	ZEPHIR_CALL_FUNCTION(&_167, "strtr", NULL, 5, &_168, &_166);
	zephir_check_call_status();
	ZEPHIR_CONCAT_VV(return_value, &output, &_167);
	RETURN_MM();
}

zend_object *zephir_init_properties_Phalcon_Support_Debug_Dump(zend_class_entry *class_type)
{
		zval _0, _2, _1$$3, _3$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$4);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("styles"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("styles"), &_1$$3);
		}
		zephir_read_property_ex(&_2, this_ptr, ZEND_STRL("methods"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_2) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_3$$4);
			array_init(&_3$$4);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("methods"), &_3$$4);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Debug_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Debug, Exception, phalcon, support_debug_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Collection_CollectionInterface)
{
	ZEPHIR_REGISTER_INTERFACE(Phalcon\\Support\\Collection, CollectionInterface, phalcon, support_collection_collectioninterface, phalcon_support_collection_collectioninterface_method_entry);

	return SUCCESS;
}

ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, __get);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, __isset);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, __set);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, __unset);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, clear);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, get);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, getKeys);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, getValues);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, has);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, init);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, remove);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, set);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, toArray);
ZEPHIR_DOC_METHOD(Phalcon_Support_Collection_CollectionInterface, toJson);



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Collection_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Collection, Exception, phalcon, support_collection_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Support_Collection_ReadOnlyCollection)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Support\\Collection, ReadOnlyCollection, phalcon, support_collection_readonlycollection, phalcon_support_collection_ce, phalcon_support_collection_readonlycollection_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Support_Collection_ReadOnlyCollection, remove)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *element_param = NULL;
	zval element;

	ZVAL_UNDEF(&element);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(element)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &element_param);
	zephir_get_strval(&element, element_param);
	ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_support_collection_exception_ce, "The object is read only", "phalcon/Support/Collection/ReadOnlyCollection.zep", 25);
	return;
}

static PHP_METHOD(Phalcon_Support_Collection_ReadOnlyCollection, set)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *element_param = NULL, *value, value_sub;
	zval element;

	ZVAL_UNDEF(&element);
	ZVAL_UNDEF(&value_sub);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(element)
		Z_PARAM_ZVAL(value)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &element_param, &value);
	zephir_get_strval(&element, element_param);
	ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_support_collection_exception_ce, "The object is read only", "phalcon/Support/Collection/ReadOnlyCollection.zep", 33);
	return;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Annotation)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Annotations, Annotation, phalcon, annotations_annotation, phalcon_annotations_annotation_method_entry, 0);

	zend_declare_property_null(phalcon_annotations_annotation_ce, SL("arguments"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_annotation_ce, SL("exprArguments"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_annotation_ce, SL("name"), ZEND_ACC_PROTECTED);
	phalcon_annotations_annotation_ce->create_object = zephir_init_properties_Phalcon_Annotations_Annotation;

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Annotation, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *reflectionData_param = NULL, name, exprArguments, argument, resolvedArgument, _0$$3, *_1$$4, _2$$4, _3$$5, _5$$8;
	zval reflectionData, arguments;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionData);
	ZVAL_UNDEF(&arguments);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&exprArguments);
	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&resolvedArgument);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_2$$4);
	ZVAL_UNDEF(&_3$$5);
	ZVAL_UNDEF(&_5$$8);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(reflectionData)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &reflectionData_param);
	ZEPHIR_OBS_COPY_OR_DUP(&reflectionData, reflectionData_param);
	zephir_memory_observe(&name);
	if (zephir_array_isset_string_fetch(&name, &reflectionData, SL("name"), 0)) {
		zephir_array_fetch_string(&_0$$3, &reflectionData, SL("name"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 48);
		zephir_update_property_zval(this_ptr, ZEND_STRL("name"), &_0$$3);
	}
	zephir_memory_observe(&exprArguments);
	if (zephir_array_isset_string_fetch(&exprArguments, &reflectionData, SL("arguments"), 0)) {
		ZEPHIR_INIT_VAR(&arguments);
		array_init(&arguments);
		zephir_is_iterable(&exprArguments, 0, "phalcon/Annotations/Annotation.zep", 69);
		if (Z_TYPE_P(&exprArguments) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&exprArguments), _1$$4)
			{
				ZEPHIR_INIT_NVAR(&argument);
				ZVAL_COPY(&argument, _1$$4);
				zephir_array_fetch_string(&_3$$5, &argument, SL("expr"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 60);
				ZEPHIR_CALL_METHOD(&resolvedArgument, this_ptr, "getexpression", &_4, 0, &_3$$5);
				zephir_check_call_status();
				ZEPHIR_OBS_NVAR(&name);
				if (zephir_array_isset_string_fetch(&name, &argument, SL("name"), 0)) {
					zephir_array_update_zval(&arguments, &name, &resolvedArgument, PH_COPY | PH_SEPARATE);
				} else {
					zephir_array_append(&arguments, &resolvedArgument, PH_SEPARATE, "phalcon/Annotations/Annotation.zep", 65);
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &exprArguments, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_2$$4, &exprArguments, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_2$$4)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&argument, &exprArguments, "current", NULL, 0);
				zephir_check_call_status();
					zephir_array_fetch_string(&_5$$8, &argument, SL("expr"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 60);
					ZEPHIR_CALL_METHOD(&resolvedArgument, this_ptr, "getexpression", &_4, 0, &_5$$8);
					zephir_check_call_status();
					ZEPHIR_OBS_NVAR(&name);
					if (zephir_array_isset_string_fetch(&name, &argument, SL("name"), 0)) {
						zephir_array_update_zval(&arguments, &name, &resolvedArgument, PH_COPY | PH_SEPARATE);
					} else {
						zephir_array_append(&arguments, &resolvedArgument, PH_SEPARATE, "phalcon/Annotations/Annotation.zep", 65);
					}
				ZEPHIR_CALL_METHOD(NULL, &exprArguments, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&argument);
		zephir_update_property_zval(this_ptr, ZEND_STRL("arguments"), &arguments);
		zephir_update_property_zval(this_ptr, ZEND_STRL("exprArguments"), &exprArguments);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getArgument)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *position, position_sub, argument, _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&position_sub);
	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(position)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &position);
	zephir_memory_observe(&argument);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("arguments"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset_fetch(&argument, &_0, position, 0)) {
		RETURN_CCTOR(&argument);
	}
	RETURN_MM_NULL();
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getArguments)
{

	RETURN_MEMBER(getThis(), "arguments");
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getExprArguments)
{

	RETURN_MEMBER(getThis(), "exprArguments");
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getExpression)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *expr_param = NULL, value, item, resolvedItem, arrayValue, name, type, _0$$7, *_1$$7, _2$$7, _3$$8, _5$$11, _6$$15, _7$$15;
	zval expr;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&expr);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&item);
	ZVAL_UNDEF(&resolvedItem);
	ZVAL_UNDEF(&arrayValue);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&type);
	ZVAL_UNDEF(&_0$$7);
	ZVAL_UNDEF(&_2$$7);
	ZVAL_UNDEF(&_3$$8);
	ZVAL_UNDEF(&_5$$11);
	ZVAL_UNDEF(&_6$$15);
	ZVAL_UNDEF(&_7$$15);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(expr)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &expr_param);
	ZEPHIR_OBS_COPY_OR_DUP(&expr, expr_param);
	zephir_memory_observe(&type);
	zephir_array_fetch_string(&type, &expr, SL("type"), PH_NOISY, "phalcon/Annotations/Annotation.zep", 111);
	do {
		if (ZEPHIR_IS_LONG(&type, 301) || ZEPHIR_IS_LONG(&type, 302) || ZEPHIR_IS_LONG(&type, 303) || ZEPHIR_IS_LONG(&type, 307)) {
			zephir_memory_observe(&value);
			zephir_array_fetch_string(&value, &expr, SL("value"), PH_NOISY, "phalcon/Annotations/Annotation.zep", 118);
			break;
		}
		if (ZEPHIR_IS_LONG(&type, 304)) {
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_NULL(&value);
			break;
		}
		if (ZEPHIR_IS_LONG(&type, 305)) {
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_BOOL(&value, 0);
			break;
		}
		if (ZEPHIR_IS_LONG(&type, 306)) {
			ZEPHIR_INIT_NVAR(&value);
			ZVAL_BOOL(&value, 1);
			break;
		}
		if (ZEPHIR_IS_LONG(&type, 308)) {
			ZEPHIR_INIT_VAR(&arrayValue);
			array_init(&arrayValue);
			zephir_array_fetch_string(&_0$$7, &expr, SL("items"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 136);
			zephir_is_iterable(&_0$$7, 0, "phalcon/Annotations/Annotation.zep", 148);
			if (Z_TYPE_P(&_0$$7) == IS_ARRAY) {
				ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&_0$$7), _1$$7)
				{
					ZEPHIR_INIT_NVAR(&item);
					ZVAL_COPY(&item, _1$$7);
					zephir_array_fetch_string(&_3$$8, &item, SL("expr"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 139);
					ZEPHIR_CALL_METHOD(&resolvedItem, this_ptr, "getexpression", &_4, 157, &_3$$8);
					zephir_check_call_status();
					ZEPHIR_OBS_NVAR(&name);
					if (zephir_array_isset_string_fetch(&name, &item, SL("name"), 0)) {
						zephir_array_update_zval(&arrayValue, &name, &resolvedItem, PH_COPY | PH_SEPARATE);
					} else {
						zephir_array_append(&arrayValue, &resolvedItem, PH_SEPARATE, "phalcon/Annotations/Annotation.zep", 144);
					}
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &_0$$7, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_2$$7, &_0$$7, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_2$$7)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&item, &_0$$7, "current", NULL, 0);
					zephir_check_call_status();
						zephir_array_fetch_string(&_5$$11, &item, SL("expr"), PH_NOISY | PH_READONLY, "phalcon/Annotations/Annotation.zep", 139);
						ZEPHIR_CALL_METHOD(&resolvedItem, this_ptr, "getexpression", &_4, 157, &_5$$11);
						zephir_check_call_status();
						ZEPHIR_OBS_NVAR(&name);
						if (zephir_array_isset_string_fetch(&name, &item, SL("name"), 0)) {
							zephir_array_update_zval(&arrayValue, &name, &resolvedItem, PH_COPY | PH_SEPARATE);
						} else {
							zephir_array_append(&arrayValue, &resolvedItem, PH_SEPARATE, "phalcon/Annotations/Annotation.zep", 144);
						}
					ZEPHIR_CALL_METHOD(NULL, &_0$$7, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&item);
			RETURN_CCTOR(&arrayValue);
		}
		if (ZEPHIR_IS_LONG(&type, 300)) {
			object_init_ex(return_value, phalcon_annotations_annotation_ce);
			ZEPHIR_CALL_METHOD(NULL, return_value, "__construct", NULL, 158, &expr);
			zephir_check_call_status();
			RETURN_MM();
		}
		ZEPHIR_INIT_VAR(&_6$$15);
		object_init_ex(&_6$$15, phalcon_annotations_exception_ce);
		ZEPHIR_INIT_VAR(&_7$$15);
		ZEPHIR_CONCAT_SVS(&_7$$15, "The expression ", &type, " is unknown");
		ZEPHIR_CALL_METHOD(NULL, &_6$$15, "__construct", NULL, 33, &_7$$15);
		zephir_check_call_status();
		zephir_throw_exception_debug(&_6$$15, "phalcon/Annotations/Annotation.zep", 154);
		ZEPHIR_MM_RESTORE();
		return;
	} while(0);

	RETURN_CCTOR(&value);
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getName)
{

	RETURN_MEMBER(getThis(), "name");
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getNamedArgument)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *name_param = NULL, argument, _0;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&argument);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	if (UNEXPECTED(Z_TYPE_P(name_param) != IS_STRING && Z_TYPE_P(name_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'name' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(name_param) == IS_STRING)) {
		zephir_get_strval(&name, name_param);
	} else {
		ZEPHIR_INIT_VAR(&name);
	}
	zephir_memory_observe(&argument);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("arguments"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset_fetch(&argument, &_0, &name, 0)) {
		RETURN_CCTOR(&argument);
	}
	RETURN_MM_NULL();
}

static PHP_METHOD(Phalcon_Annotations_Annotation, getNamedParameter)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *name_param = NULL;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	if (UNEXPECTED(Z_TYPE_P(name_param) != IS_STRING && Z_TYPE_P(name_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'name' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(name_param) == IS_STRING)) {
		zephir_get_strval(&name, name_param);
	} else {
		ZEPHIR_INIT_VAR(&name);
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "getnamedargument", NULL, 0, &name);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Annotation, hasArgument)
{
	zval *position, position_sub, _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&position_sub);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(position)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &position);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("arguments"), PH_NOISY_CC | PH_READONLY);
	RETURN_BOOL(zephir_array_isset(&_0, position));
}

static PHP_METHOD(Phalcon_Annotations_Annotation, numberArguments)
{
	zval _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("arguments"), PH_NOISY_CC | PH_READONLY);
	RETURN_LONG(zephir_fast_count_int(&_0));
}

zend_object *zephir_init_properties_Phalcon_Annotations_Annotation(zend_class_entry *class_type)
{
		zval _0, _2, _1$$3, _3$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$4);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("exprArguments"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("exprArguments"), &_1$$3);
		}
		zephir_read_property_ex(&_2, this_ptr, ZEND_STRL("arguments"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_2) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_3$$4);
			array_init(&_3$$4);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("arguments"), &_3$$4);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_AnnotationsFactory)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Annotations, AnnotationsFactory, phalcon, annotations_annotationsfactory, phalcon_factory_abstractfactory_ce, phalcon_annotations_annotationsfactory_method_entry, 0);

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_AnnotationsFactory, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *services_param = NULL;
	zval services;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&services);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(services)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &services_param);
	if (!services_param) {
		ZEPHIR_INIT_VAR(&services);
		array_init(&services);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&services, services_param);
	}
	ZEPHIR_CALL_METHOD(NULL, this_ptr, "init", NULL, 0, &services);
	zephir_check_call_status();
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_AnnotationsFactory, load)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *config = NULL, config_sub, name, options, _0, _1, _2, _3;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&config_sub);
	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&options);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(config)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &config);
	ZEPHIR_SEPARATE_PARAM(config);
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "checkconfig", NULL, 0, config);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(config, &_0);
	ZEPHIR_INIT_VAR(&_1);
	ZVAL_STRING(&_1, "adapter");
	ZEPHIR_CALL_METHOD(&_0, this_ptr, "checkconfigelement", NULL, 0, config, &_1);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(config, &_0);
	zephir_memory_observe(&name);
	zephir_array_fetch_string(&name, config, SL("adapter"), PH_NOISY, "phalcon/Annotations/AnnotationsFactory.zep", 48);
	zephir_array_unset_string(config, SL("adapter"), PH_SEPARATE);
	ZEPHIR_INIT_NVAR(&_1);
	object_init_ex(&_1, phalcon_support_helper_arr_get_ce);
	if (zephir_has_constructor(&_1)) {
		ZEPHIR_CALL_METHOD(NULL, &_1, "__construct", NULL, 0);
		zephir_check_call_status();
	}

	ZEPHIR_INIT_VAR(&_2);
	array_init(&_2);
	ZEPHIR_INIT_VAR(&_3);
	ZVAL_STRING(&_3, "options");
	ZEPHIR_CALL_METHOD(&options, &_1, "__invoke", NULL, 159, config, &_3, &_2);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "newinstance", NULL, 0, &name, &options);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_AnnotationsFactory, newInstance)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval options, _0;
	zval *name_param = NULL, *options_param = NULL, definition;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&definition);
	ZVAL_UNDEF(&options);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(1, 2)
		Z_PARAM_STR(name)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 1, &name_param, &options_param);
	if (UNEXPECTED(Z_TYPE_P(name_param) != IS_STRING && Z_TYPE_P(name_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'name' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(name_param) == IS_STRING)) {
		zephir_get_strval(&name, name_param);
	} else {
		ZEPHIR_INIT_VAR(&name);
	}
	if (!options_param) {
		ZEPHIR_INIT_VAR(&options);
		array_init(&options);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&options, options_param);
	}
	ZEPHIR_CALL_METHOD(&definition, this_ptr, "getservice", NULL, 0, &name);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 1, 0);
	zephir_array_fast_append(&_0, &options);
	ZEPHIR_LAST_CALL_STATUS = zephir_create_instance_params(return_value, &definition, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_AnnotationsFactory, getExceptionClass)
{

	RETURN_STRING("Phalcon\\Annotations\\Exception");
}

static PHP_METHOD(Phalcon_Annotations_AnnotationsFactory, getServices)
{

	zephir_create_array(return_value, 3, 0);
	add_assoc_stringl_ex(return_value, SL("apcu"), SL("Phalcon\\Annotations\\Adapter\\Apcu"));
	add_assoc_stringl_ex(return_value, SL("memory"), SL("Phalcon\\Annotations\\Adapter\\Memory"));
	add_assoc_stringl_ex(return_value, SL("stream"), SL("Phalcon\\Annotations\\Adapter\\Stream"));
	return;
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Collection)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Annotations, Collection, phalcon, annotations_collection, phalcon_annotations_collection_method_entry, 0);

	zend_declare_property_null(phalcon_annotations_collection_ce, SL("annotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_long(phalcon_annotations_collection_ce, SL("position"), 0, ZEND_ACC_PROTECTED);
	zend_class_implements(phalcon_annotations_collection_ce, 1, zend_ce_iterator);
	zend_class_implements(phalcon_annotations_collection_ce, 1, zend_ce_countable);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Collection, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_3 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *reflectionData_param = NULL, annotations, annotationData, *_0, _1, _2$$3, _4$$4;
	zval reflectionData;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionData);
	ZVAL_UNDEF(&annotations);
	ZVAL_UNDEF(&annotationData);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_4$$4);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(reflectionData)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &reflectionData_param);
	if (!reflectionData_param) {
		ZEPHIR_INIT_VAR(&reflectionData);
		array_init(&reflectionData);
	} else {
		zephir_get_arrval(&reflectionData, reflectionData_param);
	}
	ZEPHIR_INIT_VAR(&annotations);
	array_init(&annotations);
	zephir_is_iterable(&reflectionData, 0, "phalcon/Annotations/Collection.zep", 58);
	if (Z_TYPE_P(&reflectionData) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&reflectionData), _0)
		{
			ZEPHIR_INIT_NVAR(&annotationData);
			ZVAL_COPY(&annotationData, _0);
			ZEPHIR_INIT_NVAR(&_2$$3);
			object_init_ex(&_2$$3, phalcon_annotations_annotation_ce);
			ZEPHIR_CALL_METHOD(NULL, &_2$$3, "__construct", &_3, 158, &annotationData);
			zephir_check_call_status();
			zephir_array_append(&annotations, &_2$$3, PH_SEPARATE, "phalcon/Annotations/Collection.zep", 55);
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &reflectionData, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_1, &reflectionData, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_1)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&annotationData, &reflectionData, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_INIT_NVAR(&_4$$4);
				object_init_ex(&_4$$4, phalcon_annotations_annotation_ce);
				ZEPHIR_CALL_METHOD(NULL, &_4$$4, "__construct", &_3, 158, &annotationData);
				zephir_check_call_status();
				zephir_array_append(&annotations, &_4$$4, PH_SEPARATE, "phalcon/Annotations/Collection.zep", 55);
			ZEPHIR_CALL_METHOD(NULL, &reflectionData, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&annotationData);
	zephir_update_property_zval(this_ptr, ZEND_STRL("annotations"), &annotations);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_Collection, count)
{
	zval _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	RETURN_LONG(zephir_fast_count_int(&_0));
}

static PHP_METHOD(Phalcon_Annotations_Collection, current)
{
	zval annotation, _0, _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&annotation);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&annotation);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("position"), PH_NOISY_CC | PH_READONLY);
	if (!(zephir_array_isset_fetch(&annotation, &_0, &_1, 0))) {
		RETURN_MM_BOOL(0);
	}
	RETURN_CCTOR(&annotation);
}

static PHP_METHOD(Phalcon_Annotations_Collection, get)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *name_param = NULL, annotation, annotations, _0, *_1, _2, _5, _3$$3, _4$$5;
	zval name, _6;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&annotation);
	ZVAL_UNDEF(&annotations);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$5);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	zephir_get_strval(&name, name_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&annotations, &_0);
	zephir_is_iterable(&annotations, 0, "phalcon/Annotations/Collection.zep", 98);
	if (Z_TYPE_P(&annotations) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&annotations), _1)
		{
			ZEPHIR_INIT_NVAR(&annotation);
			ZVAL_COPY(&annotation, _1);
			ZEPHIR_CALL_METHOD(&_3$$3, &annotation, "getname", NULL, 0);
			zephir_check_call_status();
			if (ZEPHIR_IS_EQUAL(&name, &_3$$3)) {
				RETURN_CCTOR(&annotation);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &annotations, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &annotations, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&annotation, &annotations, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_4$$5, &annotation, "getname", NULL, 0);
				zephir_check_call_status();
				if (ZEPHIR_IS_EQUAL(&name, &_4$$5)) {
					RETURN_CCTOR(&annotation);
				}
			ZEPHIR_CALL_METHOD(NULL, &annotations, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&annotation);
	ZEPHIR_INIT_VAR(&_5);
	object_init_ex(&_5, phalcon_annotations_exception_ce);
	ZEPHIR_INIT_VAR(&_6);
	ZEPHIR_CONCAT_SVS(&_6, "Collection doesn't have an annotation called '", &name, "'");
	ZEPHIR_CALL_METHOD(NULL, &_5, "__construct", NULL, 33, &_6);
	zephir_check_call_status();
	zephir_throw_exception_debug(&_5, "phalcon/Annotations/Collection.zep", 100);
	ZEPHIR_MM_RESTORE();
	return;
}

static PHP_METHOD(Phalcon_Annotations_Collection, getAll)
{
	zval found;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *name_param = NULL, annotations, annotation, _0, *_1, _2, _3$$3, _4$$5;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&annotations);
	ZVAL_UNDEF(&annotation);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$5);
	ZVAL_UNDEF(&found);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	zephir_get_strval(&name, name_param);
	ZEPHIR_INIT_VAR(&found);
	array_init(&found);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&annotations, &_0);
	zephir_is_iterable(&annotations, 0, "phalcon/Annotations/Collection.zep", 120);
	if (Z_TYPE_P(&annotations) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&annotations), _1)
		{
			ZEPHIR_INIT_NVAR(&annotation);
			ZVAL_COPY(&annotation, _1);
			ZEPHIR_CALL_METHOD(&_3$$3, &annotation, "getname", NULL, 0);
			zephir_check_call_status();
			if (ZEPHIR_IS_EQUAL(&name, &_3$$3)) {
				zephir_array_append(&found, &annotation, PH_SEPARATE, "phalcon/Annotations/Collection.zep", 116);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &annotations, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &annotations, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&annotation, &annotations, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_4$$5, &annotation, "getname", NULL, 0);
				zephir_check_call_status();
				if (ZEPHIR_IS_EQUAL(&name, &_4$$5)) {
					zephir_array_append(&found, &annotation, PH_SEPARATE, "phalcon/Annotations/Collection.zep", 116);
				}
			ZEPHIR_CALL_METHOD(NULL, &annotations, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&annotation);
	RETURN_CTOR(&found);
}

static PHP_METHOD(Phalcon_Annotations_Collection, getAnnotations)
{

	RETURN_MEMBER(getThis(), "annotations");
}

static PHP_METHOD(Phalcon_Annotations_Collection, has)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *name_param = NULL, annotations, annotation, _0, *_1, _2, _3$$3, _4$$5;
	zval name;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&name);
	ZVAL_UNDEF(&annotations);
	ZVAL_UNDEF(&annotation);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$5);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(name)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &name_param);
	zephir_get_strval(&name, name_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&annotations, &_0);
	zephir_is_iterable(&annotations, 0, "phalcon/Annotations/Collection.zep", 146);
	if (Z_TYPE_P(&annotations) == IS_ARRAY) {
		ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&annotations), _1)
		{
			ZEPHIR_INIT_NVAR(&annotation);
			ZVAL_COPY(&annotation, _1);
			ZEPHIR_CALL_METHOD(&_3$$3, &annotation, "getname", NULL, 0);
			zephir_check_call_status();
			if (ZEPHIR_IS_EQUAL(&name, &_3$$3)) {
				RETURN_MM_BOOL(1);
			}
		} ZEND_HASH_FOREACH_END();
	} else {
		ZEPHIR_CALL_METHOD(NULL, &annotations, "rewind", NULL, 0);
		zephir_check_call_status();
		while (1) {
			ZEPHIR_CALL_METHOD(&_2, &annotations, "valid", NULL, 0);
			zephir_check_call_status();
			if (!zend_is_true(&_2)) {
				break;
			}
			ZEPHIR_CALL_METHOD(&annotation, &annotations, "current", NULL, 0);
			zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&_4$$5, &annotation, "getname", NULL, 0);
				zephir_check_call_status();
				if (ZEPHIR_IS_EQUAL(&name, &_4$$5)) {
					RETURN_MM_BOOL(1);
				}
			ZEPHIR_CALL_METHOD(NULL, &annotations, "next", NULL, 0);
			zephir_check_call_status();
		}
	}
	ZEPHIR_INIT_NVAR(&annotation);
	RETURN_MM_BOOL(0);
}

static PHP_METHOD(Phalcon_Annotations_Collection, key)
{

	RETURN_MEMBER(getThis(), "position");
}

static PHP_METHOD(Phalcon_Annotations_Collection, next)
{
	zval *this_ptr = getThis();
	RETURN_ON_FAILURE(zephir_property_incr(this_ptr, SL("position")));
}

static PHP_METHOD(Phalcon_Annotations_Collection, rewind)
{
	zval _0;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_0);
	ZVAL_LONG(&_0, 0);
	zephir_update_property_zval(this_ptr, ZEND_STRL("position"), &_0);
}

static PHP_METHOD(Phalcon_Annotations_Collection, valid)
{
	zval _0, _1;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("position"), PH_NOISY_CC | PH_READONLY);
	RETURN_BOOL(zephir_array_isset(&_0, &_1));
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Exception)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Annotations, Exception, phalcon, annotations_exception, zend_ce_exception, NULL, 0);

	return SUCCESS;
}



/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
// 18 "parser.php.lemon"


// 12 "parser.php.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    AACODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    AANOCODE           is a number of type AACODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    AAFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    AAACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    phannot_TOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    AAMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is phannot_TOKENTYPE.  The entry in the union
**                       for base tokens is called "aa0".
**    AASTACKDEPTH       is the maximum depth of the parser's stack.
**    phannot_ARG_SDECL     A static variable declaration for the %extra_argument
**    phannot_ARG_PDECL     A parameter declaration for the %extra_argument
**    phannot_ARG_STORE     Code to store %extra_argument into aapParser
**    phannot_ARG_FETCH     Code to extract %extra_argument from aapParser
**    AANSTATE           the combined number of states.
**    AANRULE            the number of rules in the grammar
**    AAERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define AACODETYPE unsigned char
#define AANOCODE 28
#define AAACTIONTYPE unsigned char
#define phannot_TOKENTYPE phannot_parser_token*
typedef union {
  phannot_TOKENTYPE aa0;
  zval aa8;
  int aa55;
} AAMINORTYPE;
#define AASTACKDEPTH 100
#define phannot_ARG_SDECL phannot_parser_status *status;
#define phannot_ARG_PDECL ,phannot_parser_status *status
#define phannot_ARG_FETCH phannot_parser_status *status = aapParser->status
#define phannot_ARG_STORE aapParser->status = status
#define AANSTATE 40
#define AANRULE 25
#define AAERRORSYMBOL 18
#define AAERRSYMDT aa55
#define AA_NO_ACTION      (AANSTATE+AANRULE+2)
#define AA_ACCEPT_ACTION  (AANSTATE+AANRULE+1)
#define AA_ERROR_ACTION   (AANSTATE+AANRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < AANSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   AANSTATE <= N < AANSTATE+AANRULE   Reduce by rule N-AANSTATE.
**
**   N == AANSTATE+AANRULE              A syntax error has occurred.
**
**   N == AANSTATE+AANRULE+1            The parser accepts its input.
**
**   N == AANSTATE+AANRULE+2            No such action.  Denotes unused
**                                      slots in the aa_action[] table.
**
** The action table is constructed as a single large table named aa_action[].
** Given state S and lookahead X, the action is computed as
**
**      aa_action[ aa_shift_ofst[S] + X ]
**
** If the index value aa_shift_ofst[S]+X is out of range or if the value
** aa_lookahead[aa_shift_ofst[S]+X] is not equal to X or if aa_shift_ofst[S]
** is equal to AA_SHIFT_USE_DFLT, it means that the action is not in the table
** and that aa_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the aa_reduce_ofst[] array is used in place of
** the aa_shift_ofst[] array and AA_REDUCE_USE_DFLT is used in place of
** AA_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  aa_action[]        A single table containing all actions.
**  aa_lookahead[]     A table containing the lookahead for each entry in
**                     aa_action.  Used to detect hash collisions.
**  aa_shift_ofst[]    For each state, the offset into aa_action for
**                     shifting terminals.
**  aa_reduce_ofst[]   For each state, the offset into aa_action for
**                     shifting non-terminals after a reduce.
**  aa_default[]       Default action for each state.
*/
static AAACTIONTYPE aa_action[] = {
 /*     0 */     4,   28,   15,   38,   12,   14,   16,   18,   20,   21,
 /*    10 */    22,   23,   24,    4,   31,    4,   28,   15,   40,   12,
 /*    20 */    30,   16,   18,   20,   21,   22,   23,   24,    3,   31,
 /*    30 */     4,   17,   15,    6,   19,   35,   16,   18,   20,   21,
 /*    40 */    22,   23,   24,    5,   31,   15,    7,   27,   11,   16,
 /*    50 */    54,   54,   15,   25,   27,   11,   16,   15,   32,   27,
 /*    60 */    11,   16,   66,    1,    2,   39,   41,   15,    4,   10,
 /*    70 */    11,   16,   15,    9,    9,   37,   16,    8,   13,   36,
 /*    80 */     9,   29,   34,   54,   54,   54,   54,   54,   26,   54,
 /*    90 */    54,   54,   54,   54,   54,   54,   33,
};
static AACODETYPE aa_lookahead[] = {
 /*     0 */     2,    3,   22,    5,    6,   25,   26,    9,   10,   11,
 /*    10 */    12,   13,   14,    2,   16,    2,    3,   22,    0,    6,
 /*    20 */    25,   26,    9,   10,   11,   12,   13,   14,   22,   16,
 /*    30 */     2,    3,   22,    4,    6,   25,   26,    9,   10,   11,
 /*    40 */    12,   13,   14,    3,   16,   22,   23,   24,   25,   26,
 /*    50 */    27,   27,   22,   23,   24,   25,   26,   22,   23,   24,
 /*    60 */    25,   26,   19,   20,   21,   22,    0,   22,    2,   24,
 /*    70 */    25,   26,   22,    1,    1,   25,   26,    5,    7,    8,
 /*    80 */     1,    7,    8,   27,   27,   27,   27,   27,   15,   27,
 /*    90 */    27,   27,   27,   27,   27,   27,   17,
};
#define AA_SHIFT_USE_DFLT (-3)
static signed char aa_shift_ofst[] = {
 /*     0 */    11,   18,   66,   -3,   40,   29,   -2,   72,   -3,   13,
 /*    10 */    -3,   -3,   71,   28,   -3,   -3,   -3,   -3,   -3,   -3,
 /*    20 */    -3,   -3,   -3,   -3,   13,   73,   -3,   -3,   74,   28,
 /*    30 */    -3,   13,   79,   -3,   28,   -3,   28,   -3,   -3,   -3,
};
#define AA_REDUCE_USE_DFLT (-21)
static signed char aa_reduce_ofst[] = {
 /*     0 */    43,  -21,    6,  -21,  -21,  -21,   23,  -21,  -21,   45,
 /*    10 */   -21,  -21,  -21,  -20,  -21,  -21,  -21,  -21,  -21,  -21,
 /*    20 */   -21,  -21,  -21,  -21,   30,  -21,  -21,  -21,  -21,   -5,
 /*    30 */   -21,   35,  -21,  -21,   10,  -21,   50,  -21,  -21,  -21,
};
static AAACTIONTYPE aa_default[] = {
 /*     0 */    65,   65,   65,   42,   65,   46,   65,   65,   44,   65,
 /*    10 */    47,   49,   58,   65,   50,   54,   55,   56,   57,   58,
 /*    20 */    59,   60,   61,   62,   65,   65,   63,   48,   56,   65,
 /*    30 */    52,   65,   65,   64,   65,   53,   65,   51,   45,   43,
};
#define AA_SZ_ACTTAB (sizeof(aa_action)/sizeof(aa_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef AAFALLBACK
static const AACODETYPE aaFallback[] = {
};
#endif /* AAFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct aaStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  AAMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct aaStackEntry aaStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct aaParser {
  int aaidx;                    /* Index of top element in stack */
  int aaerrcnt;                 /* Shifts left before out of the error */
  phannot_ARG_SDECL                /* A place to hold %extra_argument */
  aaStackEntry aastack[AASTACKDEPTH];  /* The parser's stack */
};
typedef struct aaParser aaParser;

#ifndef NDEBUG
static FILE *aaTraceFILE = 0;
static char *aaTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
static void phannot_Trace(FILE *TraceFILE, char *zTracePrompt){
  aaTraceFILE = TraceFILE;
  aaTracePrompt = zTracePrompt;
  if( aaTraceFILE==0 ) aaTracePrompt = 0;
  else if( aaTracePrompt==0 ) aaTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *aaTokenName[] = {
  "$",             "COMMA",         "AT",            "IDENTIFIER",
  "PARENTHESES_OPEN",  "PARENTHESES_CLOSE",  "STRING",        "EQUALS",
  "COLON",         "INTEGER",       "DOUBLE",        "NULL",
  "FALSE",         "TRUE",          "BRACKET_OPEN",  "BRACKET_CLOSE",
  "SBRACKET_OPEN",  "SBRACKET_CLOSE",  "error",         "program",
  "annotation_language",  "annotation_list",  "annotation",    "argument_list",
  "argument_item",  "expr",          "array",
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *aaRuleName[] = {
 /*   0 */ "program ::= annotation_language",
 /*   1 */ "annotation_language ::= annotation_list",
 /*   2 */ "annotation_list ::= annotation_list annotation",
 /*   3 */ "annotation_list ::= annotation",
 /*   4 */ "annotation ::= AT IDENTIFIER PARENTHESES_OPEN argument_list PARENTHESES_CLOSE",
 /*   5 */ "annotation ::= AT IDENTIFIER PARENTHESES_OPEN PARENTHESES_CLOSE",
 /*   6 */ "annotation ::= AT IDENTIFIER",
 /*   7 */ "argument_list ::= argument_list COMMA argument_item",
 /*   8 */ "argument_list ::= argument_item",
 /*   9 */ "argument_item ::= expr",
 /*  10 */ "argument_item ::= STRING EQUALS expr",
 /*  11 */ "argument_item ::= STRING COLON expr",
 /*  12 */ "argument_item ::= IDENTIFIER EQUALS expr",
 /*  13 */ "argument_item ::= IDENTIFIER COLON expr",
 /*  14 */ "expr ::= annotation",
 /*  15 */ "expr ::= array",
 /*  16 */ "expr ::= IDENTIFIER",
 /*  17 */ "expr ::= INTEGER",
 /*  18 */ "expr ::= STRING",
 /*  19 */ "expr ::= DOUBLE",
 /*  20 */ "expr ::= NULL",
 /*  21 */ "expr ::= FALSE",
 /*  22 */ "expr ::= TRUE",
 /*  23 */ "array ::= BRACKET_OPEN argument_list BRACKET_CLOSE",
 /*  24 */ "array ::= SBRACKET_OPEN argument_list SBRACKET_CLOSE",
};
#endif /* NDEBUG */

const char *phannot_TokenName(int tokenType){
#ifndef NDEBUG
  if( tokenType>0 && tokenType<(sizeof(aaTokenName)/sizeof(aaTokenName[0])) ){
    return aaTokenName[tokenType];
  }else{
    return "Unknown";
  }
#else
  return "";
#endif
}

void *phannot_Alloc(void *(*mallocProc)(size_t)){
  aaParser *pParser;
  pParser = (aaParser*)(*mallocProc)( (size_t)sizeof(aaParser) );
  if( pParser ){
    pParser->aaidx = -1;
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "aamajor" is the symbol code, and "aapminor" is a pointer to
** the value.
*/
static void aa_destructor(AACODETYPE aamajor, AAMINORTYPE *aapminor){
  switch( aamajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
// 67 "parser.php.lemon"
{
	if ((aapminor->aa0)) {
		if ((aapminor->aa0)->free_flag) {
			efree((aapminor->aa0)->token);
		}
		efree((aapminor->aa0));
	}
}
// 380 "parser.php.c"
      break;
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
// 80 "parser.php.lemon"
{
    zval_ptr_dtor(&(aapminor->aa8));
}
// 392 "parser.php.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

static int aa_pop_parser_stack(aaParser *pParser){
  AACODETYPE aamajor;
  aaStackEntry *aatos = &pParser->aastack[pParser->aaidx];

  if( pParser->aaidx<0 ) return 0;
#ifndef NDEBUG
  if( aaTraceFILE && pParser->aaidx>=0 ){
    fprintf(aaTraceFILE,"%sPopping %s\n",
      aaTracePrompt,
      aaTokenName[aatos->major]);
  }
#endif
  aamajor = aatos->major;
  aa_destructor( aamajor, &aatos->minor);
  pParser->aaidx--;
  return aamajor;
}

static void phannot_Free(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  aaParser *pParser = (aaParser*)p;
  if( pParser==0 ) return;
  while( pParser->aaidx>=0 ) aa_pop_parser_stack(pParser);
  (*freeProc)((void*)pParser);
}

static int aa_find_shift_action(
  aaParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->aastack[pParser->aaidx].stateno;

  /* if( pParser->aaidx<0 ) return AA_NO_ACTION;  */
  i = aa_shift_ofst[stateno];
  if( i==AA_SHIFT_USE_DFLT ){
    return aa_default[stateno];
  }
  if( iLookAhead==AANOCODE ){
    return AA_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=AA_SZ_ACTTAB || aa_lookahead[i]!=iLookAhead ){
#ifdef AAFALLBACK
    int iFallback;            /* Fallback token */
    if( iLookAhead<sizeof(aaFallback)/sizeof(aaFallback[0])
           && (iFallback = aaFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
      if( aaTraceFILE ){
        fprintf(aaTraceFILE, "%sFALLBACK %s => %s\n",
           aaTracePrompt, aaTokenName[iLookAhead], aaTokenName[iFallback]);
      }
#endif
      return aa_find_shift_action(pParser, iFallback);
    }
#endif
    return aa_default[stateno];
  }else{
    return aa_action[i];
  }
}

static int aa_find_reduce_action(
  aaParser *pParser,        /* The parser */
  int iLookAhead            /* The look-ahead token */
){
  int i;
  int stateno = pParser->aastack[pParser->aaidx].stateno;

  i = aa_reduce_ofst[stateno];
  if( i==AA_REDUCE_USE_DFLT ){
    return aa_default[stateno];
  }
  if( iLookAhead==AANOCODE ){
    return AA_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=AA_SZ_ACTTAB || aa_lookahead[i]!=iLookAhead ){
    return aa_default[stateno];
  }else{
    return aa_action[i];
  }
}

static void aa_shift(
  aaParser *aapParser,          /* The parser to be shifted */
  int aaNewState,               /* The new state to shift in */
  int aaMajor,                  /* The major token to shift in */
  AAMINORTYPE *aapMinor         /* Pointer ot the minor token to shift in */
){
  aaStackEntry *aatos;
  aapParser->aaidx++;
  if( aapParser->aaidx>=AASTACKDEPTH ){
     phannot_ARG_FETCH;
     aapParser->aaidx--;
#ifndef NDEBUG
     if( aaTraceFILE ){
       fprintf(aaTraceFILE,"%sStack Overflow!\n",aaTracePrompt);
     }
#endif
     while( aapParser->aaidx>=0 ) aa_pop_parser_stack(aapParser);
     /* Here code is inserted which will execute if the parser
     ** stack every overflows */
     phannot_ARG_STORE; /* Suppress warning about unused %extra_argument var */
     return;
  }
  aatos = &aapParser->aastack[aapParser->aaidx];
  aatos->stateno = aaNewState;
  aatos->major = aaMajor;
  aatos->minor = *aapMinor;
#ifndef NDEBUG
  if( aaTraceFILE && aapParser->aaidx>0 ){
    int i;
    fprintf(aaTraceFILE,"%sShift %d\n",aaTracePrompt,aaNewState);
    fprintf(aaTraceFILE,"%sStack:",aaTracePrompt);
    for(i=1; i<=aapParser->aaidx; i++)
      fprintf(aaTraceFILE," %s",aaTokenName[aapParser->aastack[i].major]);
    fprintf(aaTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static struct {
  AACODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} aaRuleInfo[] = {
  { 19, 1 },
  { 20, 1 },
  { 21, 2 },
  { 21, 1 },
  { 22, 5 },
  { 22, 4 },
  { 22, 2 },
  { 23, 3 },
  { 23, 1 },
  { 24, 1 },
  { 24, 3 },
  { 24, 3 },
  { 24, 3 },
  { 24, 3 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 25, 1 },
  { 26, 3 },
  { 26, 3 },
};

static void aa_accept(aaParser*);  /* Forward Declaration */

static void aa_reduce(
  aaParser *aapParser,         /* The parser */
  int aaruleno                 /* Number of the rule by which to reduce */
){
  int aagoto;                     /* The next state */
  int aaact;                      /* The next action */
  AAMINORTYPE aagotominor;        /* The LHS of the rule reduced */
  aaStackEntry *aamsp;            /* The top of the parser's stack */
  int aasize;                     /* Amount to pop the stack */
  phannot_ARG_FETCH;
  aamsp = &aapParser->aastack[aapParser->aaidx];
#ifndef NDEBUG
  if( aaTraceFILE && aaruleno>=0
        && aaruleno<sizeof(aaRuleName)/sizeof(aaRuleName[0]) ){
    fprintf(aaTraceFILE, "%sReduce [%s].\n", aaTracePrompt,
      aaRuleName[aaruleno]);
  }
#endif /* NDEBUG */

  switch( aaruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  // <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  // <lineno> <thisfile>
  **     break;
  */
      case 0:
// 76 "parser.php.lemon"
{
	ZVAL_ZVAL(&status->ret, &aamsp[0].minor.aa8, 1, 1);
}
// 634 "parser.php.c"
        break;
      case 1:
      case 14:
      case 15:
// 84 "parser.php.lemon"
{
	aagotominor.aa8 = aamsp[0].minor.aa8;
}
// 643 "parser.php.c"
        break;
      case 2:
// 92 "parser.php.lemon"
{
	phannot_ret_zval_list(&aagotominor.aa8, &aamsp[-1].minor.aa8, &aamsp[0].minor.aa8);
}
// 650 "parser.php.c"
        break;
      case 3:
      case 8:
// 96 "parser.php.lemon"
{
	phannot_ret_zval_list(&aagotominor.aa8, NULL, &aamsp[0].minor.aa8);
}
// 658 "parser.php.c"
        break;
      case 4:
// 104 "parser.php.lemon"
{
	phannot_ret_annotation(&aagotominor.aa8, aamsp[-3].minor.aa0, &aamsp[-1].minor.aa8, status->scanner_state);
  aa_destructor(2,&aamsp[-4].minor);
  aa_destructor(4,&aamsp[-2].minor);
  aa_destructor(5,&aamsp[0].minor);
}
// 668 "parser.php.c"
        break;
      case 5:
// 108 "parser.php.lemon"
{
	phannot_ret_annotation(&aagotominor.aa8, aamsp[-2].minor.aa0, NULL, status->scanner_state);
  aa_destructor(2,&aamsp[-3].minor);
  aa_destructor(4,&aamsp[-1].minor);
  aa_destructor(5,&aamsp[0].minor);
}
// 678 "parser.php.c"
        break;
      case 6:
// 112 "parser.php.lemon"
{
	phannot_ret_annotation(&aagotominor.aa8, aamsp[0].minor.aa0, NULL, status->scanner_state);
  aa_destructor(2,&aamsp[-1].minor);
}
// 686 "parser.php.c"
        break;
      case 7:
// 120 "parser.php.lemon"
{
	phannot_ret_zval_list(&aagotominor.aa8, &aamsp[-2].minor.aa8, &aamsp[0].minor.aa8);
  aa_destructor(1,&aamsp[-1].minor);
}
// 694 "parser.php.c"
        break;
      case 9:
// 132 "parser.php.lemon"
{
	phannot_ret_named_item(&aagotominor.aa8, NULL, &aamsp[0].minor.aa8);
}
// 701 "parser.php.c"
        break;
      case 10:
      case 12:
// 136 "parser.php.lemon"
{
	phannot_ret_named_item(&aagotominor.aa8, aamsp[-2].minor.aa0, &aamsp[0].minor.aa8);
  aa_destructor(7,&aamsp[-1].minor);
}
// 710 "parser.php.c"
        break;
      case 11:
      case 13:
// 140 "parser.php.lemon"
{
	phannot_ret_named_item(&aagotominor.aa8, aamsp[-2].minor.aa0, &aamsp[0].minor.aa8);
  aa_destructor(8,&aamsp[-1].minor);
}
// 719 "parser.php.c"
        break;
      case 16:
// 164 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_IDENTIFIER, aamsp[0].minor.aa0);
}
// 726 "parser.php.c"
        break;
      case 17:
// 168 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_INTEGER, aamsp[0].minor.aa0);
}
// 733 "parser.php.c"
        break;
      case 18:
// 172 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_STRING, aamsp[0].minor.aa0);
}
// 740 "parser.php.c"
        break;
      case 19:
// 176 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_DOUBLE, aamsp[0].minor.aa0);
}
// 747 "parser.php.c"
        break;
      case 20:
// 180 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_NULL, NULL);
  aa_destructor(11,&aamsp[0].minor);
}
// 755 "parser.php.c"
        break;
      case 21:
// 184 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_FALSE, NULL);
  aa_destructor(12,&aamsp[0].minor);
}
// 763 "parser.php.c"
        break;
      case 22:
// 188 "parser.php.lemon"
{
	phannot_ret_literal_zval(&aagotominor.aa8, PHANNOT_T_TRUE, NULL);
  aa_destructor(13,&aamsp[0].minor);
}
// 771 "parser.php.c"
        break;
      case 23:
// 192 "parser.php.lemon"
{
	phannot_ret_array(&aagotominor.aa8, &aamsp[-1].minor.aa8);
  aa_destructor(14,&aamsp[-2].minor);
  aa_destructor(15,&aamsp[0].minor);
}
// 780 "parser.php.c"
        break;
      case 24:
// 196 "parser.php.lemon"
{
	phannot_ret_array(&aagotominor.aa8, &aamsp[-1].minor.aa8);
  aa_destructor(16,&aamsp[-2].minor);
  aa_destructor(17,&aamsp[0].minor);
}
// 789 "parser.php.c"
        break;
  };
  aagoto = aaRuleInfo[aaruleno].lhs;
  aasize = aaRuleInfo[aaruleno].nrhs;
  aapParser->aaidx -= aasize;
  aaact = aa_find_reduce_action(aapParser,aagoto);
  if( aaact < AANSTATE ){
    aa_shift(aapParser,aaact,aagoto,&aagotominor);
  }else if( aaact == AANSTATE + AANRULE + 1 ){
    aa_accept(aapParser);
  }
}

static void aa_parse_failed(
  aaParser *aapParser           /* The parser */
){
  phannot_ARG_FETCH;
#ifndef NDEBUG
  if( aaTraceFILE ){
    fprintf(aaTraceFILE,"%sFail!\n",aaTracePrompt);
  }
#endif
  while( aapParser->aaidx>=0 ) aa_pop_parser_stack(aapParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  phannot_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

static void aa_syntax_error(
  aaParser *aapParser,           /* The parser */
  int aamajor,                   /* The major type of the error token */
  AAMINORTYPE aaminor            /* The minor type of the error token */
){
  phannot_ARG_FETCH;
#define ATOKEN (aaminor.aa0)
// 22 "parser.php.lemon"

	if (status->scanner_state->start_length) {
		char *token_name = NULL;
		const phannot_token_names *tokens = phannot_tokens;
		int active_token = status->scanner_state->active_token;
		unsigned int near_length = status->scanner_state->start_length;

		if (active_token) {
			do {
				if (tokens->code == active_token) {
					token_name = tokens->name;
					break;
				}
				++tokens;
			} while (tokens[0].code != 0);
		}

		if (!token_name) {
			token_name  = "UNKNOWN";
		}

		if (near_length > 0) {
			if (status->token->value) {
				spprintf(&status->syntax_error, 0, "Syntax error, unexpected token %s(%s), near to '%s' in %s on line %d", token_name, status->token->value, status->scanner_state->start, status->scanner_state->active_file, status->scanner_state->active_line);
			} else {
				spprintf(&status->syntax_error, 0, "Syntax error, unexpected token %s, near to '%s' in %s on line %d", token_name, status->scanner_state->start, status->scanner_state->active_file, status->scanner_state->active_line);
			}
		} else {
			if (active_token != PHANNOT_T_IGNORE) {
				if (status->token->value) {
					spprintf(&status->syntax_error, 0, "Syntax error, unexpected token %s(%s), at the end of docblock in %s on line %d", token_name, status->token->value, status->scanner_state->active_file, status->scanner_state->active_line);
				} else {
					spprintf(&status->syntax_error, 0, "Syntax error, unexpected token %s, at the end of docblock in %s on line %d", token_name, status->scanner_state->active_file, status->scanner_state->active_line);
				}
			} else {
				spprintf(&status->syntax_error, 0, "Syntax error, unexpected EOF, at the end of docblock in %s on line %d", status->scanner_state->active_file, status->scanner_state->active_line);
			}
		}
	} else {
		spprintf(&status->syntax_error, 0, "Syntax error, unexpected EOF in %s", status->scanner_state->active_file);
	}

	status->status = PHANNOT_PARSING_FAILED;

// 876 "parser.php.c"
  phannot_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

static void aa_accept(
  aaParser *aapParser           /* The parser */
){
  phannot_ARG_FETCH;
#ifndef NDEBUG
  if( aaTraceFILE ){
    fprintf(aaTraceFILE,"%sAccept!\n",aaTracePrompt);
  }
#endif
  while( aapParser->aaidx>=0 ) aa_pop_parser_stack(aapParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  phannot_ARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "phannot_Alloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
static void phannot_(
  void *aap,                   /* The parser */
  int aamajor,                 /* The major token code number */
  phannot_TOKENTYPE aaminor       /* The value for the token */
  phannot_ARG_PDECL               /* Optional %extra_argument parameter */
){
  AAMINORTYPE aaminorunion;
  int aaact;            /* The parser action. */
  int aaendofinput;     /* True if we are at the end of input */
  int aaerrorhit = 0;   /* True if aamajor has invoked an error */
  aaParser *aapParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  aapParser = (aaParser*)aap;
  if( aapParser->aaidx<0 ){
    if( aamajor==0 ) return;
    aapParser->aaidx = 0;
    aapParser->aaerrcnt = -1;
    aapParser->aastack[0].stateno = 0;
    aapParser->aastack[0].major = 0;
  }
  aaminorunion.aa0 = aaminor;
  aaendofinput = (aamajor==0);
  phannot_ARG_STORE;

#ifndef NDEBUG
  if( aaTraceFILE ){
    fprintf(aaTraceFILE,"%sInput %s\n",aaTracePrompt,aaTokenName[aamajor]);
  }
#endif

  do{
    aaact = aa_find_shift_action(aapParser,aamajor);
    if( aaact<AANSTATE ){
      aa_shift(aapParser,aaact,aamajor,&aaminorunion);
      aapParser->aaerrcnt--;
      if( aaendofinput && aapParser->aaidx>=0 ){
        aamajor = 0;
      }else{
        aamajor = AANOCODE;
      }
    }else if( aaact < AANSTATE + AANRULE ){
      aa_reduce(aapParser,aaact-AANSTATE);
    }else if( aaact == AA_ERROR_ACTION ){
      int aamx;
#ifndef NDEBUG
      if( aaTraceFILE ){
        fprintf(aaTraceFILE,"%sSyntax Error!\n",aaTracePrompt);
      }
#endif
#ifdef AAERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( aapParser->aaerrcnt<0 ){
        aa_syntax_error(aapParser,aamajor,aaminorunion);
      }
      aamx = aapParser->aastack[aapParser->aaidx].major;
      if( aamx==AAERRORSYMBOL || aaerrorhit ){
#ifndef NDEBUG
        if( aaTraceFILE ){
          fprintf(aaTraceFILE,"%sDiscard input token %s\n",
             aaTracePrompt,aaTokenName[aamajor]);
        }
#endif
        aa_destructor(aamajor,&aaminorunion);
        aamajor = AANOCODE;
      }else{
         while(
          aapParser->aaidx >= 0 &&
          aamx != AAERRORSYMBOL &&
          (aaact = aa_find_shift_action(aapParser,AAERRORSYMBOL)) >= AANSTATE
        ){
          aa_pop_parser_stack(aapParser);
        }
        if( aapParser->aaidx < 0 || aamajor==0 ){
          aa_destructor(aamajor,&aaminorunion);
          aa_parse_failed(aapParser);
          aamajor = AANOCODE;
        }else if( aamx!=AAERRORSYMBOL ){
          AAMINORTYPE u2;
          u2.AAERRSYMDT = 0;
          aa_shift(aapParser,aaact,AAERRORSYMBOL,&u2);
        }
      }
      aapParser->aaerrcnt = 3;
      aaerrorhit = 1;
#else  /* AAERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( aapParser->aaerrcnt<=0 ){
        aa_syntax_error(aapParser,aamajor,aaminorunion);
      }
      aapParser->aaerrcnt = 3;
      aa_destructor(aamajor,&aaminorunion);
      if( aaendofinput ){
        aa_parse_failed(aapParser);
      }
      aamajor = AANOCODE;
#endif
    }else{
      aa_accept(aapParser);
      aamajor = AANOCODE;
    }
  }while( aamajor!=AANOCODE && aapParser->aaidx>=0 );
  return;
}
/* base.c
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */

const phannot_token_names phannot_tokens[] =
{
	{ "INTEGER",        PHANNOT_T_INTEGER },
	{ "DOUBLE",         PHANNOT_T_DOUBLE },
	{ "STRING",         PHANNOT_T_STRING },
	{ "IDENTIFIER",     PHANNOT_T_IDENTIFIER },
	{ "@",              PHANNOT_T_AT },
	{ ",",              PHANNOT_T_COMMA },
	{ "=",              PHANNOT_T_EQUALS },
	{ ":",              PHANNOT_T_COLON },
	{ "(",              PHANNOT_T_PARENTHESES_OPEN },
	{ ")",              PHANNOT_T_PARENTHESES_CLOSE },
	{ "{",              PHANNOT_T_BRACKET_OPEN },
	{ "}",              PHANNOT_T_BRACKET_CLOSE },
 	{ "[",              PHANNOT_T_SBRACKET_OPEN },
	{ "]",              PHANNOT_T_SBRACKET_CLOSE },
	{ "ARBITRARY TEXT", PHANNOT_T_ARBITRARY_TEXT },
	{ NULL, 0 }
};

static void *phannot_wrapper_alloc(size_t bytes){
	return emalloc(bytes);
}

static void phannot_wrapper_free(void *pointer){
	efree(pointer);
}

static void phannot_parse_with_token(void* phannot_parser, int opcode, int parsercode, phannot_scanner_token *token, phannot_parser_status *parser_status){

	phannot_parser_token *pToken;

	pToken = emalloc(sizeof(phannot_parser_token));
	pToken->opcode = opcode;
	pToken->token = token->value;
	pToken->token_len = token->len;
	pToken->free_flag = 1;

	phannot_(phannot_parser, parsercode, pToken, parser_status);

	token->value = NULL;
	token->len = 0;
}

static void phannot_scanner_error_msg(phannot_parser_status *parser_status, char **error_msg){

	phannot_scanner_state *state = parser_status->scanner_state;

	if (state->start) {
		if (state->start_length > 16) {
			spprintf(error_msg, 0, "Scanning error before '%.16s...' in %s on line %d", state->start, state->active_file, state->active_line);
		} else {
			spprintf(error_msg, 0, "Scanning error before '%s' in %s on line %d", state->start, state->active_file, state->active_line);
		}
	} else {
		spprintf(error_msg, 0, "Scanning error near to EOF in %s", state->active_file);
	}
}

static int phannot_parse_annotations(zval *result, zval *comment, zval *file_path, zval *line) {

	char *comment_str;
	int comment_len;
	char *file_path_str;
	int line_num;

	char *error_msg = NULL;

	ZVAL_NULL(result);

	if (Z_TYPE_P(comment) == IS_STRING) {
		comment_str = Z_STRVAL_P(comment);
		comment_len = Z_STRLEN_P(comment);
	} else {
		comment_str = "";
		comment_len = 0;
	}

	if (Z_TYPE_P(file_path) == IS_STRING) {
		file_path_str = Z_STRVAL_P(file_path);
	} else {
		file_path_str = "eval";
	}

	if (Z_TYPE_P(line) == IS_LONG) {
		line_num = Z_LVAL_P(line);
	} else {
		line_num = 0;
	}

	if (phannot_internal_parse_annotations(&result, comment_str, comment_len, file_path_str, line_num, &error_msg) == FAILURE) {
		if (likely(error_msg != NULL)) {
			zephir_throw_exception_string(phalcon_annotations_exception_ce, error_msg, strlen(error_msg));
			efree(error_msg);
		} else {
			zephir_throw_exception_string(phalcon_annotations_exception_ce, SL("There was an error parsing annotation"));
		}

		return FAILURE;
	}

	return SUCCESS;
}

static void phannot_remove_comment_separators(char **ret, int *ret_len, const char *comment, int length, int *start_lines)
{
	char ch;
	int start_mode = 1, j, i, open_parentheses;
	smart_str processed_str = {0};

	(*start_lines) = 0;

	for (i = 0; i < length; i++) {

		ch = comment[i];

		if (start_mode) {
			if (ch == ' ' || ch == '*' || ch == '/' || ch == '\t' || ch == 11) {
				continue;
			}
			start_mode = 0;
		}

		if (ch == '@') {

			smart_str_appendc(&processed_str, ch);
			i++;

			open_parentheses = 0;
			for (j = i; j < length; j++) {

				ch = comment[j];

				if (start_mode) {
					if (ch == ' ' || ch == '*' || ch == '/' || ch == '\t' || ch == 11) {
						continue;
					}
					start_mode = 0;
				}

				if (open_parentheses == 0) {

					if (isalnum(ch) || '_' == ch || '\\' == ch) {
						smart_str_appendc(&processed_str, ch);
						continue;
					}

					if (ch == '(') {
						smart_str_appendc(&processed_str, ch);
						open_parentheses++;
						continue;
					}

				} else {

					smart_str_appendc(&processed_str, ch);

					if (ch == '(') {
						open_parentheses++;
					} else {
						if (ch == ')') {
							open_parentheses--;
						} else {
							if (ch == '\n') {
								(*start_lines)++;
								start_mode = 1;
							}
						}
					}

					if (open_parentheses > 0) {
						continue;
					}
				}

				i = j;
				smart_str_appendc(&processed_str, ' ');
				break;
			}
		}

		if (ch == '\n') {
			(*start_lines)++;
			start_mode = 1;
		}
	}

	smart_str_0(&processed_str);

	if (processed_str.s) {
		*ret     = estrndup(ZSTR_VAL(processed_str.s), ZSTR_LEN(processed_str.s));
		*ret_len = ZSTR_LEN(processed_str.s);
		smart_str_free(&processed_str);
	} else {
		*ret     = NULL;
		*ret_len = 0;
	}
}

static int phannot_internal_parse_annotations(zval **result, const char *comment, int comment_len, const char *file_path, int line, char **error_msg)
{
	phannot_scanner_state *state;
	phannot_scanner_token token;
	int start_lines;
	int scanner_status, status = SUCCESS;
	phannot_parser_status *parser_status = NULL;
	void* phannot_parser;
	char *processed_comment;
	int processed_comment_len;

	*error_msg = NULL;

	if (UNEXPECTED(!comment)) {
		ZVAL_BOOL(*result, 0);
		spprintf(error_msg, 0, "Empty annotation");
		return FAILURE;
	}

	if (comment_len < 2) {
		ZVAL_BOOL(*result, 0);
		return SUCCESS;
	}

	phannot_remove_comment_separators(&processed_comment, &processed_comment_len, comment, comment_len, &start_lines);

	if (processed_comment_len < 2) {
		ZVAL_BOOL(*result, 0);
		if (processed_comment) {
			efree(processed_comment);
		}

		return SUCCESS;
	}

	phannot_parser = phannot_Alloc(phannot_wrapper_alloc);
	if (unlikely(!phannot_parser)) {
		ZVAL_BOOL(*result, 0);
		return FAILURE;
	}

	parser_status = emalloc(sizeof(phannot_parser_status) + sizeof(phannot_scanner_state));
	state         = (phannot_scanner_state*)((char*)parser_status + sizeof(phannot_parser_status));

	parser_status->status = PHANNOT_PARSING_OK;
	parser_status->scanner_state = state;
	parser_status->token = &token;
	parser_status->syntax_error = NULL;

	state->active_token = 0;
	state->start = processed_comment;
	state->start_length = 0;
	state->mode = PHANNOT_MODE_RAW;
	state->active_file = file_path;

	token.value = NULL;
	token.len = 0;

	if (line) {
		state->active_line = line - start_lines;
	} else {
		state->active_line = 1;
	}

	state->end = state->start;

	while(0 <= (scanner_status = phannot_get_token(state, &token))) {

		state->active_token = token.opcode;

		state->start_length = processed_comment + processed_comment_len - state->start;

		switch (token.opcode) {

			case PHANNOT_T_IGNORE:
				break;

			case PHANNOT_T_AT:
				phannot_(phannot_parser, PHANNOT_AT, NULL, parser_status);
				break;
			case PHANNOT_T_COMMA:
				phannot_(phannot_parser, PHANNOT_COMMA, NULL, parser_status);
				break;
			case PHANNOT_T_EQUALS:
				phannot_(phannot_parser, PHANNOT_EQUALS, NULL, parser_status);
				break;
			case PHANNOT_T_COLON:
				phannot_(phannot_parser, PHANNOT_COLON, NULL, parser_status);
				break;

			case PHANNOT_T_PARENTHESES_OPEN:
				phannot_(phannot_parser, PHANNOT_PARENTHESES_OPEN, NULL, parser_status);
				break;
			case PHANNOT_T_PARENTHESES_CLOSE:
				phannot_(phannot_parser, PHANNOT_PARENTHESES_CLOSE, NULL, parser_status);
				break;

			case PHANNOT_T_BRACKET_OPEN:
				phannot_(phannot_parser, PHANNOT_BRACKET_OPEN, NULL, parser_status);
				break;
			case PHANNOT_T_BRACKET_CLOSE:
				phannot_(phannot_parser, PHANNOT_BRACKET_CLOSE, NULL, parser_status);
				break;

			case PHANNOT_T_SBRACKET_OPEN:
				phannot_(phannot_parser, PHANNOT_SBRACKET_OPEN, NULL, parser_status);
				break;
			case PHANNOT_T_SBRACKET_CLOSE:
				phannot_(phannot_parser, PHANNOT_SBRACKET_CLOSE, NULL, parser_status);
				break;

			case PHANNOT_T_NULL:
				phannot_(phannot_parser, PHANNOT_NULL, NULL, parser_status);
				break;
			case PHANNOT_T_TRUE:
				phannot_(phannot_parser, PHANNOT_TRUE, NULL, parser_status);
				break;
			case PHANNOT_T_FALSE:
				phannot_(phannot_parser, PHANNOT_FALSE, NULL, parser_status);
				break;

			case PHANNOT_T_INTEGER:
				phannot_parse_with_token(phannot_parser, PHANNOT_T_INTEGER, PHANNOT_INTEGER, &token, parser_status);
				break;
			case PHANNOT_T_DOUBLE:
				phannot_parse_with_token(phannot_parser, PHANNOT_T_DOUBLE, PHANNOT_DOUBLE, &token, parser_status);
				break;
			case PHANNOT_T_STRING:
				phannot_parse_with_token(phannot_parser, PHANNOT_T_STRING, PHANNOT_STRING, &token, parser_status);
				break;
			case PHANNOT_T_IDENTIFIER:
				phannot_parse_with_token(phannot_parser, PHANNOT_T_IDENTIFIER, PHANNOT_IDENTIFIER, &token, parser_status);
				break;
			/*case PHANNOT_T_ARBITRARY_TEXT:
				phannot_parse_with_token(phannot_parser, PHANNOT_T_ARBITRARY_TEXT, PHANNOT_ARBITRARY_TEXT, &token, parser_status);
				break;*/

			default:
				parser_status->status = PHANNOT_PARSING_FAILED;
				if (!*error_msg) {
					spprintf(error_msg, 0, "Scanner: unknown opcode %d on in %s line %d", token.opcode, state->active_file, state->active_line);
				}
				break;
		}

		if (parser_status->status != PHANNOT_PARSING_OK) {
			status = FAILURE;
			break;
		}

		state->end = state->start;
	}

	if (status != FAILURE) {
		switch (scanner_status) {

			case PHANNOT_SCANNER_RETCODE_ERR:
			case PHANNOT_SCANNER_RETCODE_IMPOSSIBLE:
				if (!*error_msg) {
					phannot_scanner_error_msg(parser_status, error_msg);
				}
				status = FAILURE;
				break;

			default:
				phannot_(phannot_parser, 0, NULL, parser_status);
		}
	}

	state->active_token = 0;
	state->start = NULL;

	if (parser_status->status != PHANNOT_PARSING_OK) {
		status = FAILURE;
		if (parser_status->syntax_error) {
			if (!*error_msg) {
				*error_msg = parser_status->syntax_error;
			} else {
				efree(parser_status->syntax_error);
			}
		}
	}

	phannot_Free(phannot_parser, phannot_wrapper_free);

	if (status != FAILURE) {
		if (parser_status->status == PHANNOT_PARSING_OK) {
			ZVAL_ZVAL(*result, &parser_status->ret, 1, 1);
		}
	}

	efree(processed_comment);
	efree(parser_status);

	return status;
}



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Reader)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Annotations, Reader, phalcon, annotations_reader, phalcon_annotations_reader_method_entry, 0);

	zend_class_implements(phalcon_annotations_reader_ce, 1, phalcon_annotations_readerinterface_ce);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Reader, parse)
{
	zval annotations;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_4 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS, line = 0;
	zval *className_param = NULL, reflection, comment, arrayKeys, classAnnotations, properties, property, annotationsProperties, propertyAnnotations, methods, method, annotationsMethods, methodAnnotations, constants, constant, anotationsConstants, constantAnnotations, constantReflection, _0$$3, _1$$3, *_2$$5, _3$$5, _5$$7, _6$$7, _7$$10, _8$$10, *_9$$13, _10$$13, _11$$15, _12$$15, _13$$16, _14$$18, _15$$18, _16$$19, *_17$$21, _18$$21, _19$$23, _20$$23, _21$$24, _22$$26, _23$$26, _24$$27;
	zval className;

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&reflection);
	ZVAL_UNDEF(&comment);
	ZVAL_UNDEF(&arrayKeys);
	ZVAL_UNDEF(&classAnnotations);
	ZVAL_UNDEF(&properties);
	ZVAL_UNDEF(&property);
	ZVAL_UNDEF(&annotationsProperties);
	ZVAL_UNDEF(&propertyAnnotations);
	ZVAL_UNDEF(&methods);
	ZVAL_UNDEF(&method);
	ZVAL_UNDEF(&annotationsMethods);
	ZVAL_UNDEF(&methodAnnotations);
	ZVAL_UNDEF(&constants);
	ZVAL_UNDEF(&constant);
	ZVAL_UNDEF(&anotationsConstants);
	ZVAL_UNDEF(&constantAnnotations);
	ZVAL_UNDEF(&constantReflection);
	ZVAL_UNDEF(&_0$$3);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$5);
	ZVAL_UNDEF(&_5$$7);
	ZVAL_UNDEF(&_6$$7);
	ZVAL_UNDEF(&_7$$10);
	ZVAL_UNDEF(&_8$$10);
	ZVAL_UNDEF(&_10$$13);
	ZVAL_UNDEF(&_11$$15);
	ZVAL_UNDEF(&_12$$15);
	ZVAL_UNDEF(&_13$$16);
	ZVAL_UNDEF(&_14$$18);
	ZVAL_UNDEF(&_15$$18);
	ZVAL_UNDEF(&_16$$19);
	ZVAL_UNDEF(&_18$$21);
	ZVAL_UNDEF(&_19$$23);
	ZVAL_UNDEF(&_20$$23);
	ZVAL_UNDEF(&_21$$24);
	ZVAL_UNDEF(&_22$$26);
	ZVAL_UNDEF(&_23$$26);
	ZVAL_UNDEF(&_24$$27);
	ZVAL_UNDEF(&annotations);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(className)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &className_param);
	zephir_get_strval(&className, className_param);
	ZEPHIR_INIT_VAR(&annotations);
	array_init(&annotations);
	ZEPHIR_INIT_VAR(&reflection);
	object_init_ex(&reflection, zephir_get_internal_ce(SL("reflectionclass")));
	ZEPHIR_CALL_METHOD(NULL, &reflection, "__construct", NULL, 154, &className);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&comment, &reflection, "getdoccomment", NULL, 160);
	zephir_check_call_status();
	if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
		ZEPHIR_INIT_VAR(&classAnnotations);
		ZEPHIR_CALL_METHOD(&_0$$3, &reflection, "getfilename", NULL, 161);
		zephir_check_call_status();
		ZEPHIR_CALL_METHOD(&_1$$3, &reflection, "getstartline", NULL, 162);
		zephir_check_call_status();
		ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&classAnnotations, &comment, &_0$$3, &_1$$3);
		zephir_check_call_status();
		if (Z_TYPE_P(&classAnnotations) == IS_ARRAY) {
			zephir_array_update_string(&annotations, SL("class"), &classAnnotations, PH_COPY | PH_SEPARATE);
		}
	}
	ZEPHIR_CALL_METHOD(&constants, &reflection, "getconstants", NULL, 163);
	zephir_check_call_status();
	if (zephir_fast_count_int(&constants)) {
		line = 1;
		ZEPHIR_INIT_VAR(&arrayKeys);
		zephir_array_keys(&arrayKeys, &constants);
		ZEPHIR_INIT_VAR(&anotationsConstants);
		array_init(&anotationsConstants);
		zephir_is_iterable(&arrayKeys, 0, "phalcon/Annotations/Reader.zep", 92);
		if (Z_TYPE_P(&arrayKeys) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&arrayKeys), _2$$5)
			{
				ZEPHIR_INIT_NVAR(&constant);
				ZVAL_COPY(&constant, _2$$5);
				ZEPHIR_CALL_METHOD(&constantReflection, &reflection, "getreflectionconstant", &_4, 164, &constant);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&comment, &constantReflection, "getdoccomment", NULL, 0);
				zephir_check_call_status();
				if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
					ZEPHIR_INIT_NVAR(&constantAnnotations);
					ZEPHIR_CALL_METHOD(&_5$$7, &reflection, "getfilename", NULL, 161);
					zephir_check_call_status();
					ZVAL_LONG(&_6$$7, line);
					ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&constantAnnotations, &comment, &_5$$7, &_6$$7);
					zephir_check_call_status();
					if (Z_TYPE_P(&constantAnnotations) == IS_ARRAY) {
						zephir_array_update_zval(&anotationsConstants, &constant, &constantAnnotations, PH_COPY | PH_SEPARATE);
					}
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &arrayKeys, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_3$$5, &arrayKeys, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_3$$5)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&constant, &arrayKeys, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&constantReflection, &reflection, "getreflectionconstant", &_4, 164, &constant);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&comment, &constantReflection, "getdoccomment", NULL, 0);
					zephir_check_call_status();
					if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
						ZEPHIR_INIT_NVAR(&constantAnnotations);
						ZEPHIR_CALL_METHOD(&_7$$10, &reflection, "getfilename", NULL, 161);
						zephir_check_call_status();
						ZVAL_LONG(&_8$$10, line);
						ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&constantAnnotations, &comment, &_7$$10, &_8$$10);
						zephir_check_call_status();
						if (Z_TYPE_P(&constantAnnotations) == IS_ARRAY) {
							zephir_array_update_zval(&anotationsConstants, &constant, &constantAnnotations, PH_COPY | PH_SEPARATE);
						}
					}
				ZEPHIR_CALL_METHOD(NULL, &arrayKeys, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&constant);
		if (zephir_fast_count_int(&anotationsConstants)) {
			zephir_array_update_string(&annotations, SL("constants"), &anotationsConstants, PH_COPY | PH_SEPARATE);
		}
	}
	ZEPHIR_CALL_METHOD(&properties, &reflection, "getproperties", NULL, 165);
	zephir_check_call_status();
	if (zephir_fast_count_int(&properties)) {
		line = 1;
		ZEPHIR_INIT_VAR(&annotationsProperties);
		array_init(&annotationsProperties);
		zephir_is_iterable(&properties, 0, "phalcon/Annotations/Reader.zep", 130);
		if (Z_TYPE_P(&properties) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&properties), _9$$13)
			{
				ZEPHIR_INIT_NVAR(&property);
				ZVAL_COPY(&property, _9$$13);
				ZEPHIR_CALL_METHOD(&comment, &property, "getdoccomment", NULL, 0);
				zephir_check_call_status();
				if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
					ZEPHIR_INIT_NVAR(&propertyAnnotations);
					ZEPHIR_CALL_METHOD(&_11$$15, &reflection, "getfilename", NULL, 161);
					zephir_check_call_status();
					ZVAL_LONG(&_12$$15, line);
					ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&propertyAnnotations, &comment, &_11$$15, &_12$$15);
					zephir_check_call_status();
					if (Z_TYPE_P(&propertyAnnotations) == IS_ARRAY) {
						ZEPHIR_OBS_NVAR(&_13$$16);
						zephir_read_property(&_13$$16, &property, ZEND_STRL("name"), PH_NOISY_CC);
						zephir_array_update_zval(&annotationsProperties, &_13$$16, &propertyAnnotations, PH_COPY | PH_SEPARATE);
					}
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &properties, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_10$$13, &properties, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_10$$13)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&property, &properties, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&comment, &property, "getdoccomment", NULL, 0);
					zephir_check_call_status();
					if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
						ZEPHIR_INIT_NVAR(&propertyAnnotations);
						ZEPHIR_CALL_METHOD(&_14$$18, &reflection, "getfilename", NULL, 161);
						zephir_check_call_status();
						ZVAL_LONG(&_15$$18, line);
						ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&propertyAnnotations, &comment, &_14$$18, &_15$$18);
						zephir_check_call_status();
						if (Z_TYPE_P(&propertyAnnotations) == IS_ARRAY) {
							ZEPHIR_OBS_NVAR(&_16$$19);
							zephir_read_property(&_16$$19, &property, ZEND_STRL("name"), PH_NOISY_CC);
							zephir_array_update_zval(&annotationsProperties, &_16$$19, &propertyAnnotations, PH_COPY | PH_SEPARATE);
						}
					}
				ZEPHIR_CALL_METHOD(NULL, &properties, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&property);
		if (zephir_fast_count_int(&annotationsProperties)) {
			zephir_array_update_string(&annotations, SL("properties"), &annotationsProperties, PH_COPY | PH_SEPARATE);
		}
	}
	ZEPHIR_CALL_METHOD(&methods, &reflection, "getmethods", NULL, 166);
	zephir_check_call_status();
	if (0 == ZEPHIR_IS_EMPTY(&methods)) {
		ZEPHIR_INIT_VAR(&annotationsMethods);
		array_init(&annotationsMethods);
		zephir_is_iterable(&methods, 0, "phalcon/Annotations/Reader.zep", 164);
		if (Z_TYPE_P(&methods) == IS_ARRAY) {
			ZEND_HASH_FOREACH_VAL(Z_ARRVAL_P(&methods), _17$$21)
			{
				ZEPHIR_INIT_NVAR(&method);
				ZVAL_COPY(&method, _17$$21);
				ZEPHIR_CALL_METHOD(&comment, &method, "getdoccomment", NULL, 0);
				zephir_check_call_status();
				if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
					ZEPHIR_INIT_NVAR(&methodAnnotations);
					ZEPHIR_CALL_METHOD(&_19$$23, &method, "getfilename", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&_20$$23, &method, "getstartline", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&methodAnnotations, &comment, &_19$$23, &_20$$23);
					zephir_check_call_status();
					if (Z_TYPE_P(&methodAnnotations) == IS_ARRAY) {
						ZEPHIR_OBS_NVAR(&_21$$24);
						zephir_read_property(&_21$$24, &method, ZEND_STRL("name"), PH_NOISY_CC);
						zephir_array_update_zval(&annotationsMethods, &_21$$24, &methodAnnotations, PH_COPY | PH_SEPARATE);
					}
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &methods, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_18$$21, &methods, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_18$$21)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&method, &methods, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&comment, &method, "getdoccomment", NULL, 0);
					zephir_check_call_status();
					if (!ZEPHIR_IS_FALSE_IDENTICAL(&comment)) {
						ZEPHIR_INIT_NVAR(&methodAnnotations);
						ZEPHIR_CALL_METHOD(&_22$$26, &method, "getfilename", NULL, 0);
						zephir_check_call_status();
						ZEPHIR_CALL_METHOD(&_23$$26, &method, "getstartline", NULL, 0);
						zephir_check_call_status();
						ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(&methodAnnotations, &comment, &_22$$26, &_23$$26);
						zephir_check_call_status();
						if (Z_TYPE_P(&methodAnnotations) == IS_ARRAY) {
							ZEPHIR_OBS_NVAR(&_24$$27);
							zephir_read_property(&_24$$27, &method, ZEND_STRL("name"), PH_NOISY_CC);
							zephir_array_update_zval(&annotationsMethods, &_24$$27, &methodAnnotations, PH_COPY | PH_SEPARATE);
						}
					}
				ZEPHIR_CALL_METHOD(NULL, &methods, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&method);
		if (zephir_fast_count_int(&annotationsMethods)) {
			zephir_array_update_string(&annotations, SL("methods"), &annotationsMethods, PH_COPY | PH_SEPARATE);
		}
	}
	RETURN_CTOR(&annotations);
}

static PHP_METHOD(Phalcon_Annotations_Reader, parseDocBlock)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *docBlock_param = NULL, *file = NULL, file_sub, *line = NULL, line_sub, __$null;
	zval docBlock;

	ZVAL_UNDEF(&docBlock);
	ZVAL_UNDEF(&file_sub);
	ZVAL_UNDEF(&line_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_STR(docBlock)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(file)
		Z_PARAM_ZVAL_OR_NULL(line)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &docBlock_param, &file, &line);
	zephir_get_strval(&docBlock, docBlock_param);
	if (!file) {
		file = &file_sub;
		ZEPHIR_CPY_WRT(file, &__$null);
	} else {
		ZEPHIR_SEPARATE_PARAM(file);
	}
	if (!line) {
		line = &line_sub;
		line = &__$null;
	}
	if (Z_TYPE_P(file) != IS_STRING) {
		ZEPHIR_INIT_NVAR(file);
		ZVAL_STRING(file, "eval code");
	}
	ZEPHIR_LAST_CALL_STATUS = phannot_parse_annotations(return_value, &docBlock, file, line);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_ReaderInterface)
{
	ZEPHIR_REGISTER_INTERFACE(Phalcon\\Annotations, ReaderInterface, phalcon, annotations_readerinterface, phalcon_annotations_readerinterface_method_entry);

	return SUCCESS;
}

ZEPHIR_DOC_METHOD(Phalcon_Annotations_ReaderInterface, parse);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_ReaderInterface, parseDocBlock);



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Reflection)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Annotations, Reflection, phalcon, annotations_reflection, phalcon_annotations_reflection_method_entry, 0);

	zend_declare_property_null(phalcon_annotations_reflection_ce, SL("classAnnotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_reflection_ce, SL("constantAnnotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_reflection_ce, SL("propertyAnnotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_reflection_ce, SL("methodAnnotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_reflection_ce, SL("reflectionData"), ZEND_ACC_PROTECTED);
	phalcon_annotations_reflection_ce->create_object = zephir_init_properties_Phalcon_Annotations_Reflection;

	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Reflection, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *reflectionData_param = NULL;
	zval reflectionData;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionData);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(reflectionData)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &reflectionData_param);
	if (!reflectionData_param) {
		ZEPHIR_INIT_VAR(&reflectionData);
		array_init(&reflectionData);
	} else {
		zephir_get_arrval(&reflectionData, reflectionData_param);
	}
	zephir_update_property_zval(this_ptr, ZEND_STRL("reflectionData"), &reflectionData);
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_Reflection, getClassAnnotations)
{
	zval reflectionClass, _0, _1$$3, _2$$4;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionClass);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$4);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("classAnnotations"), PH_NOISY_CC | PH_READONLY);
	if (Z_TYPE_P(&_0) == IS_NULL) {
		zephir_memory_observe(&reflectionClass);
		zephir_read_property(&_1$$3, this_ptr, ZEND_STRL("reflectionData"), PH_NOISY_CC | PH_READONLY);
		if (zephir_array_isset_string_fetch(&reflectionClass, &_1$$3, SL("class"), 0)) {
			ZEPHIR_INIT_VAR(&_2$$4);
			object_init_ex(&_2$$4, phalcon_annotations_collection_ce);
			ZEPHIR_CALL_METHOD(NULL, &_2$$4, "__construct", NULL, 38, &reflectionClass);
			zephir_check_call_status();
			zephir_update_property_zval(this_ptr, ZEND_STRL("classAnnotations"), &_2$$4);
		}
	}
	RETURN_MM_MEMBER(getThis(), "classAnnotations");
}

static PHP_METHOD(Phalcon_Annotations_Reflection, getConstantsAnnotations)
{
	zend_string *_5$$4;
	zend_ulong _4$$4;
	zend_bool _1$$3;
	zval reflectionConstants, constant, reflectionConstant, _0, *_2$$4, _3$$4, _6$$5, _8$$6;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionConstants);
	ZVAL_UNDEF(&constant);
	ZVAL_UNDEF(&reflectionConstant);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_8$$6);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&reflectionConstants);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("reflectionData"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset_string_fetch(&reflectionConstants, &_0, SL("constants"), 0)) {
		_1$$3 = Z_TYPE_P(&reflectionConstants) == IS_ARRAY;
		if (_1$$3) {
			_1$$3 = zephir_fast_count_int(&reflectionConstants) > 0;
		}
		if (_1$$3) {
			zephir_is_iterable(&reflectionConstants, 0, "phalcon/Annotations/Reflection.zep", 97);
			if (Z_TYPE_P(&reflectionConstants) == IS_ARRAY) {
				ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&reflectionConstants), _4$$4, _5$$4, _2$$4)
				{
					ZEPHIR_INIT_NVAR(&constant);
					if (_5$$4 != NULL) { 
						ZVAL_STR_COPY(&constant, _5$$4);
					} else {
						ZVAL_LONG(&constant, _4$$4);
					}
					ZEPHIR_INIT_NVAR(&reflectionConstant);
					ZVAL_COPY(&reflectionConstant, _2$$4);
					ZEPHIR_INIT_NVAR(&_6$$5);
					object_init_ex(&_6$$5, phalcon_annotations_collection_ce);
					ZEPHIR_CALL_METHOD(NULL, &_6$$5, "__construct", &_7, 38, &reflectionConstant);
					zephir_check_call_status();
					zephir_update_property_array(this_ptr, SL("constantAnnotations"), &constant, &_6$$5);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &reflectionConstants, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_3$$4, &reflectionConstants, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_3$$4)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&constant, &reflectionConstants, "key", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&reflectionConstant, &reflectionConstants, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_8$$6);
						object_init_ex(&_8$$6, phalcon_annotations_collection_ce);
						ZEPHIR_CALL_METHOD(NULL, &_8$$6, "__construct", &_7, 38, &reflectionConstant);
						zephir_check_call_status();
						zephir_update_property_array(this_ptr, SL("constantAnnotations"), &constant, &_8$$6);
					ZEPHIR_CALL_METHOD(NULL, &reflectionConstants, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&reflectionConstant);
			ZEPHIR_INIT_NVAR(&constant);
		}
	}
	RETURN_MM_MEMBER(getThis(), "constantAnnotations");
}

static PHP_METHOD(Phalcon_Annotations_Reflection, getPropertiesAnnotations)
{
	zend_string *_5$$4;
	zend_ulong _4$$4;
	zend_bool _1$$3;
	zval reflectionProperties, property, reflectionProperty, _0, *_2$$4, _3$$4, _6$$5, _8$$6;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionProperties);
	ZVAL_UNDEF(&property);
	ZVAL_UNDEF(&reflectionProperty);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_8$$6);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&reflectionProperties);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("reflectionData"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset_string_fetch(&reflectionProperties, &_0, SL("properties"), 0)) {
		_1$$3 = Z_TYPE_P(&reflectionProperties) == IS_ARRAY;
		if (_1$$3) {
			_1$$3 = zephir_fast_count_int(&reflectionProperties) > 0;
		}
		if (_1$$3) {
			zephir_is_iterable(&reflectionProperties, 0, "phalcon/Annotations/Reflection.zep", 119);
			if (Z_TYPE_P(&reflectionProperties) == IS_ARRAY) {
				ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&reflectionProperties), _4$$4, _5$$4, _2$$4)
				{
					ZEPHIR_INIT_NVAR(&property);
					if (_5$$4 != NULL) { 
						ZVAL_STR_COPY(&property, _5$$4);
					} else {
						ZVAL_LONG(&property, _4$$4);
					}
					ZEPHIR_INIT_NVAR(&reflectionProperty);
					ZVAL_COPY(&reflectionProperty, _2$$4);
					ZEPHIR_INIT_NVAR(&_6$$5);
					object_init_ex(&_6$$5, phalcon_annotations_collection_ce);
					ZEPHIR_CALL_METHOD(NULL, &_6$$5, "__construct", &_7, 38, &reflectionProperty);
					zephir_check_call_status();
					zephir_update_property_array(this_ptr, SL("propertyAnnotations"), &property, &_6$$5);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &reflectionProperties, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_3$$4, &reflectionProperties, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_3$$4)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&property, &reflectionProperties, "key", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&reflectionProperty, &reflectionProperties, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_8$$6);
						object_init_ex(&_8$$6, phalcon_annotations_collection_ce);
						ZEPHIR_CALL_METHOD(NULL, &_8$$6, "__construct", &_7, 38, &reflectionProperty);
						zephir_check_call_status();
						zephir_update_property_array(this_ptr, SL("propertyAnnotations"), &property, &_8$$6);
					ZEPHIR_CALL_METHOD(NULL, &reflectionProperties, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&reflectionProperty);
			ZEPHIR_INIT_NVAR(&property);
		}
	}
	RETURN_MM_MEMBER(getThis(), "propertyAnnotations");
}

static PHP_METHOD(Phalcon_Annotations_Reflection, getMethodsAnnotations)
{
	zend_string *_5$$4;
	zend_ulong _4$$4;
	zend_bool _1$$3;
	zval reflectionMethods, methodName, reflectionMethod, _0, *_2$$4, _3$$4, _6$$5, _8$$6;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_7 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reflectionMethods);
	ZVAL_UNDEF(&methodName);
	ZVAL_UNDEF(&reflectionMethod);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_8$$6);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&reflectionMethods);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("reflectionData"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset_string_fetch(&reflectionMethods, &_0, SL("methods"), 0)) {
		_1$$3 = Z_TYPE_P(&reflectionMethods) == IS_ARRAY;
		if (_1$$3) {
			_1$$3 = zephir_fast_count_int(&reflectionMethods) > 0;
		}
		if (_1$$3) {
			zephir_is_iterable(&reflectionMethods, 0, "phalcon/Annotations/Reflection.zep", 141);
			if (Z_TYPE_P(&reflectionMethods) == IS_ARRAY) {
				ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&reflectionMethods), _4$$4, _5$$4, _2$$4)
				{
					ZEPHIR_INIT_NVAR(&methodName);
					if (_5$$4 != NULL) { 
						ZVAL_STR_COPY(&methodName, _5$$4);
					} else {
						ZVAL_LONG(&methodName, _4$$4);
					}
					ZEPHIR_INIT_NVAR(&reflectionMethod);
					ZVAL_COPY(&reflectionMethod, _2$$4);
					ZEPHIR_INIT_NVAR(&_6$$5);
					object_init_ex(&_6$$5, phalcon_annotations_collection_ce);
					ZEPHIR_CALL_METHOD(NULL, &_6$$5, "__construct", &_7, 38, &reflectionMethod);
					zephir_check_call_status();
					zephir_update_property_array(this_ptr, SL("methodAnnotations"), &methodName, &_6$$5);
				} ZEND_HASH_FOREACH_END();
			} else {
				ZEPHIR_CALL_METHOD(NULL, &reflectionMethods, "rewind", NULL, 0);
				zephir_check_call_status();
				while (1) {
					ZEPHIR_CALL_METHOD(&_3$$4, &reflectionMethods, "valid", NULL, 0);
					zephir_check_call_status();
					if (!zend_is_true(&_3$$4)) {
						break;
					}
					ZEPHIR_CALL_METHOD(&methodName, &reflectionMethods, "key", NULL, 0);
					zephir_check_call_status();
					ZEPHIR_CALL_METHOD(&reflectionMethod, &reflectionMethods, "current", NULL, 0);
					zephir_check_call_status();
						ZEPHIR_INIT_NVAR(&_8$$6);
						object_init_ex(&_8$$6, phalcon_annotations_collection_ce);
						ZEPHIR_CALL_METHOD(NULL, &_8$$6, "__construct", &_7, 38, &reflectionMethod);
						zephir_check_call_status();
						zephir_update_property_array(this_ptr, SL("methodAnnotations"), &methodName, &_8$$6);
					ZEPHIR_CALL_METHOD(NULL, &reflectionMethods, "next", NULL, 0);
					zephir_check_call_status();
				}
			}
			ZEPHIR_INIT_NVAR(&reflectionMethod);
			ZEPHIR_INIT_NVAR(&methodName);
		}
	}
	RETURN_MM_MEMBER(getThis(), "methodAnnotations");
}

static PHP_METHOD(Phalcon_Annotations_Reflection, getReflectionData)
{

	RETURN_MEMBER(getThis(), "reflectionData");
}

zend_object *zephir_init_properties_Phalcon_Annotations_Reflection(zend_class_entry *class_type)
{
		zval _0, _2, _4, _6, _1$$3, _3$$4, _5$$5, _7$$6;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_3$$4);
	ZVAL_UNDEF(&_5$$5);
	ZVAL_UNDEF(&_7$$6);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("reflectionData"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("reflectionData"), &_1$$3);
		}
		zephir_read_property_ex(&_2, this_ptr, ZEND_STRL("methodAnnotations"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_2) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_3$$4);
			array_init(&_3$$4);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("methodAnnotations"), &_3$$4);
		}
		zephir_read_property_ex(&_4, this_ptr, ZEND_STRL("propertyAnnotations"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_4) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_5$$5);
			array_init(&_5$$5);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("propertyAnnotations"), &_5$$5);
		}
		zephir_read_property_ex(&_6, this_ptr, ZEND_STRL("constantAnnotations"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_6) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_7$$6);
			array_init(&_7$$6);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("constantAnnotations"), &_7$$6);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}



/* Generated by re2c 1.1.1 */
/* scanner.re
 * This file is part of the Phalcon Framework.
 *
 * (c) Phalcon Team <team@phalcon.io>
 *
 * For the full copyright and license information, please view the
 * LICENSE.txt file that was distributed with this source code.
 */



#define AACTYPE unsigned char
#define AACURSOR (s->start)
#define AALIMIT (s->end)
#define AAMARKER q

static int phannot_get_token(phannot_scanner_state *s, phannot_scanner_token *token) {

	char next, *q = AACURSOR, *start = AACURSOR;
	int status = PHANNOT_SCANNER_RETCODE_IMPOSSIBLE;

	while (PHANNOT_SCANNER_RETCODE_IMPOSSIBLE == status) {

		if (s->mode == PHANNOT_MODE_RAW) {

			if (*AACURSOR == '\n') {
				s->active_line++;
			}

			next = *(AACURSOR+1);

			if (*AACURSOR == '\0' || *AACURSOR == '@') {
				if ((next >= 'A' && next <= 'Z') || (next >= 'a' && next <= 'z')) {
					s->mode = PHANNOT_MODE_ANNOTATION;
					continue;
				}
			}

			++AACURSOR;
			token->opcode = PHANNOT_T_IGNORE;
			return 0;

		} else {

		
		{
			AACTYPE aach;
			unsigned int aaaccept = 0;
			aach = *AACURSOR;
			switch (aach) {
			case 0x00:	goto aa2;
			case '\t':
			case '\r':
			case ' ':	goto aa6;
			case '\n':	goto aa9;
			case '"':	goto aa11;
			case '\'':	goto aa12;
			case '(':	goto aa13;
			case ')':	goto aa15;
			case ',':	goto aa17;
			case '-':	goto aa19;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto aa20;
			case ':':	goto aa23;
			case '=':	goto aa25;
			case '@':	goto aa27;
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			case 'F':
			case 'f':	goto aa32;
			case 'N':
			case 'n':	goto aa33;
			case 'T':
			case 't':	goto aa34;
			case '[':	goto aa35;
			case '\\':	goto aa37;
			case ']':	goto aa38;
			case '{':	goto aa40;
			case '}':	goto aa42;
			default:	goto aa4;
			}
aa2:
			++AACURSOR;
			{
			status = PHANNOT_SCANNER_RETCODE_EOF;
			break;
		}
aa4:
			++AACURSOR;
aa5:
			{
			status = PHANNOT_SCANNER_RETCODE_ERR;
			break;
		}
aa6:
			aach = *++AACURSOR;
			switch (aach) {
			case '\t':
			case '\r':
			case ' ':	goto aa6;
			default:	goto aa8;
			}
aa8:
			{
			token->opcode = PHANNOT_T_IGNORE;
			return 0;
		}
aa9:
			++AACURSOR;
			{
			s->active_line++;
			token->opcode = PHANNOT_T_IGNORE;
			return 0;
		}
aa11:
			aaaccept = 0;
			aach = *(AAMARKER = ++AACURSOR);
			if (aach <= 0x00) goto aa5;
			goto aa45;
aa12:
			aaaccept = 0;
			aach = *(AAMARKER = ++AACURSOR);
			if (aach <= 0x00) goto aa5;
			goto aa51;
aa13:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_PARENTHESES_OPEN;
			return 0;
		}
aa15:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_PARENTHESES_CLOSE;
			return 0;
		}
aa17:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_COMMA;
			return 0;
		}
aa19:
			aach = *++AACURSOR;
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto aa20;
			default:	goto aa5;
			}
aa20:
			aaaccept = 1;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case '.':	goto aa53;
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto aa20;
			default:	goto aa22;
			}
aa22:
			{
			token->opcode = PHANNOT_T_INTEGER;
			token->value = estrndup(start, AACURSOR - start);
			token->len = AACURSOR - start;
			q = AACURSOR;
			return 0;
		}
aa23:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_COLON;
			return 0;
		}
aa25:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_EQUALS;
			return 0;
		}
aa27:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_AT;
			return 0;
		}
aa29:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
aa30:
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			case '\\':	goto aa54;
			default:	goto aa31;
			}
aa31:
			{
			token->opcode = PHANNOT_T_IDENTIFIER;
			token->value = estrndup(start, AACURSOR - start);
			token->len = AACURSOR - start;
			q = AACURSOR;
			return 0;
		}
aa32:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'A':
			case 'a':	goto aa55;
			default:	goto aa30;
			}
aa33:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'U':
			case 'u':	goto aa56;
			default:	goto aa30;
			}
aa34:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'R':
			case 'r':	goto aa57;
			default:	goto aa30;
			}
aa35:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_SBRACKET_OPEN;
			return 0;
		}
aa37:
			aach = *++AACURSOR;
			switch (aach) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			default:	goto aa5;
			}
aa38:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_SBRACKET_CLOSE;
			return 0;
		}
aa40:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_BRACKET_OPEN;
			return 0;
		}
aa42:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_BRACKET_CLOSE;
			return 0;
		}
aa44:
			aach = *++AACURSOR;
aa45:
			switch (aach) {
			case 0x00:	goto aa46;
			case '"':	goto aa47;
			case '\\':	goto aa49;
			default:	goto aa44;
			}
aa46:
			AACURSOR = AAMARKER;
			switch (aaaccept) {
			case 0: 	goto aa5;
			case 1: 	goto aa22;
			case 2: 	goto aa31;
			case 3: 	goto aa66;
			case 4: 	goto aa68;
			default:	goto aa70;
			}
aa47:
			++AACURSOR;
			{
			token->opcode = PHANNOT_T_STRING;
			token->value = estrndup(q, AACURSOR - q - 1);
			token->len = AACURSOR - q - 1;
			q = AACURSOR;
			return 0;
		}
aa49:
			aach = *++AACURSOR;
			switch (aach) {
			case '\n':	goto aa46;
			default:	goto aa44;
			}
aa50:
			aach = *++AACURSOR;
aa51:
			switch (aach) {
			case 0x00:	goto aa46;
			case '\'':	goto aa47;
			case '\\':	goto aa52;
			default:	goto aa50;
			}
aa52:
			aach = *++AACURSOR;
			switch (aach) {
			case '\n':	goto aa46;
			default:	goto aa50;
			}
aa53:
			aach = *++AACURSOR;
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto aa58;
			default:	goto aa46;
			}
aa54:
			aach = *++AACURSOR;
			switch (aach) {
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			default:	goto aa46;
			}
aa55:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'L':
			case 'l':	goto aa61;
			default:	goto aa30;
			}
aa56:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'L':
			case 'l':	goto aa62;
			default:	goto aa30;
			}
aa57:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'U':
			case 'u':	goto aa63;
			default:	goto aa30;
			}
aa58:
			aach = *++AACURSOR;
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':	goto aa58;
			default:	goto aa60;
			}
aa60:
			{
			token->opcode = PHANNOT_T_DOUBLE;
			token->value = estrndup(start, AACURSOR - start);
			token->len = AACURSOR - start;
			q = AACURSOR;
			return 0;
		}
aa61:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'S':
			case 's':	goto aa64;
			default:	goto aa30;
			}
aa62:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'L':
			case 'l':	goto aa65;
			default:	goto aa30;
			}
aa63:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'E':
			case 'e':	goto aa67;
			default:	goto aa30;
			}
aa64:
			aaaccept = 2;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case 'E':
			case 'e':	goto aa69;
			default:	goto aa30;
			}
aa65:
			aaaccept = 3;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			case '\\':	goto aa54;
			default:	goto aa66;
			}
aa66:
			{
			token->opcode = PHANNOT_T_NULL;
			return 0;
		}
aa67:
			aaaccept = 4;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			case '\\':	goto aa54;
			default:	goto aa68;
			}
aa68:
			{
			token->opcode = PHANNOT_T_TRUE;
			return 0;
		}
aa69:
			aaaccept = 5;
			aach = *(AAMARKER = ++AACURSOR);
			switch (aach) {
			case '0':
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9':
			case 'A':
			case 'B':
			case 'C':
			case 'D':
			case 'E':
			case 'F':
			case 'G':
			case 'H':
			case 'I':
			case 'J':
			case 'K':
			case 'L':
			case 'M':
			case 'N':
			case 'O':
			case 'P':
			case 'Q':
			case 'R':
			case 'S':
			case 'T':
			case 'U':
			case 'V':
			case 'W':
			case 'X':
			case 'Y':
			case 'Z':
			case '_':
			case 'a':
			case 'b':
			case 'c':
			case 'd':
			case 'e':
			case 'f':
			case 'g':
			case 'h':
			case 'i':
			case 'j':
			case 'k':
			case 'l':
			case 'm':
			case 'n':
			case 'o':
			case 'p':
			case 'q':
			case 'r':
			case 's':
			case 't':
			case 'u':
			case 'v':
			case 'w':
			case 'x':
			case 'y':
			case 'z':	goto aa29;
			case '\\':	goto aa54;
			default:	goto aa70;
			}
aa70:
			{
			token->opcode = PHANNOT_T_FALSE;
			return 0;
		}
		}


		}
	}

	return status;
}



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Adapter_AbstractAdapter)
{
	ZEPHIR_REGISTER_CLASS(Phalcon\\Annotations\\Adapter, AbstractAdapter, phalcon, annotations_adapter_abstractadapter, phalcon_annotations_adapter_abstractadapter_method_entry, ZEND_ACC_EXPLICIT_ABSTRACT_CLASS);

	zend_declare_property_null(phalcon_annotations_adapter_abstractadapter_ce, SL("annotations"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_annotations_adapter_abstractadapter_ce, SL("reader"), ZEND_ACC_PROTECTED);
	phalcon_annotations_adapter_abstractadapter_ce->create_object = zephir_init_properties_Phalcon_Annotations_Adapter_AbstractAdapter;

	zend_class_implements(phalcon_annotations_adapter_abstractadapter_ce, 1, phalcon_annotations_adapter_adapterinterface_ce);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, get)
{
	zend_bool _3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className, className_sub, classAnnotations, parsedAnnotations, realClassName, reader, _0, _1$$5, _2$$5;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className_sub);
	ZVAL_UNDEF(&classAnnotations);
	ZVAL_UNDEF(&parsedAnnotations);
	ZVAL_UNDEF(&realClassName);
	ZVAL_UNDEF(&reader);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$5);
	ZVAL_UNDEF(&_2$$5);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ZVAL(className)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &className);
	if (Z_TYPE_P(className) == IS_OBJECT) {
		ZEPHIR_INIT_VAR(&realClassName);
		zephir_get_class(&realClassName, className, 0);
	} else {
		ZEPHIR_CPY_WRT(&realClassName, className);
	}
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
	if (zephir_array_isset(&_0, &realClassName)) {
		zephir_read_property(&_1$$5, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
		zephir_array_fetch(&_2$$5, &_1$$5, &realClassName, PH_NOISY | PH_READONLY, "phalcon/Annotations/Adapter/AbstractAdapter.zep", 51);
		RETURN_CTOR(&_2$$5);
	}
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "read", NULL, 0, &realClassName);
	zephir_check_call_status();
	_3 = Z_TYPE_P(&classAnnotations) == IS_NULL;
	if (!(_3)) {
		_3 = ZEPHIR_IS_FALSE_IDENTICAL(&classAnnotations);
	}
	if (_3) {
		ZEPHIR_CALL_METHOD(&reader, this_ptr, "getreader", NULL, 0);
		zephir_check_call_status();
		ZEPHIR_CALL_METHOD(&parsedAnnotations, &reader, "parse", NULL, 0, &realClassName);
		zephir_check_call_status();
		ZEPHIR_INIT_NVAR(&classAnnotations);
		object_init_ex(&classAnnotations, phalcon_annotations_reflection_ce);
		ZEPHIR_CALL_METHOD(NULL, &classAnnotations, "__construct", NULL, 37, &parsedAnnotations);
		zephir_check_call_status();
		zephir_update_property_array(this_ptr, SL("annotations"), &realClassName, &classAnnotations);
		ZEPHIR_CALL_METHOD(NULL, this_ptr, "write", NULL, 0, &realClassName, &classAnnotations);
		zephir_check_call_status();
	}
	RETURN_CCTOR(&classAnnotations);
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getConstant)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, *constantName_param = NULL, constants, constant;
	zval className, constantName;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&constantName);
	ZVAL_UNDEF(&constants);
	ZVAL_UNDEF(&constant);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(className)
		Z_PARAM_STR(constantName)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &className_param, &constantName_param);
	zephir_get_strval(&className, className_param);
	zephir_get_strval(&constantName, constantName_param);
	ZEPHIR_CALL_METHOD(&constants, this_ptr, "getconstants", NULL, 0, &className);
	zephir_check_call_status();
	if (!(zephir_array_isset_fetch(&constant, &constants, &constantName, 1))) {
		object_init_ex(return_value, phalcon_annotations_collection_ce);
		ZEPHIR_CALL_METHOD(NULL, return_value, "__construct", NULL, 38);
		zephir_check_call_status();
		RETURN_MM();
	}
	RETURN_CTOR(&constant);
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getConstants)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, classAnnotations;
	zval className;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&classAnnotations);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(className)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &className_param);
	zephir_get_strval(&className, className_param);
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "get", NULL, 0, &className);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_METHOD(&classAnnotations, "getconstantsannotations", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getProperty)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, *propertyName_param = NULL, classAnnotations, properties, property;
	zval className, propertyName;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&propertyName);
	ZVAL_UNDEF(&classAnnotations);
	ZVAL_UNDEF(&properties);
	ZVAL_UNDEF(&property);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(className)
		Z_PARAM_STR(propertyName)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &className_param, &propertyName_param);
	zephir_get_strval(&className, className_param);
	zephir_get_strval(&propertyName, propertyName_param);
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "get", NULL, 0, &className);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&properties, &classAnnotations, "getpropertiesannotations", NULL, 0);
	zephir_check_call_status();
	if (!(zephir_array_isset_fetch(&property, &properties, &propertyName, 1))) {
		object_init_ex(return_value, phalcon_annotations_collection_ce);
		ZEPHIR_CALL_METHOD(NULL, return_value, "__construct", NULL, 38);
		zephir_check_call_status();
		RETURN_MM();
	}
	RETURN_CTOR(&property);
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getProperties)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, classAnnotations;
	zval className;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&classAnnotations);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(className)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &className_param);
	zephir_get_strval(&className, className_param);
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "get", NULL, 0, &className);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_METHOD(&classAnnotations, "getpropertiesannotations", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getMethod)
{
	zend_string *_3$$3;
	zend_ulong _2$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_5 = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, *methodName_param = NULL, classAnnotations, methods, method, methodKey, *_0$$3, _1$$3, _4$$4, _6$$6;
	zval className, methodName;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&methodName);
	ZVAL_UNDEF(&classAnnotations);
	ZVAL_UNDEF(&methods);
	ZVAL_UNDEF(&method);
	ZVAL_UNDEF(&methodKey);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_4$$4);
	ZVAL_UNDEF(&_6$$6);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(className)
		Z_PARAM_STR(methodName)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &className_param, &methodName_param);
	zephir_get_strval(&className, className_param);
	zephir_get_strval(&methodName, methodName_param);
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "get", NULL, 0, &className);
	zephir_check_call_status();
	ZEPHIR_CALL_METHOD(&methods, &classAnnotations, "getmethodsannotations", NULL, 0);
	zephir_check_call_status();
	if (Z_TYPE_P(&methods) == IS_ARRAY) {
		zephir_is_iterable(&methods, 0, "phalcon/Annotations/Adapter/AbstractAdapter.zep", 167);
		if (Z_TYPE_P(&methods) == IS_ARRAY) {
			ZEND_HASH_FOREACH_KEY_VAL(Z_ARRVAL_P(&methods), _2$$3, _3$$3, _0$$3)
			{
				ZEPHIR_INIT_NVAR(&methodKey);
				if (_3$$3 != NULL) { 
					ZVAL_STR_COPY(&methodKey, _3$$3);
				} else {
					ZVAL_LONG(&methodKey, _2$$3);
				}
				ZEPHIR_INIT_NVAR(&method);
				ZVAL_COPY(&method, _0$$3);
				ZEPHIR_CALL_FUNCTION(&_4$$4, "strcasecmp", &_5, 39, &methodKey, &methodName);
				zephir_check_call_status();
				if (!(zephir_is_true(&_4$$4))) {
					RETURN_CCTOR(&method);
				}
			} ZEND_HASH_FOREACH_END();
		} else {
			ZEPHIR_CALL_METHOD(NULL, &methods, "rewind", NULL, 0);
			zephir_check_call_status();
			while (1) {
				ZEPHIR_CALL_METHOD(&_1$$3, &methods, "valid", NULL, 0);
				zephir_check_call_status();
				if (!zend_is_true(&_1$$3)) {
					break;
				}
				ZEPHIR_CALL_METHOD(&methodKey, &methods, "key", NULL, 0);
				zephir_check_call_status();
				ZEPHIR_CALL_METHOD(&method, &methods, "current", NULL, 0);
				zephir_check_call_status();
					ZEPHIR_CALL_FUNCTION(&_6$$6, "strcasecmp", &_5, 39, &methodKey, &methodName);
					zephir_check_call_status();
					if (!(zephir_is_true(&_6$$6))) {
						RETURN_CCTOR(&method);
					}
				ZEPHIR_CALL_METHOD(NULL, &methods, "next", NULL, 0);
				zephir_check_call_status();
			}
		}
		ZEPHIR_INIT_NVAR(&method);
		ZEPHIR_INIT_NVAR(&methodKey);
	}
	object_init_ex(return_value, phalcon_annotations_collection_ce);
	ZEPHIR_CALL_METHOD(NULL, return_value, "__construct", NULL, 38);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getMethods)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *className_param = NULL, classAnnotations;
	zval className;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&className);
	ZVAL_UNDEF(&classAnnotations);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(className)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &className_param);
	zephir_get_strval(&className, className_param);
	ZEPHIR_CALL_METHOD(&classAnnotations, this_ptr, "get", NULL, 0, &className);
	zephir_check_call_status();
	ZEPHIR_RETURN_CALL_METHOD(&classAnnotations, "getmethodsannotations", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, getReader)
{
	zval _0, _1$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("reader"), PH_NOISY_CC | PH_READONLY);
	if (Z_TYPE_P(&_0) == IS_NULL) {
		ZEPHIR_INIT_VAR(&_1$$3);
		object_init_ex(&_1$$3, phalcon_annotations_reader_ce);
		if (zephir_has_constructor(&_1$$3)) {
			ZEPHIR_CALL_METHOD(NULL, &_1$$3, "__construct", NULL, 0);
			zephir_check_call_status();
		}

		zephir_update_property_zval(this_ptr, ZEND_STRL("reader"), &_1$$3);
	}
	RETURN_MM_MEMBER(getThis(), "reader");
}

static PHP_METHOD(Phalcon_Annotations_Adapter_AbstractAdapter, setReader)
{
	zval *reader, reader_sub;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&reader_sub);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_OBJECT_OF_CLASS(reader, phalcon_annotations_readerinterface_ce)
	ZEND_PARSE_PARAMETERS_END();
	zephir_fetch_params_without_memory_grow(1, 0, &reader);
	zephir_update_property_zval(this_ptr, ZEND_STRL("reader"), reader);
}

zend_object *zephir_init_properties_Phalcon_Annotations_Adapter_AbstractAdapter(zend_class_entry *class_type)
{
		zval _0, _1$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
		ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	

		ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
		zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	
	{
		zval local_this_ptr, *this_ptr = &local_this_ptr;
		ZEPHIR_CREATE_OBJECT(this_ptr, class_type);
		zephir_read_property_ex(&_0, this_ptr, ZEND_STRL("annotations"), PH_NOISY_CC | PH_READONLY);
		if (Z_TYPE_P(&_0) == IS_NULL) {
			ZEPHIR_INIT_VAR(&_1$$3);
			array_init(&_1$$3);
			zephir_update_property_zval_ex(this_ptr, ZEND_STRL("annotations"), &_1$$3);
		}
		ZEPHIR_MM_RESTORE();
		return Z_OBJ_P(this_ptr);
	}
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Adapter_AdapterInterface)
{
	ZEPHIR_REGISTER_INTERFACE(Phalcon\\Annotations\\Adapter, AdapterInterface, phalcon, annotations_adapter_adapterinterface, phalcon_annotations_adapter_adapterinterface_method_entry);

	return SUCCESS;
}

ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, get);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getConstant);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getConstants);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getProperty);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getProperties);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getMethod);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getMethods);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, getReader);
ZEPHIR_DOC_METHOD(Phalcon_Annotations_Adapter_AdapterInterface, setReader);



#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Adapter_Apcu)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Annotations\\Adapter, Apcu, phalcon, annotations_adapter_apcu, phalcon_annotations_adapter_abstractadapter_ce, phalcon_annotations_adapter_apcu_method_entry, 0);

	zend_declare_property_string(phalcon_annotations_adapter_apcu_ce, SL("prefix"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_long(phalcon_annotations_adapter_apcu_ce, SL("ttl"), 172800, ZEND_ACC_PROTECTED);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Apcu, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *options_param = NULL, prefix, ttl;
	zval options;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&options);
	ZVAL_UNDEF(&prefix);
	ZVAL_UNDEF(&ttl);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &options_param);
	if (!options_param) {
		ZEPHIR_INIT_VAR(&options);
		array_init(&options);
	} else {
		zephir_get_arrval(&options, options_param);
	}
	zephir_memory_observe(&prefix);
	if (zephir_array_isset_string_fetch(&prefix, &options, SL("prefix"), 0)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("prefix"), &prefix);
	}
	zephir_memory_observe(&ttl);
	if (zephir_array_isset_string_fetch(&ttl, &options, SL("lifetime"), 0)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("ttl"), &ttl);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Apcu, read)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *key_param = NULL, _0, _1, _2;
	zval key;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(key)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &key_param);
	if (UNEXPECTED(Z_TYPE_P(key_param) != IS_STRING && Z_TYPE_P(key_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'key' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(key_param) == IS_STRING)) {
		zephir_get_strval(&key, key_param);
	} else {
		ZEPHIR_INIT_VAR(&key);
	}
	ZEPHIR_INIT_VAR(&_0);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("prefix"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_INIT_VAR(&_2);
	ZEPHIR_CONCAT_SVV(&_2, "_PHAN", &_1, &key);
	zephir_fast_strtolower(&_0, &_2);
	ZEPHIR_RETURN_CALL_FUNCTION("apcu_fetch", NULL, 107, &_0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Apcu, write)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *key_param = NULL, *data, data_sub, _0, _1, _2, _3;
	zval key;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&data_sub);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(key)
		Z_PARAM_OBJECT_OF_CLASS(data, phalcon_annotations_reflection_ce)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &key_param, &data);
	if (UNEXPECTED(Z_TYPE_P(key_param) != IS_STRING && Z_TYPE_P(key_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'key' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(key_param) == IS_STRING)) {
		zephir_get_strval(&key, key_param);
	} else {
		ZEPHIR_INIT_VAR(&key);
	}
	ZEPHIR_INIT_VAR(&_0);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("prefix"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_INIT_VAR(&_2);
	ZEPHIR_CONCAT_SVV(&_2, "_PHAN", &_1, &key);
	zephir_fast_strtolower(&_0, &_2);
	zephir_read_property(&_3, this_ptr, ZEND_STRL("ttl"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_RETURN_CALL_FUNCTION("apcu_store", NULL, 108, &_0, data, &_3);
	zephir_check_call_status();
	RETURN_MM();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Adapter_Memory)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Annotations\\Adapter, Memory, phalcon, annotations_adapter_memory, phalcon_annotations_adapter_abstractadapter_ce, phalcon_annotations_adapter_memory_method_entry, 0);

	zend_declare_property_null(phalcon_annotations_adapter_memory_ce, SL("data"), ZEND_ACC_PROTECTED);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Memory, read)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *key_param = NULL, data, _0, _1;
	zval key;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&data);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(key)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &key_param);
	if (UNEXPECTED(Z_TYPE_P(key_param) != IS_STRING && Z_TYPE_P(key_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'key' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(key_param) == IS_STRING)) {
		zephir_get_strval(&key, key_param);
	} else {
		ZEPHIR_INIT_VAR(&key);
	}
	zephir_memory_observe(&data);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("data"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_INIT_VAR(&_1);
	zephir_fast_strtolower(&_1, &key);
	if (!(zephir_array_isset_fetch(&data, &_0, &_1, 0))) {
		RETURN_MM_BOOL(0);
	}
	RETURN_CCTOR(&data);
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Memory, write)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *key_param = NULL, *data, data_sub, lowercasedKey;
	zval key;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&data_sub);
	ZVAL_UNDEF(&lowercasedKey);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(key)
		Z_PARAM_OBJECT_OF_CLASS(data, phalcon_annotations_reflection_ce)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &key_param, &data);
	if (UNEXPECTED(Z_TYPE_P(key_param) != IS_STRING && Z_TYPE_P(key_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'key' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(key_param) == IS_STRING)) {
		zephir_get_strval(&key, key_param);
	} else {
		ZEPHIR_INIT_VAR(&key);
	}
	ZEPHIR_INIT_VAR(&lowercasedKey);
	zephir_fast_strtolower(&lowercasedKey, &key);
	zephir_update_property_array(this_ptr, SL("data"), &lowercasedKey, data);
	ZEPHIR_MM_RESTORE();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Annotations_Adapter_Stream)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Annotations\\Adapter, Stream, phalcon, annotations_adapter_stream, phalcon_annotations_adapter_abstractadapter_ce, phalcon_annotations_adapter_stream_method_entry, 0);

	zend_declare_property_string(phalcon_annotations_adapter_stream_ce, SL("annotationsDir"), "./", ZEND_ACC_PROTECTED);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Stream, __construct)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *options_param = NULL, annotationsDir;
	zval options;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&options);
	ZVAL_UNDEF(&annotationsDir);
	ZEND_PARSE_PARAMETERS_START(0, 1)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(options)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 0, 1, &options_param);
	if (!options_param) {
		ZEPHIR_INIT_VAR(&options);
		array_init(&options);
	} else {
		zephir_get_arrval(&options, options_param);
	}
	zephir_memory_observe(&annotationsDir);
	if (zephir_array_isset_string_fetch(&annotationsDir, &options, SL("annotationsDir"), 0)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("annotationsDir"), &annotationsDir);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Stream, read)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *key_param = NULL, __$false, contents, version, _0, _1, _2, _3, _4, _5, _6, _11, _7$$5, _8$$5, _9$$6, _10$$6;
	zval key, path;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&path);
	ZVAL_BOOL(&__$false, 0);
	ZVAL_UNDEF(&contents);
	ZVAL_UNDEF(&version);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_6);
	ZVAL_UNDEF(&_11);
	ZVAL_UNDEF(&_7$$5);
	ZVAL_UNDEF(&_8$$5);
	ZVAL_UNDEF(&_9$$6);
	ZVAL_UNDEF(&_10$$6);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_STR(key)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &key_param);
	zephir_get_strval(&key, key_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotationsDir"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_INIT_VAR(&_1);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "_");
	zephir_prepare_virtual_path(&_1, &key, &_2);
	ZEPHIR_INIT_VAR(&_3);
	ZEPHIR_CONCAT_VVS(&_3, &_0, &_1, ".php");
	zephir_get_strval(&path, &_3);
	if (!((zephir_file_exists(&path) == SUCCESS))) {
		RETURN_MM_BOOL(0);
	}
	ZEPHIR_INIT_VAR(&contents);
	zephir_file_get_contents(&contents, &path);
	if (UNEXPECTED(ZEPHIR_IS_EMPTY(&contents))) {
		RETURN_MM_BOOL(0);
	}
	ZEPHIR_GLOBAL(warning).enable = zend_is_true(&__$false);
	ZEPHIR_CALL_FUNCTION(&version, "phpversion", NULL, 133);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_4);
	ZVAL_STRING(&_4, "8.0");
	ZEPHIR_INIT_VAR(&_5);
	ZVAL_STRING(&_5, ">=");
	ZEPHIR_CALL_FUNCTION(&_6, "version_compare", NULL, 134, &version, &_4, &_5);
	zephir_check_call_status();
	if (zephir_is_true(&_6)) {
		ZEPHIR_INIT_VAR(&_7$$5);
		ZEPHIR_INIT_NVAR(&_7$$5);
		zephir_create_closure_ex(&_7$$5, NULL, phalcon_4__closure_ce, SL("__invoke"));
		ZVAL_LONG(&_8$$5, 2);
		ZEPHIR_CALL_FUNCTION(NULL, "set_error_handler", NULL, 135, &_7$$5, &_8$$5);
		zephir_check_call_status();
	} else {
		ZEPHIR_INIT_VAR(&_9$$6);
		ZEPHIR_INIT_NVAR(&_9$$6);
		zephir_create_closure_ex(&_9$$6, NULL, phalcon_5__closure_ce, SL("__invoke"));
		ZVAL_LONG(&_10$$6, 2);
		ZEPHIR_CALL_FUNCTION(NULL, "set_error_handler", NULL, 135, &_9$$6, &_10$$6);
		zephir_check_call_status();
	}
	ZEPHIR_CALL_FUNCTION(&_11, "unserialize", NULL, 16, &contents);
	zephir_check_call_status();
	ZEPHIR_CPY_WRT(&contents, &_11);
	ZEPHIR_CALL_FUNCTION(NULL, "restore_error_handler", NULL, 136);
	zephir_check_call_status();
	if (UNEXPECTED(ZEPHIR_GLOBAL(warning).enable)) {
		ZEPHIR_THROW_EXCEPTION_DEBUG_STR(spl_ce_RuntimeException, "Cannot read annotation data", "phalcon/Annotations/Adapter/Stream.zep", 102);
		return;
	}
	RETURN_CCTOR(&contents);
}

static PHP_METHOD(Phalcon_Annotations_Adapter_Stream, write)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *key_param = NULL, *data, data_sub, code, _0, _1, _2, _3, _4;
	zval key, path;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&key);
	ZVAL_UNDEF(&path);
	ZVAL_UNDEF(&data_sub);
	ZVAL_UNDEF(&code);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZEND_PARSE_PARAMETERS_START(2, 2)
		Z_PARAM_STR(key)
		Z_PARAM_OBJECT_OF_CLASS(data, phalcon_annotations_reflection_ce)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 0, &key_param, &data);
	if (UNEXPECTED(Z_TYPE_P(key_param) != IS_STRING && Z_TYPE_P(key_param) != IS_NULL)) {
		zephir_throw_exception_string(spl_ce_InvalidArgumentException, SL("Parameter 'key' must be of the type string"));
		RETURN_MM_NULL();
	}
	if (EXPECTED(Z_TYPE_P(key_param) == IS_STRING)) {
		zephir_get_strval(&key, key_param);
	} else {
		ZEPHIR_INIT_VAR(&key);
	}
	zephir_read_property(&_0, this_ptr, ZEND_STRL("annotationsDir"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_INIT_VAR(&_1);
	ZEPHIR_INIT_VAR(&_2);
	ZVAL_STRING(&_2, "_");
	zephir_prepare_virtual_path(&_1, &key, &_2);
	ZEPHIR_INIT_VAR(&_3);
	ZEPHIR_CONCAT_VVS(&_3, &_0, &_1, ".php");
	zephir_get_strval(&path, &_3);
	ZEPHIR_CALL_FUNCTION(&code, "serialize", NULL, 15, data);
	zephir_check_call_status();
	ZEPHIR_INIT_VAR(&_4);
	zephir_file_put_contents(&_4, &path, &code);
	if (UNEXPECTED(ZEPHIR_IS_FALSE_IDENTICAL(&_4))) {
		ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_annotations_exception_ce, "Annotations directory cannot be written", "phalcon/Annotations/Adapter/Stream.zep", 123);
		return;
	}
	ZEPHIR_MM_RESTORE();
}




#ifdef HAVE_CONFIG_H
#endif





ZEPHIR_INIT_CLASS(Phalcon_Dispatcher_AbstractDispatcher)
{
	ZEPHIR_REGISTER_CLASS_EX(Phalcon\\Dispatcher, AbstractDispatcher, phalcon, dispatcher_abstractdispatcher, phalcon_di_abstractinjectionaware_ce, phalcon_dispatcher_abstractdispatcher_method_entry, ZEND_ACC_EXPLICIT_ABSTRACT_CLASS);

	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("activeHandler"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("activeMethodMap"), ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("actionName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("actionSuffix"), "Action", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("camelCaseMap"), ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("defaultAction"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("defaultNamespace"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("defaultHandler"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("handlerHashes"), ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("handlerName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("handlerSuffix"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("eventsManager"), ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_dispatcher_abstractdispatcher_ce, SL("finished"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_dispatcher_abstractdispatcher_ce, SL("forwarded"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_dispatcher_abstractdispatcher_ce, SL("isControllerInitialize"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("lastHandler"), ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("modelBinder"), ZEND_ACC_PROTECTED);
	zend_declare_property_bool(phalcon_dispatcher_abstractdispatcher_ce, SL("modelBinding"), 0, ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("moduleName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("namespaceName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("params"), ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("previousActionName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("previousHandlerName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_string(phalcon_dispatcher_abstractdispatcher_ce, SL("previousNamespaceName"), "", ZEND_ACC_PROTECTED);
	zend_declare_property_null(phalcon_dispatcher_abstractdispatcher_ce, SL("returnedValue"), ZEND_ACC_PROTECTED);
	phalcon_dispatcher_abstractdispatcher_ce->create_object = zephir_init_properties_Phalcon_Dispatcher_AbstractDispatcher;

	zend_class_implements(phalcon_dispatcher_abstractdispatcher_ce, 1, phalcon_dispatcher_dispatcherinterface_ce);
	zend_class_implements(phalcon_dispatcher_abstractdispatcher_ce, 1, phalcon_events_eventsawareinterface_ce);
	return SUCCESS;
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, callActionMethod)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval params, _0;
	zval actionMethod;
	zval *handler, handler_sub, *actionMethod_param = NULL, *params_param = NULL;

	ZVAL_UNDEF(&handler_sub);
	ZVAL_UNDEF(&actionMethod);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&_0);
	ZEND_PARSE_PARAMETERS_START(2, 3)
		Z_PARAM_ZVAL(handler)
		Z_PARAM_STR(actionMethod)
		Z_PARAM_OPTIONAL
		Z_PARAM_ARRAY(params)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 2, 1, &handler, &actionMethod_param, &params_param);
	zephir_get_strval(&actionMethod, actionMethod_param);
	if (!params_param) {
		ZEPHIR_INIT_VAR(&params);
		array_init(&params);
	} else {
	ZEPHIR_OBS_COPY_OR_DUP(&params, params_param);
	}
	ZEPHIR_INIT_VAR(&_0);
	zephir_create_array(&_0, 2, 0);
	zephir_array_fast_append(&_0, handler);
	zephir_array_fast_append(&_0, &actionMethod);
	ZEPHIR_CALL_USER_FUNC_ARRAY(return_value, &_0, &params);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, dispatch)
{
	zval _44$$10;
	zend_bool hasService = 0, hasEventsManager = 0, isNewHandler = 0, _5$$5, _16$$13, _21$$15, _29$$18, _34$$20, _42$$23, _52$$25, _56$$31, _62$$33, _66$$36, _72$$38, _78$$43, _83$$46, _88$$48, _105$$59, _110$$62, _115$$64, _118$$67, _123$$69, _130$$73;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zephir_fcall_cache_entry *_11 = NULL, *_12 = NULL, *_15 = NULL, *_20 = NULL, *_23 = NULL, *_25 = NULL, *_28 = NULL, *_30 = NULL, *_33 = NULL, *_35 = NULL, *_41 = NULL, *_43 = NULL, *_47 = NULL, *_51 = NULL, *_55 = NULL, *_58 = NULL, *_61 = NULL, *_64 = NULL, *_68 = NULL, *_71 = NULL, *_74 = NULL, *_77 = NULL, *_82 = NULL, *_87 = NULL, *_94 = NULL, *_100 = NULL, *_104 = NULL, *_109 = NULL, *_114 = NULL, *_122 = NULL, *_126 = NULL, *_129 = NULL;
	zval __$true, __$false, value, handler, container, namespaceName, handlerName, actionName, eventsManager, handlerClass, status, actionMethod, modelBinder, bindCacheKey, handlerHash, e, _0, _1$$3, _2$$3, _3$$5, _4$$5, _6$$5, _7$$4, _8$$7, _9$$11, _10$$11, _13$$13, _14$$13, _17$$13, _18$$12, _19$$15, _22$$15, _24$$10, _36$$10, _37$$10, _38$$10, _102$$10, _26$$18, _27$$18, _31$$20, _32$$20, _39$$23, _40$$23, _45$$26, _46$$26, _48$$26, _49$$25, _50$$25, _53$$31, _54$$31, _57$$31, _59$$30, _60$$33, _63$$33, _65$$36, _67$$36, _69$$35, _70$$38, _73$$38, _75$$41, _76$$43, _79$$43, _80$$46, _81$$46, _84$$46, _85$$45, _86$$48, _89$$48, _90$$50, _91$$50, _92$$51, _93$$51, _95$$51, _96$$54, _97$$54, _98$$57, _99$$57, _101$$57, _103$$59, _106$$59, _107$$62, _108$$62, _111$$62, _112$$61, _113$$64, _116$$64, _117$$67, _119$$67, _120$$66, _121$$69, _124$$69, _125$$72, _127$$71, _128$$73, _131$$73, _132$$76, _133$$75, _134$$77;
	zend_long ZEPHIR_LAST_CALL_STATUS, numberDispatches = 0;
	zval *this_ptr = getThis();

	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZVAL_UNDEF(&value);
	ZVAL_UNDEF(&handler);
	ZVAL_UNDEF(&container);
	ZVAL_UNDEF(&namespaceName);
	ZVAL_UNDEF(&handlerName);
	ZVAL_UNDEF(&actionName);
	ZVAL_UNDEF(&eventsManager);
	ZVAL_UNDEF(&handlerClass);
	ZVAL_UNDEF(&status);
	ZVAL_UNDEF(&actionMethod);
	ZVAL_UNDEF(&modelBinder);
	ZVAL_UNDEF(&bindCacheKey);
	ZVAL_UNDEF(&handlerHash);
	ZVAL_UNDEF(&e);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1$$3);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$5);
	ZVAL_UNDEF(&_4$$5);
	ZVAL_UNDEF(&_6$$5);
	ZVAL_UNDEF(&_7$$4);
	ZVAL_UNDEF(&_8$$7);
	ZVAL_UNDEF(&_9$$11);
	ZVAL_UNDEF(&_10$$11);
	ZVAL_UNDEF(&_13$$13);
	ZVAL_UNDEF(&_14$$13);
	ZVAL_UNDEF(&_17$$13);
	ZVAL_UNDEF(&_18$$12);
	ZVAL_UNDEF(&_19$$15);
	ZVAL_UNDEF(&_22$$15);
	ZVAL_UNDEF(&_24$$10);
	ZVAL_UNDEF(&_36$$10);
	ZVAL_UNDEF(&_37$$10);
	ZVAL_UNDEF(&_38$$10);
	ZVAL_UNDEF(&_102$$10);
	ZVAL_UNDEF(&_26$$18);
	ZVAL_UNDEF(&_27$$18);
	ZVAL_UNDEF(&_31$$20);
	ZVAL_UNDEF(&_32$$20);
	ZVAL_UNDEF(&_39$$23);
	ZVAL_UNDEF(&_40$$23);
	ZVAL_UNDEF(&_45$$26);
	ZVAL_UNDEF(&_46$$26);
	ZVAL_UNDEF(&_48$$26);
	ZVAL_UNDEF(&_49$$25);
	ZVAL_UNDEF(&_50$$25);
	ZVAL_UNDEF(&_53$$31);
	ZVAL_UNDEF(&_54$$31);
	ZVAL_UNDEF(&_57$$31);
	ZVAL_UNDEF(&_59$$30);
	ZVAL_UNDEF(&_60$$33);
	ZVAL_UNDEF(&_63$$33);
	ZVAL_UNDEF(&_65$$36);
	ZVAL_UNDEF(&_67$$36);
	ZVAL_UNDEF(&_69$$35);
	ZVAL_UNDEF(&_70$$38);
	ZVAL_UNDEF(&_73$$38);
	ZVAL_UNDEF(&_75$$41);
	ZVAL_UNDEF(&_76$$43);
	ZVAL_UNDEF(&_79$$43);
	ZVAL_UNDEF(&_80$$46);
	ZVAL_UNDEF(&_81$$46);
	ZVAL_UNDEF(&_84$$46);
	ZVAL_UNDEF(&_85$$45);
	ZVAL_UNDEF(&_86$$48);
	ZVAL_UNDEF(&_89$$48);
	ZVAL_UNDEF(&_90$$50);
	ZVAL_UNDEF(&_91$$50);
	ZVAL_UNDEF(&_92$$51);
	ZVAL_UNDEF(&_93$$51);
	ZVAL_UNDEF(&_95$$51);
	ZVAL_UNDEF(&_96$$54);
	ZVAL_UNDEF(&_97$$54);
	ZVAL_UNDEF(&_98$$57);
	ZVAL_UNDEF(&_99$$57);
	ZVAL_UNDEF(&_101$$57);
	ZVAL_UNDEF(&_103$$59);
	ZVAL_UNDEF(&_106$$59);
	ZVAL_UNDEF(&_107$$62);
	ZVAL_UNDEF(&_108$$62);
	ZVAL_UNDEF(&_111$$62);
	ZVAL_UNDEF(&_112$$61);
	ZVAL_UNDEF(&_113$$64);
	ZVAL_UNDEF(&_116$$64);
	ZVAL_UNDEF(&_117$$67);
	ZVAL_UNDEF(&_119$$67);
	ZVAL_UNDEF(&_120$$66);
	ZVAL_UNDEF(&_121$$69);
	ZVAL_UNDEF(&_124$$69);
	ZVAL_UNDEF(&_125$$72);
	ZVAL_UNDEF(&_127$$71);
	ZVAL_UNDEF(&_128$$73);
	ZVAL_UNDEF(&_131$$73);
	ZVAL_UNDEF(&_132$$76);
	ZVAL_UNDEF(&_133$$75);
	ZVAL_UNDEF(&_134$$77);
	ZVAL_UNDEF(&_44$$10);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("container"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&container, &_0);
	if (Z_TYPE_P(&container) == IS_NULL) {
		ZEPHIR_INIT_VAR(&_1$$3);
		ZVAL_STRING(&_1$$3, "A dependency injection container is required to access related dispatching services");
		ZVAL_LONG(&_2$$3, 0);
		ZEPHIR_CALL_METHOD(NULL, this_ptr, "throwdispatchexception", NULL, 0, &_1$$3, &_2$$3);
		zephir_check_call_status();
		RETURN_MM_BOOL(0);
	}
	zephir_read_property(&_0, this_ptr, ZEND_STRL("eventsManager"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&eventsManager, &_0);
	hasEventsManager = Z_TYPE_P(&eventsManager) == IS_OBJECT;
	if (1) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$false);
	}
	if (hasEventsManager) {

		/* try_start_1: */

			ZEPHIR_INIT_VAR(&_4$$5);
			ZVAL_STRING(&_4$$5, "dispatch:beforeDispatchLoop");
			ZEPHIR_CALL_METHOD(&_3$$5, &eventsManager, "fire", NULL, 0, &_4$$5, this_ptr);
			zephir_check_call_status_or_jump(try_end_1);
			_5$$5 = ZEPHIR_IS_FALSE_IDENTICAL(&_3$$5);
			if (_5$$5) {
				zephir_read_property(&_6$$5, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				_5$$5 = !ZEPHIR_IS_FALSE_IDENTICAL(&_6$$5);
			}
			if (_5$$5) {
				RETURN_MM_BOOL(0);
			}

		try_end_1:

		if (EG(exception)) {
			ZEPHIR_INIT_VAR(&_7$$4);
			ZVAL_OBJ(&_7$$4, EG(exception));
			Z_ADDREF_P(&_7$$4);
			if (zephir_is_instance_of(&_7$$4, SL("Exception"))) {
				zend_clear_exception();
				ZEPHIR_CPY_WRT(&e, &_7$$4);
				ZEPHIR_CALL_METHOD(&status, this_ptr, "handleexception", NULL, 0, &e);
				zephir_check_call_status();
				zephir_read_property(&_8$$7, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				if (!ZEPHIR_IS_FALSE_IDENTICAL(&_8$$7)) {
					if (ZEPHIR_IS_FALSE_IDENTICAL(&status)) {
						RETURN_MM_BOOL(0);
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 229);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
	}
	ZEPHIR_INIT_VAR(&value);
	ZVAL_NULL(&value);
	ZEPHIR_INIT_VAR(&handler);
	ZVAL_NULL(&handler);
	numberDispatches = 0;
	if (0) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$false);
	}
	while (1) {
		zephir_read_property(&_0, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
		if (!(!(zephir_is_true(&_0)))) {
			break;
		}
		numberDispatches++;
		if (UNEXPECTED(numberDispatches == 256)) {
			ZEPHIR_INIT_NVAR(&_9$$11);
			ZVAL_STRING(&_9$$11, "Dispatcher has detected a cyclic routing causing stability problems");
			ZVAL_LONG(&_10$$11, 1);
			ZEPHIR_CALL_METHOD(NULL, this_ptr, "throwdispatchexception", &_11, 0, &_9$$11, &_10$$11);
			zephir_check_call_status();
			break;
		}
		if (1) {
			zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$true);
		} else {
			zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$false);
		}
		ZEPHIR_CALL_METHOD(NULL, this_ptr, "resolveemptyproperties", &_12, 0);
		zephir_check_call_status();
		if (hasEventsManager) {

			/* try_start_2: */

				ZEPHIR_INIT_NVAR(&_14$$13);
				ZVAL_STRING(&_14$$13, "dispatch:beforeDispatch");
				ZEPHIR_CALL_METHOD(&_13$$13, &eventsManager, "fire", &_15, 0, &_14$$13, this_ptr);
				zephir_check_call_status_or_jump(try_end_2);
				_16$$13 = ZEPHIR_IS_FALSE_IDENTICAL(&_13$$13);
				if (!(_16$$13)) {
					zephir_read_property(&_17$$13, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_16$$13 = ZEPHIR_IS_FALSE_IDENTICAL(&_17$$13);
				}
				if (_16$$13) {
					continue;
				}

			try_end_2:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_18$$12);
				ZVAL_OBJ(&_18$$12, EG(exception));
				Z_ADDREF_P(&_18$$12);
				if (zephir_is_instance_of(&_18$$12, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_18$$12);
					ZEPHIR_CALL_METHOD(&_19$$15, this_ptr, "handleexception", &_20, 0, &e);
					zephir_check_call_status();
					_21$$15 = ZEPHIR_IS_FALSE_IDENTICAL(&_19$$15);
					if (!(_21$$15)) {
						zephir_read_property(&_22$$15, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_21$$15 = ZEPHIR_IS_FALSE_IDENTICAL(&_22$$15);
					}
					if (_21$$15) {
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 269);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
		ZEPHIR_CALL_METHOD(&handlerClass, this_ptr, "gethandlerclass", &_23, 0);
		zephir_check_call_status();
		ZEPHIR_CALL_METHOD(&_24$$10, &container, "has", &_25, 0, &handlerClass);
		zephir_check_call_status();
		hasService = zephir_get_boolval(&_24$$10);
		if (!(hasService)) {
			hasService = zephir_class_exists(&handlerClass, 1);
		}
		if (!(hasService)) {
			ZEPHIR_INIT_NVAR(&_26$$18);
			ZEPHIR_CONCAT_VS(&_26$$18, &handlerClass, " handler class cannot be loaded");
			ZVAL_LONG(&_27$$18, 2);
			ZEPHIR_CALL_METHOD(&status, this_ptr, "throwdispatchexception", &_28, 0, &_26$$18, &_27$$18);
			zephir_check_call_status();
			_29$$18 = ZEPHIR_IS_FALSE_IDENTICAL(&status);
			if (_29$$18) {
				zephir_read_property(&_27$$18, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				_29$$18 = ZEPHIR_IS_FALSE_IDENTICAL(&_27$$18);
			}
			if (_29$$18) {
				continue;
			}
			break;
		}
		ZEPHIR_CALL_METHOD(&handler, &container, "getshared", &_30, 0, &handlerClass);
		zephir_check_call_status();
		if (UNEXPECTED(Z_TYPE_P(&handler) != IS_OBJECT)) {
			ZEPHIR_INIT_NVAR(&_31$$20);
			ZVAL_STRING(&_31$$20, "Invalid handler returned from the services container");
			ZVAL_LONG(&_32$$20, 3);
			ZEPHIR_CALL_METHOD(&status, this_ptr, "throwdispatchexception", &_33, 0, &_31$$20, &_32$$20);
			zephir_check_call_status();
			_34$$20 = ZEPHIR_IS_FALSE_IDENTICAL(&status);
			if (_34$$20) {
				zephir_read_property(&_32$$20, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				_34$$20 = ZEPHIR_IS_FALSE_IDENTICAL(&_32$$20);
			}
			if (_34$$20) {
				continue;
			}
			break;
		}
		ZEPHIR_CALL_FUNCTION(&handlerHash, "spl_object_hash", &_35, 80, &handler);
		zephir_check_call_status();
		zephir_read_property(&_36$$10, this_ptr, ZEND_STRL("handlerHashes"), PH_NOISY_CC | PH_READONLY);
		isNewHandler = !((zephir_array_isset(&_36$$10, &handlerHash)));
		if (isNewHandler) {
			zephir_update_property_array(this_ptr, SL("handlerHashes"), &handlerHash, &__$true);
		}
		zephir_update_property_zval(this_ptr, ZEND_STRL("activeHandler"), &handler);
		zephir_read_property(&_37$$10, this_ptr, ZEND_STRL("namespaceName"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&namespaceName, &_37$$10);
		zephir_read_property(&_37$$10, this_ptr, ZEND_STRL("handlerName"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&handlerName, &_37$$10);
		zephir_read_property(&_37$$10, this_ptr, ZEND_STRL("actionName"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CPY_WRT(&actionName, &_37$$10);
		ZEPHIR_OBS_NVAR(&_38$$10);
		zephir_read_property(&_38$$10, this_ptr, ZEND_STRL("params"), PH_NOISY_CC);
		if (UNEXPECTED(Z_TYPE_P(&_38$$10) != IS_ARRAY)) {
			ZEPHIR_INIT_NVAR(&_39$$23);
			ZVAL_STRING(&_39$$23, "Action parameters must be an Array");
			ZVAL_LONG(&_40$$23, 4);
			ZEPHIR_CALL_METHOD(&status, this_ptr, "throwdispatchexception", &_41, 0, &_39$$23, &_40$$23);
			zephir_check_call_status();
			_42$$23 = ZEPHIR_IS_FALSE_IDENTICAL(&status);
			if (_42$$23) {
				zephir_read_property(&_40$$23, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				_42$$23 = ZEPHIR_IS_FALSE_IDENTICAL(&_40$$23);
			}
			if (_42$$23) {
				continue;
			}
			break;
		}
		ZEPHIR_CALL_METHOD(&actionMethod, this_ptr, "getactivemethod", &_43, 0);
		zephir_check_call_status();
		ZEPHIR_INIT_NVAR(&_44$$10);
		zephir_create_array(&_44$$10, 2, 0);
		zephir_array_fast_append(&_44$$10, &handler);
		zephir_array_fast_append(&_44$$10, &actionMethod);
		if (UNEXPECTED(!(zephir_is_callable(&_44$$10)))) {
			if (hasEventsManager) {
				ZEPHIR_INIT_NVAR(&_46$$26);
				ZVAL_STRING(&_46$$26, "dispatch:beforeNotFoundAction");
				ZEPHIR_CALL_METHOD(&_45$$26, &eventsManager, "fire", &_47, 0, &_46$$26, this_ptr);
				zephir_check_call_status();
				if (ZEPHIR_IS_FALSE_IDENTICAL(&_45$$26)) {
					continue;
				}
				zephir_read_property(&_48$$26, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				if (ZEPHIR_IS_FALSE_IDENTICAL(&_48$$26)) {
					continue;
				}
			}
			ZEPHIR_INIT_NVAR(&_49$$25);
			ZEPHIR_CONCAT_SVSVS(&_49$$25, "Action '", &actionName, "' was not found on handler '", &handlerName, "'");
			ZVAL_LONG(&_50$$25, 5);
			ZEPHIR_CALL_METHOD(&status, this_ptr, "throwdispatchexception", &_51, 0, &_49$$25, &_50$$25);
			zephir_check_call_status();
			_52$$25 = ZEPHIR_IS_FALSE_IDENTICAL(&status);
			if (_52$$25) {
				zephir_read_property(&_50$$25, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
				_52$$25 = ZEPHIR_IS_FALSE_IDENTICAL(&_50$$25);
			}
			if (_52$$25) {
				continue;
			}
			break;
		}
		if (hasEventsManager) {

			/* try_start_3: */

				ZEPHIR_INIT_NVAR(&_54$$31);
				ZVAL_STRING(&_54$$31, "dispatch:beforeExecuteRoute");
				ZEPHIR_CALL_METHOD(&_53$$31, &eventsManager, "fire", &_55, 0, &_54$$31, this_ptr);
				zephir_check_call_status_or_jump(try_end_3);
				_56$$31 = ZEPHIR_IS_FALSE_IDENTICAL(&_53$$31);
				if (!(_56$$31)) {
					zephir_read_property(&_57$$31, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_56$$31 = ZEPHIR_IS_FALSE_IDENTICAL(&_57$$31);
				}
				if (_56$$31) {
					ZEPHIR_CALL_METHOD(NULL, &container, "remove", &_58, 0, &handlerClass);
					zephir_check_call_status_or_jump(try_end_3);
					continue;
				}

			try_end_3:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_59$$30);
				ZVAL_OBJ(&_59$$30, EG(exception));
				Z_ADDREF_P(&_59$$30);
				if (zephir_is_instance_of(&_59$$30, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_59$$30);
					ZEPHIR_CALL_METHOD(&_60$$33, this_ptr, "handleexception", &_61, 0, &e);
					zephir_check_call_status();
					_62$$33 = ZEPHIR_IS_FALSE_IDENTICAL(&_60$$33);
					if (!(_62$$33)) {
						zephir_read_property(&_63$$33, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_62$$33 = ZEPHIR_IS_FALSE_IDENTICAL(&_63$$33);
					}
					if (_62$$33) {
						ZEPHIR_CALL_METHOD(NULL, &container, "remove", &_64, 0, &handlerClass);
						zephir_check_call_status();
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 408);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
		if ((zephir_method_exists_ex(&handler, ZEND_STRL("beforeexecuteroute")) == SUCCESS)) {

			/* try_start_4: */

				ZEPHIR_CALL_METHOD(&_65$$36, &handler, "beforeexecuteroute", NULL, 0, this_ptr);
				zephir_check_call_status_or_jump(try_end_4);
				_66$$36 = ZEPHIR_IS_FALSE_IDENTICAL(&_65$$36);
				if (!(_66$$36)) {
					zephir_read_property(&_67$$36, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_66$$36 = ZEPHIR_IS_FALSE_IDENTICAL(&_67$$36);
				}
				if (_66$$36) {
					ZEPHIR_CALL_METHOD(NULL, &container, "remove", &_68, 0, &handlerClass);
					zephir_check_call_status_or_jump(try_end_4);
					continue;
				}

			try_end_4:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_69$$35);
				ZVAL_OBJ(&_69$$35, EG(exception));
				Z_ADDREF_P(&_69$$35);
				if (zephir_is_instance_of(&_69$$35, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_69$$35);
					ZEPHIR_CALL_METHOD(&_70$$38, this_ptr, "handleexception", &_71, 0, &e);
					zephir_check_call_status();
					_72$$38 = ZEPHIR_IS_FALSE_IDENTICAL(&_70$$38);
					if (!(_72$$38)) {
						zephir_read_property(&_73$$38, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_72$$38 = ZEPHIR_IS_FALSE_IDENTICAL(&_73$$38);
					}
					if (_72$$38) {
						ZEPHIR_CALL_METHOD(NULL, &container, "remove", &_74, 0, &handlerClass);
						zephir_check_call_status();
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 427);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
		if (isNewHandler) {
			if ((zephir_method_exists_ex(&handler, ZEND_STRL("initialize")) == SUCCESS)) {

				/* try_start_5: */

					if (1) {
						zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$true);
					} else {
						zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$false);
					}
					ZEPHIR_CALL_METHOD(NULL, &handler, "initialize", NULL, 0);
					zephir_check_call_status_or_jump(try_end_5);

				try_end_5:

				if (EG(exception)) {
					ZEPHIR_INIT_NVAR(&_75$$41);
					ZVAL_OBJ(&_75$$41, EG(exception));
					Z_ADDREF_P(&_75$$41);
					if (zephir_is_instance_of(&_75$$41, SL("Exception"))) {
						zend_clear_exception();
						ZEPHIR_CPY_WRT(&e, &_75$$41);
						if (0) {
							zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$true);
						} else {
							zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$false);
						}
						ZEPHIR_CALL_METHOD(&_76$$43, this_ptr, "handleexception", &_77, 0, &e);
						zephir_check_call_status();
						_78$$43 = ZEPHIR_IS_FALSE_IDENTICAL(&_76$$43);
						if (!(_78$$43)) {
							zephir_read_property(&_79$$43, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
							_78$$43 = ZEPHIR_IS_FALSE_IDENTICAL(&_79$$43);
						}
						if (_78$$43) {
							continue;
						}
						zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 469);
						ZEPHIR_MM_RESTORE();
						return;
					}
				}
			}
			if (0) {
				zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$true);
			} else {
				zephir_update_property_zval(this_ptr, ZEND_STRL("isControllerInitialize"), &__$false);
			}
			if (zephir_is_true(&eventsManager)) {

				/* try_start_6: */

					ZEPHIR_INIT_NVAR(&_81$$46);
					ZVAL_STRING(&_81$$46, "dispatch:afterInitialize");
					ZEPHIR_CALL_METHOD(&_80$$46, &eventsManager, "fire", &_82, 0, &_81$$46, this_ptr);
					zephir_check_call_status_or_jump(try_end_6);
					_83$$46 = ZEPHIR_IS_FALSE_IDENTICAL(&_80$$46);
					if (!(_83$$46)) {
						zephir_read_property(&_84$$46, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_83$$46 = ZEPHIR_IS_FALSE_IDENTICAL(&_84$$46);
					}
					if (_83$$46) {
						continue;
					}

				try_end_6:

				if (EG(exception)) {
					ZEPHIR_INIT_NVAR(&_85$$45);
					ZVAL_OBJ(&_85$$45, EG(exception));
					Z_ADDREF_P(&_85$$45);
					if (zephir_is_instance_of(&_85$$45, SL("Exception"))) {
						zend_clear_exception();
						ZEPHIR_CPY_WRT(&e, &_85$$45);
						ZEPHIR_CALL_METHOD(&_86$$48, this_ptr, "handleexception", &_87, 0, &e);
						zephir_check_call_status();
						_88$$48 = ZEPHIR_IS_FALSE_IDENTICAL(&_86$$48);
						if (!(_88$$48)) {
							zephir_read_property(&_89$$48, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
							_88$$48 = ZEPHIR_IS_FALSE_IDENTICAL(&_89$$48);
						}
						if (_88$$48) {
							continue;
						}
						zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 488);
						ZEPHIR_MM_RESTORE();
						return;
					}
				}
			}
		}
		zephir_read_property(&_37$$10, this_ptr, ZEND_STRL("modelBinding"), PH_NOISY_CC | PH_READONLY);
		if (zephir_is_true(&_37$$10)) {
			zephir_read_property(&_90$$50, this_ptr, ZEND_STRL("modelBinder"), PH_NOISY_CC | PH_READONLY);
			ZEPHIR_CPY_WRT(&modelBinder, &_90$$50);
			ZEPHIR_INIT_NVAR(&bindCacheKey);
			ZEPHIR_CONCAT_SVSV(&bindCacheKey, "_PHMB_", &handlerClass, "_", &actionMethod);
			zephir_read_property(&_90$$50, this_ptr, ZEND_STRL("params"), PH_NOISY_CC | PH_READONLY);
			ZEPHIR_CALL_METHOD(&_91$$50, &modelBinder, "bindtohandler", NULL, 0, &handler, &_90$$50, &bindCacheKey, &actionMethod);
			zephir_check_call_status();
			zephir_update_property_zval(this_ptr, ZEND_STRL("params"), &_91$$50);
		}
		if (hasEventsManager) {
			ZEPHIR_INIT_NVAR(&_93$$51);
			ZVAL_STRING(&_93$$51, "dispatch:afterBinding");
			ZEPHIR_CALL_METHOD(&_92$$51, &eventsManager, "fire", &_94, 0, &_93$$51, this_ptr);
			zephir_check_call_status();
			if (ZEPHIR_IS_FALSE_IDENTICAL(&_92$$51)) {
				continue;
			}
			zephir_read_property(&_95$$51, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
			if (ZEPHIR_IS_FALSE_IDENTICAL(&_95$$51)) {
				continue;
			}
		}
		if ((zephir_method_exists_ex(&handler, ZEND_STRL("afterbinding")) == SUCCESS)) {
			ZEPHIR_CALL_METHOD(&_96$$54, &handler, "afterbinding", NULL, 0, this_ptr);
			zephir_check_call_status();
			if (ZEPHIR_IS_FALSE_IDENTICAL(&_96$$54)) {
				continue;
			}
			zephir_read_property(&_97$$54, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
			if (ZEPHIR_IS_FALSE_IDENTICAL(&_97$$54)) {
				continue;
			}
		}
		zephir_update_property_zval(this_ptr, ZEND_STRL("lastHandler"), &handler);

		/* try_start_7: */

			zephir_read_property(&_99$$57, this_ptr, ZEND_STRL("params"), PH_NOISY_CC | PH_READONLY);
			ZEPHIR_CALL_METHOD(&_98$$57, this_ptr, "callactionmethod", &_100, 0, &handler, &actionMethod, &_99$$57);
			zephir_check_call_status_or_jump(try_end_7);
			zephir_update_property_zval(this_ptr, ZEND_STRL("returnedValue"), &_98$$57);
			zephir_read_property(&_101$$57, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
			if (ZEPHIR_IS_FALSE_IDENTICAL(&_101$$57)) {
				continue;
			}

		try_end_7:

		if (EG(exception)) {
			ZEPHIR_INIT_NVAR(&_102$$10);
			ZVAL_OBJ(&_102$$10, EG(exception));
			Z_ADDREF_P(&_102$$10);
			if (zephir_is_instance_of(&_102$$10, SL("Exception"))) {
				zend_clear_exception();
				ZEPHIR_CPY_WRT(&e, &_102$$10);
				ZEPHIR_CALL_METHOD(&_103$$59, this_ptr, "handleexception", &_104, 0, &e);
				zephir_check_call_status();
				_105$$59 = ZEPHIR_IS_FALSE_IDENTICAL(&_103$$59);
				if (!(_105$$59)) {
					zephir_read_property(&_106$$59, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_105$$59 = ZEPHIR_IS_FALSE_IDENTICAL(&_106$$59);
				}
				if (_105$$59) {
					continue;
				}
				zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 560);
				ZEPHIR_MM_RESTORE();
				return;
			}
		}
		if (hasEventsManager) {

			/* try_start_8: */

				ZEPHIR_INIT_NVAR(&_108$$62);
				ZVAL_STRING(&_108$$62, "dispatch:afterExecuteRoute");
				ZEPHIR_CALL_METHOD(&_107$$62, &eventsManager, "fire", &_109, 0, &_108$$62, this_ptr, &value);
				zephir_check_call_status_or_jump(try_end_8);
				_110$$62 = ZEPHIR_IS_FALSE_IDENTICAL(&_107$$62);
				if (!(_110$$62)) {
					zephir_read_property(&_111$$62, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_110$$62 = ZEPHIR_IS_FALSE_IDENTICAL(&_111$$62);
				}
				if (_110$$62) {
					continue;
				}

			try_end_8:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_112$$61);
				ZVAL_OBJ(&_112$$61, EG(exception));
				Z_ADDREF_P(&_112$$61);
				if (zephir_is_instance_of(&_112$$61, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_112$$61);
					ZEPHIR_CALL_METHOD(&_113$$64, this_ptr, "handleexception", &_114, 0, &e);
					zephir_check_call_status();
					_115$$64 = ZEPHIR_IS_FALSE_IDENTICAL(&_113$$64);
					if (!(_115$$64)) {
						zephir_read_property(&_116$$64, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_115$$64 = ZEPHIR_IS_FALSE_IDENTICAL(&_116$$64);
					}
					if (_115$$64) {
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 576);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
		if ((zephir_method_exists_ex(&handler, ZEND_STRL("afterexecuteroute")) == SUCCESS)) {

			/* try_start_9: */

				ZEPHIR_CALL_METHOD(&_117$$67, &handler, "afterexecuteroute", NULL, 0, this_ptr, &value);
				zephir_check_call_status_or_jump(try_end_9);
				_118$$67 = ZEPHIR_IS_FALSE_IDENTICAL(&_117$$67);
				if (!(_118$$67)) {
					zephir_read_property(&_119$$67, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
					_118$$67 = ZEPHIR_IS_FALSE_IDENTICAL(&_119$$67);
				}
				if (_118$$67) {
					continue;
				}

			try_end_9:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_120$$66);
				ZVAL_OBJ(&_120$$66, EG(exception));
				Z_ADDREF_P(&_120$$66);
				if (zephir_is_instance_of(&_120$$66, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_120$$66);
					ZEPHIR_CALL_METHOD(&_121$$69, this_ptr, "handleexception", &_122, 0, &e);
					zephir_check_call_status();
					_123$$69 = ZEPHIR_IS_FALSE_IDENTICAL(&_121$$69);
					if (!(_123$$69)) {
						zephir_read_property(&_124$$69, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_123$$69 = ZEPHIR_IS_FALSE_IDENTICAL(&_124$$69);
					}
					if (_123$$69) {
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 593);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
		if (hasEventsManager) {

			/* try_start_10: */

				ZEPHIR_INIT_NVAR(&_125$$72);
				ZVAL_STRING(&_125$$72, "dispatch:afterDispatch");
				ZEPHIR_CALL_METHOD(NULL, &eventsManager, "fire", &_126, 0, &_125$$72, this_ptr, &value);
				zephir_check_call_status_or_jump(try_end_10);

			try_end_10:

			if (EG(exception)) {
				ZEPHIR_INIT_NVAR(&_127$$71);
				ZVAL_OBJ(&_127$$71, EG(exception));
				Z_ADDREF_P(&_127$$71);
				if (zephir_is_instance_of(&_127$$71, SL("Exception"))) {
					zend_clear_exception();
					ZEPHIR_CPY_WRT(&e, &_127$$71);
					ZEPHIR_CALL_METHOD(&_128$$73, this_ptr, "handleexception", &_129, 0, &e);
					zephir_check_call_status();
					_130$$73 = ZEPHIR_IS_FALSE_IDENTICAL(&_128$$73);
					if (!(_130$$73)) {
						zephir_read_property(&_131$$73, this_ptr, ZEND_STRL("finished"), PH_NOISY_CC | PH_READONLY);
						_130$$73 = ZEPHIR_IS_FALSE_IDENTICAL(&_131$$73);
					}
					if (_130$$73) {
						continue;
					}
					zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 610);
					ZEPHIR_MM_RESTORE();
					return;
				}
			}
		}
	}
	if (hasEventsManager) {

		/* try_start_11: */

			ZEPHIR_INIT_VAR(&_132$$76);
			ZVAL_STRING(&_132$$76, "dispatch:afterDispatchLoop");
			ZEPHIR_CALL_METHOD(NULL, &eventsManager, "fire", NULL, 0, &_132$$76, this_ptr);
			zephir_check_call_status_or_jump(try_end_11);

		try_end_11:

		if (EG(exception)) {
			ZEPHIR_INIT_VAR(&_133$$75);
			ZVAL_OBJ(&_133$$75, EG(exception));
			Z_ADDREF_P(&_133$$75);
			if (zephir_is_instance_of(&_133$$75, SL("Exception"))) {
				zend_clear_exception();
				ZEPHIR_CPY_WRT(&e, &_133$$75);
				ZEPHIR_CALL_METHOD(&_134$$77, this_ptr, "handleexception", NULL, 0, &e);
				zephir_check_call_status();
				if (ZEPHIR_IS_FALSE_IDENTICAL(&_134$$77)) {
					RETURN_MM_BOOL(0);
				}
				zephir_throw_exception_debug(&e, "phalcon/Dispatcher/AbstractDispatcher.zep", 627);
				ZEPHIR_MM_RESTORE();
				return;
			}
		}
	}
	RETURN_CCTOR(&handler);
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, forward)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zval *forward_param = NULL, __$true, __$false, namespaceName, controllerName, params, actionName, taskName, _0, _1, _2, _3;
	zval forward;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&forward);
	ZVAL_BOOL(&__$true, 1);
	ZVAL_BOOL(&__$false, 0);
	ZVAL_UNDEF(&namespaceName);
	ZVAL_UNDEF(&controllerName);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&actionName);
	ZVAL_UNDEF(&taskName);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_2);
	ZVAL_UNDEF(&_3);
	ZEND_PARSE_PARAMETERS_START(1, 1)
		Z_PARAM_ARRAY(forward)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 0, &forward_param);
	zephir_get_arrval(&forward, forward_param);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("isControllerInitialize"), PH_NOISY_CC | PH_READONLY);
	if (UNEXPECTED(ZEPHIR_IS_TRUE_IDENTICAL(&_0))) {
		ZEPHIR_THROW_EXCEPTION_DEBUG_STR(phalcon_dispatcher_exception_ce, "Forwarding inside a controller's initialize() method is forbidden", "phalcon/Dispatcher/AbstractDispatcher.zep", 661);
		return;
	}
	zephir_read_property(&_1, this_ptr, ZEND_STRL("namespaceName"), PH_NOISY_CC | PH_READONLY);
	zephir_update_property_zval(this_ptr, ZEND_STRL("previousNamespaceName"), &_1);
	zephir_read_property(&_2, this_ptr, ZEND_STRL("handlerName"), PH_NOISY_CC | PH_READONLY);
	zephir_update_property_zval(this_ptr, ZEND_STRL("previousHandlerName"), &_2);
	zephir_read_property(&_3, this_ptr, ZEND_STRL("actionName"), PH_NOISY_CC | PH_READONLY);
	zephir_update_property_zval(this_ptr, ZEND_STRL("previousActionName"), &_3);
	if (zephir_array_isset_string_fetch(&namespaceName, &forward, SL("namespace"), 1)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("namespaceName"), &namespaceName);
	}
	zephir_memory_observe(&taskName);
	if (zephir_array_isset_string_fetch(&controllerName, &forward, SL("controller"), 1)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("handlerName"), &controllerName);
	} else if (zephir_array_isset_string_fetch(&taskName, &forward, SL("task"), 0)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("handlerName"), &taskName);
	}
	if (zephir_array_isset_string_fetch(&actionName, &forward, SL("action"), 1)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("actionName"), &actionName);
	}
	if (zephir_array_isset_string_fetch(&params, &forward, SL("params"), 1)) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("params"), &params);
	}
	if (0) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("finished"), &__$false);
	}
	if (1) {
		zephir_update_property_zval(this_ptr, ZEND_STRL("forwarded"), &__$true);
	} else {
		zephir_update_property_zval(this_ptr, ZEND_STRL("forwarded"), &__$false);
	}
	ZEPHIR_MM_RESTORE();
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getActionName)
{

	RETURN_MEMBER(getThis(), "actionName");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getActionSuffix)
{

	RETURN_MEMBER(getThis(), "actionSuffix");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getActiveMethod)
{
	zval activeMethodName, _0, _1, _5, _2$$3, _3$$3, _4$$3;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&activeMethodName);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_2$$3);
	ZVAL_UNDEF(&_3$$3);
	ZVAL_UNDEF(&_4$$3);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_memory_observe(&activeMethodName);
	zephir_read_property(&_0, this_ptr, ZEND_STRL("activeMethodMap"), PH_NOISY_CC | PH_READONLY);
	zephir_read_property(&_1, this_ptr, ZEND_STRL("actionName"), PH_NOISY_CC | PH_READONLY);
	if (!(zephir_array_isset_fetch(&activeMethodName, &_0, &_1, 0))) {
		zephir_read_property(&_3$$3, this_ptr, ZEND_STRL("actionName"), PH_NOISY_CC | PH_READONLY);
		ZEPHIR_CALL_METHOD(&_2$$3, this_ptr, "tocamelcase", NULL, 0, &_3$$3);
		zephir_check_call_status();
		ZEPHIR_CALL_FUNCTION(&activeMethodName, "lcfirst", NULL, 76, &_2$$3);
		zephir_check_call_status();
		zephir_memory_observe(&_4$$3);
		zephir_read_property(&_4$$3, this_ptr, ZEND_STRL("actionName"), PH_NOISY_CC);
		zephir_update_property_array(this_ptr, SL("activeMethodMap"), &_4$$3, &activeMethodName);
	}
	zephir_read_property(&_5, this_ptr, ZEND_STRL("actionSuffix"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CONCAT_VV(return_value, &activeMethodName, &_5);
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getBoundModels)
{
	zval _0, _1;
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_1);
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);

	zephir_read_property(&_0, this_ptr, ZEND_STRL("modelBinder"), PH_NOISY_CC | PH_READONLY);
	if (Z_TYPE_P(&_0) == IS_NULL) {
		array_init(return_value);
		RETURN_MM();
	}
	zephir_read_property(&_1, this_ptr, ZEND_STRL("modelBinder"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_RETURN_CALL_METHOD(&_1, "getboundmodels", NULL, 0);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getDefaultNamespace)
{

	RETURN_MEMBER(getThis(), "defaultNamespace");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getEventsManager)
{

	RETURN_MEMBER(getThis(), "eventsManager");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getHandlerSuffix)
{

	RETURN_MEMBER(getThis(), "handlerSuffix");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getModelBinder)
{

	RETURN_MEMBER(getThis(), "modelBinder");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getModuleName)
{

	RETURN_MEMBER(getThis(), "moduleName");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getNamespaceName)
{

	RETURN_MEMBER(getThis(), "namespaceName");
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getParam)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *param, param_sub, *filters = NULL, filters_sub, *defaultValue = NULL, defaultValue_sub, __$null;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&param_sub);
	ZVAL_UNDEF(&filters_sub);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(param)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(filters)
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &param, &filters, &defaultValue);
	if (!filters) {
		filters = &filters_sub;
		filters = &__$null;
	}
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	ZEPHIR_RETURN_CALL_METHOD(this_ptr, "getparameter", NULL, 0, param, filters, defaultValue);
	zephir_check_call_status();
	RETURN_MM();
}

static PHP_METHOD(Phalcon_Dispatcher_AbstractDispatcher, getParameter)
{
	zephir_method_globals *ZEPHIR_METHOD_GLOBALS_PTR = NULL;
	zend_long ZEPHIR_LAST_CALL_STATUS;
	zval *param, param_sub, *filters = NULL, filters_sub, *defaultValue = NULL, defaultValue_sub, __$null, params, filter, paramValue, _0, _3, _4, _5, _1$$5, _2$$5;
	zval *this_ptr = getThis();

	ZVAL_UNDEF(&param_sub);
	ZVAL_UNDEF(&filters_sub);
	ZVAL_UNDEF(&defaultValue_sub);
	ZVAL_NULL(&__$null);
	ZVAL_UNDEF(&params);
	ZVAL_UNDEF(&filter);
	ZVAL_UNDEF(&paramValue);
	ZVAL_UNDEF(&_0);
	ZVAL_UNDEF(&_3);
	ZVAL_UNDEF(&_4);
	ZVAL_UNDEF(&_5);
	ZVAL_UNDEF(&_1$$5);
	ZVAL_UNDEF(&_2$$5);
	bool is_null_true = 1;
	ZEND_PARSE_PARAMETERS_START(1, 3)
		Z_PARAM_ZVAL(param)
		Z_PARAM_OPTIONAL
		Z_PARAM_ZVAL_OR_NULL(filters)
		Z_PARAM_ZVAL_OR_NULL(defaultValue)
	ZEND_PARSE_PARAMETERS_END();
	ZEPHIR_METHOD_GLOBALS_PTR = pecalloc(1, sizeof(zephir_method_globals), 0);
	zephir_memory_grow_stack(ZEPHIR_METHOD_GLOBALS_PTR, __func__);
	zephir_fetch_params(1, 1, 2, &param, &filters, &defaultValue);
	if (!filters) {
		filters = &filters_sub;
		filters = &__$null;
	}
	if (!defaultValue) {
		defaultValue = &defaultValue_sub;
		defaultValue = &__$null;
	}
	zephir_read_property(&_0, this_ptr, ZEND_STRL("params"), PH_NOISY_CC | PH_READONLY);
	ZEPHIR_CPY_WRT(&params, &_0);
	zephir_memory_observe(&paramValue);
	if (!(zephir_array_isset_fetch(&paramVa